% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metaflow_client.R
\docType{class}
\name{mf_client}
\alias{mf_client}
\title{Instantiate Metaflow flow/run/step/task client}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} with fields/methods for introspection.
}
\description{
A R6 Class representing a MetaflowClient used to inspect flow/run/step/task artifacts.
This is a factory class that provides convenience for creating Flow/Run/Step/Task Client objects.
}
\section{Usage}{

\preformatted{
client <- mf_flow$new()

f <- client$flow("HelloWorldFlow")

r <- client$run(f, run_id)
r <- client$flow('HelloWorldFlow')$run(run_id)

s <- client$step(r, step_id)
s <- client$flow('HelloWorldFlow')$run(run_id)$step(step_id)

t <- client$task(s, task_id)
t <- client$flow('HelloWorldFlow')$run(run_id)$step(step_id)$task(task_id)

}
}

\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-flow}{\code{mf_client$flow()}}
\item \href{#method-run}{\code{mf_client$run()}}
\item \href{#method-step}{\code{mf_client$step()}}
\item \href{#method-task}{\code{mf_client$task()}}
\item \href{#method-clone}{\code{mf_client$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-flow"></a>}}
\if{latex}{\out{\hypertarget{method-flow}{}}}
\subsection{Method \code{flow()}}{
Create a metaflow FlowClient R6 object based on flow_id.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{mf_client$flow(flow_id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{flow_id}}{the name/id of the flow for inspection, for example "HelloWorldFlow"}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
R6 object representing the FlowClient object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-run"></a>}}
\if{latex}{\out{\hypertarget{method-run}{}}}
\subsection{Method \code{run()}}{
Create a metaflow RunClient R6 object from a FlowClient R6 object and run_id
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{mf_client$run(flow_client, run_id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{flow_client}}{R6 object}

\item{\code{run_id}}{run id}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
R6 object representing the RunClient object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-step"></a>}}
\if{latex}{\out{\hypertarget{method-step}{}}}
\subsection{Method \code{step()}}{
Create a metaflow StepClient R6 object from RunClient R6 object and step_id
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{mf_client$step(run_client, step_id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{run_client}}{run_client}

\item{\code{step_id}}{step id}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
R6 object representing the StepClient object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-task"></a>}}
\if{latex}{\out{\hypertarget{method-task}{}}}
\subsection{Method \code{task()}}{
Create a metaflow StepClient R6 object from RunClient R6 object and step_id
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{mf_client$task(step_client, task_id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{step_client}}{step client}

\item{\code{task_id}}{task id}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
R6 object representing the StepClient object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{mf_client$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
