% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install.R
\name{install_metaflow}
\alias{install_metaflow}
\title{Install Metaflow Python package}
\usage{
install_metaflow(
  method = c("conda", "virtualenv"),
  prompt = TRUE,
  version = NULL,
  ...
)
}
\arguments{
\item{method}{\code{character}, indicates to use \code{"conda"} or \code{"virtualenv"}.}

\item{prompt}{boolean, whether or not to prompt user for confirmation before installation. Default is TRUE.}

\item{version}{\code{character}, version of Metaflow to install. The default version
is the latest available on PyPi.}

\item{...}{other arguments sent to \code{\link[reticulate:conda-tools]{reticulate::conda_install()}} or
\code{\link[reticulate:virtualenv-tools]{reticulate::virtualenv_install()}}}
}
\description{
This function wraps installation functions from \link[reticulate:reticulate]{reticulate} to install the Python packages
\strong{metaflow} and it's Python dependencies.
}
\details{
This package uses the \link[reticulate:reticulate]{reticulate} package
to make an interface with the \href{https://metaflow.org/}{Metaflow}
Python package.
}
\examples{
\dontrun{
# not run because it requires Python
install_metaflow()
}
}
\seealso{
\href{https://rstudio.github.io/reticulate/articles/package.html}{reticulate: Using reticulate in an R Package},
\href{https://rstudio.github.io/reticulate/articles/python_packages.html}{reticulate: Installing Python Packages}
}
