% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decorators.R
\name{fmt_decorator}
\alias{fmt_decorator}
\title{Format an R decorator as a Python decorator}
\usage{
fmt_decorator(x, ..., .convert_args = TRUE)
}
\arguments{
\item{x}{Decorator name.}

\item{...}{Named arguments for the decorator (e.g, \code{cpu=1}, \code{memory=1000}).
Note that memory unit is in MB.}

\item{.convert_args}{Boolean. If \code{TRUE} (the default), argument values will
be converted to analogous Python values, with strings quoted and escaped.
Disable this if argument values are already formatted for Python.}
}
\value{
character vector of length two, in which the first element is the
translated decorator and the second element is a new line character.
}
\description{
Format an R decorator as a Python decorator
}
\section{Python decorators}{
 Metaflow decorators are so called because they
translate directly to Python decorators that are applied to a step. So, for
example, \code{decorator("batch", cpu = 1)} in R becomes \verb{@batch(cpu = 1)} in
Python. A new line is appended as well, as Python decorators are placed
above the function they take as an input.
}

\examples{
\dontrun{
fmt_decorator("resources", cpu = 1, memory = 1000)
# returns c("@resources(cpu=1, memory=1000)", "\n")
}
}
\keyword{internal}
