% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decorators-environment.R
\name{environment_variables}
\alias{environment_variables}
\title{Decorator that sets environment variables during step execution}
\usage{
environment_variables(...)
}
\arguments{
\item{...}{Named environment variables and their values, with all values
coercible to a character string.. For example, \code{environment_variables(foo = "bar")} will set the "foo" environment variable as "bar" during step
execution.}
}
\value{
A object of class "decorator"
}
\description{
Decorator that sets environment variables during step execution
}
\examples{
\dontrun{
start <- function(self) {
  print(paste("The cutest animal is the", Sys.getenv("CUTEST_ANIMAL")))
  print(paste("The", Sys.getenv("ALSO_CUTE"), "is also cute, though"))
}

metaflow("EnvironmentVariables") \%>\%
  step(step="start", 
       environment_variables(CUTEST_ANIMAL = "corgi", ALSO_CUTE = "penguin"),
       r_function=start, 
       next_step="end") \%>\%
  step(step="end") \%>\% 
  run()
}
}
