% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decorators.R
\name{decorator_arguments}
\alias{decorator_arguments}
\title{Format the arguments of a decorator as inputs to a Python function}
\usage{
decorator_arguments(args, .convert_args = TRUE)
}
\arguments{
\item{args}{Named list of arguments, as would be provided to the \code{...} of a
function.}

\item{.convert_args}{Boolean. If \code{TRUE} (the default), argument values will
be converted to analogous Python values, with strings quoted and escaped.
Disable this if argument values are already formatted for Python.}
}
\value{
atomic character of arguments, separated by a comma
}
\description{
Format the arguments of a decorator as inputs to a Python function
}
\section{Python decorators}{
 Metaflow decorators are so called because they
translate directly to Python decorators that are applied to a step. So, for
example, \code{decorator("batch", cpu = 1)} in R becomes \verb{@batch(cpu = 1)} in
Python. A new line is appended as well, as Python decorators are placed
above the function they take as an input.
}

\examples{
\dontrun{
decorator_arguments(list(cpu = 1, memory = 1000))
#> "cpu=1, memory=1000"
}
}
\keyword{internal}
