% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decorators-errors.R
\name{catch}
\alias{catch}
\title{Decorator that configures a step to catch an error}
\usage{
catch(var = NULL, print_exception = TRUE)
}
\arguments{
\item{var}{Character. Name of the artifact in which to store the caught
exception. If \code{NULL} (the default), the exception is not stored.}

\item{print_exception}{Boolean. Determines whether or not the exception is
printed to stdout when caught. Defaults to \code{TRUE}.}
}
\value{
A object of class "decorator"
}
\description{
Use this decorator to configure a step to catch any errors that occur during
evaluation. For steps that can't be safely retried, it is a good idea to use
this decorator along with \code{retry(times = 0)}.

See \url{https://docs.metaflow.org/v/r/metaflow/failures#catching-exceptions-with-the-catch-decorator}
for more information on how to use this decorator.
}
\examples{
\donttest{

start <- function(self) {
  stop("Oh no!")
}

end <- function(self) {
  message(
    "Error is : ", self$start_failed
  )
}

metaflow("AlwaysErrors") \%>\%
  step(
    catch(var = "start_failed"),
    retry(times = 0),
    step = "start",
    r_function = start,
    next_step = "end"
  ) \%>\%
  step(
    step = "end",
    r_function = end
  ) \%>\%
  run()
}
}
