% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decorators.R
\name{add_decorators}
\alias{add_decorators}
\title{Format a list of decorators as a character vector}
\usage{
add_decorators(decorators)
}
\arguments{
\item{decorators}{List of decorators, as created by the
\code{\link{decorator}} function.}
}
\value{
character vector
}
\description{
Format a list of decorators as a character vector
}
\section{Python decorators}{
 Metaflow decorators are so called because they
translate directly to Python decorators that are applied to a step. So, for
example, \code{decorator("batch", cpu = 1)} in R becomes \verb{@batch(cpu = 1)} in
Python. A new line is appended as well, as Python decorators are placed
above the function they take as an input.
}

\examples{
\dontrun{
add_decorators(list(decorator("batch", cpu = 4), decorator("retry")))
#> c("@batch(cpu=4)", "\n", "@retry", "\n")
}
}
\keyword{internal}
