# Papers and Resources about Role-Playing Language Models

[![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/Neph0s/awesome-llm-role-playing-with-persona) 
[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](https://opensource.org/licenses/MIT) 
![Last Commit](https://img.shields.io/github/last-commit/Neph0s/awesome-llm-role-playing-with-persona.svg)

Awesome-llm-role-playing-agents: a curated list of resources for large language models, personas, and role-playing agents.

---

This repo primarily focuses on **character role-playing**, such as fictional characters, celebrities, and historical figures. While role-playing language agents are related to many research topics, such as multi-agent systems and long-context models, we cannot guarantee the inclusion of papers in these areas.

*Here are some other paper lists you might be interested in:*

💡 ![Last Commit](https://img.shields.io/github/last-commit/Sahandfer/PersonaPaper.svg)**[Persona Paper](https://github.com/Sahandfer/PersonaPaper):** A list of papers related to persona-based dialogue systems and personalized response generation.

🔬 ![Last Commit](https://img.shields.io/github/last-commit/penguinnnnn/awesome-llm-and-society.svg)**[LLM and Society](https://github.com/penguinnnnn/awesome-llm-and-society):**  Recent papers on (1) Psychology of LLMs; (2) Biases in LLMs.

🤖 ![Last Commit](https://img.shields.io/github/last-commit/zjunlp/LLMAgentPapers.svg)**[LLM Agent Papers](https://github.com/zjunlp/LLMAgentPapers):**  Must-read Papers on Large Language Model Agents.

## 🔔 News

- **2024-10-09 🎉Our survey paper"*From Persona to Personalization:A Survey on Role-Playing Language Agents"* [[arxiv](https://arxiv.org/abs/2404.18231)] has been accepted to TMLR!**

- **2024-08-19 FYI: Boson AI has released their benchmark *[[RPBench Leaderboard](https://boson.ai/rpbench/)]* and open-source model *[[Higgs-Llama-3 70B V2](https://huggingface.co/bosonai/Higgs-Llama-3-70B)]* which ranks first on it.**

- **2024-06-28 We reorganized this repo, putting more focus on role-playing agents.**

- **2024-04-30 We are super excited to announce our survey paper: "*From Persona to Personalization:A Survey on Role-Playing Language Agents"* [[arxiv](https://arxiv.org/abs/2404.18231)]**

- **2024-04-17 We are looking for collaborators interested in research on this topic. Contact us via email: xtwang21@m.fudan.edu.cn**

- **2023-10-30 We create this repository to maintain a paper list on *LLMs Role-Playing with Assigned Personas* .**

## 📜Content

- [LLM Role-Playing/Persona Papers and Resources](#llm-role-playingpersona-papers-and-resources)
  - [🔔 News](#-news)
  - [📜Content](#content)
    - [🧙 Role-Playing](#-role-playing)
      - [🧙 Characters](#-characters)
      - [👨‍👩‍👧‍👦 Demographics](#️-demographics)
      - [🤖 Personalization](#-personalization)
    - [👥 Multi Agents](#-multi-agents)
    - [🧠 Anthropomorphic Cognition](#-anthropomorphic-cognition)
      - [🎭 Personality Traits](#-personality-traits)
      - [👥 Social Intelligence & Theory-of-Mind](#-social-intelligence--theory-of-mind) 
      - [🧠 Others](#-others-1)
    - [🌐 Others](#-others-2)
      - [📂 Resources](#-resources)
      - [📰 Blogs](#-blogs)
      - [📄 Papers](#-papers)
  - [💡  Contribution](#--contribution)
    - [Contributing to this repo](#contributing-to-this-repo)
    - [Contributors](#contributors)



### 🧙 Role-Playing

#### 🧙 Characters

*Established Characters*

-  **From Persona to Personalization: A Survey on Role-Playing Language Agents.**
   
   *Jiangjie Chen, Xintao Wang, Rui Xu, Siyu Yuan, Yikai Zhang, Wei Shi, Jian Xie, Shuang Li, Ruihan Yang, Tinghui Zhu, Aili Chen, Nianqi Li, Lida Chen, Caiyu Hu, Siye Wu, Scott Ren, Ziquan Fu, Yanghua Xiao.* [[abs](https://arxiv.org/abs/2404.18231)], TMLR 2024.04

-  **InCharacter: Evaluating Personality Fidelity in Role-Playing Agents through Psychological Interviews. (Previously: Do Role-Playing Chatbots Capture the Character Personalities? Assessing Personality Traits for Role-Playing Chatbots)**

   *Xintao Wang, Yunze Xiao, Jen-tse Huang, Siyu Yuan, Rui Xu, Haoran Guo, Quan Tu, Yaying Fei, Ziang Leng, Wei Wang, Jiangjie Chen, Cheng Li, Yanghua Xiao.* [[abs](https://arxiv.org/abs/2310.17976)], ACL 2024

-  **RoleLLM: Benchmarking, Eliciting, and Enhancing Role-Playing Abilities of Large Language Models.**

   *Zekun Moore Wang, Zhongyuan Peng, Haoran Que, Jiaheng Liu, Wangchunshu Zhou, Yuhan Wu, Hongcheng Guo, Ruitong Gan, Zehao Ni, Man Zhang, Zhaoxiang Zhang, Wanli Ouyang, Ke Xu, Wenhu Chen, Jie Fu, Junran Peng.*, [[abs](https://arxiv.org/abs/2310.00746)], Findings of ACL 2024

-  **ChatHaruhi: Reviving Anime Character in Reality via Large Language Model.**

   *Cheng Li, Ziang Leng, Chenxi Yan, Junyi Shen, Hao Wang, Weishi MI, Yaying Fei, Xiaoyang Feng, Song Yan, HaoSheng Wang, Linkang Zhan, Yaokai Jia, Pingyu Wu, Haozhen Sun.* [[abs](https://arxiv.org/abs/2308.09597)], 2023.8

-  **Character-LLM: A Trainable Agent for Role-Playing.**

   *Yunfan Shao, Linyang Li, Junqi Dai, Xipeng Qiu.*, [[abs](https://arxiv.org/abs/2310.10158)], EMNLP 2023

-  **Mitigating Hallucination in Fictional Character Role-Play**

   *Nafis Sadeq, Zhouhang Xie, Byungkyu Kang, Prarit Lamba, Xiang Gao, Julian McAuley.*, [[abs](https://arxiv.org/abs/2406.17260)] [[dataset](https://github.com/NafisSadeq/rolefact)], Findings of EMNLP 2024

-  **Quantifying and Optimizing Global Faithfulness in Persona-driven Role-playing**

   *Letian Peng, Jingbo Shang.*, [[abs](https://arxiv.org/abs/2405.07726)] [[dataset](https://github.com/KomeijiForce/Active_Passive_Constraint_Koishiday_2024)], NeurIPS 2024

-  **CharacterGLM: Customizing Chinese Conversational AI Characters with Large Language Models.**
   *Jinfeng Zhou, Zhuang Chen, Dazhen Wan, Bosi Wen, Yi Song, Jifan Yu, Yongkang Huang, Libiao Peng, Jiaming Yang, Xiyao Xiao, Sahand Sabour, Xiaohan Zhang, Wenjing Hou, Yijia Zhang, Yuxiao Dong, Jie Tang, Minlie Huang.*, [[abs](https://arxiv.org/abs/2311.16832)], 2023.11

-  **PIPPA: A Partially Synthetic Conversational Dataset**
   *Tear Gosling, Alpin Dale, Yinhe Zheng.* [[abs](https://arxiv.org/abs/2308.05884)], 2023.08

- **Character is Destiny: Can Large Language Models Simulate Persona-Driven Decisions in Role-Playing?**

   *Rui Xu, Xintao Wang, Jiangjie Chen, Siyu Yuan, Xinfeng Yuan, Jiaqing Liang, Zulong Chen, Xiaoqing Dong, Yanghua Xiao.* [[abs](https://arxiv.org/abs/2404.12138)], 2024.04


-  **Large Language Models are Superpositions of All Characters: Attaining Arbitrary Role-play via Self-Alignment**
   *Keming Lu, Bowen Yu, Chang Zhou, Jingren Zhou.*, [[abs](https://arxiv.org/abs/2401.12474)], 2024.01

-  **Large Language Models Meet Harry Potter: A Bilingual Dataset for Aligning Dialogue Agents with Characters.**
   *Nuo Chen, Yan Wang, Haiyun Jiang, Deng Cai, Yuhan Li, Ziyang Chen, Longyue Wang, Jia Li.*, [[abs](https://arxiv.org/abs/2211.06869)], 2022.11

- **Evaluating Character Understanding of Large Language Models via Character Profiling from Fictional Works**
   *Xinfeng Yuan, Siyu Yuan, Yuhan Cui, Tianhe Lin, Xintao Wang, Rui Xu, Jiangjie Chen, Deqing Yang.* [[abs](https://arxiv.org/abs/2404.12726)], 2024.04


- **From Role-Play to Drama-Interaction: An LLM Solution**
   *Weiqi Wu, Hongqiu Wu, Lai Jiang, Xingyuan Liu, Jiale Hong, Hai Zhao, Min Zhang.* [[abs](https://arxiv.org/abs/2405.14231)], Findings of ACL 2024

- **TimeChara: Evaluating Point-in-Time Character Hallucination of Role-Playing Large Language Models**
   *Jaewoo Ahn, Taehyun Lee, Junyoung Lim, Jin-Hwa Kim, Sangdoo Yun, Hwaran Lee, Gunhee Kim.* [[abs](https://arxiv.org/abs/2405.18027)], Findings of ACL 2024


-  **“Let Your Characters Tell Their Story”: A Dataset for Character-Centric Narrative Understanding**
   *Faeze Brahman, Meng Huang, Oyvind Tafjord, Chao Zhao, Mrinmaya Sachan, Snigdha Chaturvedi.*, [[abs](https://aclanthology.org/2021.findings-emnlp.150/)], EMNLP findings 2021


-  **CharacterEval: A Chinese Benchmark for Role-Playing Conversational Agent Evaluation.**
   *Quan Tu, Shilong Fan, Zihang Tian, Rui Yan.*, [[abs](https://arxiv.org/abs/2401.01275)], ACL 2024


-  **Neeko: Leveraging Dynamic LoRA for Efficient Multi-Character Role-Playing Agent**
   *Xiaoyan Yu, Tongxu Luo, Yifan Wei, Fangyu Lei, Yiming Huang, Hao Peng, Liehuang Zhu.*, [[abs](https://arxiv.org/abs/2402.13717)], 2024.02

-  **RoleEval: A Bilingual Role Evaluation Benchmark for Large Language Models**
   *Tianhao Shen, Sun Li, Quan Tu, Deyi Xiong.* [[abs](https://arxiv.org/abs/2312.16132)], 2023.12

-  **ERABAL: Enhancing Role-Playing Agents through Boundary-Aware Learning**
   *Yihong Tang, Jiao Ou, Che Liu, Fuzheng Zhang, Di Zhang, Kun Gai.* [[abs](https://arxiv.org/abs/2409.14710)], 2024.09

-  **SocialBench: Sociality Evaluation of Role-Playing Conversational Agents**
   *Hongzhan Chen, Hehong Chen, Ming Yan, Wenshen Xu, Xing Gao, Weizhou Shen, Xiaojun Quan, Chenliang Li, Ji Zhang, Fei Huang, Jingren Zhou.* [[abs](https://arxiv.org/abs/2403.13679)], 2024.03

- **Capturing Minds, Not Just Words: Enhancing Role-Playing Language Models with Personality-Indicative Data**
   *Yiting Ran, Xintao Wang, Rui Xu, Xinfeng Yuan, Jiaqing Liang, Yanghua Xiao, Deqing Yang.* [[abs](https://arxiv.org/abs/2406.18921)], Findings of EMNLP 2024

- **MMRole: A Comprehensive Framework for Developing and Evaluating Multimodal Role-Playing Agents**
   *Yanqi Dai, Huanran Hu, Lei Wang, Shengjie Jin, Xu Chen, Zhiwu Lu.* [[abs](https://arxiv.org/abs/2408.04203)], 2024.08

- **Revealing the Challenge of Detecting Character Knowledge Errors in LLM Role-Playing**
   *Wenyuan Zhang, Jiawei Sheng, Shuaiyi Nie, Zefeng Zhang, Xinghua Zhang, Yongquan He, Tingwen Liu.* [[abs](https://arxiv.org/abs/2409.11726)], 2024.09

- **BEYOND DIALOGUE: A Profile-Dialogue Alignment Framework Towards General Role-Playing Language Model**
   *Yeyong Yu, Runsheng Yu, Haojie Wei, Zhanqiu Zhang, Quan Qian.* [[abs](https://arxiv.org/abs/2408.10903)], 2024.08

- **PRODIGy: a PROfile-based DIalogue Generation dataset**
  *Daniela Occhipinti, Serra Sinem Tekiroglu, Marco Guerini* [[abs](https://arxiv.org/abs/2311.05195)] [[dataset](https://github.com/LanD-FBK/prodigy-dataset)], NAACL Findings 2024

*Original Characters*

- **Scaling Synthetic Data Creation with 1,000,000,000 Personas**
   *Xin Chan, Xiaoyang Wang, Dian Yu, Haitao Mi, Dong Yu.* [[abs](https://arxiv.org/abs/2406.20094)], 2024.06

- **Stark: Social Long-Term Multi-Modal Conversation with Persona Commonsense Knowledge**
   *Young-Jun Lee, Dokyong Lee, Junyoung Youn, Kyeongjin Oh, Byungsoo Ko, Jonghwan Hyeon, Ho-Jin Choi.* [[abs](https://arxiv.org/abs/2407.03958)], EMNLP 2024

- **PersonaGym: Evaluating Persona Agents and LLMs**
   *Vinay Samuel, Henry Peng Zou, Yue Zhou, Shreyas Chaudhari, Ashwin Kalyan, Tanmay Rajpurohit, Ameet Deshpande, Karthik Narasimhan, Vishvak Murahari.* [[abs](https://arxiv.org/abs/2407.18416)], 2024.10

#### 👨‍👩‍👧‍👦 Demographics

-  **Expertprompting: Instructing large language models to be distinguished experts**

   *Benfeng Xu , An Yang , Junyang Lin , Quan Wang , Chang Zhou, Yongdong Zhang and Zhendong Mao.* [[abs](https://arxiv.org/abs/2305.14688)], 2023.5

-  **Toxicity in ChatGPT: Analyzing Persona-assigned Language Models**

   *Ameet Deshpande, Vishvak Murahari, Tanmay Rajpurohit, Ashwin Kalyan, Karthik Narasimhan.* [[abs](https://arxiv.org/abs/2304.05335)], 2023.4

-  **Better Zero-Shot Reasoning with Role-Play Prompting**
   *Aobo Kong, Shiwan Zhao, Hao Chen, Qicheng Li, Yong Qin, Ruiqi Sun, Xin Zhou.* [[abs](https://arxiv.org/abs/2308.07702)], 2023.8

-  **Bias Runs Deep: Implicit Reasoning Biases in Persona-Assigned LLMs**
   *Shashank Gupta, Vaishnavi Shrivastava, Ameet Deshpande, Ashwin Kalyan, Peter Clark, Ashish Sabharwal, Tushar Khot* [[abs](https://arxiv.org/abs/2311.04892)], 2023.11

-  **Is "A Helpful Assistant" the Best Role for Large Language Models? A Systematic Evaluation of Social Roles in System Prompts.**
   *Mingqian Zheng, Jiaxin Pei, David Jurgens* [[abs](https://arxiv.org/abs/2311.10054)], 2023.11

-  **CoMPosT: Characterizing and Evaluating Caricature in LLM Simulations**
   *Myra Cheng, Tiziano Piccardi, Diyi Yang.* [[abs](https://arxiv.org/abs/2310.11501)], 2023.10

-  **Deciphering Stereotypes in Pre-Trained Language Models**
   *Weicheng Ma, Henry Scheible, Brian Wang, Goutham Veeramachaneni, Pratim Chowdhary, Alan Sun, Andrew Koulogeorge, Lili Wang, Diyi Yang, Soroush Vosoughi.* [[abs](https://aclanthology.org/2023.emnlp-main.697/)], EMNLP Findings 2023

-  **CultureLLM: Incorporating Cultural Differences into Large Language Models**
   *Cheng Li, Mengzhou Chen, Jindong Wang, Sunayana Sitaram, Xing Xie.* [[abs](https://arxiv.org/abs/2402.10946)], 2024.02

- **Aligning Large Language Models with Human Opinions through Persona Selection and Value–Belief–Norm Reasoning**
   *CDo Xuan Long, Kenji Kawaguchi, Min Yen Kan, Nancy F Chen.* [[abs](https://arxiv.org/abs/2311.08385)], 2024.11

#### 🤖 Personalization



-  **LaMP: When Large Language Models Meet Personalization**
   *Alireza Salemi, Sheshera Mysore, Michael Bendersky, Hamed Zamani* [[abs](https://arxiv.org/abs/2304.11406)], 2023.04.

- **How Well Can LLMs Echo Us? Evaluating AI Chatbots' Role-Play Ability with ECHO**
   *Man Tik Ng, Hui Tung Tse, Jen-tse Huang, Jingjing Li, Wenxuan Wang, Michael R. Lyu.* [[abs](https://arxiv.org/abs/2404.13957)], 2024.04

-  **On the steerability of large language models toward data-driven personas**
   *Junyi Li, Ninareh Mehrabi, Charith Peris, Palash Goyal, Kai-Wei Chang, Aram Galstyan, Richard Zemel, Rahul Gupta* [[abs](https://aclanthology.org/2024.naacl-long.405/)], NAACL 2024.

- **Show, Don’t Tell: Aligning Language Models with Demonstrated Feedback**
   *Omar Shaikh, Michelle Lam, Joey Hejna, Yijia Shao, Michael Bernstein, Diyi Yang* [[abs](https://arxiv.org/pdf/2406.00888)], 2024.06

- **PersLLM: A Personified Training Approach for Large Language Models**
   *Zheni Zeng, Jiayi Chen, Huimin Chen, Yukun Yan, Yuxuan Chen, Zhenghao Liu, Zhiyuan Liu, Maosong Sun* [[abs](https://arxiv.org/abs/2407.12393)], 2024.07

-  **LiveChat: A Large-Scale Personalized Dialogue Dataset Automatically Constructed from Live Streaming**

   *Jingsheng Gao, Yixin Lian, Ziyi Zhou, Yuzhuo Fu, Baoyuan Wang.* [[abs](https://arxiv.org/abs/2306.08401)], 2023.6. Tags: streamer persona.

-  **COSPLAY: Concept Set Guided Personalized Dialogue Generation Across Both Party Personas**
   *Jingsheng Gao, Yixin Lian, Ziyi Zhou, Yuzhuo Fu, Baoyuan Wang.* [[abs](https://arxiv.org/abs/2205.00872)], SIGIR 2022.

-  **Personalizing Dialogue Agents: I have a dog, do you have pets too?** 
   *Saizheng Zhang, Emily Dinan, Jack Urbanek, Arthur Szlam, Douwe Kiela, Jason Weston.* [[abs](https://arxiv.org/abs/1801.07243)], ACL 2018.

-  **MPCHAT: Towards Multimodal Persona-Grounded Conversation**
   *Jaewoo Ahn, Yeda Song, Sangdoo Yun, Gunhee Kim.* [[abs](https://arxiv.org/abs/2305.17388)], ACL 2023. Tags: multimodal persona.


-  **Personalized Reward Learning with Interaction-Grounded Learning (IGL)**
   *Jessica Maghakian, Paul Mineiro, Kishan Panaganti, Mark Rucker, Akanksha Saran, Cheng Tan* [[abs](https://arxiv.org/abs/2211.15823)], 2022.11.

-  **When Large Language Models Meet Personalization: Perspectives of Challenges and Opportunities**
   *Jin Chen, Zheng Liu, Xu Huang, Chenwang Wu, Qi Liu, Gangwei Jiang, Yuanhao Pu, Yuxuan Lei, Xiaolong Chen, Xingmei Wang, Defu Lian, Enhong Chen* [[abs](https://arxiv.org/abs/2307.16376)], 2023.07, Survey.

-  **Beyond ChatBots: ExploreLLM for Structured Thoughts and Personalized Model Responses**
   *Xiao Ma, Swaroop Mishra, Ariel Liu, Sophie Su, Jilin Chen, Chinmay Kulkarni, Heng-Tze Cheng, Quoc Le, Ed Chi* [[abs](https://arxiv.org/abs/2312.00763)], 2023.12.

-  **PersonalityChat: Conversation Distillation for Personalized Dialog Modeling with Facts and Traits**
   *Ehsan Lotfi, Maxime De Bruyn, Jeska Buhmann, Walter Daelemans.* [[abs](https://arxiv.org/abs/2401.07363)], 2024.01.

- **Beyond Demographics: Aligning Role-playing LLM-based Agents Using Human Belief Networks**
   *Yun-Shiuan Chuang, Krirk Nirunwiroj, Zach Studdiford, Agam Goyal, Vincent V. Frigo, Sijia Yang, Dhavan Shah, Junjie Hu, Timothy T. Rogers.* [[abs](https://arxiv.org/abs/2406.17232)], 2024.06

- **Generative Agent Simulations of 1,000 People**
   *Joon Sung Park, Carolyn Q. Zou, Aaron Shaw, Benjamin Mako Hill, Carrie Cai, Meredith Ringel Morris, Robb Willer, Percy Liang, Michael S. Bernstein.* [[abs](https://arxiv.org/abs/2411.10109)], 2024.11


### 👥 Multi Agents

-  **Generative Agents: Interactive Simulacra of Human Behavior**
   *Joon Sung Park, Joseph C. O'Brien, Carrie J. Cai, Meredith Ringel Morris, Percy Liang, Michael S. Bernstein.* [[abs](https://arxiv.org/abs/2304.03442)], 2023.04.

-  **Communicative Agents for Software Development**
   *Chen Qian, Xin Cong, Wei Liu, Cheng Yang, Weize Chen, Yusheng Su, Yufan Dang, Jiahao Li, Juyuan Xu, Dahai Li, Zhiyuan Liu, Maosong Sun.* [[abs](https://arxiv.org/abs/2307.07924)], 2023.07.

-  **Corex: Pushing the Boundaries of Complex Reasoning through Multi-Model Collaboration.**
   *Qiushi Sun, Zhangyue Yin, Xiang Li, Zhiyong Wu, Xipeng Qiu, Lingpeng Kong.* [[abs](https://arxiv.org/abs/2310.00280)], 2023.09.

-  **AVALONBENCH: Evaluating LLMs Playing the Game of Avalon.**
   *Jonathan Light, Min Cai, Sheng Shen, Ziniu Hu.* [[abs](https://arxiv.org/abs/2310.05036)], 2023.10.

-  **War and Peace (WarAgent): Large Language Model-based Multi-Agent Simulation of World Wars.**
   *Wenyue Hua, Lizhou Fan, Lingyao Li, Kai Mei, Jianchao Ji, Yingqiang Ge, Libby Hemphill, Yongfeng Zhang.* [[abs](https://arxiv.org/abs/2311.17227)], 2023.11.

-  **Leveraging Word Guessing Games to Assess the Intelligence of Large Language Models.**
   *Tian Liang, Zhiwei He, Jen-tse Huang, Wenxuan Wang, Wenxiang Jiao, Rui Wang, Yujiu Yang, Zhaopeng Tu, Shuming Shi, Xing Wang.* [[abs](https://arxiv.org/abs/2310.20499)], 2023.10.

-  **AntEval: Quantitatively Evaluating Informativeness and Expressiveness of Agent Social Interactions.**
   *Yuanzhi Liang, Linchao Zhu, Yi Yang.* [[abs](https://arxiv.org/abs/2401.06509)], 2024.01.

-  **Exchange-of-Thought: Enhancing Large Language Model Capabilities through Cross-Model Communication**
   *Zhangyue Yin, Qiushi Sun, Cheng Chang, Qipeng Guo, Junqi Dai, Xuanjing Huang, Xipeng Qiu.* [[abs](https://aclanthology.org/2023.emnlp-main.936/)], 2024.01.

-  **Exploring Collaboration Mechanisms for LLM Agents: A Social Psychology View**
   *Jintian Zhang, Xin Xu, Ningyu Zhang, Ruibo Liu, Bryan Hooi, Shumin Deng.* [[abs](https://arxiv.org/abs/2310.02124)], 2023.10

-  **Training socially aligned language models on simulated social interactions**
   *Ruibo Liu, Ruixin Yang, Chenyan Jia, Ge Zhang, Diyi Yang, Soroush Vosoughi.* [[abs](https://openreview.net/forum?id=NddKiWtdUm)], ICLR 2024

-  **How Far Are We on the Decision-Making of LLMs? Evaluating LLMs' Gaming Ability in Multi-Agent Environments**
   *Jen-tse Huang, Eric John Li, Man Ho Lam, Tian Liang, Wenxuan Wang, Youliang Yuan, Wenxiang Jiao, Xing Wang, Zhaopeng Tu, Michael R. Lyu.* [[abs](https://arxiv.org/abs/2403.11807)], 2024.03

-  **AgentGroupChat: An Interactive Group Chat Simulacra For Better Eliciting Collective Emergent Behavior**
   *Zhouhong Gu, Xiaoxuan Zhu, Haoran Guo, Lin Zhang, Yin Cai, Hao Shen, Jiangjie Chen, Zheyu Ye, Yifei Dai, Yan Gao, Yao Hu, Hongwei Feng, Yanghua Xiao* [[abs](https://arxiv.org/abs/2403.13433)], 2024.03

-  **Is this the real life? Is this just fantasy? The Misleading Success of Simulating Social Interactions With LLMs**
   *Xuhui Zhou, Zhe Su, Tiwalayo Eisape, Hyunwoo Kim, Maarten Sap.* [[abs](https://arxiv.org/abs/2403.05020)], 2024.03

- **EvoAgent: Towards Automatic Multi-Agent Generation via Evolutionary Algorithms**
  *Siyu Yuan, Kaitao Song, Jiangjie Chen, Xu Tan, Dongsheng Li, Deqing Yang.* [[abs](https://arxiv.org/abs/2406.14228)], 2024.06

- **HoLLMwood: Unleashing the Creativity of Large Language Models in Screenwriting via Role Playing**
   *Jing Chen, Xinyu Zhu, Cheng Yang, Chufan Shi, Yadong Xi, Yuxiang Zhang, Junjie Wang, Jiashu Pu, Rongsheng Zhang, Yujiu Yang, Tian Feng* [[abs](https://arxiv.org/abs/2406.11683)], 2024.06

- **MathVC: An LLM-Simulated Multi-Character Virtual Classroom for Mathematics Education**
  *Murong Yue, Wijdane Mifdal, Yixuan Zhang, Jennifer Suh, Ziyu Yao.* [[abs](https://murongyue.github.io/MathVC.github.io/)], 2024.4

- **Artificial Leviathan: Exploring Social Evolution of LLM Agents Through the Lens of Hobbesian Social Contract Theory**
   *Gordon Dai, Weijia Zhang, Jinhan Li, Siqi Yang, Chidera Onochie lbe, Srihas Rao, Arthur Caetano, Misha Sra.* [[abs](https://arxiv.org/abs/2406.14373)], 2024.06


- **Dialogue Action Tokens: Steering Language Models in Goal-Directed Dialogue with a Multi-Turn Planner**
   *Kenneth Li, Yiming Wang, Fernanda Viégas, Martin Wattenberg.* [[abs](https://arxiv.org/abs/2406.11978)], 2024.06

- **LLM Discussion: Enhancing the Creativity of Large Language Models via Discussion Framework and Role-Play**
   *Li-Chun Lu, Shou-Jen Chen, Tsung-Min Pai, Chan-Hung Yu, Hung-yi Lee, Shao-Hua Sun.* [[abs](https://arxiv.org/abs/2405.06373)], COLM 2024

- **Persona Inconstancy in Multi-Agent LLM Collaboration: Conformity, Confabulation, and Impersonation**
   *Razan Baltaji, Babak Hemmatian, Lav R. Varshney.* [[abs](https://arxiv.org/abs/2405.03862)], 2024.05

-  **Multi-expert Prompting Improves Reliability, Safety, and Usefulness of Large Language Models**

   *Do Xuan Long, Duong Ngoc Yen, Anh Tuan Luu, Kenji Kawaguchi, Min-Yen Kan, Nancy F. Chen.* [[abs](https://arxiv.org/abs/2411.00492)], 2024.11, EMNLP 2024.

### 🧠 Anthropomorphic Cognition

#### 🎭 Personality Traits

-  **Personality Traits in Large Language Models**

   *Mustafa Safdari, Greg Serapio-García, Clément Crepy, Stephen Fitz, Peter Romero, Luning Sun, Marwa Abdulhai, Aleksandra Faust, Maja Matarić.* [[abs](https://arxiv.org/abs/2307.00184)], 2023.7

-  **Estimating the Personality of White-Box Language Models.**

   *Saketh Reddy Karra, Son The Nguyen, Theja Tulabandhula.* [[abs](https://arxiv.org/abs/2204.12000)], 2022.4

-  **PersonaLLM: Investigating the Ability of GPT-3.5 to Express Personality Traits and Gender Differences.**
    
    *Hang Jiang, Xiajie Zhang, Xubo Cao, Jad Kabbara.*, [[abs](https://arxiv.org/abs/2305.02547)], 2023.5

-  **Does GPT-3 Demonstrate Psychopathy? Evaluating Large Language Models from a Psychological Perspective.**

   *Xingxuan Li, Yutong Li, Shafiq Joty, Linlin Liu, Fei Huang, Lin Qiu, Lidong Bing.* [[abs](https://arxiv.org/abs/2212.10529)], 2022.12

-  **Evaluating and Inducing Personality in Pre-trained Language Models.**
   *Guangyuan Jiang, Manjie Xu, Song-Chun Zhu, Wenjuan Han, Chi Zhang, Yixin Zhu.* [[abs](https://arxiv.org/abs/2206.07550)], 2022.6

-  **Revisiting the Reliability of Psychological Scales on Large Language Models (Previously: ChatGPT an ENFJ, Bard an ISTJ:Empirical Study on Personalities of Large Language Models.)**
   *Jen-tse Huang, Wenxuan Wang, Man Ho Lam, Eric John Li, Wenxiang Jiao, Michael R. Lyu.* [[abs](https://arxiv.org/abs/2305.19926)], 2023.5

-  **Do llms possess a personality? making the mbti test an amazing evaluation for large language models.**

   *Keyu Pan, Yawen Zeng.* [[abs](https://arxiv.org/abs/2307.16180)], 2023.7

-  **Can chatgpt assess human personalities? a general evaluation framework.**

   *Haocong Rao, Cyril Leung, Chunyan Miao.* [[abs](https://arxiv.org/abs/2303.01248)], 2023.3

-  **Who is GPT-3? An Exploration of Personality, Values and Demographics.**

   *Marilù Miotto, Nicola Rossberg, Bennett Kleinberg.*, [[abs](https://arxiv.org/abs/2209.14338)], 2022.9

-  **Editing Personality for LLMs**
    
   *Shengyu Mao, Ningyu Zhang, Xiaohan Wang, Mengru Wang, Yunzhi Yao, Yong Jiang, Pengjun Xie, Fei Huang, Huajun Chen.*, [[abs](https://arxiv.org/abs/2310.02168)], 2023.10


-  **MBTI Personality Prediction for Fictional Characters Using Movie Scripts**
    
    *Yisi Sang, Xiangyang Mou, Mo Yu, Dakuo Wang, Jing Li, Jeffrey Stanton.*, [[abs](https://arxiv.org/abs/2210.10994)], EMNLP 2022

-  **Unleashing Cognitive Synergy in Large Language Models: A Task-Solving Agent through Multi-Persona Self-Collaboration**
    
    *Zhenhailong Wang, Shaoguang Mao, Wenshan Wu, Tao Ge, Furu Wei, Heng Ji.*, [[abs](https://arxiv.org/abs/2307.05300)], 2023.7
   
-  **Open Models, Closed Minds? On Agents Capabilities in Mimicking Human Personalities through Open Large Language Models**

   *Lucio La Cava, Davide Costa, Andrea Tagarelli.*, [[abs](https://arxiv.org/abs/2401.07115)], 2024.01

- **Generative Agent Simulations of 1,000 People**
   *Joon Sung Park, Carolyn Q. Zou, Aaron Shaw, Benjamin Mako Hill, Carrie Cai, Meredith Ringel Morris, Robb Willer, Percy Liang, Michael S. Bernstein.* [[abs](https://arxiv.org/abs/2411.10109)], 2024.11

#### 👥 Social Intelligence & Theory-of-Mind

-  **Theory of Mind May Have Spontaneously Emerged in Large Language Models**

   *Michal Kosinski.* [[abs](https://arxiv.org/abs/2302.02083)], 2023.2

-  **SOTOPIA: Interactive Evaluation for Social Intelligence in Language Agents**

   *Xuhui Zhou, Hao Zhu, Leena Mathur, Ruohong Zhang, Haofei Yu, Zhengyang Qi, Louis-Philippe Morency, Yonatan Bisk, Daniel Fried, Graham Neubig, Maarten Sap.* [[abs](https://arxiv.org/abs/2310.11667)], 2023.10

- **SOTOPIA-π: Interactive Learning of Socially Intelligent Language Agents**

   *Ruiyi Wang, Haofei Yu, Wenxin Zhang, Zhengyang Qi, Maarten Sap, Graham Neubig, Yonatan Bisk, Hao Zhu.* [[abs](https://arxiv.org/abs/2403.08715)], 2024.03

- **AgentSense: Benchmarking Social Intelligence of Language Agents through Interactive Scenarios**
   *Xinyi Mou, Jingcong Liang, Jiayu Lin, Xinnong Zhang, Xiawei Liu, Shiyue Yang, Rong Ye, Lei Chen, Haoyu Kuang, Xuanjing Huang, Zhongyu Wei* [[abs](https://arxiv.org/abs/2410.19346)], 2024.10

- **Towards Objectively Benchmarking Social Intelligence for Language Agents at Action Level**
   *Chenxu Wang, Bin Dai, Huaping Liu, Baoyuan Wang.* [[abs](https://arxiv.org/abs/2404.05337)], 2024.04

-  **OpenToM: A Comprehensive Benchmark for Evaluating Theory-of-Mind Reasoning Capabilities of Large Language Models.**
   *Hainiu Xu, Runcong Zhao, Lixing Zhu, Jinhua Du, Yulan He.* [[abs](https://arxiv.org/abs/2402.06044)], 2024.02.

-  **Is this the real life? Is this just fantasy? The Misleading Success of Simulating Social Interactions With LLMs**
   *Xuhui Zhou, Zhe Su, Tiwalayo Eisape, Hyunwoo Kim, Maarten Sap* [[abs](https://arxiv.org/abs/2403.05020)], 2024.03

#### 🧠 Others <!---others-1-->

-  **Role-Play with Large Language Models**
   *Murray Shanahan, Kyle McDonell, and Laria Reynolds.*[[abs](https://arxiv.org/abs/2305.16367)], 2023.5

-  **Consciousness in artificial intelligence: Insights from the science of consciousness.**
   *Patrick Butlin, Robert Long, Eric Elmoznino, Yoshua Bengio, Jonathan Birch, Axel Constant, George Deane, Stephen M. Fleming, Chris Frith, Xu Ji, Ryota Kanai, Colin Klein, Grace Lindsay, Matthias Michel, Liad Mudrik, Megan A. K. Peters, Eric Schwitzgebel, Jonathan Simon, Rufin VanRullen.*[[abs](https://arxiv.org/abs/2308.08708)], 2023.8

-  **The Self-Perception and Political Biases of ChatGPT.**

   *Jérôme Rutinowski, Sven Franke, Jan Endendyk, Ina Dormuth, Markus Pauly.*, 2023.4. Tags: personality traits, political biases, dark personality traits.

-  **The political ideology of conversational AI: Converging evidence on ChatGPT's pro-environmental, left-libertarian orientation.**

   *Jochen Hartmann, Jasper Schwenzow, Maximilian Witte.*, 2023.1. Tags: political biases.

-  **Inducing anxiety in large language models increases exploration and bias.**

   *Julian Coda-Forno, Kristin Witte, Akshay K. Jagadish, Marcel Binz, Zeynep Akata, Eric Schulz.*, 2023.4. Tags: anxiety.

-  **Exploring Collaboration Mechanisms for LLM Agents: A Social Psychology View.**

   *Jintian Zhang, Xin Xu, Shumin Deng.*, 2023.10. Tags: social psychology.



### 🌐 Others <!---others-2-->

#### 📂 Resources

- **RPBench Leaderboard**
   *Boson AI.* [[leaderboard](https://boson.ai/rpbench/)]

- **Higgs-Llama-3-70B**
   *Boson AI.* [[huggingface](https://huggingface.co/bosonai/Higgs-Llama-3-70B)]

#### 📰 Blogs

- **[[Character.ai 赛道的真相 (The Truth About the Character.ai Track)](https://mp.weixin.qq.com/s/H2KNDGRNHktHiQc3sayFsA)]**, 2024.08

- **[[李沐：创业一年，人间三年！(Mu Li (Boson AI): One Year of Entrepreneurship, Three Years in the Human World!)](https://mp.weixin.qq.com/s/2lbCMo64-nU5yRz1cLQxYA)]**, 2024.08

- **[[盘点ACL 2024 角色扮演方向都发了啥 (A Review of Publications in Role-Playing Direction at ACL 2024)](https://mp.weixin.qq.com/s/E5qp5YPYPVaLM07OumDTRw)]**, 2024.07

- **[[角色扮演大模型的碎碎念 (Ramblings on Large Language Models for Role-Playing)](https://mp.weixin.qq.com/s/yoM-srJYGGfyd1VXirg_Hg)]**, 2024.03

- **[[聊一聊做角色扮演大模型的经验 (Discussing Experiences in Developing Role-Playing Large Language Models)](https://zhuanlan.zhihu.com/p/3641608640)]**, 2024.10

- **[[角色扮演大模型技术分享 (Technical Insights on Role-Playing Large Language Models)](https://zhuanlan.zhihu.com/p/685823865)]**, 2024.03

- **[[角色扮演大模型技术分享2-超拟人模型的困境 (Technical Insights on Role-Playing Large Language Models 2 - The Dilemma of Super-Anthropomorphic Models)](https://zhuanlan.zhihu.com/p/719135803)]**, 2024.09

- **[[角色扮演大模型技术分享3-拟人能力提升&数据合成pipeline (Technical Insights on Role-Playing Large Language Models 3 - Improving Anthropomorphic Capabilities & Data Synthesis Pipeline)](https://zhuanlan.zhihu.com/p/719772276)]**, 2024.09


#### 📄 Papers

- **One Thousand and One Pairs: A “novel” challenge for long-context language models**
   *Marzena Karpinska, Katherine Thai, Kyle Lo, Tanya Goyal, Mohit Iyyer.* [[abs](https://arxiv.org/abs/2406.16264)], 2024.06

- **NovelQA: Benchmarking Question Answering on Documents Exceeding 200K Tokens**
   *Cunxiang Wang, Ruoxi Ning, Boqi Pan, Tonghui Wu, Qipeng Guo, Cheng Deng, Guangsheng Bao, Xiangkun Hu, Zheng Zhang, Qian Wang, Yue Zhang.* [[abs](https://arxiv.org/abs/2403.12766)], 2024.03


- **Visual-RolePlay: Universal Jailbreak Attack on MultiModal Large Language Models via Role-playing Image Character**
   *Siyuan Ma, Weidi Luo, Yu Wang, Xiaogeng Liu.* [[abs](https://arxiv.org/abs/2405.20773)], 2024.06

- **AI Cat Narrator: Designing an AI Tool for Exploring the Shared World and Social Connection with a Cat**
   *Zhenchi Lai, Janet Yi-Ching Huang, Rung-Huei Liang.* [[abs](https://arxiv.org/abs/2406.06192)], 2024.06

- **THEANINE: Revisiting Memory Management in Long-term Conversations with Timeline-augmented Response Generation**
  *Seo Hyun Kim, Kai Tzu-iunn Ong, Taeyoon Kwon, Namyoung Kim, Keummin Ka, SeongHyeon Bae, Yohan Jo, Seung-won Hwang, Dongha Lee, Jinyoung Yeo.* [[abs](https://arxiv.org/abs/2406.10996)], 2024.06

- **ESC-Eval: Evaluating Emotion Support Conversations in Large Language Models**
   *Haiquan Zhao, Lingyu Li, Shisong Chen, Shuqi Kong, Jiaan Wang, Kexin Huang, Tianle Gu, Yixu Wang, Dandan Liang, Zhixu Li, Yan Teng, Yanghua Xiao, Yingchun Wang.* [[abs](https://arxiv.org/abs/2406.14952)], 2024.06

- **PATIENT-Ψ: Using Large Language Models to Simulate Patients for Training Mental Health Professionals**
   *Ruiyi Wang, Stephanie Milani, Jamie C. Chiu, Jiayin Zhi, Shaun M. Eack, Travis Labrum, Samuel M. Murphy, Nev Jones, Kate Hardy, Hong Shen, Fei Fang, Zhiyu Zoey Chen.* [[abs](https://arxiv.org/abs/2405.19660)], 2024.05

- **CharacterMeet: Supporting Creative Writers' Entire Story Character Construction Processes Through Conversation with LLM-Powered Chatbot Avatars**
   *Hua Xuan Qin, Shan Jin, Ze Gao, Mingming Fan, Pan Hui.' [[abs](https://dl.acm.org/doi/abs/10.1145/3613904.3642105)], CHI 2024.

- **Stephanie: Step-by-Step Dialogues for Mimicking Human Interactions in Social Conversations**
   *Hao Yang, Hongyuan Lu, Xinhua Zeng, Yang Liu, Xiang Zhang, Haoran Yang, Yumeng Zhang, Yiran Wei, Wai Lam.* [[abs](https://arxiv.org/pdf/2407.04093)], 2024.07


---

## 💡  Contribution

### Contributing to this repo

🤲" **Join us in improving this repository!** Spotted any notable works we might have missed? We welcome your additions. Every contribution counts!   "

### Contributors

<a href="https://github.com/Neph0s/awesome-llm-role-playing-with-persona/graphs/contributors">
  <img src="https://contrib.rocks/image?repo=Neph0s/awesome-llm-role-playing-with-persona" />
</a>
