﻿; images
bitmaps["logo_mode0"] := Gdip_BitmapFromBase64("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")
bitmaps["logo_mode1"] := Gdip_BitmapFromBase64("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")
bitmaps["copy"] := Gdip_BitmapFromBase64("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")
bitmaps["paste"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAACgAAAAyCAYAAAAus5mQAAAACXBIWXMAAAsTAAALEwEAmpwYAAAFomlUWHRYTUw6Y29tLmFkb2JlLnhtcAAAAAAAPD94cGFja2V0IGJlZ2luPSLvu78iIGlkPSJXNU0wTXBDZWhpSHpyZVN6TlRjemtjOWQiPz4gPHg6eG1wbWV0YSB4bWxuczp4PSJhZG9iZTpuczptZXRhLyIgeDp4bXB0az0iQWRvYmUgWE1QIENvcmUgNy4xLWMwMDAgNzkuOWNjYzRkZSwgMjAyMi8wMy8xNC0xMToyNjoxOSAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvIiB4bWxuczpkYz0iaHR0cDovL3B1cmwub3JnL2RjL2VsZW1lbnRzLzEuMS8iIHhtbG5zOnBob3Rvc2hvcD0iaHR0cDovL25zLmFkb2JlLmNvbS9waG90b3Nob3AvMS4wLyIgeG1sbnM6eG1wTU09Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9tbS8iIHhtbG5zOnN0RXZ0PSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvc1R5cGUvUmVzb3VyY2VFdmVudCMiIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIDIzLjMgKFdpbmRvd3MpIiB4bXA6Q3JlYXRlRGF0ZT0iMjAyMy0wMi0wN1QyMToxODozN1oiIHhtcDpNb2RpZnlEYXRlPSIyMDIzLTAyLTA4VDAxOjA0OjI3WiIgeG1wOk1ldGFkYXRhRGF0ZT0iMjAyMy0wMi0wOFQwMTowNDoyN1oiIGRjOmZvcm1hdD0iaW1hZ2UvcG5nIiBwaG90b3Nob3A6Q29sb3JNb2RlPSIzIiB4bXBNTTpJbnN0YW5jZUlEPSJ4bXAuaWlkOmFhZWI1OTk0LWYzNmEtODM0OC04N2Y3LWVmNGY3MDAxM2E0NyIgeG1wTU06RG9jdW1lbnRJRD0ieG1wLmRpZDo4MjFjYzRkYS0wYWJmLWEwNDEtOGNlNC03MDQxM2ZkYzczMmYiIHhtcE1NOk9yaWdpbmFsRG9jdW1lbnRJRD0ieG1wLmRpZDo4MjFjYzRkYS0wYWJmLWEwNDEtOGNlNC03MDQxM2ZkYzczMmYiPiA8eG1wTU06SGlzdG9yeT4gPHJkZjpTZXE+IDxyZGY6bGkgc3RFdnQ6YWN0aW9uPSJjcmVhdGVkIiBzdEV2dDppbnN0YW5jZUlEPSJ4bXAuaWlkOjgyMWNjNGRhLTBhYmYtYTA0MS04Y2U0LTcwNDEzZmRjNzMyZiIgc3RFdnQ6d2hlbj0iMjAyMy0wMi0wN1QyMToxODozN1oiIHN0RXZ0OnNvZnR3YXJlQWdlbnQ9IkFkb2JlIFBob3Rvc2hvcCAyMy4zIChXaW5kb3dzKSIvPiA8cmRmOmxpIHN0RXZ0OmFjdGlvbj0ic2F2ZWQiIHN0RXZ0Omluc3RhbmNlSUQ9InhtcC5paWQ6YWFlYjU5OTQtZjM2YS04MzQ4LTg3ZjctZWY0ZjcwMDEzYTQ3IiBzdEV2dDp3aGVuPSIyMDIzLTAyLTA4VDAxOjA0OjI3WiIgc3RFdnQ6c29mdHdhcmVBZ2VudD0iQWRvYmUgUGhvdG9zaG9wIDIzLjMgKFdpbmRvd3MpIiBzdEV2dDpjaGFuZ2VkPSIvIi8+IDwvcmRmOlNlcT4gPC94bXBNTTpIaXN0b3J5PiA8L3JkZjpEZXNjcmlwdGlvbj4gPC9yZGY6UkRGPiA8L3g6eG1wbWV0YT4gPD94cGFja2V0IGVuZD0iciI/PjQH77oAAAGqSURBVFjD7dk7SMNAHMfxQAfBxcXJFwpKEYv4GNwUwcXBSRcnwdHBSXBVHNRqtSaLQjdRsCBFJ0GcOriIIC6Kj9VZBd8Yf4F/4QgUesn/0iD/wJcWj14/2jbpnZbrulacswQoQAGaATagRZRGK2VaRctoqBrAJfSMPtB7mbyxN3SMElECm1z9Y8IE0PutbXSLHtAd3X8KAPT+2jc0xz3dHqH6MMB51/yxEwa4HQGwEAa47pvsCp2iywCQa3SGiuhH+fkBJ7BHGTvRwBV9874oY3lO4LBvvAOlUGeZulDS95ga9KrMecgJHGG4MtT6gIW4AS065ZSOPZPAJF3OsmizgjaQgz6VOR/RlAlgHfpmPN3McgMHmM+HOW5gPzMwww3s841toRbUVkGtaDRq4JzmJ7kxauCCJrBbgAIUoAAFKEABagN7lbHmOAKnlRXbeByAGY0vnFUB5jSAMwGWn6GBYxrAc3qSbAV5q7tdDqDXIO2WrtFuapqWmvvMaxKbe4c1wQx0TGyie3t7X/QEvwEqPe4CtZsApuild2hVp5tN78lJ+T+JAAX4n4F/91iGBShXhUAAAAAASUVORK5CYII=")
bitmaps["close"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAABoAAAAaCAYAAACpSkzOAAAACXBIWXMAAAsTAAALEwEAmpwYAAAFsGlUWHRYTUw6Y29tLmFkb2JlLnhtcAAAAAAAPD94cGFja2V0IGJlZ2luPSLvu78iIGlkPSJXNU0wTXBDZWhpSHpyZVN6TlRjemtjOWQiPz4gPHg6eG1wbWV0YSB4bWxuczp4PSJhZG9iZTpuczptZXRhLyIgeDp4bXB0az0iQWRvYmUgWE1QIENvcmUgNy4xLWMwMDAgNzkuOWNjYzRkZSwgMjAyMi8wMy8xNC0xMToyNjoxOSAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvIiB4bWxuczpkYz0iaHR0cDovL3B1cmwub3JnL2RjL2VsZW1lbnRzLzEuMS8iIHhtbG5zOnBob3Rvc2hvcD0iaHR0cDovL25zLmFkb2JlLmNvbS9waG90b3Nob3AvMS4wLyIgeG1sbnM6eG1wTU09Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9tbS8iIHhtbG5zOnN0RXZ0PSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvc1R5cGUvUmVzb3VyY2VFdmVudCMiIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIDIzLjMgKFdpbmRvd3MpIiB4bXA6Q3JlYXRlRGF0ZT0iMjAyMy0wMi0wN1QxNzo1Mzo1NVoiIHhtcDpNb2RpZnlEYXRlPSIyMDIzLTAyLTA3VDE3OjU2OjIyWiIgeG1wOk1ldGFkYXRhRGF0ZT0iMjAyMy0wMi0wN1QxNzo1NjoyMloiIGRjOmZvcm1hdD0iaW1hZ2UvcG5nIiBwaG90b3Nob3A6Q29sb3JNb2RlPSIzIiB4bXBNTTpJbnN0YW5jZUlEPSJ4bXAuaWlkOjE4OTVjNTRhLWFmZGMtZDU0ZC1hOTUyLTdiNTQ4NDQxNWEwNiIgeG1wTU06RG9jdW1lbnRJRD0iYWRvYmU6ZG9jaWQ6cGhvdG9zaG9wOmI1ZGZiN2M1LTFkYWYtMGI0ZS05MjAzLTNiNDIwZDc0Y2MxOSIgeG1wTU06T3JpZ2luYWxEb2N1bWVudElEPSJ4bXAuZGlkOjBhMThjNWRmLTlhZDQtZjU0ZC05OTM2LTk2MmUxNGE0MTRhNyI+IDx4bXBNTTpIaXN0b3J5PiA8cmRmOlNlcT4gPHJkZjpsaSBzdEV2dDphY3Rpb249ImNyZWF0ZWQiIHN0RXZ0Omluc3RhbmNlSUQ9InhtcC5paWQ6MGExOGM1ZGYtOWFkNC1mNTRkLTk5MzYtOTYyZTE0YTQxNGE3IiBzdEV2dDp3aGVuPSIyMDIzLTAyLTA3VDE3OjUzOjU1WiIgc3RFdnQ6c29mdHdhcmVBZ2VudD0iQWRvYmUgUGhvdG9zaG9wIDIzLjMgKFdpbmRvd3MpIi8+IDxyZGY6bGkgc3RFdnQ6YWN0aW9uPSJzYXZlZCIgc3RFdnQ6aW5zdGFuY2VJRD0ieG1wLmlpZDoxODk1YzU0YS1hZmRjLWQ1NGQtYTk1Mi03YjU0ODQ0MTVhMDYiIHN0RXZ0OndoZW49IjIwMjMtMDItMDdUMTc6NTY6MjJaIiBzdEV2dDpzb2Z0d2FyZUFnZW50PSJBZG9iZSBQaG90b3Nob3AgMjMuMyAoV2luZG93cykiIHN0RXZ0OmNoYW5nZWQ9Ii8iLz4gPC9yZGY6U2VxPiA8L3htcE1NOkhpc3Rvcnk+IDwvcmRmOkRlc2NyaXB0aW9uPiA8L3JkZjpSREY+IDwveDp4bXBtZXRhPiA8P3hwYWNrZXQgZW5kPSJyIj8+dPVL6AAAAoNJREFUSImVls1LVFEYxp+ZWogbESKp0Ejp28nChJiiqFUJ/QERQbTURUVtooUtUlq0yChcRLmRaFEThZCGVlSGERE2ORFEJVT0RUGLIDJ+LeZce+fMPXf0hcPMeb7ee++593BSgCrUckk7JWUlrZZUJykl6Yukl5LGJQ1LKiSmAKHRBuSYfQ0CW0J5qcAd9Ug65mFTkiYlfXTzOklrJTV6ul5Jh2ZzR4PelV4CtiXceRbo8zz3gLTV+aYhI84DGxMa+KMZeGz8Y6FGPUZ0B0jNoYkdN0xOn99olSFfe8YFQFWF8GXe/JnJa7ONbhtihTHUAt+ByYQm3cA0sNtgi0zek6hRvQEvG3Ej8MtwwzFNDlNa+wx33uBrBBw0QKv3OL55QTnDd1BeewzfZPATAq66yfuYK64GJrywXmB/TJPtMf6C40bs5HqMUMB8YDwmOKq/wOaAt99p3qbdFy5JnwK71LSkTZKuxHAFSRlJYwHvZ/dbk7abREAc1WgM9k7Jm+lMZlrSV/d/YYKhQ9KFGLxdUi7BF2X+lFsbgKnAc/Zf4Q8UtxdbtwLe546/K+CoMWSMqAroiln4Bsf7L8gosMT4GwzXHX2YUV00wnWUV9bwaYobr63jhj9t8PUReN+A9Q6bB3QaPO47qQZeOf4aUMP/reuPw/OYva7FBOa9sCPA3pgm0VgMnPQwu4ZbbSMBZw15MyG40hgwOQMR7oseGtEjYOUcGiwFRox/wvK+OE3pegGcATYkNGgGTgG/jecpxfWb0YUOJ+ckdXrYC0l5lR5OMpJaPF2/pANliQlXusN7FJXqAdAeygvdka1WSbtUPEA2SapV8QD5Q9IbFQ+QQ+43WP8ANwq8BrGnZFkAAAAASUVORK5CYII=")
bitmaps["check"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAACXBIWXMAAAsTAAALEwEAmpwYAAAE2mlUWHRYTUw6Y29tLmFkb2JlLnhtcAAAAAAAPD94cGFja2V0IGJlZ2luPSLvu78iIGlkPSJXNU0wTXBDZWhpSHpyZVN6TlRjemtjOWQiPz4gPHg6eG1wbWV0YSB4bWxuczp4PSJhZG9iZTpuczptZXRhLyIgeDp4bXB0az0iQWRvYmUgWE1QIENvcmUgNy4xLWMwMDAgNzkuOWNjYzRkZSwgMjAyMi8wMy8xNC0xMToyNjoxOSAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvIiB4bWxuczpkYz0iaHR0cDovL3B1cmwub3JnL2RjL2VsZW1lbnRzLzEuMS8iIHhtbG5zOnBob3Rvc2hvcD0iaHR0cDovL25zLmFkb2JlLmNvbS9waG90b3Nob3AvMS4wLyIgeG1sbnM6eG1wTU09Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9tbS8iIHhtbG5zOnN0RXZ0PSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvc1R5cGUvUmVzb3VyY2VFdmVudCMiIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIDIzLjMgKFdpbmRvd3MpIiB4bXA6Q3JlYXRlRGF0ZT0iMjAyMy0wMi0wOVQwMjoxNTo0N1oiIHhtcDpNb2RpZnlEYXRlPSIyMDIzLTAyLTA5VDAyOjE2OjQ1WiIgeG1wOk1ldGFkYXRhRGF0ZT0iMjAyMy0wMi0wOVQwMjoxNjo0NVoiIGRjOmZvcm1hdD0iaW1hZ2UvcG5nIiBwaG90b3Nob3A6Q29sb3JNb2RlPSIzIiB4bXBNTTpJbnN0YW5jZUlEPSJ4bXAuaWlkOjhjNzE5NjRkLWNlOWEtYjM0Mi05NmIzLWYyZjE0NWI1MWVjMiIgeG1wTU06RG9jdW1lbnRJRD0ieG1wLmRpZDo4YzcxOTY0ZC1jZTlhLWIzNDItOTZiMy1mMmYxNDViNTFlYzIiIHhtcE1NOk9yaWdpbmFsRG9jdW1lbnRJRD0ieG1wLmRpZDo4YzcxOTY0ZC1jZTlhLWIzNDItOTZiMy1mMmYxNDViNTFlYzIiPiA8eG1wTU06SGlzdG9yeT4gPHJkZjpTZXE+IDxyZGY6bGkgc3RFdnQ6YWN0aW9uPSJjcmVhdGVkIiBzdEV2dDppbnN0YW5jZUlEPSJ4bXAuaWlkOjhjNzE5NjRkLWNlOWEtYjM0Mi05NmIzLWYyZjE0NWI1MWVjMiIgc3RFdnQ6d2hlbj0iMjAyMy0wMi0wOVQwMjoxNTo0N1oiIHN0RXZ0OnNvZnR3YXJlQWdlbnQ9IkFkb2JlIFBob3Rvc2hvcCAyMy4zIChXaW5kb3dzKSIvPiA8L3JkZjpTZXE+IDwveG1wTU06SGlzdG9yeT4gPC9yZGY6RGVzY3JpcHRpb24+IDwvcmRmOlJERj4gPC94OnhtcG1ldGE+IDw/eHBhY2tldCBlbmQ9InIiPz5+hZIuAAAAjklEQVQ4EWP4//8/AzUxw6iBpGBWIG4DYjFqGTjvPwQcBmINSg2c+x8V1FFi4Dw0w3zweVkNiHcCsTA5hqEbmIek8CoWw+ajGeZLKJbDgPgrkoYLSHILiDEMm5f5gPg1ksZNQDyNWMNwRQooXX3+jx34kZuw5YD4JykuIybZKJHiMmLTYSgQl4yWNvQ1EADFfeAu6V6LpgAAAABJRU5ErkJggg==")

; text
bitmaps["text_mode0"] := Gdip_BitmapFromBase64("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")
bitmaps["text_mode1"] := Gdip_BitmapFromBase64("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")
bitmaps["text_webhookurl"] := Gdip_BitmapFromBase64("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")
bitmaps["text_bottoken"] := Gdip_BitmapFromBase64("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")
bitmaps["text_mainchannelid"] := Gdip_BitmapFromBase64("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")
bitmaps["text_reportchannelid"] := Gdip_BitmapFromBase64("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")
bitmaps["text_screenshots"] := Gdip_BitmapFromBase64("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")
bitmaps["text_userid"] := Gdip_BitmapFromBase64("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")
bitmaps["text_critical"] := Gdip_BitmapFromBase64("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")
bitmaps["text_amulet"] := Gdip_BitmapFromBase64("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")
bitmaps["text_machine"] := Gdip_BitmapFromBase64("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")
bitmaps["text_balloon"] := Gdip_BitmapFromBase64("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")
bitmaps["text_vicious"] := Gdip_BitmapFromBase64("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")
bitmaps["text_death"] := Gdip_BitmapFromBase64("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")
bitmaps["text_planter"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAAIYAAAAQCAYAAADTRgfPAAAACXBIWXMAADXUAAA11AFeZeUIAAANVmlUWHRYTUw6Y29tLmFkb2JlLnhtcAAAAAAAPD94cGFja2V0IGJlZ2luPSLvu78iIGlkPSJXNU0wTXBDZWhpSHpyZVN6TlRjemtjOWQiPz4gPHg6eG1wbWV0YSB4bWxuczp4PSJhZG9iZTpuczptZXRhLyIgeDp4bXB0az0iQWRvYmUgWE1QIENvcmUgNy4xLWMwMDAgNzkuOWNjYzRkZSwgMjAyMi8wMy8xNC0xMToyNjoxOSAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvIiB4bWxuczpkYz0iaHR0cDovL3B1cmwub3JnL2RjL2VsZW1lbnRzLzEuMS8iIHhtbG5zOnBob3Rvc2hvcD0iaHR0cDovL25zLmFkb2JlLmNvbS9waG90b3Nob3AvMS4wLyIgeG1sbnM6eG1wTU09Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9tbS8iIHhtbG5zOnN0RXZ0PSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvc1R5cGUvUmVzb3VyY2VFdmVudCMiIHhtbG5zOnN0UmVmPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvc1R5cGUvUmVzb3VyY2VSZWYjIiB4bWxuczp0aWZmPSJodHRwOi8vbnMuYWRvYmUuY29tL3RpZmYvMS4wLyIgeG1sbnM6ZXhpZj0iaHR0cDovL25zLmFkb2JlLmNvbS9leGlmLzEuMC8iIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIDIzLjMgKFdpbmRvd3MpIiB4bXA6Q3JlYXRlRGF0ZT0iMjAyMy0wMS0xOFQyMDoyMTozNVoiIHhtcDpNb2RpZnlEYXRlPSIyMDIzLTAyLTA4VDE0OjMxOjU3WiIgeG1wOk1ldGFkYXRhRGF0ZT0iMjAyMy0wMi0wOFQxNDozMTo1N1oiIGRjOmZvcm1hdD0iaW1hZ2UvcG5nIiBwaG90b3Nob3A6Q29sb3JNb2RlPSIzIiB4bXBNTTpJbnN0YW5jZUlEPSJ4bXAuaWlkOmFlYTZhZTU0LTdiZmItOWY0Ni1iOWI1LTY4NTc3NGU5OTA2YSIgeG1wTU06RG9jdW1lbnRJRD0iYWRvYmU6ZG9jaWQ6cGhvdG9zaG9wOmViYzEzMWI5LTA0MDgtNGQ0NS05MjJhLTA1NWJhZGFkYTBmNyIgeG1wTU06T3JpZ2luYWxEb2N1bWVudElEPSJ4bXAuZGlkOjY1ZDVjOThlLWYyZmQtNWQ0OS04OTBlLTc3MGJhNmYxYWYwOCIgdGlmZjpPcmllbnRhdGlvbj0iMSIgdGlmZjpYUmVzb2x1dGlvbj0iMzUwMDAwMC8xMDAwMCIgdGlmZjpZUmVzb2x1dGlvbj0iMzUwMDAwMC8xMDAwMCIgdGlmZjpSZXNvbHV0aW9uVW5pdD0iMiIgZXhpZjpDb2xvclNwYWNlPSI2NTUzNSIgZXhpZjpQaXhlbFhEaW1lbnNpb249IjUwMCIgZXhpZjpQaXhlbFlEaW1lbnNpb249IjMyIj4gPHBob3Rvc2hvcDpUZXh0TGF5ZXJzPiA8cmRmOkJhZz4gPHJkZjpsaSBwaG90b3Nob3A6TGF5ZXJOYW1lPSJQbGFudGVyIFByb2dyZXNzIiBwaG90b3Nob3A6TGF5ZXJUZXh0PSJQbGFudGVyIFByb2dyZXNzIi8+IDwvcmRmOkJhZz4gPC9waG90b3Nob3A6VGV4dExheWVycz4gPHhtcE1NOkhpc3Rvcnk+IDxyZGY6U2VxPiA8cmRmOmxpIHN0RXZ0OmFjdGlvbj0iY3JlYXRlZCIgc3RFdnQ6aW5zdGFuY2VJRD0ieG1wLmlpZDo2NWQ1Yzk4ZS1mMmZkLTVkNDktODkwZS03NzBiYTZmMWFmMDgiIHN0RXZ0OndoZW49IjIwMjMtMDEtMThUMjA6MjE6MzVaIiBzdEV2dDpzb2Z0d2FyZUFnZW50PSJBZG9iZSBQaG90b3Nob3AgMjMuMyAoV2luZG93cykiLz4gPHJkZjpsaSBzdEV2dDphY3Rpb249InNhdmVkIiBzdEV2dDppbnN0YW5jZUlEPSJ4bXAuaWlkOjAyMjNkNDYwLWM0YTAtMTE0ZS05NTMxLWE5ZWY3ZmM3OTkzNiIgc3RFdnQ6d2hlbj0iMjAyMy0wMS0xOFQyMDo1MjoyMFoiIHN0RXZ0OnNvZnR3YXJlQWdlbnQ9IkFkb2JlIFBob3Rvc2hvcCAyMy4zIChXaW5kb3dzKSIgc3RFdnQ6Y2hhbmdlZD0iLyIvPiA8cmRmOmxpIHN0RXZ0OmFjdGlvbj0ic2F2ZWQiIHN0RXZ0Omluc3RhbmNlSUQ9InhtcC5paWQ6NGFiZDc2MDYtNjAzNS1lYjQwLTg1NmItNmE4ZjIzODdmNTc5IiBzdEV2dDp3aGVuPSIyMDIzLTAyLTA4VDA0OjA2OjU2WiIgc3RFdnQ6c29mdHdhcmVBZ2VudD0iQWRvYmUgUGhvdG9zaG9wIDIzLjMgKFdpbmRvd3MpIiBzdEV2dDpjaGFuZ2VkPSIvIi8+IDxyZGY6bGkgc3RFdnQ6YWN0aW9uPSJjb252ZXJ0ZWQiIHN0RXZ0OnBhcmFtZXRlcnM9ImZyb20gaW1hZ2UvcG5nIHRvIGFwcGxpY2F0aW9uL3ZuZC5hZG9iZS5waG90b3Nob3AiLz4gPHJkZjpsaSBzdEV2dDphY3Rpb249ImRlcml2ZWQiIHN0RXZ0OnBhcmFtZXRlcnM9ImNvbnZlcnRlZCBmcm9tIGltYWdlL3BuZyB0byBhcHBsaWNhdGlvbi92bmQuYWRvYmUucGhvdG9zaG9wIi8+IDxyZGY6bGkgc3RFdnQ6YWN0aW9uPSJzYXZlZCIgc3RFdnQ6aW5zdGFuY2VJRD0ieG1wLmlpZDo3ZDliNzRhNi1jNDE1LWRkNGUtOTljNC03MjA2Mjg2ZDlkNTEiIHN0RXZ0OndoZW49IjIwMjMtMDItMDhUMDQ6MDY6NTZaIiBzdEV2dDpzb2Z0d2FyZUFnZW50PSJBZG9iZSBQaG90b3Nob3AgMjMuMyAoV2luZG93cykiIHN0RXZ0OmNoYW5nZWQ9Ii8iLz4gPHJkZjpsaSBzdEV2dDphY3Rpb249InNhdmVkIiBzdEV2dDppbnN0YW5jZUlEPSJ4bXAuaWlkOjNkOGFhNWU5LTBhYzctY2Q0ZS1iNmFiLWVhNWM5ZTc3OWVmMyIgc3RFdnQ6d2hlbj0iMjAyMy0wMi0wOFQxNDozMTo1N1oiIHN0RXZ0OnNvZnR3YXJlQWdlbnQ9IkFkb2JlIFBob3Rvc2hvcCAyMy4zIChXaW5kb3dzKSIgc3RFdnQ6Y2hhbmdlZD0iLyIvPiA8cmRmOmxpIHN0RXZ0OmFjdGlvbj0iY29udmVydGVkIiBzdEV2dDpwYXJhbWV0ZXJzPSJmcm9tIGFwcGxpY2F0aW9uL3ZuZC5hZG9iZS5waG90b3Nob3AgdG8gaW1hZ2UvcG5nIi8+IDxyZGY6bGkgc3RFdnQ6YWN0aW9uPSJkZXJpdmVkIiBzdEV2dDpwYXJhbWV0ZXJzPSJjb252ZXJ0ZWQgZnJvbSBhcHBsaWNhdGlvbi92bmQuYWRvYmUucGhvdG9zaG9wIHRvIGltYWdlL3BuZyIvPiA8cmRmOmxpIHN0RXZ0OmFjdGlvbj0ic2F2ZWQiIHN0RXZ0Omluc3RhbmNlSUQ9InhtcC5paWQ6YWVhNmFlNTQtN2JmYi05ZjQ2LWI5YjUtNjg1Nzc0ZTk5MDZhIiBzdEV2dDp3aGVuPSIyMDIzLTAyLTA4VDE0OjMxOjU3WiIgc3RFdnQ6c29mdHdhcmVBZ2VudD0iQWRvYmUgUGhvdG9zaG9wIDIzLjMgKFdpbmRvd3MpIiBzdEV2dDpjaGFuZ2VkPSIvIi8+IDwvcmRmOlNlcT4gPC94bXBNTTpIaXN0b3J5PiA8eG1wTU06RGVyaXZlZEZyb20gc3RSZWY6aW5zdGFuY2VJRD0ieG1wLmlpZDozZDhhYTVlOS0wYWM3LWNkNGUtYjZhYi1lYTVjOWU3NzllZjMiIHN0UmVmOmRvY3VtZW50SUQ9ImFkb2JlOmRvY2lkOnBob3Rvc2hvcDpmY2JhMzAzZi0yOGFhLTM2NGUtYjNjOC1jODJkMzkxN2NhZTIiIHN0UmVmOm9yaWdpbmFsRG9jdW1lbnRJRD0ieG1wLmRpZDo2NWQ1Yzk4ZS1mMmZkLTVkNDktODkwZS03NzBiYTZmMWFmMDgiLz4gPC9yZGY6RGVzY3JpcHRpb24+IDwvcmRmOlJERj4gPC94OnhtcG1ldGE+IDw/eHBhY2tldCBlbmQ9InIiPz5PnLxqAAACf0lEQVRo3u1ZC42EMBDFQi1goRawUAtYqIVawEIt1AIWsIAFbi9pL5O5N/0Au1wOmkx2swyd3+t8ut22beuG1/fv9kUdoTk+0+z3s2l8kXtR/2Y5XaP9t6GcY9KaLgCGj3LMhcBA9t8SGDzYA3GOvgEwaux/gBEpxGc2Awwd0z5dS6EMBcIbSMkwwqn1bC9XONVJ1hB1yZ38WvtV/D7HUpfWmNHLg3KoCPDTfoborJgvXNQ9LeqrAPahsizLiIHFhcqlcVNnAKPPpGELgrUAvqUBGLPAEwDPKgTwCDB46ekLeq2ERwn20305MFbgpzHj84GAIudLLTxfShlDg2dSKelB80gNoe/OxHjqqLGilDgAOMRPZe0tJdx+lclQDthG9fKMLwj6I2Bw36io18JkJX1ntid/t2fAmUAJPa35TFPEGj8tQTt/l5/cCQRbAsZS0NUWZB1pPhXIElyvAZSNlfhB4uszwFiEQ7dlMg8NfBCmK032dwxkXeu4hoBhK5TMgcqRWloCRimIbkeTXGu/AjbxPVThWS0fBYYHfUNpKaHHWNlhMaAEuprms6sAxgqCaN8EDOnE1ejZ7egxukpgHM0YqgEYo1COSqSJ/F6wL/VU415gDAXHngUMK/Bypxh2Ej4NjFLvcKTH8BkQGVCWKRCMED8T95H861qBMYEx02dS8V5gWGHiKHX16iJgqMxUshycSjyQZxvKKdJHsVj+mmxagaHY7DwCwNC5fC8w+J3AzHSYwAimL8wYkl4T6Ceke4wWYKSSMmfujjTQJzCQOtaD/NyF3PJ/gD9Kucb0kpvPhz5LFjR/tuHe5QHGP6ShMGYODzDunTECqP1/6o+6L0+ZdW2OO0mlAAAAAElFTkSuQmCC")
bitmaps["text_honey"] := Gdip_BitmapFromBase64("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")
bitmaps["text_criticalerror"] := Gdip_BitmapFromBase64("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")
bitmaps["text_disconnect"] := Gdip_BitmapFromBase64("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")
bitmaps["text_gamefrozen"] := Gdip_BitmapFromBase64("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")
bitmaps["text_phantom"] := Gdip_BitmapFromBase64("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")
bitmaps["text_unexpecteddeath"] := Gdip_BitmapFromBase64("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")
bitmaps["text_emergencyballoon"] := Gdip_BitmapFromBase64("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")