﻿hBitmapsSBT["Sunflower"] := Gdip_BitmapFromBase64("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")
hBitmapsSBT["StrawBerry"] := Gdip_BitmapFromBase64("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")
hBitmapsSBT["Pineapple"] := Gdip_BitmapFromBase64("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")
hBitmapsSBT["BlueBerry"] := Gdip_BitmapFromBase64("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")
hBitmapsSBT["BlueExtract"] := Gdip_BitmapFromBase64("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")
hBitmapsSBT["CausticWax"] := Gdip_BitmapFromBase64("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")
hBitmapsSBT["Enzymes"] := Gdip_BitmapFromBase64("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")
hBitmapsSBT["FieldDice"] := Gdip_BitmapFromBase64("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")
hBitmapsSBT["Glitter"] := Gdip_BitmapFromBase64("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")
hBitmapsSBT["Glue"] := Gdip_BitmapFromBase64("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")
hBitmapsSBT["Gumdrops"] := Gdip_BitmapFromBase64("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")
hBitmapsSBT["HardWax"] := Gdip_BitmapFromBase64("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")
hBitmapsSBT["LoadedDice"] := Gdip_BitmapFromBase64("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")
hBitmapsSBT["MoonCharms"] := Gdip_BitmapFromBase64("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")
hBitmapsSBT["Oil"] := Gdip_BitmapFromBase64("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")
hBitmapsSBT["PurplePotion"] := Gdip_BitmapFromBase64("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")
hBitmapsSBT["RedExtract"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAACgAAAAoCAYAAACM/rhtAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAA4OSURBVFhHnVhZc1vJdT59d2wEARAAwU0bNVpGVqU0SzlWUnFVHE+mEr/Hechj/lL+QJ7yD/yQcrlsazIjzSQRZ7RRFPcNIJZ7cfet/Z1LkWOWLFmeVrUauOjb/fU53/nOaQr6ge2TTz5RpJQlIUQH4108+gjjVYwK2g56H58X0XvoU/RnOcm1XFG2RZpNBAk3S9PosH8sTwYDSuJYYs4b7QcBrFQq4vr16yVN064DyGcYf2EYRhu9rOu6hmdRkiQhAJuYbqZZKtM0m6ZZNkjS9DhLkmdA838k5QspxJFQFEdIir9++NUbIH8QwKWlJaXdbjdgvb8zTfPfO53O31y+fFmfnZ0V5XKZ15TT6VRmWSZIkoiTmPwwyF3PS8ejUehO3aMojrfSNH2Oqd8IoXwjc7n5cv1FOB6PL4BUX4/v3WAh5cqVKzqsxq77CQB+du3atfa9e/fUlZUVpdvtKs1mU6nX6yqAKwsLC0Xv9RZU/KbPzMyYlmXVsc487LOU5/m8lLkBVAPTNCa8h+/75yD/IoCqqopLly5ptVqtBTf+CBb8W1js3gcffGDduHFDYGM8gj0URQCAwDwBsKKBzuNca47m2nOi2WppOICJ9epRFPXCMOyAj0cquItnEUBLPDvds/j/PRpvBt6Z1Wr1NjB8Bn79HFb8CM/nYTm11WpxdIBWkrDB67eKQxVjhmd4LjRdAw0qYmamJsBlBTQwHMdpAqhHQmyqmjoKwyh1Xbew4nsBvHr1KrsO3jRvAMS/AdgvAfTHANVD0zCec5lBMijuOAhhYwqDkILAL7rn++xCQhAVc2FvAkDNmTrM2R2880pRVX94clIA/LNBAvcpsJKFDVkyfgnX/Mv8/Pwy+FVqNBpKqVQSbDVuOADB5QRXF5/h5gIgAwrgsiiO8D0uwHEDEwiulOvrL+XW9tY6fvsPBM1/YbXj/334qHDDn7UgwKjYqImPPwbIf71169aNTz/9tHTz5k0mP/OMNyk6opLiOD7/zp+DIKDRaETHgz71j/s0HA1pMh4TLPbasgGNJ+Pcdaa7OOgDGP2ZN3XPLajwf29rsBCTXcPHJvjzESxz7cMPP7Tu3r2rXF+9LhDNBP4R5KVwF3PvDCBkhiAZNJlMyLFtmozGBImhqeOQ57oU+gHFhfsDioKQ3XsCd57ILE8CWPysvRPg7du32U0GNm4CwFVwrcp8hFQIq2QVwBYXFwuQcP05SLYkj+xKdjE0r/jMz6F3BTfBYzJAA244lEQUZ/iY4zdWgeI5t3e6GGLMereAj38NoD+D5Xqrq6t4hMUNo+AbgoUtTeBiwbmzKGYwsErhQs/zCh7yMw4enjs3N1ccDgcTCBIFlp7BuwPstYl1bHgg50O9EyACoYzhLgj/Obj4V+Ae8FQVDgAGxsHA1mCwbEGWGhyq2Jw7f4f+8Tq0vLxMTAl4gAOv6JCtwvp84KOjIwUH2cd+32LNAQAmTJW3Arx//74CS7Rx4o8B5qfIFlfu3LljcNQyGHYvW4LdwZZioAyYgZ/9zuAYMKSI0yMhqM47g+Y5PJ95++rVq6Tf7z/DOt9gzSMGyJZ/GweFbdsaJrdwuksQ1DlYUOM8C/5dAHfGNXYfN7Ym5hed5zAN+DOPbHm21pkU8aH4XazBUsWBkmBIeA5TgdvbAEpsxAA74MMlnHKG8+osLMMWYQuBnIXl+PQ5xjRJT4MAHFQgviB9Eck4aNE5mofDIYtyAYrfZV7yb6+fcYpz8L6PPdPDw8O3y8zHH38sVKGWsNGiZVors7ON+ny3q/bm56kNbpVMq+CGkmSkomtZjjFB2RKT4JGBQ+NsyMwYusc6yJLDgNjifIgU8ziAkNJYdjiKIyw5ZpDg3qk70P4kQJGSLjJxSRP6nVplZqHX7ZmdubZoztTJhEyAzVjKJtlH0B0ckNzZoRxd7uwSHfVJdT0y4oQs2KCsG1SDi9nqzDvulmFSBosnYUQ5j8guGdwAyU1VVcmEgurwdXsjSJaWFkS9CqGT4n6lVP7HlYXFKzdXV0vLKKNKUFIfAOz1DRo+fUr9tcd09PgxjZ4/o9GLF2RvblJ6MibpBSSxuaGrBbA6Dlat1qhcqeIZtA9JLPB8CtFjpLq9/T25/urlwPGm/wMIa1BC72D/oAB5AaCuq2Ku3VJA4GUQ9edzjcZPVpeX5lZas7ruOsLb2KTh2rfUB6jhk6c0efmSvO1tSvvHADZEP6F8OKZ4cELO0THlUUg68q1paFhbIwW8hUwXXOVsEYexRP6Vu3t7+fbO7pbvB7/LcvncdT1/NBy+CbDZrCnNVh0lu3anZJn/tNTr3rze65TqSaiMvl0Tk8drJLd3SD0+Jg28stwplaFVFfCphG5FCek+6jjbIffwmJzhCYVTUCHFc00lDVHMIJMsJZ+tB6Ah3Lu1swuG7G0A7APQcwPpMHIc+2KQVGtl0e62hAmCgAKLlqVfbdUrpRkcPOsfCnf9OWU721Syx9RA+urInLqwTkdVqIGlZrHyLAKght8sFAIGgiPb2qbJ2hodPXpIJxiTwwPSQp90vEsyoxw9QUAFYQw1SCEHSgRqocDGYq/bOUCkXGGYZRQGagt7flAvm8utsmVAEMUUVhNwnY7NVZxax3wTUgJ7EGposqCH3E04UMtR58UBGWlAldgjC9KSvFinwYMvaPe/f03Od08QRE4xj/JURFEofPAwzvJRJsQ4R4jicnUKCu0cYK1SJlUqZZGL1ZKuX2/XquVZkkrSH4gM4ErgDrCQ7XvkglshXBoBbAKZKQoAnBmHR7bPKJOQGwm3w1INmVIDhaq+f0CTR1/Ty1/9iva/+pLEeEhVEEzl+XmcS5EPhaqOpVD+NMCZWoXNbkDOL5cMY6VhWqoBfqQQWAWFJirWosAM4pCGsMDQn9KUyyUsVpTz8AoSHiWcHXAQiX8qwlXJWScT3D0j0qcTsp8+oc3f/Ibs589J9VxSs5hkEktF5gkurJGmFkd9jeqPAHL6gQIqucxnIcRzNdNScFekdOpSDo5kIDZnCya4FwaFJW3wyYM4B0x2FmcIdgygMUDCXZTCgjECJE4iyqKAROiRHJ2Qt7FB9ssNik5wYUegpZEPA6axBrMDIBP0FBTaOUCDc6OmKrhIo0zDzRCcTIJYxGFSpKYIwotLN14QSGUAADAR7rtT8M1Gd2BZ7i6szYADjlS8wwfwcEDci1Gk4l6EUYXEJFCBaGQjyl0JoY7zNHVknvkI0Lzb6b4ZJGASviH54zPyjJCqTjk6Q0LyooR5pqhkaii1DIvK6LgmUojgGwcu9T2HjuHCASJ4jExjQ6jHkKAJpzx0N4Cl4xQrEQIKfIY3UFVL34vyLM0CUOvEg7Yoqki/+27tTYBTpCfoElN+NHRs59Cx87xWlQaKAwn3pwDDAHVNLwpTiDrhCkkaRFiquL2BZx4sygHkg5s+59rC9XAzDhcLMBIHzhQNfMVa4DQiVgZRhGyXxqqmJDJP8y8efPG9f9HOAR7sHUpFUV1N1R/Znv/bp3u7493YT7SlTl69tIQwrxLOCjejtGINA5ehNARWFJWNoimE0xdrcUFQdPCRCwPeERjhBXgCW2Yq5lslyiHeQRanfhza0MMpMswFcNzOM0ngB/x3lKxcKU9RZuFUSQfcq+jgY6vZUOvVihDglApLMQ5c0Yt6TsAyfHvNsHRaADtdjzXpFC43gIf1cQocTKUUxYI616a0MZvvudNo9/joFbLbr8MgejWavONvMwkAmJaZlkqWi68BajYzzeWsValW5nsLSp3/tIEggMAWLyrYDGmRoRYZgfWLLVaAQz9tHFRsXeQABS4WGsUo16jVpLhSlnuOHe/3B7sQ69/6gb89sYsUdw7yAsCiAAV/qrWqrxvGMJMyjZK0AT7NWeWKubK8rFQtU6RcHmEuti4sw67EPABEwfp6LW5ccRc3NHRZWE+nGOVXCrpYiz1KqgBoT6LD4XAvTpLfI5i3J+PJ2wFyS7DRaDSR7W7XQ9njAkgWhOHM1PebsKQ1v7AoNMOEISE76MicRUUdISgY9B83BfzEHRLg1IJ3Ma4D2WydSpeXqPejW1I0ZvLd4TA+7Pf3kYsfwIPbKG7fDZCbBJGODg7zdrvlQvOOkSn2p36QHkwm85FQK+V6U1i1OjIICVy6wb30NO1BmFO4M0GEJgCUoXphBVBwhzG7Xapdu0qV1ctSdlrStwyC9fLdw6PgZDR+haD6XRhGu+8F8KzhvpDj8uJapfJ+rij9ydSbGU3sTiqEaVRw/azWRAICBpCXANGdwGIpBJ9QoGrtDplLy2StXJbKfI9wWg4KMdFUuWWP4yfb2+H69s746ORkC8C+AF9+7wfBaDy6GCTfB9rbm8AFG3v0GiiF7lmC/rlRKd9fbrWvXG21a13dUMgeiRid5UavVkgHwMy0ZIJgCGCNCaqVieumU9+Lp6E/nXjeoRsG+3GW7aR5tplm+UPs8/9ffvnIOd3y+/Y+AIu/SS+vXFJr5WpVE3QTkvd5xTD/oVuv37rS7lTapZJqCanMzKCkL5cl3376jpsf2HYy8oPE8X3Pcd1hGIV7WZ7uQZg3MplvILi20Acw2RhQpo8efn2RxGjvBfCs9eYXlMXegqVp4rYqxOempv5stlS+Mteot1qN2VKz2UBgq3IwHGYHh313NHW2/SQdQKr6sNQ6wDzGhpt5no5wMcLNizxUp/FwNMlHKOlwNb3gXm5/EUBullVS7ty5ZeJesIJo+gQe/HsI3U8RrYtIfZxPUOGjtsrlE6z+nygqvkozOUA4O9BY6LEfHuzvnd2Nc8eZvgHq+0b0B/x1epomNCEgAAAAAElFTkSuQmCC")
hBitmapsSBT["SmoothDice"] := Gdip_BitmapFromBase64("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")
hBitmapsSBT["SoftWax"] := Gdip_BitmapFromBase64("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")
hBitmapsSBT["StarJelly"] := Gdip_BitmapFromBase64("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")
hBitmapsSBT["SuperSmoothie"] := Gdip_BitmapFromBase64("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")
hBitmapsSBT["SwirledWax"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAACgAAAAoCAYAAACM/rhtAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAA8WSURBVFhHlVhZcxzXdT739jr7jpnBDoIgARKAiqSkKopiLIuyKSWyJUtx7JTst6RSXvKYl+QH+C1VeU4lL3mIn1KVSkpOypWyKFkbTZkSTZsLQGIfDDAYzN57983XA0ACFzDMqbqYwXTP7e+e5TvfGUb/t4X3iPn5+Vgspv+jZRuvSoz5nPG/DxzxT9du3Kjt3xMu/6WXxnXmjzwrSapmO86ttcra1vLycnCwz/56apP2X4+ycFOOJcaGJ/5CVugHuXw2KYIgJoSQFUVZSqTS97LZLD9xYlAfGytfare9f+i0Gn/luL3vMvK/mYxHB4ZKpdr6ZrUe7rO/51Pb0wDsn3ygNPBWKhW78Orlb0RM0+TtVifuecFmlMevR2L+JIngp4bR+mlEZ/Pnzp7KjI0PxHvGbtGxzdOMpAvD5dHBkeHp5fXKUmt/z6eyJwKcnp5muVyO1+v1YHi4dNl17GdfeOEFjXPGtqpV3TCsrBbRCyKwxjmzf1QeTIy+887r6quvXeDnX5hjkQhJltWJG71u2fe9CYQ9WiyXrlYqFRfbPxXIJwJMpVJc13W+vb0djI+Pz5mmczGby2qzc9Pc9Sxe297JOo4zzsiciEbdye9//xvslW/OsVxBYoVCjBWLCcpkFeb5LdbutFKmRRlNjS2urK4uYPt+6vQf9AQ7CmA/tEEQsGIpr42NDz/je94brudOdrqNaCYfZaNjJcYkIe3u1tKcdcszp3L05pvneSxpsE63Qr5vUTYTZYUBlcWTxHZ362xjox0hriWGhsqL6+ubW3uPerIdCbBYLEqjoyM5SWanhPB/4gfW9waHM/F0RmOCGWx0vEiTU8NkWjsUiXbolZenebFMFIKz7R4FHpGuK/BTD7uZzLJ9Wlys67bNJxjjJMv6fzWbzf6z+k88wh4HkJ2dP6tnM+mSJNElVOJfer7xp2PjWfmNN19ir71+gU2dGCRF9QEsYBPH0lgam51LAViVGru7pCpRiqgp0tUIuW6HekabDNNnzVZAO/W2TAE/FolEf66qensf5JH2MEA2PDzMsun0MUbBDxSV/i4Zl87GY5744Q+/xf7ktYtMUWyRSUdpqJRlqZRK0YigTFqmTmuDdne2qdl0KJko0UBuhCKRJMB1aLNapd2mRZwnqb5riFbDSihq7G4yGb29tlaBr4+2wwD7dDI1NaWpMn+bCfdv4pFg4OKLp/0f/+gt+dzZCbazvUJXP/6A/vD762xjbYkco0sa3NxttGljdYtsQ6JkfIRGBk9SMlWkaDxNu60OLS6tw3M9eDxLlsXE2mqDSxSThM/f3ahsGHuPf7wdBth/Pzk5+aJltN9JxKQz3/nWRf/HP/lzJZ3BpcCi1eUl2lhfZr3eDvlemyTmo3cIau82SeYyHT8+TfPPnKNCaZAiiSi5gQvvbVKt3iTbZdTreQxn4t0W6r4XTDGJXRkZHdlYX18/knYOAIYXg/Pnz+uW0/peJMr++Jn5Y5lvv/E1ns8lGBKa9Eiccvk8BeRQ16giB8NQRimVTFOpNEAnpsYpP5AiLtvUNXcAqEVbO+vUajfI830yDY/qdYvA8cKxFb/R6KJbBp8KCm5VKpv2HoxHaSfkotD6tMI0dyYQ9mw2lyzNnJ4IhkfzzAVdKFoMlyMUiaVo8vgJmpufg7cmaHSsTGPjJRoZKVA8KZEk9ahnrlOzswxwC9RAXtooEi4xLJUcOyB0H1S3inz0ibOAc/IPR/EROwyQmAjiYIAUklcdGS0JTUcNCwcroAAX/IBTIlmgofIUjQ3PUGlgiBJxDd60cW0XntugjrFOtreF77QApkOBcAl0SpbpU3PXoMDhpMkSAAYhQKwnc/UBwD3DvQx/HMdCMht4qIeQ+sglvPLwikyypOMEeUqn8qQpMnkIZbdXAf9tkmHVcS9ACI9czychJOSqQrt1k2rVDnkAx5lCCgBKAMf215PsAGD/GGjqFSGo3mn3/Gq1xnw/DI0MiKJ/g8Ad6C4g2XDTHpn2FrV7qwhrFYTdRK65eKAKAEkyehK1GhKABbS5btM20oyzKEkoJgmHDb2H3bDP/wMgp0iFhHTbNN1GvdZioAGhgmxDeAG5/fblel2Qbg2FsoZwrsJrm/3PPBymB5rpdlQURIIqa+gcd7q0cLuN9x4+U0n4CkQPIMHDYv/YkG19AEfZYYD8/ffftzhXlj03WEWVUa9jBrqi4SaEGLTiuFUk/Qa8tkw9uwIO6KCAfOSbjILQaXEhoBvXe/TbT5t07eMaff7ZNq0sGQAnITUi8L7f9xqXkNN4H0YjeEqAX1o0Gjfw3d5WdYeWlleRNzbJYaE4NXhrkdrGLbK8NYBqkmBgBxRP19Dozl1Bn12z6fNrDn1wZYtqWxGAGUAoYxSAK8NiUZAakZhE6UwCqYCE6eff04U4tP6dEpO/cB3ni0ajzRbu3ueO7ZJjNsnobiCEa2TAc07QRFU7+AICj8rudhkI3CbmF9GPI9gpCo8r5NkIpItOhgMqskcxgIvoEoDBk1ygkiGIQDRPssNX+3Xw3nsfLnEhbjiWW1tbqTLbsUQgOqCOGllOnbygB++5CDqRh4KwXJnaLQ9tDg8MBKUSHpXKnIolifIFTvk8w3sNn8UolVEpkdL6+ReG1w+Q5qCgJ9nD8Pv/R6KJNdv2FldXN8XG+magaiEJ+yQrjFRVxsnBrQK86IHfLHQJ0yThGZTNynRqtkBzzxRofDJGQyM6VgxknqIyAGIcgMIBXfkeONINC6SMFFT7Tz7CHutfwFjBw6/3Oi61m8gzgJEhbQJ0AbgTX+JhKkAo6CTjNaxiPWoCDKfp0yk6MZOgkzNJGp+I9D2ZSPgIb9hBkEXMYYoqQxXJCDWfR5QT+499rD0WIDzUZoKvBkIFbXgIs0wquE0CjwWejBzDAuiQIsJkl1GVetSj3IBM2TwqVumBKztofzZlMpBjWU6xOO6TUWweVI2GY4GsITDG8axEPp8/KOVH4v1YgOjteiBk3XVYP7+aDeSLFweQDEKdAE3oSHLoToCTIJqjMZCzBFXTgkCo1Gi7uoWwQ4gKoy8qdN0jDXTEUSgeuBRtjum6BneKQWLS88ePHzvw4iMAH27U/RsGBwePYfa9lIjHzpw+dVIkU7FwSKJ6o07t9h4pu16fOtEVVACPkmNJZFshmZt4rgexio6B3cOKDQvVB5xeD0qn7SJvOWs0LdHpmpofiJxgQikPFlqZTKJVqzWg4b6yhwH2PTo0VJoEDbySyyZOnjk7G8TiOm93DMwUFdBJkxo7HhR0AAIW6McxKOos+DMKz7oUiTPknA5RoRPmGfBf6CiO17DL+NSA4u52wx4is7CjWI4xiIqeCV2jyPL9SqXWAIQvPflYDw6PlKY4976WSsmTp+eOUTId46bp0eLdbdrZ9ml3m6HHerRTM8N0QCHkkG+M0jmOVxn5GHpP6rc1H64LfA5+lKnZFtCHAfp0QPFUgspDCZS0JWzbTgmfhoRg5tDQ0O8qlS3nAMvDORicPDmlEbmjkuJNyBoavGoyLJBzA6Tc3aMaBdXLY2SbKjqGDSEaTm4QxeEEx0PtCUHBdVyHcoa3LFMAlAcP2vgutCAoa6CgQ71n6PyFaX7yRCFIxvkEiu0CY+zkHpQ9bIcBhu8xCKXO2LZ1WZK846fnRsS550Z5tmBRKtug0eM2nZhlNHVaogw+48wi3+ZkduCqkOfDESA0oVCvK9HSYlg0JvJOYDnkIQp2p0MpUM7UsRQVQeIzJzL0Ry9Os7ERSFHWVTHiRvc22bMDgKE7g3MXzuUZt/9M0+m16Zkye/vtiyyVMVB9m5QvunTu2TKdOVekc88N0ex8EV0ClQz9FyrmEBQJHSukIIWW729RvWZhY4wBAt42wAQuxKvfgRrPY3xgFI8j1DF0mkKaolDZvuuE/fkB9XAAsO89iNzLjtd5fnQ8pT/3/DEUh8Ma9UVU4LbvuNvQ5za40IGvOqAWB4N7gmZO5TF6Mmi+XVq8vUW3b96HxLoHcA2E1KLNjTpoyobyzoAdBqgwgKLKQx9BgYdzC0eJ79Q6/XsCT8IcFZ72KzsokhCgGBwtvo4TXXj+uan8y18/haqqsZ65AoAtaJaAVSt1trZSQd5VQy6jAk6eyWJ6gwLvdg3QjYpxMwVyzlM2PQAi52TZZl//JVNJyhUKpEVVSmdj4McIDhujleVW8Osrt/jaatd1XeUjwdV31ze2doEnBIodDhtzFUkOFFkR2ACy3a2hEhtYBvjCR1PDgN7oIfntsBuAWjh6s4dQccpCQqWSe78mhJtiCKSpmRzNoi+PoS8nMhwa0qWF+3X69Ycrwa1bjn/lvS3xi3cX6M5CF2ODdI1LsV86nr+Or4dbhIn9oAeHRgrnoZrPcOakC3lN5HJoRtBwnGs4bRrFoCOHIyybzYF6EuC5cJdQ12D2CFQcSMKMErZA5CbaYKh6ZI0jHeK4rkFftsRHH90S9+/V2epyj5aXumJ7y6lgmP9PIvVf4ZaPf/PZ5+EPnV/agyEeLkYC15vtdc0Ry7KZpkXRP9PCdePi3p0O3fyiTpuoypHxMRZJQCFztC7IJscNe7ZKd+7siPv3G9RoeCgc6EIpij6uiBqIfWWlK353o0pL9+oO+vvCzrZ5FSLoExTWfzMW+YVg8pVPrl3d3IPzlT1A1IVyualKmgolNLa11UluVg2p29WpWvHovf+5TV9cr3l/uF3helSn4uAAUyM6OoGgWs1F1drigyt36ebNKi3DUxjQAU6j2nZAd+80xPXfrgbLS41WEOh3ZDn6zxEt83OE510v8H756bVrC+uVdWsfxgN2uGL678+ePZtTVfF1QfY7aOxzKA4F4oNZPcdQpeR6wNzToxPxwsWXZ/nkyTL6ahfDUUV88KvbzsZap61q0XuYaYb1qJSGjpQ9jDPQjF3f47uKHL1JJP/HJ1d/8y/9JyJqWOFz+wWxvx6wwwBD6/8/MTHBS6XYKOfiMkorp5DGuKSsscD/2PWCv8XQ893h0YFIaSgL4WnBYxvO+mqjnojn/93x3Z9pTHvLFd4lx3Vy6AyGLCuLEuNXPNP91dUbN8IfLg8iFwLqF8NR9jDA0I46Ubip//yZM5cw+f0sCLxnXS+kEBeVrO+oSvzfPvz0k7/GPQ//EHR4j/Dzgwp9xFuPGtH/Ahfyat9yT1aIAAAAAElFTkSuQmCC")
hBitmapsSBT["TropicalDrink"] := Gdip_BitmapFromBase64("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")
hBitmapsSBT["Turpentine"] := Gdip_BitmapFromBase64("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")
hBitmapsSBT["CloudVial"] := Gdip_BitmapFromBase64("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")
hBitmapsSBT["AntPass"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAACgAAAAoCAYAAACM/rhtAAAKKUlEQVR42u2Ya4xd11XHf2vvc859zMOZsWfG40ccu45jEjexFeyASptaJTwaCaFIPFRQQBUiaqESKmqAph8q8VBFilBLIBToF6SIh6CpgqMS13EbiIIbx3FsXAN+1jOO7bE9M3c8cx/nsddicu7VzFSRU+UDCR/y3/rfrbPPPWf991r/u6/25j28h3cZstS/+zBuAsf/D7i3ymAMOMDe0WwuxwtA0dOgrIDcuX3H71WT5JGQ5jHeS66BTt4BQNCbvfZt4OZTVoPIJ1rvq2ftVuMLp06d/SvAA4EeZPfu+yweCdTWQyfPWdu3mntGt1MEBZEfqE/eYtzeQp+Z4WK4eOMSx145Q9wa5PrM9CdOnz79l0AEFABRmubWv8ls/GeczDba7Nm0gUd/9BGgtcIa1qOUXJajK8ZZ0QfA82a5unyvZIV9F57mytMTevlfm7LGRr88PTz9bzMzMyfpZTKK8EJRSJblFJ2Cop2SaYNWuoB3ggbBGYDgXLcPqlSiCnEcYaZYr6krPxEVKBx5yDEL4DwYiEB/rY9ggWbzBn21fuYbHdxY6td98Bad/FojvuP2rf9y5tz5n7x27doZwEXdJ0Gke3WjaJFqm8QnIEq9UkVIEJRWewERY7DvFibmJrl48TI+qeAkx8Xw6rX/ZC7c4N7xe9lYW8O6+jh1GSTPC1QKnKvy5S89zfY7N7P3I3fjnOC8o+h0GLozuLFWVa/uv7Fl65b37Qd+YlHk2WjZsEacxJy/NsHlhWlu61uLj2o8+Rf/zIsvnOAPv/BptmweIFDwzf86yJ8dfIqJmUsk1YgogcpAhBs0fB8cvPEiQ9U6d/RtY8fwdu4dupsN0R187rGv8Nyzr1Dv94xvfJT3b99MIhGGp1O0Gd5dcc6qxfXnm5s33brprxcF7o1Y6R/ziABOwMCL55v7D/PSC6e5cOFzPPYHDxPGZ/j83/0pUa2fvkodkQA4QgZJ7oktRgqjGdoc7rzGy9cO853pu2g8NcS3/+k4w8M1Hv7VB1k3toZ21uJD2z7ASxeOcmLRdqgytLsWNS+H0DzKh3fes/Mrfnxs/eerG5T6NiMUSmyevYsPDcWDBNXFctxOmudMnrvCC98+xisTrxGNeDwRWhiIoSKYGGYGAojgEGouYdiNcfyrDY48M8ldO2/ji3/ySR786H24SqDQgnpUY/PqcY5OnmRBM4yCgS1V17ycm2/UftjdbEkTEXLtsHPXRp7889/l137nQTrRAu1XaqSv9uPaEWag6hYpsEgtHFkrkLcKinyxv1rh+OPzTB9wbHpggF2fWcWW968iyxdKXzrnSPMW21ffwcd2PYTkhgsQ1Tv0jznJ82AOQAUMcAaycmUQRTTQpsHU2Bn6H2iTbMsJk578ihDFDhHBORAnAGgRKNKCLDVyySkqbUZ/vmDjx5XjyXd4/LtPMKlXiOMEFCKJaKbz7N26h13r76SdpWCeIhjiTCJuBjPMweHJ4zz7Pwf5xokXqa6t4ofmqG6JkaqCy0tx6hTKMjtwRrCAdQIMZmz4lTpSbzJb5OVkjxTHmDhykU/90G9yz+AOiiIFBA9UnCeIEpwgdBEJBj0uw1A1oqTC00ee47lTB1jVP4zkCV4SZEQwC3iN8QRUDHEOh0MsIGoQBBYMjXLIAn06wMiqUepU+OD6e7m1so4QFBFXetcQCgCkbIgBEIGZFxGHAILhCMEI4ghpwW/81Mf56T0PMOBv4at/+yz//vyxRbF9KEYqgBogqC+fBGJEBHEQVIhGA/VRYe40/P4XP8Om0VUQQDUQQgEIaoYFD0Qogq3IV4Tzok2QjiuzIgbOx6ABDRlr3BAjo8PUktXsax3FJk6hQ3202y1MIa5U8SIIhgJgiAnxItOQ0/zvgk5cpdPq8NLzR7n9Yx+h0V7Axw5nbul/Wd9gmiFBMdWuSAwnosdnL2eEBafOQZbnTF2fAmI0QJ4H2q02uS2glmHeqGjBz966kV/Yupk1UlBIikSGd7JIh48caUjZuXqQX9++hT0jAxT5PJoGTEB7Fgqq6BsMWopcNzSKUwCBHqJGo/Ha6pGBuyVE5jRmIW9y9uoEezbsIg+Gd4ap4CwmKxSXZzyyfhsPja3DYdwXR/zR2XPM4YjUgQhZkfMjA/18dvP7GPMxc8Nr+PTUVfKggKDBEECk53cU1Ng8ehu+iHHBI2YEESIzi4VeihUAfBSBBUCXyoYV+KpjvYv4cCUhnDvNAo77+2p8vV7lYLtDPw4TQUKHvatGGbl6ldlOyppqjY/2DzFlAbAlqipAN3YIhKwAAF32oAMx6BmzJ9TK1FPSShpZ3ub++++jJcbE1BTVuXn65ma5NH2N6WYHMUFNu8EcTMxMUcxM0zd7ndCY5nvTDSw4gimq38/Sg7Dkx14D6JXcIAoe0TcoWAhoAaqChkVqRFDBS8GUC3xpdpZDKGdMeGJmnpN5TgUlRygU1Md8bb7JP3RyLuL4x07K3y/coC+pYUEIgd7kBTHFghLKOIIUHtTjcHgggh5MMC1n0CWgCtLLMSaoFjhiTnjHpzotPELmBBdFoAYOQAGhGfXxRJbyNyipF5r9NQ4feo2Hfu4DiCsr1s166e+CKBE6aNnQohQPYhGALP3UtaRpl7pIAURBNSzSQJXIBJWYAvAuL18WEFxhANBbdoMX5r0nEqh4x6WpBlmm0IulAepRlTzp8Mx3D7Dv6LfwcYJiOOcwkMgBWFegM4fTBMUTuubDDAJKgStn7MXhXPf7It3yK4IsuQZAMOkuJe12G49b7HPSooBy4gFwVOpVzjQmeObIfo5dOAE1R6VapfhepAvnOi6uVouIFeZErZuNAGa6VO6ukT15ltOYmSXNB8sxUCqJRwSM74cpJInj7h1b8N5KgbduGiGU7xTwwv6TB3nm2LdopC3q/RWqUmX61SJcfbnla1JjpjHzyZUCu1TwZYpAdXmzlGWB4TXD/OIv/zhRNS7veVE+9GO7qff2GYoAIGKggUri2LptEyIFhmEWKLIOkatwPZ3h6y8fYMFn1AfryIKz8y/Oh/x8NVqUenbyysXfen3i9X2RK6shUHQzBcb0whzNNCXPFScGQJ63Wbt2FY8+9ksYhiBgUBR52RsADnqQ3lizOV9eLEGEYB3yIi03XpokZOdVrx1quXymFonpvjPnz3xicWd3EfCRmTkVQkX6NEKEJGZy6grUEgaS+nL5BTAjy0rvLcdzMUBPsLASAtQHKwCsFI4FbqsMs318B89945B2TvrI5fVQdJp/fPzEic8CLG07Xewyisi/fuiG9x5yAmk0zePHn0JUeBMEBFkZjSWY4wdCFFNHHFU4f2mSuVPB9Sf9ly9cef3hSxMTB3rCDAgAsnbt2rvGx8efzNJso8OZioqZkaY5K+FYFqsrRaFv6xzKoQhQmLNKJSauJP9x9vTp3242m1foZe0mpybv8OHRcixdWVJ4M9w7KOrtxl++8S6KNN7D/yH+F+/5sZyQ0tOSAAAAAElFTkSuQmCC")