﻿bitmaps["e_button"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAADIAAAAEAQMAAAD20v5CAAAAA1BMVEXu7vKXSI0iAAAAK0lEQVR4AQEgAN//AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAIAABaSL1yAAAAABJRU5ErkJggg==")
bitmaps["redcannon"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAABsAAAAMAQMAAACpyVQ1AAAABlBMVEUAAAD3//lCqWtQAAAAAXRSTlMAQObYZgAAAEdJREFUeAEBPADD/wDAAGBgAMAAYGAA/gBgYAD+AGBgAMAAYGAAwABgYADAAGBgAMAAYGAAwABgYADAAGBgAMAAYGAAwABgYDdgEn1l8cC/AAAAAElFTkSuQmCC")
bitmaps["tokenlink"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAAFAAAAAOCAMAAACPS2sYAAABelBMVEUiV6gjWKgkWakmWqonW6ooXKspXasqXasrXqwrX6wsX6wxY642Z7E3aLE6arM9bbQ/brVAb7VBcLZDcbZEcrdIdrlLeLpMeLpMebpNertOertPe7tRfbxSfb1Tfr1Uf75VgL5Xgr9Zg8BchcFdhsJeh8JfiMNkjMVljMVljcVmjsZnjsZoj8Zpj8dpkMdqkcdrkchskshtk8ltk8hulMlvlMlwlcpwlspyl8tzmMt0mMt0mcx1msx3m817ns97n89+oNB/otGCpNKNrNaNrdeQr9iTsdmYtduZttybuN2cuN2cud2eut6fu96hvd+lwOGpw+OsxeSux+WvyOW0zOe5z+q50Oq60eq+1Oy/1OzA1u3C1+7E2O7E2e/F2u/G2u/H2/DI3PDK3fHL3/LM3/LN4PLO4PPP4fPP4vPQ4vTS5PTU5fXV5vbX6Pfa6vjb6/nc7Pnf7vrh7/vh8Pvi8fzj8fzk8vzl8/3m9P3n9P7o9f7o9v7p9v/q9/8MEYKwAAAEeUlEQVR4AQFuBJH7AAAAAAAAAAAAASdPAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACX13AAAAAAAAAABAbhIAAAAAAAAAAAAAASdPAAAAAAAAAAVnVgAAAAAAAAAAAAAAGX1hAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACX13AAAAAAAAAABBcBMAAAAAAAAAAAAAGX1hAAAAAAAAAAAkfS4AAAAAAAAAAAAAGn1hAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACX13AAAAAAAAAAAAAAAAAAAAAAAAAAAAGn1hAAAAAAAAAAAAX1sAAAA2YXZiOgAAGn1hAAAgJyEAAAAAJV53Yy0AABZ9ZE9vcU0HAAAAAAAACX13AAAAAAAAAAAXJQ0AFn1kT29xTQcAGn1hAAAgJyEAAAAAQn0RADx9fX19fT8AGn1hADt9chsAAAAfen19fXwmABZ9fX19fX1GAAAAAAAACX13AAAAAAAAAABTfS8AFn19fX19fUYAGn1hADt9chsAAAAAHn01AGx9OAY0fW4DGn1hMHx1IAAAAABafUAKMn1cABZ9fS8IOX10BAAAAAAACX13AAAAAAAAAABTfS8AFn19Lwg5fXQEGn1hMHx1IAAAAAAADH1EAH1eAAAAWX0bGn1zen1RAAAAAAx9agAAAF59CxZ9aQAAAGB9EQAAAAAACX13AAAAAAAAAABTfS8AFn1pAAAAYH0RGn1zen1RAAAAAAAACH1KAH1MAAAASH0pGn19dnp7FAAAABx9fX19fX19GRZ9XgAAAFV9FgAAAAAACX13AAAAAAAAAABTfS8AFn1eAAAAVX0WGn19dnp7FAAAAAAAB31JAH1MAAAAR30oGn14JE59UAAAAB19fX19fX19IhZ9XgAAAFV9FgAAAAAACX13AAAAAAAAAABTfS8AFn1eAAAAVX0WGn14JE59UAAAAAAADn1DAH1dAAAAWH0YGn1hAA95fBUAAA59bQAAAAAAABZ9XgAAAFV9FgAAAAAACX13AAAAAAAAAABTfS8AFn1eAAAAVX0WGn1hAA95fBUAAAAAI30zAGh9PQU3fWsCGn1hAABLfVIAAABlfT4JJ1gzABZ9XgAAAFV9FgAAAAAACX13AAAAAAAAAABTfS8AFn1eAAAAVX0WGn1hAABLfVIAAAAARX0QADB9fX19fTcAGn1hAAAOd30ZAAApfX19fX1FABZ9XgAAAFV9FgAAAAAACX19fX19fX1nAABTfS8AFn1eAAAAVX0WGn1hAAAOd30ZAAACa1oAAAAsXnVgMQAAGn1hAAAAR31UAAAAK2F3ZkEBABZ9XgAAAFV9FgAAAAAACX19fX19fX1nAABTfS8AFn1eAAAAVX0WGn1hAAAAR31UAAAqfS4AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAVpVwAAqhit0/6UWu4AAAAASUVORK5CYII=")
bitmaps["itemmenu"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAACcAAAAuAQAAAACD1z1QAAAAAnRSTlMAAHaTzTgAAAB4SURBVHjanc2hDcJQGAbAex9NQCCQyA6CqGMswiaM0lGACSoQDWn6I5A4zNnDiY32aCPbuoujA1rNUIsggqZRrgmGdJAd+qwN2YdDdEiPXUCgy3lGQJ6I8VK1ZoT4cQBjVa2tUAH/uTHwvZbcMWfClBduVK2i9/YB0wgl4MlLHxIAAAAASUVORK5CYII=")
bitmaps["questlog"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAACoAAAAnAQAAAABRJucoAAAAAnRSTlMAAHaTzTgAAACASURBVHjajczBCcJAEEbhl42wuSUVmFjJphRL2dLGEuxAxQIiePCw+MswBRgY+OANMxgUoJG1gZj1Bd0lWeIIkKCrgBqjxzcfjxs4/GcKhiBXVyL7M0WEIZiCJVgDoJPPJUGtcV5ksWMHB6jCWQv0dl46ToxqzJZePHnQw9W4/QAf0C04CGYsYgAAAABJRU5ErkJggg==")
bitmaps["beemenu"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAACsAAAAsAQAAAADUI3zVAAAAAnRSTlMAAHaTzTgAAACaSURBVHjadc5BDgIhDAXQT9U4y1m6G24inkyO4lGaOUm9AW7MzMY6HyQxJjaBFwotxdW3UAEjNhCc+/1z+mXGmgCH22Ti/S5bIRoXSMgtmTASBeOFsx6td/lDIgGIJ8Czl6kVRAguGL4mW9NcC8zJUjRvlCXXZH3kxiUYW+sBgewhRPq3exIwEOhYiZHl/nS3HdIBePQBlfvtDUnsNfflK46tAAAAAElFTkSuQmCC")
bitmaps["badgelist"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAACcAAAAwAQAAAAC6C167AAAAAnRSTlMAAHaTzTgAAAAXdEVYdFNvZnR3YXJlAFBob3RvRGVtb24gOS4wzRzYMQAAAAlwSFlzAAAOwwAADsMBx2+oZAAAA7VpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0n77u/JyBpZD0nVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkJz8+Cjx4OnhtcG1ldGEgeG1sbnM6eD0nYWRvYmU6bnM6bWV0YS8nIHg6eG1wdGs9J0ltYWdlOjpFeGlmVG9vbCAxMi40NCc+CjxyZGY6UkRGIHhtbG5zOnJkZj0naHR0cDovL3d3dy53My5vcmcvMTk5OS8wMi8yMi1yZGYtc3ludGF4LW5zIyc+CgogPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9JycKICB4bWxuczpleGlmPSdodHRwOi8vbnMuYWRvYmUuY29tL2V4aWYvMS4wLyc+CiAgPGV4aWY6UGl4ZWxYRGltZW5zaW9uPjM5PC9leGlmOlBpeGVsWERpbWVuc2lvbj4KICA8ZXhpZjpQaXhlbFlEaW1lbnNpb24+NDg8L2V4aWY6UGl4ZWxZRGltZW5zaW9uPgogPC9yZGY6RGVzY3JpcHRpb24+CgogPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9JycKICB4bWxuczpleGlmRVg9J2h0dHA6Ly9jaXBhLmpwL2V4aWYvMS4wLyc+CiAgPGV4aWZFWDpHYW1tYT4xMS81PC9leGlmRVg6R2FtbWE+CiA8L3JkZjpEZXNjcmlwdGlvbj4KCiA8cmRmOkRlc2NyaXB0aW9uIHJkZjphYm91dD0nJwogIHhtbG5zOnRpZmY9J2h0dHA6Ly9ucy5hZG9iZS5jb20vdGlmZi8xLjAvJz4KICA8dGlmZjpJbWFnZUxlbmd0aD40ODwvdGlmZjpJbWFnZUxlbmd0aD4KICA8dGlmZjpJbWFnZVdpZHRoPjM5PC90aWZmOkltYWdlV2lkdGg+CiAgPHRpZmY6T3JpZW50YXRpb24+MTwvdGlmZjpPcmllbnRhdGlvbj4KICA8dGlmZjpSZXNvbHV0aW9uVW5pdD4yPC90aWZmOlJlc29sdXRpb25Vbml0PgogIDx0aWZmOlhSZXNvbHV0aW9uPjU3MzA0LzU5NzwvdGlmZjpYUmVzb2x1dGlvbj4KICA8dGlmZjpZUmVzb2x1dGlvbj41NzMwNC81OTc8L3RpZmY6WVJlc29sdXRpb24+CiA8L3JkZjpEZXNjcmlwdGlvbj4KPC9yZGY6UkRGPgo8L3g6eG1wbWV0YT4KPD94cGFja2V0IGVuZD0ncic/PiU0/dgAAAC0SURBVHjaXcsxagJBGEfx9/3dmCUsyZSWc4SkSxHIHCUHCeJRPMrqCTzCYGXnCiIiszPiIBY2v+q9CZNsvWgA+C0DItCClZLRFGcLUQD72L/0o8hjQA7wKg04eQDxsFOATJ1S9b/6o5vo8tSHKszBklYLhAg0x3sTH+WggW+ivcbZ5iBmfPZKAMoekHZssamd10UtlKUAaN5OFqJ8i3cCXEfq+MpSV68/3iV6RkQkIQbOADiuiOE2csGn3KwAAAAASUVORK5CYII=")
bitmaps["settingsmenu"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAADQAAAA0AQAAAADtAyZGAAAAAnRSTlMAAHaTzTgAAAAXdEVYdFNvZnR3YXJlAFBob3RvRGVtb24gOS4wzRzYMQAAAAlwSFlzAAAOwwAADsMBx2+oZAAAA7VpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0n77u/JyBpZD0nVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkJz8+Cjx4OnhtcG1ldGEgeG1sbnM6eD0nYWRvYmU6bnM6bWV0YS8nIHg6eG1wdGs9J0ltYWdlOjpFeGlmVG9vbCAxMi40NCc+CjxyZGY6UkRGIHhtbG5zOnJkZj0naHR0cDovL3d3dy53My5vcmcvMTk5OS8wMi8yMi1yZGYtc3ludGF4LW5zIyc+CgogPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9JycKICB4bWxuczpleGlmPSdodHRwOi8vbnMuYWRvYmUuY29tL2V4aWYvMS4wLyc+CiAgPGV4aWY6UGl4ZWxYRGltZW5zaW9uPjUyPC9leGlmOlBpeGVsWERpbWVuc2lvbj4KICA8ZXhpZjpQaXhlbFlEaW1lbnNpb24+NTI8L2V4aWY6UGl4ZWxZRGltZW5zaW9uPgogPC9yZGY6RGVzY3JpcHRpb24+CgogPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9JycKICB4bWxuczpleGlmRVg9J2h0dHA6Ly9jaXBhLmpwL2V4aWYvMS4wLyc+CiAgPGV4aWZFWDpHYW1tYT4xMS81PC9leGlmRVg6R2FtbWE+CiA8L3JkZjpEZXNjcmlwdGlvbj4KCiA8cmRmOkRlc2NyaXB0aW9uIHJkZjphYm91dD0nJwogIHhtbG5zOnRpZmY9J2h0dHA6Ly9ucy5hZG9iZS5jb20vdGlmZi8xLjAvJz4KICA8dGlmZjpJbWFnZUxlbmd0aD41MjwvdGlmZjpJbWFnZUxlbmd0aD4KICA8dGlmZjpJbWFnZVdpZHRoPjUyPC90aWZmOkltYWdlV2lkdGg+CiAgPHRpZmY6T3JpZW50YXRpb24+MTwvdGlmZjpPcmllbnRhdGlvbj4KICA8dGlmZjpSZXNvbHV0aW9uVW5pdD4yPC90aWZmOlJlc29sdXRpb25Vbml0PgogIDx0aWZmOlhSZXNvbHV0aW9uPjU3MzA0LzU5NzwvdGlmZjpYUmVzb2x1dGlvbj4KICA8dGlmZjpZUmVzb2x1dGlvbj41NzMwNC81OTc8L3RpZmY6WVJlc29sdXRpb24+CiA8L3JkZjpEZXNjcmlwdGlvbj4KPC9yZGY6UkRGPgo8L3g6eG1wbWV0YT4KPD94cGFja2V0IGVuZD0ncic/Pht04fIAAACCSURBVHjahdAxCsMwEETRJxGIO13BR3CZUkf3EXwUpzMmWElULARDvM1nh2WGHaQNGZyJ+4GsDsmIuTQTqX1mE/cZbvIBr9D/8Jl+90XtnEFqlE1Pvx/i7gFp1r56W0O/YgXLyW9PDLueOwldaqv4r7O08BtO/lc9UEszEn0CLvp/A7WmKNIpIQUGAAAAAElFTkSuQmCC")
bitmaps["shopmenu"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAADIAAAAuAQAAAABCUHf8AAAAAnRSTlMAAHaTzTgAAAAXdEVYdFNvZnR3YXJlAFBob3RvRGVtb24gOS4wzRzYMQAAAAlwSFlzAAAOwwAADsMBx2+oZAAAA7VpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0n77u/JyBpZD0nVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkJz8+Cjx4OnhtcG1ldGEgeG1sbnM6eD0nYWRvYmU6bnM6bWV0YS8nIHg6eG1wdGs9J0ltYWdlOjpFeGlmVG9vbCAxMi40NCc+CjxyZGY6UkRGIHhtbG5zOnJkZj0naHR0cDovL3d3dy53My5vcmcvMTk5OS8wMi8yMi1yZGYtc3ludGF4LW5zIyc+CgogPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9JycKICB4bWxuczpleGlmPSdodHRwOi8vbnMuYWRvYmUuY29tL2V4aWYvMS4wLyc+CiAgPGV4aWY6UGl4ZWxYRGltZW5zaW9uPjUwPC9leGlmOlBpeGVsWERpbWVuc2lvbj4KICA8ZXhpZjpQaXhlbFlEaW1lbnNpb24+NDY8L2V4aWY6UGl4ZWxZRGltZW5zaW9uPgogPC9yZGY6RGVzY3JpcHRpb24+CgogPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9JycKICB4bWxuczpleGlmRVg9J2h0dHA6Ly9jaXBhLmpwL2V4aWYvMS4wLyc+CiAgPGV4aWZFWDpHYW1tYT4xMS81PC9leGlmRVg6R2FtbWE+CiA8L3JkZjpEZXNjcmlwdGlvbj4KCiA8cmRmOkRlc2NyaXB0aW9uIHJkZjphYm91dD0nJwogIHhtbG5zOnRpZmY9J2h0dHA6Ly9ucy5hZG9iZS5jb20vdGlmZi8xLjAvJz4KICA8dGlmZjpJbWFnZUxlbmd0aD40NjwvdGlmZjpJbWFnZUxlbmd0aD4KICA8dGlmZjpJbWFnZVdpZHRoPjUwPC90aWZmOkltYWdlV2lkdGg+CiAgPHRpZmY6T3JpZW50YXRpb24+MTwvdGlmZjpPcmllbnRhdGlvbj4KICA8dGlmZjpSZXNvbHV0aW9uVW5pdD4yPC90aWZmOlJlc29sdXRpb25Vbml0PgogIDx0aWZmOlhSZXNvbHV0aW9uPjU3MzA0LzU5NzwvdGlmZjpYUmVzb2x1dGlvbj4KICA8dGlmZjpZUmVzb2x1dGlvbj41NzMwNC81OTc8L3RpZmY6WVJlc29sdXRpb24+CiA8L3JkZjpEZXNjcmlwdGlvbj4KPC9yZGY6UkRGPgo8L3g6eG1wbWV0YT4KPD94cGFja2V0IGVuZD0ncic/PjV3i+oAAACVSURBVHjahc+xDcIwEIXh/5IUKZDiDfAIGYDCo2UVNgmbuKSkpAg+9DARlijyJOvzO1knGegfoEwb0EHoqtGqr1C9PBepHAuT+9bOZ+jbjkdkKrC0c+4ons1X9ewgV6QBRHWMZp8uBMR+ihwARvXkICNyJMPw28s3Zwcv//+KYFi7fx1kYh5h6eAUmvfmH25770ni+gaovR6HzkdY3gAAAABJRU5ErkJggg==")
bitmaps["dialog"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAABQAAAAUAQMAAAC3R49OAAAABlBMVEUiV6gyg//3rCo4AAAAEElEQVR42mMgFvz//4EYDABK9B1Nh2RNtgAAAABJRU5ErkJggg==")
bitmaps["shiftlock"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAABkAAAAZAgMAAAC5h23wAAAADFBMVEUAAAAFov4Fov0Gov5PyD1RAAAAAXRSTlMAQObYZgAAAG1JREFUeNp1zrENwlAMhOEvOOmQQsEgGSBSVkjB24dRMgIjeBRGyAZBLhBpKOz/ijvdEcfyhpEZXkQST+yMMHNFvUm3CjZ9L1K6dZzYtbYWh9YekoE7sij/cit/pKny8e379Udiryt92ns5lp0PKyEgGjSX+tcAAAAASUVORK5CYII=")
bitmaps["yes"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAAB0AAAAPAQMAAAAiQ1bcAAAABlBMVEUAAAD3//lCqWtQAAAAAXRSTlMAQObYZgAAAFZJREFUeAEBSwC0/wDDAAfAAEIACGAAfgAQMAA8ABAQABgAIAgAGAAgCAAYACAYABgAP/gAGAAgAAAYAAAAABgAIAAAGAAwAAAYADAAABgAGDAAGAAP4FGfB+0KKAbEAAAAAElFTkSuQmCC")
bitmaps["no"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAAB4AAAAQAQMAAAA79F2RAAAABlBMVEUAAAD3//lCqWtQAAAAAXRSTlMAQObYZgAAAFtJREFUeAEBUACv/wD4CAHAANwIB/AAjAgMGACGCAgIAIYIEAwAgwgQBACBiBAEAIGIEAQAgMgQBACAeBAEAIA4EAQAgDgQBACAOBAEAIAYCAgAgAgMGACACAfwttYQFVcrYb0AAAAASUVORK5CYII=")
bitmaps["keep"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAAEIAAAAcAQMAAADvHvssAAAABlBMVEUAAAD3//lCqWtQAAAAAXRSTlMAQObYZgAAAIBJREFUeNqVzjEOwjAQRNGxLHmbyLmAJa6RY6WkQitxMR9lIwpKWgrLy8pgkyJNfvW6GUjCL1mGrkPrkHRtuevBsOgGPNm/XSE1gYqvpIwX4kSB7gzFFIInl6GcQmzavoIpX+qsJogcaE2I2MmZlr/6hqS5kO3C1B5UU2yv0DuhDxaLPafi+H0cAAAAAElFTkSuQmCC")
bitmaps["emptyhealth"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAACgAAAAGCAAAAACUM4P3AAAAAnRSTlMAAHaTzTgAAAAXdEVYdFNvZnR3YXJlAFBob3RvRGVtb24gOS4wzRzYMQAAAyZpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0n77u/JyBpZD0nVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkJz8+Cjx4OnhtcG1ldGEgeG1sbnM6eD0nYWRvYmU6bnM6bWV0YS8nIHg6eG1wdGs9J0ltYWdlOjpFeGlmVG9vbCAxMi40NCc+CjxyZGY6UkRGIHhtbG5zOnJkZj0naHR0cDovL3d3dy53My5vcmcvMTk5OS8wMi8yMi1yZGYtc3ludGF4LW5zIyc+CgogPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9JycKICB4bWxuczpleGlmPSdodHRwOi8vbnMuYWRvYmUuY29tL2V4aWYvMS4wLyc+CiAgPGV4aWY6UGl4ZWxYRGltZW5zaW9uPjQwPC9leGlmOlBpeGVsWERpbWVuc2lvbj4KICA8ZXhpZjpQaXhlbFlEaW1lbnNpb24+NjwvZXhpZjpQaXhlbFlEaW1lbnNpb24+CiA8L3JkZjpEZXNjcmlwdGlvbj4KCiA8cmRmOkRlc2NyaXB0aW9uIHJkZjphYm91dD0nJwogIHhtbG5zOnRpZmY9J2h0dHA6Ly9ucy5hZG9iZS5jb20vdGlmZi8xLjAvJz4KICA8dGlmZjpJbWFnZUxlbmd0aD42PC90aWZmOkltYWdlTGVuZ3RoPgogIDx0aWZmOkltYWdlV2lkdGg+NDA8L3RpZmY6SW1hZ2VXaWR0aD4KICA8dGlmZjpPcmllbnRhdGlvbj4xPC90aWZmOk9yaWVudGF0aW9uPgogIDx0aWZmOlJlc29sdXRpb25Vbml0PjI8L3RpZmY6UmVzb2x1dGlvblVuaXQ+CiAgPHRpZmY6WFJlc29sdXRpb24+OTYvMTwvdGlmZjpYUmVzb2x1dGlvbj4KICA8dGlmZjpZUmVzb2x1dGlvbj45Ni8xPC90aWZmOllSZXNvbHV0aW9uPgogPC9yZGY6RGVzY3JpcHRpb24+CjwvcmRmOlJERj4KPC94OnhtcG1ldGE+Cjw/eHBhY2tldCBlbmQ9J3InPz77yGiWAAAAI0lEQVR42mNUYyAOMDJggOUMDAyRmAqXMxAHmBiobjWxngEAj7gC+wwAe1AAAAAASUVORK5CYII=")
bitmaps["disconnected"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAAGQAAAASBAMAAABft2a7AAAAElBMVEU5Oz38/Pz8/f39/f3+/v7///+Pg9IaAAAALElEQVR42mMYBcMGCAoKCikbQ4ELFIRCQQiU72wMBUqCgoIMoSSDUS100AIAwSaP+Z3P8L8AAAAASUVORK5CYII=")
bitmaps["feed"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAADwAAAAUAQMAAADrzcxqAAAABlBMVEUAAAD3//lCqWtQAAAAAXRSTlMAQObYZgAAAE1JREFUeNqNzbENwCAMRNHfpYxLSo/ACB4pG8SjMkImIAiwRIe46lX3+QtzAcE5wQ1cHeKQHhw10EwFwISK6YAvvCVg7LBamuM5fRGFBk/MFx8u1mbtAAAAAElFTkSuQmCC")
bitmaps["hiveballoon"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAADkAAAAOCAMAAACiuUSiAAABcVBMVEUiV6gjWKgkWKkkWaklWqknW6opXasqXasrXqwrX6wtYK0uYK0vYa0vYq4wYq4xY68yZK8zZbA0ZbA2Z7E4abI5abI8bLM9bLQ+brRBb7VBcLZCcbZDcbZEc7dFc7dGdLhHdLhIdrlKd7lLeLpMeLpMebpNebtOertQfLxRfbxTfr1WgL9Xgr9YgsBahMFahMBeh8JgicNhicNiisRji8RljMVljcVnjsZqkcdrkchsk8htk8lulMlwlcp1mcx5nc56nc57ns98n899oNB+oNB/odB/otGCo9KDpdKFptOGp9OHqNSNrNaNrdeOrteQr9ifu9+jvuCkv+GmwOGqw+Oux+WvyOWxyua1zOi1zei60eq70eu80uu90+y+1Oy/1OzA1e3B1u3C1+7F2e/G2u/L3vLL3vHN4PLO4fPU5fXW5/bY6PfZ6ffZ6vjb6/nf7vrg7/vh8Pvi8fzj8fzk8v3k8vzn9P7o9f7o9v7p9v/q9//L/JKlAAABP0lEQVR42qXQaTcCYRjG8atQliLL2JPsabGXSCT7Uii7DCqZksZS6f70zDydDKfe5HrxP8+b3zn3efCfWYgoF7UCqwGUW2QNf+YgV0kSZQzIH5eVvL+yXITKS45Kcm6s9NSdvNwL/C+pXqdhWRoj2ZgV8Aji3Wyx+RCWKfqW9AEh+h4POy0orr2okWRt4kwfzHKtnweGrX5WJoPaTRqqz8U5i8hjlGwKmeQkaScbOsjb9J49MoOVyQm0kK+XNoA4j24yF6ULqnnaleQKSTvEVILyblYmx6GjHSO5ZdlM3I900r4kHbSn8Ww3Aqrp9COrQurIJ0u1v05xbUH+IY1AROkGbWDQcH3DqpA4j7VNijw6UwMlWXhagiRhunp9GEFfOCVe9rAqZftpJineouvZhCqWCqO6OclfHZz5EPTs9QUVN23HSF0y5wAAAABJRU5ErkJggg==")

bitmaps["EndCraftG"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAAEkAAAAkCAYAAADFGRdYAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAANsSURBVGhD7Zh7SFNRHMe/brV06nqQCWpBaQ+bW7WpFUUQRFFg/6QVUVCU/lHQPxUYPVCiP8JeRFCU0eOPkh4UVGBJD5VVf2RrhVk+IiVTK8utNnXu0b3bT+eczqNbNG/3czns9733MC4fzj33nhMW9zLJiWGSGD4VD5X3KA2NgsYTONtcSOnfoJIrcSf5OiWgzKTDlpocSh6CKqnitx5rP2ykFPqwSpLQr4gfQkZSduwW1Gkre9qGmHVIjdLg1LSj0Kke473mNSrm6FA08wrWT8zkbpzt1qOkUdgWuxnXZl7GC3Wp63+epjzA3oQ9UIxSUC//hMzjxkvKTdhNCahur8GMiOmUfNGZnmNb7XZYnVY648v86DScnFqASaNj6Iw3bTYjxo0aS2kEPm7+BPEsUizEgcm5lHyZLU9GYdKZAQXx9BbkjxE9J62PyXKN5r6EccfhKXmQSyLoTGAEVZI2ap7XvNK7VWveUC92DOa3WPdhE1T6NGgNi3Ck8TjsTjtd5W9egqyJayh5SI9OhToyhZKbUmM5MqoyodRrsaJyNYq+36ArgxOyI6nN1obNNdl4+fsVLA6LK59rvsCJOkY93CyITqfKw8rxK6hyozcbkF23A+8sVehwdKC2ow776vNwvuUi9fBPyEoqaXsMk/0XJQ9Xvl6F2W6mBEyWJVDlQS33HkWnm856jcBuyrmJmoWQldRo/UKVN13OLjR1tVACorlXfF+SwqdRBdicNjwzvaA0PIIqif8ESKxQ9ttmvFJTLzZ4GQPhdDqo8kUaJkWkNJIS8Nna6PczgYWQHUnDRS6RU+XGaDNRNXwEJ8nOPV69cXJHoAhOksXR7jVJ88uSQBGcJJ4v1iaq+LdfvGueCgRBSqrkvoe6GSMZg7mRQ3tp9EWQkh4Zn1DlJid2K1XeLFEspso/QZXkb1nSX+O3Qv4GxT9L0Gr7QQlYNm4pDk05iHhZHGRhMm7xO8u1O8BvobAgyJHEL2PyGw5TcsPvT5WpSlCl0eNu8i1kTFhFVwZHkJJ47v8sxv6G/IA/JHkEK4nn2rfrWF6ZgcKWS3jfXu1aC3Y6OvGpsx43W29j58ddeGIs7WkGc/87FQHtTP4vCHokBQtREgOiJAZESQyIkhgQJTEgSmJAlMSAKIkBURIDoiQGREkMiJIGBfgD+xhA1qHgsMIAAAAASUVORK5CYII=")
bitmaps["EndCraftR"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAAEoAAAAjCAYAAAAzK5zjAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAI5SURBVGhD7dfPS9NxHMfx1zbcapsRyA6mdXCWpqTSgqCwQ0QHw3t4M1fdgi4RJGjUVfAPiIIuUakdohIhMwm1g4GKqAdRw60gVm7WdPvu67d9t/ccohvvzQny9f2AL3u/2XbYk89+mb5WlWvYJVuFG1XvB2jLTlNVTNWeom07142bKL13nzbgd+9rLD9I7ymmoiLUjo3D7HAkdjW4gunznsScUvmqD/a6etqAhdttWP08RFua88JFVDx9Thuw+mUYC95W2pLMdLtvKX4fTVtpigLl5w/a4i/EWUxT2iF3JU3xx8di+Ds6Qlvu9iTUv2/jmKx273hlO0070YNkommZ3wwmi2XztOmivmVo0Shtudv3JypfZrudpiQ1GKQpP4YNpcVUmkiW08dh2FAba+HEF0eKxemkKT+GDaVT/H6aAGv58cTnVr4MHWptZpqm+Ie7zQZ7fQNtuTN0qNDgR5qSXN5bNG1V3HiJpsz2JJTjrAd1s/Psy+E5R88srOBAP2KBAG3AkctXUNb5CNZjZTBZrTh8ugYnurrhavXSIzIz9InaCIfhf/yQtqSS6y2oHhzGmckZnHzzFkevNdM92Rk6lG7lwzv4Otp39WNTZ/hQusDLF5hruopfz55gfW4WaigELRJBZGkRf/p68P3uHYSGPm1e4YkJemZaQf4UHwQH4kQVgoRiklBMEopJQjFJKCYJxSShmCQUk4RiklBMEopJQjFJKCYJxSShmCQUk4RiklBMEopJQrEA/wEh5K+E9HVfjwAAAABJRU5ErkJggg==")
bitmaps["CancelCraft"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAAD4AAAAdCAYAAADy+d/cAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAR0SURBVFhH7ZhtTJtVFMf/tFDeyutYoIxRYFOpI2zxZZgY5tyHbdmSTVR0blGjm04DjsRkBoM6Q0JCYtQJ4hJNXFyMUdybukSRqRM3FTfjBkynGwMcY6BdgbajtLTUe+9zHrrS1tH2+ULoL2l6zum9l/u/97nnnoeo9lty3JjF3HzkK8QtvknYw4cP4lL1TmHfiCnhuW80IHXdehEcbW2B+ZtWpN1fjvhCA1QJCXAajbD+dAJDTY1w9F8S7fyReNvtSN+0GYl33ImYeRlwWa2YuDKAUTaeqfkTOK8aqaUvmuwFmL/1KSStWImYzEy4LBaMnfkNxg/2wtr+M7XyRlHhbpcLUWq1sKfDhVx8bDNsv5+liIfMyipkVjzHRo2iiDeukRH0bN/KxJymiIek0hXQv9UkFtkHtxuDDW/inz1NFPAQqnAVfXsRSDRHrdUi9/XdiIqOpohE2sYyJnxHQNEcdWoq8t/bC3VyCkUkYgsWQd/4jn/RHDZmVtXzUxujBH6Fc/iunH/wPnQuvRXnVq+C5Yc2+oVNNL8AKWvWkscGiYuD7oVq8oDJsTH0VVWia1kR/ri3lD3iH9MvTHxyMtI2bCRPIrvmZTZGvLBdZjN6K59BZ7EBf65fIx51Gd3Oap8FDxW/wt0OB5t4BWxdnXDb7XD83Ye+HRXirMrwcyjD7Wh2nmUG6usw2vIlJsdtok//KzWwtH0P04FPcaG8DMYP91FLabeT7i4lj/Wtq4X5aKuYg737AnornhVz4MTospG4/C5hh4tf4faei5gYHCRPYtI2xpLe1+SxCeflkQVoS0rIkhZt5IvPyfPQ8/ST6K+pxlhnB0UkkleuIgss8V3FyBHvvk7jvxg96vm7PBcogV/hTpOJLG/4JGRUCYlksWycl08WYDvbJRZppsQbDGRJC84T63R4XEZOZOES8IzfkOuS2PXJaoJde8GgTksji12F7AosPtft8+G3hUysXk9WeIQuPCBB1kNBNldpk8gKD0WEu8yjZLEElDGfrJnBs3gwBLzygkQR4Y7eHrLYmV1SNHU1zQR793mypLPcUbjofz9dy5ZQ6/BQRLi1vZ0sdvQ1GqROu6c5+e++j5y6eiQUL6WIhPXkSbL4+c3zm7zSH9oEzcKF5CmDIsItbce8avDs6hqkrF4rdj5Gp0NObR276+9B+gPlWNx8EBmPPk4tgWunfoFdfmJUKujf3gPt8hKpb1YWFuyqFf0LW74Vi8cXRwkUET45Po4rr9WTxwZl51Df0ISi010wfHdc7JgMzwfDnx0ij8Hq8Mu1r4pvTiy7Ggv2fST1PXYC8x7ZIuJ8UTS5uZgY8q4vQkUR4Zzhw4fEm5sswB/iJWXbEz4JzfrjcfS/9CLcTidFfBFV3PZtYpGVQDHhnKHG3eje8rCovnipyqs4XgzxomaIvV2J2rvjDLX2hpezf21YB9P+ZjgGLkt92fG59usp9kTsYu8NZbD39VLr8Jn1/4gIFUV3fDYRET7XiAifa0SEzzUiwucaEeFzC+A/FuGxWYDii14AAAAASUVORK5CYII=")
bitmaps["EnzymesB"] := Gdip_BitmapFromBase64("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")
bitmaps["OilB"] := Gdip_BitmapFromBase64("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")
bitmaps["GlueB"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAAC4AAAAsCAYAAAAacYo8AAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAjmSURBVGhD7VjtchTHFb3T87G7Qgh9WUgIB8sVG0JsIOUKLlKVCpV/eZS8BT/yFLyG8yt+AQImFQQCB7AESAIB0n7O7s7OZ87pmZF2V7uwWguqXOWjaobtmek+9/a5t2+PsfWPSiIfEkZ6Mc8kUvxDJM7n8X5fHCdSqbpSb7QkDNGfwTAM8X1fnjx5Ijdv3pR2uy1JktIM1YS8DpZE6V8fCiSIZhRErPlEzDlMnpEmoigWr93B9bDvSDQMgx7ShGcuiJQWQbxroGMHx4ZrjClcZhMximk3QW97XiA+PN1NLEUizaarPd59L8IAtY4tiT0pyjiBGzZ66fsPYISBsU2QVtMgbmWdAOm02h4MOJAIAZXovnJ5V+7c+SHrTeFZn0jizOIZU5TzJZZwCYPCAMPBXRPtmAwgaaOE8WfQpjC+Sr1HL0ZRJF4nOORt6rvpurK+vgHy5awXxmCwWjAJJ2P5AOVciKVwMRbni9QAdQoTYDKhd36OAXjfKGCsCUxyElfoPI8okm23fR2Q/SrhvZ3XO3L37n+ynhQdc14ic0oMk/LAUNYcSJ9DI/nfxWLDAHsFRizCCEwoXIUxZKRlgdXjGIqraeXeRmYA4WbLG+ztZlM2Np5pj+cAG6nFkIgDj2dQOniKiVizIP4ZvP/7SAqX0L6KxP4t+mGAwWXOPXYUA0CemUTxfUoQoH7bnq8Ds584sbW1JY8ePcp+pYhUSULtbZJIkS0eAEKGA9vgIROpy16BISDvfI0GA8zTmQEjBjI5mSeZBvE45JLPFISRuG5bZ5VuMCiDwIen12Vt7WHWSxgSqEmxbZI+eOeAeBcM9CpIxEImoIwKIF/4JsIGEot1DuRP4CF6MDeg3wj8VjaMXYqRTeJ9mdDbfidEUIaHvG2aSl5D2zs7r0SpbloYJ/HxL58/mGgg8X3gOZ3OsAr2cixFrMDE9VAm/gIZIRsZlFw+FkdiQMJgykrN4Cf2im5v+wG8PUTbxOPH/9MyYcY5gIHAnBEsVA8Ud68IyzZAbgegAZwcTSHj2OciKX0LA2BE4Y+RWL+BESCo50dLMImBFKgm4W0z93YiHeh6kLbp4BfPn8tPP61Lve5mvSkwsrSss1i1UtaTQhnK0BNyKd5JPgeNYNDlq4BsVPwGBlyJxDyLAUgee4pCwOcB7fuhNBptZJKOlks/Ehh169+35eHDH3u8nSCiW9aSBAmXMlu2DKR98MdJRwUNgCyY7ph5nC8QC8hG9nmk1K/g6UXoGX9u05NavY1rR0vlUCbB7+2X27K5uYmg7fU20oM07c/AOc3d3VAkm7dxEGPiSEUSlwIJZz3xV1y0utSdulQartRqLaQ/3EPuHuTtOInl9u3b8urVq6yHMHRd0lRzyChITX3eJg73DAEdRW9RqwE8x52v4Xq6JCW5Sq0p1ZYrDQtNueL6TS0Nelm/j79BxCuVMoLyqVSrtayHzzJ3F6Vtnx1ImlAhwpVeI7FBIFldfmLTIJEGcnCtDqLVJiZ1pYzG/5N8E3JgAPo+xoSBzBamaeorxzkkE+Dx4yfQf6P3HrTtJ0VsOqeyjsNQdQRNC97r+Oly5kTpVQYVCyHqlAV/udKQ3b2GJsotm+/w2UGECObjPCcffgb1Sqslq6v3kUnqPfdDoyRtY1YbMAyKhPb2oEdcNRlsDjnRvXJKlI3e5r10uQcT7Qc9zcZ3+mVCg9cerqEu2dCHhRxIogjpExIUlrOewVBcUnqWy1wuu/J2t6YJUw40gBIZpM1RwPeY3ga9z6PZd9/9ExKr9Xg7wo7lxpOSDMgk3dhXPl8OsxqZ3jgOkDQJ8tpNLggCXZPs7e3pe93wzWmJSp9mv4Zj5KwyCvKtuxsknJPmbcvEFt5x5fvv/4WYCnU/wR3SV6ekHpyAt7vOeENwbMTzzDEMud79wJOtzefa490S6qCwcZ0ViYpLqYXvwbERfxdpglRgmuztvpVbt24jdjrpDSBQU1IJZ9JM0leTDIPiiaNfZx8CNMtrt+TFixfyYO3HtDND21qUqIBS0qRERtvCFbfbN2/eaL29z2vjghLhIWHr5UuQftRTATKLNBOcbizWv6PDxAZxg5uEZVl6s+A11+NxgQ6pYmv/7717cufO3R6ZtKxPpWXMgPj7A7Ib5vz8/I2dnR3Z3d3dDxYakJM/DiP4RYrB+MPdu6gCt7Je5HmcUir2l9D11EgB2Q3zzJkzNzqdjrx9+1ZeYilpRBtaTI3AsQm1Rl5vHBX0NFujUZfVe6uyev++zuv6HvKCB227xgJ2dn5KOBrM5eXlG/wPJ+DWSwNYGz94sCbbOHGbyLunTvKw6qBQYxIazQCOR5LValWePn2KmmRVtrdfZndxH3VItXhJEjM/Oh0NxtWrVw9FZC4PetpxHFk8vSDXr/9ZLl+5JMUCDpooNfdXgF7VF5a7KMhwGGDjrrixsa6rP8qQqxgE6YZD0kx95cIVePvdW/swGJev/S0pRHvZz8FgwE5Pn5KpqZPyp2vfyoUL52V2bl4cuwADUBSBcLlc0QUTP1Ty6nmeXkFe+zMWv5OUna+xvc+N5W3CWL7292TC8qUUvZZCuAchDM/p9PLp05/AiGm5ePG8fL6yglhIZHNrW55tPJNXO290iUqPDyqsCAZkM5mWWunyWNrOYSz/9QaOJjh5e7tywvSkmFTFiSqikjSIsLB6x+vHwsK8zM3Nak9WKlV9gul08ncGI8LpmV5uqEUJnMWsdzykxHPg/CedXZCvS0EFIJxmFit2xYlrYvC7w5GAEeBhEuYZMjCnoG2cI3myeU/Z+j70Eu+CEXGTAHEYY/hlsTo7MlXEKT5uYDUYZANfS9fHsDLCE/qw244cCRWqPuTrRNci4+m6G0OJ9yOJQ7HCstit5zJp+2KLhxXgqqRZhZkmhmdDeDbC0StUk3pHjE0Q5uewIYfecTEy8W6ooCIlf1NLytQf61GLJLa01ZyE9rzEyBoxPz4eg2eHYSziOYyoLZaBVAeCkTg4AIyfJY6Kn7V+iVnSGqYsPiZp4niF9xHxK/GPjV8ocZH/A9CN+sQm+bL9AAAAAElFTkSuQmCC")
bitmaps["TropicalDrinkB"] := Gdip_BitmapFromBase64("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")
bitmaps["MoonCharmsB"] := Gdip_BitmapFromBase64("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")
bitmaps["GlitterB"] := Gdip_BitmapFromBase64("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")
bitmaps["StarJellyB"] := Gdip_BitmapFromBase64("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")
bitmaps["PurplePotionB"] := Gdip_BitmapFromBase64("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")
bitmaps["SoftWaxB"] := Gdip_BitmapFromBase64("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")
bitmaps["HardWaxB"] := Gdip_BitmapFromBase64("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")
bitmaps["SwirledWaxB"] := Gdip_BitmapFromBase64("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")
bitmaps["CausticWaxB"] := Gdip_BitmapFromBase64("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")
bitmaps["FieldWaxB"] := Gdip_BitmapFromBase64("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")
bitmaps["SmoothDiceB"] := Gdip_BitmapFromBase64("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")
bitmaps["LoadedDiceB"] := Gdip_BitmapFromBase64("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")
bitmaps["SuperSmoothieB"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAAC8AAAAvCAYAAABzJ5OsAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAABL6SURBVGhDpVlnjBzneX6m7O7szPY77u3xGvuRFCnJaqEoUbIKZRVHEWzAphIkihH4V5zyI0aQHzaIIEiQwIiB2EmcKLBjwLEBt0SEZFowJMV01EhLrJIoHcv1vr3O7uxMnnd273gUSZGCX+njzE35vud9v7c876zy6qGveZ4KQJGhQvGUzqn8x7+hylGDp6nwdB2upvnXfiPR+X6Ax0Dn6GkeGl4FeXsCdScP12vDA9dDCC5MeIrJh02km8OIt3oR8IL8W4GqB0II6GEEtDB03YDGvzU9CFXTqQuVEVU879LglL+RKJxPdOfRVVw02hUU7GnkGhe6wFu86XLIOi4fbftDzhtaDW21xTsdDKIehf/IhF1cnr9Ad/g35KIM/tN95kbENNoIBlxu1JqXeC6WbThFFBvTvrVLzVkCL3SBd0ThQlTPB74ymkodjtIkvs58NO0agCLyNy3uyVhVonvPl+srIK8I6J6kjajlcEc7LxA2Wk4d5fosCvVpFO0ZVFtLaLpV3qN1+ZjWBKwZBYFq543OLnQs31JsjhbP5JqAF//l/x2gnaMPnP7t0b/9c46V53ylffe5tih8KKC7CBsOgkFZuA3HsdGwiyhV55CtXES5OY+WV+N6BMJ5/fc4dFtBdJLgy3Kla31PwBKy0kab4D0eRdTLLdwdIqKEgGeg+jvB4JWp/FucSCUgTRWr2gRa57EBTWvxNRdtrlUhiNllHXM5D/kKg7E8i6XcOR4v0m9pXtkNxv4KcBHfzgzgRj/VNTvAxb/leucxj27jiBr+ufL6S/9GF+IDAlosLFbtKiGA/bdWrzEH8GVdb9KiNkLhCqKRGQQCJbTbIZSrfQTXj0LDRLnVQLVJS9eyqDXy0No2IrqGUIhzRjgMDsk2OueXNdaKoJWLXLPtmpy7F+FQnIZkHNlxJJp9CLcjBP/yv/uPivjuQVHVNtOQw6zT8i1rmXlErHkYxhiv5X2LiGuoKneA0a9wG307tYPIllM4PTmMUxMGF+Y2e2IpBhwXDgVUBrEOxyB2HkMBjVlNQPrLXiF0HtSqW1HK3o30ugbC8YtQmyoSjTSsdpzgX3mWZufS3O6QWUckuoSwOUnLLtAN6j64ABXQ9RpHic/Z3amvLo1mCFPLPfjFiRHkqwFRczWvq0EFGi3vyVFXYQV0mNwNvWu0FZH6EtBMhLQ4Wo0NKJdGEYuXETAX4TRaiNfTiDgJKMde+6YXMZdhWpMwwou0SJ5bu8zJi3QR+mZnDy8Tx42hbG/GfGkHLUuLag4MpoeYMYlIcBzVhoPXz27GyYkkbJcml4JEwJ3Bc1GGCSDIeIowMZgcurglFdVVg3NFec+CTgU8rtVqxqAHGKRaG/W6jVhtHSKtJJTxsS96sdgUIpHztHSeE3Qi+aOkUN+BEwsH8LPJBwleQZjuZdDv7+r7P9zbfwiacgHjCxm8QOtX23RqAR/qghfgXVdRqXiE9yOKDtUg8KCGcCCJaKiPwDtVlE9xMHFQa/oGwTcRqfbAatLyrdoQXb1Cz1HheBEGh0nL0l89LkpgndwoCnl+dhE5m70XP/jgS/ju1Kj/94r80ZaX8eXd30LCOIKlUhI/PDqKkkPkK1YXJXzgHMRk1lSksjoMW0UzxUzfr3H3ejgyXEvAiwh4yXRBwjFg1x1YlRTCTfq8U+/1Wm4YlVYUy/XbUKzvRKG2EfVmigpRAcmrapnrObQIswp1OTI/iu9d3IOyK6niknxx22H85e5/5nPHOEcU/3VsF4pOqANaHu26i29Qjg0XQ1h/IYhwUUWp18H7e5vojfegxxqkz/M9X1bAB3zwLBcwywmE7BiUbOEu79jsH+C7738Kx6spcg1uj8/UZKxIp6JJhpF9aNGP7TYn8692RCjAn+78F/zVrX/PTWoiX4/i+6d2o9iiBSWfy5Ap/ZQrbwBb3zPQPxFAsErwPW2c3ltHKBLBxthmuk+489Cq6zD4lTBc7lK4HEfQjkB9fvwL+Orpz+DVwhCWGjEuFkaZ1ipzuy8N+TuEUstg/jao4OXARYb0Kvrp9woavKegybzvMqOs+rhvcRndFyjlZBuVuIsaRzHtwCalaLRbaLgOd/jDK4gI1/T5rj+N+u1zj2GsnEaZgSNpTQiRzoJiNEsw60uIVmcQLU8hWplmoMwh2Kr4k3xY+rQKUqgy19N3XZWEKwJXUuCK1WW1NcBF8gQ/vtXG2K4GZofEPZmBdJO0QWH8SXW9UjRWKlFARD1VGGRM0qNImAw7D4sAIwRsEqxJ0KH8RY5zMIrjCPOaUaEChSkEl8cQXDqLAM8VOmKvnkNCK8Klh0l6nKwwxckivqt0x4fEDrnI0deXMi2UoyyMrGSRYMKv7A4xuavW73BMyR1GlalyahaJd9+Fknq26QWcGsL1ZSpQJasrAU0SJgIySJzSRpGpsEiV6Qaqifl6AotlRqBdhcLtdY04I28PDgwewYGt38H2oaPIOXE8d2EXck2Jn6ugvorIngfZUwzEtjLTBBDiroVVHQG1GyxeAOZCDT2/nkD8zCxCCwUo6W+VvEiVpb82A6/dhktOEmrlYLrLGIgsYd/IHPqTM0yhGouPhZfPb8YbUwPMRB2/M/Q2hm6+E09t/B72b3oBqXQbFyoZHJ7cdMPARVTmeisQQzqygeeqX7TCbIgMKqC4wjIdDL/wFnp//AoCs0u+5ypD/zTlRYvnO8Ary3BJpO7qm8P9m8ewOfMOLFbNFSnVhvDCO3vw8th2Ng9S1l3s6inh8ZuPY1P6DAYH6DaxXrw2vxnjFav71o2JzrweC/YiZWYY18LUFZi0ukmlgmUbfW+cw8DXfwK9wJjrupOy9R9OenptCa3CPIa1JTw0ega7Bk4gaZEt+hS3U5hEXOb9Uj2OXDUNu2XBDOURN7KwQg0ESbaq4XWYwiCmKhH67I1bXSSghpAK97NG9HDNzq7G7TYyEzmkf/kOEs8fg9bi9XqNNZOYqICy42+OeJpdQqw8hidvOoFdgwJ8jn5n+5lN+u14jNSURbZa82CT1bVdVjuJepI2TVglF8prGcwog1hy4wxYidKPJ0HNQE94kIaI+7QhvljC0K/Oov/Iu0wWJIcju6A++hjzawnuoZ/CO/U2lJ1//YoXVQt4rPd/ceeGXyJhzsIIMVjJNUzWiTCHaZLuMovU6h6qbM8aDcY0c3222YMqq16F3XwRcTB6mOUvVd1V24t/dk+vJQbnGVQz6F8iaxybR+K9aSROT8KcXILSm4H6x38B7e698FpsA7/5j3APH4LaCkahBAyEIwlSXlY7NgjxuIJ0GhwKenoUWHTfaBTo5blcW5fWEExEMaEMYRxDuMix4CWY5cnVCWTtEFbEePNrtHhqx1s7ojsukqUmRqbKGD0+i9FDJ7DlJ29g00/fRP8vTsE6P092ImxSg0IAnrhMuUwFhO3ysvnkwYOsDqjUYkix3xzozWEgU0WCVS/AjCiusyJSc4Ks9iE2Eg01gjOlfuRIJ5pC6vhcWwaf8cF2AcvRB8yjDM31YDXaiFWaSM9XselsFtvfXsTW16cx+PIYIhfzJAIG1+UOSj8p/i2+y6BSigV4p08AJ94Clhc7eT7YqrKSTuLm0Dz+cM/PcPuGXyNqLPudksaAFU4jUFQ2IhLAUjIqpAmnlzfiaJ4WpwuJAk3eaTJQV1KkSqBBGY4UQRJaBqBVbmF4sYbMXBXpc3m6Rw7B+RoUyecRbu/GUSg330reTaCnCHLinD9XJwBpTT9YxSy8lPwPziwnBBdksdobq+DevnlsSS4hGc6S4U37fF3T2LCEjpO3s7qqLGbCNglSCNpkNYP5RhTnaxbO18MokA/JpCabkpGcjRFaeD1dI/0BwZ5cRrDIbecDUtlX/SjVC+XBJ6A9/bvMDAwsgnWf+xHcH3+/+8CVovT8a9lzuwxOPjGENRcmO6MguxaNvayA9D8asU9VlQbnbJGa071CVTy2bga39J3G+sRLLFYT5CRNFFomptkGFt4MYvsPLiA6T6ZIi+st7iKPGl1G4W58WJRtO6B99W+hrFsHL1+Ae/IkvBcPwXv7ze4TV4qy/iu/8pzkCBwr7X/q4KXOnY8QYdcmlRswWK65O5/OHMcnhw5jJPE6lV1GrRKCTdeM/F0B2gfcZvtKsFfIwDDUzz/DhM9de+sNussFePNzDFBSk2uIltp930G1UYJGbqPVuVizzBRUY0Fg882jDOEwfvvvfwrpkCTx8WwrhOlaAgu19f6QfjMZqtPdSOpMG6pF0GWOIsdH9+1MTXTDxQV4778HnKHmiwRuMydfQzwrCu0TD+49WM7Th6uL0Gp5qI08dB410gS9ssTrHPUcVBYylW7lBxb5hh9AvihYbBq4WF6PxeoAdHZX/dYCIqkslE1UVurVNMEvXMf6BI/sIrPIArudTiq8mngGKTN3qbr7Nmh/9qWtBxfLvNDSGMislnbFV0AV8OTzlr1IXj8LtTSPgEef1VlddTJMkiYBviIN7sRMKYhcwcIwm4otfW9CYd+q9NHJpsjNLzBDXM/6HyUSwPEY7E3bULrvYWQf2A/tO99oHByMskuqBFHn/DoD1uDiRqCNlNXElp4yhpNsMghaY2DrfnpgsxCIkHdLjFySYKuIQIU716zivm2vcZeYVpkLPPnuKNafuY71ryUsMO2ohdo9v4XlRx5H7tY70OhhdmrVe0godTbcLPel9ciVMuQvBjsaG4noEvpSE37WyZY24PDJp3D43C14v96DutmHsjXQnb0j0sxI57XNHMfXnvg5NqSfJ7mr+lZvf5tl/T+l5n5MIfBWphfZp5/A9L49jNJ+qG2yQO60dvArxkEBF9QdRM0KemOLBDyDdHIOqWiWPIeMkZzdMiqImyqmyuswtpz0562HySHWiMbA1tmRhd0qhiyFNPkY32XQydeD83Sdo1IxO8/eiNS3b8LSZx7G1IFHsXTnLjixJFQnTPCdrKi6xxx4Vfncx95VIyELVWAaZYR5lM98K14t94Z6T+GW/jF295IFruYCcs1DoxXA6dl+NMn5RZQwZ8kwctdfJw2LX1thlG8bxcznH8HF338CU4/eg/yurWgkWX3ZYSm0uAAXUd3nCH6iU26vJ+FgFkOJLAaSLmNAfie6XCSlKu0mKYmCXE0+tDKtij6SZddxDF0JXr5OO3EL5Z0bMLP/DrzzuQdw+rP3Yex39iF7zw6owxYss5t9VolSR5is+W/lxgMpSnociYXZPHdcZ61I3yu9rUqqYaksLl0O4otsgrhPV9oBDYXBBMZvGcTZ+2/C+0/twztPP4STn/skzu69CfMjGWgxoD+8jAwbHqkunvDyzuayv2DFV3+bPeKGy7PGR0koEIJuJlG/Ajwnb1TgVnP0/Soy+jiV6AYo13RzJG+LEdSSKeQHEpjalsbxR3bgxWf24OfP7MPbj9yO8U39TATS6Iv68smnxUpeYzNe5w56aDNVu12DuFREVR8neHL0GxH55FNmVS0yG31YxGXUBplgaQ5eZRYx7TwzjTBSLmSrqOb72GntxanHnsQLf/4Anv3yfvz3oztxdqQHtbB82uu4xFofWG5G8V55COeqQwQtHVzbV0JEpYLi/Tcs1eYWHF2+BUdz/d0rl0SrFwm+RNchMW6y74xfIBzGE9eare/G88O/h2989gB+dP8GvDWcRMkKkPsrZKjymWPlo2pXqLFQkAZbzbxjoOSEZF/JYG3uSOennoZN+vHWzJ+g0Lir+9a1Rb4ivzr1KRyZuxtzzZWPoJdErZFC0PLCSAesAtPseVqn89PkdLuFicQkaqMnUE8toMluzSXwAIFHgzFEghH/OV+obKf9ljV9j/M/7orLOJ7Q8DVu8833nsYPz34BJSrgeleCEhErTBT24/DsgzhRHPRJ2VqRL2ZaZZHg2ckaNnb2ZRGLkC9pHlpuCDNNDYsKA5nBp8gPb6zMVsBCr5FCnOB14Uor4uPugvf/JVACtrmGIz8R+Y0RhQdt6aGvH1yuZzAYCiJEmhtggAh7tJ00SvZWZGujOJe7A/8zcQAvzt+KOTYdlwn9MFiYQCB3HlEnh9F1i6QGZzCSWUAioWChuQ4n2S4u2CkYGtOeFkE0EPNBR9k/B+ky8qljVXjqf3SiQjqP/j1avdasMA2rsNoR/+f7lsN4kk4qyq2+N5bFJzLvMo8fQUgvoOFkUG5spEv14kJhBC8tDyDHYPV/Y+qKQuBaeRbG3Elafh7b4nN4eNtp7Nv+Jgb6q+jrU3CscDuOFTch20yxiTHp3yaPrJJCr1dMu1Y4vc7+NaSF+ByTCR9yWLUbdhmWayFjDyDcttBskESutIEfV/zswiA1L7zCYw4RvYb920/hiZteRzKyiPX9CqIpCy/lPo0pGkG+9fi/RfqjWyWvC16DwyCt2OwzGABRN9IFT1JI2B8r26wKfVAl5w9PvMbjMl3Hwd3DcxznEAnR9zlrIEQeVL8L5XaaPisWlB27tGtXBb4qa55bI5JlVl7TdA3/D2b6W/vk9bEgAAAAAElFTkSuQmCC")
bitmaps["TurpentineB"] := Gdip_BitmapFromBase64("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")
bitmaps["GumdropsB"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAAC4AAAArCAYAAAAHdLqEAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAnRSURBVGhDtVnbjhxXFV1V1V3VVdWXmcS2BhxioQQQDwgJJHCCQCIC8YLEE78Av+EP4I94QQHxgvJiHhIIWCEa2/FlZvpaXffDWqeqxp3JeKbbae/xcVVPVZ9ae5+1196nxrl9/08Gngs4DmQeXBz1YrwXv4Xfjb8H1/MwNRn+mj/Eh+kxvqhWcPseQqeH73uH+IHzBm4hxNwp8GkxRf6/NSYPK7z1wODmE2CQ2mn3bm69TFEvOHTkcJMMg9zg0AkQeD34DkG6fUy8AYY8oq5RpwXWWYr/rE7wt8Xn+PPqAT7MjnEfp/jnzTmejXIkoUHZa5/yGsw1RQWTFzAEY7ICFY/peo2TZIFZvsbK5Jgx4tM65TnvqQic91cpf5+u8Hl6hn9lJ3iQT3FarTHzCzw+yJH2SkbFtI/Zv7kwnFwPYCR1XjsGXHB8sn6Gv08/w0fzY/xj9RCfpM8xzROYsgI4dKzKEllVIi0LlHI+L1Hz87MoxbJfoMbrA+4c/eVeMzsp7vh9OEEfrt9DQJ9u1AFi18fCq3DmkR4oAUa8w+MyL4a8PnFJK7eHBBVOkKIsCvz0foSffBzh6JT0eg3m9hwmJs1xXQvaiQMg8pGFHo7dNT5ePsHx6VMk0zmwLprVaU1g7wQHuMtE/mV8B3eDI9yis55x8PSwwOmIjr4mc2/0Y8aW4SZwhrD9dWv6yCFeG3K6ZuIqJ6zx3puDEe6O3sZvJu/i16N38Nvxd/Gj8AgHXIH5qMYi4uq8JnNvDyZ2yS3HLX95FB14NN05uW8U6YIRXOf2mkNJHAcRhv0Beq7HFXOg1Tug+gy4EunAYNUqS30hHvswNzNMNJ4YApeqmNULeTSKsJxRAtt76IASUw5wKaTdJyalzudYUHHOqD5Py4Qsr5ANHEzfBJ7dApaj/YP3Rn/41b1VQYACp3+ihQXXqEcH+kvG3zlM4LLnoCLDUlPiOaXw3zl1PPmCCZqhCFyExseg9mA8B+EaoEJa9u1qLlfSJZV1dPjD8MEL/vjBvUoR7ADqKFpcBrgzXndIr9J3sXApf4z6cbXAp+UZnuQLFCo8dEzFy69d9OndcMlkzgjiimkvM4EN+gEGpGS/51vgFVniVgrBrmGgU0pWUSupCjwyK/y3nuEJBbPweF3z8Z7Ur7EMlSP0tRGvnc0n2HE4xkF8iEk0wXAwZE71VDlLPmPHMMgqgs+4UqLTpmmxeE3XU5dc5xBNwoT+7PgYRVeRjoKYIzofcsat9XBO6PR7cAZcCi6xFOI6s8lMhakVeVVNOaD2QfnBiqqAlHVpl9UnRSquhBL0FUJ0qXEBm0RzhwO4o9AOJwq2A6/Vss0Zk5s9Tk3qNK0DLzIHTN9FOnRxchN4+g0mcchLLWWUI1py3/PZnFJOL+GrkjArMyRsNTTW2ZpqTDqyxaCE8yuK8kDlnkdVTw70RNZrTPKo5oyRtyrUtQMqZmyVDUfBqZZD9j+HQBI3kZdCDPohxtEYI444IG/ZiV4GPi8ptWs2fKsZ5usZlunSrmTjvwqQItwNfdbYwqx8kiq2OLU80Go5lEDNXnnkelAj93kLnVDE+2yPY3J1zGRT4o3CEYIeuyM5fMGqukKqLpWAV+xGs4IrbGomZ1sRbVERT7uhJd/GlNiqsl0rINtwXpUzIXD2afD4CIdEF0U6iXshdVzplwRLQBVlDZ3LbFsrdTDnm4kMtZZe5X5Ls87LWTlho81C0UavpHCn/RqDVlnkgLgrJRMIDZ3vqmx2dimEdjVGSaYyz77agrhojIgFdDEyureVQEfd5sb1sqeepeF+U3wMxafAKks4Vkh4XGZLUoABe8kqi/v66Sqn7AWp5LUkzqrCV0GrqXJDyiXbXleJbPep7UV9t/u+lnLj+xXFWxFPmKDLoRwRs0oCXuFscYrp6gzzZGbVo6PBpnmsvtLuSXxg82HgDxon2utXm5Y+IGhJJoczpmRKeTaTSWDltJRGxamNHltz5H2D9aBGwQTVZzlZaufERJO8STkuAy2AAqqKeajKSfAjglc+bAXccpYR14COkk9bqBT1F7SwqsJhi5GkUU7wckHgs6hiYpJK7WLwigUr1bgMdGfqT4I2ibtEtpVzc1lfahaQEG0cr7KqraCiDoGX9Hc64h6VJLcRb2+7zjqVkWMalo764dFVVK41AZFkSq9znkuFlMAtHRr5a06taUrpuwYfogZrFXGQ43mr5duYvpszadM8RZZnVsNFLSWyq8mvC4Hkrk7Iw9ka9TxpBnsUmTbWrvjuMawvmceQHxk7xbV2RAK+6eQVpugKqBL4ZPkcJ4sTTJdnbeUUH69DLtMysXmyssloW4GiwjjjCK4dTFg6cR55raRGu7yFywCxNrglef5ySn/F9N28yq1sygnlhMy+ENra5B+B2GGTlLLoM9JdsupcvNToChHPDUfmsexzaJJdNxOWbh3PLQhO32X/K5mia4HyKJ6rMbO/az+3Tmj2kj3LbFjZ4z7MJmfD8x0n1HeUqF2P082hac6HPjcfxPOzYYmclXQf1sihyvWO88nZes32QG3Cir2NuK/+pgVrFUWS2A1SMuFuWZK4D2uEiXLXRGYHEzjteNjb2BdFF/sbAdfrDjVsOtIxPyW/6ds+jMD5sFfluMBbsBzi80UTDeVcq/lDamFvxxcs6lVUKTW0U+qsifgr4n5h14DpfOPjJKPbmkDH3NVPogO7y9eGo++xENC2rGFXWKcqF/BoFxnwwRo6l23K2XUmGVUzNRzE9pWEQA+5xdNOSc5/feCXmF4EHfWH+E7wph23+jGj5+wEXCZqKMJyoDtqbyrbO3CR4VYvxo+jb+KD0bfxi9Ed/DA6wsgL2LOwkLT3bWPaWJSslBXFw27deDyvnPb/PZkIoWi/ExziZ/G38HOCfn/4Nt7n8XYwQR46KKjj2/QqtsFiqdcGWTsk7e5X7U5Jq7Zn4I4Frj90+dwQ29+RInrtfOhHmB7USP3tyaLoLtOFbay0W5onc+uMjAWI3knHu8r3NUyQclPhUbXEk5pbM5PhrM7wuE7wsF7a3f58zI6PLa5RL2PX6GoTeIHV6Ggi8+Lfv3evAU/gHHaqrs/Yxnhft0NSr6L0y0yJpVPhuVnjQTXD/ewZPitnyFn2b+QRDk0I6gP6FfsYPbc1JaN9q6VnXxPDBrhMm4K29NvXb9uC3wDuELiepz8WzOrU/jH3uJjjUblAQkcMu8cxQrzhxDisI0R5zxYn8VkFJvRDhP3wXDku7vq1QtrpK7pf5jhvtBPpRegu1VS3btxeUfZmxRqP1jM81mszJpQcND0Hywl3QhM6OArgR2Gzf2SUBVq7+DGLjd5waWev6Auo7omYI3EQtyPG/wFq3+S0Cg/6YQAAAABJRU5ErkJggg==")
bitmaps["BlueExtractB"] := Gdip_BitmapFromBase64("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")
bitmaps["RedExtractB"] := Gdip_BitmapFromBase64("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")
bitmaps["CloseGUI"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAABkAAAAfCAYAAAASsGZ+AAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAOJSURBVEhLlZZZSFRRGMf/985ojVlpZTOaSEVULwXtPRTRhkQ9tNFGRQsZhVHZKmWaYKaCYkqBSFE9tBpBmxXUQ0RUtpGtSqbl6JRNY2rjrLd7jh8zXu+d5vp70Pv/Xy7/4Zzzfd8RHE6PJLndqF+7GK7PH6CXyOEjkXS2AoaBMeQE8bU60Ji2Fc4Xz7gW2R8hMhIJeScg9jVxMxyG2EFILD2jGcAQTVFykp8UhTAiR4xC3L4MUqER+vTFsOJyRCQmkdMDSUJTxh44X1eR0S2EEbNsNaLnJJPSQBAQn1MI0/gJZKj5WVKAtrs3SXWhCGFYMo/DaLaQUhK3Ox395y0gpab12kXYT58iFUQVwtY5PqdIfqN8FbNiLQat30JKTceTR7DlHCalRBXCiJo8HYM3bSMF9JsxG+aDWaTUuGo+wbp3OySfjxwl/AjTswL2QcOG5WDHO+nMFYhR8onRwPvThvp1S+BtbiJHjfC9slKKnjWXpBJP4zcIEREwDtXeI7/zLxo2roDr4ztytBGqpo2Thl+thHHIULJ04vfh+84UdDx6QEZoRJ/jN5oOpfHz3Rtsx4/qCmDwjf/79DHs58q5oYff58vhuHyeVHgCp6ultACdH6pJhab9wV38KMolpY9AiOTxwH62jJQ2XlszrOm75P0I9iU9BEJYLzIfCF0LDNYJomfOJqUfHmIYMLCrq8rdNRzmI7kwWuJJ6UNkdTCsqIzPBz2wH5RwrFj+0kBOeERLdgFMk6aS1Idp4hQMTkklFZ6QbYXhrqvlc0YTuRgbNq+C81VwboQisPE9YTPh68qF6Hz/lpweyMsVn1vMly8cmiFsqrHpxpqj9cAO+Dva6Y2SCEsCPwjhUIW4v9WjcVcKD2B4ZN2cnc6ftWBDjE3U/6EI4beM1I1g/aw7bOlar10ipYbdDULunUwghFV84+4UuOvryFFiy8uC+0sNKSXslpOQV8JvPVoEQpoz98P58jkpNZKrE9b9qfy/Fn1Gj0Vc2iFSSnhIy8lC/Ll9nRv/w1X7GT/ys0mpiV21HloDUGy9UYFfZSUkw+OouIC2e7dIqbEcLYAxzkyqC8Oa91VZve2q7GYyIHmRZo2w/fE57IoiFSWvlx71429v4/XT81uf/Res+7ar7l6qOtFLZ/UbtJTkk5KPubyEdUvno+3+HXKCCE/HJPZuuHdHvrayBtv+8D6fmNoA/wAAsUEDijY/VwAAAABJRU5ErkJggg==")
bitmaps["NoItems"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAABEAAAAQCAYAAADwMZRfAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAECSURBVDhPzZPNasJAFEa/iiCigrTFUpEUF3bVRVvaV+n7dOGb9Gl0V4g/1I1IzThZhCZpMGlMnJnOEBoEZ7ryLML9BnK4c29yNhi+5ijxfGPhybJE/Z0k+Nnt0K7XRQ7jGG+jMc4bDbw8PoizingewXYcWQHNWg39ywvcda/liaZkvqFIs0wm4L7Xw22nI5OmJE5TLFxXJuCq1UK1UryqJeHYDpHVXyI2M20JDQK4YShTwZRs9CWccjd5nmNCiJnkg1IkbD6KpeeJlRtJ+IbmTKSw17+rN5Jw1JX87RYr1gnHWOJFEZwvX8xCferGEs77+hMzthXFwX/HlH91UuZUJMAeBfZhd531CkUAAAAASUVORK5CYII=")

Shrine["Sunflower"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAABEAAAAUCAYAAABroNZJAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAALeSURBVDhPdVRbT1NBEP7O9sallltp6b0gAiUtgQZqVKgYjYmIGKLxRX+B/j8TfwEmioJWCFLgAXxAKhQx6fWc48yebaGCXzJn98zObWdmR3v18rlpmgYM3YRhmpB7wyI6kCujvd2Fet1AqVSR/w2MjsQgWEjXDdT1Ogk1SCeeRaapwe3uQAcZ+ddAZ2c7nixmIViwVqs1FeUq9ybsdjvCQS/8vh78Oj5TqhaE0DCRHEY45IOoVM4NWMoGNBLo7b2GsdEYUqlhHB2dSpmLCAb7kZ1Lw+GwW5GwIhPnxG63ITDQh7uzk5iZTiC/s4/jk99Skb3bbAJebzcWHs0iGh0gnrBywglksIEghX/7VgrhsB9ra9vY+r4vzzQNcLkcSIwOYnFhDpMTI9IAw/oS2ECEFLMUQVubC2/frWD181bTAS+aJvDm9QvczCRpT1YVpBEOMRL24eGDDEJ01w8fN5DPHzQNMKRMxK/+WkG3BCXRg8zMOAbjARSLf7Cz+8M6VeCwff09WH56T3FaIZxOByIhP0ZuRHFycob1r3lUq3V1zFfQ0N3txuLjLGLRgOK2QgQCfbIKgoRzG7tY/bSpjixwCccTQ0hPjSnOZQjuBU5o8fQPvuTy1Hjn/cBRdHk6kZ78vwGGSCav051BHVnE4eGxYlvwkIGlpXkkEoOKczWEz9uDMnVtoXDakguXy0k9Ecd0OqE4V4MfriwxJ/Tb5p5kMmw2G0IhautsWnEuw+Aup6dgGDpEoVDEyvscDg5+ykMueX9fF54t30c8FpS8i2goy2dC3V6jVy9yG3uU0G3ZkQwHlTxELzMeD7Z05blnHhu0N+qo0fjgCSDW1reauWAVLzXe/Py0LLkcSqRQp4pZM4eJ9mRAJ2MGDalKuQxxRNdpwONxYyaTomsEyCt7JlJedbq7XDka5pNhHmDVahWi0RdOpx1DQyHM3Zmi16bJsNlbw2tTmQeXolK5RP86/gL/fI+zFmHXowAAAABJRU5ErkJggg==")
Shrine["Strawberry"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAABQAAAATCAYAAACQjC21AAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAMUSURBVDhPrVTLahxHFD1V3T0PCaEYoYUtJ1okkBCy8c47f4FX/passvcf5BNiMPbeeKUshQyBICmSwGEEHo+FHvPod3d1VeXcGikhwYlIyG3udFd11alzzr09ar7zyp9NTvBrPsK7fobTT3sohhqeF7TCTYTxP4SslBXq+72nfm5S5L5CA4NOA07ftv2P0M4j6Ty6SMEy9Ymb4EOUIo1bNLGH/Vdg8qvQJpoklmq0hb1Vzt+FC2oolViSEhz+P6HISXVObF9e/yUCCFN87DUWW6Mc6ru9b33pGzhvmS6Iv6H/sViCeHrFYhiP9VmLLw8X+Pwkw2pmoA4PXvsDM0K2OMd0NkYRd6yYePNnVAGSEDb92mHjosbXP8+xPSowrBxiVlrpCMqeHAVeZv8A5csXsGdnQNeRJY0gyF/ZCjuEd3LC0iwdRdC9PqK796Dc/j6LzD4aj1Hv7MC+fQs/ncITVOZD/g56/SCASQK9uYbosxXOxvBpDBUNoNrd3QDoG/p4dRUY2uNjuMl76ib3IgUSYcKGsPSCbJQArq4g2V5H/HAdnt6Z3Skc/VT1jzvCnZsJai3QtvBlCeQ5WVY8dQ6dVLBjHjgu4KuKaxp6RQU9Fudej+tb2FEGVxkeGxdEI4gjGBlJqJj0hwNEGxHiLW5oE/g53zc1UBPQ8b5Kn6sC5s0Y7U8T2Is5XJpBx3cmUD3K6lpuaAAy8AWZlBmlMQdk2S/hZzO4xQIuT6E2FZJHm4gerMMZMqciy32urqG9odEN6VdNkOopFWnKwizQnaYwvyxgjujtjGBk4LKcWcLNmXkNR4ucIVsW0dEyVb9+7n1B/0pD0PqaHYGzjLngmCALeb6eN1SSsFU+6ZGZgZtyj11+EMGu8tkPHqTqy2upkgImLKUwHIskL2ukYNJO4jWb9KarJMIfBAc6bJzT0OlVaBt3cbFM9qLlvBVwAjppKwGkLEdAx08vlHCFBby/Br21xqqzwWHYP/kl3CVBzs955zMLYHmQI8NgOMG8MewEAknPEieA9WPE32xi8OQr9B9/AbUxxG8C+zEdPtD6pgAAAABJRU5ErkJggg==")
Shrine["Pineapple"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAABUAAAAUCAYAAABiS3YzAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAMiSURBVDhPdVXbbtNAED1e31KaVrQPBYQQ4gFRxC/wA/w74gUeKIVeQG1Jk9hO7PjuXc6snTaUcFTHe5k5njM7s3VM+sFA4Kx/dgDvPaCecaz4cFv/ArqPHKaoawdJ7GMxD6CUC9elPW26toAxHcfiJTyWUAho4L7m8OkwJ6GJSXjCdwatDZaph2gewqGPHxxg/PgddvePodxQSCzEc8BoIHzLsceHXqZmlD/5nqLTGlWtkDJKz9Ek9eD5+3C9MfzwwM7XGEhJoJ7zIalD8jXMgqRXlNWgbRXm05AyHVo7VrYfHlqRumvE2LoISCrLPl/MobPbL1kDGppbSo5ICCwSD9XK5RopVYDR7gsbqfhrXfLDmuMeZCChesXniFNxEkLJZQ7T/aaDRrr0kS8pj8sSpVIhwtERJSsuaTRVBKObu1gV1BNyHdN63BPKCdAQekHDGcrCxSp10TWiwLGHEz5iqhwGIFF2JepqDm1aznqQ9A33DjmUchhyQwPdniFddIgmPuqCEdkwFGW/xIikjv04vUhqNA+0N7BgSUn5kJBRwek3tK6QpxMsmce6cmm/joFiSdDPBtImtcSbIClzRalWsjU0zFGMOALqciiOAYbRVIXkWRT1kAAkn+K3BnXJQkU+nqTxKDtDFp9bwvsI1zBo6yVzHGM+mZPMbKq+A0MpSCgltWO/lSWnSJOYDr3BQ7Rtg5PP5/jy6SuiGbttCytJA772uKcoO0E8vWaBb2cU/ySqcfHthnYJDzLbEN2ja42Q8s+RTimQTH+gbVhv2zQRsryIWhR5zY5yEYYM6IGtclnHcAJLsph+p3S2JIt9K8SXdmXRWXsv8BCMAtsA/QH3kEpT/YlGKFazf3p4EwMnFfVzRW9HKbj+eLih7omV7nKskkvmMx2W/o9V1rFlO7rzQvHkLnXZ/3v9nbpRKKpaXbCvrxjlEMIWSIQi+/y0REZSaRJjSgYyQ1MnvBalowZjQhXZGbtGbpntsgWyd3tdY3pTk4Q551y3OYrsAuXqkhcPy3KDVVW5ED4s8r9R5BrTSYOmWTuKvWY3lVQo/0Y2Dxf4A2XXyY6xhjwCAAAAAElFTkSuQmCC")
Shrine["Blueberry"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAABYAAAAVCAYAAABCIB6VAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAMaSURBVEhLnZTpbRRBEIVreo6dY+21SQEh+R8JAEJEQCBkwB+HQBIERQiAD/aeow++6pk1a9nChlq1eud6r+rVq04+fPkWJIYTGfYy7FayX97I9vaH9NtlvCfBjq/8Q5hxA9s7Cc6Kt4PYvuPSx9vjK7oSvXh2TMCAeAXtxQ292GEQ77lneJzmkmQzdpYpwM+mz/5OxBtI4Aeq7WKm3X4vlqwDPwNoXlZS1PO40mouyayRJK9GoiRnHUjuExlSlNC3Ylv03W+lb7fw9JLwXl4UUtaNVM1cqpNT1pmU84Xkzalk1YmY8piESpI0QiqJ8d0uAnY0rd2uINhFSZQ/K8gY8IKsq6qWZt5IfXrKOpOKVUKUN4upkhrscpIsF9PR+XZ9K/vVrXSbpTiIAsDazCQEMoc9NZJmmRSQVGUpdQPJyYk0i4XUi/NIMpufSaaVIJkpIXr96WvQjC2AHkkC+mqYnEyRoaxrmc1mkuU54DQypVx0VcPocrjHOUfDrTi+9VZ3K+nZxftLp7r2+JUGRs8GrBd/hIp9tyWxggS3JGkWl8kzjJNF2TIqUumyYibp+as3l8G2UGumWOyQCzIE5PBkoxk59XnQ5xoAK3gkSOMykKhchqpSqjPBAYqH/4AegmvXi2/X0q+vZcckbm6uZLv6RaPXMtBkhz2jdOp5ElHfJ/QjVvHi4u3lhHQ/yC54gAesiEyO0dbh0ewVJwLFqnQ/VEKzp38Av3sIjMZxCsnKAqwuCTTEx5Efm2Mt8ui96SgIEKqTxuUfAybTCdRpM/lobChZ8YEC6HniGHs7dDJ0OrFcK4m6Qo8DnYOXHz8fCctfdB26lm03gkbtj4PJMkwZQ6DniMmKaM2U8yTNsaW6gmudvykUVDPRg0hd8hiohmZOw9RJPTaluZYh6ze30q6uaPJP2Vx/PwKmVDW4NkoJHgc9hBaJliqRQy4aG7rNSLJbygAJwADoQMRssY+C3nX5qVACfVd7wHdKYiGxO/UxpxtLBY+g2tX4wb/GgWSsxNhuD2iHDADHQfkf0IdhPN33SAA6mM+V4KkQ+Q0JqglLApEXwwAAAABJRU5ErkJggg==")
Shrine["MoonCharms"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAABEAAAATCAYAAAB2pebxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAKNSURBVDhPhVQ9T1RBFD0zbxfYJQQWY5AGowmliRUatdDCShMb+RkGK01stbKw8zdQqY2lwdaYmPhRKgFXNECEfbvwPnbfvDeeO/MeuxGih8zOzH1zzz1z7x3U0tKSxQi0UtCBRrNRw+RkHTWu88LCmMKNKB4gGxSgCUlzEdHcbdTog6mpcVy8MIebN865ebY1Aa35oYSlg8kLfPq8g2fP3+PHzx4s97Wk7b6rl6v37fVrC5ieHncGDxE3JBEI0X4YYeXBGja+d7i3yIoA4fkV6Du3FkcIqpuVBCM8BZ0CVWC/Ew+PldDHLEegnY55bpCmCQ57Ie49XHM5saWP1XU3k0TCeaOq1laSaBBHB4iiHkeER0/eYXs7pr0ksAqmseDWJBF43SLZOccRkiRCZnJkWYHHTz/g23qIJM1cLtzZoIFk9qpba5FrTAaTZZQdO2dDm2UNxWH1xVdstHskMCikrkShJtA9s4yi3nJ73e8n7s5xysgkknMSTFS1tw7x8cseDg4HR9cQgnB+GfnYKbcXaJPnjFD4VIg3h0xsA7x5u4Xd3ZjkOY9asDPQnb9LgtPeu4RmDsvIcky5WVSEYYr1zS7iRK7hD2eNs8jqQwUVtAvOhaioCGW8er2J33upzwMNBQLErStQqqzFCLQnKIf8ce52WQUWTq5kcrGWKoIZrkY6sIRTItHc7IiA9q8Y2zsRE9p3+XIqZi5D6Zr3+gv+OuUQBr5hhJ0Bwl7fv1YyZ2yqgaiQ13oCSOLlVkQiny+efSPPXb7wyU9f4r+HMbc+CUMl3Eh1rNX89VWqujNFkyqOJ7QCEyuOnkjzzkFQR9rPkYscz/FfaKUbjkBKV6uPkYg56fZJxP4olfwbwB/YlaF7aaFweAAAAABJRU5ErkJggg==")
Shrine["SoftWax"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAABUAAAARCAYAAAAyhueAAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAALSSURBVDhPjVRNbxMxEH273o98f7RpUKH0gEBCCCpx4ogQEr+bA3BA4gBqSwtFVVu1JGmyzXeym12bZ++GVNAinrRae+x5fjOesSWjEwUlIZMB5OISUAmiKMbPVhfvP3zE7v45esEMwSDEVT/iGvcqBQ0JgdC/h/H6a1h+jRbL2A2pkhEJO+SbmK0aiyjC8fEBer0uRuMQp2d9HHzv4fBHH4PRAlJqYgtSFBHkdoDmCzPXsLVKJaf8ZpymhIpKlBknKORdNBtFPN/ZxJtXD7DzpIF8TsAy/go2fa1ZS09+w9ZhqzgwYS8hpcRkPKDa0DjbtgXHEVirF/D0cQNbm0UI2gwoimGm4wy2WnRpjzhM86SRJDEmk6FRvIQmd10bGxslbG+VIYSdrfwNW6mYv5WzhhACpXIdnueTLFOUQUeRJEzPtQP/xI3HCeGgWKyQuMbQ0y2aJIoStNpjnJ2Psou6GbfGoIlLpRr/rplrwovWCLsHl7hoT5Gkd8q8kMIS2STFraQ6bNf1eEEuCRS6wRSf99o4POpjOouz8FlStg/lr6dOGW4lNWA6tW8Yxjg+ucKXvS76w8jYNCTdY3cDWHuWbs7wD1JWKmNMJDtsIdHqzKg2vJZLC4koYVh/CeVWMluKW0l1eLoUS8Uqcrky5w4PYKMYTguKeQzzD6C8GtP6HzlVdI5jti5Vlis1NJubqFarphLSIJWmhXTKHGvLKnQNWxf68pPmv2C4c3bTnA9HwgtT8L20m4oFj/4ZATvJmxwBsW7vZUpS2J32GTrtU/S6FxiPrhDOpykhVaaw2AQC2/fr2LpbZYktVSl4cRf5wSeokK0u2UTZDdpBr4UgaJOwb0LWSvlsmUUNLcxxbKagwvasI+c72Qqd1QKF2VcUe28hht/4hlC1vgujiAfomhTOyuE6LBZ4rVLAo4d30FgvrR4TOtrJHLnwFNXhO/jjfRLP8Ath6Xu1oJFQWwAAAABJRU5ErkJggg==")
Shrine["HardWax"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAABUAAAASCAYAAAC0EpUuAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAJJSURBVDhPlVS5jtRAFKzu9pw7BwkIECAhEUC0pIiUX0CE5PwY/0CKiBASIQQk7Kz20A7DzM5luw/qdXuX1Q42UKO2x8/P1fWqX7c6ePM8IAR4QG68AEqlMVkHvJ14fFoGlEHBBY3p3dcw3TETmVADHQlJtCw9Trc2jnnhUTgGZQIm1X/+Z2ghXJQOR2uLExkbi8N1iYOVxblNE/4v9MZ5HJNkkTtsrY9jxUnmhcUZVedkjbysSCz5F+jp1mHBcl00NEH+lix/JZNUUhUZ5Wf8Jj43QZ/Ty7oSg7BfeadVwGD2Hsh/InhXRXehbYNpGctt64v3MoFDuzxFNvsM+LKK70LrBqO6JLzXDRiZwDapECz23CFQzKrALnRP5NSgRabHfYf9vkeP/yWTPYjMzmEWXyk8F49S8hXoYcvA1PBKWN7dp9qbLaqNeewCX2BgJ1yQb4n4Gkiq0DG6scFvZAGPeiGqTQICWvYHBtsv8FvacE2tbnP6ccdUKnYh4Q69fTr0eDbk4qUwFL1t50fouCk5pRN+E8eFGtG8rI61gnj54pam4jSRQGwYzj+gvfmeWqxSHBe/m2la0EyqSNozHi/vGIwoN2UHGLfC4OwdsvyYnHIsiQBCGkB8bYKIWBYOD/rAq9sa4wsfCOVztGcfuWhFfI5FG8rtU+1fxCLn1lXcVftjhSd76rJ3pQqzPeGGsPE5xoVZ+rVD4ibekrtPduCYHfOwx3x+fZkfS688jVeiy/JFbd0Gk3Q5dHKeauQkMb/hPaWnEyxRAr8ArJwMjR/+MQkAAAAASUVORK5CYII=")
Shrine["CausticWax"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAABgAAAASCAYAAABB7B6eAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAL6SURBVDhPnVRbbhQxECzb49mwmw0QHiJRgG+Q4BScgPNwA87CPxfgA4SQQAjBV6Q8BESBJLvz2rFnTLVndpNNSJCopOUdj13VXe2xenH4MqBH27bI8imm0ymcdwihexXagHI7w8GrHfjdGYLnvNLI7X2Um8/5W8V1f4Pux0hWzSrkeb5ELlAkSNYsklspYHqy0ELPfnW/r0AvEOBcjWk2Qc3xbObe+RhIKbKeQtnTbDU8Qn3MdXx/CaJA07TIixxFUUSbBCJSZiUmhycxqqKEuW6gBqcCiWphjj4iNHU/cxG6IPFkcoIsy+KEEPvao5gUmOVVrELmnGeWNykwWrhKNFDVz2jXZdBHx0eY0BrfdGU2rkGVl5FcqpF85zmrNQO9bhfGUhlWOW66ogLxfGELs62rGq7qmiw8VgWsMKzmM/1PbtmuD/w3XHBNlQglq7gEeuQUDHsabagdydlkCrKn2DQNniQeTxlPrMeWbTG8m0CzkqjOPaYtMGx+oK1p8V+s0s/2UqxSpPUtbZmh8U3ce083eGQdHpJ8i/GA8Th12LytkdxjFVqMk8waDKodtPl36jWR9Cz0w18Ga5XqjyP9ZFYpLRHiEce5/yI65PPGWGG0NVg6TdpnCC6PeuehP93xOErb6P98gXgu5DRiAaGLIvRuvGGhh3w715DMW8n+ooJ+c79GPmAzBzZGV/rp3vNI2OzBjQRmve/DP6AdFwWy6URjZbQCYxNUnMiC5ilfhuRXkXVm+T3cTKDm18YVWOQg941JEySphedFttsYTFu5DFg9Q8QKCh9wruBa+SbQV9tJi8WyctmmpSLjpcYKYAy+U+CbT7DD2O/Hr85in/P8fnm+Ty3S7NfQ70NJs8/14oKLhlYpRk2SH73IFyFn7PG5FD8l8ZRb5wIkHPtdjA9fI/39DqH6TSGeyPju3F2utIZmCMQesSVjyCjP89zEf/nrwK881Bi4A6zlHzCevKXIcTcv5/6/INsSSjDO+qCCx6Dcxur0PZrDz/gDJ4+WEsb93wgAAAAASUVORK5CYII=")
Shrine["SwirledWax"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAABUAAAARCAYAAAAyhueAAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAJZSURBVDhPjZTdTttAFIRnf2I7jsNfICkgXgGpV7xJb9sn7gv0gl5QqXDTBikpSby7nVljoIWkHWmxsqw/z5lzbPPp44dEYZuMiXBuySvPGKAoPMZNws23H7i+btG2QIDDXfEefnYF40vYXcBnkUZZXpwFRqMNLi8NvM/br8Qj/yHCLE8OBsCwDijKkLe195b+CTUm8ObEsuUwoR6yXkTc3iaEjv1KO6FyUhSBIMLqhKpCLlkxrNcJ25LbChWwaYC9PaAsO6feJ0bQrdDugNZ1l5Uc6KqbBZu9A05OEoZD/m9gOAE87BLKKvBcwHqD7dCLC4PZVACCZsDZGXB+DhxPgPGYTvddfhA4UkURUQxizni1egHltZuPTlblydXpKTAldPIIk9uDQ4PJkcluq8pkuHMRMSJDexkSS1ajBkq2LJUZF5ugm7QEUFMq7isWzaaiMbqbnuRw8GJG1bg63CGuF93v6SyhobPOndyYp4xVU8qFma68ZBGTyU2sKpsdZqUAv/qO1P7KP+3xJGE67VckXNklODlkczyXIUQARZiiZcM4s4zH+55KJc7vY8h8HP/w0SpNhw4OE8bMuc45drFolAROdCmncn7EvMvyJVS7Ggk2cv7T86PAnGJ3QO705jR0rKvy1l6vSKc6Ww3/fPf1wRltbhDbB9jVyiEGQpUbuf1Sblq5Ue7ZkcpPzNZzT6uXCNXyC1x7D5tLy5CYn/a3LFsrqM5IKr9tHe7nIzbUP+0L6uIC1fwzbNMEZscvIt+Wt9Q776VeLBYFFssS+/vDPC1PYOZZPXzFb53XuRz//FB5AAAAAElFTkSuQmCC")
Shrine["Turpentine"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAABMAAAATCAYAAAByUDbMAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAALTSURBVDhPVVRZW9swEBzJspKUwEdCOdLr//+G/oW+9aXvPYByFEjqkFiHOyPHkG68ViRrZ2cPyaTP77rw3OD+scXqZoqHLwuE2wnGVYU3dY3KGKSuw3POWMbEMSFzzudF9DdywcJYSFPuV7kAby2m3sMSKHCTQP6EiCYlNDHjro242gZcUn9s2hclkjBM8SQgw3lFMI1i0BBoGSMimYXc4YGgTyFhTe8bqhhpX0WLAiYkUc2xQg79kkThNQxLBvpe0cNBZYseugrHtcMJU3Hqa5yN6oFZr2FDsMjQGE4nj1yT10EcwxbAYuyxoPGpd5jVFY4IPKUDgnHzzsBUZGB6EK0o1OE9iGb/r8hhH4UdsIpGYSt/gpKYUs190RcZK3Tl7Z7F+N0GXLMYVh9lXEzKhBAC6B8m9lXkXQAqyAOLIJA7FuSRqoqTGYOiFpxEUzJTSwjI8rXPTL12vW1LW9wS6JnAciBbCcE69hinfBRzISXtuRbAQRz7ccJmHpeKVjikKvkzFuWir+Zut4aaLBn40Bx7OEU8kVVBGUrPqWqJk5HD0djJlD8RoxqfeBgIplNBYcQ9NUetyZVaUdlWqHzmfjqnxjGbel54sL9SsWVrEKzuQ5V0NAxz9t77GumjR/rksflgcTNrcDVb4dd8iZ8nT7jkuF4w12LEQvTGPAHgCVBuJHFksD53SOce+S0B5w7tIbAeBWxcRKDzZJUaEuERtJG0YuorElYjmOjgdllPDCeTXccwi9IX74zyU3MX5T5D5wUsbLeIkUvJItyNYdkeOugdvQVvkIdqUNSPIYYyDqKUWO6XjU1swJwM4mqCbjmC75y2IJPJ84R32R5YZp/FEHazV3GOlRSYmGA5RfPtDH47QW0rsuJleGCwmewqupOYmCcy2xedlpo3h0bbfJ/j79cL4OqYVfYiBdVhdQS0PPiJN4gA2rbFer2GItkXgTgnMIN/CLmbrfafZtgAAAAASUVORK5CYII=")
Shrine["Starjelly"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAABMAAAATCAYAAAByUDbMAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAANnSURBVDhPfVRLbxxFEP66d3Zeu7Mb1t7Eq2BMYi6JCSBFQSgghDggBBwQF44kP8F3ruGET/wFfgJnEPiAxEMcSBSSCAhGjkGxHTu78340X/XuCAgRpamZ7urqr6vqqx5V7HxkDBREFAzAmUHDb81hbe0i1oMvpTQ/c3+jZCRjWeDz5WfXZLc8C5dWxNLaxVPB80N4QQ+607E2z/WtygEiamvrY1PXEsV88+NEDnG6DsaTCXzfJ9g8uoDjQb8P1+kSUEErrSWz/9WGWtUGWZqhLCvalLUVHOdFhZoTmes0SelQoqoq+23HbbSt1rQdP3iALMvQNI21ie9sNsOUKna1ublJO2EfkQ7rIqoZeSsdp4P+YGBTFRHQitGJT0ib+uDq1f8iUaROUgfRVmSoOw5rI4QIGNMjoCxox4G68smW4fTfImnkBZDlYL4L4z+kPUBYDRil50J1ScKH178xe2UBVmjRDBRb3YKAAibW+cocQt4yV+iQ4W4YwPE8ApPhT//4zWxPD5ExPuvcnip1FNBHZLFqU13xA6z3IjSs5f2mhj7MYgaRo2IkFdmpWxVG6VDzECaNhiiKp5/yfIyonutijUCXohE2gghLtKkrP2ybTDaxRfLdPTRxsjh7LjoI4D25AofNOeSG15dOYcqob5QpzvYHeLY3QML5r3UO9f53X5imKJFcv4np59vQ7BnPJTOMpCxrVAQIXrqI/sXnEbItNvpDpFy7pwyW+hHGYY8napSM3rZ/PZ0h/+UuOgf7WB+HeOvyOt6+fAbnTxNoeoB4+2vkO/eQM/UfZ8e4M3uIOElwwIP3khiHWYqMZbJg5f4hqlt3MFmO8Nor5/DeO5fw7psX8Mara3hmNUQ3T2CEXfJR8lWxdaSmaZ5Z0DJNYXgDSIrkU8Bno6+fOYkLG6tYHrk4ETV44dwJPEcd9Eh7U5Fh+TX9zbBDnTguXgwGeDkYQtdszOL3XYSOxtNrKzg9GUGbmJsfwndrPBFpBE5jfRqS1ILJD8LhbRjxj3HWC3E+jAjGvIvbPxPMwXAYwXXZ1Q03iZoCbtcg7DYob922bJvF9REwKfrdLMH38RFuJlPofGcXThzj5DjCU6tj/psklcwCaVVhZdnDZNyFlxwjvfGTJUuuW8NrVvCG/BnP8O3RPr46uo+/AFI6zLcnDAuWAAAAAElFTkSuQmCC")
Shrine["TropicalDrink"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAABMAAAAUCAYAAABvVQZ0AAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAOoSURBVDhPlZRbTxtXFIW/MzP2YBvbmIshqmhC+9KoVUUeIqGmSi+q1If+uj72Nf+lahUaESAUStOGNgQwxgaPL8x4Lqdr7FS8lEjd1taMPHuvfVnrHDN88sa6gQFrieKIQdjn8Gyf52d7/Nje5WTUIrGp3KVd/Rpv4T7G8fgvc0y5CY1lbGOFpL7IdbVOu1hAEAyziNRm00jjKlqOCt9ijsn00ThyQ6rXPHWcxcQ2YZyOsfrllnlV4ZXehYXDeKzIVJ6QRSMILqj1e1QS/afRp2aIZu7hlJf0psK3mGPOj+Gyhe2cUmi/wW+9ptkfsBqlFN+CWT0HsYtTrEwmuM0cMxhgLs/hqo257k+6NPKCdmX+bSy3yfs7ZpQ5k1GUaAWQZRlxGtO3MS+zESOR8H/MmTAkAqzjkHou/UKBPS/lFaHkcNOa6MEmEVbFrAiy2nHewM1eFRP+0LFqiWux140G7LUOePb3M3Zbu5wOTiQNJcgSisReg7j8AcNIAJKKM9PAVO5ol9VJjMNsA2oLpKVZIsdo0ddKVFWTaKE3W/IYU0rOqfafshxt0gyfMj/8GT/YwY4HajAVmNixysjUchiH9EY9CoWEpWpC3c8mgDdmRUqelOISU4gvKA/3of8HpInGfBJNpg7CgJPua345+glvtch7n64Q9Nr8ebBNq9Xi4tqoWEYURQRBwGg0mhCW5T2X7hKU1wX2/V85lwx1Jq+uWhyd7JLcn2fx8UcUy77a11eVyyvmQGcC3t7eZnNzk263Q5rqzGh/cWFBHfc6mKCNG3QoDnrMhWOWU4uvbEcrcFwP1yvgieVypcLa2hpfffkFn208ZMafeTu9dKmRHTOpKvRUOhPtmd7dWglTVqDAzFvPu8vNdV3q9Tk+f/SIbx5vUCnNTIlSnmNVNfdUHUSSXFCE4ZKH8XLBilVJJtdVEFwx1GnJQV3Po95YZGNjg/XVEtXClCjHLt8jWblDv7HE8azP7zWDN/8K32ySRlsk4RbRYJNOa1877WqAqe4cibw2v8TdtQ95v5YwmwNSquh6qTGuuQwbY/xlgZUSwvCUy+4Olxdb9HovFHiE68SCydeSi1baK/rMLzYpeZZmWZLJNZY6KbUHLp985/PwWxe/krB/cMnznR5bO4GeAYcvW/x2uE+n02Uc6zhN8SiVy5OLpD4jwvreCf3msW5aKbyaXzMhL34NOGsX1fQq9bkHVKrruP7Hmm2WwWCkcXsTmaQS+TgKpTeJGcs/TGj1NDtDtOMAAAAASUVORK5CYII=")
Shrine["PurplePotion"] := Gdip_BitmapFromBase64("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")
Shrine["Enzymes"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAABQAAAAXCAYAAAALHW+jAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAQrSURBVEhLhZTNbhxFFIVPVf/M9Ngz9owT44kTmERWYuQoFpEQCyTECl4ACSlrNmx4hux4D1ZsWPAQ7JClLIKiZJEosgh2xjM9M/3/U8W53bbjiEiUfFXtnqqvzj33VqunL/6yeZajqmsoBRhjUfO5iaribC6f85zrOMtCpWoM1gz27wW4MQ6gNTdzqD+fHtm6agHGGJhLgLyrUBIgURQF0iRBVmRwtMF428fDB1u4thXA83QDAyzUr3/8Zk1ZA/yzFYGVJbhGVRJUlCgJFUjKLIo8g+KmTycjfPXFTUIHl8oEZm0B9fj3n60tLYEEFQTmBnldoBaoqCsqVFlJ5RaDoIu7uzv49ssJPr6xAcdxGptaWIqyPIH64ZefrDYatAQoCI4M0pw/agJhUBFoSwPXOtjb2cGjbx7i7u0ROr4rJI5WWV2/ocfH0GG6xCwJMYvnmEYzTOMzhMkSqyxCnMWNd6K267lUt407t4bwXOccRpylenPaqMvzkBbkzDYqUCSMqkSumaLLwrBAXIt1G2DLHWBve4zP9nfR7bpM88I3AUZUFxK4RBRl0H7C05b0L2KCLE7TJoTVTBMMyyL1vQAHkx3sftRnhaVlzmliipkTdsbnEkGgoZGz1Nyr+Mh3VEVPWBgJxd+WyQpJGbHnXPp20R4yuMYmFBARmjX/uy4pRcLWSHhSRmrSggyhXuGgb3vowoenSgLrRp1l3WS03i04s1UuK22hT5+d4uzZGdK3ySXYplSXUjkV9/Ua+l0H17d8+FTY+ie9mrKtQs55c4jcMGsNdD5L4GY1in94C16zqicZ8mmOVRgjXmWIVlPs3+ygv77GCl5Ul9lAQDn9y9pOqEVxBV3zfmYJ+26Rog5TZH/HyN/ESE9inLxmo8YZ7u9vE7jx3q2QgkgB5/MM02lGMPvV1lKJdsg9lpth2TqqCZ7GCHyPl/8W72vnSruIQnnuEqSokL5LmwmwsD7P8mGUx9un+fLc9UaFxcHBGIPB1hV1MqoG7rodDIc9jEYer6F8VAroxeRHzMePkK4/QKV6/EaIT+1m2XR4+AmLcVUdj7H8hEmj0VNp9F5Pml0KVUIrMdofIN74HOH4e7xd/5oJvdus1LsD2rlVLnyl2Mja5+xydnmQNLYs4z/a60F3BoC3JsvlNRcAL18u2o/qe8NjSAtpptpjrDE6jQVXW/8Dw+L58xMsFkumc+GtKBNg+7VxnC46nWtNBMHm/wGB4+MzPHkyRZqmTSXbIcUTK8Q7v1Ho+9fp584HgEwDjYI25TBMcHR0ilevZmyPjFB53+WvY8Y9Avfo34Rxm9BDOMP73z1udl8MVsorp3BMxJ1tf6Vpzkp22B5dpjUkZESAzJvcIDE8nzf/C5Sq1kWCTj2D5sVvgSlms5gwRXDAFDeoMoCxHmdmY6XC4qmHfwF17YaesJ/QDwAAAABJRU5ErkJggg==")
Shrine["Oil"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAABkAAAAUCAYAAAB4d5a9AAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAQhSURBVEhLjVXbbiNFED3dM23P2J7xJTZyYsRtI1ZBEGClIIFg4S0SrzzxwA/wBbzCH/APCPgAeFlps6CVYEGCFUGRIqFEa0JIwLk59njGc+mhqm1v9mJWKanc4+meOnU5VS3++uX9/N9ejGFYw+KVD6DVMpxSC7atMJM8zzEej7GxsYHt7W0EQYDd3V2cn59D6xyx5eOs+i5kdXn6xcMiO4sOXnvFx1trCp36Jqz8DGmaTLcnIoSA4zjodDpwXRflchntdpscsWk3h9IBMLg3OTxHJHuSaUlaRJxWoVE0RufJysoK1tfXoZRCrVYzyiLyjAyNCU+b/4+KvHX7GD/+6uBw8A7OkjUop0lGitPth4WNt1otE1GxWLwPwtG4MkQWnVJqs+m7C5Fffb2P37YXIcrvwVtYhee1jDGOZqYz4WdOUbPJjijzLKU0e3Z6gjw8mhuNPDqIYVse3FIFJdJypQLf91Ghlb2dGZuB8crvZyvXh4Eo4ZB5zCwx5x4UKS1mkUScpIjjmNgy8YSNc5FLpZIxxMrPbLharZp9y7LuA1pIUU72CGNOJFdWVvHiy69SlClGoxGGwyGiKCKGpYa6xgAZKxQKxiADcbqYbbP3fIYjUdHe/HR9/MmneP3aS6g4kTmcZRnCMDQ9MBgMDDCDJkli9hjY8yi9FCWnkVPL37Fxof8nXU8/uwy/3oFXewaNRoO8bKDlh2iq72HpHrK4hzGxJgiGpgm5Kdl7BmO9jEglhxR2DmlPiqxUAaq0hIK3hrr6GXV8A1f/jqLehsh65GliPOezLLMaPkkkRj8B8Z/0MfObPaPQpQM4z8PyrkMVSvAlgcmbtP5AH1DT8SkCMrWYUvhJIiEsIOkC4R1ya0SvpkCs9gLpEgiN1EdBBrDFyfTM5UWi/DZQepM8v0b/XHpFBigl0EMC/5uUGMOzKWPtw9ffopJTRHnf1ORS6dI0t7QWoBEGnYXQ6QA62oE+v0U4t6HjA2QJDc34BMPBPxj0D+CmN4gQhwaEiXBBgEnDPiridOdzagbiumpDZvsQKU1T6lxuqiyjXiFPU6LuMKDrgFSIFJ2FPr648Rz+2HPR7XbR6xELycux8NBf+pDYVJqan4jY3PiI3KDScBEFe5QSCKeAU8E0pSf64dWyBFziRMXu4subV7GzXzEgx8fHiDMLI28VUe0NCJsOPSBSmBqklKqYupw1J88JipRC5LlDTaeo0xXaT1VIPQShhSSdNO4sXTS5EBDhIR5nmxh1P8t5hIzHk47nvApB3ZuPUFAahaJPIJROfUZ7OcIoxZ27R/ju7iL2DwNsbW2Z4ke5g1P/Ouz6VSLsxa3KInkG8fCr1xt0P9TNHcEDsOqX4ZabsAs0NiTfgCwa49jC5r0XMIqEGT8zduV2BbJI98tjkQD/AfZm2Fcn2P7yAAAAAElFTkSuQmCC")
Shrine["Glue"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAABMAAAARCAYAAAA/mJfHAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAKkSURBVDhPbVTNTttAGJxd20naJBRUoFQRVdUbqrhx7tP1CegzIUrbAz8Vh0ZCqAmRGpIYJyT+X3e+dRpI5c+xsuvdnZ2ZHVv1P/sFKko1gcZRDu8gw2g6xeNjCGPKqXmeYzj8g+PjL3h4CLBQWwg2P0Hb0Ypytgu4+wY5rzTNVkBSYbjAz6srBEGAzACxu8PNO9VgqgG4nQK6XUAgimKd/Hg0xrfvPyxDKBemsQulnWowAfE6BsojkFzPsIwx6PX78H3f9nNOygqXLVUBxifeBwP9ynJCnuUolhKFYRxHGAwGiKLI9lPdhqnv2vF1MIcPaLy3T4kNYVQgjBLkZCMl/d7vHrrdX/QxJRkHYfMjVH3Tjj+BKf4oy3pFVgVH8rwEe27+xJ9gOp0h54TY3UXqbROzbseewNiyxvMEVa1kFUUpkoQy2RbJWZbh5uaGUmMYypg5Hc7d4EIyKSHKImPoDcZhjwvZFmmLsPRFStj5ZHV+fsFoRDS+AbN1CO2RwbJKMGH1kn+blNgseMyw2YridAUm2To5ObGsUtQQtQ7IqsWFKz5LMPHrhcSBQB5PUFgtEspijlgCOJlMcH19bY0v3BaSxjuqowRZvCxtgXi7kvg3PDXLKqdE+rI0PstS3N7eotfrW98KXYdT47E/A5LScoKKbJ23pURRFcwWFlBKcafxeISzs7OV5FS36BlPcB0LWu9QWot32zDJBrNZSH8Su1DunExOT7/i7m7A6QrGaSJ097i7xOE/ZvowAQ5ihLUQ/nROViHzZSyQvDrydeh2u5jP51wr2XqNovmeTXmF1kv77TEmrXuMFwEXxCsgKTH7kl+H4fCePbJiZsKNI0CyVVE6jjKayqByV8dxLJt/rBLG4OLisnwP+XVI63vIvK1KVgDwFz8AkyqlVKlOAAAAAElFTkSuQmCC")
Shrine["Glitter"] := Gdip_BitmapFromBase64("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")
Shrine["BlueExtract"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAABoAAAAWCAYAAADeiIy1AAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAPOSURBVEhLjVVtT9tWGD2+Nsa0mqCo1bRvU6X9gf2R/cxq0r5shaovn5i2Sa0aKDTQpqyFEBJCspRg58WO7es959pOQkugB11s35fn3PM8595YjUYjU0rhW5FlGYbDIZrNJqIoMn3r6+tYXV3FxsYGNjc3zThgoWs9hPXjL2bOtzMUINFkMkGapua9BN+DIIDWWr4saNuD5d3PBwUqDCMkSWImzpYtBgORKA8oASQbKysr5r0kYpwELrLvHpp+Qr3/cIyzdhfj8RhZsfgmUAlTxo1ZlgXXdeF5nvmO4zjfsDBFcSaq8g0Q6rcn23j8vIKdvUN0uj1RlxZD14M7JlkJ27YNIftKouug3rzr49VuG/9UjrH/vo7ufz1ZkOQpWLCo7CcBG0GV/X5/MdEkAdqfI2wfdPG62sFO9QQnjTMMBsNpHW4D57E+l5eXC9co5XjQmYMLf4I379p4udtCpdrEfu0EzdY5wjC8lZAqaOnRaGTepXoi16HkYoYQ2Y4LQyYu6fVD7AnZ1ssjSWcL1VoL9UZbyKIbU1kqmre89r6HpYSsgJwj5tmG7SwL6x2MwgyfGn2pWR1Ptz6gslfH4ccT+H4wtXVZF4Lv7BsMBkWPwFKI7/0MS85SibkDK4RKHCSW1JmLfpCg3grwd6WB17vHeLt/iKOjnJCWptvYaG2S+b5fxMlTqe27Em8W/oubgWRKUunKiCvqtFH356tPeLZ1gNrHUzSa56J8Sa6cNXP1rK2tGaLrrT1Xo+L5BSwTzHbuINEOTts+tqunePT7Dv54sYfav00sr9zF/QcPjCKmjqa5CQuICshOWVCd2RiMYpx1feweNPHr4x2cdwMoqQXV8Ax1Op2FZiG+IuLkLNPQqRzaNEIc+dDJRPrESWkGP5CgvTHG4cxhNEKv17uFaBo4RhqPpQ2RRAMkE3HZ6DPi8BJpMjbjWjO4NvXwgxEGQ7nzJAitPTODhUwtmec8VGICBxJ4IAFH0kITOGafEGaiLL9s891y1xMhevFXDYEQcaNUVP4CaNhIln8QnqvJUnHoT4mSKFdjVIg6LuPG6ERanwax7GXEiWXUjEOmNL8Vyos2kzM58n4y8+ehDIGoSmNRk/K6iU2B88A8L548eZjZlnhnybL8kAqHISrVEBQ/0V97THqKAopUJWfH3BByJeU3BRU4htQyqWArcl8s0zr/xc2JWW8OXK0PwZxIEAaSxhTJMwcns3HhrPGP3fzif6q5uLi48ht1HdSUW9zEwtNdGd1ldiiNT/MtgeSb8x1R6boOlhxb1ERTIqNmGnAewP9dcL5ijVVSLAAAAABJRU5ErkJggg==")
Shrine["RedExtract"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAABgAAAASCAYAAABB7B6eAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAMlSURBVDhPfVTJThtBFKzpsccDhthBhCjKlUhIHJDyD/xBvopvgSMnBCcQF0AsBxYhIZYgY/C+27OkquNxbAI86bl72u9Vva5+3c7W6mrsrqzALC8ju7iIT/PzmMpm4bouxq3T6eDx8RHtdtt+ZxmzsLBg19bW1lCpVBCEMVrxLNrff8H18zbOpGo1xKeniA8O0Dk5wfPFBZ6Z1Ot2EUeRDXrP4piArZYl1TyGAzgpOsehmSz/cMtlxGdnCHZ3ERweon5+jpe7O0sSkUTJb5n+azQaCMNwFBP5X+EYkgzNzFCKvDHwKIFzc4Nwfx/B1hYax8coXF+jUa+j3+9bMGesMs211mw2hys0x2Dw+Scc1x8ukEApHgly9FkmpAlo7u8RkKh6dIQH7uw3iZtc9zzPno3c931LUud6YtpF5GbJY4YrJNCPSFIMnmbiDMc0d4PbW3T39lDZ3kb56grlhwdktNtcDnNzc8jn85ZgMBi8IeHYGQxHa1r2tRsCTUtXHnaXUtXX11HZ3ETt8hI5Vv6FnaYdSKIuz+kjmyBI6lCDSsUMAQy7JCgU0KVU1Y0NBE9PMCxC1fd6PRSLxXebQDYiUFBI7xG0zepLPNgeR6NkjhG7xby8wCEog22ODrhUKn1M0FUnBAGq9Ar1rBC4wG0/E6jJ776kYgz1QMjvkPcm4q5Eohb9d8gOYpO247gZgdYI3pJzrsorBA8SYAIpxeE8FunODkICq2btIGCe7R4KG2S+MXBCdZgqAWv0Mr04rFr3Vxqrs9L0DDWfpnvaAUEjdRlBdYt1yWSx46Lt/yD+5BNjGkxqMajPCgXo0dVJWXVSKmVbV+BaU23JrlR1Ur1My/1osnqZvdRK1o1OQKc46vKJ0KUrzSrLuSzmqBZNbrhI/hJN6i8zGQarakkhoARM4a99lD6sXi9oItF7ZiIGK0jdErCaUM41VWbndMXYYO7OzWTgpNO2+oTAVv9/8daMwKS/fEAXiXURc7QFaGSwwL2lJT5eHnokUBeNDlnXkwf9mskSCCSpUr+JronmMquzZNQbxGdCt1jvUGKRl4fxZpkzftDAH4nZLhriLcxbAAAAAElFTkSuQmCC")
Shrine["LoadedDice"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAABsAAAAZCAYAAADAHFVeAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAATuSURBVEhLjVbZbttGFD3cRFGyvDu2m7QxUtstkDZBX9ufKFD0qX/iJ/9Y/6AwmiJN4KQtXMdWZFu7RHEbkj13KNqyLRc5woDicDjn3nOXoXFwcJAnSQIYBkwOg6NEmqU4HzXx28ffoXKl50zDhGtV8Li+jZ3lp1itreh5y7JgmiaOjo7Q7fWQpilnDbTWfobdeKzXmG/eHuO82cJwOEIYRVBKIc9zPYTMjyZI+SuR5RniNEGgQkQqms4WyLIMtuPcMngWVpzah63LK7RaV+i0O/An3JyEgoSbXvqcj3q0sYBstOgsYHflGdZqq7Ate/qkQBAENHx47dm49hymu6ifWd7C8mGSKIRhhPF4gn5/iG63j8FggJjyTuIJxsGEnup3NZl4F6URbw0971BWixIKIqrTo4yi0F0yvUIkEwkSLvAnAdoka15cIc8MbFQ34PY9pB3KNOG6NEec0eOgjTedYxx33iOIA72H3pCk80Wcks2DWLpQr6NerQOhgeSS3nxMoYYpjShjF8NPfATJBCpT2mCNB2I2n4xWhmGMN2/f4dWrPylLH1EQIu7FiC4SpGMSMiS2aWOrvomq400lzQvPPoXMYFrLYrEsjhO0KOWHsyZ830cckowGxL0EcZcZmzBbyXg5aaPtt7WXAnlfSmgerslkketWUa3WKKGlAxwz2FEcIokjJEnMK0dEwi69CxnjVKETdvHP4ASDcAgWTOHVQ2Ty0GL6erU6B4lsS6etks1VzKvS9ynjkcmVRqiA8YkzWIaFRmUBeyu7WPaWdcHbtq0LfB5Mx6loIrlKJ/HHI0z8MWUsClwKW4YEP2VSCKmKFSxlYdvbxIuN59hqbMK1K9exejBmQiTWiESDXgfDfo/JwexSlIqeCEnGwOvftERSertiLGKfHm0vbhVE/Ilxw9FIGz0PjFmuPelcXWA8GjJGpUdCkmmSWRRtLIOpTDiwtXTiScgEajab+PfkRHcRDe3hjZfmYNBHv9vhAl/HKGXQ55HcRs5u47NbMKY0rNvt4oQkZ+fnCEgq3ueMZ2ovw7Cc6Tus3Tw3D6XFqGlcSgqxx6VlFZMJJDXE+2t6zkv2bm1uaCVOT0/Rl/bGUGipDRvKqCOo7SP1npCwUrzmVBv5LImgJNpzHawznm3G6G/GIcgKf0W2ulfDzs4TdhlPe3cDA4G7g7G7CyztTz0rpLQMs3I4SyQQom/cCn5cW8H3Sw185VXZeFlTii2LlguZFK60tFqtOn2L5x8qbLzfYtL4Dkb9MxhMnJJIYM6LjSVk3ORp1cU6z6cdkr2o17BkFT2gTBKRTVQpwbRB0HgJw1snkRhxQyS41a5KOFwjRFVaLstlpCSYNUtIEsUaTBkCPhPkjLuQGOyZ83CPzKZXj9gBtimjw/9CMmBMXvsBZbw5sclQdBaOT8U9MonX1/RqgYQSmzEtPxr5eM00l3iVkJQSIjl4Z6b/F/fIVhmXLz2XKW9qr85YFr/y+6RP0rs+SNw02VRgMQ48WPWBNwesotvYdGx84brsDYBPy/+gfMcRj5W75vM2Zyno1jR9JpuZYYvzD7Srl5JxlEzkq3F8XnGwSkIp3DY3+osdYZ5K4o10GvmUuLEjgzF8j5ydaB7MXx6t4aeVRfzA4txjUjwjuUdyab4feFieUqa73pco0j+5SX++Y6byPTJb5CWA/wAa8AkGBgsp0QAAAABJRU5ErkJggg==")
Shrine["SmoothDice"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAABsAAAAaCAYAAABGiCfwAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAXUSURBVEhLjVVZb1RlGH7OOtNOO9PSTkstxQoSq3ElCkSCJi4XruHGxAsT/UteeuEfkAsTY4xGiCwSwFJkKwWhtCUd21I6+9k3n+87Z+zU1MIzc+bMeb/vvM+7f8oHP3yVvD34JfJ6PxR+OoiTWPwCiirl4qOrKrxHj3D/yi0sV2yuiZ0K8kaMiWEXe8s+3MBATx4Y6It4j6BqKlRFQbXqQV32r+F0/Vt4MV/OEMQelp1bOFn9BjeaJ+FELSkX9LnePHJ5k/8S+UUi7gmoD709AYYHXBJ5MIxILsVxgjBK0GyRzE9crPp3seLchR+7QieCxMHl1vdYcv/ENetHXKx/h3VvCVESQDNNaDmaLiHZUj4RBCWBpiVQ1ZS8Y0sQJKhVHahCJJQ/cG6QLPUuTHysBX9JeTvcIOkV3HcuI4x9KJqG/lIeOpV2gk7jGT6qIoRMEKVUKTwvRq3uCjKxOcJKMAefymknw+jLTWK/SiVR6GMjfEDPQgpUFEk23O/D1CNoasyLHvHq0k9kplBmWwEajYxMEDhxU4ZJIEYk77IsEvFSwjVP7hP+FPpNTE1YmBq3MVl2MTniYKLsyHckBGl2iTDW6vZWMj9poRGuoe6vYMGaSaXMQWzGUHUdA9oebtZISrluyiIZKnkksfHUkINCnl5nSHlSw0LaXWW+LIsF0lmOEGKu9Rsu1U7gjnNWviBXRNIVKtb3crMu85OoJpRcv8ybybI3dBrEfXK/WGc0InI7doiHDy1ebeYt7JAR3LRSn8Ni+zJa8XoqyKApOvq0XVSoSmmkaCQrpovCUwojUeJhAteN0Gx6WF1r4/addVy9WsHD9TbCoItMiRWoLhvQ3+TvQGH4DFWUu0LFDC2fE3qWsOyEFx2Sas3F/PwGZq5U8Pv5JfwxXcHCYp0h9BFFEZTnTkylLvBXiVgM5EpEZWXIq/3Ynz+CNwc+5wTJiZKhYSGU6gM0Zs+g1bBQpyeWHcBzA7hOAN8P2VshfC9gOEPZ2JGS7wojeRKdIekiKqqjeKHnPbzU/770TBAJiMQ7sYm78zXML9RR+buN9XUbdXrWbNiw2i6cto2ApH6sw9LGUMu/3EW2DYb0SRwoHMYuYzyTZBC50/P0KEKDXjXrLdhU7jgebNuDwya2ozyayS40e19Be/AY4uFDzHlm7XaoRRVYUZ3/Nr0VUJgrw+QU6S3AbrXhWhYrz0XD70MzHkDT2I9m+UN4k18gKh+FWhijfRrUHnUwU0ElLJK0iVO0ojUsu7ObE6Ubuoa+oSFohi4fPYa1OfIx3PHjCEbe4lTeLeXdUMdzz2d/+SCq0duMrJgky95NSdgN4aewtDgySjIjk7Fm8yUO6SJUo5frqbwbatnYJ71RQpZ+SKItUeXRQO/uWZfoncunzXCKUBaKJZ5XWiZ5PNRhcy/yCqeBa8gwxpo4tTqgATBYeS20ghp7Kl1L4hiebWGjUkHoiRDTQjb646AO6GM40HMMSR/PnWIgy78DQTVqPovXi8cxmBtlNaUKvVYTt8+exq0zp+C2W2xujTN0M/f/BzWvFTDZ+6ps2CRLlxi4PcoAXuv7BIdLn6Gce1oSiwi3Nx5hjkT3py/SK3ESqHD1UTilN9KXd4CqKQYGjTFO9XGYSi9yDOmw/gwO9n0qm1n0mCEMYQjb1Q3cu3AeizPTcBoNSeSQyCodAgr/6cVtIPvM1HoZyqMk2YfdxhQO9h/Hi8V30aOxstjAMeeaU2/g9rkzWJi+BLtWlfPR1wbRLh1BUphg9aUtsBOUry/MyCSJSlt3l6QXg+aYXBQQobPrNRm6e+fPIXB5SNIAn6dAs/wREnNAtsGT4N+mEh4O5cZRNMqZJEVjdQXXf/4J8wxf6HvcqMFVh9AYfIdEJRLtOPG2YMtOkT9xdknwKNlYWsTsqV+xfPM6fJa6OE4c5rfFWScmROrRlsbcEduaFQcBmmurmD35Cyqz1+Gy1BMa4TF07aIohj1Zjp6cCAD+ATVB4WVhWCOJAAAAAElFTkSuQmCC")
Shrine["FieldDice"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAAB0AAAAaCAYAAABLlle3AAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAUYSURBVEhLnZbZbhNXGMf/Z3YvCXa22hCyECWUtAKJsrZFpVUvetVKfYG+QC9709fpRR6ghCJxEahEIYlUJRCiKlgtiaAExziLHa+z9fvOzMR2YmjEX5rMeGbO+X37RPx665bveUCt6WH5eR3z6w2wFAFoig9Dd6FrLnxfoGmrqNPh03Of/xySqQlMZ3Vcm4whGdNgmiZ+v38fd+/elc8dX8MbfRoKL27YHl6+sfHvriMfshQCnulv4IcvNvDz9yv46du/8M35N0joZOFb5PFebnBm+bR5F9ugrL6s47fHFdxbq2GzTCtI5CQShoebFzYxPLhLBngwjSbOT7zG9bNF9Fot49qlKUCPqUBTRQBkj7qERFn4u4H1ooNK04cTMCGImk01MPLBrgwv/2bPE1YTl8/mcaq/FrwYilNhEGioR8XogCbhrLd6WqofDZcifNq4QufQilAMPpGoozdeD+8EUeFcnj+l48tzMZzs06CSAawDbw9JieJ/WKZBIQzWHpIvPY/E13GdCui0iVRShUpu8+MI2BUanjvEr+2UY7AdnYqiRQgqWEOjqYV3AiVNgZihSGC7ukEp292hDPrndRJ/rmVRrRvSCD5sV6Eq78XWXky+166mw4DwRyiPepGPSAoZZZFxHbbxNd/g83ZVxUIujaVcBvntJDaLPVjOZTH3OItC2ZDvs2RUqh4Kew4V4iFqKBHmg72MO3mIr378xee8MowrUCff62R1s7OG3imV1kz269ROMfRRBUdi2OLiIu7NzcG2bRlqDxqUz2h68HFjKoar4yblRwHNiq5iewObO8VGvyBP1zaDaRaJoWfGx5HJZCi0QSYFYZXLZyxcnbBwccySxVDYJxe7RIlhSUMgHaPmp7C0VzDnsmb7eL13NDyGYchxGIWYN5d4Zni08kXRll52YUrIcEqjURjHSJpaow3Kl5weK5oK7aKFLWCg4C2iuATba3TDBUCdKNm0hqETGj6n3F0aNTHaryEdVzBA/XlxxKRBb4UrOnV41wNPyzWXBv9RKNvIDozTeBsZ1OW0GSTw9ak4vv4ojk8pNTemLFyjmkgTPFLknezVtrZhBVB6UKB8dINyZWZ6VVyi3KcSQWBYgi574yomTxo4PaDLPEdqD2elUkG9XpeMQIJScWARv8y3woP+8D59CRWfUJH1hyMuEl/xT77HX5U2jgQ41CLrz59j/tEjFAoFWTO8yhc6f095lgr0U3+dJI8MGt46Rcmic4oq9cKwgYmMITc+rhqNBh4/eYKZmRmsrq7K3xxiX6hwzAzkfw5sg0MDocSThVqGb3BY49QibAy30v+JDW82m9je3pag5aUl1Gq1VlgpHw1tEPu9VwJocPf9xRtz3tbX17EwP49isSiBUgSjcQBXiaOUugkvORa2zHuIPeMp47outra2sLKygjt37uDVq1fSgEiusFAzx1Aa+k4ChaKRp7OzRz8P7xDDZKE4DnZ3drD27BlydLB3PF/5PssXGlw1iXL8Y9iJKQgjIYG0A8Ts7du0R/ePbTcxlD3J5/N49PAhNjY2ZC5boulKQFsbQC15Ds34BBSjJ3wW6Fg5lXVLMI9CWd7fxx8PHiCXy6FarcrwHhhM+fOFgf2ei6jGJqHoCapInZa2hgbrWDnlHuMmZxADnz59ilKpJEPJPA6lQ4VSVTPYTV4hD6ehWmkIzToCZL3TUw6lSxuXymUJWlxY6GwDEgNtfQglfQz+iQ8hzFT45G0C/gMgZ0Gl4VBregAAAABJRU5ErkJggg==")
Shrine["Gumdrops"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAABwAAAAYCAYAAADpnJ2CAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAToSURBVEhLpVZJjxtFFP567/bumfEsWUQSIoIIoHCKuHDgEpA4oEgc+DcgEY78Ba4cEULiEiQSCYQEN8hCkKIgAcPYnsVu271Vd/G9smcyITOICa9VXe5a3veW71XZ2vj2I60LBctzYLdqgO/CjnzY7K/cC/HmbR/dXQuWxlNiWzZ6rR5qQR1pkWIYD1Go3MxxB2zbpjrfzMtay+IYHL6aEazQ5yoL0NRcaYj+JKiQexzi8FGiuXZ3uofBuI/teBtlqcy4KG/X2jRmFZ1aF47tGLDAC2hEjS8CSuMMlz/WnrollF0tvp4WMStXGSbpxPSVroxnAtCqtQxoI5x7JyK9+Cm/AJeD7C35vQCehhrjWmm8PYmI54UqTEuKBKosOFYhKzLY1SRFNU6gpxlQVtDSmFNdFFBVYbw8MoHHiHhdViV2Jjvoj7fQH/Uxmo2Q5qkBtnVG9GlKACqW/LHpjIAJk8/ekYgegyd5cR0XnuOZ3/sioNlBqHMUBJpmU0MsE1yjz6xfbBJQVRHMgqedx+OHRAA828NSYxnLzWXDxsOg/xQJ8wHgYek6ES6HPVzwOwgtB1V1vIuG8n7N0D50Q5r1L4B8RNcBoCx1yaJXo1W8172Md7ovYokMyzzm9Bg9qlImdMJQCdt/kSc8DOjR+aCLi+EyLkU9dJoN7DTJ0iMAJUTCuuF4gK29LczymSmL42S/XJ4AzLTCj+kmvk4e4SbbL/YIuxsOsjUeDAGJIQ/zZDYyGhImxWKXdpTIunrQQLfeRTNqIvKpZ/2bD7TUnd1gDnwPgeuixhOhYCkU5MuZuIF375zC2V9LlNuxOS0CLzQUj5PYGCDP3IB5avbJExJgpblyQKhpOj0EWCcgvZAdZrmMRQE2VAvv3z2H5x8wjIOYlrZoNXPLvG2Ph8YAIY0oFNB9MDFC5mS9eCrRmGWzRUil/g6xUd6a31XGGpolODPkAV5FaNfbtDo0Hoqi9e4GVnh410muWlAzIQs5J21+btomEnmZIyFYwjxb67c+NCh26JmwcpXEhEQRI4DWSOP6Zwq9rGZIMUr3cG7pAs52njMFb3OteWQPDS+5Rk6agiDSC5OTYoYZ29Z4E9bG9ze0znk9OQ78NuspCKB8BznRxENnc4zVGzfh7KVi1zxPVN6Nunhp/WW0wjZ8x2fuQxPmOBtjMOnj0c5DxOnY7NkXs/f0z5/oKp4hqhy8sX4JL7TX8Lud4Fb+B8azCazNEVY+vgl3OF3sYATohSN3HYEsfouXkjXxUA5ppekZmVvKmOWagpc5EWaZb95/TcvHlWAVV/xVvOb20NTu/F7kLVL26qYXUd4yEm8dcRlhO7MxpOP9RLOVGKQaQ94Be7mLSVXHJLiInaW3Mehcw7DzFts1hvQ7ufFLdJwQ19deweXOafymY3w2uosdxSTPcjS+vIP67YewY2qjR/3oKuy1140BJxV7/5aYlBm+GtzHp5s/4PPd+xiphKVB91shiqvnoc505l5KaNLdxfaTC6t1HlvF2P+Vx7g37eNPFZtv3j2wWIvq3BKqtZb5nidyvudZZJ6YhWhxwKMNhgOkutz89FKHzKdiJHg5/185ALRovTltFn+mDJgwqiAjN2M4W2SsgMoYD/lnlSc8tDx6QiCLfxGtgI2EcR/0Uf/iJwJKTdmoLB5/9VPzDScW4G+680tvd+ounQAAAABJRU5ErkJggg==")
Shrine["CloudVial"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAAB4AAAAeCAIAAAC0Ujn1AAAEhklEQVR42qVTXU8bRxSdjzve9WJswAaCaEslSlJFgJDKA/0f/at9qUr73LdKfaENRIIQ4hDw59pe787c6dldFTnFAaIcW6O7d+eeuXvuGXl8fCxm4PH3AksZOC/Ye0ZcrInlfuomlqfMo4wHmRtYJ4XcMGKp3/7t1186tx1sLKoViRkgkzEnji37jH3ifDd1t1M7cX7CDMaB5ZEDr7AgcFi8KP6X1eCnja+3vt8dvDq1w74fx4IdtcfpyHLqPNbYuj56cflj6hnsecDsciJn05Q9s3Wcpd6hZopVMEup0rVnf4Sms/lC1DZk79b//afoXtPPb/t5Iw4sDhSOPdaczaH5rBDFcma9zXw2FXmesQpAayGV1FoGQaLoJE69IF9f1mEkPlz53g2d9WLv8kqXTFCDQJSkzJ5zkaWU0E2SliaQKsCqglDkSYUVQMBeMMo9a3Z1sJAaSEnTy9e+GJxUOt+KXoh0EEqphJJ5Hj+t8QaiFFNmMRkJSGEz5Rk7Mo/eHF5UpDBK1heqOy+2/+pfUxDVlKko0hqrBL+GMOloiGKVMQRBI0bglFwmVcwedIFS1QqFZFLrLhM7DgJZCV42oueN6nIUrDUWv2kt08utr0QuEoeCKzhZcDyM300H6GIhDCtEtTAKiUipWljBY2AoIDKkjdbQ4arTS97334UNGVRdLdjaWFyvViDSYhTRAQ7GlASjLZl35JsRbYarFUMVwBhDVFhVFCj2MEzi0kw65uFwyPEAfpKt8M0k+709/LEZPasFFaXI2FR7LuUuQVoFGrORCuJa4dj5AsyMt7M7mX3N6KZR3f4thpisrL0SYujiH1L3bT0kKCvmgQtYazHAO8b7qBr9XbOOeZ9036dKTZvr54nofBhtxSmJh1GSPohaYJ6vLsFD7TSO00YSLoyd/2eckfhiwFch6e1mfdP5xLjXIr0VlLC8o/5S9qhiIsgo7BKP3jr9RobzqaGvUrC4LkWfGeMjgM20zVppVhUx3ScFY71eX1tbW1xcRGY6nWKYk8lkUADxw+rDvpqtcmIOda1W29/fX19fJyI8+gJZlsHCp6enFxcXiO/Y53aGQhYfUyOLW3J0dLS0tIS4tJ0sgPzy8vLBwQEOPjs7G41Gn9IHhSYIHdFH1EEQ7O3tNRoNovlCATs7OysrKycnJ9fX1xBn/lSVttLQbHGr1drc3LzP+7/joRWC8Xjc6/U+pbcSUt3xGmNWV1fDMET8iNWUws5ms4lg/gbh68ISbAD5wAs14Yq5u++LQ0Rgv7y8xEjL5Kz0aK0mHB0eHoIavCAletK9dwXQE8RBYbVahTWhj/8P2GYEy5ubG1mgbOdR3iRJOp1OOcA0TfGhqEISpmy32whwD0p62e12xdOA/ShDK6XzFhYWwIuuQY1HHIM8Tr26uoJ58KgE8GTqOI7x4VCj9C8RQcbSl5AFBtve3t7d3cVlRjKn/iz2OzthQmC8bx5cN5yBVySeDDCCjpnhiiiKIAgyc80D6vPz88+jxldDXLCjqQdsiusKTeiJCtxlSlJkHr6xrVbrXxvR8ccHc9DqAAAAAElFTkSuQmCC")
Shrine["AntPass"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAABoAAAAYCAIAAABr4HqSAAADCUlEQVR42m1UwYpcVRA9p+6d6Z4WM8yMBqOJKLgfstWVCOIiuBVBdOVuNm4EP8CNm4Dgb7gUXSiKmGVAFMGFIhhwFQLBIT397q2jr969FzLk0Jx3XlVXvVN1Xzdf+/wakmiAYRE0ycAkzAzbBzNtD5YtsrTEGYlmpM28zuvDvSu3Tt7KACBCwhAaDLh8gkkinE7QBHekZIaUaSYz8P2r715fX39pfSNjm2gAw50JBgUvtwqznqh92VNuK3klHqX1wcGnNz853hzNbYk0t04Qs3/1AglFQy1XCuoxBgNISq8+SCeT7u9PPx1hvcbt/dVmtWdpKZ0rgHTj2osoRAGKYbIQnHWxLiJ7YfXPTfn1af/jADujW6Kdnr6csgFoZgBTAxoBcbkECJHseprKN1/fdXX04iwEJAIgFULkzKFJZhIBlzxslFqnyd0loUEAlSGNW0hDqAfX5CubDeNJF+5/bbc7954c5AQhZEWA4tKsrX9R5Mbs7eOTd567GlFM0hf3/r7z8GFdRo9p+yHOyKM9ZvRMqCR8cHx86/hoNZVYxUwfnjyjUu+cn2vMo6VU3Z36wbD3E1bG9w6vvLle7223BNDbPet+dnj4bym/IbyNkaN0uBvPCkWYcFx9td2m6DKQgRNgI9cy71hQqOEOZKRbMlzudpDwJKhU7FublJAUjLzI7lEMLani/247LwWPw4EC1FK1Z/095DjirD7k6IhAEb4s9SbK81Imx1d2wPfk7wCU27DsRYTNSho7Xa6CCnQPOgMeuHutcJf7zv2udBu4v9S4GhBV7WQDQpfBHpFz4MzsI3cDRF4An5GPmlOV6rW6pUhGXRbA1qRLxQZjvh3xj/CxMZKR7cflVT/+8Mvrb5yuzLoHGNTQ7Dbn3kLBPRmAFNLdv/v25zJVDUAZy9GSWkwFhLHgiERi/J6WqLumqdbqEnpcWRprC+5oMloo9OXkcDzLZiB217L9f+ASNKhtvG84PqG0+EV7jZtBLioqluVfNksNHRWNxklmSegYqpt8ktOBcT7jpZD+Az3+j1GcUWvqAAAAAElFTkSuQmCC")
