﻿bitmaps["boost"] := Map(), bitmaps["boost"].CaseSense := 0
bitmaps["boost"]["bamboo0"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAABgAAAAUCAIAAAAY12rUAAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOwgAADsIBFShKgAAABA5JREFUOE99lIlT2lgcx/nfqmtbz0rycr8XLhXEo7ZerFrbWrlUREG5wn2pFQENhIAHHrOzO+3YP2kToXF3O7Mz33mTmfy+n/e7Et2Pe/jj4ac6z/ew1LAvtwRbPWMqx/nTMF+OWqTc/FU6KS91w37Rv0EP8PsdUiiLcsx8FkHhGeQDcHuUSSG2sjHeyHob7v8FKXqifLtDF82JpWbMVAqhgAl6+qGzB7pe0PERsrJgOo87a27N+R/9BN3DxzvYvjJ6JLdZzKPDaeh+BZ0voKeXDQ8QZwxRWua/RlbFXblp+XaLNJemZ9CfbT5bn5uSs9xJEO5i0N3L7b+icm9AjcLqZjy3wmQCtmrss+QrNuY0l6ZnUPvS6JK8BjFDnq5TR4SCICokfslht0hfncDCy1RwFSXXrDVh8/pAc2l6Bik5v2smudMwXpvF2jzWRup5q576IyvwTbIeCvk5y1lw7VrQXJq6oO+36KxunZALdNGPtcZVv4qAeIvFJQjiPOMahe5BFJ611pJbslfza+qCHq4NB7UVk5glCy7sxqBUhEs0UVELpBN61j8InX1wlzMUdhZrB6I8rvk1dUE3l0avuMFX4kTRAeo0lR9lQ/3c3ksmOsAII9xOP7eFc8L6WCXurH65bpmU+L/a/OOvoGbL/FHcgsdBJgyhr48JD1DHerzJqNXVjFTUwoQcXCFsrKSt9fT0ZX7h/ijbXFT2rrOAXZACLtVtk40cW/CReQ5vstjtU5s7Em0g9ZFO+Nl8iMvuQ+EDH3eYa/n3D6d/tHmF8vgkndQcz9Xf+qqrpnKCzHoweewZ0VFpFgiblOCjoxucj4euPugdQIlVe6tw2TKdNKZy0lyhMadTZmmX0pavh0xqD0+sY9emJ/8/Mjp+DyJOMrLB7Juh6zd13bcH6aTTVEm+uzicqqfsUmrm5khnb+UN6Q9oh2B8JkxY6CD0bR6/guQZoIoYSM6BsIs8dLA7mELhdvrIIgVS63RyD+aDSPidDxjN5aDOJuf42AJy9rLeISxpU1NoI6JKMtFBNjRAHuMgMw9CLpBYotIkExuiinrihMRT08C/wu5aoGcY+RhjKaiblyJ8ZgN6hjjvSyLN4C2uM3s6MUyUAS4jPO8AYTdeXATnLJ15o7xiA/20n2DcADmVD7sHhubGxKTOI34xnQbgLg/dPWpEclhJRLkWb6izx1oWkF0jIm4iNUsnR9jga2UzGGFYbbmzBymULT2f35ptpnXx2rxdFFDMof43tvsYYYgoE9gN7HZasoL0JyLqIeN2Jj5MFUbBBUUegSeK0nUcJdYmRcFX39BVZeuqtG84CbAH41SawGWmi3gSfj5DpJyE4AHHb3GZVS+4RuCYg67XynxQ6rNNjHtrm3LT8jfVTP+QMce49QAAAABJRU5ErkJggg==")
bitmaps["boost"]["bamboo1"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAAAcAAAATCAIAAADTd4AJAAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOwgAADsIBFShKgAAAAWZJREFUKFNNjmtLAkEUhue/mVSoaLlzZmdndlZK6QpWdFMqKqTVpbQr7YVdU8tMQjPJtBvUL2u7QfBy4H0+POdFybatWWmtBOJgnFU03slNDS6RdjopjJDQh0Q+oHgxubM62fWQKIwKPSCMILfCpM1IK5O4tX0aVE9G6dUY9Kj0mMRXG6x2ivxOOjJ+VaUPLX4/LVkZeraJpHdNek/4yL/xmxkozXGDou8u8AvHfQFeguXHRSGCcF8hHeJ7lHKcH0WEPiwOVcTNkHo8wpwwc2NqMaTuY9XdRrQZx8/sS9KboE6KmVn12vr2/uRhFio7SvmI181/tLUA7h51S4qT+0eby2Drsp1jJ0mE34TcBtqQ4GIJrLx8nuVFCTEnws2w3MRQWwEzD+V1WpWRUo6SO8BPGq5nwSrgxhp0OcKDr1nSSwout4hdIJUF5SL2960/A9Vd4hiyN8+86C/F3TSp6MQ1oLmIn/gnIYm5hMlp/2cAAAAASUVORK5CYII=")
bitmaps["boost"]["bamboo3"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAAA4AAAAHCAIAAAC3JetOAAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOwgAADsIBFShKgAAAALpJREFUKFNj2LHUBY6WLfSvXtkQs2l68Jb8wP0xCLQvNmRNOYbSVY2xm2eGbClCVhq0JTd8WSeK0lWLfBpX1SRtXxyxoT14V2bQnuTgnRkh2/Mi1nbGrJ6FonTTYveZi2JKNk5M3LoganNf5Nb2qM29sZunJG+en7kBVSkQbVzsMWNRbNXa9uI1XUWrO4pXd1Wtampfkt+2tBBdKRBtXuK2YpHfwoXBELRiod+2Ja5LFgZiUYoVbVniBgDk5pwsxt9uDAAAAABJRU5ErkJggg==")
bitmaps["boost"]["blueflower0"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAACEAAAAUCAIAAACMMcMmAAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOwgAADsIBFShKgAAABM5JREFUSEuNlPlTW1UUx/krZJWttQjWCiqlUIUpldIWSnWwHZKQ5AUSQhK2KRDWskMDbSCUvWwlhIQsEMhbkjwIEKQFFHDYLPsS6+gPjnWccetP3sfDEBNHmfn+cN5955zPuefce53mp5mn0cwkpEG5XaOZlSOV2XDzPV1zDtJSijzSYKl2no46FWNmCmrTFwvHuvloX9LwAE2uoUiH6So11zBYNNaB4il2/nY6FWPIwBfinUyt6kYj/mHegr9g7RxvPShnKa4NS9XLGwxVcw4htjoVoxEtSYWl0fVj/vw198R9F8qhM8XiTt8Pyl6iKVTC8Z7pSdZ/YP6fYcDZeVgrbUAReG/JjXbwRoKFFMD4JG/FSPQ8g0yJCZ6bofHxZNiYMmrg6oxcYM+aITLDMWPWzMTH2QNYRgcibIeBckm16XJFI+Ucbc/NeuQM+wXIa2UAeTB2Lxc/Y2n7KmFRq05YC1eWIuL7SEMJJqlDq/uxrAlT0gkDxrkN+socvJeDgmHCFBlKGUCAqLJRumKA0ttxMfeZB33XFgDkRtsPzFqkSp8kj/SwdVLmkJwqV92VDlEHh5IRdS7e1YUJzRMQwQCbeKwvE+CqOzI4UjT1fs7XAWnr59PXzqevXshcjijFY0U9fpxlF+qhHcOVehDAXY5varrb2RrbqIysxsIKzR9kz4UWfRHTpGMMq/KMHUoklWCYTEnlmJii0AXnL3jQ951tE4HZJu6HZE14MbasjQIGaYPhn2Wt36p5fLVU4cdZBduyrvvzV2ObkFS0/4G2hGBo9PxcrO16o8mXvWmNt5U3YxtMm1g/+mv1caYcejM2IvPlvtAGsG1DXGkHwfmzdOWgUCMiGGq9IBtuiRKbfJKIYl0cGNa8oDme9F0vxo574h5ICuoFnwHsZRJpp7f5K7fbYYFaQjL4gHFdYjjLIU6OIwMINNCVehgsWOA9khW0tN8qNHrRd8CEPP7uj6N82S+u1Rt5inqnuWlIpRfkoG3xXdoLGYvEMI77QMgaAEqOKRgzmlJ/2o345eDjnZU4UY/YFyJ6S/o76gznm+gGwzEDwbmF+ma6Rh5ePu7JOD6gJAPUThqX0ucRXPDzXvifL0Nev7z4+7eh28txRa2t4ERYk9rJn7/yabtOoJIQjJkplgQt4yFPP2tXBmbNg5IJJxvGm4l7YmntdxvXSACpXy1hS18mxBUZ/7W34IwE5z9PHFQINbUEY34aUmJpeaMNNFlXVJXqLfYKyEu6EptIsIRlzC7MUX+zhFoBpH7Y+kTcV+tGPXlgjqMSLOe46zcaUC7SX6MtBTOHDGOch3A5f/RJQm9XdJX8Pf4sKP8kgGLh1skP1m6+ttkEqVd7EWokG4zdbiRezJ2PSqaoCqVQ3yGHeU7gyROjFWlo752n6vCysXf4X3kzN47bdSRweCo7G7/fjLIDAP24c6VbfR9cPSsDBPqwNi8VTMd3a9KQnia0eNIEOTXpCtINfQky5eUSsw/r5DJbdcSQODLAbPZWY1JqFWRBbrQ9P85iUKb5SgX6efdgCiKrxupQnAPuhpNQ1whpB64+wMlnlZQVADoLPqEa9fZK3B//6FXIq92IUUPGuynLpKcnfSciX31b3EqVdvBGOivQhyp9Gnjw56eZfwGyoypa2/qR4AAAAABJRU5ErkJggg==")
bitmaps["boost"]["blueflower1"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAABEAAAANCAIAAADAGxJNAAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOwgAADsIBFShKgAAAAaFJREFUKFNjMCo5r5VzVSf3ik7uZb38i/b1u3w65qmnXpSIeigW8QgZSUY90Eq/GDx5MoM4skTkI+mY++YF++TjbolHQgWBDAhbIvKhSuJV37ZJDHA5OFKIuy0V/QAkDlYN1yMe+VAh7oZTxTIGCQw9cHVAx8jF3pWPuyMdcw+oAWgPkKuVchGLHiACOlgy6qFp9pnMniWVU2f4Vu2Uj70D9KFM9H2gWQxAB4AUwRwAQUAjvSt379yb8e6u/acHtncu+XXM61VKuAlSA9IDMRjqmIcQhkXuyS27sj/cs/v5xPzXE7Pvjy1vX/SrnjYNGEJAxUC3gcMUSY9szL3eRZ1Pb7hBNEDQ10dW505F+FXvBPqFQTXlElAdwraIR1Z5x8+ciPr2yBKuAYJe3HLpXdgpFfWAQT/rONB4iB6ItvSuZQ+ueP1CsgSC3t+zX72lGBgMDArxN6DOAyNg4DTPnvj8piuaBiB6c8dx7upaKaAeuGokPRMw9QD9du+yd1rncqAFKOkA6BkgN6Ft9e1Lfj9Q3Gb+/q79xh15umkXxSIeAQCQOVQMs2QvpQAAAABJRU5ErkJggg==")
bitmaps["boost"]["blueflower3"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAAA8AAAAKCAIAAADkeZOuAAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOwgAADsIBFShKgAAAAP5JREFUKFNj2L7Ude1Cr6ZV1RnbFseuXRa+eEHo3Lkhs+YAUejcOeHzZ4XNnhTQ16OaeEE8/B7DjqWuQA2rF/lMWpxSs6Y5d+vcjO1L0rcuSt+6MGPL/OzVE+JXzQqeOlU58TJUNUTDpsUeqxb6LFsYsGRB4GIwWrIgYMH84LRN88PmzFRLRlKNC21Y7Jm5fXHkwplaGefEw+8SVp29a0n00lmG+SckIgipBjqvcn1n3Kq5FhUHpKJuE1C9ZYl799KcxA0LXTs3KyRcI6B66xL3qYuTMnYsjVi0wqL6EAHV25e6LV8UUL2xO33bkrjVSwmohqCl830rF5UXLKoHAPEB8HwAM+6SAAAAAElFTkSuQmCC")
bitmaps["boost"]["cactus0"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAABIAAAAQCAIAAACUZLgLAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAKXSURBVDhPZVJZT1NRED7r3dpb9oqQIgRIDAkvmvgE+ii+mBgfjfGvGh8QF0yQYKUsASmlpe1te7vce3bPBU0MfpnzMt/MfDNzBu5tvwMAxCnc7RXroiAUgADkMC/RzkphMOFry/4PZJ/U8EAsnOfX6+F8LRy7yk9V8yvl3KOyKPUYuY27gyytkXrHeDlirKXKDfL1Gn1r8UqDsQpcqrB7Slv5u0AGgIpaiDno6rPIL8f+WSd/1Az3OqASMXkEF2sj/0/sP0BMoktaGqhuFPzkZGCrAGgMHY78s1hVI+7smodXQ/fW6iO3z7HVJ9U0ZBCn3rkgfQOyBeQgLdGxIdI9fur3pi5y4013UxMDEHSIu8RO1vUpfvHmGSfTM2GtZprMZHtcc4sbwUJskqrokoEPB2QkkiY+7ehLyeiAzCPBETDgOlF1OZI3UhjAZTpZQF5fMYWZbS2N221ycBXuNILdK7KdJM0f7joyBqRSHLJ2qqVNm8T+HAnbcvRLxgYpQYdKJWnQstWtzeTZq7nRfczQAV3jQiqjsmUAoIz+zuof04vUSAONJtwABTm2VIDoy3AVKWfIFXKQ+3xWjWOCsvMAsWZf0ssTEWnbBjAaKYM1Th1LPfHmx5H3IW61RYo33r7enOIlzzVQd3SSGiWM1sBMk8AOOTJcACj9RPiJA/GxiGoDTEwRDRH53KJIBh60JTNBCME8KTz1Hyw544zw4UyDFXrWX5W9Q97yEPAhRLPsvDyk76/5fhLZeSxtESKHG7XPGgwISe1KM7/9zK3c6tZUcTGg6DE9oYBFg6DPoMrmyVCT/Z304kx0/zpuoHFRzYZmRmIfdYWDFaM88JIJpLN7t6E9xVoyuc25PWRkSD32PjW97cgVSe83U+uLV18y1xsAAAAASUVORK5CYII=")
bitmaps["boost"]["cactus1"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAABEAAAAJCAIAAABbilBbAAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOwgAADsIBFShKgAAAAaNJREFUKFNNkGlPwkAQhvc/KSUKtaWAiBGVgkYU0DQBDxJP1Bg1aMTzg8YjJGiMGuKJB4paz0K3XFppFPX/OIgfTN5sZt+ZZ3ZnUM/1jjftJSVDmUgRmJ5Tuo+/xtuyLCEYmFO3dXXSGPWUYQpEPzg6rtd9iTPExTYpwaYSaWBq0ubdwkjofQBaqJI68tJWv+wnb6yQAjVl2EtlMYgPkDMa0j43lv8yxpRpUHa7cnYVpsHR3FgsywNVF3ZIQZfI52hcXhl7iqCItF6XtBOiDhJqTJOSvlJiIC4XqQq+tm61T3fYCtchuT3+HRh+HvfyW+i1EDr6mOh9dVK/IxWrMWVKmztyzYxQyxy6yBgLpiPLci/NVt7XfhtGG8LWSX5uROYoyVgCGjKWWaVrWvFqsEH9VE0IevDhfY3EOO59Xfwm8sV3e/gpM25U4+L3gHHmbIG8x55tgBicklpz7IzSufc2vSDuoP54uCW6pH20ltYAdUyq2pSu+Q8UmUxTWA6cy6Fg6ggNxdZc+xuGK45I/M3zX7AJOFVJPXPn4m7n/ffbgcfwD30V2pbIsDoFAAAAAElFTkSuQmCC")
bitmaps["boost"]["cactus3"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAAAgAAAALCAIAAADN+VtyAAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOwgAADsIBFShKgAAAAPJJREFUKFNjuHQs4eLRhHU7clL3zHXZmWp80B6ILPa6gyQO74qdta0qcfssl+0pEAmTg/YgiQWLo0oOLM/cMit4Ux5QCCIHkpi9IKr+2OoNp+ccutw76UJ+7Ilgs0MOIIkly6JqDi2t2r2kdXtf4v5ku8MuJofAOg7tjF2wo6J824zUdTMyN1fmnIyxPuQCkrhwNGHf3rTO7V35O5esPTZx0cnOoB1FIAkgOnYwefrOxqLD62eeWNK0f0nOthlQibNHErfsyWnfO7l+17S6nVNnbqtmuHwsAYLOHU7YuzNh0+bEzVsSTx9MQEjAEdCAy8cSAB/4mcNDat5IAAAAAElFTkSuQmCC")
bitmaps["boost"]["clover0"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAABYAAAASCAIAAADQR7l6AAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOwgAADsIBFShKgAAAA55JREFUOE99k3lTGmkQxvlmRlllGIICBgU5higIDKeyqCGhMPEKOTywKoIGleEyGsUE5mQGuWZgK1WbzX6i7QFqK5U/UvUU9c5M9+/t7qdR/JCwob61sc9V1+anF/HSc1DyOnpXdfabo6+/kYz4LmKtB+cJm3jGpt1saYm6dJI5nCY2mPQRs0Xxnr9Fx885v0hGSK3Fj0wsJBSx6oWRfqMXEnp+08gkrXQa54jX7Fuq7vk55xcpvnftNc7zjMtg1csn1T20s4L0A+p+ABXDMw8xM3mMM7l98mWFxfP0apZaA13SUbLu4QXXt47jHxFTCLTlmN50MQXT3YGmFUH+8qs6XqTngwOAdGzcUvngvz9Z/3oUYM7dPLHM53A+H6cO9th3BTbaFTAFUTRHGnlb9VTHPoc0pO//o+KYrC2qRBweNc2V2ettcz5lvk3NkW9nuW0Dv2Vkk2Yu9bReiDSLhTuX4vTCjAtX8+S+uhcYIHzKK9vYe/0k7UQkn7obmClvGM4TWnpdLQXlALk6PyqFn3C7i/zVTj4MCBMulAeIUQTS849n5sZP56cabkBobyKPKxH5gp5P1faqHtyINCiwu2pnsy9zQcUFYQ43ytZqelrYUEsQJ/cyVV8ee6eDdtSdAMqH1G05H16OfzSNHRqm6i65ll7QymVeAUKgLGC+ky6br1K6mxePq6uoEAIQtCP30vUjwIUZtzzKa7uyaFV1vXKlff90M+aoE1tESPFDxGqcd509s99k5zJJ/X585mhdQ4bVbb9a8qONoLoVhASYkWwTTEcKoO2w/kvCep/xPtx++IQr/pWwhuDcId/Yb7PG3K72Zk1TXdGwYbQeApD2MqIlIigTQkToJYA2QtpyVJ9NmIlD/D5zRm10eEzRE2w5Zi3A5BYqKa3wJ8wPLgch8NsNoFwQ5UJwGBQyeNkKasmoqbi/XMvBmkkNuzyL9/Sug8vphPjI10GrsuAALBiw5ENgTaCXwSdwd4aN2b6cRrls6W5JwdUWktSuhTsBq//PV5atsGCqNo6ARB8YqSxalCWrqukexgDFwL1a4kvJQlBGvKZ2TPzh6Nq+f/LrU3BURnRxpO5GWl5YeXgcTxsnzk2wLEOKRlyx1c9kU7maZY/amRcOBvk+iHh0aJggFsBFGVp1IqRL9kLEJynnxLkZlmWIgH+QhT8ZIYZVwNrC2kELj45nVc1BvuRTFewgKEROG27noApoZLoVw/jcNhH+Dw8jdqNM/Pf3AAAAAElFTkSuQmCC")
bitmaps["boost"]["clover1"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAABEAAAANCAIAAADAGxJNAAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOwgAADsIBFShKgAAAAhRJREFUKFM9kn9v0kAYx++dMajQu3blpyCdjDjDhtBrC8O5BV1IdFmyqAvWf2QR4nDIMrLgZDgpA4GVAu/K5woxedL0nrvP83zv+xwK9l7jBcVz+qj9zHv7nJ9mYSmO8pGrI/m7IV8bse77iHkUvn8X7Z3IprHVv0BkpjqMwl1uuj6GvHcpbCvEUgPNg3CtJN3tE1tjBxaUzKlg5x6bx8CsUnhG3ZWY++yJb5gGRmoV1tsFVnGm8JMM/zeNbUeCtYv8gwNiwwaT5+vvuD4EQSF5UIV7nUwYAEn317irHPb1t1m3mYbkSyPYerPe2RUGOpCgkMmzKIZCC8qPX3BXSa6R4K0M0zKn/lERJVvVWOUkdHoY+LQvdnNkQolNhaFGxhqcgHtCK3ZDWxUmudBNKfGzgpLX1ej5sdR6JXbyYi8n9HUgpW8FqV4Q/uh4CvJUYahLzb1QtSTXy1lgNtqGNHgJl4byEBi+liqYmmDq8OO0cpJjTeruxRunO7fnKDg4XNntyGUBPwCDK7aCYVwgz9kC0wO94ubNGQLL/wNcMwGT5SdZDDFVwF+u8ZT7keBH6eUZwMLmW7QqPKfeX1tgNGOsLO6n8TjDP2Rg6f4S9dTiMLQlJk7zyAEUSK2Vw576BpjLqnRSuLvNHJtmvb9TnpoMQ1syZK4ieBEwYFC19jnCjxzAVviLJAS0YueW78DpA9r84+I/XjtASrSgHIEAAAAASUVORK5CYII=")
bitmaps["boost"]["clover3"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAAAsAAAAJCAIAAABrBkF6AAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOwgAADsIBFShKgAAAAN5JREFUKFNjOLotEILWL/NrWl8XtrvX/XiW+7Es1z2p9v0BjgsiUFQ0r68P393ncTzb/Uim49Jo+4lBbvvS0FQ0Ru2Y5nmkAKRiYaTzuni3IxkIFRuX+7VtaIjfviBge73nkVy3vWlAaaB1CBW71vlPX1+QtWNx9Nppvrsq3I9lAx3kcTQHoQKItm0Ib9vYlLRtadj6Xq8DxZ6HC3x3VqKoOLQ1aPX6uPJds5K2rYhdNzt6zYyYNXNRVADRwS0gRbV7ZubvX5m7b0Xp9unoKo6ATdqxMWzrhnAg2r4xDACcjqQaEHeKzAAAAABJRU5ErkJggg==")
bitmaps["boost"]["coconut0"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAABkAAAAOCAIAAABVWCAXAAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOwgAADsIBFShKgAAAAvZJREFUOE9lkvlXElEUx+ffKbPjydRMARfKTllmtlipIMzCDDNssisKDgguBIqKG6OQqGCpxCpiGpXWf9WFcUvP+f5w333v+7n3vveQP0XJVf0+lm5nqVBqwJ0esycn9MlZKhFi4kEytoDtcIpvq1R2fSDPTaZHNzLM0ff+kx+S03P9x/p5JN3M0pbCCrm/Id8LyzeCcs6rmbU53JTBpWQ8WmbKQM47sPUAmo7qC2tceuCwcIm7ZBWPpFtZ2lDg0EQYC01RXrPWTphM3W5Dh1f7xEmIWFzAEiI73WYckiiCrPwrp9lfDaV0+QP5r2PpJQsWX3KUscDJEhEyYLfpu1hFkxNrZLFGv7rFr2514qUYBME4JfLo2mmvWRZbUmc5f8aeyaPQXYl1WpTkDtCxzLgsFUUXPcOqZ5N0MxhcZf8npsWnajkDYY0eUrhobPMohKNUK0wt2wySB7H5pPnosB/5W5TAFQbTFjwfk0YCFuM7mMVLNwe0YrdCCH4wT1Aivi8XIQCuj2nm0SzRrHap5FuL2vzaStqAnBxL4lmlfn9ZFl9WuVQAguJjhGBO92icFELMizcDEbZccHHnGQclVvos6F7YnvEh+znpVIbFkxFqZtiufHxhnqKb3ESJy+uMdR6Pog18BmobrX1YZNqcmkFiezJzbgGLzpqsPXxTvKA4dHGxPHOWKZbeWmVn5UD3PYf8IWSGtB1E0KnMhBFuG6Nzn/Elzwjz9MJ5Uxcs8GveVKHtt4gXFaaPNYC2K9so/yCeiiDLMUyZWtP6LSxR+gQ3BeYhSZ2lp8YmfcCz1GUWyPC+GljjtFjn1eOJVcQXpZjd5VGPwq0QXaOAwGztrWW67pIv72jeVo3I6ssz1tCv7qpfVwEd3npaIzZMavHdEGKLGMj4gsOJwmNfA4FYtEHfXY0/vw1dAM7aVwt0wEGnw/31sFv+MU06jwrfCSGmNRO+MWcdkcOHugYCgdP44b6iowJYVGflYF8dZK6qdAwXqN0qfDf0D+2A4Hmfo8gpAAAAAElFTkSuQmCC")
bitmaps["boost"]["coconut1"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAABYAAAAICAIAAAByCpiHAAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOwgAADsIBFShKgAAAAVhJREFUKFNlj8lOwlAUQN/vKEKICIhYJKZqYlTEKaiACqUtLZQWGdKCTC22OARwiImsJHHjysSVf+elDxtTk7N4Q8+5r6j0PUp9jISuoNKEllm+Zojn4lovG4I1RjXR6MlVlybwFmhzJN+Xqc83RH+NuYdGi1+3nLtcWGcmOcw08bvuUEF8AiMrSjIzHqLM+1NVieMnYGAUzLS2U8GU5YSPjzovY/Pt9BKc1KUI86Ih+tVo5jct4T9WAjTx0E1tzTA7juqpF4otfoMb1JA0kFUmbNMw4NTP/HLce3W+iBMFMwGUjz2Q6OXI4n0JdQxWZ1dsMgCOkvDl913Z3TnxyN1MBcwf8eb2XIUDN0R1NjQUyfKthNoa1RdWbT6gUsFSzENvz8JMqChJH0ShAu9qXATg1siGbrhw0RCQ0kw/SqTNB0ConCywEQckuKizlvTDyV8mn9FEQRd+AMKzzAI0K2jWAAAAAElFTkSuQmCC")
bitmaps["boost"]["coconut3"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAAAgAAAAICAIAAABLbSncAAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOwgAADsIBFShKgAAAAMFJREFUGFdjmLkkI3PH8tTZ3XUFAX05TjNLPVrTbCfmOTMsWpFesnth8uq5ee1FrekOU4tc+3Kdu7IcGPZuSZ6xviJjx4rkBZPKquLa0+2BmqYVuzEc3Zm8ZXNG65be1K3LUub2FtWlt+W4dWY6MBzblXxoR8q6TdnNm3tSty1PXjQlt6OoLtcbJAGRW78pq2Nje+6W+ckrZ2VNrIVKANGRncnbtqTPWF9evGN+yqbFCAkgOror+cD25Fkr8+qW1gEAn+hnzYkbBHoAAAAASUVORK5CYII=")
bitmaps["boost"]["dandelion0"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAABQAAAASCAIAAADUsmlHAAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOwgAADsIBFShKgAAAA2dJREFUOE9tk+tTGmcUh/cfStrpl87kWz+mM51+aSc6XpY6GOIYq0yMolYtxtTENIamdtJg8UJUdmEXA7LsHZbLAuEiCwsIyB1BhZC/oa+aaVKTmWd23nlnnj2/c/YslBDhCxSSqDgQFSGP4h+behmfXrJM/2YGTM2Z5+9ZHk9alh5is8/3JihGGRcVl0ByAE4Gzv2YT0Gwd3RO7Ti3NeWyPBWJtQi7HuX+ClIPBfs0i6lpZIzdXqaXWf62JMLvZUDMryCYoUVa9zOLPvU5HUkxVkrmjrOFRi5TzYSP4nwqZIq4tJz1Lr2zwjyK+BVSAL6oLMJul3KJWRlhLatep1SST9uVdqfefvcBcFOsZ6mEOLq/M+oykeyduAhDqQAc8gysk5OjvPmJy5atZlqd2sfaJSet8nHzKFvPPqIwFbW7RU2ANiHJ12+jhyd54zSDhXMHV5z/OGtXGieFQu0QCbKqfaPBqYkC2Uv3rJJaNYfvhLjP1rzkuJGPS+JBIhDJx+/atn4nFoPCT9C+tXuB1M3ze5lK6orwMa231XojX6qki438LGEacuFmegwybHaNu80vfM6zt9UrwgdAok4N+KetcuWk8ITGlbRFT85Aaxu3pgTcGhPa7z6T+b1Qz+aOJL+f8fooIK8wuJIyX8jrt2YEnJD8V7RzOjUQB/hgWuAVzdMimFmxmf/VYVJxGEKrzytrBNwSdX9qBkM8TVvBnJpnpVanCj41iOA+8A6/No55LD7XAGR81aXhjKteotkq/y95pwZyMsxrOR2OVCMbcYvRs2t1oDoCUTmMf5LaqBeGHNbuB+QzMO3DShoIYBnAE4QElKuZYjlVbea2U3s9ds04sqDF/hhB9SOEgWEHJX8/JJDdOufCfQ5nEiLoLZUOg8byhUQBLGmrDM71k6NNGb+5N/Ktafgmqv5xZ3nIsQk2MuaDoYjQs02q1S5sxW2XS3ImGwODScpvknIIHMBK1o5zRJb7wTF5He39EoG/Md3rs+rv81scNwh+jD6auz3H60dZ7IVIuQ4joYIkxH1v5FC6nEqUZTEb3RDtXfj8F0j/NbT3K3TgO+SBkkL+JmchWewPe2CUHptlX0449b+Qhjkee+yxvQxShhD9zGOfIU0qs/574+LXu4PX0J7raN8NZLjXuqbhN/4FSiIWtQwwurcAAAAASUVORK5CYII=")
bitmaps["boost"]["dandelion1"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAAA4AAAAPCAIAAABbdmkjAAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOwgAADsIBFShKgAAAAd5JREFUKFN1kW1L21AUx+8X8gHfDPbOlwrDNw4GPgwEKaMWGRub4PO2FzphbjAQC0VXZpPMttqaalq1W6tZY+v64G1rmiZNk7Rpm5p9hh1QtHQKfy6Xe373nP85B9kOt79G99MlXG+Wm6bW/HsneJE0nsmwk3tbk2ECrYR9vJI3TLUVulbNkCt6kdf4JcZtYVwoXki2EbdqNMvVmiiql2Ts0LLnRPfmu1alKqTSbDLzOyGkJnzfUFu4VcaVolWFUjknVYXZAPEwCtVMFei6IZdr4krQcw96E9b4QjF9ehqKnjCAfgr9j5pq40oBGnqCD3pdgs4kXVig2wyYaow7Dga90I3eKBmmAqOF9D+TUeuuE9CWCZgqVAyFdnEunlASG6ltZ8TlpanPAdJCA2qqMGo4oRxIVvKSnFX0wvfszpB/6jX5btH9xUbZbQEHAk/ZXBwMCWJGhPUaMty1WnETe/p2bP2EtY96+XTr4wt6E+ESzvN/wP4FPrvAHFxgmWqlEOCPBum3ndRwN/m8l3g14rWjNZYJXyY4Mf0rdXKGuZyczciY5c83WP8zz3wXOdpBDfdQY0/I9+jNvn3mwDF37F6O+NZjjIMLrkb80weE5Yd9wPnhkWu8gxrqpEYek9Z/3U/0NgwDSqQAAAAASUVORK5CYII=")
bitmaps["boost"]["dandelion3"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAAAoAAAAHCAIAAAC+zks0AAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOwgAADsIBFShKgAAAAKNJREFUGFdj2LnRduVS2+Y1RUW7Vm4/f+j5y7sXLx9/9OTGjVvnbt4+D5LetNp28sqY3N0revZtuHDnwpVrpx4/u3Xh4lEgAkkD0ZLVPmXbJ+bsXDH18NY9V08cvXVm39mDxy4egUpvWuc4Y01U6dYJBZsml2+eXr1redu+tdOPbIFKA9GW9Q7L1njPXRU8ZWVMzabmio2tFRtaEdJYEV7pjbYABzuBsTZXkoAAAAAASUVORK5CYII=")
bitmaps["boost"]["mountaintop0"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAABsAAAAQCAIAAABocZPBAAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOwgAADsIBFShKgAAAAupJREFUOE+d0w1P2mAQB3A+npuJiQoqClJAXiyKwiCKCoJDmDIGCC2IIBRKtQJCpS3QTQRx79ncR9phFdBk2VzyT/O0zf16l0slv27mxQjvdRufaFO7bLqkPUKs2kC/d1T9t/+ee/G2O882DctXRd05sZrDjCy5zYWyvK3T0vzsPir4a+7Fz20kzdkX65SDSibzCReVNDN5q5CL81tXl9pnoT0RGqwLeid/YKCPMDJZ54p0OR8tEXaGtDYJnHse2hO/dhAY0MjmDEEPQcTrfEkMwVAOQBsExm21LzXw4eHKP6Untj5o93i/9ixl9W1y7FlfhOQvTjYZ0tIgYrzruqW9vYFdiXkK9dMTeUHvYt8ZyUQEC9S5AScmy1BrDLki5LHG9peO+kG8Qz8+ROTuzj2R4ldQPmdOhUvFLM8Vn4jwJM0U7LWCo45fNFGwoNPbLlyHRBEVxW5LE+G29eXjjegbtnY6sIaaZbliqEouVY+CNU+lgfpauKNL7bej11eapy6IMLKbCy6eJEPJcLVS6Cuw8f4ZencF3MqQx1BNWdhDfZ3SsgWjcLrTDFcE07dr1SMxx1vNfAZNhfF4sHJOwozgwn7YGp0j4qcn6TP6OI4HTEsamX5OHnQrSQwhYlt4wJdPmJiMTTjONWyf2uqBeMiu6UpH5rC3QCaZKpXNYN7XDvbitFQkbFajCUUgC1r57MyYdGpUtiCfclqUblsUf1uuUvh5frVGrgvpanPxB+xKFP2sD8ke6Bzm/b1tCNRr1NNndAZEo0Epk76UTr4YRDYqVYzPqqf8fidMc8HSWIVc4Qq73B4vGERUssZhiohXjsgQlUw1L4UyUFxb1j2/E1H1bqUTI7300YmRKdkouqja33cfRPzJdBSN7BpLCT/rh6XB3yxBmZR8xy6FXsTKXvGIfGZMOTcOlXAeen4vwhVeKebGYRrzslahV8x61/U07uQiBP9Koilg0xbdoOw/AmMpJ+UuK5KP2dj4b8oS5B0cJ3aCAAAAAElFTkSuQmCC")
bitmaps["boost"]["mountaintop1"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAAAoAAAALCAIAAADJDItPAAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOwgAADsIBFShKgAAAAOpJREFUKFNljutqwkAQRufxokJBTawimrQKDQqCQRAvrT9a2lqRKqIR8ZLoRnNDXd0YH68jgkqFAzvzneVjIGOPlc+ax2z/4F5Y7FY1SopHHWQy7PZbvnd1ZzS6LFMChXHHdbSD5/zTmEyoAdXeN9ubV3FTwzwHfked7ca4RP5NDbbCQG1v1gSr8BMeyPbWXFfN1cS2puqgBQYZ0e1Sm/U/3itsZ7qOXlLkfE5CspkE/DQbCC7PT4+2NUMtv6QEPshHAwhIoiCmeZwweqsrza9XSTytfIRD4PyciHKJ+EMqGY4JIZzv9D0R7g9mB7JYrREIVQAAAABJRU5ErkJggg==")
bitmaps["boost"]["mountaintop3"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAAAsAAAAICAIAAACgWpLfAAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOwgAADsIBFShKgAAAANdJREFUKFNj2LwhpWLLtNh5E0My44MDPTERw/xV2XmbZkd1NwTHhaLJQRBDw/L61A3zwyvygsN8ERJBXnA2Q8mKjsRVs0NzkpFFQexg7+BI/5C0WJCKhAWTQ9NiQRJhPsHxoaGZ8eElmRENpdHdjYlz+hjKVnUmr5gVUVUQlpscUV0Q09ecOG9C+srpxesmVW2c2Lm+iaFjdW3+nuUpq+cmrZiRtnF+yebprRva+zc0LNuQv35T1sEdKQwb1ia3LyuvXFxXubCmYXHl/BWZB7cnH9sFQ7uSAak8diIr8IqZAAAAAElFTkSuQmCC")
bitmaps["boost"]["mushroom0"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAABsAAAARCAIAAACjLUBkAAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOwgAADsIBFShKgAAABCdJREFUOE9tlOlTWlcYh+//JDqxTTTGtKaCKzFqjeSKSo2yKKhlcaCyKGJEkUUlKotiVbSIKFw0xgXBiAubYEJAJtpEzDStmhjysZdAtdLOPB/eOed3nrn3Pe+9gMsGxnDaQMc6aF2pmDHipDoKf4rOm6TTJtj1v/KJmnbCaFscTTtpvIM2yRVM08YNjxcWKrctoMMKUwGza624MtrXsLoFfJeJxzBK6o0KmnZAIG+XPaHLuRQ5p0HKa+zpoHUL6D2d9A4xlzoqxRtUzfMytlEoMbH0i/hNCzbmjRs317BaM4lpluLnR6lqsbiTrqWASyBqozhjC33Ljr61UZS+XnLHUpJpKc18jsmeIpWL+FSOoqdRO0iAxlgL0ikz6cUa1mEDo0ZYNwmRmCZx/ay6W9MHDXf7elj+RtBd+K0TiXBmJyWCRLjup7l5lO1phUGn4o9ICIaRXxYkc4u1u1YQ2LJUTJmJsI6iVw2O9fuf6c69GxdB119W6BWx1JV3I1GXneTKSXlZgz7dWoqEA58Czi2NtE0hIpo0/aYW2woIQM9quFA3aUYpU4hCSzNfTg6+vA/FOJKwPUXpCToYd8E3Byz8ZfJ0Z9kg5jRNyLnGJxCEBaQmVsOcol3aZhe1XgRcl7rIceBQxPIUpSXoYFz5qa+bsRcH7ng4HNxTi7mqXoahd0JfDTAgKU0t1jVXvRG2wJZL3dnu6j4u35WTnKCLgkR4im+/Hez8/MYbCQdhjnVKeT+fqFdxxukA2aiQtjVtldwJMms/+XcjJweRd69PNxdfPka7clP+4/rK18JdePNIxv3o2zx3rcNNmCODDJXo51EmQNcOTDVgnKhk9/00f+OjQzE7yKrzlGQ44aeLHY67EPDVex/94MXci18XvFKQGl0pz4L7YCu92yVqpakYAH+4c7EyL5aAo270TXgbrq9cMKjkV/ji8OTAucd2tr18JOP9I01yoZKdKARc2IvSxV0tdCUd6Onjrpbfu3b+Ou781AAd98fi9EVoL9qT4wDcEx8WmRCzPMwSSHlUdQsg7OetYLITtq9AJvnJmA9Lv30+3I/f7PvQudsKd/nfMUdOygSlonmsj6phAhxVt/Gna9vXQCLgGfq4b7/URd75/1yb2yu7e5mBdcbqQraUVz+nFE5SgCbd0AgVt/1/30YUJCLEI5851qLvGw7CM/hhZfaAQ4qNgQOVbH1wW0v4kdPLwetVbEg0O18FkCElu48/U1difZCxk3vDgbw+gMgkL4g8FLeezCjD00O/PxUEmXW+6jxfdf4+BWNn1EiYxKanXQT9EBMST5jrX6yCAM8sJM2rW4aFMjZZQwZ1OPRy2fc7pZl7lbneqlzPwyxP2Xc+XIGfWhXgNgQ7aSEZ73BU8nZ25Nhq2ttcahiXE/RywTxvdrEW/qE5beDf6FgU5dVvNzgAAAAASUVORK5CYII=")
bitmaps["boost"]["mushroom1"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAABMAAAAOCAIAAABCerDeAAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOwgAADsIBFShKgAAAAiZJREFUOE9jKNi0qH/p9B3z+q9NqL9VknApyPqCt8kFL2N05G1yMcTuUmvxmbXzN69f2LF4CsOcZTNu7Vn/6erxr3cvvj+642Ze5EV/C3RtXsYXfc1uZAR/OL33+4s7X+5cOL10KsP9vRt+vLz349V9CHo8pelyqD2aNiC6FGh1rz4HrvLD2f0MX+9chGv7/vzOo4n1l0Pt0LQB0cUAy9tlSV/vXYIqfnGXAagaru3juYPX0wIu+pqiaQMhb5PL4Q5P53R/e3j1+4u7QMTw5da57y/vfX92+8PJ3Tcygy/6mWHoASMw41KQzeNpLZ+vnfx08QjDrZL4R5Ob7tZnX45wvAC0DaIIqscEGNRX4z2vxnlAgw0oEmgJEol1ZwAKXQq2AXoDPTJ8TG/mhL9YNfPT5WMfz+x/PK0Vptn4oo/pBR8TBhTVMHQpwPJOVdqb3Wu/3r8C8svzO0C/XEvyRlaDTae38a2iuLd71317dB0akq/uf7p0FBgKyMqw6jQBxs3n66fg2r4/u/Xu0JYr0S5wNed9zbDrvN9a9PH8IZA7X9wFxuHbA5vuNedDgv28j+nRMIfVuVEMZ/0sznujRqC38dUE70eTG19uWPBi7dwns7vu1mVfS/W/lhpwvTjuVHXGlLq80tm9DEuLEtanBe+Pdjsb6Xwl2e9qit/lGPfL0a7X0gJvVaTcaSm82115f1rroyVTnm5a/Pzo9isn9xaumJW7cRYAGCHQPwmzuiAAAAAASUVORK5CYII=")
bitmaps["boost"]["mushroom3"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAAA0AAAAJCAIAAABmGDE9AAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOwgAADsIBFShKgAAAAORJREFUKFNjuHYoomV+Ttn6OYsr0s76W1z0MsKCvI1B6qYvTS3ZMa95RvvG7PDjYQ7n/C0ueJugKQWp2705qnNHV8HWRbVze6c3FS4tit+QFrw/yuVchNPVZN9ryX5XYlxB6i7tj9i8I71nR0fp9lnZm+dnrp5VNL+vu7PyyMSGJxsXPdu85PGiSSB1EHR6b/S6bVm9O9obt/VVbezLWD9/6/Hdb1/d+/j6IRAh1CGjI7tiC3YsXn5059uXhNQV7l0548DmNwTU7Y4tObBqwr6NBNQB3dq/tblp99oXz++C1L1+CAB+Q9rwdR02EwAAAABJRU5ErkJggg==")
bitmaps["boost"]["pepper0"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAIAAACQkWg2AAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOwgAADsIBFShKgAAAAshJREFUOE9dz/tPUmEcBvDzz3hZOUBDRE1JyXkvyXMQOQIHAUFREC+gJ1sauuxw0+SqwJGL4N30xBxQmtk017rZ1lo2XDONP6OX2VZze358Pu/7fKHPB5L/c/gSpdZaIiHYF0BxEu92DGnduCmoSVCCj2/EoHAVrESR+z691jmo8Y1i/inMi2O+cc2ya4aU7seFoHAVuGfhjqgbdQ0JZtQIMdjuRzGvDPObDF6cWuWDwj/wdqctSQlMTlQasCA2IWyt5U1g8iCiCPLF7hHtiisc4oNVfwGYHokKjf7eXtIonnsEWxHYWtM0LpEF+IoQInJq5GEHWHXwAs2Ao9228JIEj04q5qfFdrzVhvGttc2Wxrujatl8iyIEi93K9oANd2li63zo/b4osowNRwm1y6x7qOobqVUbK6REFWKBmye08kvgUcrCT82k6tV2K7SxIhgIjGschFUuXK5grZfQl6oKZno4Si+syOyBQUSuLvmCnfQ1H4Ojn4QHtPO2aaUoxquON3A3bxZsl9AOaxgJefFqP2fC0aj38SROVXtw2ryoT1KtkC442W8eW5C27ML1iYZKqrRgrzDv5EbO98Lcb+zcL5zrR7x8o5Un84yoo/ZZLx/q9E9NG3riYjjZyN0qYybY9E+V7FOUd1pdlqJnpfKzf7Bywji3y66UhaYIfydEjOkpuTDRVL3FYW2y6fvlzJRSdBHy/LIYTznMFCMbJN5RoptpxfwTBmcvFEXqY3UVoL1RzIgVMz401547TOnEs99L5GkdJwPoWXu80t7HcsxHDNh10FoZc6Mkf51N3yii7VSXnzzoT1NL6e3VczuRAr8xsgB4XX+rjxjpXnSa/CoIVDMpolFFtHco74x0gOcvFuZ+tt1L5edkzgCgkWuwE2Me9fN1wSWgAZBk5X2VIBcRb3pr8cw4nGJeu2xnwJ3bwy4L6YOPD7A/BmaB1X3KE+gAAAAASUVORK5CYII=")
bitmaps["boost"]["pepper1"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAAAgAAAANCAIAAAAboLhvAAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOwgAADsIBFShKgAAAAUBJREFUKFNjSFzYG9ofFdLnGdiakLIoNHVRWNyMmvzV0xniZjeF9IWG9HkEtMQnLwxLXRwaOy0vZclUhsj+hLA+z+BeX/+G7OQF4amLQ+JmpCct7GfIbnZM7HIN7Q0Jbs1PgUjMTE9eMolhpavR5Fz79DkhqSBzQoAodnpWytIpDNut9I57GOxKsVxTbN861bdsbmD8tIykRRMZDprq3DZWv2WqccNC47K99slAw+a+wOSZNQwXnCzuRwfed7e9p696z1Dtjpn6kirnrCnpDPfSY58tnvmkt/m+vck9AzUg2plmVTg5kuHp1O4XuzY8Xzn/vpc9SEJf9WCgdUF7CsOLzStfbF/zdErXPTugDlWgxCFvh6KuGgag8mdLZz+MCbpnqA6yBijh61w+pYvhxaYVj5sr75loQURBEn4uldN7Acz5k9BCLbT5AAAAAElFTkSuQmCC")
bitmaps["boost"]["pepper3"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAAAkAAAAICAIAAACkr0LiAAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOwgAADsIBFShKgAAAAMNJREFUGFdjuLLL/eou94OrXaYsSMxf2F08pW12fsr5CN/HS2aC5I6scZ48K7JsfmdXQ8neILeLNob3bA0fV+aB5LYudKyZmN7RXnXM0+6WicYdQ9Wbphr37YxAcuvnOlT0pk2pyrthqXfXQPWOodotU81bploguW2Lneonp9dNal2eEbsuIXRtQuiq5IjFmbEguePrXebO9K2cXlTal1fZnQ1E5T05pb25IDmQ9AaXTQucl053REJOUDkIAnoGgXZ5AABysXAbqNsGJAAAAABJRU5ErkJggg==")
bitmaps["boost"]["pineapple0"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAABoAAAASCAIAAADKe1n0AAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOwgAADsIBFShKgAAAA+ZJREFUOE9103tTGlcYB2A+RwgkoEWJJbE2NqPEJH+YaJPR3QWCYLWEKtREDdaoSEV3ud8EjCACIntluaiAiJdJp51m2sbkW/UsELW0nfnNztmZfZ9937NneWdMb5Z4Ys2vjufWFZ7HsO2uasM4Smxo8bAy/APifoLY7sGoTOF9qk3ZJgqxmeLmQmVjg50Ehf8Ox5Wohx566sX+lio0DmO3Ycd9ZeiNIrQGOx5xt+iXENoB23uUQaM6jmlxm76cWqhuFsj+q1A9vEPqAUsMeEmj/iAxsr0MyiBUBjuGINcMjHXDaAewOA7rQpxDiFuh8D3VpldfVneTpKrJAuGts1Mr+bXZvP97NqaO2RDnMFePdUE2BYx21i2OQzthTM69wN79PGIwlpJRarTJAuHNvqN0xTgYQR1bUYYssGsCQm/X2rkH1cb8zMlg9A4YvLa5ekMxHiX/izOc0JqdZYV7AHH2wy4tZNdBmLzGXVpXA9u/UUd+NJb/pztjlRhJLoLt557G7kDYAwgbvFrfFMTZq0kuvjraSZFIkwXCM1WiY+ymMqiDgcUVyCCsh3OvELVJG80qvP3jjH+p6K1QfU0WCM/NTE+WUyOJFcT56KIewi4/AgiMfj4uWKcqqDbk3gbJFye0vMkC4eHE0MK+ZywXVYX0ECb7h4IBqM41FohDro6YJvJRe2YOJ4dPmWaRd0T1+ZgpwzGpxd0K7/DFQatx4FPWFxyHYB3T/q+9Kc0EFdYfpKZOCGvJmSbhKn3/kjtlemniW+seqj/ENTso4np8wYF6jf3WS2/bfECid0lnfW30jug9Kz5jv9plx8w5n6Gcnj3dTVDPj+jGPnI/GeAJ4tnP+TXdfkK9tQTbuYOisnX4Iq2F9I1jUnBKCcq48JgU/sHyP+WufcwKfqMlcX+P2TE+uZ80H7gyxEB9KzmuLu7gsKng+44MjAWUoClLSHJCCT9k+R9z/E/gmuWfs/y/GJDrYP2eEETM7faZLg/+eroUsxasDDEIxAYHQuDPTOWIKeMi0z14UlQlOQv0chFgld/eTNtaWY94LygKzLWH39yqknd9ucXZw220YAH/foMDcAJXmI6TkazxPHvjHLRT6+VDhluA7gB3nuG/SwgZd0vMIgnOtzmmpJtL0l9Sokqmz5J3zlRTYUrX4MrUwwA1+VMlspcd5HrJXjvcvEm7xLSrpbAuOosL/6Sv10cGY+YDItcrqWdauj7XnlyTVKKtSXLUVIxY9uwNLk/2oznzQil0xsprHD/vF2+vfBGebwuY2reWJYWA6NddAWjwd0JAOlo8M9KMp4Vxi8EDkSUJGexepS2vK/G/AbhzfvwKVxziAAAAAElFTkSuQmCC")
bitmaps["boost"]["pineapple1"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAAA4AAAASCAIAAADkPnhmAAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOwgAADsIBFShKgAAAAkRJREFUOE9dkP9PEmEcx5+/wxMUMKgIJcsc0Vo/ZHNues8ddEHlHDFpLRvLrOla3XMHh3xJQC9RkYDj2wG1IhfF2tpyleh/1XOHIrW99+zzPJ/X8/58AfTqBOQuO5O+u/mkO5dwJB5QoVsUNw5ZCx2ecmc4bz218HFjaS8JnPFZiIZh4Joj/oyOv4aBG8qVvUCyZsjbHGs+Zhu5c5ynkQF3tpbxE8laYGCaFBYgGoOsGXMKikap4DQVounIlDv7CjApjgrOKDk0SnI0ZK0dTkFZK0R25TM/dlucB474ChS8JDus2oyTaukT1ALZEdyMOowHQMFN8nMksqvoKdcryF9hxIeARCMkuk6iyf/SvaKCV13p50C9WEhkU/70pNXqx0Xo8M3ZUrSDqkKnA2FB9mRlyOpcY+ar67gByz8EwlAHPQ6ogJ0R/d7aW0CHZ7qLVFE8cidQUAqZH0cvhTMubyEBXLssJUx0UZxz8ecfhU2LMaNHOPckYiru6vYr+lblIpj7sMNsvoC8siwnZ46IQ/XsQFPSfCtoGjltU9L+qhBH1b5DWQP89cg9KXY/5sBmK3Hj14L2QCYOq8QRPmWiXSH+lLD6cQz8DdFfFqSsLZfWfZEUDnt0hbnG+mCWG6qs6oG/mRZlX1seaGMb1eOgrATYFaPtMvF9R1sKGVIrRvB0T3wvTyoect/njcGioC8KhvobXWtb+7vY32ljP6+pxXRg6VO8VbGrKFGL6rdenkksmmL+s5vLxnpM9+OdBhv/zGukgOEvdM8yN5+qBUMAAAAASUVORK5CYII=")
bitmaps["boost"]["pineapple3"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAAAkAAAAFCAIAAAAYMVE8AAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOwgAADsIBFShKgAAAAINJREFUGFdjOLYreevmjNYNnRUb+vassDq1Uu7oUoXlXWoduboguZ1b03o2NhVvmbZ+hceJFfLrJqpOrdKaU68Bkju0I2XB+sKi7XMXrowD6ts/X3HHLOUDCxRBckC0fENuwe6lXauqTq1SPL1KDoKgcus3ZVVun1W2fuKuldZQuVVyAEO+Sk6Yd8cHAAAAAElFTkSuQmCC")
bitmaps["boost"]["pinetree0"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAABgAAAAMCAIAAAD3UuoiAAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOwgAADsIBFShKgAAAAlxJREFUOE+FkmtPGkEUhvkxO5JaQBRWIBIloTXWAkoXEVZFKaJc3QVtkUpD6UWpvdhiakEUL1yMdhVcLiqh0TYN9Wd1Jtxs/dDk/TBnct5nzjlzONdlTTxN2s721dEgl5ZjlKQpQEkxpFooBZSM65F3LQ2r1pcmmK3Z89RiZTNeoC9L2uuymvO7rImlSAu7ff8DfcNWNzdvILSNkkEWFP9Jv2rNr0usmotpzy/mlDUg0M+iKrI3YWI2el5NYnM3KX/LgWM2HJuTAmc3DCGOt3DPkFl3XR7WQSfpgWc79OhBBH+ug3lNJzB1ArID+WE4i4MRAXjER5djQkhp9yrkocmxoxh11QB9Sw74Eh4i+U7ge1BrBL4JjB2A4AMtDzwWYW4JZhVjE52YWQRIIdeM476hwZX5kfhbS2H/I+v/XiQQ6Dg1sLjrJZlY77KFS8kxiwjo+GCqC7PjAJ5JIdAL4A0CuSQYfMMtgeUoXk4b9yIUu8GyhurFEAJVcoOfk1OOfFy3vdoXNANomBEjD+wI1gJbgyGsyIFGUxOgZYKn/URseSaf2Mlaf5wNI1D1XJ1liNBJkMx8Ub6x1YfyH0nbPD29ry3jRzF/KcKyo9ULDdqjY4YI5Fb0yTU8QNz2NDfgn/PdBaX6a3C6lIzm3FclLapoK006C3FNNNg+r2jk1W3wgxr+ploJ0hdG8igaKoSLeT2nnH0Y3rWaTjb7wjM3UxtrfVsStG52NIE7XoVu7z1dTjCn4xwmBb+f1mc+iQPaVmqrlub7Dc1JgL2bS4raXb28eSWxs+qsHBzmTH8AwIc5SFOPNSMAAAAASUVORK5CYII=")
bitmaps["boost"]["pinetree1"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAABIAAAAMCAIAAADgcHrrAAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOwgAADsIBFShKgAAAAZBJREFUKFOFUllLAlEUvj/mHodMzW2cEcUEKyi0MhdybDPLpdJxKwsNW62EEJLKVmh9iJ5aoId+XGdQR8uH4Hu45zvfd5Z7L3HVS0zKSkVOBog8ldAIeRDNTNqqL4w7a4Xp1+vo1+P69yUZPE51iJpSmcESCtGMToR6dchZ3fDeVkKfT8SyO0uTnZ7fWGJpjKVJHpZNGKJZlRuYfK4RdtOLrKyDGR0IfZIawygLPg1MqCUyqEWPMmO3bs8GXy6IJj/cGAnrQaAPPGpwq2DeQBMcXTTSaR0NGUDQMiGWzY+NHGR9V0fhj3tiK4cZ0UrDBvCqYU5P4yzgWdCCX4OMZFvhKFZMcNjKvrMQuDsR386I96bSXwoBpiNGSYGzYR8cEkPstiSt1ACkzJq1Ic9FOfJ+S4TnU8d+rLnMP+AVaYttLzyFu/kfqmzR062Q3+DPuTfncJ2XyGi9pMzaW2xThJfWUstoC/itAOk/jHQmWl+kG5z0vHFpl56MnRiL7nai3Ueu3UKSg7iJEQzKFZsq6/gBdrG+3fkcURoAAAAASUVORK5CYII=")
bitmaps["boost"]["pinetree3"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAAA4AAAAFCAIAAAD67UpFAAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOwgAADsIBFShKgAAAAJNJREFUGFdj2LvKARlNnhmYvGm2S0++Sp65cp4ZHAG5GEpnBSZtmGnblqySZwFTZKlZ6GBY5o2udNrsgIxtc71n1BnV+OuUu+mWuxvXBDq2Zfj1VaMrXTzfs2ZLd+rWRVHLJgfOagqe0xq9dFL8imnxy6eiK9210nHZssCGLR0l26YWbZ5StHly8ebJNWubq1fVAwDP2mQSr4nZIgAAAABJRU5ErkJggg==")
bitmaps["boost"]["pumpkin0"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAABsAAAAQCAIAAABocZPBAAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOwgAADsIBFShKgAAAA35JREFUOE+NkP9PGncYx+9/8VCoOFu7pUv2pc26pFmzpVp1S0xXriAghyJFDbVFaQSqVVC+3HEc3zv8AkIRRDwOEHEiXddZrcma2GoVQef8K/ahGkV/sEte90nu+byfV57PA73Jcs7hdYYTjAo0gZ4ur6ZzQq30Px6fFi1nzsZK+YRxLsUfoHXiiEto1QixXtGUXZEkn8fbz8RK+YTRGeu+TzkFpl4x/3or8o2wX4pGPf0p7EyslPOMK0uc/thQi98ikjW01TEldUwxelMQsClSjjPJUs4zLqZ5vVG9gOgTc69KbsGtjZ8Ju+8KQw5NXP/y93vZBS5gOYOsnu46ZQR3rxaR9DwvneJlF+55qXZpxMIf7BDfuQKMKOcr7vDD1hBhn+l0U104pSRo5XQCBV7wmmPJkRGU/sogS2nueLyjMxvsyASGZp88jOj5kxbBI27bzxcltxii5usIruYHLNKwWRSbQKkxEe2TpAOmuDqdal5d4qxli0DgW8kgyZTAFlMo5mxowsebGeVNuZGgm+OziR2D8o7bXU2XZI2VbYLveQblHZde4DFq3KqQjU+6ulsDZEtiUh8rSk+MkQTaM+9Aaa/8OeF6JovYfl0kawnyvo6QJfEf3xrY6yPwWx28NlKVMt30Y02r+LV3eM02XrGFs2jyF7l3BKXH9THN/EcptDDfrKdU7dTo4MSTP+0/bVgvf8BZ2zjzHc5ex9lbWMUOBuexsp0iMPjdxFg7GCP/sQgA4QTZ0OMblsY9Lkr+OoNAz6guGe3u82tfepr2ArX/+n8omMvzeDH9P9nEK4N2RB4i+qhhOimENJRWEbHQk227wcaDcOPBVF3Bwjw0FoiKXSsbnKX9gC0T/N4AxjypvDF//XTssZRygTGhBzGHI6jammoq6orG2gJR/t5QvmFkFBw1+2PfAmlp87apbFXLSqqqQeCkiF9wO1rap53aWQ2kjFoTfslBuKGoC9Xv+27kcXixv+qPp5U555f7E9/t2qqOOwE5rGxNxwz2XH4xwN42HW0TQJH13ZN6xawRGgrplr13jwYM1u45P89hcERZM6eu/mC5uOe+UiAvHLcdsmlkJFTVYWXNRsnbX5mvDniU0qgdMgTUf4/ePgjXgw3+M3Ytb2bkTDBIp9TVm8ZysMSC+dTKADlT2YqW5Xv0BRgWjHxYXMcvWV0S8cxv/wFqhenEtw0OXAAAAABJRU5ErkJggg==")
bitmaps["boost"]["pumpkin1"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAABIAAAAJCAIAAACwvetYAAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOwgAADsIBFShKgAAAAX9JREFUKFNjyNq9MnnLkuT1CxLWLYhfOTt7bld5cVBplGFRqHZumkvyxPqY+RPSFk9qXdC8YXbqzPmVOWtmZuxexTB/YdHm2bGHZwZMn1nYO71oz1SfaxN1bvarXOtVudSvu2+y1+opURemOtyaavRgqvr9qZo7Z4aXr+hnuDPL+N5UzQdTNW5N1bk5Vef+FPVHU1QeT1F+BEIqQO7dKZqPpqg+BgsCEVDx7pkhDC9Xez6ZpvZ4KkiISHR3qjbDq/WBT2ZoQLQ9ma7+dJYOkERWBET3J6vcngi0ECEC1BbwZLra7YlqdyapPplr9GKpHVAnsooHk5Uv9GjuadYHKoALMrxY6f54qsrhdt0TndoP51m8WO70dLYuXBqIHk5RvtSrsa7W+HiHzoPJUB8yPJtn8nCKyuZ6o70t+vdmGDxbYP5kphZcDwTdnaS6u1l/Y73RHZhTGR5PU304WQUotK9F/+4kNaDHnkxD8QYQPZysfL5Hc2W1KdBaoOWPpygDAHq5AmWIK4vxAAAAAElFTkSuQmCC")
bitmaps["boost"]["pumpkin3"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAAAsAAAAHCAIAAABRDCAKAAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOwgAADsIBFShKgAAAAMZJREFUGFdjuHg0YcKa4qLti+YtLLw91ejxFGU4ujNRdX2dMcOlYwkrN2dW7ZxVtXbK1tkxD6dqwFU8mqJ8sE0XpOLIvsRpO+qLdy7sWNV5apbnEyRjbk9UBam4cDRh7960yTuaKnbN71rfs3xJ1ub5cXtnB5yZYX9vqh5IBUTR/n2p87eXd2zvatnS27BlasOGSV2rWhYszYeqgKAzhxL27U7atDVl1tq8zpVlpcubSpc0Mlw+loCJLh1NOL0/bsPqiDUrwgHsH4gNs4dE+AAAAABJRU5ErkJggg==")
bitmaps["boost"]["rose0"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAABYAAAAQCAIAAACdjxhxAAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOwgAADsIBFShKgAAAA3RJREFUOE9tkotPGlkUxvlrZmTGcZjuBuQxgDzTNq1rs001dkNxW1yUreyW4qMg5VUfoBREFxFheKgorVVBZBAj+ECtq6v9i/ZYutmmaXJyc3PunN/9vu8O57qu+7rOD3XMRr9tzWld8Viznje5kbW8oV598s1nX9cXxFVdd3agX2XNke1haylqW5mbmxzxzXqt61FbMTxXtBd2jZdH3wfdIC6OnlT2DLGdIWuFefkh5pifXDLrSu2S5CNNYLDXGZ38s8C42eBmue+7FA7cX91/6i/7Bsor9nggMmLMPr6zrKJCIq5bgCTbyC39/bGg07SZcJRCQDk90H+LgFZqx/Ic5qO+d7p7GTnhF6IuPuLmI14BOiNqYlVUUd8+GvYaP8SHS38xJWu91gMX/48A8FAlYUmH13o6JlpROx8Z5SMxCRaXYCkaDwmb0jR+cVew/esDR9BlzMX6K9lo6dUN5fg/xOyOY2ArFXSYGRqfEja5BGhMjI23ovNiLqwOPgKIf9TU1e0fD7o0Mx5L7+qCsZJbYG0nNX1DC8e9Mz3MvC12qidb0QUJtiLFl6V4hsbfy5qnhOhrPgKdaw31SUNda2+ddtBh14unucX+6vpy2XJ+qP8ECAubmfbbD9WUk48wNAb+wY6Lj3oEKOxXpc0bMgJwIKRBOeug/T77b4UlkH9S67lBDOUT6Vd9dRVvXIQdKsmKoiVJ414BZInA5LmaV1OSEE1UjB0pSaCAo3xflykbDRVG69XPiME8k7L1f1TzFiV4UMSdFXEXJVixjThQkmcqXkFOsG0tgM5IcTiC5rX2h+ovd54vBsz5+XHWt7H7O2eQTbyeHs0pSDjeU7TsK8hjJXmp5oF/EA9BgJYrDXWsImEfEXMvtbdqXdq+t87udKC3mLTvxznjxQkTExx7oNiUE6cqHihvhAd1ouJBrtC/SUFDgaOwiMsqyf1OTae3Vzn1rDM7Y6q+42SKf5g2EiNDxmkxBuFtyYlLNfW3mgdylmickeAw2SCCryQ8mYzY7NZonT+L3jx8mPYP7KY5W2Xji3JqIOp3dyjgvwgKuQDKSpthGKrU1nLx+S2gPqp44IWREaFnt2Xudnri8aPloL0Y4uztGbxswLiecDnMQSkBbxkRYykJvi0nwAik0Jj/ooLG4yrK8PKe2POTYsrQnYtMbI/9Cx51/RDmA0F7AAAAAElFTkSuQmCC")
bitmaps["boost"]["rose1"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAABEAAAAJCAIAAABbilBbAAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOwgAADsIBFShKgAAAAaZJREFUKFMtUGlLW0EUnV+T53uTycyzkpi8LXkrCqIpfoiI39q6FVuQghRKm2hQW5emWJDY1CjaWkSpKxUsatW61Kamv8ijEc6HO3fuufecQ3Yz3ttGaU5Xvpr0i0mXDLpmhSfj0ptoCJ2qr/731WpQf542ZnKDj1ZL/Yfr5NhTs9FQ2VDyMWm8UcpFpZGYhPqbGf5uMfD/efe0i7Qx8e5Vz/Yy+e2KsYRy7PB9O7Jg0HwsBGD0jyeOHP5JV4qacuJw0K6bGrb6Op6uFMmlJ0o6LSTkjwm5pCu7KfbL4Reu2E6yvVQEu5ZMii80q8GDw67mgdI0WbU53j/tyIHNTx1e8QQ8QA/M4Nq1r566HPWsJleC+qOOoO99low+tDeS7NwVEFNzDJy5AmGgf+vEVyFyJiHvOfwg42fy3eTlUO+UpsDxZpJVPPXKEzi4bNCyTjFaWwGpCwjWYhudfpBtJ8+KE8NpezJeV4jLYK6YYUwDP1KRv3eJAZeugLyyxT48brKGW0nv+nzu9fOCyRDxrKYs6nQnyaANTmqE+zsG/eyqT160aCNtN1jns+KXnkf/AAAAAElFTkSuQmCC")
bitmaps["boost"]["rose3"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAAAkAAAAJCAIAAABv85FHAAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOwgAADsIBFShKgAAAAORJREFUGFdjOL8nfPmWnJwN86orMvqttVbaam+y1znnqn/WVZ/h2qGIrdtSincuKJjZ3Rzg2GepPtFSY5Wt9gpbbZDcwV3x7Tt6MtfOa6rLn2ir22KuNtNKc7GNFkju/P6oNduyirfNKZ3btzHMZZat9gkX/YtuBiA5IDqxJ2bClsac9QsW1mTvDLI/6Wtx0cMYKndmX/SCbWV5e1bkrZ7d31W9sDxtf5Q7VO7KwYjje2LnbK/K378ybcvilDVzqmZ1QeUg6PLByG070mZvq6zYtzB7z0oUOYj0xQORZ/dFbd2eBgDMPoPHYyEVRwAAAABJRU5ErkJggg==")
bitmaps["boost"]["spider0"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAABsAAAAQCAIAAABocZPBAAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOwgAADsIBFShKgAAAA59JREFUOE91k3tXGlcUxflgTavGt+C9MwwMTwcYEATUGZCHWFCCEutb0SgFQXk2YjRFBEEEMSFpV5O+PlHPhLUSy0rW2v/MPXN/9+6zzxX98455rL/fMb+3dOmibb6w4syFHJmgMxvynT07vpx+29D91WbubvXbFy7XS6E698vK0kXo+sb48e0XQjfxwxvdeW12vp5gL080L1ZVGwH1fthQiLsr0eOy59fq1E55abqa0p0nNNENJh+1NC/j1YXfHvSfCd3E9r0hXN9jr/OKoIvUEgQ1QqqRfN7OpCL81aH/ast6daxNReR+jtTL6UWHoZiJlBfbLcNnQjfxvsFy92fa5C6w0PATNPQdCKOnANWkDpjzhDq5K/PNYNSPx3qkTjNTiK+XQtX65B9vdNAxIHQTmw3WXsvSy248+kMH1xGhIeTPffTRuizkwfJRNPI9ViNqza/JHbqKkfXK80KNe98SvIv+bOvetwxwNdBDk63cTlpLJzLHJOx5TMTkEOmykMtewqyCu8MnXpiRbgbpozVNat9QynkfMpe1aYF43zTu3K072xdcq+CpJ1aLIeOrGDXLdhEROYg5I3aYEO5Hkj5k0eBlDxmeJ7026ZRWtRW0VnO5CicQU1W3s5HVF9MTL2NM4RikPo1IPVb0f9dIOY5nDZiRYvCrEONFBwq5YQWJe+FsOjhnKZ3mK9y/QHxR8ZvPDuXTeoIWSzlWthGQ763A4RgQj6EAGu/D4h5EDCCHCQfnMG8UcMNPSJNKHdu01XL5ymyHGDAXkzTEJ+6FDVg6RJiU2GPFXhtC/V+InyT8o5cjP494U6dKMFLZTz9qsod8KRot++p3k6LkjZe7TWlP9mQeG5YJIaKxHqFZspHuVoKgpKPwjAERg0JVjQg/L9sJqU722FdxmPy12qao2TBuXy9ZXsdU8S3qmYuwM1gpQeN9X8GBYEIlvQgPABprMfggAjzptUvdU/SSc+I0wtfTotOqJ1jZhpcAN5fvh8kVL563Y45FwP0qFAT9VUqwSYGNCphKTA1jPEBQw8qQ21LOiLx3SfN1Wnf2szK2Sa0uEOB9Rg/DgeixbxJhnRwUjENQMJuSPkIpoaxadSQ8Vc2LzBdx1Zof3qmUNxF6udBKaDmEOPoNHAi8Q+4woQoxydKUy6KAcBK7pqu0r5EUGXMHMruu804F4X5MjWCFBOyg8afC5i4c6FM+BG8kAzy9uzyRObC8jrvKR+GbrWzV9R9IUTv8dIg/QAAAAABJRU5ErkJggg==")
bitmaps["boost"]["spider1"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAABYAAAAJCAIAAAC5VksiAAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOwgAADsIBFShKgAAAAYtJREFUKFN1UVsvA2EQ/X6YotVWW7ud8+19W9RqN6m2qitoXVqpW0gQikiUpIIHvAh/0CwPLiE5D19m5pxvzhnhvd5NP/YLzzeM/O2Z3qxQZoTGh77gZrEwi4KO9DAcBZuLtL3CFVKilB62u0vCmvekreiNonnYsXq72t4qmPNdhZnZGJRRkgla9NFdQlAK+amI5ufy/SNhr9WhRHkC+rj0XTQraFWJ4l8SHwhnPIvaAQX+Z1cWdPNgY/LhUkwNemazCjPDv9HEKCFOZjp8/5QIWzMG6rMkk2E3T7IdmCfbuUFPlF/6uetjY2tZ1gpwVcrG/uAzUhFSo4QEa2EKvKnsBFqrpq/MicrbDS9jne9puy2s1tAoEgv9qcLgjFwVvoOSgzzBSAEJMfN05faPjP11yXbqHpUnyZ74V4LrWjL0wummIlBj0lWF1W7ogS89K4yDc+KoM//wGWyHr6Ml+bpa0TaWy87BhgDFwfYYiMNIw1F5Q8qOhdO/+IyPUGVQ0jqBfbozfX9Rfrl+By7hyZ4LJCz9AAAAAElFTkSuQmCC")
bitmaps["boost"]["spider3"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAAAcAAAAKCAIAAAD3rtNaAAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOwgAADsIBFShKgAAAAM9JREFUGFdjKN40JXPDzJjlM8MmtwbkJvp52fv5ODJsXhNUt6YxdtmM4IpsPw9rP19H/5wEhuWronL2LIue0xcQ6OLv6xRQlulfVwgSzd+/Mm7JtKDE0KDK3KDOmoDyLIbtawO6N9el714Vt2R61LwJoZPbArPiGA5t9NqyNnDy2vzm1dVJ6+dHzu4LiPRjOLrJ8/BGrz3rfTesDs7ZvSxuxaygjBiQKATtW+9TvW922s6VcQsmIkQPbfCavySicWFeyfxyhCgEbV7itmKOKwBQR2pBQlMVJwAAAABJRU5ErkJggg==")
bitmaps["boost"]["strawberry0"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAABcAAAASCAIAAAA/hdJEAAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOwgAADsIBFShKgAAAA4hJREFUOE99kvtTGlcUx/e/cnfVOBVE1Fieu7CwIuWhtQqIr2AEViIiRRtNgrXg6vJQF8GFXViIroozTfqadpJMptPfks70L+ldQdNhOpn5zJm953zP955770Jvj9DP0GT6dzKTc6cJ/+kmxYaOGLxD0OJzLr/ne9J5l1/c+6qxO954OnVBx8urHZoWn1z+yHc3s4pGZuieIqN/XIzZq9tEzWOufW0XEgFus860q+cZ9a+5B29aLnxWc5gbp7Pjqaxjgw1Qp5FwYTVUoEJseJGNuQo7RHkRr1rwksuSi04UdoLHwXCBooqRJ+Uoc+L8Kdcnu1DVremL3KSYdgl7dn7XVnlK8jGysm4tr1nYDXM+jJcdRs5ipGdwOkCcBqyVIClQY+K68zwbuKSljEp2cUsMKUTBhuazeRM3beIdeM0ib14jsJIDY90YTxgLYwbGjZ2RmIhhdQNWN+J1E8lHZ6Rsg1HLLuPnW7holWsNPVbX30agM2CiEathmGDCqjhWMWMCjoNqGwNexQlucapOi8wQuBrI9XKP4P141Sq33elwUW8S9bdtt453SULQ2c60zhOtM20nD6ITPJ1jzOCOoSXhub30gzkbNpXGyLKO5LQ2Tutgta5jjUXQASO5mdeNcTpHQbPwYuT5vKJs6GUto7PxFQebWqolq5mHEPiRvIXvbPtbc5SvQCg4Y4+g7X45jKS++cJ99CVwAY6JlYEzrKcxjFwq4Uslet3fBSgRo97khruW//54Cnp27HGXD2a3I6xFc6WALwdQEC9UiC81aq7q/XsjGWcfWIIk6ARRUnVLgz3ytxKJB32TbGqtSEGrxch0LvlsfhKUrwbQayXSVME3D+Fdv+LboIq1PpBUyLWi6zUG/zaB3KiAVwt5nBOb3pdK+EQa8lXTSy/WOdPINRhB3QviX1vI3yzatKH1EUQakBtu1PC7ZeQfHn0XQG772y7nw32hzbCnxkAzwuFqbPliuA9MCI4Dan+uIR9z6Gu8LQUAlzfzyIcs+j7Udmm2Skokuv7Iy9OQl9tPhPxXShTQ2uSVEf7FBt+o2xaAprLrRw38MwmD0n1SRgHHIwve8j7k49KbwVmwlvmvQgZkWnTk72i5VPYhj3CwFn0kgRvpUPR3gUe9H/B/kQZ7qfiKRziE5irJ5e0ngkHdoQCAF70aRJuKTxlwtFd68FhgcHlZMQ4tJGO+Gv0vmIFSwKMJiI4AAAAASUVORK5CYII=")
bitmaps["boost"]["strawberry1"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAABQAAAAOCAIAAACgpqunAAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOwgAADsIBFShKgAAAAnRJREFUOE9tke1P01AUxvtfrS0gkW5jbuK2rvd27bqGbAyiEGBOdIQBKuNFRIkCQXBEh0pntm7t2BC6twSIxi+GGOM3NfEv8XQbaIjJL6e9z3Oee097ieGj3aHS9oC+2a9tyIWnkrYgFeYD+TlRWfS/mcH5EKeKXGoEp+LC+3igkJD02WBpPnyYjldShKQnhfyEPxfj1WFeC+F9ERdFvC+gbAgpEaQJXCboexVBOQmVECr7UJnDZV7SkiNGmsClgCkdsKjMNivYPlTi0D5COo+KGBX8SMcY3DY+XMSCOnGznCIELYqLAbP73MYlli+xze7mRueioHvlnCe85wlv90s7yUEtRfRnX/jTM3w2KOW9kuqRVU9I8Qy8c4u6F/JmRvMGVW8o476z5noeY/K+LkXsG1+aCilbxGjmifxy5fbsWEZgVK5T93R8cFJbt65G3t6AMGy0PGXLoc4DJ1WxkhUrXeuxAFmhb3R9kYjkd8ZXHyiiu8qQFRsN9chOjW31+YtsdNP1OtwNSxAhANWwdxi9nea7lVpKjBHDu+vPYkOgVm10zUrV7WTjOrkRZR4l7ErgimGnaozlFJGfB6mGHbZoYR6+J7PE3bV5lXfV4EBHF9TvK9Qvha7LdNlFGTazr+Egzyap3xp9FqeasXb40NlN3F+YPHJ2wxgwM0jf5qifu/QpbncAEP4So36k6a/T7XC9ZVkpYnk6WrXSQGvLE478JJMNRzsJ1K2WYzf5USLBuhBNGJJ4nBiHh8m/hgkoLS7p50B4LnnPgK+9ZPRY4FYuxvkvRm8XMbn6UPc5LhkAXEm1l64zfxWY/4SF3w5jmssCd+0P+6d12DQJpTEAAAAASUVORK5CYII=")
bitmaps["boost"]["strawberry3"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAAAsAAAAGCAIAAACaUPOvAAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOwgAADsIBFShKgAAAAJdJREFUGFdjuH44Eoh2bYlt3tJdNG/ikpTI/R5WRyKsDwVZ73Oz2udqBVVxeEd079bm3NVz+qvzDgTaXWm3vVBhs98dScXlA5FLt+TnbF1UMaFpa6TnyXSbU5moKoBoy/a0iu0zc+ZPmpsVC5SAI4SKI7vje7a0ZK2e01OTv9/NGouKSwejlm/Jzd60oK67dq+7LVSFqxUANzhozSG6Li0AAAAASUVORK5CYII=")
bitmaps["boost"]["stump0"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAACQAAAASCAIAAAC8Qet/AAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOwgAADsIBFShKgAAABLBJREFUSEullIlTGmcYxvljosZJUpuO5rBqbFJtmjYK3opyLLvAsgfLjWKQUy5RVE4hgiKixhgVZRdpJyYx6TSd9PiP+mLSpKXaTtOZZ5hvZ3be3/c8z7vwfnsprujVGfr1pfjH59JCWRXjrB4uYGEj+mJCU4hr9qLMXlS9FyV2E9huGtvN4AdpbTFp+S65dcS8fiGtmvNevKrnt/rlpfjkGNngGB/nN7Ex8nBZvr2EJb3ygEFpxXArirtJfFqNTyJK7YDCIES9WiThRfdXx8vJnSPqpxeSqoFvVQ0DzPOnsjzHBIrThmJCvptGUn7Mw6gMQ2rV1ybFbSfZETIL4s7RuFs0Z+Y/QJrp/gZi9AaOdchmLdjBWohzwYSqsW/1F9irZ8ijEh0sugzFuPxxEo05lTa5TttrV9+b1XTGzN9mbH2PAuKDsLKUoECFReWKY9CBNqv5tXT3BSXFl+bC41ycLSv+PPa9PsCAtMrpJ0pxxV4aTXpVDtys6farO1OTgg3f2KZ/DDDbM5LHQel2UFpYVJSTdDml5uJk1jVkHGoAGCG8Lo65lcXs6qHm9fMzmnsH++GZdJXVmYpxbDOGz5rNxoEAczdj69+fl++G0BV7/xzz5Sx9J0jfgV8f3hYfv38YxQFWTqoLYcWU9DrdXUMLLiIOSpqPTxZm11kGwoRS3pNAFRisXJbTGdgEth6m3YTHwF9zDx9GcDZGgJt57VdT4iYX1hwxfpN6IFiydMN5WtGyM4sA7GiJBq+W0asVWPcFXHZHMjOObCaYUibKWp89lcFKf4C9OZHkOJ2eS8nzEa0dW5zs25vHYAQUs+IYcGE357Wdee9oMao6StIQ2nZQ4lPdAov7Cwqo7cmcLMR0MIJKZ6eqUYnbZC5auham2Mwia3tx/IHHK5QJfTmNbi0ZHFjKOVKM4kCC6Bb0dx2yG2AxY++HQ94r3FvAlqd64WxHrsM9oLace9ijbGF66v4gvRPVd0VuEklXFyh2ZYG1vzpGfj6RAJLnOgrJ9zMavzYTQOHicP0tvyhAts+QX0CSoClJk5+4BVVNCBtMQ1dmqNtJS/eCtnNK3KjrrVfzK+n9XeTgVdQqF6/H6MNUqGhfK+m573EeUcqhy8FIQHEYVUHbeY/Qo2yFZDZ9Yw8f9MwxHcbBS+bhBj/RnpjoSox3QWGGgUuMoO4UczbpVDXE6E3EToqyYdmTtLKUNx7neOhuxmiTbYVgldVQ+Pr0iA25Zhi8bBU3evHWeU3nsrUn6xyMm+9Df+BMA6Gd46ZKlKCOGGnClfcUZpEs6pJzeR6Si1h1XTtzaGWPU2rYQOh8yy+GMFcdA2ARSpoc+www2t6L54V2rvi1VE891f+JStGB5iI82ZLPgLZBYrCE0PkpSZSe6oOSoC3j4GWw8m+J/YNqaX4dDRaRdtl6lIdGnJSwCe4OVXnxNhfabJNeswg/1fWdW/5/UeVLJ0Sfox6NvJDloVE3OdIIc+FbUYM+3sRZ4tcRombMRWNbCVM5xUMfBsnR0z+bqvf+v8CTpBVzUthGzMQl1jgdD8uFSUkrNFn96seolhLU04J6cqBBJW5RkvdRnx57tGRiE1lW/+ZE+jv+m28SC0nGXQAAAABJRU5ErkJggg==")
bitmaps["boost"]["stump1"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAABgAAAAMCAIAAAD3UuoiAAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOwgAADsIBFShKgAAAAcJJREFUOE+lkfdLAmEYx98/piypaNAUm5IFUXZqmlmdaYee47yutOE4t2ZaadO0PaS99z/XkxREHdGAzw/P8cJ3HSIOFqmgKWzr3guqbpfI+xXT8QyeYNpYvCpACJbsHRkXtuaQwB3SC89mtc8Z69MadRofcvSXU5J8SpJH6kSa2CRivMSCU36ZIOD5ZtGw7VMEiLoEI85G+u+WjU9p6mHVfBLXTBsb45ToKql/TFnO53TzdCuN8UAlR74Rb0AZf9/dMgkqF/PDybF2n64Wom15e+DIRtSXSWKDlcHt1daAx/WCfj+oChuEtLTgXeUNBIZgexQdnDE3xczN0A5gNVVRU+MsJZpSl473lsQsLWmHJMmIWbxyVMa3dr82+gR6TluzYXXYUA9pD6cH1l3SObrVriyaUJVGTU2pqa7UZBcMZFMU0VhBToJDBUAw3kGoz6OttimL3XhlhKxPjIg33NJdv3J1ohP2gkQjUIQrxUdeheBPwX5HURwK7vgUEA1GcQ5UgAQjK+Qs8hUE++VUBjdZOYwC69iVxRDhmxacoAjZEBgWeIaqHeqyUTn3kD8BWTHeb805QZ++/8z/hXgWjE9h/Bf2YjsQ5xbKLQAAAABJRU5ErkJggg==")
bitmaps["boost"]["stump3"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAAA0AAAAGCAIAAACXToPoAAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOwgAADsIBFShKgAAAANlJREFUGFdjSM/wzgnUzgnQzvVXz/VTBaLsYL20LP/4yc2Jq+fkb5zRuLolZeNChqwoy9wA9ZwATbA6tcxoq+SKxIRprSkbFlRsmb5wfeGmTRkdG1oZsuLtcwM0cv3VcoK0M+Ptkusy4hdMSt28qGbrlGUb8g/tSDm2K3nL5gyG1LaCtMKQtLyg1LKYpJ7KxKXTcjbPbdvYsXxjPlAFHDGkb1mSsmpWysoZKWvnZmxeVLxtbt/Gxm1b0pEVgdRVLa6pWFBbvqC6YmFtw+KKucuzdm5GUQFCu5IBIsB18CE3kEsAAAAASUVORK5CYII=")
bitmaps["boost"]["sunflower0"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAACMAAAAUCAIAAACIxBMbAAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOwgAADsIBFShKgAAABVBJREFUSEuVk/lbUlkYx/2XwBSVptSpp32m0rK0CRStVHIDFRNlccMtF0jUCJFKatQUUO7CpoALiqgplikgovM8NWY2uc8vcy4gIfXLPM/nl3vPe97P+Z773pDZEdL/xWokadAUifxh2Rs2o4dX1Mtj9Vf2Qw/A+6DKQH5imjaRTHqKEs1QoBkqdfqkgRxUIEepleqmQrSjVC2q0z+pG2rJ1cpYQ89M+pSZ45WBhMyOkgKZHiFBmgf1aHUR2s6AWh8hwlqY141kjQ0nY11GSaPDKc0wt2RIIhtnzdruLC9ef/cuocNUnqHvlSG5FiM5sFsgwaZhfSofKWMbnskmuS/HWNW6pjykkwEJ6wbLxTBDr0uFNfc5qscCY61z8frBWuThOmFn9aRlJiUVkrVDj8yG5KCGfoJN4PgcXVuXmfO34+In+7n5uVvK8awGbTUdFueppQ0D7CfKoiJlc+8Yfdt1+nA9HLDnjlqy3aT0S8DqoPrBsJ5iMf0kWbBJDBVUmEQTcxRwWKzRWsTO6qklW1y3gVY4IKDK26l9Qnpfs9qcBpa8pn13pMN2LfmVkCbnlw3W1kEVEhW9B8kCFwC+hb/zDyZVQaWxzTp312fyQfji+FVhyCjoqSY959NllSZzon91zx259PbqXVFtgeJx4zCPP1bVON7ANj7jI1ytLs0vCzY9h/JKNW3K8ZzdVaK/l5evzug+TdpDUSlTWmCdvOZ/v+uKmhqPL5QUjEwkbTljQNYN59muieJHOjEf5piGUrydfSariTxhJIPv2QdnMBX1PKjKbrtyuBYYC+Pj4pnWnntNsvQPMxf8L7+tEHXaxA+zF/fdvvsEd/DJfuHFOIuJCrvgPNDcZ7KOkFWadAlSCIanXsnOfdOcLmuUDFB3XMGxQIupsasQcsdtO+N/s+si2md+PBZheTGOP9rARgVa3T2fSa6hFuvEVF13PtKZLX+aKhOkinhMSf685fd/18OD+LgYuzD528f3MQerYF4AwHQS3JhnleDBV7npOPvaXMKA2xRo5ltgApfG1bYwtJ366YcbznNbruhNZ+ymI2bTHv15KTZwJwC0XrcSh2Sn+5sjYOGJOShs207waI6VeXF/uPzUWAF+f5/pDZKZp5H2TpZ8cpz3DC7Y6ePA8+jfuecKt/SFteWHVtzFc5PwZUm4Ggpeyg6fRmIO3JH+MgCYe+fCpS49nQ6JWIhAq72Hmf6Es7JR6chc5rYrGtN8x3fj3s0gzTwcJszDs2/hmPE4ZhxGSTyOcxvfkBmmEYfvOLEaUAm+rt5wq+xVYebrJpqipVNFmzKRMZNeR2GgT3vMTF8mLwE+j4bw2UaQloZyE32O78TjSm/gatPwlr4TuysEMCmDaBJbQktuq/ijq5WmbHkF5YDZw0xWE6kSqeeqBag5zT5/aWMpdnvl1N4q0Xt1GGsRW/Zog4xYTQkFIYJNHkBQw/Owr8vEd5Yrk2PXhowJT+Q5+d21Ocp2Ftzcg2ZjJjB7YlV+tqK1uLeyG7nveHt5Z+WXfXfUUTIs0D+Ok1JuBCcR/717PB4j0NQV+c0R9cV+Ctwe+OtXFs6bp25LjMV0tIOH1I3ok0PAr1ozUE6TCwRQkXni5sZyDEhzNK8+9lcJLzihnNtHmuMmELT8Dt6midp3HdsFzrq4cL1eU5MLi1uURSFMRHhf9ZIzUGObi9tzEwNL/YBYOsmJKjLoHiA7AgTqKA7dsWPpgzZurZw2WFNZ2tYclSiECknJ3SL+QKH7/bmgukD+mgpvz8ezEwIc8VgaVgKuMQNvQ8IO3WB2gneBWO6lyx2jVVmDov8A/G4Nzk263S4AAAAASUVORK5CYII=")
bitmaps["boost"]["sunflower1"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAAB4AAAAKCAIAAAAsFXl4AAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOwgAADsIBFShKgAAAAmBJREFUOE9dkv1PEnEcx+9fugPugDMFVtNNq5UUItVq6tqipguZNcAAowf9oSfyeYbUIEfOfGiImThYawTmFg9pyvFw2GZDouJJ+qXv8SAH2+uX2/f9ed37872DFGtT19csctt09/xEp1nfOflAaZD7PKf/7aE17G8LAu5T+1v8wyiajwGwTKQuH2MXTrECpWSCODHjUkG3PkzbN2/EQ43JCC8REiQIfiLIO9gR0KMA4Nr7gq+bG94+ZS+PML1WViqIFbxVsSLk95YJpw6adat+Ek0glN8D0RKHhcejaDaCeuZYY3KG7hKilSADEniwAzGq0U0b/5DkHMUAOZITCjSb7L291knoo1eaivAobwW0SDEN+vqWWSM3EXUbrBTCylYKlRDWiJFHUtbqFJoOURmQTEdwu6Nt4HWfdOaJbGEYeuNSlloXob2g4MUO/Jixn6FtL0krCOH+c/BQF+KZY2bCGOk//m5FojbIrozpLppGZYvDkPa9fsXVFfQ1x3cEqXB9NooXb4Mixk4GeQ4z/rCDAWrWqguAVRwvWb938W+ek+5PZ9adoufzPXLLUM/iONS9MKqYvWexXSW+tqTDx3Ikt9ydqvyHqDNq2Zp2pKITIhR0tYnzl+D+CtaDC8lE8XCgybUhNjgVkGxer7fedn0+H9/lg77l36hELoq90jA04rK3Wg1WuXsB8a9yc5GqKVBuO3AW0iwN+r2tWRKnnx0Biq8ZmPcvAx3NXgZUfqFgpIPUfjWDyXAD9Gypj9xqrDmg82MDHZcjahFNKqT63hHBj68hfhsrT4IPXjuVj7H/AwAmDjXfM4k2AAAAAElFTkSuQmCC")
bitmaps["boost"]["sunflower3"] := Gdip_BitmapFromBase64("iVBORw0KGgoAAAANSUhEUgAAAAgAAAAKCAIAAAAGpYjXAAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOwgAADsIBFShKgAAAANlJREFUGFdjeHvX8f41v+PHY9dsT03qL1+1KfbrA/Ofj0wYGnZOy9wwJ37FzNh5vVkzqh9fcfvxyBQkMWllZt+K7NrllSmrprevrPr2yAwoCpLYs8Ztw0rf9lWlmRtnL95RABEFSRxe77xttVf76vK8LbN2H01Gl+hYU166c9bF85EoEjvXeExYW1C4b8maY2WPb3i/v+sAtB8ksX+d68qVIQ1bOiv3zZt+qHXxkYqzFyNBEkC0b63rqlXB/avy2lcWF2+Y0LxnIlQCgg6td9671m3OyoSqTb0ARSmQdpOmGhkAAAAASUVORK5CYII=")
