// Each new term in the Fibonacci sequence is generated by adding the previous two terms. By starting with 1 and 2, the first 10 terms will be:
//
// 1, 2, 3, 5, 8, 13, 21, 34, 55, 89, ...
//
// By considering the terms in the Fibonacci sequence whose values do not exceed four million, find the sum of the even-valued terms.
function fib() {
  let prev = 0;
  let curr = 1;

  let sum = 0;
  while (true) {
    if (sum > 4000000) {
      break;
    }
    let temp = prev + curr;
    if (temp % 2 === 0) {
      sum += temp;
    }
    prev = curr;
    curr = temp;
  }
  return sum;
}
