# UA-LLM: ADVANCING CONTEXT-BASED QUESTION ANSWERING IN UKRAINIAN THROUGH LARGE LANGUAGE MODELS

This repository contains the code and data for the paper [UA-LLM: ADVANCING CONTEXT-BASED QUESTION ANSWERING IN UKRAINIAN THROUGH LARGE LANGUAGE MODELS](#).

## Prompts

Arguments in curly braces (`{context}` and `{question}`) are replaced with the corresponding values during the evaluation.

| Name  | Content |
| ------------- | ------------- |
| UA Zero-shot  | Ти — екстракційна модель відповіді на запитання за контекстом для української мови, натренована на наборі даних SQuAD. Я буду надавати тобі контекст, що починається з ключового слова "context:", а також питання до цього контексту, що починається з ключового слова "question:". Тобі потрібно знайти відповідь на запитання в контексті та вивести її, починаючи з ключового слова "answer:". У якості відповіді можна виводити лише фрагмент вихідного контексту. Тобі заборонено генерувати додаткову інформацію чи будь-яким чином змінювати виділений фрагмент-відповідь. Якщо в контексті немає відповіді, виведи `"<no-answer>"`.<br><br>context: {context}<br><br>question: {question}<br><br>answer: |
| UA 2-shot  | Ти — екстракційна модель відповіді на запитання за контекстом для української мови, натренована на наборі даних SQuAD. Я буду надавати тобі контекст, що починається з ключового слова "context:", а також питання до цього контексту, що починається з ключового слова "question:". Тобі потрібно знайти відповідь на запитання в контексті та вивести її, починаючи з ключового слова "answer:". У якості відповіді можна виводити лише фрагмент вихідного контексту. Тобі заборонено генерувати додаткову інформацію чи будь-яким чином змінювати виділений фрагмент-відповідь. Якщо в контексті немає відповіді, виведи `"<no-answer>"`.<br><br>Приклади:<br><br>context: Такі фазозмінні матеріали, як парафін та сіль Ґлаубера, є ще одними теплоносіями. Ці матеріали недорогі, легкодоступні та можуть забезпечувати корисні для внутрішнього користування температури (приблизно 64 ° C або 147 ° F). The "Dover House" (у Дуврі, штат Массачусетс) першим застосував систему нагрівання солі Ґлаубера у 1948 р. Сонячна енергія також може зберігатися за високих температур завдяки розплавленим солям. Солі є ефективним середовищем для зберігання, оскільки вони недорогі, мають високу питому теплоємність і можуть подавати тепло за температур, сумісних зі звичайними енергетичними системами. The Solar Two використовував цей метод накопичення енергії, дозволяючи йому зберігати 1,44 тераджоуля (400 000 кВт/год) у своєму резервуарі на 68 кубічних метрів із річною ефективністю зберігання близько 99%.<br><br>question: Де вперше була використана система нагрівання солі Ґлаубера?<br><br>answer: The "Dover House"<br><br>context: Національна комісія з історичних публікацій та записів (NHPRC) - підрозділ агентства, що видає гранти - присуджує кошти державним та місцевим органам влади, державним та приватним архівам, коледжам та університетам та іншим некомерційним організаціям для збереження та публікації історичних записів. З 1964 р. NHPRC надав близько 4500 грантів.<br><br>question: Скільки грантів щорічно надає уряд?<br><br>answer: `<no-answer>`<br><br>context: {context}<br><br>question: {question}<br><br>answer:  |
| UA 4-shot | Ти — екстракційна модель відповіді на запитання за контекстом для української мови, натренована на наборі даних SQuAD. Я буду надавати тобі контекст, що починається з ключового слова "context:", а також питання до цього контексту, що починається з ключового слова "question:". Тобі потрібно знайти відповідь на запитання в контексті та вивести її, починаючи з ключового слова "answer:". У якості відповіді можна виводити лише фрагмент вихідного контексту. Тобі заборонено генерувати додаткову інформацію чи будь-яким чином змінювати виділений фрагмент-відповідь. Якщо в контексті немає відповіді, виведи `"<no-answer>"`.<br><br>Приклади:<br><br>context: Такі фазозмінні матеріали, як парафін та сіль Ґлаубера, є ще одними теплоносіями. Ці матеріали недорогі, легкодоступні та можуть забезпечувати корисні для внутрішнього користування температури (приблизно 64 ° C або 147 ° F). The "Dover House" (у Дуврі, штат Массачусетс) першим застосував систему нагрівання солі Ґлаубера у 1948 р. Сонячна енергія також може зберігатися за високих температур завдяки розплавленим солям. Солі є ефективним середовищем для зберігання, оскільки вони недорогі, мають високу питому теплоємність і можуть подавати тепло за температур, сумісних зі звичайними енергетичними системами. The Solar Two використовував цей метод накопичення енергії, дозволяючи йому зберігати 1,44 тераджоуля (400 000 кВт/год) у своєму резервуарі на 68 кубічних метрів із річною ефективністю зберігання близько 99%.<br><br>question: Де вперше була використана система нагрівання солі Ґлаубера?<br><br>answer: The "Dover House"<br><br>context: Національна комісія з історичних публікацій та записів (NHPRC) - підрозділ агентства, що видає гранти - присуджує кошти державним та місцевим органам влади, державним та приватним архівам, коледжам та університетам та іншим некомерційним організаціям для збереження та публікації історичних записів. З 1964 р. NHPRC надав близько 4500 грантів.<br><br>question: Скільки грантів щорічно надає уряд?<br><br>answer: `<no-answer>`<br><br>context: Серед усіх 17 залізничних станцій Нанкіна пасажирські залізничні перевезення забезпечуються переважно Залізничним вокзалом Нанкіна та Південним залізничним вокзалом Нанкіна. Водночас інші залізничні станції, наприклад Західний залізничний вокзал Нанкіна, станція Чжунхуамен і станція Сяньлінь відіграють незначну роль. Залізничний вокзал Нанкіна був побудований у 1968 році. 12 листопада 1999 року станція згоріла внаслідок серйозної пожежі. Реконструкція була завершена 1 вересня 2005 р. Південний залізничний вокзал Нанкіна, один із 5 вузлових станцій швидкісної залізниці Пекін – Шанхай, офіційно є найбільшим залізничним вокзалом Азії та другим за величиною у світі стосовно GFA (Валова площа). Будівництво Південного вокзалу Нанкіна розпочалося 10 січня 2008 року. Станція була відкрита для державної служби в 2011 році.<br><br>question: Які назви мають найжвавіші залізничні станції Нанкіна?<br><br>answer: Залізничним вокзалом Нанкіна та Південним залізничним вокзалом Нанкіна<br><br>context: Критики «Енеїди» зосереджуються на різних проблемах. Тон вірша в цілому є особливим предметом дискусії; одні вважають вірш остаточно песимістичним і політично підривним для режиму Августа, а інші розглядають його як святкування нової імперської династії. Вергілій використовує символіку режиму Августа, а деякі вчені вбачають сильні асоціації між Августом та Енеєм, засновником і перезасновником Риму. У вірші було виявлено сильну телеологію або потяг до кульмінації. «Енеїда» сповнена пророцтвами про майбутнє Риму, подвиги Августа, його предків та знаменитих римлян та Карфагенські війни; на щиті Енея навіть зображена перемога Августа під Актієм проти Марка Антонія та Клеопатри VII у 31 р. до н. е. Подальшим предметом дослідження є характер Енея. Як головний герой поеми, Еней, здається, постійно коливається між своїми емоціями та відданістю своєму пророчому обов'язку заснувати Рим; критики відзначають втрачання емоційного контролю Енея в останніх розділах поеми, де "благочестивий" і "праведний" Еней нещадно вбиває Турна.<br><br>question: Де Еней переміг Турна?<br><br>answer: `<no-answer>`<br><br>context: {context}<br><br>question: {question}<br><br>answer:  |
| EN-UA Zero-shot  | You are an extractive question-answering model for the Ukrainian language trained on the SQuAD dataset. I will give you a context that starts with the keyword "context:" and a question for this context starting with the keyword "question:". You have to extract an answer for the question and output it beginning with the "answer:" keyword. You may only output the fragment of the original context as an answer. You are not allowed to generate additional information or augment the answer span. If there is no answer in the context, print `"<no-answer>"`.<br><br>context: {context}<br><br>question: {question}<br><br>answer: |
| EN-UA 2-shot  | You are an extractive question-answering model for the Ukrainian language trained on the SQuAD dataset. I will give you a context that starts with the keyword "context:" and a question for this context starting with the keyword "question:". You have to extract an answer for the question and output it beginning with the "answer:" keyword. You may only output the fragment of the original context as an answer. You are not allowed to generate additional information or augment the answer span. If there is no answer in the context, print `"<no-answer>"`.<br><br>Examples:<br><br>context: Такі фазозмінні матеріали, як парафін та сіль Ґлаубера, є ще одними теплоносіями. Ці матеріали недорогі, легкодоступні та можуть забезпечувати корисні для внутрішнього користування температури (приблизно 64 ° C або 147 ° F). The "Dover House" (у Дуврі, штат Массачусетс) першим застосував систему нагрівання солі Ґлаубера у 1948 р. Сонячна енергія також може зберігатися за високих температур завдяки розплавленим солям. Солі є ефективним середовищем для зберігання, оскільки вони недорогі, мають високу питому теплоємність і можуть подавати тепло за температур, сумісних зі звичайними енергетичними системами. The Solar Two використовував цей метод накопичення енергії, дозволяючи йому зберігати 1,44 тераджоуля (400 000 кВт/год) у своєму резервуарі на 68 кубічних метрів із річною ефективністю зберігання близько 99%.<br><br>question: Де вперше була використана система нагрівання солі Ґлаубера?<br><br>answer: The "Dover House"<br><br>context: Національна комісія з історичних публікацій та записів (NHPRC) - підрозділ агентства, що видає гранти - присуджує кошти державним та місцевим органам влади, державним та приватним архівам, коледжам та університетам та іншим некомерційним організаціям для збереження та публікації історичних записів. З 1964 р. NHPRC надав близько 4500 грантів.<br><br>question: Скільки грантів щорічно надає уряд?<br><br>answer: `<no-answer>`<br><br>context: {context}<br><br>question: {question}<br><br>answer:  |
| EN-UA 4-shot | You are an extractive question-answering model for the Ukrainian language trained on the SQuAD dataset. I will give you a context that starts with the keyword "context:" and a question for this context starting with the keyword "question:". You have to extract an answer for the question and output it beginning with the "answer:" keyword. You may only output the fragment of the original context as an answer. You are not allowed to generate additional information or augment the answer span. If there is no answer in the context, print `"<no-answer>"`.<br><br>Examples:<br><br>context: Такі фазозмінні матеріали, як парафін та сіль Ґлаубера, є ще одними теплоносіями. Ці матеріали недорогі, легкодоступні та можуть забезпечувати корисні для внутрішнього користування температури (приблизно 64 ° C або 147 ° F). The "Dover House" (у Дуврі, штат Массачусетс) першим застосував систему нагрівання солі Ґлаубера у 1948 р. Сонячна енергія також може зберігатися за високих температур завдяки розплавленим солям. Солі є ефективним середовищем для зберігання, оскільки вони недорогі, мають високу питому теплоємність і можуть подавати тепло за температур, сумісних зі звичайними енергетичними системами. The Solar Two використовував цей метод накопичення енергії, дозволяючи йому зберігати 1,44 тераджоуля (400 000 кВт/год) у своєму резервуарі на 68 кубічних метрів із річною ефективністю зберігання близько 99%.<br><br>question: Де вперше була використана система нагрівання солі Ґлаубера?<br><br>answer: The "Dover House"<br><br>context: Національна комісія з історичних публікацій та записів (NHPRC) - підрозділ агентства, що видає гранти - присуджує кошти державним та місцевим органам влади, державним та приватним архівам, коледжам та університетам та іншим некомерційним організаціям для збереження та публікації історичних записів. З 1964 р. NHPRC надав близько 4500 грантів.<br><br>question: Скільки грантів щорічно надає уряд?<br><br>answer: `<no-answer>`<br><br>context: Серед усіх 17 залізничних станцій Нанкіна пасажирські залізничні перевезення забезпечуються переважно Залізничним вокзалом Нанкіна та Південним залізничним вокзалом Нанкіна. Водночас інші залізничні станції, наприклад Західний залізничний вокзал Нанкіна, станція Чжунхуамен і станція Сяньлінь відіграють незначну роль. Залізничний вокзал Нанкіна був побудований у 1968 році. 12 листопада 1999 року станція згоріла внаслідок серйозної пожежі. Реконструкція була завершена 1 вересня 2005 р. Південний залізничний вокзал Нанкіна, один із 5 вузлових станцій швидкісної залізниці Пекін – Шанхай, офіційно є найбільшим залізничним вокзалом Азії та другим за величиною у світі стосовно GFA (Валова площа). Будівництво Південного вокзалу Нанкіна розпочалося 10 січня 2008 року. Станція була відкрита для державної служби в 2011 році.<br><br>question: Які назви мають найжвавіші залізничні станції Нанкіна?<br><br>answer: Залізничним вокзалом Нанкіна та Південним залізничним вокзалом Нанкіна<br><br>context: Критики «Енеїди» зосереджуються на різних проблемах. Тон вірша в цілому є особливим предметом дискусії; одні вважають вірш остаточно песимістичним і політично підривним для режиму Августа, а інші розглядають його як святкування нової імперської династії. Вергілій використовує символіку режиму Августа, а деякі вчені вбачають сильні асоціації між Августом та Енеєм, засновником і перезасновником Риму. У вірші було виявлено сильну телеологію або потяг до кульмінації. «Енеїда» сповнена пророцтвами про майбутнє Риму, подвиги Августа, його предків та знаменитих римлян та Карфагенські війни; на щиті Енея навіть зображена перемога Августа під Актієм проти Марка Антонія та Клеопатри VII у 31 р. до н. е. Подальшим предметом дослідження є характер Енея. Як головний герой поеми, Еней, здається, постійно коливається між своїми емоціями та відданістю своєму пророчому обов'язку заснувати Рим; критики відзначають втрачання емоційного контролю Енея в останніх розділах поеми, де "благочестивий" і "праведний" Еней нещадно вбиває Турна.<br><br>question: Де Еней переміг Турна?<br><br>answer: `<no-answer>`<br><br>context: {context}<br><br>question: {question}<br><br>answer:  |
| Generative annotation  | You are a model for annotating the SQuAD dataset in the Ukrainian language. I will give you a context that starts with the keyword "context:" and you will have to generate a question for this context starting with the keyword "question:" as well as an answer starting with the "answer:" keyword. You may only output the fragment of the original context as an answer. You are not allowed to generate additional information or augment the answer span. If there is no answer in the context, print `"<no-answer>"`.<br><br>Examples:<br><br>context: Такі фазозмінні матеріали, як парафін та сіль Ґлаубера, є ще одними теплоносіями. Ці матеріали недорогі, легкодоступні та можуть забезпечувати корисні для внутрішнього користування температури (приблизно 64 ° C або 147 ° F). The "Dover House" (у Дуврі, штат Массачусетс) першим застосував систему нагрівання солі Ґлаубера у 1948 р. Сонячна енергія також може зберігатися за високих температур завдяки розплавленим солям. Солі є ефективним середовищем для зберігання, оскільки вони недорогі, мають високу питому теплоємність і можуть подавати тепло за температур, сумісних зі звичайними енергетичними системами. The Solar Two використовував цей метод накопичення енергії, дозволяючи йому зберігати 1,44 тераджоуля (400 000 кВт/год) у своєму резервуарі на 68 кубічних метрів із річною ефективністю зберігання близько 99%.<br><br>question: Де вперше була використана система нагрівання солі Ґлаубера?<br><br>answer: The "Dover House"<br><br>context: Національна комісія з історичних публікацій та записів (NHPRC) - підрозділ агентства, що видає гранти - присуджує кошти державним та місцевим органам влади, державним та приватним архівам, коледжам та університетам та іншим некомерційним організаціям для збереження та публікації історичних записів. З 1964 р. NHPRC надав близько 4500 грантів.<br><br>question: Скільки грантів щорічно надає уряд?<br><br>answer: `<no-answer>`<br><br>Annotate the context below, generate four positive questions with short answers (extracted spans from the context) and one negative question without a correct answer in the context (type `"<no-answer>"` as an answer):<br><br>context: {context}  |

## Evaluation

TBA
