import { type MaterialIcon } from "material-icons/index.d";

type IconListItem = Record<MaterialIcon, number>;

export const iconCodepoints: IconListItem = {
  "123": 0xeb8d,
  "360": 0xe577,
  "10k": 0xe951,
  "10mp": 0xe952,
  "11mp": 0xe953,
  "12mp": 0xe954,
  "13mp": 0xe955,
  "14mp": 0xe956,
  "15mp": 0xe957,
  "16mp": 0xe958,
  "17mp": 0xe959,
  "18_up_rating": 0xf8fd,
  "18mp": 0xe95a,
  "19mp": 0xe95b,
  "1k": 0xe95c,
  "1k_plus": 0xe95d,
  "1x_mobiledata": 0xefcd,
  "20mp": 0xe95e,
  "21mp": 0xe95f,
  "22mp": 0xe960,
  "23mp": 0xe961,
  "24mp": 0xe962,
  "2k": 0xe963,
  "2k_plus": 0xe964,
  "2mp": 0xe965,
  "30fps": 0xefce,
  "30fps_select": 0xefcf,
  "3d_rotation": 0xe84d,
  "3g_mobiledata": 0xefd0,
  "3k": 0xe966,
  "3k_plus": 0xe967,
  "3mp": 0xe968,
  "3p": 0xefd1,
  "4g_mobiledata": 0xefd2,
  "4g_plus_mobiledata": 0xefd3,
  "4k": 0xe072,
  "4k_plus": 0xe969,
  "4mp": 0xe96a,
  "5g": 0xef38,
  "5k": 0xe96b,
  "5k_plus": 0xe96c,
  "5mp": 0xe96d,
  "60fps": 0xefd4,
  "60fps_select": 0xefd5,
  "6_ft_apart": 0xf21e,
  "6k": 0xe96e,
  "6k_plus": 0xe96f,
  "6mp": 0xe970,
  "7k": 0xe971,
  "7k_plus": 0xe972,
  "7mp": 0xe973,
  "8k": 0xe974,
  "8k_plus": 0xe975,
  "8mp": 0xe976,
  "9k": 0xe977,
  "9k_plus": 0xe978,
  "9mp": 0xe979,
  "abc": 0xeb94,
  "ac_unit": 0xeb3b,
  "access_alarm": 0xe190,
  "access_alarms": 0xe191,
  "access_time": 0xe192,
  "access_time_filled": 0xefd6,
  "accessibility": 0xe84e,
  "accessibility_new": 0xe92c,
  "accessible": 0xe914,
  "accessible_forward": 0xe934,
  "account_balance": 0xe84f,
  "account_balance_wallet": 0xe850,
  "account_box": 0xe851,
  "account_circle": 0xe853,
  "account_tree": 0xe97a,
  "ad_units": 0xef39,
  "adb": 0xe60e,
  "add": 0xe145,
  "add_a_photo": 0xe439,
  "add_alarm": 0xe193,
  "add_alert": 0xe003,
  "add_box": 0xe146,
  "add_business": 0xe729,
  "add_card": 0xeb86,
  "add_chart": 0xe97b,
  "add_circle": 0xe147,
  "add_circle_outline": 0xe148,
  "add_comment": 0xe266,
  "add_home": 0xf8eb,
  "add_home_work": 0xf8ed,
  "add_ic_call": 0xe97c,
  "add_link": 0xe178,
  "add_location": 0xe567,
  "add_location_alt": 0xef3a,
  "add_moderator": 0xe97d,
  "add_photo_alternate": 0xe43e,
  "add_reaction": 0xe1d3,
  "add_road": 0xef3b,
  "add_shopping_cart": 0xe854,
  "add_task": 0xf23a,
  "add_to_drive": 0xe65c,
  "add_to_home_screen": 0xe1fe,
  "add_to_photos": 0xe39d,
  "add_to_queue": 0xe05c,
  "addchart": 0xef3c,
  "adf_scanner": 0xeada,
  "adjust": 0xe39e,
  "admin_panel_settings": 0xef3d,
  "ads_click": 0xe762,
  "agriculture": 0xea79,
  "air": 0xefd8,
  "airline_seat_flat": 0xe630,
  "airline_seat_flat_angled": 0xe631,
  "airline_seat_individual_suite": 0xe632,
  "airline_seat_legroom_extra": 0xe633,
  "airline_seat_legroom_normal": 0xe634,
  "airline_seat_legroom_reduced": 0xe635,
  "airline_seat_recline_extra": 0xe636,
  "airline_seat_recline_normal": 0xe637,
  "airline_stops": 0xe7d0,
  "airlines": 0xe7ca,
  "airplane_ticket": 0xefd9,
  "airplanemode_active": 0xe195,
  "airplanemode_inactive": 0xe194,
  "airplay": 0xe055,
  "airport_shuttle": 0xeb3c,
  "alarm": 0xe855,
  "alarm_add": 0xe856,
  "alarm_off": 0xe857,
  "alarm_on": 0xe858,
  "album": 0xe019,
  "align_horizontal_center": 0xe00f,
  "align_horizontal_left": 0xe00d,
  "align_horizontal_right": 0xe010,
  "align_vertical_bottom": 0xe015,
  "align_vertical_center": 0xe011,
  "align_vertical_top": 0xe00c,
  "all_inbox": 0xe97f,
  "all_inclusive": 0xeb3d,
  "all_out": 0xe90b,
  "alt_route": 0xf184,
  "alternate_email": 0xe0e6,
  "analytics": 0xef3e,
  "anchor": 0xf1cd,
  "android": 0xe859,
  "animation": 0xe71c,
  "announcement": 0xe85a,
  "aod": 0xefda,
  "apartment": 0xea40,
  "api": 0xf1b7,
  "app_blocking": 0xef3f,
  "app_registration": 0xef40,
  "app_settings_alt": 0xef41,
  "app_shortcut": 0xeae4,
  "approval": 0xe982,
  "apps": 0xe5c3,
  "apps_outage": 0xe7cc,
  "architecture": 0xea3b,
  "archive": 0xe149,
  "area_chart": 0xe770,
  "arrow_back": 0xe5c4,
  "arrow_back_ios": 0xe5e0,
  "arrow_back_ios_new": 0xe2ea,
  "arrow_circle_down": 0xf181,
  "arrow_circle_left": 0xeaa7,
  "arrow_circle_right": 0xeaaa,
  "arrow_circle_up": 0xf182,
  "arrow_downward": 0xe5db,
  "arrow_drop_down": 0xe5c5,
  "arrow_drop_down_circle": 0xe5c6,
  "arrow_drop_up": 0xe5c7,
  "arrow_forward": 0xe5c8,
  "arrow_forward_ios": 0xe5e1,
  "arrow_left": 0xe5de,
  "arrow_outward": 0xf8ce,
  "arrow_right": 0xe5df,
  "arrow_right_alt": 0xe941,
  "arrow_upward": 0xe5d8,
  "art_track": 0xe060,
  "article": 0xef42,
  "aspect_ratio": 0xe85b,
  "assessment": 0xe85c,
  "assignment": 0xe85d,
  "assignment_ind": 0xe85e,
  "assignment_late": 0xe85f,
  "assignment_return": 0xe860,
  "assignment_returned": 0xe861,
  "assignment_turned_in": 0xe862,
  "assist_walker": 0xf8d5,
  "assistant": 0xe39f,
  "assistant_direction": 0xe988,
  "assistant_photo": 0xe3a0,
  "assured_workload": 0xeb6f,
  "atm": 0xe573,
  "attach_email": 0xea5e,
  "attach_file": 0xe226,
  "attach_money": 0xe227,
  "attachment": 0xe2bc,
  "attractions": 0xea52,
  "attribution": 0xefdb,
  "audio_file": 0xeb82,
  "audiotrack": 0xe3a1,
  "auto_awesome": 0xe65f,
  "auto_awesome_mosaic": 0xe660,
  "auto_awesome_motion": 0xe661,
  "auto_delete": 0xea4c,
  "auto_fix_high": 0xe663,
  "auto_fix_normal": 0xe664,
  "auto_fix_off": 0xe665,
  "auto_graph": 0xe4fb,
  "auto_mode": 0xec20,
  "auto_stories": 0xe666,
  "autofps_select": 0xefdc,
  "autorenew": 0xe863,
  "av_timer": 0xe01b,
  "baby_changing_station": 0xf19b,
  "back_hand": 0xe764,
  "backpack": 0xf19c,
  "backspace": 0xe14a,
  "backup": 0xe864,
  "backup_table": 0xef43,
  "badge": 0xea67,
  "bakery_dining": 0xea53,
  "balance": 0xeaf6,
  "balcony": 0xe58f,
  "ballot": 0xe172,
  "bar_chart": 0xe26b,
  "batch_prediction": 0xf0f5,
  "bathroom": 0xefdd,
  "bathtub": 0xea41,
  "battery_0_bar": 0xebdc,
  "battery_1_bar": 0xebd9,
  "battery_2_bar": 0xebe0,
  "battery_3_bar": 0xebdd,
  "battery_4_bar": 0xebe2,
  "battery_5_bar": 0xebd4,
  "battery_6_bar": 0xebd2,
  "battery_alert": 0xe19c,
  "battery_charging_full": 0xe1a3,
  "battery_full": 0xe1a4,
  "battery_saver": 0xefde,
  "battery_std": 0xe1a5,
  "battery_unknown": 0xe1a6,
  "beach_access": 0xeb3e,
  "bed": 0xefdf,
  "bedroom_baby": 0xefe0,
  "bedroom_child": 0xefe1,
  "bedroom_parent": 0xefe2,
  "bedtime": 0xef44,
  "bedtime_off": 0xeb76,
  "beenhere": 0xe52d,
  "bento": 0xf1f4,
  "bike_scooter": 0xef45,
  "biotech": 0xea3a,
  "blender": 0xefe3,
  "blind": 0xf8d6,
  "blinds": 0xe286,
  "blinds_closed": 0xec1f,
  "block": 0xe14b,
  "bloodtype": 0xefe4,
  "bluetooth": 0xe1a7,
  "bluetooth_audio": 0xe60f,
  "bluetooth_connected": 0xe1a8,
  "bluetooth_disabled": 0xe1a9,
  "bluetooth_drive": 0xefe5,
  "bluetooth_searching": 0xe1aa,
  "blur_circular": 0xe3a2,
  "blur_linear": 0xe3a3,
  "blur_off": 0xe3a4,
  "blur_on": 0xe3a5,
  "bolt": 0xea0b,
  "book": 0xe865,
  "book_online": 0xf217,
  "bookmark": 0xe866,
  "bookmark_add": 0xe598,
  "bookmark_added": 0xe599,
  "bookmark_border": 0xe867,
  "bookmark_remove": 0xe59a,
  "bookmarks": 0xe98b,
  "border_all": 0xe228,
  "border_bottom": 0xe229,
  "border_clear": 0xe22a,
  "border_color": 0xe22b,
  "border_horizontal": 0xe22c,
  "border_inner": 0xe22d,
  "border_left": 0xe22e,
  "border_outer": 0xe22f,
  "border_right": 0xe230,
  "border_style": 0xe231,
  "border_top": 0xe232,
  "border_vertical": 0xe233,
  "boy": 0xeb67,
  "branding_watermark": 0xe06b,
  "breakfast_dining": 0xea54,
  "brightness_1": 0xe3a6,
  "brightness_2": 0xe3a7,
  "brightness_3": 0xe3a8,
  "brightness_4": 0xe3a9,
  "brightness_5": 0xe3aa,
  "brightness_6": 0xe3ab,
  "brightness_7": 0xe3ac,
  "brightness_auto": 0xe1ab,
  "brightness_high": 0xe1ac,
  "brightness_low": 0xe1ad,
  "brightness_medium": 0xe1ae,
  "broadcast_on_home": 0xf8f8,
  "broadcast_on_personal": 0xf8f9,
  "broken_image": 0xe3ad,
  "browse_gallery": 0xebd1,
  "browser_not_supported": 0xef47,
  "browser_updated": 0xe7cf,
  "brunch_dining": 0xea73,
  "brush": 0xe3ae,
  "bubble_chart": 0xe6dd,
  "bug_report": 0xe868,
  "build": 0xe869,
  "build_circle": 0xef48,
  "bungalow": 0xe591,
  "burst_mode": 0xe43c,
  "bus_alert": 0xe98f,
  "business": 0xe0af,
  "business_center": 0xeb3f,
  "cabin": 0xe589,
  "cable": 0xefe6,
  "cached": 0xe86a,
  "cake": 0xe7e9,
  "calculate": 0xea5f,
  "calendar_month": 0xebcc,
  "calendar_today": 0xe935,
  "calendar_view_day": 0xe936,
  "calendar_view_month": 0xefe7,
  "calendar_view_week": 0xefe8,
  "call": 0xe0b0,
  "call_end": 0xe0b1,
  "call_made": 0xe0b2,
  "call_merge": 0xe0b3,
  "call_missed": 0xe0b4,
  "call_missed_outgoing": 0xe0e4,
  "call_received": 0xe0b5,
  "call_split": 0xe0b6,
  "call_to_action": 0xe06c,
  "camera": 0xe3af,
  "camera_alt": 0xe3b0,
  "camera_enhance": 0xe8fc,
  "camera_front": 0xe3b1,
  "camera_indoor": 0xefe9,
  "camera_outdoor": 0xefea,
  "camera_rear": 0xe3b2,
  "camera_roll": 0xe3b3,
  "cameraswitch": 0xefeb,
  "campaign": 0xef49,
  "cancel": 0xe5c9,
  "cancel_presentation": 0xe0e9,
  "cancel_schedule_send": 0xea39,
  "candlestick_chart": 0xead4,
  "car_crash": 0xebf2,
  "car_rental": 0xea55,
  "car_repair": 0xea56,
  "card_giftcard": 0xe8f6,
  "card_membership": 0xe8f7,
  "card_travel": 0xe8f8,
  "carpenter": 0xf1f8,
  "cases": 0xe992,
  "casino": 0xeb40,
  "cast": 0xe307,
  "cast_connected": 0xe308,
  "cast_for_education": 0xefec,
  "castle": 0xeab1,
  "catching_pokemon": 0xe508,
  "category": 0xe574,
  "celebration": 0xea65,
  "cell_tower": 0xebba,
  "cell_wifi": 0xe0ec,
  "center_focus_strong": 0xe3b4,
  "center_focus_weak": 0xe3b5,
  "chair": 0xefed,
  "chair_alt": 0xefee,
  "chalet": 0xe585,
  "change_circle": 0xe2e7,
  "change_history": 0xe86b,
  "charging_station": 0xf19d,
  "chat": 0xe0b7,
  "chat_bubble": 0xe0ca,
  "chat_bubble_outline": 0xe0cb,
  "check": 0xe5ca,
  "check_box": 0xe834,
  "check_box_outline_blank": 0xe835,
  "check_circle": 0xe86c,
  "check_circle_outline": 0xe92d,
  "checklist": 0xe6b1,
  "checklist_rtl": 0xe6b3,
  "checkroom": 0xf19e,
  "chevron_left": 0xe5cb,
  "chevron_right": 0xe5cc,
  "child_care": 0xeb41,
  "child_friendly": 0xeb42,
  "chrome_reader_mode": 0xe86d,
  "church": 0xeaae,
  "circle": 0xef4a,
  "circle_notifications": 0xe994,
  "class": 0xe86e,
  "clean_hands": 0xf21f,
  "cleaning_services": 0xf0ff,
  "clear": 0xe14c,
  "clear_all": 0xe0b8,
  "close": 0xe5cd,
  "close_fullscreen": 0xf1cf,
  "closed_caption": 0xe01c,
  "closed_caption_disabled": 0xf1dc,
  "closed_caption_off": 0xe996,
  "cloud": 0xe2bd,
  "cloud_circle": 0xe2be,
  "cloud_done": 0xe2bf,
  "cloud_download": 0xe2c0,
  "cloud_off": 0xe2c1,
  "cloud_queue": 0xe2c2,
  "cloud_sync": 0xeb5a,
  "cloud_upload": 0xe2c3,
  "co2": 0xe7b0,
  "co_present": 0xeaf0,
  "code": 0xe86f,
  "code_off": 0xe4f3,
  "coffee": 0xefef,
  "coffee_maker": 0xeff0,
  "collections": 0xe3b6,
  "collections_bookmark": 0xe431,
  "color_lens": 0xe3b7,
  "colorize": 0xe3b8,
  "comment": 0xe0b9,
  "comment_bank": 0xea4e,
  "comments_disabled": 0xe7a2,
  "commit": 0xeaf5,
  "commute": 0xe940,
  "compare": 0xe3b9,
  "compare_arrows": 0xe915,
  "compass_calibration": 0xe57c,
  "compost": 0xe761,
  "compress": 0xe94d,
  "computer": 0xe30a,
  "confirmation_number": 0xe638,
  "connect_without_contact": 0xf223,
  "connected_tv": 0xe998,
  "connecting_airports": 0xe7c9,
  "construction": 0xea3c,
  "contact_emergency": 0xf8d1,
  "contact_mail": 0xe0d0,
  "contact_page": 0xf22e,
  "contact_phone": 0xe0cf,
  "contact_support": 0xe94c,
  "contactless": 0xea71,
  "contacts": 0xe0ba,
  "content_copy": 0xe14d,
  "content_cut": 0xe14e,
  "content_paste": 0xe14f,
  "content_paste_go": 0xea8e,
  "content_paste_off": 0xe4f8,
  "content_paste_search": 0xea9b,
  "contrast": 0xeb37,
  "control_camera": 0xe074,
  "control_point": 0xe3ba,
  "control_point_duplicate": 0xe3bb,
  "cookie": 0xeaac,
  "copy_all": 0xe2ec,
  "copyright": 0xe90c,
  "coronavirus": 0xf221,
  "corporate_fare": 0xf1d0,
  "cottage": 0xe587,
  "countertops": 0xf1f7,
  "create": 0xe150,
  "create_new_folder": 0xe2cc,
  "credit_card": 0xe870,
  "credit_card_off": 0xe4f4,
  "credit_score": 0xeff1,
  "crib": 0xe588,
  "crisis_alert": 0xebe9,
  "crop": 0xe3be,
  "crop_16_9": 0xe3bc,
  "crop_3_2": 0xe3bd,
  "crop_5_4": 0xe3bf,
  "crop_7_5": 0xe3c0,
  "crop_din": 0xe3c1,
  "crop_free": 0xe3c2,
  "crop_landscape": 0xe3c3,
  "crop_original": 0xe3c4,
  "crop_portrait": 0xe3c5,
  "crop_rotate": 0xe437,
  "crop_square": 0xe3c6,
  "cruelty_free": 0xe799,
  "css": 0xeb93,
  "currency_bitcoin": 0xebc5,
  "currency_exchange": 0xeb70,
  "currency_franc": 0xeafa,
  "currency_lira": 0xeaef,
  "currency_pound": 0xeaf1,
  "currency_ruble": 0xeaec,
  "currency_rupee": 0xeaf7,
  "currency_yen": 0xeafb,
  "currency_yuan": 0xeaf9,
  "curtains": 0xec1e,
  "curtains_closed": 0xec1d,
  "cyclone": 0xebd5,
  "dangerous": 0xe99a,
  "dark_mode": 0xe51c,
  "dashboard": 0xe871,
  "dashboard_customize": 0xe99b,
  "data_array": 0xead1,
  "data_exploration": 0xe76f,
  "data_object": 0xead3,
  "data_saver_off": 0xeff2,
  "data_saver_on": 0xeff3,
  "data_thresholding": 0xeb9f,
  "data_usage": 0xe1af,
  "dataset": 0xf8ee,
  "dataset_linked": 0xf8ef,
  "date_range": 0xe916,
  "deblur": 0xeb77,
  "deck": 0xea42,
  "dehaze": 0xe3c7,
  "delete": 0xe872,
  "delete_forever": 0xe92b,
  "delete_outline": 0xe92e,
  "delete_sweep": 0xe16c,
  "delivery_dining": 0xea72,
  "density_large": 0xeba9,
  "density_medium": 0xeb9e,
  "density_small": 0xeba8,
  "departure_board": 0xe576,
  "description": 0xe873,
  "deselect": 0xebb6,
  "design_services": 0xf10a,
  "desk": 0xf8f4,
  "desktop_access_disabled": 0xe99d,
  "desktop_mac": 0xe30b,
  "desktop_windows": 0xe30c,
  "details": 0xe3c8,
  "developer_board": 0xe30d,
  "developer_board_off": 0xe4ff,
  "developer_mode": 0xe1b0,
  "device_hub": 0xe335,
  "device_thermostat": 0xe1ff,
  "device_unknown": 0xe339,
  "devices": 0xe1b1,
  "devices_fold": 0xebde,
  "devices_other": 0xe337,
  "dialer_sip": 0xe0bb,
  "dialpad": 0xe0bc,
  "diamond": 0xead5,
  "difference": 0xeb7d,
  "dining": 0xeff4,
  "dinner_dining": 0xea57,
  "directions": 0xe52e,
  "directions_bike": 0xe52f,
  "directions_boat": 0xe532,
  "directions_boat_filled": 0xeff5,
  "directions_bus": 0xe530,
  "directions_bus_filled": 0xeff6,
  "directions_car": 0xe531,
  "directions_car_filled": 0xeff7,
  "directions_off": 0xf10f,
  "directions_railway": 0xe534,
  "directions_railway_filled": 0xeff8,
  "directions_run": 0xe566,
  "directions_subway": 0xe533,
  "directions_subway_filled": 0xeff9,
  "directions_transit": 0xe535,
  "directions_transit_filled": 0xeffa,
  "directions_walk": 0xe536,
  "dirty_lens": 0xef4b,
  "disabled_by_default": 0xf230,
  "disabled_visible": 0xe76e,
  "disc_full": 0xe610,
  "discount": 0xebc9,
  "display_settings": 0xeb97,
  "diversity_1": 0xf8d7,
  "diversity_2": 0xf8d8,
  "diversity_3": 0xf8d9,
  "dns": 0xe875,
  "do_disturb": 0xf08c,
  "do_disturb_alt": 0xf08d,
  "do_disturb_off": 0xf08e,
  "do_disturb_on": 0xf08f,
  "do_not_disturb": 0xe612,
  "do_not_disturb_alt": 0xe611,
  "do_not_disturb_off": 0xe643,
  "do_not_disturb_on": 0xe644,
  "do_not_disturb_on_total_silence": 0xeffb,
  "do_not_step": 0xf19f,
  "do_not_touch": 0xf1b0,
  "dock": 0xe30e,
  "document_scanner": 0xe5fa,
  "domain": 0xe7ee,
  "domain_add": 0xeb62,
  "domain_disabled": 0xe0ef,
  "domain_verification": 0xef4c,
  "done": 0xe876,
  "done_all": 0xe877,
  "done_outline": 0xe92f,
  "donut_large": 0xe917,
  "donut_small": 0xe918,
  "door_back": 0xeffc,
  "door_front": 0xeffd,
  "door_sliding": 0xeffe,
  "doorbell": 0xefff,
  "double_arrow": 0xea50,
  "downhill_skiing": 0xe509,
  "download": 0xf090,
  "download_done": 0xf091,
  "download_for_offline": 0xf000,
  "downloading": 0xf001,
  "drafts": 0xe151,
  "drag_handle": 0xe25d,
  "drag_indicator": 0xe945,
  "draw": 0xe746,
  "drive_eta": 0xe613,
  "drive_file_move": 0xe675,
  "drive_file_move_rtl": 0xe76d,
  "drive_file_rename_outline": 0xe9a2,
  "drive_folder_upload": 0xe9a3,
  "dry": 0xf1b3,
  "dry_cleaning": 0xea58,
  "duo": 0xe9a5,
  "dvr": 0xe1b2,
  "dynamic_feed": 0xea14,
  "dynamic_form": 0xf1bf,
  "e_mobiledata": 0xf002,
  "earbuds": 0xf003,
  "earbuds_battery": 0xf004,
  "east": 0xf1df,
  "edgesensor_high": 0xf005,
  "edgesensor_low": 0xf006,
  "edit": 0xe3c9,
  "edit_attributes": 0xe578,
  "edit_calendar": 0xe742,
  "edit_location": 0xe568,
  "edit_location_alt": 0xe1c5,
  "edit_note": 0xe745,
  "edit_notifications": 0xe525,
  "edit_off": 0xe950,
  "edit_road": 0xef4d,
  "egg": 0xeacc,
  "egg_alt": 0xeac8,
  "eject": 0xe8fb,
  "elderly": 0xf21a,
  "elderly_woman": 0xeb69,
  "electric_bike": 0xeb1b,
  "electric_bolt": 0xec1c,
  "electric_car": 0xeb1c,
  "electric_meter": 0xec1b,
  "electric_moped": 0xeb1d,
  "electric_rickshaw": 0xeb1e,
  "electric_scooter": 0xeb1f,
  "electrical_services": 0xf102,
  "elevator": 0xf1a0,
  "email": 0xe0be,
  "emergency": 0xe1eb,
  "emergency_recording": 0xebf4,
  "emergency_share": 0xebf6,
  "emoji_emotions": 0xea22,
  "emoji_events": 0xea23,
  "emoji_food_beverage": 0xea1b,
  "emoji_nature": 0xea1c,
  "emoji_objects": 0xea24,
  "emoji_people": 0xea1d,
  "emoji_symbols": 0xea1e,
  "emoji_transportation": 0xea1f,
  "energy_savings_leaf": 0xec1a,
  "engineering": 0xea3d,
  "enhanced_encryption": 0xe63f,
  "equalizer": 0xe01d,
  "error": 0xe000,
  "error_outline": 0xe001,
  "escalator": 0xf1a1,
  "escalator_warning": 0xf1ac,
  "euro": 0xea15,
  "euro_symbol": 0xe926,
  "ev_station": 0xe56d,
  "event": 0xe878,
  "event_available": 0xe614,
  "event_busy": 0xe615,
  "event_note": 0xe616,
  "event_repeat": 0xeb7b,
  "event_seat": 0xe903,
  "exit_to_app": 0xe879,
  "expand": 0xe94f,
  "expand_circle_down": 0xe7cd,
  "expand_less": 0xe5ce,
  "expand_more": 0xe5cf,
  "explicit": 0xe01e,
  "explore": 0xe87a,
  "explore_off": 0xe9a8,
  "exposure": 0xe3ca,
  "exposure_neg_1": 0xe3cb,
  "exposure_neg_2": 0xe3cc,
  "exposure_plus_1": 0xe3cd,
  "exposure_plus_2": 0xe3ce,
  "exposure_zero": 0xe3cf,
  "extension": 0xe87b,
  "extension_off": 0xe4f5,
  "face": 0xe87c,
  "face_2": 0xf8da,
  "face_3": 0xf8db,
  "face_4": 0xf8dc,
  "face_5": 0xf8dd,
  "face_6": 0xf8de,
  "face_retouching_natural": 0xef4e,
  "face_retouching_off": 0xf007,
  "fact_check": 0xf0c5,
  "factory": 0xebbc,
  "family_restroom": 0xf1a2,
  "fast_forward": 0xe01f,
  "fast_rewind": 0xe020,
  "fastfood": 0xe57a,
  "favorite": 0xe87d,
  "favorite_border": 0xe87e,
  "fax": 0xead8,
  "featured_play_list": 0xe06d,
  "featured_video": 0xe06e,
  "feed": 0xf009,
  "feedback": 0xe87f,
  "female": 0xe590,
  "fence": 0xf1f6,
  "festival": 0xea68,
  "fiber_dvr": 0xe05d,
  "fiber_manual_record": 0xe061,
  "fiber_new": 0xe05e,
  "fiber_pin": 0xe06a,
  "fiber_smart_record": 0xe062,
  "file_copy": 0xe173,
  "file_download": 0xe2c4,
  "file_download_done": 0xe9aa,
  "file_download_off": 0xe4fe,
  "file_open": 0xeaf3,
  "file_present": 0xea0e,
  "file_upload": 0xe2c6,
  "filter": 0xe3d3,
  "filter_1": 0xe3d0,
  "filter_2": 0xe3d1,
  "filter_3": 0xe3d2,
  "filter_4": 0xe3d4,
  "filter_5": 0xe3d5,
  "filter_6": 0xe3d6,
  "filter_7": 0xe3d7,
  "filter_8": 0xe3d8,
  "filter_9": 0xe3d9,
  "filter_9_plus": 0xe3da,
  "filter_alt": 0xef4f,
  "filter_alt_off": 0xeb32,
  "filter_b_and_w": 0xe3db,
  "filter_center_focus": 0xe3dc,
  "filter_drama": 0xe3dd,
  "filter_frames": 0xe3de,
  "filter_hdr": 0xe3df,
  "filter_list": 0xe152,
  "filter_list_off": 0xeb57,
  "filter_none": 0xe3e0,
  "filter_tilt_shift": 0xe3e2,
  "filter_vintage": 0xe3e3,
  "find_in_page": 0xe880,
  "find_replace": 0xe881,
  "fingerprint": 0xe90d,
  "fire_extinguisher": 0xf1d8,
  "fire_hydrant_alt": 0xf8f1,
  "fire_truck": 0xf8f2,
  "fireplace": 0xea43,
  "first_page": 0xe5dc,
  "fit_screen": 0xea10,
  "fitbit": 0xe82b,
  "fitness_center": 0xeb43,
  "flag": 0xe153,
  "flag_circle": 0xeaf8,
  "flaky": 0xef50,
  "flare": 0xe3e4,
  "flash_auto": 0xe3e5,
  "flash_off": 0xe3e6,
  "flash_on": 0xe3e7,
  "flashlight_off": 0xf00a,
  "flashlight_on": 0xf00b,
  "flatware": 0xf00c,
  "flight": 0xe539,
  "flight_class": 0xe7cb,
  "flight_land": 0xe904,
  "flight_takeoff": 0xe905,
  "flip": 0xe3e8,
  "flip_camera_android": 0xea37,
  "flip_camera_ios": 0xea38,
  "flip_to_back": 0xe882,
  "flip_to_front": 0xe883,
  "flood": 0xebe6,
  "fluorescent": 0xec31,
  "flutter_dash": 0xe00b,
  "fmd_bad": 0xf00e,
  "fmd_good": 0xf00f,
  "folder": 0xe2c7,
  "folder_copy": 0xebbd,
  "folder_delete": 0xeb34,
  "folder_off": 0xeb83,
  "folder_open": 0xe2c8,
  "folder_shared": 0xe2c9,
  "folder_special": 0xe617,
  "folder_zip": 0xeb2c,
  "follow_the_signs": 0xf222,
  "font_download": 0xe167,
  "font_download_off": 0xe4f9,
  "food_bank": 0xf1f2,
  "forest": 0xea99,
  "fork_left": 0xeba0,
  "fork_right": 0xebac,
  "format_align_center": 0xe234,
  "format_align_justify": 0xe235,
  "format_align_left": 0xe236,
  "format_align_right": 0xe237,
  "format_bold": 0xe238,
  "format_clear": 0xe239,
  "format_color_fill": 0xe23a,
  "format_color_reset": 0xe23b,
  "format_color_text": 0xe23c,
  "format_indent_decrease": 0xe23d,
  "format_indent_increase": 0xe23e,
  "format_italic": 0xe23f,
  "format_line_spacing": 0xe240,
  "format_list_bulleted": 0xe241,
  "format_list_numbered": 0xe242,
  "format_list_numbered_rtl": 0xe267,
  "format_overline": 0xeb65,
  "format_paint": 0xe243,
  "format_quote": 0xe244,
  "format_shapes": 0xe25e,
  "format_size": 0xe245,
  "format_strikethrough": 0xe246,
  "format_textdirection_l_to_r": 0xe247,
  "format_textdirection_r_to_l": 0xe248,
  "format_underlined": 0xe249,
  "fort": 0xeaad,
  "forum": 0xe0bf,
  "forward": 0xe154,
  "forward_10": 0xe056,
  "forward_30": 0xe057,
  "forward_5": 0xe058,
  "forward_to_inbox": 0xf187,
  "foundation": 0xf200,
  "free_breakfast": 0xeb44,
  "free_cancellation": 0xe748,
  "front_hand": 0xe769,
  "fullscreen": 0xe5d0,
  "fullscreen_exit": 0xe5d1,
  "functions": 0xe24a,
  "g_mobiledata": 0xf010,
  "g_translate": 0xe927,
  "gamepad": 0xe30f,
  "games": 0xe021,
  "garage": 0xf011,
  "gas_meter": 0xec19,
  "gavel": 0xe90e,
  "generating_tokens": 0xe749,
  "gesture": 0xe155,
  "get_app": 0xe884,
  "gif": 0xe908,
  "gif_box": 0xe7a3,
  "girl": 0xeb68,
  "gite": 0xe58b,
  "golf_course": 0xeb45,
  "gpp_bad": 0xf012,
  "gpp_good": 0xf013,
  "gpp_maybe": 0xf014,
  "gps_fixed": 0xe1b3,
  "gps_not_fixed": 0xe1b4,
  "gps_off": 0xe1b5,
  "grade": 0xe885,
  "gradient": 0xe3e9,
  "grading": 0xea4f,
  "grain": 0xe3ea,
  "graphic_eq": 0xe1b8,
  "grass": 0xf205,
  "grid_3x3": 0xf015,
  "grid_4x4": 0xf016,
  "grid_goldenratio": 0xf017,
  "grid_off": 0xe3eb,
  "grid_on": 0xe3ec,
  "grid_view": 0xe9b0,
  "group": 0xe7ef,
  "group_add": 0xe7f0,
  "group_off": 0xe747,
  "group_remove": 0xe7ad,
  "group_work": 0xe886,
  "groups": 0xf233,
  "groups_2": 0xf8df,
  "groups_3": 0xf8e0,
  "h_mobiledata": 0xf018,
  "h_plus_mobiledata": 0xf019,
  "hail": 0xe9b1,
  "handshake": 0xebcb,
  "handyman": 0xf10b,
  "hardware": 0xea59,
  "hd": 0xe052,
  "hdr_auto": 0xf01a,
  "hdr_auto_select": 0xf01b,
  "hdr_enhanced_select": 0xef51,
  "hdr_off": 0xe3ed,
  "hdr_off_select": 0xf01c,
  "hdr_on": 0xe3ee,
  "hdr_on_select": 0xf01d,
  "hdr_plus": 0xf01e,
  "hdr_strong": 0xe3f1,
  "hdr_weak": 0xe3f2,
  "headphones": 0xf01f,
  "headphones_battery": 0xf020,
  "headset": 0xe310,
  "headset_mic": 0xe311,
  "headset_off": 0xe33a,
  "healing": 0xe3f3,
  "health_and_safety": 0xe1d5,
  "hearing": 0xe023,
  "hearing_disabled": 0xf104,
  "heart_broken": 0xeac2,
  "heat_pump": 0xec18,
  "height": 0xea16,
  "help": 0xe887,
  "help_center": 0xf1c0,
  "help_outline": 0xe8fd,
  "hevc": 0xf021,
  "hexagon": 0xeb39,
  "hide_image": 0xf022,
  "hide_source": 0xf023,
  "high_quality": 0xe024,
  "highlight": 0xe25f,
  "highlight_alt": 0xef52,
  "highlight_off": 0xe888,
  "hiking": 0xe50a,
  "history": 0xe889,
  "history_edu": 0xea3e,
  "history_toggle_off": 0xf17d,
  "hive": 0xeaa6,
  "hls": 0xeb8a,
  "hls_off": 0xeb8c,
  "holiday_village": 0xe58a,
  "home": 0xe88a,
  "home_max": 0xf024,
  "home_mini": 0xf025,
  "home_repair_service": 0xf100,
  "home_work": 0xea09,
  "horizontal_distribute": 0xe014,
  "horizontal_rule": 0xf108,
  "horizontal_split": 0xe947,
  "hot_tub": 0xeb46,
  "hotel": 0xe53a,
  "hotel_class": 0xe743,
  "hourglass_bottom": 0xea5c,
  "hourglass_disabled": 0xef53,
  "hourglass_empty": 0xe88b,
  "hourglass_full": 0xe88c,
  "hourglass_top": 0xea5b,
  "house": 0xea44,
  "house_siding": 0xf202,
  "houseboat": 0xe584,
  "how_to_reg": 0xe174,
  "how_to_vote": 0xe175,
  "html": 0xeb7e,
  "http": 0xe902,
  "https": 0xe88d,
  "hub": 0xe9f4,
  "hvac": 0xf10e,
  "ice_skating": 0xe50b,
  "icecream": 0xea69,
  "image": 0xe3f4,
  "image_aspect_ratio": 0xe3f5,
  "image_not_supported": 0xf116,
  "image_search": 0xe43f,
  "imagesearch_roller": 0xe9b4,
  "import_contacts": 0xe0e0,
  "import_export": 0xe0c3,
  "important_devices": 0xe912,
  "inbox": 0xe156,
  "incomplete_circle": 0xe79b,
  "indeterminate_check_box": 0xe909,
  "info": 0xe88e,
  "input": 0xe890,
  "insert_chart": 0xe24b,
  "insert_chart_outlined": 0xe26a,
  "insert_comment": 0xe24c,
  "insert_drive_file": 0xe24d,
  "insert_emoticon": 0xe24e,
  "insert_invitation": 0xe24f,
  "insert_link": 0xe250,
  "insert_page_break": 0xeaca,
  "insert_photo": 0xe251,
  "insights": 0xf092,
  "install_desktop": 0xeb71,
  "install_mobile": 0xeb72,
  "integration_instructions": 0xef54,
  "interests": 0xe7c8,
  "interpreter_mode": 0xe83b,
  "inventory": 0xe179,
  "inventory_2": 0xe1a1,
  "invert_colors": 0xe891,
  "invert_colors_off": 0xe0c4,
  "ios_share": 0xe6b8,
  "iron": 0xe583,
  "iso": 0xe3f6,
  "javascript": 0xeb7c,
  "join_full": 0xeaeb,
  "join_inner": 0xeaf4,
  "join_left": 0xeaf2,
  "join_right": 0xeaea,
  "kayaking": 0xe50c,
  "kebab_dining": 0xe842,
  "key": 0xe73c,
  "key_off": 0xeb84,
  "keyboard": 0xe312,
  "keyboard_alt": 0xf028,
  "keyboard_arrow_down": 0xe313,
  "keyboard_arrow_left": 0xe314,
  "keyboard_arrow_right": 0xe315,
  "keyboard_arrow_up": 0xe316,
  "keyboard_backspace": 0xe317,
  "keyboard_capslock": 0xe318,
  "keyboard_command_key": 0xeae7,
  "keyboard_control_key": 0xeae6,
  "keyboard_double_arrow_down": 0xead0,
  "keyboard_double_arrow_left": 0xeac3,
  "keyboard_double_arrow_right": 0xeac9,
  "keyboard_double_arrow_up": 0xeacf,
  "keyboard_hide": 0xe31a,
  "keyboard_option_key": 0xeae8,
  "keyboard_return": 0xe31b,
  "keyboard_tab": 0xe31c,
  "keyboard_voice": 0xe31d,
  "king_bed": 0xea45,
  "kitchen": 0xeb47,
  "kitesurfing": 0xe50d,
  "label": 0xe892,
  "label_important": 0xe937,
  "label_off": 0xe9b6,
  "lan": 0xeb2f,
  "landscape": 0xe3f7,
  "landslide": 0xebd7,
  "language": 0xe894,
  "laptop": 0xe31e,
  "laptop_chromebook": 0xe31f,
  "laptop_mac": 0xe320,
  "laptop_windows": 0xe321,
  "last_page": 0xe5dd,
  "launch": 0xe895,
  "layers": 0xe53b,
  "layers_clear": 0xe53c,
  "leaderboard": 0xf20c,
  "leak_add": 0xe3f8,
  "leak_remove": 0xe3f9,
  "legend_toggle": 0xf11b,
  "lens": 0xe3fa,
  "lens_blur": 0xf029,
  "library_add": 0xe02e,
  "library_add_check": 0xe9b7,
  "library_books": 0xe02f,
  "library_music": 0xe030,
  "light": 0xf02a,
  "light_mode": 0xe518,
  "lightbulb": 0xe0f0,
  "lightbulb_circle": 0xebfe,
  "line_axis": 0xea9a,
  "line_style": 0xe919,
  "line_weight": 0xe91a,
  "linear_scale": 0xe260,
  "link": 0xe157,
  "link_off": 0xe16f,
  "linked_camera": 0xe438,
  "liquor": 0xea60,
  "list": 0xe896,
  "list_alt": 0xe0ee,
  "live_help": 0xe0c6,
  "live_tv": 0xe639,
  "living": 0xf02b,
  "local_activity": 0xe53f,
  "local_airport": 0xe53d,
  "local_atm": 0xe53e,
  "local_bar": 0xe540,
  "local_cafe": 0xe541,
  "local_car_wash": 0xe542,
  "local_convenience_store": 0xe543,
  "local_dining": 0xe556,
  "local_drink": 0xe544,
  "local_fire_department": 0xef55,
  "local_florist": 0xe545,
  "local_gas_station": 0xe546,
  "local_grocery_store": 0xe547,
  "local_hospital": 0xe548,
  "local_hotel": 0xe549,
  "local_laundry_service": 0xe54a,
  "local_library": 0xe54b,
  "local_mall": 0xe54c,
  "local_movies": 0xe54d,
  "local_offer": 0xe54e,
  "local_parking": 0xe54f,
  "local_pharmacy": 0xe550,
  "local_phone": 0xe551,
  "local_pizza": 0xe552,
  "local_play": 0xe553,
  "local_police": 0xef56,
  "local_post_office": 0xe554,
  "local_printshop": 0xe555,
  "local_see": 0xe557,
  "local_shipping": 0xe558,
  "local_taxi": 0xe559,
  "location_city": 0xe7f1,
  "location_disabled": 0xe1b6,
  "location_off": 0xe0c7,
  "location_on": 0xe0c8,
  "location_searching": 0xe1b7,
  "lock": 0xe897,
  "lock_clock": 0xef57,
  "lock_open": 0xe898,
  "lock_person": 0xf8f3,
  "lock_reset": 0xeade,
  "login": 0xea77,
  "logo_dev": 0xead6,
  "logout": 0xe9ba,
  "looks": 0xe3fc,
  "looks_3": 0xe3fb,
  "looks_4": 0xe3fd,
  "looks_5": 0xe3fe,
  "looks_6": 0xe3ff,
  "looks_one": 0xe400,
  "looks_two": 0xe401,
  "loop": 0xe028,
  "loupe": 0xe402,
  "low_priority": 0xe16d,
  "loyalty": 0xe89a,
  "lte_mobiledata": 0xf02c,
  "lte_plus_mobiledata": 0xf02d,
  "luggage": 0xf235,
  "lunch_dining": 0xea61,
  "lyrics": 0xec0b,
  "macro_off": 0xf8d2,
  "mail": 0xe158,
  "mail_lock": 0xec0a,
  "mail_outline": 0xe0e1,
  "male": 0xe58e,
  "man": 0xe4eb,
  "man_2": 0xf8e1,
  "man_3": 0xf8e2,
  "man_4": 0xf8e3,
  "manage_accounts": 0xf02e,
  "manage_history": 0xebe7,
  "manage_search": 0xf02f,
  "map": 0xe55b,
  "maps_home_work": 0xf030,
  "maps_ugc": 0xef58,
  "margin": 0xe9bb,
  "mark_as_unread": 0xe9bc,
  "mark_chat_read": 0xf18b,
  "mark_chat_unread": 0xf189,
  "mark_email_read": 0xf18c,
  "mark_email_unread": 0xf18a,
  "mark_unread_chat_alt": 0xeb9d,
  "markunread": 0xe159,
  "markunread_mailbox": 0xe89b,
  "masks": 0xf218,
  "maximize": 0xe930,
  "media_bluetooth_off": 0xf031,
  "media_bluetooth_on": 0xf032,
  "mediation": 0xefa7,
  "medical_information": 0xebed,
  "medical_services": 0xf109,
  "medication": 0xf033,
  "medication_liquid": 0xea87,
  "meeting_room": 0xeb4f,
  "memory": 0xe322,
  "menu": 0xe5d2,
  "menu_book": 0xea19,
  "menu_open": 0xe9bd,
  "merge": 0xeb98,
  "merge_type": 0xe252,
  "message": 0xe0c9,
  "mic": 0xe029,
  "mic_external_off": 0xef59,
  "mic_external_on": 0xef5a,
  "mic_none": 0xe02a,
  "mic_off": 0xe02b,
  "microwave": 0xf204,
  "military_tech": 0xea3f,
  "minimize": 0xe931,
  "minor_crash": 0xebf1,
  "miscellaneous_services": 0xf10c,
  "missed_video_call": 0xe073,
  "mms": 0xe618,
  "mobile_friendly": 0xe200,
  "mobile_off": 0xe201,
  "mobile_screen_share": 0xe0e7,
  "mobiledata_off": 0xf034,
  "mode": 0xf097,
  "mode_comment": 0xe253,
  "mode_edit": 0xe254,
  "mode_edit_outline": 0xf035,
  "mode_fan_off": 0xec17,
  "mode_night": 0xf036,
  "mode_of_travel": 0xe7ce,
  "mode_standby": 0xf037,
  "model_training": 0xf0cf,
  "monetization_on": 0xe263,
  "money": 0xe57d,
  "money_off": 0xe25c,
  "money_off_csred": 0xf038,
  "monitor": 0xef5b,
  "monitor_heart": 0xeaa2,
  "monitor_weight": 0xf039,
  "monochrome_photos": 0xe403,
  "mood": 0xe7f2,
  "mood_bad": 0xe7f3,
  "moped": 0xeb28,
  "more": 0xe619,
  "more_horiz": 0xe5d3,
  "more_time": 0xea5d,
  "more_vert": 0xe5d4,
  "mosque": 0xeab2,
  "motion_photos_auto": 0xf03a,
  "motion_photos_off": 0xe9c0,
  "motion_photos_on": 0xe9c1,
  "motion_photos_pause": 0xf227,
  "motion_photos_paused": 0xe9c2,
  "mouse": 0xe323,
  "move_down": 0xeb61,
  "move_to_inbox": 0xe168,
  "move_up": 0xeb64,
  "movie": 0xe02c,
  "movie_creation": 0xe404,
  "movie_filter": 0xe43a,
  "moving": 0xe501,
  "mp": 0xe9c3,
  "multiline_chart": 0xe6df,
  "multiple_stop": 0xf1b9,
  "museum": 0xea36,
  "music_note": 0xe405,
  "music_off": 0xe440,
  "music_video": 0xe063,
  "my_location": 0xe55c,
  "nat": 0xef5c,
  "nature": 0xe406,
  "nature_people": 0xe407,
  "navigate_before": 0xe408,
  "navigate_next": 0xe409,
  "navigation": 0xe55d,
  "near_me": 0xe569,
  "near_me_disabled": 0xf1ef,
  "nearby_error": 0xf03b,
  "nearby_off": 0xf03c,
  "nest_cam_wired_stand": 0xec16,
  "network_cell": 0xe1b9,
  "network_check": 0xe640,
  "network_locked": 0xe61a,
  "network_ping": 0xebca,
  "network_wifi": 0xe1ba,
  "network_wifi_1_bar": 0xebe4,
  "network_wifi_2_bar": 0xebd6,
  "network_wifi_3_bar": 0xebe1,
  "new_label": 0xe609,
  "new_releases": 0xe031,
  "newspaper": 0xeb81,
  "next_plan": 0xef5d,
  "next_week": 0xe16a,
  "nfc": 0xe1bb,
  "night_shelter": 0xf1f1,
  "nightlife": 0xea62,
  "nightlight": 0xf03d,
  "nightlight_round": 0xef5e,
  "nights_stay": 0xea46,
  "no_accounts": 0xf03e,
  "no_adult_content": 0xf8fe,
  "no_backpack": 0xf237,
  "no_cell": 0xf1a4,
  "no_crash": 0xebf0,
  "no_drinks": 0xf1a5,
  "no_encryption": 0xe641,
  "no_encryption_gmailerrorred": 0xf03f,
  "no_flash": 0xf1a6,
  "no_food": 0xf1a7,
  "no_luggage": 0xf23b,
  "no_meals": 0xf1d6,
  "no_meeting_room": 0xeb4e,
  "no_photography": 0xf1a8,
  "no_sim": 0xe0cc,
  "no_stroller": 0xf1af,
  "no_transfer": 0xf1d5,
  "noise_aware": 0xebec,
  "noise_control_off": 0xebf3,
  "nordic_walking": 0xe50e,
  "north": 0xf1e0,
  "north_east": 0xf1e1,
  "north_west": 0xf1e2,
  "not_accessible": 0xf0fe,
  "not_interested": 0xe033,
  "not_listed_location": 0xe575,
  "not_started": 0xf0d1,
  "note": 0xe06f,
  "note_add": 0xe89c,
  "note_alt": 0xf040,
  "notes": 0xe26c,
  "notification_add": 0xe399,
  "notification_important": 0xe004,
  "notifications": 0xe7f4,
  "notifications_active": 0xe7f7,
  "notifications_none": 0xe7f5,
  "notifications_off": 0xe7f6,
  "notifications_paused": 0xe7f8,
  "numbers": 0xeac7,
  "offline_bolt": 0xe932,
  "offline_pin": 0xe90a,
  "offline_share": 0xe9c5,
  "oil_barrel": 0xec15,
  "on_device_training": 0xebfd,
  "ondemand_video": 0xe63a,
  "online_prediction": 0xf0eb,
  "opacity": 0xe91c,
  "open_in_browser": 0xe89d,
  "open_in_full": 0xf1ce,
  "open_in_new": 0xe89e,
  "open_in_new_off": 0xe4f6,
  "open_with": 0xe89f,
  "other_houses": 0xe58c,
  "outbound": 0xe1ca,
  "outbox": 0xef5f,
  "outdoor_grill": 0xea47,
  "outlet": 0xf1d4,
  "outlined_flag": 0xe16e,
  "output": 0xebbe,
  "padding": 0xe9c8,
  "pages": 0xe7f9,
  "pageview": 0xe8a0,
  "paid": 0xf041,
  "palette": 0xe40a,
  "pan_tool": 0xe925,
  "pan_tool_alt": 0xebb9,
  "panorama": 0xe40b,
  "panorama_fish_eye": 0xe40c,
  "panorama_horizontal": 0xe40d,
  "panorama_horizontal_select": 0xef60,
  "panorama_photosphere": 0xe9c9,
  "panorama_photosphere_select": 0xe9ca,
  "panorama_vertical": 0xe40e,
  "panorama_vertical_select": 0xef61,
  "panorama_wide_angle": 0xe40f,
  "panorama_wide_angle_select": 0xef62,
  "paragliding": 0xe50f,
  "park": 0xea63,
  "party_mode": 0xe7fa,
  "password": 0xf042,
  "pattern": 0xf043,
  "pause": 0xe034,
  "pause_circle": 0xe1a2,
  "pause_circle_filled": 0xe035,
  "pause_circle_outline": 0xe036,
  "pause_presentation": 0xe0ea,
  "payment": 0xe8a1,
  "payments": 0xef63,
  "pedal_bike": 0xeb29,
  "pending": 0xef64,
  "pending_actions": 0xf1bb,
  "pentagon": 0xeb50,
  "people": 0xe7fb,
  "people_alt": 0xea21,
  "people_outline": 0xe7fc,
  "percent": 0xeb58,
  "perm_camera_mic": 0xe8a2,
  "perm_contact_calendar": 0xe8a3,
  "perm_data_setting": 0xe8a4,
  "perm_device_information": 0xe8a5,
  "perm_identity": 0xe8a6,
  "perm_media": 0xe8a7,
  "perm_phone_msg": 0xe8a8,
  "perm_scan_wifi": 0xe8a9,
  "person": 0xe7fd,
  "person_2": 0xf8e4,
  "person_3": 0xf8e5,
  "person_4": 0xf8e6,
  "person_add": 0xe7fe,
  "person_add_alt": 0xea4d,
  "person_add_alt_1": 0xef65,
  "person_add_disabled": 0xe9cb,
  "person_off": 0xe510,
  "person_outline": 0xe7ff,
  "person_pin": 0xe55a,
  "person_pin_circle": 0xe56a,
  "person_remove": 0xef66,
  "person_remove_alt_1": 0xef67,
  "person_search": 0xf106,
  "personal_injury": 0xe6da,
  "personal_video": 0xe63b,
  "pest_control": 0xf0fa,
  "pest_control_rodent": 0xf0fd,
  "pets": 0xe91d,
  "phishing": 0xead7,
  "phone": 0xe0cd,
  "phone_android": 0xe324,
  "phone_bluetooth_speaker": 0xe61b,
  "phone_callback": 0xe649,
  "phone_disabled": 0xe9cc,
  "phone_enabled": 0xe9cd,
  "phone_forwarded": 0xe61c,
  "phone_iphone": 0xe325,
  "phone_locked": 0xe61e,
  "phone_missed": 0xe61f,
  "phone_paused": 0xe620,
  "phonelink": 0xe326,
  "phonelink_erase": 0xe0db,
  "phonelink_lock": 0xe0dc,
  "phonelink_off": 0xe327,
  "phonelink_ring": 0xe0dd,
  "phonelink_setup": 0xe0de,
  "photo": 0xe410,
  "photo_album": 0xe411,
  "photo_camera": 0xe412,
  "photo_camera_back": 0xef68,
  "photo_camera_front": 0xef69,
  "photo_filter": 0xe43b,
  "photo_library": 0xe413,
  "photo_size_select_actual": 0xe432,
  "photo_size_select_large": 0xe433,
  "photo_size_select_small": 0xe434,
  "php": 0xeb8f,
  "piano": 0xe521,
  "piano_off": 0xe520,
  "picture_as_pdf": 0xe415,
  "picture_in_picture": 0xe8aa,
  "picture_in_picture_alt": 0xe911,
  "pie_chart": 0xe6c4,
  "pie_chart_outline": 0xf044,
  "pin": 0xf045,
  "pin_drop": 0xe55e,
  "pin_end": 0xe767,
  "pin_invoke": 0xe763,
  "pinch": 0xeb38,
  "pivot_table_chart": 0xe9ce,
  "pix": 0xeaa3,
  "place": 0xe55f,
  "plagiarism": 0xea5a,
  "play_arrow": 0xe037,
  "play_circle": 0xe1c4,
  "play_circle_filled": 0xe038,
  "play_circle_outline": 0xe039,
  "play_disabled": 0xef6a,
  "play_for_work": 0xe906,
  "play_lesson": 0xf047,
  "playlist_add": 0xe03b,
  "playlist_add_check": 0xe065,
  "playlist_add_check_circle": 0xe7e6,
  "playlist_add_circle": 0xe7e5,
  "playlist_play": 0xe05f,
  "playlist_remove": 0xeb80,
  "plumbing": 0xf107,
  "plus_one": 0xe800,
  "podcasts": 0xf048,
  "point_of_sale": 0xf17e,
  "policy": 0xea17,
  "poll": 0xe801,
  "polyline": 0xebbb,
  "polymer": 0xe8ab,
  "pool": 0xeb48,
  "portable_wifi_off": 0xe0ce,
  "portrait": 0xe416,
  "post_add": 0xea20,
  "power": 0xe63c,
  "power_input": 0xe336,
  "power_off": 0xe646,
  "power_settings_new": 0xe8ac,
  "precision_manufacturing": 0xf049,
  "pregnant_woman": 0xe91e,
  "present_to_all": 0xe0df,
  "preview": 0xf1c5,
  "price_change": 0xf04a,
  "price_check": 0xf04b,
  "print": 0xe8ad,
  "print_disabled": 0xe9cf,
  "priority_high": 0xe645,
  "privacy_tip": 0xf0dc,
  "private_connectivity": 0xe744,
  "production_quantity_limits": 0xe1d1,
  "propane": 0xec14,
  "propane_tank": 0xec13,
  "psychology": 0xea4a,
  "psychology_alt": 0xf8ea,
  "public": 0xe80b,
  "public_off": 0xf1ca,
  "publish": 0xe255,
  "published_with_changes": 0xf232,
  "punch_clock": 0xeaa8,
  "push_pin": 0xf10d,
  "qr_code": 0xef6b,
  "qr_code_2": 0xe00a,
  "qr_code_scanner": 0xf206,
  "query_builder": 0xe8ae,
  "query_stats": 0xe4fc,
  "question_answer": 0xe8af,
  "question_mark": 0xeb8b,
  "queue": 0xe03c,
  "queue_music": 0xe03d,
  "queue_play_next": 0xe066,
  "quickreply": 0xef6c,
  "quiz": 0xf04c,
  "r_mobiledata": 0xf04d,
  "radar": 0xf04e,
  "radio": 0xe03e,
  "radio_button_checked": 0xe837,
  "radio_button_unchecked": 0xe836,
  "railway_alert": 0xe9d1,
  "ramen_dining": 0xea64,
  "ramp_left": 0xeb9c,
  "ramp_right": 0xeb96,
  "rate_review": 0xe560,
  "raw_off": 0xf04f,
  "raw_on": 0xf050,
  "read_more": 0xef6d,
  "real_estate_agent": 0xe73a,
  "receipt": 0xe8b0,
  "receipt_long": 0xef6e,
  "recent_actors": 0xe03f,
  "recommend": 0xe9d2,
  "record_voice_over": 0xe91f,
  "rectangle": 0xeb54,
  "recycling": 0xe760,
  "redeem": 0xe8b1,
  "redo": 0xe15a,
  "reduce_capacity": 0xf21c,
  "refresh": 0xe5d5,
  "remember_me": 0xf051,
  "remove": 0xe15b,
  "remove_circle": 0xe15c,
  "remove_circle_outline": 0xe15d,
  "remove_done": 0xe9d3,
  "remove_from_queue": 0xe067,
  "remove_moderator": 0xe9d4,
  "remove_red_eye": 0xe417,
  "remove_road": 0xebfc,
  "remove_shopping_cart": 0xe928,
  "reorder": 0xe8fe,
  "repartition": 0xf8e8,
  "repeat": 0xe040,
  "repeat_on": 0xe9d6,
  "repeat_one": 0xe041,
  "repeat_one_on": 0xe9d7,
  "replay": 0xe042,
  "replay_10": 0xe059,
  "replay_30": 0xe05a,
  "replay_5": 0xe05b,
  "replay_circle_filled": 0xe9d8,
  "reply": 0xe15e,
  "reply_all": 0xe15f,
  "report": 0xe160,
  "report_gmailerrorred": 0xf052,
  "report_off": 0xe170,
  "report_problem": 0xe8b2,
  "request_page": 0xf22c,
  "request_quote": 0xf1b6,
  "reset_tv": 0xe9d9,
  "restart_alt": 0xf053,
  "restaurant": 0xe56c,
  "restaurant_menu": 0xe561,
  "restore": 0xe8b3,
  "restore_from_trash": 0xe938,
  "restore_page": 0xe929,
  "reviews": 0xf054,
  "rice_bowl": 0xf1f5,
  "ring_volume": 0xe0d1,
  "rocket": 0xeba5,
  "rocket_launch": 0xeb9b,
  "roller_shades": 0xec12,
  "roller_shades_closed": 0xec11,
  "roller_skating": 0xebcd,
  "roofing": 0xf201,
  "room": 0xe8b4,
  "room_preferences": 0xf1b8,
  "room_service": 0xeb49,
  "rotate_90_degrees_ccw": 0xe418,
  "rotate_90_degrees_cw": 0xeaab,
  "rotate_left": 0xe419,
  "rotate_right": 0xe41a,
  "roundabout_left": 0xeb99,
  "roundabout_right": 0xeba3,
  "rounded_corner": 0xe920,
  "route": 0xeacd,
  "router": 0xe328,
  "rowing": 0xe921,
  "rss_feed": 0xe0e5,
  "rsvp": 0xf055,
  "rtt": 0xe9ad,
  "rule": 0xf1c2,
  "rule_folder": 0xf1c9,
  "run_circle": 0xef6f,
  "running_with_errors": 0xe51d,
  "rv_hookup": 0xe642,
  "safety_check": 0xebef,
  "safety_divider": 0xe1cc,
  "sailing": 0xe502,
  "sanitizer": 0xf21d,
  "satellite": 0xe562,
  "satellite_alt": 0xeb3a,
  "save": 0xe161,
  "save_alt": 0xe171,
  "save_as": 0xeb60,
  "saved_search": 0xea11,
  "savings": 0xe2eb,
  "scale": 0xeb5f,
  "scanner": 0xe329,
  "scatter_plot": 0xe268,
  "schedule": 0xe8b5,
  "schedule_send": 0xea0a,
  "schema": 0xe4fd,
  "school": 0xe80c,
  "science": 0xea4b,
  "score": 0xe269,
  "scoreboard": 0xebd0,
  "screen_lock_landscape": 0xe1be,
  "screen_lock_portrait": 0xe1bf,
  "screen_lock_rotation": 0xe1c0,
  "screen_rotation": 0xe1c1,
  "screen_rotation_alt": 0xebee,
  "screen_search_desktop": 0xef70,
  "screen_share": 0xe0e2,
  "screenshot": 0xf056,
  "screenshot_monitor": 0xec08,
  "scuba_diving": 0xebce,
  "sd": 0xe9dd,
  "sd_card": 0xe623,
  "sd_card_alert": 0xf057,
  "sd_storage": 0xe1c2,
  "search": 0xe8b6,
  "search_off": 0xea76,
  "security": 0xe32a,
  "security_update": 0xf058,
  "security_update_good": 0xf059,
  "security_update_warning": 0xf05a,
  "segment": 0xe94b,
  "select_all": 0xe162,
  "self_improvement": 0xea78,
  "sell": 0xf05b,
  "send": 0xe163,
  "send_and_archive": 0xea0c,
  "send_time_extension": 0xeadb,
  "send_to_mobile": 0xf05c,
  "sensor_door": 0xf1b5,
  "sensor_occupied": 0xec10,
  "sensor_window": 0xf1b4,
  "sensors": 0xe51e,
  "sensors_off": 0xe51f,
  "sentiment_dissatisfied": 0xe811,
  "sentiment_neutral": 0xe812,
  "sentiment_satisfied": 0xe813,
  "sentiment_satisfied_alt": 0xe0ed,
  "sentiment_very_dissatisfied": 0xe814,
  "sentiment_very_satisfied": 0xe815,
  "set_meal": 0xf1ea,
  "settings": 0xe8b8,
  "settings_accessibility": 0xf05d,
  "settings_applications": 0xe8b9,
  "settings_backup_restore": 0xe8ba,
  "settings_bluetooth": 0xe8bb,
  "settings_brightness": 0xe8bd,
  "settings_cell": 0xe8bc,
  "settings_ethernet": 0xe8be,
  "settings_input_antenna": 0xe8bf,
  "settings_input_component": 0xe8c0,
  "settings_input_composite": 0xe8c1,
  "settings_input_hdmi": 0xe8c2,
  "settings_input_svideo": 0xe8c3,
  "settings_overscan": 0xe8c4,
  "settings_phone": 0xe8c5,
  "settings_power": 0xe8c6,
  "settings_remote": 0xe8c7,
  "settings_suggest": 0xf05e,
  "settings_system_daydream": 0xe1c3,
  "settings_voice": 0xe8c8,
  "severe_cold": 0xebd3,
  "shape_line": 0xf8d3,
  "share": 0xe80d,
  "share_location": 0xf05f,
  "shield": 0xe9e0,
  "shield_moon": 0xeaa9,
  "shop": 0xe8c9,
  "shop_2": 0xe19e,
  "shop_two": 0xe8ca,
  "shopping_bag": 0xf1cc,
  "shopping_basket": 0xe8cb,
  "shopping_cart": 0xe8cc,
  "shopping_cart_checkout": 0xeb88,
  "short_text": 0xe261,
  "shortcut": 0xf060,
  "show_chart": 0xe6e1,
  "shower": 0xf061,
  "shuffle": 0xe043,
  "shuffle_on": 0xe9e1,
  "shutter_speed": 0xe43d,
  "sick": 0xf220,
  "sign_language": 0xebe5,
  "signal_cellular_0_bar": 0xf0a8,
  "signal_cellular_4_bar": 0xe1c8,
  "signal_cellular_alt": 0xe202,
  "signal_cellular_alt_1_bar": 0xebdf,
  "signal_cellular_alt_2_bar": 0xebe3,
  "signal_cellular_connected_no_internet_0_bar": 0xf0ac,
  "signal_cellular_connected_no_internet_4_bar": 0xe1cd,
  "signal_cellular_no_sim": 0xe1ce,
  "signal_cellular_nodata": 0xf062,
  "signal_cellular_null": 0xe1cf,
  "signal_cellular_off": 0xe1d0,
  "signal_wifi_0_bar": 0xf0b0,
  "signal_wifi_4_bar": 0xe1d8,
  "signal_wifi_4_bar_lock": 0xe1d9,
  "signal_wifi_bad": 0xf063,
  "signal_wifi_connected_no_internet_4": 0xf064,
  "signal_wifi_off": 0xe1da,
  "signal_wifi_statusbar_4_bar": 0xf065,
  "signal_wifi_statusbar_connected_no_internet_4": 0xf066,
  "signal_wifi_statusbar_null": 0xf067,
  "signpost": 0xeb91,
  "sim_card": 0xe32b,
  "sim_card_alert": 0xe624,
  "sim_card_download": 0xf068,
  "single_bed": 0xea48,
  "sip": 0xf069,
  "skateboarding": 0xe511,
  "skip_next": 0xe044,
  "skip_previous": 0xe045,
  "sledding": 0xe512,
  "slideshow": 0xe41b,
  "slow_motion_video": 0xe068,
  "smart_button": 0xf1c1,
  "smart_display": 0xf06a,
  "smart_screen": 0xf06b,
  "smart_toy": 0xf06c,
  "smartphone": 0xe32c,
  "smoke_free": 0xeb4a,
  "smoking_rooms": 0xeb4b,
  "sms": 0xe625,
  "sms_failed": 0xe626,
  "snippet_folder": 0xf1c7,
  "snooze": 0xe046,
  "snowboarding": 0xe513,
  "snowmobile": 0xe503,
  "snowshoeing": 0xe514,
  "soap": 0xf1b2,
  "social_distance": 0xe1cb,
  "solar_power": 0xec0f,
  "sort": 0xe164,
  "sort_by_alpha": 0xe053,
  "sos": 0xebf7,
  "soup_kitchen": 0xe7d3,
  "source": 0xf1c4,
  "south": 0xf1e3,
  "south_america": 0xe7e4,
  "south_east": 0xf1e4,
  "south_west": 0xf1e5,
  "spa": 0xeb4c,
  "space_bar": 0xe256,
  "space_dashboard": 0xe66b,
  "spatial_audio": 0xebeb,
  "spatial_audio_off": 0xebe8,
  "spatial_tracking": 0xebea,
  "speaker": 0xe32d,
  "speaker_group": 0xe32e,
  "speaker_notes": 0xe8cd,
  "speaker_notes_off": 0xe92a,
  "speaker_phone": 0xe0d2,
  "speed": 0xe9e4,
  "spellcheck": 0xe8ce,
  "splitscreen": 0xf06d,
  "spoke": 0xe9a7,
  "sports": 0xea30,
  "sports_bar": 0xf1f3,
  "sports_baseball": 0xea51,
  "sports_basketball": 0xea26,
  "sports_cricket": 0xea27,
  "sports_esports": 0xea28,
  "sports_football": 0xea29,
  "sports_golf": 0xea2a,
  "sports_gymnastics": 0xebc4,
  "sports_handball": 0xea33,
  "sports_hockey": 0xea2b,
  "sports_kabaddi": 0xea34,
  "sports_martial_arts": 0xeae9,
  "sports_mma": 0xea2c,
  "sports_motorsports": 0xea2d,
  "sports_rugby": 0xea2e,
  "sports_score": 0xf06e,
  "sports_soccer": 0xea2f,
  "sports_tennis": 0xea32,
  "sports_volleyball": 0xea31,
  "square": 0xeb36,
  "square_foot": 0xea49,
  "ssid_chart": 0xeb66,
  "stacked_bar_chart": 0xe9e6,
  "stacked_line_chart": 0xf22b,
  "stadium": 0xeb90,
  "stairs": 0xf1a9,
  "star": 0xe838,
  "star_border": 0xe83a,
  "star_border_purple500": 0xf099,
  "star_half": 0xe839,
  "star_outline": 0xf06f,
  "star_purple500": 0xf09a,
  "star_rate": 0xf0ec,
  "stars": 0xe8d0,
  "start": 0xe089,
  "stay_current_landscape": 0xe0d3,
  "stay_current_portrait": 0xe0d4,
  "stay_primary_landscape": 0xe0d5,
  "stay_primary_portrait": 0xe0d6,
  "sticky_note_2": 0xf1fc,
  "stop": 0xe047,
  "stop_circle": 0xef71,
  "stop_screen_share": 0xe0e3,
  "storage": 0xe1db,
  "store": 0xe8d1,
  "store_mall_directory": 0xe563,
  "storefront": 0xea12,
  "storm": 0xf070,
  "straight": 0xeb95,
  "straighten": 0xe41c,
  "stream": 0xe9e9,
  "streetview": 0xe56e,
  "strikethrough_s": 0xe257,
  "stroller": 0xf1ae,
  "style": 0xe41d,
  "subdirectory_arrow_left": 0xe5d9,
  "subdirectory_arrow_right": 0xe5da,
  "subject": 0xe8d2,
  "subscript": 0xf111,
  "subscriptions": 0xe064,
  "subtitles": 0xe048,
  "subtitles_off": 0xef72,
  "subway": 0xe56f,
  "summarize": 0xf071,
  "superscript": 0xf112,
  "supervised_user_circle": 0xe939,
  "supervisor_account": 0xe8d3,
  "support": 0xef73,
  "support_agent": 0xf0e2,
  "surfing": 0xe515,
  "surround_sound": 0xe049,
  "swap_calls": 0xe0d7,
  "swap_horiz": 0xe8d4,
  "swap_horizontal_circle": 0xe933,
  "swap_vert": 0xe8d5,
  "swap_vertical_circle": 0xe8d6,
  "swipe": 0xe9ec,
  "swipe_down": 0xeb53,
  "swipe_down_alt": 0xeb30,
  "swipe_left": 0xeb59,
  "swipe_left_alt": 0xeb33,
  "swipe_right": 0xeb52,
  "swipe_right_alt": 0xeb56,
  "swipe_up": 0xeb2e,
  "swipe_up_alt": 0xeb35,
  "swipe_vertical": 0xeb51,
  "switch_access_shortcut": 0xe7e1,
  "switch_access_shortcut_add": 0xe7e2,
  "switch_account": 0xe9ed,
  "switch_camera": 0xe41e,
  "switch_left": 0xf1d1,
  "switch_right": 0xf1d2,
  "switch_video": 0xe41f,
  "synagogue": 0xeab0,
  "sync": 0xe627,
  "sync_alt": 0xea18,
  "sync_disabled": 0xe628,
  "sync_lock": 0xeaee,
  "sync_problem": 0xe629,
  "system_security_update": 0xf072,
  "system_security_update_good": 0xf073,
  "system_security_update_warning": 0xf074,
  "system_update": 0xe62a,
  "system_update_alt": 0xe8d7,
  "tab": 0xe8d8,
  "tab_unselected": 0xe8d9,
  "table_bar": 0xead2,
  "table_chart": 0xe265,
  "table_restaurant": 0xeac6,
  "table_rows": 0xf101,
  "table_view": 0xf1be,
  "tablet": 0xe32f,
  "tablet_android": 0xe330,
  "tablet_mac": 0xe331,
  "tag": 0xe9ef,
  "tag_faces": 0xe420,
  "takeout_dining": 0xea74,
  "tap_and_play": 0xe62b,
  "tapas": 0xf1e9,
  "task": 0xf075,
  "task_alt": 0xe2e6,
  "taxi_alert": 0xef74,
  "temple_buddhist": 0xeab3,
  "temple_hindu": 0xeaaf,
  "terminal": 0xeb8e,
  "terrain": 0xe564,
  "text_decrease": 0xeadd,
  "text_fields": 0xe262,
  "text_format": 0xe165,
  "text_increase": 0xeae2,
  "text_rotate_up": 0xe93a,
  "text_rotate_vertical": 0xe93b,
  "text_rotation_angledown": 0xe93c,
  "text_rotation_angleup": 0xe93d,
  "text_rotation_down": 0xe93e,
  "text_rotation_none": 0xe93f,
  "text_snippet": 0xf1c6,
  "textsms": 0xe0d8,
  "texture": 0xe421,
  "theater_comedy": 0xea66,
  "theaters": 0xe8da,
  "thermostat": 0xf076,
  "thermostat_auto": 0xf077,
  "thumb_down": 0xe8db,
  "thumb_down_alt": 0xe816,
  "thumb_down_off_alt": 0xe9f2,
  "thumb_up": 0xe8dc,
  "thumb_up_alt": 0xe817,
  "thumb_up_off_alt": 0xe9f3,
  "thumbs_up_down": 0xe8dd,
  "thunderstorm": 0xebdb,
  "time_to_leave": 0xe62c,
  "timelapse": 0xe422,
  "timeline": 0xe922,
  "timer": 0xe425,
  "timer_10": 0xe423,
  "timer_10_select": 0xf07a,
  "timer_3": 0xe424,
  "timer_3_select": 0xf07b,
  "timer_off": 0xe426,
  "tips_and_updates": 0xe79a,
  "tire_repair": 0xebc8,
  "title": 0xe264,
  "toc": 0xe8de,
  "today": 0xe8df,
  "toggle_off": 0xe9f5,
  "toggle_on": 0xe9f6,
  "token": 0xea25,
  "toll": 0xe8e0,
  "tonality": 0xe427,
  "topic": 0xf1c8,
  "tornado": 0xe199,
  "touch_app": 0xe913,
  "tour": 0xef75,
  "toys": 0xe332,
  "track_changes": 0xe8e1,
  "traffic": 0xe565,
  "train": 0xe570,
  "tram": 0xe571,
  "transcribe": 0xf8ec,
  "transfer_within_a_station": 0xe572,
  "transform": 0xe428,
  "transgender": 0xe58d,
  "transit_enterexit": 0xe579,
  "translate": 0xe8e2,
  "travel_explore": 0xe2db,
  "trending_down": 0xe8e3,
  "trending_flat": 0xe8e4,
  "trending_up": 0xe8e5,
  "trip_origin": 0xe57b,
  "troubleshoot": 0xe1d2,
  "try": 0xf07c,
  "tsunami": 0xebd8,
  "tty": 0xf1aa,
  "tune": 0xe429,
  "tungsten": 0xf07d,
  "turn_left": 0xeba6,
  "turn_right": 0xebab,
  "turn_sharp_left": 0xeba7,
  "turn_sharp_right": 0xebaa,
  "turn_slight_left": 0xeba4,
  "turn_slight_right": 0xeb9a,
  "turned_in": 0xe8e6,
  "turned_in_not": 0xe8e7,
  "tv": 0xe333,
  "tv_off": 0xe647,
  "two_wheeler": 0xe9f9,
  "type_specimen": 0xf8f0,
  "u_turn_left": 0xeba1,
  "u_turn_right": 0xeba2,
  "umbrella": 0xf1ad,
  "unarchive": 0xe169,
  "undo": 0xe166,
  "unfold_less": 0xe5d6,
  "unfold_less_double": 0xf8cf,
  "unfold_more": 0xe5d7,
  "unfold_more_double": 0xf8d0,
  "unpublished": 0xf236,
  "unsubscribe": 0xe0eb,
  "upcoming": 0xf07e,
  "update": 0xe923,
  "update_disabled": 0xe075,
  "upgrade": 0xf0fb,
  "upload": 0xf09b,
  "upload_file": 0xe9fc,
  "usb": 0xe1e0,
  "usb_off": 0xe4fa,
  "vaccines": 0xe138,
  "vape_free": 0xebc6,
  "vaping_rooms": 0xebcf,
  "verified": 0xef76,
  "verified_user": 0xe8e8,
  "vertical_align_bottom": 0xe258,
  "vertical_align_center": 0xe259,
  "vertical_align_top": 0xe25a,
  "vertical_distribute": 0xe076,
  "vertical_shades": 0xec0e,
  "vertical_shades_closed": 0xec0d,
  "vertical_split": 0xe949,
  "vibration": 0xe62d,
  "video_call": 0xe070,
  "video_camera_back": 0xf07f,
  "video_camera_front": 0xf080,
  "video_chat": 0xf8a0,
  "video_file": 0xeb87,
  "video_label": 0xe071,
  "video_library": 0xe04a,
  "video_settings": 0xea75,
  "video_stable": 0xf081,
  "videocam": 0xe04b,
  "videocam_off": 0xe04c,
  "videogame_asset": 0xe338,
  "videogame_asset_off": 0xe500,
  "view_agenda": 0xe8e9,
  "view_array": 0xe8ea,
  "view_carousel": 0xe8eb,
  "view_column": 0xe8ec,
  "view_comfy": 0xe42a,
  "view_comfy_alt": 0xeb73,
  "view_compact": 0xe42b,
  "view_compact_alt": 0xeb74,
  "view_cozy": 0xeb75,
  "view_day": 0xe8ed,
  "view_headline": 0xe8ee,
  "view_in_ar": 0xe9fe,
  "view_kanban": 0xeb7f,
  "view_list": 0xe8ef,
  "view_module": 0xe8f0,
  "view_quilt": 0xe8f1,
  "view_sidebar": 0xf114,
  "view_stream": 0xe8f2,
  "view_timeline": 0xeb85,
  "view_week": 0xe8f3,
  "vignette": 0xe435,
  "villa": 0xe586,
  "visibility": 0xe8f4,
  "visibility_off": 0xe8f5,
  "voice_chat": 0xe62e,
  "voice_over_off": 0xe94a,
  "voicemail": 0xe0d9,
  "volcano": 0xebda,
  "volume_down": 0xe04d,
  "volume_mute": 0xe04e,
  "volume_off": 0xe04f,
  "volume_up": 0xe050,
  "volunteer_activism": 0xea70,
  "vpn_key": 0xe0da,
  "vpn_key_off": 0xeb7a,
  "vpn_lock": 0xe62f,
  "vrpano": 0xf082,
  "wallet": 0xf8ff,
  "wallpaper": 0xe1bc,
  "warehouse": 0xebb8,
  "warning": 0xe002,
  "warning_amber": 0xf083,
  "wash": 0xf1b1,
  "watch": 0xe334,
  "watch_later": 0xe924,
  "watch_off": 0xeae3,
  "water": 0xf084,
  "water_damage": 0xf203,
  "water_drop": 0xe798,
  "waterfall_chart": 0xea00,
  "waves": 0xe176,
  "waving_hand": 0xe766,
  "wb_auto": 0xe42c,
  "wb_cloudy": 0xe42d,
  "wb_incandescent": 0xe42e,
  "wb_iridescent": 0xe436,
  "wb_shade": 0xea01,
  "wb_sunny": 0xe430,
  "wb_twilight": 0xe1c6,
  "wc": 0xe63d,
  "web": 0xe051,
  "web_asset": 0xe069,
  "web_asset_off": 0xe4f7,
  "web_stories": 0xe595,
  "webhook": 0xeb92,
  "weekend": 0xe16b,
  "west": 0xf1e6,
  "whatshot": 0xe80e,
  "wheelchair_pickup": 0xf1ab,
  "where_to_vote": 0xe177,
  "widgets": 0xe1bd,
  "width_full": 0xf8f5,
  "width_normal": 0xf8f6,
  "width_wide": 0xf8f7,
  "wifi": 0xe63e,
  "wifi_1_bar": 0xe4ca,
  "wifi_2_bar": 0xe4d9,
  "wifi_calling": 0xef77,
  "wifi_calling_3": 0xf085,
  "wifi_channel": 0xeb6a,
  "wifi_find": 0xeb31,
  "wifi_lock": 0xe1e1,
  "wifi_off": 0xe648,
  "wifi_password": 0xeb6b,
  "wifi_protected_setup": 0xf0fc,
  "wifi_tethering": 0xe1e2,
  "wifi_tethering_error": 0xead9,
  "wifi_tethering_off": 0xf087,
  "wind_power": 0xec0c,
  "window": 0xf088,
  "wine_bar": 0xf1e8,
  "woman": 0xe13e,
  "woman_2": 0xf8e7,
  "work": 0xe8f9,
  "work_history": 0xec09,
  "work_off": 0xe942,
  "work_outline": 0xe943,
  "workspace_premium": 0xe7af,
  "workspaces": 0xe1a0,
  "wrap_text": 0xe25b,
  "wrong_location": 0xef78,
  "wysiwyg": 0xf1c3,
  "yard": 0xf089,
  "youtube_searched_for": 0xe8fa,
  "zoom_in": 0xe8ff,
  "zoom_in_map": 0xeb2d,
  "zoom_out": 0xe900,
  "zoom_out_map": 0xe56b,
};

export { type MaterialIcon } from "material-icons/index.d";
