# Beginner's Roadmap to Learn Generative AI in 2024

## 1. User

To start learning Generative AI as a User, follow these steps:

- Sign up and create an account on any Generative AI tools (e.g., ChatGPT, BARD, Midjourney, Dalle 2, Stable Diffusion).
- Gain hands-on experience with these tools.
- Understand the capabilities and features of Generative AI tools.
- Experiment with the tools to explore their pros and cons.

## 2. Super User

After becoming familiar with Generative AI tools, enhance your knowledge as a Super User:

- Learn about Prompt Engineering.
- Explore effective prompts for Generative AI tools.
- Understand best practices for writing prompts.

## 3. Developer

For Developers, the roadmap includes:

### Prerequisites

Before diving into Generative AI development, ensure you have a good understanding of:

- Probability and Statistics concepts.
- Linear Algebra concepts.
- Calculus concepts.
- Programming languages like Python/R.

### Machine Learning

- Comfortable with supervised and unsupervised learning algorithms.
- Build machine learning models on tabular datasets.

### Deep Learning

- Understand deep learning architectures (MLP, RNNs, LSTMs, GRUs, CNNs).
- Hands-on experience with deep learning frameworks (Keras, Tensorflow, Pytorch, or FastAI).
- Train deep learning models, including MLP, RNNs, CNNs.

### Generative Models for NLP and Computer Vision

Choose your path:

#### 3.3.1 Generative Models for NLP

- Master Large Language Models (LLMs) like Transformers, BERT, GPT 3.5, PaLM 2.
- Use LLMs for downstream tasks and finetuning.
- Explore models like ChatGPT and BARD.

#### 3.3.2 Generative Models for Computer Vision

- Learn about diffusion models.
- Understand stable diffusion models.
- Explore models like Mid Journey, DALLE 2.

## 4. Researcher

For aspiring Researchers in Generative AI:

### NLP Researcher

- Implement attention models, KQV attention, layer normalization, positional encoding.
- Build your own GPT architecture.
- Learn reinforcement learning algorithms and PPO.
- Implement RLHF.
- Build ChatGPT from scratch.
- Stay updated with current trends in Generative AI for NLP.

### Computer Vision Researcher

- Build diffusion models from scratch.
- Implement stable diffusion.
- Stay updated with current trends in Generative AI for Computer Vision.

---

This roadmap is a guide to help you progress from being a User to a Researcher in Generative AI. Customize your learning path based on your interests and goals.
