#ifndef MUDLET_MXPENTITYRESOLVER_H
#define MUDLET_MXPENTITYRESOLVER_H

/***************************************************************************
 *   Copyright (C) 2020 by Gustavo Sousa - gustavocms@gmail.com            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "pre_guard.h"
#include <QHash>
#include <QString>
#include "post_guard.h"
#include <functional>

enum TEntityType { ENTITY_TYPE_SYSTEM, ENTITY_TYPE_CUSTOM, ENTITY_TYPE_UNKNOWN };

class TEntityResolver
{
public:
    static const QHash<QString, QString> scmStandardEntites;
    static const TEntityResolver scmDefaultResolver;


    inline bool registerEntity(const QString& entity, const QChar ch) { return registerEntity(entity, QString(ch)); }

    inline bool registerEntity(const QString& entity, const char ch) { return registerEntity(entity, QChar::fromLatin1(ch)); }

    bool registerEntity(const QString& entity, const QString& str);
    bool unregisterEntity(const QString& entity);

    // Having this optional pointer argument may not be optimal, but some callers must know the type
    // and we cannot have a private variable recording it as many classes calling us are using this
    // as a const class.
    QString getResolution(const QString& entityValue, bool resolveCustomEntities = true, TEntityType *entityType = nullptr) const;

    static QString resolveCode(ushort val);
    static QString resolveCode(const QString& entityValue);
    static QString resolveCode(const QString& entityValue, int base);
    static QString interpolate(const QString& input, std::function<QString(const QString&)> resolver);

    QString interpolate(const QString& input) const;

private:
    QHash<QString, QString> mEntititesMap;
};

#endif //MUDLET_MXPENTITYRESOLVER_H
