#include "stdafx.h"
#include "Actor_Loader.hpp"
#include "Script.hpp"
#include "Actor_GameD.hpp"
#include "Timer.hpp"
#include "System.hpp"
#include "Sound.hpp"
#include "ResourceNameHash.hpp"
#include "LibGV.hpp"
#include "Fs.hpp"
#include "Psx.hpp"
#include "Renderer.hpp"
#include "pcx.hpp"
#include <gmock/gmock.h>

#define ACTOR_LOADER_IMPL true

void DoTests();

void Actor_LoaderCpp_ForceLink() 
{
    DoTests();
}

struct Actor_Loader_Impl
{
    int field_0;
    int field_4_data_cnf_line_count;
    int field_8_unknown_state;
    const char* field_C_c_str_ptr_field_2C;
    int field_10;
    int field_14_last_loaded_file_size;
    int field_18_state;
    char* field_1C_c_str_data_cnf_sys_allocd;
    const char* field_20_c_str;
    s16 field_24_field_2C_char_state_resident_type;
    s16 field_26_padding_q;
    void* field_28_sys2_alloc_file_buffer;
    char field_2C_c_str[64];
    char* field_6C_pointer_file_second_dword;
    int field_70_count_file_first_dword;
};
MGS_ASSERT_SIZEOF(Actor_Loader_Impl, 0x74);

MGS_VAR(1, 0x71D13C, DWORD, dword_71D13C, 0);
MGS_VAR(1, 0x6BFBA4, DWORD, dword_6BFBA4, 0);
MGS_VAR(1, 0x71D138, DWORD, dword_71D138, 0);
MGS_VAR(1, 0x78D7AC, DWORD, gFixupLibDg_Allocs_And_Hahses_dword_78D7AC, 0);
MGS_VAR(1, 0x650478, DWORD, dword_650478, 0);
MGS_VAR(1, 0x99533C, DWORD, dword_99533C, 0);

MGS_ARY(1, 0x6504C8, char, 256, gStage_Name_byte_6504C8, {});

void CC Res_loader_tick_helper_401F77(__int16 yoff)
{
    gDispEnv_6BECF0.screen.y1 += yoff;
    gDispEnv_6BECF0.screen.y2 -= yoff;
    Render_Scene_DispEnv_40DD00(&gDispEnv_6BECF0);
    gDispEnv_6BECF0.screen.y1 -= yoff;
    gDispEnv_6BECF0.screen.y2 += yoff;
}
MGS_FUNC_IMPLEX(0x401F77, Res_loader_tick_helper_401F77, ACTOR_LOADER_IMPL);

void CC Res_loader_shutdown_helper_408E95(void* ptr)
{
    System_2_free_40B2A7(ptr);
}
MGS_FUNC_IMPLEX(0x408E95, Res_loader_shutdown_helper_408E95, ACTOR_LOADER_IMPL);

void CC Res_loader_48_end_457C95(Actor_Loader* pLoader)
{
    printf("LoadEnd\n");
    Res_loader_shutdown_helper_408E95(pLoader->field_20_pSystem_allocated_size_0x74);
    gLoaderState_dword_9942B8 = -1;
    Timer_30_1();
}
MGS_FUNC_IMPLEX(0x457C95, Res_loader_48_end_457C95, ACTOR_LOADER_IMPL);

void CC Stage_SetNameQ(const char* stageName)
{
    sprintf(gStage_Name_byte_6504C8, "stage/%s", stageName);
}
MGS_FUNC_IMPLEX(0x408ED8, Stage_SetNameQ, ACTOR_LOADER_IMPL);

Actor_Loader_Impl* CC Stage_LoadRelated_DataCnf_Q2(const char* strStageNameParam)
{
    dword_6BFBA4 = 0;

    char strStageName[80] = {};
    strcpy(strStageName, strStageNameParam);
    if (!strstr(strStageName, "s11d") || dword_71D138)
    {
        dword_71D13C = 0;
        dword_71D138 = 0;
    }
    else
    {
        dword_71D13C = 1;
    }

    gFixupLibDg_Allocs_And_Hahses_dword_78D7AC = 0;

    Actor_Loader_Impl* pAllocated = System_2_zerod_allocate_memory_40B296_T<Actor_Loader_Impl>();
    pAllocated->field_18_state = 0;
    pAllocated->field_1C_c_str_data_cnf_sys_allocd = 0;
    pAllocated->field_8_unknown_state = -1;
    pAllocated->field_C_c_str_ptr_field_2C = pAllocated->field_2C_c_str;

    Stage_SetNameQ(strStageName);

    if (FS_LoadRequest("data.cnf", (void**)&pAllocated->field_1C_c_str_data_cnf_sys_allocd, 1) >= 0)
    {
        File_HITEXT_INIT_51D2ED();

        char strFullStageName[256] = {};
        sprintf(strFullStageName, "stage/%s", strStageName);

        if (dword_650478)
        {
            dword_650478 = 0;
        }
        else
        {
            Sound_CleanUpRelated();
        }

        Sound_LoadFxRelatedQ2(strFullStageName);
        Timer_30_1();
        return pAllocated;
    }
    return nullptr;
}
MGS_FUNC_IMPLEX(0x408918, Stage_LoadRelated_DataCnf_Q2, ACTOR_LOADER_IMPL);


MGS_VAR(1, 0x6BFBA0, char*, Str1_6BFBA0, 0);
MGS_VAR(1, 0x78D7A8, DWORD, Actor_Loader_Impl_Field10_dword_78D7A8, 0);


signed int CC Res_loader_DataCnf_FileLoader_408D6C(Actor_Loader_Impl* pSystemStruct)
{
    if (pSystemStruct->field_20_c_str) //data.cnf data
    {
        for (;;)
        {
            const char* curLine = pSystemStruct->field_2C_c_str;
            pSystemStruct->field_20_c_str = Res_loader_GetLine_408E1B(pSystemStruct->field_20_c_str, pSystemStruct->field_2C_c_str);

            if (!*curLine)
            {
                break;
            }

            if (*curLine == '.')
            {
                // Set the mode to load the next seen files from the data.cnf as 
                switch (pSystemStruct->field_2C_c_str[1])
                {
                case 'c': // .cache
                    pSystemStruct->field_24_field_2C_char_state_resident_type = Actor_Loader::eCache;
                    break;
                case 'n': // .nocache
                    pSystemStruct->field_24_field_2C_char_state_resident_type = Actor_Loader::eNoCache;
                    break;
                case 'r': // .resident
                    pSystemStruct->field_24_field_2C_char_state_resident_type = Actor_Loader::eResident;
                    gFixupLibDg_Allocs_And_Hahses_dword_78D7AC = 1;
                    break;
                case 's': // .sound
                    pSystemStruct->field_24_field_2C_char_state_resident_type = Actor_Loader::eSound;
                    break;
                }
            }
            else
            {
                pSystemStruct->field_28_sys2_alloc_file_buffer = 0;

                const int loadedFileSize = FS_LoadRequest(
                    pSystemStruct->field_2C_c_str,
                    &pSystemStruct->field_28_sys2_alloc_file_buffer,
                    pSystemStruct->field_24_field_2C_char_state_resident_type);

                pSystemStruct->field_10 = loadedFileSize;

                if (loadedFileSize >= 0)
                {
                    // Save the name of the last loaded file
                    pSystemStruct->field_C_c_str_ptr_field_2C = curLine;
                    if (*curLine == '*')
                    {
                        // Remove * from the start of the file name
                        pSystemStruct->field_C_c_str_ptr_field_2C = &pSystemStruct->field_2C_c_str[1];
                    }

                    ++pSystemStruct->field_8_unknown_state;
                    pSystemStruct->field_14_last_loaded_file_size = loadedFileSize;
                    return 1;
                }

                return -1;
            }
        }
    }
    return 0;
}
MGS_FUNC_IMPLEX(0x408D6C, Res_loader_DataCnf_FileLoader_408D6C, ACTOR_LOADER_IMPL);

bool CC Res_loader_Is_Extension_4088F2(const char* fileName, const char* extension)
{
    const char* dotPos = strchr(fileName, '.');
    if (dotPos)
    {
        dotPos++;
    }
    else
    {
        dotPos = fileName;
    }
    return strcmp(dotPos, extension) == 0;
}
MGS_FUNC_IMPLEX(0x4088F2, Res_loader_Is_Extension_4088F2, ACTOR_LOADER_IMPL);

const char* CC Res_loader_GetLine_408E1B(const char* pInput, char* pOutputLine)
{
    *pOutputLine = '\0';

    // Skip new lines
    while (*pInput == '\r' || *pInput == '\n')
    {
        pInput++;
    }

    // Bail if at end
    if (*pInput == '\0')
    {
        return nullptr;
    }

    // Keep going till new line or end
    while (*pInput != '\0')
    {
        if (*pInput == '\n' || *pInput == '\r')
        {
            pInput++;
            break;
        }

        // Copy to output
        *pOutputLine = *pInput;
        pOutputLine++;

        pInput++;
    }

    *pOutputLine = '\0';

    // Bail if at end
    if (*pInput == '\0')
    {
        return nullptr;
    }

    return pInput;
}
MGS_FUNC_IMPLEX(0x408E1B, Res_loader_GetLine_408E1B, ACTOR_LOADER_IMPL);

int CC Res_loader_CountOfNonDotLines_408E67(const char* pInput)
{
    int count = 0;
    char line[64] = {};
    do
    {
        pInput = Res_loader_GetLine_408E1B(pInput, line);
        if (line[0] != '.')
        {
            count++;
        }
    } while (pInput);
    return count;
}
MGS_FUNC_IMPLEX(0x408E67, Res_loader_CountOfNonDotLines_408E67, ACTOR_LOADER_IMPL);

signed int CC Res_loader_help2_408A73(Actor_Loader_Impl* pSystemStruct)
{
    switch (pSystemStruct->field_18_state)
    {
    case 0:
        if (Res_loader_load_file_to_mem_408FAE() <= 0) // Returns 0 so always true
        {
            pSystemStruct->field_18_state = 1;
            pSystemStruct->field_20_c_str = pSystemStruct->field_1C_c_str_data_cnf_sys_allocd;
            pSystemStruct->field_24_field_2C_char_state_resident_type = 1;
            pSystemStruct->field_4_data_cnf_line_count = Res_loader_CountOfNonDotLines_408E67(pSystemStruct->field_1C_c_str_data_cnf_sys_allocd);
            pSystemStruct->field_8_unknown_state = 0;
        }
        break;

    case 1:
        if (Res_loader_DataCnf_FileLoader_408D6C(pSystemStruct) <= 0)
        {
            return 0;
        }
        pSystemStruct->field_18_state = 2;
        break;

    case 2:
        pSystemStruct->field_14_last_loaded_file_size = Res_loader_load_file_to_mem_408FAE(); // Always returns 0
        if (pSystemStruct->field_14_last_loaded_file_size <= 0) // Always true
        {
            if (Res_loader_Is_Extension_4088F2(pSystemStruct->field_C_c_str_ptr_field_2C, "dar"))
            {
                int* file_first_dword = (int *)pSystemStruct->field_28_sys2_alloc_file_buffer;
                pSystemStruct->field_70_count_file_first_dword = *file_first_dword;
                pSystemStruct->field_6C_pointer_file_second_dword = (char*)(file_first_dword + 1);
                pSystemStruct->field_18_state = 3;
            }
            else
            {
                if (pSystemStruct->field_24_field_2C_char_state_resident_type == 3)
                {
                    // dead branch ??
                    //int v3 = pSystemStruct->field_26_padding_q;
                }
                else
                {
                    Actor_Loader_Impl_Field10_dword_78D7A8 = pSystemStruct->field_10;
                    s16 resident_type = pSystemStruct->field_24_field_2C_char_state_resident_type;
                    int maybe_id = Hash_40A5C3(pSystemStruct->field_C_c_str_ptr_field_2C);
                    LibGV_LoadFile_40A77F(pSystemStruct->field_28_sys2_alloc_file_buffer, maybe_id, resident_type);
                    if (pSystemStruct->field_24_field_2C_char_state_resident_type == Actor_Loader::eNoCache)
                    {
                        System_2_free_40B2A7(pSystemStruct->field_28_sys2_alloc_file_buffer);
                    }
                }
                pSystemStruct->field_18_state = 1;
            }
        }
        break;

    case 3:
        if (strstr(pSystemStruct->field_2C_c_str, ".dar"))
        {
            strstr(pSystemStruct->field_2C_c_str, "tex"); // ?? not used
        }

        char* darDataPointer = pSystemStruct->field_6C_pointer_file_second_dword;
        int darItemCount = pSystemStruct->field_70_count_file_first_dword;
        do
        {
            pSystemStruct->field_6C_pointer_file_second_dword = darDataPointer;
            pSystemStruct->field_70_count_file_first_dword = darItemCount;
            
            // Copy the string from the file data into field_2C_c_str
            char* pFileName = pSystemStruct->field_2C_c_str;
            char fileDataChar = 0;
            do
            {
                *pFileName = *darDataPointer;
                fileDataChar = *pFileName++;
                ++darDataPointer;
            } while (fileDataChar);
            LOG_INFO("Processing DAR item: " << pSystemStruct->field_2C_c_str);

            char* pAfterFileNameData = RoundUpPowerOf2Ptr(darDataPointer, 4);

            DWORD darItemFileSize = *(DWORD*)pAfterFileNameData;
            char* darFileDataPointer = pAfterFileNameData + 4;

            if (strstr(pSystemStruct->field_2C_c_str, "pcx"))
            {
                Res_loader_EnableHiTex_51D1DB(pSystemStruct->field_2C_c_str);
            }

            const s16 resident_type = pSystemStruct->field_24_field_2C_char_state_resident_type;
            Str1_6BFBA0 = pSystemStruct->field_2C_c_str;
            const int fileNameHashed = Hash_40A5C3(pSystemStruct->field_2C_c_str);
            const int loadFileRet = LibGV_LoadFile_40A77F(darFileDataPointer, fileNameHashed, resident_type);

            if (!loadFileRet)
            {
                return 1;
            }

            if (loadFileRet < 0)
            {
                printf("INIT_ERROR in %s !!\n", pSystemStruct->field_2C_c_str);
                return 0;
            }

            // Move to the next file in the DAR
            darDataPointer = &darFileDataPointer[darItemFileSize + 1];
            --darItemCount;
        } while (darItemCount > 0);

        if (!pSystemStruct->field_24_field_2C_char_state_resident_type)
        {
            System_2_free_40B2A7(pSystemStruct->field_28_sys2_alloc_file_buffer);
        }
        pSystemStruct->field_18_state = 1;
        break;
    }
    return 1;
}
MGS_FUNC_IMPLEX(0x408A73, Res_loader_help2_408A73, ACTOR_LOADER_IMPL);

signed int CC Res_loader_j_helper2_408A68(Actor_Loader_Impl* pSystemStruct)
{
    return Res_loader_help2_408A73(pSystemStruct);
}
MGS_FUNC_IMPLEX(0x408A68, Res_loader_j_helper2_408A68, ACTOR_LOADER_IMPL);

void CC Res_loader_48_Tick_457C4B(Actor_Loader* pLoader)
{
    ++pLoader->field_2C_counter;
    int flagsM2 = pLoader->field_24_proc_cancel_flags - 2;
    if (flagsM2)
    {
        if (flagsM2 == 1)
        {
            Res_loader_tick_helper_401F77(pLoader->field_2C_counter & 2);// Do a render tick to avoid not responding state?
            dword_99533C = 100;
        }
    }

    if (pLoader->mIsRunning)
    {
        if (!Res_loader_j_helper2_408A68(pLoader->field_20_pSystem_allocated_size_0x74))
        {
            pLoader->mIsRunning = 0;
        }
    }
    else
    {
        Actor_DestroyOnNextUpdate_40A3ED(&pLoader->mBase);
    }
}
MGS_FUNC_IMPLEX(0x457C4B, Res_loader_48_Tick_457C4B, ACTOR_LOADER_IMPL);

void CC Res_loader_Create_457BDD(const char* strStageName)
{
    Actor_Loader* pLoader = Actor_ResourceAllocT<Actor_Loader>(2);

    printf("LoadReq\n");

    Actor_Loader_Impl* pLoaderImpl = Stage_LoadRelated_DataCnf_Q2(strStageName);
    pLoader->field_20_pSystem_allocated_size_0x74 = pLoaderImpl;

    if (!pLoaderImpl)
    {
        printf("NOT FOUND STAGE %s\n", strStageName);
    }

    Actor_Init_40A347(
        &pLoader->mBase,
        reinterpret_cast<TActorFunction>(Res_loader_48_Tick_457C4B),
        reinterpret_cast<TActorFunction>(Res_loader_48_end_457C95),
        "C:\\mgs\\source\\Game\\loader.c");

    int flags = script_cancel_non_zero_dword_7227A0 & 0xF;
    pLoader->mIsRunning = 1;
    pLoader->field_24_proc_cancel_flags = flags;
    gLoaderState_dword_9942B8 = 0;
}
MGS_FUNC_IMPLEX(0x457BDD, Res_loader_Create_457BDD, ACTOR_LOADER_IMPL);

static void Res_loader_Is_Extension_4088F2_Test()
{
    ASSERT_EQ(true, Res_loader_Is_Extension_4088F2("blah.dar", "dar"));
    ASSERT_EQ(true, Res_loader_Is_Extension_4088F2("dar", "dar"));
    ASSERT_EQ(true, Res_loader_Is_Extension_4088F2(".dar", "dar"));
    ASSERT_EQ(false, Res_loader_Is_Extension_4088F2(".DAR", "dar"));
    ASSERT_EQ(false, Res_loader_Is_Extension_4088F2("dar.exe", "dar"));
}

static void Res_loader_408E1B_Test()
{
    const char* kInput = "Line1\r\r\n\nLine2\nblah3\rLOLS4";
    char buffer[40] = {};
    const char* ret = Res_loader_GetLine_408E1B(kInput, buffer);
    ASSERT_STREQ("\r\n\nLine2\nblah3\rLOLS4", ret);
    ASSERT_STREQ("Line1", buffer);

    ret = Res_loader_GetLine_408E1B(ret, buffer);
    ASSERT_STREQ("blah3\rLOLS4", ret);
    ASSERT_STREQ("Line2", buffer);

    ret = Res_loader_GetLine_408E1B(ret, buffer);
    ASSERT_STREQ("LOLS4", ret);
    ASSERT_STREQ("blah3", buffer);
    
    ret = Res_loader_GetLine_408E1B(ret, buffer);
    ASSERT_TRUE(ret == nullptr);
    ASSERT_STREQ("LOLS4", buffer);
}

void DoTests()
{
    Res_loader_Is_Extension_4088F2_Test();
    Res_loader_408E1B_Test();
}
