/* eslint-disable */

export const width = {
  auto: "auto",
  xs: "20rem",
  sm: "24rem",
  md: "28rem",
  lg: "32rem",
  xl: "36rem",
  "2xl": "42rem",
  "3xl": "48rem",
  "4xl": "56rem",
  "5xl": "64rem",
  "6xl": "72rem",
  "7xl": "80rem",
  prose: "65ch",
  screen: "100vw"
};
export const height = {
  auto: "auto",
  xs: "20rem",
  sm: "24rem",
  md: "28rem",
  lg: "32rem",
  xl: "36rem",
  "2xl": "42rem",
  "3xl": "48rem",
  "4xl": "56rem",
  "5xl": "64rem",
  "6xl": "72rem",
  "7xl": "80rem",
  prose: "65ch",
  screen: "100vh"
};
export const maxWidth = {
  none: "none",
  xs: "20rem",
  sm: "24rem",
  md: "28rem",
  lg: "32rem",
  xl: "36rem",
  "2xl": "42rem",
  "3xl": "48rem",
  "4xl": "56rem",
  "5xl": "64rem",
  "6xl": "72rem",
  "7xl": "80rem",
  prose: "65ch",
  screen: "100vw"
};
export const maxHeight = {
  none: "none",
  xs: "20rem",
  sm: "24rem",
  md: "28rem",
  lg: "32rem",
  xl: "36rem",
  "2xl": "42rem",
  "3xl": "48rem",
  "4xl": "56rem",
  "5xl": "64rem",
  "6xl": "72rem",
  "7xl": "80rem",
  prose: "65ch",
  screen: "100vh"
};
export const minWidth = {
  none: "none",
  xs: "20rem",
  sm: "24rem",
  md: "28rem",
  lg: "32rem",
  xl: "36rem",
  "2xl": "42rem",
  "3xl": "48rem",
  "4xl": "56rem",
  "5xl": "64rem",
  "6xl": "72rem",
  "7xl": "80rem",
  prose: "65ch",
  screen: "100vw"
};
export const minHeight = {
  none: "none",
  xs: "20rem",
  sm: "24rem",
  md: "28rem",
  lg: "32rem",
  xl: "36rem",
  "2xl": "42rem",
  "3xl": "48rem",
  "4xl": "56rem",
  "5xl": "64rem",
  "6xl": "72rem",
  "7xl": "80rem",
  prose: "65ch",
  screen: "100vh"
};
export const inlineSize = {
  auto: "auto",
  xs: "20rem",
  sm: "24rem",
  md: "28rem",
  lg: "32rem",
  xl: "36rem",
  "2xl": "42rem",
  "3xl": "48rem",
  "4xl": "56rem",
  "5xl": "64rem",
  "6xl": "72rem",
  "7xl": "80rem",
  prose: "65ch",
  screen: "100vw"
};
export const blockSize = {
  auto: "auto",
  xs: "20rem",
  sm: "24rem",
  md: "28rem",
  lg: "32rem",
  xl: "36rem",
  "2xl": "42rem",
  "3xl": "48rem",
  "4xl": "56rem",
  "5xl": "64rem",
  "6xl": "72rem",
  "7xl": "80rem",
  prose: "65ch",
  screen: "100vh"
};
export const maxInlineSize = {
  none: "none",
  xs: "20rem",
  sm: "24rem",
  md: "28rem",
  lg: "32rem",
  xl: "36rem",
  "2xl": "42rem",
  "3xl": "48rem",
  "4xl": "56rem",
  "5xl": "64rem",
  "6xl": "72rem",
  "7xl": "80rem",
  prose: "65ch",
  screen: "100vw"
};
export const maxBlockSize = {
  none: "none",
  xs: "20rem",
  sm: "24rem",
  md: "28rem",
  lg: "32rem",
  xl: "36rem",
  "2xl": "42rem",
  "3xl": "48rem",
  "4xl": "56rem",
  "5xl": "64rem",
  "6xl": "72rem",
  "7xl": "80rem",
  prose: "65ch",
  screen: "100vh"
};
export const minInlineSize = {
  none: "none",
  xs: "20rem",
  sm: "24rem",
  md: "28rem",
  lg: "32rem",
  xl: "36rem",
  "2xl": "42rem",
  "3xl": "48rem",
  "4xl": "56rem",
  "5xl": "64rem",
  "6xl": "72rem",
  "7xl": "80rem",
  prose: "65ch",
  screen: "100vw"
};
export const minBlockSize = {
  none: "none",
  xs: "20rem",
  sm: "24rem",
  md: "28rem",
  lg: "32rem",
  xl: "36rem",
  "2xl": "42rem",
  "3xl": "48rem",
  "4xl": "56rem",
  "5xl": "64rem",
  "6xl": "72rem",
  "7xl": "80rem",
  prose: "65ch",
  screen: "100vh"
};
export const colors = {
  inherit: "inherit",
  current: "currentColor",
  transparent: "transparent",
  black: "#000",
  white: "#fff",
  rose: {
    "1": "#ffe4e6",
    "2": "#fecdd3",
    "3": "#fda4af",
    "4": "#fb7185",
    "5": "#f43f5e",
    "6": "#e11d48",
    "7": "#be123c",
    "8": "#9f1239",
    "9": "#881337",
    "50": "#fff1f2",
    "100": "#ffe4e6",
    "200": "#fecdd3",
    "300": "#fda4af",
    "400": "#fb7185",
    "500": "#f43f5e",
    "600": "#e11d48",
    "700": "#be123c",
    "800": "#9f1239",
    "900": "#881337",
    "950": "#4c0519",
    DEFAULT: "#fb7185"
  },
  pink: {
    "1": "#fce7f3",
    "2": "#fbcfe8",
    "3": "#f9a8d4",
    "4": "#f472b6",
    "5": "#ec4899",
    "6": "#db2777",
    "7": "#be185d",
    "8": "#9d174d",
    "9": "#831843",
    "50": "#fdf2f8",
    "100": "#fce7f3",
    "200": "#fbcfe8",
    "300": "#f9a8d4",
    "400": "#f472b6",
    "500": "#ec4899",
    "600": "#db2777",
    "700": "#be185d",
    "800": "#9d174d",
    "900": "#831843",
    "950": "#500724",
    DEFAULT: "#f472b6"
  },
  fuchsia: {
    "1": "#fae8ff",
    "2": "#f5d0fe",
    "3": "#f0abfc",
    "4": "#e879f9",
    "5": "#d946ef",
    "6": "#c026d3",
    "7": "#a21caf",
    "8": "#86198f",
    "9": "#701a75",
    "50": "#fdf4ff",
    "100": "#fae8ff",
    "200": "#f5d0fe",
    "300": "#f0abfc",
    "400": "#e879f9",
    "500": "#d946ef",
    "600": "#c026d3",
    "700": "#a21caf",
    "800": "#86198f",
    "900": "#701a75",
    "950": "#4a044e",
    DEFAULT: "#e879f9"
  },
  purple: {
    "1": "#f3e8ff",
    "2": "#e9d5ff",
    "3": "#d8b4fe",
    "4": "#c084fc",
    "5": "#a855f7",
    "6": "#9333ea",
    "7": "#7e22ce",
    "8": "#6b21a8",
    "9": "#581c87",
    "50": "#faf5ff",
    "100": "#f3e8ff",
    "200": "#e9d5ff",
    "300": "#d8b4fe",
    "400": "#c084fc",
    "500": "#a855f7",
    "600": "#9333ea",
    "700": "#7e22ce",
    "800": "#6b21a8",
    "900": "#581c87",
    "950": "#3b0764",
    DEFAULT: "#c084fc"
  },
  violet: {
    "1": "#ede9fe",
    "2": "#ddd6fe",
    "3": "#c4b5fd",
    "4": "#a78bfa",
    "5": "#8b5cf6",
    "6": "#7c3aed",
    "7": "#6d28d9",
    "8": "#5b21b6",
    "9": "#4c1d95",
    "50": "#f5f3ff",
    "100": "#ede9fe",
    "200": "#ddd6fe",
    "300": "#c4b5fd",
    "400": "#a78bfa",
    "500": "#8b5cf6",
    "600": "#7c3aed",
    "700": "#6d28d9",
    "800": "#5b21b6",
    "900": "#4c1d95",
    "950": "#2e1065",
    DEFAULT: "#a78bfa"
  },
  indigo: {
    "1": "#e0e7ff",
    "2": "#c7d2fe",
    "3": "#a5b4fc",
    "4": "#818cf8",
    "5": "#6366f1",
    "6": "#4f46e5",
    "7": "#4338ca",
    "8": "#3730a3",
    "9": "#312e81",
    "50": "#eef2ff",
    "100": "#e0e7ff",
    "200": "#c7d2fe",
    "300": "#a5b4fc",
    "400": "#818cf8",
    "500": "#6366f1",
    "600": "#4f46e5",
    "700": "#4338ca",
    "800": "#3730a3",
    "900": "#312e81",
    "950": "#1e1b4b",
    DEFAULT: "#818cf8"
  },
  blue: {
    "1": "#dbeafe",
    "2": "#bfdbfe",
    "3": "#93c5fd",
    "4": "#60a5fa",
    "5": "#3b82f6",
    "6": "#2563eb",
    "7": "#1d4ed8",
    "8": "#1e40af",
    "9": "#1e3a8a",
    "50": "#eff6ff",
    "100": "#dbeafe",
    "200": "#bfdbfe",
    "300": "#93c5fd",
    "400": "#60a5fa",
    "500": "#3b82f6",
    "600": "#2563eb",
    "700": "#1d4ed8",
    "800": "#1e40af",
    "900": "#1e3a8a",
    "950": "#172554",
    DEFAULT: "#60a5fa"
  },
  sky: {
    "1": "#e0f2fe",
    "2": "#bae6fd",
    "3": "#7dd3fc",
    "4": "#38bdf8",
    "5": "#0ea5e9",
    "6": "#0284c7",
    "7": "#0369a1",
    "8": "#075985",
    "9": "#0c4a6e",
    "50": "#f0f9ff",
    "100": "#e0f2fe",
    "200": "#bae6fd",
    "300": "#7dd3fc",
    "400": "#38bdf8",
    "500": "#0ea5e9",
    "600": "#0284c7",
    "700": "#0369a1",
    "800": "#075985",
    "900": "#0c4a6e",
    "950": "#082f49",
    DEFAULT: "#38bdf8"
  },
  cyan: {
    "1": "#cffafe",
    "2": "#a5f3fc",
    "3": "#67e8f9",
    "4": "#22d3ee",
    "5": "#06b6d4",
    "6": "#0891b2",
    "7": "#0e7490",
    "8": "#155e75",
    "9": "#164e63",
    "50": "#ecfeff",
    "100": "#cffafe",
    "200": "#a5f3fc",
    "300": "#67e8f9",
    "400": "#22d3ee",
    "500": "#06b6d4",
    "600": "#0891b2",
    "700": "#0e7490",
    "800": "#155e75",
    "900": "#164e63",
    "950": "#083344",
    DEFAULT: "#22d3ee"
  },
  teal: {
    "1": "#ccfbf1",
    "2": "#99f6e4",
    "3": "#5eead4",
    "4": "#2dd4bf",
    "5": "#14b8a6",
    "6": "#0d9488",
    "7": "#0f766e",
    "8": "#115e59",
    "9": "#134e4a",
    "50": "#f0fdfa",
    "100": "#ccfbf1",
    "200": "#99f6e4",
    "300": "#5eead4",
    "400": "#2dd4bf",
    "500": "#14b8a6",
    "600": "#0d9488",
    "700": "#0f766e",
    "800": "#115e59",
    "900": "#134e4a",
    "950": "#042f2e",
    DEFAULT: "#2dd4bf"
  },
  emerald: {
    "1": "#d1fae5",
    "2": "#a7f3d0",
    "3": "#6ee7b7",
    "4": "#34d399",
    "5": "#10b981",
    "6": "#059669",
    "7": "#047857",
    "8": "#065f46",
    "9": "#064e3b",
    "50": "#ecfdf5",
    "100": "#d1fae5",
    "200": "#a7f3d0",
    "300": "#6ee7b7",
    "400": "#34d399",
    "500": "#10b981",
    "600": "#059669",
    "700": "#047857",
    "800": "#065f46",
    "900": "#064e3b",
    "950": "#022c22",
    DEFAULT: "#34d399"
  },
  green: {
    "1": "#dcfce7",
    "2": "#bbf7d0",
    "3": "#86efac",
    "4": "#4ade80",
    "5": "#22c55e",
    "6": "#16a34a",
    "7": "#15803d",
    "8": "#166534",
    "9": "#14532d",
    "50": "#f0fdf4",
    "100": "#dcfce7",
    "200": "#bbf7d0",
    "300": "#86efac",
    "400": "#4ade80",
    "500": "#22c55e",
    "600": "#16a34a",
    "700": "#15803d",
    "800": "#166534",
    "900": "#14532d",
    "950": "#052e16",
    DEFAULT: "#4ade80"
  },
  lime: {
    "1": "#ecfccb",
    "2": "#d9f99d",
    "3": "#bef264",
    "4": "#a3e635",
    "5": "#84cc16",
    "6": "#65a30d",
    "7": "#4d7c0f",
    "8": "#3f6212",
    "9": "#365314",
    "50": "#f7fee7",
    "100": "#ecfccb",
    "200": "#d9f99d",
    "300": "#bef264",
    "400": "#a3e635",
    "500": "#84cc16",
    "600": "#65a30d",
    "700": "#4d7c0f",
    "800": "#3f6212",
    "900": "#365314",
    "950": "#1a2e05",
    DEFAULT: "#a3e635"
  },
  yellow: {
    "1": "#fef9c3",
    "2": "#fef08a",
    "3": "#fde047",
    "4": "#facc15",
    "5": "#eab308",
    "6": "#ca8a04",
    "7": "#a16207",
    "8": "#854d0e",
    "9": "#713f12",
    "50": "#fefce8",
    "100": "#fef9c3",
    "200": "#fef08a",
    "300": "#fde047",
    "400": "#facc15",
    "500": "#eab308",
    "600": "#ca8a04",
    "700": "#a16207",
    "800": "#854d0e",
    "900": "#713f12",
    "950": "#422006",
    DEFAULT: "#facc15"
  },
  amber: {
    "1": "#fef3c7",
    "2": "#fde68a",
    "3": "#fcd34d",
    "4": "#fbbf24",
    "5": "#f59e0b",
    "6": "#d97706",
    "7": "#b45309",
    "8": "#92400e",
    "9": "#78350f",
    "50": "#fffbeb",
    "100": "#fef3c7",
    "200": "#fde68a",
    "300": "#fcd34d",
    "400": "#fbbf24",
    "500": "#f59e0b",
    "600": "#d97706",
    "700": "#b45309",
    "800": "#92400e",
    "900": "#78350f",
    "950": "#451a03",
    DEFAULT: "#fbbf24"
  },
  orange: {
    "1": "#ffedd5",
    "2": "#fed7aa",
    "3": "#fdba74",
    "4": "#fb923c",
    "5": "#f97316",
    "6": "#ea580c",
    "7": "#c2410c",
    "8": "#9a3412",
    "9": "#7c2d12",
    "50": "#fff7ed",
    "100": "#ffedd5",
    "200": "#fed7aa",
    "300": "#fdba74",
    "400": "#fb923c",
    "500": "#f97316",
    "600": "#ea580c",
    "700": "#c2410c",
    "800": "#9a3412",
    "900": "#7c2d12",
    "950": "#431407",
    DEFAULT: "#fb923c"
  },
  red: {
    "1": "#fee2e2",
    "2": "#fecaca",
    "3": "#fca5a5",
    "4": "#f87171",
    "5": "#ef4444",
    "6": "#dc2626",
    "7": "#b91c1c",
    "8": "#991b1b",
    "9": "#7f1d1d",
    "50": "#fef2f2",
    "100": "#fee2e2",
    "200": "#fecaca",
    "300": "#fca5a5",
    "400": "#f87171",
    "500": "#ef4444",
    "600": "#dc2626",
    "700": "#b91c1c",
    "800": "#991b1b",
    "900": "#7f1d1d",
    "950": "#450a0a",
    DEFAULT: "#f87171"
  },
  gray: {
    "1": "#f3f4f6",
    "2": "#e5e7eb",
    "3": "#d1d5db",
    "4": "#9ca3af",
    "5": "#6b7280",
    "6": "#4b5563",
    "7": "#374151",
    "8": "#1f2937",
    "9": "#111827",
    "50": "#f9fafb",
    "100": "#f3f4f6",
    "200": "#e5e7eb",
    "300": "#d1d5db",
    "400": "#9ca3af",
    "500": "#6b7280",
    "600": "#4b5563",
    "700": "#374151",
    "800": "#1f2937",
    "900": "#111827",
    "950": "#030712",
    DEFAULT: "#9ca3af"
  },
  slate: {
    "1": "#f1f5f9",
    "2": "#e2e8f0",
    "3": "#cbd5e1",
    "4": "#94a3b8",
    "5": "#64748b",
    "6": "#475569",
    "7": "#334155",
    "8": "#1e293b",
    "9": "#0f172a",
    "50": "#f8fafc",
    "100": "#f1f5f9",
    "200": "#e2e8f0",
    "300": "#cbd5e1",
    "400": "#94a3b8",
    "500": "#64748b",
    "600": "#475569",
    "700": "#334155",
    "800": "#1e293b",
    "900": "#0f172a",
    "950": "#020617",
    DEFAULT: "#94a3b8"
  },
  zinc: {
    "1": "#f4f4f5",
    "2": "#e4e4e7",
    "3": "#d4d4d8",
    "4": "#a1a1aa",
    "5": "#71717a",
    "6": "#52525b",
    "7": "#3f3f46",
    "8": "#27272a",
    "9": "#18181b",
    "50": "#fafafa",
    "100": "#f4f4f5",
    "200": "#e4e4e7",
    "300": "#d4d4d8",
    "400": "#a1a1aa",
    "500": "#71717a",
    "600": "#52525b",
    "700": "#3f3f46",
    "800": "#27272a",
    "900": "#18181b",
    "950": "#09090b",
    DEFAULT: "#a1a1aa"
  },
  neutral: {
    "1": "#f5f5f5",
    "2": "#e5e5e5",
    "3": "#d4d4d4",
    "4": "#a3a3a3",
    "5": "#737373",
    "6": "#525252",
    "7": "#404040",
    "8": "#262626",
    "9": "#171717",
    "50": "#fafafa",
    "100": "#f5f5f5",
    "200": "#e5e5e5",
    "300": "#d4d4d4",
    "400": "#a3a3a3",
    "500": "#737373",
    "600": "#525252",
    "700": "#404040",
    "800": "#262626",
    "900": "#171717",
    "950": "#0a0a0a",
    DEFAULT: "#a3a3a3"
  },
  stone: {
    "1": "#f5f5f4",
    "2": "#e7e5e4",
    "3": "#d6d3d1",
    "4": "#a8a29e",
    "5": "#78716c",
    "6": "#57534e",
    "7": "#44403c",
    "8": "#292524",
    "9": "#1c1917",
    "50": "#fafaf9",
    "100": "#f5f5f4",
    "200": "#e7e5e4",
    "300": "#d6d3d1",
    "400": "#a8a29e",
    "500": "#78716c",
    "600": "#57534e",
    "700": "#44403c",
    "800": "#292524",
    "900": "#1c1917",
    "950": "#0c0a09",
    DEFAULT: "#a8a29e"
  },
  light: {
    "1": "#fcfcfc",
    "2": "#fafafa",
    "3": "#f8f9fa",
    "4": "#f6f6f6",
    "5": "#f2f2f2",
    "6": "#f1f3f5",
    "7": "#e9ecef",
    "8": "#dee2e6",
    "9": "#dde1e3",
    "50": "#fdfdfd",
    "100": "#fcfcfc",
    "200": "#fafafa",
    "300": "#f8f9fa",
    "400": "#f6f6f6",
    "500": "#f2f2f2",
    "600": "#f1f3f5",
    "700": "#e9ecef",
    "800": "#dee2e6",
    "900": "#dde1e3",
    "950": "#d8dcdf",
    DEFAULT: "#f6f6f6"
  },
  dark: {
    "1": "#3c3c3c",
    "2": "#323232",
    "3": "#2d2d2d",
    "4": "#222222",
    "5": "#1f1f1f",
    "6": "#1c1c1e",
    "7": "#1b1b1b",
    "8": "#181818",
    "9": "#0f0f0f",
    "50": "#4a4a4a",
    "100": "#3c3c3c",
    "200": "#323232",
    "300": "#2d2d2d",
    "400": "#222222",
    "500": "#1f1f1f",
    "600": "#1c1c1e",
    "700": "#1b1b1b",
    "800": "#181818",
    "900": "#0f0f0f",
    "950": "#080808",
    DEFAULT: "#222222"
  },
  lightblue: {
    "1": "#e0f2fe",
    "2": "#bae6fd",
    "3": "#7dd3fc",
    "4": "#38bdf8",
    "5": "#0ea5e9",
    "6": "#0284c7",
    "7": "#0369a1",
    "8": "#075985",
    "9": "#0c4a6e",
    "50": "#f0f9ff",
    "100": "#e0f2fe",
    "200": "#bae6fd",
    "300": "#7dd3fc",
    "400": "#38bdf8",
    "500": "#0ea5e9",
    "600": "#0284c7",
    "700": "#0369a1",
    "800": "#075985",
    "900": "#0c4a6e",
    "950": "#082f49",
    DEFAULT: "#38bdf8"
  },
  lightBlue: {
    "1": "#e0f2fe",
    "2": "#bae6fd",
    "3": "#7dd3fc",
    "4": "#38bdf8",
    "5": "#0ea5e9",
    "6": "#0284c7",
    "7": "#0369a1",
    "8": "#075985",
    "9": "#0c4a6e",
    "50": "#f0f9ff",
    "100": "#e0f2fe",
    "200": "#bae6fd",
    "300": "#7dd3fc",
    "400": "#38bdf8",
    "500": "#0ea5e9",
    "600": "#0284c7",
    "700": "#0369a1",
    "800": "#075985",
    "900": "#0c4a6e",
    "950": "#082f49",
    DEFAULT: "#38bdf8"
  },
  warmgray: {
    "1": "#f5f5f4",
    "2": "#e7e5e4",
    "3": "#d6d3d1",
    "4": "#a8a29e",
    "5": "#78716c",
    "6": "#57534e",
    "7": "#44403c",
    "8": "#292524",
    "9": "#1c1917",
    "50": "#fafaf9",
    "100": "#f5f5f4",
    "200": "#e7e5e4",
    "300": "#d6d3d1",
    "400": "#a8a29e",
    "500": "#78716c",
    "600": "#57534e",
    "700": "#44403c",
    "800": "#292524",
    "900": "#1c1917",
    "950": "#0c0a09",
    DEFAULT: "#a8a29e"
  },
  warmGray: {
    "1": "#f5f5f4",
    "2": "#e7e5e4",
    "3": "#d6d3d1",
    "4": "#a8a29e",
    "5": "#78716c",
    "6": "#57534e",
    "7": "#44403c",
    "8": "#292524",
    "9": "#1c1917",
    "50": "#fafaf9",
    "100": "#f5f5f4",
    "200": "#e7e5e4",
    "300": "#d6d3d1",
    "400": "#a8a29e",
    "500": "#78716c",
    "600": "#57534e",
    "700": "#44403c",
    "800": "#292524",
    "900": "#1c1917",
    "950": "#0c0a09",
    DEFAULT: "#a8a29e"
  },
  truegray: {
    "1": "#f5f5f5",
    "2": "#e5e5e5",
    "3": "#d4d4d4",
    "4": "#a3a3a3",
    "5": "#737373",
    "6": "#525252",
    "7": "#404040",
    "8": "#262626",
    "9": "#171717",
    "50": "#fafafa",
    "100": "#f5f5f5",
    "200": "#e5e5e5",
    "300": "#d4d4d4",
    "400": "#a3a3a3",
    "500": "#737373",
    "600": "#525252",
    "700": "#404040",
    "800": "#262626",
    "900": "#171717",
    "950": "#0a0a0a",
    DEFAULT: "#a3a3a3"
  },
  trueGray: {
    "1": "#f5f5f5",
    "2": "#e5e5e5",
    "3": "#d4d4d4",
    "4": "#a3a3a3",
    "5": "#737373",
    "6": "#525252",
    "7": "#404040",
    "8": "#262626",
    "9": "#171717",
    "50": "#fafafa",
    "100": "#f5f5f5",
    "200": "#e5e5e5",
    "300": "#d4d4d4",
    "400": "#a3a3a3",
    "500": "#737373",
    "600": "#525252",
    "700": "#404040",
    "800": "#262626",
    "900": "#171717",
    "950": "#0a0a0a",
    DEFAULT: "#a3a3a3"
  },
  coolgray: {
    "1": "#f3f4f6",
    "2": "#e5e7eb",
    "3": "#d1d5db",
    "4": "#9ca3af",
    "5": "#6b7280",
    "6": "#4b5563",
    "7": "#374151",
    "8": "#1f2937",
    "9": "#111827",
    "50": "#f9fafb",
    "100": "#f3f4f6",
    "200": "#e5e7eb",
    "300": "#d1d5db",
    "400": "#9ca3af",
    "500": "#6b7280",
    "600": "#4b5563",
    "700": "#374151",
    "800": "#1f2937",
    "900": "#111827",
    "950": "#030712",
    DEFAULT: "#9ca3af"
  },
  coolGray: {
    "1": "#f3f4f6",
    "2": "#e5e7eb",
    "3": "#d1d5db",
    "4": "#9ca3af",
    "5": "#6b7280",
    "6": "#4b5563",
    "7": "#374151",
    "8": "#1f2937",
    "9": "#111827",
    "50": "#f9fafb",
    "100": "#f3f4f6",
    "200": "#e5e7eb",
    "300": "#d1d5db",
    "400": "#9ca3af",
    "500": "#6b7280",
    "600": "#4b5563",
    "700": "#374151",
    "800": "#1f2937",
    "900": "#111827",
    "950": "#030712",
    DEFAULT: "#9ca3af"
  },
  bluegray: {
    "1": "#f1f5f9",
    "2": "#e2e8f0",
    "3": "#cbd5e1",
    "4": "#94a3b8",
    "5": "#64748b",
    "6": "#475569",
    "7": "#334155",
    "8": "#1e293b",
    "9": "#0f172a",
    "50": "#f8fafc",
    "100": "#f1f5f9",
    "200": "#e2e8f0",
    "300": "#cbd5e1",
    "400": "#94a3b8",
    "500": "#64748b",
    "600": "#475569",
    "700": "#334155",
    "800": "#1e293b",
    "900": "#0f172a",
    "950": "#020617",
    DEFAULT: "#94a3b8"
  },
  blueGray: {
    "1": "#f1f5f9",
    "2": "#e2e8f0",
    "3": "#cbd5e1",
    "4": "#94a3b8",
    "5": "#64748b",
    "6": "#475569",
    "7": "#334155",
    "8": "#1e293b",
    "9": "#0f172a",
    "50": "#f8fafc",
    "100": "#f1f5f9",
    "200": "#e2e8f0",
    "300": "#cbd5e1",
    "400": "#94a3b8",
    "500": "#64748b",
    "600": "#475569",
    "700": "#334155",
    "800": "#1e293b",
    "900": "#0f172a",
    "950": "#020617",
    DEFAULT: "#94a3b8"
  }
};
export const fontFamily = {
  sans: "ui-sans-serif,system-ui,-apple-system,BlinkMacSystemFont,\"Segoe UI\",Roboto,\"Helvetica Neue\",Arial,\"Noto Sans\",sans-serif,\"Apple Color Emoji\",\"Segoe UI Emoji\",\"Segoe UI Symbol\",\"Noto Color Emoji\"",
  serif: "ui-serif,Georgia,Cambria,\"Times New Roman\",Times,serif",
  mono: "ui-monospace,SFMono-Regular,Menlo,Monaco,Consolas,\"Liberation Mono\",\"Courier New\",monospace"
};
export const fontSize = {
  xs: [
    "0.75rem",
    "1rem"
  ],
  sm: [
    "0.875rem",
    "1.25rem"
  ],
  base: [
    "1rem",
    "1.5rem"
  ],
  lg: [
    "1.125rem",
    "1.75rem"
  ],
  xl: [
    "1.25rem",
    "1.75rem"
  ],
  "2xl": [
    "1.5rem",
    "2rem"
  ],
  "3xl": [
    "1.875rem",
    "2.25rem"
  ],
  "4xl": [
    "2.25rem",
    "2.5rem"
  ],
  "5xl": [
    "3rem",
    "1"
  ],
  "6xl": [
    "3.75rem",
    "1"
  ],
  "7xl": [
    "4.5rem",
    "1"
  ],
  "8xl": [
    "6rem",
    "1"
  ],
  "9xl": [
    "8rem",
    "1"
  ]
};
export const fontWeight = {
  thin: "100",
  extralight: "200",
  light: "300",
  normal: "400",
  medium: "500",
  semibold: "600",
  bold: "700",
  extrabold: "800",
  black: "900"
};
export const breakpoints = {
  sm: "640px",
  md: "768px",
  lg: "1024px",
  xl: "1280px",
  "2xl": "1536px"
};
export const verticalBreakpoints = {
  sm: "640px",
  md: "768px",
  lg: "1024px",
  xl: "1280px",
  "2xl": "1536px"
};
export const borderRadius = {
  DEFAULT: "0.25rem",
  none: "0",
  sm: "0.125rem",
  md: "0.375rem",
  lg: "0.5rem",
  xl: "0.75rem",
  "2xl": "1rem",
  "3xl": "1.5rem",
  full: "9999px"
};
export const lineHeight = {
  none: "1",
  tight: "1.25",
  snug: "1.375",
  normal: "1.5",
  relaxed: "1.625",
  loose: "2"
};
export const letterSpacing = {
  tighter: "-0.05em",
  tight: "-0.025em",
  normal: "0em",
  wide: "0.025em",
  wider: "0.05em",
  widest: "0.1em"
};
export const wordSpacing = {
  tighter: "-0.05em",
  tight: "-0.025em",
  normal: "0em",
  wide: "0.025em",
  wider: "0.05em",
  widest: "0.1em"
};
export const boxShadow = {
  DEFAULT: [
    "var(--un-shadow-inset) 0 1px 3px 0 rgb(0 0 0 / 0.1)",
    "var(--un-shadow-inset) 0 1px 2px -1px rgb(0 0 0 / 0.1)"
  ],
  none: "0 0 rgb(0 0 0 / 0)",
  sm: "var(--un-shadow-inset) 0 1px 2px 0 rgb(0 0 0 / 0.05)",
  md: [
    "var(--un-shadow-inset) 0 4px 6px -1px rgb(0 0 0 / 0.1)",
    "var(--un-shadow-inset) 0 2px 4px -2px rgb(0 0 0 / 0.1)"
  ],
  lg: [
    "var(--un-shadow-inset) 0 10px 15px -3px rgb(0 0 0 / 0.1)",
    "var(--un-shadow-inset) 0 4px 6px -4px rgb(0 0 0 / 0.1)"
  ],
  xl: [
    "var(--un-shadow-inset) 0 20px 25px -5px rgb(0 0 0 / 0.1)",
    "var(--un-shadow-inset) 0 8px 10px -6px rgb(0 0 0 / 0.1)"
  ],
  "2xl": "var(--un-shadow-inset) 0 25px 50px -12px rgb(0 0 0 / 0.25)",
  inner: "inset 0 2px 4px 0 rgb(0 0 0 / 0.05)"
};
export const textIndent = {
  DEFAULT: "1.5rem",
  xs: "0.5rem",
  sm: "1rem",
  md: "1.5rem",
  lg: "2rem",
  xl: "2.5rem",
  "2xl": "3rem",
  "3xl": "4rem"
};
export const textShadow = {
  DEFAULT: [
    "0 0 1px rgb(0 0 0 / 0.2)",
    "0 0 1px rgb(1 0 5 / 0.1)"
  ],
  none: "0 0 rgb(0 0 0 / 0)",
  sm: "1px 1px 3px rgb(36 37 47 / 0.25)",
  md: [
    "0 1px 2px rgb(30 29 39 / 0.19)",
    "1px 2px 4px rgb(54 64 147 / 0.18)"
  ],
  lg: [
    "3px 3px 6px rgb(0 0 0 / 0.26)",
    "0 0 5px rgb(15 3 86 / 0.22)"
  ],
  xl: [
    "1px 1px 3px rgb(0 0 0 / 0.29)",
    "2px 4px 7px rgb(73 64 125 / 0.35)"
  ]
};
export const textStrokeWidth = {
  DEFAULT: "1.5rem",
  none: "0",
  sm: "thin",
  md: "medium",
  lg: "thick"
};
export const blur = {
  "0": "0",
  DEFAULT: "8px",
  sm: "4px",
  md: "12px",
  lg: "16px",
  xl: "24px",
  "2xl": "40px",
  "3xl": "64px"
};
export const dropShadow = {
  DEFAULT: [
    "0 1px 2px rgb(0 0 0 / 0.1)",
    "0 1px 1px rgb(0 0 0 / 0.06)"
  ],
  sm: "0 1px 1px rgb(0 0 0 / 0.05)",
  md: [
    "0 4px 3px rgb(0 0 0 / 0.07)",
    "0 2px 2px rgb(0 0 0 / 0.06)"
  ],
  lg: [
    "0 10px 8px rgb(0 0 0 / 0.04)",
    "0 4px 3px rgb(0 0 0 / 0.1)"
  ],
  xl: [
    "0 20px 13px rgb(0 0 0 / 0.03)",
    "0 8px 5px rgb(0 0 0 / 0.08)"
  ],
  "2xl": "0 25px 25px rgb(0 0 0 / 0.15)",
  none: "0 0 rgb(0 0 0 / 0)"
};
export const easing = {
  DEFAULT: "cubic-bezier(0.4, 0, 0.2, 1)",
  linear: "linear",
  "in": "cubic-bezier(0.4, 0, 1, 1)",
  out: "cubic-bezier(0, 0, 0.2, 1)",
  "in-out": "cubic-bezier(0.4, 0, 0.2, 1)"
};
export const transitionProperty = {
  none: "none",
  all: "all",
  colors: "color,background-color,border-color,text-decoration-color,fill,stroke",
  opacity: "opacity",
  shadow: "box-shadow",
  transform: "transform",
  DEFAULT: "color,background-color,border-color,text-decoration-color,fill,stroke,opacity,box-shadow,transform,filter,backdrop-filter"
};
export const lineWidth = {
  DEFAULT: "1px",
  none: "0"
};
export const spacing = {
  DEFAULT: "1rem",
  none: "0",
  xs: "0.75rem",
  sm: "0.875rem",
  lg: "1.125rem",
  xl: "1.25rem",
  "2xl": "1.5rem",
  "3xl": "1.875rem",
  "4xl": "2.25rem",
  "5xl": "3rem",
  "6xl": "3.75rem",
  "7xl": "4.5rem",
  "8xl": "6rem",
  "9xl": "8rem"
};
export const duration = {
  "75": "75ms",
  "100": "100ms",
  "150": "150ms",
  "200": "200ms",
  "300": "300ms",
  "500": "500ms",
  "700": "700ms",
  "1000": "1000ms",
  DEFAULT: "150ms",
  none: "0s"
};
export const ringWidth = {
  DEFAULT: "3px",
  none: "0"
};
export const preflightBase = {
  "--un-rotate": 0,
  "--un-rotate-x": 0,
  "--un-rotate-y": 0,
  "--un-rotate-z": 0,
  "--un-scale-x": 1,
  "--un-scale-y": 1,
  "--un-scale-z": 1,
  "--un-skew-x": 0,
  "--un-skew-y": 0,
  "--un-translate-x": 0,
  "--un-translate-y": 0,
  "--un-translate-z": 0,
  "--un-pan-x": " ",
  "--un-pan-y": " ",
  "--un-pinch-zoom": " ",
  "--un-scroll-snap-strictness": "proximity",
  "--un-ordinal": " ",
  "--un-slashed-zero": " ",
  "--un-numeric-figure": " ",
  "--un-numeric-spacing": " ",
  "--un-numeric-fraction": " ",
  "--un-border-spacing-x": 0,
  "--un-border-spacing-y": 0,
  "--un-ring-offset-shadow": "0 0 rgb(0 0 0 / 0)",
  "--un-ring-shadow": "0 0 rgb(0 0 0 / 0)",
  "--un-shadow-inset": " ",
  "--un-shadow": "0 0 rgb(0 0 0 / 0)",
  "--un-ring-inset": " ",
  "--un-ring-offset-width": "0px",
  "--un-ring-offset-color": "#fff",
  "--un-ring-width": "0px",
  "--un-ring-color": "rgb(147 197 253 / 0.5)",
  "--un-blur": " ",
  "--un-brightness": " ",
  "--un-contrast": " ",
  "--un-drop-shadow": " ",
  "--un-grayscale": " ",
  "--un-hue-rotate": " ",
  "--un-invert": " ",
  "--un-saturate": " ",
  "--un-sepia": " ",
  "--un-backdrop-blur": " ",
  "--un-backdrop-brightness": " ",
  "--un-backdrop-contrast": " ",
  "--un-backdrop-grayscale": " ",
  "--un-backdrop-hue-rotate": " ",
  "--un-backdrop-invert": " ",
  "--un-backdrop-opacity": " ",
  "--un-backdrop-saturate": " ",
  "--un-backdrop-sepia": " "
};
export const containers = {
  xs: "20rem",
  sm: "24rem",
  md: "28rem",
  lg: "32rem",
  xl: "36rem",
  "2xl": "42rem",
  "3xl": "48rem",
  "4xl": "56rem",
  "5xl": "64rem",
  "6xl": "72rem",
  "7xl": "80rem",
  prose: "65ch"
};
export const zIndex = {
  auto: "auto"
};
export const media = {
  portrait: "(orientation: portrait)",
  landscape: "(orientation: landscape)",
  os_dark: "(prefers-color-scheme: dark)",
  os_light: "(prefers-color-scheme: light)",
  motion_ok: "(prefers-reduced-motion: no-preference)",
  motion_not_ok: "(prefers-reduced-motion: reduce)",
  high_contrast: "(prefers-contrast: high)",
  low_contrast: "(prefers-contrast: low)",
  opacity_ok: "(prefers-reduced-transparency: no-preference)",
  opacity_not_ok: "(prefers-reduced-transparency: reduce)",
  use_data_ok: "(prefers-reduced-data: no-preference)",
  use_data_not_ok: "(prefers-reduced-data: reduce)",
  touch: "(hover: none) and (pointer: coarse)",
  stylus: "(hover: none) and (pointer: fine)",
  pointer: "(hover) and (pointer: coarse)",
  mouse: "(hover) and (pointer: fine)",
  hd_color: "(dynamic-range: high)"
};
export const aria = {
  busy: "busy=\"true\"",
  checked: "checked=\"true\"",
  disabled: "disabled=\"true\"",
  expanded: "expanded=\"true\"",
  hidden: "hidden=\"true\"",
  pressed: "pressed=\"true\"",
  readonly: "readonly=\"true\"",
  required: "required=\"true\"",
  selected: "selected=\"true\""
};
export const animation = {
  keyframes: {
    pulse: "{0%, 100% {opacity:1} 50% {opacity:.5}}",
    bounce: "{0%, 100% {transform:translateY(-25%);animation-timing-function:cubic-bezier(0.8,0,1,1)} 50% {transform:translateY(0);animation-timing-function:cubic-bezier(0,0,0.2,1)}}",
    spin: "{from{transform:rotate(0deg)}to{transform:rotate(360deg)}}",
    ping: "{0%{transform:scale(1);opacity:1}75%,100%{transform:scale(2);opacity:0}}",
    "bounce-alt": "{from,20%,53%,80%,to{animation-timing-function:cubic-bezier(0.215,0.61,0.355,1);transform:translate3d(0,0,0)}40%,43%{animation-timing-function:cubic-bezier(0.755,0.05,0.855,0.06);transform:translate3d(0,-30px,0)}70%{animation-timing-function:cubic-bezier(0.755,0.05,0.855,0.06);transform:translate3d(0,-15px,0)}90%{transform:translate3d(0,-4px,0)}}",
    flash: "{from,50%,to{opacity:1}25%,75%{opacity:0}}",
    "pulse-alt": "{from{transform:scale3d(1,1,1)}50%{transform:scale3d(1.05,1.05,1.05)}to{transform:scale3d(1,1,1)}}",
    "rubber-band": "{from{transform:scale3d(1,1,1)}30%{transform:scale3d(1.25,0.75,1)}40%{transform:scale3d(0.75,1.25,1)}50%{transform:scale3d(1.15,0.85,1)}65%{transform:scale3d(0.95,1.05,1)}75%{transform:scale3d(1.05,0.95,1)}to{transform:scale3d(1,1,1)}}",
    "shake-x": "{from,to{transform:translate3d(0,0,0)}10%,30%,50%,70%,90%{transform:translate3d(-10px,0,0)}20%,40%,60%,80%{transform:translate3d(10px,0,0)}}",
    "shake-y": "{from,to{transform:translate3d(0,0,0)}10%,30%,50%,70%,90%{transform:translate3d(0,-10px,0)}20%,40%,60%,80%{transform:translate3d(0,10px,0)}}",
    "head-shake": "{0%{transform:translateX(0)}6.5%{transform:translateX(-6px) rotateY(-9deg)}18.5%{transform:translateX(5px) rotateY(7deg)}31.5%{transform:translateX(-3px) rotateY(-5deg)}43.5%{transform:translateX(2px) rotateY(3deg)}50%{transform:translateX(0)}}",
    swing: "{20%{transform:rotate3d(0,0,1,15deg)}40%{transform:rotate3d(0,0,1,-10deg)}60%{transform:rotate3d(0,0,1,5deg)}80%{transform:rotate3d(0,0,1,-5deg)}to{transform:rotate3d(0,0,1,0deg)}}",
    tada: "{from{transform:scale3d(1,1,1)}10%,20%{transform:scale3d(0.9,0.9,0.9) rotate3d(0,0,1,-3deg)}30%,50%,70%,90%{transform:scale3d(1.1,1.1,1.1) rotate3d(0,0,1,3deg)}40%,60%,80%{transform:scale3d(1.1,1.1,1.1) rotate3d(0,0,1,-3deg)}to{transform:scale3d(1,1,1)}}",
    wobble: "{from{transform:translate3d(0,0,0)}15%{transform:translate3d(-25%,0,0) rotate3d(0,0,1,-5deg)}30%{transform:translate3d(20%,0,0) rotate3d(0,0,1,3deg)}45%{transform:translate3d(-15%,0,0) rotate3d(0,0,1,-3deg)}60%{transform:translate3d(10%,0,0) rotate3d(0,0,1,2deg)}75%{transform:translate3d(-5%,0,0) rotate3d(0,0,1,-1deg)}to{transform:translate3d(0,0,0)}}",
    jello: "{from,11.1%,to{transform:translate3d(0,0,0)}22.2%{transform:skewX(-12.5deg) skewY(-12.5deg)}33.3%{transform:skewX(6.25deg) skewY(6.25deg)}44.4%{transform:skewX(-3.125deg)skewY(-3.125deg)}55.5%{transform:skewX(1.5625deg) skewY(1.5625deg)}66.6%{transform:skewX(-0.78125deg) skewY(-0.78125deg)}77.7%{transform:skewX(0.390625deg) skewY(0.390625deg)}88.8%{transform:skewX(-0.1953125deg) skewY(-0.1953125deg)}}",
    "heart-beat": "{0%{transform:scale(1)}14%{transform:scale(1.3)}28%{transform:scale(1)}42%{transform:scale(1.3)}70%{transform:scale(1)}}",
    hinge: "{0%{transform-origin:top left;animation-timing-function:ease-in-out}20%,60%{transform:rotate3d(0,0,1,80deg);transform-origin:top left;animation-timing-function:ease-in-out}40%,80%{transform:rotate3d(0,0,1,60deg);transform-origin:top left;animation-timing-function:ease-in-out}to{transform:translate3d(0,700px,0);opacity:0}}",
    "jack-in-the-box": "{from{opacity:0;transform-origin:center bottom;transform:scale(0.1) rotate(30deg)}50%{transform:rotate(-10deg)}70%{transform:rotate(3deg)}to{transform:scale(1)}}",
    "light-speed-in-left": "{from{opacity:0;transform:translate3d(-100%,0,0) skewX(-30deg)}60%{opacity:1;transform:skewX(20deg)}80%{transform:skewX(-5deg)}to{transform:translate3d(0,0,0)}}",
    "light-speed-in-right": "{from{opacity:0;transform:translate3d(100%,0,0) skewX(-30deg)}60%{opacity:1;transform:skewX(20deg)}80%{transform:skewX(-5deg)}to{transform:translate3d(0,0,0)}}",
    "light-speed-out-left": "{from{opacity:1}to{opacity:0;transform:translate3d(-100%,0,0) skewX(30deg)}}",
    "light-speed-out-right": "{from{opacity:1}to{opacity:0;transform:translate3d(100%,0,0) skewX(30deg)}}",
    flip: "{from{transform:perspective(400px) scale3d(1,1,1) translate3d(0,0,0) rotate3d(0,1,0,-360deg);animation-timing-function:ease-out}40%{transform:perspective(400px) scale3d(1,1,1) translate3d(0,0,150px) rotate3d(0,1,0,-190deg);animation-timing-function:ease-out}50%{transform:perspective(400px) scale3d(1,1,1) translate3d(0,0,150px) rotate3d(0,1,0,-170deg);animation-timing-function:ease-in}80%{transform:perspective(400px) scale3d(0.95,0.95,0.95) translate3d(0,0,0) rotate3d(0,1,0,0deg);animation-timing-function:ease-in}to{transform:perspective(400px) scale3d(1,1,1) translate3d(0,0,0) rotate3d(0,1,0,0deg);animation-timing-function:ease-in}}",
    "flip-in-x": "{from{transform:perspective(400px) rotate3d(1,0,0,90deg);animation-timing-function:ease-in;opacity:0}40%{transform:perspective(400px) rotate3d(1,0,0,-20deg);animation-timing-function:ease-in}60%{transform:perspective(400px) rotate3d(1,0,0,10deg);opacity:1}80%{transform:perspective(400px) rotate3d(1,0,0,-5deg)}to{transform:perspective(400px)}}",
    "flip-in-y": "{from{transform:perspective(400px) rotate3d(0,1,0,90deg);animation-timing-function:ease-in;opacity:0}40%{transform:perspective(400px) rotate3d(0,1,0,-20deg);animation-timing-function:ease-in}60%{transform:perspective(400px) rotate3d(0,1,0,10deg);opacity:1}80%{transform:perspective(400px) rotate3d(0,1,0,-5deg)}to{transform:perspective(400px)}}",
    "flip-out-x": "{from{transform:perspective(400px)}30%{transform:perspective(400px) rotate3d(1,0,0,-20deg);opacity:1}to{transform:perspective(400px) rotate3d(1,0,0,90deg);opacity:0}}",
    "flip-out-y": "{from{transform:perspective(400px)}30%{transform:perspective(400px) rotate3d(0,1,0,-15deg);opacity:1}to{transform:perspective(400px) rotate3d(0,1,0,90deg);opacity:0}}",
    "rotate-in": "{from{transform-origin:center;transform:rotate3d(0,0,1,-200deg);opacity:0}to{transform-origin:center;transform:translate3d(0,0,0);opacity:1}}",
    "rotate-in-down-left": "{from{transform-origin:left bottom;transform:rotate3d(0,0,1,-45deg);opacity:0}to{transform-origin:left bottom;transform:translate3d(0,0,0);opacity:1}}",
    "rotate-in-down-right": "{from{transform-origin:right bottom;transform:rotate3d(0,0,1,45deg);opacity:0}to{transform-origin:right bottom;transform:translate3d(0,0,0);opacity:1}}",
    "rotate-in-up-left": "{from{transform-origin:left top;transform:rotate3d(0,0,1,45deg);opacity:0}to{transform-origin:left top;transform:translate3d(0,0,0);opacity:1}}",
    "rotate-in-up-right": "{from{transform-origin:right bottom;transform:rotate3d(0,0,1,-90deg);opacity:0}to{transform-origin:right bottom;transform:translate3d(0,0,0);opacity:1}}",
    "rotate-out": "{from{transform-origin:center;opacity:1}to{transform-origin:center;transform:rotate3d(0,0,1,200deg);opacity:0}}",
    "rotate-out-down-left": "{from{transform-origin:left bottom;opacity:1}to{transform-origin:left bottom;transform:rotate3d(0,0,1,45deg);opacity:0}}",
    "rotate-out-down-right": "{from{transform-origin:right bottom;opacity:1}to{transform-origin:right bottom;transform:rotate3d(0,0,1,-45deg);opacity:0}}",
    "rotate-out-up-left": "{from{transform-origin:left bottom;opacity:1}to{transform-origin:left bottom;transform:rotate3d(0,0,1,-45deg);opacity:0}}",
    "rotate-out-up-right": "{from{transform-origin:right bottom;opacity:1}to{transform-origin:left bottom;transform:rotate3d(0,0,1,90deg);opacity:0}}",
    "roll-in": "{from{opacity:0;transform:translate3d(-100%,0,0) rotate3d(0,0,1,-120deg)}to{opacity:1;transform:translate3d(0,0,0)}}",
    "roll-out": "{from{opacity:1}to{opacity:0;transform:translate3d(100%,0,0) rotate3d(0,0,1,120deg)}}",
    "zoom-in": "{from{opacity:0;transform:scale3d(0.3,0.3,0.3)}50%{opacity:1}}",
    "zoom-in-down": "{from{opacity:0;transform:scale3d(0.1,0.1,0.1) translate3d(0,-1000px,0);animation-timing-function:cubic-bezier(0.55,0.055,0.675,0.19)}60%{opacity:1;transform:scale3d(0.475,0.475,0.475) translate3d(0,60px,0);animation-timing-function:cubic-bezier(0.175,0.885,0.32,1)}}",
    "zoom-in-left": "{from{opacity:0;transform:scale3d(0.1,0.1,0.1) translate3d(-1000px,0,0);animation-timing-function:cubic-bezier(0.55,0.055,0.675,0.19)}60%{opacity:1;transform:scale3d(0.475,0.475,0.475) translate3d(10px,0,0);animation-timing-function:cubic-bezier(0.175,0.885,0.32,1)}}",
    "zoom-in-right": "{from{opacity:0;transform:scale3d(0.1,0.1,0.1) translate3d(1000px,0,0);animation-timing-function:cubic-bezier(0.55,0.055,0.675,0.19)}60%{opacity:1;transform:scale3d(0.475,0.475,0.475) translate3d(-10px,0,0);animation-timing-function:cubic-bezier(0.175,0.885,0.32,1)}}",
    "zoom-in-up": "{from{opacity:0;transform:scale3d(0.1,0.1,0.1) translate3d(0,1000px,0);animation-timing-function:cubic-bezier(0.55,0.055,0.675,0.19)}60%{opacity:1;transform:scale3d(0.475,0.475,0.475) translate3d(0,-60px,0);animation-timing-function:cubic-bezier(0.175,0.885,0.32,1)}}",
    "zoom-out": "{from{opacity:1}50%{opacity:0;transform:scale3d(0.3,0.3,0.3)}to{opacity:0}}",
    "zoom-out-down": "{40%{opacity:1;transform:scale3d(0.475,0.475,0.475) translate3d(0,-60px,0);animation-timing-function:cubic-bezier(0.55,0.055,0.675,0.19)}to{opacity:0;transform:scale3d(0.1,0.1,0.1) translate3d(0,2000px,0);transform-origin:center bottom;animation-timing-function:cubic-bezier(0.175,0.885,0.32,1)}}",
    "zoom-out-left": "{40%{opacity:1;transform:scale3d(0.475,0.475,0.475) translate3d(42px,0,0)}to{opacity:0;transform:scale(0.1) translate3d(-2000px,0,0);transform-origin:left center}}",
    "zoom-out-right": "{40%{opacity:1;transform:scale3d(0.475,0.475,0.475) translate3d(-42px,0,0)}to{opacity:0;transform:scale(0.1) translate3d(2000px,0,0);transform-origin:right center}}",
    "zoom-out-up": "{40%{opacity:1;transform:scale3d(0.475,0.475,0.475) translate3d(0,60px,0);animation-timing-function:cubic-bezier(0.55,0.055,0.675,0.19)}to{opacity:0;transform:scale3d(0.1,0.1,0.1) translate3d(0,-2000px,0);transform-origin:center bottom;animation-timing-function:cubic-bezier(0.175,0.885,0.32,1)}}",
    "bounce-in": "{from,20%,40%,60%,80%,to{animation-timing-function:ease-in-out}0%{opacity:0;transform:scale3d(0.3,0.3,0.3)}20%{transform:scale3d(1.1,1.1,1.1)}40%{transform:scale3d(0.9,0.9,0.9)}60%{transform:scale3d(1.03,1.03,1.03);opacity:1}80%{transform:scale3d(0.97,0.97,0.97)}to{opacity:1;transform:scale3d(1,1,1)}}",
    "bounce-in-down": "{from,60%,75%,90%,to{animation-timing-function:cubic-bezier(0.215,0.61,0.355,1)}0%{opacity:0;transform:translate3d(0,-3000px,0)}60%{opacity:1;transform:translate3d(0,25px,0)}75%{transform:translate3d(0,-10px,0)}90%{transform:translate3d(0,5px,0)}to{transform:translate3d(0,0,0)}}",
    "bounce-in-left": "{from,60%,75%,90%,to{animation-timing-function:cubic-bezier(0.215,0.61,0.355,1)}0%{opacity:0;transform:translate3d(-3000px,0,0)}60%{opacity:1;transform:translate3d(25px,0,0)}75%{transform:translate3d(-10px,0,0)}90%{transform:translate3d(5px,0,0)}to{transform:translate3d(0,0,0)}}",
    "bounce-in-right": "{from,60%,75%,90%,to{animation-timing-function:cubic-bezier(0.215,0.61,0.355,1)}0%{opacity:0;transform:translate3d(3000px,0,0)}60%{opacity:1;transform:translate3d(-25px,0,0)}75%{transform:translate3d(10px,0,0)}90%{transform:translate3d(-5px,0,0)}to{transform:translate3d(0,0,0)}}",
    "bounce-in-up": "{from,60%,75%,90%,to{animation-timing-function:cubic-bezier(0.215,0.61,0.355,1)}0%{opacity:0;transform:translate3d(0,3000px,0)}60%{opacity:1;transform:translate3d(0,-20px,0)}75%{transform:translate3d(0,10px,0)}90%{transform:translate3d(0,-5px,0)}to{transform:translate3d(0,0,0)}}",
    "bounce-out": "{20%{transform:scale3d(0.9,0.9,0.9)}50%,55%{opacity:1;transform:scale3d(1.1,1.1,1.1)}to{opacity:0;transform:scale3d(0.3,0.3,0.3)}}",
    "bounce-out-down": "{20%{transform:translate3d(0,10px,0)}40%,45%{opacity:1;transform:translate3d(0,-20px,0)}to{opacity:0;transform:translate3d(0,2000px,0)}}",
    "bounce-out-left": "{20%{opacity:1;transform:translate3d(20px,0,0)}to{opacity:0;transform:translate3d(-2000px,0,0)}}",
    "bounce-out-right": "{20%{opacity:1;transform:translate3d(-20px,0,0)}to{opacity:0;transform:translate3d(2000px,0,0)}}",
    "bounce-out-up": "{20%{transform:translate3d(0,-10px,0)}40%,45%{opacity:1;transform:translate3d(0,20px,0)}to{opacity:0;transform:translate3d(0,-2000px,0)}}",
    "slide-in-down": "{from{transform:translate3d(0,-100%,0);visibility:visible}to{transform:translate3d(0,0,0)}}",
    "slide-in-left": "{from{transform:translate3d(-100%,0,0);visibility:visible}to{transform:translate3d(0,0,0)}}",
    "slide-in-right": "{from{transform:translate3d(100%,0,0);visibility:visible}to{transform:translate3d(0,0,0)}}",
    "slide-in-up": "{from{transform:translate3d(0,100%,0);visibility:visible}to{transform:translate3d(0,0,0)}}",
    "slide-out-down": "{from{transform:translate3d(0,0,0)}to{visibility:hidden;transform:translate3d(0,100%,0)}}",
    "slide-out-left": "{from{transform:translate3d(0,0,0)}to{visibility:hidden;transform:translate3d(-100%,0,0)}}",
    "slide-out-right": "{from{transform:translate3d(0,0,0)}to{visibility:hidden;transform:translate3d(100%,0,0)}}",
    "slide-out-up": "{from{transform:translate3d(0,0,0)}to{visibility:hidden;transform:translate3d(0,-100%,0)}}",
    "fade-in": "{from{opacity:0}to{opacity:1}}",
    "fade-in-down": "{from{opacity:0;transform:translate3d(0,-100%,0)}to{opacity:1;transform:translate3d(0,0,0)}}",
    "fade-in-down-big": "{from{opacity:0;transform:translate3d(0,-2000px,0)}to{opacity:1;transform:translate3d(0,0,0)}}",
    "fade-in-left": "{from{opacity:0;transform:translate3d(-100%,0,0)}to{opacity:1;transform:translate3d(0,0,0)}}",
    "fade-in-left-big": "{from{opacity:0;transform:translate3d(-2000px,0,0)}to{opacity:1;transform:translate3d(0,0,0)}}",
    "fade-in-right": "{from{opacity:0;transform:translate3d(100%,0,0)}to{opacity:1;transform:translate3d(0,0,0)}}",
    "fade-in-right-big": "{from{opacity:0;transform:translate3d(2000px,0,0)}to{opacity:1;transform:translate3d(0,0,0)}}",
    "fade-in-up": "{from{opacity:0;transform:translate3d(0,100%,0)}to{opacity:1;transform:translate3d(0,0,0)}}",
    "fade-in-up-big": "{from{opacity:0;transform:translate3d(0,2000px,0)}to{opacity:1;transform:translate3d(0,0,0)}}",
    "fade-in-top-left": "{from{opacity:0;transform:translate3d(-100%,-100%,0)}to{opacity:1;transform:translate3d(0,0,0)}}",
    "fade-in-top-right": "{from{opacity:0;transform:translate3d(100%,-100%,0)}to{opacity:1;transform:translate3d(0,0,0)}}",
    "fade-in-bottom-left": "{from{opacity:0;transform:translate3d(-100%,100%,0)}to{opacity:1;transform:translate3d(0,0,0)}}",
    "fade-in-bottom-right": "{from{opacity:0;transform:translate3d(100%,100%,0)}to{opacity:1;transform:translate3d(0,0,0)}}",
    "fade-out": "{from{opacity:1}to{opacity:0}}",
    "fade-out-down": "{from{opacity:1}to{opacity:0;transform:translate3d(0,100%,0)}}",
    "fade-out-down-big": "{from{opacity:1}to{opacity:0;transform:translate3d(0,2000px,0)}}",
    "fade-out-left": "{from{opacity:1}to{opacity:0;transform:translate3d(-100%,0,0)}}",
    "fade-out-left-big": "{from{opacity:1}to{opacity:0;transform:translate3d(-2000px,0,0)}}",
    "fade-out-right": "{from{opacity:1}to{opacity:0;transform:translate3d(100%,0,0)}}",
    "fade-out-right-big": "{from{opacity:1}to{opacity:0;transform:translate3d(2000px,0,0)}}",
    "fade-out-up": "{from{opacity:1}to{opacity:0;transform:translate3d(0,-100%,0)}}",
    "fade-out-up-big": "{from{opacity:1}to{opacity:0;transform:translate3d(0,-2000px,0)}}",
    "fade-out-top-left": "{from{opacity:1;transform:translate3d(0,0,0)}to{opacity:0;transform:translate3d(-100%,-100%,0)}}",
    "fade-out-top-right": "{from{opacity:1;transform:translate3d(0,0,0)}to{opacity:0;transform:translate3d(100%,-100%,0)}}",
    "fade-out-bottom-left": "{from{opacity:1;transform:translate3d(0,0,0)}to{opacity:0;transform:translate3d(-100%,100%,0)}}",
    "fade-out-bottom-right": "{from{opacity:1;transform:translate3d(0,0,0)}to{opacity:0;transform:translate3d(100%,100%,0)}}",
    "back-in-up": "{0%{opacity:0.7;transform:translateY(1200px) scale(0.7)}80%{opacity:0.7;transform:translateY(0px) scale(0.7)}100%{opacity:1;transform:scale(1)}}",
    "back-in-down": "{0%{opacity:0.7;transform:translateY(-1200px) scale(0.7)}80%{opacity:0.7;transform:translateY(0px) scale(0.7)}100%{opacity:1;transform:scale(1)}}",
    "back-in-right": "{0%{opacity:0.7;transform:translateX(2000px) scale(0.7)}80%{opacity:0.7;transform:translateY(0px) scale(0.7)}100%{opacity:1;transform:scale(1)}}",
    "back-in-left": "{0%{opacity:0.7;transform:translateX(-2000px) scale(0.7)}80%{opacity:0.7;transform:translateX(0px) scale(0.7)}100%{opacity:1;transform:scale(1)}}",
    "back-out-up": "{0%{opacity:1;transform:scale(1)}80%{opacity:0.7;transform:translateY(0px) scale(0.7)}100%{opacity:0.7;transform:translateY(-700px) scale(0.7)}}",
    "back-out-down": "{0%{opacity:1;transform:scale(1)}80%{opacity:0.7;transform:translateY(0px) scale(0.7)}100%{opacity:0.7;transform:translateY(700px) scale(0.7)}}",
    "back-out-right": "{0%{opacity:1;transform:scale(1)}80%{opacity:0.7;transform:translateY(0px) scale(0.7)}100%{opacity:0.7;transform:translateX(2000px) scale(0.7)}}",
    "back-out-left": "{0%{opacity:1;transform:scale(1)}80%{opacity:0.7;transform:translateX(-2000px) scale(0.7)}100%{opacity:0.7;transform:translateY(-700px) scale(0.7)}}"
  },
  durations: {
    pulse: "2s",
    "heart-beat": "1.3s",
    "bounce-in": "0.75s",
    "bounce-out": "0.75s",
    "flip-out-x": "0.75s",
    "flip-out-y": "0.75s",
    hinge: "2s"
  },
  timingFns: {
    pulse: "cubic-bezier(0.4,0,.6,1)",
    ping: "cubic-bezier(0,0,.2,1)",
    "head-shake": "ease-in-out",
    "heart-beat": "ease-in-out",
    "pulse-alt": "ease-in-out",
    "light-speed-in-left": "ease-out",
    "light-speed-in-right": "ease-out",
    "light-speed-out-left": "ease-in",
    "light-speed-out-right": "ease-in"
  },
  properties: {
    "bounce-alt": {
      "transform-origin": "center bottom"
    },
    jello: {
      "transform-origin": "center"
    },
    swing: {
      "transform-origin": "top center"
    },
    flip: {
      "backface-visibility": "visible"
    },
    "flip-in-x": {
      "backface-visibility": "visible !important"
    },
    "flip-in-y": {
      "backface-visibility": "visible !important"
    },
    "flip-out-x": {
      "backface-visibility": "visible !important"
    },
    "flip-out-y": {
      "backface-visibility": "visible !important"
    },
    "rotate-in": {
      "transform-origin": "center"
    },
    "rotate-in-down-left": {
      "transform-origin": "left bottom"
    },
    "rotate-in-down-right": {
      "transform-origin": "right bottom"
    },
    "rotate-in-up-left": {
      "transform-origin": "left bottom"
    },
    "rotate-in-up-right": {
      "transform-origin": "right bottom"
    },
    "rotate-out": {
      "transform-origin": "center"
    },
    "rotate-out-down-left": {
      "transform-origin": "left bottom"
    },
    "rotate-out-down-right": {
      "transform-origin": "right bottom"
    },
    "rotate-out-up-left": {
      "transform-origin": "left bottom"
    },
    "rotate-out-up-right": {
      "transform-origin": "right bottom"
    },
    hinge: {
      "transform-origin": "top left"
    },
    "zoom-out-down": {
      "transform-origin": "center bottom"
    },
    "zoom-out-left": {
      "transform-origin": "left center"
    },
    "zoom-out-right": {
      "transform-origin": "right center"
    },
    "zoom-out-up": {
      "transform-origin": "center bottom"
    }
  },
  counts: {
    spin: "infinite",
    ping: "infinite",
    pulse: "infinite",
    "pulse-alt": "infinite",
    bounce: "infinite",
    "bounce-alt": "infinite"
  },
  category: {
    pulse: "Attention Seekers",
    bounce: "Attention Seekers",
    spin: "Attention Seekers",
    ping: "Attention Seekers",
    "bounce-alt": "Attention Seekers",
    flash: "Attention Seekers",
    "pulse-alt": "Attention Seekers",
    "rubber-band": "Attention Seekers",
    "shake-x": "Attention Seekers",
    "shake-y": "Attention Seekers",
    "head-shake": "Attention Seekers",
    swing: "Attention Seekers",
    tada: "Attention Seekers",
    wobble: "Attention Seekers",
    jello: "Attention Seekers",
    "heart-beat": "Attention Seekers",
    hinge: "Specials",
    "jack-in-the-box": "Specials",
    "light-speed-in-left": "Lightspeed",
    "light-speed-in-right": "Lightspeed",
    "light-speed-out-left": "Lightspeed",
    "light-speed-out-right": "Lightspeed",
    flip: "Flippers",
    "flip-in-x": "Flippers",
    "flip-in-y": "Flippers",
    "flip-out-x": "Flippers",
    "flip-out-y": "Flippers",
    "rotate-in": "Rotating Entrances",
    "rotate-in-down-left": "Rotating Entrances",
    "rotate-in-down-right": "Rotating Entrances",
    "rotate-in-up-left": "Rotating Entrances",
    "rotate-in-up-right": "Rotating Entrances",
    "rotate-out": "Rotating Exits",
    "rotate-out-down-left": "Rotating Exits",
    "rotate-out-down-right": "Rotating Exits",
    "rotate-out-up-left": "Rotating Exits",
    "rotate-out-up-right": "Rotating Exits",
    "roll-in": "Specials",
    "roll-out": "Specials",
    "zoom-in": "Zooming Entrances",
    "zoom-in-down": "Zooming Entrances",
    "zoom-in-left": "Zooming Entrances",
    "zoom-in-right": "Zooming Entrances",
    "zoom-in-up": "Zooming Entrances",
    "zoom-out": "Zooming Exits",
    "zoom-out-down": "Zooming Exits",
    "zoom-out-left": "Zooming Exits",
    "zoom-out-right": "Zooming Exits",
    "zoom-out-up": "Zooming Exits",
    "bounce-in": "Bouncing Entrances",
    "bounce-in-down": "Bouncing Entrances",
    "bounce-in-left": "Bouncing Entrances",
    "bounce-in-right": "Bouncing Entrances",
    "bounce-in-up": "Bouncing Entrances",
    "bounce-out": "Bouncing Exits",
    "bounce-out-down": "Bouncing Exits",
    "bounce-out-left": "Bouncing Exits",
    "bounce-out-right": "Bouncing Exits",
    "bounce-out-up": "Bouncing Exits",
    "slide-in-down": "Sliding Entrances",
    "slide-in-left": "Sliding Entrances",
    "slide-in-right": "Sliding Entrances",
    "slide-in-up": "Sliding Entrances",
    "slide-out-down": "Sliding Exits",
    "slide-out-left": "Sliding Exits",
    "slide-out-right": "Sliding Exits",
    "slide-out-up": "Sliding Exits",
    "fade-in": "Fading Entrances",
    "fade-in-down": "Fading Entrances",
    "fade-in-down-big": "Fading Entrances",
    "fade-in-left": "Fading Entrances",
    "fade-in-left-big": "Fading Entrances",
    "fade-in-right": "Fading Entrances",
    "fade-in-right-big": "Fading Entrances",
    "fade-in-up": "Fading Entrances",
    "fade-in-up-big": "Fading Entrances",
    "fade-in-top-left": "Fading Entrances",
    "fade-in-top-right": "Fading Entrances",
    "fade-in-bottom-left": "Fading Entrances",
    "fade-in-bottom-right": "Fading Entrances",
    "fade-out": "Fading Exits",
    "fade-out-down": "Fading Exits",
    "fade-out-down-big": "Fading Exits",
    "fade-out-left": "Fading Exits",
    "fade-out-left-big": "Fading Exits",
    "fade-out-right": "Fading Exits",
    "fade-out-right-big": "Fading Exits",
    "fade-out-up": "Fading Exits",
    "fade-out-up-big": "Fading Exits",
    "fade-out-top-left": "Fading Exits",
    "fade-out-top-right": "Fading Exits",
    "fade-out-bottom-left": "Fading Exits",
    "fade-out-bottom-right": "Fading Exits",
    "back-in-up": "Back Entrances",
    "back-in-down": "Back Entrances",
    "back-in-right": "Back Entrances",
    "back-in-left": "Back Entrances",
    "back-out-up": "Back Exits",
    "back-out-down": "Back Exits",
    "back-out-right": "Back Exits",
    "back-out-left": "Back Exits"
  }
};
export const supports = {
  grid: "(display: grid)"
};
export default {
  width,
  height,
  maxWidth,
  maxHeight,
  minWidth,
  minHeight,
  inlineSize,
  blockSize,
  maxInlineSize,
  maxBlockSize,
  minInlineSize,
  minBlockSize,
  colors,
  fontFamily,
  fontSize,
  fontWeight,
  breakpoints,
  verticalBreakpoints,
  borderRadius,
  lineHeight,
  letterSpacing,
  wordSpacing,
  boxShadow,
  textIndent,
  textShadow,
  textStrokeWidth,
  blur,
  dropShadow,
  easing,
  transitionProperty,
  lineWidth,
  spacing,
  duration,
  ringWidth,
  preflightBase,
  containers,
  zIndex,
  media,
  aria,
  animation,
  supports
};
