# Static Code Analysis

[![Build Status](https://travis-ci.org/Monits/static-code-analysis-plugin.svg?branch=development)](https://travis-ci.org/Monits/static-code-analysis-plugin)
[![Download](https://api.bintray.com/packages/monits/monits-android/static-code-analysis-plugin/images/download.svg) ](https://bintray.com/monits/monits-android/static-code-analysis-plugin/_latestVersion)

Static Code Analysis wraps around Checkstyle, Spotbugs, PMD and CPD, offering new features
and extensions to the encapsulated plugins, making it easier to use them and providing
better results with minimum effort.

Out of the box, with just applying the plugin you get:
 * Improved build performance. Spotbugs and PMD will ignore changes to autogenerated
Android files (``R.class`` and ``BuildConfig.class``)
 * Android Lint task is reconfigured to detect when it's up-to-date and cache results
 * Better PMD and Spotbugs analysis, allowing both tools to look into Android's SDK classes when performing analysis.
 * More detectors, by automatically including:
   * [fb-contrib](https://github.com/mebigfatguy/fb-contrib)
   * [Monits Findbugs](https://github.com/Monits/findbugs-plugin)
 * Automatically use the latest available version of each tool compatible with the
used Gradle version. Just updating Gradle will introduce newer tools.
 * Checkstyle and Spotbugs support remote file configuration, which they normally don't.
 * Easy configuration through DSL.
 * Easily and reliably include [custom Android Lint rules](http://tools.android.com/tips/lint-custom-rules) accross teams and CI servers.
 * Backporting of fixes and improvements from later Gradle versions (in case you can't update)
 * Fully compatible with the use of Android's build cache.

# Adding it to your project

We are on [the Grade Plugin Portal](https://plugins.gradle.org/plugin/com.monits.staticCodeAnalysis), so you can simply do:

```groovy
plugins {
  id 'com.monits.staticCodeAnalysis' version '3.1.1'
}
```

or, you could also do

```groovy
buildscript {
  repositories {
    maven {
      url 'https://plugins.gradle.org/m2/'
    }
  }
  dependencies {
    classpath 'com.monits:static-code-analysis-plugin:3.1.1'
  }
}

apply plugin: 'com.monits.staticCodeAnalysis'
```

or, directly from jcenter

```groovy
buildscript {
  repositories {
    jcenter()
  }
  dependencies {
    classpath 'com.monits:static-code-analysis-plugin:3.1.1'
  }
}

apply plugin: 'com.monits.staticCodeAnalysis'
```

## Compatibility

Plugin Version | Gradle Version | Android Gradle Plugin Version
-----|----|-----
3.x|5.6+|3.3.0+
2.6.12|2.3 up to 5.6.x|1.1.x up to 3.5.x

*Prior to version 3.0.0 Findbugs was used instead of Spotbugs.*

## DSL

Configuring Static Code Analysis is very simple and intuitive thanks to its DSL. You can choose
which encapsulated plugin to run and set its configuration files. Here is a quick example

```groovy
staticCodeAnalysis {
    spotbugs = true
    checkstyle = true
    pmd = true
    cpd = true
    androidLint = true

    ignoreErrors = true

    // default rules
    spotbugsExclude = "$project.rootProject.projectDir/config/spotbugs/excludeFilter.xml"
    checkstyleRules = 'https://raw.githubusercontent.com/Monits/static-code-analysis-plugin/staging/defaults/checkstyle/checkstyle-cache.xml'
    pmdRules = [ 'https://raw.githubusercontent.com/Monits/static-code-analysis-plugin/staging/defaults/pmd/pmd.xml',
        'https://raw.githubusercontent.com/Monits/static-code-analysis-plugin/staging/defaults/pmd/pmd-android.xml' ]

    androidLintConfig = 'https://raw.githubusercontent.com/Monits/static-code-analysis-plugin/staging/defaults/android/android-lint.xml'

    sourceSetConfig {
        test { // or the name of any other sourceset
            // use a more relaxed ruleset
            checkstyleRules = 'config/checkstyle/test-checkstyle.xml'
            spotbugsExclude = 'config/spotbugs/test-spotbugs.xml'
            pmdRules = [ 'config/pmd/test-pmd.xml',
                'https://raw.githubusercontent.com/Monits/static-code-analysis-plugin/staging/defaults/pmd/pmd-android.xml' ]
        }
    }
}
```

By default, all plugins are applied, errors will not fail the build, and rules and exclusions will
be taken from [this repository's latest defaults](https://github.com/Monits/static-code-analysis-plugin/tree/staging/defaults)

*Prior to version 3.0.0 Findbugs was used instead of Spotbugs. If using the old version, the DSL is equivalent,
but uses `findbugs` instead of `spotbugs` for all properties.*

*All v2.x Findbugs DSL properties are automatically maped to Spotbugs in v3.x for easier upgrading*

Rules used by PMD, Spotbugs and Checkstyle can be overriden per-sourceset under the ``sourceSetConfig`` block.

To include custom lint rules, you can simply include the jars as dependencies under `androidLint`.
For instance, you could include [Monits' Android Linters](https://github.com/monits/android-linters) by adding:

```groovy
dependencies {
    androidLint 'com.monits:android-linters:1.+'
}
```

## Tasks

The plugin will add the following tasks:

* `cpd`
* `checkstyle`, depends on:
  * a `checkstyleSourcesetname` task per source-set (`checkstyleMain`, `checkstyleTest`, so on).
* `spotbugs`, depends on:
  * a `spotbugsSourcesetname` task per source-set (`spotbugsMain`, `spotbugsTest`, so on).
* `pmd`, depends on:
  * a `pmdSourcesetname` task per source-set (`pmdMain`, `pmdTest`, so on).

*Prior to version 3.0.0 Findbugs was used instead of Spotbugs. The old `findbugs*` tasks are still available and map to the corresponding `spotbugs*` task*

All tasks, are hooked to be run as part of the `check` task of the Java Plugin.

# Contributing

As always feel free to contribute in any shape or form, we look forward to your feedback!.

## Suppressing warnings

If you re seeing things being reported which you think shouldn't it could be one of two things:

1. It's a false-positive. The tool is convinced of a violation that is simply not there. These should be reported to
the tool's developers in a Github issue.
2. You have found yourself in a corner case, where the rule, even 'though correct, doesn't really apply to a particular snippet of code.
These should be **absolute exceptions**, if you find yourself in this scenario all the time, consider modifying the set of applied rules.

Since every tool has its own suppression mechanism, you should refer to its documentation:

- Android Lint: [Documentation](http://tools.android.com/tips/lint/suppressing-lint-warnings)
- Checkstyle: [Documentation](http://checkstyle.sourceforge.net/config_annotation.html#SuppressWarnings)
- CPD: [Documentation](https://pmd.github.io/latest/pmd_userdocs_cpd.html#suppression) 
- Spotbugs: [Annotations documentation](https://spotbugs.readthedocs.io/en/latest/annotations.html); `@SupressFBWarnings` [javadoc](https://spotbugs.readthedocs.io/en/latest/annotations.html#edu-umd-cs-findbugs-annotations-suppressfbwarnings)
- PMD: [Documentation](https://pmd.github.io/latest/pmd_userdocs_suppressing_warnings.html)


# Copyright and License
Copyright 2010-2017 Monits S.A.

Licensed under the Apache License, Version 2.0 (the "License"); you may not use
this work except in compliance with the License. You may obtain a copy of the
License at:

http://www.apache.org/licenses/LICENSE-2.0

