# frozen_string_literal: true

# This file is auto-generated from the current state of the database. Instead
# of editing this file, please use the migrations feature of Active Record to
# incrementally modify your database, and then regenerate this schema definition.
#
# Note that this schema.rb definition is the authoritative source for your
# database schema. If you need to create the application database on another
# system, you should be using db:schema:load, not running all the migrations
# from scratch. The latter is a flawed and unsustainable approach (the more migrations
# you'll amass, the slower it'll run and the greater likelihood for issues).
#
# It's strongly recommended that you check this file into your version control system.

ActiveRecord::Schema.define(version: 20_200_229_112_828) do
  create_table 'account_histories', force: :cascade do |t|
    t.integer 'account_id'
    t.integer 'credit_rating'
    t.datetime 'created_at', null: false
    t.datetime 'updated_at', null: false
    t.index ['account_id'], name: 'index_account_histories_on_account_id'
  end

  create_table 'accounts', force: :cascade do |t|
    t.integer 'supplier_id'
    t.string 'account_number'
    t.datetime 'created_at', null: false
    t.datetime 'updated_at', null: false
    t.index ['supplier_id'], name: 'index_accounts_on_supplier_id'
  end

  create_table 'appointments', force: :cascade do |t|
    t.integer 'physician_id'
    t.integer 'patient_id'
    t.datetime 'appointment_date'
    t.datetime 'created_at', null: false
    t.datetime 'updated_at', null: false
    t.index ['patient_id'], name: 'index_appointments_on_patient_id'
    t.index ['physician_id'], name: 'index_appointments_on_physician_id'
  end

  create_table 'assemblies', force: :cascade do |t|
    t.string 'name'
    t.datetime 'created_at', null: false
    t.datetime 'updated_at', null: false
    t.integer 'points'
  end

  create_table 'assemblies_parts', id: false, force: :cascade do |t|
    t.integer 'assembly_id'
    t.integer 'part_id'
    t.index ['assembly_id'], name: 'index_assemblies_parts_on_assembly_id'
    t.index ['part_id'], name: 'index_assemblies_parts_on_part_id'
  end

  create_table 'authors', force: :cascade do |t|
    t.string 'name'
    t.datetime 'created_at', null: false
    t.datetime 'updated_at', null: false
  end

  create_table 'books', force: :cascade do |t|
    t.integer 'author_id'
    t.datetime 'published_at'
    t.datetime 'created_at', null: false
    t.datetime 'updated_at', null: false
    t.index ['author_id'], name: 'index_books_on_author_id'
  end

  create_table 'companies', force: :cascade do |t|
    t.integer 'owner'
    t.datetime 'created_at', null: false
    t.datetime 'updated_at', null: false
    t.string 'subdomain'
  end

  create_table 'companies_users', id: false, force: :cascade do |t|
    t.integer 'company_id'
    t.integer 'user_id'
    t.index ['company_id'], name: 'index_companies_users_on_company_id'
    t.index ['user_id'], name: 'index_companies_users_on_user_id'
  end

  create_table 'parts', force: :cascade do |t|
    t.string 'part_number'
    t.datetime 'created_at', null: false
    t.datetime 'updated_at', null: false
    t.string 'legacy_code'
    t.string 'size'
  end

  create_table 'patients', force: :cascade do |t|
    t.string 'name'
    t.datetime 'created_at', null: false
    t.datetime 'updated_at', null: false
    t.string 'email'
  end

  create_table 'physicians', force: :cascade do |t|
    t.string 'name'
    t.datetime 'created_at', null: false
    t.datetime 'updated_at', null: false
  end

  create_table 'suppliers', force: :cascade do |t|
    t.string 'name'
    t.datetime 'created_at', null: false
    t.datetime 'updated_at', null: false
  end

  create_table 'users', force: :cascade do |t|
    t.string 'name'
    t.boolean 'active'
    t.integer 'company_id'
  end
end
