# Security Policy

This document outlines our security policy for the codebases, platforms that we operate, and how to report vulnerabilities.

## Reporting a Vulnerability

> [!NOTE]
> If you think you have found a vulnerability, **please report it responsibly**. Do not create GitHub issues for security issues. Instead, follow this guide.

### Guidelines

We appreciate responsible disclosure of vulnerabilities that might impact the integrity of our platforms and users. In the interest of saving everyone time, we encourage you to report vulnerabilities with these in mind:

1. Ensure that you are using the **latest**, **stable**, and **updated** versions to you on your machine.
2. While we do not offer any bounties or swags at the moment, we'll be happy to list your name in our [Hall of Fame](security-hall-of-fame.md) list, provided the reports are not low-effort.

### Reporting

After confirming the above guidelines, please feel free to send a message to `github maintainer`. 

Once you report a vulnerability, we will look into it and ensure that it is not a false positive. If we need to clarify any details, we will get back to you. You can submit separate reports for each issue you find. Please note that we will not be able to respond to any issues that we think are outside the guidelines.

## Platforms & Codebases

Here is a list of the platforms and codebases we are accepting reports for:

### Learn Platform

| Version     | Branch         | Supported          |
| ----------- | -------------- | ------------------ |
| development | `main`         | :white_check_mark: |


If you are reporting a vulnerability, please ensure that it is not a bug in the upstream software.
