# Visual Studio Code extensions

## Tutorials

- [VS Code JS Tutorial](https://code.visualstudio.com/docs/languages/javascript) - JavaScript in Visual Studio Code;
- [Can Do That](https://burkeholland.gitbook.io/vs-code-can-do-that/) - what Visual Studio Code can do (Workshop);

## Extensions

- [ESLint](https://marketplace.visualstudio.com/items?itemName=dbaeumer.vscode-eslint) - code analyzer for JavaScript;
- [TSLint](https://marketplace.visualstudio.com/items?itemName=eg2.tslint) - code analyzer for TypeScript;
- [JSHint](https://marketplace.visualstudio.com/items?itemName=dbaeumer.jshint) - linter for JavaScript;
- [Debugger for Chrome](https://marketplace.visualstudio.com/items?itemName=msjsdiag.debugger-for-chrome) - debug your JavaScript code running in Google Chrome;
- [Material Icon Theme](https://marketplace.visualstudio.com/items?itemName=PKief.material-icon-theme) - Material Design icons into your VS Code;
- [Live Server](https://marketplace.visualstudio.com/items?itemName=ritwickdey.LiveServer) - launch a local development server;
- [Prettier](https://marketplace.visualstudio.com/items?itemName=esbenp.prettier-vscode) - opinionated code formatter;
- [Bracket Pair Colorizer](https://marketplace.visualstudio.com/items?itemName=CoenraadS.bracket-pair-colorizer) - allows matching brackets to be identified with colours;
- [Git Graph](https://marketplace.visualstudio.com/items?itemName=mhutchie.git-graph) - view a Git Graph of your repository and more;
- [VSCode Faker](https://marketplace.visualstudio.com/items?itemName=deerawan.vscode-faker) - generate fake data inside Visual Studio Code;
- [Path Intellisense](https://marketplace.visualstudio.com/items?itemName=christian-kohler.path-intellisense) - Visual Studio Code plugin that autocompletes filenames;
- [Bookmarks](https://marketplace.visualstudio.com/items?itemName=alefragnani.Bookmarks) - helps you to navigate in your code;
- [Better Comments](https://marketplace.visualstudio.com/items?itemName=aaron-bond.better-comments) - help you create more human-friendly comments in your code;
- [Google Fonts](https://marketplace.visualstudio.com/items?itemName=lior-chamla.google-fonts) - allows you to browse the Google Fonts list and insert;
- [Code Runner](https://marketplace.visualstudio.com/items?itemName=formulahendry.code-runner) - run code snippet or code file for multiple languages;
- [JavaScript Snippet Pack](https://marketplace.visualstudio.com/items?itemName=xabikos.JavaScriptSnippets) - contains code snippets for JavaScript in ES6 syntax;
- [Indent Rainbow](https://marketplace.visualstudio.com/items?itemName=oderwat.indent-rainbow) - colorizes the indentation in front of your text;
- [BEM Helper](https://marketplace.visualstudio.com/items?itemName=Box-Of-Hats.bemhelper) - improve writing html using BEM naming conventions;
- [Visual Studio IntelliCode](https://marketplace.visualstudio.com/items?itemName=VisualStudioExptTeam.vscodeintellicode) - AI-assisted development;
- [IntelliSense for CSS](https://marketplace.visualstudio.com/items?itemName=Zignd.html-css-class-completion) - provides CSS class name completion for the HTML;
- [YAML](https://marketplace.visualstudio.com/items?itemName=redhat.vscode-yaml) - provides comprehensive YAML Language;
- [NPM](https://marketplace.visualstudio.com/items?itemName=eg2.vscode-npm-script) - supports running npm scripts defined in the package.json file;
- [NPM IntelliSense](https://marketplace.visualstudio.com/items?itemName=christian-kohler.npm-intellisense) - autocompletes npm modules in import statements;
- [Settings Sync](https://marketplace.visualstudio.com/items?itemName=Shan.code-settings-sync) - synchronize all Visual Studio Code settings;
- [C#](https://marketplace.visualstudio.com/items?itemName=ms-dotnettools.csharp) - lightweight development tools for .NET Core and more;
- [SQL Server (mssql)](https://marketplace.visualstudio.com/items?itemName=ms-mssql.mssql) - extension for developing Microsoft SQL Server and more.
- [Docker](https://marketplace.visualstudio.com/items?itemName=ms-azuretools.vscode-docker) - makes it easy to build, manage and deploy containerized applications;
- [Remote - SSH](https://marketplace.visualstudio.com/items?itemName=ms-vscode-remote.remote-ssh) - use any remote machine with a SSH server as your dev env;
- [CSS Peek](https://marketplace.visualstudio.com/items?itemName=pranaygp.vscode-css-peek) - allow peeking to css ID and class strings;
- [JS Parameter Annotations](https://marketplace.visualstudio.com/items?itemName=lannonbr.vscode-js-annotations) - annotations for parameters in your JS / TS Files;
- [Commitizen](https://marketplace.visualstudio.com/items?itemName=KnisterPeter.vscode-commitizen) - git commit with conventions;
- [Solution Explorer](https://marketplace.visualstudio.com/items?itemName=fernandoescolar.vscode-solution-explorer) - Visual Studio .sln file explorer for Visual Studio Code;
- [Live Share](https://marketplace.visualstudio.com/items?itemName=MS-vsliveshare.vsliveshare) - real-time collaborative development from the comfort of your favorite tools;
- [Version Lens](https://marketplace.visualstudio.com/items?itemName=pflannery.vscode-versionlens) - shows the latest version for each package using code lens;
- [TODO Highlight](https://marketplace.visualstudio.com/items?itemName=wayou.vscode-todo-highlight) - highlight TODOs, FIXMEs, and any keywords, annotations, etc;
- [React JS snippets](https://marketplace.visualstudio.com/items?itemName=dsznajder.es7-react-js-snippets) - simple extensions for React, Redux and GraphQL;
- [TypeScript Hero](https://marketplace.visualstudio.com/items?itemName=rbbit.typescript-hero) - organize your imports;
- [Angular Language Service](https://marketplace.visualstudio.com/items?itemName=Angular.ng-template) - provides a rich editing experience for Angular templates;
- [Angular Snippets](https://marketplace.visualstudio.com/items?itemName=johnpapa.Angular2) - snippets for Angular for TypeScript and HTML;
- [EditorConfig](https://marketplace.visualstudio.com/items?itemName=EditorConfig.EditorConfig) - editor config Support for Visual Studio Code;
- [GitLens](https://marketplace.visualstudio.com/items?itemName=eamodio.gitlens) - helps you to visualize code authorship at a glance via Git blame annotations and etc;
- [Live Sass Compiler](https://marketplace.visualstudio.com/items?itemName=ritwickdey.live-sass) - compile Sass or Scss to CSS at realtime with live browser reload;
- [PostgreSQL](https://marketplace.visualstudio.com/items?itemName=ms-ossdata.vscode-postgresql) - extension for developing PostgreSQL;
- [VSCode Icons](https://marketplace.visualstudio.com/items?itemName=vscode-icons-team.vscode-icons) - bring icons to your Visual Studio Code;
- [Path Intellisense](https://marketplace.visualstudio.com/items?itemName=christian-kohler.path-intellisense) - plugin that autocompletes filenames;
