# CSS

## Main

- [CSS Reference #1](https://cssreference.io/) - list of all CSS properties;
- [CSS Reference #2](http://tympanus.net/codrops/css_reference/) - extensive CSS reference with all the important properties;

## Examples

- [Flexbox Froggy](https://flexboxfroggy.com/) - game for learning CSS flexbox;
- [Grid Garden](http://cssgridgarden.com/) - game for learning CSS grid;
- [CSS Diner](https://flukeout.github.io/) - game for learning CSS;
- [Flexbox Examples](https://tpverstak.ru/flex-cheatsheet/) - cheatsheet for flexbox;
- [Flexbox Guide EN](https://css-tricks.com/snippets/css/a-guide-to-flexbox/) - comprehensive guide to CSS flexbox layout;
- [Flexbox Guide RU](https://frontender.info/a-guide-to-flexbox/) - guide to CSS flexbox;
- [CSS Animation](https://cssanimation.rocks/principles/) - animation principles for the Web;
- [Animation Exmaples](https://css-tricks.com/tips-for-writing-animation-code-efficiently/) - tips for writing animation code efficiently;

## Services

- [SassMeister](https://www.sassmeister.com/) - Sass playground;
- [CSS Grid](https://cssgr.id/) - interactive CSS Grid code tool and generator;
- [Pure CSS Loaders](https://loading.io/css/) - open source CSS loading animations;
- [Clippy](https://bennettfeely.com/clippy/) - CSS clip-path maker;
- [Fancy Border Radius](https://9elements.github.io/fancy-border-radius/) - create very cool effects with CSS;
- [Animista](https://animista.net/) - create CSS animation;
- [Animate](https://daneden.github.io/animate.css/) - choose CSS animation (library);
- [Triangle Generator](http://apps.eky.hk/css-triangle-generator/) - CSS triangle generator;
- [Autoprefixer CSS](https://autoprefixer.github.io/) - autoprefixer CSS online;
- [PX to REM](https://nekocalc.com/px-to-rem-converter) - convertor px to rem;
- [Hot To Center In CSS](http://howtocenterincss.com/) - service for centering data in the div block;
- [Specificity Calculator](https://specificity.keegan.st/) - visual way to understand CSS specificity;
- [CSS Layout](https://csslayout.io/) - ollection of popular layouts and patterns;

## Github repositories

- [pattern.css](https://github.com/bansal-io/pattern.css) - CSS only library to fill your empty background;
