/**
* \file  conf_extint.h
*
* \brief WLR089 External Interrupt Configuration
*
*
* Copyright (c) 2020 Microchip Technology Inc. and its subsidiaries.
*
* \asf_license_start
*
* \page License
*
* Subject to your compliance with these terms, you may use Microchip
* software and any derivatives exclusively with Microchip products.
* It is your responsibility to comply with third party license terms applicable
* to your use of third party software (including open source software) that
* may accompany Microchip software.
*
* THIS SOFTWARE IS SUPPLIED BY MICROCHIP "AS IS".  NO WARRANTIES,
* WHETHER EXPRESS, IMPLIED OR STATUTORY, APPLY TO THIS SOFTWARE,
* INCLUDING ANY IMPLIED WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY,
* AND FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT WILL MICROCHIP BE
* LIABLE FOR ANY INDIRECT, SPECIAL, PUNITIVE, INCIDENTAL OR CONSEQUENTIAL
* LOSS, DAMAGE, COST OR EXPENSE OF ANY KIND WHATSOEVER RELATED TO THE
* SOFTWARE, HOWEVER CAUSED, EVEN IF MICROCHIP HAS BEEN ADVISED OF THE
* POSSIBILITY OR THE DAMAGES ARE FORESEEABLE.  TO THE FULLEST EXTENT
* ALLOWED BY LAW, MICROCHIP'S TOTAL LIABILITY ON ALL CLAIMS IN ANY WAY
* RELATED TO THIS SOFTWARE WILL NOT EXCEED THE AMOUNT OF FEES, IF ANY,
* THAT YOU HAVE PAID DIRECTLY TO MICROCHIP FOR THIS SOFTWARE.
*
* \asf_license_stop
*
*/
/*
* Support and FAQ: visit <a href="https://www.microchip.com/support/">Microchip Support</a>
*/


#ifndef CONF_EXTINT_H_INCLUDED
#define CONF_EXTINT_H_INCLUDED

/**
 * Define which clock type is used to clock EIC peripheral:
 *     - EXTINT_CLK_GCLK
 *     - EXTINT_CLK_ULP32K
 *
 * EXTINT_CLK_ULP32K is available for SAM L21/C21.
 */
#define EXTINT_CLOCK_SELECTION   EXTINT_CLK_ULP32K

/**
 * Define which GCLK source is used when selecting EXTINT_CLK_GCLK type.
 */
#if (EXTINT_CLOCK_SELECTION == EXTINT_CLK_GCLK)
#  define EXTINT_CLOCK_SOURCE      GCLK_GENERATOR_0
#endif

#endif
