# Colemak Practice Words

Home-row typing is really great, _aLMost all of the time_.

This is a collection of hard-to-type same-finger bigram (and some
trigram) words.

These are your primary enemies:

	hj hk hl hm hn jk jl jm jn kl km kn lm ln mn
	jh kh lh mh nh kj lj mj nj lk mk nk ml nl mn
	sc cs fs sf fc cf rw wr rx xr qa za ue eu iy yi

The goal is to never use the same finger twice in succession … ’cuz
that maKEs you slow (and uncomfortable!). And if you ever wanna beat
[Sean Wrona](https://forum.colemak.com/topic/1309-typing-tips-from-the-fastest-typist-sean-wrona/)
in a typing contest and tell him to his face that **colemak rulez!**,
you gotta get that
[1.52%](https://colemakmods.github.io/mod-dh/compare.html#compare-results)
down to 0%! (among other UNLIKELY things)

This even covers “shifting” as you might do on a piano. Eg, try typing
some of these: _helm, acknowledge, wrinkly_. Not great, huh?
Well, it turns out there are a lot of nasty colemak words LIKE these.
But the good news is that it’s not _that_ many! And you can train them
all into your hands in probably a couple weeks until the patterns
become automatic. And bam, you’re wearing the world-champion co-Wrona!

There are some particularly nasty words LIKE _ploying_ and _unkempt_
that just taKE a lot of practice of the shifts.

But a lot of the words are pretty easy and are natural “SCrunches”,
LIKE _scriptwriter_, featuring three! scrunches in a single word: `sc
pt wr`. _(Can you figure out how to SCrunch them??)_ Although
“slide-downs” sound nice in theory, I don’t find them possible, so I
thINK we should stick to vertical SCrunching.

The words in this file collection can be loaded into typing practice
tools, LIKE https://www.keybr.com

Some diSCussion:
https://forum.colemak.com/topic/2642-practice-with-altfloatingsamefinger-bigram-combos/

## Source

The words in these practice lists are taKEN from the OED (I thINK, but
source really doesn’t matter).

## Files

All same-finger permutations with more than ~10 semi-common words are
in files of the respective names. Others LIKE _hk_ and _jk_ are
basically non-existent. You can get away with skipping tiny files LIKE
_ln.lst_.

There is also a *programming* file of oddball names LIKE `mkfs` that
are tricksy.

The best file for training is _best.lst_, containting ~100 words that
have multiple odd patterns in a single word, LIKE _dEUtSCHMark_
(they’re mostly English :P). The file is sorted by patterns, so It’s
probably best to take sections of 10-20 words at a time to load into
your trainer.

## Tricks

``` shell
❯ echo `shuf tb.lst`
hatbox eastbound outbuilding ratbag paintbox …
```

That randomizes the list and puts them on a single line. Now you can
load them into your favorite typing tutor.

## Convention

Since fingerstyle guitar already has a
[convention](https://en.wikipedia.org/wiki/Fingerstyle_guitar#Notation)
for referring to index, middle, ring, and pINKY, let’s stick with it: “I M
A X”.

## Shifty Patterns

The following might be all you need to practice to conqUEr all the
trigrams. However, these are quite difficult to work though
altogether; typing them as parts of words is easier.

``` text
ken
kel
kne
key
ink
enk
unk
ulm
uln
ulken
unl
unmi
uen
uen
fsc
mne
helm
enj
inj
enli
inme
dbr
onke
like
lunk
keu
lke
lumny
nly
```

## oPTimiZAtions deSCribed (with examples)

### like

It’s not obvious that _like_ is a bad word. However, l and k are so
awkward/slow for your index that you can improve it with your first
full shift by typing: `l(M) i(X) k(I) e(A)`

_helm_ becomes: `h(I) e(A) l(M) m(I)`

_key_ becomes: `k(I) e(A) y(X)`

## Antirecommendations

Don’t bother with the _hm_ combo. It’s rare and requires lookahead.

## This is ridiculous

What’s that, this is a total waste? You might be right. Most people
probably don’t care about tuning an already amazing layout. But no
layout can be perfect – without some hacks. And that’s what these are,
but they should actually speed you up if you really wanna up your game
(after you down it yet again).

But seriously, these are cool, and I don’t see any harm in using them.
They don’t maKE otheRWise normal words worse. They actually maKE your
fingers more comfortable and spry for a little more learning effort.
Imagine a pianist never leaving C-position. That’s what you’ve been …
till now.

ENJoy!
