if(CMAKE_GENERATOR STREQUAL "Xcode" AND CMAKE_HOST_SYSTEM_PROCESSOR STREQUAL "arm64")

    # FIXME: Catch2 issue https://github.com/catchorg/Catch2/issues/2411
    #        "Result: Subprocess killed" build issue with CMake & Xcode generator on macOS with Apple Silicon 
    message(WARNING "Unable to discover and run Catch tests for ${TARGET} using Xcode generator on Apple Silicon")

else()

    include(CTest)
    include(Catch)

    catch_discover_tests(${TARGET})

    if (METHANE_RUN_TESTS_DURING_BUILD)
        # Get list of CTest include files which have to be generated by catch_discover_tests before tests can be started
        get_directory_property(CTEST_INCLUDE_FILES "TEST_INCLUDE_FILES")
        add_custom_command(TARGET ${TARGET} POST_BUILD
            DEPENDS ${CTEST_INCLUDE_FILES}
            COMMAND ${CTEST_EXE} -C $<CONFIGURATION> --output-on-failure
        )
    endif()

endif()