# Methane Kit External Dependencies

All external [libraries](#libraries) and [build tools](#build-tools)
are integrated using [CPM.cmake](https://github.com/cpm-cmake/CPM.cmake) package manager script.
Specific versions of the dependent repositories are cloned and configured
during `MethaneKit` CMake configuration step either to the `Build/Output/ExternalsCache` directory (by default)
or to the custom location provided via CMake option `CPM_SOURCE_CACHE`.
Under CLion IDE dependent repositories are cloned inside cmake build directory of each configuration 
to support parallel cmake configurations processing.

## Libraries

| Libraries                                                         | Version             | Linkage           | License                                                                                           | Description                                                                                                                                    |
|-------------------------------------------------------------------|---------------------|-------------------|---------------------------------------------------------------------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------|
| [Boost Nowide](https://github.com/boostorg/nowide)                | 1.87.0 (standalone) | Static            | [BSL 1.0](https://github.com/boostorg/nowide/blob/develop/LICENSE)                                | Standard library functions with UTF-8 API on Windows.                                                                                          |
| [Catch2](https://github.com/catchorg/Catch2)                      | 3.7.1               | Static (tests)    | [BSL 1.0](https://github.com/catchorg/Catch2/blob/devel/LICENSE.txt)                              | A modern, C++-native, test framework for unit-tests, TDD and BDD - using C++14, C++17 and later.                                               |
| [CLI11](https://github.com/CLIUtils/CLI11)                        | 2.3.2+ (2024-12-10) | Header-only       | [CLI11 2.2](https://github.com/CLIUtils/CLI11/blob/main/LICENSE)                                  | CLI11 is a command line parser for C++11 and beyond that provides a rich feature set with a simple and intuitive interface.                    |
| [DirectX Headers](https://github.com/microsoft/DirectX-Headers)   | 1.614.1             | Header-only       | [MIT](https://github.com/microsoft/DirectX-Headers/blob/main/LICENSE)                             | Official DirectX headers available under an open source license                                                                                |
| [DirectX Tex](https://github.com/microsoft/DirectXTex)            | 2.0.6 (2025-10)     | Static            | [MIT](https://github.com/microsoft/DirectXTex/blob/main/LICENSE)                                  | Texture processing library.                                                                                                                    |
| [FMT](https://github.com/fmtlib/fmt)                              | 11.0.2              | Header-only       | [Victor Zverovich](https://github.com/fmtlib/fmt/blob/master/LICENSE.rst)                         | A modern formatting library.                                                                                                                   |
| [FreeType](https://gitlab.freedesktop.org/freetype/freetype/)     | 2.13.3              | Static            | [FreeType (GPL 3.0)](https://gitlab.freedesktop.org/freetype/freetype/-/blob/master/docs/FTL.TXT) | FreeType is a freely available software library to render fonts.                                                                               |
| [FTXUI](https://github.com/ArthurSonzogni/FTXUI/)                 | 5.0.0               | Static            | [MIT](https://github.com/ArthurSonzogni/FTXUI/blob/main/LICENSE)                                  | C++ Functional Terminal User Interface.                                                                                                        |
| [HLSL++](https://github.com/redorav/hlslpp)                       | 3.5.3               | Header-only       | [MIT](https://github.com/MethanePowered/HLSLpp/blob/master/LICENSE)                               | Math library using hlsl syntax with SSE/NEON support.                                                                                          |
| [ITT API](https://github.com/intel/ittapi)                        | 3.25.3              | Static            | [BSD 3.0](https://github.com/MethanePowered/IttApi/blob/master/LICENSES/BSD-3-Clause.txt)         | Intel® Instrumentation and Tracing Technology (ITT) and Just-In-Time (JIT) API.                                                                |
| [Magic Enum](https://github.com/Neargye/magic_enum)               | 0.9.7               | Header-only       | [MIT](https://github.com/Neargye/magic_enum/blob/master/LICENSE)                                  | Static reflection for enums (to string, from string, iteration) for modern C++, work with any enum type without any macro or boilerplate code. |
| [OpenImageIO](https://github.com/OpenImageIO/oiio)                | 2.0.5               | Static (optional) | [GPL 3.0](https://github.com/OpenCppCoverage/OpenCppCoverage/blob/master/LICENSE.txt)             | Reading, writing, and processing images in a wide variety of file formats, using a format-agnostic API, aimed at VFX applications.             |
| [SPIRV-Cross](https://github.com/KhronosGroup/SPIRV-Cross)        | 1.3.296.0           | Static            | [Apache 2.0](https://github.com/KhronosGroup/SPIRV-Cross/blob/master/LICENSE)                     | A library for performing reflection on SPIR-V and disassembling SPIR-V back to high level languages.                                           |
| [STB](https://github.com/nothings/stb)                            | 2023-01-29          | Header-only       | [MIT, Public Domain](https://github.com/nothings/stb/blob/master/LICENSE)                         | Single-file public domain libraries for C/C++.                                                                                                 |
| [TaskFlow](https://github.com/taskflow/taskflow)                  | 3.8.0               | Header-only       | [MIT](https://github.com/taskflow/taskflow/blob/master/LICENSE)                                   | A General-purpose Parallel and Heterogeneous Task Programming System.                                                                          |
| [Tracy](https://github.com/wolfpld/tracy)                         | 0.11.2 (2024-12-12) | Static            | [BSD 3.0](https://github.com/wolfpld/tracy/blob/master/LICENSE)                                   | A real time, nanosecond resolution, remote telemetry, hybrid frame and sampling profiler for games and other applications.                     |
| [Vulkan Headers](https://github.com/MethanePowered/VulkanHeaders) | 1.3.296             | Header-only       | [Apache 2.0](https://github.com/KhronosGroup/Vulkan-Headers/blob/main/LICENSE.txt)                | Vulkan Header files and API registry.                                                                                                          |

## Build Tools

| Script or Tool                                                                | Version      | Usage                       | License                                                                                  | Description                                                                                                                                      |
|-------------------------------------------------------------------------------|--------------|-----------------------------|------------------------------------------------------------------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------|
| [CPM.cmake](https://github.com/cpm-cmake/CPM.cmake)                           | 0.40.5       | CMake                       | [MIT](https://github.com/cpm-cmake/CPM.cmake/blob/master/LICENSE)                        | CMake's missing package manager.                                                                                                                 |
| [CMRC](https://github.com/vector-of-bool/cmrc)                                | 2.0.2        | CMake                       | [MIT](https://github.com/vector-of-bool/cmrc/blob/master/LICENSE.txt)                    | A Resource Compiler in a Single CMake script.                                                                                                    |
| [CMake Modules](https://github.com/rpavlik/cmake-modules)                     | Methane Fork | CMake                       | [BSL 1.0](https://github.com/microsoft/CMakeModules/blob/main/LICENSE_1_0.txt)           | R.Pavlik collection of CMake modules.                                                                                                            |
| [iOS-Toolchain.cmake](https://github.com/leetal/ios-cmake)                    | 4.3.0        | CMake                       | [BSD 3.0](https://github.com/leetal/ios-cmake/blob/master/LICENSE.md)                    | A CMake toolchain file for iOS, macOS, watchOS & tvOS C/C++/Obj-C++ development.                                                                 |                                                                       |
| [DirectX Shader Compiler](https://github.com/microsoft/DirectXShaderCompiler) | 1.7.2308     | HLSL Compiler to DXIL/SPIRV | [LLVM Release](https://github.com/microsoft/DirectXShaderCompiler/blob/main/LICENSE.TXT) | Open-source HLSL Shader Compiler which is based on LLVM/Clang.                                                                                   |
| [Filter Sarif](https://github.com/zbazztian/filter-sarif)                     | n/a          | CodeQL Workflow             | [Apache 2.0](https://github.com/zbazztian/filter-sarif/blob/master/LICENSE)              | GitHub action to filter .sarif files produced by CodeQL.                                                                                         |
| [SPIRV-Cross](https://github.com/KhronosGroup/SPIRV-Cross)                    | 1.3.268.0    | SPIRV Converter to MSL      | [Apache 2.0](https://github.com/KhronosGroup/SPIRV-Cross/blob/master/LICENSE)            | Practical tool for disassembling SPIR-V back to high level languages.                                                                            |
| [MetalShaderConverter](https://developer.apple.com/metal/shader-converter/)   | 1.1          | DXIL Converter to MSL       | [Apache 2.0](https://github.com/MethanePowered/MetalShaderConverterBinary/blob/main/include/metal_irconverter/LICENSE.txt)  | CLI Tool and library for converting shader intermediate representations in LLVM IR bytecode form into bytecode suitable to be loaded into Metal. |
| [OpenCppCoverage](https://github.com/OpenCppCoverage/OpenCppCoverage)         | 0.9.9.0      | Code Coverage in Azure      | [GPL 3.0](https://github.com/OpenCppCoverage/OpenCppCoverage/blob/master/LICENSE.txt)    | Open source code coverage tool for C++ under Windows.                                                                                            |

## Assets

| Type     | Asset Name                                                           | Copyright                                              | License                                                   | Description                                                                                                                                                                                                                                                             |
|----------|----------------------------------------------------------------------|--------------------------------------------------------|-----------------------------------------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| Font     | [Amiri](https://fonts.google.com/specimen/Amiri)                     | [Khaled Hosny](khaledhosny@eglug.org)                  | [OFL 1.1](http://scripts.sil.org/OFL)                     | Amiri is a classical Arabic typeface in Naskh style for typesetting books and other running text. Its design is a revival of the beautiful typeface pioneered in early 20th century by Bulaq Press in Cairo, also known as Amiria Press, after which the font is named. |
| Font     | [Playball](https://fonts.google.com/specimen/Playball)               | [Robert Leuschke, TypeSETit LLC](typesetit.com)        | [OFL 1.1](http://scripts.sil.org/OFL)                     | An athletic look was the inspiration for Playball. Take advantage of the sweeping swashes to give a true sports look. Perfect for baseball banners and the like. Playball comes with Latin Character sets including Western, Central, and Vietnamese language support.  |
| Font     | [Roboto](https://fonts.google.com/specimen/Roboto)                   | [Christian Robertson](http://christianrobertson.com/)  | [Apache 2.0](http://www.apache.org/licenses/)             | Roboto has a mechanical skeleton and the forms are largely geometric. At the same time, the font features friendly and open curves. This makes for a more natural reading rhythm more commonly found in humanist and serif types.                                       |
| Font     | [Roboto Mono](https://fonts.google.com/specimen/Roboto+Mono)         | [Christian Robertson](http://christianrobertson.com/)  | [Apache 2.0](http://www.apache.org/licenses/)             | Monospaced addition to the Roboto type family. Like the other members of the Roboto family, the fonts are optimized for readability on screens across a wide variety of devices and reading environments.                                                               |
| Font     | [Sawarabi Mincho](https://fonts.google.com/specimen/Sawarabi+Mincho) | [Mshio](http://mshio.b.osdn.me/)                       | [OFL 1.1](http://scripts.sil.org/OFL)                     | Japanese font with a delicate and beautiful design, it is suitable for text and headline usage. It already has many hiragana, katakana, ruled lines, and so on, but it does not yet have enough kanji glyphs.                                                           |
| Font     | [Squada One](https://fonts.google.com/specimen/Squada+One)           | [Admix Designs](http://www.admixdesigns.com/)          | [OFL 1.1](http://scripts.sil.org/OFL)                     | Perfect font to make a lasting impression on any webpage. Its bold presence and geometric, condensed form allow for setting in any context. Squada One can be used at any size while still maintaining clarity and smoothness.                                          |
