var search_index = [
	[
	"QRazyBox is a web-based application (a toolkit), that used to analyzing and recovering damaged QR Code.QRazyBox lets you recover QR Code by redrawing and reconstructing it with Paint-like editor. It also provides several sub-tools (known as Extension Tools) to help you analyze and recover faster and more efficient. Main Features Reconstruct QR Code by drawing pixel by pixel Decode and read unscannable QR Code Save and load existing work for later use Import/export QR Code from/to Image file Currently support up to QR Code Version 6 (41x41) Support both Error and Erasure Correction using universal Reed-Solomon decoder Extract valuable information although from badly damaged QR Code Simulate data unmasking for manual data analysis Lightweight, fast, and easy to use Free and open source :)",
	"introduction/index.html",
	"Introduction"
	],

	["Before start using QRazyBox, I assumes that you already have basic knowledge about QR Code such as data encoding, the structure, and error correction. If not, I recommend to read a wonderful tutorial from thonky.com that'll covers how to generating QR Code step by step. Though, in the next section, we will discuss a little bit about QR Code as a summary and you just can skip it if you want. Jump to : - &nbsp; About QR Code - &nbsp; Interface Overview - &nbsp; Create, Save, and Load Project - &nbsp; Drawing and Decoding QR Code","getting-started/index.html","Getting Started"],

	['QR code (abbreviated from Quick Response Code ) is the trademark for a type of matrix barcode (or two-dimensional barcode) first designed for the automotive industry in Japan. A QR code uses four standardized encoding modes (numeric, alphanumeric, byte/binary, and kanji) to efficiently store data. (Wikipedia) The QR code format was created in 1994 by Japanese company Denso-Wave, which is a subsidiary of Toyota that manufactures auto components. The standard is defined in ISO/IEC 18004:2006. The use of QR codes is license-free. (thonky.com) Keep in mind, that in this section, we\'ll only discuss a summary about QR Code standards. If you want to learn QR Code in detail, you can visit a page that I recommend you before in previous section. QR Code Versions The size of QR Code is called version . Version of QR Code range from version 1 (21x21 pixels) up to version 40 (177x177 pixels) . These versions is defined by how much data that stored in the QR Code. So, the larger the data stored, the larger the version will be. *Pixel in QR Code is often also called Module . Error Correction QR Code also has error correction feature, that will automatically restore the data if some of them are damaged or unreadable. This error correction scheme use Reed-Solomon Error Correction algorithm that consists of 4 correction levels: Low (L) , Medium (M) , Quartile (Q) , and High (H) , where each of the level has its own capability of how much the data can be restored. Error-Correction Level % of data that can be restored Level L &plusmn; 7% Level M &plusmn; 15% Level Q &plusmn; 25% Level H &plusmn; 30% (The table above show the capabilty of each Error-Correction level) Structure of QR Code QR Code always consist of three things, Function pattern , Format &amp; Version Information Pattern , and Data Bits .Function Pattern is a non-data element of the QR Code that is required by the QR Code specification.Format &amp; Version Information Pattern are pattern that describe current specification that being used by QR Code such as Version, Error correction level, and Mask Pattern. And Data Bits itself is an actual data that encoded in the QR Code.Function pattern often also called Fixed Pattern because their form never changed, but only their position that will change depending on the QR Code version. (The image above explains about QR Code structure) Format and Version Information As explained in previous part, Format and Version Information are patterns in QR Code that tell about current specification that being used by QR code. Format information is always exist in every version of QR code, but Version information only exist in version 7 or above.Format information consist of 15 bits data that store information about error correction and mask pattern that being used by QR code.Thereafter, Version information consist of 18 bits data that store information about QR code version.Because until now, QRazyBox only support up to version 6 QR code, so we will ignore about version information for now. (The image above explain about how Format information store error correction level and mask pattern) The placement of these pattern are shared into 3 places (for Format info) and 2 places (for Version info). Those placement can be see in the image in the previous part that explains QR code structure. We will discuss about Mask Pattern in the last part of this section. Data Bits Layout Data bits is sequence of modules that contained blocks of encoded message and blocks of reed-solomon that will be used as error corrector later. The encoded message itself, is arranged from: Mode Indicator , Character Count Indicator , and main message itself . Mode indicator is encoding mode codeword (4 bits) that being used to encode the message to binary form. As explained before that QR code has 4 modes for encodes text: Numeric , Alphanumeric , Byte , and Kanji .Character count indicator is a number that tell the length of message. It is possible to use multiple modes in a single QR code by including the mode indicator before each section of bytes that uses that mode. Data bits are placed in QR code from right to left in a zigzag pattern and form a snake flow.The order is : Mode Indicator &rArr; Character Count Indicator &rArr; Main message &rArr; Error correction (reed-solomon block) (Example of data bits placement process, encoding text "www.wikipedia.org") But, pay attention that for larger QR code, data blocks must be interleaved and broken into smaller blocks according to the version and error correction level that being used. The Image below explain process of placing interleaved data blocks. Mask Pattern Before QR code is finally generated, the data bits must be XOR -ed with mask pattern. There are 8 mask pattern that available in QR code, namely mask pattern 0 to 7 (or 000 to 111 in binary). This process have a purpose of making QR code more readable by QR scanner. (Eight mask patterns) (The process of data masking) References : https://en.wikipedia.org/wiki/QR_code http://www.thonky.com/qr-code-tutorial http://www.qrcode.com',"getting-started/about-qr-code.html","About QR Code"
	],

	["Create, Save, and Load Project Create, save, and load project can be done through main menu in the header. Create New Project There are two ways to create new project. First, quickly create a blank QR code with template that ready to use. Therefore, you don't need to draw the Function pattern. The second is, you can import it from image file and QRazyBox will try to convert it to bitmatrix array. But, keep in mind that when you importing new project from image file, there are conditions that should be met besides that the image must contains valid QR code. Those conditions are, the loaded image must contain three Finder patterns and Alignment pattern according to the QR version. When you fail in importing an image, unfortunately you should reconstruct manually. Last, when you importing an image, QRazyBox only accept black and white colors, other than those colors will be transformed to black or white depending on its grayscale value, so you should change it manually when you want to mark it as damaged part of QR code.Save and Load Project QRazyBox use HTML5 Local Storage to store all of your project data. Therefore, if you change to the different new browser, you can't use your saved project from the previous browser.Be careful when you save a project with name that already exist, since it will overwrite the older project. You can delete your saved project by clicking cross mark ( x ) in the save or load dialog menu.","getting-started/create-save-load-project.html","Create, Save, and Load Project"
	],

	["Drawing and Decoding QR Code There are two main working modes in QRazyBox : Editor mode and Decode mode . To switch working mode, you can use Mode Indicator as explained before in the previous section . Editor Mode Editor mode is working mode where you can create, draw, and edit the QR code using painter and other tools.This image below is the main toolbox of Editor Mode that lets you draw QR code and maintain it.1. Painter : Collection of painter tools that used to draw QR code. 2. QR Code version : Change current version of your QR code. Remember that, change version of QR code will cause your work start from beginning, therefore, don't forget to set this before you start to reconstructing the QR code. 3. Module size : Change size of each module of the QR code. Use it to zoom in/out your QR code. You can draw QR code by clicking the square in the QR canvas which has been provided. Each square represents one module/pixel in QR code with its respective colors. Each color representation can be seen in the following image. Red color modules are fixed pattern. Therefore, they can't be edited.Blue color modules can be edited by clicking the blue area and you will be prompted with a dialog to set Format Information pattern there. Also, by editing only one part of format information, the other parts will change themselves automatically. Further details about Painter and drawing QR code will be explained in the next section . Decode Mode Decode mode is working mode that used to displays final result of your QR code where you can decode it or export it as image.The image below is the toolbox when Decode mode is active. 1. Module Size : Change size of each module of the QR code. Use it to zoom in/out your QR code. 2. Grey Modules : Option whether you want to show the grey modules or to show them in white color (this doesn't change the main data of the QR code). 3. QR Decoder : Decode your final QR code and read the message. When you decode QR code, you will be prompted a dialog and the decoded message will be shown there. If the dialog show blank message, it means that the QR decoder cannot decode it. You can also save your final result as an image file. Simply right click in the QR code and select Save Image as.. (when using Firefox or Chrome ).","getting-started/drawing-and-decoding-qr-code.html","Drawing and Decoding QR Code"
	],

	["Interface Overview 1. Menu : Main menu where you can create new project, save/load project, use sub-tools, etc.. 2. Mode indicator : The button that lets you switch main workspace mode from Editor mode to Decode mode or otherwise. 3. Main Toolbox : Toolbox that does the core commands (such as draw, erase QR code, or decode QR code) and maintain your workspace. This toolbox will change according to the current workspace mode that being used. 4. Sample toolbox : Toolbox that store your image sample as a replication, to ease in reconstructing QR code. 5. History toolbox : Toolbox that store your drawing history of current QR code, lets you to undo or redo your work. 6. Workspace : Your main canvas to drawing and reconstructing QR code.","getting-started/interface-overview.html","Interface Overview"
	],

	["This section will explain more details about using Painter and other tools in Editor mode. Jump to : - &nbsp; Painter Basic Usage - &nbsp; Format Info Pattern - &nbsp; Undo/Redo using History","editor-painter/index.html","Editor & Painter"
	],

	["Painter Basic Usage (The image of Painter tools) Color Palettes There are three colors to draw data bits of QR code that available in Painter: Black , White , and Grey .Black and white color represent binary value of data bits (black = 1 and white = 0).Then, grey color represents damaged or missing data of QR code.You can switch the active color by clicking color palette you want to activated. Drawing Methods There are two methods that you can use to draw QR code using color palette.First, called Toggling , where you color modules by clicking one by one. In addition, when you color on an already colored module with the same color as your current color palette, it will color alternately between that color and grey color (this only works on black and white palettes).The second is Dragging . This method will let you color modules freely by dragging cursor to the modules you want to color. Flood Fill Besides using the above methods, you can also color modules quickly by using Flood fill . It use the same concept as bucket fill tool that perhaps you have seen in common Paint-like application. It will color all similarly-colored and connected modules. Flood fill is toggleable, and will color according to the currently active color palette.","editor-painter/painter-basic-usage.html","Painter Basic Usage"
	],

	["Format Info Pattern As explained in the previous section , Format information pattern is module pattern that tell about current specification that being used by QR code, that is Error correction level and Mask Pattern .You can set Format information pattern by clicking the blue colored modules and you will be prompted with the dialog as shown below. There are two ways to set Format info pattern. First, simply clicking on module one by one like using Painter. Second, you can select options that located under the modules to set values of Error correction level and Mask pattern and Format info pattern will automatically drawn by itself. These two ways will synchronize with each other automatically.Keep in mind, that Format info pattern only accept black and white color. Thus, grey color (damaged parts) cannot be drawn in here. Just leave it with white color if the actual module is missing or unknown.But, if the whole format info pattern is missing, you can use extension tools called Brute-force Format Info Pattern to automatically find the right pattern. Format info pattern is shared in three location of QR code ( top left , bottom left , and top right ) and always located close to finder pattern. By setting only in one location, will automatically set the other two location.","editor-painter/format-info-pattern.html","Format Info Pattern"
	],

	["Undo/Redo using History You can undo or redo your work by selecting one of history you want to rollback on History toolbox , so that you can jump to any previous states of your work. History in QRazyBox works with following conditions : Any changes of your work (including from Extension tools) will be stored in History. History can only store maximum of 10 states. When maximum is reached, the oldest one will be lost. When creating or loading new project, history will be cleared and start from beginning. Suppose you have history with states named A , B , C , D sequentially. D is your current state. Then, you jump to state B and make changes and thus create new state called E . The state C and D will be lost and overwritten by state E . Therefore, your history list now is: A , B , E .","editor-painter/undo-redo-using-history.html","Undo/Redo using History"
	],

	["Extension Tools Extension Tools are collection of advanced individual tool that helps you analyze and recover your QR code according to the problems that being encountered in your work.You can access these tools by clicking Tools in main menu. QRazyBox provides following extension tools : Extract QR Information Reed-Solomon Decoder Brute-force Format Info Pattern Data Unmasking Padding Bits Recovery","extension-tools/index.html","Extension Tools"],

	["Extract QR Information The best tool as starting point of your work that used to analyzing your QR code.This tool will force decode QR code and then extract information such as: specifications (Version, Error Correction level and Mask Pattern that being used), data sequence, reed-solomon blocks, and decoded message (if possible) from it. Always use this tool first when you trying to recover the unscannable QR code. The big difference between this tool and normal decoder is, when you decoding with normal decoder and find any error on the QR code, the decoder will stop the process (and maybe prints the error message).Whereas, this tool will ignore those errors and continue the decoding process although with rough results. This tool also use the different algorithm to make the process more effective for that purpose. In addition, it will also display the decoding process including the process of error correction and message decoding. Interface 1. Error Correction Log : Option whether you want to show error correction process (Reed-Solomon calculation) or not in the output. 2. Decoding Error : Option whether you want to show decoding error or not in the output. 3. Back to Editor : Close the tool and back to main workspace. 4. Output : Main output that display the result of extracted information from QR code. Reading QR code without Error correction In rare case, you can recover the message from bad damaged QR code just by using this tool, as shown in the following example. It can be happened, since the damaged modules only affect the Reed-Solomon blocks instead of the message. Therefore, by reading the data sequence normally, this tool can still recover the message. *Javascript implementation of this tool was ported from Python script of Strong-QR-Decoder","extension-tools/extract-qr-information.html","Extract QR Information"],

	["Data Masking is a simple tool to mask/unmask (performing XOR operation) modules of your current work according to the specified mask pattern. It can be used when you want to analyze QR code that not masked normally or when the QR code is already unmasked. Selecting this tool will open new dialog and you should select mask pattern from 0 to 7 that you want mask/unmask on your current work.","extension-tools/data-masking.html","Data Masking"],

	["Brute-force Format Info Pattern This tool is very suitable to use when almost all or even the whole modules of format info pattern are unknown or damaged.It will try all possibilities of Format info pattern. Since QR code only has 4 ECC level and 8 Mask pattern, it just needs 32 trials to find the correct one.Though, this condition is very rarely happen to QR code. Brute-force Format Info Pattern is toggleable tool. Which means, it will remain active until you de-activate it or the tool has found the correct pattern.As long as this tool is active, you cannot edit or set the format info pattern.This tool will be executed when you decode the QR code through Decode mode . (The image above displays brute-force result with ECC level H and Mask pattern 2 along with the decoded message) Keep in mind, that it may generate more than one result. You can check all result(s) by clicking the arrow button.","extension-tools/brute-force-format-info-pattern.html","Brute-force Format Info Pattern"],

	["Padding Bits Recovery Padding Bits Recovery is tool that used to recover missing terminator and padding bits of QR code automatically.I assume that you already know about how data encoding works in QR code before using this tool.As we already know that if the message bit string is shorter than the total number of required bits, QR code should be padded with terminator and padding bits until it reach the required number of bits.Terminator always consists of 0 value of their modules and Padding bits always consists of alternate value between 11101100 and 00010001 . Therefore, we can exploit that to automatically recover some missing bits in QR code. This tool can be used when QR code meets the following conditions : It contains at least four values of Terminator ( 0000 ) at the end of message bit string It contains one or more Encoding mode indicator It contains Character count indicator right after encoding mode indicator Otherwise, the tool will throw error when the above conditions are not fulfilled. (The dialog of Padding Bits Recovery. The green-colored modules indicating recovered/affected modules) Tool's Warning In certain cases, this tool can also throw a warning when the recovered modules are overwritting modules that are not grey-colored.When that happen, you have an option to ignore the warning or cancel the operation. Be careful though, overwriting already known modules may cause addition of the Error in QR code.You can undo this operation anytime through History Further details about the implementation of this tool can be seen in the example section .","extension-tools/padding-bits-recovery.html","Padding Bits Recovery"],

	["Reed-Solomon Decoder Reed-Solomon error correction is the error correcting codes that used widely in two-dimensional barcode, including QR code. It allows to correct reading when some of the data is damaged or unreadable.This is the most essential tool of QRazyBox, since our recovery method is very dependent on Reed-Solomon.This tool implements all type of correction process (also known as Reed-Solomon decoding ). Error and Erasure Correction There are three types of correction that used by Reed-Solomon codes: Error correction , Erasure correction and both of Error and Erasure correction .Error correction is type of correction where the errors location are unknown, whereas Erasure correction is type of correction where the errors location are known. Using Error correction , we can correct errors up to half of the number of ECC symbol ( Reed-Solomon blocks ) and correct errors as many as the number of ECC symbol with Erasure correction . Therefore, Error correction become twice as strong when the error location is known.Thus, according to that fact, when we know position of the errors, the capability to restore the data of each ECC level can be doubled.See the following table to see the difference. Error Correction Level % of data that can be restored Without Erasure Correction With Erasure Correction Level L &plusmn; 7% &plusmn; 14% Level M &plusmn; 15% &plusmn; 30% Level Q &plusmn; 25% &plusmn; 50% Level H &plusmn; 30% &plusmn; 60% However, normal QR code scanner doesn't have erasure correction feature, since it difficult to recognize the error locations of QR code automatically and may resulting in slower scan. Example of Reed-Solomon in General Before using this tool, it is better to know how Reed-Solomon works generally. So, we will ignore about QR code for a moment and take a look at the following simple example.Suppose we will encode text \"HELLO WORLD\" to Reed-Solomon block. Convert the text to decimal value : 72,69,76,76,79,32,87,79,82,76,68 Encode with Reed-Solomon using 11 ECC symbol (ECC level Q if in QR code) : 72,69,76,76,79,32,87,79,82,76,68, 123,80,185,183,114,194,10,36,93,160,102 Now, that we have the encoded Reed-Solomon block, we will try to calculate the correction possiblity in various damaged states. According to the ECC symbol that used to encode, we can correct up to 2*e+n , where e is number of error and n is number of erasure.Suppose x as error and ? as erasure 72,69,x,x,x,x,87,79,82,76,68,123,80,185,183,114,194,10,36,93,160,102 (4 errors) &ensp; = &ensp;8 CORRECTABLE 72,69,x,x,x,x,87,79,82,76,68,123,80,185,183,114,x,x,x,93,160,102 (7 errors) &ensp; = &ensp;14 UNCORRECTABLE 72,69,?,?,?,?,87,79,82,76,68,123,80,185,183,114,194,10,36,93,160,102 (4 erasures) &ensp; = &ensp;4 CORRECTABLE 72,69,?,?,?,?,87,79,82,76,68,123,80,185,183,114,?,?,?,93,160,102 (7 erasures) &ensp; = &ensp;7 CORRECTABLE ?,?,?,?,?,?,87,?,?,76,68,123,80,185,183,114,?,?,?,?,160,102 (12 erasures) &ensp; = &ensp;12 UNCORRECTABLE 72,69,x,x,x,x,87,79,82,76,68,123,80,185,183,114,?,?,?,93,160,102 (4 errors &amp; 3 erasures) &ensp; = &ensp;11 CORRECTABLE Basic Usage When you use Reed-Solomon Decoder, you will be prompted by dialog. There will be total 2 page of dialog, for input and output. Although, this tool will input the Reed-Solomon blocks automatically, but you can edit and enter manually if you want to.You also don't have to input number of ECC symbol and even the error position/location, since this tool will automatically detect from the QR code that you already drawn before (zero values of Reed-Solomon blocks will be treated as error position). Keep in mind, that Reed-Solomon block can also consist more than one on a larger QR code.The second page of the dialog will display output such as decoded Reed-Solomon blocks and the final message from QR code. Jump to examples section to see the further details about using Reed-Solomon Decoder.","extension-tools/reed-solomon-decoder.html","Reed-Solomon Decoder"],

	["Examples This section will contain some examples that explain how to recover QR code step by step. These examples was created in such a way to make explanation about usage of the used tools is easy to understand. List of examples : Basic Example Advanced Example","examples/index.html","Examples"],

	["Basic Example In this example, we are going to recover the following QR code. Of course, we cannot scan it normally, because it lost too much modules including Finder and Alignment pattern.The first step is to reconstruct it with Painter manually (we cannot import it as image since its Finder and Alignment pattern are missing). (Reconstructed QR code using Painter) The next step is to set the Format Info Pattern. Because the known modules of format info pattern only located in top right corner, the easiest way to reconstruct it is to try the pattern one by one and check whether it's match or not. (The most suitable pattern is ECC level M and Mask pattern 1) Now we have reconstructed QR code in our Editor and the missing Finder along with Alignment pattern are recovered. Still, we can't decode it using normal Decoder because it's to much damaged for Error level M to be corrected. So, we should recover more modules of this QR code.The next step, analyze the QR code using Extract QR Information . Using that tool, give us the following result. We got the decoded message, but it rather unreadable and seems broken. We can ignore that for a moment.Pay attention to the Number of missing bytes . It said that our QR code have 39 bytes of its data missing. Meanwhile, to correcting Erasure with Reed-Solomon, the maximum number of missing bytes in ECC level M version 3 should be about 26 . Therefore, we should recover some modules until the missing bytes are dropped about 26 bytes or less. The next step, we will try recover padding bits using Padding Bits Recovery .Luckily, our padding bits in this QR code was quite big and we successfully recovered almost half of the damaged parts.Checking again with Extract QR Information , we dropped number of missing bytes to 25 bytes (35.71%) . Also, the final part of messsage become more readable than before ( EVERYTHING from EVERYTHIMY ).QR code version 3 with ECC level M have 26 of the ECC symbol, and since our number of missing bytes is 25, we can apply Erasure correction to the current QR code (remember from previous section that we can correct Errors half of the ECC symbol and Erasures as many as the ECC symbol ).Using Reed-Solomon Decoder , we successfully recover the message. And finally, we got the final message : \"YOU CAN DO ANYTHING BUT NOT EVERYTHING\" . *This example concept inspired from MMA CTF 2015 challenge and the solving concept from https://github.com/pwning/public-writeup/blob/master/mma2015/misc400-qr/writeup.md","examples/basic-example.html","Basic Example"],

	["Here are some sample of QR code that can be used to practice using QRazyBox. Access to /sample directory if you run this on computer locally to quickly browse these samples.","misc/qr-code-samples.html","QR Code Samples"],

	["This is list of shortcut keys that can be used as alternate way to do various commands. Q   : Black color palette W   : White color palette E   : Grey color palette G   : Toggle flood fill  -   : Zoom out (-5px module size) =   : Zoom in (+5px module size)  Z   : Undo (move to previous history) X   : Redo (move to next history)  TAB   : Switch working mode","misc/shortcut-keys.html","Shortcut Keys"]
];