/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "./node_modules/alpinejs/dist/alpine.js":
/*!**********************************************!*\
  !*** ./node_modules/alpinejs/dist/alpine.js ***!
  \**********************************************/
/***/ (function(module) {

(function (global, factory) {
   true ? module.exports = factory() :
  0;
}(this, (function () { 'use strict';

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, {
        value: value,
        enumerable: true,
        configurable: true,
        writable: true
      });
    } else {
      obj[key] = value;
    }

    return obj;
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);

    if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);
      if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });
      keys.push.apply(keys, symbols);
    }

    return keys;
  }

  function _objectSpread2(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};

      if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }

    return target;
  }

  // Thanks @stimulus:
  // https://github.com/stimulusjs/stimulus/blob/master/packages/%40stimulus/core/src/application.ts
  function domReady() {
    return new Promise(resolve => {
      if (document.readyState == "loading") {
        document.addEventListener("DOMContentLoaded", resolve);
      } else {
        resolve();
      }
    });
  }
  function arrayUnique(array) {
    return Array.from(new Set(array));
  }
  function isTesting() {
    return navigator.userAgent.includes("Node.js") || navigator.userAgent.includes("jsdom");
  }
  function checkedAttrLooseCompare(valueA, valueB) {
    return valueA == valueB;
  }
  function warnIfMalformedTemplate(el, directive) {
    if (el.tagName.toLowerCase() !== 'template') {
      console.warn(`Alpine: [${directive}] directive should only be added to <template> tags. See https://github.com/alpinejs/alpine#${directive}`);
    } else if (el.content.childElementCount !== 1) {
      console.warn(`Alpine: <template> tag with [${directive}] encountered with multiple element roots. Make sure <template> only has a single child element.`);
    }
  }
  function kebabCase(subject) {
    return subject.replace(/([a-z])([A-Z])/g, '$1-$2').replace(/[_\s]/, '-').toLowerCase();
  }
  function camelCase(subject) {
    return subject.toLowerCase().replace(/-(\w)/g, (match, char) => char.toUpperCase());
  }
  function walk(el, callback) {
    if (callback(el) === false) return;
    let node = el.firstElementChild;

    while (node) {
      walk(node, callback);
      node = node.nextElementSibling;
    }
  }
  function debounce(func, wait) {
    var timeout;
    return function () {
      var context = this,
          args = arguments;

      var later = function later() {
        timeout = null;
        func.apply(context, args);
      };

      clearTimeout(timeout);
      timeout = setTimeout(later, wait);
    };
  }

  const handleError = (el, expression, error) => {
    console.warn(`Alpine Error: "${error}"\n\nExpression: "${expression}"\nElement:`, el);

    if (!isTesting()) {
      throw error;
    }
  };

  function tryCatch(cb, {
    el,
    expression
  }) {
    try {
      const value = cb();
      return value instanceof Promise ? value.catch(e => handleError(el, expression, e)) : value;
    } catch (e) {
      handleError(el, expression, e);
    }
  }

  function saferEval(el, expression, dataContext, additionalHelperVariables = {}) {
    return tryCatch(() => {
      if (typeof expression === 'function') {
        return expression.call(dataContext);
      }

      return new Function(['$data', ...Object.keys(additionalHelperVariables)], `var __alpine_result; with($data) { __alpine_result = ${expression} }; return __alpine_result`)(dataContext, ...Object.values(additionalHelperVariables));
    }, {
      el,
      expression
    });
  }
  function saferEvalNoReturn(el, expression, dataContext, additionalHelperVariables = {}) {
    return tryCatch(() => {
      if (typeof expression === 'function') {
        return Promise.resolve(expression.call(dataContext, additionalHelperVariables['$event']));
      }

      let AsyncFunction = Function;
      /* MODERN-ONLY:START */

      AsyncFunction = Object.getPrototypeOf(async function () {}).constructor;
      /* MODERN-ONLY:END */
      // For the cases when users pass only a function reference to the caller: `x-on:click="foo"`
      // Where "foo" is a function. Also, we'll pass the function the event instance when we call it.

      if (Object.keys(dataContext).includes(expression)) {
        let methodReference = new Function(['dataContext', ...Object.keys(additionalHelperVariables)], `with(dataContext) { return ${expression} }`)(dataContext, ...Object.values(additionalHelperVariables));

        if (typeof methodReference === 'function') {
          return Promise.resolve(methodReference.call(dataContext, additionalHelperVariables['$event']));
        } else {
          return Promise.resolve();
        }
      }

      return Promise.resolve(new AsyncFunction(['dataContext', ...Object.keys(additionalHelperVariables)], `with(dataContext) { ${expression} }`)(dataContext, ...Object.values(additionalHelperVariables)));
    }, {
      el,
      expression
    });
  }
  const xAttrRE = /^x-(on|bind|data|text|html|model|if|for|show|cloak|transition|ref|spread)\b/;
  function isXAttr(attr) {
    const name = replaceAtAndColonWithStandardSyntax(attr.name);
    return xAttrRE.test(name);
  }
  function getXAttrs(el, component, type) {
    let directives = Array.from(el.attributes).filter(isXAttr).map(parseHtmlAttribute); // Get an object of directives from x-spread.

    let spreadDirective = directives.filter(directive => directive.type === 'spread')[0];

    if (spreadDirective) {
      let spreadObject = saferEval(el, spreadDirective.expression, component.$data); // Add x-spread directives to the pile of existing directives.

      directives = directives.concat(Object.entries(spreadObject).map(([name, value]) => parseHtmlAttribute({
        name,
        value
      })));
    }

    if (type) return directives.filter(i => i.type === type);
    return sortDirectives(directives);
  }

  function sortDirectives(directives) {
    let directiveOrder = ['bind', 'model', 'show', 'catch-all'];
    return directives.sort((a, b) => {
      let typeA = directiveOrder.indexOf(a.type) === -1 ? 'catch-all' : a.type;
      let typeB = directiveOrder.indexOf(b.type) === -1 ? 'catch-all' : b.type;
      return directiveOrder.indexOf(typeA) - directiveOrder.indexOf(typeB);
    });
  }

  function parseHtmlAttribute({
    name,
    value
  }) {
    const normalizedName = replaceAtAndColonWithStandardSyntax(name);
    const typeMatch = normalizedName.match(xAttrRE);
    const valueMatch = normalizedName.match(/:([a-zA-Z0-9\-:]+)/);
    const modifiers = normalizedName.match(/\.[^.\]]+(?=[^\]]*$)/g) || [];
    return {
      type: typeMatch ? typeMatch[1] : null,
      value: valueMatch ? valueMatch[1] : null,
      modifiers: modifiers.map(i => i.replace('.', '')),
      expression: value
    };
  }
  function isBooleanAttr(attrName) {
    // As per HTML spec table https://html.spec.whatwg.org/multipage/indices.html#attributes-3:boolean-attribute
    // Array roughly ordered by estimated usage
    const booleanAttributes = ['disabled', 'checked', 'required', 'readonly', 'hidden', 'open', 'selected', 'autofocus', 'itemscope', 'multiple', 'novalidate', 'allowfullscreen', 'allowpaymentrequest', 'formnovalidate', 'autoplay', 'controls', 'loop', 'muted', 'playsinline', 'default', 'ismap', 'reversed', 'async', 'defer', 'nomodule'];
    return booleanAttributes.includes(attrName);
  }
  function replaceAtAndColonWithStandardSyntax(name) {
    if (name.startsWith('@')) {
      return name.replace('@', 'x-on:');
    } else if (name.startsWith(':')) {
      return name.replace(':', 'x-bind:');
    }

    return name;
  }
  function convertClassStringToArray(classList, filterFn = Boolean) {
    return classList.split(' ').filter(filterFn);
  }
  const TRANSITION_TYPE_IN = 'in';
  const TRANSITION_TYPE_OUT = 'out';
  const TRANSITION_CANCELLED = 'cancelled';
  function transitionIn(el, show, reject, component, forceSkip = false) {
    // We don't want to transition on the initial page load.
    if (forceSkip) return show();

    if (el.__x_transition && el.__x_transition.type === TRANSITION_TYPE_IN) {
      // there is already a similar transition going on, this was probably triggered by
      // a change in a different property, let's just leave the previous one doing its job
      return;
    }

    const attrs = getXAttrs(el, component, 'transition');
    const showAttr = getXAttrs(el, component, 'show')[0]; // If this is triggered by a x-show.transition.

    if (showAttr && showAttr.modifiers.includes('transition')) {
      let modifiers = showAttr.modifiers; // If x-show.transition.out, we'll skip the "in" transition.

      if (modifiers.includes('out') && !modifiers.includes('in')) return show();
      const settingBothSidesOfTransition = modifiers.includes('in') && modifiers.includes('out'); // If x-show.transition.in...out... only use "in" related modifiers for this transition.

      modifiers = settingBothSidesOfTransition ? modifiers.filter((i, index) => index < modifiers.indexOf('out')) : modifiers;
      transitionHelperIn(el, modifiers, show, reject); // Otherwise, we can assume x-transition:enter.
    } else if (attrs.some(attr => ['enter', 'enter-start', 'enter-end'].includes(attr.value))) {
      transitionClassesIn(el, component, attrs, show, reject);
    } else {
      // If neither, just show that damn thing.
      show();
    }
  }
  function transitionOut(el, hide, reject, component, forceSkip = false) {
    // We don't want to transition on the initial page load.
    if (forceSkip) return hide();

    if (el.__x_transition && el.__x_transition.type === TRANSITION_TYPE_OUT) {
      // there is already a similar transition going on, this was probably triggered by
      // a change in a different property, let's just leave the previous one doing its job
      return;
    }

    const attrs = getXAttrs(el, component, 'transition');
    const showAttr = getXAttrs(el, component, 'show')[0];

    if (showAttr && showAttr.modifiers.includes('transition')) {
      let modifiers = showAttr.modifiers;
      if (modifiers.includes('in') && !modifiers.includes('out')) return hide();
      const settingBothSidesOfTransition = modifiers.includes('in') && modifiers.includes('out');
      modifiers = settingBothSidesOfTransition ? modifiers.filter((i, index) => index > modifiers.indexOf('out')) : modifiers;
      transitionHelperOut(el, modifiers, settingBothSidesOfTransition, hide, reject);
    } else if (attrs.some(attr => ['leave', 'leave-start', 'leave-end'].includes(attr.value))) {
      transitionClassesOut(el, component, attrs, hide, reject);
    } else {
      hide();
    }
  }
  function transitionHelperIn(el, modifiers, showCallback, reject) {
    // Default values inspired by: https://material.io/design/motion/speed.html#duration
    const styleValues = {
      duration: modifierValue(modifiers, 'duration', 150),
      origin: modifierValue(modifiers, 'origin', 'center'),
      first: {
        opacity: 0,
        scale: modifierValue(modifiers, 'scale', 95)
      },
      second: {
        opacity: 1,
        scale: 100
      }
    };
    transitionHelper(el, modifiers, showCallback, () => {}, reject, styleValues, TRANSITION_TYPE_IN);
  }
  function transitionHelperOut(el, modifiers, settingBothSidesOfTransition, hideCallback, reject) {
    // Make the "out" transition .5x slower than the "in". (Visually better)
    // HOWEVER, if they explicitly set a duration for the "out" transition,
    // use that.
    const duration = settingBothSidesOfTransition ? modifierValue(modifiers, 'duration', 150) : modifierValue(modifiers, 'duration', 150) / 2;
    const styleValues = {
      duration: duration,
      origin: modifierValue(modifiers, 'origin', 'center'),
      first: {
        opacity: 1,
        scale: 100
      },
      second: {
        opacity: 0,
        scale: modifierValue(modifiers, 'scale', 95)
      }
    };
    transitionHelper(el, modifiers, () => {}, hideCallback, reject, styleValues, TRANSITION_TYPE_OUT);
  }

  function modifierValue(modifiers, key, fallback) {
    // If the modifier isn't present, use the default.
    if (modifiers.indexOf(key) === -1) return fallback; // If it IS present, grab the value after it: x-show.transition.duration.500ms

    const rawValue = modifiers[modifiers.indexOf(key) + 1];
    if (!rawValue) return fallback;

    if (key === 'scale') {
      // Check if the very next value is NOT a number and return the fallback.
      // If x-show.transition.scale, we'll use the default scale value.
      // That is how a user opts out of the opacity transition.
      if (!isNumeric(rawValue)) return fallback;
    }

    if (key === 'duration') {
      // Support x-show.transition.duration.500ms && duration.500
      let match = rawValue.match(/([0-9]+)ms/);
      if (match) return match[1];
    }

    if (key === 'origin') {
      // Support chaining origin directions: x-show.transition.top.right
      if (['top', 'right', 'left', 'center', 'bottom'].includes(modifiers[modifiers.indexOf(key) + 2])) {
        return [rawValue, modifiers[modifiers.indexOf(key) + 2]].join(' ');
      }
    }

    return rawValue;
  }

  function transitionHelper(el, modifiers, hook1, hook2, reject, styleValues, type) {
    // clear the previous transition if exists to avoid caching the wrong styles
    if (el.__x_transition) {
      el.__x_transition.cancel && el.__x_transition.cancel();
    } // If the user set these style values, we'll put them back when we're done with them.


    const opacityCache = el.style.opacity;
    const transformCache = el.style.transform;
    const transformOriginCache = el.style.transformOrigin; // If no modifiers are present: x-show.transition, we'll default to both opacity and scale.

    const noModifiers = !modifiers.includes('opacity') && !modifiers.includes('scale');
    const transitionOpacity = noModifiers || modifiers.includes('opacity');
    const transitionScale = noModifiers || modifiers.includes('scale'); // These are the explicit stages of a transition (same stages for in and for out).
    // This way you can get a birds eye view of the hooks, and the differences
    // between them.

    const stages = {
      start() {
        if (transitionOpacity) el.style.opacity = styleValues.first.opacity;
        if (transitionScale) el.style.transform = `scale(${styleValues.first.scale / 100})`;
      },

      during() {
        if (transitionScale) el.style.transformOrigin = styleValues.origin;
        el.style.transitionProperty = [transitionOpacity ? `opacity` : ``, transitionScale ? `transform` : ``].join(' ').trim();
        el.style.transitionDuration = `${styleValues.duration / 1000}s`;
        el.style.transitionTimingFunction = `cubic-bezier(0.4, 0.0, 0.2, 1)`;
      },

      show() {
        hook1();
      },

      end() {
        if (transitionOpacity) el.style.opacity = styleValues.second.opacity;
        if (transitionScale) el.style.transform = `scale(${styleValues.second.scale / 100})`;
      },

      hide() {
        hook2();
      },

      cleanup() {
        if (transitionOpacity) el.style.opacity = opacityCache;
        if (transitionScale) el.style.transform = transformCache;
        if (transitionScale) el.style.transformOrigin = transformOriginCache;
        el.style.transitionProperty = null;
        el.style.transitionDuration = null;
        el.style.transitionTimingFunction = null;
      }

    };
    transition(el, stages, type, reject);
  }

  const ensureStringExpression = (expression, el, component) => {
    return typeof expression === 'function' ? component.evaluateReturnExpression(el, expression) : expression;
  };

  function transitionClassesIn(el, component, directives, showCallback, reject) {
    const enter = convertClassStringToArray(ensureStringExpression((directives.find(i => i.value === 'enter') || {
      expression: ''
    }).expression, el, component));
    const enterStart = convertClassStringToArray(ensureStringExpression((directives.find(i => i.value === 'enter-start') || {
      expression: ''
    }).expression, el, component));
    const enterEnd = convertClassStringToArray(ensureStringExpression((directives.find(i => i.value === 'enter-end') || {
      expression: ''
    }).expression, el, component));
    transitionClasses(el, enter, enterStart, enterEnd, showCallback, () => {}, TRANSITION_TYPE_IN, reject);
  }
  function transitionClassesOut(el, component, directives, hideCallback, reject) {
    const leave = convertClassStringToArray(ensureStringExpression((directives.find(i => i.value === 'leave') || {
      expression: ''
    }).expression, el, component));
    const leaveStart = convertClassStringToArray(ensureStringExpression((directives.find(i => i.value === 'leave-start') || {
      expression: ''
    }).expression, el, component));
    const leaveEnd = convertClassStringToArray(ensureStringExpression((directives.find(i => i.value === 'leave-end') || {
      expression: ''
    }).expression, el, component));
    transitionClasses(el, leave, leaveStart, leaveEnd, () => {}, hideCallback, TRANSITION_TYPE_OUT, reject);
  }
  function transitionClasses(el, classesDuring, classesStart, classesEnd, hook1, hook2, type, reject) {
    // clear the previous transition if exists to avoid caching the wrong classes
    if (el.__x_transition) {
      el.__x_transition.cancel && el.__x_transition.cancel();
    }

    const originalClasses = el.__x_original_classes || [];
    const stages = {
      start() {
        el.classList.add(...classesStart);
      },

      during() {
        el.classList.add(...classesDuring);
      },

      show() {
        hook1();
      },

      end() {
        // Don't remove classes that were in the original class attribute.
        el.classList.remove(...classesStart.filter(i => !originalClasses.includes(i)));
        el.classList.add(...classesEnd);
      },

      hide() {
        hook2();
      },

      cleanup() {
        el.classList.remove(...classesDuring.filter(i => !originalClasses.includes(i)));
        el.classList.remove(...classesEnd.filter(i => !originalClasses.includes(i)));
      }

    };
    transition(el, stages, type, reject);
  }
  function transition(el, stages, type, reject) {
    const finish = once(() => {
      stages.hide(); // Adding an "isConnected" check, in case the callback
      // removed the element from the DOM.

      if (el.isConnected) {
        stages.cleanup();
      }

      delete el.__x_transition;
    });
    el.__x_transition = {
      // Set transition type so we can avoid clearing transition if the direction is the same
      type: type,
      // create a callback for the last stages of the transition so we can call it
      // from different point and early terminate it. Once will ensure that function
      // is only called one time.
      cancel: once(() => {
        reject(TRANSITION_CANCELLED);
        finish();
      }),
      finish,
      // This store the next animation frame so we can cancel it
      nextFrame: null
    };
    stages.start();
    stages.during();
    el.__x_transition.nextFrame = requestAnimationFrame(() => {
      // Note: Safari's transitionDuration property will list out comma separated transition durations
      // for every single transition property. Let's grab the first one and call it a day.
      let duration = Number(getComputedStyle(el).transitionDuration.replace(/,.*/, '').replace('s', '')) * 1000;

      if (duration === 0) {
        duration = Number(getComputedStyle(el).animationDuration.replace('s', '')) * 1000;
      }

      stages.show();
      el.__x_transition.nextFrame = requestAnimationFrame(() => {
        stages.end();
        setTimeout(el.__x_transition.finish, duration);
      });
    });
  }
  function isNumeric(subject) {
    return !Array.isArray(subject) && !isNaN(subject);
  } // Thanks @vuejs
  // https://github.com/vuejs/vue/blob/4de4649d9637262a9b007720b59f80ac72a5620c/src/shared/util.js

  function once(callback) {
    let called = false;
    return function () {
      if (!called) {
        called = true;
        callback.apply(this, arguments);
      }
    };
  }

  function handleForDirective(component, templateEl, expression, initialUpdate, extraVars) {
    warnIfMalformedTemplate(templateEl, 'x-for');
    let iteratorNames = typeof expression === 'function' ? parseForExpression(component.evaluateReturnExpression(templateEl, expression)) : parseForExpression(expression);
    let items = evaluateItemsAndReturnEmptyIfXIfIsPresentAndFalseOnElement(component, templateEl, iteratorNames, extraVars); // As we walk the array, we'll also walk the DOM (updating/creating as we go).

    let currentEl = templateEl;
    items.forEach((item, index) => {
      let iterationScopeVariables = getIterationScopeVariables(iteratorNames, item, index, items, extraVars());
      let currentKey = generateKeyForIteration(component, templateEl, index, iterationScopeVariables);
      let nextEl = lookAheadForMatchingKeyedElementAndMoveItIfFound(currentEl.nextElementSibling, currentKey); // If we haven't found a matching key, insert the element at the current position.

      if (!nextEl) {
        nextEl = addElementInLoopAfterCurrentEl(templateEl, currentEl); // And transition it in if it's not the first page load.

        transitionIn(nextEl, () => {}, () => {}, component, initialUpdate);
        nextEl.__x_for = iterationScopeVariables;
        component.initializeElements(nextEl, () => nextEl.__x_for); // Otherwise update the element we found.
      } else {
        // Temporarily remove the key indicator to allow the normal "updateElements" to work.
        delete nextEl.__x_for_key;
        nextEl.__x_for = iterationScopeVariables;
        component.updateElements(nextEl, () => nextEl.__x_for);
      }

      currentEl = nextEl;
      currentEl.__x_for_key = currentKey;
    });
    removeAnyLeftOverElementsFromPreviousUpdate(currentEl, component);
  } // This was taken from VueJS 2.* core. Thanks Vue!

  function parseForExpression(expression) {
    let forIteratorRE = /,([^,\}\]]*)(?:,([^,\}\]]*))?$/;
    let stripParensRE = /^\(|\)$/g;
    let forAliasRE = /([\s\S]*?)\s+(?:in|of)\s+([\s\S]*)/;
    let inMatch = expression.match(forAliasRE);
    if (!inMatch) return;
    let res = {};
    res.items = inMatch[2].trim();
    let item = inMatch[1].trim().replace(stripParensRE, '');
    let iteratorMatch = item.match(forIteratorRE);

    if (iteratorMatch) {
      res.item = item.replace(forIteratorRE, '').trim();
      res.index = iteratorMatch[1].trim();

      if (iteratorMatch[2]) {
        res.collection = iteratorMatch[2].trim();
      }
    } else {
      res.item = item;
    }

    return res;
  }

  function getIterationScopeVariables(iteratorNames, item, index, items, extraVars) {
    // We must create a new object, so each iteration has a new scope
    let scopeVariables = extraVars ? _objectSpread2({}, extraVars) : {};
    scopeVariables[iteratorNames.item] = item;
    if (iteratorNames.index) scopeVariables[iteratorNames.index] = index;
    if (iteratorNames.collection) scopeVariables[iteratorNames.collection] = items;
    return scopeVariables;
  }

  function generateKeyForIteration(component, el, index, iterationScopeVariables) {
    let bindKeyAttribute = getXAttrs(el, component, 'bind').filter(attr => attr.value === 'key')[0]; // If the dev hasn't specified a key, just return the index of the iteration.

    if (!bindKeyAttribute) return index;
    return component.evaluateReturnExpression(el, bindKeyAttribute.expression, () => iterationScopeVariables);
  }

  function evaluateItemsAndReturnEmptyIfXIfIsPresentAndFalseOnElement(component, el, iteratorNames, extraVars) {
    let ifAttribute = getXAttrs(el, component, 'if')[0];

    if (ifAttribute && !component.evaluateReturnExpression(el, ifAttribute.expression)) {
      return [];
    }

    let items = component.evaluateReturnExpression(el, iteratorNames.items, extraVars); // This adds support for the `i in n` syntax.

    if (isNumeric(items) && items > 0) {
      items = Array.from(Array(items).keys(), i => i + 1);
    }

    return items;
  }

  function addElementInLoopAfterCurrentEl(templateEl, currentEl) {
    let clone = document.importNode(templateEl.content, true);
    currentEl.parentElement.insertBefore(clone, currentEl.nextElementSibling);
    return currentEl.nextElementSibling;
  }

  function lookAheadForMatchingKeyedElementAndMoveItIfFound(nextEl, currentKey) {
    if (!nextEl) return; // If we are already past the x-for generated elements, we don't need to look ahead.

    if (nextEl.__x_for_key === undefined) return; // If the the key's DO match, no need to look ahead.

    if (nextEl.__x_for_key === currentKey) return nextEl; // If they don't, we'll look ahead for a match.
    // If we find it, we'll move it to the current position in the loop.

    let tmpNextEl = nextEl;

    while (tmpNextEl) {
      if (tmpNextEl.__x_for_key === currentKey) {
        return tmpNextEl.parentElement.insertBefore(tmpNextEl, nextEl);
      }

      tmpNextEl = tmpNextEl.nextElementSibling && tmpNextEl.nextElementSibling.__x_for_key !== undefined ? tmpNextEl.nextElementSibling : false;
    }
  }

  function removeAnyLeftOverElementsFromPreviousUpdate(currentEl, component) {
    var nextElementFromOldLoop = currentEl.nextElementSibling && currentEl.nextElementSibling.__x_for_key !== undefined ? currentEl.nextElementSibling : false;

    while (nextElementFromOldLoop) {
      let nextElementFromOldLoopImmutable = nextElementFromOldLoop;
      let nextSibling = nextElementFromOldLoop.nextElementSibling;
      transitionOut(nextElementFromOldLoop, () => {
        nextElementFromOldLoopImmutable.remove();
      }, () => {}, component);
      nextElementFromOldLoop = nextSibling && nextSibling.__x_for_key !== undefined ? nextSibling : false;
    }
  }

  function handleAttributeBindingDirective(component, el, attrName, expression, extraVars, attrType, modifiers) {
    var value = component.evaluateReturnExpression(el, expression, extraVars);

    if (attrName === 'value') {
      if (Alpine.ignoreFocusedForValueBinding && document.activeElement.isSameNode(el)) return; // If nested model key is undefined, set the default value to empty string.

      if (value === undefined && expression.match(/\./)) {
        value = '';
      }

      if (el.type === 'radio') {
        // Set radio value from x-bind:value, if no "value" attribute exists.
        // If there are any initial state values, radio will have a correct
        // "checked" value since x-bind:value is processed before x-model.
        if (el.attributes.value === undefined && attrType === 'bind') {
          el.value = value;
        } else if (attrType !== 'bind') {
          el.checked = checkedAttrLooseCompare(el.value, value);
        }
      } else if (el.type === 'checkbox') {
        // If we are explicitly binding a string to the :value, set the string,
        // If the value is a boolean, leave it alone, it will be set to "on"
        // automatically.
        if (typeof value !== 'boolean' && ![null, undefined].includes(value) && attrType === 'bind') {
          el.value = String(value);
        } else if (attrType !== 'bind') {
          if (Array.isArray(value)) {
            // I'm purposely not using Array.includes here because it's
            // strict, and because of Numeric/String mis-casting, I
            // want the "includes" to be "fuzzy".
            el.checked = value.some(val => checkedAttrLooseCompare(val, el.value));
          } else {
            el.checked = !!value;
          }
        }
      } else if (el.tagName === 'SELECT') {
        updateSelect(el, value);
      } else {
        if (el.value === value) return;
        el.value = value;
      }
    } else if (attrName === 'class') {
      if (Array.isArray(value)) {
        const originalClasses = el.__x_original_classes || [];
        el.setAttribute('class', arrayUnique(originalClasses.concat(value)).join(' '));
      } else if (typeof value === 'object') {
        // Sorting the keys / class names by their boolean value will ensure that
        // anything that evaluates to `false` and needs to remove classes is run first.
        const keysSortedByBooleanValue = Object.keys(value).sort((a, b) => value[a] - value[b]);
        keysSortedByBooleanValue.forEach(classNames => {
          if (value[classNames]) {
            convertClassStringToArray(classNames).forEach(className => el.classList.add(className));
          } else {
            convertClassStringToArray(classNames).forEach(className => el.classList.remove(className));
          }
        });
      } else {
        const originalClasses = el.__x_original_classes || [];
        const newClasses = value ? convertClassStringToArray(value) : [];
        el.setAttribute('class', arrayUnique(originalClasses.concat(newClasses)).join(' '));
      }
    } else {
      attrName = modifiers.includes('camel') ? camelCase(attrName) : attrName; // If an attribute's bound value is null, undefined or false, remove the attribute

      if ([null, undefined, false].includes(value)) {
        el.removeAttribute(attrName);
      } else {
        isBooleanAttr(attrName) ? setIfChanged(el, attrName, attrName) : setIfChanged(el, attrName, value);
      }
    }
  }

  function setIfChanged(el, attrName, value) {
    if (el.getAttribute(attrName) != value) {
      el.setAttribute(attrName, value);
    }
  }

  function updateSelect(el, value) {
    const arrayWrappedValue = [].concat(value).map(value => {
      return value + '';
    });
    Array.from(el.options).forEach(option => {
      option.selected = arrayWrappedValue.includes(option.value || option.text);
    });
  }

  function handleTextDirective(el, output, expression) {
    // If nested model key is undefined, set the default value to empty string.
    if (output === undefined && expression.match(/\./)) {
      output = '';
    }

    el.textContent = output;
  }

  function handleHtmlDirective(component, el, expression, extraVars) {
    el.innerHTML = component.evaluateReturnExpression(el, expression, extraVars);
  }

  function handleShowDirective(component, el, value, modifiers, initialUpdate = false) {
    const hide = () => {
      el.style.display = 'none';
      el.__x_is_shown = false;
    };

    const show = () => {
      if (el.style.length === 1 && el.style.display === 'none') {
        el.removeAttribute('style');
      } else {
        el.style.removeProperty('display');
      }

      el.__x_is_shown = true;
    };

    if (initialUpdate === true) {
      if (value) {
        show();
      } else {
        hide();
      }

      return;
    }

    const handle = (resolve, reject) => {
      if (value) {
        if (el.style.display === 'none' || el.__x_transition) {
          transitionIn(el, () => {
            show();
          }, reject, component);
        }

        resolve(() => {});
      } else {
        if (el.style.display !== 'none') {
          transitionOut(el, () => {
            resolve(() => {
              hide();
            });
          }, reject, component);
        } else {
          resolve(() => {});
        }
      }
    }; // The working of x-show is a bit complex because we need to
    // wait for any child transitions to finish before hiding
    // some element. Also, this has to be done recursively.
    // If x-show.immediate, foregoe the waiting.


    if (modifiers.includes('immediate')) {
      handle(finish => finish(), () => {});
      return;
    } // x-show is encountered during a DOM tree walk. If an element
    // we encounter is NOT a child of another x-show element we
    // can execute the previous x-show stack (if one exists).


    if (component.showDirectiveLastElement && !component.showDirectiveLastElement.contains(el)) {
      component.executeAndClearRemainingShowDirectiveStack();
    }

    component.showDirectiveStack.push(handle);
    component.showDirectiveLastElement = el;
  }

  function handleIfDirective(component, el, expressionResult, initialUpdate, extraVars) {
    warnIfMalformedTemplate(el, 'x-if');
    const elementHasAlreadyBeenAdded = el.nextElementSibling && el.nextElementSibling.__x_inserted_me === true;

    if (expressionResult && (!elementHasAlreadyBeenAdded || el.__x_transition)) {
      const clone = document.importNode(el.content, true);
      el.parentElement.insertBefore(clone, el.nextElementSibling);
      transitionIn(el.nextElementSibling, () => {}, () => {}, component, initialUpdate);
      component.initializeElements(el.nextElementSibling, extraVars);
      el.nextElementSibling.__x_inserted_me = true;
    } else if (!expressionResult && elementHasAlreadyBeenAdded) {
      transitionOut(el.nextElementSibling, () => {
        el.nextElementSibling.remove();
      }, () => {}, component, initialUpdate);
    }
  }

  function registerListener(component, el, event, modifiers, expression, extraVars = {}) {
    const options = {
      passive: modifiers.includes('passive')
    };

    if (modifiers.includes('camel')) {
      event = camelCase(event);
    }

    if (modifiers.includes('away')) {
      let handler = e => {
        // Don't do anything if the click came from the element or within it.
        if (el.contains(e.target)) return; // Don't do anything if this element isn't currently visible.

        if (el.offsetWidth < 1 && el.offsetHeight < 1) return; // Now that we are sure the element is visible, AND the click
        // is from outside it, let's run the expression.

        runListenerHandler(component, expression, e, extraVars);

        if (modifiers.includes('once')) {
          document.removeEventListener(event, handler, options);
        }
      }; // Listen for this event at the root level.


      document.addEventListener(event, handler, options);
    } else {
      let listenerTarget = modifiers.includes('window') ? window : modifiers.includes('document') ? document : el;

      let handler = e => {
        // Remove this global event handler if the element that declared it
        // has been removed. It's now stale.
        if (listenerTarget === window || listenerTarget === document) {
          if (!document.body.contains(el)) {
            listenerTarget.removeEventListener(event, handler, options);
            return;
          }
        }

        if (isKeyEvent(event)) {
          if (isListeningForASpecificKeyThatHasntBeenPressed(e, modifiers)) {
            return;
          }
        }

        if (modifiers.includes('prevent')) e.preventDefault();
        if (modifiers.includes('stop')) e.stopPropagation(); // If the .self modifier isn't present, or if it is present and
        // the target element matches the element we are registering the
        // event on, run the handler

        if (!modifiers.includes('self') || e.target === el) {
          const returnValue = runListenerHandler(component, expression, e, extraVars);
          returnValue.then(value => {
            if (value === false) {
              e.preventDefault();
            } else {
              if (modifiers.includes('once')) {
                listenerTarget.removeEventListener(event, handler, options);
              }
            }
          });
        }
      };

      if (modifiers.includes('debounce')) {
        let nextModifier = modifiers[modifiers.indexOf('debounce') + 1] || 'invalid-wait';
        let wait = isNumeric(nextModifier.split('ms')[0]) ? Number(nextModifier.split('ms')[0]) : 250;
        handler = debounce(handler, wait);
      }

      listenerTarget.addEventListener(event, handler, options);
    }
  }

  function runListenerHandler(component, expression, e, extraVars) {
    return component.evaluateCommandExpression(e.target, expression, () => {
      return _objectSpread2(_objectSpread2({}, extraVars()), {}, {
        '$event': e
      });
    });
  }

  function isKeyEvent(event) {
    return ['keydown', 'keyup'].includes(event);
  }

  function isListeningForASpecificKeyThatHasntBeenPressed(e, modifiers) {
    let keyModifiers = modifiers.filter(i => {
      return !['window', 'document', 'prevent', 'stop'].includes(i);
    });

    if (keyModifiers.includes('debounce')) {
      let debounceIndex = keyModifiers.indexOf('debounce');
      keyModifiers.splice(debounceIndex, isNumeric((keyModifiers[debounceIndex + 1] || 'invalid-wait').split('ms')[0]) ? 2 : 1);
    } // If no modifier is specified, we'll call it a press.


    if (keyModifiers.length === 0) return false; // If one is passed, AND it matches the key pressed, we'll call it a press.

    if (keyModifiers.length === 1 && keyModifiers[0] === keyToModifier(e.key)) return false; // The user is listening for key combinations.

    const systemKeyModifiers = ['ctrl', 'shift', 'alt', 'meta', 'cmd', 'super'];
    const selectedSystemKeyModifiers = systemKeyModifiers.filter(modifier => keyModifiers.includes(modifier));
    keyModifiers = keyModifiers.filter(i => !selectedSystemKeyModifiers.includes(i));

    if (selectedSystemKeyModifiers.length > 0) {
      const activelyPressedKeyModifiers = selectedSystemKeyModifiers.filter(modifier => {
        // Alias "cmd" and "super" to "meta"
        if (modifier === 'cmd' || modifier === 'super') modifier = 'meta';
        return e[`${modifier}Key`];
      }); // If all the modifiers selected are pressed, ...

      if (activelyPressedKeyModifiers.length === selectedSystemKeyModifiers.length) {
        // AND the remaining key is pressed as well. It's a press.
        if (keyModifiers[0] === keyToModifier(e.key)) return false;
      }
    } // We'll call it NOT a valid keypress.


    return true;
  }

  function keyToModifier(key) {
    switch (key) {
      case '/':
        return 'slash';

      case ' ':
      case 'Spacebar':
        return 'space';

      default:
        return key && kebabCase(key);
    }
  }

  function registerModelListener(component, el, modifiers, expression, extraVars) {
    // If the element we are binding to is a select, a radio, or checkbox
    // we'll listen for the change event instead of the "input" event.
    var event = el.tagName.toLowerCase() === 'select' || ['checkbox', 'radio'].includes(el.type) || modifiers.includes('lazy') ? 'change' : 'input';
    const listenerExpression = `${expression} = rightSideOfExpression($event, ${expression})`;
    registerListener(component, el, event, modifiers, listenerExpression, () => {
      return _objectSpread2(_objectSpread2({}, extraVars()), {}, {
        rightSideOfExpression: generateModelAssignmentFunction(el, modifiers, expression)
      });
    });
  }

  function generateModelAssignmentFunction(el, modifiers, expression) {
    if (el.type === 'radio') {
      // Radio buttons only work properly when they share a name attribute.
      // People might assume we take care of that for them, because
      // they already set a shared "x-model" attribute.
      if (!el.hasAttribute('name')) el.setAttribute('name', expression);
    }

    return (event, currentValue) => {
      // Check for event.detail due to an issue where IE11 handles other events as a CustomEvent.
      if (event instanceof CustomEvent && event.detail) {
        return event.detail;
      } else if (el.type === 'checkbox') {
        // If the data we are binding to is an array, toggle its value inside the array.
        if (Array.isArray(currentValue)) {
          const newValue = modifiers.includes('number') ? safeParseNumber(event.target.value) : event.target.value;
          return event.target.checked ? currentValue.concat([newValue]) : currentValue.filter(el => !checkedAttrLooseCompare(el, newValue));
        } else {
          return event.target.checked;
        }
      } else if (el.tagName.toLowerCase() === 'select' && el.multiple) {
        return modifiers.includes('number') ? Array.from(event.target.selectedOptions).map(option => {
          const rawValue = option.value || option.text;
          return safeParseNumber(rawValue);
        }) : Array.from(event.target.selectedOptions).map(option => {
          return option.value || option.text;
        });
      } else {
        const rawValue = event.target.value;
        return modifiers.includes('number') ? safeParseNumber(rawValue) : modifiers.includes('trim') ? rawValue.trim() : rawValue;
      }
    };
  }

  function safeParseNumber(rawValue) {
    const number = rawValue ? parseFloat(rawValue) : null;
    return isNumeric(number) ? number : rawValue;
  }

  /**
   * Copyright (C) 2017 salesforce.com, inc.
   */
  const { isArray } = Array;
  const { getPrototypeOf, create: ObjectCreate, defineProperty: ObjectDefineProperty, defineProperties: ObjectDefineProperties, isExtensible, getOwnPropertyDescriptor, getOwnPropertyNames, getOwnPropertySymbols, preventExtensions, hasOwnProperty, } = Object;
  const { push: ArrayPush, concat: ArrayConcat, map: ArrayMap, } = Array.prototype;
  function isUndefined(obj) {
      return obj === undefined;
  }
  function isFunction(obj) {
      return typeof obj === 'function';
  }
  function isObject(obj) {
      return typeof obj === 'object';
  }
  const proxyToValueMap = new WeakMap();
  function registerProxy(proxy, value) {
      proxyToValueMap.set(proxy, value);
  }
  const unwrap = (replicaOrAny) => proxyToValueMap.get(replicaOrAny) || replicaOrAny;

  function wrapValue(membrane, value) {
      return membrane.valueIsObservable(value) ? membrane.getProxy(value) : value;
  }
  /**
   * Unwrap property descriptors will set value on original descriptor
   * We only need to unwrap if value is specified
   * @param descriptor external descrpitor provided to define new property on original value
   */
  function unwrapDescriptor(descriptor) {
      if (hasOwnProperty.call(descriptor, 'value')) {
          descriptor.value = unwrap(descriptor.value);
      }
      return descriptor;
  }
  function lockShadowTarget(membrane, shadowTarget, originalTarget) {
      const targetKeys = ArrayConcat.call(getOwnPropertyNames(originalTarget), getOwnPropertySymbols(originalTarget));
      targetKeys.forEach((key) => {
          let descriptor = getOwnPropertyDescriptor(originalTarget, key);
          // We do not need to wrap the descriptor if configurable
          // Because we can deal with wrapping it when user goes through
          // Get own property descriptor. There is also a chance that this descriptor
          // could change sometime in the future, so we can defer wrapping
          // until we need to
          if (!descriptor.configurable) {
              descriptor = wrapDescriptor(membrane, descriptor, wrapValue);
          }
          ObjectDefineProperty(shadowTarget, key, descriptor);
      });
      preventExtensions(shadowTarget);
  }
  class ReactiveProxyHandler {
      constructor(membrane, value) {
          this.originalTarget = value;
          this.membrane = membrane;
      }
      get(shadowTarget, key) {
          const { originalTarget, membrane } = this;
          const value = originalTarget[key];
          const { valueObserved } = membrane;
          valueObserved(originalTarget, key);
          return membrane.getProxy(value);
      }
      set(shadowTarget, key, value) {
          const { originalTarget, membrane: { valueMutated } } = this;
          const oldValue = originalTarget[key];
          if (oldValue !== value) {
              originalTarget[key] = value;
              valueMutated(originalTarget, key);
          }
          else if (key === 'length' && isArray(originalTarget)) {
              // fix for issue #236: push will add the new index, and by the time length
              // is updated, the internal length is already equal to the new length value
              // therefore, the oldValue is equal to the value. This is the forking logic
              // to support this use case.
              valueMutated(originalTarget, key);
          }
          return true;
      }
      deleteProperty(shadowTarget, key) {
          const { originalTarget, membrane: { valueMutated } } = this;
          delete originalTarget[key];
          valueMutated(originalTarget, key);
          return true;
      }
      apply(shadowTarget, thisArg, argArray) {
          /* No op */
      }
      construct(target, argArray, newTarget) {
          /* No op */
      }
      has(shadowTarget, key) {
          const { originalTarget, membrane: { valueObserved } } = this;
          valueObserved(originalTarget, key);
          return key in originalTarget;
      }
      ownKeys(shadowTarget) {
          const { originalTarget } = this;
          return ArrayConcat.call(getOwnPropertyNames(originalTarget), getOwnPropertySymbols(originalTarget));
      }
      isExtensible(shadowTarget) {
          const shadowIsExtensible = isExtensible(shadowTarget);
          if (!shadowIsExtensible) {
              return shadowIsExtensible;
          }
          const { originalTarget, membrane } = this;
          const targetIsExtensible = isExtensible(originalTarget);
          if (!targetIsExtensible) {
              lockShadowTarget(membrane, shadowTarget, originalTarget);
          }
          return targetIsExtensible;
      }
      setPrototypeOf(shadowTarget, prototype) {
      }
      getPrototypeOf(shadowTarget) {
          const { originalTarget } = this;
          return getPrototypeOf(originalTarget);
      }
      getOwnPropertyDescriptor(shadowTarget, key) {
          const { originalTarget, membrane } = this;
          const { valueObserved } = this.membrane;
          // keys looked up via hasOwnProperty need to be reactive
          valueObserved(originalTarget, key);
          let desc = getOwnPropertyDescriptor(originalTarget, key);
          if (isUndefined(desc)) {
              return desc;
          }
          const shadowDescriptor = getOwnPropertyDescriptor(shadowTarget, key);
          if (!isUndefined(shadowDescriptor)) {
              return shadowDescriptor;
          }
          // Note: by accessing the descriptor, the key is marked as observed
          // but access to the value, setter or getter (if available) cannot observe
          // mutations, just like regular methods, in which case we just do nothing.
          desc = wrapDescriptor(membrane, desc, wrapValue);
          if (!desc.configurable) {
              // If descriptor from original target is not configurable,
              // We must copy the wrapped descriptor over to the shadow target.
              // Otherwise, proxy will throw an invariant error.
              // This is our last chance to lock the value.
              // https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Proxy/handler/getOwnPropertyDescriptor#Invariants
              ObjectDefineProperty(shadowTarget, key, desc);
          }
          return desc;
      }
      preventExtensions(shadowTarget) {
          const { originalTarget, membrane } = this;
          lockShadowTarget(membrane, shadowTarget, originalTarget);
          preventExtensions(originalTarget);
          return true;
      }
      defineProperty(shadowTarget, key, descriptor) {
          const { originalTarget, membrane } = this;
          const { valueMutated } = membrane;
          const { configurable } = descriptor;
          // We have to check for value in descriptor
          // because Object.freeze(proxy) calls this method
          // with only { configurable: false, writeable: false }
          // Additionally, method will only be called with writeable:false
          // if the descriptor has a value, as opposed to getter/setter
          // So we can just check if writable is present and then see if
          // value is present. This eliminates getter and setter descriptors
          if (hasOwnProperty.call(descriptor, 'writable') && !hasOwnProperty.call(descriptor, 'value')) {
              const originalDescriptor = getOwnPropertyDescriptor(originalTarget, key);
              descriptor.value = originalDescriptor.value;
          }
          ObjectDefineProperty(originalTarget, key, unwrapDescriptor(descriptor));
          if (configurable === false) {
              ObjectDefineProperty(shadowTarget, key, wrapDescriptor(membrane, descriptor, wrapValue));
          }
          valueMutated(originalTarget, key);
          return true;
      }
  }

  function wrapReadOnlyValue(membrane, value) {
      return membrane.valueIsObservable(value) ? membrane.getReadOnlyProxy(value) : value;
  }
  class ReadOnlyHandler {
      constructor(membrane, value) {
          this.originalTarget = value;
          this.membrane = membrane;
      }
      get(shadowTarget, key) {
          const { membrane, originalTarget } = this;
          const value = originalTarget[key];
          const { valueObserved } = membrane;
          valueObserved(originalTarget, key);
          return membrane.getReadOnlyProxy(value);
      }
      set(shadowTarget, key, value) {
          return false;
      }
      deleteProperty(shadowTarget, key) {
          return false;
      }
      apply(shadowTarget, thisArg, argArray) {
          /* No op */
      }
      construct(target, argArray, newTarget) {
          /* No op */
      }
      has(shadowTarget, key) {
          const { originalTarget, membrane: { valueObserved } } = this;
          valueObserved(originalTarget, key);
          return key in originalTarget;
      }
      ownKeys(shadowTarget) {
          const { originalTarget } = this;
          return ArrayConcat.call(getOwnPropertyNames(originalTarget), getOwnPropertySymbols(originalTarget));
      }
      setPrototypeOf(shadowTarget, prototype) {
      }
      getOwnPropertyDescriptor(shadowTarget, key) {
          const { originalTarget, membrane } = this;
          const { valueObserved } = membrane;
          // keys looked up via hasOwnProperty need to be reactive
          valueObserved(originalTarget, key);
          let desc = getOwnPropertyDescriptor(originalTarget, key);
          if (isUndefined(desc)) {
              return desc;
          }
          const shadowDescriptor = getOwnPropertyDescriptor(shadowTarget, key);
          if (!isUndefined(shadowDescriptor)) {
              return shadowDescriptor;
          }
          // Note: by accessing the descriptor, the key is marked as observed
          // but access to the value or getter (if available) cannot be observed,
          // just like regular methods, in which case we just do nothing.
          desc = wrapDescriptor(membrane, desc, wrapReadOnlyValue);
          if (hasOwnProperty.call(desc, 'set')) {
              desc.set = undefined; // readOnly membrane does not allow setters
          }
          if (!desc.configurable) {
              // If descriptor from original target is not configurable,
              // We must copy the wrapped descriptor over to the shadow target.
              // Otherwise, proxy will throw an invariant error.
              // This is our last chance to lock the value.
              // https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Proxy/handler/getOwnPropertyDescriptor#Invariants
              ObjectDefineProperty(shadowTarget, key, desc);
          }
          return desc;
      }
      preventExtensions(shadowTarget) {
          return false;
      }
      defineProperty(shadowTarget, key, descriptor) {
          return false;
      }
  }
  function createShadowTarget(value) {
      let shadowTarget = undefined;
      if (isArray(value)) {
          shadowTarget = [];
      }
      else if (isObject(value)) {
          shadowTarget = {};
      }
      return shadowTarget;
  }
  const ObjectDotPrototype = Object.prototype;
  function defaultValueIsObservable(value) {
      // intentionally checking for null
      if (value === null) {
          return false;
      }
      // treat all non-object types, including undefined, as non-observable values
      if (typeof value !== 'object') {
          return false;
      }
      if (isArray(value)) {
          return true;
      }
      const proto = getPrototypeOf(value);
      return (proto === ObjectDotPrototype || proto === null || getPrototypeOf(proto) === null);
  }
  const defaultValueObserved = (obj, key) => {
      /* do nothing */
  };
  const defaultValueMutated = (obj, key) => {
      /* do nothing */
  };
  const defaultValueDistortion = (value) => value;
  function wrapDescriptor(membrane, descriptor, getValue) {
      const { set, get } = descriptor;
      if (hasOwnProperty.call(descriptor, 'value')) {
          descriptor.value = getValue(membrane, descriptor.value);
      }
      else {
          if (!isUndefined(get)) {
              descriptor.get = function () {
                  // invoking the original getter with the original target
                  return getValue(membrane, get.call(unwrap(this)));
              };
          }
          if (!isUndefined(set)) {
              descriptor.set = function (value) {
                  // At this point we don't have a clear indication of whether
                  // or not a valid mutation will occur, we don't have the key,
                  // and we are not sure why and how they are invoking this setter.
                  // Nevertheless we preserve the original semantics by invoking the
                  // original setter with the original target and the unwrapped value
                  set.call(unwrap(this), membrane.unwrapProxy(value));
              };
          }
      }
      return descriptor;
  }
  class ReactiveMembrane {
      constructor(options) {
          this.valueDistortion = defaultValueDistortion;
          this.valueMutated = defaultValueMutated;
          this.valueObserved = defaultValueObserved;
          this.valueIsObservable = defaultValueIsObservable;
          this.objectGraph = new WeakMap();
          if (!isUndefined(options)) {
              const { valueDistortion, valueMutated, valueObserved, valueIsObservable } = options;
              this.valueDistortion = isFunction(valueDistortion) ? valueDistortion : defaultValueDistortion;
              this.valueMutated = isFunction(valueMutated) ? valueMutated : defaultValueMutated;
              this.valueObserved = isFunction(valueObserved) ? valueObserved : defaultValueObserved;
              this.valueIsObservable = isFunction(valueIsObservable) ? valueIsObservable : defaultValueIsObservable;
          }
      }
      getProxy(value) {
          const unwrappedValue = unwrap(value);
          const distorted = this.valueDistortion(unwrappedValue);
          if (this.valueIsObservable(distorted)) {
              const o = this.getReactiveState(unwrappedValue, distorted);
              // when trying to extract the writable version of a readonly
              // we return the readonly.
              return o.readOnly === value ? value : o.reactive;
          }
          return distorted;
      }
      getReadOnlyProxy(value) {
          value = unwrap(value);
          const distorted = this.valueDistortion(value);
          if (this.valueIsObservable(distorted)) {
              return this.getReactiveState(value, distorted).readOnly;
          }
          return distorted;
      }
      unwrapProxy(p) {
          return unwrap(p);
      }
      getReactiveState(value, distortedValue) {
          const { objectGraph, } = this;
          let reactiveState = objectGraph.get(distortedValue);
          if (reactiveState) {
              return reactiveState;
          }
          const membrane = this;
          reactiveState = {
              get reactive() {
                  const reactiveHandler = new ReactiveProxyHandler(membrane, distortedValue);
                  // caching the reactive proxy after the first time it is accessed
                  const proxy = new Proxy(createShadowTarget(distortedValue), reactiveHandler);
                  registerProxy(proxy, value);
                  ObjectDefineProperty(this, 'reactive', { value: proxy });
                  return proxy;
              },
              get readOnly() {
                  const readOnlyHandler = new ReadOnlyHandler(membrane, distortedValue);
                  // caching the readOnly proxy after the first time it is accessed
                  const proxy = new Proxy(createShadowTarget(distortedValue), readOnlyHandler);
                  registerProxy(proxy, value);
                  ObjectDefineProperty(this, 'readOnly', { value: proxy });
                  return proxy;
              }
          };
          objectGraph.set(distortedValue, reactiveState);
          return reactiveState;
      }
  }
  /** version: 0.26.0 */

  function wrap(data, mutationCallback) {

    let membrane = new ReactiveMembrane({
      valueMutated(target, key) {
        mutationCallback(target, key);
      }

    });
    return {
      data: membrane.getProxy(data),
      membrane: membrane
    };
  }
  function unwrap$1(membrane, observable) {
    let unwrappedData = membrane.unwrapProxy(observable);
    let copy = {};
    Object.keys(unwrappedData).forEach(key => {
      if (['$el', '$refs', '$nextTick', '$watch'].includes(key)) return;
      copy[key] = unwrappedData[key];
    });
    return copy;
  }

  class Component {
    constructor(el, componentForClone = null) {
      this.$el = el;
      const dataAttr = this.$el.getAttribute('x-data');
      const dataExpression = dataAttr === '' ? '{}' : dataAttr;
      const initExpression = this.$el.getAttribute('x-init');
      let dataExtras = {
        $el: this.$el
      };
      let canonicalComponentElementReference = componentForClone ? componentForClone.$el : this.$el;
      Object.entries(Alpine.magicProperties).forEach(([name, callback]) => {
        Object.defineProperty(dataExtras, `$${name}`, {
          get: function get() {
            return callback(canonicalComponentElementReference);
          }
        });
      });
      this.unobservedData = componentForClone ? componentForClone.getUnobservedData() : saferEval(el, dataExpression, dataExtras);
      // Construct a Proxy-based observable. This will be used to handle reactivity.

      let {
        membrane,
        data
      } = this.wrapDataInObservable(this.unobservedData);
      this.$data = data;
      this.membrane = membrane; // After making user-supplied data methods reactive, we can now add
      // our magic properties to the original data for access.

      this.unobservedData.$el = this.$el;
      this.unobservedData.$refs = this.getRefsProxy();
      this.nextTickStack = [];

      this.unobservedData.$nextTick = callback => {
        this.nextTickStack.push(callback);
      };

      this.watchers = {};

      this.unobservedData.$watch = (property, callback) => {
        if (!this.watchers[property]) this.watchers[property] = [];
        this.watchers[property].push(callback);
      };
      /* MODERN-ONLY:START */
      // We remove this piece of code from the legacy build.
      // In IE11, we have already defined our helpers at this point.
      // Register custom magic properties.


      Object.entries(Alpine.magicProperties).forEach(([name, callback]) => {
        Object.defineProperty(this.unobservedData, `$${name}`, {
          get: function get() {
            return callback(canonicalComponentElementReference, this.$el);
          }
        });
      });
      /* MODERN-ONLY:END */

      this.showDirectiveStack = [];
      this.showDirectiveLastElement;
      componentForClone || Alpine.onBeforeComponentInitializeds.forEach(callback => callback(this));
      var initReturnedCallback; // If x-init is present AND we aren't cloning (skip x-init on clone)

      if (initExpression && !componentForClone) {
        // We want to allow data manipulation, but not trigger DOM updates just yet.
        // We haven't even initialized the elements with their Alpine bindings. I mean c'mon.
        this.pauseReactivity = true;
        initReturnedCallback = this.evaluateReturnExpression(this.$el, initExpression);
        this.pauseReactivity = false;
      } // Register all our listeners and set all our attribute bindings.


      this.initializeElements(this.$el); // Use mutation observer to detect new elements being added within this component at run-time.
      // Alpine's just so darn flexible amirite?

      this.listenForNewElementsToInitialize();

      if (typeof initReturnedCallback === 'function') {
        // Run the callback returned from the "x-init" hook to allow the user to do stuff after
        // Alpine's got it's grubby little paws all over everything.
        initReturnedCallback.call(this.$data);
      }

      componentForClone || setTimeout(() => {
        Alpine.onComponentInitializeds.forEach(callback => callback(this));
      }, 0);
    }

    getUnobservedData() {
      return unwrap$1(this.membrane, this.$data);
    }

    wrapDataInObservable(data) {
      var self = this;
      let updateDom = debounce(function () {
        self.updateElements(self.$el);
      }, 0);
      return wrap(data, (target, key) => {
        if (self.watchers[key]) {
          // If there's a watcher for this specific key, run it.
          self.watchers[key].forEach(callback => callback(target[key]));
        } else if (Array.isArray(target)) {
          // Arrays are special cases, if any of the items change, we consider the array as mutated.
          Object.keys(self.watchers).forEach(fullDotNotationKey => {
            let dotNotationParts = fullDotNotationKey.split('.'); // Ignore length mutations since they would result in duplicate calls.
            // For example, when calling push, we would get a mutation for the item's key
            // and a second mutation for the length property.

            if (key === 'length') return;
            dotNotationParts.reduce((comparisonData, part) => {
              if (Object.is(target, comparisonData[part])) {
                self.watchers[fullDotNotationKey].forEach(callback => callback(target));
              }

              return comparisonData[part];
            }, self.unobservedData);
          });
        } else {
          // Let's walk through the watchers with "dot-notation" (foo.bar) and see
          // if this mutation fits any of them.
          Object.keys(self.watchers).filter(i => i.includes('.')).forEach(fullDotNotationKey => {
            let dotNotationParts = fullDotNotationKey.split('.'); // If this dot-notation watcher's last "part" doesn't match the current
            // key, then skip it early for performance reasons.

            if (key !== dotNotationParts[dotNotationParts.length - 1]) return; // Now, walk through the dot-notation "parts" recursively to find
            // a match, and call the watcher if one's found.

            dotNotationParts.reduce((comparisonData, part) => {
              if (Object.is(target, comparisonData)) {
                // Run the watchers.
                self.watchers[fullDotNotationKey].forEach(callback => callback(target[key]));
              }

              return comparisonData[part];
            }, self.unobservedData);
          });
        } // Don't react to data changes for cases like the `x-created` hook.


        if (self.pauseReactivity) return;
        updateDom();
      });
    }

    walkAndSkipNestedComponents(el, callback, initializeComponentCallback = () => {}) {
      walk(el, el => {
        // We've hit a component.
        if (el.hasAttribute('x-data')) {
          // If it's not the current one.
          if (!el.isSameNode(this.$el)) {
            // Initialize it if it's not.
            if (!el.__x) initializeComponentCallback(el); // Now we'll let that sub-component deal with itself.

            return false;
          }
        }

        return callback(el);
      });
    }

    initializeElements(rootEl, extraVars = () => {}) {
      this.walkAndSkipNestedComponents(rootEl, el => {
        // Don't touch spawns from for loop
        if (el.__x_for_key !== undefined) return false; // Don't touch spawns from if directives

        if (el.__x_inserted_me !== undefined) return false;
        this.initializeElement(el, extraVars);
      }, el => {
        el.__x = new Component(el);
      });
      this.executeAndClearRemainingShowDirectiveStack();
      this.executeAndClearNextTickStack(rootEl);
    }

    initializeElement(el, extraVars) {
      // To support class attribute merging, we have to know what the element's
      // original class attribute looked like for reference.
      if (el.hasAttribute('class') && getXAttrs(el, this).length > 0) {
        el.__x_original_classes = convertClassStringToArray(el.getAttribute('class'));
      }

      this.registerListeners(el, extraVars);
      this.resolveBoundAttributes(el, true, extraVars);
    }

    updateElements(rootEl, extraVars = () => {}) {
      this.walkAndSkipNestedComponents(rootEl, el => {
        // Don't touch spawns from for loop (and check if the root is actually a for loop in a parent, don't skip it.)
        if (el.__x_for_key !== undefined && !el.isSameNode(this.$el)) return false;
        this.updateElement(el, extraVars);
      }, el => {
        el.__x = new Component(el);
      });
      this.executeAndClearRemainingShowDirectiveStack();
      this.executeAndClearNextTickStack(rootEl);
    }

    executeAndClearNextTickStack(el) {
      // Skip spawns from alpine directives
      if (el === this.$el && this.nextTickStack.length > 0) {
        // We run the tick stack after the next frame to allow any
        // running transitions to pass the initial show stage.
        requestAnimationFrame(() => {
          while (this.nextTickStack.length > 0) {
            this.nextTickStack.shift()();
          }
        });
      }
    }

    executeAndClearRemainingShowDirectiveStack() {
      // The goal here is to start all the x-show transitions
      // and build a nested promise chain so that elements
      // only hide when the children are finished hiding.
      this.showDirectiveStack.reverse().map(handler => {
        return new Promise((resolve, reject) => {
          handler(resolve, reject);
        });
      }).reduce((promiseChain, promise) => {
        return promiseChain.then(() => {
          return promise.then(finishElement => {
            finishElement();
          });
        });
      }, Promise.resolve(() => {})).catch(e => {
        if (e !== TRANSITION_CANCELLED) throw e;
      }); // We've processed the handler stack. let's clear it.

      this.showDirectiveStack = [];
      this.showDirectiveLastElement = undefined;
    }

    updateElement(el, extraVars) {
      this.resolveBoundAttributes(el, false, extraVars);
    }

    registerListeners(el, extraVars) {
      getXAttrs(el, this).forEach(({
        type,
        value,
        modifiers,
        expression
      }) => {
        switch (type) {
          case 'on':
            registerListener(this, el, value, modifiers, expression, extraVars);
            break;

          case 'model':
            registerModelListener(this, el, modifiers, expression, extraVars);
            break;
        }
      });
    }

    resolveBoundAttributes(el, initialUpdate = false, extraVars) {
      let attrs = getXAttrs(el, this);
      attrs.forEach(({
        type,
        value,
        modifiers,
        expression
      }) => {
        switch (type) {
          case 'model':
            handleAttributeBindingDirective(this, el, 'value', expression, extraVars, type, modifiers);
            break;

          case 'bind':
            // The :key binding on an x-for is special, ignore it.
            if (el.tagName.toLowerCase() === 'template' && value === 'key') return;
            handleAttributeBindingDirective(this, el, value, expression, extraVars, type, modifiers);
            break;

          case 'text':
            var output = this.evaluateReturnExpression(el, expression, extraVars);
            handleTextDirective(el, output, expression);
            break;

          case 'html':
            handleHtmlDirective(this, el, expression, extraVars);
            break;

          case 'show':
            var output = this.evaluateReturnExpression(el, expression, extraVars);
            handleShowDirective(this, el, output, modifiers, initialUpdate);
            break;

          case 'if':
            // If this element also has x-for on it, don't process x-if.
            // We will let the "x-for" directive handle the "if"ing.
            if (attrs.some(i => i.type === 'for')) return;
            var output = this.evaluateReturnExpression(el, expression, extraVars);
            handleIfDirective(this, el, output, initialUpdate, extraVars);
            break;

          case 'for':
            handleForDirective(this, el, expression, initialUpdate, extraVars);
            break;

          case 'cloak':
            el.removeAttribute('x-cloak');
            break;
        }
      });
    }

    evaluateReturnExpression(el, expression, extraVars = () => {}) {
      return saferEval(el, expression, this.$data, _objectSpread2(_objectSpread2({}, extraVars()), {}, {
        $dispatch: this.getDispatchFunction(el)
      }));
    }

    evaluateCommandExpression(el, expression, extraVars = () => {}) {
      return saferEvalNoReturn(el, expression, this.$data, _objectSpread2(_objectSpread2({}, extraVars()), {}, {
        $dispatch: this.getDispatchFunction(el)
      }));
    }

    getDispatchFunction(el) {
      return (event, detail = {}) => {
        el.dispatchEvent(new CustomEvent(event, {
          detail,
          bubbles: true
        }));
      };
    }

    listenForNewElementsToInitialize() {
      const targetNode = this.$el;
      const observerOptions = {
        childList: true,
        attributes: true,
        subtree: true
      };
      const observer = new MutationObserver(mutations => {
        for (let i = 0; i < mutations.length; i++) {
          // Filter out mutations triggered from child components.
          const closestParentComponent = mutations[i].target.closest('[x-data]');
          if (!(closestParentComponent && closestParentComponent.isSameNode(this.$el))) continue;

          if (mutations[i].type === 'attributes' && mutations[i].attributeName === 'x-data') {
            const xAttr = mutations[i].target.getAttribute('x-data') || '{}';
            const rawData = saferEval(this.$el, xAttr, {
              $el: this.$el
            });
            Object.keys(rawData).forEach(key => {
              if (this.$data[key] !== rawData[key]) {
                this.$data[key] = rawData[key];
              }
            });
          }

          if (mutations[i].addedNodes.length > 0) {
            mutations[i].addedNodes.forEach(node => {
              if (node.nodeType !== 1 || node.__x_inserted_me) return;

              if (node.matches('[x-data]') && !node.__x) {
                node.__x = new Component(node);
                return;
              }

              this.initializeElements(node);
            });
          }
        }
      });
      observer.observe(targetNode, observerOptions);
    }

    getRefsProxy() {
      var self = this;
      var refObj = {};
      // One of the goals of this is to not hold elements in memory, but rather re-evaluate
      // the DOM when the system needs something from it. This way, the framework is flexible and
      // friendly to outside DOM changes from libraries like Vue/Livewire.
      // For this reason, I'm using an "on-demand" proxy to fake a "$refs" object.

      return new Proxy(refObj, {
        get(object, property) {
          if (property === '$isAlpineProxy') return true;
          var ref; // We can't just query the DOM because it's hard to filter out refs in
          // nested components.

          self.walkAndSkipNestedComponents(self.$el, el => {
            if (el.hasAttribute('x-ref') && el.getAttribute('x-ref') === property) {
              ref = el;
            }
          });
          return ref;
        }

      });
    }

  }

  const Alpine = {
    version: "2.8.0",
    pauseMutationObserver: false,
    magicProperties: {},
    onComponentInitializeds: [],
    onBeforeComponentInitializeds: [],
    ignoreFocusedForValueBinding: false,
    start: async function start() {
      if (!isTesting()) {
        await domReady();
      }

      this.discoverComponents(el => {
        this.initializeComponent(el);
      }); // It's easier and more performant to just support Turbolinks than listen
      // to MutationObserver mutations at the document level.

      document.addEventListener("turbolinks:load", () => {
        this.discoverUninitializedComponents(el => {
          this.initializeComponent(el);
        });
      });
      this.listenForNewUninitializedComponentsAtRunTime();
    },
    discoverComponents: function discoverComponents(callback) {
      const rootEls = document.querySelectorAll('[x-data]');
      rootEls.forEach(rootEl => {
        callback(rootEl);
      });
    },
    discoverUninitializedComponents: function discoverUninitializedComponents(callback, el = null) {
      const rootEls = (el || document).querySelectorAll('[x-data]');
      Array.from(rootEls).filter(el => el.__x === undefined).forEach(rootEl => {
        callback(rootEl);
      });
    },
    listenForNewUninitializedComponentsAtRunTime: function listenForNewUninitializedComponentsAtRunTime() {
      const targetNode = document.querySelector('body');
      const observerOptions = {
        childList: true,
        attributes: true,
        subtree: true
      };
      const observer = new MutationObserver(mutations => {
        if (this.pauseMutationObserver) return;

        for (let i = 0; i < mutations.length; i++) {
          if (mutations[i].addedNodes.length > 0) {
            mutations[i].addedNodes.forEach(node => {
              // Discard non-element nodes (like line-breaks)
              if (node.nodeType !== 1) return; // Discard any changes happening within an existing component.
              // They will take care of themselves.

              if (node.parentElement && node.parentElement.closest('[x-data]')) return;
              this.discoverUninitializedComponents(el => {
                this.initializeComponent(el);
              }, node.parentElement);
            });
          }
        }
      });
      observer.observe(targetNode, observerOptions);
    },
    initializeComponent: function initializeComponent(el) {
      if (!el.__x) {
        // Wrap in a try/catch so that we don't prevent other components
        // from initializing when one component contains an error.
        try {
          el.__x = new Component(el);
        } catch (error) {
          setTimeout(() => {
            throw error;
          }, 0);
        }
      }
    },
    clone: function clone(component, newEl) {
      if (!newEl.__x) {
        newEl.__x = new Component(newEl, component);
      }
    },
    addMagicProperty: function addMagicProperty(name, callback) {
      this.magicProperties[name] = callback;
    },
    onComponentInitialized: function onComponentInitialized(callback) {
      this.onComponentInitializeds.push(callback);
    },
    onBeforeComponentInitialized: function onBeforeComponentInitialized(callback) {
      this.onBeforeComponentInitializeds.push(callback);
    }
  };

  if (!isTesting()) {
    window.Alpine = Alpine;

    if (window.deferLoadingAlpine) {
      window.deferLoadingAlpine(function () {
        window.Alpine.start();
      });
    } else {
      window.Alpine.start();
    }
  }

  return Alpine;

})));


/***/ }),

/***/ "./node_modules/axios/index.js":
/*!*************************************!*\
  !*** ./node_modules/axios/index.js ***!
  \*************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__(/*! ./lib/axios */ "./node_modules/axios/lib/axios.js");

/***/ }),

/***/ "./node_modules/axios/lib/adapters/xhr.js":
/*!************************************************!*\
  !*** ./node_modules/axios/lib/adapters/xhr.js ***!
  \************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var utils = __webpack_require__(/*! ./../utils */ "./node_modules/axios/lib/utils.js");
var settle = __webpack_require__(/*! ./../core/settle */ "./node_modules/axios/lib/core/settle.js");
var cookies = __webpack_require__(/*! ./../helpers/cookies */ "./node_modules/axios/lib/helpers/cookies.js");
var buildURL = __webpack_require__(/*! ./../helpers/buildURL */ "./node_modules/axios/lib/helpers/buildURL.js");
var buildFullPath = __webpack_require__(/*! ../core/buildFullPath */ "./node_modules/axios/lib/core/buildFullPath.js");
var parseHeaders = __webpack_require__(/*! ./../helpers/parseHeaders */ "./node_modules/axios/lib/helpers/parseHeaders.js");
var isURLSameOrigin = __webpack_require__(/*! ./../helpers/isURLSameOrigin */ "./node_modules/axios/lib/helpers/isURLSameOrigin.js");
var createError = __webpack_require__(/*! ../core/createError */ "./node_modules/axios/lib/core/createError.js");

module.exports = function xhrAdapter(config) {
  return new Promise(function dispatchXhrRequest(resolve, reject) {
    var requestData = config.data;
    var requestHeaders = config.headers;

    if (utils.isFormData(requestData)) {
      delete requestHeaders['Content-Type']; // Let the browser set it
    }

    var request = new XMLHttpRequest();

    // HTTP basic authentication
    if (config.auth) {
      var username = config.auth.username || '';
      var password = config.auth.password ? unescape(encodeURIComponent(config.auth.password)) : '';
      requestHeaders.Authorization = 'Basic ' + btoa(username + ':' + password);
    }

    var fullPath = buildFullPath(config.baseURL, config.url);
    request.open(config.method.toUpperCase(), buildURL(fullPath, config.params, config.paramsSerializer), true);

    // Set the request timeout in MS
    request.timeout = config.timeout;

    // Listen for ready state
    request.onreadystatechange = function handleLoad() {
      if (!request || request.readyState !== 4) {
        return;
      }

      // The request errored out and we didn't get a response, this will be
      // handled by onerror instead
      // With one exception: request that using file: protocol, most browsers
      // will return status as 0 even though it's a successful request
      if (request.status === 0 && !(request.responseURL && request.responseURL.indexOf('file:') === 0)) {
        return;
      }

      // Prepare the response
      var responseHeaders = 'getAllResponseHeaders' in request ? parseHeaders(request.getAllResponseHeaders()) : null;
      var responseData = !config.responseType || config.responseType === 'text' ? request.responseText : request.response;
      var response = {
        data: responseData,
        status: request.status,
        statusText: request.statusText,
        headers: responseHeaders,
        config: config,
        request: request
      };

      settle(resolve, reject, response);

      // Clean up request
      request = null;
    };

    // Handle browser request cancellation (as opposed to a manual cancellation)
    request.onabort = function handleAbort() {
      if (!request) {
        return;
      }

      reject(createError('Request aborted', config, 'ECONNABORTED', request));

      // Clean up request
      request = null;
    };

    // Handle low level network errors
    request.onerror = function handleError() {
      // Real errors are hidden from us by the browser
      // onerror should only fire if it's a network error
      reject(createError('Network Error', config, null, request));

      // Clean up request
      request = null;
    };

    // Handle timeout
    request.ontimeout = function handleTimeout() {
      var timeoutErrorMessage = 'timeout of ' + config.timeout + 'ms exceeded';
      if (config.timeoutErrorMessage) {
        timeoutErrorMessage = config.timeoutErrorMessage;
      }
      reject(createError(timeoutErrorMessage, config, 'ECONNABORTED',
        request));

      // Clean up request
      request = null;
    };

    // Add xsrf header
    // This is only done if running in a standard browser environment.
    // Specifically not if we're in a web worker, or react-native.
    if (utils.isStandardBrowserEnv()) {
      // Add xsrf header
      var xsrfValue = (config.withCredentials || isURLSameOrigin(fullPath)) && config.xsrfCookieName ?
        cookies.read(config.xsrfCookieName) :
        undefined;

      if (xsrfValue) {
        requestHeaders[config.xsrfHeaderName] = xsrfValue;
      }
    }

    // Add headers to the request
    if ('setRequestHeader' in request) {
      utils.forEach(requestHeaders, function setRequestHeader(val, key) {
        if (typeof requestData === 'undefined' && key.toLowerCase() === 'content-type') {
          // Remove Content-Type if data is undefined
          delete requestHeaders[key];
        } else {
          // Otherwise add header to the request
          request.setRequestHeader(key, val);
        }
      });
    }

    // Add withCredentials to request if needed
    if (!utils.isUndefined(config.withCredentials)) {
      request.withCredentials = !!config.withCredentials;
    }

    // Add responseType to request if needed
    if (config.responseType) {
      try {
        request.responseType = config.responseType;
      } catch (e) {
        // Expected DOMException thrown by browsers not compatible XMLHttpRequest Level 2.
        // But, this can be suppressed for 'json' type as it can be parsed by default 'transformResponse' function.
        if (config.responseType !== 'json') {
          throw e;
        }
      }
    }

    // Handle progress if needed
    if (typeof config.onDownloadProgress === 'function') {
      request.addEventListener('progress', config.onDownloadProgress);
    }

    // Not all browsers support upload events
    if (typeof config.onUploadProgress === 'function' && request.upload) {
      request.upload.addEventListener('progress', config.onUploadProgress);
    }

    if (config.cancelToken) {
      // Handle cancellation
      config.cancelToken.promise.then(function onCanceled(cancel) {
        if (!request) {
          return;
        }

        request.abort();
        reject(cancel);
        // Clean up request
        request = null;
      });
    }

    if (!requestData) {
      requestData = null;
    }

    // Send the request
    request.send(requestData);
  });
};


/***/ }),

/***/ "./node_modules/axios/lib/axios.js":
/*!*****************************************!*\
  !*** ./node_modules/axios/lib/axios.js ***!
  \*****************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var utils = __webpack_require__(/*! ./utils */ "./node_modules/axios/lib/utils.js");
var bind = __webpack_require__(/*! ./helpers/bind */ "./node_modules/axios/lib/helpers/bind.js");
var Axios = __webpack_require__(/*! ./core/Axios */ "./node_modules/axios/lib/core/Axios.js");
var mergeConfig = __webpack_require__(/*! ./core/mergeConfig */ "./node_modules/axios/lib/core/mergeConfig.js");
var defaults = __webpack_require__(/*! ./defaults */ "./node_modules/axios/lib/defaults.js");

/**
 * Create an instance of Axios
 *
 * @param {Object} defaultConfig The default config for the instance
 * @return {Axios} A new instance of Axios
 */
function createInstance(defaultConfig) {
  var context = new Axios(defaultConfig);
  var instance = bind(Axios.prototype.request, context);

  // Copy axios.prototype to instance
  utils.extend(instance, Axios.prototype, context);

  // Copy context to instance
  utils.extend(instance, context);

  return instance;
}

// Create the default instance to be exported
var axios = createInstance(defaults);

// Expose Axios class to allow class inheritance
axios.Axios = Axios;

// Factory for creating new instances
axios.create = function create(instanceConfig) {
  return createInstance(mergeConfig(axios.defaults, instanceConfig));
};

// Expose Cancel & CancelToken
axios.Cancel = __webpack_require__(/*! ./cancel/Cancel */ "./node_modules/axios/lib/cancel/Cancel.js");
axios.CancelToken = __webpack_require__(/*! ./cancel/CancelToken */ "./node_modules/axios/lib/cancel/CancelToken.js");
axios.isCancel = __webpack_require__(/*! ./cancel/isCancel */ "./node_modules/axios/lib/cancel/isCancel.js");

// Expose all/spread
axios.all = function all(promises) {
  return Promise.all(promises);
};
axios.spread = __webpack_require__(/*! ./helpers/spread */ "./node_modules/axios/lib/helpers/spread.js");

// Expose isAxiosError
axios.isAxiosError = __webpack_require__(/*! ./helpers/isAxiosError */ "./node_modules/axios/lib/helpers/isAxiosError.js");

module.exports = axios;

// Allow use of default import syntax in TypeScript
module.exports.default = axios;


/***/ }),

/***/ "./node_modules/axios/lib/cancel/Cancel.js":
/*!*************************************************!*\
  !*** ./node_modules/axios/lib/cancel/Cancel.js ***!
  \*************************************************/
/***/ ((module) => {

"use strict";


/**
 * A `Cancel` is an object that is thrown when an operation is canceled.
 *
 * @class
 * @param {string=} message The message.
 */
function Cancel(message) {
  this.message = message;
}

Cancel.prototype.toString = function toString() {
  return 'Cancel' + (this.message ? ': ' + this.message : '');
};

Cancel.prototype.__CANCEL__ = true;

module.exports = Cancel;


/***/ }),

/***/ "./node_modules/axios/lib/cancel/CancelToken.js":
/*!******************************************************!*\
  !*** ./node_modules/axios/lib/cancel/CancelToken.js ***!
  \******************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var Cancel = __webpack_require__(/*! ./Cancel */ "./node_modules/axios/lib/cancel/Cancel.js");

/**
 * A `CancelToken` is an object that can be used to request cancellation of an operation.
 *
 * @class
 * @param {Function} executor The executor function.
 */
function CancelToken(executor) {
  if (typeof executor !== 'function') {
    throw new TypeError('executor must be a function.');
  }

  var resolvePromise;
  this.promise = new Promise(function promiseExecutor(resolve) {
    resolvePromise = resolve;
  });

  var token = this;
  executor(function cancel(message) {
    if (token.reason) {
      // Cancellation has already been requested
      return;
    }

    token.reason = new Cancel(message);
    resolvePromise(token.reason);
  });
}

/**
 * Throws a `Cancel` if cancellation has been requested.
 */
CancelToken.prototype.throwIfRequested = function throwIfRequested() {
  if (this.reason) {
    throw this.reason;
  }
};

/**
 * Returns an object that contains a new `CancelToken` and a function that, when called,
 * cancels the `CancelToken`.
 */
CancelToken.source = function source() {
  var cancel;
  var token = new CancelToken(function executor(c) {
    cancel = c;
  });
  return {
    token: token,
    cancel: cancel
  };
};

module.exports = CancelToken;


/***/ }),

/***/ "./node_modules/axios/lib/cancel/isCancel.js":
/*!***************************************************!*\
  !*** ./node_modules/axios/lib/cancel/isCancel.js ***!
  \***************************************************/
/***/ ((module) => {

"use strict";


module.exports = function isCancel(value) {
  return !!(value && value.__CANCEL__);
};


/***/ }),

/***/ "./node_modules/axios/lib/core/Axios.js":
/*!**********************************************!*\
  !*** ./node_modules/axios/lib/core/Axios.js ***!
  \**********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var utils = __webpack_require__(/*! ./../utils */ "./node_modules/axios/lib/utils.js");
var buildURL = __webpack_require__(/*! ../helpers/buildURL */ "./node_modules/axios/lib/helpers/buildURL.js");
var InterceptorManager = __webpack_require__(/*! ./InterceptorManager */ "./node_modules/axios/lib/core/InterceptorManager.js");
var dispatchRequest = __webpack_require__(/*! ./dispatchRequest */ "./node_modules/axios/lib/core/dispatchRequest.js");
var mergeConfig = __webpack_require__(/*! ./mergeConfig */ "./node_modules/axios/lib/core/mergeConfig.js");

/**
 * Create a new instance of Axios
 *
 * @param {Object} instanceConfig The default config for the instance
 */
function Axios(instanceConfig) {
  this.defaults = instanceConfig;
  this.interceptors = {
    request: new InterceptorManager(),
    response: new InterceptorManager()
  };
}

/**
 * Dispatch a request
 *
 * @param {Object} config The config specific for this request (merged with this.defaults)
 */
Axios.prototype.request = function request(config) {
  /*eslint no-param-reassign:0*/
  // Allow for axios('example/url'[, config]) a la fetch API
  if (typeof config === 'string') {
    config = arguments[1] || {};
    config.url = arguments[0];
  } else {
    config = config || {};
  }

  config = mergeConfig(this.defaults, config);

  // Set config.method
  if (config.method) {
    config.method = config.method.toLowerCase();
  } else if (this.defaults.method) {
    config.method = this.defaults.method.toLowerCase();
  } else {
    config.method = 'get';
  }

  // Hook up interceptors middleware
  var chain = [dispatchRequest, undefined];
  var promise = Promise.resolve(config);

  this.interceptors.request.forEach(function unshiftRequestInterceptors(interceptor) {
    chain.unshift(interceptor.fulfilled, interceptor.rejected);
  });

  this.interceptors.response.forEach(function pushResponseInterceptors(interceptor) {
    chain.push(interceptor.fulfilled, interceptor.rejected);
  });

  while (chain.length) {
    promise = promise.then(chain.shift(), chain.shift());
  }

  return promise;
};

Axios.prototype.getUri = function getUri(config) {
  config = mergeConfig(this.defaults, config);
  return buildURL(config.url, config.params, config.paramsSerializer).replace(/^\?/, '');
};

// Provide aliases for supported request methods
utils.forEach(['delete', 'get', 'head', 'options'], function forEachMethodNoData(method) {
  /*eslint func-names:0*/
  Axios.prototype[method] = function(url, config) {
    return this.request(mergeConfig(config || {}, {
      method: method,
      url: url,
      data: (config || {}).data
    }));
  };
});

utils.forEach(['post', 'put', 'patch'], function forEachMethodWithData(method) {
  /*eslint func-names:0*/
  Axios.prototype[method] = function(url, data, config) {
    return this.request(mergeConfig(config || {}, {
      method: method,
      url: url,
      data: data
    }));
  };
});

module.exports = Axios;


/***/ }),

/***/ "./node_modules/axios/lib/core/InterceptorManager.js":
/*!***********************************************************!*\
  !*** ./node_modules/axios/lib/core/InterceptorManager.js ***!
  \***********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var utils = __webpack_require__(/*! ./../utils */ "./node_modules/axios/lib/utils.js");

function InterceptorManager() {
  this.handlers = [];
}

/**
 * Add a new interceptor to the stack
 *
 * @param {Function} fulfilled The function to handle `then` for a `Promise`
 * @param {Function} rejected The function to handle `reject` for a `Promise`
 *
 * @return {Number} An ID used to remove interceptor later
 */
InterceptorManager.prototype.use = function use(fulfilled, rejected) {
  this.handlers.push({
    fulfilled: fulfilled,
    rejected: rejected
  });
  return this.handlers.length - 1;
};

/**
 * Remove an interceptor from the stack
 *
 * @param {Number} id The ID that was returned by `use`
 */
InterceptorManager.prototype.eject = function eject(id) {
  if (this.handlers[id]) {
    this.handlers[id] = null;
  }
};

/**
 * Iterate over all the registered interceptors
 *
 * This method is particularly useful for skipping over any
 * interceptors that may have become `null` calling `eject`.
 *
 * @param {Function} fn The function to call for each interceptor
 */
InterceptorManager.prototype.forEach = function forEach(fn) {
  utils.forEach(this.handlers, function forEachHandler(h) {
    if (h !== null) {
      fn(h);
    }
  });
};

module.exports = InterceptorManager;


/***/ }),

/***/ "./node_modules/axios/lib/core/buildFullPath.js":
/*!******************************************************!*\
  !*** ./node_modules/axios/lib/core/buildFullPath.js ***!
  \******************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var isAbsoluteURL = __webpack_require__(/*! ../helpers/isAbsoluteURL */ "./node_modules/axios/lib/helpers/isAbsoluteURL.js");
var combineURLs = __webpack_require__(/*! ../helpers/combineURLs */ "./node_modules/axios/lib/helpers/combineURLs.js");

/**
 * Creates a new URL by combining the baseURL with the requestedURL,
 * only when the requestedURL is not already an absolute URL.
 * If the requestURL is absolute, this function returns the requestedURL untouched.
 *
 * @param {string} baseURL The base URL
 * @param {string} requestedURL Absolute or relative URL to combine
 * @returns {string} The combined full path
 */
module.exports = function buildFullPath(baseURL, requestedURL) {
  if (baseURL && !isAbsoluteURL(requestedURL)) {
    return combineURLs(baseURL, requestedURL);
  }
  return requestedURL;
};


/***/ }),

/***/ "./node_modules/axios/lib/core/createError.js":
/*!****************************************************!*\
  !*** ./node_modules/axios/lib/core/createError.js ***!
  \****************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var enhanceError = __webpack_require__(/*! ./enhanceError */ "./node_modules/axios/lib/core/enhanceError.js");

/**
 * Create an Error with the specified message, config, error code, request and response.
 *
 * @param {string} message The error message.
 * @param {Object} config The config.
 * @param {string} [code] The error code (for example, 'ECONNABORTED').
 * @param {Object} [request] The request.
 * @param {Object} [response] The response.
 * @returns {Error} The created error.
 */
module.exports = function createError(message, config, code, request, response) {
  var error = new Error(message);
  return enhanceError(error, config, code, request, response);
};


/***/ }),

/***/ "./node_modules/axios/lib/core/dispatchRequest.js":
/*!********************************************************!*\
  !*** ./node_modules/axios/lib/core/dispatchRequest.js ***!
  \********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var utils = __webpack_require__(/*! ./../utils */ "./node_modules/axios/lib/utils.js");
var transformData = __webpack_require__(/*! ./transformData */ "./node_modules/axios/lib/core/transformData.js");
var isCancel = __webpack_require__(/*! ../cancel/isCancel */ "./node_modules/axios/lib/cancel/isCancel.js");
var defaults = __webpack_require__(/*! ../defaults */ "./node_modules/axios/lib/defaults.js");

/**
 * Throws a `Cancel` if cancellation has been requested.
 */
function throwIfCancellationRequested(config) {
  if (config.cancelToken) {
    config.cancelToken.throwIfRequested();
  }
}

/**
 * Dispatch a request to the server using the configured adapter.
 *
 * @param {object} config The config that is to be used for the request
 * @returns {Promise} The Promise to be fulfilled
 */
module.exports = function dispatchRequest(config) {
  throwIfCancellationRequested(config);

  // Ensure headers exist
  config.headers = config.headers || {};

  // Transform request data
  config.data = transformData(
    config.data,
    config.headers,
    config.transformRequest
  );

  // Flatten headers
  config.headers = utils.merge(
    config.headers.common || {},
    config.headers[config.method] || {},
    config.headers
  );

  utils.forEach(
    ['delete', 'get', 'head', 'post', 'put', 'patch', 'common'],
    function cleanHeaderConfig(method) {
      delete config.headers[method];
    }
  );

  var adapter = config.adapter || defaults.adapter;

  return adapter(config).then(function onAdapterResolution(response) {
    throwIfCancellationRequested(config);

    // Transform response data
    response.data = transformData(
      response.data,
      response.headers,
      config.transformResponse
    );

    return response;
  }, function onAdapterRejection(reason) {
    if (!isCancel(reason)) {
      throwIfCancellationRequested(config);

      // Transform response data
      if (reason && reason.response) {
        reason.response.data = transformData(
          reason.response.data,
          reason.response.headers,
          config.transformResponse
        );
      }
    }

    return Promise.reject(reason);
  });
};


/***/ }),

/***/ "./node_modules/axios/lib/core/enhanceError.js":
/*!*****************************************************!*\
  !*** ./node_modules/axios/lib/core/enhanceError.js ***!
  \*****************************************************/
/***/ ((module) => {

"use strict";


/**
 * Update an Error with the specified config, error code, and response.
 *
 * @param {Error} error The error to update.
 * @param {Object} config The config.
 * @param {string} [code] The error code (for example, 'ECONNABORTED').
 * @param {Object} [request] The request.
 * @param {Object} [response] The response.
 * @returns {Error} The error.
 */
module.exports = function enhanceError(error, config, code, request, response) {
  error.config = config;
  if (code) {
    error.code = code;
  }

  error.request = request;
  error.response = response;
  error.isAxiosError = true;

  error.toJSON = function toJSON() {
    return {
      // Standard
      message: this.message,
      name: this.name,
      // Microsoft
      description: this.description,
      number: this.number,
      // Mozilla
      fileName: this.fileName,
      lineNumber: this.lineNumber,
      columnNumber: this.columnNumber,
      stack: this.stack,
      // Axios
      config: this.config,
      code: this.code
    };
  };
  return error;
};


/***/ }),

/***/ "./node_modules/axios/lib/core/mergeConfig.js":
/*!****************************************************!*\
  !*** ./node_modules/axios/lib/core/mergeConfig.js ***!
  \****************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var utils = __webpack_require__(/*! ../utils */ "./node_modules/axios/lib/utils.js");

/**
 * Config-specific merge-function which creates a new config-object
 * by merging two configuration objects together.
 *
 * @param {Object} config1
 * @param {Object} config2
 * @returns {Object} New object resulting from merging config2 to config1
 */
module.exports = function mergeConfig(config1, config2) {
  // eslint-disable-next-line no-param-reassign
  config2 = config2 || {};
  var config = {};

  var valueFromConfig2Keys = ['url', 'method', 'data'];
  var mergeDeepPropertiesKeys = ['headers', 'auth', 'proxy', 'params'];
  var defaultToConfig2Keys = [
    'baseURL', 'transformRequest', 'transformResponse', 'paramsSerializer',
    'timeout', 'timeoutMessage', 'withCredentials', 'adapter', 'responseType', 'xsrfCookieName',
    'xsrfHeaderName', 'onUploadProgress', 'onDownloadProgress', 'decompress',
    'maxContentLength', 'maxBodyLength', 'maxRedirects', 'transport', 'httpAgent',
    'httpsAgent', 'cancelToken', 'socketPath', 'responseEncoding'
  ];
  var directMergeKeys = ['validateStatus'];

  function getMergedValue(target, source) {
    if (utils.isPlainObject(target) && utils.isPlainObject(source)) {
      return utils.merge(target, source);
    } else if (utils.isPlainObject(source)) {
      return utils.merge({}, source);
    } else if (utils.isArray(source)) {
      return source.slice();
    }
    return source;
  }

  function mergeDeepProperties(prop) {
    if (!utils.isUndefined(config2[prop])) {
      config[prop] = getMergedValue(config1[prop], config2[prop]);
    } else if (!utils.isUndefined(config1[prop])) {
      config[prop] = getMergedValue(undefined, config1[prop]);
    }
  }

  utils.forEach(valueFromConfig2Keys, function valueFromConfig2(prop) {
    if (!utils.isUndefined(config2[prop])) {
      config[prop] = getMergedValue(undefined, config2[prop]);
    }
  });

  utils.forEach(mergeDeepPropertiesKeys, mergeDeepProperties);

  utils.forEach(defaultToConfig2Keys, function defaultToConfig2(prop) {
    if (!utils.isUndefined(config2[prop])) {
      config[prop] = getMergedValue(undefined, config2[prop]);
    } else if (!utils.isUndefined(config1[prop])) {
      config[prop] = getMergedValue(undefined, config1[prop]);
    }
  });

  utils.forEach(directMergeKeys, function merge(prop) {
    if (prop in config2) {
      config[prop] = getMergedValue(config1[prop], config2[prop]);
    } else if (prop in config1) {
      config[prop] = getMergedValue(undefined, config1[prop]);
    }
  });

  var axiosKeys = valueFromConfig2Keys
    .concat(mergeDeepPropertiesKeys)
    .concat(defaultToConfig2Keys)
    .concat(directMergeKeys);

  var otherKeys = Object
    .keys(config1)
    .concat(Object.keys(config2))
    .filter(function filterAxiosKeys(key) {
      return axiosKeys.indexOf(key) === -1;
    });

  utils.forEach(otherKeys, mergeDeepProperties);

  return config;
};


/***/ }),

/***/ "./node_modules/axios/lib/core/settle.js":
/*!***********************************************!*\
  !*** ./node_modules/axios/lib/core/settle.js ***!
  \***********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var createError = __webpack_require__(/*! ./createError */ "./node_modules/axios/lib/core/createError.js");

/**
 * Resolve or reject a Promise based on response status.
 *
 * @param {Function} resolve A function that resolves the promise.
 * @param {Function} reject A function that rejects the promise.
 * @param {object} response The response.
 */
module.exports = function settle(resolve, reject, response) {
  var validateStatus = response.config.validateStatus;
  if (!response.status || !validateStatus || validateStatus(response.status)) {
    resolve(response);
  } else {
    reject(createError(
      'Request failed with status code ' + response.status,
      response.config,
      null,
      response.request,
      response
    ));
  }
};


/***/ }),

/***/ "./node_modules/axios/lib/core/transformData.js":
/*!******************************************************!*\
  !*** ./node_modules/axios/lib/core/transformData.js ***!
  \******************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var utils = __webpack_require__(/*! ./../utils */ "./node_modules/axios/lib/utils.js");

/**
 * Transform the data for a request or a response
 *
 * @param {Object|String} data The data to be transformed
 * @param {Array} headers The headers for the request or response
 * @param {Array|Function} fns A single function or Array of functions
 * @returns {*} The resulting transformed data
 */
module.exports = function transformData(data, headers, fns) {
  /*eslint no-param-reassign:0*/
  utils.forEach(fns, function transform(fn) {
    data = fn(data, headers);
  });

  return data;
};


/***/ }),

/***/ "./node_modules/axios/lib/defaults.js":
/*!********************************************!*\
  !*** ./node_modules/axios/lib/defaults.js ***!
  \********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var process = __webpack_require__(/*! process/browser */ "./node_modules/process/browser.js");


var utils = __webpack_require__(/*! ./utils */ "./node_modules/axios/lib/utils.js");
var normalizeHeaderName = __webpack_require__(/*! ./helpers/normalizeHeaderName */ "./node_modules/axios/lib/helpers/normalizeHeaderName.js");

var DEFAULT_CONTENT_TYPE = {
  'Content-Type': 'application/x-www-form-urlencoded'
};

function setContentTypeIfUnset(headers, value) {
  if (!utils.isUndefined(headers) && utils.isUndefined(headers['Content-Type'])) {
    headers['Content-Type'] = value;
  }
}

function getDefaultAdapter() {
  var adapter;
  if (typeof XMLHttpRequest !== 'undefined') {
    // For browsers use XHR adapter
    adapter = __webpack_require__(/*! ./adapters/xhr */ "./node_modules/axios/lib/adapters/xhr.js");
  } else if (typeof process !== 'undefined' && Object.prototype.toString.call(process) === '[object process]') {
    // For node use HTTP adapter
    adapter = __webpack_require__(/*! ./adapters/http */ "./node_modules/axios/lib/adapters/xhr.js");
  }
  return adapter;
}

var defaults = {
  adapter: getDefaultAdapter(),

  transformRequest: [function transformRequest(data, headers) {
    normalizeHeaderName(headers, 'Accept');
    normalizeHeaderName(headers, 'Content-Type');
    if (utils.isFormData(data) ||
      utils.isArrayBuffer(data) ||
      utils.isBuffer(data) ||
      utils.isStream(data) ||
      utils.isFile(data) ||
      utils.isBlob(data)
    ) {
      return data;
    }
    if (utils.isArrayBufferView(data)) {
      return data.buffer;
    }
    if (utils.isURLSearchParams(data)) {
      setContentTypeIfUnset(headers, 'application/x-www-form-urlencoded;charset=utf-8');
      return data.toString();
    }
    if (utils.isObject(data)) {
      setContentTypeIfUnset(headers, 'application/json;charset=utf-8');
      return JSON.stringify(data);
    }
    return data;
  }],

  transformResponse: [function transformResponse(data) {
    /*eslint no-param-reassign:0*/
    if (typeof data === 'string') {
      try {
        data = JSON.parse(data);
      } catch (e) { /* Ignore */ }
    }
    return data;
  }],

  /**
   * A timeout in milliseconds to abort a request. If set to 0 (default) a
   * timeout is not created.
   */
  timeout: 0,

  xsrfCookieName: 'XSRF-TOKEN',
  xsrfHeaderName: 'X-XSRF-TOKEN',

  maxContentLength: -1,
  maxBodyLength: -1,

  validateStatus: function validateStatus(status) {
    return status >= 200 && status < 300;
  }
};

defaults.headers = {
  common: {
    'Accept': 'application/json, text/plain, */*'
  }
};

utils.forEach(['delete', 'get', 'head'], function forEachMethodNoData(method) {
  defaults.headers[method] = {};
});

utils.forEach(['post', 'put', 'patch'], function forEachMethodWithData(method) {
  defaults.headers[method] = utils.merge(DEFAULT_CONTENT_TYPE);
});

module.exports = defaults;


/***/ }),

/***/ "./node_modules/axios/lib/helpers/bind.js":
/*!************************************************!*\
  !*** ./node_modules/axios/lib/helpers/bind.js ***!
  \************************************************/
/***/ ((module) => {

"use strict";


module.exports = function bind(fn, thisArg) {
  return function wrap() {
    var args = new Array(arguments.length);
    for (var i = 0; i < args.length; i++) {
      args[i] = arguments[i];
    }
    return fn.apply(thisArg, args);
  };
};


/***/ }),

/***/ "./node_modules/axios/lib/helpers/buildURL.js":
/*!****************************************************!*\
  !*** ./node_modules/axios/lib/helpers/buildURL.js ***!
  \****************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var utils = __webpack_require__(/*! ./../utils */ "./node_modules/axios/lib/utils.js");

function encode(val) {
  return encodeURIComponent(val).
    replace(/%3A/gi, ':').
    replace(/%24/g, '$').
    replace(/%2C/gi, ',').
    replace(/%20/g, '+').
    replace(/%5B/gi, '[').
    replace(/%5D/gi, ']');
}

/**
 * Build a URL by appending params to the end
 *
 * @param {string} url The base of the url (e.g., http://www.google.com)
 * @param {object} [params] The params to be appended
 * @returns {string} The formatted url
 */
module.exports = function buildURL(url, params, paramsSerializer) {
  /*eslint no-param-reassign:0*/
  if (!params) {
    return url;
  }

  var serializedParams;
  if (paramsSerializer) {
    serializedParams = paramsSerializer(params);
  } else if (utils.isURLSearchParams(params)) {
    serializedParams = params.toString();
  } else {
    var parts = [];

    utils.forEach(params, function serialize(val, key) {
      if (val === null || typeof val === 'undefined') {
        return;
      }

      if (utils.isArray(val)) {
        key = key + '[]';
      } else {
        val = [val];
      }

      utils.forEach(val, function parseValue(v) {
        if (utils.isDate(v)) {
          v = v.toISOString();
        } else if (utils.isObject(v)) {
          v = JSON.stringify(v);
        }
        parts.push(encode(key) + '=' + encode(v));
      });
    });

    serializedParams = parts.join('&');
  }

  if (serializedParams) {
    var hashmarkIndex = url.indexOf('#');
    if (hashmarkIndex !== -1) {
      url = url.slice(0, hashmarkIndex);
    }

    url += (url.indexOf('?') === -1 ? '?' : '&') + serializedParams;
  }

  return url;
};


/***/ }),

/***/ "./node_modules/axios/lib/helpers/combineURLs.js":
/*!*******************************************************!*\
  !*** ./node_modules/axios/lib/helpers/combineURLs.js ***!
  \*******************************************************/
/***/ ((module) => {

"use strict";


/**
 * Creates a new URL by combining the specified URLs
 *
 * @param {string} baseURL The base URL
 * @param {string} relativeURL The relative URL
 * @returns {string} The combined URL
 */
module.exports = function combineURLs(baseURL, relativeURL) {
  return relativeURL
    ? baseURL.replace(/\/+$/, '') + '/' + relativeURL.replace(/^\/+/, '')
    : baseURL;
};


/***/ }),

/***/ "./node_modules/axios/lib/helpers/cookies.js":
/*!***************************************************!*\
  !*** ./node_modules/axios/lib/helpers/cookies.js ***!
  \***************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var utils = __webpack_require__(/*! ./../utils */ "./node_modules/axios/lib/utils.js");

module.exports = (
  utils.isStandardBrowserEnv() ?

  // Standard browser envs support document.cookie
    (function standardBrowserEnv() {
      return {
        write: function write(name, value, expires, path, domain, secure) {
          var cookie = [];
          cookie.push(name + '=' + encodeURIComponent(value));

          if (utils.isNumber(expires)) {
            cookie.push('expires=' + new Date(expires).toGMTString());
          }

          if (utils.isString(path)) {
            cookie.push('path=' + path);
          }

          if (utils.isString(domain)) {
            cookie.push('domain=' + domain);
          }

          if (secure === true) {
            cookie.push('secure');
          }

          document.cookie = cookie.join('; ');
        },

        read: function read(name) {
          var match = document.cookie.match(new RegExp('(^|;\\s*)(' + name + ')=([^;]*)'));
          return (match ? decodeURIComponent(match[3]) : null);
        },

        remove: function remove(name) {
          this.write(name, '', Date.now() - 86400000);
        }
      };
    })() :

  // Non standard browser env (web workers, react-native) lack needed support.
    (function nonStandardBrowserEnv() {
      return {
        write: function write() {},
        read: function read() { return null; },
        remove: function remove() {}
      };
    })()
);


/***/ }),

/***/ "./node_modules/axios/lib/helpers/isAbsoluteURL.js":
/*!*********************************************************!*\
  !*** ./node_modules/axios/lib/helpers/isAbsoluteURL.js ***!
  \*********************************************************/
/***/ ((module) => {

"use strict";


/**
 * Determines whether the specified URL is absolute
 *
 * @param {string} url The URL to test
 * @returns {boolean} True if the specified URL is absolute, otherwise false
 */
module.exports = function isAbsoluteURL(url) {
  // A URL is considered absolute if it begins with "<scheme>://" or "//" (protocol-relative URL).
  // RFC 3986 defines scheme name as a sequence of characters beginning with a letter and followed
  // by any combination of letters, digits, plus, period, or hyphen.
  return /^([a-z][a-z\d\+\-\.]*:)?\/\//i.test(url);
};


/***/ }),

/***/ "./node_modules/axios/lib/helpers/isAxiosError.js":
/*!********************************************************!*\
  !*** ./node_modules/axios/lib/helpers/isAxiosError.js ***!
  \********************************************************/
/***/ ((module) => {

"use strict";


/**
 * Determines whether the payload is an error thrown by Axios
 *
 * @param {*} payload The value to test
 * @returns {boolean} True if the payload is an error thrown by Axios, otherwise false
 */
module.exports = function isAxiosError(payload) {
  return (typeof payload === 'object') && (payload.isAxiosError === true);
};


/***/ }),

/***/ "./node_modules/axios/lib/helpers/isURLSameOrigin.js":
/*!***********************************************************!*\
  !*** ./node_modules/axios/lib/helpers/isURLSameOrigin.js ***!
  \***********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var utils = __webpack_require__(/*! ./../utils */ "./node_modules/axios/lib/utils.js");

module.exports = (
  utils.isStandardBrowserEnv() ?

  // Standard browser envs have full support of the APIs needed to test
  // whether the request URL is of the same origin as current location.
    (function standardBrowserEnv() {
      var msie = /(msie|trident)/i.test(navigator.userAgent);
      var urlParsingNode = document.createElement('a');
      var originURL;

      /**
    * Parse a URL to discover it's components
    *
    * @param {String} url The URL to be parsed
    * @returns {Object}
    */
      function resolveURL(url) {
        var href = url;

        if (msie) {
        // IE needs attribute set twice to normalize properties
          urlParsingNode.setAttribute('href', href);
          href = urlParsingNode.href;
        }

        urlParsingNode.setAttribute('href', href);

        // urlParsingNode provides the UrlUtils interface - http://url.spec.whatwg.org/#urlutils
        return {
          href: urlParsingNode.href,
          protocol: urlParsingNode.protocol ? urlParsingNode.protocol.replace(/:$/, '') : '',
          host: urlParsingNode.host,
          search: urlParsingNode.search ? urlParsingNode.search.replace(/^\?/, '') : '',
          hash: urlParsingNode.hash ? urlParsingNode.hash.replace(/^#/, '') : '',
          hostname: urlParsingNode.hostname,
          port: urlParsingNode.port,
          pathname: (urlParsingNode.pathname.charAt(0) === '/') ?
            urlParsingNode.pathname :
            '/' + urlParsingNode.pathname
        };
      }

      originURL = resolveURL(window.location.href);

      /**
    * Determine if a URL shares the same origin as the current location
    *
    * @param {String} requestURL The URL to test
    * @returns {boolean} True if URL shares the same origin, otherwise false
    */
      return function isURLSameOrigin(requestURL) {
        var parsed = (utils.isString(requestURL)) ? resolveURL(requestURL) : requestURL;
        return (parsed.protocol === originURL.protocol &&
            parsed.host === originURL.host);
      };
    })() :

  // Non standard browser envs (web workers, react-native) lack needed support.
    (function nonStandardBrowserEnv() {
      return function isURLSameOrigin() {
        return true;
      };
    })()
);


/***/ }),

/***/ "./node_modules/axios/lib/helpers/normalizeHeaderName.js":
/*!***************************************************************!*\
  !*** ./node_modules/axios/lib/helpers/normalizeHeaderName.js ***!
  \***************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var utils = __webpack_require__(/*! ../utils */ "./node_modules/axios/lib/utils.js");

module.exports = function normalizeHeaderName(headers, normalizedName) {
  utils.forEach(headers, function processHeader(value, name) {
    if (name !== normalizedName && name.toUpperCase() === normalizedName.toUpperCase()) {
      headers[normalizedName] = value;
      delete headers[name];
    }
  });
};


/***/ }),

/***/ "./node_modules/axios/lib/helpers/parseHeaders.js":
/*!********************************************************!*\
  !*** ./node_modules/axios/lib/helpers/parseHeaders.js ***!
  \********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var utils = __webpack_require__(/*! ./../utils */ "./node_modules/axios/lib/utils.js");

// Headers whose duplicates are ignored by node
// c.f. https://nodejs.org/api/http.html#http_message_headers
var ignoreDuplicateOf = [
  'age', 'authorization', 'content-length', 'content-type', 'etag',
  'expires', 'from', 'host', 'if-modified-since', 'if-unmodified-since',
  'last-modified', 'location', 'max-forwards', 'proxy-authorization',
  'referer', 'retry-after', 'user-agent'
];

/**
 * Parse headers into an object
 *
 * ```
 * Date: Wed, 27 Aug 2014 08:58:49 GMT
 * Content-Type: application/json
 * Connection: keep-alive
 * Transfer-Encoding: chunked
 * ```
 *
 * @param {String} headers Headers needing to be parsed
 * @returns {Object} Headers parsed into an object
 */
module.exports = function parseHeaders(headers) {
  var parsed = {};
  var key;
  var val;
  var i;

  if (!headers) { return parsed; }

  utils.forEach(headers.split('\n'), function parser(line) {
    i = line.indexOf(':');
    key = utils.trim(line.substr(0, i)).toLowerCase();
    val = utils.trim(line.substr(i + 1));

    if (key) {
      if (parsed[key] && ignoreDuplicateOf.indexOf(key) >= 0) {
        return;
      }
      if (key === 'set-cookie') {
        parsed[key] = (parsed[key] ? parsed[key] : []).concat([val]);
      } else {
        parsed[key] = parsed[key] ? parsed[key] + ', ' + val : val;
      }
    }
  });

  return parsed;
};


/***/ }),

/***/ "./node_modules/axios/lib/helpers/spread.js":
/*!**************************************************!*\
  !*** ./node_modules/axios/lib/helpers/spread.js ***!
  \**************************************************/
/***/ ((module) => {

"use strict";


/**
 * Syntactic sugar for invoking a function and expanding an array for arguments.
 *
 * Common use case would be to use `Function.prototype.apply`.
 *
 *  ```js
 *  function f(x, y, z) {}
 *  var args = [1, 2, 3];
 *  f.apply(null, args);
 *  ```
 *
 * With `spread` this example can be re-written.
 *
 *  ```js
 *  spread(function(x, y, z) {})([1, 2, 3]);
 *  ```
 *
 * @param {Function} callback
 * @returns {Function}
 */
module.exports = function spread(callback) {
  return function wrap(arr) {
    return callback.apply(null, arr);
  };
};


/***/ }),

/***/ "./node_modules/axios/lib/utils.js":
/*!*****************************************!*\
  !*** ./node_modules/axios/lib/utils.js ***!
  \*****************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var bind = __webpack_require__(/*! ./helpers/bind */ "./node_modules/axios/lib/helpers/bind.js");

/*global toString:true*/

// utils is a library of generic helper functions non-specific to axios

var toString = Object.prototype.toString;

/**
 * Determine if a value is an Array
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is an Array, otherwise false
 */
function isArray(val) {
  return toString.call(val) === '[object Array]';
}

/**
 * Determine if a value is undefined
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if the value is undefined, otherwise false
 */
function isUndefined(val) {
  return typeof val === 'undefined';
}

/**
 * Determine if a value is a Buffer
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is a Buffer, otherwise false
 */
function isBuffer(val) {
  return val !== null && !isUndefined(val) && val.constructor !== null && !isUndefined(val.constructor)
    && typeof val.constructor.isBuffer === 'function' && val.constructor.isBuffer(val);
}

/**
 * Determine if a value is an ArrayBuffer
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is an ArrayBuffer, otherwise false
 */
function isArrayBuffer(val) {
  return toString.call(val) === '[object ArrayBuffer]';
}

/**
 * Determine if a value is a FormData
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is an FormData, otherwise false
 */
function isFormData(val) {
  return (typeof FormData !== 'undefined') && (val instanceof FormData);
}

/**
 * Determine if a value is a view on an ArrayBuffer
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is a view on an ArrayBuffer, otherwise false
 */
function isArrayBufferView(val) {
  var result;
  if ((typeof ArrayBuffer !== 'undefined') && (ArrayBuffer.isView)) {
    result = ArrayBuffer.isView(val);
  } else {
    result = (val) && (val.buffer) && (val.buffer instanceof ArrayBuffer);
  }
  return result;
}

/**
 * Determine if a value is a String
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is a String, otherwise false
 */
function isString(val) {
  return typeof val === 'string';
}

/**
 * Determine if a value is a Number
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is a Number, otherwise false
 */
function isNumber(val) {
  return typeof val === 'number';
}

/**
 * Determine if a value is an Object
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is an Object, otherwise false
 */
function isObject(val) {
  return val !== null && typeof val === 'object';
}

/**
 * Determine if a value is a plain Object
 *
 * @param {Object} val The value to test
 * @return {boolean} True if value is a plain Object, otherwise false
 */
function isPlainObject(val) {
  if (toString.call(val) !== '[object Object]') {
    return false;
  }

  var prototype = Object.getPrototypeOf(val);
  return prototype === null || prototype === Object.prototype;
}

/**
 * Determine if a value is a Date
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is a Date, otherwise false
 */
function isDate(val) {
  return toString.call(val) === '[object Date]';
}

/**
 * Determine if a value is a File
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is a File, otherwise false
 */
function isFile(val) {
  return toString.call(val) === '[object File]';
}

/**
 * Determine if a value is a Blob
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is a Blob, otherwise false
 */
function isBlob(val) {
  return toString.call(val) === '[object Blob]';
}

/**
 * Determine if a value is a Function
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is a Function, otherwise false
 */
function isFunction(val) {
  return toString.call(val) === '[object Function]';
}

/**
 * Determine if a value is a Stream
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is a Stream, otherwise false
 */
function isStream(val) {
  return isObject(val) && isFunction(val.pipe);
}

/**
 * Determine if a value is a URLSearchParams object
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is a URLSearchParams object, otherwise false
 */
function isURLSearchParams(val) {
  return typeof URLSearchParams !== 'undefined' && val instanceof URLSearchParams;
}

/**
 * Trim excess whitespace off the beginning and end of a string
 *
 * @param {String} str The String to trim
 * @returns {String} The String freed of excess whitespace
 */
function trim(str) {
  return str.replace(/^\s*/, '').replace(/\s*$/, '');
}

/**
 * Determine if we're running in a standard browser environment
 *
 * This allows axios to run in a web worker, and react-native.
 * Both environments support XMLHttpRequest, but not fully standard globals.
 *
 * web workers:
 *  typeof window -> undefined
 *  typeof document -> undefined
 *
 * react-native:
 *  navigator.product -> 'ReactNative'
 * nativescript
 *  navigator.product -> 'NativeScript' or 'NS'
 */
function isStandardBrowserEnv() {
  if (typeof navigator !== 'undefined' && (navigator.product === 'ReactNative' ||
                                           navigator.product === 'NativeScript' ||
                                           navigator.product === 'NS')) {
    return false;
  }
  return (
    typeof window !== 'undefined' &&
    typeof document !== 'undefined'
  );
}

/**
 * Iterate over an Array or an Object invoking a function for each item.
 *
 * If `obj` is an Array callback will be called passing
 * the value, index, and complete array for each item.
 *
 * If 'obj' is an Object callback will be called passing
 * the value, key, and complete object for each property.
 *
 * @param {Object|Array} obj The object to iterate
 * @param {Function} fn The callback to invoke for each item
 */
function forEach(obj, fn) {
  // Don't bother if no value provided
  if (obj === null || typeof obj === 'undefined') {
    return;
  }

  // Force an array if not already something iterable
  if (typeof obj !== 'object') {
    /*eslint no-param-reassign:0*/
    obj = [obj];
  }

  if (isArray(obj)) {
    // Iterate over array values
    for (var i = 0, l = obj.length; i < l; i++) {
      fn.call(null, obj[i], i, obj);
    }
  } else {
    // Iterate over object keys
    for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        fn.call(null, obj[key], key, obj);
      }
    }
  }
}

/**
 * Accepts varargs expecting each argument to be an object, then
 * immutably merges the properties of each object and returns result.
 *
 * When multiple objects contain the same key the later object in
 * the arguments list will take precedence.
 *
 * Example:
 *
 * ```js
 * var result = merge({foo: 123}, {foo: 456});
 * console.log(result.foo); // outputs 456
 * ```
 *
 * @param {Object} obj1 Object to merge
 * @returns {Object} Result of all merge properties
 */
function merge(/* obj1, obj2, obj3, ... */) {
  var result = {};
  function assignValue(val, key) {
    if (isPlainObject(result[key]) && isPlainObject(val)) {
      result[key] = merge(result[key], val);
    } else if (isPlainObject(val)) {
      result[key] = merge({}, val);
    } else if (isArray(val)) {
      result[key] = val.slice();
    } else {
      result[key] = val;
    }
  }

  for (var i = 0, l = arguments.length; i < l; i++) {
    forEach(arguments[i], assignValue);
  }
  return result;
}

/**
 * Extends object a by mutably adding to it the properties of object b.
 *
 * @param {Object} a The object to be extended
 * @param {Object} b The object to copy properties from
 * @param {Object} thisArg The object to bind function to
 * @return {Object} The resulting value of object a
 */
function extend(a, b, thisArg) {
  forEach(b, function assignValue(val, key) {
    if (thisArg && typeof val === 'function') {
      a[key] = bind(val, thisArg);
    } else {
      a[key] = val;
    }
  });
  return a;
}

/**
 * Remove byte order marker. This catches EF BB BF (the UTF-8 BOM)
 *
 * @param {string} content with BOM
 * @return {string} content value without BOM
 */
function stripBOM(content) {
  if (content.charCodeAt(0) === 0xFEFF) {
    content = content.slice(1);
  }
  return content;
}

module.exports = {
  isArray: isArray,
  isArrayBuffer: isArrayBuffer,
  isBuffer: isBuffer,
  isFormData: isFormData,
  isArrayBufferView: isArrayBufferView,
  isString: isString,
  isNumber: isNumber,
  isObject: isObject,
  isPlainObject: isPlainObject,
  isUndefined: isUndefined,
  isDate: isDate,
  isFile: isFile,
  isBlob: isBlob,
  isFunction: isFunction,
  isStream: isStream,
  isURLSearchParams: isURLSearchParams,
  isStandardBrowserEnv: isStandardBrowserEnv,
  forEach: forEach,
  merge: merge,
  extend: extend,
  trim: trim,
  stripBOM: stripBOM
};


/***/ }),

/***/ "./resources/js/app.js":
/*!*****************************!*\
  !*** ./resources/js/app.js ***!
  \*****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var grapesjs_preset_webpage__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! grapesjs-preset-webpage */ "./node_modules/grapesjs-preset-webpage/dist/grapesjs-preset-webpage.min.js");
/* harmony import */ var grapesjs_preset_webpage__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(grapesjs_preset_webpage__WEBPACK_IMPORTED_MODULE_0__);
__webpack_require__(/*! ./bootstrap */ "./resources/js/bootstrap.js");

__webpack_require__(/*! livewire-sortable */ "./node_modules/livewire-sortable/dist/livewire-sortable.js");

window.grapesjs = __webpack_require__(/*! grapesjs */ "./node_modules/grapesjs/dist/grapes.min.js");

__webpack_require__(/*! grapesjs-preset-webpage */ "./node_modules/grapesjs-preset-webpage/dist/grapesjs-preset-webpage.min.js");



__webpack_require__(/*! alpinejs */ "./node_modules/alpinejs/dist/alpine.js");

/***/ }),

/***/ "./resources/js/bootstrap.js":
/*!***********************************!*\
  !*** ./resources/js/bootstrap.js ***!
  \***********************************/
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

window._ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/**
 * We'll load the axios HTTP library which allows us to easily issue requests
 * to our Laravel back-end. This library automatically handles sending the
 * CSRF token as a header based on the value of the "XSRF" token cookie.
 */

window.axios = __webpack_require__(/*! axios */ "./node_modules/axios/index.js");
window.axios.defaults.headers.common['X-Requested-With'] = 'XMLHttpRequest';
/**
 * Echo exposes an expressive API for subscribing to channels and listening
 * for events that are broadcast by Laravel. Echo and event broadcasting
 * allows your team to easily build robust real-time web applications.
 */
// import Echo from 'laravel-echo';
// window.Pusher = require('pusher-js');
// window.Echo = new Echo({
//     broadcaster: 'pusher',
//     key: process.env.MIX_PUSHER_APP_KEY,
//     cluster: process.env.MIX_PUSHER_APP_CLUSTER,
//     forceTLS: true
// });

/***/ }),

/***/ "./node_modules/grapesjs-preset-webpage/dist/grapesjs-preset-webpage.min.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/grapesjs-preset-webpage/dist/grapesjs-preset-webpage.min.js ***!
  \**********************************************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

/*! grapesjs-preset-webpage - 0.1.11 */
!function(e,t){ true?module.exports=t(__webpack_require__(/*! grapesjs */ "./node_modules/grapesjs/dist/grapes.min.js")):0}("undefined"!=typeof self?self:this,function(e){return function(e){function t(r){if(n[r])return n[r].exports;var i=n[r]={i:r,l:!1,exports:{}};return e[r].call(i.exports,i,i.exports,t),i.l=!0,i.exports}var n={};return t.m=e,t.c=n,t.d=function(e,n,r){t.o(e,n)||Object.defineProperty(e,n,{configurable:!1,enumerable:!0,get:r})},t.n=function(e){var n=e&&e.__esModule?function(){return e.default}:function(){return e};return t.d(n,"a",n),n},t.o=function(e,t){return Object.prototype.hasOwnProperty.call(e,t)},t.p="",t(t.s=4)}([function(t,n){t.exports=e},function(e,t,n){(function(e){function r(e,t){this._id=e,this._clearFn=t}var i=Function.prototype.apply;t.setTimeout=function(){return new r(i.call(setTimeout,window,arguments),clearTimeout)},t.setInterval=function(){return new r(i.call(setInterval,window,arguments),clearInterval)},t.clearTimeout=t.clearInterval=function(e){e&&e.close()},r.prototype.unref=r.prototype.ref=function(){},r.prototype.close=function(){this._clearFn.call(window,this._id)},t.enroll=function(e,t){clearTimeout(e._idleTimeoutId),e._idleTimeout=t},t.unenroll=function(e){clearTimeout(e._idleTimeoutId),e._idleTimeout=-1},t._unrefActive=t.active=function(e){clearTimeout(e._idleTimeoutId);var t=e._idleTimeout;t>=0&&(e._idleTimeoutId=setTimeout(function(){e._onTimeout&&e._onTimeout()},t))},n(10),t.setImmediate="undefined"!=typeof self&&self.setImmediate||void 0!==e&&e.setImmediate||this&&this.setImmediate,t.clearImmediate="undefined"!=typeof self&&self.clearImmediate||void 0!==e&&e.clearImmediate||this&&this.clearImmediate}).call(t,n(2))},function(e,t){var n;n=function(){return this}();try{n=n||Function("return this")()||(0,eval)("this")}catch(e){"object"==typeof window&&(n=window)}e.exports=n},function(e,t,n){"use strict";Object.defineProperty(t,"__esModule",{value:!0});t.cmdImport="gjs-open-import-webpage",t.cmdDeviceDesktop="set-device-desktop",t.cmdDeviceTablet="set-device-tablet",t.cmdDeviceMobile="set-device-mobile",t.cmdClear="canvas-clear"},function(e,t,n){"use strict";function r(e){return e&&e.__esModule?e:{default:e}}Object.defineProperty(t,"__esModule",{value:!0});var i=n(0),a=r(i),o=n(5),s=r(o),l=n(6),u=r(l),c=n(7),f=r(c),h=n(8),d=r(h),p=n(9),m=r(p),g=n(12),v=r(g),b=n(13),y=r(b),w=n(14),_=r(w),k=n(16),x=r(k),S=n(17),E=r(S),T=n(18),C=r(T),A=n(19),O=r(A);t.default=a.default.plugins.add("gjs-preset-webpage",function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},n=t,r={blocks:["link-block","quote","text-basic"],modalImportTitle:"Import",modalImportButton:"Import",modalImportLabel:"",modalImportContent:"",importViewerOptions:{},textCleanCanvas:"Are you sure to clean the canvas?",showStylesOnChange:1,textGeneral:"General",textLayout:"Layout",textTypography:"Typography",textDecorations:"Decorations",textExtra:"Extra",customStyleManager:[],blocksBasicOpts:{},navbarOpts:{},countdownOpts:{},formsOpts:{},exportOpts:{},aviaryOpts:0,filestackOpts:0};for(var i in r)i in n||(n[i]=r[i]);var a=n.blocksBasicOpts,o=n.navbarOpts,l=n.countdownOpts,c=n.formsOpts,h=n.exportOpts,p=n.aviaryOpts,g=n.filestackOpts;a&&(0,s.default)(e,a),o&&(0,u.default)(e,o),l&&(0,f.default)(e,l),c&&(0,d.default)(e,c),h&&(0,m.default)(e,h),p&&(0,v.default)(e,p),g&&(0,y.default)(e,g),(0,E.default)(e,n),(0,x.default)(e,n),(0,_.default)(e,n),(0,C.default)(e,n),(0,O.default)(e,n)})},function(e,t,n){/*! grapesjs-blocks-basic - 0.1.7 */
!function(t,r){e.exports=r(n(0))}(0,function(e){return function(e){function t(r){if(n[r])return n[r].exports;var i=n[r]={i:r,l:!1,exports:{}};return e[r].call(i.exports,i,i.exports,t),i.l=!0,i.exports}var n={};return t.m=e,t.c=n,t.d=function(e,n,r){t.o(e,n)||Object.defineProperty(e,n,{configurable:!1,enumerable:!0,get:r})},t.n=function(e){var n=e&&e.__esModule?function(){return e.default}:function(){return e};return t.d(n,"a",n),n},t.o=function(e,t){return Object.prototype.hasOwnProperty.call(e,t)},t.p="",t(t.s=0)}([function(e,t,n){"use strict";Object.defineProperty(t,"__esModule",{value:!0});var r=Object.assign||function(e){for(var t=1;t<arguments.length;t++){var n=arguments[t];for(var r in n)Object.prototype.hasOwnProperty.call(n,r)&&(e[r]=n[r])}return e},i=n(1),a=function(e){return e&&e.__esModule?e:{default:e}}(i);t.default=a.default.plugins.add("gjs-blocks-basic",function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},i=r({blocks:["column1","column2","column3","column3-7","text","link","image","video","map"],flexGrid:0,stylePrefix:"",addBasicStyle:!0,category:"Basic",labelColumn1:"1 Column",labelColumn2:"2 Columns",labelColumn3:"3 Columns",labelColumn37:"2 Columns 3/7",labelText:"Text",labelLink:"Link",labelImage:"Image",labelVideo:"Video",labelMap:"Map"},t);n(2).default(e,i)})},function(t,n){t.exports=e},function(e,t,n){"use strict";Object.defineProperty(t,"__esModule",{value:!0});var r=Object.assign||function(e){for(var t=1;t<arguments.length;t++){var n=arguments[t];for(var r in n)Object.prototype.hasOwnProperty.call(n,r)&&(e[r]=n[r])}return e};t.default=function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},n=t,i=e.BlockManager,a=n.blocks,o=n.stylePrefix,s=n.flexGrid,l=n.addBasicStyle,u=o+"row",c=o+"cell",f=s?"\n    ."+u+" {\n      display: flex;\n      justify-content: flex-start;\n      align-items: stretch;\n      flex-wrap: nowrap;\n      padding: 10px;\n    }\n    @media (max-width: 768px) {\n      ."+u+" {\n        flex-wrap: wrap;\n      }\n    }":"\n    ."+u+" {\n      display: table;\n      padding: 10px;\n      width: 100%;\n    }\n    @media (max-width: 768px) {\n      ."+o+"cell, ."+o+"cell30, ."+o+"cell70 {\n        width: 100%;\n        display: block;\n      }\n    }",h=s?"\n    ."+c+" {\n      min-height: 75px;\n      flex-grow: 1;\n      flex-basis: 100%;\n    }":"\n    ."+c+" {\n      width: 8%;\n      display: table-cell;\n      height: 75px;\n    }",d="\n  ."+o+"cell30 {\n    width: 30%;\n  }",p="\n  ."+o+"cell70 {\n    width: 70%;\n  }",m={tl:0,tc:0,tr:0,cl:0,cr:0,bl:0,br:0,minDim:1},g=r({},m,{cr:1,bc:0,currentUnit:1,minDim:1,step:.2});s&&(g.keyWidth="flex-basis");var v={class:u,"data-gjs-droppable":"."+c,"data-gjs-resizable":m,"data-gjs-name":"Row"},b={class:c,"data-gjs-draggable":"."+u,"data-gjs-resizable":g,"data-gjs-name":"Cell"};s&&(b["data-gjs-unstylable"]=["width"],b["data-gjs-stylable-require"]=["flex-basis"]);var y=["."+u,"."+c];e.on("selector:add",function(e){return y.indexOf(e.getFullName())>=0&&e.set("private",1)});var w=function(e){var t=[];for(var n in e){var r=e[n],i=r instanceof Array||r instanceof Object;r=i?JSON.stringify(r):r,t.push(n+"="+(i?"'"+r+"'":'"'+r+'"'))}return t.length?" "+t.join(" "):""},_=function(e){return a.indexOf(e)>=0},k=w(v),x=w(b);_("column1")&&i.add("column1",{label:n.labelColumn1,category:n.category,attributes:{class:"gjs-fonts gjs-f-b1"},content:"<div "+k+">\n        <div "+x+"></div>\n      </div>\n      "+(l?"<style>\n          "+f+"\n          "+h+"\n        </style>":"")}),_("column2")&&i.add("column2",{label:n.labelColumn2,attributes:{class:"gjs-fonts gjs-f-b2"},category:n.category,content:"<div "+k+">\n        <div "+x+"></div>\n        <div "+x+"></div>\n      </div>\n      "+(l?"<style>\n          "+f+"\n          "+h+"\n        </style>":"")}),_("column3")&&i.add("column3",{label:n.labelColumn3,category:n.category,attributes:{class:"gjs-fonts gjs-f-b3"},content:"<div "+k+">\n        <div "+x+"></div>\n        <div "+x+"></div>\n        <div "+x+"></div>\n      </div>\n      "+(l?"<style>\n          "+f+"\n          "+h+"\n        </style>":"")}),_("column3-7")&&i.add("column3-7",{label:n.labelColumn37,category:n.category,attributes:{class:"gjs-fonts gjs-f-b37"},content:"<div "+k+">\n        <div "+x+' style="'+(s?"flex-basis":"width")+': 30%;"></div>\n        <div '+x+' style="'+(s?"flex-basis":"width")+': 70%;"></div>\n      </div>\n      '+(l?"<style>\n          "+f+"\n          "+h+"\n          "+d+"\n          "+p+"\n        </style>":"")}),_("text")&&i.add("text",{label:n.labelText,category:n.category,attributes:{class:"gjs-fonts gjs-f-text"},content:{type:"text",content:"Insert your text here",style:{padding:"10px"},activeOnRender:1}}),_("link")&&i.add("link",{label:n.labelLink,category:n.category,attributes:{class:"fa fa-link"},content:{type:"link",content:"Link",style:{color:"#d983a6"}}}),_("image")&&i.add("image",{label:n.labelImage,category:n.category,attributes:{class:"gjs-fonts gjs-f-image"},content:{style:{color:"black"},type:"image",activeOnRender:1}}),_("video")&&i.add("video",{label:n.labelVideo,category:n.category,attributes:{class:"fa fa-youtube-play"},content:{type:"video",src:"img/video2.webm",style:{height:"350px",width:"615px"}}}),_("map")&&i.add("map",{label:n.labelMap,category:n.category,attributes:{class:"fa fa-map-o"},content:{type:"map",style:{height:"350px"}}})}}])})},function(e,t,n){/*! grapesjs-navbar - 0.1.5 */
!function(t,r){e.exports=r(n(0))}(0,function(e){return function(e){function t(r){if(n[r])return n[r].exports;var i=n[r]={i:r,l:!1,exports:{}};return e[r].call(i.exports,i,i.exports,t),i.l=!0,i.exports}var n={};return t.m=e,t.c=n,t.d=function(e,n,r){t.o(e,n)||Object.defineProperty(e,n,{configurable:!1,enumerable:!0,get:r})},t.n=function(e){var n=e&&e.__esModule?function(){return e.default}:function(){return e};return t.d(n,"a",n),n},t.o=function(e,t){return Object.prototype.hasOwnProperty.call(e,t)},t.p="",t(t.s=1)}([function(e,t,n){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.hNavbarRef="h-navbar",t.navbarRef="navbar",t.navbarItemsRef="navbar-items",t.menuRef="navbar-menu"},function(e,t,n){"use strict";function r(e){return e&&e.__esModule?e:{default:e}}Object.defineProperty(t,"__esModule",{value:!0});var i=n(2),a=r(i),o=n(3),s=r(o),l=n(4),u=r(l),c=n(0);t.default=a.default.plugins.add("gjs-navbar",function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},n=t,r={blocks:[c.hNavbarRef],defaultStyle:1,navbarClsPfx:"navbar",labelNavbar:"Navbar",labelNavbarContainer:"Navbar Container",labelMenu:"Navbar Menu",labelMenuLink:"Menu link",labelBurger:"Burger",labelBurgerLine:"Burger Line",labelNavbarBlock:"Navbar",labelNavbarCategory:"Extra",labelHome:"Home",labelAbout:"About",labelContact:"Contact"};for(var i in r)i in n||(n[i]=r[i]);(0,s.default)(e,n),(0,u.default)(e,n)})},function(t,n){t.exports=e},function(e,t,n){"use strict";Object.defineProperty(t,"__esModule",{value:!0});var r=n(0);t.default=function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},n=t,i=e.BlockManager,a=n.navbarClsPfx||"navbar",o=n.defaultStyle?"\n  <style>\n    ."+a+"-items-c {\n      display: inline-block;\n      float: right;\n    }\n\n    ."+a+" {\n      background-color: #222;\n      color: #ddd;\n      min-height: 50px;\n      width: 100%;\n    }\n\n    ."+a+"-container {\n      max-width: 950px;\n      margin: 0 auto;\n      width: 95%;\n    }\n\n    ."+a+'-container::after {\n      content: "";\n      clear: both;\n      display: block;\n    }\n\n    .'+a+"-brand {\n      vertical-align: top;\n      display: inline-block;\n      padding: 5px;\n      min-height: 50px;\n      min-width: 50px;\n      color: inherit;\n      text-decoration: none;\n    }\n\n    ."+a+"-menu {\n      padding: 10px 0;\n      display: block;\n      float: right;\n      margin: 0;\n    }\n\n    ."+a+"-menu-link {\n      margin: 0;\n      color: inherit;\n      text-decoration: none;\n      display: inline-block;\n      padding: 10px 15px;\n    }\n\n    ."+a+"-burger {\n      margin: 10px 0;\n      width: 45px;\n      padding: 5px 10px;\n      display: none;\n      float: right;\n      cursor: pointer;\n    }\n\n    ."+a+"-burger-line {\n      padding: 1px;\n      background-color: white;\n      margin: 5px 0;\n    }\n\n    @media (max-width: 768px) {\n      ."+a+"-burger {\n        display: block;\n      }\n\n      ."+a+"-items-c {\n        display: none;\n        width: 100%;\n      }\n\n      ."+a+"-menu {\n        width: 100%;\n      }\n\n      ."+a+"-menu-link {\n        display: block;\n      }\n    }\n  </style>\n  ":"";n.blocks.indexOf(r.hNavbarRef)>=0&&i.add(r.hNavbarRef,{label:'\n        <svg class="gjs-block-svg" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">\n          <path class="gjs-block-svg-path" d="M22,9 C22,8.4 21.5,8 20.75,8 L3.25,8 C2.5,8 2,8.4 2,9 L2,15 C2,15.6 2.5,16 3.25,16 L20.75,16 C21.5,16 22,15.6 22,15 L22,9 Z M21,15 L3,15 L3,9 L21,9 L21,15 Z" fill-rule="nonzero"></path>\n          <rect class="gjs-block-svg-path" x="15" y="10" width="5" height="1"></rect>\n          <rect class="gjs-block-svg-path" x="15" y="13" width="5" height="1"></rect>\n          <rect class="gjs-block-svg-path" x="15" y="11.5" width="5" height="1"></rect>\n        </svg>\n        <div class="gjs-block-label">'+n.labelNavbarBlock+"</div>",category:n.labelNavbarCategory,content:'\n        <div class="'+a+'" data-gjs-droppable="false" data-gjs-custom-name="'+n.labelNavbar+'" data-gjs="'+r.navbarRef+'">\n          <div class="'+a+'-container" data-gjs-droppable="false" data-gjs-draggable="false"\n            data-gjs-removable="false" data-gjs-copyable="false" data-gjs-highlightable="false"\n            data-gjs-custom-name="'+n.labelNavbarContainer+'">\n\n            <a href="/" class="'+a+'-brand" data-gjs-droppable="true"></a>\n\n            <div class="'+a+'-burger" data-gjs-type="burger-menu">\n              <div class="'+a+'-burger-line" data-gjs-custom-name="'+n.labelBurgerLine+'" data-gjs-droppable="false" data-gjs-draggable="false"></div>\n              <div class="'+a+'-burger-line" data-gjs-custom-name="'+n.labelBurgerLine+'" data-gjs-droppable="false" data-gjs-draggable="false"></div>\n              <div class="'+a+'-burger-line" data-gjs-custom-name="'+n.labelBurgerLine+'" data-gjs-droppable="false" data-gjs-draggable="false"></div>\n            </div>\n\n            <div class="'+a+'-items-c" data-gjs="'+r.navbarItemsRef+'">\n              <nav class="'+a+'-menu" data-gjs="'+r.menuRef+'" data-gjs-custom-name="'+n.labelMenu+'">\n                <a href="#" class="'+a+'-menu-link" data-gjs-custom-name="'+n.labelMenuLink+'" data-gjs-draggable="[data-gjs='+r.menuRef+']">'+n.labelHome+'</a>\n                <a href="#" class="'+a+'-menu-link" data-gjs-custom-name="'+n.labelMenuLink+'" data-gjs-draggable="[data-gjs='+r.menuRef+']">'+n.labelAbout+'</a>\n                <a href="#" class="'+a+'-menu-link" data-gjs-custom-name="'+n.labelMenuLink+'" data-gjs-draggable="[data-gjs='+r.menuRef+']">'+n.labelContact+"</a>\n              </nav>\n            </div>\n\n          </div>\n        </div>\n        "+o+"\n      "})}},function(e,t,n){"use strict";Object.defineProperty(t,"__esModule",{value:!0});var r=Object.assign||function(e){for(var t=1;t<arguments.length;t++){var n=arguments[t];for(var r in n)Object.prototype.hasOwnProperty.call(n,r)&&(e[r]=n[r])}return e};t.default=function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},n=t,i=e.DomComponents,a=i.getType("default"),o=a.model;i.addType("burger-menu",{model:o.extend({defaults:r({},o.prototype.defaults,{"custom-name":n.labelBurger,draggable:!1,droppable:!1,copyable:!1,removable:!1,script:function(){var e,t=0,n=function(){var e,t=document.createElement("void"),n={transition:"transitionend",OTransition:"oTransitionEnd",MozTransition:"transitionend",WebkitTransition:"webkitTransitionEnd"};for(e in n)if(void 0!==t.style[e])return n[e]}(),r=function(e){var t=window.getComputedStyle(e),n=t.display,r=(t.position,t.visibility,t.height,parseInt(t["max-height"]));if("none"!==n&&"0"!==r)return e.offsetHeight;e.style.height="auto",e.style.display="block",e.style.position="absolute",e.style.visibility="hidden";var i=e.offsetHeight;return e.style.height="",e.style.display="",e.style.position="",e.style.visibility="",i},i=function(e){t=1;var n=r(e),i=e.style;i.display="block",i.transition="max-height 0.25s ease-in-out",i.overflowY="hidden",""==i["max-height"]&&(i["max-height"]=0),0==parseInt(i["max-height"])?(i["max-height"]="0",setTimeout(function(){i["max-height"]=n+"px"},10)):i["max-height"]="0"},a=function(r){if(r.preventDefault(),!t){var a=this.closest("[data-gjs=navbar]"),o=a.querySelector("[data-gjs=navbar-items]");i(o),e||(o.addEventListener(n,function(){t=0;var e=o.style;0==parseInt(e["max-height"])&&(e.display="",e["max-height"]="")}),e=1)}};"gjs-collapse"in this||this.addEventListener("click",a),this["gjs-collapse"]=1}})},{isComponent:function(e){if(e.getAttribute&&"burger-menu"==e.getAttribute("data-gjs-type"))return{type:"burger-menu"}}}),view:a.view})}}])})},function(e,t,n){/*! grapesjs-component-countdown - 0.1.2 */
!function(t,r){e.exports=r(n(0))}(0,function(e){return function(e){function t(r){if(n[r])return n[r].exports;var i=n[r]={i:r,l:!1,exports:{}};return e[r].call(i.exports,i,i.exports,t),i.l=!0,i.exports}var n={};return t.m=e,t.c=n,t.d=function(e,n,r){t.o(e,n)||Object.defineProperty(e,n,{configurable:!1,enumerable:!0,get:r})},t.n=function(e){var n=e&&e.__esModule?function(){return e.default}:function(){return e};return t.d(n,"a",n),n},t.o=function(e,t){return Object.prototype.hasOwnProperty.call(e,t)},t.p="",t(t.s=1)}([function(e,t,n){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.countdownRef="countdown"},function(e,t,n){"use strict";function r(e){return e&&e.__esModule?e:{default:e}}Object.defineProperty(t,"__esModule",{value:!0});var i=n(2),a=r(i),o=n(3),s=r(o),l=n(4),u=r(l),c=n(0);t.default=a.default.plugins.add("gjs-component-countdown",function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},n=t,r={blocks:[c.countdownRef],defaultStyle:!0,startTime:"",endText:"EXPIRED",dateInputType:"date",countdownClsPfx:"countdown",labelCountdown:"Countdown",labelCountdownCategory:"Extra",labelDays:"days",labelHours:"hours",labelMinutes:"minutes",labelSeconds:"seconds"};for(var i in r)i in n||(n[i]=r[i]);(0,s.default)(e,n),(0,u.default)(e,n)})},function(t,n){t.exports=e},function(e,t,n){"use strict";Object.defineProperty(t,"__esModule",{value:!0});var r=Object.assign||function(e){for(var t=1;t<arguments.length;t++){var n=arguments[t];for(var r in n)Object.prototype.hasOwnProperty.call(n,r)&&(e[r]=n[r])}return e};t.default=function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},n=t,i=e.DomComponents,a=i.getType("default"),o=i.getType("text"),s=a.model,l=a.view,u=(o.model,o.view,n.countdownClsPfx);i.addType("countdown",{model:s.extend({defaults:r({},s.prototype.defaults,{startfrom:n.startTime,endText:n.endText,droppable:!1,traits:[{label:"Start",name:"startfrom",changeProp:1,type:n.dateInputType},{label:"End text",name:"endText",changeProp:1}],script:function(){var e=new Date("{[ startfrom ]}").getTime(),t=this.querySelector("[data-js=countdown]"),n=this.querySelector("[data-js=countdown-endtext]"),r=this.querySelector("[data-js=countdown-day]"),i=this.querySelector("[data-js=countdown-hour]"),a=this.querySelector("[data-js=countdown-minute]"),o=this.querySelector("[data-js=countdown-second]"),s=this.gjs_countdown_interval;s&&s&&clearInterval(s);var l=function(e,t,n,s){r.innerHTML=e<10?"0"+e:e,i.innerHTML=t<10?"0"+t:t,a.innerHTML=n<10?"0"+n:n,o.innerHTML=s<10?"0"+s:s},u=function(){var r=(new Date).getTime(),i=e-r,a=Math.floor(i/864e5),o=Math.floor(i%864e5/36e5),s=Math.floor(i%36e4/6e4),u=Math.floor(i%6e4/1e3);l(a,o,s,u),i<0&&(clearInterval(c),n.innerHTML="{[ endText ]}",t.style.display="none",n.style.display="")};if(e){var c=setInterval(u,1e3);this.gjs_countdown_interval=c,n.style.display="none",t.style.display="",u()}else l(0,0,0,0)}})},{isComponent:function(e){if(e.getAttribute&&"countdown"==e.getAttribute("data-gjs-type"))return{type:"countdown"}}}),view:l.extend({init:function(){this.listenTo(this.model,"change:startfrom change:endText",this.updateScript);var e=this.model.get("components");e.length||(e.reset(),e.add('\n            <span data-js="countdown" class="'+u+'-cont">\n              <div class="'+u+'-block">\n                <div data-js="countdown-day" class="'+u+'-digit"></div>\n                <div class="'+u+'-label">'+n.labelDays+'</div>\n              </div>\n              <div class="'+u+'-block">\n                <div data-js="countdown-hour" class="'+u+'-digit"></div>\n                <div class="'+u+'-label">'+n.labelHours+'</div>\n              </div>\n              <div class="'+u+'-block">\n                <div data-js="countdown-minute" class="'+u+'-digit"></div>\n                <div class="'+u+'-label">'+n.labelMinutes+'</div>\n              </div>\n              <div class="'+u+'-block">\n                <div data-js="countdown-second" class="'+u+'-digit"></div>\n                <div class="'+u+'-label">'+n.labelSeconds+'</div>\n              </div>\n            </span>\n            <span data-js="countdown-endtext" class="'+u+'-endtext"></span>\n          '))}})})}},function(e,t,n){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.default=function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},n=t,i=e.BlockManager,a=n.countdownClsPfx,o=n.defaultStyle?"<style>\n    ."+a+" {\n      text-align: center;\n      font-family: Helvetica, serif;\n    }\n\n    ."+a+"-block {\n      display: inline-block;\n      margin: 0 10px;\n      padding: 10px;\n    }\n\n    ."+a+"-digit {\n      font-size: 5rem;\n    }\n\n    ."+a+"-endtext {\n      font-size: 5rem;\n    }\n\n    ."+a+"-cont,\n    ."+a+"-block {\n      display: inline-block;\n    }\n  </style>":"";n.blocks.indexOf(r.countdownRef)>=0&&i.add(r.countdownRef,{label:n.labelCountdown,category:n.labelCountdownCategory,attributes:{class:"fa fa-clock-o"},content:'\n        <div class="'+a+'" data-gjs-type="countdown"></div>\n        '+o+"\n      "})};var r=n(0)}])})},function(e,t,n){/*! grapesjs-plugin-forms - 0.3.5 */
!function(t,r){e.exports=r(n(0))}(0,function(e){return function(e){function t(r){if(n[r])return n[r].exports;var i=n[r]={i:r,l:!1,exports:{}};return e[r].call(i.exports,i,i.exports,t),i.l=!0,i.exports}var n={};return t.m=e,t.c=n,t.d=function(e,n,r){t.o(e,n)||Object.defineProperty(e,n,{configurable:!1,enumerable:!0,get:r})},t.n=function(e){var n=e&&e.__esModule?function(){return e.default}:function(){return e};return t.d(n,"a",n),n},t.o=function(e,t){return Object.prototype.hasOwnProperty.call(e,t)},t.p="",t(t.s=0)}([function(e,t,n){"use strict";Object.defineProperty(t,"__esModule",{value:!0});var r=n(1),i=function(e){return e&&e.__esModule?e:{default:e}}(r);t.default=i.default.plugins.add("gjs-plugin-forms",function(e,t){var r=t||{},i=e.getConfig(),a=(i.stylePrefix,{blocks:["form","input","textarea","select","button","label","checkbox","radio"],labelTraitMethod:"Method",labelTraitAction:"Action",labelTraitState:"State",labelTraitId:"ID",labelTraitFor:"For",labelInputName:"Input",labelTextareaName:"Textarea",labelSelectName:"Select",labelCheckboxName:"Checkbox",labelRadioName:"Radio",labelButtonName:"Button",labelTraitName:"Name",labelTraitPlaceholder:"Placeholder",labelTraitValue:"Value",labelTraitRequired:"Required",labelTraitType:"Type",labelTraitOptions:"Options",labelTraitChecked:"Checked",labelTypeText:"Text",labelTypeEmail:"Email",labelTypePassword:"Password",labelTypeNumber:"Number",labelTypeSubmit:"Submit",labelTypeReset:"Reset",labelTypeButton:"Button",labelNameLabel:"Label",labelForm:"Form",labelSelectOption:"- Select option -",labelOption:"Option",labelStateNormal:"Normal",labelStateSuccess:"Success",labelStateError:"Error"});for(var o in a)o in r||(r[o]=a[o]);n(2).default(e,r),n(3).default(e,r),n(4).default(e,r)})},function(t,n){t.exports=e},function(e,t,n){"use strict";Object.defineProperty(t,"__esModule",{value:!0});var r=Object.assign||function(e){for(var t=1;t<arguments.length;t++){var n=arguments[t];for(var r in n)Object.prototype.hasOwnProperty.call(n,r)&&(e[r]=n[r])}return e};t.default=function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},n=t,i=e.DomComponents,a=i.getType("default"),o=i.getType("text"),s=a.model,l=a.view,u=o.model,c=o.view,f={name:"id",label:n.labelTraitId},h={name:"for",label:n.labelTraitFor},d={name:"name",label:n.labelTraitName},p={name:"placeholder",label:n.labelTraitPlaceholder},m={name:"value",label:n.labelTraitValue},g={type:"checkbox",name:"required",label:n.labelTraitRequired},v={label:n.labelTraitChecked,type:"checkbox",name:"checked",changeProp:1};i.addType("form",{model:s.extend({defaults:r({},s.prototype.defaults,{droppable:":not(form)",draggable:":not(form)",traits:[{type:"select",label:n.labelTraitMethod,name:"method",options:[{value:"post",name:"POST"},{value:"get",name:"GET"}]},{label:n.labelTraitAction,name:"action"}]}),init:function(){this.listenTo(this,"change:formState",this.updateFormState)},updateFormState:function(){switch(this.get("formState")){case"success":this.showState("success");break;case"error":this.showState("error");break;default:this.showState("normal")}},showState:function(e){var t,n,r=e||"normal";"success"==r?(t="none",n="block"):"error"==r?(t="block",n="none"):(t="none",n="none");var i=this.getStateModel("success"),a=this.getStateModel("error"),o=i.getStyle(),s=a.getStyle();o.display=n,s.display=t,i.setStyle(o),a.setStyle(s)},getStateModel:function(e){for(var t,n=e||"success",r=this.get("components"),i=0;i<r.length;i++){var a=r.models[i];if(a.get("form-state-type")==n){t=a;break}}if(!t){var o=formMsgSuccess;"error"==n&&(o=formMsgError),t=r.add({"form-state-type":n,type:"text",removable:!1,copyable:!1,draggable:!1,attributes:{"data-form-state":n},content:o})}return t}},{isComponent:function(e){if("FORM"==e.tagName)return{type:"form"}}}),view:l.extend({events:{submit:function(e){e.preventDefault()}}})}),i.addType("input",{model:s.extend({defaults:r({},s.prototype.defaults,{"custom-name":n.labelInputName,tagName:"input",draggable:"form, form *",droppable:!1,traits:[d,p,{label:n.labelTraitType,type:"select",name:"type",options:[{value:"text",name:n.labelTypeText},{value:"email",name:n.labelTypeEmail},{value:"password",name:n.labelTypePassword},{value:"number",name:n.labelTypeNumber}]},g]})},{isComponent:function(e){if("INPUT"==e.tagName)return{type:"input"}}}),view:l});var b=i.getType("input"),y=b.model;i.addType("textarea",{model:b.model.extend({defaults:r({},y.prototype.defaults,{"custom-name":n.labelTextareaName,tagName:"textarea",traits:[d,p,g]})},{isComponent:function(e){if("TEXTAREA"==e.tagName)return{type:"textarea"}}}),view:l}),i.addType("select",{model:s.extend({defaults:r({},y.prototype.defaults,{"custom-name":n.labelSelectName,tagName:"select",traits:[d,{label:n.labelTraitOptions,type:"select-options"},g]})},{isComponent:function(e){if("SELECT"==e.tagName)return{type:"select"}}}),view:function(){return a.view.extend({events:{mousedown:"handleClick"},handleClick:function(e){e.preventDefault()}})}()}),i.addType("checkbox",{model:s.extend({defaults:r({},y.prototype.defaults,{"custom-name":n.labelCheckboxName,copyable:!1,attributes:{type:"checkbox"},traits:[f,d,m,g,v]}),init:function(){this.listenTo(this,"change:checked",this.handleChecked)},handleChecked:function(){var e=this.get("checked"),t=this.get("attributes"),n=this.view;e?t.checked="checked":delete t.checked,n&&(n.el.checked=e),this.set("attributes",r({},t))}},{isComponent:function(e){if("INPUT"==e.tagName&&"checkbox"==e.type)return{type:"checkbox"}}}),view:l.extend({events:{click:"handleClick"},handleClick:function(e){e.preventDefault()}})});var w=i.getType("checkbox");i.addType("radio",{model:w.model.extend({defaults:r({},w.model.prototype.defaults,{"custom-name":n.labelRadioName,attributes:{type:"radio"}})},{isComponent:function(e){if("INPUT"==e.tagName&&"radio"==e.type)return{type:"radio"}}}),view:w.view}),i.addType("button",{model:s.extend({defaults:r({},y.prototype.defaults,{"custom-name":n.labelButtonName,tagName:"button",traits:[{type:"content",label:"Text"},{label:n.labelTraitType,type:"select",name:"type",options:[{value:"submit",name:n.labelTypeSubmit},{value:"reset",name:n.labelTypeReset},{value:"button",name:n.labelTypeButton}]}]})},{isComponent:function(e){if("BUTTON"==e.tagName)return{type:"button"}}}),view:l.extend({events:{click:"handleClick"},init:function(){this.listenTo(this.model,"change:content",this.updateContent)},updateContent:function(){this.el.innerHTML=this.model.get("content")},handleClick:function(e){e.preventDefault()}})}),i.addType("label",{model:u.extend({defaults:r({},u.prototype.defaults,{"custom-name":n.labelNameLabel,tagName:"label",traits:[h]})},{isComponent:function(e){if("LABEL"==e.tagName)return{type:"label"}}}),view:c})}},function(e,t,n){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.default=function(e){var t=(arguments.length>1&&void 0!==arguments[1]&&arguments[1],e.TraitManager),n=t.getType("text");t.addType("content",{events:{keyup:"onChange"},onValueChange:function(){var e=this.model;e.target.set("content",e.get("value"))},getInputEl:function(){return this.inputEl||(this.inputEl=n.prototype.getInputEl.bind(this)(),this.inputEl.value=this.target.get("content")),this.inputEl}}),t.addType("select-options",{events:{keyup:"onChange"},onValueChange:function(){for(var e=this.model.get("value").trim(),t=e.split("\n"),n=[],r=0;r<t.length;r++){var i=t[r],a=i.split("::"),o={tagName:"option",attributes:{}};a[1]?(o.content=a[1],o.attributes.value=a[0]):(o.content=a[0],o.attributes.value=a[0]),n.push(o)}this.target.get("components").reset(n),this.target.view.render()},getInputEl:function(){if(!this.$input){for(var e=this.model,t=this.target,n=(e.get("name"),""),r=t.get("components"),i=0;i<r.length;i++){var a=r.models[i];n+=(a.get("attributes").value||"")+"::"+a.get("content")+"\n"}this.$input=document.createElement("textarea"),this.$input.value=n}return this.$input}})}},function(e,t,n){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.default=function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},n=t,r=e.BlockManager;n.blocks.indexOf("form")>=0&&r.add("form",{label:'\n      <svg class="gjs-block-svg" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">\n        <path class="gjs-block-svg-path" d="M22,5.5 C22,5.2 21.5,5 20.75,5 L3.25,5 C2.5,5 2,5.2 2,5.5 L2,8.5 C2,8.8 2.5,9 3.25,9 L20.75,9 C21.5,9 22,8.8 22,8.5 L22,5.5 Z M21,8 L3,8 L3,6 L21,6 L21,8 Z" fill-rule="nonzero"></path>\n        <path class="gjs-block-svg-path" d="M22,10.5 C22,10.2 21.5,10 20.75,10 L3.25,10 C2.5,10 2,10.2 2,10.5 L2,13.5 C2,13.8 2.5,14 3.25,14 L20.75,14 C21.5,14 22,13.8 22,13.5 L22,10.5 Z M21,13 L3,13 L3,11 L21,11 L21,13 Z" fill-rule="nonzero"></path>\n        <rect class="gjs-block-svg-path" x="2" y="15" width="10" height="3" rx="0.5"></rect>\n      </svg>\n      <div class="gjs-block-label">'+n.labelForm+"</div>",category:"Forms",content:'\n        <form class="form">\n          <div class="form-group">\n            <label class="label">Name</label>\n            <input placeholder="Type here your name" class="input"/>\n          </div>\n          <div class="form-group">\n            <label class="label">Email</label>\n            <input type="email" placeholder="Type here your email" class="input"/>\n          </div>\n          <div class="form-group">\n            <label class="label">Gender</label>\n            <input type="checkbox" class="checkbox" value="M">\n            <label class="checkbox-label">M</label>\n            <input type="checkbox" class="checkbox" value="F">\n            <label class="checkbox-label">F</label>\n          </div>\n          <div class="form-group">\n            <label class="label">Message</label>\n            <textarea class="textarea"></textarea>\n          </div>\n          <div class="form-group">\n            <button type="submit" class="button">Send</button>\n          </div>\n        </form>\n      '}),n.blocks.indexOf("input")>=0&&r.add("input",{label:'\n      <svg class="gjs-block-svg" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">\n        <path class="gjs-block-svg-path" d="M22,9 C22,8.4 21.5,8 20.75,8 L3.25,8 C2.5,8 2,8.4 2,9 L2,15 C2,15.6 2.5,16 3.25,16 L20.75,16 C21.5,16 22,15.6 22,15 L22,9 Z M21,15 L3,15 L3,9 L21,9 L21,15 Z"></path>\n        <polygon class="gjs-block-svg-path" points="4 10 5 10 5 14 4 14"></polygon>\n      </svg>\n      <div class="gjs-block-label">'+n.labelInputName+"</div>",category:"Forms",content:'<input class="input"/>'}),n.blocks.indexOf("textarea")>=0&&r.add("textarea",{label:'\n      <svg class="gjs-block-svg" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">\n        <path class="gjs-block-svg-path" d="M22,7.5 C22,6.6 21.5,6 20.75,6 L3.25,6 C2.5,6 2,6.6 2,7.5 L2,16.5 C2,17.4 2.5,18 3.25,18 L20.75,18 C21.5,18 22,17.4 22,16.5 L22,7.5 Z M21,17 L3,17 L3,7 L21,7 L21,17 Z"></path>\n        <polygon class="gjs-block-svg-path" points="4 8 5 8 5 12 4 12"></polygon>\n        <polygon class="gjs-block-svg-path" points="19 7 20 7 20 17 19 17"></polygon>\n        <polygon class="gjs-block-svg-path" points="20 8 21 8 21 9 20 9"></polygon>\n        <polygon class="gjs-block-svg-path" points="20 15 21 15 21 16 20 16"></polygon>\n      </svg>\n      <div class="gjs-block-label">'+n.labelTextareaName+"</div>",category:"Forms",content:'<textarea class="textarea"></textarea>'}),n.blocks.indexOf("select")>=0&&r.add("select",{label:'\n      <svg class="gjs-block-svg" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">\n        <path class="gjs-block-svg-path" d="M22,9 C22,8.4 21.5,8 20.75,8 L3.25,8 C2.5,8 2,8.4 2,9 L2,15 C2,15.6 2.5,16 3.25,16 L20.75,16 C21.5,16 22,15.6 22,15 L22,9 Z M21,15 L3,15 L3,9 L21,9 L21,15 Z" fill-rule="nonzero"></path>\n        <polygon class="gjs-block-svg-path" transform="translate(18.500000, 12.000000) scale(1, -1) translate(-18.500000, -12.000000) " points="18.5 11 20 13 17 13"></polygon>\n        <rect class="gjs-block-svg-path" x="4" y="11.5" width="11" height="1"></rect>\n      </svg>\n      <div class="gjs-block-label">'+n.labelSelectName+"</div>",category:"Forms",content:'<select class="select">\n        '+(n.labelSelectOption?'<option value="">'+n.labelSelectOption+"</option>":"")+'\n        <option value="1">'+n.labelOption+" 1</option>\n        </select>"}),n.blocks.indexOf("button")>=0&&r.add("button",{label:'\n      <svg class="gjs-block-svg" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">\n        <path class="gjs-block-svg-path" d="M22,9 C22,8.4 21.5,8 20.75,8 L3.25,8 C2.5,8 2,8.4 2,9 L2,15 C2,15.6 2.5,16 3.25,16 L20.75,16 C21.5,16 22,15.6 22,15 L22,9 Z M21,15 L3,15 L3,9 L21,9 L21,15 Z" fill-rule="nonzero"></path>\n        <rect class="gjs-block-svg-path" x="4" y="11.5" width="16" height="1"></rect>\n      </svg>\n      <div class="gjs-block-label">'+n.labelButtonName+"</div>",category:"Forms",content:'<button class="button">Send</button>'}),n.blocks.indexOf("label")>=0&&r.add("label",{label:'\n      <svg class="gjs-block-svg" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">\n        <path class="gjs-block-svg-path" d="M22,11.875 C22,11.35 21.5,11 20.75,11 L3.25,11 C2.5,11 2,11.35 2,11.875 L2,17.125 C2,17.65 2.5,18 3.25,18 L20.75,18 C21.5,18 22,17.65 22,17.125 L22,11.875 Z M21,17 L3,17 L3,12 L21,12 L21,17 Z" fill-rule="nonzero"></path>\n        <rect class="gjs-block-svg-path" x="2" y="5" width="14" height="5" rx="0.5"></rect>\n        <polygon class="gjs-block-svg-path" fill-rule="nonzero" points="4 13 5 13 5 16 4 16"></polygon>\n      </svg>\n      <div class="gjs-block-label">'+n.labelNameLabel+"</div>",category:"Forms",content:'<label class="label">Label</label>'}),n.blocks.indexOf("checkbox")>=0&&r.add("checkbox",{label:n.labelCheckboxName,attributes:{class:"fa fa-check-square"},category:"Forms",content:'<input type="checkbox" class="checkbox"/>'}),n.blocks.indexOf("radio")>=0&&r.add("radio",{label:n.labelRadioName,attributes:{class:"fa fa-dot-circle-o"},category:"Forms",content:'<input type="radio" class="radio"/>'})}}])})},function(e,t,n){(function(t,r){/*! grapesjs-plugin-export - 0.1.5 */
!function(t,r){e.exports=r(n(0))}(0,function(e){return function(e){function t(r){if(n[r])return n[r].exports;var i=n[r]={i:r,l:!1,exports:{}};return e[r].call(i.exports,i,i.exports,t),i.l=!0,i.exports}var n={};return t.m=e,t.c=n,t.d=function(e,n,r){t.o(e,n)||Object.defineProperty(e,n,{configurable:!1,enumerable:!0,get:r})},t.n=function(e){var n=e&&e.__esModule?function(){return e.default}:function(){return e};return t.d(n,"a",n),n},t.o=function(e,t){return Object.prototype.hasOwnProperty.call(e,t)},t.p="",t(t.s=50)}([function(e,t,n){"use strict";function r(e){var t=null;return t=l.uint8array?new Uint8Array(e.length):new Array(e.length),a(e,t)}function i(e){return e}function a(e,t){for(var n=0;n<e.length;++n)t[n]=255&e.charCodeAt(n);return t}function o(e){var n=65536,r=t.getTypeOf(e),i=!0;if("uint8array"===r?i=d.applyCanBeUsed.uint8array:"nodebuffer"===r&&(i=d.applyCanBeUsed.nodebuffer),i)for(;n>1;)try{return d.stringifyByChunk(e,r,n)}catch(e){n=Math.floor(n/2)}return d.stringifyByChar(e)}function s(e,t){for(var n=0;n<e.length;n++)t[n]=e[n];return t}var l=n(3),u=n(29),c=n(14),f=n(66),h=n(9);t.newBlob=function(e,n){t.checkSupport("blob");try{return new Blob([e],{type:n})}catch(t){try{var r=self.BlobBuilder||self.WebKitBlobBuilder||self.MozBlobBuilder||self.MSBlobBuilder,i=new r;return i.append(e),i.getBlob(n)}catch(e){throw new Error("Bug : can't construct the Blob.")}}};var d={stringifyByChunk:function(e,t,n){var r=[],i=0,a=e.length;if(a<=n)return String.fromCharCode.apply(null,e);for(;i<a;)"array"===t||"nodebuffer"===t?r.push(String.fromCharCode.apply(null,e.slice(i,Math.min(i+n,a)))):r.push(String.fromCharCode.apply(null,e.subarray(i,Math.min(i+n,a)))),i+=n;return r.join("")},stringifyByChar:function(e){for(var t="",n=0;n<e.length;n++)t+=String.fromCharCode(e[n]);return t},applyCanBeUsed:{uint8array:function(){try{return l.uint8array&&1===String.fromCharCode.apply(null,new Uint8Array(1)).length}catch(e){return!1}}(),nodebuffer:function(){try{return l.nodebuffer&&1===String.fromCharCode.apply(null,c.allocBuffer(1)).length}catch(e){return!1}}()}};t.applyFromCharCode=o;var p={};p.string={string:i,array:function(e){return a(e,new Array(e.length))},arraybuffer:function(e){return p.string.uint8array(e).buffer},uint8array:function(e){return a(e,new Uint8Array(e.length))},nodebuffer:function(e){return a(e,c.allocBuffer(e.length))}},p.array={string:o,array:i,arraybuffer:function(e){return new Uint8Array(e).buffer},uint8array:function(e){return new Uint8Array(e)},nodebuffer:function(e){return c.newBufferFrom(e)}},p.arraybuffer={string:function(e){return o(new Uint8Array(e))},array:function(e){return s(new Uint8Array(e),new Array(e.byteLength))},arraybuffer:i,uint8array:function(e){return new Uint8Array(e)},nodebuffer:function(e){return c.newBufferFrom(new Uint8Array(e))}},p.uint8array={string:o,array:function(e){return s(e,new Array(e.length))},arraybuffer:function(e){return e.buffer},uint8array:i,nodebuffer:function(e){return c.newBufferFrom(e)}},p.nodebuffer={string:o,array:function(e){return s(e,new Array(e.length))},arraybuffer:function(e){return p.nodebuffer.uint8array(e).buffer},uint8array:function(e){return s(e,new Uint8Array(e.length))},nodebuffer:i},t.transformTo=function(e,n){if(n||(n=""),!e)return n;t.checkSupport(e);var r=t.getTypeOf(n);return p[r][e](n)},t.getTypeOf=function(e){return"string"==typeof e?"string":"[object Array]"===Object.prototype.toString.call(e)?"array":l.nodebuffer&&c.isBuffer(e)?"nodebuffer":l.uint8array&&e instanceof Uint8Array?"uint8array":l.arraybuffer&&e instanceof ArrayBuffer?"arraybuffer":void 0},t.checkSupport=function(e){if(!l[e.toLowerCase()])throw new Error(e+" is not supported by this platform")},t.MAX_VALUE_16BITS=65535,t.MAX_VALUE_32BITS=-1,t.pretty=function(e){var t,n,r="";for(n=0;n<(e||"").length;n++)t=e.charCodeAt(n),r+="\\x"+(t<16?"0":"")+t.toString(16).toUpperCase();return r},t.delay=function(e,t,n){f(function(){e.apply(n||null,t||[])})},t.inherits=function(e,t){var n=function(){};n.prototype=t.prototype,e.prototype=new n},t.extend=function(){var e,t,n={};for(e=0;e<arguments.length;e++)for(t in arguments[e])arguments[e].hasOwnProperty(t)&&void 0===n[t]&&(n[t]=arguments[e][t]);return n},t.prepareContent=function(e,n,i,a,o){return h.Promise.resolve(n).then(function(e){return l.blob&&(e instanceof Blob||-1!==["[object File]","[object Blob]"].indexOf(Object.prototype.toString.call(e)))&&"undefined"!=typeof FileReader?new h.Promise(function(t,n){var r=new FileReader;r.onload=function(e){t(e.target.result)},r.onerror=function(e){n(e.target.error)},r.readAsArrayBuffer(e)}):e}).then(function(n){var s=t.getTypeOf(n);return s?("arraybuffer"===s?n=t.transformTo("uint8array",n):"string"===s&&(o?n=u.decode(n):i&&!0!==a&&(n=r(n))),n):h.Promise.reject(new Error("Can't read the data of '"+e+"'. Is it in a supported JavaScript type (String, Blob, ArrayBuffer, etc) ?"))})}},function(e,t,n){"use strict";function r(e){this.name=e||"default",this.streamInfo={},this.generatedError=null,this.extraStreamInfo={},this.isPaused=!0,this.isFinished=!1,this.isLocked=!1,this._listeners={data:[],end:[],error:[]},this.previous=null}r.prototype={push:function(e){this.emit("data",e)},end:function(){if(this.isFinished)return!1;this.flush();try{this.emit("end"),this.cleanUp(),this.isFinished=!0}catch(e){this.emit("error",e)}return!0},error:function(e){return!this.isFinished&&(this.isPaused?this.generatedError=e:(this.isFinished=!0,this.emit("error",e),this.previous&&this.previous.error(e),this.cleanUp()),!0)},on:function(e,t){return this._listeners[e].push(t),this},cleanUp:function(){this.streamInfo=this.generatedError=this.extraStreamInfo=null,this._listeners=[]},emit:function(e,t){if(this._listeners[e])for(var n=0;n<this._listeners[e].length;n++)this._listeners[e][n].call(this,t)},pipe:function(e){return e.registerPrevious(this)},registerPrevious:function(e){if(this.isLocked)throw new Error("The stream '"+this+"' has already been used.");this.streamInfo=e.streamInfo,this.mergeStreamInfo(),this.previous=e;var t=this;return e.on("data",function(e){t.processChunk(e)}),e.on("end",function(){t.end()}),e.on("error",function(e){t.error(e)}),this},pause:function(){return!this.isPaused&&!this.isFinished&&(this.isPaused=!0,this.previous&&this.previous.pause(),!0)},resume:function(){if(!this.isPaused||this.isFinished)return!1;this.isPaused=!1;var e=!1;return this.generatedError&&(this.error(this.generatedError),e=!0),this.previous&&this.previous.resume(),!e},flush:function(){},processChunk:function(e){this.push(e)},withStreamInfo:function(e,t){return this.extraStreamInfo[e]=t,this.mergeStreamInfo(),this},mergeStreamInfo:function(){for(var e in this.extraStreamInfo)this.extraStreamInfo.hasOwnProperty(e)&&(this.streamInfo[e]=this.extraStreamInfo[e])},lock:function(){if(this.isLocked)throw new Error("The stream '"+this+"' has already been used.");this.isLocked=!0,this.previous&&this.previous.lock()},toString:function(){var e="Worker "+this.name;return this.previous?this.previous+" -> "+e:e}},e.exports=r},function(e,t,n){"use strict";(function(e){function r(){return a.TYPED_ARRAY_SUPPORT?2147483647:1073741823}function i(e,t){if(r()<t)throw new RangeError("Invalid typed array length");return a.TYPED_ARRAY_SUPPORT?(e=new Uint8Array(t),e.__proto__=a.prototype):(null===e&&(e=new a(t)),e.length=t),e}function a(e,t,n){if(!(a.TYPED_ARRAY_SUPPORT||this instanceof a))return new a(e,t,n);if("number"==typeof e){if("string"==typeof t)throw new Error("If encoding is specified then the first argument must be a string");return u(this,e)}return o(this,e,t,n)}function o(e,t,n,r){if("number"==typeof t)throw new TypeError('"value" argument must not be a number');return"undefined"!=typeof ArrayBuffer&&t instanceof ArrayBuffer?h(e,t,n,r):"string"==typeof t?c(e,t,n):d(e,t)}function s(e){if("number"!=typeof e)throw new TypeError('"size" argument must be a number');if(e<0)throw new RangeError('"size" argument must not be negative')}function l(e,t,n,r){return s(t),t<=0?i(e,t):void 0!==n?"string"==typeof r?i(e,t).fill(n,r):i(e,t).fill(n):i(e,t)}function u(e,t){if(s(t),e=i(e,t<0?0:0|p(t)),!a.TYPED_ARRAY_SUPPORT)for(var n=0;n<t;++n)e[n]=0;return e}function c(e,t,n){if("string"==typeof n&&""!==n||(n="utf8"),!a.isEncoding(n))throw new TypeError('"encoding" must be a valid string encoding');var r=0|g(t,n);e=i(e,r);var o=e.write(t,n);return o!==r&&(e=e.slice(0,o)),e}function f(e,t){var n=t.length<0?0:0|p(t.length);e=i(e,n);for(var r=0;r<n;r+=1)e[r]=255&t[r];return e}function h(e,t,n,r){if(t.byteLength,n<0||t.byteLength<n)throw new RangeError("'offset' is out of bounds");if(t.byteLength<n+(r||0))throw new RangeError("'length' is out of bounds");return t=void 0===n&&void 0===r?new Uint8Array(t):void 0===r?new Uint8Array(t,n):new Uint8Array(t,n,r),a.TYPED_ARRAY_SUPPORT?(e=t,e.__proto__=a.prototype):e=f(e,t),e}function d(e,t){if(a.isBuffer(t)){var n=0|p(t.length);return e=i(e,n),0===e.length?e:(t.copy(e,0,0,n),e)}if(t){if("undefined"!=typeof ArrayBuffer&&t.buffer instanceof ArrayBuffer||"length"in t)return"number"!=typeof t.length||X(t.length)?i(e,0):f(e,t);if("Buffer"===t.type&&$(t.data))return f(e,t.data)}throw new TypeError("First argument must be a string, Buffer, ArrayBuffer, Array, or array-like object.")}function p(e){if(e>=r())throw new RangeError("Attempt to allocate Buffer larger than maximum size: 0x"+r().toString(16)+" bytes");return 0|e}function m(e){return+e!=e&&(e=0),a.alloc(+e)}function g(e,t){if(a.isBuffer(e))return e.length;if("undefined"!=typeof ArrayBuffer&&"function"==typeof ArrayBuffer.isView&&(ArrayBuffer.isView(e)||e instanceof ArrayBuffer))return e.byteLength;"string"!=typeof e&&(e=""+e);var n=e.length;if(0===n)return 0;for(var r=!1;;)switch(t){case"ascii":case"latin1":case"binary":return n;case"utf8":case"utf-8":case void 0:return Y(e).length;case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":return 2*n;case"hex":return n>>>1;case"base64":return V(e).length;default:if(r)return Y(e).length;t=(""+t).toLowerCase(),r=!0}}function v(e,t,n){var r=!1;if((void 0===t||t<0)&&(t=0),t>this.length)return"";if((void 0===n||n>this.length)&&(n=this.length),n<=0)return"";if(n>>>=0,t>>>=0,n<=t)return"";for(e||(e="utf8");;)switch(e){case"hex":return L(this,t,n);case"utf8":case"utf-8":return A(this,t,n);case"ascii":return I(this,t,n);case"latin1":case"binary":return R(this,t,n);case"base64":return C(this,t,n);case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":return j(this,t,n);default:if(r)throw new TypeError("Unknown encoding: "+e);e=(e+"").toLowerCase(),r=!0}}function b(e,t,n){var r=e[t];e[t]=e[n],e[n]=r}function y(e,t,n,r,i){if(0===e.length)return-1;if("string"==typeof n?(r=n,n=0):n>2147483647?n=2147483647:n<-2147483648&&(n=-2147483648),n=+n,isNaN(n)&&(n=i?0:e.length-1),n<0&&(n=e.length+n),n>=e.length){if(i)return-1;n=e.length-1}else if(n<0){if(!i)return-1;n=0}if("string"==typeof t&&(t=a.from(t,r)),a.isBuffer(t))return 0===t.length?-1:w(e,t,n,r,i);if("number"==typeof t)return t&=255,a.TYPED_ARRAY_SUPPORT&&"function"==typeof Uint8Array.prototype.indexOf?i?Uint8Array.prototype.indexOf.call(e,t,n):Uint8Array.prototype.lastIndexOf.call(e,t,n):w(e,[t],n,r,i);throw new TypeError("val must be string, number or Buffer")}function w(e,t,n,r,i){function a(e,t){return 1===o?e[t]:e.readUInt16BE(t*o)}var o=1,s=e.length,l=t.length;if(void 0!==r&&("ucs2"===(r=String(r).toLowerCase())||"ucs-2"===r||"utf16le"===r||"utf-16le"===r)){if(e.length<2||t.length<2)return-1;o=2,s/=2,l/=2,n/=2}var u;if(i){var c=-1;for(u=n;u<s;u++)if(a(e,u)===a(t,-1===c?0:u-c)){if(-1===c&&(c=u),u-c+1===l)return c*o}else-1!==c&&(u-=u-c),c=-1}else for(n+l>s&&(n=s-l),u=n;u>=0;u--){for(var f=!0,h=0;h<l;h++)if(a(e,u+h)!==a(t,h)){f=!1;break}if(f)return u}return-1}function _(e,t,n,r){n=Number(n)||0;var i=e.length-n;r?(r=Number(r))>i&&(r=i):r=i;var a=t.length;if(a%2!=0)throw new TypeError("Invalid hex string");r>a/2&&(r=a/2);for(var o=0;o<r;++o){var s=parseInt(t.substr(2*o,2),16);if(isNaN(s))return o;e[n+o]=s}return o}function k(e,t,n,r){return K(Y(t,e.length-n),e,n,r)}function x(e,t,n,r){return K(q(t),e,n,r)}function S(e,t,n,r){return x(e,t,n,r)}function E(e,t,n,r){return K(V(t),e,n,r)}function T(e,t,n,r){return K(H(t,e.length-n),e,n,r)}function C(e,t,n){return 0===t&&n===e.length?G.fromByteArray(e):G.fromByteArray(e.slice(t,n))}function A(e,t,n){n=Math.min(e.length,n);for(var r=[],i=t;i<n;){var a=e[i],o=null,s=a>239?4:a>223?3:a>191?2:1;if(i+s<=n){var l,u,c,f;switch(s){case 1:a<128&&(o=a);break;case 2:128==(192&(l=e[i+1]))&&(f=(31&a)<<6|63&l)>127&&(o=f);break;case 3:l=e[i+1],u=e[i+2],128==(192&l)&&128==(192&u)&&(f=(15&a)<<12|(63&l)<<6|63&u)>2047&&(f<55296||f>57343)&&(o=f);break;case 4:l=e[i+1],u=e[i+2],c=e[i+3],128==(192&l)&&128==(192&u)&&128==(192&c)&&(f=(15&a)<<18|(63&l)<<12|(63&u)<<6|63&c)>65535&&f<1114112&&(o=f)}}null===o?(o=65533,s=1):o>65535&&(o-=65536,r.push(o>>>10&1023|55296),o=56320|1023&o),r.push(o),i+=s}return O(r)}function O(e){var t=e.length;if(t<=Q)return String.fromCharCode.apply(String,e);for(var n="",r=0;r<t;)n+=String.fromCharCode.apply(String,e.slice(r,r+=Q));return n}function I(e,t,n){var r="";n=Math.min(e.length,n);for(var i=t;i<n;++i)r+=String.fromCharCode(127&e[i]);return r}function R(e,t,n){var r="";n=Math.min(e.length,n);for(var i=t;i<n;++i)r+=String.fromCharCode(e[i]);return r}function L(e,t,n){var r=e.length;(!t||t<0)&&(t=0),(!n||n<0||n>r)&&(n=r);for(var i="",a=t;a<n;++a)i+=W(e[a]);return i}function j(e,t,n){for(var r=e.slice(t,n),i="",a=0;a<r.length;a+=2)i+=String.fromCharCode(r[a]+256*r[a+1]);return i}function B(e,t,n){if(e%1!=0||e<0)throw new RangeError("offset is not uint");if(e+t>n)throw new RangeError("Trying to access beyond buffer length")}function M(e,t,n,r,i,o){if(!a.isBuffer(e))throw new TypeError('"buffer" argument must be a Buffer instance');if(t>i||t<o)throw new RangeError('"value" argument is out of bounds');if(n+r>e.length)throw new RangeError("Index out of range")}function P(e,t,n,r){t<0&&(t=65535+t+1);for(var i=0,a=Math.min(e.length-n,2);i<a;++i)e[n+i]=(t&255<<8*(r?i:1-i))>>>8*(r?i:1-i)}function N(e,t,n,r){t<0&&(t=4294967295+t+1);for(var i=0,a=Math.min(e.length-n,4);i<a;++i)e[n+i]=t>>>8*(r?i:3-i)&255}function z(e,t,n,r,i,a){if(n+r>e.length)throw new RangeError("Index out of range");if(n<0)throw new RangeError("Index out of range")}function D(e,t,n,r,i){return i||z(e,t,n,4,3.4028234663852886e38,-3.4028234663852886e38),J.write(e,t,n,r,23,4),n+4}function F(e,t,n,r,i){return i||z(e,t,n,8,1.7976931348623157e308,-1.7976931348623157e308),J.write(e,t,n,r,52,8),n+8}function U(e){if(e=Z(e).replace(ee,""),e.length<2)return"";for(;e.length%4!=0;)e+="=";return e}function Z(e){return e.trim?e.trim():e.replace(/^\s+|\s+$/g,"")}function W(e){return e<16?"0"+e.toString(16):e.toString(16)}function Y(e,t){t=t||1/0;for(var n,r=e.length,i=null,a=[],o=0;o<r;++o){if((n=e.charCodeAt(o))>55295&&n<57344){if(!i){if(n>56319){(t-=3)>-1&&a.push(239,191,189);continue}if(o+1===r){(t-=3)>-1&&a.push(239,191,189);continue}i=n;continue}if(n<56320){(t-=3)>-1&&a.push(239,191,189),i=n;continue}n=65536+(i-55296<<10|n-56320)}else i&&(t-=3)>-1&&a.push(239,191,189);if(i=null,n<128){if((t-=1)<0)break;a.push(n)}else if(n<2048){if((t-=2)<0)break;a.push(n>>6|192,63&n|128)}else if(n<65536){if((t-=3)<0)break;a.push(n>>12|224,n>>6&63|128,63&n|128)}else{if(!(n<1114112))throw new Error("Invalid code point");if((t-=4)<0)break;a.push(n>>18|240,n>>12&63|128,n>>6&63|128,63&n|128)}}return a}function q(e){for(var t=[],n=0;n<e.length;++n)t.push(255&e.charCodeAt(n));return t}function H(e,t){for(var n,r,i,a=[],o=0;o<e.length&&!((t-=2)<0);++o)n=e.charCodeAt(o),r=n>>8,i=n%256,a.push(i),a.push(r);return a}function V(e){return G.toByteArray(U(e))}function K(e,t,n,r){for(var i=0;i<r&&!(i+n>=t.length||i>=e.length);++i)t[i+n]=e[i];return i}function X(e){return e!==e}/*!
 * The buffer module from node.js, for the browser.
 *
 * @author   Feross Aboukhadijeh <feross@feross.org> <http://feross.org>
 * @license  MIT
 */
var G=n(54),J=n(55),$=n(24);t.Buffer=a,t.SlowBuffer=m,t.INSPECT_MAX_BYTES=50,a.TYPED_ARRAY_SUPPORT=void 0!==e.TYPED_ARRAY_SUPPORT?e.TYPED_ARRAY_SUPPORT:function(){try{var e=new Uint8Array(1);return e.__proto__={__proto__:Uint8Array.prototype,foo:function(){return 42}},42===e.foo()&&"function"==typeof e.subarray&&0===e.subarray(1,1).byteLength}catch(e){return!1}}(),t.kMaxLength=r(),a.poolSize=8192,a._augment=function(e){return e.__proto__=a.prototype,e},a.from=function(e,t,n){return o(null,e,t,n)},a.TYPED_ARRAY_SUPPORT&&(a.prototype.__proto__=Uint8Array.prototype,a.__proto__=Uint8Array,"undefined"!=typeof Symbol&&Symbol.species&&a[Symbol.species]===a&&Object.defineProperty(a,Symbol.species,{value:null,configurable:!0})),a.alloc=function(e,t,n){return l(null,e,t,n)},a.allocUnsafe=function(e){return u(null,e)},a.allocUnsafeSlow=function(e){return u(null,e)},a.isBuffer=function(e){return!(null==e||!e._isBuffer)},a.compare=function(e,t){if(!a.isBuffer(e)||!a.isBuffer(t))throw new TypeError("Arguments must be Buffers");if(e===t)return 0;for(var n=e.length,r=t.length,i=0,o=Math.min(n,r);i<o;++i)if(e[i]!==t[i]){n=e[i],r=t[i];break}return n<r?-1:r<n?1:0},a.isEncoding=function(e){switch(String(e).toLowerCase()){case"hex":case"utf8":case"utf-8":case"ascii":case"latin1":case"binary":case"base64":case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":return!0;default:return!1}},a.concat=function(e,t){if(!$(e))throw new TypeError('"list" argument must be an Array of Buffers');if(0===e.length)return a.alloc(0);var n;if(void 0===t)for(t=0,n=0;n<e.length;++n)t+=e[n].length;var r=a.allocUnsafe(t),i=0;for(n=0;n<e.length;++n){var o=e[n];if(!a.isBuffer(o))throw new TypeError('"list" argument must be an Array of Buffers');o.copy(r,i),i+=o.length}return r},a.byteLength=g,a.prototype._isBuffer=!0,a.prototype.swap16=function(){var e=this.length;if(e%2!=0)throw new RangeError("Buffer size must be a multiple of 16-bits");for(var t=0;t<e;t+=2)b(this,t,t+1);return this},a.prototype.swap32=function(){var e=this.length;if(e%4!=0)throw new RangeError("Buffer size must be a multiple of 32-bits");for(var t=0;t<e;t+=4)b(this,t,t+3),b(this,t+1,t+2);return this},a.prototype.swap64=function(){var e=this.length;if(e%8!=0)throw new RangeError("Buffer size must be a multiple of 64-bits");for(var t=0;t<e;t+=8)b(this,t,t+7),b(this,t+1,t+6),b(this,t+2,t+5),b(this,t+3,t+4);return this},a.prototype.toString=function(){var e=0|this.length;return 0===e?"":0===arguments.length?A(this,0,e):v.apply(this,arguments)},a.prototype.equals=function(e){if(!a.isBuffer(e))throw new TypeError("Argument must be a Buffer");return this===e||0===a.compare(this,e)},a.prototype.inspect=function(){var e="",n=t.INSPECT_MAX_BYTES;return this.length>0&&(e=this.toString("hex",0,n).match(/.{2}/g).join(" "),this.length>n&&(e+=" ... ")),"<Buffer "+e+">"},a.prototype.compare=function(e,t,n,r,i){if(!a.isBuffer(e))throw new TypeError("Argument must be a Buffer");if(void 0===t&&(t=0),void 0===n&&(n=e?e.length:0),void 0===r&&(r=0),void 0===i&&(i=this.length),t<0||n>e.length||r<0||i>this.length)throw new RangeError("out of range index");if(r>=i&&t>=n)return 0;if(r>=i)return-1;if(t>=n)return 1;if(t>>>=0,n>>>=0,r>>>=0,i>>>=0,this===e)return 0;for(var o=i-r,s=n-t,l=Math.min(o,s),u=this.slice(r,i),c=e.slice(t,n),f=0;f<l;++f)if(u[f]!==c[f]){o=u[f],s=c[f];break}return o<s?-1:s<o?1:0},a.prototype.includes=function(e,t,n){return-1!==this.indexOf(e,t,n)},a.prototype.indexOf=function(e,t,n){return y(this,e,t,n,!0)},a.prototype.lastIndexOf=function(e,t,n){return y(this,e,t,n,!1)},a.prototype.write=function(e,t,n,r){if(void 0===t)r="utf8",n=this.length,t=0;else if(void 0===n&&"string"==typeof t)r=t,n=this.length,t=0;else{if(!isFinite(t))throw new Error("Buffer.write(string, encoding, offset[, length]) is no longer supported");t|=0,isFinite(n)?(n|=0,void 0===r&&(r="utf8")):(r=n,n=void 0)}var i=this.length-t;if((void 0===n||n>i)&&(n=i),e.length>0&&(n<0||t<0)||t>this.length)throw new RangeError("Attempt to write outside buffer bounds");r||(r="utf8");for(var a=!1;;)switch(r){case"hex":return _(this,e,t,n);case"utf8":case"utf-8":return k(this,e,t,n);case"ascii":return x(this,e,t,n);case"latin1":case"binary":return S(this,e,t,n);case"base64":return E(this,e,t,n);case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":return T(this,e,t,n);default:if(a)throw new TypeError("Unknown encoding: "+r);r=(""+r).toLowerCase(),a=!0}},a.prototype.toJSON=function(){return{type:"Buffer",data:Array.prototype.slice.call(this._arr||this,0)}};var Q=4096;a.prototype.slice=function(e,t){var n=this.length;e=~~e,t=void 0===t?n:~~t,e<0?(e+=n)<0&&(e=0):e>n&&(e=n),t<0?(t+=n)<0&&(t=0):t>n&&(t=n),t<e&&(t=e);var r;if(a.TYPED_ARRAY_SUPPORT)r=this.subarray(e,t),r.__proto__=a.prototype;else{var i=t-e;r=new a(i,void 0);for(var o=0;o<i;++o)r[o]=this[o+e]}return r},a.prototype.readUIntLE=function(e,t,n){e|=0,t|=0,n||B(e,t,this.length);for(var r=this[e],i=1,a=0;++a<t&&(i*=256);)r+=this[e+a]*i;return r},a.prototype.readUIntBE=function(e,t,n){e|=0,t|=0,n||B(e,t,this.length);for(var r=this[e+--t],i=1;t>0&&(i*=256);)r+=this[e+--t]*i;return r},a.prototype.readUInt8=function(e,t){return t||B(e,1,this.length),this[e]},a.prototype.readUInt16LE=function(e,t){return t||B(e,2,this.length),this[e]|this[e+1]<<8},a.prototype.readUInt16BE=function(e,t){return t||B(e,2,this.length),this[e]<<8|this[e+1]},a.prototype.readUInt32LE=function(e,t){return t||B(e,4,this.length),(this[e]|this[e+1]<<8|this[e+2]<<16)+16777216*this[e+3]},a.prototype.readUInt32BE=function(e,t){return t||B(e,4,this.length),16777216*this[e]+(this[e+1]<<16|this[e+2]<<8|this[e+3])},a.prototype.readIntLE=function(e,t,n){e|=0,t|=0,n||B(e,t,this.length);for(var r=this[e],i=1,a=0;++a<t&&(i*=256);)r+=this[e+a]*i;return i*=128,r>=i&&(r-=Math.pow(2,8*t)),r},a.prototype.readIntBE=function(e,t,n){e|=0,t|=0,n||B(e,t,this.length);for(var r=t,i=1,a=this[e+--r];r>0&&(i*=256);)a+=this[e+--r]*i;return i*=128,a>=i&&(a-=Math.pow(2,8*t)),a},a.prototype.readInt8=function(e,t){return t||B(e,1,this.length),128&this[e]?-1*(255-this[e]+1):this[e]},a.prototype.readInt16LE=function(e,t){t||B(e,2,this.length);var n=this[e]|this[e+1]<<8;return 32768&n?4294901760|n:n},a.prototype.readInt16BE=function(e,t){t||B(e,2,this.length);var n=this[e+1]|this[e]<<8;return 32768&n?4294901760|n:n},a.prototype.readInt32LE=function(e,t){return t||B(e,4,this.length),this[e]|this[e+1]<<8|this[e+2]<<16|this[e+3]<<24},a.prototype.readInt32BE=function(e,t){return t||B(e,4,this.length),this[e]<<24|this[e+1]<<16|this[e+2]<<8|this[e+3]},a.prototype.readFloatLE=function(e,t){return t||B(e,4,this.length),J.read(this,e,!0,23,4)},a.prototype.readFloatBE=function(e,t){return t||B(e,4,this.length),J.read(this,e,!1,23,4)},a.prototype.readDoubleLE=function(e,t){return t||B(e,8,this.length),J.read(this,e,!0,52,8)},a.prototype.readDoubleBE=function(e,t){return t||B(e,8,this.length),J.read(this,e,!1,52,8)},a.prototype.writeUIntLE=function(e,t,n,r){e=+e,t|=0,n|=0,r||M(this,e,t,n,Math.pow(2,8*n)-1,0);var i=1,a=0;for(this[t]=255&e;++a<n&&(i*=256);)this[t+a]=e/i&255;return t+n},a.prototype.writeUIntBE=function(e,t,n,r){e=+e,t|=0,n|=0,r||M(this,e,t,n,Math.pow(2,8*n)-1,0);var i=n-1,a=1;for(this[t+i]=255&e;--i>=0&&(a*=256);)this[t+i]=e/a&255;return t+n},a.prototype.writeUInt8=function(e,t,n){return e=+e,t|=0,n||M(this,e,t,1,255,0),a.TYPED_ARRAY_SUPPORT||(e=Math.floor(e)),this[t]=255&e,t+1},a.prototype.writeUInt16LE=function(e,t,n){return e=+e,t|=0,n||M(this,e,t,2,65535,0),a.TYPED_ARRAY_SUPPORT?(this[t]=255&e,this[t+1]=e>>>8):P(this,e,t,!0),t+2},a.prototype.writeUInt16BE=function(e,t,n){return e=+e,t|=0,n||M(this,e,t,2,65535,0),a.TYPED_ARRAY_SUPPORT?(this[t]=e>>>8,this[t+1]=255&e):P(this,e,t,!1),t+2},a.prototype.writeUInt32LE=function(e,t,n){return e=+e,t|=0,n||M(this,e,t,4,4294967295,0),a.TYPED_ARRAY_SUPPORT?(this[t+3]=e>>>24,this[t+2]=e>>>16,this[t+1]=e>>>8,this[t]=255&e):N(this,e,t,!0),t+4},a.prototype.writeUInt32BE=function(e,t,n){return e=+e,t|=0,n||M(this,e,t,4,4294967295,0),a.TYPED_ARRAY_SUPPORT?(this[t]=e>>>24,this[t+1]=e>>>16,this[t+2]=e>>>8,this[t+3]=255&e):N(this,e,t,!1),t+4},a.prototype.writeIntLE=function(e,t,n,r){if(e=+e,t|=0,!r){var i=Math.pow(2,8*n-1);M(this,e,t,n,i-1,-i)}var a=0,o=1,s=0;for(this[t]=255&e;++a<n&&(o*=256);)e<0&&0===s&&0!==this[t+a-1]&&(s=1),this[t+a]=(e/o>>0)-s&255;return t+n},a.prototype.writeIntBE=function(e,t,n,r){if(e=+e,t|=0,!r){var i=Math.pow(2,8*n-1);M(this,e,t,n,i-1,-i)}var a=n-1,o=1,s=0;for(this[t+a]=255&e;--a>=0&&(o*=256);)e<0&&0===s&&0!==this[t+a+1]&&(s=1),this[t+a]=(e/o>>0)-s&255;return t+n},a.prototype.writeInt8=function(e,t,n){return e=+e,t|=0,n||M(this,e,t,1,127,-128),a.TYPED_ARRAY_SUPPORT||(e=Math.floor(e)),e<0&&(e=255+e+1),this[t]=255&e,t+1},a.prototype.writeInt16LE=function(e,t,n){return e=+e,t|=0,n||M(this,e,t,2,32767,-32768),a.TYPED_ARRAY_SUPPORT?(this[t]=255&e,this[t+1]=e>>>8):P(this,e,t,!0),t+2},a.prototype.writeInt16BE=function(e,t,n){return e=+e,t|=0,n||M(this,e,t,2,32767,-32768),a.TYPED_ARRAY_SUPPORT?(this[t]=e>>>8,this[t+1]=255&e):P(this,e,t,!1),t+2},a.prototype.writeInt32LE=function(e,t,n){return e=+e,t|=0,n||M(this,e,t,4,2147483647,-2147483648),a.TYPED_ARRAY_SUPPORT?(this[t]=255&e,this[t+1]=e>>>8,this[t+2]=e>>>16,this[t+3]=e>>>24):N(this,e,t,!0),t+4},a.prototype.writeInt32BE=function(e,t,n){return e=+e,t|=0,n||M(this,e,t,4,2147483647,-2147483648),e<0&&(e=4294967295+e+1),a.TYPED_ARRAY_SUPPORT?(this[t]=e>>>24,this[t+1]=e>>>16,this[t+2]=e>>>8,this[t+3]=255&e):N(this,e,t,!1),t+4},a.prototype.writeFloatLE=function(e,t,n){return D(this,e,t,!0,n)},a.prototype.writeFloatBE=function(e,t,n){return D(this,e,t,!1,n)},a.prototype.writeDoubleLE=function(e,t,n){return F(this,e,t,!0,n)},a.prototype.writeDoubleBE=function(e,t,n){return F(this,e,t,!1,n)},a.prototype.copy=function(e,t,n,r){if(n||(n=0),r||0===r||(r=this.length),t>=e.length&&(t=e.length),t||(t=0),r>0&&r<n&&(r=n),r===n)return 0;if(0===e.length||0===this.length)return 0;if(t<0)throw new RangeError("targetStart out of bounds");if(n<0||n>=this.length)throw new RangeError("sourceStart out of bounds");if(r<0)throw new RangeError("sourceEnd out of bounds");r>this.length&&(r=this.length),e.length-t<r-n&&(r=e.length-t+n);var i,o=r-n;if(this===e&&n<t&&t<r)for(i=o-1;i>=0;--i)e[i+t]=this[i+n];else if(o<1e3||!a.TYPED_ARRAY_SUPPORT)for(i=0;i<o;++i)e[i+t]=this[i+n];else Uint8Array.prototype.set.call(e,this.subarray(n,n+o),t);return o},a.prototype.fill=function(e,t,n,r){if("string"==typeof e){if("string"==typeof t?(r=t,t=0,n=this.length):"string"==typeof n&&(r=n,n=this.length),1===e.length){var i=e.charCodeAt(0);i<256&&(e=i)}if(void 0!==r&&"string"!=typeof r)throw new TypeError("encoding must be a string");if("string"==typeof r&&!a.isEncoding(r))throw new TypeError("Unknown encoding: "+r)}else"number"==typeof e&&(e&=255);if(t<0||this.length<t||this.length<n)throw new RangeError("Out of range index");if(n<=t)return this;t>>>=0,n=void 0===n?this.length:n>>>0,e||(e=0);var o;if("number"==typeof e)for(o=t;o<n;++o)this[o]=e;else{var s=a.isBuffer(e)?e:Y(new a(e,r).toString()),l=s.length;for(o=0;o<n-t;++o)this[o+t]=s[o%l]}return this};var ee=/[^+\/0-9A-Za-z-_]/g}).call(t,n(10))},function(e,t,n){"use strict";(function(e){if(t.base64=!0,t.array=!0,t.string=!0,t.arraybuffer="undefined"!=typeof ArrayBuffer&&"undefined"!=typeof Uint8Array,t.nodebuffer=void 0!==e,t.uint8array="undefined"!=typeof Uint8Array,"undefined"==typeof ArrayBuffer)t.blob=!1;else{var r=new ArrayBuffer(0);try{t.blob=0===new Blob([r],{type:"application/zip"}).size}catch(e){try{var i=self.BlobBuilder||self.WebKitBlobBuilder||self.MozBlobBuilder||self.MSBlobBuilder,a=new i;a.append(r),t.blob=0===a.getBlob("application/zip").size}catch(e){t.blob=!1}}}try{t.nodestream=!!n(25).Readable}catch(e){t.nodestream=!1}}).call(t,n(2).Buffer)},function(e,t,n){"use strict";function r(e,t){return Object.prototype.hasOwnProperty.call(e,t)}var i="undefined"!=typeof Uint8Array&&"undefined"!=typeof Uint16Array&&"undefined"!=typeof Int32Array;t.assign=function(e){for(var t=Array.prototype.slice.call(arguments,1);t.length;){var n=t.shift();if(n){if("object"!=typeof n)throw new TypeError(n+"must be non-object");for(var i in n)r(n,i)&&(e[i]=n[i])}}return e},t.shrinkBuf=function(e,t){return e.length===t?e:e.subarray?e.subarray(0,t):(e.length=t,e)};var a={arraySet:function(e,t,n,r,i){if(t.subarray&&e.subarray)return void e.set(t.subarray(n,n+r),i);for(var a=0;a<r;a++)e[i+a]=t[n+a]},flattenChunks:function(e){var t,n,r,i,a,o;for(r=0,t=0,n=e.length;t<n;t++)r+=e[t].length;for(o=new Uint8Array(r),i=0,t=0,n=e.length;t<n;t++)a=e[t],o.set(a,i),i+=a.length;return o}},o={arraySet:function(e,t,n,r,i){for(var a=0;a<r;a++)e[i+a]=t[n+a]},flattenChunks:function(e){return[].concat.apply([],e)}};t.setTyped=function(e){e?(t.Buf8=Uint8Array,t.Buf16=Uint16Array,t.Buf32=Int32Array,t.assign(t,a)):(t.Buf8=Array,t.Buf16=Array,t.Buf32=Array,t.assign(t,o))},t.setTyped(i)},function(e,t,n){"use strict";function r(e){if(!(this instanceof r))return new r(e);u.call(this,e),c.call(this,e),e&&!1===e.readable&&(this.readable=!1),e&&!1===e.writable&&(this.writable=!1),this.allowHalfOpen=!0,e&&!1===e.allowHalfOpen&&(this.allowHalfOpen=!1),this.once("end",i)}function i(){this.allowHalfOpen||this._writableState.ended||s(a,this)}function a(e){e.end()}var o=Object.keys||function(e){var t=[];for(var n in e)t.push(n);return t};e.exports=r;var s=n(16),l=n(8);l.inherits=n(7);var u=n(26),c=n(17);l.inherits(r,u);for(var f=o(c.prototype),h=0;h<f.length;h++){var d=f[h];r.prototype[d]||(r.prototype[d]=c.prototype[d])}},function(e,t,n){"use strict";function r(){l.call(this,"utf-8 decode"),this.leftOver=null}function i(){l.call(this,"utf-8 encode")}for(var a=n(0),o=n(3),s=n(14),l=n(1),u=new Array(256),c=0;c<256;c++)u[c]=c>=252?6:c>=248?5:c>=240?4:c>=224?3:c>=192?2:1;u[254]=u[254]=1;var f=function(e){var t,n,r,i,a,s=e.length,l=0;for(i=0;i<s;i++)n=e.charCodeAt(i),55296==(64512&n)&&i+1<s&&56320==(64512&(r=e.charCodeAt(i+1)))&&(n=65536+(n-55296<<10)+(r-56320),i++),l+=n<128?1:n<2048?2:n<65536?3:4;for(t=o.uint8array?new Uint8Array(l):new Array(l),a=0,i=0;a<l;i++)n=e.charCodeAt(i),55296==(64512&n)&&i+1<s&&56320==(64512&(r=e.charCodeAt(i+1)))&&(n=65536+(n-55296<<10)+(r-56320),i++),n<128?t[a++]=n:n<2048?(t[a++]=192|n>>>6,t[a++]=128|63&n):n<65536?(t[a++]=224|n>>>12,t[a++]=128|n>>>6&63,t[a++]=128|63&n):(t[a++]=240|n>>>18,t[a++]=128|n>>>12&63,t[a++]=128|n>>>6&63,t[a++]=128|63&n);return t},h=function(e,t){var n;for(t=t||e.length,t>e.length&&(t=e.length),n=t-1;n>=0&&128==(192&e[n]);)n--;return n<0?t:0===n?t:n+u[e[n]]>t?n:t},d=function(e){var t,n,r,i,o=e.length,s=new Array(2*o);for(n=0,t=0;t<o;)if((r=e[t++])<128)s[n++]=r;else if((i=u[r])>4)s[n++]=65533,t+=i-1;else{for(r&=2===i?31:3===i?15:7;i>1&&t<o;)r=r<<6|63&e[t++],i--;i>1?s[n++]=65533:r<65536?s[n++]=r:(r-=65536,s[n++]=55296|r>>10&1023,s[n++]=56320|1023&r)}return s.length!==n&&(s.subarray?s=s.subarray(0,n):s.length=n),a.applyFromCharCode(s)};t.utf8encode=function(e){return o.nodebuffer?s.newBufferFrom(e,"utf-8"):f(e)},t.utf8decode=function(e){return o.nodebuffer?a.transformTo("nodebuffer",e).toString("utf-8"):(e=a.transformTo(o.uint8array?"uint8array":"array",e),d(e))},a.inherits(r,l),r.prototype.processChunk=function(e){var n=a.transformTo(o.uint8array?"uint8array":"array",e.data);if(this.leftOver&&this.leftOver.length){if(o.uint8array){var r=n;n=new Uint8Array(r.length+this.leftOver.length),n.set(this.leftOver,0),n.set(r,this.leftOver.length)}else n=this.leftOver.concat(n);this.leftOver=null}var i=h(n),s=n;i!==n.length&&(o.uint8array?(s=n.subarray(0,i),this.leftOver=n.subarray(i,n.length)):(s=n.slice(0,i),this.leftOver=n.slice(i,n.length))),this.push({data:t.utf8decode(s),meta:e.meta})},r.prototype.flush=function(){this.leftOver&&this.leftOver.length&&(this.push({data:t.utf8decode(this.leftOver),meta:{}}),this.leftOver=null)},t.Utf8DecodeWorker=r,a.inherits(i,l),i.prototype.processChunk=function(e){this.push({data:t.utf8encode(e.data),meta:e.meta})},t.Utf8EncodeWorker=i},function(e,t){"function"==typeof Object.create?e.exports=function(e,t){e.super_=t,e.prototype=Object.create(t.prototype,{constructor:{value:e,enumerable:!1,writable:!0,configurable:!0}})}:e.exports=function(e,t){e.super_=t;var n=function(){};n.prototype=t.prototype,e.prototype=new n,e.prototype.constructor=e}},function(e,t,n){(function(e){function n(e){return Array.isArray?Array.isArray(e):"[object Array]"===g(e)}function r(e){return"boolean"==typeof e}function i(e){return null===e}function a(e){return null==e}function o(e){return"number"==typeof e}function s(e){return"string"==typeof e}function l(e){return"symbol"==typeof e}function u(e){return void 0===e}function c(e){return"[object RegExp]"===g(e)}function f(e){return"object"==typeof e&&null!==e}function h(e){return"[object Date]"===g(e)}function d(e){return"[object Error]"===g(e)||e instanceof Error}function p(e){return"function"==typeof e}function m(e){return null===e||"boolean"==typeof e||"number"==typeof e||"string"==typeof e||"symbol"==typeof e||void 0===e}function g(e){return Object.prototype.toString.call(e)}t.isArray=n,t.isBoolean=r,t.isNull=i,t.isNullOrUndefined=a,t.isNumber=o,t.isString=s,t.isSymbol=l,t.isUndefined=u,t.isRegExp=c,t.isObject=f,t.isDate=h,t.isError=d,t.isFunction=p,t.isPrimitive=m,t.isBuffer=e.isBuffer}).call(t,n(2).Buffer)},function(e,t,n){"use strict";var r=null;r="undefined"!=typeof Promise?Promise:n(80),e.exports={Promise:r}},function(e,t){var n;n=function(){return this}();try{n=n||Function("return this")()||(0,eval)("this")}catch(e){"object"==typeof window&&(n=window)}e.exports=n},function(e,t,n){function r(){i.call(this)}e.exports=r;var i=n(12).EventEmitter;n(7)(r,i),r.Readable=n(56),r.Writable=n(62),r.Duplex=n(63),r.Transform=n(64),r.PassThrough=n(65),r.Stream=r,r.prototype.pipe=function(e,t){function n(t){e.writable&&!1===e.write(t)&&u.pause&&u.pause()}function r(){u.readable&&u.resume&&u.resume()}function a(){c||(c=!0,e.end())}function o(){c||(c=!0,"function"==typeof e.destroy&&e.destroy())}function s(e){if(l(),0===i.listenerCount(this,"error"))throw e}function l(){u.removeListener("data",n),e.removeListener("drain",r),u.removeListener("end",a),u.removeListener("close",o),u.removeListener("error",s),e.removeListener("error",s),u.removeListener("end",l),u.removeListener("close",l),e.removeListener("close",l)}var u=this;u.on("data",n),e.on("drain",r),e._isStdio||t&&!1===t.end||(u.on("end",a),u.on("close",o));var c=!1;return u.on("error",s),e.on("error",s),u.on("end",l),u.on("close",l),e.on("close",l),e.emit("pipe",u),e}},function(e,t){function n(){this._events=this._events||{},this._maxListeners=this._maxListeners||void 0}function r(e){return"function"==typeof e}function i(e){return"number"==typeof e}function a(e){return"object"==typeof e&&null!==e}function o(e){return void 0===e}e.exports=n,n.EventEmitter=n,n.prototype._events=void 0,n.prototype._maxListeners=void 0,n.defaultMaxListeners=10,n.prototype.setMaxListeners=function(e){if(!i(e)||e<0||isNaN(e))throw TypeError("n must be a positive number");return this._maxListeners=e,this},n.prototype.emit=function(e){var t,n,i,s,l,u;if(this._events||(this._events={}),"error"===e&&(!this._events.error||a(this._events.error)&&!this._events.error.length)){if((t=arguments[1])instanceof Error)throw t;var c=new Error('Uncaught, unspecified "error" event. ('+t+")");throw c.context=t,c}if(n=this._events[e],o(n))return!1;if(r(n))switch(arguments.length){case 1:n.call(this);break;case 2:n.call(this,arguments[1]);break;case 3:n.call(this,arguments[1],arguments[2]);break;default:s=Array.prototype.slice.call(arguments,1),n.apply(this,s)}else if(a(n))for(s=Array.prototype.slice.call(arguments,1),u=n.slice(),i=u.length,l=0;l<i;l++)u[l].apply(this,s);return!0},n.prototype.addListener=function(e,t){var i;if(!r(t))throw TypeError("listener must be a function");return this._events||(this._events={}),this._events.newListener&&this.emit("newListener",e,r(t.listener)?t.listener:t),this._events[e]?a(this._events[e])?this._events[e].push(t):this._events[e]=[this._events[e],t]:this._events[e]=t,a(this._events[e])&&!this._events[e].warned&&(i=o(this._maxListeners)?n.defaultMaxListeners:this._maxListeners)&&i>0&&this._events[e].length>i&&(this._events[e].warned=!0,console.error("(node) warning: possible EventEmitter memory leak detected. %d listeners added. Use emitter.setMaxListeners() to increase limit.",this._events[e].length),"function"==typeof console.trace&&console.trace()),this},n.prototype.on=n.prototype.addListener,n.prototype.once=function(e,t){function n(){this.removeListener(e,n),i||(i=!0,t.apply(this,arguments))}if(!r(t))throw TypeError("listener must be a function");var i=!1;return n.listener=t,this.on(e,n),this},n.prototype.removeListener=function(e,t){var n,i,o,s;if(!r(t))throw TypeError("listener must be a function");if(!this._events||!this._events[e])return this;if(n=this._events[e],o=n.length,i=-1,n===t||r(n.listener)&&n.listener===t)delete this._events[e],this._events.removeListener&&this.emit("removeListener",e,t);else if(a(n)){for(s=o;s-- >0;)if(n[s]===t||n[s].listener&&n[s].listener===t){i=s;break}if(i<0)return this;1===n.length?(n.length=0,delete this._events[e]):n.splice(i,1),this._events.removeListener&&this.emit("removeListener",e,t)}return this},n.prototype.removeAllListeners=function(e){var t,n;if(!this._events)return this;if(!this._events.removeListener)return 0===arguments.length?this._events={}:this._events[e]&&delete this._events[e],this;if(0===arguments.length){for(t in this._events)"removeListener"!==t&&this.removeAllListeners(t);return this.removeAllListeners("removeListener"),this._events={},this}if(n=this._events[e],r(n))this.removeListener(e,n);else if(n)for(;n.length;)this.removeListener(e,n[n.length-1]);return delete this._events[e],this},n.prototype.listeners=function(e){return this._events&&this._events[e]?r(this._events[e])?[this._events[e]]:this._events[e].slice():[]},n.prototype.listenerCount=function(e){if(this._events){var t=this._events[e];if(r(t))return 1;if(t)return t.length}return 0},n.listenerCount=function(e,t){return e.listenerCount(t)}},function(e,t){function n(){throw new Error("setTimeout has not been defined")}function r(){throw new Error("clearTimeout has not been defined")}function i(e){if(c===setTimeout)return setTimeout(e,0);if((c===n||!c)&&setTimeout)return c=setTimeout,setTimeout(e,0);try{return c(e,0)}catch(t){try{return c.call(null,e,0)}catch(t){return c.call(this,e,0)}}}function a(e){if(f===clearTimeout)return clearTimeout(e);if((f===r||!f)&&clearTimeout)return f=clearTimeout,clearTimeout(e);try{return f(e)}catch(t){try{return f.call(null,e)}catch(t){return f.call(this,e)}}}function o(){m&&d&&(m=!1,d.length?p=d.concat(p):g=-1,p.length&&s())}function s(){if(!m){var e=i(o);m=!0;for(var t=p.length;t;){for(d=p,p=[];++g<t;)d&&d[g].run();g=-1,t=p.length}d=null,m=!1,a(e)}}function l(e,t){this.fun=e,this.array=t}function u(){}var c,f,h=e.exports={};!function(){try{c="function"==typeof setTimeout?setTimeout:n}catch(e){c=n}try{f="function"==typeof clearTimeout?clearTimeout:r}catch(e){f=r}}();var d,p=[],m=!1,g=-1;h.nextTick=function(e){var t=new Array(arguments.length-1);if(arguments.length>1)for(var n=1;n<arguments.length;n++)t[n-1]=arguments[n];p.push(new l(e,t)),1!==p.length||m||i(s)},l.prototype.run=function(){this.fun.apply(null,this.array)},h.title="browser",h.browser=!0,h.env={},h.argv=[],h.version="",h.versions={},h.on=u,h.addListener=u,h.once=u,h.off=u,h.removeListener=u,h.removeAllListeners=u,h.emit=u,h.prependListener=u,h.prependOnceListener=u,h.listeners=function(e){return[]},h.binding=function(e){throw new Error("process.binding is not supported")},h.cwd=function(){return"/"},h.chdir=function(e){throw new Error("process.chdir is not supported")},h.umask=function(){return 0}},function(e,t,n){"use strict";(function(t){e.exports={isNode:void 0!==t,newBufferFrom:function(e,n){return new t(e,n)},allocBuffer:function(e){return t.alloc?t.alloc(e):new t(e)},isBuffer:function(e){return t.isBuffer(e)},isStream:function(e){return e&&"function"==typeof e.on&&"function"==typeof e.pause&&"function"==typeof e.resume}}}).call(t,n(2).Buffer)},function(e,t){var n=e.exports="undefined"!=typeof window&&window.Math==Math?window:"undefined"!=typeof self&&self.Math==Math?self:Function("return this")();"number"==typeof __g&&(__g=n)},function(e,t,n){"use strict";(function(t){function n(e,n,r,i){if("function"!=typeof e)throw new TypeError('"callback" argument must be a function');var a,o,s=arguments.length;switch(s){case 0:case 1:return t.nextTick(e);case 2:return t.nextTick(function(){e.call(null,n)});case 3:return t.nextTick(function(){e.call(null,n,r)});case 4:return t.nextTick(function(){e.call(null,n,r,i)});default:for(a=new Array(s-1),o=0;o<a.length;)a[o++]=arguments[o];return t.nextTick(function(){e.apply(null,a)})}}!t.version||0===t.version.indexOf("v0.")||0===t.version.indexOf("v1.")&&0!==t.version.indexOf("v1.8.")?e.exports=n:e.exports=t.nextTick}).call(t,n(13))},function(e,t,n){"use strict";(function(t,r){function i(){}function a(e,t,n){this.chunk=e,this.encoding=t,this.callback=n,this.next=null}function o(e,t){I=I||n(5),e=e||{},this.objectMode=!!e.objectMode,t instanceof I&&(this.objectMode=this.objectMode||!!e.writableObjectMode);var r=e.highWaterMark,i=this.objectMode?16:16384;this.highWaterMark=r||0===r?r:i,this.highWaterMark=~~this.highWaterMark,this.needDrain=!1,this.ending=!1,this.ended=!1,this.finished=!1;var a=!1===e.decodeStrings;this.decodeStrings=!a,this.defaultEncoding=e.defaultEncoding||"utf8",this.length=0,this.writing=!1,this.corked=0,this.sync=!0,this.bufferProcessing=!1,this.onwrite=function(e){m(t,e)},this.writecb=null,this.writelen=0,this.bufferedRequest=null,this.lastBufferedRequest=null,this.pendingcb=0,this.prefinished=!1,this.errorEmitted=!1,this.bufferedRequestCount=0,this.corkedRequestsFree=new x(this),this.corkedRequestsFree.next=new x(this)}function s(e){if(I=I||n(5),!(this instanceof s||this instanceof I))return new s(e);this._writableState=new o(e,this),this.writable=!0,e&&("function"==typeof e.write&&(this._write=e.write),"function"==typeof e.writev&&(this._writev=e.writev)),A.call(this)}function l(e,t){var n=new Error("write after end");e.emit("error",n),S(t,n)}function u(e,t,n,r){var i=!0;if(!T.isBuffer(n)&&"string"!=typeof n&&null!==n&&void 0!==n&&!t.objectMode){var a=new TypeError("Invalid non-string/buffer chunk");e.emit("error",a),S(r,a),i=!1}return i}function c(e,t,n){return e.objectMode||!1===e.decodeStrings||"string"!=typeof t||(t=new T(t,n)),t}function f(e,t,n,r,i){n=c(t,n,r),T.isBuffer(n)&&(r="buffer");var o=t.objectMode?1:n.length;t.length+=o;var s=t.length<t.highWaterMark;if(s||(t.needDrain=!0),t.writing||t.corked){var l=t.lastBufferedRequest;t.lastBufferedRequest=new a(n,r,i),l?l.next=t.lastBufferedRequest:t.bufferedRequest=t.lastBufferedRequest,t.bufferedRequestCount+=1}else h(e,t,!1,o,n,r,i);return s}function h(e,t,n,r,i,a,o){t.writelen=r,t.writecb=o,t.writing=!0,t.sync=!0,n?e._writev(i,t.onwrite):e._write(i,a,t.onwrite),t.sync=!1}function d(e,t,n,r,i){--t.pendingcb,n?S(i,r):i(r),e._writableState.errorEmitted=!0,e.emit("error",r)}function p(e){e.writing=!1,e.writecb=null,e.length-=e.writelen,e.writelen=0}function m(e,t){var n=e._writableState,r=n.sync,i=n.writecb;if(p(n),t)d(e,n,r,t,i);else{var a=y(n);a||n.corked||n.bufferProcessing||!n.bufferedRequest||b(e,n),r?E(g,e,n,a,i):g(e,n,a,i)}}function g(e,t,n,r){n||v(e,t),t.pendingcb--,r(),_(e,t)}function v(e,t){0===t.length&&t.needDrain&&(t.needDrain=!1,e.emit("drain"))}function b(e,t){t.bufferProcessing=!0;var n=t.bufferedRequest;if(e._writev&&n&&n.next){var r=t.bufferedRequestCount,i=new Array(r),a=t.corkedRequestsFree;a.entry=n;for(var o=0;n;)i[o]=n,n=n.next,o+=1;h(e,t,!0,t.length,i,"",a.finish),t.pendingcb++,t.lastBufferedRequest=null,t.corkedRequestsFree=a.next,a.next=null}else{for(;n;){var s=n.chunk,l=n.encoding,u=n.callback;if(h(e,t,!1,t.objectMode?1:s.length,s,l,u),n=n.next,t.writing)break}null===n&&(t.lastBufferedRequest=null)}t.bufferedRequestCount=0,t.bufferedRequest=n,t.bufferProcessing=!1}function y(e){return e.ending&&0===e.length&&null===e.bufferedRequest&&!e.finished&&!e.writing}function w(e,t){t.prefinished||(t.prefinished=!0,e.emit("prefinish"))}function _(e,t){var n=y(t);return n&&(0===t.pendingcb?(w(e,t),t.finished=!0,e.emit("finish")):w(e,t)),n}function k(e,t,n){t.ending=!0,_(e,t),n&&(t.finished?S(n):e.once("finish",n)),t.ended=!0,e.writable=!1}function x(e){var t=this;this.next=null,this.entry=null,this.finish=function(n){var r=t.entry;for(t.entry=null;r;){var i=r.callback;e.pendingcb--,i(n),r=r.next}e.corkedRequestsFree?e.corkedRequestsFree.next=t:e.corkedRequestsFree=t}}e.exports=s;var S=n(16),E=!t.browser&&["v0.10","v0.9."].indexOf(t.version.slice(0,5))>-1?r:S,T=n(2).Buffer;s.WritableState=o;var C=n(8);C.inherits=n(7);var A,O={deprecate:n(60)};!function(){try{A=n(11)}catch(e){}finally{A||(A=n(12).EventEmitter)}}();var T=n(2).Buffer;C.inherits(s,A);var I;o.prototype.getBuffer=function(){for(var e=this.bufferedRequest,t=[];e;)t.push(e),e=e.next;return t},function(){try{Object.defineProperty(o.prototype,"buffer",{get:O.deprecate(function(){return this.getBuffer()},"_writableState.buffer is deprecated. Use _writableState.getBuffer instead.")})}catch(e){}}();var I;s.prototype.pipe=function(){this.emit("error",new Error("Cannot pipe. Not readable."))},s.prototype.write=function(e,t,n){var r=this._writableState,a=!1;return"function"==typeof t&&(n=t,t=null),T.isBuffer(e)?t="buffer":t||(t=r.defaultEncoding),"function"!=typeof n&&(n=i),r.ended?l(this,n):u(this,r,e,n)&&(r.pendingcb++,a=f(this,r,e,t,n)),a},s.prototype.cork=function(){this._writableState.corked++},s.prototype.uncork=function(){var e=this._writableState;e.corked&&(e.corked--,e.writing||e.corked||e.finished||e.bufferProcessing||!e.bufferedRequest||b(this,e))},s.prototype.setDefaultEncoding=function(e){if("string"==typeof e&&(e=e.toLowerCase()),!(["hex","utf8","utf-8","ascii","binary","base64","ucs2","ucs-2","utf16le","utf-16le","raw"].indexOf((e+"").toLowerCase())>-1))throw new TypeError("Unknown encoding: "+e);this._writableState.defaultEncoding=e},s.prototype._write=function(e,t,n){n(new Error("not implemented"))},s.prototype._writev=null,s.prototype.end=function(e,t,n){var r=this._writableState;"function"==typeof e?(n=e,e=null,t=null):"function"==typeof t&&(n=t,t=null),null!==e&&void 0!==e&&this.write(e,t),r.corked&&(r.corked=1,this.uncork()),r.ending||r.finished||k(this,r,n)}}).call(t,n(13),n(58).setImmediate)},function(e,t,n){"use strict";function r(e){this.afterTransform=function(t,n){return i(e,t,n)},this.needTransform=!1,this.transforming=!1,this.writecb=null,this.writechunk=null,this.writeencoding=null}function i(e,t,n){var r=e._transformState;r.transforming=!1;var i=r.writecb;if(!i)return e.emit("error",new Error("no writecb in Transform class"));r.writechunk=null,r.writecb=null,null!==n&&void 0!==n&&e.push(n),i(t);var a=e._readableState;a.reading=!1,(a.needReadable||a.length<a.highWaterMark)&&e._read(a.highWaterMark)}function a(e){if(!(this instanceof a))return new a(e);s.call(this,e),this._transformState=new r(this);var t=this;this._readableState.needReadable=!0,this._readableState.sync=!1,e&&("function"==typeof e.transform&&(this._transform=e.transform),"function"==typeof e.flush&&(this._flush=e.flush)),this.once("prefinish",function(){"function"==typeof this._flush?this._flush(function(e){o(t,e)}):o(t)})}function o(e,t){if(t)return e.emit("error",t);var n=e._writableState,r=e._transformState;if(n.length)throw new Error("calling transform done when ws.length != 0");if(r.transforming)throw new Error("calling transform done when still transforming");return e.push(null)}e.exports=a;var s=n(5),l=n(8);l.inherits=n(7),l.inherits(a,s),a.prototype.push=function(e,t){return this._transformState.needTransform=!1,s.prototype.push.call(this,e,t)},a.prototype._transform=function(e,t,n){throw new Error("not implemented")},a.prototype._write=function(e,t,n){var r=this._transformState;if(r.writecb=n,r.writechunk=e,r.writeencoding=t,!r.transforming){var i=this._readableState;(r.needTransform||i.needReadable||i.length<i.highWaterMark)&&this._read(i.highWaterMark)}},a.prototype._read=function(e){var t=this._transformState;null!==t.writechunk&&t.writecb&&!t.transforming?(t.transforming=!0,this._transform(t.writechunk,t.writeencoding,t.afterTransform)):t.needTransform=!0}},function(e,t){e.exports=function(e){return"object"==typeof e?null!==e:"function"==typeof e}},function(e,t,n){e.exports=!n(32)(function(){return 7!=Object.defineProperty({},"a",{get:function(){return 7}}).a})},function(e,t,n){"use strict";function r(e,t,n,r,i){this.compressedSize=e,this.uncompressedSize=t,this.crc32=n,this.compression=r,this.compressedContent=i}var i=n(9),a=n(36),o=n(37),s=n(38),o=n(37);r.prototype={getContentWorker:function(){var e=new a(i.Promise.resolve(this.compressedContent)).pipe(this.compression.uncompressWorker()).pipe(new o("data_length")),t=this;return e.on("end",function(){if(this.streamInfo.data_length!==t.uncompressedSize)throw new Error("Bug : uncompressed data size mismatch")}),e},getCompressedWorker:function(){return new a(i.Promise.resolve(this.compressedContent)).withStreamInfo("compressedSize",this.compressedSize).withStreamInfo("uncompressedSize",this.uncompressedSize).withStreamInfo("crc32",this.crc32).withStreamInfo("compression",this.compression)}},r.createWorkerFrom=function(e,t,n){return e.pipe(new s).pipe(new o("uncompressedSize")).pipe(t.compressWorker(n)).pipe(new o("compressedSize")).withStreamInfo("compression",t)},e.exports=r},function(e,t,n){"use strict";function r(e,t,n,r){var i=o,a=r+n;e^=-1;for(var s=r;s<a;s++)e=e>>>8^i[255&(e^t[s])];return-1^e}function i(e,t,n,r){var i=o,a=r+n;e^=-1;for(var s=r;s<a;s++)e=e>>>8^i[255&(e^t.charCodeAt(s))];return-1^e}var a=n(0),o=function(){for(var e,t=[],n=0;n<256;n++){e=n;for(var r=0;r<8;r++)e=1&e?3988292384^e>>>1:e>>>1;t[n]=e}return t}();e.exports=function(e,t){return void 0!==e&&e.length?"string"!==a.getTypeOf(e)?r(0|t,e,e.length,0):i(0|t,e,e.length,0):0}},function(e,t,n){"use strict";e.exports={2:"need dictionary",1:"stream end",0:"","-1":"file error","-2":"stream error","-3":"data error","-4":"insufficient memory","-5":"buffer error","-6":"incompatible version"}},function(e,t){var n={}.toString;e.exports=Array.isArray||function(e){return"[object Array]"==n.call(e)}},function(e,t,n){e.exports=n(11)},function(e,t,n){"use strict";(function(t){function r(e,t){B=B||n(5),e=e||{},this.objectMode=!!e.objectMode,t instanceof B&&(this.objectMode=this.objectMode||!!e.readableObjectMode);var r=e.highWaterMark,i=this.objectMode?16:16384;this.highWaterMark=r||0===r?r:i,this.highWaterMark=~~this.highWaterMark,this.buffer=[],this.length=0,this.pipes=null,this.pipesCount=0,this.flowing=null,this.ended=!1,this.endEmitted=!1,this.reading=!1,this.sync=!0,this.needReadable=!1,this.emittedReadable=!1,this.readableListening=!1,this.resumeScheduled=!1,this.defaultEncoding=e.defaultEncoding||"utf8",this.ranOut=!1,this.awaitDrain=0,this.readingMore=!1,this.decoder=null,this.encoding=null,e.encoding&&(j||(j=n(27).StringDecoder),this.decoder=new j(e.encoding),this.encoding=e.encoding)}function i(e){if(B=B||n(5),!(this instanceof i))return new i(e);this._readableState=new r(e,this),this.readable=!0,e&&"function"==typeof e.read&&(this._read=e.read),A.call(this)}function a(e,t,n,r,i){var a=u(t,n);if(a)e.emit("error",a);else if(null===n)t.reading=!1,c(e,t);else if(t.objectMode||n&&n.length>0)if(t.ended&&!i){var s=new Error("stream.push() after EOF");e.emit("error",s)}else if(t.endEmitted&&i){var s=new Error("stream.unshift() after end event");e.emit("error",s)}else{var l;!t.decoder||i||r||(n=t.decoder.write(n),l=!t.objectMode&&0===n.length),i||(t.reading=!1),l||(t.flowing&&0===t.length&&!t.sync?(e.emit("data",n),e.read(0)):(t.length+=t.objectMode?1:n.length,i?t.buffer.unshift(n):t.buffer.push(n),t.needReadable&&f(e))),d(e,t)}else i||(t.reading=!1);return o(t)}function o(e){return!e.ended&&(e.needReadable||e.length<e.highWaterMark||0===e.length)}function s(e){return e>=M?e=M:(e--,e|=e>>>1,e|=e>>>2,e|=e>>>4,e|=e>>>8,e|=e>>>16,e++),e}function l(e,t){return 0===t.length&&t.ended?0:t.objectMode?0===e?0:1:null===e||isNaN(e)?t.flowing&&t.buffer.length?t.buffer[0].length:t.length:e<=0?0:(e>t.highWaterMark&&(t.highWaterMark=s(e)),e>t.length?t.ended?t.length:(t.needReadable=!0,0):e)}function u(e,t){var n=null;return C.isBuffer(t)||"string"==typeof t||null===t||void 0===t||e.objectMode||(n=new TypeError("Invalid non-string/buffer chunk")),n}function c(e,t){if(!t.ended){if(t.decoder){var n=t.decoder.end();n&&n.length&&(t.buffer.push(n),t.length+=t.objectMode?1:n.length)}t.ended=!0,f(e)}}function f(e){var t=e._readableState;t.needReadable=!1,t.emittedReadable||(L("emitReadable",t.flowing),t.emittedReadable=!0,t.sync?E(h,e):h(e))}function h(e){L("emit readable"),e.emit("readable"),y(e)}function d(e,t){t.readingMore||(t.readingMore=!0,E(p,e,t))}function p(e,t){for(var n=t.length;!t.reading&&!t.flowing&&!t.ended&&t.length<t.highWaterMark&&(L("maybeReadMore read 0"),e.read(0),n!==t.length);)n=t.length;t.readingMore=!1}function m(e){return function(){var t=e._readableState;L("pipeOnDrain",t.awaitDrain),t.awaitDrain&&t.awaitDrain--,0===t.awaitDrain&&O(e,"data")&&(t.flowing=!0,y(e))}}function g(e){L("readable nexttick read 0"),e.read(0)}function v(e,t){t.resumeScheduled||(t.resumeScheduled=!0,E(b,e,t))}function b(e,t){t.reading||(L("resume read 0"),e.read(0)),t.resumeScheduled=!1,e.emit("resume"),y(e),t.flowing&&!t.reading&&e.read(0)}function y(e){var t=e._readableState;if(L("flow",t.flowing),t.flowing)do{var n=e.read()}while(null!==n&&t.flowing)}function w(e,t){var n,r=t.buffer,i=t.length,a=!!t.decoder,o=!!t.objectMode;if(0===r.length)return null;if(0===i)n=null;else if(o)n=r.shift();else if(!e||e>=i)n=a?r.join(""):1===r.length?r[0]:C.concat(r,i),r.length=0;else if(e<r[0].length){var s=r[0];n=s.slice(0,e),r[0]=s.slice(e)}else if(e===r[0].length)n=r.shift();else{n=a?"":new C(e);for(var l=0,u=0,c=r.length;u<c&&l<e;u++){var s=r[0],f=Math.min(e-l,s.length);a?n+=s.slice(0,f):s.copy(n,l,0,f),f<s.length?r[0]=s.slice(f):r.shift(),l+=f}}return n}function _(e){var t=e._readableState;if(t.length>0)throw new Error("endReadable called on non-empty stream");t.endEmitted||(t.ended=!0,E(k,t,e))}function k(e,t){e.endEmitted||0!==e.length||(e.endEmitted=!0,t.readable=!1,t.emit("end"))}function x(e,t){for(var n=0,r=e.length;n<r;n++)t(e[n],n)}function S(e,t){for(var n=0,r=e.length;n<r;n++)if(e[n]===t)return n;return-1}e.exports=i;var E=n(16),T=n(24),C=n(2).Buffer;i.ReadableState=r;var A,O=(n(12),function(e,t){return e.listeners(t).length});!function(){try{A=n(11)}catch(e){}finally{A||(A=n(12).EventEmitter)}}();var C=n(2).Buffer,I=n(8);I.inherits=n(7);var R=n(57),L=void 0;L=R&&R.debuglog?R.debuglog("stream"):function(){};var j;I.inherits(i,A);var B,B;i.prototype.push=function(e,t){var n=this._readableState;return n.objectMode||"string"!=typeof e||(t=t||n.defaultEncoding)!==n.encoding&&(e=new C(e,t),t=""),a(this,n,e,t,!1)},i.prototype.unshift=function(e){return a(this,this._readableState,e,"",!0)},i.prototype.isPaused=function(){return!1===this._readableState.flowing},i.prototype.setEncoding=function(e){return j||(j=n(27).StringDecoder),this._readableState.decoder=new j(e),this._readableState.encoding=e,this};var M=8388608;i.prototype.read=function(e){L("read",e);var t=this._readableState,n=e;if(("number"!=typeof e||e>0)&&(t.emittedReadable=!1),0===e&&t.needReadable&&(t.length>=t.highWaterMark||t.ended))return L("read: emitReadable",t.length,t.ended),0===t.length&&t.ended?_(this):f(this),null;if(0===(e=l(e,t))&&t.ended)return 0===t.length&&_(this),null;var r=t.needReadable;L("need readable",r),(0===t.length||t.length-e<t.highWaterMark)&&(r=!0,L("length less than watermark",r)),(t.ended||t.reading)&&(r=!1,L("reading or ended",r)),r&&(L("do read"),t.reading=!0,t.sync=!0,0===t.length&&(t.needReadable=!0),this._read(t.highWaterMark),t.sync=!1),r&&!t.reading&&(e=l(n,t));var i;return i=e>0?w(e,t):null,null===i&&(t.needReadable=!0,e=0),t.length-=e,0!==t.length||t.ended||(t.needReadable=!0),n!==e&&t.ended&&0===t.length&&_(this),null!==i&&this.emit("data",i),i},i.prototype._read=function(e){this.emit("error",new Error("not implemented"))},i.prototype.pipe=function(e,n){function r(e){L("onunpipe"),e===f&&a()}function i(){L("onend"),e.end()}function a(){L("cleanup"),e.removeListener("close",l),e.removeListener("finish",u),e.removeListener("drain",g),e.removeListener("error",s),e.removeListener("unpipe",r),f.removeListener("end",i),f.removeListener("end",a),f.removeListener("data",o),v=!0,!h.awaitDrain||e._writableState&&!e._writableState.needDrain||g()}function o(t){L("ondata"),!1===e.write(t)&&(1!==h.pipesCount||h.pipes[0]!==e||1!==f.listenerCount("data")||v||(L("false write response, pause",f._readableState.awaitDrain),f._readableState.awaitDrain++),f.pause())}function s(t){L("onerror",t),c(),e.removeListener("error",s),0===O(e,"error")&&e.emit("error",t)}function l(){e.removeListener("finish",u),c()}function u(){L("onfinish"),e.removeListener("close",l),c()}function c(){L("unpipe"),f.unpipe(e)}var f=this,h=this._readableState;switch(h.pipesCount){case 0:h.pipes=e;break;case 1:h.pipes=[h.pipes,e];break;default:h.pipes.push(e)}h.pipesCount+=1,L("pipe count=%d opts=%j",h.pipesCount,n);var d=(!n||!1!==n.end)&&e!==t.stdout&&e!==t.stderr,p=d?i:a;h.endEmitted?E(p):f.once("end",p),e.on("unpipe",r);var g=m(f);e.on("drain",g);var v=!1;return f.on("data",o),e._events&&e._events.error?T(e._events.error)?e._events.error.unshift(s):e._events.error=[s,e._events.error]:e.on("error",s),e.once("close",l),e.once("finish",u),e.emit("pipe",f),h.flowing||(L("pipe resume"),f.resume()),e},i.prototype.unpipe=function(e){var t=this._readableState;if(0===t.pipesCount)return this;if(1===t.pipesCount)return e&&e!==t.pipes?this:(e||(e=t.pipes),t.pipes=null,t.pipesCount=0,t.flowing=!1,e&&e.emit("unpipe",this),this);if(!e){var n=t.pipes,r=t.pipesCount;t.pipes=null,t.pipesCount=0,t.flowing=!1;for(var i=0;i<r;i++)n[i].emit("unpipe",this);return this}var a=S(t.pipes,e);return-1===a?this:(t.pipes.splice(a,1),t.pipesCount-=1,1===t.pipesCount&&(t.pipes=t.pipes[0]),e.emit("unpipe",this),this)},i.prototype.on=function(e,t){var n=A.prototype.on.call(this,e,t);if("data"===e&&!1!==this._readableState.flowing&&this.resume(),"readable"===e&&!this._readableState.endEmitted){var r=this._readableState;r.readableListening||(r.readableListening=!0,r.emittedReadable=!1,r.needReadable=!0,r.reading?r.length&&f(this):E(g,this))}return n},i.prototype.addListener=i.prototype.on,i.prototype.resume=function(){var e=this._readableState;return e.flowing||(L("resume"),e.flowing=!0,v(this,e)),this},i.prototype.pause=function(){return L("call pause flowing=%j",this._readableState.flowing),!1!==this._readableState.flowing&&(L("pause"),this._readableState.flowing=!1,this.emit("pause")),this},i.prototype.wrap=function(e){var t=this._readableState,n=!1,r=this;e.on("end",function(){if(L("wrapped end"),t.decoder&&!t.ended){var e=t.decoder.end();e&&e.length&&r.push(e)}r.push(null)}),e.on("data",function(i){L("wrapped data"),t.decoder&&(i=t.decoder.write(i)),(!t.objectMode||null!==i&&void 0!==i)&&(t.objectMode||i&&i.length)&&(r.push(i)||(n=!0,e.pause()))});for(var i in e)void 0===this[i]&&"function"==typeof e[i]&&(this[i]=function(t){return function(){return e[t].apply(e,arguments)}}(i));return x(["error","close","destroy","pause","resume"],function(t){e.on(t,r.emit.bind(r,t))}),r._read=function(t){L("wrapped _read",t),n&&(n=!1,e.resume())},r},i._fromList=w}).call(t,n(13))},function(e,t,n){"use strict";function r(e){if(!e)return"utf8";for(var t;;)switch(e){case"utf8":case"utf-8":return"utf8";case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":return"utf16le";case"latin1":case"binary":return"latin1";case"base64":case"ascii":case"hex":return e;default:if(t)return;e=(""+e).toLowerCase(),t=!0}}function i(e){var t=r(e);if("string"!=typeof t&&(b.isEncoding===y||!y(e)))throw new Error("Unknown encoding: "+e);return t||e}function a(e){this.encoding=i(e);var t;switch(this.encoding){case"utf16le":this.text=h,this.end=d,t=4;break;case"utf8":this.fillLast=u,t=4;break;case"base64":this.text=p,this.end=m,t=3;break;default:return this.write=g,void(this.end=v)}this.lastNeed=0,this.lastTotal=0,this.lastChar=b.allocUnsafe(t)}function o(e){return e<=127?0:e>>5==6?2:e>>4==14?3:e>>3==30?4:-1}function s(e,t,n){var r=t.length-1;if(r<n)return 0;var i=o(t[r]);return i>=0?(i>0&&(e.lastNeed=i-1),i):--r<n?0:(i=o(t[r]))>=0?(i>0&&(e.lastNeed=i-2),i):--r<n?0:(i=o(t[r]),i>=0?(i>0&&(2===i?i=0:e.lastNeed=i-3),i):0)}function l(e,t,n){if(128!=(192&t[0]))return e.lastNeed=0,"�".repeat(n);if(e.lastNeed>1&&t.length>1){if(128!=(192&t[1]))return e.lastNeed=1,"�".repeat(n+1);if(e.lastNeed>2&&t.length>2&&128!=(192&t[2]))return e.lastNeed=2,"�".repeat(n+2)}}function u(e){var t=this.lastTotal-this.lastNeed,n=l(this,e,t);return void 0!==n?n:this.lastNeed<=e.length?(e.copy(this.lastChar,t,0,this.lastNeed),this.lastChar.toString(this.encoding,0,this.lastTotal)):(e.copy(this.lastChar,t,0,e.length),void(this.lastNeed-=e.length))}function c(e,t){var n=s(this,e,t);if(!this.lastNeed)return e.toString("utf8",t);this.lastTotal=n;var r=e.length-(n-this.lastNeed);return e.copy(this.lastChar,0,r),e.toString("utf8",t,r)}function f(e){var t=e&&e.length?this.write(e):"";return this.lastNeed?t+"�".repeat(this.lastTotal-this.lastNeed):t}function h(e,t){if((e.length-t)%2==0){var n=e.toString("utf16le",t);if(n){var r=n.charCodeAt(n.length-1);if(r>=55296&&r<=56319)return this.lastNeed=2,this.lastTotal=4,this.lastChar[0]=e[e.length-2],this.lastChar[1]=e[e.length-1],n.slice(0,-1)}return n}return this.lastNeed=1,this.lastTotal=2,this.lastChar[0]=e[e.length-1],e.toString("utf16le",t,e.length-1)}function d(e){var t=e&&e.length?this.write(e):"";if(this.lastNeed){var n=this.lastTotal-this.lastNeed;return t+this.lastChar.toString("utf16le",0,n)}return t}function p(e,t){var n=(e.length-t)%3;return 0===n?e.toString("base64",t):(this.lastNeed=3-n,this.lastTotal=3,1===n?this.lastChar[0]=e[e.length-1]:(this.lastChar[0]=e[e.length-2],this.lastChar[1]=e[e.length-1]),e.toString("base64",t,e.length-n))}function m(e){var t=e&&e.length?this.write(e):"";return this.lastNeed?t+this.lastChar.toString("base64",0,3-this.lastNeed):t}function g(e){return e.toString(this.encoding)}function v(e){return e&&e.length?this.write(e):""}var b=n(61).Buffer,y=b.isEncoding||function(e){switch((e=""+e)&&e.toLowerCase()){case"hex":case"utf8":case"utf-8":case"ascii":case"binary":case"base64":case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":case"raw":return!0;default:return!1}};t.StringDecoder=a,a.prototype.write=function(e){if(0===e.length)return"";var t,n;if(this.lastNeed){if(void 0===(t=this.fillLast(e)))return"";n=this.lastNeed,this.lastNeed=0}else n=0;return n<e.length?t?t+this.text(e,n):this.text(e,n):t||""},a.prototype.end=f,a.prototype.text=c,a.prototype.fillLast=function(e){if(this.lastNeed<=e.length)return e.copy(this.lastChar,this.lastTotal-this.lastNeed,0,this.lastNeed),this.lastChar.toString(this.encoding,0,this.lastTotal);e.copy(this.lastChar,this.lastTotal-this.lastNeed,0,e.length),this.lastNeed-=e.length}},function(e,t,n){"use strict";function r(e){if(!(this instanceof r))return new r(e);i.call(this,e)}e.exports=r;var i=n(18),a=n(8);a.inherits=n(7),a.inherits(r,i),r.prototype._transform=function(e,t,n){n(null,e)}},function(e,t,n){"use strict";var r=n(0),i=n(3),a="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";t.encode=function(e){for(var t,n,i,o,s,l,u,c=[],f=0,h=e.length,d=h,p="string"!==r.getTypeOf(e);f<e.length;)d=h-f,p?(t=e[f++],n=f<h?e[f++]:0,i=f<h?e[f++]:0):(t=e.charCodeAt(f++),n=f<h?e.charCodeAt(f++):0,i=f<h?e.charCodeAt(f++):0),o=t>>2,s=(3&t)<<4|n>>4,l=d>1?(15&n)<<2|i>>6:64,u=d>2?63&i:64,c.push(a.charAt(o)+a.charAt(s)+a.charAt(l)+a.charAt(u));return c.join("")},t.decode=function(e){var t,n,r,o,s,l,u,c=0,f=0;if("data:"===e.substr(0,"data:".length))throw new Error("Invalid base64 input, it looks like a data url.");e=e.replace(/[^A-Za-z0-9\+\/\=]/g,"");var h=3*e.length/4;if(e.charAt(e.length-1)===a.charAt(64)&&h--,e.charAt(e.length-2)===a.charAt(64)&&h--,h%1!=0)throw new Error("Invalid base64 input, bad content length.");var d;for(d=i.uint8array?new Uint8Array(0|h):new Array(0|h);c<e.length;)o=a.indexOf(e.charAt(c++)),s=a.indexOf(e.charAt(c++)),l=a.indexOf(e.charAt(c++)),u=a.indexOf(e.charAt(c++)),t=o<<2|s>>4,n=(15&s)<<4|l>>2,r=(3&l)<<6|u,d[f++]=t,64!==l&&(d[f++]=n),64!==u&&(d[f++]=r);return d}},function(e,t){var n=e.exports={version:"2.3.0"};"number"==typeof __e&&(__e=n)},function(e,t,n){var r=n(69);e.exports=function(e,t,n){if(r(e),void 0===t)return e;switch(n){case 1:return function(n){return e.call(t,n)};case 2:return function(n,r){return e.call(t,n,r)};case 3:return function(n,r,i){return e.call(t,n,r,i)}}return function(){return e.apply(t,arguments)}}},function(e,t){e.exports=function(e){try{return!!e()}catch(e){return!0}}},function(e,t,n){var r=n(19),i=n(15).document,a=r(i)&&r(i.createElement);e.exports=function(e){return a?i.createElement(e):{}}},function(e,t,n){"use strict";(function(t){function r(e,t,n){switch(e){case"blob":return s.newBlob(s.transformTo("arraybuffer",t),n);case"base64":return c.encode(t);default:return s.transformTo(e,t)}}function i(e,n){var r,i=0,a=null,o=0;for(r=0;r<n.length;r++)o+=n[r].length;switch(e){case"string":return n.join("");case"array":return Array.prototype.concat.apply([],n);case"uint8array":for(a=new Uint8Array(o),r=0;r<n.length;r++)a.set(n[r],i),i+=n[r].length;return a;case"nodebuffer":return t.concat(n);default:throw new Error("concat : unsupported type '"+e+"'")}}function a(e,t){return new h.Promise(function(n,a){var o=[],s=e._internalType,l=e._outputType,u=e._mimeType;e.on("data",function(e,n){o.push(e),t&&t(n)}).on("error",function(e){o=[],a(e)}).on("end",function(){try{var e=r(l,i(s,o),u);n(e)}catch(e){a(e)}o=[]}).resume()})}function o(e,t,n){var r=t;switch(t){case"blob":case"arraybuffer":r="uint8array";break;case"base64":r="string"}try{this._internalType=r,this._outputType=t,this._mimeType=n,s.checkSupport(r),this._worker=e.pipe(new l(r)),e.lock()}catch(e){this._worker=new u("error"),this._worker.error(e)}}var s=n(0),l=n(82),u=n(1),c=n(29),f=n(3),h=n(9),d=null;if(f.nodestream)try{d=n(83)}catch(e){}o.prototype={accumulate:function(e){return a(this,e)},on:function(e,t){var n=this;return"data"===e?this._worker.on(e,function(e){t.call(n,e.data,e.meta)}):this._worker.on(e,function(){s.delay(t,arguments,n)}),this},resume:function(){return s.delay(this._worker.resume,[],this._worker),this},pause:function(){return this._worker.pause(),this},toNodejsStream:function(e){if(s.checkSupport("nodestream"),"nodebuffer"!==this._outputType)throw new Error(this._outputType+" is not supported by this method");return new d(this,{objectMode:"nodebuffer"!==this._outputType},e)}},e.exports=o}).call(t,n(2).Buffer)},function(e,t,n){"use strict";t.base64=!1,t.binary=!1,t.dir=!1,t.createFolders=!0,t.date=null,t.compression=null,t.compressionOptions=null,t.comment=null,t.unixPermissions=null,t.dosPermissions=null},function(e,t,n){"use strict";function r(e){a.call(this,"DataWorker");var t=this;this.dataIsReady=!1,this.index=0,this.max=0,this.data=null,this.type="",this._tickScheduled=!1,e.then(function(e){t.dataIsReady=!0,t.data=e,t.max=e&&e.length||0,t.type=i.getTypeOf(e),t.isPaused||t._tickAndRepeat()},function(e){t.error(e)})}var i=n(0),a=n(1);i.inherits(r,a),r.prototype.cleanUp=function(){a.prototype.cleanUp.call(this),this.data=null},r.prototype.resume=function(){return!!a.prototype.resume.call(this)&&(!this._tickScheduled&&this.dataIsReady&&(this._tickScheduled=!0,i.delay(this._tickAndRepeat,[],this)),!0)},r.prototype._tickAndRepeat=function(){this._tickScheduled=!1,this.isPaused||this.isFinished||(this._tick(),this.isFinished||(i.delay(this._tickAndRepeat,[],this),this._tickScheduled=!0))},r.prototype._tick=function(){if(this.isPaused||this.isFinished)return!1;var e=null,t=Math.min(this.max,this.index+16384);if(this.index>=this.max)return this.end();switch(this.type){case"string":e=this.data.substring(this.index,t);break;case"uint8array":e=this.data.subarray(this.index,t);break;case"array":case"nodebuffer":e=this.data.slice(this.index,t)}return this.index=t,this.push({data:e,meta:{percent:this.max?this.index/this.max*100:0}})},e.exports=r},function(e,t,n){"use strict";function r(e){a.call(this,"DataLengthProbe for "+e),this.propName=e,this.withStreamInfo(e,0)}var i=n(0),a=n(1);i.inherits(r,a),r.prototype.processChunk=function(e){if(e){var t=this.streamInfo[this.propName]||0;this.streamInfo[this.propName]=t+e.data.length}a.prototype.processChunk.call(this,e)},e.exports=r},function(e,t,n){"use strict";function r(){i.call(this,"Crc32Probe"),this.withStreamInfo("crc32",0)}var i=n(1),a=n(22);n(0).inherits(r,i),r.prototype.processChunk=function(e){this.streamInfo.crc32=a(e.data,this.streamInfo.crc32||0),this.push(e)},e.exports=r},function(e,t,n){"use strict";var r=n(1);t.STORE={magic:"\0\0",compressWorker:function(e){return new r("STORE compression")},uncompressWorker:function(){return new r("STORE decompression")}},t.DEFLATE=n(86)},function(e,t,n){"use strict";function r(e,t,n,r){for(var i=65535&e|0,a=e>>>16&65535|0,o=0;0!==n;){o=n>2e3?2e3:n,n-=o;do{i=i+t[r++]|0,a=a+i|0}while(--o);i%=65521,a%=65521}return i|a<<16|0}e.exports=r},function(e,t,n){"use strict";function r(e,t,n,r){var a=i,o=r+n;e^=-1;for(var s=r;s<o;s++)e=e>>>8^a[255&(e^t[s])];return-1^e}var i=function(){for(var e,t=[],n=0;n<256;n++){e=n;for(var r=0;r<8;r++)e=1&e?3988292384^e>>>1:e>>>1;t[n]=e}return t}();e.exports=r},function(e,t,n){"use strict";function r(e,t){if(t<65537&&(e.subarray&&o||!e.subarray&&a))return String.fromCharCode.apply(null,i.shrinkBuf(e,t));for(var n="",r=0;r<t;r++)n+=String.fromCharCode(e[r]);return n}var i=n(4),a=!0,o=!0;try{String.fromCharCode.apply(null,[0])}catch(e){a=!1}try{String.fromCharCode.apply(null,new Uint8Array(1))}catch(e){o=!1}for(var s=new i.Buf8(256),l=0;l<256;l++)s[l]=l>=252?6:l>=248?5:l>=240?4:l>=224?3:l>=192?2:1;s[254]=s[254]=1,t.string2buf=function(e){var t,n,r,a,o,s=e.length,l=0;for(a=0;a<s;a++)n=e.charCodeAt(a),55296==(64512&n)&&a+1<s&&56320==(64512&(r=e.charCodeAt(a+1)))&&(n=65536+(n-55296<<10)+(r-56320),a++),l+=n<128?1:n<2048?2:n<65536?3:4;for(t=new i.Buf8(l),o=0,a=0;o<l;a++)n=e.charCodeAt(a),55296==(64512&n)&&a+1<s&&56320==(64512&(r=e.charCodeAt(a+1)))&&(n=65536+(n-55296<<10)+(r-56320),a++),n<128?t[o++]=n:n<2048?(t[o++]=192|n>>>6,t[o++]=128|63&n):n<65536?(t[o++]=224|n>>>12,t[o++]=128|n>>>6&63,t[o++]=128|63&n):(t[o++]=240|n>>>18,t[o++]=128|n>>>12&63,t[o++]=128|n>>>6&63,t[o++]=128|63&n);return t},t.buf2binstring=function(e){return r(e,e.length)},t.binstring2buf=function(e){for(var t=new i.Buf8(e.length),n=0,r=t.length;n<r;n++)t[n]=e.charCodeAt(n);return t},t.buf2string=function(e,t){var n,i,a,o,l=t||e.length,u=new Array(2*l);for(i=0,n=0;n<l;)if((a=e[n++])<128)u[i++]=a;else if((o=s[a])>4)u[i++]=65533,n+=o-1;else{for(a&=2===o?31:3===o?15:7;o>1&&n<l;)a=a<<6|63&e[n++],o--;o>1?u[i++]=65533:a<65536?u[i++]=a:(a-=65536,u[i++]=55296|a>>10&1023,u[i++]=56320|1023&a)}return r(u,i)},t.utf8border=function(e,t){var n;for(t=t||e.length,t>e.length&&(t=e.length),n=t-1;n>=0&&128==(192&e[n]);)n--;return n<0?t:0===n?t:n+s[e[n]]>t?n:t}},function(e,t,n){"use strict";function r(){this.input=null,this.next_in=0,this.avail_in=0,this.total_in=0,this.output=null,this.next_out=0,this.avail_out=0,this.total_out=0,this.msg="",this.state=null,this.data_type=2,this.adler=0}e.exports=r},function(e,t,n){"use strict";e.exports={Z_NO_FLUSH:0,Z_PARTIAL_FLUSH:1,Z_SYNC_FLUSH:2,Z_FULL_FLUSH:3,Z_FINISH:4,Z_BLOCK:5,Z_TREES:6,Z_OK:0,Z_STREAM_END:1,Z_NEED_DICT:2,Z_ERRNO:-1,Z_STREAM_ERROR:-2,Z_DATA_ERROR:-3,Z_BUF_ERROR:-5,Z_NO_COMPRESSION:0,Z_BEST_SPEED:1,Z_BEST_COMPRESSION:9,Z_DEFAULT_COMPRESSION:-1,Z_FILTERED:1,Z_HUFFMAN_ONLY:2,Z_RLE:3,Z_FIXED:4,Z_DEFAULT_STRATEGY:0,Z_BINARY:0,Z_TEXT:1,Z_UNKNOWN:2,Z_DEFLATED:8}},function(e,t,n){"use strict";t.LOCAL_FILE_HEADER="PK",t.CENTRAL_FILE_HEADER="PK",t.CENTRAL_DIRECTORY_END="PK",t.ZIP64_CENTRAL_DIRECTORY_LOCATOR="PK",t.ZIP64_CENTRAL_DIRECTORY_END="PK",t.DATA_DESCRIPTOR="PK\b"},function(e,t,n){"use strict";var r=n(0),i=n(3),a=n(47),o=n(100),s=n(101),l=n(49);e.exports=function(e){var t=r.getTypeOf(e);return r.checkSupport(t),"string"!==t||i.uint8array?"nodebuffer"===t?new s(e):i.uint8array?new l(r.transformTo("uint8array",e)):new a(r.transformTo("array",e)):new o(e)}},function(e,t,n){"use strict";function r(e){i.call(this,e);for(var t=0;t<this.data.length;t++)e[t]=255&e[t]}var i=n(48);n(0).inherits(r,i),r.prototype.byteAt=function(e){return this.data[this.zero+e]},r.prototype.lastIndexOfSignature=function(e){for(var t=e.charCodeAt(0),n=e.charCodeAt(1),r=e.charCodeAt(2),i=e.charCodeAt(3),a=this.length-4;a>=0;--a)if(this.data[a]===t&&this.data[a+1]===n&&this.data[a+2]===r&&this.data[a+3]===i)return a-this.zero;return-1},r.prototype.readAndCheckSignature=function(e){var t=e.charCodeAt(0),n=e.charCodeAt(1),r=e.charCodeAt(2),i=e.charCodeAt(3),a=this.readData(4);return t===a[0]&&n===a[1]&&r===a[2]&&i===a[3]},r.prototype.readData=function(e){if(this.checkOffset(e),0===e)return[];var t=this.data.slice(this.zero+this.index,this.zero+this.index+e);return this.index+=e,t},e.exports=r},function(e,t,n){"use strict";function r(e){this.data=e,this.length=e.length,this.index=0,this.zero=0}var i=n(0);r.prototype={checkOffset:function(e){this.checkIndex(this.index+e)},checkIndex:function(e){if(this.length<this.zero+e||e<0)throw new Error("End of data reached (data length = "+this.length+", asked index = "+e+"). Corrupted zip ?")},setIndex:function(e){this.checkIndex(e),this.index=e},skip:function(e){this.setIndex(this.index+e)},byteAt:function(e){},readInt:function(e){var t,n=0;for(this.checkOffset(e),t=this.index+e-1;t>=this.index;t--)n=(n<<8)+this.byteAt(t);return this.index+=e,n},readString:function(e){return i.transformTo("string",this.readData(e))},readData:function(e){},lastIndexOfSignature:function(e){},readAndCheckSignature:function(e){},readDate:function(){var e=this.readInt(4);return new Date(Date.UTC(1980+(e>>25&127),(e>>21&15)-1,e>>16&31,e>>11&31,e>>5&63,(31&e)<<1))}},e.exports=r},function(e,t,n){"use strict";function r(e){i.call(this,e)}var i=n(47);n(0).inherits(r,i),r.prototype.readData=function(e){if(this.checkOffset(e),0===e)return new Uint8Array(0);var t=this.data.subarray(this.zero+this.index,this.zero+this.index+e);return this.index+=e,t},e.exports=r},function(e,t,n){"use strict";function r(e){return e&&e.__esModule?e:{default:e}}Object.defineProperty(t,"__esModule",{value:!0});var i=n(51),a=r(i),o=n(52),s=r(o),l=n(103),u=r(l);t.default=a.default.plugins.add("gjs-plugin-export",function(e,t){var n=t||{},r=e.getConfig(),i=r.stylePrefix,a=document.createElement("BUTTON"),o={addExportBtn:1,btnLabel:"Export to ZIP",preHtml:'<!doctype html><html lang="en"><head><meta charset="utf-8"><link rel="stylesheet" href="./css/style.css"></head><body>',postHtml:"</body><html>",preCss:"",postCss:""};for(var l in o)l in n||(n[l]=o[l]);a.innerHTML=n.btnLabel,a.className=i+"btn-prim",e.Commands.add("gjs-export-zip",{run:function(){var t=new s.default,r=t.folder("css"),i="grapesjs_template_"+Date.now()+".zip";t.file("index.html",n.preHtml+e.getHtml()+n.postHtml),r.file("style.css",n.preCss+e.getCss()+n.postCss),t.generateAsync({type:"blob"}).then(function(e){u.default.saveAs(e,i)})}}),n.addExportBtn&&e.on("run:export-template",function(){e.Modal.getContentEl().appendChild(a),a.onclick=function(){e.runCommand("gjs-export-zip")}})})},function(t,n){t.exports=e},function(e,t,n){"use strict";function r(){if(!(this instanceof r))return new r;if(arguments.length)throw new Error("The constructor with parameters has been removed in JSZip 3.0, please check the upgrade guide.");this.files={},this.comment=null,this.root="",this.clone=function(){var e=new r;for(var t in this)"function"!=typeof this[t]&&(e[t]=this[t]);return e}}r.prototype=n(53),r.prototype.loadAsync=n(98),r.support=n(3),r.defaults=n(35),r.version="3.1.5",r.loadAsync=function(e,t){return(new r).loadAsync(e,t)},r.external=n(9),e.exports=r},function(e,t,n){"use strict";function r(e){return"[object RegExp]"===Object.prototype.toString.call(e)}var i=n(6),a=n(0),o=n(1),s=n(34),l=n(35),u=n(21),c=n(84),f=n(85),h=n(14),d=n(97),p=function(e,t,n){var r,i=a.getTypeOf(t),s=a.extend(n||{},l);s.date=s.date||new Date,null!==s.compression&&(s.compression=s.compression.toUpperCase()),"string"==typeof s.unixPermissions&&(s.unixPermissions=parseInt(s.unixPermissions,8)),s.unixPermissions&&16384&s.unixPermissions&&(s.dir=!0),s.dosPermissions&&16&s.dosPermissions&&(s.dir=!0),s.dir&&(e=g(e)),s.createFolders&&(r=m(e))&&v.call(this,r,!0);var f="string"===i&&!1===s.binary&&!1===s.base64;n&&void 0!==n.binary||(s.binary=!f),(t instanceof u&&0===t.uncompressedSize||s.dir||!t||0===t.length)&&(s.base64=!1,s.binary=!0,t="",s.compression="STORE",i="string");var p=null;p=t instanceof u||t instanceof o?t:h.isNode&&h.isStream(t)?new d(e,t):a.prepareContent(e,t,s.binary,s.optimizedBinaryString,s.base64);var b=new c(e,p,s);this.files[e]=b},m=function(e){"/"===e.slice(-1)&&(e=e.substring(0,e.length-1));var t=e.lastIndexOf("/");return t>0?e.substring(0,t):""},g=function(e){return"/"!==e.slice(-1)&&(e+="/"),e},v=function(e,t){return t=void 0!==t?t:l.createFolders,e=g(e),this.files[e]||p.call(this,e,null,{dir:!0,createFolders:t}),this.files[e]},b={load:function(){throw new Error("This method has been removed in JSZip 3.0, please check the upgrade guide.")},forEach:function(e){var t,n,r;for(t in this.files)this.files.hasOwnProperty(t)&&(r=this.files[t],(n=t.slice(this.root.length,t.length))&&t.slice(0,this.root.length)===this.root&&e(n,r))},filter:function(e){var t=[];return this.forEach(function(n,r){e(n,r)&&t.push(r)}),t},file:function(e,t,n){if(1===arguments.length){if(r(e)){var i=e;return this.filter(function(e,t){return!t.dir&&i.test(e)})}var a=this.files[this.root+e];return a&&!a.dir?a:null}return e=this.root+e,p.call(this,e,t,n),this},folder:function(e){if(!e)return this;if(r(e))return this.filter(function(t,n){return n.dir&&e.test(t)});var t=this.root+e,n=v.call(this,t),i=this.clone();return i.root=n.name,i},remove:function(e){e=this.root+e;var t=this.files[e];if(t||("/"!==e.slice(-1)&&(e+="/"),t=this.files[e]),t&&!t.dir)delete this.files[e];else for(var n=this.filter(function(t,n){return n.name.slice(0,e.length)===e}),r=0;r<n.length;r++)delete this.files[n[r].name];return this},generate:function(e){throw new Error("This method has been removed in JSZip 3.0, please check the upgrade guide.")},generateInternalStream:function(e){var t,n={};try{if(n=a.extend(e||{},{streamFiles:!1,compression:"STORE",compressionOptions:null,type:"",platform:"DOS",comment:null,mimeType:"application/zip",encodeFileName:i.utf8encode}),n.type=n.type.toLowerCase(),n.compression=n.compression.toUpperCase(),"binarystring"===n.type&&(n.type="string"),!n.type)throw new Error("No output type specified.");a.checkSupport(n.type),"darwin"!==n.platform&&"freebsd"!==n.platform&&"linux"!==n.platform&&"sunos"!==n.platform||(n.platform="UNIX"),"win32"===n.platform&&(n.platform="DOS");var r=n.comment||this.comment||"";t=f.generateWorker(this,n,r)}catch(e){t=new o("error"),t.error(e)}return new s(t,n.type||"string",n.mimeType)},generateAsync:function(e,t){return this.generateInternalStream(e).accumulate(t)},generateNodeStream:function(e,t){return e=e||{},e.type||(e.type="nodebuffer"),this.generateInternalStream(e).toNodejsStream(t)}};e.exports=b},function(e,t,n){"use strict";function r(e){var t=e.length;if(t%4>0)throw new Error("Invalid string. Length must be a multiple of 4");return"="===e[t-2]?2:"="===e[t-1]?1:0}function i(e){return 3*e.length/4-r(e)}function a(e){var t,n,i,a,o,s=e.length;a=r(e),o=new f(3*s/4-a),n=a>0?s-4:s;var l=0;for(t=0;t<n;t+=4)i=c[e.charCodeAt(t)]<<18|c[e.charCodeAt(t+1)]<<12|c[e.charCodeAt(t+2)]<<6|c[e.charCodeAt(t+3)],o[l++]=i>>16&255,o[l++]=i>>8&255,o[l++]=255&i;return 2===a?(i=c[e.charCodeAt(t)]<<2|c[e.charCodeAt(t+1)]>>4,o[l++]=255&i):1===a&&(i=c[e.charCodeAt(t)]<<10|c[e.charCodeAt(t+1)]<<4|c[e.charCodeAt(t+2)]>>2,o[l++]=i>>8&255,o[l++]=255&i),o}function o(e){return u[e>>18&63]+u[e>>12&63]+u[e>>6&63]+u[63&e]}function s(e,t,n){for(var r,i=[],a=t;a<n;a+=3)r=(e[a]<<16)+(e[a+1]<<8)+e[a+2],i.push(o(r));return i.join("")}function l(e){for(var t,n=e.length,r=n%3,i="",a=[],o=0,l=n-r;o<l;o+=16383)a.push(s(e,o,o+16383>l?l:o+16383));return 1===r?(t=e[n-1],i+=u[t>>2],i+=u[t<<4&63],i+="=="):2===r&&(t=(e[n-2]<<8)+e[n-1],i+=u[t>>10],i+=u[t>>4&63],i+=u[t<<2&63],i+="="),a.push(i),a.join("")}t.byteLength=i,t.toByteArray=a,t.fromByteArray=l;for(var u=[],c=[],f="undefined"!=typeof Uint8Array?Uint8Array:Array,h="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/",d=0,p=h.length;d<p;++d)u[d]=h[d],c[h.charCodeAt(d)]=d;c["-".charCodeAt(0)]=62,c["_".charCodeAt(0)]=63},function(e,t){t.read=function(e,t,n,r,i){var a,o,s=8*i-r-1,l=(1<<s)-1,u=l>>1,c=-7,f=n?i-1:0,h=n?-1:1,d=e[t+f];for(f+=h,a=d&(1<<-c)-1,d>>=-c,c+=s;c>0;a=256*a+e[t+f],f+=h,c-=8);for(o=a&(1<<-c)-1,a>>=-c,c+=r;c>0;o=256*o+e[t+f],f+=h,c-=8);if(0===a)a=1-u;else{if(a===l)return o?NaN:1/0*(d?-1:1);o+=Math.pow(2,r),a-=u}return(d?-1:1)*o*Math.pow(2,a-r)},t.write=function(e,t,n,r,i,a){var o,s,l,u=8*a-i-1,c=(1<<u)-1,f=c>>1,h=23===i?Math.pow(2,-24)-Math.pow(2,-77):0,d=r?0:a-1,p=r?1:-1,m=t<0||0===t&&1/t<0?1:0;for(t=Math.abs(t),isNaN(t)||t===1/0?(s=isNaN(t)?1:0,o=c):(o=Math.floor(Math.log(t)/Math.LN2),t*(l=Math.pow(2,-o))<1&&(o--,l*=2),t+=o+f>=1?h/l:h*Math.pow(2,1-f),t*l>=2&&(o++,l/=2),o+f>=c?(s=0,o=c):o+f>=1?(s=(t*l-1)*Math.pow(2,i),o+=f):(s=t*Math.pow(2,f-1)*Math.pow(2,i),o=0));i>=8;e[n+d]=255&s,d+=p,s/=256,i-=8);for(o=o<<i|s,u+=i;u>0;e[n+d]=255&o,d+=p,o/=256,u-=8);e[n+d-p]|=128*m}},function(e,t,n){var r=function(){try{return n(11)}catch(e){}}();t=e.exports=n(26),t.Stream=r||t,t.Readable=t,t.Writable=n(17),t.Duplex=n(5),t.Transform=n(18),t.PassThrough=n(28)},function(e,t){},function(e,n,i){function a(e,t){this._id=e,this._clearFn=t}var o=Function.prototype.apply;n.setTimeout=function(){return new a(o.call(setTimeout,window,arguments),clearTimeout)},n.setInterval=function(){return new a(o.call(setInterval,window,arguments),clearInterval)},n.clearTimeout=n.clearInterval=function(e){e&&e.close()},a.prototype.unref=a.prototype.ref=function(){},a.prototype.close=function(){this._clearFn.call(window,this._id)},n.enroll=function(e,t){clearTimeout(e._idleTimeoutId),e._idleTimeout=t},n.unenroll=function(e){clearTimeout(e._idleTimeoutId),e._idleTimeout=-1},n._unrefActive=n.active=function(e){clearTimeout(e._idleTimeoutId);var t=e._idleTimeout;t>=0&&(e._idleTimeoutId=setTimeout(function(){e._onTimeout&&e._onTimeout()},t))},i(59),n.setImmediate=t,n.clearImmediate=r},function(e,t,n){(function(e,t){!function(e,n){"use strict";function r(e){"function"!=typeof e&&(e=new Function(""+e));for(var t=new Array(arguments.length-1),n=0;n<t.length;n++)t[n]=arguments[n+1];var r={callback:e,args:t};return u[l]=r,s(l),l++}function i(e){delete u[e]}function a(e){var t=e.callback,r=e.args;switch(r.length){case 0:t();break;case 1:t(r[0]);break;case 2:t(r[0],r[1]);break;case 3:t(r[0],r[1],r[2]);break;default:t.apply(n,r)}}function o(e){if(c)setTimeout(o,0,e);else{var t=u[e];if(t){c=!0;try{a(t)}finally{i(e),c=!1}}}}if(!e.setImmediate){var s,l=1,u={},c=!1,f=e.document,h=Object.getPrototypeOf&&Object.getPrototypeOf(e);h=h&&h.setTimeout?h:e,"[object process]"==={}.toString.call(e.process)?function(){s=function(e){t.nextTick(function(){o(e)})}}():function(){if(e.postMessage&&!e.importScripts){var t=!0,n=e.onmessage;return e.onmessage=function(){t=!1},e.postMessage("","*"),e.onmessage=n,t}}()?function(){var t="setImmediate$"+Math.random()+"$",n=function(n){n.source===e&&"string"==typeof n.data&&0===n.data.indexOf(t)&&o(+n.data.slice(t.length))};e.addEventListener?e.addEventListener("message",n,!1):e.attachEvent("onmessage",n),s=function(n){e.postMessage(t+n,"*")}}():e.MessageChannel?function(){var e=new MessageChannel;e.port1.onmessage=function(e){o(e.data)},s=function(t){e.port2.postMessage(t)}}():f&&"onreadystatechange"in f.createElement("script")?function(){var e=f.documentElement;s=function(t){var n=f.createElement("script");n.onreadystatechange=function(){o(t),n.onreadystatechange=null,e.removeChild(n),n=null},e.appendChild(n)}}():function(){s=function(e){setTimeout(o,0,e)}}(),h.setImmediate=r,h.clearImmediate=i}}("undefined"==typeof self?void 0===e?this:e:self)}).call(t,n(10),n(13))},function(e,t,n){(function(t){function n(e,t){function n(){if(!i){if(r("throwDeprecation"))throw new Error(t);r("traceDeprecation")?console.trace(t):console.warn(t),i=!0}return e.apply(this,arguments)}if(r("noDeprecation"))return e;var i=!1;return n}function r(e){try{if(!t.localStorage)return!1}catch(e){return!1}var n=t.localStorage[e];return null!=n&&"true"===String(n).toLowerCase()}e.exports=n}).call(t,n(10))},function(e,t,n){function r(e,t){for(var n in e)t[n]=e[n]}function i(e,t,n){return o(e,t,n)}var a=n(2),o=a.Buffer;o.from&&o.alloc&&o.allocUnsafe&&o.allocUnsafeSlow?e.exports=a:(r(a,t),t.Buffer=i),r(o,i),i.from=function(e,t,n){if("number"==typeof e)throw new TypeError("Argument must not be a number");return o(e,t,n)},i.alloc=function(e,t,n){if("number"!=typeof e)throw new TypeError("Argument must be a number");var r=o(e);return void 0!==t?"string"==typeof n?r.fill(t,n):r.fill(t):r.fill(0),r},i.allocUnsafe=function(e){if("number"!=typeof e)throw new TypeError("Argument must be a number");return o(e)},i.allocUnsafeSlow=function(e){if("number"!=typeof e)throw new TypeError("Argument must be a number");return a.SlowBuffer(e)}},function(e,t,n){e.exports=n(17)},function(e,t,n){e.exports=n(5)},function(e,t,n){e.exports=n(18)},function(e,t,n){e.exports=n(28)},function(e,t,n){n(67),e.exports=n(30).setImmediate},function(e,t,n){var r=n(68),i=n(76);r(r.G+r.B,{setImmediate:i.set,clearImmediate:i.clear})},function(e,t,n){var r=n(15),i=n(30),a=n(31),o=n(70),s=function(e,t,n){var l,u,c,f=e&s.F,h=e&s.G,d=e&s.S,p=e&s.P,m=e&s.B,g=e&s.W,v=h?i:i[t]||(i[t]={}),b=v.prototype,y=h?r:d?r[t]:(r[t]||{}).prototype;h&&(n=t);for(l in n)(u=!f&&y&&void 0!==y[l])&&l in v||(c=u?y[l]:n[l],v[l]=h&&"function"!=typeof y[l]?n[l]:m&&u?a(c,r):g&&y[l]==c?function(e){var t=function(t,n,r){if(this instanceof e){switch(arguments.length){case 0:return new e;case 1:return new e(t);case 2:return new e(t,n)}return new e(t,n,r)}return e.apply(this,arguments)};return t.prototype=e.prototype,t}(c):p&&"function"==typeof c?a(Function.call,c):c,p&&((v.virtual||(v.virtual={}))[l]=c,e&s.R&&b&&!b[l]&&o(b,l,c)))};s.F=1,s.G=2,s.S=4,s.P=8,s.B=16,s.W=32,s.U=64,s.R=128,e.exports=s},function(e,t){e.exports=function(e){if("function"!=typeof e)throw TypeError(e+" is not a function!");return e}},function(e,t,n){var r=n(71),i=n(75);e.exports=n(20)?function(e,t,n){return r.f(e,t,i(1,n))}:function(e,t,n){return e[t]=n,e}},function(e,t,n){var r=n(72),i=n(73),a=n(74),o=Object.defineProperty;t.f=n(20)?Object.defineProperty:function(e,t,n){if(r(e),t=a(t,!0),r(n),i)try{return o(e,t,n)}catch(e){}if("get"in n||"set"in n)throw TypeError("Accessors not supported!");return"value"in n&&(e[t]=n.value),e}},function(e,t,n){var r=n(19);e.exports=function(e){if(!r(e))throw TypeError(e+" is not an object!");return e}},function(e,t,n){e.exports=!n(20)&&!n(32)(function(){return 7!=Object.defineProperty(n(33)("div"),"a",{get:function(){return 7}}).a})},function(e,t,n){var r=n(19);e.exports=function(e,t){if(!r(e))return e;var n,i;if(t&&"function"==typeof(n=e.toString)&&!r(i=n.call(e)))return i;if("function"==typeof(n=e.valueOf)&&!r(i=n.call(e)))return i;if(!t&&"function"==typeof(n=e.toString)&&!r(i=n.call(e)))return i;throw TypeError("Can't convert object to primitive value")}},function(e,t){e.exports=function(e,t){return{enumerable:!(1&e),configurable:!(2&e),writable:!(4&e),value:t}}},function(e,t,n){var r,i,a,o=n(31),s=n(77),l=n(78),u=n(33),c=n(15),f=c.process,h=c.setImmediate,d=c.clearImmediate,p=c.MessageChannel,m=0,g={},v=function(){var e=+this;if(g.hasOwnProperty(e)){var t=g[e];delete g[e],t()}},b=function(e){v.call(e.data)};h&&d||(h=function(e){for(var t=[],n=1;arguments.length>n;)t.push(arguments[n++]);return g[++m]=function(){s("function"==typeof e?e:Function(e),t)},r(m),m},d=function(e){delete g[e]},"process"==n(79)(f)?r=function(e){f.nextTick(o(v,e,1))}:p?(i=new p,a=i.port2,i.port1.onmessage=b,r=o(a.postMessage,a,1)):c.addEventListener&&"function"==typeof postMessage&&!c.importScripts?(r=function(e){c.postMessage(e+"","*")},c.addEventListener("message",b,!1)):r="onreadystatechange"in u("script")?function(e){l.appendChild(u("script")).onreadystatechange=function(){l.removeChild(this),v.call(e)}}:function(e){setTimeout(o(v,e,1),0)}),e.exports={set:h,clear:d}},function(e,t){e.exports=function(e,t,n){var r=void 0===n;switch(t.length){case 0:return r?e():e.call(n);case 1:return r?e(t[0]):e.call(n,t[0]);case 2:return r?e(t[0],t[1]):e.call(n,t[0],t[1]);case 3:return r?e(t[0],t[1],t[2]):e.call(n,t[0],t[1],t[2]);case 4:return r?e(t[0],t[1],t[2],t[3]):e.call(n,t[0],t[1],t[2],t[3])}return e.apply(n,t)}},function(e,t,n){e.exports=n(15).document&&document.documentElement},function(e,t){var n={}.toString;e.exports=function(e){return n.call(e).slice(8,-1)}},function(e,t,n){"use strict";function r(){}function i(e){if("function"!=typeof e)throw new TypeError("resolver must be a function");this.state=b,this.queue=[],this.outcome=void 0,e!==r&&l(this,e)}function a(e,t,n){this.promise=e,"function"==typeof t&&(this.onFulfilled=t,this.callFulfilled=this.otherCallFulfilled),"function"==typeof n&&(this.onRejected=n,this.callRejected=this.otherCallRejected)}function o(e,t,n){p(function(){var r;try{r=t(n)}catch(t){return m.reject(e,t)}r===e?m.reject(e,new TypeError("Cannot resolve promise with itself")):m.resolve(e,r)})}function s(e){var t=e&&e.then;if(e&&("object"==typeof e||"function"==typeof e)&&"function"==typeof t)return function(){t.apply(e,arguments)}}function l(e,t){function n(t){a||(a=!0,m.reject(e,t))}function r(t){a||(a=!0,m.resolve(e,t))}function i(){t(r,n)}var a=!1,o=u(i);"error"===o.status&&n(o.value)}function u(e,t){var n={};try{n.value=e(t),n.status="success"}catch(e){n.status="error",n.value=e}return n}function c(e){return e instanceof this?e:m.resolve(new this(r),e)}function f(e){var t=new this(r);return m.reject(t,e)}function h(e){var t=this;if("[object Array]"!==Object.prototype.toString.call(e))return this.reject(new TypeError("must be an array"));var n=e.length,i=!1;if(!n)return this.resolve([]);for(var a=new Array(n),o=0,s=-1,l=new this(r);++s<n;)!function(e,r){function s(e){a[r]=e,++o!==n||i||(i=!0,m.resolve(l,a))}t.resolve(e).then(s,function(e){i||(i=!0,m.reject(l,e))})}(e[s],s);return l}function d(e){var t=this;if("[object Array]"!==Object.prototype.toString.call(e))return this.reject(new TypeError("must be an array"));var n=e.length,i=!1;if(!n)return this.resolve([]);for(var a=-1,o=new this(r);++a<n;)!function(e){t.resolve(e).then(function(e){i||(i=!0,m.resolve(o,e))},function(e){i||(i=!0,m.reject(o,e))})}(e[a]);return o}var p=n(81),m={},g=["REJECTED"],v=["FULFILLED"],b=["PENDING"];e.exports=i,i.prototype.catch=function(e){return this.then(null,e)},i.prototype.then=function(e,t){if("function"!=typeof e&&this.state===v||"function"!=typeof t&&this.state===g)return this;var n=new this.constructor(r);return this.state!==b?o(n,this.state===v?e:t,this.outcome):this.queue.push(new a(n,e,t)),n},a.prototype.callFulfilled=function(e){m.resolve(this.promise,e)},a.prototype.otherCallFulfilled=function(e){o(this.promise,this.onFulfilled,e)},a.prototype.callRejected=function(e){m.reject(this.promise,e)},a.prototype.otherCallRejected=function(e){o(this.promise,this.onRejected,e)},m.resolve=function(e,t){var n=u(s,t);if("error"===n.status)return m.reject(e,n.value);var r=n.value;if(r)l(e,r);else{e.state=v,e.outcome=t;for(var i=-1,a=e.queue.length;++i<a;)e.queue[i].callFulfilled(t)}return e},m.reject=function(e,t){e.state=g,e.outcome=t;for(var n=-1,r=e.queue.length;++n<r;)e.queue[n].callRejected(t);return e},i.resolve=c,i.reject=f,i.all=h,i.race=d},function(e,t,n){"use strict";(function(t){function n(){c=!0;for(var e,t,n=f.length;n;){for(t=f,f=[],e=-1;++e<n;)t[e]();n=f.length}c=!1}function r(e){1!==f.push(e)||c||i()}var i,a=t.MutationObserver||t.WebKitMutationObserver;if(a){var o=0,s=new a(n),l=t.document.createTextNode("");s.observe(l,{characterData:!0}),i=function(){l.data=o=++o%2}}else if(t.setImmediate||void 0===t.MessageChannel)i="document"in t&&"onreadystatechange"in t.document.createElement("script")?function(){var e=t.document.createElement("script");e.onreadystatechange=function(){n(),e.onreadystatechange=null,e.parentNode.removeChild(e),e=null},t.document.documentElement.appendChild(e)}:function(){setTimeout(n,0)};else{var u=new t.MessageChannel;u.port1.onmessage=n,i=function(){u.port2.postMessage(0)}}var c,f=[];e.exports=r}).call(t,n(10))},function(e,t,n){"use strict";function r(e){i.call(this,"ConvertWorker to "+e),this.destType=e}var i=n(1),a=n(0);a.inherits(r,i),r.prototype.processChunk=function(e){this.push({data:a.transformTo(this.destType,e.data),meta:e.meta})},e.exports=r},function(e,t,n){"use strict";function r(e,t,n){i.call(this,t),this._helper=e;var r=this;e.on("data",function(e,t){r.push(e)||r._helper.pause(),n&&n(t)}).on("error",function(e){r.emit("error",e)}).on("end",function(){r.push(null)})}var i=n(25).Readable;n(0).inherits(r,i),r.prototype._read=function(){this._helper.resume()},e.exports=r},function(e,t,n){"use strict";var r=n(34),i=n(36),a=n(6),o=n(21),s=n(1),l=function(e,t,n){this.name=e,this.dir=n.dir,this.date=n.date,this.comment=n.comment,this.unixPermissions=n.unixPermissions,this.dosPermissions=n.dosPermissions,this._data=t,this._dataBinary=n.binary,this.options={compression:n.compression,compressionOptions:n.compressionOptions}};l.prototype={internalStream:function(e){var t=null,n="string";try{if(!e)throw new Error("No output type specified.");n=e.toLowerCase();var i="string"===n||"text"===n;"binarystring"!==n&&"text"!==n||(n="string"),t=this._decompressWorker();var o=!this._dataBinary;o&&!i&&(t=t.pipe(new a.Utf8EncodeWorker)),!o&&i&&(t=t.pipe(new a.Utf8DecodeWorker))}catch(e){t=new s("error"),t.error(e)}return new r(t,n,"")},async:function(e,t){return this.internalStream(e).accumulate(t)},nodeStream:function(e,t){return this.internalStream(e||"nodebuffer").toNodejsStream(t)},_compressWorker:function(e,t){if(this._data instanceof o&&this._data.compression.magic===e.magic)return this._data.getCompressedWorker();var n=this._decompressWorker();return this._dataBinary||(n=n.pipe(new a.Utf8EncodeWorker)),o.createWorkerFrom(n,e,t)},_decompressWorker:function(){return this._data instanceof o?this._data.getContentWorker():this._data instanceof s?this._data:new i(this._data)}};for(var u=["asText","asBinary","asNodeBuffer","asUint8Array","asArrayBuffer"],c=function(){throw new Error("This method has been removed in JSZip 3.0, please check the upgrade guide.")},f=0;f<u.length;f++)l.prototype[u[f]]=c;e.exports=l},function(e,t,n){"use strict";var r=n(39),i=n(96),a=function(e,t){var n=e||t,i=r[n];if(!i)throw new Error(n+" is not a valid compression method !");return i};t.generateWorker=function(e,t,n){var r=new i(t.streamFiles,n,t.platform,t.encodeFileName),o=0;try{e.forEach(function(e,n){o++;var i=a(n.options.compression,t.compression),s=n.options.compressionOptions||t.compressionOptions||{},l=n.dir,u=n.date;n._compressWorker(i,s).withStreamInfo("file",{name:e,dir:l,date:u,comment:n.comment||"",unixPermissions:n.unixPermissions,dosPermissions:n.dosPermissions}).pipe(r)}),r.entriesCount=o}catch(e){r.error(e)}return r}},function(e,t,n){"use strict";function r(e,t){s.call(this,"FlateWorker/"+e),this._pako=null,this._pakoAction=e,this._pakoOptions=t,this.meta={}}var i="undefined"!=typeof Uint8Array&&"undefined"!=typeof Uint16Array&&"undefined"!=typeof Uint32Array,a=n(87),o=n(0),s=n(1),l=i?"uint8array":"array";t.magic="\b\0",o.inherits(r,s),r.prototype.processChunk=function(e){this.meta=e.meta,null===this._pako&&this._createPako(),this._pako.push(o.transformTo(l,e.data),!1)},r.prototype.flush=function(){s.prototype.flush.call(this),null===this._pako&&this._createPako(),this._pako.push([],!0)},r.prototype.cleanUp=function(){s.prototype.cleanUp.call(this),this._pako=null},r.prototype._createPako=function(){this._pako=new a[this._pakoAction]({raw:!0,level:this._pakoOptions.level||-1});var e=this;this._pako.onData=function(t){e.push({data:t,meta:e.meta})}},t.compressWorker=function(e){return new r("Deflate",e)},t.uncompressWorker=function(){return new r("Inflate",{})}},function(e,t,n){"use strict";var r=n(4).assign,i=n(88),a=n(91),o=n(44),s={};r(s,i,a,o),e.exports=s},function(e,t,n){"use strict";function r(e){if(!(this instanceof r))return new r(e);this.options=l.assign({level:p,method:g,chunkSize:16384,windowBits:15,memLevel:8,strategy:m,to:""},e||{});var t=this.options;t.raw&&t.windowBits>0?t.windowBits=-t.windowBits:t.gzip&&t.windowBits>0&&t.windowBits<16&&(t.windowBits+=16),this.err=0,this.msg="",this.ended=!1,this.chunks=[],this.strm=new f,this.strm.avail_out=0;var n=s.deflateInit2(this.strm,t.level,t.method,t.windowBits,t.memLevel,t.strategy);if(n!==d)throw new Error(c[n]);if(t.header&&s.deflateSetHeader(this.strm,t.header),t.dictionary){var i;if(i="string"==typeof t.dictionary?u.string2buf(t.dictionary):"[object ArrayBuffer]"===h.call(t.dictionary)?new Uint8Array(t.dictionary):t.dictionary,(n=s.deflateSetDictionary(this.strm,i))!==d)throw new Error(c[n]);this._dict_set=!0}}function i(e,t){var n=new r(t);if(n.push(e,!0),n.err)throw n.msg||c[n.err];return n.result}function a(e,t){return t=t||{},t.raw=!0,i(e,t)}function o(e,t){return t=t||{},t.gzip=!0,i(e,t)}var s=n(89),l=n(4),u=n(42),c=n(23),f=n(43),h=Object.prototype.toString,d=0,p=-1,m=0,g=8;r.prototype.push=function(e,t){var n,r,i=this.strm,a=this.options.chunkSize;if(this.ended)return!1;r=t===~~t?t:!0===t?4:0,"string"==typeof e?i.input=u.string2buf(e):"[object ArrayBuffer]"===h.call(e)?i.input=new Uint8Array(e):i.input=e,i.next_in=0,i.avail_in=i.input.length;do{if(0===i.avail_out&&(i.output=new l.Buf8(a),i.next_out=0,i.avail_out=a),1!==(n=s.deflate(i,r))&&n!==d)return this.onEnd(n),this.ended=!0,!1;0!==i.avail_out&&(0!==i.avail_in||4!==r&&2!==r)||("string"===this.options.to?this.onData(u.buf2binstring(l.shrinkBuf(i.output,i.next_out))):this.onData(l.shrinkBuf(i.output,i.next_out)))}while((i.avail_in>0||0===i.avail_out)&&1!==n);return 4===r?(n=s.deflateEnd(this.strm),this.onEnd(n),this.ended=!0,n===d):2!==r||(this.onEnd(d),i.avail_out=0,!0)},r.prototype.onData=function(e){this.chunks.push(e)},r.prototype.onEnd=function(e){e===d&&("string"===this.options.to?this.result=this.chunks.join(""):this.result=l.flattenChunks(this.chunks)),this.chunks=[],this.err=e,this.msg=this.strm.msg},t.Deflate=r,t.deflate=i,t.deflateRaw=a,t.gzip=o},function(e,t,n){"use strict";function r(e,t){return e.msg=B[t],t}function i(e){return(e<<1)-(e>4?9:0)}function a(e){for(var t=e.length;--t>=0;)e[t]=0}function o(e){var t=e.state,n=t.pending;n>e.avail_out&&(n=e.avail_out),0!==n&&(I.arraySet(e.output,t.pending_buf,t.pending_out,n,e.next_out),e.next_out+=n,t.pending_out+=n,e.total_out+=n,e.avail_out-=n,t.pending-=n,0===t.pending&&(t.pending_out=0))}function s(e,t){R._tr_flush_block(e,e.block_start>=0?e.block_start:-1,e.strstart-e.block_start,t),e.block_start=e.strstart,o(e.strm)}function l(e,t){e.pending_buf[e.pending++]=t}function u(e,t){e.pending_buf[e.pending++]=t>>>8&255,e.pending_buf[e.pending++]=255&t}function c(e,t,n,r){var i=e.avail_in;return i>r&&(i=r),0===i?0:(e.avail_in-=i,I.arraySet(t,e.input,e.next_in,i,n),1===e.state.wrap?e.adler=L(e.adler,t,i,n):2===e.state.wrap&&(e.adler=j(e.adler,t,i,n)),e.next_in+=i,e.total_in+=i,i)}function f(e,t){var n,r,i=e.max_chain_length,a=e.strstart,o=e.prev_length,s=e.nice_match,l=e.strstart>e.w_size-ue?e.strstart-(e.w_size-ue):0,u=e.window,c=e.w_mask,f=e.prev,h=e.strstart+le,d=u[a+o-1],p=u[a+o];e.prev_length>=e.good_match&&(i>>=2),s>e.lookahead&&(s=e.lookahead);do{if(n=t,u[n+o]===p&&u[n+o-1]===d&&u[n]===u[a]&&u[++n]===u[a+1]){a+=2,n++;do{}while(u[++a]===u[++n]&&u[++a]===u[++n]&&u[++a]===u[++n]&&u[++a]===u[++n]&&u[++a]===u[++n]&&u[++a]===u[++n]&&u[++a]===u[++n]&&u[++a]===u[++n]&&a<h);if(r=le-(h-a),a=h-le,r>o){if(e.match_start=t,o=r,r>=s)break;d=u[a+o-1],p=u[a+o]}}}while((t=f[t&c])>l&&0!=--i);return o<=e.lookahead?o:e.lookahead}function h(e){var t,n,r,i,a,o=e.w_size;do{if(i=e.window_size-e.lookahead-e.strstart,e.strstart>=o+(o-ue)){I.arraySet(e.window,e.window,o,o,0),e.match_start-=o,e.strstart-=o,e.block_start-=o,n=e.hash_size,t=n;do{r=e.head[--t],e.head[t]=r>=o?r-o:0}while(--n);n=o,t=n;do{r=e.prev[--t],e.prev[t]=r>=o?r-o:0}while(--n);i+=o}if(0===e.strm.avail_in)break;if(n=c(e.strm,e.window,e.strstart+e.lookahead,i),e.lookahead+=n,e.lookahead+e.insert>=se)for(a=e.strstart-e.insert,e.ins_h=e.window[a],e.ins_h=(e.ins_h<<e.hash_shift^e.window[a+1])&e.hash_mask;e.insert&&(e.ins_h=(e.ins_h<<e.hash_shift^e.window[a+se-1])&e.hash_mask,e.prev[a&e.w_mask]=e.head[e.ins_h],e.head[e.ins_h]=a,a++,e.insert--,!(e.lookahead+e.insert<se)););}while(e.lookahead<ue&&0!==e.strm.avail_in)}function d(e,t){var n=65535;for(n>e.pending_buf_size-5&&(n=e.pending_buf_size-5);;){if(e.lookahead<=1){if(h(e),0===e.lookahead&&t===M)return be;if(0===e.lookahead)break}e.strstart+=e.lookahead,e.lookahead=0;var r=e.block_start+n;if((0===e.strstart||e.strstart>=r)&&(e.lookahead=e.strstart-r,e.strstart=r,s(e,!1),0===e.strm.avail_out))return be;if(e.strstart-e.block_start>=e.w_size-ue&&(s(e,!1),0===e.strm.avail_out))return be}return e.insert=0,t===z?(s(e,!0),0===e.strm.avail_out?we:_e):(e.strstart>e.block_start&&(s(e,!1),e.strm.avail_out),be)}function p(e,t){for(var n,r;;){if(e.lookahead<ue){if(h(e),e.lookahead<ue&&t===M)return be;if(0===e.lookahead)break}if(n=0,e.lookahead>=se&&(e.ins_h=(e.ins_h<<e.hash_shift^e.window[e.strstart+se-1])&e.hash_mask,n=e.prev[e.strstart&e.w_mask]=e.head[e.ins_h],e.head[e.ins_h]=e.strstart),0!==n&&e.strstart-n<=e.w_size-ue&&(e.match_length=f(e,n)),e.match_length>=se)if(r=R._tr_tally(e,e.strstart-e.match_start,e.match_length-se),e.lookahead-=e.match_length,e.match_length<=e.max_lazy_match&&e.lookahead>=se){e.match_length--;do{e.strstart++,e.ins_h=(e.ins_h<<e.hash_shift^e.window[e.strstart+se-1])&e.hash_mask,n=e.prev[e.strstart&e.w_mask]=e.head[e.ins_h],e.head[e.ins_h]=e.strstart}while(0!=--e.match_length);e.strstart++}else e.strstart+=e.match_length,e.match_length=0,e.ins_h=e.window[e.strstart],e.ins_h=(e.ins_h<<e.hash_shift^e.window[e.strstart+1])&e.hash_mask;else r=R._tr_tally(e,0,e.window[e.strstart]),e.lookahead--,e.strstart++;if(r&&(s(e,!1),0===e.strm.avail_out))return be}return e.insert=e.strstart<se-1?e.strstart:se-1,t===z?(s(e,!0),0===e.strm.avail_out?we:_e):e.last_lit&&(s(e,!1),0===e.strm.avail_out)?be:ye}function m(e,t){for(var n,r,i;;){if(e.lookahead<ue){if(h(e),e.lookahead<ue&&t===M)return be;if(0===e.lookahead)break}if(n=0,e.lookahead>=se&&(e.ins_h=(e.ins_h<<e.hash_shift^e.window[e.strstart+se-1])&e.hash_mask,n=e.prev[e.strstart&e.w_mask]=e.head[e.ins_h],e.head[e.ins_h]=e.strstart),e.prev_length=e.match_length,e.prev_match=e.match_start,e.match_length=se-1,0!==n&&e.prev_length<e.max_lazy_match&&e.strstart-n<=e.w_size-ue&&(e.match_length=f(e,n),e.match_length<=5&&(e.strategy===H||e.match_length===se&&e.strstart-e.match_start>4096)&&(e.match_length=se-1)),e.prev_length>=se&&e.match_length<=e.prev_length){i=e.strstart+e.lookahead-se,r=R._tr_tally(e,e.strstart-1-e.prev_match,e.prev_length-se),e.lookahead-=e.prev_length-1,e.prev_length-=2;do{++e.strstart<=i&&(e.ins_h=(e.ins_h<<e.hash_shift^e.window[e.strstart+se-1])&e.hash_mask,n=e.prev[e.strstart&e.w_mask]=e.head[e.ins_h],e.head[e.ins_h]=e.strstart)}while(0!=--e.prev_length);if(e.match_available=0,e.match_length=se-1,e.strstart++,r&&(s(e,!1),0===e.strm.avail_out))return be}else if(e.match_available){if(r=R._tr_tally(e,0,e.window[e.strstart-1]),r&&s(e,!1),e.strstart++,e.lookahead--,0===e.strm.avail_out)return be}else e.match_available=1,e.strstart++,e.lookahead--}return e.match_available&&(r=R._tr_tally(e,0,e.window[e.strstart-1]),e.match_available=0),e.insert=e.strstart<se-1?e.strstart:se-1,t===z?(s(e,!0),0===e.strm.avail_out?we:_e):e.last_lit&&(s(e,!1),0===e.strm.avail_out)?be:ye}function g(e,t){for(var n,r,i,a,o=e.window;;){if(e.lookahead<=le){if(h(e),e.lookahead<=le&&t===M)return be;if(0===e.lookahead)break}if(e.match_length=0,e.lookahead>=se&&e.strstart>0&&(i=e.strstart-1,(r=o[i])===o[++i]&&r===o[++i]&&r===o[++i])){a=e.strstart+le;do{}while(r===o[++i]&&r===o[++i]&&r===o[++i]&&r===o[++i]&&r===o[++i]&&r===o[++i]&&r===o[++i]&&r===o[++i]&&i<a);e.match_length=le-(a-i),e.match_length>e.lookahead&&(e.match_length=e.lookahead)}if(e.match_length>=se?(n=R._tr_tally(e,1,e.match_length-se),e.lookahead-=e.match_length,e.strstart+=e.match_length,e.match_length=0):(n=R._tr_tally(e,0,e.window[e.strstart]),e.lookahead--,e.strstart++),n&&(s(e,!1),0===e.strm.avail_out))return be}return e.insert=0,t===z?(s(e,!0),0===e.strm.avail_out?we:_e):e.last_lit&&(s(e,!1),0===e.strm.avail_out)?be:ye}function v(e,t){for(var n;;){if(0===e.lookahead&&(h(e),0===e.lookahead)){if(t===M)return be;break}if(e.match_length=0,n=R._tr_tally(e,0,e.window[e.strstart]),e.lookahead--,e.strstart++,n&&(s(e,!1),0===e.strm.avail_out))return be}return e.insert=0,t===z?(s(e,!0),0===e.strm.avail_out?we:_e):e.last_lit&&(s(e,!1),0===e.strm.avail_out)?be:ye}function b(e,t,n,r,i){this.good_length=e,this.max_lazy=t,this.nice_length=n,this.max_chain=r,this.func=i}function y(e){e.window_size=2*e.w_size,a(e.head),e.max_lazy_match=O[e.level].max_lazy,e.good_match=O[e.level].good_length,e.nice_match=O[e.level].nice_length,e.max_chain_length=O[e.level].max_chain,e.strstart=0,e.block_start=0,e.lookahead=0,e.insert=0,e.match_length=e.prev_length=se-1,e.match_available=0,e.ins_h=0}function w(){this.strm=null,this.status=0,this.pending_buf=null,this.pending_buf_size=0,this.pending_out=0,this.pending=0,this.wrap=0,this.gzhead=null,this.gzindex=0,this.method=$,this.last_flush=-1,this.w_size=0,this.w_bits=0,this.w_mask=0,this.window=null,this.window_size=0,this.prev=null,this.head=null,this.ins_h=0,this.hash_size=0,this.hash_bits=0,this.hash_mask=0,this.hash_shift=0,this.block_start=0,this.match_length=0,this.prev_match=0,this.match_available=0,this.strstart=0,this.match_start=0,this.lookahead=0,this.prev_length=0,this.max_chain_length=0,this.max_lazy_match=0,this.level=0,this.strategy=0,this.good_match=0,this.nice_match=0,this.dyn_ltree=new I.Buf16(2*ae),this.dyn_dtree=new I.Buf16(2*(2*re+1)),this.bl_tree=new I.Buf16(2*(2*ie+1)),a(this.dyn_ltree),a(this.dyn_dtree),a(this.bl_tree),this.l_desc=null,this.d_desc=null,this.bl_desc=null,this.bl_count=new I.Buf16(oe+1),this.heap=new I.Buf16(2*ne+1),a(this.heap),this.heap_len=0,this.heap_max=0,this.depth=new I.Buf16(2*ne+1),a(this.depth),this.l_buf=0,this.lit_bufsize=0,this.last_lit=0,this.d_buf=0,this.opt_len=0,this.static_len=0,this.matches=0,this.insert=0,this.bi_buf=0,this.bi_valid=0}function _(e){var t;return e&&e.state?(e.total_in=e.total_out=0,e.data_type=J,t=e.state,t.pending=0,t.pending_out=0,t.wrap<0&&(t.wrap=-t.wrap),t.status=t.wrap?fe:ge,e.adler=2===t.wrap?0:1,t.last_flush=M,R._tr_init(t),F):r(e,Z)}function k(e){var t=_(e);return t===F&&y(e.state),t}function x(e,t){return e&&e.state?2!==e.state.wrap?Z:(e.state.gzhead=t,F):Z}function S(e,t,n,i,a,o){if(!e)return Z;var s=1;if(t===q&&(t=6),i<0?(s=0,i=-i):i>15&&(s=2,i-=16),a<1||a>Q||n!==$||i<8||i>15||t<0||t>9||o<0||o>X)return r(e,Z);8===i&&(i=9);var l=new w;return e.state=l,l.strm=e,l.wrap=s,l.gzhead=null,l.w_bits=i,l.w_size=1<<l.w_bits,l.w_mask=l.w_size-1,l.hash_bits=a+7,l.hash_size=1<<l.hash_bits,l.hash_mask=l.hash_size-1,l.hash_shift=~~((l.hash_bits+se-1)/se),l.window=new I.Buf8(2*l.w_size),l.head=new I.Buf16(l.hash_size),l.prev=new I.Buf16(l.w_size),l.lit_bufsize=1<<a+6,l.pending_buf_size=4*l.lit_bufsize,l.pending_buf=new I.Buf8(l.pending_buf_size),l.d_buf=1*l.lit_bufsize,l.l_buf=3*l.lit_bufsize,l.level=t,l.strategy=o,l.method=n,k(e)}function E(e,t){return S(e,t,$,ee,te,G)}function T(e,t){var n,s,c,f;if(!e||!e.state||t>D||t<0)return e?r(e,Z):Z;if(s=e.state,!e.output||!e.input&&0!==e.avail_in||s.status===ve&&t!==z)return r(e,0===e.avail_out?Y:Z);if(s.strm=e,n=s.last_flush,s.last_flush=t,s.status===fe)if(2===s.wrap)e.adler=0,l(s,31),l(s,139),l(s,8),s.gzhead?(l(s,(s.gzhead.text?1:0)+(s.gzhead.hcrc?2:0)+(s.gzhead.extra?4:0)+(s.gzhead.name?8:0)+(s.gzhead.comment?16:0)),l(s,255&s.gzhead.time),l(s,s.gzhead.time>>8&255),l(s,s.gzhead.time>>16&255),l(s,s.gzhead.time>>24&255),l(s,9===s.level?2:s.strategy>=V||s.level<2?4:0),l(s,255&s.gzhead.os),s.gzhead.extra&&s.gzhead.extra.length&&(l(s,255&s.gzhead.extra.length),l(s,s.gzhead.extra.length>>8&255)),s.gzhead.hcrc&&(e.adler=j(e.adler,s.pending_buf,s.pending,0)),s.gzindex=0,s.status=he):(l(s,0),l(s,0),l(s,0),l(s,0),l(s,0),l(s,9===s.level?2:s.strategy>=V||s.level<2?4:0),l(s,ke),s.status=ge);else{var h=$+(s.w_bits-8<<4)<<8,d=-1;d=s.strategy>=V||s.level<2?0:s.level<6?1:6===s.level?2:3,h|=d<<6,0!==s.strstart&&(h|=ce),h+=31-h%31,s.status=ge,u(s,h),0!==s.strstart&&(u(s,e.adler>>>16),u(s,65535&e.adler)),e.adler=1}if(s.status===he)if(s.gzhead.extra){for(c=s.pending;s.gzindex<(65535&s.gzhead.extra.length)&&(s.pending!==s.pending_buf_size||(s.gzhead.hcrc&&s.pending>c&&(e.adler=j(e.adler,s.pending_buf,s.pending-c,c)),o(e),c=s.pending,s.pending!==s.pending_buf_size));)l(s,255&s.gzhead.extra[s.gzindex]),s.gzindex++;s.gzhead.hcrc&&s.pending>c&&(e.adler=j(e.adler,s.pending_buf,s.pending-c,c)),s.gzindex===s.gzhead.extra.length&&(s.gzindex=0,s.status=de)}else s.status=de;if(s.status===de)if(s.gzhead.name){c=s.pending;do{if(s.pending===s.pending_buf_size&&(s.gzhead.hcrc&&s.pending>c&&(e.adler=j(e.adler,s.pending_buf,s.pending-c,c)),o(e),c=s.pending,s.pending===s.pending_buf_size)){f=1;break}f=s.gzindex<s.gzhead.name.length?255&s.gzhead.name.charCodeAt(s.gzindex++):0,l(s,f)}while(0!==f);s.gzhead.hcrc&&s.pending>c&&(e.adler=j(e.adler,s.pending_buf,s.pending-c,c)),0===f&&(s.gzindex=0,s.status=pe)}else s.status=pe;if(s.status===pe)if(s.gzhead.comment){c=s.pending;do{if(s.pending===s.pending_buf_size&&(s.gzhead.hcrc&&s.pending>c&&(e.adler=j(e.adler,s.pending_buf,s.pending-c,c)),o(e),c=s.pending,s.pending===s.pending_buf_size)){f=1;break}f=s.gzindex<s.gzhead.comment.length?255&s.gzhead.comment.charCodeAt(s.gzindex++):0,l(s,f)}while(0!==f);s.gzhead.hcrc&&s.pending>c&&(e.adler=j(e.adler,s.pending_buf,s.pending-c,c)),0===f&&(s.status=me)}else s.status=me;if(s.status===me&&(s.gzhead.hcrc?(s.pending+2>s.pending_buf_size&&o(e),s.pending+2<=s.pending_buf_size&&(l(s,255&e.adler),l(s,e.adler>>8&255),e.adler=0,s.status=ge)):s.status=ge),0!==s.pending){if(o(e),0===e.avail_out)return s.last_flush=-1,F}else if(0===e.avail_in&&i(t)<=i(n)&&t!==z)return r(e,Y);if(s.status===ve&&0!==e.avail_in)return r(e,Y);if(0!==e.avail_in||0!==s.lookahead||t!==M&&s.status!==ve){var p=s.strategy===V?v(s,t):s.strategy===K?g(s,t):O[s.level].func(s,t);if(p!==we&&p!==_e||(s.status=ve),p===be||p===we)return 0===e.avail_out&&(s.last_flush=-1),F;if(p===ye&&(t===P?R._tr_align(s):t!==D&&(R._tr_stored_block(s,0,0,!1),t===N&&(a(s.head),0===s.lookahead&&(s.strstart=0,s.block_start=0,s.insert=0))),o(e),0===e.avail_out))return s.last_flush=-1,F}return t!==z?F:s.wrap<=0?U:(2===s.wrap?(l(s,255&e.adler),l(s,e.adler>>8&255),l(s,e.adler>>16&255),l(s,e.adler>>24&255),l(s,255&e.total_in),l(s,e.total_in>>8&255),l(s,e.total_in>>16&255),l(s,e.total_in>>24&255)):(u(s,e.adler>>>16),u(s,65535&e.adler)),o(e),s.wrap>0&&(s.wrap=-s.wrap),0!==s.pending?F:U)}function C(e){var t;return e&&e.state?(t=e.state.status)!==fe&&t!==he&&t!==de&&t!==pe&&t!==me&&t!==ge&&t!==ve?r(e,Z):(e.state=null,t===ge?r(e,W):F):Z}function A(e,t){var n,r,i,o,s,l,u,c,f=t.length;if(!e||!e.state)return Z;if(n=e.state,2===(o=n.wrap)||1===o&&n.status!==fe||n.lookahead)return Z;for(1===o&&(e.adler=L(e.adler,t,f,0)),n.wrap=0,f>=n.w_size&&(0===o&&(a(n.head),n.strstart=0,n.block_start=0,n.insert=0),c=new I.Buf8(n.w_size),I.arraySet(c,t,f-n.w_size,n.w_size,0),t=c,f=n.w_size),s=e.avail_in,l=e.next_in,u=e.input,e.avail_in=f,e.next_in=0,e.input=t,h(n);n.lookahead>=se;){r=n.strstart,i=n.lookahead-(se-1);do{n.ins_h=(n.ins_h<<n.hash_shift^n.window[r+se-1])&n.hash_mask,n.prev[r&n.w_mask]=n.head[n.ins_h],n.head[n.ins_h]=r,r++}while(--i);n.strstart=r,n.lookahead=se-1,h(n)}return n.strstart+=n.lookahead,n.block_start=n.strstart,n.insert=n.lookahead,n.lookahead=0,n.match_length=n.prev_length=se-1,n.match_available=0,e.next_in=l,e.input=u,e.avail_in=s,n.wrap=o,F}var O,I=n(4),R=n(90),L=n(40),j=n(41),B=n(23),M=0,P=1,N=3,z=4,D=5,F=0,U=1,Z=-2,W=-3,Y=-5,q=-1,H=1,V=2,K=3,X=4,G=0,J=2,$=8,Q=9,ee=15,te=8,ne=286,re=30,ie=19,ae=2*ne+1,oe=15,se=3,le=258,ue=le+se+1,ce=32,fe=42,he=69,de=73,pe=91,me=103,ge=113,ve=666,be=1,ye=2,we=3,_e=4,ke=3;O=[new b(0,0,0,0,d),new b(4,4,8,4,p),new b(4,5,16,8,p),new b(4,6,32,32,p),new b(4,4,16,16,m),new b(8,16,32,32,m),new b(8,16,128,128,m),new b(8,32,128,256,m),new b(32,128,258,1024,m),new b(32,258,258,4096,m)],t.deflateInit=E,t.deflateInit2=S,t.deflateReset=k,t.deflateResetKeep=_,t.deflateSetHeader=x,t.deflate=T,t.deflateEnd=C,t.deflateSetDictionary=A,t.deflateInfo="pako deflate (from Nodeca project)"},function(e,t,n){"use strict";function r(e){for(var t=e.length;--t>=0;)e[t]=0}function i(e,t,n,r,i){this.static_tree=e,this.extra_bits=t,this.extra_base=n,this.elems=r,this.max_length=i,this.has_stree=e&&e.length}function a(e,t){this.dyn_tree=e,this.max_code=0,this.stat_desc=t}function o(e){return e<256?ae[e]:ae[256+(e>>>7)]}function s(e,t){e.pending_buf[e.pending++]=255&t,e.pending_buf[e.pending++]=t>>>8&255}function l(e,t,n){e.bi_valid>V-n?(e.bi_buf|=t<<e.bi_valid&65535,s(e,e.bi_buf),e.bi_buf=t>>V-e.bi_valid,e.bi_valid+=n-V):(e.bi_buf|=t<<e.bi_valid&65535,e.bi_valid+=n)}function u(e,t,n){l(e,n[2*t],n[2*t+1])}function c(e,t){var n=0;do{n|=1&e,e>>>=1,n<<=1}while(--t>0);return n>>>1}function f(e){16===e.bi_valid?(s(e,e.bi_buf),e.bi_buf=0,e.bi_valid=0):e.bi_valid>=8&&(e.pending_buf[e.pending++]=255&e.bi_buf,e.bi_buf>>=8,e.bi_valid-=8)}function h(e,t){var n,r,i,a,o,s,l=t.dyn_tree,u=t.max_code,c=t.stat_desc.static_tree,f=t.stat_desc.has_stree,h=t.stat_desc.extra_bits,d=t.stat_desc.extra_base,p=t.stat_desc.max_length,m=0;for(a=0;a<=H;a++)e.bl_count[a]=0;for(l[2*e.heap[e.heap_max]+1]=0,n=e.heap_max+1;n<q;n++)r=e.heap[n],a=l[2*l[2*r+1]+1]+1,a>p&&(a=p,m++),l[2*r+1]=a,r>u||(e.bl_count[a]++,o=0,r>=d&&(o=h[r-d]),s=l[2*r],e.opt_len+=s*(a+o),f&&(e.static_len+=s*(c[2*r+1]+o)));if(0!==m){do{for(a=p-1;0===e.bl_count[a];)a--;e.bl_count[a]--,e.bl_count[a+1]+=2,e.bl_count[p]--,m-=2}while(m>0);for(a=p;0!==a;a--)for(r=e.bl_count[a];0!==r;)(i=e.heap[--n])>u||(l[2*i+1]!==a&&(e.opt_len+=(a-l[2*i+1])*l[2*i],l[2*i+1]=a),r--)}}function d(e,t,n){var r,i,a=new Array(H+1),o=0;for(r=1;r<=H;r++)a[r]=o=o+n[r-1]<<1;for(i=0;i<=t;i++){var s=e[2*i+1];0!==s&&(e[2*i]=c(a[s]++,s))}}function p(){var e,t,n,r,a,o=new Array(H+1);for(n=0,r=0;r<F-1;r++)for(se[r]=n,e=0;e<1<<Q[r];e++)oe[n++]=r;for(oe[n-1]=r,a=0,r=0;r<16;r++)for(le[r]=a,e=0;e<1<<ee[r];e++)ae[a++]=r;for(a>>=7;r<W;r++)for(le[r]=a<<7,e=0;e<1<<ee[r]-7;e++)ae[256+a++]=r;for(t=0;t<=H;t++)o[t]=0;for(e=0;e<=143;)re[2*e+1]=8,e++,o[8]++;for(;e<=255;)re[2*e+1]=9,e++,o[9]++;for(;e<=279;)re[2*e+1]=7,e++,o[7]++;for(;e<=287;)re[2*e+1]=8,e++,o[8]++;for(d(re,Z+1,o),e=0;e<W;e++)ie[2*e+1]=5,ie[2*e]=c(e,5);ue=new i(re,Q,U+1,Z,H),ce=new i(ie,ee,0,W,H),fe=new i(new Array(0),te,0,Y,K)}function m(e){var t;for(t=0;t<Z;t++)e.dyn_ltree[2*t]=0;for(t=0;t<W;t++)e.dyn_dtree[2*t]=0;for(t=0;t<Y;t++)e.bl_tree[2*t]=0;e.dyn_ltree[2*X]=1,e.opt_len=e.static_len=0,e.last_lit=e.matches=0}function g(e){e.bi_valid>8?s(e,e.bi_buf):e.bi_valid>0&&(e.pending_buf[e.pending++]=e.bi_buf),e.bi_buf=0,e.bi_valid=0}function v(e,t,n,r){g(e),r&&(s(e,n),s(e,~n)),L.arraySet(e.pending_buf,e.window,t,n,e.pending),e.pending+=n}function b(e,t,n,r){var i=2*t,a=2*n;return e[i]<e[a]||e[i]===e[a]&&r[t]<=r[n]}function y(e,t,n){for(var r=e.heap[n],i=n<<1;i<=e.heap_len&&(i<e.heap_len&&b(t,e.heap[i+1],e.heap[i],e.depth)&&i++,!b(t,r,e.heap[i],e.depth));)e.heap[n]=e.heap[i],n=i,i<<=1;e.heap[n]=r}function w(e,t,n){var r,i,a,s,c=0;if(0!==e.last_lit)do{r=e.pending_buf[e.d_buf+2*c]<<8|e.pending_buf[e.d_buf+2*c+1],i=e.pending_buf[e.l_buf+c],c++,0===r?u(e,i,t):(a=oe[i],u(e,a+U+1,t),s=Q[a],0!==s&&(i-=se[a],l(e,i,s)),r--,a=o(r),u(e,a,n),0!==(s=ee[a])&&(r-=le[a],l(e,r,s)))}while(c<e.last_lit);u(e,X,t)}function _(e,t){var n,r,i,a=t.dyn_tree,o=t.stat_desc.static_tree,s=t.stat_desc.has_stree,l=t.stat_desc.elems,u=-1;for(e.heap_len=0,e.heap_max=q,n=0;n<l;n++)0!==a[2*n]?(e.heap[++e.heap_len]=u=n,e.depth[n]=0):a[2*n+1]=0;for(;e.heap_len<2;)i=e.heap[++e.heap_len]=u<2?++u:0,a[2*i]=1,e.depth[i]=0,e.opt_len--,s&&(e.static_len-=o[2*i+1]);for(t.max_code=u,n=e.heap_len>>1;n>=1;n--)y(e,a,n);i=l;do{n=e.heap[1],e.heap[1]=e.heap[e.heap_len--],y(e,a,1),r=e.heap[1],e.heap[--e.heap_max]=n,e.heap[--e.heap_max]=r,a[2*i]=a[2*n]+a[2*r],e.depth[i]=(e.depth[n]>=e.depth[r]?e.depth[n]:e.depth[r])+1,a[2*n+1]=a[2*r+1]=i,e.heap[1]=i++,y(e,a,1)}while(e.heap_len>=2);e.heap[--e.heap_max]=e.heap[1],h(e,t),d(a,u,e.bl_count)}function k(e,t,n){var r,i,a=-1,o=t[1],s=0,l=7,u=4;for(0===o&&(l=138,u=3),t[2*(n+1)+1]=65535,r=0;r<=n;r++)i=o,o=t[2*(r+1)+1],++s<l&&i===o||(s<u?e.bl_tree[2*i]+=s:0!==i?(i!==a&&e.bl_tree[2*i]++,e.bl_tree[2*G]++):s<=10?e.bl_tree[2*J]++:e.bl_tree[2*$]++,s=0,a=i,0===o?(l=138,u=3):i===o?(l=6,u=3):(l=7,u=4))}function x(e,t,n){var r,i,a=-1,o=t[1],s=0,c=7,f=4;for(0===o&&(c=138,f=3),r=0;r<=n;r++)if(i=o,o=t[2*(r+1)+1],!(++s<c&&i===o)){if(s<f)do{u(e,i,e.bl_tree)}while(0!=--s);else 0!==i?(i!==a&&(u(e,i,e.bl_tree),s--),u(e,G,e.bl_tree),l(e,s-3,2)):s<=10?(u(e,J,e.bl_tree),l(e,s-3,3)):(u(e,$,e.bl_tree),l(e,s-11,7));s=0,a=i,0===o?(c=138,f=3):i===o?(c=6,f=3):(c=7,f=4)}}function S(e){var t;for(k(e,e.dyn_ltree,e.l_desc.max_code),k(e,e.dyn_dtree,e.d_desc.max_code),_(e,e.bl_desc),t=Y-1;t>=3&&0===e.bl_tree[2*ne[t]+1];t--);return e.opt_len+=3*(t+1)+5+5+4,t}function E(e,t,n,r){var i;for(l(e,t-257,5),l(e,n-1,5),l(e,r-4,4),i=0;i<r;i++)l(e,e.bl_tree[2*ne[i]+1],3);x(e,e.dyn_ltree,t-1),x(e,e.dyn_dtree,n-1)}function T(e){var t,n=4093624447;for(t=0;t<=31;t++,n>>>=1)if(1&n&&0!==e.dyn_ltree[2*t])return B;if(0!==e.dyn_ltree[18]||0!==e.dyn_ltree[20]||0!==e.dyn_ltree[26])return M;for(t=32;t<U;t++)if(0!==e.dyn_ltree[2*t])return M;return B}function C(e){he||(p(),he=!0),e.l_desc=new a(e.dyn_ltree,ue),e.d_desc=new a(e.dyn_dtree,ce),e.bl_desc=new a(e.bl_tree,fe),e.bi_buf=0,e.bi_valid=0,m(e)}function A(e,t,n,r){l(e,(N<<1)+(r?1:0),3),v(e,t,n,!0)}function O(e){l(e,z<<1,3),u(e,X,re),f(e)}function I(e,t,n,r){var i,a,o=0;e.level>0?(e.strm.data_type===P&&(e.strm.data_type=T(e)),_(e,e.l_desc),_(e,e.d_desc),o=S(e),i=e.opt_len+3+7>>>3,(a=e.static_len+3+7>>>3)<=i&&(i=a)):i=a=n+5,n+4<=i&&-1!==t?A(e,t,n,r):e.strategy===j||a===i?(l(e,(z<<1)+(r?1:0),3),w(e,re,ie)):(l(e,(D<<1)+(r?1:0),3),E(e,e.l_desc.max_code+1,e.d_desc.max_code+1,o+1),w(e,e.dyn_ltree,e.dyn_dtree)),m(e),r&&g(e)}function R(e,t,n){return e.pending_buf[e.d_buf+2*e.last_lit]=t>>>8&255,e.pending_buf[e.d_buf+2*e.last_lit+1]=255&t,e.pending_buf[e.l_buf+e.last_lit]=255&n,e.last_lit++,0===t?e.dyn_ltree[2*n]++:(e.matches++,t--,e.dyn_ltree[2*(oe[n]+U+1)]++,e.dyn_dtree[2*o(t)]++),e.last_lit===e.lit_bufsize-1}var L=n(4),j=4,B=0,M=1,P=2,N=0,z=1,D=2,F=29,U=256,Z=U+1+F,W=30,Y=19,q=2*Z+1,H=15,V=16,K=7,X=256,G=16,J=17,$=18,Q=[0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,4,5,5,5,5,0],ee=[0,0,0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13],te=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,3,7],ne=[16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15],re=new Array(2*(Z+2));r(re);var ie=new Array(2*W);r(ie);var ae=new Array(512);r(ae);var oe=new Array(256);r(oe);var se=new Array(F);r(se);var le=new Array(W);r(le);var ue,ce,fe,he=!1;t._tr_init=C,t._tr_stored_block=A,t._tr_flush_block=I,t._tr_tally=R,t._tr_align=O},function(e,t,n){"use strict";function r(e){if(!(this instanceof r))return new r(e);this.options=s.assign({chunkSize:16384,windowBits:0,to:""},e||{});var t=this.options;t.raw&&t.windowBits>=0&&t.windowBits<16&&(t.windowBits=-t.windowBits,0===t.windowBits&&(t.windowBits=-15)),!(t.windowBits>=0&&t.windowBits<16)||e&&e.windowBits||(t.windowBits+=32),t.windowBits>15&&t.windowBits<48&&0==(15&t.windowBits)&&(t.windowBits|=15),this.err=0,this.msg="",this.ended=!1,this.chunks=[],this.strm=new f,this.strm.avail_out=0;var n=o.inflateInit2(this.strm,t.windowBits);if(n!==u.Z_OK)throw new Error(c[n]);this.header=new h,o.inflateGetHeader(this.strm,this.header)}function i(e,t){var n=new r(t);if(n.push(e,!0),n.err)throw n.msg||c[n.err];return n.result}function a(e,t){return t=t||{},t.raw=!0,i(e,t)}var o=n(92),s=n(4),l=n(42),u=n(44),c=n(23),f=n(43),h=n(95),d=Object.prototype.toString;r.prototype.push=function(e,t){var n,r,i,a,c,f,h=this.strm,p=this.options.chunkSize,m=this.options.dictionary,g=!1;if(this.ended)return!1;r=t===~~t?t:!0===t?u.Z_FINISH:u.Z_NO_FLUSH,"string"==typeof e?h.input=l.binstring2buf(e):"[object ArrayBuffer]"===d.call(e)?h.input=new Uint8Array(e):h.input=e,h.next_in=0,h.avail_in=h.input.length;do{if(0===h.avail_out&&(h.output=new s.Buf8(p),h.next_out=0,h.avail_out=p),n=o.inflate(h,u.Z_NO_FLUSH),n===u.Z_NEED_DICT&&m&&(f="string"==typeof m?l.string2buf(m):"[object ArrayBuffer]"===d.call(m)?new Uint8Array(m):m,n=o.inflateSetDictionary(this.strm,f)),n===u.Z_BUF_ERROR&&!0===g&&(n=u.Z_OK,g=!1),n!==u.Z_STREAM_END&&n!==u.Z_OK)return this.onEnd(n),this.ended=!0,!1;h.next_out&&(0!==h.avail_out&&n!==u.Z_STREAM_END&&(0!==h.avail_in||r!==u.Z_FINISH&&r!==u.Z_SYNC_FLUSH)||("string"===this.options.to?(i=l.utf8border(h.output,h.next_out),a=h.next_out-i,c=l.buf2string(h.output,i),h.next_out=a,h.avail_out=p-a,a&&s.arraySet(h.output,h.output,i,a,0),this.onData(c)):this.onData(s.shrinkBuf(h.output,h.next_out)))),0===h.avail_in&&0===h.avail_out&&(g=!0)}while((h.avail_in>0||0===h.avail_out)&&n!==u.Z_STREAM_END);return n===u.Z_STREAM_END&&(r=u.Z_FINISH),r===u.Z_FINISH?(n=o.inflateEnd(this.strm),this.onEnd(n),this.ended=!0,n===u.Z_OK):r!==u.Z_SYNC_FLUSH||(this.onEnd(u.Z_OK),h.avail_out=0,!0)},r.prototype.onData=function(e){this.chunks.push(e)},r.prototype.onEnd=function(e){e===u.Z_OK&&("string"===this.options.to?this.result=this.chunks.join(""):this.result=s.flattenChunks(this.chunks)),this.chunks=[],this.err=e,this.msg=this.strm.msg},t.Inflate=r,t.inflate=i,t.inflateRaw=a,t.ungzip=i},function(e,t,n){"use strict";function r(e){return(e>>>24&255)+(e>>>8&65280)+((65280&e)<<8)+((255&e)<<24)}function i(){this.mode=0,this.last=!1,this.wrap=0,this.havedict=!1,this.flags=0,this.dmax=0,this.check=0,this.total=0,this.head=null,this.wbits=0,this.wsize=0,this.whave=0,this.wnext=0,this.window=null,this.hold=0,this.bits=0,this.length=0,this.offset=0,this.extra=0,this.lencode=null,this.distcode=null,this.lenbits=0,this.distbits=0,this.ncode=0,this.nlen=0,this.ndist=0,this.have=0,this.next=null,this.lens=new b.Buf16(320),this.work=new b.Buf16(288),this.lendyn=null,this.distdyn=null,this.sane=0,this.back=0,this.was=0}function a(e){var t;return e&&e.state?(t=e.state,e.total_in=e.total_out=t.total=0,e.msg="",t.wrap&&(e.adler=1&t.wrap),t.mode=N,t.last=0,t.havedict=0,t.dmax=32768,t.head=null,t.hold=0,t.bits=0,t.lencode=t.lendyn=new b.Buf32(me),t.distcode=t.distdyn=new b.Buf32(ge),t.sane=1,t.back=-1,O):L}function o(e){var t;return e&&e.state?(t=e.state,t.wsize=0,t.whave=0,t.wnext=0,a(e)):L}function s(e,t){var n,r;return e&&e.state?(r=e.state,t<0?(n=0,t=-t):(n=1+(t>>4),t<48&&(t&=15)),t&&(t<8||t>15)?L:(null!==r.window&&r.wbits!==t&&(r.window=null),r.wrap=n,r.wbits=t,o(e))):L}function l(e,t){var n,r;return e?(r=new i,e.state=r,r.window=null,n=s(e,t),n!==O&&(e.state=null),n):L}function u(e){return l(e,ve)}function c(e){if(be){var t;for(g=new b.Buf32(512),v=new b.Buf32(32),t=0;t<144;)e.lens[t++]=8;for(;t<256;)e.lens[t++]=9;for(;t<280;)e.lens[t++]=7;for(;t<288;)e.lens[t++]=8;for(k(S,e.lens,0,288,g,0,e.work,{bits:9}),t=0;t<32;)e.lens[t++]=5;k(E,e.lens,0,32,v,0,e.work,{bits:5}),be=!1}e.lencode=g,e.lenbits=9,e.distcode=v,e.distbits=5}function f(e,t,n,r){var i,a=e.state;return null===a.window&&(a.wsize=1<<a.wbits,a.wnext=0,a.whave=0,a.window=new b.Buf8(a.wsize)),r>=a.wsize?(b.arraySet(a.window,t,n-a.wsize,a.wsize,0),a.wnext=0,a.whave=a.wsize):(i=a.wsize-a.wnext,i>r&&(i=r),b.arraySet(a.window,t,n-r,i,a.wnext),r-=i,r?(b.arraySet(a.window,t,n-r,r,0),a.wnext=r,a.whave=a.wsize):(a.wnext+=i,a.wnext===a.wsize&&(a.wnext=0),a.whave<a.wsize&&(a.whave+=i))),0}function h(e,t){var n,i,a,o,s,l,u,h,d,p,m,g,v,me,ge,ve,be,ye,we,_e,ke,xe,Se,Ee,Te=0,Ce=new b.Buf8(4),Ae=[16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15];if(!e||!e.state||!e.output||!e.input&&0!==e.avail_in)return L;n=e.state,n.mode===K&&(n.mode=X),s=e.next_out,a=e.output,u=e.avail_out,o=e.next_in,i=e.input,l=e.avail_in,h=n.hold,d=n.bits,p=l,m=u,xe=O;e:for(;;)switch(n.mode){case N:if(0===n.wrap){n.mode=X;break}for(;d<16;){if(0===l)break e;l--,h+=i[o++]<<d,d+=8}if(2&n.wrap&&35615===h){n.check=0,Ce[0]=255&h,Ce[1]=h>>>8&255,n.check=w(n.check,Ce,2,0),h=0,d=0,n.mode=z;break}if(n.flags=0,n.head&&(n.head.done=!1),!(1&n.wrap)||(((255&h)<<8)+(h>>8))%31){e.msg="incorrect header check",n.mode=he;break}if((15&h)!==P){e.msg="unknown compression method",n.mode=he;break}if(h>>>=4,d-=4,ke=8+(15&h),0===n.wbits)n.wbits=ke;else if(ke>n.wbits){e.msg="invalid window size",n.mode=he;break}n.dmax=1<<ke,e.adler=n.check=1,n.mode=512&h?H:K,h=0,d=0;break;case z:for(;d<16;){if(0===l)break e;l--,h+=i[o++]<<d,d+=8}if(n.flags=h,(255&n.flags)!==P){e.msg="unknown compression method",n.mode=he;break}if(57344&n.flags){e.msg="unknown header flags set",n.mode=he;break}n.head&&(n.head.text=h>>8&1),512&n.flags&&(Ce[0]=255&h,Ce[1]=h>>>8&255,n.check=w(n.check,Ce,2,0)),h=0,d=0,n.mode=D;case D:for(;d<32;){if(0===l)break e;l--,h+=i[o++]<<d,d+=8}n.head&&(n.head.time=h),512&n.flags&&(Ce[0]=255&h,Ce[1]=h>>>8&255,Ce[2]=h>>>16&255,Ce[3]=h>>>24&255,n.check=w(n.check,Ce,4,0)),h=0,d=0,n.mode=F;case F:for(;d<16;){if(0===l)break e;l--,h+=i[o++]<<d,d+=8}n.head&&(n.head.xflags=255&h,n.head.os=h>>8),512&n.flags&&(Ce[0]=255&h,Ce[1]=h>>>8&255,n.check=w(n.check,Ce,2,0)),h=0,d=0,n.mode=U;case U:if(1024&n.flags){for(;d<16;){if(0===l)break e;l--,h+=i[o++]<<d,d+=8}n.length=h,n.head&&(n.head.extra_len=h),512&n.flags&&(Ce[0]=255&h,Ce[1]=h>>>8&255,n.check=w(n.check,Ce,2,0)),h=0,d=0}else n.head&&(n.head.extra=null);n.mode=Z;case Z:if(1024&n.flags&&(g=n.length,g>l&&(g=l),g&&(n.head&&(ke=n.head.extra_len-n.length,n.head.extra||(n.head.extra=new Array(n.head.extra_len)),b.arraySet(n.head.extra,i,o,g,ke)),512&n.flags&&(n.check=w(n.check,i,g,o)),l-=g,o+=g,n.length-=g),n.length))break e;n.length=0,n.mode=W;case W:if(2048&n.flags){if(0===l)break e;g=0;do{ke=i[o+g++],n.head&&ke&&n.length<65536&&(n.head.name+=String.fromCharCode(ke))}while(ke&&g<l);if(512&n.flags&&(n.check=w(n.check,i,g,o)),l-=g,o+=g,ke)break e}else n.head&&(n.head.name=null);n.length=0,n.mode=Y;case Y:if(4096&n.flags){if(0===l)break e;g=0;do{ke=i[o+g++],n.head&&ke&&n.length<65536&&(n.head.comment+=String.fromCharCode(ke))}while(ke&&g<l);if(512&n.flags&&(n.check=w(n.check,i,g,o)),l-=g,o+=g,ke)break e}else n.head&&(n.head.comment=null);n.mode=q;case q:if(512&n.flags){for(;d<16;){if(0===l)break e;l--,h+=i[o++]<<d,d+=8}if(h!==(65535&n.check)){e.msg="header crc mismatch",n.mode=he;break}h=0,d=0}n.head&&(n.head.hcrc=n.flags>>9&1,n.head.done=!0),e.adler=n.check=0,n.mode=K;break;case H:for(;d<32;){if(0===l)break e;l--,h+=i[o++]<<d,d+=8}e.adler=n.check=r(h),h=0,d=0,n.mode=V;case V:if(0===n.havedict)return e.next_out=s,e.avail_out=u,e.next_in=o,e.avail_in=l,n.hold=h,n.bits=d,R;e.adler=n.check=1,n.mode=K;case K:if(t===C||t===A)break e;case X:if(n.last){h>>>=7&d,d-=7&d,n.mode=ue;break}for(;d<3;){if(0===l)break e;l--,h+=i[o++]<<d,d+=8}switch(n.last=1&h,h>>>=1,d-=1,3&h){case 0:n.mode=G;break;case 1:if(c(n),n.mode=ne,t===A){h>>>=2,d-=2;break e}break;case 2:n.mode=Q;break;case 3:e.msg="invalid block type",n.mode=he}h>>>=2,d-=2;break;case G:for(h>>>=7&d,d-=7&d;d<32;){if(0===l)break e;l--,h+=i[o++]<<d,d+=8}if((65535&h)!=(h>>>16^65535)){e.msg="invalid stored block lengths",n.mode=he;break}if(n.length=65535&h,h=0,d=0,n.mode=J,t===A)break e;case J:n.mode=$;case $:if(g=n.length){if(g>l&&(g=l),g>u&&(g=u),0===g)break e;b.arraySet(a,i,o,g,s),l-=g,o+=g,u-=g,s+=g,n.length-=g;break}n.mode=K;break;case Q:for(;d<14;){if(0===l)break e;l--,h+=i[o++]<<d,d+=8}if(n.nlen=257+(31&h),h>>>=5,d-=5,n.ndist=1+(31&h),h>>>=5,d-=5,n.ncode=4+(15&h),h>>>=4,d-=4,n.nlen>286||n.ndist>30){e.msg="too many length or distance symbols",n.mode=he;break}n.have=0,n.mode=ee;case ee:for(;n.have<n.ncode;){for(;d<3;){if(0===l)break e;l--,h+=i[o++]<<d,d+=8}n.lens[Ae[n.have++]]=7&h,h>>>=3,d-=3}for(;n.have<19;)n.lens[Ae[n.have++]]=0;if(n.lencode=n.lendyn,n.lenbits=7,Se={bits:n.lenbits},xe=k(x,n.lens,0,19,n.lencode,0,n.work,Se),n.lenbits=Se.bits,xe){e.msg="invalid code lengths set",n.mode=he;break}n.have=0,n.mode=te;case te:for(;n.have<n.nlen+n.ndist;){for(;Te=n.lencode[h&(1<<n.lenbits)-1],ge=Te>>>24,ve=Te>>>16&255,be=65535&Te,!(ge<=d);){if(0===l)break e;l--,h+=i[o++]<<d,d+=8}if(be<16)h>>>=ge,d-=ge,n.lens[n.have++]=be;else{if(16===be){for(Ee=ge+2;d<Ee;){if(0===l)break e;l--,h+=i[o++]<<d,d+=8}if(h>>>=ge,d-=ge,0===n.have){e.msg="invalid bit length repeat",n.mode=he;break}ke=n.lens[n.have-1],g=3+(3&h),h>>>=2,d-=2}else if(17===be){for(Ee=ge+3;d<Ee;){if(0===l)break e;l--,h+=i[o++]<<d,d+=8}h>>>=ge,d-=ge,ke=0,g=3+(7&h),h>>>=3,d-=3}else{for(Ee=ge+7;d<Ee;){if(0===l)break e;l--,h+=i[o++]<<d,d+=8}h>>>=ge,d-=ge,ke=0,g=11+(127&h),h>>>=7,d-=7}if(n.have+g>n.nlen+n.ndist){e.msg="invalid bit length repeat",n.mode=he;break}for(;g--;)n.lens[n.have++]=ke}}if(n.mode===he)break;if(0===n.lens[256]){e.msg="invalid code -- missing end-of-block",n.mode=he;break}if(n.lenbits=9,Se={bits:n.lenbits},xe=k(S,n.lens,0,n.nlen,n.lencode,0,n.work,Se),n.lenbits=Se.bits,xe){e.msg="invalid literal/lengths set",n.mode=he;break}if(n.distbits=6,n.distcode=n.distdyn,Se={bits:n.distbits},xe=k(E,n.lens,n.nlen,n.ndist,n.distcode,0,n.work,Se),n.distbits=Se.bits,xe){e.msg="invalid distances set",n.mode=he;break}if(n.mode=ne,t===A)break e;case ne:n.mode=re;case re:if(l>=6&&u>=258){e.next_out=s,e.avail_out=u,e.next_in=o,e.avail_in=l,n.hold=h,n.bits=d,_(e,m),s=e.next_out,a=e.output,u=e.avail_out,o=e.next_in,i=e.input,l=e.avail_in,h=n.hold,d=n.bits,n.mode===K&&(n.back=-1);break}for(n.back=0;Te=n.lencode[h&(1<<n.lenbits)-1],ge=Te>>>24,ve=Te>>>16&255,be=65535&Te,!(ge<=d);){if(0===l)break e;l--,h+=i[o++]<<d,d+=8}if(ve&&0==(240&ve)){for(ye=ge,we=ve,_e=be;Te=n.lencode[_e+((h&(1<<ye+we)-1)>>ye)],ge=Te>>>24,ve=Te>>>16&255,be=65535&Te,!(ye+ge<=d);){if(0===l)break e;l--,h+=i[o++]<<d,d+=8}h>>>=ye,d-=ye,n.back+=ye}if(h>>>=ge,d-=ge,n.back+=ge,n.length=be,0===ve){n.mode=le;break}if(32&ve){n.back=-1,n.mode=K;break}if(64&ve){e.msg="invalid literal/length code",n.mode=he;break}n.extra=15&ve,n.mode=ie;case ie:if(n.extra){for(Ee=n.extra;d<Ee;){if(0===l)break e;l--,h+=i[o++]<<d,d+=8}n.length+=h&(1<<n.extra)-1,h>>>=n.extra,d-=n.extra,n.back+=n.extra}n.was=n.length,n.mode=ae;case ae:for(;Te=n.distcode[h&(1<<n.distbits)-1],ge=Te>>>24,ve=Te>>>16&255,be=65535&Te,!(ge<=d);){if(0===l)break e;l--,h+=i[o++]<<d,d+=8}if(0==(240&ve)){for(ye=ge,we=ve,_e=be;Te=n.distcode[_e+((h&(1<<ye+we)-1)>>ye)],ge=Te>>>24,ve=Te>>>16&255,be=65535&Te,!(ye+ge<=d);){if(0===l)break e;l--,h+=i[o++]<<d,d+=8}h>>>=ye,d-=ye,n.back+=ye}if(h>>>=ge,d-=ge,n.back+=ge,64&ve){e.msg="invalid distance code",n.mode=he;break}n.offset=be,n.extra=15&ve,n.mode=oe;case oe:if(n.extra){for(Ee=n.extra;d<Ee;){if(0===l)break e;l--,h+=i[o++]<<d,d+=8}n.offset+=h&(1<<n.extra)-1,h>>>=n.extra,d-=n.extra,n.back+=n.extra}if(n.offset>n.dmax){e.msg="invalid distance too far back",n.mode=he;break}n.mode=se;case se:if(0===u)break e;if(g=m-u,n.offset>g){if((g=n.offset-g)>n.whave&&n.sane){e.msg="invalid distance too far back",n.mode=he;break}g>n.wnext?(g-=n.wnext,v=n.wsize-g):v=n.wnext-g,g>n.length&&(g=n.length),me=n.window}else me=a,v=s-n.offset,g=n.length;g>u&&(g=u),u-=g,n.length-=g;do{a[s++]=me[v++]}while(--g);0===n.length&&(n.mode=re);break;case le:if(0===u)break e;a[s++]=n.length,u--,n.mode=re;break;case ue:if(n.wrap){for(;d<32;){if(0===l)break e;l--,h|=i[o++]<<d,d+=8}if(m-=u,e.total_out+=m,n.total+=m,m&&(e.adler=n.check=n.flags?w(n.check,a,m,s-m):y(n.check,a,m,s-m)),m=u,(n.flags?h:r(h))!==n.check){e.msg="incorrect data check",n.mode=he;break}h=0,d=0}n.mode=ce;case ce:if(n.wrap&&n.flags){for(;d<32;){if(0===l)break e;l--,h+=i[o++]<<d,d+=8}if(h!==(4294967295&n.total)){e.msg="incorrect length check",n.mode=he;break}h=0,d=0}n.mode=fe;case fe:xe=I;break e;case he:xe=j;break e;case de:return B;case pe:default:return L}return e.next_out=s,e.avail_out=u,e.next_in=o,e.avail_in=l,n.hold=h,n.bits=d,(n.wsize||m!==e.avail_out&&n.mode<he&&(n.mode<ue||t!==T))&&f(e,e.output,e.next_out,m-e.avail_out)?(n.mode=de,B):(p-=e.avail_in,m-=e.avail_out,e.total_in+=p,e.total_out+=m,n.total+=m,n.wrap&&m&&(e.adler=n.check=n.flags?w(n.check,a,m,e.next_out-m):y(n.check,a,m,e.next_out-m)),e.data_type=n.bits+(n.last?64:0)+(n.mode===K?128:0)+(n.mode===ne||n.mode===J?256:0),(0===p&&0===m||t===T)&&xe===O&&(xe=M),xe)}function d(e){if(!e||!e.state)return L;var t=e.state;return t.window&&(t.window=null),e.state=null,O}function p(e,t){var n;return e&&e.state?(n=e.state,0==(2&n.wrap)?L:(n.head=t,t.done=!1,O)):L}function m(e,t){var n,r,i=t.length;return e&&e.state?(n=e.state,0!==n.wrap&&n.mode!==V?L:n.mode===V&&(r=1,(r=y(r,t,i,0))!==n.check)?j:f(e,t,i,i)?(n.mode=de,B):(n.havedict=1,O)):L}var g,v,b=n(4),y=n(40),w=n(41),_=n(93),k=n(94),x=0,S=1,E=2,T=4,C=5,A=6,O=0,I=1,R=2,L=-2,j=-3,B=-4,M=-5,P=8,N=1,z=2,D=3,F=4,U=5,Z=6,W=7,Y=8,q=9,H=10,V=11,K=12,X=13,G=14,J=15,$=16,Q=17,ee=18,te=19,ne=20,re=21,ie=22,ae=23,oe=24,se=25,le=26,ue=27,ce=28,fe=29,he=30,de=31,pe=32,me=852,ge=592,ve=15,be=!0;t.inflateReset=o,t.inflateReset2=s,t.inflateResetKeep=a,t.inflateInit=u,t.inflateInit2=l,t.inflate=h,t.inflateEnd=d,t.inflateGetHeader=p,t.inflateSetDictionary=m,t.inflateInfo="pako inflate (from Nodeca project)"},function(e,t,n){"use strict";e.exports=function(e,t){var n,r,i,a,o,s,l,u,c,f,h,d,p,m,g,v,b,y,w,_,k,x,S,E,T;n=e.state,r=e.next_in,E=e.input,i=r+(e.avail_in-5),a=e.next_out,T=e.output,o=a-(t-e.avail_out),s=a+(e.avail_out-257),l=n.dmax,u=n.wsize,c=n.whave,f=n.wnext,h=n.window,d=n.hold,p=n.bits,m=n.lencode,g=n.distcode,v=(1<<n.lenbits)-1,b=(1<<n.distbits)-1;e:do{p<15&&(d+=E[r++]<<p,p+=8,d+=E[r++]<<p,p+=8),y=m[d&v];t:for(;;){if(w=y>>>24,d>>>=w,p-=w,0==(w=y>>>16&255))T[a++]=65535&y;else{if(!(16&w)){if(0==(64&w)){y=m[(65535&y)+(d&(1<<w)-1)];continue t}if(32&w){n.mode=12;break e}e.msg="invalid literal/length code",n.mode=30;break e}_=65535&y,w&=15,w&&(p<w&&(d+=E[r++]<<p,p+=8),_+=d&(1<<w)-1,d>>>=w,p-=w),p<15&&(d+=E[r++]<<p,p+=8,d+=E[r++]<<p,p+=8),y=g[d&b];n:for(;;){if(w=y>>>24,d>>>=w,p-=w,!(16&(w=y>>>16&255))){if(0==(64&w)){y=g[(65535&y)+(d&(1<<w)-1)];continue n}e.msg="invalid distance code",n.mode=30;break e}if(k=65535&y,w&=15,p<w&&(d+=E[r++]<<p,(p+=8)<w&&(d+=E[r++]<<p,p+=8)),(k+=d&(1<<w)-1)>l){e.msg="invalid distance too far back",n.mode=30;break e}if(d>>>=w,p-=w,w=a-o,k>w){if((w=k-w)>c&&n.sane){e.msg="invalid distance too far back",n.mode=30;break e}if(x=0,S=h,0===f){if(x+=u-w,w<_){_-=w;do{T[a++]=h[x++]}while(--w);x=a-k,S=T}}else if(f<w){if(x+=u+f-w,(w-=f)<_){_-=w;do{T[a++]=h[x++]}while(--w);if(x=0,f<_){w=f,_-=w;do{T[a++]=h[x++]}while(--w);x=a-k,S=T}}}else if(x+=f-w,w<_){_-=w;do{T[a++]=h[x++]}while(--w);x=a-k,S=T}for(;_>2;)T[a++]=S[x++],T[a++]=S[x++],T[a++]=S[x++],_-=3;_&&(T[a++]=S[x++],_>1&&(T[a++]=S[x++]))}else{x=a-k;do{T[a++]=T[x++],T[a++]=T[x++],T[a++]=T[x++],_-=3}while(_>2);_&&(T[a++]=T[x++],_>1&&(T[a++]=T[x++]))}break}}break}}while(r<i&&a<s);_=p>>3,r-=_,p-=_<<3,d&=(1<<p)-1,e.next_in=r,e.next_out=a,e.avail_in=r<i?i-r+5:5-(r-i),e.avail_out=a<s?s-a+257:257-(a-s),n.hold=d,n.bits=p}},function(e,t,n){"use strict";var r=n(4),i=[3,4,5,6,7,8,9,10,11,13,15,17,19,23,27,31,35,43,51,59,67,83,99,115,131,163,195,227,258,0,0],a=[16,16,16,16,16,16,16,16,17,17,17,17,18,18,18,18,19,19,19,19,20,20,20,20,21,21,21,21,16,72,78],o=[1,2,3,4,5,7,9,13,17,25,33,49,65,97,129,193,257,385,513,769,1025,1537,2049,3073,4097,6145,8193,12289,16385,24577,0,0],s=[16,16,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23,24,24,25,25,26,26,27,27,28,28,29,29,64,64];e.exports=function(e,t,n,l,u,c,f,h){var d,p,m,g,v,b,y,w,_,k=h.bits,x=0,S=0,E=0,T=0,C=0,A=0,O=0,I=0,R=0,L=0,j=null,B=0,M=new r.Buf16(16),P=new r.Buf16(16),N=null,z=0;for(x=0;x<=15;x++)M[x]=0;for(S=0;S<l;S++)M[t[n+S]]++;for(C=k,T=15;T>=1&&0===M[T];T--);if(C>T&&(C=T),0===T)return u[c++]=20971520,u[c++]=20971520,h.bits=1,0;for(E=1;E<T&&0===M[E];E++);for(C<E&&(C=E),I=1,x=1;x<=15;x++)if(I<<=1,(I-=M[x])<0)return-1;if(I>0&&(0===e||1!==T))return-1;for(P[1]=0,x=1;x<15;x++)P[x+1]=P[x]+M[x];for(S=0;S<l;S++)0!==t[n+S]&&(f[P[t[n+S]]++]=S);if(0===e?(j=N=f,b=19):1===e?(j=i,B-=257,N=a,z-=257,b=256):(j=o,N=s,b=-1),L=0,S=0,x=E,v=c,A=C,O=0,m=-1,R=1<<C,g=R-1,1===e&&R>852||2===e&&R>592)return 1;for(;;){y=x-O,f[S]<b?(w=0,_=f[S]):f[S]>b?(w=N[z+f[S]],_=j[B+f[S]]):(w=96,_=0),d=1<<x-O,p=1<<A,E=p;do{p-=d,u[v+(L>>O)+p]=y<<24|w<<16|_|0}while(0!==p);for(d=1<<x-1;L&d;)d>>=1;if(0!==d?(L&=d-1,L+=d):L=0,S++,0==--M[x]){if(x===T)break;x=t[n+f[S]]}if(x>C&&(L&g)!==m){for(0===O&&(O=C),v+=E,A=x-O,I=1<<A;A+O<T&&!((I-=M[A+O])<=0);)A++,I<<=1;if(R+=1<<A,1===e&&R>852||2===e&&R>592)return 1;m=L&g,u[m]=C<<24|A<<16|v-c|0}}return 0!==L&&(u[v+L]=x-O<<24|64<<16|0),h.bits=C,0}},function(e,t,n){"use strict";function r(){this.text=0,this.time=0,this.xflags=0,this.os=0,this.extra=null,this.extra_len=0,this.name="",this.comment="",this.hcrc=0,this.done=!1}e.exports=r},function(e,t,n){"use strict";function r(e,t,n,r){a.call(this,"ZipFileWorker"),this.bytesWritten=0,this.zipComment=t,this.zipPlatform=n,this.encodeFileName=r,this.streamFiles=e,this.accumulate=!1,this.contentBuffer=[],this.dirRecords=[],this.currentSourceOffset=0,this.entriesCount=0,this.currentFile=null,this._sources=[]}var i=n(0),a=n(1),o=n(6),s=n(22),l=n(45),u=function(e,t){var n,r="";for(n=0;n<t;n++)r+=String.fromCharCode(255&e),e>>>=8;return r},c=function(e,t){var n=e;return e||(n=t?16893:33204),(65535&n)<<16},f=function(e,t){return 63&(e||0)},h=function(e,t,n,r,a,h){var d,p,m=e.file,g=e.compression,v=h!==o.utf8encode,b=i.transformTo("string",h(m.name)),y=i.transformTo("string",o.utf8encode(m.name)),w=m.comment,_=i.transformTo("string",h(w)),k=i.transformTo("string",o.utf8encode(w)),x=y.length!==m.name.length,S=k.length!==w.length,E="",T="",C="",A=m.dir,O=m.date,I={crc32:0,compressedSize:0,uncompressedSize:0};t&&!n||(I.crc32=e.crc32,I.compressedSize=e.compressedSize,I.uncompressedSize=e.uncompressedSize);var R=0;t&&(R|=8),v||!x&&!S||(R|=2048);var L=0,j=0;A&&(L|=16),"UNIX"===a?(j=798,L|=c(m.unixPermissions,A)):(j=20,L|=f(m.dosPermissions)),d=O.getUTCHours(),d<<=6,d|=O.getUTCMinutes(),d<<=5,d|=O.getUTCSeconds()/2,p=O.getUTCFullYear()-1980,p<<=4,p|=O.getUTCMonth()+1,p<<=5,p|=O.getUTCDate(),x&&(T=u(1,1)+u(s(b),4)+y,E+="up"+u(T.length,2)+T),S&&(C=u(1,1)+u(s(_),4)+k,E+="uc"+u(C.length,2)+C);var B="";return B+="\n\0",B+=u(R,2),B+=g.magic,B+=u(d,2),B+=u(p,2),B+=u(I.crc32,4),B+=u(I.compressedSize,4),B+=u(I.uncompressedSize,4),B+=u(b.length,2),B+=u(E.length,2),{fileRecord:l.LOCAL_FILE_HEADER+B+b+E,dirRecord:l.CENTRAL_FILE_HEADER+u(j,2)+B+u(_.length,2)+"\0\0\0\0"+u(L,4)+u(r,4)+b+E+_}},d=function(e,t,n,r,a){var o=i.transformTo("string",a(r));return l.CENTRAL_DIRECTORY_END+"\0\0\0\0"+u(e,2)+u(e,2)+u(t,4)+u(n,4)+u(o.length,2)+o},p=function(e){return l.DATA_DESCRIPTOR+u(e.crc32,4)+u(e.compressedSize,4)+u(e.uncompressedSize,4)};i.inherits(r,a),r.prototype.push=function(e){var t=e.meta.percent||0,n=this.entriesCount,r=this._sources.length;this.accumulate?this.contentBuffer.push(e):(this.bytesWritten+=e.data.length,a.prototype.push.call(this,{data:e.data,meta:{currentFile:this.currentFile,percent:n?(t+100*(n-r-1))/n:100}}))},r.prototype.openedSource=function(e){this.currentSourceOffset=this.bytesWritten,this.currentFile=e.file.name;var t=this.streamFiles&&!e.file.dir;if(t){var n=h(e,t,!1,this.currentSourceOffset,this.zipPlatform,this.encodeFileName);this.push({data:n.fileRecord,meta:{percent:0}})}else this.accumulate=!0},r.prototype.closedSource=function(e){this.accumulate=!1;var t=this.streamFiles&&!e.file.dir,n=h(e,t,!0,this.currentSourceOffset,this.zipPlatform,this.encodeFileName);if(this.dirRecords.push(n.dirRecord),t)this.push({data:p(e),meta:{percent:100}});else for(this.push({data:n.fileRecord,meta:{percent:0}});this.contentBuffer.length;)this.push(this.contentBuffer.shift());this.currentFile=null},r.prototype.flush=function(){for(var e=this.bytesWritten,t=0;t<this.dirRecords.length;t++)this.push({data:this.dirRecords[t],meta:{percent:100}});var n=this.bytesWritten-e,r=d(this.dirRecords.length,n,e,this.zipComment,this.encodeFileName);this.push({data:r,meta:{percent:100}})},r.prototype.prepareNextSource=function(){this.previous=this._sources.shift(),this.openedSource(this.previous.streamInfo),this.isPaused?this.previous.pause():this.previous.resume()},r.prototype.registerPrevious=function(e){this._sources.push(e);var t=this;return e.on("data",function(e){t.processChunk(e)}),e.on("end",function(){t.closedSource(t.previous.streamInfo),t._sources.length?t.prepareNextSource():t.end()}),e.on("error",function(e){t.error(e)}),this},r.prototype.resume=function(){return!!a.prototype.resume.call(this)&&(!this.previous&&this._sources.length?(this.prepareNextSource(),!0):this.previous||this._sources.length||this.generatedError?void 0:(this.end(),!0))},r.prototype.error=function(e){var t=this._sources;if(!a.prototype.error.call(this,e))return!1;for(var n=0;n<t.length;n++)try{t[n].error(e)}catch(e){}return!0},r.prototype.lock=function(){a.prototype.lock.call(this);for(var e=this._sources,t=0;t<e.length;t++)e[t].lock()},e.exports=r},function(e,t,n){"use strict";function r(e,t){a.call(this,"Nodejs stream input adapter for "+e),this._upstreamEnded=!1,this._bindStream(t)}var i=n(0),a=n(1);i.inherits(r,a),r.prototype._bindStream=function(e){var t=this;this._stream=e,e.pause(),e.on("data",function(e){t.push({data:e,meta:{percent:0}})}).on("error",function(e){t.isPaused?this.generatedError=e:t.error(e)}).on("end",function(){t.isPaused?t._upstreamEnded=!0:t.end()})},r.prototype.pause=function(){return!!a.prototype.pause.call(this)&&(this._stream.pause(),!0)},r.prototype.resume=function(){return!!a.prototype.resume.call(this)&&(this._upstreamEnded?this.end():this._stream.resume(),!0)},e.exports=r},function(e,t,n){"use strict";function r(e){return new a.Promise(function(t,n){var r=e.decompressed.getContentWorker().pipe(new l);r.on("error",function(e){n(e)}).on("end",function(){r.streamInfo.crc32!==e.decompressed.crc32?n(new Error("Corrupted zip : CRC32 mismatch")):t()}).resume()})}var i=n(0),a=n(9),o=n(6),i=n(0),s=n(99),l=n(38),u=n(14);e.exports=function(e,t){var n=this;return t=i.extend(t||{},{base64:!1,checkCRC32:!1,optimizedBinaryString:!1,createFolders:!1,decodeFileName:o.utf8decode}),u.isNode&&u.isStream(e)?a.Promise.reject(new Error("JSZip can't accept a stream when loading a zip file.")):i.prepareContent("the loaded zip file",e,!0,t.optimizedBinaryString,t.base64).then(function(e){var n=new s(t);return n.load(e),n}).then(function(e){var n=[a.Promise.resolve(e)],i=e.files;if(t.checkCRC32)for(var o=0;o<i.length;o++)n.push(r(i[o]));return a.Promise.all(n)}).then(function(e){for(var r=e.shift(),i=r.files,a=0;a<i.length;a++){var o=i[a];n.file(o.fileNameStr,o.decompressed,{binary:!0,optimizedBinaryString:!0,date:o.date,dir:o.dir,comment:o.fileCommentStr.length?o.fileCommentStr:null,unixPermissions:o.unixPermissions,dosPermissions:o.dosPermissions,createFolders:t.createFolders})}return r.zipComment.length&&(n.comment=r.zipComment),n})}},function(e,t,n){"use strict";function r(e){this.files=[],this.loadOptions=e}var i=n(46),a=n(0),o=n(45),s=n(102),l=(n(6),n(3));r.prototype={checkSignature:function(e){if(!this.reader.readAndCheckSignature(e)){this.reader.index-=4;var t=this.reader.readString(4);throw new Error("Corrupted zip or bug: unexpected signature ("+a.pretty(t)+", expected "+a.pretty(e)+")")}},isSignature:function(e,t){var n=this.reader.index;this.reader.setIndex(e);var r=this.reader.readString(4),i=r===t;return this.reader.setIndex(n),i},readBlockEndOfCentral:function(){this.diskNumber=this.reader.readInt(2),this.diskWithCentralDirStart=this.reader.readInt(2),this.centralDirRecordsOnThisDisk=this.reader.readInt(2),this.centralDirRecords=this.reader.readInt(2),this.centralDirSize=this.reader.readInt(4),this.centralDirOffset=this.reader.readInt(4),this.zipCommentLength=this.reader.readInt(2);var e=this.reader.readData(this.zipCommentLength),t=l.uint8array?"uint8array":"array",n=a.transformTo(t,e);this.zipComment=this.loadOptions.decodeFileName(n)},readBlockZip64EndOfCentral:function(){this.zip64EndOfCentralSize=this.reader.readInt(8),this.reader.skip(4),this.diskNumber=this.reader.readInt(4),this.diskWithCentralDirStart=this.reader.readInt(4),this.centralDirRecordsOnThisDisk=this.reader.readInt(8),this.centralDirRecords=this.reader.readInt(8),this.centralDirSize=this.reader.readInt(8),this.centralDirOffset=this.reader.readInt(8),this.zip64ExtensibleData={};for(var e,t,n,r=this.zip64EndOfCentralSize-44;0<r;)e=this.reader.readInt(2),t=this.reader.readInt(4),n=this.reader.readData(t),this.zip64ExtensibleData[e]={id:e,length:t,value:n}},readBlockZip64EndOfCentralLocator:function(){if(this.diskWithZip64CentralDirStart=this.reader.readInt(4),this.relativeOffsetEndOfZip64CentralDir=this.reader.readInt(8),this.disksCount=this.reader.readInt(4),this.disksCount>1)throw new Error("Multi-volumes zip are not supported")},readLocalFiles:function(){var e,t;for(e=0;e<this.files.length;e++)t=this.files[e],this.reader.setIndex(t.localHeaderOffset),this.checkSignature(o.LOCAL_FILE_HEADER),t.readLocalPart(this.reader),t.handleUTF8(),t.processAttributes()},readCentralDir:function(){var e;for(this.reader.setIndex(this.centralDirOffset);this.reader.readAndCheckSignature(o.CENTRAL_FILE_HEADER);)e=new s({zip64:this.zip64},this.loadOptions),e.readCentralPart(this.reader),this.files.push(e);if(this.centralDirRecords!==this.files.length&&0!==this.centralDirRecords&&0===this.files.length)throw new Error("Corrupted zip or bug: expected "+this.centralDirRecords+" records in central dir, got "+this.files.length)},readEndOfCentral:function(){var e=this.reader.lastIndexOfSignature(o.CENTRAL_DIRECTORY_END);if(e<0)throw this.isSignature(0,o.LOCAL_FILE_HEADER)?new Error("Corrupted zip: can't find end of central directory"):new Error("Can't find end of central directory : is this a zip file ? If it is, see https://stuk.github.io/jszip/documentation/howto/read_zip.html");this.reader.setIndex(e);var t=e;if(this.checkSignature(o.CENTRAL_DIRECTORY_END),this.readBlockEndOfCentral(),this.diskNumber===a.MAX_VALUE_16BITS||this.diskWithCentralDirStart===a.MAX_VALUE_16BITS||this.centralDirRecordsOnThisDisk===a.MAX_VALUE_16BITS||this.centralDirRecords===a.MAX_VALUE_16BITS||this.centralDirSize===a.MAX_VALUE_32BITS||this.centralDirOffset===a.MAX_VALUE_32BITS){if(this.zip64=!0,(e=this.reader.lastIndexOfSignature(o.ZIP64_CENTRAL_DIRECTORY_LOCATOR))<0)throw new Error("Corrupted zip: can't find the ZIP64 end of central directory locator");if(this.reader.setIndex(e),this.checkSignature(o.ZIP64_CENTRAL_DIRECTORY_LOCATOR),this.readBlockZip64EndOfCentralLocator(),!this.isSignature(this.relativeOffsetEndOfZip64CentralDir,o.ZIP64_CENTRAL_DIRECTORY_END)&&(this.relativeOffsetEndOfZip64CentralDir=this.reader.lastIndexOfSignature(o.ZIP64_CENTRAL_DIRECTORY_END),this.relativeOffsetEndOfZip64CentralDir<0))throw new Error("Corrupted zip: can't find the ZIP64 end of central directory");this.reader.setIndex(this.relativeOffsetEndOfZip64CentralDir),this.checkSignature(o.ZIP64_CENTRAL_DIRECTORY_END),this.readBlockZip64EndOfCentral()}var n=this.centralDirOffset+this.centralDirSize;this.zip64&&(n+=20,n+=12+this.zip64EndOfCentralSize);var r=t-n;if(r>0)this.isSignature(t,o.CENTRAL_FILE_HEADER)||(this.reader.zero=r);else if(r<0)throw new Error("Corrupted zip: missing "+Math.abs(r)+" bytes.")},prepareReader:function(e){this.reader=i(e)},load:function(e){this.prepareReader(e),this.readEndOfCentral(),this.readCentralDir(),this.readLocalFiles()}},e.exports=r},function(e,t,n){"use strict";function r(e){i.call(this,e)}var i=n(48);n(0).inherits(r,i),r.prototype.byteAt=function(e){return this.data.charCodeAt(this.zero+e)},r.prototype.lastIndexOfSignature=function(e){return this.data.lastIndexOf(e)-this.zero},r.prototype.readAndCheckSignature=function(e){return e===this.readData(4)},r.prototype.readData=function(e){this.checkOffset(e);var t=this.data.slice(this.zero+this.index,this.zero+this.index+e);return this.index+=e,t},e.exports=r},function(e,t,n){"use strict";function r(e){i.call(this,e)}var i=n(49);n(0).inherits(r,i),r.prototype.readData=function(e){this.checkOffset(e);var t=this.data.slice(this.zero+this.index,this.zero+this.index+e);return this.index+=e,t},e.exports=r},function(e,t,n){"use strict";function r(e,t){this.options=e,this.loadOptions=t}var i=n(46),a=n(0),o=n(21),s=n(22),l=n(6),u=n(39),c=n(3),f=function(e){for(var t in u)if(u.hasOwnProperty(t)&&u[t].magic===e)return u[t];return null};r.prototype={isEncrypted:function(){return 1==(1&this.bitFlag)},useUTF8:function(){return 2048==(2048&this.bitFlag)},readLocalPart:function(e){var t,n;if(e.skip(22),this.fileNameLength=e.readInt(2),n=e.readInt(2),this.fileName=e.readData(this.fileNameLength),e.skip(n),-1===this.compressedSize||-1===this.uncompressedSize)throw new Error("Bug or corrupted zip : didn't get enough informations from the central directory (compressedSize === -1 || uncompressedSize === -1)");if(null===(t=f(this.compressionMethod)))throw new Error("Corrupted zip : compression "+a.pretty(this.compressionMethod)+" unknown (inner file : "+a.transformTo("string",this.fileName)+")");this.decompressed=new o(this.compressedSize,this.uncompressedSize,this.crc32,t,e.readData(this.compressedSize))},readCentralPart:function(e){this.versionMadeBy=e.readInt(2),e.skip(2),this.bitFlag=e.readInt(2),this.compressionMethod=e.readString(2),this.date=e.readDate(),this.crc32=e.readInt(4),this.compressedSize=e.readInt(4),this.uncompressedSize=e.readInt(4);var t=e.readInt(2);if(this.extraFieldsLength=e.readInt(2),this.fileCommentLength=e.readInt(2),this.diskNumberStart=e.readInt(2),this.internalFileAttributes=e.readInt(2),this.externalFileAttributes=e.readInt(4),this.localHeaderOffset=e.readInt(4),this.isEncrypted())throw new Error("Encrypted zip are not supported");e.skip(t),this.readExtraFields(e),this.parseZIP64ExtraField(e),this.fileComment=e.readData(this.fileCommentLength)},processAttributes:function(){this.unixPermissions=null,this.dosPermissions=null;var e=this.versionMadeBy>>8;this.dir=!!(16&this.externalFileAttributes),0===e&&(this.dosPermissions=63&this.externalFileAttributes),3===e&&(this.unixPermissions=this.externalFileAttributes>>16&65535),this.dir||"/"!==this.fileNameStr.slice(-1)||(this.dir=!0)},parseZIP64ExtraField:function(e){if(this.extraFields[1]){var t=i(this.extraFields[1].value);this.uncompressedSize===a.MAX_VALUE_32BITS&&(this.uncompressedSize=t.readInt(8)),this.compressedSize===a.MAX_VALUE_32BITS&&(this.compressedSize=t.readInt(8)),this.localHeaderOffset===a.MAX_VALUE_32BITS&&(this.localHeaderOffset=t.readInt(8)),this.diskNumberStart===a.MAX_VALUE_32BITS&&(this.diskNumberStart=t.readInt(4))}},readExtraFields:function(e){var t,n,r,i=e.index+this.extraFieldsLength;for(this.extraFields||(this.extraFields={});e.index<i;)t=e.readInt(2),n=e.readInt(2),r=e.readData(n),this.extraFields[t]={id:t,length:n,value:r}},handleUTF8:function(){var e=c.uint8array?"uint8array":"array";if(this.useUTF8())this.fileNameStr=l.utf8decode(this.fileName),this.fileCommentStr=l.utf8decode(this.fileComment);else{var t=this.findExtraFieldUnicodePath();if(null!==t)this.fileNameStr=t;else{var n=a.transformTo(e,this.fileName);this.fileNameStr=this.loadOptions.decodeFileName(n)}var r=this.findExtraFieldUnicodeComment();if(null!==r)this.fileCommentStr=r;else{var i=a.transformTo(e,this.fileComment);this.fileCommentStr=this.loadOptions.decodeFileName(i)}}},findExtraFieldUnicodePath:function(){var e=this.extraFields[28789];if(e){var t=i(e.value);return 1!==t.readInt(1)?null:s(this.fileName)!==t.readInt(4)?null:l.utf8decode(t.readData(e.length-5))}return null},findExtraFieldUnicodeComment:function(){var e=this.extraFields[25461];if(e){var t=i(e.value);return 1!==t.readInt(1)?null:s(this.fileComment)!==t.readInt(4)?null:l.utf8decode(t.readData(e.length-5))}return null}},e.exports=r},function(e,t,n){var r,i=i||function(e){"use strict";if(!(void 0===e||"undefined"!=typeof navigator&&/MSIE [1-9]\./.test(navigator.userAgent))){var t=e.document,n=function(){return e.URL||e.webkitURL||e},r=t.createElementNS("http://www.w3.org/1999/xhtml","a"),i="download"in r,a=function(e){var t=new MouseEvent("click");e.dispatchEvent(t)},o=/constructor/i.test(e.HTMLElement)||e.safari,s=/CriOS\/[\d]+/.test(navigator.userAgent),l=function(t){(e.setImmediate||e.setTimeout)(function(){throw t},0)},u=function(e){var t=function(){"string"==typeof e?n().revokeObjectURL(e):e.remove()};setTimeout(t,4e4)},c=function(e,t,n){t=[].concat(t);for(var r=t.length;r--;){var i=e["on"+t[r]];if("function"==typeof i)try{i.call(e,n||e)}catch(e){l(e)}}},f=function(e){return/^\s*(?:text\/\S*|application\/xml|\S*\/\S*\+xml)\s*;.*charset\s*=\s*utf-8/i.test(e.type)?new Blob([String.fromCharCode(65279),e],{type:e.type}):e},h=function(t,l,h){h||(t=f(t));var d,p=this,m=t.type,g="application/octet-stream"===m,v=function(){c(p,"writestart progress write writeend".split(" "))};if(p.readyState=p.INIT,i)return d=n().createObjectURL(t),void setTimeout(function(){r.href=d,r.download=l,a(r),v(),u(d),p.readyState=p.DONE});!function(){if((s||g&&o)&&e.FileReader){var r=new FileReader;return r.onloadend=function(){var t=s?r.result:r.result.replace(/^data:[^;]*;/,"data:attachment/file;");e.open(t,"_blank")||(e.location.href=t),t=void 0,p.readyState=p.DONE,v()},r.readAsDataURL(t),void(p.readyState=p.INIT)}d||(d=n().createObjectURL(t)),g?e.location.href=d:e.open(d,"_blank")||(e.location.href=d),p.readyState=p.DONE,v(),u(d)}()},d=h.prototype,p=function(e,t,n){return new h(e,t||e.name||"download",n)};return"undefined"!=typeof navigator&&navigator.msSaveOrOpenBlob?function(e,t,n){return t=t||e.name||"download",n||(e=f(e)),navigator.msSaveOrOpenBlob(e,t)}:(d.abort=function(){},d.readyState=d.INIT=0,d.WRITING=1,d.DONE=2,d.error=d.onwritestart=d.onprogress=d.onwrite=d.onabort=d.onerror=d.onwriteend=null,p)}}("undefined"!=typeof self&&self||"undefined"!=typeof window&&window||this.content);void 0!==e&&e.exports?e.exports.saveAs=i:null!==n(104)&&null!==n(105)&&void 0!==(r=function(){return i}.call(t,n,t,e))&&(e.exports=r)},function(e,t){e.exports=function(){throw new Error("define cannot be used indirect")}},function(e,t){(function(t){e.exports=t}).call(t,{})}])})}).call(t,n(1).setImmediate,n(1).clearImmediate)},function(e,t,n){(function(e,t){!function(e,n){"use strict";function r(e){"function"!=typeof e&&(e=new Function(""+e));for(var t=new Array(arguments.length-1),n=0;n<t.length;n++)t[n]=arguments[n+1];var r={callback:e,args:t};return u[l]=r,s(l),l++}function i(e){delete u[e]}function a(e){var t=e.callback,r=e.args;switch(r.length){case 0:t();break;case 1:t(r[0]);break;case 2:t(r[0],r[1]);break;case 3:t(r[0],r[1],r[2]);break;default:t.apply(n,r)}}function o(e){if(c)setTimeout(o,0,e);else{var t=u[e];if(t){c=!0;try{a(t)}finally{i(e),c=!1}}}}if(!e.setImmediate){var s,l=1,u={},c=!1,f=e.document,h=Object.getPrototypeOf&&Object.getPrototypeOf(e);h=h&&h.setTimeout?h:e,"[object process]"==={}.toString.call(e.process)?function(){s=function(e){t.nextTick(function(){o(e)})}}():function(){if(e.postMessage&&!e.importScripts){var t=!0,n=e.onmessage;return e.onmessage=function(){t=!1},e.postMessage("","*"),e.onmessage=n,t}}()?function(){var t="setImmediate$"+Math.random()+"$",n=function(n){n.source===e&&"string"==typeof n.data&&0===n.data.indexOf(t)&&o(+n.data.slice(t.length))};e.addEventListener?e.addEventListener("message",n,!1):e.attachEvent("onmessage",n),s=function(n){e.postMessage(t+n,"*")}}():e.MessageChannel?function(){var e=new MessageChannel;e.port1.onmessage=function(e){o(e.data)},s=function(t){e.port2.postMessage(t)}}():f&&"onreadystatechange"in f.createElement("script")?function(){var e=f.documentElement;s=function(t){var n=f.createElement("script");n.onreadystatechange=function(){o(t),n.onreadystatechange=null,e.removeChild(n),n=null},e.appendChild(n)}}():function(){s=function(e){setTimeout(o,0,e)}}(),h.setImmediate=r,h.clearImmediate=i}}("undefined"==typeof self?void 0===e?this:e:self)}).call(t,n(2),n(11))},function(e,t){function n(){throw new Error("setTimeout has not been defined")}function r(){throw new Error("clearTimeout has not been defined")}function i(e){if(c===setTimeout)return setTimeout(e,0);if((c===n||!c)&&setTimeout)return c=setTimeout,setTimeout(e,0);try{return c(e,0)}catch(t){try{return c.call(null,e,0)}catch(t){return c.call(this,e,0)}}}function a(e){if(f===clearTimeout)return clearTimeout(e);if((f===r||!f)&&clearTimeout)return f=clearTimeout,clearTimeout(e);try{return f(e)}catch(t){try{return f.call(null,e)}catch(t){return f.call(this,e)}}}function o(){m&&d&&(m=!1,d.length?p=d.concat(p):g=-1,p.length&&s())}function s(){if(!m){var e=i(o);m=!0;for(var t=p.length;t;){for(d=p,p=[];++g<t;)d&&d[g].run();g=-1,t=p.length}d=null,m=!1,a(e)}}function l(e,t){this.fun=e,this.array=t}function u(){}var c,f,h=e.exports={};!function(){try{c="function"==typeof setTimeout?setTimeout:n}catch(e){c=n}try{f="function"==typeof clearTimeout?clearTimeout:r}catch(e){f=r}}();var d,p=[],m=!1,g=-1;h.nextTick=function(e){var t=new Array(arguments.length-1);if(arguments.length>1)for(var n=1;n<arguments.length;n++)t[n-1]=arguments[n];p.push(new l(e,t)),1!==p.length||m||i(s)},l.prototype.run=function(){this.fun.apply(null,this.array)},h.title="browser",h.browser=!0,h.env={},h.argv=[],h.version="",h.versions={},h.on=u,h.addListener=u,h.once=u,h.off=u,h.removeListener=u,h.removeAllListeners=u,h.emit=u,h.prependListener=u,h.prependOnceListener=u,h.listeners=function(e){return[]},h.binding=function(e){throw new Error("process.binding is not supported")},h.cwd=function(){return"/"},h.chdir=function(e){throw new Error("process.chdir is not supported")},h.umask=function(){return 0}},function(e,t,n){/*! grapesjs-aviary - 0.1.2 */
!function(t,r){e.exports=r(n(0))}(0,function(e){return function(e){function t(r){if(n[r])return n[r].exports;var i=n[r]={i:r,l:!1,exports:{}};return e[r].call(i.exports,i,i.exports,t),i.l=!0,i.exports}var n={};return t.m=e,t.c=n,t.d=function(e,n,r){t.o(e,n)||Object.defineProperty(e,n,{configurable:!1,enumerable:!0,get:r})},t.n=function(e){var n=e&&e.__esModule?function(){return e.default}:function(){return e};return t.d(n,"a",n),n},t.o=function(e,t){return Object.prototype.hasOwnProperty.call(e,t)},t.p="",t(t.s=0)}([function(e,t,n){"use strict";Object.defineProperty(t,"__esModule",{value:!0});var r=n(1),i=function(e){return e&&e.__esModule?e:{default:e}}(r);t.default=i.default.plugins.add("gjs-aviary",function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},n=t,r=e.getModel(),i=void 0,a={key:"1",onApply:null,getFilename:null,closeOnApply:!0,config:{}};for(var o in a)o in n||(n[o]=a[o]);var s=n.config;s.apiKey=n.key,s.onSave=function(e,t){i.set("src",t);var r="function"==typeof n.getFilename?n.getFilename:c,a=r(i);("function"==typeof n.onApply?n.onApply:f)(t,a,i),n.closeOnApply&&l.close()};var l=new Aviary.Feather(s),u=e.Commands,c=function(e){var t=e.get("src").split("/").pop();return Date.now()+"_"+t.slice(-15)},f=function(t,n){e.AssetManager.add({src:t,name:n})},h=document.createElement("img");u.add("image-editor",{run:function(e,t,n){var a=n||{},o=a.model||e.getSelected();i=o,h.src=o.get("src"),l.launch({image:h}),r.trigger("gjs-aviary:launch",o,l)}})})},function(t,n){t.exports=e}])})},function(e,t,n){/*! grapesjs-plugin-filestack - 0.1.1 */
!function(t,r){e.exports=r(n(0))}(0,function(e){return function(e){function t(r){if(n[r])return n[r].exports;var i=n[r]={i:r,l:!1,exports:{}};return e[r].call(i.exports,i,i.exports,t),i.l=!0,i.exports}var n={};return t.m=e,t.c=n,t.d=function(e,n,r){t.o(e,n)||Object.defineProperty(e,n,{configurable:!1,enumerable:!0,get:r})},t.n=function(e){var n=e&&e.__esModule?function(){return e.default}:function(){return e};return t.d(n,"a",n),n},t.o=function(e,t){return Object.prototype.hasOwnProperty.call(e,t)},t.p="",t(t.s=0)}([function(e,t,n){"use strict";Object.defineProperty(t,"__esModule",{value:!0});var r=n(1),i=function(e){return e&&e.__esModule?e:{default:e}}(r);t.default=i.default.plugins.add("gjs-plugin-filestack",function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},n=t,r=e.getConfig(),i=r.stylePrefix||"",a=void 0,o={key:"",btnEl:"",btnText:"Add images",filestackOpts:{accept:"image/*",maxFiles:10},onComplete:function(e,t){}};for(var s in o)s in n||(n[s]=o[s]);if(!filestack)throw new Error("Filestack instance not found");if(!n.key)throw new Error("Filestack's API key not found");var l=filestack.init(n.key);e.on("run:open-assets",function(){var t=e.Modal,r=t.getContentEl(),o=r.querySelector("."+i+"am-file-uploader"),s=r.querySelector("."+i+"am-assets-header"),c=r.querySelector("."+i+"am-assets-cont");o&&(o.style.display="none"),s&&(s.style.display="none"),c.style.width="100%",a||(a=n.btnEl,a||(a=document.createElement("button"),a.className=i+"btn-prim "+i+"btn-filestack",a.innerHTML=n.btnText),a.onclick=function(){l.pick(n.filestackOpts).then(function(e){var t=e.filesUploaded,r=t instanceof Array?t:[t],i=u(r);n.onComplete(r,i)})}),c.insertBefore(a,s)});var u=function(t){var n=t.map(function(e){return e.src=e.url,e});return e.AssetManager.add(n)}})},function(t,n){t.exports=e}])})},function(e,t,n){"use strict";Object.defineProperty(t,"__esModule",{value:!0});var r=n(15),i=function(e){return e&&e.__esModule?e:{default:e}}(r),a=n(3);t.default=function(e,t){var n=e.Commands,r=t.textCleanCanvas;n.add(a.cmdImport,(0,i.default)(e,t)),n.add(a.cmdDeviceDesktop,function(e){return e.setDevice("Desktop")}),n.add(a.cmdDeviceTablet,function(e){return e.setDevice("Tablet")}),n.add(a.cmdDeviceMobile,function(e){return e.setDevice("Mobile portrait")}),n.add(a.cmdClear,function(e){return confirm(r)&&e.runCommand("core:canvas-clear")})}},function(e,t,n){"use strict";Object.defineProperty(t,"__esModule",{value:!0});var r=Object.assign||function(e){for(var t=1;t<arguments.length;t++){var n=arguments[t];for(var r in n)Object.prototype.hasOwnProperty.call(n,r)&&(e[r]=n[r])}return e};t.default=function(e,t){var n=e.getConfig("stylePrefix"),i=e.Modal,a=e.CodeManager.getViewer("CodeMirror").clone(),o=document.createElement("div"),s=t.modalImportLabel,l=t.modalImportContent,u=a.editor,c=document.createElement("button");return c.type="button",c.innerHTML=t.modalImportButton,c.className=n+"btn-prim "+n+"btn-import",c.onclick=function(t){e.setComponents(u.getValue().trim()),i.close()},a.set(r({codeName:"htmlmixed",theme:"hopscotch",readOnly:0},t.importViewerOptions)),{run:function(e){var r=this;if(!u){var f=document.createElement("textarea");if(s){var h=document.createElement("div");h.className=n+"import-label",h.innerHTML=s,o.appendChild(h)}o.appendChild(f),o.appendChild(c),a.init(f),u=a.editor}i.setTitle(t.modalImportTitle),i.setContent(o);var d="function"==typeof l?l(e):l;a.setContent(d||""),i.open().getModel().once("change:open",function(){return e.stopCommand(r.id)}),u.refresh()},stop:function(){i.close()}}}},function(e,t,n){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.default=function(e,t){var n=e.BlockManager,r=function(e){return t.blocks.indexOf(e)>=0};r("link-block")&&n.add("link-block",{category:"Basic",label:"Link Block",attributes:{class:"fa fa-link"},content:{type:"link",editable:!1,droppable:!0,style:{display:"inline-block",padding:"5px","min-height":"50px","min-width":"50px"}}}),r("quote")&&n.add("quote",{label:"Quote",category:"Basic",attributes:{class:"fa fa-quote-right"},content:'<blockquote class="quote">\n        Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore ipsum dolor sit\n      </blockquote>'}),r("text-basic")&&n.add("text-basic",{category:"Basic",label:"Text section",attributes:{class:"gjs-fonts gjs-f-h1p"},content:'<section class="bdg-sect">\n      <h1 class="heading">Insert title here</h1>\n      <p class="paragraph">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua</p>\n      </section>'})}},function(e,t,n){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.default=function(e){var t=(arguments.length>1&&void 0!==arguments[1]&&arguments[1],e.DomComponents),n=t.getType("default");n.model,n.view}},function(e,t,n){"use strict";Object.defineProperty(t,"__esModule",{value:!0});var r=n(3);t.default=function(e,t){var n=e.Panels,i=e.getConfig(),a="sw-visibility",o="export-template",s="open-sm",l="open-layers",u="open-blocks",c="fullscreen",f="preview";i.showDevices=0,n.getPanels().reset([{id:"commands",buttons:[{}]},{id:"options",buttons:[{id:a,command:a,context:a,className:"fa fa-square-o"},{id:f,context:f,command:function(e){return e.runCommand(f)},className:"fa fa-eye"},{id:c,command:c,context:c,className:"fa fa-arrows-alt"},{id:o,className:"fa fa-code",command:function(e){return e.runCommand(o)}},{id:"undo",className:"fa fa-undo",command:function(e){return e.runCommand("core:undo")}},{id:"redo",className:"fa fa-repeat",command:function(e){return e.runCommand("core:redo")}},{id:r.cmdImport,className:"fa fa-download",command:function(e){return e.runCommand(r.cmdImport)}},{id:r.cmdClear,className:"fa fa-trash",command:function(e){return e.runCommand(r.cmdClear)}}]},{id:"views",buttons:[{id:s,command:s,active:!0,className:"fa fa-paint-brush"},{id:"open-tm",command:"open-tm",className:"fa fa-cog"},{id:l,command:l,className:"fa fa-bars"},{id:u,command:u,className:"fa fa-th-large"}]}]),n.addPanel({id:"devices-c"}).get("buttons").add([{id:r.cmdDeviceDesktop,command:r.cmdDeviceDesktop,className:"fa fa-desktop",active:1},{id:r.cmdDeviceTablet,command:r.cmdDeviceTablet,className:"fa fa-tablet"},{id:r.cmdDeviceMobile,command:r.cmdDeviceMobile,className:"fa fa-mobile"}]);var h=n.getButton("views",u);e.on("load",function(){return h&&h.set("active",1)}),t.showStylesOnChange&&e.on("component:selected",function(){var t=n.getButton("views",s),r=n.getButton("views",l);r&&r.get("active")||!e.getSelected()||t&&t.set("active",1)})}},function(e,t,n){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.default=function(e,t){var n=e.StyleManager,r=t.customStyleManager;n.getSectors().reset(r&&r.length?r:[{name:t.textGeneral,open:!1,buildProps:["float","display","position","top","right","left","bottom"]},{name:t.textLayout,open:!1,buildProps:["width","height","max-width","min-height","margin","padding"]},{name:t.textTypography,open:!1,buildProps:["font-family","font-size","font-weight","letter-spacing","color","line-height","text-align","text-shadow"],properties:[{property:"text-align",list:[{value:"left",className:"fa fa-align-left"},{value:"center",className:"fa fa-align-center"},{value:"right",className:"fa fa-align-right"},{value:"justify",className:"fa fa-align-justify"}]}]},{name:t.textDecorations,open:!1,buildProps:["border-radius-c","background-color","border-radius","border","box-shadow","background"]},{name:t.textExtra,open:!1,buildProps:["transition","perspective","transform"]}])}}])});

/***/ }),

/***/ "./node_modules/grapesjs/dist/grapes.min.js":
/*!**************************************************!*\
  !*** ./node_modules/grapesjs/dist/grapes.min.js ***!
  \**************************************************/
/***/ (function(module) {

/*! grapesjs - 0.17.29 */
!function(t,e){ true?module.exports=e():0}('undefined'!=typeof globalThis?globalThis:'undefined'!=typeof window?window:this,(function(){return function(t){var e={};function n(r){if(e[r])return e[r].exports;var i=e[r]={i:r,l:!1,exports:{}};return t[r].call(i.exports,i,i.exports,n),i.l=!0,i.exports}return n.m=t,n.c=e,n.d=function(t,e,r){n.o(t,e)||Object.defineProperty(t,e,{enumerable:!0,get:r})},n.r=function(t){'undefined'!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(t,Symbol.toStringTag,{value:'Module'}),Object.defineProperty(t,'__esModule',{value:!0})},n.t=function(t,e){if(1&e&&(t=n(t)),8&e)return t;if(4&e&&'object'==typeof t&&t&&t.__esModule)return t;var r=Object.create(null);if(n.r(r),Object.defineProperty(r,'default',{enumerable:!0,value:t}),2&e&&'string'!=typeof t)for(var i in t)n.d(r,i,function(e){return t[e]}.bind(null,i));return r},n.n=function(t){var e=t&&t.__esModule?function(){return t['default']}:function(){return t};return n.d(e,'a',e),e},n.o=function(t,e){return Object.prototype.hasOwnProperty.call(t,e)},n.p="",n(n.s=100)}([function(t,e,n){"use strict";n.r(e),n.d(e,"default",(function(){return kn})),n.d(e,"VERSION",(function(){return i["e"]})),n.d(e,"restArguments",(function(){return o})),n.d(e,"isObject",(function(){return a})),n.d(e,"isNull",(function(){return s})),n.d(e,"isUndefined",(function(){return c})),n.d(e,"isBoolean",(function(){return l})),n.d(e,"isElement",(function(){return u})),n.d(e,"isString",(function(){return h})),n.d(e,"isNumber",(function(){return f})),n.d(e,"isDate",(function(){return p})),n.d(e,"isRegExp",(function(){return g})),n.d(e,"isError",(function(){return v})),n.d(e,"isSymbol",(function(){return m})),n.d(e,"isArrayBuffer",(function(){return y})),n.d(e,"isDataView",(function(){return j})),n.d(e,"isArray",(function(){return T})),n.d(e,"isFunction",(function(){return O})),n.d(e,"isArguments",(function(){return _})),n.d(e,"isFinite",(function(){return M})),n.d(e,"isNaN",(function(){return D})),n.d(e,"isTypedArray",(function(){return V})),n.d(e,"isEmpty",(function(){return U})),n.d(e,"isMatch",(function(){return $})),n.d(e,"isEqual",(function(){return Y})),n.d(e,"isMap",(function(){return ot})),n.d(e,"isWeakMap",(function(){return at})),n.d(e,"isSet",(function(){return st})),n.d(e,"isWeakSet",(function(){return ct})),n.d(e,"keys",(function(){return B})),n.d(e,"allKeys",(function(){return X})),n.d(e,"values",(function(){return lt})),n.d(e,"pairs",(function(){return ut})),n.d(e,"invert",(function(){return dt})),n.d(e,"functions",(function(){return ht})),n.d(e,"methods",(function(){return ht})),n.d(e,"extend",(function(){return pt})),n.d(e,"extendOwn",(function(){return gt})),n.d(e,"assign",(function(){return gt})),n.d(e,"defaults",(function(){return vt})),n.d(e,"create",(function(){return yt})),n.d(e,"clone",(function(){return bt})),n.d(e,"tap",(function(){return wt})),n.d(e,"get",(function(){return kt})),n.d(e,"has",(function(){return St})),n.d(e,"mapObject",(function(){return At})),n.d(e,"identity",(function(){return jt})),n.d(e,"constant",(function(){return A})),n.d(e,"noop",(function(){return Lt})),n.d(e,"toPath",(function(){return Ot})),n.d(e,"property",(function(){return Pt})),n.d(e,"propertyOf",(function(){return Nt})),n.d(e,"matcher",(function(){return Tt})),n.d(e,"matches",(function(){return Tt})),n.d(e,"times",(function(){return Rt})),n.d(e,"random",(function(){return It})),n.d(e,"now",(function(){return Ft})),n.d(e,"escape",(function(){return Ht})),n.d(e,"unescape",(function(){return Bt})),n.d(e,"templateSettings",(function(){return Ut})),n.d(e,"template",(function(){return Yt})),n.d(e,"result",(function(){return Xt})),n.d(e,"uniqueId",(function(){return Zt})),n.d(e,"chain",(function(){return Qt})),n.d(e,"iteratee",(function(){return Mt})),n.d(e,"partial",(function(){return ne})),n.d(e,"bind",(function(){return re})),n.d(e,"bindAll",(function(){return ae})),n.d(e,"memoize",(function(){return se})),n.d(e,"delay",(function(){return ce})),n.d(e,"defer",(function(){return le})),n.d(e,"throttle",(function(){return ue})),n.d(e,"debounce",(function(){return de})),n.d(e,"wrap",(function(){return he})),n.d(e,"negate",(function(){return fe})),n.d(e,"compose",(function(){return pe})),n.d(e,"after",(function(){return ge})),n.d(e,"before",(function(){return ve})),n.d(e,"once",(function(){return me})),n.d(e,"findKey",(function(){return ye})),n.d(e,"findIndex",(function(){return we})),n.d(e,"findLastIndex",(function(){return Oe})),n.d(e,"sortedIndex",(function(){return xe})),n.d(e,"indexOf",(function(){return ke})),n.d(e,"lastIndexOf",(function(){return Se})),n.d(e,"find",(function(){return je})),n.d(e,"detect",(function(){return je})),n.d(e,"findWhere",(function(){return Te})),n.d(e,"each",(function(){return Pe})),n.d(e,"forEach",(function(){return Pe})),n.d(e,"map",(function(){return Ee})),n.d(e,"collect",(function(){return Ee})),n.d(e,"reduce",(function(){return Me})),n.d(e,"foldl",(function(){return Me})),n.d(e,"inject",(function(){return Me})),n.d(e,"reduceRight",(function(){return De})),n.d(e,"foldr",(function(){return De})),n.d(e,"filter",(function(){return Ae})),n.d(e,"select",(function(){return Ae})),n.d(e,"reject",(function(){return Le})),n.d(e,"every",(function(){return Ne})),n.d(e,"all",(function(){return Ne})),n.d(e,"some",(function(){return Re})),n.d(e,"any",(function(){return Re})),n.d(e,"contains",(function(){return Ie})),n.d(e,"includes",(function(){return Ie})),n.d(e,"include",(function(){return Ie})),n.d(e,"invoke",(function(){return Fe})),n.d(e,"pluck",(function(){return Ve})),n.d(e,"where",(function(){return ze})),n.d(e,"max",(function(){return He})),n.d(e,"min",(function(){return Be})),n.d(e,"shuffle",(function(){return $e})),n.d(e,"sample",(function(){return Ue})),n.d(e,"sortBy",(function(){return We})),n.d(e,"groupBy",(function(){return Ge})),n.d(e,"indexBy",(function(){return Ke})),n.d(e,"countBy",(function(){return Ye})),n.d(e,"partition",(function(){return Xe})),n.d(e,"toArray",(function(){return Ze})),n.d(e,"size",(function(){return Qe})),n.d(e,"pick",(function(){return en})),n.d(e,"omit",(function(){return nn})),n.d(e,"first",(function(){return on})),n.d(e,"head",(function(){return on})),n.d(e,"take",(function(){return on})),n.d(e,"initial",(function(){return rn})),n.d(e,"last",(function(){return sn})),n.d(e,"rest",(function(){return an})),n.d(e,"tail",(function(){return an})),n.d(e,"drop",(function(){return an})),n.d(e,"compact",(function(){return cn})),n.d(e,"flatten",(function(){return ln})),n.d(e,"without",(function(){return dn})),n.d(e,"uniq",(function(){return hn})),n.d(e,"unique",(function(){return hn})),n.d(e,"union",(function(){return fn})),n.d(e,"intersection",(function(){return pn})),n.d(e,"difference",(function(){return un})),n.d(e,"unzip",(function(){return gn})),n.d(e,"transpose",(function(){return gn})),n.d(e,"zip",(function(){return vn})),n.d(e,"object",(function(){return mn})),n.d(e,"range",(function(){return yn})),n.d(e,"chunk",(function(){return bn})),n.d(e,"mixin",(function(){return On}));var r={};n.r(r),n.d(r,"VERSION",(function(){return i["e"]})),n.d(r,"restArguments",(function(){return o})),n.d(r,"isObject",(function(){return a})),n.d(r,"isNull",(function(){return s})),n.d(r,"isUndefined",(function(){return c})),n.d(r,"isBoolean",(function(){return l})),n.d(r,"isElement",(function(){return u})),n.d(r,"isString",(function(){return h})),n.d(r,"isNumber",(function(){return f})),n.d(r,"isDate",(function(){return p})),n.d(r,"isRegExp",(function(){return g})),n.d(r,"isError",(function(){return v})),n.d(r,"isSymbol",(function(){return m})),n.d(r,"isArrayBuffer",(function(){return y})),n.d(r,"isDataView",(function(){return j})),n.d(r,"isArray",(function(){return T})),n.d(r,"isFunction",(function(){return O})),n.d(r,"isArguments",(function(){return _})),n.d(r,"isFinite",(function(){return M})),n.d(r,"isNaN",(function(){return D})),n.d(r,"isTypedArray",(function(){return V})),n.d(r,"isEmpty",(function(){return U})),n.d(r,"isMatch",(function(){return $})),n.d(r,"isEqual",(function(){return Y})),n.d(r,"isMap",(function(){return ot})),n.d(r,"isWeakMap",(function(){return at})),n.d(r,"isSet",(function(){return st})),n.d(r,"isWeakSet",(function(){return ct})),n.d(r,"keys",(function(){return B})),n.d(r,"allKeys",(function(){return X})),n.d(r,"values",(function(){return lt})),n.d(r,"pairs",(function(){return ut})),n.d(r,"invert",(function(){return dt})),n.d(r,"functions",(function(){return ht})),n.d(r,"methods",(function(){return ht})),n.d(r,"extend",(function(){return pt})),n.d(r,"extendOwn",(function(){return gt})),n.d(r,"assign",(function(){return gt})),n.d(r,"defaults",(function(){return vt})),n.d(r,"create",(function(){return yt})),n.d(r,"clone",(function(){return bt})),n.d(r,"tap",(function(){return wt})),n.d(r,"get",(function(){return kt})),n.d(r,"has",(function(){return St})),n.d(r,"mapObject",(function(){return At})),n.d(r,"identity",(function(){return jt})),n.d(r,"constant",(function(){return A})),n.d(r,"noop",(function(){return Lt})),n.d(r,"toPath",(function(){return Ot})),n.d(r,"property",(function(){return Pt})),n.d(r,"propertyOf",(function(){return Nt})),n.d(r,"matcher",(function(){return Tt})),n.d(r,"matches",(function(){return Tt})),n.d(r,"times",(function(){return Rt})),n.d(r,"random",(function(){return It})),n.d(r,"now",(function(){return Ft})),n.d(r,"escape",(function(){return Ht})),n.d(r,"unescape",(function(){return Bt})),n.d(r,"templateSettings",(function(){return Ut})),n.d(r,"template",(function(){return Yt})),n.d(r,"result",(function(){return Xt})),n.d(r,"uniqueId",(function(){return Zt})),n.d(r,"chain",(function(){return Qt})),n.d(r,"iteratee",(function(){return Mt})),n.d(r,"partial",(function(){return ne})),n.d(r,"bind",(function(){return re})),n.d(r,"bindAll",(function(){return ae})),n.d(r,"memoize",(function(){return se})),n.d(r,"delay",(function(){return ce})),n.d(r,"defer",(function(){return le})),n.d(r,"throttle",(function(){return ue})),n.d(r,"debounce",(function(){return de})),n.d(r,"wrap",(function(){return he})),n.d(r,"negate",(function(){return fe})),n.d(r,"compose",(function(){return pe})),n.d(r,"after",(function(){return ge})),n.d(r,"before",(function(){return ve})),n.d(r,"once",(function(){return me})),n.d(r,"findKey",(function(){return ye})),n.d(r,"findIndex",(function(){return we})),n.d(r,"findLastIndex",(function(){return Oe})),n.d(r,"sortedIndex",(function(){return xe})),n.d(r,"indexOf",(function(){return ke})),n.d(r,"lastIndexOf",(function(){return Se})),n.d(r,"find",(function(){return je})),n.d(r,"detect",(function(){return je})),n.d(r,"findWhere",(function(){return Te})),n.d(r,"each",(function(){return Pe})),n.d(r,"forEach",(function(){return Pe})),n.d(r,"map",(function(){return Ee})),n.d(r,"collect",(function(){return Ee})),n.d(r,"reduce",(function(){return Me})),n.d(r,"foldl",(function(){return Me})),n.d(r,"inject",(function(){return Me})),n.d(r,"reduceRight",(function(){return De})),n.d(r,"foldr",(function(){return De})),n.d(r,"filter",(function(){return Ae})),n.d(r,"select",(function(){return Ae})),n.d(r,"reject",(function(){return Le})),n.d(r,"every",(function(){return Ne})),n.d(r,"all",(function(){return Ne})),n.d(r,"some",(function(){return Re})),n.d(r,"any",(function(){return Re})),n.d(r,"contains",(function(){return Ie})),n.d(r,"includes",(function(){return Ie})),n.d(r,"include",(function(){return Ie})),n.d(r,"invoke",(function(){return Fe})),n.d(r,"pluck",(function(){return Ve})),n.d(r,"where",(function(){return ze})),n.d(r,"max",(function(){return He})),n.d(r,"min",(function(){return Be})),n.d(r,"shuffle",(function(){return $e})),n.d(r,"sample",(function(){return Ue})),n.d(r,"sortBy",(function(){return We})),n.d(r,"groupBy",(function(){return Ge})),n.d(r,"indexBy",(function(){return Ke})),n.d(r,"countBy",(function(){return Ye})),n.d(r,"partition",(function(){return Xe})),n.d(r,"toArray",(function(){return Ze})),n.d(r,"size",(function(){return Qe})),n.d(r,"pick",(function(){return en})),n.d(r,"omit",(function(){return nn})),n.d(r,"first",(function(){return on})),n.d(r,"head",(function(){return on})),n.d(r,"take",(function(){return on})),n.d(r,"initial",(function(){return rn})),n.d(r,"last",(function(){return sn})),n.d(r,"rest",(function(){return an})),n.d(r,"tail",(function(){return an})),n.d(r,"drop",(function(){return an})),n.d(r,"compact",(function(){return cn})),n.d(r,"flatten",(function(){return ln})),n.d(r,"without",(function(){return dn})),n.d(r,"uniq",(function(){return hn})),n.d(r,"unique",(function(){return hn})),n.d(r,"union",(function(){return fn})),n.d(r,"intersection",(function(){return pn})),n.d(r,"difference",(function(){return un})),n.d(r,"unzip",(function(){return gn})),n.d(r,"transpose",(function(){return gn})),n.d(r,"zip",(function(){return vn})),n.d(r,"object",(function(){return mn})),n.d(r,"range",(function(){return yn})),n.d(r,"chunk",(function(){return bn})),n.d(r,"mixin",(function(){return On})),n.d(r,"default",(function(){return xn}));var i=n(7);function o(t,e){return e=null==e?t.length-1:+e,function(){for(var n=Math.max(arguments.length-e,0),r=Array(n),i=0;i<n;i++)r[i]=arguments[i+e];switch(e){case 0:return t.call(this,r);case 1:return t.call(this,arguments[0],r);case 2:return t.call(this,arguments[0],arguments[1],r)}var o=Array(e+1);for(i=0;i<e;i++)o[i]=arguments[i];return o[e]=r,t.apply(this,o)}}function a(t){var e=typeof t;return'function'===e||'object'===e&&!!t}function s(t){return null===t}function c(t){return void 0===t}function l(t){return!0===t||!1===t||'[object Boolean]'===i["t"].call(t)}function u(t){return!(!t||1!==t.nodeType)}function d(t){var e='[object '+t+']';return function(t){return i["t"].call(t)===e}}var h=d('String'),f=d('Number'),p=d('Date'),g=d('RegExp'),v=d('Error'),m=d('Symbol'),y=d('ArrayBuffer'),b=d('Function'),w=i["p"].document&&i["p"].document.childNodes; true&&'object'!=typeof Int8Array&&'function'!=typeof w&&(b=function(t){return'function'==typeof t||!1});var O=b,x=d('Object'),C=i["s"]&&x(new DataView(new ArrayBuffer(8))),k='undefined'!=typeof Map&&x(new Map),S=d('DataView');var j=C?function(t){return null!=t&&O(t.getInt8)&&y(t.buffer)}:S,T=i["k"]||d('Array');function P(t,e){return null!=t&&i["i"].call(t,e)}var E=d('Arguments');!function(){E(arguments)||(E=function(t){return P(t,'callee')})}();var _=E;function M(t){return!m(t)&&Object(i["f"])(t)&&!isNaN(parseFloat(t))}function D(t){return f(t)&&Object(i["g"])(t)}function A(t){return function(){return t}}function L(t){return function(e){var n=t(e);return'number'==typeof n&&n>=0&&n<=i["b"]}}function N(t){return function(e){return null==e?void 0:e[t]}}var R=N('byteLength'),I=L(R),F=/\[object ((I|Ui)nt(8|16|32)|Float(32|64)|Uint8Clamped|Big(I|Ui)nt64)Array\]/;var V=i["r"]?function(t){return i["l"]?Object(i["l"])(t)&&!j(t):I(t)&&F.test(i["t"].call(t))}:A(!1),z=N('length');function H(t,e){e=function(t){for(var e={},n=t.length,r=0;r<n;++r)e[t[r]]=!0;return{contains:function(t){return e[t]},push:function(n){return e[n]=!0,t.push(n)}}}(e);var n=i["n"].length,r=t.constructor,o=O(r)&&r.prototype||i["c"],a='constructor';for(P(t,a)&&!e.contains(a)&&e.push(a);n--;)(a=i["n"][n])in t&&t[a]!==o[a]&&!e.contains(a)&&e.push(a)}function B(t){if(!a(t))return[];if(i["m"])return Object(i["m"])(t);var e=[];for(var n in t)P(t,n)&&e.push(n);return i["h"]&&H(t,e),e}function U(t){if(null==t)return!0;var e=z(t);return'number'==typeof e&&(T(t)||h(t)||_(t))?0===e:0===z(B(t))}function $(t,e){var n=B(e),r=n.length;if(null==t)return!r;for(var i=Object(t),o=0;o<r;o++){var a=n[o];if(e[a]!==i[a]||!(a in i))return!1}return!0}function W(t){return t instanceof W?t:this instanceof W?void(this._wrapped=t):new W(t)}function q(t){return new Uint8Array(t.buffer||t,t.byteOffset||0,R(t))}W.VERSION=i["e"],W.prototype.value=function(){return this._wrapped},W.prototype.valueOf=W.prototype.toJSON=W.prototype.value,W.prototype.toString=function(){return String(this._wrapped)};var G='[object DataView]';function K(t,e,n,r){if(t===e)return 0!==t||1/t==1/e;if(null==t||null==e)return!1;if(t!=t)return e!=e;var o=typeof t;return('function'===o||'object'===o||'object'==typeof e)&&function t(e,n,r,o){e instanceof W&&(e=e._wrapped);n instanceof W&&(n=n._wrapped);var a=i["t"].call(e);if(a!==i["t"].call(n))return!1;if(C&&'[object Object]'==a&&j(e)){if(!j(n))return!1;a=G}switch(a){case'[object RegExp]':case'[object String]':return''+e==''+n;case'[object Number]':return+e!=+e?+n!=+n:0==+e?1/+e==1/n:+e==+n;case'[object Date]':case'[object Boolean]':return+e==+n;case'[object Symbol]':return i["d"].valueOf.call(e)===i["d"].valueOf.call(n);case'[object ArrayBuffer]':case G:return t(q(e),q(n),r,o)}var s='[object Array]'===a;if(!s&&V(e)){if(R(e)!==R(n))return!1;if(e.buffer===n.buffer&&e.byteOffset===n.byteOffset)return!0;s=!0}if(!s){if('object'!=typeof e||'object'!=typeof n)return!1;var c=e.constructor,l=n.constructor;if(c!==l&&!(O(c)&&c instanceof c&&O(l)&&l instanceof l)&&'constructor'in e&&'constructor'in n)return!1}o=o||[];var u=(r=r||[]).length;for(;u--;)if(r[u]===e)return o[u]===n;if(r.push(e),o.push(n),s){if((u=e.length)!==n.length)return!1;for(;u--;)if(!K(e[u],n[u],r,o))return!1}else{var d,h=B(e);if(u=h.length,B(n).length!==u)return!1;for(;u--;)if(d=h[u],!P(n,d)||!K(e[d],n[d],r,o))return!1}return r.pop(),o.pop(),!0}(t,e,n,r)}function Y(t,e){return K(t,e)}function X(t){if(!a(t))return[];var e=[];for(var n in t)e.push(n);return i["h"]&&H(t,e),e}function J(t){var e=z(t);return function(n){if(null==n)return!1;var r=X(n);if(z(r))return!1;for(var i=0;i<e;i++)if(!O(n[t[i]]))return!1;return t!==rt||!O(n[Z])}}var Z='forEach',Q='has',tt=['clear','delete'],et=['get',Q,'set'],nt=tt.concat(Z,et),rt=tt.concat(et),it=['add'].concat(tt,Z,Q),ot=k?J(nt):d('Map'),at=k?J(rt):d('WeakMap'),st=k?J(it):d('Set'),ct=d('WeakSet');function lt(t){for(var e=B(t),n=e.length,r=Array(n),i=0;i<n;i++)r[i]=t[e[i]];return r}function ut(t){for(var e=B(t),n=e.length,r=Array(n),i=0;i<n;i++)r[i]=[e[i],t[e[i]]];return r}function dt(t){for(var e={},n=B(t),r=0,i=n.length;r<i;r++)e[t[n[r]]]=n[r];return e}function ht(t){var e=[];for(var n in t)O(t[n])&&e.push(n);return e.sort()}function ft(t,e){return function(n){var r=arguments.length;if(e&&(n=Object(n)),r<2||null==n)return n;for(var i=1;i<r;i++)for(var o=arguments[i],a=t(o),s=a.length,c=0;c<s;c++){var l=a[c];e&&void 0!==n[l]||(n[l]=o[l])}return n}}var pt=ft(X),gt=ft(B),vt=ft(X,!0);function mt(t){if(!a(t))return{};if(i["j"])return Object(i["j"])(t);var e=function(){};e.prototype=t;var n=new e;return e.prototype=null,n}function yt(t,e){var n=mt(t);return e&&gt(n,e),n}function bt(t){return a(t)?T(t)?t.slice():pt({},t):t}function wt(t,e){return e(t),t}function Ot(t){return T(t)?t:[t]}function xt(t){return W.toPath(t)}function Ct(t,e){for(var n=e.length,r=0;r<n;r++){if(null==t)return;t=t[e[r]]}return n?t:void 0}function kt(t,e,n){var r=Ct(t,xt(e));return c(r)?n:r}function St(t,e){for(var n=(e=xt(e)).length,r=0;r<n;r++){var i=e[r];if(!P(t,i))return!1;t=t[i]}return!!n}function jt(t){return t}function Tt(t){return t=gt({},t),function(e){return $(e,t)}}function Pt(t){return t=xt(t),function(e){return Ct(e,t)}}function Et(t,e,n){if(void 0===e)return t;switch(null==n?3:n){case 1:return function(n){return t.call(e,n)};case 3:return function(n,r,i){return t.call(e,n,r,i)};case 4:return function(n,r,i,o){return t.call(e,n,r,i,o)}}return function(){return t.apply(e,arguments)}}function _t(t,e,n){return null==t?jt:O(t)?Et(t,e,n):a(t)&&!T(t)?Tt(t):Pt(t)}function Mt(t,e){return _t(t,e,1/0)}function Dt(t,e,n){return W.iteratee!==Mt?W.iteratee(t,e):_t(t,e,n)}function At(t,e,n){e=Dt(e,n);for(var r=B(t),i=r.length,o={},a=0;a<i;a++){var s=r[a];o[s]=e(t[s],s,t)}return o}function Lt(){}function Nt(t){return null==t?Lt:function(e){return kt(t,e)}}function Rt(t,e,n){var r=Array(Math.max(0,t));e=Et(e,n,1);for(var i=0;i<t;i++)r[i]=e(i);return r}function It(t,e){return null==e&&(e=t,t=0),t+Math.floor(Math.random()*(e-t+1))}W.toPath=Ot,W.iteratee=Mt;var Ft=Date.now||function(){return(new Date).getTime()};function Vt(t){var e=function(e){return t[e]},n='(?:'+B(t).join('|')+')',r=RegExp(n),i=RegExp(n,'g');return function(t){return t=null==t?'':''+t,r.test(t)?t.replace(i,e):t}}var zt={'&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;',"'":'&#x27;','`':'&#x60;'},Ht=Vt(zt),Bt=Vt(dt(zt)),Ut=W.templateSettings={evaluate:/<%([\s\S]+?)%>/g,interpolate:/<%=([\s\S]+?)%>/g,escape:/<%-([\s\S]+?)%>/g},$t=/(.)^/,Wt={"'":"'",'\\':'\\','\r':'r','\n':'n','\u2028':'u2028','\u2029':'u2029'},qt=/\\|'|\r|\n|\u2028|\u2029/g;function Gt(t){return'\\'+Wt[t]}var Kt=/^\s*(\w|\$)+\s*$/;function Yt(t,e,n){!e&&n&&(e=n),e=vt({},e,W.templateSettings);var r=RegExp([(e.escape||$t).source,(e.interpolate||$t).source,(e.evaluate||$t).source].join('|')+'|$','g'),i=0,o="__p+='";t.replace(r,(function(e,n,r,a,s){return o+=t.slice(i,s).replace(qt,Gt),i=s+e.length,n?o+="'+\n((__t=("+n+"))==null?'':_.escape(__t))+\n'":r?o+="'+\n((__t=("+r+"))==null?'':__t)+\n'":a&&(o+="';\n"+a+"\n__p+='"),e})),o+="';\n";var a,s=e.variable;if(s){if(!Kt.test(s))throw new Error('variable is not a bare identifier: '+s)}else o='with(obj||{}){\n'+o+'}\n',s='obj';o="var __t,__p='',__j=Array.prototype.join,"+"print=function(){__p+=__j.call(arguments,'');};\n"+o+'return __p;\n';try{a=new Function(s,'_',o)}catch(t){throw t.source=o,t}var c=function(t){return a.call(this,t,W)};return c.source='function('+s+'){\n'+o+'}',c}function Xt(t,e,n){var r=(e=xt(e)).length;if(!r)return O(n)?n.call(t):n;for(var i=0;i<r;i++){var o=null==t?void 0:t[e[i]];void 0===o&&(o=n,i=r),t=O(o)?o.call(t):o}return t}var Jt=0;function Zt(t){var e=++Jt+'';return t?t+e:e}function Qt(t){var e=W(t);return e._chain=!0,e}function te(t,e,n,r,i){if(!(r instanceof e))return t.apply(n,i);var o=mt(t.prototype),s=t.apply(o,i);return a(s)?s:o}var ee=o((function(t,e){var n=ee.placeholder,r=function(){for(var i=0,o=e.length,a=Array(o),s=0;s<o;s++)a[s]=e[s]===n?arguments[i++]:e[s];for(;i<arguments.length;)a.push(arguments[i++]);return te(t,r,this,this,a)};return r}));ee.placeholder=W;var ne=ee,re=o((function(t,e,n){if(!O(t))throw new TypeError('Bind must be called on a function');var r=o((function(i){return te(t,r,e,this,n.concat(i))}));return r})),ie=L(z);function oe(t,e,n,r){if(r=r||[],e||0===e){if(e<=0)return r.concat(t)}else e=1/0;for(var i=r.length,o=0,a=z(t);o<a;o++){var s=t[o];if(ie(s)&&(T(s)||_(s)))if(e>1)oe(s,e-1,n,r),i=r.length;else for(var c=0,l=s.length;c<l;)r[i++]=s[c++];else n||(r[i++]=s)}return r}var ae=o((function(t,e){var n=(e=oe(e,!1,!1)).length;if(n<1)throw new Error('bindAll must be passed function names');for(;n--;){var r=e[n];t[r]=re(t[r],t)}return t}));function se(t,e){var n=function(r){var i=n.cache,o=''+(e?e.apply(this,arguments):r);return P(i,o)||(i[o]=t.apply(this,arguments)),i[o]};return n.cache={},n}var ce=o((function(t,e,n){return setTimeout((function(){return t.apply(null,n)}),e)})),le=ne(ce,W,1);function ue(t,e,n){var r,i,o,a,s=0;n||(n={});var c=function(){s=!1===n.leading?0:Ft(),r=null,a=t.apply(i,o),r||(i=o=null)},l=function(){var l=Ft();s||!1!==n.leading||(s=l);var u=e-(l-s);return i=this,o=arguments,u<=0||u>e?(r&&(clearTimeout(r),r=null),s=l,a=t.apply(i,o),r||(i=o=null)):r||!1===n.trailing||(r=setTimeout(c,u)),a};return l.cancel=function(){clearTimeout(r),s=0,r=i=o=null},l}function de(t,e,n){var r,i,a,s,c,l=function(){var o=Ft()-i;e>o?r=setTimeout(l,e-o):(r=null,n||(s=t.apply(c,a)),r||(a=c=null))},u=o((function(o){return c=this,a=o,i=Ft(),r||(r=setTimeout(l,e),n&&(s=t.apply(c,a))),s}));return u.cancel=function(){clearTimeout(r),r=a=c=null},u}function he(t,e){return ne(e,t)}function fe(t){return function(){return!t.apply(this,arguments)}}function pe(){var t=arguments,e=t.length-1;return function(){for(var n=e,r=t[e].apply(this,arguments);n--;)r=t[n].call(this,r);return r}}function ge(t,e){return function(){if(--t<1)return e.apply(this,arguments)}}function ve(t,e){var n;return function(){return--t>0&&(n=e.apply(this,arguments)),t<=1&&(e=null),n}}var me=ne(ve,2);function ye(t,e,n){e=Dt(e,n);for(var r,i=B(t),o=0,a=i.length;o<a;o++)if(e(t[r=i[o]],r,t))return r}function be(t){return function(e,n,r){n=Dt(n,r);for(var i=z(e),o=t>0?0:i-1;o>=0&&o<i;o+=t)if(n(e[o],o,e))return o;return-1}}var we=be(1),Oe=be(-1);function xe(t,e,n,r){for(var i=(n=Dt(n,r,1))(e),o=0,a=z(t);o<a;){var s=Math.floor((o+a)/2);n(t[s])<i?o=s+1:a=s}return o}function Ce(t,e,n){return function(r,o,a){var s=0,c=z(r);if('number'==typeof a)t>0?s=a>=0?a:Math.max(a+c,s):c=a>=0?Math.min(a+1,c):a+c+1;else if(n&&a&&c)return r[a=n(r,o)]===o?a:-1;if(o!=o)return(a=e(i["q"].call(r,s,c),D))>=0?a+s:-1;for(a=t>0?s:c-1;a>=0&&a<c;a+=t)if(r[a]===o)return a;return-1}}var ke=Ce(1,we,xe),Se=Ce(-1,Oe);function je(t,e,n){var r=(ie(t)?we:ye)(t,e,n);if(void 0!==r&&-1!==r)return t[r]}function Te(t,e){return je(t,Tt(e))}function Pe(t,e,n){var r,i;if(e=Et(e,n),ie(t))for(r=0,i=t.length;r<i;r++)e(t[r],r,t);else{var o=B(t);for(r=0,i=o.length;r<i;r++)e(t[o[r]],o[r],t)}return t}function Ee(t,e,n){e=Dt(e,n);for(var r=!ie(t)&&B(t),i=(r||t).length,o=Array(i),a=0;a<i;a++){var s=r?r[a]:a;o[a]=e(t[s],s,t)}return o}function _e(t){var e=function(e,n,r,i){var o=!ie(e)&&B(e),a=(o||e).length,s=t>0?0:a-1;for(i||(r=e[o?o[s]:s],s+=t);s>=0&&s<a;s+=t){var c=o?o[s]:s;r=n(r,e[c],c,e)}return r};return function(t,n,r,i){var o=arguments.length>=3;return e(t,Et(n,i,4),r,o)}}var Me=_e(1),De=_e(-1);function Ae(t,e,n){var r=[];return e=Dt(e,n),Pe(t,(function(t,n,i){e(t,n,i)&&r.push(t)})),r}function Le(t,e,n){return Ae(t,fe(Dt(e)),n)}function Ne(t,e,n){e=Dt(e,n);for(var r=!ie(t)&&B(t),i=(r||t).length,o=0;o<i;o++){var a=r?r[o]:o;if(!e(t[a],a,t))return!1}return!0}function Re(t,e,n){e=Dt(e,n);for(var r=!ie(t)&&B(t),i=(r||t).length,o=0;o<i;o++){var a=r?r[o]:o;if(e(t[a],a,t))return!0}return!1}function Ie(t,e,n,r){return ie(t)||(t=lt(t)),('number'!=typeof n||r)&&(n=0),ke(t,e,n)>=0}var Fe=o((function(t,e,n){var r,i;return O(e)?i=e:(e=xt(e),r=e.slice(0,-1),e=e[e.length-1]),Ee(t,(function(t){var o=i;if(!o){if(r&&r.length&&(t=Ct(t,r)),null==t)return;o=t[e]}return null==o?o:o.apply(t,n)}))}));function Ve(t,e){return Ee(t,Pt(e))}function ze(t,e){return Ae(t,Tt(e))}function He(t,e,n){var r,i,o=-1/0,a=-1/0;if(null==e||'number'==typeof e&&'object'!=typeof t[0]&&null!=t)for(var s=0,c=(t=ie(t)?t:lt(t)).length;s<c;s++)null!=(r=t[s])&&r>o&&(o=r);else e=Dt(e,n),Pe(t,(function(t,n,r){((i=e(t,n,r))>a||i===-1/0&&o===-1/0)&&(o=t,a=i)}));return o}function Be(t,e,n){var r,i,o=1/0,a=1/0;if(null==e||'number'==typeof e&&'object'!=typeof t[0]&&null!=t)for(var s=0,c=(t=ie(t)?t:lt(t)).length;s<c;s++)null!=(r=t[s])&&r<o&&(o=r);else e=Dt(e,n),Pe(t,(function(t,n,r){((i=e(t,n,r))<a||i===1/0&&o===1/0)&&(o=t,a=i)}));return o}function Ue(t,e,n){if(null==e||n)return ie(t)||(t=lt(t)),t[It(t.length-1)];var r=ie(t)?bt(t):lt(t),i=z(r);e=Math.max(Math.min(e,i),0);for(var o=i-1,a=0;a<e;a++){var s=It(a,o),c=r[a];r[a]=r[s],r[s]=c}return r.slice(0,e)}function $e(t){return Ue(t,1/0)}function We(t,e,n){var r=0;return e=Dt(e,n),Ve(Ee(t,(function(t,n,i){return{value:t,index:r++,criteria:e(t,n,i)}})).sort((function(t,e){var n=t.criteria,r=e.criteria;if(n!==r){if(n>r||void 0===n)return 1;if(n<r||void 0===r)return-1}return t.index-e.index})),'value')}function qe(t,e){return function(n,r,i){var o=e?[[],[]]:{};return r=Dt(r,i),Pe(n,(function(e,i){var a=r(e,i,n);t(o,e,a)})),o}}var Ge=qe((function(t,e,n){P(t,n)?t[n].push(e):t[n]=[e]})),Ke=qe((function(t,e,n){t[n]=e})),Ye=qe((function(t,e,n){P(t,n)?t[n]++:t[n]=1})),Xe=qe((function(t,e,n){t[n?0:1].push(e)}),!0),Je=/[^\ud800-\udfff]|[\ud800-\udbff][\udc00-\udfff]|[\ud800-\udfff]/g;function Ze(t){return t?T(t)?i["q"].call(t):h(t)?t.match(Je):ie(t)?Ee(t,jt):lt(t):[]}function Qe(t){return null==t?0:ie(t)?t.length:B(t).length}function tn(t,e,n){return e in n}var en=o((function(t,e){var n={},r=e[0];if(null==t)return n;O(r)?(e.length>1&&(r=Et(r,e[1])),e=X(t)):(r=tn,e=oe(e,!1,!1),t=Object(t));for(var i=0,o=e.length;i<o;i++){var a=e[i],s=t[a];r(s,a,t)&&(n[a]=s)}return n})),nn=o((function(t,e){var n,r=e[0];return O(r)?(r=fe(r),e.length>1&&(n=e[1])):(e=Ee(oe(e,!1,!1),String),r=function(t,n){return!Ie(e,n)}),en(t,r,n)}));function rn(t,e,n){return i["q"].call(t,0,Math.max(0,t.length-(null==e||n?1:e)))}function on(t,e,n){return null==t||t.length<1?null==e||n?void 0:[]:null==e||n?t[0]:rn(t,t.length-e)}function an(t,e,n){return i["q"].call(t,null==e||n?1:e)}function sn(t,e,n){return null==t||t.length<1?null==e||n?void 0:[]:null==e||n?t[t.length-1]:an(t,Math.max(0,t.length-e))}function cn(t){return Ae(t,Boolean)}function ln(t,e){return oe(t,e,!1)}var un=o((function(t,e){return e=oe(e,!0,!0),Ae(t,(function(t){return!Ie(e,t)}))})),dn=o((function(t,e){return un(t,e)}));function hn(t,e,n,r){l(e)||(r=n,n=e,e=!1),null!=n&&(n=Dt(n,r));for(var i=[],o=[],a=0,s=z(t);a<s;a++){var c=t[a],u=n?n(c,a,t):c;e&&!n?(a&&o===u||i.push(c),o=u):n?Ie(o,u)||(o.push(u),i.push(c)):Ie(i,c)||i.push(c)}return i}var fn=o((function(t){return hn(oe(t,!0,!0))}));function pn(t){for(var e=[],n=arguments.length,r=0,i=z(t);r<i;r++){var o=t[r];if(!Ie(e,o)){var a;for(a=1;a<n&&Ie(arguments[a],o);a++);a===n&&e.push(o)}}return e}function gn(t){for(var e=t&&He(t,z).length||0,n=Array(e),r=0;r<e;r++)n[r]=Ve(t,r);return n}var vn=o(gn);function mn(t,e){for(var n={},r=0,i=z(t);r<i;r++)e?n[t[r]]=e[r]:n[t[r][0]]=t[r][1];return n}function yn(t,e,n){null==e&&(e=t||0,t=0),n||(n=e<t?-1:1);for(var r=Math.max(Math.ceil((e-t)/n),0),i=Array(r),o=0;o<r;o++,t+=n)i[o]=t;return i}function bn(t,e){if(null==e||e<1)return[];for(var n=[],r=0,o=t.length;r<o;)n.push(i["q"].call(t,r,r+=e));return n}function wn(t,e){return t._chain?W(e).chain():e}function On(t){return Pe(ht(t),(function(e){var n=W[e]=t[e];W.prototype[e]=function(){var t=[this._wrapped];return i["o"].apply(t,arguments),wn(this,n.apply(W,t))}})),W}Pe(['pop','push','reverse','shift','sort','splice','unshift'],(function(t){var e=i["a"][t];W.prototype[t]=function(){var n=this._wrapped;return null!=n&&(e.apply(n,arguments),'shift'!==t&&'splice'!==t||0!==n.length||delete n[0]),wn(this,n)}})),Pe(['concat','join','slice'],(function(t){var e=i["a"][t];W.prototype[t]=function(){var t=this._wrapped;return null!=t&&(t=e.apply(t,arguments)),wn(this,t)}}));var xn=W,Cn=On(r);Cn._=Cn;var kn=Cn},function(t,e,n){"use strict";n.r(e),n.d(e,"hasWin",(function(){return c})),n.d(e,"toLowerCase",(function(){return l})),n.d(e,"getUiClass",(function(){return h})),n.d(e,"isCommentNode",(function(){return k})),n.d(e,"isTaggableNode",(function(){return S})),n.d(e,"find",(function(){return j})),n.d(e,"escape",(function(){return T})),n.d(e,"on",(function(){return g})),n.d(e,"off",(function(){return v})),n.d(e,"hasDnd",(function(){return O})),n.d(e,"upFirst",(function(){return y})),n.d(e,"matches",(function(){return d})),n.d(e,"getModel",(function(){return P})),n.d(e,"getElRect",(function(){return E})),n.d(e,"camelCase",(function(){return b})),n.d(e,"isTextNode",(function(){return C})),n.d(e,"getKeyCode",(function(){return M})),n.d(e,"getKeyChar",(function(){return D})),n.d(e,"isEscKey",(function(){return A})),n.d(e,"isEnterKey",(function(){return L})),n.d(e,"getElement",(function(){return x})),n.d(e,"shallowDiff",(function(){return p})),n.d(e,"normalizeFloat",(function(){return w})),n.d(e,"getPointerEvent",(function(){return _})),n.d(e,"getUnitFromValue",(function(){return m})),n.d(e,"capitalize",(function(){return I})),n.d(e,"getViewEl",(function(){return z})),n.d(e,"setViewEl",(function(){return H})),n.d(e,"appendStyles",(function(){return f})),n.d(e,"isObject",(function(){return N})),n.d(e,"isEmptyObj",(function(){return R})),n.d(e,"isComponent",(function(){return F})),n.d(e,"createId",(function(){return B})),n.d(e,"isRule",(function(){return V}));var r=n(14),i=n.n(r),o=n(11),a=n.n(o),s=n(0),c=function(){return'undefined'!=typeof window},l=function(t){return(t||'').toLowerCase()},u=c()?window.Element.prototype:{},d=u.matches||u.webkitMatchesSelector||u.mozMatchesSelector||u.msMatchesSelector,h=function(t,e){var n=t.getConfig(),r=n.stylePrefix;return[n.customUI&&"".concat(r,"cui"),e].filter((function(t){return t})).join(' ')},f=function t(e){var n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},r=Object(s["isArray"])(e)?a()(e):[e];if(r.length){var i=r.shift();if(i&&(!n.unique||!document.querySelector("link[href=\"".concat(i,"\"]")))){var o=document,c=o.head,l=document.createElement('link');l.href=i,l.rel='stylesheet',n.prepand?c.insertBefore(l,c.firstChild):c.appendChild(l)}t(r)}},p=function(t,e){var n={},r=Object(s["keys"])(e);for(var i in t)if(t.hasOwnProperty(i)){var o=t[i],a=e[i];r.indexOf(i)>=0?o!==a&&(n[i]=a):n[i]=null}for(var c in e)e.hasOwnProperty(c)&&Object(s["isUndefined"])(t[c])&&(n[c]=e[c]);return n},g=function(t,e,n,r){e=e.split(/\s+/),t=t instanceof Array?t:[t];for(var i=function(i){t.forEach((function(t){return t&&t.addEventListener(e[i],n,r)}))},o=0;o<e.length;++o)i(o)},v=function(t,e,n,r){e=e.split(/\s+/),t=t instanceof Array?t:[t];for(var i=function(i){t.forEach((function(t){return t&&t.removeEventListener(e[i],n,r)}))},o=0;o<e.length;++o)i(o)},m=function(t){return t.replace(parseFloat(t),'')},y=function(t){return t[0].toUpperCase()+t.toLowerCase().slice(1)},b=function(t){var e=t.split('-').filter(String);return e[0].toLowerCase()+e.slice(1).map(y)},w=function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:1,n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:0,r=0;if(isNaN(t))return n;if(t=parseFloat(t),Math.floor(t)!==t){var i=e.toString().split('.')[1];r=i?i.length:0}return r?parseFloat(t.toFixed(r)):t},O=function(t){return'draggable'in document.createElement('i')&&(t?t.get('Config').nativeDnD:1)},x=function(t){return Object(s["isElement"])(t)||C(t)?t:t&&t.getEl?t.getEl():void 0},C=function(t){return t&&3===t.nodeType},k=function(t){return t&&8===t.nodeType},S=function(t){return t&&!C(t)&&!k(t)},j=function(t,e){var n=null;return t.some((function(r,i){return e(r,i,t)?(n=r,1):0})),n},T=function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:'';return"".concat(t).replace(/&/g,'&amp;').replace(/</g,'&lt;').replace(/>/g,'&gt;').replace(/"/g,'&quot;').replace(/'/g,'&#039;').replace(/`/g,'&#96;')},P=function(t,e){var n=t;return Object(s["isElement"])(t)&&(n=e(t).data('model')),n},E=function(t){var e,n={top:0,left:0,width:0,height:0};if(!t)return n;if(C(t)){var r=document.createRange();r.selectNode(t),e=r.getBoundingClientRect(),r.detach()}return e||(t.getBoundingClientRect?t.getBoundingClientRect():n)},_=function(t){return t.touches&&t.touches[0]?t.touches[0]:t},M=function(t){return t.which||t.keyCode},D=function(t){return String.fromCharCode(M(t))},A=function(t){return 27===M(t)},L=function(t){return 13===M(t)},N=function(t){return null!==t&&!Array.isArray(t)&&'object'===i()(t)},R=function(t){return Object.keys(t).length<=0},I=function(t){return t&&t.charAt(0).toUpperCase()+t.substring(1)},F=function(t){return t&&t.toHTML},V=function(t){return t&&t.toCSS},z=function(t){return t.__gjsv},H=function(t,e){t.__gjsv=e},B=function(){for(var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:16,e='',n='ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789',r=n.length,i=0;i<t;i++)e+=n.charAt(Math.floor(Math.random()*r));return e}},function(t,e,n){(function(r){var i,o;!function(a){var s='object'==typeof self&&self.self===self&&self||'object'==typeof r&&r.global===r&&r;if(true)i=[n(0),n(18),e],void 0===(o=function(t,e,n){s.Backbone=function(t,e,n,r){var i=t.Backbone,o=Array.prototype.slice;e.VERSION='1.3.3',e.$=r,e.noConflict=function(){return t.Backbone=i,this},e.emulateHTTP=!1,e.emulateJSON=!1;var a=function(t,e,r){n.each(e,(function(e,i){n[i]&&(t.prototype[i]=function(t,e,r){switch(t){case 1:return function(){return n[e](this[r])};case 2:return function(t){return n[e](this[r],t)};case 3:return function(t,i){return n[e](this[r],s(t,this),i)};case 4:return function(t,i,o){return n[e](this[r],s(t,this),i,o)};default:return function(){var t=o.call(arguments);return t.unshift(this[r]),n[e].apply(n,t)}}}(e,i,r))}))},s=function(t,e){return n.isFunction(t)?t:n.isObject(t)&&!e._isModel(t)?c(t):n.isString(t)?function(e){return e.get(t)}:t},c=function(t){var e=n.matches(t);return function(t){return e(t.attributes)}},l=e.Events={},u=/\s+/,d=function(t,e,r,i,o){var a,s=0;if(r&&'object'==typeof r){void 0!==i&&'context'in o&&void 0===o.context&&(o.context=i);for(a=n.keys(r);s<a.length;s++)e=d(t,e,a[s],r[a[s]],o)}else if(r&&u.test(r))for(a=r.split(u);s<a.length;s++)e=t(e,a[s],i,o);else e=t(e,r,i,o);return e};l.on=function(t,e,n){return h(this,t,e,n)};var h=function(t,e,n,r,i){(t._events=d(f,t._events||{},e,n,{context:r,ctx:t,listening:i}),i)&&((t._listeners||(t._listeners={}))[i.id]=i);return t};l.listenTo=function(t,e,r){if(!t)return this;var i=t._listenId||(t._listenId=n.uniqueId('l')),o=this._listeningTo||(this._listeningTo={}),a=o[i];if(!a){var s=this._listenId||(this._listenId=n.uniqueId('l'));a=o[i]={obj:t,objId:i,id:s,listeningTo:o,count:0}}return h(t,e,r,this,a),this};var f=function(t,e,n,r){if(n){var i=t[e]||(t[e]=[]),o=r.context,a=r.ctx,s=r.listening;s&&s.count++,i.push({callback:n,context:o,ctx:o||a,listening:s})}return t};l.off=function(t,e,n){return this._events?(this._events=d(p,this._events,t,e,{context:n,listeners:this._listeners}),this):this},l.stopListening=function(t,e,r){var i=this._listeningTo;if(!i)return this;for(var o=t?[t._listenId]:n.keys(i),a=0;a<o.length;a++){var s=i[o[a]];if(!s)break;s.obj.off(e,r,this)}return this};var p=function(t,e,r,i){if(t){var o,a=0,s=i.context,c=i.listeners;if(e||r||s){for(var l=e?[e]:n.keys(t);a<l.length;a++){var u=t[e=l[a]];if(!u)break;for(var d=[],h=0;h<u.length;h++){var f=u[h];r&&r!==f.callback&&r!==f.callback._callback||s&&s!==f.context?d.push(f):(o=f.listening)&&0==--o.count&&(delete c[o.id],delete o.listeningTo[o.objId])}d.length?t[e]=d:delete t[e]}return t}for(var p=n.keys(c);a<p.length;a++)delete c[(o=c[p[a]]).id],delete o.listeningTo[o.objId]}};l.once=function(t,e,r){var i=d(g,{},t,e,n.bind(this.off,this));return'string'==typeof t&&null==r&&(e=void 0),this.on(i,e,r)},l.listenToOnce=function(t,e,r){var i=d(g,{},e,r,n.bind(this.stopListening,this,t));return this.listenTo(t,i)};var g=function(t,e,r,i){if(r){var o=t[e]=n.once((function(){i(e,o),r.apply(this,arguments)}));o._callback=r}return t};l.trigger=function(t){if(!this._events)return this;for(var e=Math.max(0,arguments.length-1),n=Array(e),r=0;r<e;r++)n[r]=arguments[r+1];return d(v,this._events,t,void 0,n),this};var v=function(t,e,n,r){if(t){var i=t[e],o=t.all;i&&o&&(o=o.slice()),i&&m(i,r),o&&m(o,[e].concat(r))}return t},m=function(t,e){var n,r=-1,i=t.length,o=e[0],a=e[1],s=e[2];switch(e.length){case 0:for(;++r<i;)(n=t[r]).callback.call(n.ctx);return;case 1:for(;++r<i;)(n=t[r]).callback.call(n.ctx,o);return;case 2:for(;++r<i;)(n=t[r]).callback.call(n.ctx,o,a);return;case 3:for(;++r<i;)(n=t[r]).callback.call(n.ctx,o,a,s);return;default:for(;++r<i;)(n=t[r]).callback.apply(n.ctx,e);return}};l.bind=l.on,l.unbind=l.off,n.extend(e,l);var y=e.Model=function(t,e){var r=t||{};e||(e={}),this.cid=n.uniqueId(this.cidPrefix),this.attributes={},e.collection&&(this.collection=e.collection),e.parse&&(r=this.parse(r,e)||{});var i=n.result(this,'defaults');r=n.defaults(n.extend({},i,r),i),this.set(r,e),this.changed={},this.initialize.apply(this,arguments)};n.extend(y.prototype,l,{changed:null,validationError:null,idAttribute:'id',cidPrefix:'c',initialize:function(){},toJSON:function(t){return n.clone(this.attributes)},sync:function(){return e.sync.apply(this,arguments)},get:function(t){return this.attributes[t]},escape:function(t){return n.escape(this.get(t))},has:function(t){return null!=this.get(t)},matches:function(t){return!!n.iteratee(t,this)(this.attributes)},set:function(t,e,r){if(null==t)return this;var i;if('object'==typeof t?(i=t,r=e):(i={})[t]=e,r||(r={}),!this._validate(i,r))return!1;var o=r.unset,a=r.silent,s=[],c=this._changing;this._changing=!0,c||(this._previousAttributes=n.clone(this.attributes),this.changed={});var l=this.attributes,u=this.changed,d=this._previousAttributes;for(var h in i)e=i[h],n.isEqual(l[h],e)||s.push(h),n.isEqual(d[h],e)?delete u[h]:u[h]=e,o?delete l[h]:l[h]=e;if(this.idAttribute in i&&(this.id=this.get(this.idAttribute)),!a){s.length&&(this._pending=r);for(var f=0;f<s.length;f++)this.trigger('change:'+s[f],this,l[s[f]],r)}if(c)return this;if(!a)for(;this._pending;)r=this._pending,this._pending=!1,this.trigger('change',this,r);return this._pending=!1,this._changing=!1,this},unset:function(t,e){return this.set(t,void 0,n.extend({},e,{unset:!0}))},clear:function(t){var e={};for(var r in this.attributes)e[r]=void 0;return this.set(e,n.extend({},t,{unset:!0}))},hasChanged:function(t){return null==t?!n.isEmpty(this.changed):n.has(this.changed,t)},changedAttributes:function(t){if(!t)return!!this.hasChanged()&&n.clone(this.changed);var e=this._changing?this._previousAttributes:this.attributes,r={};for(var i in t){var o=t[i];n.isEqual(e[i],o)||(r[i]=o)}return!!n.size(r)&&r},previous:function(t){return null!=t&&this._previousAttributes?this._previousAttributes[t]:null},previousAttributes:function(){return n.clone(this._previousAttributes)},fetch:function(t){t=n.extend({parse:!0},t);var e=this,r=t.success;return t.success=function(n){var i=t.parse?e.parse(n,t):n;if(!e.set(i,t))return!1;r&&r.call(t.context,e,n,t),e.trigger('sync',e,n,t)},I(this,t),this.sync('read',this,t)},save:function(t,e,r){var i;null==t||'object'==typeof t?(i=t,r=e):(i={})[t]=e;var o=(r=n.extend({validate:!0,parse:!0},r)).wait;if(i&&!o){if(!this.set(i,r))return!1}else if(!this._validate(i,r))return!1;var a=this,s=r.success,c=this.attributes;r.success=function(t){a.attributes=c;var e=r.parse?a.parse(t,r):t;if(o&&(e=n.extend({},i,e)),e&&!a.set(e,r))return!1;s&&s.call(r.context,a,t,r),a.trigger('sync',a,t,r)},I(this,r),i&&o&&(this.attributes=n.extend({},c,i));var l=this.isNew()?'create':r.patch?'patch':'update';'patch'!==l||r.attrs||(r.attrs=i);var u=this.sync(l,this,r);return this.attributes=c,u},destroy:function(t){t=t?n.clone(t):{};var e=this,r=t.success,i=t.wait,o=function(){e.stopListening(),e.trigger('destroy',e,e.collection,t)};t.success=function(n){i&&o(),r&&r.call(t.context,e,n,t),e.isNew()||e.trigger('sync',e,n,t)};var a=!1;return this.isNew()?n.defer(t.success):(I(this,t),a=this.sync('delete',this,t)),i||o(),a},url:function(){var t=n.result(this,'urlRoot')||n.result(this.collection,'url')||R();if(this.isNew())return t;var e=this.get(this.idAttribute);return t.replace(/[^\/]$/,'$&/')+encodeURIComponent(e)},parse:function(t,e){return t},clone:function(){return new this.constructor(this.attributes)},isNew:function(){return!this.has(this.idAttribute)},isValid:function(t){return this._validate({},n.extend({},t,{validate:!0}))},_validate:function(t,e){if(!e.validate||!this.validate)return!0;t=n.extend({},this.attributes,t);var r=this.validationError=this.validate(t,e)||null;return!r||(this.trigger('invalid',this,r,n.extend(e,{validationError:r})),!1)}}),a(y,{keys:1,values:1,pairs:1,invert:1,pick:0,omit:0,chain:1,isEmpty:1},'attributes');var b=e.Collection=function(t,e){e||(e={}),e.model&&(this.model=e.model),void 0!==e.comparator&&(this.comparator=e.comparator),this._reset(),this.initialize.apply(this,arguments),t&&this.reset(t,n.extend({silent:!0},e))},w={add:!0,remove:!0,merge:!0},O={add:!0,remove:!1},x=function(t,e,n){n=Math.min(Math.max(n,0),t.length);var r,i=Array(t.length-n),o=e.length;for(r=0;r<i.length;r++)i[r]=t[r+n];for(r=0;r<o;r++)t[r+n]=e[r];for(r=0;r<i.length;r++)t[r+o+n]=i[r]};n.extend(b.prototype,l,{model:y,initialize:function(){},toJSON:function(t){return this.map((function(e){return e.toJSON(t)}))},sync:function(){return e.sync.apply(this,arguments)},add:function(t,e){return this.set(t,n.extend({merge:!1},e,O))},remove:function(t,e){e=n.extend({},e);var r=!n.isArray(t);t=r?[t]:t.slice();var i=this._removeModels(t,e);return!e.silent&&i.length&&(e.changes={added:[],merged:[],removed:i},this.trigger('update',this,e)),r?i[0]:i},set:function(t,e){if(null!=t){(e=n.extend({},w,e)).parse&&!this._isModel(t)&&(t=this.parse(t,e)||[]);var r=!n.isArray(t);t=r?[t]:t.slice();var i=e.at;null!=i&&(i=+i),i>this.length&&(i=this.length),i<0&&(i+=this.length+1);var o,a,s=[],c=[],l=[],u=[],d={},h=e.add,f=e.merge,p=e.remove,g=!1,v=this.comparator&&null==i&&!1!==e.sort,m=n.isString(this.comparator)?this.comparator:null;for(a=0;a<t.length;a++){o=t[a];var y=this.get(o);if(y){if(f&&o!==y){var b=this._isModel(o)?o.attributes:o;e.parse&&(b=y.parse(b,e)),y.set(b,e),l.push(y),v&&!g&&(g=y.hasChanged(m))}d[y.cid]||(d[y.cid]=!0,s.push(y)),t[a]=y}else h&&(o=t[a]=this._prepareModel(o,e))&&(c.push(o),this._addReference(o,e),d[o.cid]=!0,s.push(o))}if(p){for(a=0;a<this.length;a++)d[(o=this.models[a]).cid]||u.push(o);u.length&&this._removeModels(u,e)}var O=!1,C=!v&&h&&p;if(s.length&&C?(O=this.length!==s.length||n.some(this.models,(function(t,e){return t!==s[e]})),this.models.length=0,x(this.models,s,0),this.length=this.models.length):c.length&&(v&&(g=!0),x(this.models,c,null==i?this.length:i),this.length=this.models.length),g&&this.sort({silent:!0}),!e.silent){for(a=0;a<c.length;a++)null!=i&&(e.index=i+a),(o=c[a]).trigger('add',o,this,e);(g||O)&&this.trigger('sort',this,e),(c.length||u.length||l.length)&&(e.changes={added:c,removed:u,merged:l},this.trigger('update',this,e))}return r?t[0]:t}},reset:function(t,e){e=e?n.clone(e):{};for(var r=0;r<this.models.length;r++)this._removeReference(this.models[r],e);return e.previousModels=this.models,this._reset(),t=this.add(t,n.extend({silent:!0},e)),e.silent||this.trigger('reset',this,e),t},push:function(t,e){return this.add(t,n.extend({at:this.length},e))},pop:function(t){var e=this.at(this.length-1);return this.remove(e,t)},unshift:function(t,e){return this.add(t,n.extend({at:0},e))},shift:function(t){var e=this.at(0);return this.remove(e,t)},slice:function(){return o.apply(this.models,arguments)},get:function(t){if(null!=t)return this._byId[t]||this._byId[this.modelId(t.attributes||t)]||t.cid&&this._byId[t.cid]},has:function(t){return null!=this.get(t)},at:function(t){return t<0&&(t+=this.length),this.models[t]},where:function(t,e){return this[e?'find':'filter'](t)},findWhere:function(t){return this.where(t,!0)},sort:function(t){var e=this.comparator;if(!e)throw new Error('Cannot sort a set without a comparator');t||(t={});var r=e.length;return n.isFunction(e)&&(e=n.bind(e,this)),1===r||n.isString(e)?this.models=this.sortBy(e):this.models.sort(e),t.silent||this.trigger('sort',this,t),this},pluck:function(t){return this.map(t+'')},fetch:function(t){var e=(t=n.extend({parse:!0},t)).success,r=this;return t.success=function(n){var i=t.reset?'reset':'set';r[i](n,t),e&&e.call(t.context,r,n,t),r.trigger('sync',r,n,t)},I(this,t),this.sync('read',this,t)},create:function(t,e){var r=(e=e?n.clone(e):{}).wait;if(!(t=this._prepareModel(t,e)))return!1;r||this.add(t,e);var i=this,o=e.success;return e.success=function(t,e,n){r&&i.add(t,n),o&&o.call(n.context,t,e,n)},t.save(null,e),t},parse:function(t,e){return t},clone:function(){return new this.constructor(this.models,{model:this.model,comparator:this.comparator})},modelId:function(t){return t[this.model.prototype.idAttribute||'id']},_reset:function(){this.length=0,this.models=[],this._byId={}},_prepareModel:function(t,e){if(this._isModel(t))return t.collection||(t.collection=this),t;(e=e?n.clone(e):{}).collection=this;var r=new this.model(t,e);return r.validationError?(this.trigger('invalid',this,r.validationError,e),!1):r},_removeModels:function(t,e){for(var n=[],r=0;r<t.length;r++){var i=this.get(t[r]);if(i){var o=this.indexOf(i);this.models.splice(o,1),this.length--,delete this._byId[i.cid];var a=this.modelId(i.attributes);null!=a&&delete this._byId[a],e.silent||(e.index=o,i.trigger('remove',i,this,e)),n.push(i),this._removeReference(i,e)}}return n},_isModel:function(t){return t instanceof y},_addReference:function(t,e){this._byId[t.cid]=t;var n=this.modelId(t.attributes);null!=n&&(this._byId[n]=t),t.on('all',this._onModelEvent,this)},_removeReference:function(t,e){delete this._byId[t.cid];var n=this.modelId(t.attributes);null!=n&&delete this._byId[n],this===t.collection&&delete t.collection,t.off('all',this._onModelEvent,this)},_onModelEvent:function(t,e,n,r){if(e){if(('add'===t||'remove'===t)&&n!==this)return;if('destroy'===t&&this.remove(e,r),'change'===t){var i=this.modelId(e.previousAttributes()),o=this.modelId(e.attributes);i!==o&&(null!=i&&delete this._byId[i],null!=o&&(this._byId[o]=e))}}this.trigger.apply(this,arguments)}}),a(b,{forEach:3,each:3,map:3,collect:3,reduce:0,foldl:0,inject:0,reduceRight:0,foldr:0,find:3,detect:3,filter:3,select:3,reject:3,every:3,all:3,some:3,any:3,include:3,includes:3,contains:3,invoke:0,max:3,min:3,toArray:1,size:1,first:3,head:3,take:3,initial:3,rest:3,tail:3,drop:3,last:3,without:0,difference:0,indexOf:3,shuffle:1,lastIndexOf:3,isEmpty:1,chain:1,sample:3,partition:3,groupBy:3,countBy:3,sortBy:3,indexBy:3,findIndex:3,findLastIndex:3},'models');var C=e.View=function(t){this.cid=n.uniqueId('view'),n.extend(this,n.pick(t,S)),this._ensureElement(),this.initialize.apply(this,arguments)},k=/^(\S+)\s*(.*)$/,S=['model','collection','el','id','attributes','className','tagName','events'];n.extend(C.prototype,l,{tagName:'div',$:function(t){return this.$el.find(t)},initialize:function(){},render:function(){return this},remove:function(){return this._removeElement(),this.stopListening(),this},_removeElement:function(){this.$el.remove()},setElement:function(t){return this.undelegateEvents(),this._setElement(t),this.delegateEvents(),this},_setElement:function(t){this.$el=t instanceof e.$?t:e.$(t),this.el=this.$el[0]},delegateEvents:function(t){if(t||(t=n.result(this,'events')),!t)return this;for(var e in this.undelegateEvents(),t){var r=t[e];if(n.isFunction(r)||(r=this[r]),r){var i=e.match(k);this.delegate(i[1],i[2],n.bind(r,this))}}return this},delegate:function(t,e,n){return this.$el.on(t+'.delegateEvents'+this.cid,e,n),this},undelegateEvents:function(){return this.$el&&this.$el.off('.delegateEvents'+this.cid),this},undelegate:function(t,e,n){return this.$el.off(t+'.delegateEvents'+this.cid,e,n),this},_createElement:function(t){return document.createElement(t)},_ensureElement:function(){if(this.el)this.setElement(n.result(this,'el'));else{var t=n.extend({},n.result(this,'attributes'));this.id&&(t.id=n.result(this,'id')),this.className&&(t['class']=n.result(this,'className')),this.setElement(this._createElement(n.result(this,'tagName'))),this._setAttributes(t)}},_setAttributes:function(t){this.$el.attr(t)}}),e.sync=function(t,r,i){var o=j[t];n.defaults(i||(i={}),{emulateHTTP:e.emulateHTTP,emulateJSON:e.emulateJSON});var a={type:o,dataType:'json'};if(i.url||(a.url=n.result(r,'url')||R()),null!=i.data||!r||'create'!==t&&'update'!==t&&'patch'!==t||(a.contentType='application/json',a.data=JSON.stringify(i.attrs||r.toJSON(i))),i.emulateJSON&&(a.contentType='application/x-www-form-urlencoded',a.data=a.data?{model:a.data}:{}),i.emulateHTTP&&('PUT'===o||'DELETE'===o||'PATCH'===o)){a.type='POST',i.emulateJSON&&(a.data._method=o);var s=i.beforeSend;i.beforeSend=function(t){if(t.setRequestHeader('X-HTTP-Method-Override',o),s)return s.apply(this,arguments)}}'GET'===a.type||i.emulateJSON||(a.processData=!1);var c=i.error;i.error=function(t,e,n){i.textStatus=e,i.errorThrown=n,c&&c.call(i.context,t,e,n)};var l=i.xhr=e.ajax(n.extend(a,i));return r.trigger('request',r,l,i),l};var j={create:'POST',update:'PUT',patch:'PATCH',delete:'DELETE',read:'GET'};e.ajax=function(){return e.$.ajax.apply(e.$,arguments)};var T=e.Router=function(t){t||(t={}),t.routes&&(this.routes=t.routes),this._bindRoutes(),this.initialize.apply(this,arguments)},P=/\((.*?)\)/g,E=/(\(\?)?:\w+/g,_=/\*\w+/g,M=/[\-{}\[\]+?.,\\\^$|#\s]/g;n.extend(T.prototype,l,{initialize:function(){},route:function(t,r,i){n.isRegExp(t)||(t=this._routeToRegExp(t)),n.isFunction(r)&&(i=r,r=''),i||(i=this[r]);var o=this;return e.history.route(t,(function(n){var a=o._extractParameters(t,n);!1!==o.execute(i,a,r)&&(o.trigger.apply(o,['route:'+r].concat(a)),o.trigger('route',r,a),e.history.trigger('route',o,r,a))})),this},execute:function(t,e,n){t&&t.apply(this,e)},navigate:function(t,n){return e.history.navigate(t,n),this},_bindRoutes:function(){if(this.routes){this.routes=n.result(this,'routes');for(var t,e=n.keys(this.routes);null!=(t=e.pop());)this.route(t,this.routes[t])}},_routeToRegExp:function(t){return t=t.replace(M,'\\$&').replace(P,'(?:$1)?').replace(E,(function(t,e){return e?t:'([^/?]+)'})).replace(_,'([^?]*?)'),new RegExp('^'+t+'(?:\\?([\\s\\S]*))?$')},_extractParameters:function(t,e){var r=t.exec(e).slice(1);return n.map(r,(function(t,e){return e===r.length-1?t||null:t?decodeURIComponent(t):null}))}});var D=e.History=function(){this.handlers=[],this.checkUrl=n.bind(this.checkUrl,this),'undefined'!=typeof window&&(this.location=window.location,this.history=window.history)},A=/^[#\/]|\s+$/g,L=/^\/+|\/+$/g,N=/#.*$/;D.started=!1,n.extend(D.prototype,l,{interval:50,atRoot:function(){return this.location.pathname.replace(/[^\/]$/,'$&/')===this.root&&!this.getSearch()},matchRoot:function(){return this.decodeFragment(this.location.pathname).slice(0,this.root.length-1)+'/'===this.root},decodeFragment:function(t){return decodeURI(t.replace(/%25/g,'%2525'))},getSearch:function(){var t=this.location.href.replace(/#.*/,'').match(/\?.+/);return t?t[0]:''},getHash:function(t){var e=(t||this).location.href.match(/#(.*)$/);return e?e[1]:''},getPath:function(){var t=this.decodeFragment(this.location.pathname+this.getSearch()).slice(this.root.length-1);return'/'===t.charAt(0)?t.slice(1):t},getFragment:function(t){return null==t&&(t=this._usePushState||!this._wantsHashChange?this.getPath():this.getHash()),t.replace(A,'')},start:function(t){if(D.started)throw new Error('Backbone.history has already been started');if(D.started=!0,this.options=n.extend({root:'/'},this.options,t),this.root=this.options.root,this._wantsHashChange=!1!==this.options.hashChange,this._hasHashChange='onhashchange'in window&&(void 0===document.documentMode||document.documentMode>7),this._useHashChange=this._wantsHashChange&&this._hasHashChange,this._wantsPushState=!!this.options.pushState,this._hasPushState=!(!this.history||!this.history.pushState),this._usePushState=this._wantsPushState&&this._hasPushState,this.fragment=this.getFragment(),this.root=('/'+this.root+'/').replace(L,'/'),this._wantsHashChange&&this._wantsPushState){if(!this._hasPushState&&!this.atRoot()){var e=this.root.slice(0,-1)||'/';return this.location.replace(e+'#'+this.getPath()),!0}this._hasPushState&&this.atRoot()&&this.navigate(this.getHash(),{replace:!0})}if(!this._hasHashChange&&this._wantsHashChange&&!this._usePushState){this.iframe=document.createElement('iframe'),this.iframe.src='javascript:0',this.iframe.style.display='none',this.iframe.tabIndex=-1;var r=document.body,i=r.insertBefore(this.iframe,r.firstChild).contentWindow;i.document.open(),i.document.close(),i.location.hash='#'+this.fragment}var o=window.addEventListener||function(t,e){return attachEvent('on'+t,e)};if(this._usePushState?o('popstate',this.checkUrl,!1):this._useHashChange&&!this.iframe?o('hashchange',this.checkUrl,!1):this._wantsHashChange&&(this._checkUrlInterval=setInterval(this.checkUrl,this.interval)),!this.options.silent)return this.loadUrl()},stop:function(){var t=window.removeEventListener||function(t,e){return detachEvent('on'+t,e)};this._usePushState?t('popstate',this.checkUrl,!1):this._useHashChange&&!this.iframe&&t('hashchange',this.checkUrl,!1),this.iframe&&(document.body.removeChild(this.iframe),this.iframe=null),this._checkUrlInterval&&clearInterval(this._checkUrlInterval),D.started=!1},route:function(t,e){this.handlers.unshift({route:t,callback:e})},checkUrl:function(t){var e=this.getFragment();if(e===this.fragment&&this.iframe&&(e=this.getHash(this.iframe.contentWindow)),e===this.fragment)return!1;this.iframe&&this.navigate(e),this.loadUrl()},loadUrl:function(t){return!!this.matchRoot()&&(t=this.fragment=this.getFragment(t),n.some(this.handlers,(function(e){if(e.route.test(t))return e.callback(t),!0})))},navigate:function(t,e){if(!D.started)return!1;e&&!0!==e||(e={trigger:!!e}),t=this.getFragment(t||'');var n=this.root;''!==t&&'?'!==t.charAt(0)||(n=n.slice(0,-1)||'/');var r=n+t;if(t=this.decodeFragment(t.replace(N,'')),this.fragment!==t){if(this.fragment=t,this._usePushState)this.history[e.replace?'replaceState':'pushState']({},document.title,r);else{if(!this._wantsHashChange)return this.location.assign(r);if(this._updateHash(this.location,t,e.replace),this.iframe&&t!==this.getHash(this.iframe.contentWindow)){var i=this.iframe.contentWindow;e.replace||(i.document.open(),i.document.close()),this._updateHash(i.location,t,e.replace)}}return e.trigger?this.loadUrl(t):void 0}},_updateHash:function(t,e,n){if(n){var r=t.href.replace(/(javascript:|#).*$/,'');t.replace(r+'#'+e)}else t.hash='#'+e}}),e.history=new D;y.extend=b.extend=T.extend=C.extend=D.extend=function(t,e){var r,i=this;return r=t&&n.has(t,'constructor')?t.constructor:function(){return i.apply(this,arguments)},n.extend(r,i,e),r.prototype=n.create(i.prototype,t),r.prototype.constructor=r,r.__super__=i.prototype,r};var R=function(){throw new Error('A "url" property or function must be specified')},I=function(t,e){var n=e.error;e.error=function(r){n&&n.call(e.context,t,r,e),t.trigger('error',t,r,e)}};return e}(s,n,t,e)}.apply(e,i))||(t.exports=o);else{}}()}).call(this,n(35))},function(t,e){t.exports=function(t,e,n){return e in t?Object.defineProperty(t,e,{value:n,enumerable:!0,configurable:!0,writable:!0}):t[e]=n,t},t.exports["default"]=t.exports,t.exports.__esModule=!0},function(t,e){function n(e){return t.exports=n=Object.setPrototypeOf?Object.getPrototypeOf:function(t){return t.__proto__||Object.getPrototypeOf(t)},t.exports["default"]=t.exports,t.exports.__esModule=!0,n(e)}t.exports=n,t.exports["default"]=t.exports,t.exports.__esModule=!0},function(t,e){t.exports=function(t,e){if(!(t instanceof e))throw new TypeError("Cannot call a class as a function")},t.exports["default"]=t.exports,t.exports.__esModule=!0},function(t,e){function n(t,e){for(var n=0;n<e.length;n++){var r=e[n];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(t,r.key,r)}}t.exports=function(t,e,r){return e&&n(t.prototype,e),r&&n(t,r),t},t.exports["default"]=t.exports,t.exports.__esModule=!0},function(t,e,n){"use strict";(function(t){n.d(e,"e",(function(){return r})),n.d(e,"p",(function(){return i})),n.d(e,"a",(function(){return o})),n.d(e,"c",(function(){return a})),n.d(e,"d",(function(){return s})),n.d(e,"o",(function(){return c})),n.d(e,"q",(function(){return l})),n.d(e,"t",(function(){return u})),n.d(e,"i",(function(){return d})),n.d(e,"r",(function(){return h})),n.d(e,"s",(function(){return f})),n.d(e,"k",(function(){return p})),n.d(e,"m",(function(){return g})),n.d(e,"j",(function(){return v})),n.d(e,"l",(function(){return m})),n.d(e,"g",(function(){return y})),n.d(e,"f",(function(){return b})),n.d(e,"h",(function(){return w})),n.d(e,"n",(function(){return O})),n.d(e,"b",(function(){return x}));var r='1.13.1',i='object'==typeof self&&self.self===self&&self||'object'==typeof t&&t.global===t&&t||Function('return this')()||{},o=Array.prototype,a=Object.prototype,s='undefined'!=typeof Symbol?Symbol.prototype:null,c=o.push,l=o.slice,u=a.toString,d=a.hasOwnProperty,h='undefined'!=typeof ArrayBuffer,f='undefined'!=typeof DataView,p=Array.isArray,g=Object.keys,v=Object.create,m=h&&ArrayBuffer.isView,y=isNaN,b=isFinite,w=!{toString:null}.propertyIsEnumerable('toString'),O=['valueOf','isPrototypeOf','toString','propertyIsEnumerable','hasOwnProperty','toLocaleString'],x=Math.pow(2,53)-1}).call(this,n(35))},function(t,e,n){var r=n(87);t.exports=function(t,e){if("function"!=typeof e&&null!==e)throw new TypeError("Super expression must either be null or a function");t.prototype=Object.create(e&&e.prototype,{constructor:{value:t,writable:!0,configurable:!0}}),e&&r(t,e)},t.exports["default"]=t.exports,t.exports.__esModule=!0},function(t,e,n){var r=n(14)["default"],i=n(88);t.exports=function(t,e){return!e||"object"!==r(e)&&"function"!=typeof e?i(t):e},t.exports["default"]=t.exports,t.exports.__esModule=!0},function(t,e,n){"use strict";n.d(e,"b",(function(){return V})),n.d(e,"a",(function(){return W}));var r=n(14),i=n.n(r),o=n(11),a=n.n(o),s=n(41),c=n.n(s),l=n(3),u=n.n(l),d=n(5),h=n.n(d),f=n(6),p=n.n(f),g=n(8),v=n.n(g),m=n(9),y=n.n(m),b=n(4),w=n.n(b),O=n(0),x=n(1),C=n(32),k=n(2),S=n.n(k),j=n(30),T=n(16),P=n(20);function E(t,e){var n=Object.keys(t);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(t);e&&(r=r.filter((function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable}))),n.push.apply(n,r)}return n}function _(t){for(var e=1;e<arguments.length;e++){var n=null!=arguments[e]?arguments[e]:{};e%2?E(Object(n),!0).forEach((function(e){u()(t,e,n[e])})):Object.getOwnPropertyDescriptors?Object.defineProperties(t,Object.getOwnPropertyDescriptors(n)):E(Object(n)).forEach((function(e){Object.defineProperty(t,e,Object.getOwnPropertyDescriptor(n,e))}))}return t}var M,D=S.a.Model.extend({defaults:{type:'text',label:'',name:'',min:'',max:'',unit:'',step:1,value:'',target:'',default:'',placeholder:'',changeProp:0,options:[]},initialize:function(){var t=this.get('target'),e=this.get('name'),n=this.get('changeProp');if(!this.get('id')&&this.set('id',e),t){this.target=t,this.unset('target');var r=n?"change:".concat(e):"change:attributes:".concat(e);this.listenTo(t,r,this.targetUpdated)}},props:function(){return this.attributes},targetUpdated:function(){var t=this.getTargetValue();this.set({value:t},{fromTarget:1})},getTargetValue:function(){var t,e=this.get('name'),n=this.target;return t=this.get('changeProp')?n.get(e):n.getAttributes()[e],Object(O["isUndefined"])(t)?'':t},setTargetValue:function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},n=this.target,r=this.get('name');if(!Object(O["isUndefined"])(t)){var i=t;if('false'===t?i=!1:'true'===t&&(i=!0),this.get('changeProp'))n.set(r,i,e);else{var o=_({},n.get('attributes'));o[r]=i,n.set('attributes',o,e)}}},setValueFromInput:function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:1,n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},r={value:t};this.set(r,_(_({},n),{},{avoidStore:1})),e&&(this.set('value','',n),this.set(r,n))},getInitValue:function(){var t,e=this.target,n=this.get('name');if(e){var r=e.get('attributes');t=this.get('changeProp')?e.get(n):r[n]}return t||this.get('value')||this.get('default')}}),A=S.a.Collection.extend({model:D,initialize:function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};this.em=e.em||'',this.listenTo(this,'add',this.handleAdd),this.listenTo(this,'reset',this.handleReset)},handleReset:function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},n=e.previousModels,r=void 0===n?[]:n;r.forEach((function(t){return t.trigger('remove')}))},handleAdd:function(t){var e=this.target;e&&(t.target=e)},setTarget:function(t){this.target=t},add:function(t,e){var n=this.em;if(Object(O["isString"])(t)||Object(O["isArray"])(t)){var r=n&&n.get&&n.get('TraitManager'),i=function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};return{build:function(e){var n=[];'string'==typeof e&&(e=[e]);for(var r=0;r<e.length;r++){var i={},o=e[r];switch(i.name=o,o){case'target':i.type='select',i.default=!1,i.options=t.optionsTarget}n.push(i)}return n}}}(r&&r.getConfig());Object(O["isString"])(t)&&(t=[t]);for(var o=0,a=t.length;o<a;o++){var s=t[o],c=Object(O["isString"])(s)?i.build(s)[0]:s;c.target=this.target,t[o]=c}}return S.a.Collection.prototype.add.apply(this,[t,e])}});function L(t,e){var n=Object.keys(t);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(t);e&&(r=r.filter((function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable}))),n.push.apply(n,r)}return n}function N(t){for(var e=1;e<arguments.length;e++){var n=null!=arguments[e]?arguments[e]:{};e%2?L(Object(n),!0).forEach((function(e){u()(t,e,n[e])})):Object.getOwnPropertyDescriptors?Object.defineProperties(t,Object.getOwnPropertyDescriptors(n)):L(Object(n)).forEach((function(e){Object.defineProperty(t,e,Object.getOwnPropertyDescriptor(n,e))}))}return t}function R(t){var e=function(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],(function(){}))),!0}catch(t){return!1}}();return function(){var n,r=w()(t);if(e){var i=w()(this).constructor;n=Reflect.construct(r,arguments,i)}else n=r.apply(this,arguments);return y()(this,n)}}var I=function(t){return t.replace(/[|\\{}()[\]^$+*?.]/g,'\\$&')},F=function(t){return t&&t.getConfig('avoidInlineStyle')},V='component:drag',z='__symbols',H='__symbol',B='__symbol_ovrd',U='component:update',$="".concat(U,"-inside"),W=function(t){v()(n,t);var e=R(n);function n(){return h()(this,n),e.apply(this,arguments)}return p()(n,[{key:"init",value:function(){}},{key:"updated",value:function(t,e,n){}},{key:"removed",value:function(){}},{key:"initialize",value:function(){var t=this,e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},r=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};Object(O["bindAll"])(this,'__upSymbProps','__upSymbCls','__upSymbComps');var i=r.em,o=this.parent(),a=o&&o.attributes;if(a&&a.propagate){var s={},c=a.propagate;c.forEach((function(t){return s[t]=o.get(t)})),s.propagate=c,s=N(N({},s),e),this.set(s)}var l=this.get('propagate');if(l&&this.set('propagate',Object(O["isArray"])(l)?l:[l]),r&&r.config&&r.config.voidElements.indexOf(this.get('tagName'))>=0&&this.set('void',!0),r.em=i,this.opt=r,this.em=i,this.frame=r.frame,this.config=r.config||{},this.set('attributes',N(N({},Object(O["result"])(this,'defaults').attributes||{}),this.get('attributes')||{})),this.ccid=n.createId(this,r),this.initClasses(),this.initTraits(),this.initComponents(),this.initToolbar(),this.initScriptProps(),this.listenTo(this,'change:script',this.scriptUpdated),this.listenTo(this,'change:tagName',this.tagUpdated),this.listenTo(this,'change:attributes',this.attrUpdated),this.listenTo(this,'change:attributes:id',this._idUpdated),this.on('change:toolbar',this.__emitUpdateTlb),this.on('change',this.__onChange),this.on($,this.__propToParent),this.set('status',''),this.views=[],['classes','traits','components'].forEach((function(e){var n="add remove ".concat('components'!==e?'change':'');t.listenTo(t.get(e),n.trim(),(function(){for(var n=arguments.length,r=new Array(n),i=0;i<n;i++)r[i]=arguments[i];return t.emitUpdate.apply(t,[e].concat(r))}))})),!r.temporary){var u=i&&i.get('CssComposer'),d=this.attributes,h=d.styles,f=d.type;h&&u&&u.addCollection(h,{},{group:"cmp:".concat(f)}),this.__postAdd(),this.init(),this.__isSymbolOrInst()&&this.__initSymb(),i&&i.trigger('component:create',this)}}},{key:"__postAdd",value:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},e=this.em,n=e&&e.get('UndoManager'),r=this.components();n&&!this.__hasUm&&(n.add(r),n.add(this.getSelectors()),this.__hasUm=1),t.recursive&&r.map((function(e){return e.__postAdd(t)}))}},{key:"__postRemove",value:function(){var t=this.em,e=t&&t.get('UndoManager');e&&(e.remove(this.components()),e.remove(this.getSelectors()),delete this.__hasUm)}},{key:"__onChange",value:function(t,e){var n=this.changedAttributes();['status','open','toolbar','traits'].forEach((function(t){return delete n[t]})),Object(x["isEmptyObj"])(n)||(this.__changesUp(e),this.__propSelfToParent({component:this,changed:n,options:e}))}},{key:"__changesUp",value:function(t){var e=this.em;[this.frame,e].forEach((function(e){return e&&e.changesUp(t)}))}},{key:"__propSelfToParent",value:function(t){this.trigger(U,t),this.__propToParent(t)}},{key:"__propToParent",value:function(t){var e=this.parent();e&&e.trigger($,t)}},{key:"__emitUpdateTlb",value:function(){this.emitUpdate('toolbar')}},{key:"is",value:function(t){return!(this.get('type')!=t)}},{key:"props",value:function(){return this.attributes}},{key:"index",value:function(){var t=this.collection;return t?t.indexOf(this):0}},{key:"setDragMode",value:function(t){return this.set('dmode',t)}},{key:"find",value:function(t){var e=[],n=this.view.$el.find(t);return n.each((function(t){var r=n.eq(t).data('model');r&&e.push(r)})),e}},{key:"findType",value:function(t){var e=[];return function n(r){return r.forEach((function(r){r.is(t)&&e.push(r),n(r.components())}))}(this.components()),e}},{key:"closest",value:function(t){var e=this.view.$el.closest(t);return e.length&&e.data('model')}},{key:"closestType",value:function(t){for(var e=this.parent();e&&!e.is(t);)e=e.parent();return e}},{key:"contains",value:function(t){var e=!1;if(!t)return e;var n=function n(r){!e&&r.forEach((function(r){r===t&&(e=!0),!e&&n(r.components())}))};return n(this.components()),e}},{key:"tagUpdated",value:function(){this.trigger('rerender')}},{key:"replaceWith",value:function(t){var e=this.collection,n=e.indexOf(this);return e.remove(this),e.add(t,{at:n})}},{key:"attrUpdated",value:function(t,e){var n=this,r=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},i=this.get('attributes'),o=i.class;o&&this.setClass(o),delete i.class;var a=i.style;a&&this.setStyle(a),delete i.style;var s=N({},this.previous('attributes')),c=Object(x["shallowDiff"])(s,this.get('attributes'));Object(O["keys"])(c).forEach((function(t){return n.trigger("change:attributes:".concat(t),n,c[t],r)}))}},{key:"setAttributes",value:function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};return this.set('attributes',N({},t),e),this}},{key:"addAttributes",value:function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};return this.setAttributes(N(N({},this.getAttributes({noClass:1})),t),e)}},{key:"removeAttributes",value:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:[],e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},n=Array.isArray(t)?t:[t],r=this.getAttributes();return n.map((function(t){return delete r[t]})),this.setAttributes(r,e)}},{key:"getStyle",value:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},n=this.em,r=Object(O["isString"])(t)?t:'',i=r?e:t;if(n&&n.getConfig('avoidInlineStyle')&&!i.inline){var o=n.get('state'),a=n.get('CssComposer'),s=a.getIdRule(this.getId(),N({state:o},i));if(this.rule=s,s)return s.getStyle(r)}return C["a"].getStyle.call(this,r)}},{key:"setStyle",value:function(){var t=this,e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},r=this.em,i=this.opt;if(r&&r.getConfig('avoidInlineStyle')&&!i.temporary&&!n.inline){var o=this.get('style')||{};e=N(N({},e=Object(O["isString"])(e)?this.parseStyle(e):e),o);var a=r.get('state'),s=r.get('CssComposer'),c=this.getStyle(n);this.rule=s.setIdRule(this.getId(),e,N(N({},n),{},{state:a}));var l=Object(x["shallowDiff"])(c,e);this.set('style','',{silent:1}),Object(O["keys"])(l).forEach((function(e){return t.trigger("change:style:".concat(e))}))}else e=C["a"].setStyle.apply(this,arguments);return e}},{key:"getAttributes",value:function(){var t,e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},n=this.em,r=[],i=N({},this.get('attributes')),o=n&&n.get('SelectorManager'),a=this.getId();if(e.noClass||(this.get('classes').forEach((function(t){return r.push(Object(O["isString"])(t)?t:t.get('name'))})),r.length&&(i.class=r.join(' '))),!e.noStyle){var s=this.get('style');Object(x["isObject"])(s)&&!Object(x["isEmptyObj"])(s)&&(i.style=this.styleToString({inline:1}))}Object(O["has"])(i,'id')||(F(n)?t=o&&o.get(a,o.Selector.TYPE_ID):Object(O["isEmpty"])(this.getStyle())||(t=1),(this.__getSymbol()||this.__getSymbols())&&(t=1),t&&(i.id=a));return i}},{key:"addClass",value:function(t){var e=this.em.get('SelectorManager').addClass(t);return this.get('classes').add(e)}},{key:"setClass",value:function(t){return this.get('classes').reset(),this.addClass(t)}},{key:"removeClass",value:function(t){var e=[];t=Object(O["isArray"])(t)?t:[t];var n=this.get('classes'),r=T["a"].TYPE_CLASS;return t.forEach((function(t){t.split(' ').forEach((function(t){var i=n.where({name:t,type:r})[0];i&&e.push(n.remove(i))}))})),e}},{key:"getClasses",value:function(){var t=this.getAttributes().class;return t?t.split(' '):[]}},{key:"__logSymbol",value:function(t,e){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},r=this.__getSymbol(),i=this.__getSymbols();(r||i)&&this.em.log(t,{model:this,toUp:e,context:'symbols',opts:n})}},{key:"__initSymb",value:function(){this.__symbReady||(this.on('change',this.__upSymbProps),this.__symbReady=1)}},{key:"__isSymbol",value:function(){return Object(O["isArray"])(this.get(z))}},{key:"__isSymbolOrInst",value:function(){return!(!this.__isSymbol()&&!this.get(H))}},{key:"__isSymbolTop",value:function(){var t=this.parent();return this.__isSymbolOrInst()&&(!t||t&&!t.__isSymbol()&&!t.__getSymbol())}},{key:"__isSymbolNested",value:function(){if(!this.__isSymbolOrInst()||this.__isSymbolTop())return!1;var t=(this.__isSymbol()?this:this.__getSymbol()).__getSymbTop(),e=this.__getSymbTop();return(e.__isSymbol()?e:e.__getSymbol())!==t}},{key:"__getAllById",value:function(){var t=this.em;return t?t.get('DomComponents').allById():{}}},{key:"__getSymbol",value:function(){var t=this.get(H);if(t&&Object(O["isString"])(t)){var e=this.__getAllById()[t];e?(t=e,this.set(H,e)):t=0}return t}},{key:"__getSymbols",value:function(){var t=this,e=this.get(z);return e&&Object(O["isArray"])(e)&&(e.forEach((function(n,r){n&&Object(O["isString"])(n)&&(e[r]=t.__getAllById()[n])})),e=e.filter((function(t){return t&&!Object(O["isString"])(t)}))),e}},{key:"__isSymbOvrd",value:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:'',e=this.get(B),n=t.split(':'),r=c()(n,1),i=r[0],o=t!==i?[t,i]:[t];return!0===e||Object(O["isArray"])(e)&&o.some((function(t){return e.indexOf(t)>=0}))}},{key:"__getSymbToUp",value:function(){var t=this,e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},n=[],r=this.em,i=e.changed,o=r&&r.get('symbols');if(e.fromInstance||e.noPropagate||e.fromUndo||!o||i&&this.__isSymbOvrd(i))return n;var s=this.__getSymbols()||[],c=this.__getSymbol(),l=c?[c].concat(a()(c.__getSymbols()||[])):s;return n=l.filter((function(e){return e!==t})).filter((function(t){return!(i&&t.__isSymbOvrd(i))}))}},{key:"__getSymbTop",value:function(t){for(var e=this,n=this.parent(t);n&&(n.__isSymbol()||n.__getSymbol());)e=n,n=n.parent(t);return e}},{key:"__upSymbProps",value:function(t){var e=this,n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},r=this.changedAttributes(),i=r.attributes||{};if(delete r.status,delete r.open,delete r[z],delete r[H],delete r[B],delete r.attributes,delete i.id,Object(x["isEmptyObj"])(i)||(r.attributes=i),!Object(x["isEmptyObj"])(r)){var o=this.__getSymbToUp(n);Object(O["keys"])(r).map((function(t){e.__isSymbOvrd(t)&&delete r[t]})),this.__logSymbol('props',o,{opts:n,changed:r}),o.forEach((function(t){var i=N({},r);Object(O["keys"])(i).map((function(e){t.__isSymbOvrd(e)&&delete i[e]})),t.set(i,N({fromInstance:e},n))}))}}},{key:"__upSymbCls",value:function(t,e){var n=this,r=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},i=this.__getSymbToUp(r);this.__logSymbol('classes',i,{opts:r}),i.forEach((function(t){t.set('classes',n.get('classes'),{fromInstance:n})})),this.__changesUp(r)}},{key:"__upSymbComps",value:function(t,e,n){var r=this,i=n||e||{},o={fromInstance:i.fromInstance,fromUndo:i.fromUndo},s=t.opt.temporary;if(n)if(n.add){var c=[],l=!!this.__getSymbols(),u=this.__getSymbToUp(N(N({},o),{},{changed:'components:add'}));if(u.length){var d=t.__getSymbol();c=(d?d.__getSymbols():t.__getSymbols())||[],(c=a()(c)).push(d||t)}!s&&this.__logSymbol('add',u,{opts:n,addedInstances:c.map((function(t){return t.cid})),added:t.cid}),u.forEach((function(e){var i=e.__getSymbTop(),o=c.filter((function(t){var e=t.__getSymbTop({prev:1});return i&&e&&e===i}))[0]||t.clone({symbol:1,symbolInv:l});e.append(o,N({fromInstance:r},n))}))}else{var h=t.__getSymbol();if(h&&!n.temporary&&h.set(z,h.__getSymbols().filter((function(e){return e!==t}))),!t.__isSymbolTop()){var f='components:remove',p=n.index,g=t.parent(),v=N({fromInstance:t},n),m=t.__isSymbolNested(),y=function(t){var e=t.parent();e&&!e.__isSymbOvrd(f)&&t.remove(v)},b=g.__isSymbOvrd(f)?[]:t.__getSymbToUp(o);m&&(b=g.__getSymbToUp(N(N({},o),{},{changed:f})),y=function(t){var e=t.components().at(p);e&&e.remove(N({fromInstance:g},v))}),!s&&this.__logSymbol('remove',b,{opts:n,removed:t.cid,isSymbNested:m}),b.forEach(y)}}else{var w=this.__getSymbToUp(N(N({},o),{},{changed:'components:reset'}));this.__logSymbol('reset',w,{components:t.models}),w.forEach((function(n){var i=t.models.map((function(t){return t.clone({symbol:1})}));n.components().reset(i,N({fromInstance:r},e))}))}this.__changesUp(i)}},{key:"initClasses",value:function(t,e){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},r='change:classes',i=this.get('attributes').class||[],o=[this,r,this.initClasses],a=this.get('classes')||i,s=Object(O["isString"])(a)?a.split(' '):a;this.stopListening.apply(this,o);var c=this.normalizeClasses(s),l=new P["a"]([]);return this.set('classes',l,n),l.add(c),l.on('add remove reset',this.__upSymbCls),this.listenTo.apply(this,o),this}},{key:"initComponents",value:function(){var t=[this,'change:components',this.initComponents];this.stopListening.apply(this,t);var e=new j["a"](null,this.opt);e.parent=this;var n=this.get('components'),r=!this.opt.avoidChildren;return this.set('components',e),r&&n&&e.add(Object(O["isFunction"])(n)?n(this):n,this.opt),e.on('add remove reset',this.__upSymbComps),this.listenTo.apply(this,t),this}},{key:"initTraits",value:function(t){var e=this.em,n=[this,'change:traits',this.initTraits];this.stopListening.apply(this,n),this.loadTraits();var r=N({},this.get('attributes')),i=this.get('traits');return i.each((function(t){if(!t.get('changeProp')){var e=t.get('name'),n=t.getInitValue();e&&n&&(r[e]=n)}})),i.length&&this.set('attributes',r),this.listenTo.apply(this,n),t&&e&&e.trigger('component:toggled'),this}},{key:"initScriptProps",value:function(){if(!this.opt.temporary){var t='script-props',e=["change:".concat(t),this.initScriptProps];this.off.apply(this,e);var n=this.previous(t)||[],r=this.get(t)||[],i=n.map((function(t){return"change:".concat(t)})).join(' '),o=r.map((function(t){return"change:".concat(t)})).join(' ');i&&this.off(i,this.__scriptPropsChange),o&&this.on(o,this.__scriptPropsChange),this.on.apply(this,e)}}},{key:"__scriptPropsChange",value:function(t,e){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};n.avoidStore||this.trigger('rerender')}},{key:"append",value:function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},n=Object(O["isArray"])(t)?t:[t],r=n.map((function(t){return Object(O["isString"])(t)||t.collection&&t.collection.remove(t,{temporary:1}),t})),i=this.components().add(r,e);return Object(O["isArray"])(i)?i:[i]}},{key:"components",value:function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},n=this.get('components');return Object(O["isUndefined"])(t)?n:(n.reset(null,e),t?this.append(t,e):[])}},{key:"getChildAt",value:function(t){return this.components().at(t||0)||null}},{key:"getLastChild",value:function(){var t=this.components();return t.at(t.length-1)||null}},{key:"empty",value:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};return this.components().reset(null,t),this}},{key:"parent",value:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},e=this.collection||t.prev&&this.prevColl;return e?e.parent:null}},{key:"scriptUpdated",value:function(){this.set('scriptUpdated',1)}},{key:"initToolbar",value:function(){var t=this.em,e=t&&t.getConfig('stylePrefix')||'';if(!this.get('toolbar')){var n=[];this.collection&&n.push({attributes:{class:'fa fa-arrow-up'},command:function(t){return t.runCommand('core:component-exit',{force:1})}}),this.get('draggable')&&n.push({attributes:{class:"fa fa-arrows ".concat(e,"no-touch-actions"),draggable:!0},command:'tlb-move'}),this.get('copyable')&&n.push({attributes:{class:'fa fa-clone'},command:'tlb-clone'}),this.get('removable')&&n.push({attributes:{class:'fa fa-trash-o'},command:'tlb-delete'}),this.set('toolbar',n)}}},{key:"loadTraits",value:function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(t=t||this.get('traits'),!((t=Object(O["isFunction"])(t)?t(this):t)instanceof A)){var n=new A([],this.opt);n.setTarget(this),t.length&&(t.forEach((function(t){return t.attributes&&delete t.attributes.value})),n.add(t)),this.set('traits',n,e)}return this}},{key:"getTrait",value:function(t){return this.get('traits').filter((function(e){return e.get('id')===t||e.get('name')===t}))[0]}},{key:"updateTrait",value:function(t,e){var n=this.em,r=this.getTrait(t);return r&&r.set(e),n&&n.trigger('component:toggled'),this}},{key:"getTraitIndex",value:function(t){var e=this.getTrait(t);return e?this.get('traits').indexOf(e):-1}},{key:"removeTrait",value:function(t){var e=this,n=this.em,r=(Object(O["isArray"])(t)?t:[t]).map((function(t){return e.getTrait(t)})),i=this.get('traits').remove(r);return n&&n.trigger('component:toggled'),i}},{key:"addTrait",value:function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},n=this.em,r=this.get('traits').add(t,e);return n&&n.trigger('component:toggled'),r}},{key:"normalizeClasses",value:function(t){var e=[],n=this.em,r=n&&n.get('SelectorManager');if(r)return t.models?a()(t.models):(t.forEach((function(t){return e.push(r.add(t))})),e)}},{key:"clone",value:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},e=this.em,n=N({},this.attributes),r=N({},this.opt),i=this.getId(),o=e&&e.get('CssComposer');n.attributes=N({},n.attributes),delete n.attributes.id,n.components=[],n.classes=[],n.traits=[],this.__isSymbolTop()&&(t.symbol=1),this.get('components').each((function(e,r){n.components[r]=e.clone(N(N({},t),{},{_inner:1}))})),this.get('traits').each((function(t,e){n.traits[e]=t.clone()})),this.get('classes').each((function(t,e){n.classes[e]=t.get('name')})),n.status='',r.collection=null;var s=new this.constructor(n,r),c="#".concat(s.getId()),l=o?o.getRules("#".concat(i)):[];l.forEach((function(t){var e=t.clone();e.set('selectors',[c]),o.getAll().add(e)})),s.set(z,0);var u=this.__getSymbol(),d=this.__getSymbols();t.symbol||!u&&!d?u?(u.set(z,[].concat(a()(u.__getSymbols()),[s])),s.__initSymb()):t.symbol&&(this.__isSymbol()?(this.set(z,[].concat(a()(d),[s])),s.set(H,this),s.__initSymb()):t.symbolInv?(this.set(z,[s]),s.set(H,this),[this,s].map((function(t){return t.__initSymb()}))):(s.set(z,[this]),[this,s].map((function(t){return t.__initSymb()})),this.set(H,s))):(s.set(H,0),s.set(z,0));var h='component:clone';return e&&e.trigger(h,s),this.trigger(h,s),s}},{key:"getName",value:function(){var t=this.em,e=this.attributes,n=e.type,r=e.tagName,i=this.get('name'),o='div'==r,a=n||(o?'box':r),s=!n&&r&&!o&&r,c='domComponents.names.',l=i&&t&&t.t("".concat(c).concat(i)),u=s&&t&&t.t("".concat(c).concat(s)),d=t&&(t.t("".concat(c).concat(n))||t.t("".concat(c).concat(r)));return this.get('custom-name')||l||i||u||Object(x["capitalize"])(s)||d||Object(x["capitalize"])(a)}},{key:"getIcon",value:function(){var t=this.get('icon');return t?t+' ':''}},{key:"toHTML",value:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},e=this,n=[],r=t.tag,i=r||e.get('tagName'),o=e.get('void'),a=t.attributes,s=this.getAttrToHTML();for(var c in delete t.tag,a&&(Object(O["isFunction"])(a)?s=a(e,s)||{}:Object(x["isObject"])(a)&&(s=a)),s){var l=s[c],u=Object(O["isString"])(l)?l.replace(/"/g,'&quot;'):l;Object(O["isUndefined"])(u)||(Object(O["isBoolean"])(u)?u&&n.push(c):n.push("".concat(c,"=\"").concat(u,"\"")))}var d=n.length?" ".concat(n.join(' ')):'',h=e.__innerHTML(t),f="<".concat(i).concat(d).concat(o?'/':'',">").concat(h);return!o&&(f+="</".concat(i,">")),f}},{key:"__innerHTML",value:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},e=this.components();return e.length?e.map((function(e){return e.toHTML(t)})).join(''):this.get('content')}},{key:"getAttrToHTML",value:function(){var t=this.getAttributes();return delete t.style,t}},{key:"toJSON",value:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},e=k["Model"].prototype.toJSON.call(this,t);if(e.attributes=this.getAttributes(),delete e.attributes.class,delete e.toolbar,delete e.traits,delete e.status,delete e.open,!t.fromUndo){var n=e[H],r=e[z];r&&Object(O["isArray"])(r)&&(e[z]=r.filter((function(t){return t})).map((function(t){return t.getId?t.getId():t}))),n&&!Object(O["isString"])(n)&&(e[H]=n.getId())}return this.em.getConfig('avoidDefaults')&&this.getChangedProps(e),e}},{key:"getChangedProps",value:function(t){var e=t||k["Model"].prototype.toJSON.apply(this),n=Object(O["result"])(this,'defaults');return Object(O["forEach"])(n,(function(t,n){-1===['type'].indexOf(n)&&e[n]===t&&delete e[n]})),Object(O["isEmpty"])(e.type)&&delete e.type,Object(O["forEach"])(['attributes','style'],(function(t){Object(O["isEmpty"])(n[t])&&Object(O["isEmpty"])(e[t])&&delete e[t]})),Object(O["forEach"])(['classes','components'],(function(t){(!e[t]||Object(O["isEmpty"])(n[t])&&!e[t].length)&&delete e[t]})),e}},{key:"getId",value:function(){return(this.get('attributes')||{}).id||this.ccid||this.cid}},{key:"setId",value:function(t,e){var n=N({},this.get('attributes'));return n.id=t,this.set('attributes',n,e),this}},{key:"getEl",value:function(t){var e=this.getView(t);return e&&e.el}},{key:"getView",value:function(t){var e=this.view,n=this.views;return t&&(e=n.filter((function(e){return e._getFrame()===t.view}))[0]),e}},{key:"getCurrentView",value:function(){var t=(this.em.get('currentFrame')||{}).model;return this.getView(t)}},{key:"__getScriptProps",value:function(){var t=this.props();return(this.get('script-props')||[]).reduce((function(e,n){return e[n]=t[n],e}),{})}},{key:"getScriptString",value:function(t){var e=this,n=t||this.get('script');if(!n)return n;if(this.get('script-props'))n=n.toString().trim();else{if('function'==typeof n){var r=n.toString().trim();n=(r=r.replace(/^function[\s\w]*\(\)\s?\{/,'').replace(/\}$/,'')).trim()}var o=this.em.getConfig(),a=I(o.tagVarStart||'{[ '),s=I(o.tagVarEnd||' ]}'),c=new RegExp("".concat(a,"([\\w\\d-]*)").concat(s),'g');n=n.replace(c,(function(t,n){e.scriptUpdated();var r=e.attributes[n]||'';return Object(O["isArray"])(r)||'object'==i()(r)?JSON.stringify(r):r}))}return n}},{key:"emitUpdate",value:function(t){for(var e=this.em,n=U+(t?":".concat(t):''),r=t&&this.get(t),i=arguments.length,o=new Array(i>1?i-1:0),a=1;a<i;a++)o[a-1]=arguments[a];t&&this.updated.apply(this,[t,r,t&&this.previous(t)].concat(o)),this.trigger.apply(this,[n].concat(o)),e&&e.trigger.apply(e,[n,this].concat(o)),['components','classes'].indexOf(t)>=0&&this.__propSelfToParent({component:this,changed:u()({},t,r),options:o[2]||o[1]||{}})}},{key:"onAll",value:function(t){return Object(O["isFunction"])(t)&&(t(this),this.components().forEach((function(e){return e.onAll(t)}))),this}},{key:"remove",value:function(){var t=this,e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},n=this.em,r=this.collection,i=function(){r&&r.remove(t,e),e.root&&t.components('')},o=N({},e);return[this,n].map((function(e){return e.trigger('component:remove:before',t,i,o)})),!o.abort&&i(),this}},{key:"move",value:function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};return this.remove({temporary:1}),t&&t.append(this,e),this}},{key:"resetId",value:function(){var t=this.em,e=this.getId();if(e){var r=n.createId(this);this.setId(r);var i=t&&t.get('CssComposer').getIdRule(e),o=i&&i.get('selectors').at(0);return o&&o.set('name',r),this}}},{key:"_getStyleRule",value:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},e=t.id,n=this.em,r=e||this.getId();return n&&n.get('CssComposer').getIdRule(r)}},{key:"_getStyleSelector",value:function(t){var e=this._getStyleRule(t);return e&&e.get('selectors').at(0)}},{key:"_idUpdated",value:function(t,e){var r=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};if(!r.idUpdate){var i=this.ccid,o=this.get('attributes')||{},a=o.id,s=(this.previous('attributes')||{}).id||i,c=n.getList(this);if(c[a]||!a&&s)return this.setId(s,{idUpdate:1});delete c[s],c[a]=this,this.ccid=a;var l=this._getStyleSelector({id:s});l&&l.set({name:a,label:a})}}}]),n}(k["Model"].extend(C["a"]));W.isComponent=function(t){return{tagName:Object(x["toLowerCase"])(t.tagName)}},W.ensureInList=function(t){var e=W.getList(t),n=t.getId(),r=e[n];if(r){if(r!==t){var i=W.getIncrementId(n,e);t.setId(i),e[i]=t}}else e[n]=t;t.components().forEach((function(t){return W.ensureInList(t)}))},W.createId=function(t){var e,n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},r=W.getList(t),i=n.idMap,o=void 0===i?{}:i,a=t.get('attributes'),s=a.id;return s?(e=W.getIncrementId(s,r,n),t.setId(e),s!==e&&(o[s]=e)):e=W.getNewId(r),r[e]=t,e},W.getNewId=function(t){for(var e=Object.keys(t).length.toString().length+2,n=(Math.random()+1.1).toString(36).slice(-e),r="i".concat(n);t[r];)r=W.getNewId(t);return r},W.getIncrementId=function(t,e){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},r=n.keepIds,i=void 0===r?[]:r,o=1,a=t;if(i.indexOf(t)<0)for(;e[a];)o++,a="".concat(t,"-").concat(o);return a},W.getList=function(t){var e=t.opt,n=void 0===e?{}:e,r=n.domc,i=n.em,o=r||i&&i.get('DomComponents');return o?o.componentsById:{}},W.checkId=function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:[],n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},r=arguments.length>3&&void 0!==arguments[3]?arguments[3]:{},i=Object(O["isArray"])(t)?t:[t],o=r.keepIds,a=void 0===o?[]:o;i.forEach((function(t){var i=t.attributes,o=void 0===i?{}:i,s=t.components,c=o.id;if(c&&n[c]&&a.indexOf(c)<0){var l=W.getIncrementId(c,n);o.id=l,Object(O["isArray"])(e)&&e.forEach((function(t){var e=t.selectors;e.forEach((function(t,n){t==="#".concat(c)&&(e[n]="#".concat(l))}))}))}s&&W.checkId(s,e,n,r)}))},W.getDefaults=function(){return Object(O["result"])(this.prototype,'defaults')},W.prototype.defaults=(M={tagName:'div',type:'',name:'',removable:!0,draggable:!0,droppable:!0,badgable:!0,stylable:!0,'stylable-require':'','style-signature':'',unstylable:'',highlightable:!0,copyable:!0,resizable:!1,editable:!1,layerable:!0,selectable:!0,hoverable:!0,void:!1,state:'',status:'',content:'',icon:'',style:'',styles:'',classes:'',script:'','script-props':'','script-export':'',attributes:'',traits:['id','title'],propagate:'',dmode:'',toolbar:null},u()(M,H,0),u()(M,z,0),u()(M,B,0),u()(M,"_undo",!0),u()(M,"_undoexc",['status','open']),M)},function(t,e,n){var r=n(79),i=n(80),o=n(50),a=n(81);t.exports=function(t){return r(t)||i(t)||o(t)||a()},t.exports["default"]=t.exports,t.exports.__esModule=!0},function(t,e,n){"use strict";n.r(e);var r=n(3),i=n.n(r),o=n(2),a=n.n(o),s=n(0),c=n(30),l=n(42),u=n(20),d=n(13),h=n(1);function f(t,e){var n=Object.keys(t);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(t);e&&(r=r.filter((function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable}))),n.push.apply(n,r)}return n}function p(t){for(var e=1;e<arguments.length;e++){var n=null!=arguments[e]?arguments[e]:{};e%2?f(Object(n),!0).forEach((function(e){i()(t,e,n[e])})):Object.getOwnPropertyDescriptors?Object.defineProperties(t,Object.getOwnPropertyDescriptors(n)):f(Object(n)).forEach((function(e){Object.defineProperty(t,e,Object.getOwnPropertyDescriptor(n,e))}))}return t}e["default"]=a.a.View.extend({className:function(){return this.getClasses()},tagName:function(){return this.model.get('tagName')},initialize:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},e=this.model,n=t.config||{},r=n.em,i=e.opt||{},o=this.$el,a=this.el;n.draggableComponents;this.opts=t,this.modelOpt=i,this.config=n,this.em=r||'',this.pfx=n.stylePrefix||'',this.ppfx=n.pStylePrefix||'',this.attr=e.get('attributes'),this.classe=this.attr.class||[],this.listenTo(e,'change:style',this.updateStyle),this.listenTo(e,'change:attributes change:_innertext',this.renderAttributes),this.listenTo(e,'change:highlightable',this.updateHighlight),this.listenTo(e,'change:status',this.updateStatus),this.listenTo(e,'change:script rerender',this.reset),this.listenTo(e,'change:content',this.updateContent),this.listenTo(e,'change',this.handleChange),this.listenTo(e,'active',this.onActive),this.listenTo(e,'disable',this.onDisable),o.data('model',e),Object(h["setViewEl"])(a,this),e.view=this,this._getFrame()&&e.views.push(this),this.initClasses(),this.initComponents({avoidRender:1}),this.events=p(p({},this.events),this.__isDraggable()&&{dragstart:'handleDragStart'}),this.delegateEvents(),!i.temporary&&this.init(this._clbObj())},__isDraggable:function(){var t=this.model,e=this.config,n=t.attributes,r=n._innertext,i=n.draggable;return e.draggableComponents&&i&&!r},_clbObj:function(){var t=this.em,e=this.model,n=this.el;return{editor:t&&t.getEditor(),model:e,el:n}},init:function(){},removed:function(){},onActive:function(){},onDisable:function(){},remove:function(){var t=this;a.a.View.prototype.remove.apply(t,arguments);var e=t.model,n=t._getFrame()||{},r=n.model;e.components().forEach((function(t){var e=t.getView(r);e&&e.remove()}));var i=t.childrenView;i&&i.remove();var o=e.views;return o.splice(o.indexOf(t),1),t.removed(t._clbObj()),t.$el.data({model:'',collection:'',view:''}),t},handleDragStart:function(t){t.preventDefault(),t.stopPropagation(),this.em.get('Commands').run('tlb-move',{target:this.model,event:t})},initClasses:function(){var t=this.model,e='change:classes',n=t.get('classes');n instanceof u["a"]&&(this.stopListening(t,e,this.initClasses),this.listenTo(t,e,this.initClasses),this.listenTo(n,'add remove change',this.updateClasses),n.length&&this.importClasses())},initComponents:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},e=this.model,n=this.$el,r=this.childrenView,i='change:components',o=e.get('components'),a=[e,i,this.initComponents];o instanceof c["a"]&&(n.data('collection',o),r&&r.remove(),this.stopListening.apply(this,a),!t.avoidRender&&this.renderChildren(),this.listenTo.apply(this,a))},handleChange:function(){var t=this.model,e=Object(s["keys"])(t.changed);if(1!==e.length||'status'!==e[0])for(var n in t.emitUpdate(),t.changed)t.emitUpdate(n)},importClasses:function(){var t=this.config.em.get('SelectorManager');t&&this.model.get('classes').each((function(e){t.add(e.get('name'))}))},updateStatus:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},e=this.em,n=e?e.get('Canvas').getConfig():{},r=n.extHl,i=this.el,o=this.model.get('status'),a=this.ppfx,s="".concat(a,"selected"),c="".concat(s,"-parent"),l="".concat(a,"freezed"),u="".concat(a,"hovered"),d=[s,c,l,u],h=r&&!t.noExtHl?'':s;this.$el.removeClass(d.join(' '));var f=i.getAttribute('class')||'',p='';switch(o){case'selected':p="".concat(f," ").concat(h);break;case'selected-parent':p="".concat(f," ").concat(c);break;case'freezed':p="".concat(f," ").concat(l);break;case'freezed-selected':p="".concat(f," ").concat(l," ").concat(h);break;case'hovered':p=t.avoidHover?'':"".concat(f," ").concat(u)}(p=p.trim())&&i.setAttribute('class',p)},updateHighlight:function(){var t=this.model.get('highlightable');this.setAttribute('data-highlightable',t?1:'')},updateStyle:function(t,e){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},r=this.model,i=this.em,o=this.el;if(i&&i.getConfig('avoidInlineStyle')&&!n.inline){var a=r.getStyle(),c=Object(s["isEmpty"])(a);!c&&r.setStyle(a),r.get('_innertext')&&c?o.removeAttribute('id'):o.id=r.getId()}else this.setAttribute('style',r.styleToString(n))},updateClasses:function(){var t=this.model.get('classes').pluck('name').join(' ');this.setAttribute('class',t),this.updateStatus(),this.onAttrUpdate()},setAttribute:function(t,e){var n=this.$el;e?n.attr(t,e):n.removeAttr(t)},getClasses:function(){return this.model.getClasses().join(' ')},updateAttributes:function(){var t=[],e=this.model,n=this.$el,r=this.el,i=e.attributes,o=i.highlightable,a=i.textable,c=p(p(p({'data-gjs-type':i.type||'default'},this.__isDraggable()?{draggable:!0}:{}),o?{'data-highlightable':1}:{}),a?{contenteditable:'false','data-gjs-textable':'true'}:{});Object(s["each"])(r.attributes,(function(e){return t.push(e.nodeName)})),t.forEach((function(t){return n.removeAttr(t)})),this.updateStyle();var l=p(p({},c),e.getAttributes());Object(s["keys"])(l).forEach((function(t){return!1===l[t]&&delete l[t]})),n.attr(l)},updateContent:function(){var t=this.model.get('content'),e=this.model.components().length;this.getChildrenContainer().innerHTML=e?'':t},prevDef:function(t){t.preventDefault()},updateScript:function(){var t=this.model,e=this.em;t.get('script')&&e&&e.get('Canvas').getCanvasView().updateScript(this)},getChildrenContainer:function(){var t=this.el;return'function'==typeof this.getChildrenSelector?t=this.el.querySelector(this.getChildrenSelector()):this.getTemplate,t},getOffsetRect:function(){var t={},e=this.el,n=0,r=0;return function i(o){var a=o.offsetParent;a?(n+=a.offsetTop,r+=a.offsetLeft,i(a)):(t.top=e.offsetTop+n,t.left=e.offsetLeft+r,t.bottom=t.top+e.offsetHeight,t.right=t.left+e.offsetWidth)}(e),t},isInViewport:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},e=t.rect,n=this.el,r=n.ownerDocument,i=r.body,o=r.defaultView.frameElement,a=e||this.getOffsetRect(),s=a.top,c=a.left,l=this._getFrame().getOffsetRect();return s>=l.scrollTop&&c>=l.scrollLeft&&s<=l.scrollBottom&&c<=o.offsetWidth+i.scrollLeft},scrollIntoView:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},e=this.getOffsetRect(),n=this.isInViewport({rect:e});if(!n||t.force){var r=this.el;'smooth'!==t.behavior?r.ownerDocument.defaultView.scrollTo(0,e.top):r.scrollIntoView(p({behavior:'smooth',block:'nearest'},t))}},reset:function(){var t=this.el;this.el='',this._ensureElement(),this._setData(),Object(d["m"])(t,this.el),this.render()},_setData:function(){var t=this.model,e=t.components();this.$el.data({model:t,collection:e,view:this})},_getFrame:function(){return this.config.frameView},renderChildren:function(){this.updateContent();var t=this.getChildrenContainer(),e=this.childrenView||new l["a"]({collection:this.model.get('components'),config:this.config,componentTypes:this.opts.componentTypes});e.render(t),this.childrenView=e;for(var n=Array.prototype.slice.call(e.el.childNodes),r=0,i=n.length;r<i;r++)t.appendChild(n.shift())},renderAttributes:function(){this.updateAttributes(),this.updateClasses()},onAttrUpdate:function(){},render:function(){return this.renderAttributes(),this.modelOpt.temporary||(this.renderChildren(),this.updateScript(),Object(h["setViewEl"])(this.el,this),this.postRender()),this},postRender:function(){var t=this.em,e=this.model;this.modelOpt.temporary||(this.onRender(this._clbObj()),t&&t.trigger('component:mount',e))},onRender:function(){}})},function(t,e,n){"use strict";n.d(e,"k",(function(){return a})),n.d(e,"i",(function(){return s})),n.d(e,"l",(function(){return c})),n.d(e,"h",(function(){return l})),n.d(e,"d",(function(){return u})),n.d(e,"j",(function(){return d})),n.d(e,"m",(function(){return h})),n.d(e,"b",(function(){return f})),n.d(e,"a",(function(){return p})),n.d(e,"f",(function(){return g})),n.d(e,"g",(function(){return v})),n.d(e,"e",(function(){return m})),n.d(e,"c",(function(){return y}));var r=n(0),i='tag',o='attributes',a='transitionend oTransitionEnd transitionend webkitTransitionEnd',s=function(t){return t&&9===t.nodeType},c=function(t){var e=t&&t.parentNode;e&&e.removeChild(t)},l=function(t,e){return t.querySelectorAll(e)},u=function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};return t&&t.setAttribute&&Object(r["each"])(e,(function(e,n){return t.setAttribute(n,e)}))},d=function(t){return t&&!!(t.offsetWidth||t.offsetHeight||t.getClientRects().length)},h=function(t,e){t.parentNode.replaceChild(e,t)},f=function(t,e,n){var i=t.childNodes,o=i.length,a=Object(r["isUndefined"])(n)?o:n;Object(r["isString"])(e)&&(t.insertAdjacentHTML('beforeEnd',e),e=t.lastChild,t.removeChild(e)),a>=o?t.appendChild(e):t.insertBefore(e,i[a])},p=function(t,e){return f(t,e)},g=function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:'',n=arguments.length>2?arguments[2]:void 0,i=document.createElement(t);return e&&Object(r["each"])(e,(function(t,e){return i.setAttribute(e,t)})),n&&(Object(r["isString"])(n)?i.innerHTML=n:i.appendChild(n)),i},v=function(t){return document.createTextNode(t)},m=function(t,e){var n,r=t.type;try{n=new window[e](r,t)}catch(t){(n=document.createEvent(e)).initEvent(r,!0,!0)}return n._parentEvent=t,0===r.indexOf('key')&&(n.keyCodeVal=t.keyCode,['keyCode','which'].forEach((function(t){Object.defineProperty(n,t,{get:function(){return this.keyCodeVal}})}))),n},y=function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:[],n=Array.isArray(e)?e:[e];n.forEach((function(e){var n=e[i]||'div',a=e[o]||{},s=document.createElement(n);Object(r["each"])(a,(function(t,e){s.setAttribute(e,t)})),t.appendChild(s)}))}},function(t,e){function n(e){return"function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?(t.exports=n=function(t){return typeof t},t.exports["default"]=t.exports,t.exports.__esModule=!0):(t.exports=n=function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},t.exports["default"]=t.exports,t.exports.__esModule=!0),n(e)}t.exports=n,t.exports["default"]=t.exports,t.exports.__esModule=!0},,function(t,e,n){"use strict";n.d(e,"a",(function(){return y}));var r=n(5),i=n.n(r),o=n(6),a=n.n(o),s=n(8),c=n.n(s),l=n(9),u=n.n(l),d=n(4),h=n.n(d),f=n(2),p=n(0);function g(t){var e=function(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],(function(){}))),!0}catch(t){return!1}}();return function(){var n,r=h()(t);if(e){var i=h()(this).constructor;n=Reflect.construct(r,arguments,i)}else n=r.apply(this,arguments);return u()(this,n)}}var v=1,m=2,y=function(t){c()(n,t);var e=g(n);function n(){return i()(this,n),e.apply(this,arguments)}return a()(n,[{key:"defaults",value:function(){return{name:'',label:'',type:v,active:!0,private:!1,protected:!1,_undo:!0}}},{key:"initialize",value:function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},r=e.config,i=void 0===r?{}:r,o=this.get('name'),a=this.get('label');o?a||this.set('label',o):this.set('name',a);var s=this.get('name'),c=i.escapeName,l=c?c(s):n.escapeName(s);this.set('name',l),this.em=i.em}},{key:"isId",value:function(){return this.get('type')===m}},{key:"isClass",value:function(){return this.get('type')===v}},{key:"getFullName",value:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},e=t.escape,n=this.get('name'),r='';switch(this.get('type')){case v:r='.';break;case m:r='#'}return r+(e?e(n):n)}},{key:"toString",value:function(){return this.getFullName()}},{key:"getLabel",value:function(){return this.get('label')}},{key:"setLabel",value:function(t){return this.set('label',t)}},{key:"getActive",value:function(){return this.get('active')}},{key:"setActive",value:function(t){return this.set('active',t)}},{key:"toJSON",value:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},e=this.em,n=f["Model"].prototype.toJSON.call(this,[t]),r=Object(p["result"])(this,'defaults');if(e&&e.getConfig('avoidDefaults')){Object(p["forEach"])(r,(function(t,e){n[e]===t&&delete n[e]})),n.label===n.name&&delete n.label;var i=Object(p["keys"])(n).length;1===i&&n.name&&(n=n.name),2===i&&n.name&&n.type&&(n=this.getFullName())}return n}}]),n}(f["Model"]);y.prototype.idAttribute='name',y.TYPE_CLASS=v,y.TYPE_ID=m,y.escapeName=function(t){return"".concat(t).trim().replace(/([^a-z0-9\w-\:]+)/gi,'-')}},function(t,e,n){"use strict";n.d(e,"a",(function(){return i}));var r=n(1);function i(t){for(var e=arguments.length,n=new Array(e>1?e-1:0),i=1;i<e;i++)n[i-1]=arguments[i];var o=t.raw;return o.reduce((function(t,e,i){var a=n[i-1],s=o[i-1];return Array.isArray(a)?a=a.join(''):s&&'$'===s.slice(-1)?t=t.slice(0,-1):a=Object(r["escape"])(a),t+a+e}))}},function(t,e,n){"use strict";n.r(e);var r='undefined'!=typeof document?document:null,i='undefined'!=typeof window?window:null,o=Array.prototype,a=o.filter,s=o.indexOf,c=o.map,l=o.push,u=o.reverse,d=o.slice,h=o.splice,f=/^#[\w-]*$/,p=/^\.[\w-]*$/,g=/<.+>/,v=/^\w+$/;function m(t,e){return void 0===e&&(e=r),p.test(t)?e.getElementsByClassName(t.slice(1)):v.test(t)?e.getElementsByTagName(t):e.querySelectorAll(t)}function y(t,e){if(void 0===e&&(e=r),t){if(t.__cash)return t;var n=t;if(P(t)){if(e.__cash&&(e=e[0]),!(n=f.test(t)?e.getElementById(t.slice(1)):g.test(t)?ft(t):m(t,e)))return}else if(T(t))return this.ready(t);(n.nodeType||n===i)&&(n=[n]),this.length=n.length;for(var o=0,a=this.length;o<a;o++)this[o]=n[o]}}function b(t,e){return new y(t,e)}var w=b.fn=b.prototype=y.prototype={constructor:b,__cash:!0,length:0,splice:h};w.get=function(t){return void 0===t?d.call(this):this[t<0?t+this.length:t]},w.eq=function(t){return b(this.get(t))},w.first=function(){return this.eq(0)},w.last=function(){return this.eq(-1)},w.map=function(t){return b(c.call(this,(function(e,n){return t.call(e,n,e)})))},w.slice=function(){return b(d.apply(this,arguments))};var O=/(?:^\w|[A-Z]|\b\w)/g,x=/[\s-_]+/g;function C(t){return t.replace(O,(function(t,e){return t[e?'toUpperCase':'toLowerCase']()})).replace(x,'')}function k(t,e){for(var n=0,r=t.length;n<r&&!1!==e.call(t[n],t[n],n,t);n++);}b.camelCase=C,b.each=k,w.each=function(t){return k(this,(function(e,n){return t.call(e,n,e)})),this},w.removeProp=function(t){return this.each((function(e,n){delete n[t]}))},b.extend=w.extend=function(t){void 0===t&&(t=this);for(var e=arguments,n=e.length,r=n<2?0:1;r<n;r++)for(var i in e[r])t[i]=e[r][i];return t};var S=1;function j(t,e){var n=t&&(t.matches||t.webkitMatchesSelector||t.mozMatchesSelector||t.msMatchesSelector||t.oMatchesSelector);return!!n&&n.call(t,e)}function T(t){return'function'==typeof t}function P(t){return'string'==typeof t}function E(t){return!isNaN(parseFloat(t))&&isFinite(t)}b.guid=S,b.matches=j,b.isFunction=T,b.isString=P,b.isNumeric=E;var _=Array.isArray;function M(t){return P(t)?function(e,n){return j(n,t)}:t.__cash?function(e,n){return t.is(n)}:function(t,e,n){return e===n}}b.isArray=_,w.prop=function(t,e){if(t){if(P(t))return arguments.length<2?this[0]&&this[0][t]:this.each((function(n,r){r[t]=e}));for(var n in t)this.prop(n,t[n]);return this}},w.filter=function(t){if(!t)return b();var e=T(t)?t:M(t);return b(a.call(this,(function(n,r){return e.call(n,r,n,t)})))};var D=/\S+/g;function A(t){return P(t)&&t.match(D)||[]}function L(t){return t.filter((function(t,e,n){return n.indexOf(t)===e}))}function N(t,e,n){if(1===t.nodeType){var r=i.getComputedStyle(t,null);return e?n?r.getPropertyValue(e):r[e]:r}}function R(t,e){return parseInt(N(t,e),10)||0}w.hasClass=function(t){var e=A(t),n=!1;return e.length&&this.each((function(t,r){return!(n=r.classList.contains(e[0]))})),n},w.removeAttr=function(t){var e=A(t);return e.length?this.each((function(t,n){k(e,(function(t){n.removeAttribute(t)}))})):this},w.attr=function(t,e){if(t){if(P(t)){if(arguments.length<2){if(!this[0])return;var n=this[0].getAttribute(t);return null===n?void 0:n}return null===e?this.removeAttr(t):this.each((function(n,r){r.setAttribute(t,e)}))}for(var r in t)this.attr(r,t[r]);return this}},w.toggleClass=function(t,e){var n=A(t),r=void 0!==e;return n.length?this.each((function(t,i){k(n,(function(t){r?e?i.classList.add(t):i.classList.remove(t):i.classList.toggle(t)}))})):this},w.addClass=function(t){return this.toggleClass(t,!0)},w.removeClass=function(t){return arguments.length?this.toggleClass(t,!1):this.attr('class','')},b.unique=L,w.add=function(t,e){return b(L(this.get().concat(b(t,e).get())))};var I=/^--/;function F(t){return I.test(t)}var V={},z=r&&r.createElement('div'),H=z?z.style:{},B=['webkit','moz','ms','o'];function U(t,e){if(void 0===e&&(e=F(t)),e)return t;if(!V[t]){var n=C(t),r=''+n.charAt(0).toUpperCase()+n.slice(1);k((n+' '+B.join(r+' ')+r).split(' '),(function(e){if(e in H)return V[t]=e,!1}))}return V[t]}b.prefixedProp=U;var $={animationIterationCount:!0,columnCount:!0,flexGrow:!0,flexShrink:!0,fontWeight:!0,lineHeight:!0,opacity:!0,order:!0,orphans:!0,widows:!0,zIndex:!0};function W(t,e,n){return void 0===n&&(n=F(t)),n||$[t]||!E(e)?e:e+'px'}w.css=function(t,e){if(P(t)){var n=F(t);return t=U(t,n),arguments.length<2?this[0]&&N(this[0],t,n):t?(e=W(t,e,n),this.each((function(r,i){1===i.nodeType&&(n?i.style.setProperty(t,e):i.style[t]=e)}))):this}for(var r in t)this.css(r,t[r]);return this};var q='__cashData',G=/^data-(.*)/;function K(t){return t[q]=t[q]||{}}function Y(t,e){var n=K(t);if(e){if(!(e in n)){var r=t.dataset?t.dataset[e]||t.dataset[C(e)]:b(t).attr('data-'+e);if(void 0!==r){try{r=JSON.parse(r)}catch(t){}n[e]=r}}return n[e]}return n}function X(t,e){return R(t,'border'+(e?'Left':'Top')+'Width')+R(t,'padding'+(e?'Left':'Top'))+R(t,'padding'+(e?'Right':'Bottom'))+R(t,'border'+(e?'Right':'Bottom')+'Width')}function J(t,e){for(var n=0,r=e.length;n<r;n++)if(t.indexOf(e[n])<0)return!1;return!0}function Z(t,e,n){k(t[n],(function(t){t[0];var r=t[1];e.removeEventListener(n,r)})),delete t[n]}b.hasData=function(t){return q in t},w.data=function(t,e){var n=this;if(!t){if(!this[0])return;return k(this[0].attributes,(function(t){var e=t.name.match(G);e&&n.data(e[1])})),Y(this[0])}if(P(t))return void 0===e?this[0]&&Y(this[0],t):this.each((function(n,r){return function(t,e,n){K(t)[e]=n}(r,t,e)}));for(var r in t)this.data(r,t[r]);return this},w.removeData=function(t){return this.each((function(e,n){return function(t,e){void 0===e?delete t[q]:delete K(t)[e]}(n,t)}))},k(['Width','Height'],(function(t){w['inner'+t]=function(){if(this[0])return this[0]===i?i['inner'+t]:this[0]['client'+t]}})),k(['width','height'],(function(t,e){w[t]=function(n){return this[0]?arguments.length?(n=parseInt(n,10),this.each((function(r,i){if(1===i.nodeType){var o=N(i,'boxSizing');i.style[t]=W(t,n+('border-box'===o?X(i,!e):0))}}))):this[0]===i?this[0][C('outer-'+t)]:this[0].getBoundingClientRect()[t]-X(this[0],!e):void 0===n?void 0:this}})),k(['Width','Height'],(function(t,e){w['outer'+t]=function(n){if(this[0])return this[0]===i?i['outer'+t]:this[0]['offset'+t]+(n?R(this[0],'margin'+(e?'Top':'Left'))+R(this[0],'margin'+(e?'Bottom':'Right')):0)}}));var Q='__cashEvents',tt='.';function et(t){return t[Q]=t[Q]||{}}function nt(t){var e=t.split(tt);return[e[0],e.slice(1).sort()]}function rt(t,e,n,r){var i=et(t);if(e){var o=i[e];if(!o)return;r&&(r.guid=r.guid||S++),i[e]=o.filter((function(i){var o=i[0],a=i[1];if(r&&a.guid!==r.guid||!J(o,n))return!0;t.removeEventListener(e,a)}))}else if(n&&n.length)for(e in i)rt(t,e,n,r);else for(e in i)Z(i,t,e)}w.off=function(t,e){var n=this;return void 0===t?this.each((function(t,e){return rt(e)})):k(A(t),(function(t){var r=nt(t),i=r[0],o=r[1];n.each((function(t,n){return rt(n,i,o,e)}))})),this},w.on=function(t,e,n,r){var i=this;if(!P(t)){for(var o in t)this.on(o,e,t[o]);return this}return T(e)&&(n=e,e=!1),k(A(t),(function(t){var o=nt(t),a=o[0],s=o[1];i.each((function(t,i){var o=function t(o){if(!o.namespace||J(s,o.namespace.split(tt))){var c=i;if(e){for(var l=o.target;!j(l,e);){if(l===i)return;if(!(l=l.parentNode))return}c=l}o.namespace=o.namespace||'';var u=n.call(c,o,o.data);r&&rt(i,a,s,t),!1===u&&(o.preventDefault(),o.stopPropagation())}};o.guid=n.guid=n.guid||S++,function(t,e,n,r){r.guid=r.guid||S++;var i=et(t);i[e]=i[e]||[],i[e].push([n,r]),t.addEventListener(e,r)}(i,a,s,o)}))})),this},w.one=function(t,e,n){return this.on(t,e,n,!0)},w.ready=function(t){var e=function(){return t(b)};return'loading'!==r.readyState?setTimeout(e):r.addEventListener('DOMContentLoaded',e),this},w.trigger=function(t,e){var n=t;if(P(t)){var i=nt(t),o=i[0],a=i[1];(n=r.createEvent('HTMLEvents')).initEvent(o,!0,!0),n.namespace=a.join(tt)}return n.data=e,this.each((function(t,e){e.dispatchEvent(n)}))};var it=/select-one/i,ot=/select-multiple/i;function at(t){var e=t.type;return it.test(e)?function(t){return t.selectedIndex<0?null:t.options[t.selectedIndex].value}(t):ot.test(e)?function(t){var e=[];return k(t.options,(function(t){!t.selected||t.disabled||t.parentNode.disabled||e.push(t.value)})),e}(t):t.value}var st=/%20/g;var ct=/file|reset|submit|button|image/i,lt=/radio|checkbox/i;w.serialize=function(){var t='';return this.each((function(e,n){k(n.elements||[n],(function(e){if(!e.disabled&&e.name&&'FIELDSET'!==e.tagName&&!ct.test(e.type)&&(!lt.test(e.type)||e.checked)){var n=at(e);if(void 0!==n)k(_(n)?n:[n],(function(n){t+=function(t,e){return'&'+encodeURIComponent(t)+'='+encodeURIComponent(e).replace(st,'+')}(e.name,n)}))}}))})),t.substr(1)},w.val=function(t){return void 0===t?this[0]&&at(this[0]):this.each((function(e,n){var r=ot.test(n.type),i=null===t?r?[]:'':t;r&&_(i)?k(n.options,(function(t){t.selected=i.indexOf(t.value)>=0})):n.value=i}))},w.clone=function(){return this.map((function(t,e){return e.cloneNode(!0)}))},w.detach=function(){return this.each((function(t,e){e.parentNode&&e.parentNode.removeChild(e)}))};var ut,dt=/^\s*<(\w+)[^>]*>/,ht=/^\s*<(\w+)\s*\/?>(?:<\/\1>)?\s*$/;function ft(t){if(function(){if(!ut){var t=r.createElement('table'),e=r.createElement('tr');ut={'*':r.createElement('div'),tr:r.createElement('tbody'),td:e,th:e,thead:t,tbody:t,tfoot:t}}}(),!P(t))return[];if(ht.test(t))return[r.createElement(RegExp.$1)];var e=dt.test(t)&&RegExp.$1,n=ut[e]||ut['*'];return n.innerHTML=t,b(n.childNodes).detach().get()}function pt(t,e,n){if(void 0!==e){var r=P(e);!r&&e.length?k(e,(function(e){return pt(t,e,n)})):k(t,r?function(t){t.insertAdjacentHTML(n?'afterbegin':'beforeend',e)}:function(t,r){return function(t,e,n){n?t.insertBefore(e,t.childNodes[0]):t.appendChild(e)}(t,r?e.cloneNode(!0):e,n)})}}b.parseHTML=ft,w.empty=function(){var t=this[0];if(t)for(;t.firstChild;)t.removeChild(t.firstChild);return this},w.append=function(){var t=this;return k(arguments,(function(e){pt(t,e)})),this},w.appendTo=function(t){return pt(b(t),this),this},w.html=function(t){if(void 0===t)return this[0]&&this[0].innerHTML;var e=t.nodeType?t[0].outerHTML:t;return this.each((function(t,n){n.innerHTML=e}))},w.insertAfter=function(t){var e=this;return b(t).each((function(t,n){var r=n.parentNode;e.each((function(e,i){r.insertBefore(t?i.cloneNode(!0):i,n.nextSibling)}))})),this},w.after=function(){var t=this;return k(u.apply(arguments),(function(e){u.apply(b(e).slice()).insertAfter(t)})),this},w.insertBefore=function(t){var e=this;return b(t).each((function(t,n){var r=n.parentNode;e.each((function(e,i){r.insertBefore(t?i.cloneNode(!0):i,n)}))})),this},w.before=function(){var t=this;return k(arguments,(function(e){b(e).insertBefore(t)})),this},w.prepend=function(){var t=this;return k(arguments,(function(e){pt(t,e,!0)})),this},w.prependTo=function(t){return pt(b(t),u.apply(this.slice()),!0),this},w.remove=function(){return this.detach().off()},w.replaceWith=function(t){var e=this;return this.each((function(n,r){var i=r.parentNode;if(i){var o=n?b(t).clone():b(t);if(!o[0])return e.remove(),!1;i.replaceChild(o[0],r),b(o[0]).after(o.slice(1))}}))},w.replaceAll=function(t){return b(t).replaceWith(this),this},w.text=function(t){return void 0===t?this[0]?this[0].textContent:'':this.each((function(e,n){n.textContent=t}))};var gt=r&&r.documentElement;w.offset=function(){var t=this[0];if(t){var e=t.getBoundingClientRect();return{top:e.top+i.pageYOffset-gt.clientTop,left:e.left+i.pageXOffset-gt.clientLeft}}},w.offsetParent=function(){return b(this[0]&&this[0].offsetParent)},w.position=function(){var t=this[0];if(t)return{left:t.offsetLeft,top:t.offsetTop}},w.children=function(t){var e=[];return this.each((function(t,n){l.apply(e,n.children)})),e=b(L(e)),t?e.filter((function(e,n){return j(n,t)})):e},w.contents=function(){var t=[];return this.each((function(e,n){l.apply(t,'IFRAME'===n.tagName?[n.contentDocument]:n.childNodes)})),b(t.length&&L(t))},w.find=function(t){for(var e=[],n=0,r=this.length;n<r;n++){var i=m(t,this[n]);i.length&&l.apply(e,i)}return b(e.length&&L(e))},w.has=function(t){var e=P(t)?function(e,n){return!!m(t,n).length}:function(e,n){return n.contains(t)};return this.filter(e)},w.is=function(t){if(!t||!this[0])return!1;var e=M(t),n=!1;return this.each((function(r,i){return!(n=e(r,i,t))})),n},w.next=function(){return b(this[0]&&this[0].nextElementSibling)},w.not=function(t){if(!t||!this[0])return this;var e=M(t);return this.filter((function(n,r){return!e(n,r,t)}))},w.parent=function(){var t=[];return this.each((function(e,n){n&&n.parentNode&&t.push(n.parentNode)})),b(L(t))},w.index=function(t){var e=t?b(t)[0]:this[0],n=t?this:b(e).parent().children();return s.call(n,e)},w.closest=function(t){return t&&this[0]?this.is(t)?this.filter(t):this.parent().closest(t):b()},w.parents=function(t){var e,n=[];return this.each((function(i,o){for(e=o;e&&e.parentNode&&e!==r.body.parentNode;)e=e.parentNode,(!t||t&&j(e,t))&&n.push(e)})),b(L(n))},w.prev=function(){return b(this[0]&&this[0].previousElementSibling)},w.siblings=function(){var t=this[0];return this.parent().children().filter((function(e,n){return n!==t}))},e["default"]=b},function(t,e){t.exports=function(t,e){return e||(e=t.slice(0)),Object.freeze(Object.defineProperties(t,{raw:{value:Object.freeze(e)}}))},t.exports["default"]=t.exports,t.exports.__esModule=!0},function(t,e,n){"use strict";n.d(e,"a",(function(){return m}));var r=n(5),i=n.n(r),o=n(6),a=n.n(o),s=n(8),c=n.n(s),l=n(9),u=n.n(l),d=n(4),h=n.n(d),f=n(0),p=n(2),g=n(16);function v(t){var e=function(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],(function(){}))),!0}catch(t){return!1}}();return function(){var n,r=h()(t);if(e){var i=h()(this).constructor;n=Reflect.construct(r,arguments,i)}else n=r.apply(this,arguments);return u()(this,n)}}var m=function(t){c()(n,t);var e=v(n);function n(){return i()(this,n),e.apply(this,arguments)}return a()(n,[{key:"modelId",value:function(t){return"".concat(t.name,"_").concat(t.type||g["a"].TYPE_CLASS)}},{key:"getStyleable",value:function(){return Object(f["filter"])(this.models,(function(t){return t.get('active')&&!t.get('private')}))}},{key:"getValid",value:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},e=t.noDisabled;return Object(f["filter"])(this.models,(function(t){return!t.get('private')})).filter((function(t){return e?t.get('active'):1}))}},{key:"getFullString",value:function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},n=[],r=t||this;return r.forEach((function(t){return n.push(t.getFullName(e))})),n.join('').trim()}}]),n}(p["Collection"]);m.prototype.model=g["a"]},function(t,e,n){"use strict";var r=n(3),i=n.n(r),o=n(11),a=n.n(o),s=n(0),c=n(1);function l(t,e){var n=Object.keys(t);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(t);e&&(r=r.filter((function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable}))),n.push.apply(n,r)}return n}function u(t){for(var e=1;e<arguments.length;e++){var n=null!=arguments[e]?arguments[e]:{};e%2?l(Object(n),!0).forEach((function(e){i()(t,e,n[e])})):Object.getOwnPropertyDescriptors?Object.defineProperties(t,Object.getOwnPropertyDescriptors(n)):l(Object(n)).forEach((function(e){Object.defineProperty(t,e,Object.getOwnPropertyDescriptor(n,e))}))}return t}e["a"]={getConfig:function(t){return this.__getConfig(t)},__getConfig:function(t){var e=this.config||{};return t?e[t]:e},getAll:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};return this.all?t.array?a()(this.all.models):this.all:[]},getAllMap:function(){return this.getAll().reduce((function(t,e){return t[e.get(e.idAttribute)]=e,t}),{})},__initConfig:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};this.config=u(u({},t),e),this.em=this.config.em},__initListen:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},e=this.all,n=this.em,r=this.events;e&&n&&e.on('add',(function(t,e,i){return n.trigger(r.add,t,i)})).on('remove',(function(t,e,i){return n.trigger(r.remove,t,i)})).on('change',(function(t,e){return n.trigger(r.update,t,t.changedAttributes(),e)})).on('all',this.__catchAllEvent,this),this.cls=[e].concat(t.collections||[]),(t.propagate||[]).forEach((function(t){var r=t.entity,i=t.event;r.on('all',(function(t,r,o,a){var s=u({event:t},a||o);[n,e].map((function(t){return t.trigger(i,r,s)}))}))}))},__remove:function(t){var e=this,n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},r=this.em,i=Object(s["isString"])(t)?this.get(t):t,o=function(){return i&&e.all.remove(i,n),i};return!n.silent&&r&&r.trigger(this.events.removeBefore,i,o,n),!n.abort&&o()},__catchAllEvent:function(t,e,n,r){var i=this.em,o=this.events,a=r||n;i&&o.all&&i.trigger(o.all,{event:t,model:e,options:a}),this.__onAllEvent()},__appendTo:function(){var t=this.getConfig().appendTo;if(t){var e=Object(s["isElement"])(t)?t:document.querySelector(t);if(!e)return this.__logWarn('"appendTo" element not found');e.appendChild(this.render())}},__onAllEvent:function(){},__logWarn:function(t){this.em.logWarning("[".concat(this.name,"]: ").concat(t))},_createId:function(){var t,e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:16,n=this.getAll(),r=n.length+e,i=this.getAllMap();do{t=Object(c["createId"])(r)}while(i[t]);return t},__destroy:function(){this.cls.forEach((function(t){t.stopListening(),t.reset()})),this.em=0}}},function(t,e,n){var r=n(82);t.exports=function(t,e){if(null==t)return{};var n,i,o=r(t,e);if(Object.getOwnPropertySymbols){var a=Object.getOwnPropertySymbols(t);for(i=0;i<a.length;i++)n=a[i],e.indexOf(n)>=0||Object.prototype.propertyIsEnumerable.call(t,n)&&(o[n]=t[n])}return o},t.exports["default"]=t.exports,t.exports.__esModule=!0},function(t,e,n){"use strict";n.r(e);var r=n(14),i=n.n(r),o=n(3),a=n.n(o),s=n(2),c=n.n(s),l=n(0),u=n(1),d=n(13),h=n(29);function f(t,e){var n=Object.keys(t);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(t);e&&(r=r.filter((function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable}))),n.push.apply(n,r)}return n}function p(t){for(var e=1;e<arguments.length;e++){var n=null!=arguments[e]?arguments[e]:{};e%2?f(Object(n),!0).forEach((function(e){a()(t,e,n[e])})):Object.getOwnPropertyDescriptors?Object.defineProperties(t,Object.getOwnPropertyDescriptors(n)):f(Object(n)).forEach((function(e){Object.defineProperty(t,e,Object.getOwnPropertyDescriptor(n,e))}))}return t}var g=c.a.View.extend({events:function(){return this.model.get('events')||{mousedown:'handleClick'}},attributes:function(){return this.model.get('attributes')},initialize:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},e=t.config,n=void 0===e?{}:e;this.em=n.em,this.editor=n.editor},handleClick:function(t){t.preventDefault(),t.stopPropagation();var e=this.editor,n=this.em,r=e.Canvas.getFrameEl().getBoundingClientRect(),i=r.left,o=r.top,a=p(p({},t),{},{clientX:t.clientX-i,clientY:t.clientY-o});n.trigger('toolbar:run:before'),this.execCommand(a)},execCommand:function(t){var e={event:t},n=this.model.get('command'),r=this.editor;'function'==typeof n&&n(r,null,e),'string'==typeof n&&r.runCommand(n,e)},render:function(){var t=this.editor,e=this.$el,n=this.model,r=n.get('id'),i=n.get('label'),o=t.getConfig('stylePrefix');return e.addClass("".concat(o,"toolbar-item")),r&&e.addClass("".concat(o,"toolbar-item__").concat(r)),i&&e.append(i),this}}),v=h["a"].extend({itemView:g,initialize:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};this.config={editor:t.editor||'',em:t.em},this.listenTo(this.collection,'reset',this.render)}}),m=c.a.Model.extend({defaults:{command:'',attributes:{}}}),y=c.a.Collection.extend({model:m});function b(t,e){var n=Object.keys(t);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(t);e&&(r=r.filter((function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable}))),n.push.apply(n,r)}return n}function w(t){for(var e=1;e<arguments.length;e++){var n=null!=arguments[e]?arguments[e]:{};e%2?b(Object(n),!0).forEach((function(e){a()(t,e,n[e])})):Object.getOwnPropertyDescriptors?Object.defineProperties(t,Object.getOwnPropertyDescriptors(n)):b(Object(n)).forEach((function(e){Object.defineProperty(t,e,Object.getOwnPropertyDescriptor(n,e))}))}return t}var O,x=c.a.$;e["default"]={init:function(t){Object(l["bindAll"])(this,'onHover','onOut','onClick','onFrameScroll','onFrameUpdated','onContainerChange')},enable:function(){this.frameOff=this.canvasOff=this.adjScroll=null,this.startSelectComponent(),O=1},startSelectComponent:function(){this.toggleSelectComponent(1),this.em.getSelected()&&this.onSelect()},stopSelectComponent:function(){this.toggleSelectComponent()},toggleSelectComponent:function(t){var e=this,n=this.em,r=n.getConfig('listenToEl'),i=n.getContainer().parentNode,o=t?'on':'off',a={on:u["on"],off:u["off"]};!r.length&&i&&r.push(i);a[o](window,'resize',this.onFrameUpdated),a[o](r,'scroll',this.onContainerChange),n[o]('component:toggled component:update',this.onSelect,this),n[o]('change:componentHovered',this.onHovered,this),n[o]('component:resize component:styleUpdate component:input',this.updateGlobalPos,this),n[o]('component:update:toolbar',this._upToolbar,this),n[o]('change:canvasOffset',this.updateAttached,this),n[o]('frame:updated',this.onFrameUpdated,this),n[o]('canvas:updateTools',this.onFrameUpdated,this),n.get('Canvas').getFrames().forEach((function(t){var n,r,i=t.view;i&&(n=i.getWindow(),r=i.getBody(),a[o](r,'mouseover',e.onHover),a[o](r,'mouseleave',e.onOut),a[o](r,'click touchend',e.onClick),a[o](n,'scroll',e.onFrameScroll,!0))}))},onHover:function(t){t.stopPropagation();var e=t.target,n=Object(u["getViewEl"])(e),r=n&&n._getFrame(),i=x(e),o=i.data('model');if(!o)for(var a=i.parent();!o&&a.length&&!Object(d["i"])(a[0]);)o=a.data('model'),a=a.parent();if(o&&!o.get('hoverable')){for(var s=o&&o.parent();s&&!s.get('hoverable');)s=s.parent();o=s}this.currentDoc=e.ownerDocument,this.em.setHovered(o),r&&this.em.set('currentFrame',r)},onFrameUpdated:function(){this.updateLocalPos(),this.updateGlobalPos()},onHovered:function(t,e){var n=this,r={};e?e.views.forEach((function(t){var i=t.el,o=n.getElementPos(i);r={el:i,pos:o,component:e,view:Object(u["getViewEl"])(i)},n.updateToolsLocal(r),i.ownerDocument===n.currentDoc&&(n.elHovered=r)})):(this.currentDoc=null,this.elHovered=0,this.updateToolsLocal(),this.canvas.getFrames().forEach((function(t){var e=t.view,r=e&&e.getToolsEl();r&&n.toggleToolsEl(0,0,{el:r})})))},onSelect:Object(l["debounce"])((function(){var t=this.em,e=t.getSelected(),n=t.get('currentFrame')||{},r=e&&e.getView(n.model),i=r&&r.el,o={};i&&Object(d["j"])(i)&&(o={el:i,pos:this.getElementPos(i),component:e,view:Object(u["getViewEl"])(i)});this.elSelected=o,this.updateToolsGlobal(),this.updateLocalPos(o),this.initResize(e)})),updateGlobalPos:function(){var t=this.getElSelected();t.el&&(t.pos=this.getElementPos(t.el),this.updateToolsGlobal())},updateLocalPos:function(t){var e=this.getElHovered();e.el&&(e.pos=this.getElementPos(e.el),this.updateToolsLocal(t))},getElHovered:function(){return this.elHovered||{}},getElSelected:function(){return this.elSelected||{}},onOut:function(){this.em.setHovered(0)},toggleToolsEl:function(t,e){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},r=n.el||this.canvas.getToolsEl(e);return r&&(r.style.display=t?'':'none'),r||{}},showElementOffset:function(t,e){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};O&&this.editor.runCommand('show-offset',{el:t,elPos:e,view:n.view,force:1,top:0,left:0})},hideElementOffset:function(t){this.editor.stopCommand('show-offset',{view:t})},showFixedElementOffset:function(t,e){this.editor.runCommand('show-offset',{el:t,elPos:e,state:'Fixed'})},hideFixedElementOffset:function(t,e){this.editor&&this.editor.stopCommand('show-offset',{state:'Fixed'})},hideHighlighter:function(t){this.canvas.getHighlighter(t).style.opacity=0},onClick:function(t){t.stopPropagation(),t.preventDefault();var e=this.em;if(e.get('_cmpDrag'))return e.set('_cmpDrag');var n=x(t.target),r=n.data('model');if(!r)for(var i=n.parent();!r&&i.length&&!Object(d["i"])(i[0]);)r=i.data('model'),i=i.parent();if(r)if(r.get('selectable'))this.select(r,t);else{for(var o=r.parent();o&&!o.get('selectable');)o=o.parent();this.select(o,t)}},select:function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};t&&(this.editor.select(t,{scroll:{},event:e}),this.initResize(t))},updateBadge:function(t,e){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},r=this.canvas,i=x(t).data('model');if(i&&i.get('badgable')){var o=this.getBadge(n);if(!n.posOnly){var a=this.canvas.getConfig(),s=i.getIcon(),c=a.pStylePrefix||'',l="".concat(c,"badge"),u=a.customBadgeLabel,d="".concat(s?"<div class=\"".concat(l,"__icon\">").concat(s,"</div>"):'',"\n        <div class=\"").concat(l,"__name\">").concat(i.getName(),"</div>");o.innerHTML=u?u(i):d}var h='px',f=o.style;f.display='block';var p=r.getTargetToElementFixed(t,o,{pos:e}),g=p.top,v=n.leftOff<0?-n.leftOff:0;f.top=g+h,f.left=v+h}},showHighlighter:function(t){this.canvas.getHighlighter(t).style.opacity=''},initResize:function(t){var e,n=this.em,r=this.canvas,o=n?n.get('Editor'):'',a=(n?n.get('Config'):'').stylePrefix||'',s="".concat(a,"resizing"),c=!Object(l["isElement"])(t)&&Object(u["isTaggableNode"])(t)?t:n.getSelected(),d=c&&c.get('resizable'),h={},f=function(t,e,n){var r=n.docs;r&&r.forEach((function(e){var n=e.body,r=n.className||'';n.className=('add'==t?"".concat(r," ").concat(s):r.replace(s,'')).trim()}))};if(o&&d){var p=Object(l["isElement"])(t)?t:c.getEl();h={onStart:function(t){var i=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},o=i.el,a=i.config,s=i.resizer,l=a.keyHeight,d=a.keyWidth,h=a.currentUnit,p=a.keepAutoHeight,g=a.keepAutoWidth;f('add',0,i),e=n.get('StyleManager').getModelToStyle(c),r.toggleFramesEvents();var v=getComputedStyle(o),m=e.getStyle(),y=m[d];a.autoWidth=g&&'auto'===y,isNaN(parseFloat(y))&&(y=v[d]);var b=m[l];a.autoHeight=p&&'auto'===b,isNaN(parseFloat(b))&&(b=v[l]),s.startDim.w=parseFloat(y),s.startDim.h=parseFloat(b),O=0,h&&(a.unitHeight=Object(u["getUnitFromValue"])(b),a.unitWidth=Object(u["getUnitFromValue"])(y))},onMove:function(){o.trigger('component:resize')},onEnd:function(t,e){f('remove',0,e),o.trigger('component:resize'),r.toggleFramesEvents(1),O=1},updateTarget:function(t,i){var o=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};if(e){var a=o.store,s=o.selectedHandler,c=o.config,l=c.keyHeight,u=c.keyWidth,d=c.autoHeight,h=c.autoWidth,f=c.unitWidth,p=c.unitHeight,g=['tc','bc'].indexOf(s)>=0,v=['cl','cr'].indexOf(s)>=0,m={},y=a?'':1;if(!g){var b=r.getBody().offsetWidth,O=i.w<b?i.w:b;m[u]=h?'auto':"".concat(O).concat(f)}v||(m[l]=d?'auto':"".concat(i.h).concat(p)),e.addStyle(w(w({},m),{},{en:y}),{avoidStore:!a});var x="update:component:style",C="".concat(x,":").concat(l," ").concat(x,":").concat(u);n&&n.trigger(C,null,null,{noEmit:1})}}},'object'==i()(d)&&(h=w(w(w({},h),d),{},{parent:h})),this.resizer=o.runCommand('resize',{el:p,options:h,force:1})}else o.stopCommand('resize'),this.resizer=null},updateToolbar:function(t){var e=this.config.em,n=t==e?e.getSelected():t,r=this.canvas.getToolbarEl(),i=r.style,o=n.get('toolbar'),a=e.get('Config').showToolbar;if(n&&a&&o&&o.length){if(i.display='',!this.toolbar){r.innerHTML='',this.toolbar=new y(o);var s=new v({collection:this.toolbar,editor:this.editor,em:e});r.appendChild(s.render().el)}this.toolbar.reset(o),i.top='-100px',i.left=0}else i.display='none'},updateToolbarPos:function(t){var e='px',n=this.canvas.getToolbarEl().style;n.top="".concat(t.top).concat(e),n.left="".concat(t.left).concat(e),n.opacity=''},getCanvasPosition:function(){return this.canvas.getCanvasView().getPosition()},getBadge:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};return this.canvas.getBadgeEl(t.view)},onFrameScroll:function(){this.updateTools()},updateTools:function(){this.updateLocalPos(),this.updateGlobalPos()},isCompSelected:function(t){return t&&'selected'===t.get('status')},updateToolsLocal:function(t){var e=t||this.getElHovered(),n=e.el,r=e.pos,i=e.view,o=e.component;if(n){var a=o.get('hoverable'),s=this.lastHovered!==n,c=s?{}:{posOnly:1};s&&a&&(this.lastHovered=n,this.showHighlighter(i),this.showElementOffset(n,r,{view:i})),this.isCompSelected(o)&&(this.hideHighlighter(i),this.hideElementOffset(i));var l='px',u=this.toggleToolsEl(1,i),d=u.style,h=this.canvas.canvasRectOffset(n,r),f=h.top,p=h.left;this.updateBadge(n,r,w(w({},c),{},{view:i,topOff:f,leftOff:p})),d.top=f+l,d.left=p+l,d.width=r.width+l,d.height=r.height+l,this._trgToolUp('local',{component:o,el:u,top:f,left:p,width:r.width,height:r.height})}else this.lastHovered=0},_upToolbar:Object(l["debounce"])((function(){this.updateToolsGlobal({force:1})})),_trgToolUp:function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};this.em.trigger('canvas:tools:update',w({type:t},e))},updateToolsGlobal:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},e=this.getElSelected(),n=e.el,r=e.pos,i=e.component;if(!n)return this.toggleToolsEl(),void(this.lastSelected=0);var o=this.canvas,a=this.lastSelected!==n;(a||t.force)&&(this.lastSelected=n,this.updateToolbar(i));var s='px',c=this.toggleToolsEl(1),l=c.style,u=o.getTargetToElementFixed(n,o.getToolbarEl(),{pos:r}),d=u.canvasOffsetTop,h=u.canvasOffsetLeft;l.top=d+s,l.left=h+s,l.width=r.width+s,l.height=r.height+s,this.updateToolbarPos({top:u.top,left:u.left}),this._trgToolUp('global',{component:i,el:c,top:d,left:h,width:r.width,height:r.height})},updateAttached:Object(l["debounce"])((function(){this.updateGlobalPos()})),onContainerChange:Object(l["debounce"])((function(){this.em.refreshCanvas()}),150),getElementPos:function(t){return this.canvas.getCanvasView().getElementPos(t)},hideBadge:function(){this.getBadge().style.display='none'},cleanPrevious:function(t){t&&t.set({status:'',state:''})},getContentWindow:function(){return this.canvas.getWindow()},run:function(t){Object(u["hasWin"])()&&(this.editor=t&&t.get('Editor'),this.enable())},stop:function(t,e){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};if(Object(u["hasWin"])()){var r=this.em,i=this.editor;this.onHovered(),this.stopSelectComponent(),!n.preserveSelected&&r.setSelected(null),this.toggleToolsEl(),i&&i.stopCommand('resize')}}}},function(t,e,n){"use strict";n.d(e,"a",(function(){return f}));var r=n(3),i=n.n(r),o=n(5),a=n.n(o),s=n(6),c=n.n(s),l=n(0),u=n(1);function d(t,e){var n=Object.keys(t);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(t);e&&(r=r.filter((function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable}))),n.push.apply(n,r)}return n}function h(t){for(var e=1;e<arguments.length;e++){var n=null!=arguments[e]?arguments[e]:{};e%2?d(Object(n),!0).forEach((function(e){i()(t,e,n[e])})):Object.getOwnPropertyDescriptors?Object.defineProperties(t,Object.getOwnPropertyDescriptors(n)):d(Object(n)).forEach((function(e){Object.defineProperty(t,e,Object.getOwnPropertyDescriptor(n,e))}))}return t}var f=function(){function t(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};return a()(this,t),this.opts={container:null,onStart:null,onDrag:null,onEnd:null,setPosition:null,getPosition:null,guidesStatic:null,guidesTarget:null,snapOffset:5,doc:0,scale:1},Object(l["bindAll"])(this,'drag','stop','keyHandle','handleScroll'),this.setOptions(e),this.delta={x:0,y:0},this}return c()(t,[{key:"setOptions",value:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};this.opts=h(h({},this.opts),t)}},{key:"toggleDrag",value:function(t){var e=this.getDocumentEl(),n=this.getContainerEl(),r=this.getWindowEl(),i=t?'on':'off',o={on:u["on"],off:u["off"]};o[i](n,'mousemove dragover',this.drag),o[i](e,'mouseup dragend touchend',this.stop),o[i](e,'keydown',this.keyHandle),o[i](r,'scroll',this.handleScroll)}},{key:"handleScroll",value:function(){var t=this.lastScroll,e=this.delta,n=this.getScrollInfo(),r={x:n.x-t.x,y:n.y-t.y};this.move(e.x+r.x,e.y+r.y),this.lastScrollDiff=r}},{key:"start",value:function(t){var e=this.opts,n=e.onStart;this.toggleDrag(1),this.startPointer=this.getPointerPos(t),this.guidesStatic=Object(l["result"])(e,'guidesStatic')||[],this.guidesTarget=Object(l["result"])(e,'guidesTarget')||[],Object(l["isFunction"])(n)&&n(t,this),this.startPosition=this.getStartPosition(),this.lastScrollDiff={x:0,y:0},this.globScrollDiff={x:0,y:0},this.drag(t)}},{key:"drag",value:function(t){var e=this,n=this.opts,r=this.lastScrollDiff,i=this.globScrollDiff,o=n.onDrag,a=this.startPointer,s=this.getPointerPos(t),c={x:i.x+r.x,y:i.y+r.y};this.globScrollDiff=c;var u={x:s.x-a.x+c.x,y:s.y-a.y+c.y};this.lastScrollDiff={x:0,y:0};var d=this.lockedAxis;'x'===(d=t.shiftKey?!d&&this.detectAxisLock(u.x,u.y):null)?u.x=a.x:'y'===d&&(u.y=a.y);var f=function(r){['x','y'].forEach((function(t){return r[t]=r[t]*Object(l["result"])(n,'scale')})),e.delta=r,e.move(r.x,r.y),Object(l["isFunction"])(o)&&o(t,e)},p=h({},u);if(this.currentPointer=s,this.lockedAxis=d,this.lastScroll=this.getScrollInfo(),f(u),this.guidesTarget.length){var g=this.snapGuides(p),v=g.newDelta,m=g.trgX,y=g.trgY;(m||y)&&f(v)}0===t.which&&this.stop(t)}},{key:"snapGuides",value:function(t){var e=this,n=t,r=this.trgX,i=this.trgY;return this.guidesTarget.forEach((function(n){n.x&&e.trgX||n.y&&e.trgY||(n.active=0,e.guidesStatic.forEach((function(o){if(!(n.y&&o.x||n.x&&o.y)){var a=n.y&&o.y,s=a?'y':'x',c=n[s],u=o[s],d=t[s],h=a?i:r;if(e.isPointIn(c,u)&&Object(l["isUndefined"])(h)){var f=d-(c-u);e.setGuideLock(n,f)}}})))})),r=this.trgX,i=this.trgY,['x','y'].forEach((function(r){var i=r.toUpperCase(),o=e["trg".concat(i)];o&&!e.isPointIn(t[r],o.lock)&&(e.setGuideLock(o,null),o=null),o&&!Object(l["isUndefined"])(o.lock)&&(n[r]=o.lock)})),{newDelta:n,trgX:this.trgX,trgY:this.trgY}}},{key:"isPointIn",value:function(t,e){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},r=n.offset,i=r||this.opts.snapOffset;return t>=e&&t<=e+i||t<=e&&t>=e-i}},{key:"setGuideLock",value:function(t,e){var n=Object(l["isUndefined"])(t.x)?'Y':'X',r="trg".concat(n);return null!==e?(t.active=1,t.lock=e,this[r]=t):(delete t.active,delete t.lock,delete this[r]),t}},{key:"stop",value:function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},n=this.delta,r=e.cancel,i=r?0:n.x,o=r?0:n.y;this.toggleDrag(),this.lockedAxis=null,this.move(i,o,1);var a=this.opts.onEnd;Object(l["isFunction"])(a)&&a(t,this,{cancelled:r})}},{key:"keyHandle",value:function(t){Object(u["isEscKey"])(t)&&this.stop(t,{cancel:1})}},{key:"move",value:function(t,e,n){var r=this.el,i=this.opts,o=this.startPosition;if(o){var a=i.setPosition,s=o.x+t,c=o.y+e;this.position={x:s,y:c,end:n},Object(l["isFunction"])(a)&&a(this.position),r&&(r.style.left="".concat(s,"px"),r.style.top="".concat(c,"px"))}}},{key:"getContainerEl",value:function(){var t=this.opts.container;return t?[t]:this.getDocumentEl()}},{key:"getWindowEl",value:function(){return this.getContainerEl().map((function(t){var e=t.ownerDocument||t;return e.defaultView||e.parentWindow}))}},{key:"getDocumentEl",value:function(t){var e=this.opts.doc;if(t=t||this.el,!this.docs){var n=[document];t&&n.push(t.ownerDocument),e&&n.push(e),this.docs=n}return this.docs}},{key:"getPointerPos",value:function(t){var e=this.opts.getPointerPosition,n=Object(u["getPointerEvent"])(t);return e?e(t):{x:n.clientX,y:n.clientY}}},{key:"getStartPosition",value:function(){var t=this.el,e=this.opts.getPosition,n={x:0,y:0};return Object(l["isFunction"])(e)?n=e():t&&(n={x:parseFloat(t.style.left),y:parseFloat(t.style.top)}),n}},{key:"getScrollInfo",value:function(){var t=this.opts.doc,e=t&&t.body;return{y:e?e.scrollTop:0,x:e?e.scrollLeft:0}}},{key:"detectAxisLock",value:function(t,e){var n=t,r=e,i=Math.abs(n),o=Math.abs(r);return r>=i||r<=-i?'x':n>o||n<-o?'y':void 0}}]),t}()},function(t,e,n){"use strict";var r=n(2),i=n.n(r),o=i.a.$;e["a"]=i.a.View.extend({events:{change:'handleChange'},template:function(){return"<span class=\"".concat(this.holderClass(),"\"></span>")},inputClass:function(){return"".concat(this.ppfx,"field")},holderClass:function(){return"".concat(this.ppfx,"input-holder")},initialize:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},e=t.ppfx||'';this.opts=t,this.ppfx=e,this.em=t.target||{},this.listenTo(this.model,'change:value',this.handleModelChange)},elementUpdated:function(){this.model.trigger('el:change')},setValue:function(t){var e=this.model,n=t||e.get('defaults'),r=this.getInputEl();r&&(r.value=n)},handleModelChange:function(t,e,n){this.setValue(e,n)},handleChange:function(t){t.stopPropagation();var e=this.getInputEl().value;this.__onInputChange(e),this.elementUpdated()},__onInputChange:function(t){this.model.set({value:t},{fromInput:1})},getInputEl:function(){if(!this.inputEl){var t=this.model,e=this.opts.type||'text',n=t.get('placeholder')||t.get('defaults')||t.get('default')||'';this.inputEl=o("<input type=\"".concat(e,"\" placeholder=\"").concat(n,"\">"))}return this.inputEl.get(0)},render:function(){this.inputEl=null;var t=this.$el;return t.addClass(this.inputClass()),t.html(this.template()),t.find(".".concat(this.holderClass())).append(this.getInputEl()),this}})},function(t,e,n){t.exports=n(93)},function(t,e,n){ true&&(t.exports=function(){'use strict';var t=navigator.userAgent,e=navigator.platform,n=/gecko\/\d/i.test(t),r=/MSIE \d/.test(t),i=/Trident\/(?:[7-9]|\d{2,})\..*rv:(\d+)/.exec(t),o=/Edge\/(\d+)/.exec(t),a=r||i||o,s=a&&(r?document.documentMode||6:+(o||i)[1]),c=!o&&/WebKit\//.test(t),l=c&&/Qt\/\d+\.\d+/.test(t),u=!o&&/Chrome\//.test(t),d=/Opera\//.test(t),h=/Apple Computer/.test(navigator.vendor),f=/Mac OS X 1\d\D([8-9]|\d\d)\D/.test(t),p=/PhantomJS/.test(t),g=h&&(/Mobile\/\w+/.test(t)||navigator.maxTouchPoints>2),v=/Android/.test(t),m=g||v||/webOS|BlackBerry|Opera Mini|Opera Mobi|IEMobile/i.test(t),y=g||/Mac/.test(e),b=/\bCrOS\b/.test(t),w=/win/i.test(e),O=d&&t.match(/Version\/(\d*\.\d*)/);O&&(O=Number(O[1])),O&&O>=15&&(d=!1,c=!0);var x=y&&(l||d&&(null==O||O<12.11)),C=n||a&&s>=9;function k(t){return new RegExp("(^|\\s)"+t+"(?:$|\\s)\\s*")}var S,j=function(t,e){var n=t.className,r=k(e).exec(n);if(r){var i=n.slice(r.index+r[0].length);t.className=n.slice(0,r.index)+(i?r[1]+i:"")}};function T(t){for(var e=t.childNodes.length;e>0;--e)t.removeChild(t.firstChild);return t}function P(t,e){return T(t).appendChild(e)}function E(t,e,n,r){var i=document.createElement(t);if(n&&(i.className=n),r&&(i.style.cssText=r),"string"==typeof e)i.appendChild(document.createTextNode(e));else if(e)for(var o=0;o<e.length;++o)i.appendChild(e[o]);return i}function _(t,e,n,r){var i=E(t,e,n,r);return i.setAttribute("role","presentation"),i}function M(t,e){if(3==e.nodeType&&(e=e.parentNode),t.contains)return t.contains(e);do{if(11==e.nodeType&&(e=e.host),e==t)return!0}while(e=e.parentNode)}function D(){var t;try{t=document.activeElement}catch(e){t=document.body||null}for(;t&&t.shadowRoot&&t.shadowRoot.activeElement;)t=t.shadowRoot.activeElement;return t}function A(t,e){var n=t.className;k(e).test(n)||(t.className+=(n?" ":"")+e)}function L(t,e){for(var n=t.split(" "),r=0;r<n.length;r++)n[r]&&!k(n[r]).test(e)&&(e+=" "+n[r]);return e}S=document.createRange?function(t,e,n,r){var i=document.createRange();return i.setEnd(r||t,n),i.setStart(t,e),i}:function(t,e,n){var r=document.body.createTextRange();try{r.moveToElementText(t.parentNode)}catch(t){return r}return r.collapse(!0),r.moveEnd("character",n),r.moveStart("character",e),r};var N=function(t){t.select()};function R(t){var e=Array.prototype.slice.call(arguments,1);return function(){return t.apply(null,e)}}function I(t,e,n){for(var r in e||(e={}),t)!t.hasOwnProperty(r)||!1===n&&e.hasOwnProperty(r)||(e[r]=t[r]);return e}function F(t,e,n,r,i){null==e&&-1==(e=t.search(/[^\s\u00a0]/))&&(e=t.length);for(var o=r||0,a=i||0;;){var s=t.indexOf("\t",o);if(s<0||s>=e)return a+(e-o);a+=s-o,a+=n-a%n,o=s+1}}g?N=function(t){t.selectionStart=0,t.selectionEnd=t.value.length}:a&&(N=function(t){try{t.select()}catch(t){}});var V=function(){this.id=null,this.f=null,this.time=0,this.handler=R(this.onTimeout,this)};function z(t,e){for(var n=0;n<t.length;++n)if(t[n]==e)return n;return-1}V.prototype.onTimeout=function(t){t.id=0,t.time<=+new Date?t.f():setTimeout(t.handler,t.time-+new Date)},V.prototype.set=function(t,e){this.f=e;var n=+new Date+t;(!this.id||n<this.time)&&(clearTimeout(this.id),this.id=setTimeout(this.handler,t),this.time=n)};var H=50,B={toString:function(){return"CodeMirror.Pass"}},U={scroll:!1},$={origin:"*mouse"},W={origin:"+move"};function q(t,e,n){for(var r=0,i=0;;){var o=t.indexOf("\t",r);-1==o&&(o=t.length);var a=o-r;if(o==t.length||i+a>=e)return r+Math.min(a,e-i);if(i+=o-r,r=o+1,(i+=n-i%n)>=e)return r}}var G=[""];function K(t){for(;G.length<=t;)G.push(Y(G)+" ");return G[t]}function Y(t){return t[t.length-1]}function X(t,e){for(var n=[],r=0;r<t.length;r++)n[r]=e(t[r],r);return n}function J(){}function Z(t,e){var n;return Object.create?n=Object.create(t):(J.prototype=t,n=new J),e&&I(e,n),n}var Q=/[\u00df\u0587\u0590-\u05f4\u0600-\u06ff\u3040-\u309f\u30a0-\u30ff\u3400-\u4db5\u4e00-\u9fcc\uac00-\ud7af]/;function tt(t){return/\w/.test(t)||t>""&&(t.toUpperCase()!=t.toLowerCase()||Q.test(t))}function et(t,e){return e?!!(e.source.indexOf("\\w")>-1&&tt(t))||e.test(t):tt(t)}function nt(t){for(var e in t)if(t.hasOwnProperty(e)&&t[e])return!1;return!0}var rt=/[\u0300-\u036f\u0483-\u0489\u0591-\u05bd\u05bf\u05c1\u05c2\u05c4\u05c5\u05c7\u0610-\u061a\u064b-\u065e\u0670\u06d6-\u06dc\u06de-\u06e4\u06e7\u06e8\u06ea-\u06ed\u0711\u0730-\u074a\u07a6-\u07b0\u07eb-\u07f3\u0816-\u0819\u081b-\u0823\u0825-\u0827\u0829-\u082d\u0900-\u0902\u093c\u0941-\u0948\u094d\u0951-\u0955\u0962\u0963\u0981\u09bc\u09be\u09c1-\u09c4\u09cd\u09d7\u09e2\u09e3\u0a01\u0a02\u0a3c\u0a41\u0a42\u0a47\u0a48\u0a4b-\u0a4d\u0a51\u0a70\u0a71\u0a75\u0a81\u0a82\u0abc\u0ac1-\u0ac5\u0ac7\u0ac8\u0acd\u0ae2\u0ae3\u0b01\u0b3c\u0b3e\u0b3f\u0b41-\u0b44\u0b4d\u0b56\u0b57\u0b62\u0b63\u0b82\u0bbe\u0bc0\u0bcd\u0bd7\u0c3e-\u0c40\u0c46-\u0c48\u0c4a-\u0c4d\u0c55\u0c56\u0c62\u0c63\u0cbc\u0cbf\u0cc2\u0cc6\u0ccc\u0ccd\u0cd5\u0cd6\u0ce2\u0ce3\u0d3e\u0d41-\u0d44\u0d4d\u0d57\u0d62\u0d63\u0dca\u0dcf\u0dd2-\u0dd4\u0dd6\u0ddf\u0e31\u0e34-\u0e3a\u0e47-\u0e4e\u0eb1\u0eb4-\u0eb9\u0ebb\u0ebc\u0ec8-\u0ecd\u0f18\u0f19\u0f35\u0f37\u0f39\u0f71-\u0f7e\u0f80-\u0f84\u0f86\u0f87\u0f90-\u0f97\u0f99-\u0fbc\u0fc6\u102d-\u1030\u1032-\u1037\u1039\u103a\u103d\u103e\u1058\u1059\u105e-\u1060\u1071-\u1074\u1082\u1085\u1086\u108d\u109d\u135f\u1712-\u1714\u1732-\u1734\u1752\u1753\u1772\u1773\u17b7-\u17bd\u17c6\u17c9-\u17d3\u17dd\u180b-\u180d\u18a9\u1920-\u1922\u1927\u1928\u1932\u1939-\u193b\u1a17\u1a18\u1a56\u1a58-\u1a5e\u1a60\u1a62\u1a65-\u1a6c\u1a73-\u1a7c\u1a7f\u1b00-\u1b03\u1b34\u1b36-\u1b3a\u1b3c\u1b42\u1b6b-\u1b73\u1b80\u1b81\u1ba2-\u1ba5\u1ba8\u1ba9\u1c2c-\u1c33\u1c36\u1c37\u1cd0-\u1cd2\u1cd4-\u1ce0\u1ce2-\u1ce8\u1ced\u1dc0-\u1de6\u1dfd-\u1dff\u200c\u200d\u20d0-\u20f0\u2cef-\u2cf1\u2de0-\u2dff\u302a-\u302f\u3099\u309a\ua66f-\ua672\ua67c\ua67d\ua6f0\ua6f1\ua802\ua806\ua80b\ua825\ua826\ua8c4\ua8e0-\ua8f1\ua926-\ua92d\ua947-\ua951\ua980-\ua982\ua9b3\ua9b6-\ua9b9\ua9bc\uaa29-\uaa2e\uaa31\uaa32\uaa35\uaa36\uaa43\uaa4c\uaab0\uaab2-\uaab4\uaab7\uaab8\uaabe\uaabf\uaac1\uabe5\uabe8\uabed\udc00-\udfff\ufb1e\ufe00-\ufe0f\ufe20-\ufe26\uff9e\uff9f]/;function it(t){return t.charCodeAt(0)>=768&&rt.test(t)}function ot(t,e,n){for(;(n<0?e>0:e<t.length)&&it(t.charAt(e));)e+=n;return e}function at(t,e,n){for(var r=e>n?-1:1;;){if(e==n)return e;var i=(e+n)/2,o=r<0?Math.ceil(i):Math.floor(i);if(o==e)return t(o)?e:n;t(o)?n=o:e=o+r}}var st=null;function ct(t,e,n){var r;st=null;for(var i=0;i<t.length;++i){var o=t[i];if(o.from<e&&o.to>e)return i;o.to==e&&(o.from!=o.to&&"before"==n?r=i:st=i),o.from==e&&(o.from!=o.to&&"before"!=n?r=i:st=i)}return null!=r?r:st}var lt=function(){var t="bbbbbbbbbtstwsbbbbbbbbbbbbbbssstwNN%%%NNNNNN,N,N1111111111NNNNNNNLLLLLLLLLLLLLLLLLLLLLLLLLLNNNNNNLLLLLLLLLLLLLLLLLLLLLLLLLLNNNNbbbbbbsbbbbbbbbbbbbbbbbbbbbbbbbbb,N%%%%NNNNLNNNNN%%11NLNNN1LNNNNNLLLLLLLLLLLLLLLLLLLLLLLNLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLN",e="nnnnnnNNr%%r,rNNmmmmmmmmmmmrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrmmmmmmmmmmmmmmmmmmmmmnnnnnnnnnn%nnrrrmrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrmmmmmmmnNmmmmmmrrmmNmmmmrr1111111111",n=/[\u0590-\u05f4\u0600-\u06ff\u0700-\u08ac]/,r=/[stwN]/,i=/[LRr]/,o=/[Lb1n]/,a=/[1n]/;function s(t,e,n){this.level=t,this.from=e,this.to=n}return function(c,l){var u="ltr"==l?"L":"R";if(0==c.length||"ltr"==l&&!n.test(c))return!1;for(var d,h=c.length,f=[],p=0;p<h;++p)f.push((d=c.charCodeAt(p))<=247?t.charAt(d):1424<=d&&d<=1524?"R":1536<=d&&d<=1785?e.charAt(d-1536):1774<=d&&d<=2220?"r":8192<=d&&d<=8203?"w":8204==d?"b":"L");for(var g=0,v=u;g<h;++g){var m=f[g];"m"==m?f[g]=v:v=m}for(var y=0,b=u;y<h;++y){var w=f[y];"1"==w&&"r"==b?f[y]="n":i.test(w)&&(b=w,"r"==w&&(f[y]="R"))}for(var O=1,x=f[0];O<h-1;++O){var C=f[O];"+"==C&&"1"==x&&"1"==f[O+1]?f[O]="1":","!=C||x!=f[O+1]||"1"!=x&&"n"!=x||(f[O]=x),x=C}for(var k=0;k<h;++k){var S=f[k];if(","==S)f[k]="N";else if("%"==S){var j=void 0;for(j=k+1;j<h&&"%"==f[j];++j);for(var T=k&&"!"==f[k-1]||j<h&&"1"==f[j]?"1":"N",P=k;P<j;++P)f[P]=T;k=j-1}}for(var E=0,_=u;E<h;++E){var M=f[E];"L"==_&&"1"==M?f[E]="L":i.test(M)&&(_=M)}for(var D=0;D<h;++D)if(r.test(f[D])){var A=void 0;for(A=D+1;A<h&&r.test(f[A]);++A);for(var L="L"==(D?f[D-1]:u),N=L==("L"==(A<h?f[A]:u))?L?"L":"R":u,R=D;R<A;++R)f[R]=N;D=A-1}for(var I,F=[],V=0;V<h;)if(o.test(f[V])){var z=V;for(++V;V<h&&o.test(f[V]);++V);F.push(new s(0,z,V))}else{var H=V,B=F.length,U="rtl"==l?1:0;for(++V;V<h&&"L"!=f[V];++V);for(var $=H;$<V;)if(a.test(f[$])){H<$&&(F.splice(B,0,new s(1,H,$)),B+=U);var W=$;for(++$;$<V&&a.test(f[$]);++$);F.splice(B,0,new s(2,W,$)),B+=U,H=$}else++$;H<V&&F.splice(B,0,new s(1,H,V))}return"ltr"==l&&(1==F[0].level&&(I=c.match(/^\s+/))&&(F[0].from=I[0].length,F.unshift(new s(0,0,I[0].length))),1==Y(F).level&&(I=c.match(/\s+$/))&&(Y(F).to-=I[0].length,F.push(new s(0,h-I[0].length,h)))),"rtl"==l?F.reverse():F}}();function ut(t,e){var n=t.order;return null==n&&(n=t.order=lt(t.text,e)),n}var dt=[],ht=function(t,e,n){if(t.addEventListener)t.addEventListener(e,n,!1);else if(t.attachEvent)t.attachEvent("on"+e,n);else{var r=t._handlers||(t._handlers={});r[e]=(r[e]||dt).concat(n)}};function ft(t,e){return t._handlers&&t._handlers[e]||dt}function pt(t,e,n){if(t.removeEventListener)t.removeEventListener(e,n,!1);else if(t.detachEvent)t.detachEvent("on"+e,n);else{var r=t._handlers,i=r&&r[e];if(i){var o=z(i,n);o>-1&&(r[e]=i.slice(0,o).concat(i.slice(o+1)))}}}function gt(t,e){var n=ft(t,e);if(n.length)for(var r=Array.prototype.slice.call(arguments,2),i=0;i<n.length;++i)n[i].apply(null,r)}function vt(t,e,n){return"string"==typeof e&&(e={type:e,preventDefault:function(){this.defaultPrevented=!0}}),gt(t,n||e.type,t,e),xt(e)||e.codemirrorIgnore}function mt(t){var e=t._handlers&&t._handlers.cursorActivity;if(e)for(var n=t.curOp.cursorActivityHandlers||(t.curOp.cursorActivityHandlers=[]),r=0;r<e.length;++r)-1==z(n,e[r])&&n.push(e[r])}function yt(t,e){return ft(t,e).length>0}function bt(t){t.prototype.on=function(t,e){ht(this,t,e)},t.prototype.off=function(t,e){pt(this,t,e)}}function wt(t){t.preventDefault?t.preventDefault():t.returnValue=!1}function Ot(t){t.stopPropagation?t.stopPropagation():t.cancelBubble=!0}function xt(t){return null!=t.defaultPrevented?t.defaultPrevented:0==t.returnValue}function Ct(t){wt(t),Ot(t)}function kt(t){return t.target||t.srcElement}function St(t){var e=t.which;return null==e&&(1&t.button?e=1:2&t.button?e=3:4&t.button&&(e=2)),y&&t.ctrlKey&&1==e&&(e=3),e}var jt,Tt,Pt=function(){if(a&&s<9)return!1;var t=E('div');return"draggable"in t||"dragDrop"in t}();function Et(t){if(null==jt){var e=E("span","​");P(t,E("span",[e,document.createTextNode("x")])),0!=t.firstChild.offsetHeight&&(jt=e.offsetWidth<=1&&e.offsetHeight>2&&!(a&&s<8))}var n=jt?E("span","​"):E("span"," ",null,"display: inline-block; width: 1px; margin-right: -1px");return n.setAttribute("cm-text",""),n}function _t(t){if(null!=Tt)return Tt;var e=P(t,document.createTextNode("AخA")),n=S(e,0,1).getBoundingClientRect(),r=S(e,1,2).getBoundingClientRect();return T(t),!(!n||n.left==n.right)&&(Tt=r.right-n.right<3)}var Mt,Dt=3!="\n\nb".split(/\n/).length?function(t){for(var e=0,n=[],r=t.length;e<=r;){var i=t.indexOf("\n",e);-1==i&&(i=t.length);var o=t.slice(e,"\r"==t.charAt(i-1)?i-1:i),a=o.indexOf("\r");-1!=a?(n.push(o.slice(0,a)),e+=a+1):(n.push(o),e=i+1)}return n}:function(t){return t.split(/\r\n?|\n/)},At=window.getSelection?function(t){try{return t.selectionStart!=t.selectionEnd}catch(t){return!1}}:function(t){var e;try{e=t.ownerDocument.selection.createRange()}catch(t){}return!(!e||e.parentElement()!=t)&&0!=e.compareEndPoints("StartToEnd",e)},Lt="oncopy"in(Mt=E("div"))||(Mt.setAttribute("oncopy","return;"),"function"==typeof Mt.oncopy),Nt=null,Rt={},It={};function Ft(t,e){arguments.length>2&&(e.dependencies=Array.prototype.slice.call(arguments,2)),Rt[t]=e}function Vt(t){if("string"==typeof t&&It.hasOwnProperty(t))t=It[t];else if(t&&"string"==typeof t.name&&It.hasOwnProperty(t.name)){var e=It[t.name];"string"==typeof e&&(e={name:e}),(t=Z(e,t)).name=e.name}else{if("string"==typeof t&&/^[\w\-]+\/[\w\-]+\+xml$/.test(t))return Vt("application/xml");if("string"==typeof t&&/^[\w\-]+\/[\w\-]+\+json$/.test(t))return Vt("application/json")}return"string"==typeof t?{name:t}:t||{name:"null"}}function zt(t,e){e=Vt(e);var n=Rt[e.name];if(!n)return zt(t,"text/plain");var r=n(t,e);if(Ht.hasOwnProperty(e.name)){var i=Ht[e.name];for(var o in i)i.hasOwnProperty(o)&&(r.hasOwnProperty(o)&&(r["_"+o]=r[o]),r[o]=i[o])}if(r.name=e.name,e.helperType&&(r.helperType=e.helperType),e.modeProps)for(var a in e.modeProps)r[a]=e.modeProps[a];return r}var Ht={};function Bt(t,e){I(e,Ht.hasOwnProperty(t)?Ht[t]:Ht[t]={})}function Ut(t,e){if(!0===e)return e;if(t.copyState)return t.copyState(e);var n={};for(var r in e){var i=e[r];i instanceof Array&&(i=i.concat([])),n[r]=i}return n}function $t(t,e){for(var n;t.innerMode&&(n=t.innerMode(e))&&n.mode!=t;)e=n.state,t=n.mode;return n||{mode:t,state:e}}function Wt(t,e,n){return!t.startState||t.startState(e,n)}var qt=function(t,e,n){this.pos=this.start=0,this.string=t,this.tabSize=e||8,this.lastColumnPos=this.lastColumnValue=0,this.lineStart=0,this.lineOracle=n};function Gt(t,e){if((e-=t.first)<0||e>=t.size)throw new Error("There is no line "+(e+t.first)+" in the document.");for(var n=t;!n.lines;)for(var r=0;;++r){var i=n.children[r],o=i.chunkSize();if(e<o){n=i;break}e-=o}return n.lines[e]}function Kt(t,e,n){var r=[],i=e.line;return t.iter(e.line,n.line+1,(function(t){var o=t.text;i==n.line&&(o=o.slice(0,n.ch)),i==e.line&&(o=o.slice(e.ch)),r.push(o),++i})),r}function Yt(t,e,n){var r=[];return t.iter(e,n,(function(t){r.push(t.text)})),r}function Xt(t,e){var n=e-t.height;if(n)for(var r=t;r;r=r.parent)r.height+=n}function Jt(t){if(null==t.parent)return null;for(var e=t.parent,n=z(e.lines,t),r=e.parent;r;e=r,r=r.parent)for(var i=0;r.children[i]!=e;++i)n+=r.children[i].chunkSize();return n+e.first}function Zt(t,e){var n=t.first;t:do{for(var r=0;r<t.children.length;++r){var i=t.children[r],o=i.height;if(e<o){t=i;continue t}e-=o,n+=i.chunkSize()}return n}while(!t.lines);for(var a=0;a<t.lines.length;++a){var s=t.lines[a].height;if(e<s)break;e-=s}return n+a}function Qt(t,e){return e>=t.first&&e<t.first+t.size}function te(t,e){return String(t.lineNumberFormatter(e+t.firstLineNumber))}function ee(t,e,n){if(void 0===n&&(n=null),!(this instanceof ee))return new ee(t,e,n);this.line=t,this.ch=e,this.sticky=n}function ne(t,e){return t.line-e.line||t.ch-e.ch}function re(t,e){return t.sticky==e.sticky&&0==ne(t,e)}function ie(t){return ee(t.line,t.ch)}function oe(t,e){return ne(t,e)<0?e:t}function ae(t,e){return ne(t,e)<0?t:e}function se(t,e){return Math.max(t.first,Math.min(e,t.first+t.size-1))}function ce(t,e){if(e.line<t.first)return ee(t.first,0);var n=t.first+t.size-1;return e.line>n?ee(n,Gt(t,n).text.length):function(t,e){var n=t.ch;return null==n||n>e?ee(t.line,e):n<0?ee(t.line,0):t}(e,Gt(t,e.line).text.length)}function le(t,e){for(var n=[],r=0;r<e.length;r++)n[r]=ce(t,e[r]);return n}qt.prototype.eol=function(){return this.pos>=this.string.length},qt.prototype.sol=function(){return this.pos==this.lineStart},qt.prototype.peek=function(){return this.string.charAt(this.pos)||void 0},qt.prototype.next=function(){if(this.pos<this.string.length)return this.string.charAt(this.pos++)},qt.prototype.eat=function(t){var e=this.string.charAt(this.pos);if("string"==typeof t?e==t:e&&(t.test?t.test(e):t(e)))return++this.pos,e},qt.prototype.eatWhile=function(t){for(var e=this.pos;this.eat(t););return this.pos>e},qt.prototype.eatSpace=function(){for(var t=this.pos;/[\s\u00a0]/.test(this.string.charAt(this.pos));)++this.pos;return this.pos>t},qt.prototype.skipToEnd=function(){this.pos=this.string.length},qt.prototype.skipTo=function(t){var e=this.string.indexOf(t,this.pos);if(e>-1)return this.pos=e,!0},qt.prototype.backUp=function(t){this.pos-=t},qt.prototype.column=function(){return this.lastColumnPos<this.start&&(this.lastColumnValue=F(this.string,this.start,this.tabSize,this.lastColumnPos,this.lastColumnValue),this.lastColumnPos=this.start),this.lastColumnValue-(this.lineStart?F(this.string,this.lineStart,this.tabSize):0)},qt.prototype.indentation=function(){return F(this.string,null,this.tabSize)-(this.lineStart?F(this.string,this.lineStart,this.tabSize):0)},qt.prototype.match=function(t,e,n){if("string"!=typeof t){var r=this.string.slice(this.pos).match(t);return r&&r.index>0?null:(r&&!1!==e&&(this.pos+=r[0].length),r)}var i=function(t){return n?t.toLowerCase():t};if(i(this.string.substr(this.pos,t.length))==i(t))return!1!==e&&(this.pos+=t.length),!0},qt.prototype.current=function(){return this.string.slice(this.start,this.pos)},qt.prototype.hideFirstChars=function(t,e){this.lineStart+=t;try{return e()}finally{this.lineStart-=t}},qt.prototype.lookAhead=function(t){var e=this.lineOracle;return e&&e.lookAhead(t)},qt.prototype.baseToken=function(){var t=this.lineOracle;return t&&t.baseToken(this.pos)};var ue=function(t,e){this.state=t,this.lookAhead=e},de=function(t,e,n,r){this.state=e,this.doc=t,this.line=n,this.maxLookAhead=r||0,this.baseTokens=null,this.baseTokenPos=1};function he(t,e,n,r){var i=[t.state.modeGen],o={};Oe(t,e.text,t.doc.mode,n,(function(t,e){return i.push(t,e)}),o,r);for(var a=n.state,s=function(r){n.baseTokens=i;var s=t.state.overlays[r],c=1,l=0;n.state=!0,Oe(t,e.text,s.mode,n,(function(t,e){for(var n=c;l<t;){var r=i[c];r>t&&i.splice(c,1,t,i[c+1],r),c+=2,l=Math.min(t,r)}if(e)if(s.opaque)i.splice(n,c-n,t,"overlay "+e),c=n+2;else for(;n<c;n+=2){var o=i[n+1];i[n+1]=(o?o+" ":"")+"overlay "+e}}),o),n.state=a,n.baseTokens=null,n.baseTokenPos=1},c=0;c<t.state.overlays.length;++c)s(c);return{styles:i,classes:o.bgClass||o.textClass?o:null}}function fe(t,e,n){if(!e.styles||e.styles[0]!=t.state.modeGen){var r=pe(t,Jt(e)),i=e.text.length>t.options.maxHighlightLength&&Ut(t.doc.mode,r.state),o=he(t,e,r);i&&(r.state=i),e.stateAfter=r.save(!i),e.styles=o.styles,o.classes?e.styleClasses=o.classes:e.styleClasses&&(e.styleClasses=null),n===t.doc.highlightFrontier&&(t.doc.modeFrontier=Math.max(t.doc.modeFrontier,++t.doc.highlightFrontier))}return e.styles}function pe(t,e,n){var r=t.doc,i=t.display;if(!r.mode.startState)return new de(r,!0,e);var o=function(t,e,n){for(var r,i,o=t.doc,a=n?-1:e-(t.doc.mode.innerMode?1e3:100),s=e;s>a;--s){if(s<=o.first)return o.first;var c=Gt(o,s-1),l=c.stateAfter;if(l&&(!n||s+(l instanceof ue?l.lookAhead:0)<=o.modeFrontier))return s;var u=F(c.text,null,t.options.tabSize);(null==i||r>u)&&(i=s-1,r=u)}return i}(t,e,n),a=o>r.first&&Gt(r,o-1).stateAfter,s=a?de.fromSaved(r,a,o):new de(r,Wt(r.mode),o);return r.iter(o,e,(function(n){ge(t,n.text,s);var r=s.line;n.stateAfter=r==e-1||r%5==0||r>=i.viewFrom&&r<i.viewTo?s.save():null,s.nextLine()})),n&&(r.modeFrontier=s.line),s}function ge(t,e,n,r){var i=t.doc.mode,o=new qt(e,t.options.tabSize,n);for(o.start=o.pos=r||0,""==e&&ve(i,n.state);!o.eol();)me(i,o,n.state),o.start=o.pos}function ve(t,e){if(t.blankLine)return t.blankLine(e);if(t.innerMode){var n=$t(t,e);return n.mode.blankLine?n.mode.blankLine(n.state):void 0}}function me(t,e,n,r){for(var i=0;i<10;i++){r&&(r[0]=$t(t,n).mode);var o=t.token(e,n);if(e.pos>e.start)return o}throw new Error("Mode "+t.name+" failed to advance stream.")}de.prototype.lookAhead=function(t){var e=this.doc.getLine(this.line+t);return null!=e&&t>this.maxLookAhead&&(this.maxLookAhead=t),e},de.prototype.baseToken=function(t){if(!this.baseTokens)return null;for(;this.baseTokens[this.baseTokenPos]<=t;)this.baseTokenPos+=2;var e=this.baseTokens[this.baseTokenPos+1];return{type:e&&e.replace(/( |^)overlay .*/,""),size:this.baseTokens[this.baseTokenPos]-t}},de.prototype.nextLine=function(){this.line++,this.maxLookAhead>0&&this.maxLookAhead--},de.fromSaved=function(t,e,n){return e instanceof ue?new de(t,Ut(t.mode,e.state),n,e.lookAhead):new de(t,Ut(t.mode,e),n)},de.prototype.save=function(t){var e=!1!==t?Ut(this.doc.mode,this.state):this.state;return this.maxLookAhead>0?new ue(e,this.maxLookAhead):e};var ye=function(t,e,n){this.start=t.start,this.end=t.pos,this.string=t.current(),this.type=e||null,this.state=n};function be(t,e,n,r){var i,o,a=t.doc,s=a.mode,c=Gt(a,(e=ce(a,e)).line),l=pe(t,e.line,n),u=new qt(c.text,t.options.tabSize,l);for(r&&(o=[]);(r||u.pos<e.ch)&&!u.eol();)u.start=u.pos,i=me(s,u,l.state),r&&o.push(new ye(u,i,Ut(a.mode,l.state)));return r?o:new ye(u,i,l.state)}function we(t,e){if(t)for(;;){var n=t.match(/(?:^|\s+)line-(background-)?(\S+)/);if(!n)break;t=t.slice(0,n.index)+t.slice(n.index+n[0].length);var r=n[1]?"bgClass":"textClass";null==e[r]?e[r]=n[2]:new RegExp("(?:^|\\s)"+n[2]+"(?:$|\\s)").test(e[r])||(e[r]+=" "+n[2])}return t}function Oe(t,e,n,r,i,o,a){var s=n.flattenSpans;null==s&&(s=t.options.flattenSpans);var c,l=0,u=null,d=new qt(e,t.options.tabSize,r),h=t.options.addModeClass&&[null];for(""==e&&we(ve(n,r.state),o);!d.eol();){if(d.pos>t.options.maxHighlightLength?(s=!1,a&&ge(t,e,r,d.pos),d.pos=e.length,c=null):c=we(me(n,d,r.state,h),o),h){var f=h[0].name;f&&(c="m-"+(c?f+" "+c:f))}if(!s||u!=c){for(;l<d.start;)i(l=Math.min(d.start,l+5e3),u);u=c}d.start=d.pos}for(;l<d.pos;){var p=Math.min(d.pos,l+5e3);i(p,u),l=p}}var xe=!1,Ce=!1;function ke(t,e,n){this.marker=t,this.from=e,this.to=n}function Se(t,e){if(t)for(var n=0;n<t.length;++n){var r=t[n];if(r.marker==e)return r}}function je(t,e){for(var n,r=0;r<t.length;++r)t[r]!=e&&(n||(n=[])).push(t[r]);return n}function Te(t,e){if(e.full)return null;var n=Qt(t,e.from.line)&&Gt(t,e.from.line).markedSpans,r=Qt(t,e.to.line)&&Gt(t,e.to.line).markedSpans;if(!n&&!r)return null;var i=e.from.ch,o=e.to.ch,a=0==ne(e.from,e.to),s=function(t,e,n){var r;if(t)for(var i=0;i<t.length;++i){var o=t[i],a=o.marker;if(null==o.from||(a.inclusiveLeft?o.from<=e:o.from<e)||o.from==e&&"bookmark"==a.type&&(!n||!o.marker.insertLeft)){var s=null==o.to||(a.inclusiveRight?o.to>=e:o.to>e);(r||(r=[])).push(new ke(a,o.from,s?null:o.to))}}return r}(n,i,a),c=function(t,e,n){var r;if(t)for(var i=0;i<t.length;++i){var o=t[i],a=o.marker;if(null==o.to||(a.inclusiveRight?o.to>=e:o.to>e)||o.from==e&&"bookmark"==a.type&&(!n||o.marker.insertLeft)){var s=null==o.from||(a.inclusiveLeft?o.from<=e:o.from<e);(r||(r=[])).push(new ke(a,s?null:o.from-e,null==o.to?null:o.to-e))}}return r}(r,o,a),l=1==e.text.length,u=Y(e.text).length+(l?i:0);if(s)for(var d=0;d<s.length;++d){var h=s[d];if(null==h.to){var f=Se(c,h.marker);f?l&&(h.to=null==f.to?null:f.to+u):h.to=i}}if(c)for(var p=0;p<c.length;++p){var g=c[p];null!=g.to&&(g.to+=u),null==g.from?Se(s,g.marker)||(g.from=u,l&&(s||(s=[])).push(g)):(g.from+=u,l&&(s||(s=[])).push(g))}s&&(s=Pe(s)),c&&c!=s&&(c=Pe(c));var v=[s];if(!l){var m,y=e.text.length-2;if(y>0&&s)for(var b=0;b<s.length;++b)null==s[b].to&&(m||(m=[])).push(new ke(s[b].marker,null,null));for(var w=0;w<y;++w)v.push(m);v.push(c)}return v}function Pe(t){for(var e=0;e<t.length;++e){var n=t[e];null!=n.from&&n.from==n.to&&!1!==n.marker.clearWhenEmpty&&t.splice(e--,1)}return t.length?t:null}function Ee(t){var e=t.markedSpans;if(e){for(var n=0;n<e.length;++n)e[n].marker.detachLine(t);t.markedSpans=null}}function _e(t,e){if(e){for(var n=0;n<e.length;++n)e[n].marker.attachLine(t);t.markedSpans=e}}function Me(t){return t.inclusiveLeft?-1:0}function De(t){return t.inclusiveRight?1:0}function Ae(t,e){var n=t.lines.length-e.lines.length;if(0!=n)return n;var r=t.find(),i=e.find(),o=ne(r.from,i.from)||Me(t)-Me(e);if(o)return-o;var a=ne(r.to,i.to)||De(t)-De(e);return a||e.id-t.id}function Le(t,e){var n,r=Ce&&t.markedSpans;if(r)for(var i=void 0,o=0;o<r.length;++o)(i=r[o]).marker.collapsed&&null==(e?i.from:i.to)&&(!n||Ae(n,i.marker)<0)&&(n=i.marker);return n}function Ne(t){return Le(t,!0)}function Re(t){return Le(t,!1)}function Ie(t,e){var n,r=Ce&&t.markedSpans;if(r)for(var i=0;i<r.length;++i){var o=r[i];o.marker.collapsed&&(null==o.from||o.from<e)&&(null==o.to||o.to>e)&&(!n||Ae(n,o.marker)<0)&&(n=o.marker)}return n}function Fe(t,e,n,r,i){var o=Gt(t,e),a=Ce&&o.markedSpans;if(a)for(var s=0;s<a.length;++s){var c=a[s];if(c.marker.collapsed){var l=c.marker.find(0),u=ne(l.from,n)||Me(c.marker)-Me(i),d=ne(l.to,r)||De(c.marker)-De(i);if(!(u>=0&&d<=0||u<=0&&d>=0)&&(u<=0&&(c.marker.inclusiveRight&&i.inclusiveLeft?ne(l.to,n)>=0:ne(l.to,n)>0)||u>=0&&(c.marker.inclusiveRight&&i.inclusiveLeft?ne(l.from,r)<=0:ne(l.from,r)<0)))return!0}}}function Ve(t){for(var e;e=Ne(t);)t=e.find(-1,!0).line;return t}function ze(t,e){var n=Gt(t,e),r=Ve(n);return n==r?e:Jt(r)}function He(t,e){if(e>t.lastLine())return e;var n,r=Gt(t,e);if(!Be(t,r))return e;for(;n=Re(r);)r=n.find(1,!0).line;return Jt(r)+1}function Be(t,e){var n=Ce&&e.markedSpans;if(n)for(var r=void 0,i=0;i<n.length;++i)if((r=n[i]).marker.collapsed){if(null==r.from)return!0;if(!r.marker.widgetNode&&0==r.from&&r.marker.inclusiveLeft&&Ue(t,e,r))return!0}}function Ue(t,e,n){if(null==n.to){var r=n.marker.find(1,!0);return Ue(t,r.line,Se(r.line.markedSpans,n.marker))}if(n.marker.inclusiveRight&&n.to==e.text.length)return!0;for(var i=void 0,o=0;o<e.markedSpans.length;++o)if((i=e.markedSpans[o]).marker.collapsed&&!i.marker.widgetNode&&i.from==n.to&&(null==i.to||i.to!=n.from)&&(i.marker.inclusiveLeft||n.marker.inclusiveRight)&&Ue(t,e,i))return!0}function $e(t){for(var e=0,n=(t=Ve(t)).parent,r=0;r<n.lines.length;++r){var i=n.lines[r];if(i==t)break;e+=i.height}for(var o=n.parent;o;o=(n=o).parent)for(var a=0;a<o.children.length;++a){var s=o.children[a];if(s==n)break;e+=s.height}return e}function We(t){if(0==t.height)return 0;for(var e,n=t.text.length,r=t;e=Ne(r);){var i=e.find(0,!0);r=i.from.line,n+=i.from.ch-i.to.ch}for(r=t;e=Re(r);){var o=e.find(0,!0);n-=r.text.length-o.from.ch,n+=(r=o.to.line).text.length-o.to.ch}return n}function qe(t){var e=t.display,n=t.doc;e.maxLine=Gt(n,n.first),e.maxLineLength=We(e.maxLine),e.maxLineChanged=!0,n.iter((function(t){var n=We(t);n>e.maxLineLength&&(e.maxLineLength=n,e.maxLine=t)}))}var Ge=function(t,e,n){this.text=t,_e(this,e),this.height=n?n(this):1};function Ke(t){t.parent=null,Ee(t)}Ge.prototype.lineNo=function(){return Jt(this)},bt(Ge);var Ye={},Xe={};function Je(t,e){if(!t||/^\s*$/.test(t))return null;var n=e.addModeClass?Xe:Ye;return n[t]||(n[t]=t.replace(/\S+/g,"cm-$&"))}function Ze(t,e){var n=_("span",null,null,c?"padding-right: .1px":null),r={pre:_("pre",[n],"CodeMirror-line"),content:n,col:0,pos:0,cm:t,trailingSpace:!1,splitSpaces:t.getOption("lineWrapping")};e.measure={};for(var i=0;i<=(e.rest?e.rest.length:0);i++){var o=i?e.rest[i-1]:e.line,a=void 0;r.pos=0,r.addToken=tn,_t(t.display.measure)&&(a=ut(o,t.doc.direction))&&(r.addToken=en(r.addToken,a)),r.map=[],rn(o,r,fe(t,o,e!=t.display.externalMeasured&&Jt(o))),o.styleClasses&&(o.styleClasses.bgClass&&(r.bgClass=L(o.styleClasses.bgClass,r.bgClass||"")),o.styleClasses.textClass&&(r.textClass=L(o.styleClasses.textClass,r.textClass||""))),0==r.map.length&&r.map.push(0,0,r.content.appendChild(Et(t.display.measure))),0==i?(e.measure.map=r.map,e.measure.cache={}):((e.measure.maps||(e.measure.maps=[])).push(r.map),(e.measure.caches||(e.measure.caches=[])).push({}))}if(c){var s=r.content.lastChild;(/\bcm-tab\b/.test(s.className)||s.querySelector&&s.querySelector(".cm-tab"))&&(r.content.className="cm-tab-wrap-hack")}return gt(t,"renderLine",t,e.line,r.pre),r.pre.className&&(r.textClass=L(r.pre.className,r.textClass||"")),r}function Qe(t){var e=E("span","•","cm-invalidchar");return e.title="\\u"+t.charCodeAt(0).toString(16),e.setAttribute("aria-label",e.title),e}function tn(t,e,n,r,i,o,c){if(e){var l,u=t.splitSpaces?function(t,e){if(t.length>1&&!/  /.test(t))return t;for(var n=e,r="",i=0;i<t.length;i++){var o=t.charAt(i);" "!=o||!n||i!=t.length-1&&32!=t.charCodeAt(i+1)||(o=" "),r+=o,n=" "==o}return r}(e,t.trailingSpace):e,d=t.cm.state.specialChars,h=!1;if(d.test(e)){l=document.createDocumentFragment();for(var f=0;1;){d.lastIndex=f;var p=d.exec(e),g=p?p.index-f:e.length-f;if(g){var v=document.createTextNode(u.slice(f,f+g));a&&s<9?l.appendChild(E("span",[v])):l.appendChild(v),t.map.push(t.pos,t.pos+g,v),t.col+=g,t.pos+=g}if(!p)break;f+=g+1;var m=void 0;if("\t"==p[0]){var y=t.cm.options.tabSize,b=y-t.col%y;(m=l.appendChild(E("span",K(b),"cm-tab"))).setAttribute("role","presentation"),m.setAttribute("cm-text","\t"),t.col+=b}else"\r"==p[0]||"\n"==p[0]?((m=l.appendChild(E("span","\r"==p[0]?"␍":"␤","cm-invalidchar"))).setAttribute("cm-text",p[0]),t.col+=1):((m=t.cm.options.specialCharPlaceholder(p[0])).setAttribute("cm-text",p[0]),a&&s<9?l.appendChild(E("span",[m])):l.appendChild(m),t.col+=1);t.map.push(t.pos,t.pos+1,m),t.pos++}}else t.col+=e.length,l=document.createTextNode(u),t.map.push(t.pos,t.pos+e.length,l),a&&s<9&&(h=!0),t.pos+=e.length;if(t.trailingSpace=32==u.charCodeAt(e.length-1),n||r||i||h||o||c){var w=n||"";r&&(w+=r),i&&(w+=i);var O=E("span",[l],w,o);if(c)for(var x in c)c.hasOwnProperty(x)&&"style"!=x&&"class"!=x&&O.setAttribute(x,c[x]);return t.content.appendChild(O)}t.content.appendChild(l)}}function en(t,e){return function(n,r,i,o,a,s,c){i=i?i+" cm-force-border":"cm-force-border";for(var l=n.pos,u=l+r.length;;){for(var d=void 0,h=0;h<e.length&&!((d=e[h]).to>l&&d.from<=l);h++);if(d.to>=u)return t(n,r,i,o,a,s,c);t(n,r.slice(0,d.to-l),i,o,null,s,c),o=null,r=r.slice(d.to-l),l=d.to}}}function nn(t,e,n,r){var i=!r&&n.widgetNode;i&&t.map.push(t.pos,t.pos+e,i),!r&&t.cm.display.input.needsContentAttribute&&(i||(i=t.content.appendChild(document.createElement("span"))),i.setAttribute("cm-marker",n.id)),i&&(t.cm.display.input.setUneditable(i),t.content.appendChild(i)),t.pos+=e,t.trailingSpace=!1}function rn(t,e,n){var r=t.markedSpans,i=t.text,o=0;if(r)for(var a,s,c,l,u,d,h,f=i.length,p=0,g=1,v="",m=0;;){if(m==p){c=l=u=s="",h=null,d=null,m=1/0;for(var y=[],b=void 0,w=0;w<r.length;++w){var O=r[w],x=O.marker;if("bookmark"==x.type&&O.from==p&&x.widgetNode)y.push(x);else if(O.from<=p&&(null==O.to||O.to>p||x.collapsed&&O.to==p&&O.from==p)){if(null!=O.to&&O.to!=p&&m>O.to&&(m=O.to,l=""),x.className&&(c+=" "+x.className),x.css&&(s=(s?s+";":"")+x.css),x.startStyle&&O.from==p&&(u+=" "+x.startStyle),x.endStyle&&O.to==m&&(b||(b=[])).push(x.endStyle,O.to),x.title&&((h||(h={})).title=x.title),x.attributes)for(var C in x.attributes)(h||(h={}))[C]=x.attributes[C];x.collapsed&&(!d||Ae(d.marker,x)<0)&&(d=O)}else O.from>p&&m>O.from&&(m=O.from)}if(b)for(var k=0;k<b.length;k+=2)b[k+1]==m&&(l+=" "+b[k]);if(!d||d.from==p)for(var S=0;S<y.length;++S)nn(e,0,y[S]);if(d&&(d.from||0)==p){if(nn(e,(null==d.to?f+1:d.to)-p,d.marker,null==d.from),null==d.to)return;d.to==p&&(d=!1)}}if(p>=f)break;for(var j=Math.min(f,m);1;){if(v){var T=p+v.length;if(!d){var P=T>j?v.slice(0,j-p):v;e.addToken(e,P,a?a+c:c,u,p+P.length==m?l:"",s,h)}if(T>=j){v=v.slice(j-p),p=j;break}p=T,u=""}v=i.slice(o,o=n[g++]),a=Je(n[g++],e.cm.options)}}else for(var E=1;E<n.length;E+=2)e.addToken(e,i.slice(o,o=n[E]),Je(n[E+1],e.cm.options))}function on(t,e,n){this.line=e,this.rest=function(t){for(var e,n;e=Re(t);)t=e.find(1,!0).line,(n||(n=[])).push(t);return n}(e),this.size=this.rest?Jt(Y(this.rest))-n+1:1,this.node=this.text=null,this.hidden=Be(t,e)}function an(t,e,n){for(var r,i=[],o=e;o<n;o=r){var a=new on(t.doc,Gt(t.doc,o),o);r=o+a.size,i.push(a)}return i}var sn=null,cn=null;function ln(t,e){var n=ft(t,e);if(n.length){var r,i=Array.prototype.slice.call(arguments,2);sn?r=sn.delayedCallbacks:cn?r=cn:(r=cn=[],setTimeout(un,0));for(var o=function(t){r.push((function(){return n[t].apply(null,i)}))},a=0;a<n.length;++a)o(a)}}function un(){var t=cn;cn=null;for(var e=0;e<t.length;++e)t[e]()}function dn(t,e,n,r){for(var i=0;i<e.changes.length;i++){var o=e.changes[i];"text"==o?pn(t,e):"gutter"==o?vn(t,e,n,r):"class"==o?gn(t,e):"widget"==o&&mn(t,e,r)}e.changes=null}function hn(t){return t.node==t.text&&(t.node=E("div",null,null,"position: relative"),t.text.parentNode&&t.text.parentNode.replaceChild(t.node,t.text),t.node.appendChild(t.text),a&&s<8&&(t.node.style.zIndex=2)),t.node}function fn(t,e){var n=t.display.externalMeasured;return n&&n.line==e.line?(t.display.externalMeasured=null,e.measure=n.measure,n.built):Ze(t,e)}function pn(t,e){var n=e.text.className,r=fn(t,e);e.text==e.node&&(e.node=r.pre),e.text.parentNode.replaceChild(r.pre,e.text),e.text=r.pre,r.bgClass!=e.bgClass||r.textClass!=e.textClass?(e.bgClass=r.bgClass,e.textClass=r.textClass,gn(t,e)):n&&(e.text.className=n)}function gn(t,e){!function(t,e){var n=e.bgClass?e.bgClass+" "+(e.line.bgClass||""):e.line.bgClass;if(n&&(n+=" CodeMirror-linebackground"),e.background)n?e.background.className=n:(e.background.parentNode.removeChild(e.background),e.background=null);else if(n){var r=hn(e);e.background=r.insertBefore(E("div",null,n),r.firstChild),t.display.input.setUneditable(e.background)}}(t,e),e.line.wrapClass?hn(e).className=e.line.wrapClass:e.node!=e.text&&(e.node.className="");var n=e.textClass?e.textClass+" "+(e.line.textClass||""):e.line.textClass;e.text.className=n||""}function vn(t,e,n,r){if(e.gutter&&(e.node.removeChild(e.gutter),e.gutter=null),e.gutterBackground&&(e.node.removeChild(e.gutterBackground),e.gutterBackground=null),e.line.gutterClass){var i=hn(e);e.gutterBackground=E("div",null,"CodeMirror-gutter-background "+e.line.gutterClass,"left: "+(t.options.fixedGutter?r.fixedPos:-r.gutterTotalWidth)+"px; width: "+r.gutterTotalWidth+"px"),t.display.input.setUneditable(e.gutterBackground),i.insertBefore(e.gutterBackground,e.text)}var o=e.line.gutterMarkers;if(t.options.lineNumbers||o){var a=hn(e),s=e.gutter=E("div",null,"CodeMirror-gutter-wrapper","left: "+(t.options.fixedGutter?r.fixedPos:-r.gutterTotalWidth)+"px");if(s.setAttribute("aria-hidden","true"),t.display.input.setUneditable(s),a.insertBefore(s,e.text),e.line.gutterClass&&(s.className+=" "+e.line.gutterClass),!t.options.lineNumbers||o&&o["CodeMirror-linenumbers"]||(e.lineNumber=s.appendChild(E("div",te(t.options,n),"CodeMirror-linenumber CodeMirror-gutter-elt","left: "+r.gutterLeft["CodeMirror-linenumbers"]+"px; width: "+t.display.lineNumInnerWidth+"px"))),o)for(var c=0;c<t.display.gutterSpecs.length;++c){var l=t.display.gutterSpecs[c].className,u=o.hasOwnProperty(l)&&o[l];u&&s.appendChild(E("div",[u],"CodeMirror-gutter-elt","left: "+r.gutterLeft[l]+"px; width: "+r.gutterWidth[l]+"px"))}}}function mn(t,e,n){e.alignable&&(e.alignable=null);for(var r=k("CodeMirror-linewidget"),i=e.node.firstChild,o=void 0;i;i=o)o=i.nextSibling,r.test(i.className)&&e.node.removeChild(i);bn(t,e,n)}function yn(t,e,n,r){var i=fn(t,e);return e.text=e.node=i.pre,i.bgClass&&(e.bgClass=i.bgClass),i.textClass&&(e.textClass=i.textClass),gn(t,e),vn(t,e,n,r),bn(t,e,r),e.node}function bn(t,e,n){if(wn(t,e.line,e,n,!0),e.rest)for(var r=0;r<e.rest.length;r++)wn(t,e.rest[r],e,n,!1)}function wn(t,e,n,r,i){if(e.widgets)for(var o=hn(n),a=0,s=e.widgets;a<s.length;++a){var c=s[a],l=E("div",[c.node],"CodeMirror-linewidget"+(c.className?" "+c.className:""));c.handleMouseEvents||l.setAttribute("cm-ignore-events","true"),On(c,l,n,r),t.display.input.setUneditable(l),i&&c.above?o.insertBefore(l,n.gutter||n.text):o.appendChild(l),ln(c,"redraw")}}function On(t,e,n,r){if(t.noHScroll){(n.alignable||(n.alignable=[])).push(e);var i=r.wrapperWidth;e.style.left=r.fixedPos+"px",t.coverGutter||(i-=r.gutterTotalWidth,e.style.paddingLeft=r.gutterTotalWidth+"px"),e.style.width=i+"px"}t.coverGutter&&(e.style.zIndex=5,e.style.position="relative",t.noHScroll||(e.style.marginLeft=-r.gutterTotalWidth+"px"))}function xn(t){if(null!=t.height)return t.height;var e=t.doc.cm;if(!e)return 0;if(!M(document.body,t.node)){var n="position: relative;";t.coverGutter&&(n+="margin-left: -"+e.display.gutters.offsetWidth+"px;"),t.noHScroll&&(n+="width: "+e.display.wrapper.clientWidth+"px;"),P(e.display.measure,E("div",[t.node],null,n))}return t.height=t.node.parentNode.offsetHeight}function Cn(t,e){for(var n=kt(e);n!=t.wrapper;n=n.parentNode)if(!n||1==n.nodeType&&"true"==n.getAttribute("cm-ignore-events")||n.parentNode==t.sizer&&n!=t.mover)return!0}function kn(t){return t.lineSpace.offsetTop}function Sn(t){return t.mover.offsetHeight-t.lineSpace.offsetHeight}function jn(t){if(t.cachedPaddingH)return t.cachedPaddingH;var e=P(t.measure,E("pre","x","CodeMirror-line-like")),n=window.getComputedStyle?window.getComputedStyle(e):e.currentStyle,r={left:parseInt(n.paddingLeft),right:parseInt(n.paddingRight)};return isNaN(r.left)||isNaN(r.right)||(t.cachedPaddingH=r),r}function Tn(t){return H-t.display.nativeBarWidth}function Pn(t){return t.display.scroller.clientWidth-Tn(t)-t.display.barWidth}function En(t){return t.display.scroller.clientHeight-Tn(t)-t.display.barHeight}function _n(t,e,n){if(t.line==e)return{map:t.measure.map,cache:t.measure.cache};for(var r=0;r<t.rest.length;r++)if(t.rest[r]==e)return{map:t.measure.maps[r],cache:t.measure.caches[r]};for(var i=0;i<t.rest.length;i++)if(Jt(t.rest[i])>n)return{map:t.measure.maps[i],cache:t.measure.caches[i],before:!0}}function Mn(t,e,n,r){return Ln(t,An(t,e),n,r)}function Dn(t,e){if(e>=t.display.viewFrom&&e<t.display.viewTo)return t.display.view[dr(t,e)];var n=t.display.externalMeasured;return n&&e>=n.lineN&&e<n.lineN+n.size?n:void 0}function An(t,e){var n=Jt(e),r=Dn(t,n);r&&!r.text?r=null:r&&r.changes&&(dn(t,r,n,ar(t)),t.curOp.forceUpdate=!0),r||(r=function(t,e){var n=Jt(e=Ve(e)),r=t.display.externalMeasured=new on(t.doc,e,n);r.lineN=n;var i=r.built=Ze(t,r);return r.text=i.pre,P(t.display.lineMeasure,i.pre),r}(t,e));var i=_n(r,e,n);return{line:e,view:r,rect:null,map:i.map,cache:i.cache,before:i.before,hasHeights:!1}}function Ln(t,e,n,r,i){e.before&&(n=-1);var o,c=n+(r||"");return e.cache.hasOwnProperty(c)?o=e.cache[c]:(e.rect||(e.rect=e.view.text.getBoundingClientRect()),e.hasHeights||(function(t,e,n){var r=t.options.lineWrapping,i=r&&Pn(t);if(!e.measure.heights||r&&e.measure.width!=i){var o=e.measure.heights=[];if(r){e.measure.width=i;for(var a=e.text.firstChild.getClientRects(),s=0;s<a.length-1;s++){var c=a[s],l=a[s+1];Math.abs(c.bottom-l.bottom)>2&&o.push((c.bottom+l.top)/2-n.top)}}o.push(n.bottom-n.top)}}(t,e.view,e.rect),e.hasHeights=!0),(o=function(t,e,n,r){var i,o=In(e.map,n,r),c=o.node,l=o.start,u=o.end,d=o.collapse;if(3==c.nodeType){for(var h=0;h<4;h++){for(;l&&it(e.line.text.charAt(o.coverStart+l));)--l;for(;o.coverStart+u<o.coverEnd&&it(e.line.text.charAt(o.coverStart+u));)++u;if((i=a&&s<9&&0==l&&u==o.coverEnd-o.coverStart?c.parentNode.getBoundingClientRect():Fn(S(c,l,u).getClientRects(),r)).left||i.right||0==l)break;u=l,l-=1,d="right"}a&&s<11&&(i=function(t,e){if(!window.screen||null==screen.logicalXDPI||screen.logicalXDPI==screen.deviceXDPI||!function(t){if(null!=Nt)return Nt;var e=P(t,E("span","x")),n=e.getBoundingClientRect(),r=S(e,0,1).getBoundingClientRect();return Nt=Math.abs(n.left-r.left)>1}(t))return e;var n=screen.logicalXDPI/screen.deviceXDPI,r=screen.logicalYDPI/screen.deviceYDPI;return{left:e.left*n,right:e.right*n,top:e.top*r,bottom:e.bottom*r}}(t.display.measure,i))}else{var f;l>0&&(d=r="right"),i=t.options.lineWrapping&&(f=c.getClientRects()).length>1?f["right"==r?f.length-1:0]:c.getBoundingClientRect()}if(a&&s<9&&!l&&(!i||!i.left&&!i.right)){var p=c.parentNode.getClientRects()[0];i=p?{left:p.left,right:p.left+or(t.display),top:p.top,bottom:p.bottom}:Rn}for(var g=i.top-e.rect.top,v=i.bottom-e.rect.top,m=(g+v)/2,y=e.view.measure.heights,b=0;b<y.length-1&&!(m<y[b]);b++);var w=b?y[b-1]:0,O=y[b],x={left:("right"==d?i.right:i.left)-e.rect.left,right:("left"==d?i.left:i.right)-e.rect.left,top:w,bottom:O};return i.left||i.right||(x.bogus=!0),t.options.singleCursorHeightPerLine||(x.rtop=g,x.rbottom=v),x}(t,e,n,r)).bogus||(e.cache[c]=o)),{left:o.left,right:o.right,top:i?o.rtop:o.top,bottom:i?o.rbottom:o.bottom}}var Nn,Rn={left:0,right:0,top:0,bottom:0};function In(t,e,n){for(var r,i,o,a,s,c,l=0;l<t.length;l+=3)if(s=t[l],c=t[l+1],e<s?(i=0,o=1,a="left"):e<c?o=(i=e-s)+1:(l==t.length-3||e==c&&t[l+3]>e)&&(i=(o=c-s)-1,e>=c&&(a="right")),null!=i){if(r=t[l+2],s==c&&n==(r.insertLeft?"left":"right")&&(a=n),"left"==n&&0==i)for(;l&&t[l-2]==t[l-3]&&t[l-1].insertLeft;)r=t[(l-=3)+2],a="left";if("right"==n&&i==c-s)for(;l<t.length-3&&t[l+3]==t[l+4]&&!t[l+5].insertLeft;)r=t[(l+=3)+2],a="right";break}return{node:r,start:i,end:o,collapse:a,coverStart:s,coverEnd:c}}function Fn(t,e){var n=Rn;if("left"==e)for(var r=0;r<t.length&&(n=t[r]).left==n.right;r++);else for(var i=t.length-1;i>=0&&(n=t[i]).left==n.right;i--);return n}function Vn(t){if(t.measure&&(t.measure.cache={},t.measure.heights=null,t.rest))for(var e=0;e<t.rest.length;e++)t.measure.caches[e]={}}function zn(t){t.display.externalMeasure=null,T(t.display.lineMeasure);for(var e=0;e<t.display.view.length;e++)Vn(t.display.view[e])}function Hn(t){zn(t),t.display.cachedCharWidth=t.display.cachedTextHeight=t.display.cachedPaddingH=null,t.options.lineWrapping||(t.display.maxLineChanged=!0),t.display.lineNumChars=null}function Bn(){return u&&v?-(document.body.getBoundingClientRect().left-parseInt(getComputedStyle(document.body).marginLeft)):window.pageXOffset||(document.documentElement||document.body).scrollLeft}function Un(){return u&&v?-(document.body.getBoundingClientRect().top-parseInt(getComputedStyle(document.body).marginTop)):window.pageYOffset||(document.documentElement||document.body).scrollTop}function $n(t){var e=0;if(t.widgets)for(var n=0;n<t.widgets.length;++n)t.widgets[n].above&&(e+=xn(t.widgets[n]));return e}function Wn(t,e,n,r,i){if(!i){var o=$n(e);n.top+=o,n.bottom+=o}if("line"==r)return n;r||(r="local");var a=$e(e);if("local"==r?a+=kn(t.display):a-=t.display.viewOffset,"page"==r||"window"==r){var s=t.display.lineSpace.getBoundingClientRect();a+=s.top+("window"==r?0:Un());var c=s.left+("window"==r?0:Bn());n.left+=c,n.right+=c}return n.top+=a,n.bottom+=a,n}function qn(t,e,n){if("div"==n)return e;var r=e.left,i=e.top;if("page"==n)r-=Bn(),i-=Un();else if("local"==n||!n){var o=t.display.sizer.getBoundingClientRect();r+=o.left,i+=o.top}var a=t.display.lineSpace.getBoundingClientRect();return{left:r-a.left,top:i-a.top}}function Gn(t,e,n,r,i){return r||(r=Gt(t.doc,e.line)),Wn(t,r,Mn(t,r,e.ch,i),n)}function Kn(t,e,n,r,i,o){function a(e,a){var s=Ln(t,i,e,a?"right":"left",o);return a?s.left=s.right:s.right=s.left,Wn(t,r,s,n)}r=r||Gt(t.doc,e.line),i||(i=An(t,r));var s=ut(r,t.doc.direction),c=e.ch,l=e.sticky;if(c>=r.text.length?(c=r.text.length,l="before"):c<=0&&(c=0,l="after"),!s)return a("before"==l?c-1:c,"before"==l);function u(t,e,n){return a(n?t-1:t,1==s[e].level!=n)}var d=ct(s,c,l),h=st,f=u(c,d,"before"==l);return null!=h&&(f.other=u(c,h,"before"!=l)),f}function Yn(t,e){var n=0;e=ce(t.doc,e),t.options.lineWrapping||(n=or(t.display)*e.ch);var r=Gt(t.doc,e.line),i=$e(r)+kn(t.display);return{left:n,right:n,top:i,bottom:i+r.height}}function Xn(t,e,n,r,i){var o=ee(t,e,n);return o.xRel=i,r&&(o.outside=r),o}function Jn(t,e,n){var r=t.doc;if((n+=t.display.viewOffset)<0)return Xn(r.first,0,null,-1,-1);var i=Zt(r,n),o=r.first+r.size-1;if(i>o)return Xn(r.first+r.size-1,Gt(r,o).text.length,null,1,1);e<0&&(e=0);for(var a=Gt(r,i);;){var s=er(t,a,i,e,n),c=Ie(a,s.ch+(s.xRel>0||s.outside>0?1:0));if(!c)return s;var l=c.find(1);if(l.line==i)return l;a=Gt(r,i=l.line)}}function Zn(t,e,n,r){r-=$n(e);var i=e.text.length,o=at((function(e){return Ln(t,n,e-1).bottom<=r}),i,0);return{begin:o,end:i=at((function(e){return Ln(t,n,e).top>r}),o,i)}}function Qn(t,e,n,r){return n||(n=An(t,e)),Zn(t,e,n,Wn(t,e,Ln(t,n,r),"line").top)}function tr(t,e,n,r){return!(t.bottom<=n)&&(t.top>n||(r?t.left:t.right)>e)}function er(t,e,n,r,i){i-=$e(e);var o=An(t,e),a=$n(e),s=0,c=e.text.length,l=!0,u=ut(e,t.doc.direction);if(u){var d=(t.options.lineWrapping?rr:nr)(t,e,n,o,u,r,i);s=(l=1!=d.level)?d.from:d.to-1,c=l?d.to:d.from-1}var h,f,p=null,g=null,v=at((function(e){var n=Ln(t,o,e);return n.top+=a,n.bottom+=a,!!tr(n,r,i,!1)&&(n.top<=i&&n.left<=r&&(p=e,g=n),!0)}),s,c),m=!1;if(g){var y=r-g.left<g.right-r,b=y==l;v=p+(b?0:1),f=b?"after":"before",h=y?g.left:g.right}else{l||v!=c&&v!=s||v++,f=0==v?"after":v==e.text.length?"before":Ln(t,o,v-(l?1:0)).bottom+a<=i==l?"after":"before";var w=Kn(t,ee(n,v,f),"line",e,o);h=w.left,m=i<w.top?-1:i>=w.bottom?1:0}return Xn(n,v=ot(e.text,v,1),f,m,r-h)}function nr(t,e,n,r,i,o,a){var s=at((function(s){var c=i[s],l=1!=c.level;return tr(Kn(t,ee(n,l?c.to:c.from,l?"before":"after"),"line",e,r),o,a,!0)}),0,i.length-1),c=i[s];if(s>0){var l=1!=c.level,u=Kn(t,ee(n,l?c.from:c.to,l?"after":"before"),"line",e,r);tr(u,o,a,!0)&&u.top>a&&(c=i[s-1])}return c}function rr(t,e,n,r,i,o,a){var s=Zn(t,e,r,a),c=s.begin,l=s.end;/\s/.test(e.text.charAt(l-1))&&l--;for(var u=null,d=null,h=0;h<i.length;h++){var f=i[h];if(!(f.from>=l||f.to<=c)){var p=Ln(t,r,1!=f.level?Math.min(l,f.to)-1:Math.max(c,f.from)).right,g=p<o?o-p+1e9:p-o;(!u||d>g)&&(u=f,d=g)}}return u||(u=i[i.length-1]),u.from<c&&(u={from:c,to:u.to,level:u.level}),u.to>l&&(u={from:u.from,to:l,level:u.level}),u}function ir(t){if(null!=t.cachedTextHeight)return t.cachedTextHeight;if(null==Nn){Nn=E("pre",null,"CodeMirror-line-like");for(var e=0;e<49;++e)Nn.appendChild(document.createTextNode("x")),Nn.appendChild(E("br"));Nn.appendChild(document.createTextNode("x"))}P(t.measure,Nn);var n=Nn.offsetHeight/50;return n>3&&(t.cachedTextHeight=n),T(t.measure),n||1}function or(t){if(null!=t.cachedCharWidth)return t.cachedCharWidth;var e=E("span","xxxxxxxxxx"),n=E("pre",[e],"CodeMirror-line-like");P(t.measure,n);var r=e.getBoundingClientRect(),i=(r.right-r.left)/10;return i>2&&(t.cachedCharWidth=i),i||10}function ar(t){for(var e=t.display,n={},r={},i=e.gutters.clientLeft,o=e.gutters.firstChild,a=0;o;o=o.nextSibling,++a){var s=t.display.gutterSpecs[a].className;n[s]=o.offsetLeft+o.clientLeft+i,r[s]=o.clientWidth}return{fixedPos:sr(e),gutterTotalWidth:e.gutters.offsetWidth,gutterLeft:n,gutterWidth:r,wrapperWidth:e.wrapper.clientWidth}}function sr(t){return t.scroller.getBoundingClientRect().left-t.sizer.getBoundingClientRect().left}function cr(t){var e=ir(t.display),n=t.options.lineWrapping,r=n&&Math.max(5,t.display.scroller.clientWidth/or(t.display)-3);return function(i){if(Be(t.doc,i))return 0;var o=0;if(i.widgets)for(var a=0;a<i.widgets.length;a++)i.widgets[a].height&&(o+=i.widgets[a].height);return n?o+(Math.ceil(i.text.length/r)||1)*e:o+e}}function lr(t){var e=t.doc,n=cr(t);e.iter((function(t){var e=n(t);e!=t.height&&Xt(t,e)}))}function ur(t,e,n,r){var i=t.display;if(!n&&"true"==kt(e).getAttribute("cm-not-content"))return null;var o,a,s=i.lineSpace.getBoundingClientRect();try{o=e.clientX-s.left,a=e.clientY-s.top}catch(t){return null}var c,l=Jn(t,o,a);if(r&&l.xRel>0&&(c=Gt(t.doc,l.line).text).length==l.ch){var u=F(c,c.length,t.options.tabSize)-c.length;l=ee(l.line,Math.max(0,Math.round((o-jn(t.display).left)/or(t.display))-u))}return l}function dr(t,e){if(e>=t.display.viewTo)return null;if((e-=t.display.viewFrom)<0)return null;for(var n=t.display.view,r=0;r<n.length;r++)if((e-=n[r].size)<0)return r}function hr(t,e,n,r){null==e&&(e=t.doc.first),null==n&&(n=t.doc.first+t.doc.size),r||(r=0);var i=t.display;if(r&&n<i.viewTo&&(null==i.updateLineNumbers||i.updateLineNumbers>e)&&(i.updateLineNumbers=e),t.curOp.viewChanged=!0,e>=i.viewTo)Ce&&ze(t.doc,e)<i.viewTo&&pr(t);else if(n<=i.viewFrom)Ce&&He(t.doc,n+r)>i.viewFrom?pr(t):(i.viewFrom+=r,i.viewTo+=r);else if(e<=i.viewFrom&&n>=i.viewTo)pr(t);else if(e<=i.viewFrom){var o=gr(t,n,n+r,1);o?(i.view=i.view.slice(o.index),i.viewFrom=o.lineN,i.viewTo+=r):pr(t)}else if(n>=i.viewTo){var a=gr(t,e,e,-1);a?(i.view=i.view.slice(0,a.index),i.viewTo=a.lineN):pr(t)}else{var s=gr(t,e,e,-1),c=gr(t,n,n+r,1);s&&c?(i.view=i.view.slice(0,s.index).concat(an(t,s.lineN,c.lineN)).concat(i.view.slice(c.index)),i.viewTo+=r):pr(t)}var l=i.externalMeasured;l&&(n<l.lineN?l.lineN+=r:e<l.lineN+l.size&&(i.externalMeasured=null))}function fr(t,e,n){t.curOp.viewChanged=!0;var r=t.display,i=t.display.externalMeasured;if(i&&e>=i.lineN&&e<i.lineN+i.size&&(r.externalMeasured=null),!(e<r.viewFrom||e>=r.viewTo)){var o=r.view[dr(t,e)];if(null!=o.node){var a=o.changes||(o.changes=[]);-1==z(a,n)&&a.push(n)}}}function pr(t){t.display.viewFrom=t.display.viewTo=t.doc.first,t.display.view=[],t.display.viewOffset=0}function gr(t,e,n,r){var i,o=dr(t,e),a=t.display.view;if(!Ce||n==t.doc.first+t.doc.size)return{index:o,lineN:n};for(var s=t.display.viewFrom,c=0;c<o;c++)s+=a[c].size;if(s!=e){if(r>0){if(o==a.length-1)return null;i=s+a[o].size-e,o++}else i=s-e;e+=i,n+=i}for(;ze(t.doc,n)!=n;){if(o==(r<0?0:a.length-1))return null;n+=r*a[o-(r<0?1:0)].size,o+=r}return{index:o,lineN:n}}function vr(t){for(var e=t.display.view,n=0,r=0;r<e.length;r++){var i=e[r];i.hidden||i.node&&!i.changes||++n}return n}function mr(t){t.display.input.showSelection(t.display.input.prepareSelection())}function yr(t,e){void 0===e&&(e=!0);for(var n=t.doc,r={},i=r.cursors=document.createDocumentFragment(),o=r.selection=document.createDocumentFragment(),a=0;a<n.sel.ranges.length;a++)if(e||a!=n.sel.primIndex){var s=n.sel.ranges[a];if(!(s.from().line>=t.display.viewTo||s.to().line<t.display.viewFrom)){var c=s.empty();(c||t.options.showCursorWhenSelecting)&&br(t,s.head,i),c||Or(t,s,o)}}return r}function br(t,e,n){var r=Kn(t,e,"div",null,null,!t.options.singleCursorHeightPerLine),i=n.appendChild(E("div"," ","CodeMirror-cursor"));if(i.style.left=r.left+"px",i.style.top=r.top+"px",i.style.height=Math.max(0,r.bottom-r.top)*t.options.cursorHeight+"px",/\bcm-fat-cursor\b/.test(t.getWrapperElement().className)){var o=Gn(t,e,"div",null,null);o.right-o.left>0&&(i.style.width=o.right-o.left+"px")}if(r.other){var a=n.appendChild(E("div"," ","CodeMirror-cursor CodeMirror-secondarycursor"));a.style.display="",a.style.left=r.other.left+"px",a.style.top=r.other.top+"px",a.style.height=.85*(r.other.bottom-r.other.top)+"px"}}function wr(t,e){return t.top-e.top||t.left-e.left}function Or(t,e,n){var r=t.display,i=t.doc,o=document.createDocumentFragment(),a=jn(t.display),s=a.left,c=Math.max(r.sizerWidth,Pn(t)-r.sizer.offsetLeft)-a.right,l="ltr"==i.direction;function u(t,e,n,r){e<0&&(e=0),e=Math.round(e),r=Math.round(r),o.appendChild(E("div",null,"CodeMirror-selected","position: absolute; left: "+t+"px;\n                             top: "+e+"px; width: "+(null==n?c-t:n)+"px;\n                             height: "+(r-e)+"px"))}function d(e,n,r){var o,a,d=Gt(i,e),h=d.text.length;function f(n,r){return Gn(t,ee(e,n),"div",d,r)}function p(e,n,r){var i=Qn(t,d,null,e),o="ltr"==n==("after"==r)?"left":"right";return f("after"==r?i.begin:i.end-(/\s/.test(d.text.charAt(i.end-1))?2:1),o)[o]}var g=ut(d,i.direction);return function(t,e,n,r){if(!t)return r(e,n,"ltr",0);for(var i=!1,o=0;o<t.length;++o){var a=t[o];(a.from<n&&a.to>e||e==n&&a.to==e)&&(r(Math.max(a.from,e),Math.min(a.to,n),1==a.level?"rtl":"ltr",o),i=!0)}i||r(e,n,"ltr")}(g,n||0,null==r?h:r,(function(t,e,i,d){var v="ltr"==i,m=f(t,v?"left":"right"),y=f(e-1,v?"right":"left"),b=null==n&&0==t,w=null==r&&e==h,O=0==d,x=!g||d==g.length-1;if(y.top-m.top<=3){var C=(l?w:b)&&x,k=(l?b:w)&&O?s:(v?m:y).left,S=C?c:(v?y:m).right;u(k,m.top,S-k,m.bottom)}else{var j,T,P,E;v?(j=l&&b&&O?s:m.left,T=l?c:p(t,i,"before"),P=l?s:p(e,i,"after"),E=l&&w&&x?c:y.right):(j=l?p(t,i,"before"):s,T=!l&&b&&O?c:m.right,P=!l&&w&&x?s:y.left,E=l?p(e,i,"after"):c),u(j,m.top,T-j,m.bottom),m.bottom<y.top&&u(s,m.bottom,null,y.top),u(P,y.top,E-P,y.bottom)}(!o||wr(m,o)<0)&&(o=m),wr(y,o)<0&&(o=y),(!a||wr(m,a)<0)&&(a=m),wr(y,a)<0&&(a=y)})),{start:o,end:a}}var h=e.from(),f=e.to();if(h.line==f.line)d(h.line,h.ch,f.ch);else{var p=Gt(i,h.line),g=Gt(i,f.line),v=Ve(p)==Ve(g),m=d(h.line,h.ch,v?p.text.length+1:null).end,y=d(f.line,v?0:null,f.ch).start;v&&(m.top<y.top-2?(u(m.right,m.top,null,m.bottom),u(s,y.top,y.left,y.bottom)):u(m.right,m.top,y.left-m.right,m.bottom)),m.bottom<y.top&&u(s,m.bottom,null,y.top)}n.appendChild(o)}function xr(t){if(t.state.focused){var e=t.display;clearInterval(e.blinker);var n=!0;e.cursorDiv.style.visibility="",t.options.cursorBlinkRate>0?e.blinker=setInterval((function(){t.hasFocus()||jr(t),e.cursorDiv.style.visibility=(n=!n)?"":"hidden"}),t.options.cursorBlinkRate):t.options.cursorBlinkRate<0&&(e.cursorDiv.style.visibility="hidden")}}function Cr(t){t.hasFocus()||(t.display.input.focus(),t.state.focused||Sr(t))}function kr(t){t.state.delayingBlurEvent=!0,setTimeout((function(){t.state.delayingBlurEvent&&(t.state.delayingBlurEvent=!1,t.state.focused&&jr(t))}),100)}function Sr(t,e){t.state.delayingBlurEvent&&!t.state.draggingText&&(t.state.delayingBlurEvent=!1),"nocursor"!=t.options.readOnly&&(t.state.focused||(gt(t,"focus",t,e),t.state.focused=!0,A(t.display.wrapper,"CodeMirror-focused"),t.curOp||t.display.selForContextMenu==t.doc.sel||(t.display.input.reset(),c&&setTimeout((function(){return t.display.input.reset(!0)}),20)),t.display.input.receivedFocus()),xr(t))}function jr(t,e){t.state.delayingBlurEvent||(t.state.focused&&(gt(t,"blur",t,e),t.state.focused=!1,j(t.display.wrapper,"CodeMirror-focused")),clearInterval(t.display.blinker),setTimeout((function(){t.state.focused||(t.display.shift=!1)}),150))}function Tr(t){for(var e=t.display,n=e.lineDiv.offsetTop,r=Math.max(0,e.scroller.getBoundingClientRect().top),i=e.lineDiv.getBoundingClientRect().top,o=0,c=0;c<e.view.length;c++){var l=e.view[c],u=t.options.lineWrapping,d=void 0,h=0;if(!l.hidden){if(i+=l.line.height,a&&s<8){var f=l.node.offsetTop+l.node.offsetHeight;d=f-n,n=f}else{var p=l.node.getBoundingClientRect();d=p.bottom-p.top,!u&&l.text.firstChild&&(h=l.text.firstChild.getBoundingClientRect().right-p.left-1)}var g=l.line.height-d;if((g>.005||g<-.005)&&(i<r&&(o-=g),Xt(l.line,d),Pr(l.line),l.rest))for(var v=0;v<l.rest.length;v++)Pr(l.rest[v]);if(h>t.display.sizerWidth){var m=Math.ceil(h/or(t.display));m>t.display.maxLineLength&&(t.display.maxLineLength=m,t.display.maxLine=l.line,t.display.maxLineChanged=!0)}}}Math.abs(o)>2&&(e.scroller.scrollTop+=o)}function Pr(t){if(t.widgets)for(var e=0;e<t.widgets.length;++e){var n=t.widgets[e],r=n.node.parentNode;r&&(n.height=r.offsetHeight)}}function Er(t,e,n){var r=n&&null!=n.top?Math.max(0,n.top):t.scroller.scrollTop;r=Math.floor(r-kn(t));var i=n&&null!=n.bottom?n.bottom:r+t.wrapper.clientHeight,o=Zt(e,r),a=Zt(e,i);if(n&&n.ensure){var s=n.ensure.from.line,c=n.ensure.to.line;s<o?(o=s,a=Zt(e,$e(Gt(e,s))+t.wrapper.clientHeight)):Math.min(c,e.lastLine())>=a&&(o=Zt(e,$e(Gt(e,c))-t.wrapper.clientHeight),a=c)}return{from:o,to:Math.max(a,o+1)}}function _r(t,e){var n=t.display,r=ir(t.display);e.top<0&&(e.top=0);var i=t.curOp&&null!=t.curOp.scrollTop?t.curOp.scrollTop:n.scroller.scrollTop,o=En(t),a={};e.bottom-e.top>o&&(e.bottom=e.top+o);var s=t.doc.height+Sn(n),c=e.top<r,l=e.bottom>s-r;if(e.top<i)a.scrollTop=c?0:e.top;else if(e.bottom>i+o){var u=Math.min(e.top,(l?s:e.bottom)-o);u!=i&&(a.scrollTop=u)}var d=t.options.fixedGutter?0:n.gutters.offsetWidth,h=t.curOp&&null!=t.curOp.scrollLeft?t.curOp.scrollLeft:n.scroller.scrollLeft-d,f=Pn(t)-n.gutters.offsetWidth,p=e.right-e.left>f;return p&&(e.right=e.left+f),e.left<10?a.scrollLeft=0:e.left<h?a.scrollLeft=Math.max(0,e.left+d-(p?0:10)):e.right>f+h-3&&(a.scrollLeft=e.right+(p?0:10)-f),a}function Mr(t,e){null!=e&&(Lr(t),t.curOp.scrollTop=(null==t.curOp.scrollTop?t.doc.scrollTop:t.curOp.scrollTop)+e)}function Dr(t){Lr(t);var e=t.getCursor();t.curOp.scrollToPos={from:e,to:e,margin:t.options.cursorScrollMargin}}function Ar(t,e,n){null==e&&null==n||Lr(t),null!=e&&(t.curOp.scrollLeft=e),null!=n&&(t.curOp.scrollTop=n)}function Lr(t){var e=t.curOp.scrollToPos;e&&(t.curOp.scrollToPos=null,Nr(t,Yn(t,e.from),Yn(t,e.to),e.margin))}function Nr(t,e,n,r){var i=_r(t,{left:Math.min(e.left,n.left),top:Math.min(e.top,n.top)-r,right:Math.max(e.right,n.right),bottom:Math.max(e.bottom,n.bottom)+r});Ar(t,i.scrollLeft,i.scrollTop)}function Rr(t,e){Math.abs(t.doc.scrollTop-e)<2||(n||li(t,{top:e}),Ir(t,e,!0),n&&li(t),ii(t,100))}function Ir(t,e,n){e=Math.max(0,Math.min(t.display.scroller.scrollHeight-t.display.scroller.clientHeight,e)),(t.display.scroller.scrollTop!=e||n)&&(t.doc.scrollTop=e,t.display.scrollbars.setScrollTop(e),t.display.scroller.scrollTop!=e&&(t.display.scroller.scrollTop=e))}function Fr(t,e,n,r){e=Math.max(0,Math.min(e,t.display.scroller.scrollWidth-t.display.scroller.clientWidth)),(n?e==t.doc.scrollLeft:Math.abs(t.doc.scrollLeft-e)<2)&&!r||(t.doc.scrollLeft=e,hi(t),t.display.scroller.scrollLeft!=e&&(t.display.scroller.scrollLeft=e),t.display.scrollbars.setScrollLeft(e))}function Vr(t){var e=t.display,n=e.gutters.offsetWidth,r=Math.round(t.doc.height+Sn(t.display));return{clientHeight:e.scroller.clientHeight,viewHeight:e.wrapper.clientHeight,scrollWidth:e.scroller.scrollWidth,clientWidth:e.scroller.clientWidth,viewWidth:e.wrapper.clientWidth,barLeft:t.options.fixedGutter?n:0,docHeight:r,scrollHeight:r+Tn(t)+e.barHeight,nativeBarWidth:e.nativeBarWidth,gutterWidth:n}}var zr=function(t,e,n){this.cm=n;var r=this.vert=E("div",[E("div",null,null,"min-width: 1px")],"CodeMirror-vscrollbar"),i=this.horiz=E("div",[E("div",null,null,"height: 100%; min-height: 1px")],"CodeMirror-hscrollbar");r.tabIndex=i.tabIndex=-1,t(r),t(i),ht(r,"scroll",(function(){r.clientHeight&&e(r.scrollTop,"vertical")})),ht(i,"scroll",(function(){i.clientWidth&&e(i.scrollLeft,"horizontal")})),this.checkedZeroWidth=!1,a&&s<8&&(this.horiz.style.minHeight=this.vert.style.minWidth="18px")};zr.prototype.update=function(t){var e=t.scrollWidth>t.clientWidth+1,n=t.scrollHeight>t.clientHeight+1,r=t.nativeBarWidth;if(n){this.vert.style.display="block",this.vert.style.bottom=e?r+"px":"0";var i=t.viewHeight-(e?r:0);this.vert.firstChild.style.height=Math.max(0,t.scrollHeight-t.clientHeight+i)+"px"}else this.vert.style.display="",this.vert.firstChild.style.height="0";if(e){this.horiz.style.display="block",this.horiz.style.right=n?r+"px":"0",this.horiz.style.left=t.barLeft+"px";var o=t.viewWidth-t.barLeft-(n?r:0);this.horiz.firstChild.style.width=Math.max(0,t.scrollWidth-t.clientWidth+o)+"px"}else this.horiz.style.display="",this.horiz.firstChild.style.width="0";return!this.checkedZeroWidth&&t.clientHeight>0&&(0==r&&this.zeroWidthHack(),this.checkedZeroWidth=!0),{right:n?r:0,bottom:e?r:0}},zr.prototype.setScrollLeft=function(t){this.horiz.scrollLeft!=t&&(this.horiz.scrollLeft=t),this.disableHoriz&&this.enableZeroWidthBar(this.horiz,this.disableHoriz,"horiz")},zr.prototype.setScrollTop=function(t){this.vert.scrollTop!=t&&(this.vert.scrollTop=t),this.disableVert&&this.enableZeroWidthBar(this.vert,this.disableVert,"vert")},zr.prototype.zeroWidthHack=function(){var t=y&&!f?"12px":"18px";this.horiz.style.height=this.vert.style.width=t,this.horiz.style.pointerEvents=this.vert.style.pointerEvents="none",this.disableHoriz=new V,this.disableVert=new V},zr.prototype.enableZeroWidthBar=function(t,e,n){t.style.pointerEvents="auto",e.set(1e3,(function r(){var i=t.getBoundingClientRect();("vert"==n?document.elementFromPoint(i.right-1,(i.top+i.bottom)/2):document.elementFromPoint((i.right+i.left)/2,i.bottom-1))!=t?t.style.pointerEvents="none":e.set(1e3,r)}))},zr.prototype.clear=function(){var t=this.horiz.parentNode;t.removeChild(this.horiz),t.removeChild(this.vert)};var Hr=function(){};function Br(t,e){e||(e=Vr(t));var n=t.display.barWidth,r=t.display.barHeight;Ur(t,e);for(var i=0;i<4&&n!=t.display.barWidth||r!=t.display.barHeight;i++)n!=t.display.barWidth&&t.options.lineWrapping&&Tr(t),Ur(t,Vr(t)),n=t.display.barWidth,r=t.display.barHeight}function Ur(t,e){var n=t.display,r=n.scrollbars.update(e);n.sizer.style.paddingRight=(n.barWidth=r.right)+"px",n.sizer.style.paddingBottom=(n.barHeight=r.bottom)+"px",n.heightForcer.style.borderBottom=r.bottom+"px solid transparent",r.right&&r.bottom?(n.scrollbarFiller.style.display="block",n.scrollbarFiller.style.height=r.bottom+"px",n.scrollbarFiller.style.width=r.right+"px"):n.scrollbarFiller.style.display="",r.bottom&&t.options.coverGutterNextToScrollbar&&t.options.fixedGutter?(n.gutterFiller.style.display="block",n.gutterFiller.style.height=r.bottom+"px",n.gutterFiller.style.width=e.gutterWidth+"px"):n.gutterFiller.style.display=""}Hr.prototype.update=function(){return{bottom:0,right:0}},Hr.prototype.setScrollLeft=function(){},Hr.prototype.setScrollTop=function(){},Hr.prototype.clear=function(){};var $r={native:zr,null:Hr};function Wr(t){t.display.scrollbars&&(t.display.scrollbars.clear(),t.display.scrollbars.addClass&&j(t.display.wrapper,t.display.scrollbars.addClass)),t.display.scrollbars=new $r[t.options.scrollbarStyle]((function(e){t.display.wrapper.insertBefore(e,t.display.scrollbarFiller),ht(e,"mousedown",(function(){t.state.focused&&setTimeout((function(){return t.display.input.focus()}),0)})),e.setAttribute("cm-not-content","true")}),(function(e,n){"horizontal"==n?Fr(t,e):Rr(t,e)}),t),t.display.scrollbars.addClass&&A(t.display.wrapper,t.display.scrollbars.addClass)}var qr=0;function Gr(t){var e;t.curOp={cm:t,viewChanged:!1,startHeight:t.doc.height,forceUpdate:!1,updateInput:0,typing:!1,changeObjs:null,cursorActivityHandlers:null,cursorActivityCalled:0,selectionChanged:!1,updateMaxLine:!1,scrollLeft:null,scrollTop:null,scrollToPos:null,focus:!1,id:++qr,markArrays:null},e=t.curOp,sn?sn.ops.push(e):e.ownsGroup=sn={ops:[e],delayedCallbacks:[]}}function Kr(t){var e=t.curOp;e&&function(t,e){var n=t.ownsGroup;if(n)try{!function(t){var e=t.delayedCallbacks,n=0;do{for(;n<e.length;n++)e[n].call(null);for(var r=0;r<t.ops.length;r++){var i=t.ops[r];if(i.cursorActivityHandlers)for(;i.cursorActivityCalled<i.cursorActivityHandlers.length;)i.cursorActivityHandlers[i.cursorActivityCalled++].call(null,i.cm)}}while(n<e.length)}(n)}finally{sn=null,e(n)}}(e,(function(t){for(var e=0;e<t.ops.length;e++)t.ops[e].cm.curOp=null;!function(t){for(var e=t.ops,n=0;n<e.length;n++)Yr(e[n]);for(var r=0;r<e.length;r++)Xr(e[r]);for(var i=0;i<e.length;i++)Jr(e[i]);for(var o=0;o<e.length;o++)Zr(e[o]);for(var a=0;a<e.length;a++)Qr(e[a])}(t)}))}function Yr(t){var e=t.cm,n=e.display;!function(t){var e=t.display;!e.scrollbarsClipped&&e.scroller.offsetWidth&&(e.nativeBarWidth=e.scroller.offsetWidth-e.scroller.clientWidth,e.heightForcer.style.height=Tn(t)+"px",e.sizer.style.marginBottom=-e.nativeBarWidth+"px",e.sizer.style.borderRightWidth=Tn(t)+"px",e.scrollbarsClipped=!0)}(e),t.updateMaxLine&&qe(e),t.mustUpdate=t.viewChanged||t.forceUpdate||null!=t.scrollTop||t.scrollToPos&&(t.scrollToPos.from.line<n.viewFrom||t.scrollToPos.to.line>=n.viewTo)||n.maxLineChanged&&e.options.lineWrapping,t.update=t.mustUpdate&&new ai(e,t.mustUpdate&&{top:t.scrollTop,ensure:t.scrollToPos},t.forceUpdate)}function Xr(t){t.updatedDisplay=t.mustUpdate&&si(t.cm,t.update)}function Jr(t){var e=t.cm,n=e.display;t.updatedDisplay&&Tr(e),t.barMeasure=Vr(e),n.maxLineChanged&&!e.options.lineWrapping&&(t.adjustWidthTo=Mn(e,n.maxLine,n.maxLine.text.length).left+3,e.display.sizerWidth=t.adjustWidthTo,t.barMeasure.scrollWidth=Math.max(n.scroller.clientWidth,n.sizer.offsetLeft+t.adjustWidthTo+Tn(e)+e.display.barWidth),t.maxScrollLeft=Math.max(0,n.sizer.offsetLeft+t.adjustWidthTo-Pn(e))),(t.updatedDisplay||t.selectionChanged)&&(t.preparedSelection=n.input.prepareSelection())}function Zr(t){var e=t.cm;null!=t.adjustWidthTo&&(e.display.sizer.style.minWidth=t.adjustWidthTo+"px",t.maxScrollLeft<e.doc.scrollLeft&&Fr(e,Math.min(e.display.scroller.scrollLeft,t.maxScrollLeft),!0),e.display.maxLineChanged=!1);var n=t.focus&&t.focus==D();t.preparedSelection&&e.display.input.showSelection(t.preparedSelection,n),(t.updatedDisplay||t.startHeight!=e.doc.height)&&Br(e,t.barMeasure),t.updatedDisplay&&di(e,t.barMeasure),t.selectionChanged&&xr(e),e.state.focused&&t.updateInput&&e.display.input.reset(t.typing),n&&Cr(t.cm)}function Qr(t){var e=t.cm,n=e.display,r=e.doc;t.updatedDisplay&&ci(e,t.update),null==n.wheelStartX||null==t.scrollTop&&null==t.scrollLeft&&!t.scrollToPos||(n.wheelStartX=n.wheelStartY=null),null!=t.scrollTop&&Ir(e,t.scrollTop,t.forceScroll),null!=t.scrollLeft&&Fr(e,t.scrollLeft,!0,!0),t.scrollToPos&&function(t,e){if(!vt(t,"scrollCursorIntoView")){var n=t.display,r=n.sizer.getBoundingClientRect(),i=null;if(e.top+r.top<0?i=!0:e.bottom+r.top>(window.innerHeight||document.documentElement.clientHeight)&&(i=!1),null!=i&&!p){var o=E("div","​",null,"position: absolute;\n                         top: "+(e.top-n.viewOffset-kn(t.display))+"px;\n                         height: "+(e.bottom-e.top+Tn(t)+n.barHeight)+"px;\n                         left: "+e.left+"px; width: "+Math.max(2,e.right-e.left)+"px;");t.display.lineSpace.appendChild(o),o.scrollIntoView(i),t.display.lineSpace.removeChild(o)}}}(e,function(t,e,n,r){var i;null==r&&(r=0),t.options.lineWrapping||e!=n||(n="before"==e.sticky?ee(e.line,e.ch+1,"before"):e,e=e.ch?ee(e.line,"before"==e.sticky?e.ch-1:e.ch,"after"):e);for(var o=0;o<5;o++){var a=!1,s=Kn(t,e),c=n&&n!=e?Kn(t,n):s,l=_r(t,i={left:Math.min(s.left,c.left),top:Math.min(s.top,c.top)-r,right:Math.max(s.left,c.left),bottom:Math.max(s.bottom,c.bottom)+r}),u=t.doc.scrollTop,d=t.doc.scrollLeft;if(null!=l.scrollTop&&(Rr(t,l.scrollTop),Math.abs(t.doc.scrollTop-u)>1&&(a=!0)),null!=l.scrollLeft&&(Fr(t,l.scrollLeft),Math.abs(t.doc.scrollLeft-d)>1&&(a=!0)),!a)break}return i}(e,ce(r,t.scrollToPos.from),ce(r,t.scrollToPos.to),t.scrollToPos.margin));var i=t.maybeHiddenMarkers,o=t.maybeUnhiddenMarkers;if(i)for(var a=0;a<i.length;++a)i[a].lines.length||gt(i[a],"hide");if(o)for(var s=0;s<o.length;++s)o[s].lines.length&&gt(o[s],"unhide");n.wrapper.offsetHeight&&(r.scrollTop=e.display.scroller.scrollTop),t.changeObjs&&gt(e,"changes",e,t.changeObjs),t.update&&t.update.finish()}function ti(t,e){if(t.curOp)return e();Gr(t);try{return e()}finally{Kr(t)}}function ei(t,e){return function(){if(t.curOp)return e.apply(t,arguments);Gr(t);try{return e.apply(t,arguments)}finally{Kr(t)}}}function ni(t){return function(){if(this.curOp)return t.apply(this,arguments);Gr(this);try{return t.apply(this,arguments)}finally{Kr(this)}}}function ri(t){return function(){var e=this.cm;if(!e||e.curOp)return t.apply(this,arguments);Gr(e);try{return t.apply(this,arguments)}finally{Kr(e)}}}function ii(t,e){t.doc.highlightFrontier<t.display.viewTo&&t.state.highlight.set(e,R(oi,t))}function oi(t){var e=t.doc;if(!(e.highlightFrontier>=t.display.viewTo)){var n=+new Date+t.options.workTime,r=pe(t,e.highlightFrontier),i=[];e.iter(r.line,Math.min(e.first+e.size,t.display.viewTo+500),(function(o){if(r.line>=t.display.viewFrom){var a=o.styles,s=o.text.length>t.options.maxHighlightLength?Ut(e.mode,r.state):null,c=he(t,o,r,!0);s&&(r.state=s),o.styles=c.styles;var l=o.styleClasses,u=c.classes;u?o.styleClasses=u:l&&(o.styleClasses=null);for(var d=!a||a.length!=o.styles.length||l!=u&&(!l||!u||l.bgClass!=u.bgClass||l.textClass!=u.textClass),h=0;!d&&h<a.length;++h)d=a[h]!=o.styles[h];d&&i.push(r.line),o.stateAfter=r.save(),r.nextLine()}else o.text.length<=t.options.maxHighlightLength&&ge(t,o.text,r),o.stateAfter=r.line%5==0?r.save():null,r.nextLine();if(+new Date>n)return ii(t,t.options.workDelay),!0})),e.highlightFrontier=r.line,e.modeFrontier=Math.max(e.modeFrontier,r.line),i.length&&ti(t,(function(){for(var e=0;e<i.length;e++)fr(t,i[e],"text")}))}}var ai=function(t,e,n){var r=t.display;this.viewport=e,this.visible=Er(r,t.doc,e),this.editorIsHidden=!r.wrapper.offsetWidth,this.wrapperHeight=r.wrapper.clientHeight,this.wrapperWidth=r.wrapper.clientWidth,this.oldDisplayWidth=Pn(t),this.force=n,this.dims=ar(t),this.events=[]};function si(t,e){var n=t.display,r=t.doc;if(e.editorIsHidden)return pr(t),!1;if(!e.force&&e.visible.from>=n.viewFrom&&e.visible.to<=n.viewTo&&(null==n.updateLineNumbers||n.updateLineNumbers>=n.viewTo)&&n.renderedView==n.view&&0==vr(t))return!1;fi(t)&&(pr(t),e.dims=ar(t));var i=r.first+r.size,o=Math.max(e.visible.from-t.options.viewportMargin,r.first),a=Math.min(i,e.visible.to+t.options.viewportMargin);n.viewFrom<o&&o-n.viewFrom<20&&(o=Math.max(r.first,n.viewFrom)),n.viewTo>a&&n.viewTo-a<20&&(a=Math.min(i,n.viewTo)),Ce&&(o=ze(t.doc,o),a=He(t.doc,a));var s=o!=n.viewFrom||a!=n.viewTo||n.lastWrapHeight!=e.wrapperHeight||n.lastWrapWidth!=e.wrapperWidth;!function(t,e,n){var r=t.display;0==r.view.length||e>=r.viewTo||n<=r.viewFrom?(r.view=an(t,e,n),r.viewFrom=e):(r.viewFrom>e?r.view=an(t,e,r.viewFrom).concat(r.view):r.viewFrom<e&&(r.view=r.view.slice(dr(t,e))),r.viewFrom=e,r.viewTo<n?r.view=r.view.concat(an(t,r.viewTo,n)):r.viewTo>n&&(r.view=r.view.slice(0,dr(t,n)))),r.viewTo=n}(t,o,a),n.viewOffset=$e(Gt(t.doc,n.viewFrom)),t.display.mover.style.top=n.viewOffset+"px";var l=vr(t);if(!s&&0==l&&!e.force&&n.renderedView==n.view&&(null==n.updateLineNumbers||n.updateLineNumbers>=n.viewTo))return!1;var u=function(t){if(t.hasFocus())return null;var e=D();if(!e||!M(t.display.lineDiv,e))return null;var n={activeElt:e};if(window.getSelection){var r=window.getSelection();r.anchorNode&&r.extend&&M(t.display.lineDiv,r.anchorNode)&&(n.anchorNode=r.anchorNode,n.anchorOffset=r.anchorOffset,n.focusNode=r.focusNode,n.focusOffset=r.focusOffset)}return n}(t);return l>4&&(n.lineDiv.style.display="none"),function(t,e,n){var r=t.display,i=t.options.lineNumbers,o=r.lineDiv,a=o.firstChild;function s(e){var n=e.nextSibling;return c&&y&&t.display.currentWheelTarget==e?e.style.display="none":e.parentNode.removeChild(e),n}for(var l=r.view,u=r.viewFrom,d=0;d<l.length;d++){var h=l[d];if(h.hidden);else if(h.node&&h.node.parentNode==o){for(;a!=h.node;)a=s(a);var f=i&&null!=e&&e<=u&&h.lineNumber;h.changes&&(z(h.changes,"gutter")>-1&&(f=!1),dn(t,h,u,n)),f&&(T(h.lineNumber),h.lineNumber.appendChild(document.createTextNode(te(t.options,u)))),a=h.node.nextSibling}else{var p=yn(t,h,u,n);o.insertBefore(p,a)}u+=h.size}for(;a;)a=s(a)}(t,n.updateLineNumbers,e.dims),l>4&&(n.lineDiv.style.display=""),n.renderedView=n.view,function(t){if(t&&t.activeElt&&t.activeElt!=D()&&(t.activeElt.focus(),!/^(INPUT|TEXTAREA)$/.test(t.activeElt.nodeName)&&t.anchorNode&&M(document.body,t.anchorNode)&&M(document.body,t.focusNode))){var e=window.getSelection(),n=document.createRange();n.setEnd(t.anchorNode,t.anchorOffset),n.collapse(!1),e.removeAllRanges(),e.addRange(n),e.extend(t.focusNode,t.focusOffset)}}(u),T(n.cursorDiv),T(n.selectionDiv),n.gutters.style.height=n.sizer.style.minHeight=0,s&&(n.lastWrapHeight=e.wrapperHeight,n.lastWrapWidth=e.wrapperWidth,ii(t,400)),n.updateLineNumbers=null,!0}function ci(t,e){for(var n=e.viewport,r=!0;;r=!1){if(r&&t.options.lineWrapping&&e.oldDisplayWidth!=Pn(t))r&&(e.visible=Er(t.display,t.doc,n));else if(n&&null!=n.top&&(n={top:Math.min(t.doc.height+Sn(t.display)-En(t),n.top)}),e.visible=Er(t.display,t.doc,n),e.visible.from>=t.display.viewFrom&&e.visible.to<=t.display.viewTo)break;if(!si(t,e))break;Tr(t);var i=Vr(t);mr(t),Br(t,i),di(t,i),e.force=!1}e.signal(t,"update",t),t.display.viewFrom==t.display.reportedViewFrom&&t.display.viewTo==t.display.reportedViewTo||(e.signal(t,"viewportChange",t,t.display.viewFrom,t.display.viewTo),t.display.reportedViewFrom=t.display.viewFrom,t.display.reportedViewTo=t.display.viewTo)}function li(t,e){var n=new ai(t,e);if(si(t,n)){Tr(t),ci(t,n);var r=Vr(t);mr(t),Br(t,r),di(t,r),n.finish()}}function ui(t){var e=t.gutters.offsetWidth;t.sizer.style.marginLeft=e+"px",ln(t,"gutterChanged",t)}function di(t,e){t.display.sizer.style.minHeight=e.docHeight+"px",t.display.heightForcer.style.top=e.docHeight+"px",t.display.gutters.style.height=e.docHeight+t.display.barHeight+Tn(t)+"px"}function hi(t){var e=t.display,n=e.view;if(e.alignWidgets||e.gutters.firstChild&&t.options.fixedGutter){for(var r=sr(e)-e.scroller.scrollLeft+t.doc.scrollLeft,i=e.gutters.offsetWidth,o=r+"px",a=0;a<n.length;a++)if(!n[a].hidden){t.options.fixedGutter&&(n[a].gutter&&(n[a].gutter.style.left=o),n[a].gutterBackground&&(n[a].gutterBackground.style.left=o));var s=n[a].alignable;if(s)for(var c=0;c<s.length;c++)s[c].style.left=o}t.options.fixedGutter&&(e.gutters.style.left=r+i+"px")}}function fi(t){if(!t.options.lineNumbers)return!1;var e=t.doc,n=te(t.options,e.first+e.size-1),r=t.display;if(n.length!=r.lineNumChars){var i=r.measure.appendChild(E("div",[E("div",n)],"CodeMirror-linenumber CodeMirror-gutter-elt")),o=i.firstChild.offsetWidth,a=i.offsetWidth-o;return r.lineGutter.style.width="",r.lineNumInnerWidth=Math.max(o,r.lineGutter.offsetWidth-a)+1,r.lineNumWidth=r.lineNumInnerWidth+a,r.lineNumChars=r.lineNumInnerWidth?n.length:-1,r.lineGutter.style.width=r.lineNumWidth+"px",ui(t.display),!0}return!1}function pi(t,e){for(var n=[],r=!1,i=0;i<t.length;i++){var o=t[i],a=null;if("string"!=typeof o&&(a=o.style,o=o.className),"CodeMirror-linenumbers"==o){if(!e)continue;r=!0}n.push({className:o,style:a})}return e&&!r&&n.push({className:"CodeMirror-linenumbers",style:null}),n}function gi(t){var e=t.gutters,n=t.gutterSpecs;T(e),t.lineGutter=null;for(var r=0;r<n.length;++r){var i=n[r],o=i.className,a=i.style,s=e.appendChild(E("div",null,"CodeMirror-gutter "+o));a&&(s.style.cssText=a),"CodeMirror-linenumbers"==o&&(t.lineGutter=s,s.style.width=(t.lineNumWidth||1)+"px")}e.style.display=n.length?"":"none",ui(t)}function vi(t){gi(t.display),hr(t),hi(t)}function mi(t,e,r,i){var o=this;this.input=r,o.scrollbarFiller=E("div",null,"CodeMirror-scrollbar-filler"),o.scrollbarFiller.setAttribute("cm-not-content","true"),o.gutterFiller=E("div",null,"CodeMirror-gutter-filler"),o.gutterFiller.setAttribute("cm-not-content","true"),o.lineDiv=_("div",null,"CodeMirror-code"),o.selectionDiv=E("div",null,null,"position: relative; z-index: 1"),o.cursorDiv=E("div",null,"CodeMirror-cursors"),o.measure=E("div",null,"CodeMirror-measure"),o.lineMeasure=E("div",null,"CodeMirror-measure"),o.lineSpace=_("div",[o.measure,o.lineMeasure,o.selectionDiv,o.cursorDiv,o.lineDiv],null,"position: relative; outline: none");var l=_("div",[o.lineSpace],"CodeMirror-lines");o.mover=E("div",[l],null,"position: relative"),o.sizer=E("div",[o.mover],"CodeMirror-sizer"),o.sizerWidth=null,o.heightForcer=E("div",null,null,"position: absolute; height: "+H+"px; width: 1px;"),o.gutters=E("div",null,"CodeMirror-gutters"),o.lineGutter=null,o.scroller=E("div",[o.sizer,o.heightForcer,o.gutters],"CodeMirror-scroll"),o.scroller.setAttribute("tabIndex","-1"),o.wrapper=E("div",[o.scrollbarFiller,o.gutterFiller,o.scroller],"CodeMirror"),o.wrapper.setAttribute('translate','no'),a&&s<8&&(o.gutters.style.zIndex=-1,o.scroller.style.paddingRight=0),c||n&&m||(o.scroller.draggable=!0),t&&(t.appendChild?t.appendChild(o.wrapper):t(o.wrapper)),o.viewFrom=o.viewTo=e.first,o.reportedViewFrom=o.reportedViewTo=e.first,o.view=[],o.renderedView=null,o.externalMeasured=null,o.viewOffset=0,o.lastWrapHeight=o.lastWrapWidth=0,o.updateLineNumbers=null,o.nativeBarWidth=o.barHeight=o.barWidth=0,o.scrollbarsClipped=!1,o.lineNumWidth=o.lineNumInnerWidth=o.lineNumChars=null,o.alignWidgets=!1,o.cachedCharWidth=o.cachedTextHeight=o.cachedPaddingH=null,o.maxLine=null,o.maxLineLength=0,o.maxLineChanged=!1,o.wheelDX=o.wheelDY=o.wheelStartX=o.wheelStartY=null,o.shift=!1,o.selForContextMenu=null,o.activeTouch=null,o.gutterSpecs=pi(i.gutters,i.lineNumbers),gi(o),r.init(o)}ai.prototype.signal=function(t,e){yt(t,e)&&this.events.push(arguments)},ai.prototype.finish=function(){for(var t=0;t<this.events.length;t++)gt.apply(null,this.events[t])};var yi=0,bi=null;function wi(t){var e=t.wheelDeltaX,n=t.wheelDeltaY;return null==e&&t.detail&&t.axis==t.HORIZONTAL_AXIS&&(e=t.detail),null==n&&t.detail&&t.axis==t.VERTICAL_AXIS?n=t.detail:null==n&&(n=t.wheelDelta),{x:e,y:n}}function Oi(t){var e=wi(t);return e.x*=bi,e.y*=bi,e}function xi(t,e){var r=wi(e),i=r.x,o=r.y,a=t.display,s=a.scroller,l=s.scrollWidth>s.clientWidth,u=s.scrollHeight>s.clientHeight;if(i&&l||o&&u){if(o&&y&&c)t:for(var h=e.target,f=a.view;h!=s;h=h.parentNode)for(var p=0;p<f.length;p++)if(f[p].node==h){t.display.currentWheelTarget=h;break t}if(i&&!n&&!d&&null!=bi)return o&&u&&Rr(t,Math.max(0,s.scrollTop+o*bi)),Fr(t,Math.max(0,s.scrollLeft+i*bi)),(!o||o&&u)&&wt(e),void(a.wheelStartX=null);if(o&&null!=bi){var g=o*bi,v=t.doc.scrollTop,m=v+a.wrapper.clientHeight;g<0?v=Math.max(0,v+g-50):m=Math.min(t.doc.height,m+g+50),li(t,{top:v,bottom:m})}yi<20&&(null==a.wheelStartX?(a.wheelStartX=s.scrollLeft,a.wheelStartY=s.scrollTop,a.wheelDX=i,a.wheelDY=o,setTimeout((function(){if(null!=a.wheelStartX){var t=s.scrollLeft-a.wheelStartX,e=s.scrollTop-a.wheelStartY,n=e&&a.wheelDY&&e/a.wheelDY||t&&a.wheelDX&&t/a.wheelDX;a.wheelStartX=a.wheelStartY=null,n&&(bi=(bi*yi+n)/(yi+1),++yi)}}),200)):(a.wheelDX+=i,a.wheelDY+=o))}}a?bi=-.53:n?bi=15:u?bi=-.7:h&&(bi=-1/3);var Ci=function(t,e){this.ranges=t,this.primIndex=e};Ci.prototype.primary=function(){return this.ranges[this.primIndex]},Ci.prototype.equals=function(t){if(t==this)return!0;if(t.primIndex!=this.primIndex||t.ranges.length!=this.ranges.length)return!1;for(var e=0;e<this.ranges.length;e++){var n=this.ranges[e],r=t.ranges[e];if(!re(n.anchor,r.anchor)||!re(n.head,r.head))return!1}return!0},Ci.prototype.deepCopy=function(){for(var t=[],e=0;e<this.ranges.length;e++)t[e]=new ki(ie(this.ranges[e].anchor),ie(this.ranges[e].head));return new Ci(t,this.primIndex)},Ci.prototype.somethingSelected=function(){for(var t=0;t<this.ranges.length;t++)if(!this.ranges[t].empty())return!0;return!1},Ci.prototype.contains=function(t,e){e||(e=t);for(var n=0;n<this.ranges.length;n++){var r=this.ranges[n];if(ne(e,r.from())>=0&&ne(t,r.to())<=0)return n}return-1};var ki=function(t,e){this.anchor=t,this.head=e};function Si(t,e,n){var r=t&&t.options.selectionsMayTouch,i=e[n];e.sort((function(t,e){return ne(t.from(),e.from())})),n=z(e,i);for(var o=1;o<e.length;o++){var a=e[o],s=e[o-1],c=ne(s.to(),a.from());if(r&&!a.empty()?c>0:c>=0){var l=ae(s.from(),a.from()),u=oe(s.to(),a.to()),d=s.empty()?a.from()==a.head:s.from()==s.head;o<=n&&--n,e.splice(--o,2,new ki(d?u:l,d?l:u))}}return new Ci(e,n)}function ji(t,e){return new Ci([new ki(t,e||t)],0)}function Ti(t){return t.text?ee(t.from.line+t.text.length-1,Y(t.text).length+(1==t.text.length?t.from.ch:0)):t.to}function Pi(t,e){if(ne(t,e.from)<0)return t;if(ne(t,e.to)<=0)return Ti(e);var n=t.line+e.text.length-(e.to.line-e.from.line)-1,r=t.ch;return t.line==e.to.line&&(r+=Ti(e).ch-e.to.ch),ee(n,r)}function Ei(t,e){for(var n=[],r=0;r<t.sel.ranges.length;r++){var i=t.sel.ranges[r];n.push(new ki(Pi(i.anchor,e),Pi(i.head,e)))}return Si(t.cm,n,t.sel.primIndex)}function _i(t,e,n){return t.line==e.line?ee(n.line,t.ch-e.ch+n.ch):ee(n.line+(t.line-e.line),t.ch)}function Mi(t){t.doc.mode=zt(t.options,t.doc.modeOption),Di(t)}function Di(t){t.doc.iter((function(t){t.stateAfter&&(t.stateAfter=null),t.styles&&(t.styles=null)})),t.doc.modeFrontier=t.doc.highlightFrontier=t.doc.first,ii(t,100),t.state.modeGen++,t.curOp&&hr(t)}function Ai(t,e){return 0==e.from.ch&&0==e.to.ch&&""==Y(e.text)&&(!t.cm||t.cm.options.wholeLineUpdateBefore)}function Li(t,e,n,r){function i(t){return n?n[t]:null}function o(t,n,i){!function(t,e,n,r){t.text=e,t.stateAfter&&(t.stateAfter=null),t.styles&&(t.styles=null),null!=t.order&&(t.order=null),Ee(t),_e(t,n);var i=r?r(t):1;i!=t.height&&Xt(t,i)}(t,n,i,r),ln(t,"change",t,e)}function a(t,e){for(var n=[],o=t;o<e;++o)n.push(new Ge(l[o],i(o),r));return n}var s=e.from,c=e.to,l=e.text,u=Gt(t,s.line),d=Gt(t,c.line),h=Y(l),f=i(l.length-1),p=c.line-s.line;if(e.full)t.insert(0,a(0,l.length)),t.remove(l.length,t.size-l.length);else if(Ai(t,e)){var g=a(0,l.length-1);o(d,d.text,f),p&&t.remove(s.line,p),g.length&&t.insert(s.line,g)}else if(u==d)if(1==l.length)o(u,u.text.slice(0,s.ch)+h+u.text.slice(c.ch),f);else{var v=a(1,l.length-1);v.push(new Ge(h+u.text.slice(c.ch),f,r)),o(u,u.text.slice(0,s.ch)+l[0],i(0)),t.insert(s.line+1,v)}else if(1==l.length)o(u,u.text.slice(0,s.ch)+l[0]+d.text.slice(c.ch),i(0)),t.remove(s.line+1,p);else{o(u,u.text.slice(0,s.ch)+l[0],i(0)),o(d,h+d.text.slice(c.ch),f);var m=a(1,l.length-1);p>1&&t.remove(s.line+1,p-1),t.insert(s.line+1,m)}ln(t,"change",t,e)}function Ni(t,e,n){!function t(r,i,o){if(r.linked)for(var a=0;a<r.linked.length;++a){var s=r.linked[a];if(s.doc!=i){var c=o&&s.sharedHist;n&&!c||(e(s.doc,c),t(s.doc,r,c))}}}(t,null,!0)}function Ri(t,e){if(e.cm)throw new Error("This document is already in use.");t.doc=e,e.cm=t,lr(t),Mi(t),Ii(t),t.options.direction=e.direction,t.options.lineWrapping||qe(t),t.options.mode=e.modeOption,hr(t)}function Ii(t){("rtl"==t.doc.direction?A:j)(t.display.lineDiv,"CodeMirror-rtl")}function Fi(t){this.done=[],this.undone=[],this.undoDepth=t?t.undoDepth:1/0,this.lastModTime=this.lastSelTime=0,this.lastOp=this.lastSelOp=null,this.lastOrigin=this.lastSelOrigin=null,this.generation=this.maxGeneration=t?t.maxGeneration:1}function Vi(t,e){var n={from:ie(e.from),to:Ti(e),text:Kt(t,e.from,e.to)};return $i(t,n,e.from.line,e.to.line+1),Ni(t,(function(t){return $i(t,n,e.from.line,e.to.line+1)}),!0),n}function zi(t){for(;t.length&&Y(t).ranges;)t.pop()}function Hi(t,e,n,r){var i=t.history;i.undone.length=0;var o,a,s=+new Date;if((i.lastOp==r||i.lastOrigin==e.origin&&e.origin&&("+"==e.origin.charAt(0)&&i.lastModTime>s-(t.cm?t.cm.options.historyEventDelay:500)||"*"==e.origin.charAt(0)))&&(o=function(t,e){return e?(zi(t.done),Y(t.done)):t.done.length&&!Y(t.done).ranges?Y(t.done):t.done.length>1&&!t.done[t.done.length-2].ranges?(t.done.pop(),Y(t.done)):void 0}(i,i.lastOp==r)))a=Y(o.changes),0==ne(e.from,e.to)&&0==ne(e.from,a.to)?a.to=Ti(e):o.changes.push(Vi(t,e));else{var c=Y(i.done);for(c&&c.ranges||Ui(t.sel,i.done),o={changes:[Vi(t,e)],generation:i.generation},i.done.push(o);i.done.length>i.undoDepth;)i.done.shift(),i.done[0].ranges||i.done.shift()}i.done.push(n),i.generation=++i.maxGeneration,i.lastModTime=i.lastSelTime=s,i.lastOp=i.lastSelOp=r,i.lastOrigin=i.lastSelOrigin=e.origin,a||gt(t,"historyAdded")}function Bi(t,e,n,r){var i=t.history,o=r&&r.origin;n==i.lastSelOp||o&&i.lastSelOrigin==o&&(i.lastModTime==i.lastSelTime&&i.lastOrigin==o||function(t,e,n,r){var i=e.charAt(0);return"*"==i||"+"==i&&n.ranges.length==r.ranges.length&&n.somethingSelected()==r.somethingSelected()&&new Date-t.history.lastSelTime<=(t.cm?t.cm.options.historyEventDelay:500)}(t,o,Y(i.done),e))?i.done[i.done.length-1]=e:Ui(e,i.done),i.lastSelTime=+new Date,i.lastSelOrigin=o,i.lastSelOp=n,r&&!1!==r.clearRedo&&zi(i.undone)}function Ui(t,e){var n=Y(e);n&&n.ranges&&n.equals(t)||e.push(t)}function $i(t,e,n,r){var i=e["spans_"+t.id],o=0;t.iter(Math.max(t.first,n),Math.min(t.first+t.size,r),(function(n){n.markedSpans&&((i||(i=e["spans_"+t.id]={}))[o]=n.markedSpans),++o}))}function Wi(t){if(!t)return null;for(var e,n=0;n<t.length;++n)t[n].marker.explicitlyCleared?e||(e=t.slice(0,n)):e&&e.push(t[n]);return e?e.length?e:null:t}function qi(t,e){var n=function(t,e){var n=e["spans_"+t.id];if(!n)return null;for(var r=[],i=0;i<e.text.length;++i)r.push(Wi(n[i]));return r}(t,e),r=Te(t,e);if(!n)return r;if(!r)return n;for(var i=0;i<n.length;++i){var o=n[i],a=r[i];if(o&&a)t:for(var s=0;s<a.length;++s){for(var c=a[s],l=0;l<o.length;++l)if(o[l].marker==c.marker)continue t;o.push(c)}else a&&(n[i]=a)}return n}function Gi(t,e,n){for(var r=[],i=0;i<t.length;++i){var o=t[i];if(o.ranges)r.push(n?Ci.prototype.deepCopy.call(o):o);else{var a=o.changes,s=[];r.push({changes:s});for(var c=0;c<a.length;++c){var l=a[c],u=void 0;if(s.push({from:l.from,to:l.to,text:l.text}),e)for(var d in l)(u=d.match(/^spans_(\d+)$/))&&z(e,Number(u[1]))>-1&&(Y(s)[d]=l[d],delete l[d])}}}return r}function Ki(t,e,n,r){if(r){var i=t.anchor;if(n){var o=ne(e,i)<0;o!=ne(n,i)<0?(i=e,e=n):o!=ne(e,n)<0&&(e=n)}return new ki(i,e)}return new ki(n||e,e)}function Yi(t,e,n,r,i){null==i&&(i=t.cm&&(t.cm.display.shift||t.extend)),to(t,new Ci([Ki(t.sel.primary(),e,n,i)],0),r)}function Xi(t,e,n){for(var r=[],i=t.cm&&(t.cm.display.shift||t.extend),o=0;o<t.sel.ranges.length;o++)r[o]=Ki(t.sel.ranges[o],e[o],null,i);to(t,Si(t.cm,r,t.sel.primIndex),n)}function Ji(t,e,n,r){var i=t.sel.ranges.slice(0);i[e]=n,to(t,Si(t.cm,i,t.sel.primIndex),r)}function Zi(t,e,n,r){to(t,ji(e,n),r)}function Qi(t,e,n){var r=t.history.done,i=Y(r);i&&i.ranges?(r[r.length-1]=e,eo(t,e,n)):to(t,e,n)}function to(t,e,n){eo(t,e,n),Bi(t,t.sel,t.cm?t.cm.curOp.id:NaN,n)}function eo(t,e,n){(yt(t,"beforeSelectionChange")||t.cm&&yt(t.cm,"beforeSelectionChange"))&&(e=function(t,e,n){var r={ranges:e.ranges,update:function(e){this.ranges=[];for(var n=0;n<e.length;n++)this.ranges[n]=new ki(ce(t,e[n].anchor),ce(t,e[n].head))},origin:n&&n.origin};return gt(t,"beforeSelectionChange",t,r),t.cm&&gt(t.cm,"beforeSelectionChange",t.cm,r),r.ranges!=e.ranges?Si(t.cm,r.ranges,r.ranges.length-1):e}(t,e,n));var r=n&&n.bias||(ne(e.primary().head,t.sel.primary().head)<0?-1:1);no(t,io(t,e,r,!0)),n&&!1===n.scroll||!t.cm||"nocursor"==t.cm.getOption("readOnly")||Dr(t.cm)}function no(t,e){e.equals(t.sel)||(t.sel=e,t.cm&&(t.cm.curOp.updateInput=1,t.cm.curOp.selectionChanged=!0,mt(t.cm)),ln(t,"cursorActivity",t))}function ro(t){no(t,io(t,t.sel,null,!1))}function io(t,e,n,r){for(var i,o=0;o<e.ranges.length;o++){var a=e.ranges[o],s=e.ranges.length==t.sel.ranges.length&&t.sel.ranges[o],c=ao(t,a.anchor,s&&s.anchor,n,r),l=ao(t,a.head,s&&s.head,n,r);(i||c!=a.anchor||l!=a.head)&&(i||(i=e.ranges.slice(0,o)),i[o]=new ki(c,l))}return i?Si(t.cm,i,e.primIndex):e}function oo(t,e,n,r,i){var o=Gt(t,e.line);if(o.markedSpans)for(var a=0;a<o.markedSpans.length;++a){var s=o.markedSpans[a],c=s.marker,l="selectLeft"in c?!c.selectLeft:c.inclusiveLeft,u="selectRight"in c?!c.selectRight:c.inclusiveRight;if((null==s.from||(l?s.from<=e.ch:s.from<e.ch))&&(null==s.to||(u?s.to>=e.ch:s.to>e.ch))){if(i&&(gt(c,"beforeCursorEnter"),c.explicitlyCleared)){if(o.markedSpans){--a;continue}break}if(!c.atomic)continue;if(n){var d=c.find(r<0?1:-1),h=void 0;if((r<0?u:l)&&(d=so(t,d,-r,d&&d.line==e.line?o:null)),d&&d.line==e.line&&(h=ne(d,n))&&(r<0?h<0:h>0))return oo(t,d,e,r,i)}var f=c.find(r<0?-1:1);return(r<0?l:u)&&(f=so(t,f,r,f.line==e.line?o:null)),f?oo(t,f,e,r,i):null}}return e}function ao(t,e,n,r,i){var o=r||1,a=oo(t,e,n,o,i)||!i&&oo(t,e,n,o,!0)||oo(t,e,n,-o,i)||!i&&oo(t,e,n,-o,!0);return a||(t.cantEdit=!0,ee(t.first,0))}function so(t,e,n,r){return n<0&&0==e.ch?e.line>t.first?ce(t,ee(e.line-1)):null:n>0&&e.ch==(r||Gt(t,e.line)).text.length?e.line<t.first+t.size-1?ee(e.line+1,0):null:new ee(e.line,e.ch+n)}function co(t){t.setSelection(ee(t.firstLine(),0),ee(t.lastLine()),U)}function lo(t,e,n){var r={canceled:!1,from:e.from,to:e.to,text:e.text,origin:e.origin,cancel:function(){return r.canceled=!0}};return n&&(r.update=function(e,n,i,o){e&&(r.from=ce(t,e)),n&&(r.to=ce(t,n)),i&&(r.text=i),void 0!==o&&(r.origin=o)}),gt(t,"beforeChange",t,r),t.cm&&gt(t.cm,"beforeChange",t.cm,r),r.canceled?(t.cm&&(t.cm.curOp.updateInput=2),null):{from:r.from,to:r.to,text:r.text,origin:r.origin}}function uo(t,e,n){if(t.cm){if(!t.cm.curOp)return ei(t.cm,uo)(t,e,n);if(t.cm.state.suppressEdits)return}if(!(yt(t,"beforeChange")||t.cm&&yt(t.cm,"beforeChange"))||(e=lo(t,e,!0))){var r=xe&&!n&&function(t,e,n){var r=null;if(t.iter(e.line,n.line+1,(function(t){if(t.markedSpans)for(var e=0;e<t.markedSpans.length;++e){var n=t.markedSpans[e].marker;!n.readOnly||r&&-1!=z(r,n)||(r||(r=[])).push(n)}})),!r)return null;for(var i=[{from:e,to:n}],o=0;o<r.length;++o)for(var a=r[o],s=a.find(0),c=0;c<i.length;++c){var l=i[c];if(!(ne(l.to,s.from)<0||ne(l.from,s.to)>0)){var u=[c,1],d=ne(l.from,s.from),h=ne(l.to,s.to);(d<0||!a.inclusiveLeft&&!d)&&u.push({from:l.from,to:s.from}),(h>0||!a.inclusiveRight&&!h)&&u.push({from:s.to,to:l.to}),i.splice.apply(i,u),c+=u.length-3}}return i}(t,e.from,e.to);if(r)for(var i=r.length-1;i>=0;--i)ho(t,{from:r[i].from,to:r[i].to,text:i?[""]:e.text,origin:e.origin});else ho(t,e)}}function ho(t,e){if(1!=e.text.length||""!=e.text[0]||0!=ne(e.from,e.to)){var n=Ei(t,e);Hi(t,e,n,t.cm?t.cm.curOp.id:NaN),go(t,e,n,Te(t,e));var r=[];Ni(t,(function(t,n){n||-1!=z(r,t.history)||(bo(t.history,e),r.push(t.history)),go(t,e,null,Te(t,e))}))}}function fo(t,e,n){var r=t.cm&&t.cm.state.suppressEdits;if(!r||n){for(var i,o=t.history,a=t.sel,s="undo"==e?o.done:o.undone,c="undo"==e?o.undone:o.done,l=0;l<s.length&&(i=s[l],n?!i.ranges||i.equals(t.sel):i.ranges);l++);if(l!=s.length){for(o.lastOrigin=o.lastSelOrigin=null;;){if(!(i=s.pop()).ranges){if(r)return void s.push(i);break}if(Ui(i,c),n&&!i.equals(t.sel))return void to(t,i,{clearRedo:!1});a=i}var u=[];Ui(a,c),c.push({changes:u,generation:o.generation}),o.generation=i.generation||++o.maxGeneration;for(var d=yt(t,"beforeChange")||t.cm&&yt(t.cm,"beforeChange"),h=function(n){var r=i.changes[n];if(r.origin=e,d&&!lo(t,r,!1))return s.length=0,{};u.push(Vi(t,r));var o=n?Ei(t,r):Y(s);go(t,r,o,qi(t,r)),!n&&t.cm&&t.cm.scrollIntoView({from:r.from,to:Ti(r)});var a=[];Ni(t,(function(t,e){e||-1!=z(a,t.history)||(bo(t.history,r),a.push(t.history)),go(t,r,null,qi(t,r))}))},f=i.changes.length-1;f>=0;--f){var p=h(f);if(p)return p.v}}}}function po(t,e){if(0!=e&&(t.first+=e,t.sel=new Ci(X(t.sel.ranges,(function(t){return new ki(ee(t.anchor.line+e,t.anchor.ch),ee(t.head.line+e,t.head.ch))})),t.sel.primIndex),t.cm)){hr(t.cm,t.first,t.first-e,e);for(var n=t.cm.display,r=n.viewFrom;r<n.viewTo;r++)fr(t.cm,r,"gutter")}}function go(t,e,n,r){if(t.cm&&!t.cm.curOp)return ei(t.cm,go)(t,e,n,r);if(e.to.line<t.first)po(t,e.text.length-1-(e.to.line-e.from.line));else if(!(e.from.line>t.lastLine())){if(e.from.line<t.first){var i=e.text.length-1-(t.first-e.from.line);po(t,i),e={from:ee(t.first,0),to:ee(e.to.line+i,e.to.ch),text:[Y(e.text)],origin:e.origin}}var o=t.lastLine();e.to.line>o&&(e={from:e.from,to:ee(o,Gt(t,o).text.length),text:[e.text[0]],origin:e.origin}),e.removed=Kt(t,e.from,e.to),n||(n=Ei(t,e)),t.cm?function(t,e,n){var r=t.doc,i=t.display,o=e.from,a=e.to,s=!1,c=o.line;t.options.lineWrapping||(c=Jt(Ve(Gt(r,o.line))),r.iter(c,a.line+1,(function(t){if(t==i.maxLine)return s=!0,!0}))),r.sel.contains(e.from,e.to)>-1&&mt(t),Li(r,e,n,cr(t)),t.options.lineWrapping||(r.iter(c,o.line+e.text.length,(function(t){var e=We(t);e>i.maxLineLength&&(i.maxLine=t,i.maxLineLength=e,i.maxLineChanged=!0,s=!1)})),s&&(t.curOp.updateMaxLine=!0)),function(t,e){if(t.modeFrontier=Math.min(t.modeFrontier,e),!(t.highlightFrontier<e-10)){for(var n=t.first,r=e-1;r>n;r--){var i=Gt(t,r).stateAfter;if(i&&(!(i instanceof ue)||r+i.lookAhead<e)){n=r+1;break}}t.highlightFrontier=Math.min(t.highlightFrontier,n)}}(r,o.line),ii(t,400);var l=e.text.length-(a.line-o.line)-1;e.full?hr(t):o.line!=a.line||1!=e.text.length||Ai(t.doc,e)?hr(t,o.line,a.line+1,l):fr(t,o.line,"text");var u=yt(t,"changes"),d=yt(t,"change");if(d||u){var h={from:o,to:a,text:e.text,removed:e.removed,origin:e.origin};d&&ln(t,"change",t,h),u&&(t.curOp.changeObjs||(t.curOp.changeObjs=[])).push(h)}t.display.selForContextMenu=null}(t.cm,e,r):Li(t,e,r),eo(t,n,U),t.cantEdit&&ao(t,ee(t.firstLine(),0))&&(t.cantEdit=!1)}}function vo(t,e,n,r,i){var o;r||(r=n),ne(r,n)<0&&(n=(o=[r,n])[0],r=o[1]),"string"==typeof e&&(e=t.splitLines(e)),uo(t,{from:n,to:r,text:e,origin:i})}function mo(t,e,n,r){n<t.line?t.line+=r:e<t.line&&(t.line=e,t.ch=0)}function yo(t,e,n,r){for(var i=0;i<t.length;++i){var o=t[i],a=!0;if(o.ranges){o.copied||((o=t[i]=o.deepCopy()).copied=!0);for(var s=0;s<o.ranges.length;s++)mo(o.ranges[s].anchor,e,n,r),mo(o.ranges[s].head,e,n,r)}else{for(var c=0;c<o.changes.length;++c){var l=o.changes[c];if(n<l.from.line)l.from=ee(l.from.line+r,l.from.ch),l.to=ee(l.to.line+r,l.to.ch);else if(e<=l.to.line){a=!1;break}}a||(t.splice(0,i+1),i=0)}}}function bo(t,e){var n=e.from.line,r=e.to.line,i=e.text.length-(r-n)-1;yo(t.done,n,r,i),yo(t.undone,n,r,i)}function wo(t,e,n,r){var i=e,o=e;return"number"==typeof e?o=Gt(t,se(t,e)):i=Jt(e),null==i?null:(r(o,i)&&t.cm&&fr(t.cm,i,n),o)}function Oo(t){this.lines=t,this.parent=null;for(var e=0,n=0;n<t.length;++n)t[n].parent=this,e+=t[n].height;this.height=e}function xo(t){this.children=t;for(var e=0,n=0,r=0;r<t.length;++r){var i=t[r];e+=i.chunkSize(),n+=i.height,i.parent=this}this.size=e,this.height=n,this.parent=null}ki.prototype.from=function(){return ae(this.anchor,this.head)},ki.prototype.to=function(){return oe(this.anchor,this.head)},ki.prototype.empty=function(){return this.head.line==this.anchor.line&&this.head.ch==this.anchor.ch},Oo.prototype={chunkSize:function(){return this.lines.length},removeInner:function(t,e){for(var n=t,r=t+e;n<r;++n){var i=this.lines[n];this.height-=i.height,Ke(i),ln(i,"delete")}this.lines.splice(t,e)},collapse:function(t){t.push.apply(t,this.lines)},insertInner:function(t,e,n){this.height+=n,this.lines=this.lines.slice(0,t).concat(e).concat(this.lines.slice(t));for(var r=0;r<e.length;++r)e[r].parent=this},iterN:function(t,e,n){for(var r=t+e;t<r;++t)if(n(this.lines[t]))return!0}},xo.prototype={chunkSize:function(){return this.size},removeInner:function(t,e){this.size-=e;for(var n=0;n<this.children.length;++n){var r=this.children[n],i=r.chunkSize();if(t<i){var o=Math.min(e,i-t),a=r.height;if(r.removeInner(t,o),this.height-=a-r.height,i==o&&(this.children.splice(n--,1),r.parent=null),0==(e-=o))break;t=0}else t-=i}if(this.size-e<25&&(this.children.length>1||!(this.children[0]instanceof Oo))){var s=[];this.collapse(s),this.children=[new Oo(s)],this.children[0].parent=this}},collapse:function(t){for(var e=0;e<this.children.length;++e)this.children[e].collapse(t)},insertInner:function(t,e,n){this.size+=e.length,this.height+=n;for(var r=0;r<this.children.length;++r){var i=this.children[r],o=i.chunkSize();if(t<=o){if(i.insertInner(t,e,n),i.lines&&i.lines.length>50){for(var a=i.lines.length%25+25,s=a;s<i.lines.length;){var c=new Oo(i.lines.slice(s,s+=25));i.height-=c.height,this.children.splice(++r,0,c),c.parent=this}i.lines=i.lines.slice(0,a),this.maybeSpill()}break}t-=o}},maybeSpill:function(){if(!(this.children.length<=10)){var t=this;do{var e=new xo(t.children.splice(t.children.length-5,5));if(t.parent){t.size-=e.size,t.height-=e.height;var n=z(t.parent.children,t);t.parent.children.splice(n+1,0,e)}else{var r=new xo(t.children);r.parent=t,t.children=[r,e],t=r}e.parent=t.parent}while(t.children.length>10);t.parent.maybeSpill()}},iterN:function(t,e,n){for(var r=0;r<this.children.length;++r){var i=this.children[r],o=i.chunkSize();if(t<o){var a=Math.min(e,o-t);if(i.iterN(t,a,n))return!0;if(0==(e-=a))break;t=0}else t-=o}}};var Co=function(t,e,n){if(n)for(var r in n)n.hasOwnProperty(r)&&(this[r]=n[r]);this.doc=t,this.node=e};function ko(t,e,n){$e(e)<(t.curOp&&t.curOp.scrollTop||t.doc.scrollTop)&&Mr(t,n)}Co.prototype.clear=function(){var t=this.doc.cm,e=this.line.widgets,n=this.line,r=Jt(n);if(null!=r&&e){for(var i=0;i<e.length;++i)e[i]==this&&e.splice(i--,1);e.length||(n.widgets=null);var o=xn(this);Xt(n,Math.max(0,n.height-o)),t&&(ti(t,(function(){ko(t,n,-o),fr(t,r,"widget")})),ln(t,"lineWidgetCleared",t,this,r))}},Co.prototype.changed=function(){var t=this,e=this.height,n=this.doc.cm,r=this.line;this.height=null;var i=xn(this)-e;i&&(Be(this.doc,r)||Xt(r,r.height+i),n&&ti(n,(function(){n.curOp.forceUpdate=!0,ko(n,r,i),ln(n,"lineWidgetChanged",n,t,Jt(r))})))},bt(Co);var So=0,jo=function(t,e){this.lines=[],this.type=e,this.doc=t,this.id=++So};function To(t,e,n,r,i){if(r&&r.shared)return function(t,e,n,r,i){(r=I(r)).shared=!1;var o=[To(t,e,n,r,i)],a=o[0],s=r.widgetNode;return Ni(t,(function(t){s&&(r.widgetNode=s.cloneNode(!0)),o.push(To(t,ce(t,e),ce(t,n),r,i));for(var c=0;c<t.linked.length;++c)if(t.linked[c].isParent)return;a=Y(o)})),new Po(o,a)}(t,e,n,r,i);if(t.cm&&!t.cm.curOp)return ei(t.cm,To)(t,e,n,r,i);var o=new jo(t,i),a=ne(e,n);if(r&&I(r,o,!1),a>0||0==a&&!1!==o.clearWhenEmpty)return o;if(o.replacedWith&&(o.collapsed=!0,o.widgetNode=_("span",[o.replacedWith],"CodeMirror-widget"),r.handleMouseEvents||o.widgetNode.setAttribute("cm-ignore-events","true"),r.insertLeft&&(o.widgetNode.insertLeft=!0)),o.collapsed){if(Fe(t,e.line,e,n,o)||e.line!=n.line&&Fe(t,n.line,e,n,o))throw new Error("Inserting collapsed marker partially overlapping an existing one");Ce=!0}o.addToHistory&&Hi(t,{from:e,to:n,origin:"markText"},t.sel,NaN);var s,c=e.line,l=t.cm;if(t.iter(c,n.line+1,(function(r){l&&o.collapsed&&!l.options.lineWrapping&&Ve(r)==l.display.maxLine&&(s=!0),o.collapsed&&c!=e.line&&Xt(r,0),function(t,e,n){var r=n&&window.WeakSet&&(n.markedSpans||(n.markedSpans=new WeakSet));r&&r.has(t.markedSpans)?t.markedSpans.push(e):(t.markedSpans=t.markedSpans?t.markedSpans.concat([e]):[e],r&&r.add(t.markedSpans)),e.marker.attachLine(t)}(r,new ke(o,c==e.line?e.ch:null,c==n.line?n.ch:null),t.cm&&t.cm.curOp),++c})),o.collapsed&&t.iter(e.line,n.line+1,(function(e){Be(t,e)&&Xt(e,0)})),o.clearOnEnter&&ht(o,"beforeCursorEnter",(function(){return o.clear()})),o.readOnly&&(xe=!0,(t.history.done.length||t.history.undone.length)&&t.clearHistory()),o.collapsed&&(o.id=++So,o.atomic=!0),l){if(s&&(l.curOp.updateMaxLine=!0),o.collapsed)hr(l,e.line,n.line+1);else if(o.className||o.startStyle||o.endStyle||o.css||o.attributes||o.title)for(var u=e.line;u<=n.line;u++)fr(l,u,"text");o.atomic&&ro(l.doc),ln(l,"markerAdded",l,o)}return o}jo.prototype.clear=function(){if(!this.explicitlyCleared){var t=this.doc.cm,e=t&&!t.curOp;if(e&&Gr(t),yt(this,"clear")){var n=this.find();n&&ln(this,"clear",n.from,n.to)}for(var r=null,i=null,o=0;o<this.lines.length;++o){var a=this.lines[o],s=Se(a.markedSpans,this);t&&!this.collapsed?fr(t,Jt(a),"text"):t&&(null!=s.to&&(i=Jt(a)),null!=s.from&&(r=Jt(a))),a.markedSpans=je(a.markedSpans,s),null==s.from&&this.collapsed&&!Be(this.doc,a)&&t&&Xt(a,ir(t.display))}if(t&&this.collapsed&&!t.options.lineWrapping)for(var c=0;c<this.lines.length;++c){var l=Ve(this.lines[c]),u=We(l);u>t.display.maxLineLength&&(t.display.maxLine=l,t.display.maxLineLength=u,t.display.maxLineChanged=!0)}null!=r&&t&&this.collapsed&&hr(t,r,i+1),this.lines.length=0,this.explicitlyCleared=!0,this.atomic&&this.doc.cantEdit&&(this.doc.cantEdit=!1,t&&ro(t.doc)),t&&ln(t,"markerCleared",t,this,r,i),e&&Kr(t),this.parent&&this.parent.clear()}},jo.prototype.find=function(t,e){var n,r;null==t&&"bookmark"==this.type&&(t=1);for(var i=0;i<this.lines.length;++i){var o=this.lines[i],a=Se(o.markedSpans,this);if(null!=a.from&&(n=ee(e?o:Jt(o),a.from),-1==t))return n;if(null!=a.to&&(r=ee(e?o:Jt(o),a.to),1==t))return r}return n&&{from:n,to:r}},jo.prototype.changed=function(){var t=this,e=this.find(-1,!0),n=this,r=this.doc.cm;e&&r&&ti(r,(function(){var i=e.line,o=Jt(e.line),a=Dn(r,o);if(a&&(Vn(a),r.curOp.selectionChanged=r.curOp.forceUpdate=!0),r.curOp.updateMaxLine=!0,!Be(n.doc,i)&&null!=n.height){var s=n.height;n.height=null;var c=xn(n)-s;c&&Xt(i,i.height+c)}ln(r,"markerChanged",r,t)}))},jo.prototype.attachLine=function(t){if(!this.lines.length&&this.doc.cm){var e=this.doc.cm.curOp;e.maybeHiddenMarkers&&-1!=z(e.maybeHiddenMarkers,this)||(e.maybeUnhiddenMarkers||(e.maybeUnhiddenMarkers=[])).push(this)}this.lines.push(t)},jo.prototype.detachLine=function(t){if(this.lines.splice(z(this.lines,t),1),!this.lines.length&&this.doc.cm){var e=this.doc.cm.curOp;(e.maybeHiddenMarkers||(e.maybeHiddenMarkers=[])).push(this)}},bt(jo);var Po=function(t,e){this.markers=t,this.primary=e;for(var n=0;n<t.length;++n)t[n].parent=this};function Eo(t){return t.findMarks(ee(t.first,0),t.clipPos(ee(t.lastLine())),(function(t){return t.parent}))}function _o(t){for(var e=function(e){var n=t[e],r=[n.primary.doc];Ni(n.primary.doc,(function(t){return r.push(t)}));for(var i=0;i<n.markers.length;i++){var o=n.markers[i];-1==z(r,o.doc)&&(o.parent=null,n.markers.splice(i--,1))}},n=0;n<t.length;n++)e(n)}Po.prototype.clear=function(){if(!this.explicitlyCleared){this.explicitlyCleared=!0;for(var t=0;t<this.markers.length;++t)this.markers[t].clear();ln(this,"clear")}},Po.prototype.find=function(t,e){return this.primary.find(t,e)},bt(Po);var Mo=0,Do=function(t,e,n,r,i){if(!(this instanceof Do))return new Do(t,e,n,r,i);null==n&&(n=0),xo.call(this,[new Oo([new Ge("",null)])]),this.first=n,this.scrollTop=this.scrollLeft=0,this.cantEdit=!1,this.cleanGeneration=1,this.modeFrontier=this.highlightFrontier=n;var o=ee(n,0);this.sel=ji(o),this.history=new Fi(null),this.id=++Mo,this.modeOption=e,this.lineSep=r,this.direction="rtl"==i?"rtl":"ltr",this.extend=!1,"string"==typeof t&&(t=this.splitLines(t)),Li(this,{from:o,to:o,text:t}),to(this,ji(o),U)};Do.prototype=Z(xo.prototype,{constructor:Do,iter:function(t,e,n){n?this.iterN(t-this.first,e-t,n):this.iterN(this.first,this.first+this.size,t)},insert:function(t,e){for(var n=0,r=0;r<e.length;++r)n+=e[r].height;this.insertInner(t-this.first,e,n)},remove:function(t,e){this.removeInner(t-this.first,e)},getValue:function(t){var e=Yt(this,this.first,this.first+this.size);return!1===t?e:e.join(t||this.lineSeparator())},setValue:ri((function(t){var e=ee(this.first,0),n=this.first+this.size-1;uo(this,{from:e,to:ee(n,Gt(this,n).text.length),text:this.splitLines(t),origin:"setValue",full:!0},!0),this.cm&&Ar(this.cm,0,0),to(this,ji(e),U)})),replaceRange:function(t,e,n,r){vo(this,t,e=ce(this,e),n=n?ce(this,n):e,r)},getRange:function(t,e,n){var r=Kt(this,ce(this,t),ce(this,e));return!1===n?r:''===n?r.join(''):r.join(n||this.lineSeparator())},getLine:function(t){var e=this.getLineHandle(t);return e&&e.text},getLineHandle:function(t){if(Qt(this,t))return Gt(this,t)},getLineNumber:function(t){return Jt(t)},getLineHandleVisualStart:function(t){return"number"==typeof t&&(t=Gt(this,t)),Ve(t)},lineCount:function(){return this.size},firstLine:function(){return this.first},lastLine:function(){return this.first+this.size-1},clipPos:function(t){return ce(this,t)},getCursor:function(t){var e=this.sel.primary();return null==t||"head"==t?e.head:"anchor"==t?e.anchor:"end"==t||"to"==t||!1===t?e.to():e.from()},listSelections:function(){return this.sel.ranges},somethingSelected:function(){return this.sel.somethingSelected()},setCursor:ri((function(t,e,n){Zi(this,ce(this,"number"==typeof t?ee(t,e||0):t),null,n)})),setSelection:ri((function(t,e,n){Zi(this,ce(this,t),ce(this,e||t),n)})),extendSelection:ri((function(t,e,n){Yi(this,ce(this,t),e&&ce(this,e),n)})),extendSelections:ri((function(t,e){Xi(this,le(this,t),e)})),extendSelectionsBy:ri((function(t,e){Xi(this,le(this,X(this.sel.ranges,t)),e)})),setSelections:ri((function(t,e,n){if(t.length){for(var r=[],i=0;i<t.length;i++)r[i]=new ki(ce(this,t[i].anchor),ce(this,t[i].head||t[i].anchor));null==e&&(e=Math.min(t.length-1,this.sel.primIndex)),to(this,Si(this.cm,r,e),n)}})),addSelection:ri((function(t,e,n){var r=this.sel.ranges.slice(0);r.push(new ki(ce(this,t),ce(this,e||t))),to(this,Si(this.cm,r,r.length-1),n)})),getSelection:function(t){for(var e,n=this.sel.ranges,r=0;r<n.length;r++){var i=Kt(this,n[r].from(),n[r].to());e=e?e.concat(i):i}return!1===t?e:e.join(t||this.lineSeparator())},getSelections:function(t){for(var e=[],n=this.sel.ranges,r=0;r<n.length;r++){var i=Kt(this,n[r].from(),n[r].to());!1!==t&&(i=i.join(t||this.lineSeparator())),e[r]=i}return e},replaceSelection:function(t,e,n){for(var r=[],i=0;i<this.sel.ranges.length;i++)r[i]=t;this.replaceSelections(r,e,n||"+input")},replaceSelections:ri((function(t,e,n){for(var r=[],i=this.sel,o=0;o<i.ranges.length;o++){var a=i.ranges[o];r[o]={from:a.from(),to:a.to(),text:this.splitLines(t[o]),origin:n}}for(var s=e&&"end"!=e&&function(t,e,n){for(var r=[],i=ee(t.first,0),o=i,a=0;a<e.length;a++){var s=e[a],c=_i(s.from,i,o),l=_i(Ti(s),i,o);if(i=s.to,o=l,"around"==n){var u=t.sel.ranges[a],d=ne(u.head,u.anchor)<0;r[a]=new ki(d?l:c,d?c:l)}else r[a]=new ki(c,c)}return new Ci(r,t.sel.primIndex)}(this,r,e),c=r.length-1;c>=0;c--)uo(this,r[c]);s?Qi(this,s):this.cm&&Dr(this.cm)})),undo:ri((function(){fo(this,"undo")})),redo:ri((function(){fo(this,"redo")})),undoSelection:ri((function(){fo(this,"undo",!0)})),redoSelection:ri((function(){fo(this,"redo",!0)})),setExtending:function(t){this.extend=t},getExtending:function(){return this.extend},historySize:function(){for(var t=this.history,e=0,n=0,r=0;r<t.done.length;r++)t.done[r].ranges||++e;for(var i=0;i<t.undone.length;i++)t.undone[i].ranges||++n;return{undo:e,redo:n}},clearHistory:function(){var t=this;this.history=new Fi(this.history),Ni(this,(function(e){return e.history=t.history}),!0)},markClean:function(){this.cleanGeneration=this.changeGeneration(!0)},changeGeneration:function(t){return t&&(this.history.lastOp=this.history.lastSelOp=this.history.lastOrigin=null),this.history.generation},isClean:function(t){return this.history.generation==(t||this.cleanGeneration)},getHistory:function(){return{done:Gi(this.history.done),undone:Gi(this.history.undone)}},setHistory:function(t){var e=this.history=new Fi(this.history);e.done=Gi(t.done.slice(0),null,!0),e.undone=Gi(t.undone.slice(0),null,!0)},setGutterMarker:ri((function(t,e,n){return wo(this,t,"gutter",(function(t){var r=t.gutterMarkers||(t.gutterMarkers={});return r[e]=n,!n&&nt(r)&&(t.gutterMarkers=null),!0}))})),clearGutter:ri((function(t){var e=this;this.iter((function(n){n.gutterMarkers&&n.gutterMarkers[t]&&wo(e,n,"gutter",(function(){return n.gutterMarkers[t]=null,nt(n.gutterMarkers)&&(n.gutterMarkers=null),!0}))}))})),lineInfo:function(t){var e;if("number"==typeof t){if(!Qt(this,t))return null;if(e=t,!(t=Gt(this,t)))return null}else if(null==(e=Jt(t)))return null;return{line:e,handle:t,text:t.text,gutterMarkers:t.gutterMarkers,textClass:t.textClass,bgClass:t.bgClass,wrapClass:t.wrapClass,widgets:t.widgets}},addLineClass:ri((function(t,e,n){return wo(this,t,"gutter"==e?"gutter":"class",(function(t){var r="text"==e?"textClass":"background"==e?"bgClass":"gutter"==e?"gutterClass":"wrapClass";if(t[r]){if(k(n).test(t[r]))return!1;t[r]+=" "+n}else t[r]=n;return!0}))})),removeLineClass:ri((function(t,e,n){return wo(this,t,"gutter"==e?"gutter":"class",(function(t){var r="text"==e?"textClass":"background"==e?"bgClass":"gutter"==e?"gutterClass":"wrapClass",i=t[r];if(!i)return!1;if(null==n)t[r]=null;else{var o=i.match(k(n));if(!o)return!1;var a=o.index+o[0].length;t[r]=i.slice(0,o.index)+(o.index&&a!=i.length?" ":"")+i.slice(a)||null}return!0}))})),addLineWidget:ri((function(t,e,n){return function(t,e,n,r){var i=new Co(t,n,r),o=t.cm;return o&&i.noHScroll&&(o.display.alignWidgets=!0),wo(t,e,"widget",(function(e){var n=e.widgets||(e.widgets=[]);if(null==i.insertAt?n.push(i):n.splice(Math.min(n.length,Math.max(0,i.insertAt)),0,i),i.line=e,o&&!Be(t,e)){var r=$e(e)<t.scrollTop;Xt(e,e.height+xn(i)),r&&Mr(o,i.height),o.curOp.forceUpdate=!0}return!0})),o&&ln(o,"lineWidgetAdded",o,i,"number"==typeof e?e:Jt(e)),i}(this,t,e,n)})),removeLineWidget:function(t){t.clear()},markText:function(t,e,n){return To(this,ce(this,t),ce(this,e),n,n&&n.type||"range")},setBookmark:function(t,e){var n={replacedWith:e&&(null==e.nodeType?e.widget:e),insertLeft:e&&e.insertLeft,clearWhenEmpty:!1,shared:e&&e.shared,handleMouseEvents:e&&e.handleMouseEvents};return To(this,t=ce(this,t),t,n,"bookmark")},findMarksAt:function(t){var e=[],n=Gt(this,(t=ce(this,t)).line).markedSpans;if(n)for(var r=0;r<n.length;++r){var i=n[r];(null==i.from||i.from<=t.ch)&&(null==i.to||i.to>=t.ch)&&e.push(i.marker.parent||i.marker)}return e},findMarks:function(t,e,n){t=ce(this,t),e=ce(this,e);var r=[],i=t.line;return this.iter(t.line,e.line+1,(function(o){var a=o.markedSpans;if(a)for(var s=0;s<a.length;s++){var c=a[s];null!=c.to&&i==t.line&&t.ch>=c.to||null==c.from&&i!=t.line||null!=c.from&&i==e.line&&c.from>=e.ch||n&&!n(c.marker)||r.push(c.marker.parent||c.marker)}++i})),r},getAllMarks:function(){var t=[];return this.iter((function(e){var n=e.markedSpans;if(n)for(var r=0;r<n.length;++r)null!=n[r].from&&t.push(n[r].marker)})),t},posFromIndex:function(t){var e,n=this.first,r=this.lineSeparator().length;return this.iter((function(i){var o=i.text.length+r;if(o>t)return e=t,!0;t-=o,++n})),ce(this,ee(n,e))},indexFromPos:function(t){var e=(t=ce(this,t)).ch;if(t.line<this.first||t.ch<0)return 0;var n=this.lineSeparator().length;return this.iter(this.first,t.line,(function(t){e+=t.text.length+n})),e},copy:function(t){var e=new Do(Yt(this,this.first,this.first+this.size),this.modeOption,this.first,this.lineSep,this.direction);return e.scrollTop=this.scrollTop,e.scrollLeft=this.scrollLeft,e.sel=this.sel,e.extend=!1,t&&(e.history.undoDepth=this.history.undoDepth,e.setHistory(this.getHistory())),e},linkedDoc:function(t){t||(t={});var e=this.first,n=this.first+this.size;null!=t.from&&t.from>e&&(e=t.from),null!=t.to&&t.to<n&&(n=t.to);var r=new Do(Yt(this,e,n),t.mode||this.modeOption,e,this.lineSep,this.direction);return t.sharedHist&&(r.history=this.history),(this.linked||(this.linked=[])).push({doc:r,sharedHist:t.sharedHist}),r.linked=[{doc:this,isParent:!0,sharedHist:t.sharedHist}],function(t,e){for(var n=0;n<e.length;n++){var r=e[n],i=r.find(),o=t.clipPos(i.from),a=t.clipPos(i.to);if(ne(o,a)){var s=To(t,o,a,r.primary,r.primary.type);r.markers.push(s),s.parent=r}}}(r,Eo(this)),r},unlinkDoc:function(t){if(t instanceof Ea&&(t=t.doc),this.linked)for(var e=0;e<this.linked.length;++e)if(this.linked[e].doc==t){this.linked.splice(e,1),t.unlinkDoc(this),_o(Eo(this));break}if(t.history==this.history){var n=[t.id];Ni(t,(function(t){return n.push(t.id)}),!0),t.history=new Fi(null),t.history.done=Gi(this.history.done,n),t.history.undone=Gi(this.history.undone,n)}},iterLinkedDocs:function(t){Ni(this,t)},getMode:function(){return this.mode},getEditor:function(){return this.cm},splitLines:function(t){return this.lineSep?t.split(this.lineSep):Dt(t)},lineSeparator:function(){return this.lineSep||"\n"},setDirection:ri((function(t){var e;"rtl"!=t&&(t="ltr"),t!=this.direction&&(this.direction=t,this.iter((function(t){return t.order=null})),this.cm&&ti(e=this.cm,(function(){Ii(e),hr(e)})))}))}),Do.prototype.eachLine=Do.prototype.iter;var Ao=0;function Lo(t){var e=this;if(No(e),!vt(e,t)&&!Cn(e.display,t)){wt(t),a&&(Ao=+new Date);var n=ur(e,t,!0),r=t.dataTransfer.files;if(n&&!e.isReadOnly())if(r&&r.length&&window.FileReader&&window.File)for(var i=r.length,o=Array(i),s=0,c=function(){++s==i&&ei(e,(function(){var t={from:n=ce(e.doc,n),to:n,text:e.doc.splitLines(o.filter((function(t){return null!=t})).join(e.doc.lineSeparator())),origin:"paste"};uo(e.doc,t),Qi(e.doc,ji(ce(e.doc,n),ce(e.doc,Ti(t))))}))()},l=function(t,n){if(e.options.allowDropFileTypes&&-1==z(e.options.allowDropFileTypes,t.type))c();else{var r=new FileReader;r.onerror=function(){return c()},r.onload=function(){var t=r.result;/[\x00-\x08\x0e-\x1f]{2}/.test(t)||(o[n]=t),c()},r.readAsText(t)}},u=0;u<r.length;u++)l(r[u],u);else{if(e.state.draggingText&&e.doc.sel.contains(n)>-1)return e.state.draggingText(t),void setTimeout((function(){return e.display.input.focus()}),20);try{var d=t.dataTransfer.getData("Text");if(d){var h;if(e.state.draggingText&&!e.state.draggingText.copy&&(h=e.listSelections()),eo(e.doc,ji(n,n)),h)for(var f=0;f<h.length;++f)vo(e.doc,"",h[f].anchor,h[f].head,"drag");e.replaceSelection(d,"around","paste"),e.display.input.focus()}}catch(t){}}}}function No(t){t.display.dragCursor&&(t.display.lineSpace.removeChild(t.display.dragCursor),t.display.dragCursor=null)}function Ro(t){if(document.getElementsByClassName){for(var e=document.getElementsByClassName("CodeMirror"),n=[],r=0;r<e.length;r++){var i=e[r].CodeMirror;i&&n.push(i)}n.length&&n[0].operation((function(){for(var e=0;e<n.length;e++)t(n[e])}))}}var Io=!1;function Fo(){var t;Io||(ht(window,"resize",(function(){null==t&&(t=setTimeout((function(){t=null,Ro(Vo)}),100))})),ht(window,"blur",(function(){return Ro(jr)})),Io=!0)}function Vo(t){var e=t.display;e.cachedCharWidth=e.cachedTextHeight=e.cachedPaddingH=null,e.scrollbarsClipped=!1,t.setSize()}for(var zo={3:"Pause",8:"Backspace",9:"Tab",13:"Enter",16:"Shift",17:"Ctrl",18:"Alt",19:"Pause",20:"CapsLock",27:"Esc",32:"Space",33:"PageUp",34:"PageDown",35:"End",36:"Home",37:"Left",38:"Up",39:"Right",40:"Down",44:"PrintScrn",45:"Insert",46:"Delete",59:";",61:"=",91:"Mod",92:"Mod",93:"Mod",106:"*",107:"=",109:"-",110:".",111:"/",145:"ScrollLock",173:"-",186:";",187:"=",188:",",189:"-",190:".",191:"/",192:"`",219:"[",220:"\\",221:"]",222:"'",224:"Mod",63232:"Up",63233:"Down",63234:"Left",63235:"Right",63272:"Delete",63273:"Home",63275:"End",63276:"PageUp",63277:"PageDown",63302:"Insert"},Ho=0;Ho<10;Ho++)zo[Ho+48]=zo[Ho+96]=String(Ho);for(var Bo=65;Bo<=90;Bo++)zo[Bo]=String.fromCharCode(Bo);for(var Uo=1;Uo<=12;Uo++)zo[Uo+111]=zo[Uo+63235]="F"+Uo;var $o={};function Wo(t){var e,n,r,i,o=t.split(/-(?!$)/);t=o[o.length-1];for(var a=0;a<o.length-1;a++){var s=o[a];if(/^(cmd|meta|m)$/i.test(s))i=!0;else if(/^a(lt)?$/i.test(s))e=!0;else if(/^(c|ctrl|control)$/i.test(s))n=!0;else{if(!/^s(hift)?$/i.test(s))throw new Error("Unrecognized modifier name: "+s);r=!0}}return e&&(t="Alt-"+t),n&&(t="Ctrl-"+t),i&&(t="Cmd-"+t),r&&(t="Shift-"+t),t}function qo(t){var e={};for(var n in t)if(t.hasOwnProperty(n)){var r=t[n];if(/^(name|fallthrough|(de|at)tach)$/.test(n))continue;if("..."==r){delete t[n];continue}for(var i=X(n.split(" "),Wo),o=0;o<i.length;o++){var a=void 0,s=void 0;o==i.length-1?(s=i.join(" "),a=r):(s=i.slice(0,o+1).join(" "),a="...");var c=e[s];if(c){if(c!=a)throw new Error("Inconsistent bindings for "+s)}else e[s]=a}delete t[n]}for(var l in e)t[l]=e[l];return t}function Go(t,e,n,r){var i=(e=Jo(e)).call?e.call(t,r):e[t];if(!1===i)return"nothing";if("..."===i)return"multi";if(null!=i&&n(i))return"handled";if(e.fallthrough){if("[object Array]"!=Object.prototype.toString.call(e.fallthrough))return Go(t,e.fallthrough,n,r);for(var o=0;o<e.fallthrough.length;o++){var a=Go(t,e.fallthrough[o],n,r);if(a)return a}}}function Ko(t){var e="string"==typeof t?t:zo[t.keyCode];return"Ctrl"==e||"Alt"==e||"Shift"==e||"Mod"==e}function Yo(t,e,n){var r=t;return e.altKey&&"Alt"!=r&&(t="Alt-"+t),(x?e.metaKey:e.ctrlKey)&&"Ctrl"!=r&&(t="Ctrl-"+t),(x?e.ctrlKey:e.metaKey)&&"Mod"!=r&&(t="Cmd-"+t),!n&&e.shiftKey&&"Shift"!=r&&(t="Shift-"+t),t}function Xo(t,e){if(d&&34==t.keyCode&&t["char"])return!1;var n=zo[t.keyCode];return null!=n&&!t.altGraphKey&&(3==t.keyCode&&t.code&&(n=t.code),Yo(n,t,e))}function Jo(t){return"string"==typeof t?$o[t]:t}function Zo(t,e){for(var n=t.doc.sel.ranges,r=[],i=0;i<n.length;i++){for(var o=e(n[i]);r.length&&ne(o.from,Y(r).to)<=0;){var a=r.pop();if(ne(a.from,o.from)<0){o.from=a.from;break}}r.push(o)}ti(t,(function(){for(var e=r.length-1;e>=0;e--)vo(t.doc,"",r[e].from,r[e].to,"+delete");Dr(t)}))}function Qo(t,e,n){var r=ot(t.text,e+n,n);return r<0||r>t.text.length?null:r}function ta(t,e,n){var r=Qo(t,e.ch,n);return null==r?null:new ee(e.line,r,n<0?"after":"before")}function ea(t,e,n,r,i){if(t){"rtl"==e.doc.direction&&(i=-i);var o=ut(n,e.doc.direction);if(o){var a,s=i<0?Y(o):o[0],c=i<0==(1==s.level)?"after":"before";if(s.level>0||"rtl"==e.doc.direction){var l=An(e,n);a=i<0?n.text.length-1:0;var u=Ln(e,l,a).top;a=at((function(t){return Ln(e,l,t).top==u}),i<0==(1==s.level)?s.from:s.to-1,a),"before"==c&&(a=Qo(n,a,1))}else a=i<0?s.to:s.from;return new ee(r,a,c)}}return new ee(r,i<0?n.text.length:0,i<0?"before":"after")}$o.basic={Left:"goCharLeft",Right:"goCharRight",Up:"goLineUp",Down:"goLineDown",End:"goLineEnd",Home:"goLineStartSmart",PageUp:"goPageUp",PageDown:"goPageDown",Delete:"delCharAfter",Backspace:"delCharBefore","Shift-Backspace":"delCharBefore",Tab:"defaultTab","Shift-Tab":"indentAuto",Enter:"newlineAndIndent",Insert:"toggleOverwrite",Esc:"singleSelection"},$o.pcDefault={"Ctrl-A":"selectAll","Ctrl-D":"deleteLine","Ctrl-Z":"undo","Shift-Ctrl-Z":"redo","Ctrl-Y":"redo","Ctrl-Home":"goDocStart","Ctrl-End":"goDocEnd","Ctrl-Up":"goLineUp","Ctrl-Down":"goLineDown","Ctrl-Left":"goGroupLeft","Ctrl-Right":"goGroupRight","Alt-Left":"goLineStart","Alt-Right":"goLineEnd","Ctrl-Backspace":"delGroupBefore","Ctrl-Delete":"delGroupAfter","Ctrl-S":"save","Ctrl-F":"find","Ctrl-G":"findNext","Shift-Ctrl-G":"findPrev","Shift-Ctrl-F":"replace","Shift-Ctrl-R":"replaceAll","Ctrl-[":"indentLess","Ctrl-]":"indentMore","Ctrl-U":"undoSelection","Shift-Ctrl-U":"redoSelection","Alt-U":"redoSelection",fallthrough:"basic"},$o.emacsy={"Ctrl-F":"goCharRight","Ctrl-B":"goCharLeft","Ctrl-P":"goLineUp","Ctrl-N":"goLineDown","Ctrl-A":"goLineStart","Ctrl-E":"goLineEnd","Ctrl-V":"goPageDown","Shift-Ctrl-V":"goPageUp","Ctrl-D":"delCharAfter","Ctrl-H":"delCharBefore","Alt-Backspace":"delWordBefore","Ctrl-K":"killLine","Ctrl-T":"transposeChars","Ctrl-O":"openLine"},$o.macDefault={"Cmd-A":"selectAll","Cmd-D":"deleteLine","Cmd-Z":"undo","Shift-Cmd-Z":"redo","Cmd-Y":"redo","Cmd-Home":"goDocStart","Cmd-Up":"goDocStart","Cmd-End":"goDocEnd","Cmd-Down":"goDocEnd","Alt-Left":"goGroupLeft","Alt-Right":"goGroupRight","Cmd-Left":"goLineLeft","Cmd-Right":"goLineRight","Alt-Backspace":"delGroupBefore","Ctrl-Alt-Backspace":"delGroupAfter","Alt-Delete":"delGroupAfter","Cmd-S":"save","Cmd-F":"find","Cmd-G":"findNext","Shift-Cmd-G":"findPrev","Cmd-Alt-F":"replace","Shift-Cmd-Alt-F":"replaceAll","Cmd-[":"indentLess","Cmd-]":"indentMore","Cmd-Backspace":"delWrappedLineLeft","Cmd-Delete":"delWrappedLineRight","Cmd-U":"undoSelection","Shift-Cmd-U":"redoSelection","Ctrl-Up":"goDocStart","Ctrl-Down":"goDocEnd",fallthrough:["basic","emacsy"]},$o["default"]=y?$o.macDefault:$o.pcDefault;var na={selectAll:co,singleSelection:function(t){return t.setSelection(t.getCursor("anchor"),t.getCursor("head"),U)},killLine:function(t){return Zo(t,(function(e){if(e.empty()){var n=Gt(t.doc,e.head.line).text.length;return e.head.ch==n&&e.head.line<t.lastLine()?{from:e.head,to:ee(e.head.line+1,0)}:{from:e.head,to:ee(e.head.line,n)}}return{from:e.from(),to:e.to()}}))},deleteLine:function(t){return Zo(t,(function(e){return{from:ee(e.from().line,0),to:ce(t.doc,ee(e.to().line+1,0))}}))},delLineLeft:function(t){return Zo(t,(function(t){return{from:ee(t.from().line,0),to:t.from()}}))},delWrappedLineLeft:function(t){return Zo(t,(function(e){var n=t.charCoords(e.head,"div").top+5;return{from:t.coordsChar({left:0,top:n},"div"),to:e.from()}}))},delWrappedLineRight:function(t){return Zo(t,(function(e){var n=t.charCoords(e.head,"div").top+5,r=t.coordsChar({left:t.display.lineDiv.offsetWidth+100,top:n},"div");return{from:e.from(),to:r}}))},undo:function(t){return t.undo()},redo:function(t){return t.redo()},undoSelection:function(t){return t.undoSelection()},redoSelection:function(t){return t.redoSelection()},goDocStart:function(t){return t.extendSelection(ee(t.firstLine(),0))},goDocEnd:function(t){return t.extendSelection(ee(t.lastLine()))},goLineStart:function(t){return t.extendSelectionsBy((function(e){return ra(t,e.head.line)}),{origin:"+move",bias:1})},goLineStartSmart:function(t){return t.extendSelectionsBy((function(e){return ia(t,e.head)}),{origin:"+move",bias:1})},goLineEnd:function(t){return t.extendSelectionsBy((function(e){return function(t,e){var n=Gt(t.doc,e),r=function(t){for(var e;e=Re(t);)t=e.find(1,!0).line;return t}(n);return r!=n&&(e=Jt(r)),ea(!0,t,n,e,-1)}(t,e.head.line)}),{origin:"+move",bias:-1})},goLineRight:function(t){return t.extendSelectionsBy((function(e){var n=t.cursorCoords(e.head,"div").top+5;return t.coordsChar({left:t.display.lineDiv.offsetWidth+100,top:n},"div")}),W)},goLineLeft:function(t){return t.extendSelectionsBy((function(e){var n=t.cursorCoords(e.head,"div").top+5;return t.coordsChar({left:0,top:n},"div")}),W)},goLineLeftSmart:function(t){return t.extendSelectionsBy((function(e){var n=t.cursorCoords(e.head,"div").top+5,r=t.coordsChar({left:0,top:n},"div");return r.ch<t.getLine(r.line).search(/\S/)?ia(t,e.head):r}),W)},goLineUp:function(t){return t.moveV(-1,"line")},goLineDown:function(t){return t.moveV(1,"line")},goPageUp:function(t){return t.moveV(-1,"page")},goPageDown:function(t){return t.moveV(1,"page")},goCharLeft:function(t){return t.moveH(-1,"char")},goCharRight:function(t){return t.moveH(1,"char")},goColumnLeft:function(t){return t.moveH(-1,"column")},goColumnRight:function(t){return t.moveH(1,"column")},goWordLeft:function(t){return t.moveH(-1,"word")},goGroupRight:function(t){return t.moveH(1,"group")},goGroupLeft:function(t){return t.moveH(-1,"group")},goWordRight:function(t){return t.moveH(1,"word")},delCharBefore:function(t){return t.deleteH(-1,"codepoint")},delCharAfter:function(t){return t.deleteH(1,"char")},delWordBefore:function(t){return t.deleteH(-1,"word")},delWordAfter:function(t){return t.deleteH(1,"word")},delGroupBefore:function(t){return t.deleteH(-1,"group")},delGroupAfter:function(t){return t.deleteH(1,"group")},indentAuto:function(t){return t.indentSelection("smart")},indentMore:function(t){return t.indentSelection("add")},indentLess:function(t){return t.indentSelection("subtract")},insertTab:function(t){return t.replaceSelection("\t")},insertSoftTab:function(t){for(var e=[],n=t.listSelections(),r=t.options.tabSize,i=0;i<n.length;i++){var o=n[i].from(),a=F(t.getLine(o.line),o.ch,r);e.push(K(r-a%r))}t.replaceSelections(e)},defaultTab:function(t){t.somethingSelected()?t.indentSelection("add"):t.execCommand("insertTab")},transposeChars:function(t){return ti(t,(function(){for(var e=t.listSelections(),n=[],r=0;r<e.length;r++)if(e[r].empty()){var i=e[r].head,o=Gt(t.doc,i.line).text;if(o)if(i.ch==o.length&&(i=new ee(i.line,i.ch-1)),i.ch>0)i=new ee(i.line,i.ch+1),t.replaceRange(o.charAt(i.ch-1)+o.charAt(i.ch-2),ee(i.line,i.ch-2),i,"+transpose");else if(i.line>t.doc.first){var a=Gt(t.doc,i.line-1).text;a&&(i=new ee(i.line,1),t.replaceRange(o.charAt(0)+t.doc.lineSeparator()+a.charAt(a.length-1),ee(i.line-1,a.length-1),i,"+transpose"))}n.push(new ki(i,i))}t.setSelections(n)}))},newlineAndIndent:function(t){return ti(t,(function(){for(var e=t.listSelections(),n=e.length-1;n>=0;n--)t.replaceRange(t.doc.lineSeparator(),e[n].anchor,e[n].head,"+input");e=t.listSelections();for(var r=0;r<e.length;r++)t.indentLine(e[r].from().line,null,!0);Dr(t)}))},openLine:function(t){return t.replaceSelection("\n","start")},toggleOverwrite:function(t){return t.toggleOverwrite()}};function ra(t,e){var n=Gt(t.doc,e),r=Ve(n);return r!=n&&(e=Jt(r)),ea(!0,t,r,e,1)}function ia(t,e){var n=ra(t,e.line),r=Gt(t.doc,n.line),i=ut(r,t.doc.direction);if(!i||0==i[0].level){var o=Math.max(n.ch,r.text.search(/\S/)),a=e.line==n.line&&e.ch<=o&&e.ch;return ee(n.line,a?0:o,n.sticky)}return n}function oa(t,e,n){if("string"==typeof e&&!(e=na[e]))return!1;t.display.input.ensurePolled();var r=t.display.shift,i=!1;try{t.isReadOnly()&&(t.state.suppressEdits=!0),n&&(t.display.shift=!1),i=e(t)!=B}finally{t.display.shift=r,t.state.suppressEdits=!1}return i}var aa=new V;function sa(t,e,n,r){var i=t.state.keySeq;if(i){if(Ko(e))return"handled";if(/\'$/.test(e)?t.state.keySeq=null:aa.set(50,(function(){t.state.keySeq==i&&(t.state.keySeq=null,t.display.input.reset())})),ca(t,i+" "+e,n,r))return!0}return ca(t,e,n,r)}function ca(t,e,n,r){var i=function(t,e,n){for(var r=0;r<t.state.keyMaps.length;r++){var i=Go(e,t.state.keyMaps[r],n,t);if(i)return i}return t.options.extraKeys&&Go(e,t.options.extraKeys,n,t)||Go(e,t.options.keyMap,n,t)}(t,e,r);return"multi"==i&&(t.state.keySeq=e),"handled"==i&&ln(t,"keyHandled",t,e,n),"handled"!=i&&"multi"!=i||(wt(n),xr(t)),!!i}function la(t,e){var n=Xo(e,!0);return!!n&&(e.shiftKey&&!t.state.keySeq?sa(t,"Shift-"+n,e,(function(e){return oa(t,e,!0)}))||sa(t,n,e,(function(e){if("string"==typeof e?/^go[A-Z]/.test(e):e.motion)return oa(t,e)})):sa(t,n,e,(function(e){return oa(t,e)})))}var ua=null;function da(t){var e=this;if(!(t.target&&t.target!=e.display.input.getField()||(e.curOp.focus=D(),vt(e,t)))){a&&s<11&&27==t.keyCode&&(t.returnValue=!1);var r=t.keyCode;e.display.shift=16==r||t.shiftKey;var i=la(e,t);d&&(ua=i?r:null,i||88!=r||Lt||!(y?t.metaKey:t.ctrlKey)||e.replaceSelection("",null,"cut")),n&&!y&&!i&&46==r&&t.shiftKey&&!t.ctrlKey&&document.execCommand&&document.execCommand("cut"),18!=r||/\bCodeMirror-crosshair\b/.test(e.display.lineDiv.className)||function(t){var e=t.display.lineDiv;function n(t){18!=t.keyCode&&t.altKey||(j(e,"CodeMirror-crosshair"),pt(document,"keyup",n),pt(document,"mouseover",n))}A(e,"CodeMirror-crosshair"),ht(document,"keyup",n),ht(document,"mouseover",n)}(e)}}function ha(t){16==t.keyCode&&(this.doc.sel.shift=!1),vt(this,t)}function fa(t){var e=this;if(!(t.target&&t.target!=e.display.input.getField()||Cn(e.display,t)||vt(e,t)||t.ctrlKey&&!t.altKey||y&&t.metaKey)){var n=t.keyCode,r=t.charCode;if(d&&n==ua)return ua=null,void wt(t);if(!d||t.which&&!(t.which<10)||!la(e,t)){var i=String.fromCharCode(null==r?n:r);"\b"!=i&&(function(t,e,n){return sa(t,"'"+n+"'",e,(function(e){return oa(t,e,!0)}))}(e,t,i)||e.display.input.onKeyPress(t))}}}var pa,ga,va=400,ma=function(t,e,n){this.time=t,this.pos=e,this.button=n};function ya(t){var e=this,n=e.display;if(!(vt(e,t)||n.activeTouch&&n.input.supportsTouch()))if(n.input.ensurePolled(),n.shift=t.shiftKey,Cn(n,t))c||(n.scroller.draggable=!1,setTimeout((function(){return n.scroller.draggable=!0}),100));else if(!Oa(e,t)){var r=ur(e,t),i=St(t),o=r?function(t,e){var n=+new Date;return ga&&ga.compare(n,t,e)?(pa=ga=null,"triple"):pa&&pa.compare(n,t,e)?(ga=new ma(n,t,e),pa=null,"double"):(pa=new ma(n,t,e),ga=null,"single")}(r,i):"single";window.focus(),1==i&&e.state.selectingText&&e.state.selectingText(t),r&&function(t,e,n,r,i){var o="Click";return"double"==r?o="Double"+o:"triple"==r&&(o="Triple"+o),sa(t,Yo(o=(1==e?"Left":2==e?"Middle":"Right")+o,i),i,(function(e){if("string"==typeof e&&(e=na[e]),!e)return!1;var r=!1;try{t.isReadOnly()&&(t.state.suppressEdits=!0),r=e(t,n)!=B}finally{t.state.suppressEdits=!1}return r}))}(e,i,r,o,t)||(1==i?r?function(t,e,n,r){a?setTimeout(R(Cr,t),0):t.curOp.focus=D();var i,o=function(t,e,n){var r=t.getOption("configureMouse"),i=r?r(t,e,n):{};if(null==i.unit){var o=b?n.shiftKey&&n.metaKey:n.altKey;i.unit=o?"rectangle":"single"==e?"char":"double"==e?"word":"line"}return(null==i.extend||t.doc.extend)&&(i.extend=t.doc.extend||n.shiftKey),null==i.addNew&&(i.addNew=y?n.metaKey:n.ctrlKey),null==i.moveOnDrag&&(i.moveOnDrag=!(y?n.altKey:n.ctrlKey)),i}(t,n,r),l=t.doc.sel;t.options.dragDrop&&Pt&&!t.isReadOnly()&&"single"==n&&(i=l.contains(e))>-1&&(ne((i=l.ranges[i]).from(),e)<0||e.xRel>0)&&(ne(i.to(),e)>0||e.xRel<0)?function(t,e,n,r){var i=t.display,o=!1,l=ei(t,(function(e){c&&(i.scroller.draggable=!1),t.state.draggingText=!1,t.state.delayingBlurEvent&&(t.hasFocus()?t.state.delayingBlurEvent=!1:kr(t)),pt(i.wrapper.ownerDocument,"mouseup",l),pt(i.wrapper.ownerDocument,"mousemove",u),pt(i.scroller,"dragstart",d),pt(i.scroller,"drop",l),o||(wt(e),r.addNew||Yi(t.doc,n,null,null,r.extend),c&&!h||a&&9==s?setTimeout((function(){i.wrapper.ownerDocument.body.focus({preventScroll:!0}),i.input.focus()}),20):i.input.focus())})),u=function(t){o=o||Math.abs(e.clientX-t.clientX)+Math.abs(e.clientY-t.clientY)>=10},d=function(){return o=!0};c&&(i.scroller.draggable=!0),t.state.draggingText=l,l.copy=!r.moveOnDrag,ht(i.wrapper.ownerDocument,"mouseup",l),ht(i.wrapper.ownerDocument,"mousemove",u),ht(i.scroller,"dragstart",d),ht(i.scroller,"drop",l),t.state.delayingBlurEvent=!0,setTimeout((function(){return i.input.focus()}),20),i.scroller.dragDrop&&i.scroller.dragDrop()}(t,r,e,o):function(t,e,n,r){a&&kr(t);var i=t.display,o=t.doc;wt(e);var s,c,l=o.sel,u=l.ranges;if(r.addNew&&!r.extend?(c=o.sel.contains(n),s=c>-1?u[c]:new ki(n,n)):(s=o.sel.primary(),c=o.sel.primIndex),"rectangle"==r.unit)r.addNew||(s=new ki(n,n)),n=ur(t,e,!0,!0),c=-1;else{var d=ba(t,n,r.unit);s=r.extend?Ki(s,d.anchor,d.head,r.extend):d}r.addNew?-1==c?(c=u.length,to(o,Si(t,u.concat([s]),c),{scroll:!1,origin:"*mouse"})):u.length>1&&u[c].empty()&&"char"==r.unit&&!r.extend?(to(o,Si(t,u.slice(0,c).concat(u.slice(c+1)),0),{scroll:!1,origin:"*mouse"}),l=o.sel):Ji(o,c,s,$):(c=0,to(o,new Ci([s],0),$),l=o.sel);var h=n;function f(e){if(0!=ne(h,e))if(h=e,"rectangle"==r.unit){for(var i=[],a=t.options.tabSize,u=F(Gt(o,n.line).text,n.ch,a),d=F(Gt(o,e.line).text,e.ch,a),f=Math.min(u,d),p=Math.max(u,d),g=Math.min(n.line,e.line),v=Math.min(t.lastLine(),Math.max(n.line,e.line));g<=v;g++){var m=Gt(o,g).text,y=q(m,f,a);f==p?i.push(new ki(ee(g,y),ee(g,y))):m.length>y&&i.push(new ki(ee(g,y),ee(g,q(m,p,a))))}i.length||i.push(new ki(n,n)),to(o,Si(t,l.ranges.slice(0,c).concat(i),c),{origin:"*mouse",scroll:!1}),t.scrollIntoView(e)}else{var b,w=s,O=ba(t,e,r.unit),x=w.anchor;ne(O.anchor,x)>0?(b=O.head,x=ae(w.from(),O.anchor)):(b=O.anchor,x=oe(w.to(),O.head));var C=l.ranges.slice(0);C[c]=function(t,e){var n=e.anchor,r=e.head,i=Gt(t.doc,n.line);if(0==ne(n,r)&&n.sticky==r.sticky)return e;var o=ut(i);if(!o)return e;var a=ct(o,n.ch,n.sticky),s=o[a];if(s.from!=n.ch&&s.to!=n.ch)return e;var c,l=a+(s.from==n.ch==(1!=s.level)?0:1);if(0==l||l==o.length)return e;if(r.line!=n.line)c=(r.line-n.line)*("ltr"==t.doc.direction?1:-1)>0;else{var u=ct(o,r.ch,r.sticky),d=u-a||(r.ch-n.ch)*(1==s.level?-1:1);c=u==l-1||u==l?d<0:d>0}var h=o[l+(c?-1:0)],f=c==(1==h.level),p=f?h.from:h.to,g=f?"after":"before";return n.ch==p&&n.sticky==g?e:new ki(new ee(n.line,p,g),r)}(t,new ki(ce(o,x),b)),to(o,Si(t,C,c),$)}}var p=i.wrapper.getBoundingClientRect(),g=0;function v(e){t.state.selectingText=!1,g=1/0,e&&(wt(e),i.input.focus()),pt(i.wrapper.ownerDocument,"mousemove",m),pt(i.wrapper.ownerDocument,"mouseup",y),o.history.lastSelOrigin=null}var m=ei(t,(function(e){0!==e.buttons&&St(e)?function e(n){var a=++g,s=ur(t,n,!0,"rectangle"==r.unit);if(s)if(0!=ne(s,h)){t.curOp.focus=D(),f(s);var c=Er(i,o);(s.line>=c.to||s.line<c.from)&&setTimeout(ei(t,(function(){g==a&&e(n)})),150)}else{var l=n.clientY<p.top?-20:n.clientY>p.bottom?20:0;l&&setTimeout(ei(t,(function(){g==a&&(i.scroller.scrollTop+=l,e(n))})),50)}}(e):v(e)})),y=ei(t,v);t.state.selectingText=y,ht(i.wrapper.ownerDocument,"mousemove",m),ht(i.wrapper.ownerDocument,"mouseup",y)}(t,r,e,o)}(e,r,o,t):kt(t)==n.scroller&&wt(t):2==i?(r&&Yi(e.doc,r),setTimeout((function(){return n.input.focus()}),20)):3==i&&(C?e.display.input.onContextMenu(t):kr(e)))}}function ba(t,e,n){if("char"==n)return new ki(e,e);if("word"==n)return t.findWordAt(e);if("line"==n)return new ki(ee(e.line,0),ce(t.doc,ee(e.line+1,0)));var r=n(t,e);return new ki(r.from,r.to)}function wa(t,e,n,r){var i,o;if(e.touches)i=e.touches[0].clientX,o=e.touches[0].clientY;else try{i=e.clientX,o=e.clientY}catch(t){return!1}if(i>=Math.floor(t.display.gutters.getBoundingClientRect().right))return!1;r&&wt(e);var a=t.display,s=a.lineDiv.getBoundingClientRect();if(o>s.bottom||!yt(t,n))return xt(e);o-=s.top-a.viewOffset;for(var c=0;c<t.display.gutterSpecs.length;++c){var l=a.gutters.childNodes[c];if(l&&l.getBoundingClientRect().right>=i)return gt(t,n,t,Zt(t.doc,o),t.display.gutterSpecs[c].className,e),xt(e)}}function Oa(t,e){return wa(t,e,"gutterClick",!0)}function xa(t,e){Cn(t.display,e)||function(t,e){return!!yt(t,"gutterContextMenu")&&wa(t,e,"gutterContextMenu",!1)}(t,e)||vt(t,e,"contextmenu")||C||t.display.input.onContextMenu(e)}function Ca(t){t.display.wrapper.className=t.display.wrapper.className.replace(/\s*cm-s-\S+/g,"")+t.options.theme.replace(/(^|\s)\s*/g," cm-s-"),Hn(t)}ma.prototype.compare=function(t,e,n){return this.time+va>t&&0==ne(e,this.pos)&&n==this.button};var ka={toString:function(){return"CodeMirror.Init"}},Sa={},ja={};function Ta(t,e,n){if(!e!=!(n&&n!=ka)){var r=t.display.dragFunctions,i=e?ht:pt;i(t.display.scroller,"dragstart",r.start),i(t.display.scroller,"dragenter",r.enter),i(t.display.scroller,"dragover",r.over),i(t.display.scroller,"dragleave",r.leave),i(t.display.scroller,"drop",r.drop)}}function Pa(t){t.options.lineWrapping?(A(t.display.wrapper,"CodeMirror-wrap"),t.display.sizer.style.minWidth="",t.display.sizerWidth=null):(j(t.display.wrapper,"CodeMirror-wrap"),qe(t)),lr(t),hr(t),Hn(t),setTimeout((function(){return Br(t)}),100)}function Ea(t,e){var n=this;if(!(this instanceof Ea))return new Ea(t,e);this.options=e=e?I(e):{},I(Sa,e,!1);var r=e.value;"string"==typeof r?r=new Do(r,e.mode,null,e.lineSeparator,e.direction):e.mode&&(r.modeOption=e.mode),this.doc=r;var i=new Ea.inputStyles[e.inputStyle](this),o=this.display=new mi(t,r,i,e);for(var l in o.wrapper.CodeMirror=this,Ca(this),e.lineWrapping&&(this.display.wrapper.className+=" CodeMirror-wrap"),Wr(this),this.state={keyMaps:[],overlays:[],modeGen:0,overwrite:!1,delayingBlurEvent:!1,focused:!1,suppressEdits:!1,pasteIncoming:-1,cutIncoming:-1,selectingText:!1,draggingText:!1,highlight:new V,keySeq:null,specialChars:null},e.autofocus&&!m&&o.input.focus(),a&&s<11&&setTimeout((function(){return n.display.input.reset(!0)}),20),function(t){var e=t.display;ht(e.scroller,"mousedown",ei(t,ya)),ht(e.scroller,"dblclick",a&&s<11?ei(t,(function(e){if(!vt(t,e)){var n=ur(t,e);if(n&&!Oa(t,e)&&!Cn(t.display,e)){wt(e);var r=t.findWordAt(n);Yi(t.doc,r.anchor,r.head)}}})):function(e){return vt(t,e)||wt(e)}),ht(e.scroller,"contextmenu",(function(e){return xa(t,e)})),ht(e.input.getField(),"contextmenu",(function(n){e.scroller.contains(n.target)||xa(t,n)}));var n,r={end:0};function i(){e.activeTouch&&(n=setTimeout((function(){return e.activeTouch=null}),1e3),(r=e.activeTouch).end=+new Date)}function o(t,e){if(null==e.left)return!0;var n=e.left-t.left,r=e.top-t.top;return n*n+r*r>20*20}ht(e.scroller,"touchstart",(function(i){if(!vt(t,i)&&!function(t){if(1!=t.touches.length)return!1;var e=t.touches[0];return e.radiusX<=1&&e.radiusY<=1}(i)&&!Oa(t,i)){e.input.ensurePolled(),clearTimeout(n);var o=+new Date;e.activeTouch={start:o,moved:!1,prev:o-r.end<=300?r:null},1==i.touches.length&&(e.activeTouch.left=i.touches[0].pageX,e.activeTouch.top=i.touches[0].pageY)}})),ht(e.scroller,"touchmove",(function(){e.activeTouch&&(e.activeTouch.moved=!0)})),ht(e.scroller,"touchend",(function(n){var r=e.activeTouch;if(r&&!Cn(e,n)&&null!=r.left&&!r.moved&&new Date-r.start<300){var a,s=t.coordsChar(e.activeTouch,"page");a=!r.prev||o(r,r.prev)?new ki(s,s):!r.prev.prev||o(r,r.prev.prev)?t.findWordAt(s):new ki(ee(s.line,0),ce(t.doc,ee(s.line+1,0))),t.setSelection(a.anchor,a.head),t.focus(),wt(n)}i()})),ht(e.scroller,"touchcancel",i),ht(e.scroller,"scroll",(function(){e.scroller.clientHeight&&(Rr(t,e.scroller.scrollTop),Fr(t,e.scroller.scrollLeft,!0),gt(t,"scroll",t))})),ht(e.scroller,"mousewheel",(function(e){return xi(t,e)})),ht(e.scroller,"DOMMouseScroll",(function(e){return xi(t,e)})),ht(e.wrapper,"scroll",(function(){return e.wrapper.scrollTop=e.wrapper.scrollLeft=0})),e.dragFunctions={enter:function(e){vt(t,e)||Ct(e)},over:function(e){vt(t,e)||(function(t,e){var n=ur(t,e);if(n){var r=document.createDocumentFragment();br(t,n,r),t.display.dragCursor||(t.display.dragCursor=E("div",null,"CodeMirror-cursors CodeMirror-dragcursors"),t.display.lineSpace.insertBefore(t.display.dragCursor,t.display.cursorDiv)),P(t.display.dragCursor,r)}}(t,e),Ct(e))},start:function(e){return function(t,e){if(a&&(!t.state.draggingText||+new Date-Ao<100))Ct(e);else if(!vt(t,e)&&!Cn(t.display,e)&&(e.dataTransfer.setData("Text",t.getSelection()),e.dataTransfer.effectAllowed="copyMove",e.dataTransfer.setDragImage&&!h)){var n=E("img",null,null,"position: fixed; left: 0; top: 0;");n.src="data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==",d&&(n.width=n.height=1,t.display.wrapper.appendChild(n),n._top=n.offsetTop),e.dataTransfer.setDragImage(n,0,0),d&&n.parentNode.removeChild(n)}}(t,e)},drop:ei(t,Lo),leave:function(e){vt(t,e)||No(t)}};var c=e.input.getField();ht(c,"keyup",(function(e){return ha.call(t,e)})),ht(c,"keydown",ei(t,da)),ht(c,"keypress",ei(t,fa)),ht(c,"focus",(function(e){return Sr(t,e)})),ht(c,"blur",(function(e){return jr(t,e)}))}(this),Fo(),Gr(this),this.curOp.forceUpdate=!0,Ri(this,r),e.autofocus&&!m||this.hasFocus()?setTimeout((function(){n.hasFocus()&&!n.state.focused&&Sr(n)}),20):jr(this),ja)ja.hasOwnProperty(l)&&ja[l](this,e[l],ka);fi(this),e.finishInit&&e.finishInit(this);for(var u=0;u<_a.length;++u)_a[u](this);Kr(this),c&&e.lineWrapping&&"optimizelegibility"==getComputedStyle(o.lineDiv).textRendering&&(o.lineDiv.style.textRendering="auto")}Ea.defaults=Sa,Ea.optionHandlers=ja;var _a=[];function Ma(t,e,n,r){var i,o=t.doc;null==n&&(n="add"),"smart"==n&&(o.mode.indent?i=pe(t,e).state:n="prev");var a=t.options.tabSize,s=Gt(o,e),c=F(s.text,null,a);s.stateAfter&&(s.stateAfter=null);var l,u=s.text.match(/^\s*/)[0];if(r||/\S/.test(s.text)){if("smart"==n&&((l=o.mode.indent(i,s.text.slice(u.length),s.text))==B||l>150)){if(!r)return;n="prev"}}else l=0,n="not";"prev"==n?l=e>o.first?F(Gt(o,e-1).text,null,a):0:"add"==n?l=c+t.options.indentUnit:"subtract"==n?l=c-t.options.indentUnit:"number"==typeof n&&(l=c+n),l=Math.max(0,l);var d="",h=0;if(t.options.indentWithTabs)for(var f=Math.floor(l/a);f;--f)h+=a,d+="\t";if(h<l&&(d+=K(l-h)),d!=u)return vo(o,d,ee(e,0),ee(e,u.length),"+input"),s.stateAfter=null,!0;for(var p=0;p<o.sel.ranges.length;p++){var g=o.sel.ranges[p];if(g.head.line==e&&g.head.ch<u.length){var v=ee(e,u.length);Ji(o,p,new ki(v,v));break}}}Ea.defineInitHook=function(t){return _a.push(t)};var Da=null;function Aa(t){Da=t}function La(t,e,n,r,i){var o=t.doc;t.display.shift=!1,r||(r=o.sel);var a=+new Date-200,s="paste"==i||t.state.pasteIncoming>a,c=Dt(e),l=null;if(s&&r.ranges.length>1)if(Da&&Da.text.join("\n")==e){if(r.ranges.length%Da.text.length==0){l=[];for(var u=0;u<Da.text.length;u++)l.push(o.splitLines(Da.text[u]))}}else c.length==r.ranges.length&&t.options.pasteLinesPerSelection&&(l=X(c,(function(t){return[t]})));for(var d=t.curOp.updateInput,h=r.ranges.length-1;h>=0;h--){var f=r.ranges[h],p=f.from(),g=f.to();f.empty()&&(n&&n>0?p=ee(p.line,p.ch-n):t.state.overwrite&&!s?g=ee(g.line,Math.min(Gt(o,g.line).text.length,g.ch+Y(c).length)):s&&Da&&Da.lineWise&&Da.text.join("\n")==c.join("\n")&&(p=g=ee(p.line,0)));var v={from:p,to:g,text:l?l[h%l.length]:c,origin:i||(s?"paste":t.state.cutIncoming>a?"cut":"+input")};uo(t.doc,v),ln(t,"inputRead",t,v)}e&&!s&&Ra(t,e),Dr(t),t.curOp.updateInput<2&&(t.curOp.updateInput=d),t.curOp.typing=!0,t.state.pasteIncoming=t.state.cutIncoming=-1}function Na(t,e){var n=t.clipboardData&&t.clipboardData.getData("Text");if(n)return t.preventDefault(),e.isReadOnly()||e.options.disableInput||ti(e,(function(){return La(e,n,0,null,"paste")})),!0}function Ra(t,e){if(t.options.electricChars&&t.options.smartIndent)for(var n=t.doc.sel,r=n.ranges.length-1;r>=0;r--){var i=n.ranges[r];if(!(i.head.ch>100||r&&n.ranges[r-1].head.line==i.head.line)){var o=t.getModeAt(i.head),a=!1;if(o.electricChars){for(var s=0;s<o.electricChars.length;s++)if(e.indexOf(o.electricChars.charAt(s))>-1){a=Ma(t,i.head.line,"smart");break}}else o.electricInput&&o.electricInput.test(Gt(t.doc,i.head.line).text.slice(0,i.head.ch))&&(a=Ma(t,i.head.line,"smart"));a&&ln(t,"electricInput",t,i.head.line)}}}function Ia(t){for(var e=[],n=[],r=0;r<t.doc.sel.ranges.length;r++){var i=t.doc.sel.ranges[r].head.line,o={anchor:ee(i,0),head:ee(i+1,0)};n.push(o),e.push(t.getRange(o.anchor,o.head))}return{text:e,ranges:n}}function Fa(t,e,n,r){t.setAttribute("autocorrect",n?"":"off"),t.setAttribute("autocapitalize",r?"":"off"),t.setAttribute("spellcheck",!!e)}function Va(){var t=E("textarea",null,null,"position: absolute; bottom: -1em; padding: 0; width: 1px; height: 1em; outline: none"),e=E("div",[t],null,"overflow: hidden; position: relative; width: 3px; height: 0px;");return c?t.style.width="1000px":t.setAttribute("wrap","off"),g&&(t.style.border="1px solid black"),Fa(t),e}function za(t,e,n,r,i){var o=e,a=n,s=Gt(t,e.line),c=i&&"rtl"==t.direction?-n:n;function l(o){var a,l;if("codepoint"==r){var u=s.text.charCodeAt(e.ch+(n>0?0:-1));if(isNaN(u))a=null;else{var d=n>0?u>=55296&&u<56320:u>=56320&&u<57343;a=new ee(e.line,Math.max(0,Math.min(s.text.length,e.ch+n*(d?2:1))),-n)}}else a=i?function(t,e,n,r){var i=ut(e,t.doc.direction);if(!i)return ta(e,n,r);n.ch>=e.text.length?(n.ch=e.text.length,n.sticky="before"):n.ch<=0&&(n.ch=0,n.sticky="after");var o=ct(i,n.ch,n.sticky),a=i[o];if("ltr"==t.doc.direction&&a.level%2==0&&(r>0?a.to>n.ch:a.from<n.ch))return ta(e,n,r);var s,c=function(t,n){return Qo(e,t instanceof ee?t.ch:t,n)},l=function(n){return t.options.lineWrapping?(s=s||An(t,e),Qn(t,e,s,n)):{begin:0,end:e.text.length}},u=l("before"==n.sticky?c(n,-1):n.ch);if("rtl"==t.doc.direction||1==a.level){var d=1==a.level==r<0,h=c(n,d?1:-1);if(null!=h&&(d?h<=a.to&&h<=u.end:h>=a.from&&h>=u.begin)){var f=d?"before":"after";return new ee(n.line,h,f)}}var p=function(t,e,r){for(var o=function(t,e){return e?new ee(n.line,c(t,1),"before"):new ee(n.line,t,"after")};t>=0&&t<i.length;t+=e){var a=i[t],s=e>0==(1!=a.level),l=s?r.begin:c(r.end,-1);if(a.from<=l&&l<a.to)return o(l,s);if(l=s?a.from:c(a.to,-1),r.begin<=l&&l<r.end)return o(l,s)}},g=p(o+r,r,u);if(g)return g;var v=r>0?u.end:c(u.begin,-1);return null==v||r>0&&v==e.text.length||!(g=p(r>0?0:i.length-1,r,l(v)))?null:g}(t.cm,s,e,n):ta(s,e,n);if(null==a){if(o||(l=e.line+c)<t.first||l>=t.first+t.size||(e=new ee(l,e.ch,e.sticky),!(s=Gt(t,l))))return!1;e=ea(i,t.cm,s,e.line,c)}else e=a;return!0}if("char"==r||"codepoint"==r)l();else if("column"==r)l(!0);else if("word"==r||"group"==r)for(var u=null,d="group"==r,h=t.cm&&t.cm.getHelper(e,"wordChars"),f=!0;!(n<0)||l(!f);f=!1){var p=s.text.charAt(e.ch)||"\n",g=et(p,h)?"w":d&&"\n"==p?"n":!d||/\s/.test(p)?null:"p";if(!d||f||g||(g="s"),u&&u!=g){n<0&&(n=1,l(),e.sticky="after");break}if(g&&(u=g),n>0&&!l(!f))break}var v=ao(t,e,o,a,!0);return re(o,v)&&(v.hitSide=!0),v}function Ha(t,e,n,r){var i,o,a=t.doc,s=e.left;if("page"==r){var c=Math.min(t.display.wrapper.clientHeight,window.innerHeight||document.documentElement.clientHeight),l=Math.max(c-.5*ir(t.display),3);i=(n>0?e.bottom:e.top)+n*l}else"line"==r&&(i=n>0?e.bottom+3:e.top-3);for(;(o=Jn(t,s,i)).outside;){if(n<0?i<=0:i>=a.height){o.hitSide=!0;break}i+=5*n}return o}var Ba=function(t){this.cm=t,this.lastAnchorNode=this.lastAnchorOffset=this.lastFocusNode=this.lastFocusOffset=null,this.polling=new V,this.composing=null,this.gracePeriod=!1,this.readDOMTimeout=null};function Ua(t,e){var n=Dn(t,e.line);if(!n||n.hidden)return null;var r=Gt(t.doc,e.line),i=_n(n,r,e.line),o=ut(r,t.doc.direction),a="left";o&&(a=ct(o,e.ch)%2?"right":"left");var s=In(i.map,e.ch,a);return s.offset="right"==s.collapse?s.end:s.start,s}function $a(t,e){return e&&(t.bad=!0),t}function Wa(t,e,n){var r;if(e==t.display.lineDiv){if(!(r=t.display.lineDiv.childNodes[n]))return $a(t.clipPos(ee(t.display.viewTo-1)),!0);e=null,n=0}else for(r=e;;r=r.parentNode){if(!r||r==t.display.lineDiv)return null;if(r.parentNode&&r.parentNode==t.display.lineDiv)break}for(var i=0;i<t.display.view.length;i++){var o=t.display.view[i];if(o.node==r)return qa(o,e,n)}}function qa(t,e,n){var r=t.text.firstChild,i=!1;if(!e||!M(r,e))return $a(ee(Jt(t.line),0),!0);if(e==r&&(i=!0,e=r.childNodes[n],n=0,!e)){var o=t.rest?Y(t.rest):t.line;return $a(ee(Jt(o),o.text.length),i)}var a=3==e.nodeType?e:null,s=e;for(a||1!=e.childNodes.length||3!=e.firstChild.nodeType||(a=e.firstChild,n&&(n=a.nodeValue.length));s.parentNode!=r;)s=s.parentNode;var c=t.measure,l=c.maps;function u(e,n,r){for(var i=-1;i<(l?l.length:0);i++)for(var o=i<0?c.map:l[i],a=0;a<o.length;a+=3){var s=o[a+2];if(s==e||s==n){var u=Jt(i<0?t.line:t.rest[i]),d=o[a]+r;return(r<0||s!=e)&&(d=o[a+(r?1:0)]),ee(u,d)}}}var d=u(a,s,n);if(d)return $a(d,i);for(var h=s.nextSibling,f=a?a.nodeValue.length-n:0;h;h=h.nextSibling){if(d=u(h,h.firstChild,0))return $a(ee(d.line,d.ch-f),i);f+=h.textContent.length}for(var p=s.previousSibling,g=n;p;p=p.previousSibling){if(d=u(p,p.firstChild,-1))return $a(ee(d.line,d.ch+g),i);g+=p.textContent.length}}Ba.prototype.init=function(t){var e=this,n=this,r=n.cm,i=n.div=t.lineDiv;function o(t){for(var e=t.target;e;e=e.parentNode){if(e==i)return!0;if(/\bCodeMirror-(?:line)?widget\b/.test(e.className))break}return!1}function a(t){if(o(t)&&!vt(r,t)){if(r.somethingSelected())Aa({lineWise:!1,text:r.getSelections()}),"cut"==t.type&&r.replaceSelection("",null,"cut");else{if(!r.options.lineWiseCopyCut)return;var e=Ia(r);Aa({lineWise:!0,text:e.text}),"cut"==t.type&&r.operation((function(){r.setSelections(e.ranges,0,U),r.replaceSelection("",null,"cut")}))}if(t.clipboardData){t.clipboardData.clearData();var a=Da.text.join("\n");if(t.clipboardData.setData("Text",a),t.clipboardData.getData("Text")==a)return void t.preventDefault()}var s=Va(),c=s.firstChild;r.display.lineSpace.insertBefore(s,r.display.lineSpace.firstChild),c.value=Da.text.join("\n");var l=D();N(c),setTimeout((function(){r.display.lineSpace.removeChild(s),l.focus(),l==i&&n.showPrimarySelection()}),50)}}i.contentEditable=!0,Fa(i,r.options.spellcheck,r.options.autocorrect,r.options.autocapitalize),ht(i,"paste",(function(t){!o(t)||vt(r,t)||Na(t,r)||s<=11&&setTimeout(ei(r,(function(){return e.updateFromDOM()})),20)})),ht(i,"compositionstart",(function(t){e.composing={data:t.data,done:!1}})),ht(i,"compositionupdate",(function(t){e.composing||(e.composing={data:t.data,done:!1})})),ht(i,"compositionend",(function(t){e.composing&&(t.data!=e.composing.data&&e.readFromDOMSoon(),e.composing.done=!0)})),ht(i,"touchstart",(function(){return n.forceCompositionEnd()})),ht(i,"input",(function(){e.composing||e.readFromDOMSoon()})),ht(i,"copy",a),ht(i,"cut",a)},Ba.prototype.screenReaderLabelChanged=function(t){t?this.div.setAttribute('aria-label',t):this.div.removeAttribute('aria-label')},Ba.prototype.prepareSelection=function(){var t=yr(this.cm,!1);return t.focus=D()==this.div,t},Ba.prototype.showSelection=function(t,e){t&&this.cm.display.view.length&&((t.focus||e)&&this.showPrimarySelection(),this.showMultipleSelections(t))},Ba.prototype.getSelection=function(){return this.cm.display.wrapper.ownerDocument.getSelection()},Ba.prototype.showPrimarySelection=function(){var t=this.getSelection(),e=this.cm,r=e.doc.sel.primary(),i=r.from(),o=r.to();if(e.display.viewTo==e.display.viewFrom||i.line>=e.display.viewTo||o.line<e.display.viewFrom)t.removeAllRanges();else{var a=Wa(e,t.anchorNode,t.anchorOffset),s=Wa(e,t.focusNode,t.focusOffset);if(!a||a.bad||!s||s.bad||0!=ne(ae(a,s),i)||0!=ne(oe(a,s),o)){var c=e.display.view,l=i.line>=e.display.viewFrom&&Ua(e,i)||{node:c[0].measure.map[2],offset:0},u=o.line<e.display.viewTo&&Ua(e,o);if(!u){var d=c[c.length-1].measure,h=d.maps?d.maps[d.maps.length-1]:d.map;u={node:h[h.length-1],offset:h[h.length-2]-h[h.length-3]}}if(l&&u){var f,p=t.rangeCount&&t.getRangeAt(0);try{f=S(l.node,l.offset,u.offset,u.node)}catch(t){}f&&(!n&&e.state.focused?(t.collapse(l.node,l.offset),f.collapsed||(t.removeAllRanges(),t.addRange(f))):(t.removeAllRanges(),t.addRange(f)),p&&null==t.anchorNode?t.addRange(p):n&&this.startGracePeriod()),this.rememberSelection()}else t.removeAllRanges()}}},Ba.prototype.startGracePeriod=function(){var t=this;clearTimeout(this.gracePeriod),this.gracePeriod=setTimeout((function(){t.gracePeriod=!1,t.selectionChanged()&&t.cm.operation((function(){return t.cm.curOp.selectionChanged=!0}))}),20)},Ba.prototype.showMultipleSelections=function(t){P(this.cm.display.cursorDiv,t.cursors),P(this.cm.display.selectionDiv,t.selection)},Ba.prototype.rememberSelection=function(){var t=this.getSelection();this.lastAnchorNode=t.anchorNode,this.lastAnchorOffset=t.anchorOffset,this.lastFocusNode=t.focusNode,this.lastFocusOffset=t.focusOffset},Ba.prototype.selectionInEditor=function(){var t=this.getSelection();if(!t.rangeCount)return!1;var e=t.getRangeAt(0).commonAncestorContainer;return M(this.div,e)},Ba.prototype.focus=function(){"nocursor"!=this.cm.options.readOnly&&(this.selectionInEditor()&&D()==this.div||this.showSelection(this.prepareSelection(),!0),this.div.focus())},Ba.prototype.blur=function(){this.div.blur()},Ba.prototype.getField=function(){return this.div},Ba.prototype.supportsTouch=function(){return!0},Ba.prototype.receivedFocus=function(){var t=this,e=this;this.selectionInEditor()?setTimeout((function(){return t.pollSelection()}),20):ti(this.cm,(function(){return e.cm.curOp.selectionChanged=!0})),this.polling.set(this.cm.options.pollInterval,(function t(){e.cm.state.focused&&(e.pollSelection(),e.polling.set(e.cm.options.pollInterval,t))}))},Ba.prototype.selectionChanged=function(){var t=this.getSelection();return t.anchorNode!=this.lastAnchorNode||t.anchorOffset!=this.lastAnchorOffset||t.focusNode!=this.lastFocusNode||t.focusOffset!=this.lastFocusOffset},Ba.prototype.pollSelection=function(){if(null==this.readDOMTimeout&&!this.gracePeriod&&this.selectionChanged()){var t=this.getSelection(),e=this.cm;if(v&&u&&this.cm.display.gutterSpecs.length&&function(t){for(var e=t;e;e=e.parentNode)if(/CodeMirror-gutter-wrapper/.test(e.className))return!0;return!1}(t.anchorNode))return this.cm.triggerOnKeyDown({type:"keydown",keyCode:8,preventDefault:Math.abs}),this.blur(),void this.focus();if(!this.composing){this.rememberSelection();var n=Wa(e,t.anchorNode,t.anchorOffset),r=Wa(e,t.focusNode,t.focusOffset);n&&r&&ti(e,(function(){to(e.doc,ji(n,r),U),(n.bad||r.bad)&&(e.curOp.selectionChanged=!0)}))}}},Ba.prototype.pollContent=function(){null!=this.readDOMTimeout&&(clearTimeout(this.readDOMTimeout),this.readDOMTimeout=null);var t,e,n,r=this.cm,i=r.display,o=r.doc.sel.primary(),a=o.from(),s=o.to();if(0==a.ch&&a.line>r.firstLine()&&(a=ee(a.line-1,Gt(r.doc,a.line-1).length)),s.ch==Gt(r.doc,s.line).text.length&&s.line<r.lastLine()&&(s=ee(s.line+1,0)),a.line<i.viewFrom||s.line>i.viewTo-1)return!1;a.line==i.viewFrom||0==(t=dr(r,a.line))?(e=Jt(i.view[0].line),n=i.view[0].node):(e=Jt(i.view[t].line),n=i.view[t-1].node.nextSibling);var c,l,u=dr(r,s.line);if(u==i.view.length-1?(c=i.viewTo-1,l=i.lineDiv.lastChild):(c=Jt(i.view[u+1].line)-1,l=i.view[u+1].node.previousSibling),!n)return!1;for(var d=r.doc.splitLines(function(t,e,n,r,i){var o="",a=!1,s=t.doc.lineSeparator(),c=!1;function l(){a&&(o+=s,c&&(o+=s),a=c=!1)}function u(t){t&&(l(),o+=t)}function d(e){if(1==e.nodeType){var n=e.getAttribute("cm-text");if(n)return void u(n);var o,h=e.getAttribute("cm-marker");if(h){var f=t.findMarks(ee(r,0),ee(i+1,0),(v=+h,function(t){return t.id==v}));return void(f.length&&(o=f[0].find(0))&&u(Kt(t.doc,o.from,o.to).join(s)))}if("false"==e.getAttribute("contenteditable"))return;var p=/^(pre|div|p|li|table|br)$/i.test(e.nodeName);if(!/^br$/i.test(e.nodeName)&&0==e.textContent.length)return;p&&l();for(var g=0;g<e.childNodes.length;g++)d(e.childNodes[g]);/^(pre|p)$/i.test(e.nodeName)&&(c=!0),p&&(a=!0)}else 3==e.nodeType&&u(e.nodeValue.replace(/\u200b/g,"").replace(/\u00a0/g," "));var v}for(;d(e),e!=n;)e=e.nextSibling,c=!1;return o}(r,n,l,e,c)),h=Kt(r.doc,ee(e,0),ee(c,Gt(r.doc,c).text.length));d.length>1&&h.length>1;)if(Y(d)==Y(h))d.pop(),h.pop(),c--;else{if(d[0]!=h[0])break;d.shift(),h.shift(),e++}for(var f=0,p=0,g=d[0],v=h[0],m=Math.min(g.length,v.length);f<m&&g.charCodeAt(f)==v.charCodeAt(f);)++f;for(var y=Y(d),b=Y(h),w=Math.min(y.length-(1==d.length?f:0),b.length-(1==h.length?f:0));p<w&&y.charCodeAt(y.length-p-1)==b.charCodeAt(b.length-p-1);)++p;if(1==d.length&&1==h.length&&e==a.line)for(;f&&f>a.ch&&y.charCodeAt(y.length-p-1)==b.charCodeAt(b.length-p-1);)f--,p++;d[d.length-1]=y.slice(0,y.length-p).replace(/^\u200b+/,""),d[0]=d[0].slice(f).replace(/\u200b+$/,"");var O=ee(e,f),x=ee(c,h.length?Y(h).length-p:0);return d.length>1||d[0]||ne(O,x)?(vo(r.doc,d,O,x,"+input"),!0):void 0},Ba.prototype.ensurePolled=function(){this.forceCompositionEnd()},Ba.prototype.reset=function(){this.forceCompositionEnd()},Ba.prototype.forceCompositionEnd=function(){this.composing&&(clearTimeout(this.readDOMTimeout),this.composing=null,this.updateFromDOM(),this.div.blur(),this.div.focus())},Ba.prototype.readFromDOMSoon=function(){var t=this;null==this.readDOMTimeout&&(this.readDOMTimeout=setTimeout((function(){if(t.readDOMTimeout=null,t.composing){if(!t.composing.done)return;t.composing=null}t.updateFromDOM()}),80))},Ba.prototype.updateFromDOM=function(){var t=this;!this.cm.isReadOnly()&&this.pollContent()||ti(this.cm,(function(){return hr(t.cm)}))},Ba.prototype.setUneditable=function(t){t.contentEditable="false"},Ba.prototype.onKeyPress=function(t){0==t.charCode||this.composing||(t.preventDefault(),this.cm.isReadOnly()||ei(this.cm,La)(this.cm,String.fromCharCode(null==t.charCode?t.keyCode:t.charCode),0))},Ba.prototype.readOnlyChanged=function(t){this.div.contentEditable=String("nocursor"!=t)},Ba.prototype.onContextMenu=function(){},Ba.prototype.resetPosition=function(){},Ba.prototype.needsContentAttribute=!0;var Ga=function(t){this.cm=t,this.prevInput="",this.pollingFast=!1,this.polling=new V,this.hasSelection=!1,this.composing=null};Ga.prototype.init=function(t){var e=this,n=this,r=this.cm;this.createField(t);var i=this.textarea;function o(t){if(!vt(r,t)){if(r.somethingSelected())Aa({lineWise:!1,text:r.getSelections()});else{if(!r.options.lineWiseCopyCut)return;var e=Ia(r);Aa({lineWise:!0,text:e.text}),"cut"==t.type?r.setSelections(e.ranges,null,U):(n.prevInput="",i.value=e.text.join("\n"),N(i))}"cut"==t.type&&(r.state.cutIncoming=+new Date)}}t.wrapper.insertBefore(this.wrapper,t.wrapper.firstChild),g&&(i.style.width="0px"),ht(i,"input",(function(){a&&s>=9&&e.hasSelection&&(e.hasSelection=null),n.poll()})),ht(i,"paste",(function(t){vt(r,t)||Na(t,r)||(r.state.pasteIncoming=+new Date,n.fastPoll())})),ht(i,"cut",o),ht(i,"copy",o),ht(t.scroller,"paste",(function(e){if(!Cn(t,e)&&!vt(r,e)){if(!i.dispatchEvent)return r.state.pasteIncoming=+new Date,void n.focus();var o=new Event("paste");o.clipboardData=e.clipboardData,i.dispatchEvent(o)}})),ht(t.lineSpace,"selectstart",(function(e){Cn(t,e)||wt(e)})),ht(i,"compositionstart",(function(){var t=r.getCursor("from");n.composing&&n.composing.range.clear(),n.composing={start:t,range:r.markText(t,r.getCursor("to"),{className:"CodeMirror-composing"})}})),ht(i,"compositionend",(function(){n.composing&&(n.poll(),n.composing.range.clear(),n.composing=null)}))},Ga.prototype.createField=function(t){this.wrapper=Va(),this.textarea=this.wrapper.firstChild},Ga.prototype.screenReaderLabelChanged=function(t){t?this.textarea.setAttribute('aria-label',t):this.textarea.removeAttribute('aria-label')},Ga.prototype.prepareSelection=function(){var t=this.cm,e=t.display,n=t.doc,r=yr(t);if(t.options.moveInputWithCursor){var i=Kn(t,n.sel.primary().head,"div"),o=e.wrapper.getBoundingClientRect(),a=e.lineDiv.getBoundingClientRect();r.teTop=Math.max(0,Math.min(e.wrapper.clientHeight-10,i.top+a.top-o.top)),r.teLeft=Math.max(0,Math.min(e.wrapper.clientWidth-10,i.left+a.left-o.left))}return r},Ga.prototype.showSelection=function(t){var e=this.cm.display;P(e.cursorDiv,t.cursors),P(e.selectionDiv,t.selection),null!=t.teTop&&(this.wrapper.style.top=t.teTop+"px",this.wrapper.style.left=t.teLeft+"px")},Ga.prototype.reset=function(t){if(!this.contextMenuPending&&!this.composing){var e=this.cm;if(e.somethingSelected()){this.prevInput="";var n=e.getSelection();this.textarea.value=n,e.state.focused&&N(this.textarea),a&&s>=9&&(this.hasSelection=n)}else t||(this.prevInput=this.textarea.value="",a&&s>=9&&(this.hasSelection=null))}},Ga.prototype.getField=function(){return this.textarea},Ga.prototype.supportsTouch=function(){return!1},Ga.prototype.focus=function(){if("nocursor"!=this.cm.options.readOnly&&(!m||D()!=this.textarea))try{this.textarea.focus()}catch(t){}},Ga.prototype.blur=function(){this.textarea.blur()},Ga.prototype.resetPosition=function(){this.wrapper.style.top=this.wrapper.style.left=0},Ga.prototype.receivedFocus=function(){this.slowPoll()},Ga.prototype.slowPoll=function(){var t=this;this.pollingFast||this.polling.set(this.cm.options.pollInterval,(function(){t.poll(),t.cm.state.focused&&t.slowPoll()}))},Ga.prototype.fastPoll=function(){var t=!1,e=this;e.pollingFast=!0,e.polling.set(20,(function n(){e.poll()||t?(e.pollingFast=!1,e.slowPoll()):(t=!0,e.polling.set(60,n))}))},Ga.prototype.poll=function(){var t=this,e=this.cm,n=this.textarea,r=this.prevInput;if(this.contextMenuPending||!e.state.focused||At(n)&&!r&&!this.composing||e.isReadOnly()||e.options.disableInput||e.state.keySeq)return!1;var i=n.value;if(i==r&&!e.somethingSelected())return!1;if(a&&s>=9&&this.hasSelection===i||y&&/[\uf700-\uf7ff]/.test(i))return e.display.input.reset(),!1;if(e.doc.sel==e.display.selForContextMenu){var o=i.charCodeAt(0);if(8203!=o||r||(r="​"),8666==o)return this.reset(),this.cm.execCommand("undo")}for(var c=0,l=Math.min(r.length,i.length);c<l&&r.charCodeAt(c)==i.charCodeAt(c);)++c;return ti(e,(function(){La(e,i.slice(c),r.length-c,null,t.composing?"*compose":null),i.length>1e3||i.indexOf("\n")>-1?n.value=t.prevInput="":t.prevInput=i,t.composing&&(t.composing.range.clear(),t.composing.range=e.markText(t.composing.start,e.getCursor("to"),{className:"CodeMirror-composing"}))})),!0},Ga.prototype.ensurePolled=function(){this.pollingFast&&this.poll()&&(this.pollingFast=!1)},Ga.prototype.onKeyPress=function(){a&&s>=9&&(this.hasSelection=null),this.fastPoll()},Ga.prototype.onContextMenu=function(t){var e=this,n=e.cm,r=n.display,i=e.textarea;e.contextMenuPending&&e.contextMenuPending();var o=ur(n,t),l=r.scroller.scrollTop;if(o&&!d){n.options.resetSelectionOnContextMenu&&-1==n.doc.sel.contains(o)&&ei(n,to)(n.doc,ji(o),U);var u,h=i.style.cssText,f=e.wrapper.style.cssText,p=e.wrapper.offsetParent.getBoundingClientRect();if(e.wrapper.style.cssText="position: static",i.style.cssText="position: absolute; width: 30px; height: 30px;\n      top: "+(t.clientY-p.top-5)+"px; left: "+(t.clientX-p.left-5)+"px;\n      z-index: 1000; background: "+(a?"rgba(255, 255, 255, .05)":"transparent")+";\n      outline: none; border-width: 0; outline: none; overflow: hidden; opacity: .05; filter: alpha(opacity=5);",c&&(u=window.scrollY),r.input.focus(),c&&window.scrollTo(null,u),r.input.reset(),n.somethingSelected()||(i.value=e.prevInput=" "),e.contextMenuPending=m,r.selForContextMenu=n.doc.sel,clearTimeout(r.detectingSelectAll),a&&s>=9&&v(),C){Ct(t);var g=function(){pt(window,"mouseup",g),setTimeout(m,20)};ht(window,"mouseup",g)}else setTimeout(m,50)}function v(){if(null!=i.selectionStart){var t=n.somethingSelected(),o="​"+(t?i.value:"");i.value="⇚",i.value=o,e.prevInput=t?"":"​",i.selectionStart=1,i.selectionEnd=o.length,r.selForContextMenu=n.doc.sel}}function m(){if(e.contextMenuPending==m&&(e.contextMenuPending=!1,e.wrapper.style.cssText=f,i.style.cssText=h,a&&s<9&&r.scrollbars.setScrollTop(r.scroller.scrollTop=l),null!=i.selectionStart)){(!a||a&&s<9)&&v();var t=0,o=function(){r.selForContextMenu==n.doc.sel&&0==i.selectionStart&&i.selectionEnd>0&&"​"==e.prevInput?ei(n,co)(n):t++<10?r.detectingSelectAll=setTimeout(o,500):(r.selForContextMenu=null,r.input.reset())};r.detectingSelectAll=setTimeout(o,200)}}},Ga.prototype.readOnlyChanged=function(t){t||this.reset(),this.textarea.disabled="nocursor"==t,this.textarea.readOnly=!!t},Ga.prototype.setUneditable=function(){},Ga.prototype.needsContentAttribute=!1,function(t){var e=t.optionHandlers;function n(n,r,i,o){t.defaults[n]=r,i&&(e[n]=o?function(t,e,n){n!=ka&&i(t,e,n)}:i)}t.defineOption=n,t.Init=ka,n("value","",(function(t,e){return t.setValue(e)}),!0),n("mode",null,(function(t,e){t.doc.modeOption=e,Mi(t)}),!0),n("indentUnit",2,Mi,!0),n("indentWithTabs",!1),n("smartIndent",!0),n("tabSize",4,(function(t){Di(t),Hn(t),hr(t)}),!0),n("lineSeparator",null,(function(t,e){if(t.doc.lineSep=e,e){var n=[],r=t.doc.first;t.doc.iter((function(t){for(var i=0;;){var o=t.text.indexOf(e,i);if(-1==o)break;i=o+e.length,n.push(ee(r,o))}r++}));for(var i=n.length-1;i>=0;i--)vo(t.doc,e,n[i],ee(n[i].line,n[i].ch+e.length))}})),n("specialChars",/[\u0000-\u001f\u007f-\u009f\u00ad\u061c\u200b\u200e\u200f\u2028\u2029\ufeff\ufff9-\ufffc]/g,(function(t,e,n){t.state.specialChars=new RegExp(e.source+(e.test("\t")?"":"|\t"),"g"),n!=ka&&t.refresh()})),n("specialCharPlaceholder",Qe,(function(t){return t.refresh()}),!0),n("electricChars",!0),n("inputStyle",m?"contenteditable":"textarea",(function(){throw new Error("inputStyle can not (yet) be changed in a running editor")}),!0),n("spellcheck",!1,(function(t,e){return t.getInputField().spellcheck=e}),!0),n("autocorrect",!1,(function(t,e){return t.getInputField().autocorrect=e}),!0),n("autocapitalize",!1,(function(t,e){return t.getInputField().autocapitalize=e}),!0),n("rtlMoveVisually",!w),n("wholeLineUpdateBefore",!0),n("theme","default",(function(t){Ca(t),vi(t)}),!0),n("keyMap","default",(function(t,e,n){var r=Jo(e),i=n!=ka&&Jo(n);i&&i.detach&&i.detach(t,r),r.attach&&r.attach(t,i||null)})),n("extraKeys",null),n("configureMouse",null),n("lineWrapping",!1,Pa,!0),n("gutters",[],(function(t,e){t.display.gutterSpecs=pi(e,t.options.lineNumbers),vi(t)}),!0),n("fixedGutter",!0,(function(t,e){t.display.gutters.style.left=e?sr(t.display)+"px":"0",t.refresh()}),!0),n("coverGutterNextToScrollbar",!1,(function(t){return Br(t)}),!0),n("scrollbarStyle","native",(function(t){Wr(t),Br(t),t.display.scrollbars.setScrollTop(t.doc.scrollTop),t.display.scrollbars.setScrollLeft(t.doc.scrollLeft)}),!0),n("lineNumbers",!1,(function(t,e){t.display.gutterSpecs=pi(t.options.gutters,e),vi(t)}),!0),n("firstLineNumber",1,vi,!0),n("lineNumberFormatter",(function(t){return t}),vi,!0),n("showCursorWhenSelecting",!1,mr,!0),n("resetSelectionOnContextMenu",!0),n("lineWiseCopyCut",!0),n("pasteLinesPerSelection",!0),n("selectionsMayTouch",!1),n("readOnly",!1,(function(t,e){"nocursor"==e&&(jr(t),t.display.input.blur()),t.display.input.readOnlyChanged(e)})),n("screenReaderLabel",null,(function(t,e){e=''===e?null:e,t.display.input.screenReaderLabelChanged(e)})),n("disableInput",!1,(function(t,e){e||t.display.input.reset()}),!0),n("dragDrop",!0,Ta),n("allowDropFileTypes",null),n("cursorBlinkRate",530),n("cursorScrollMargin",0),n("cursorHeight",1,mr,!0),n("singleCursorHeightPerLine",!0,mr,!0),n("workTime",100),n("workDelay",100),n("flattenSpans",!0,Di,!0),n("addModeClass",!1,Di,!0),n("pollInterval",100),n("undoDepth",200,(function(t,e){return t.doc.history.undoDepth=e})),n("historyEventDelay",1250),n("viewportMargin",10,(function(t){return t.refresh()}),!0),n("maxHighlightLength",1e4,Di,!0),n("moveInputWithCursor",!0,(function(t,e){e||t.display.input.resetPosition()})),n("tabindex",null,(function(t,e){return t.display.input.getField().tabIndex=e||""})),n("autofocus",null),n("direction","ltr",(function(t,e){return t.doc.setDirection(e)}),!0),n("phrases",null)}(Ea),function(t){var e=t.optionHandlers,n=t.helpers={};t.prototype={constructor:t,focus:function(){window.focus(),this.display.input.focus()},setOption:function(t,n){var r=this.options,i=r[t];r[t]==n&&"mode"!=t||(r[t]=n,e.hasOwnProperty(t)&&ei(this,e[t])(this,n,i),gt(this,"optionChange",this,t))},getOption:function(t){return this.options[t]},getDoc:function(){return this.doc},addKeyMap:function(t,e){this.state.keyMaps[e?"push":"unshift"](Jo(t))},removeKeyMap:function(t){for(var e=this.state.keyMaps,n=0;n<e.length;++n)if(e[n]==t||e[n].name==t)return e.splice(n,1),!0},addOverlay:ni((function(e,n){var r=e.token?e:t.getMode(this.options,e);if(r.startState)throw new Error("Overlays may not be stateful.");!function(t,e,n){for(var r=0,i=n(e);r<t.length&&n(t[r])<=i;)r++;t.splice(r,0,e)}(this.state.overlays,{mode:r,modeSpec:e,opaque:n&&n.opaque,priority:n&&n.priority||0},(function(t){return t.priority})),this.state.modeGen++,hr(this)})),removeOverlay:ni((function(t){for(var e=this.state.overlays,n=0;n<e.length;++n){var r=e[n].modeSpec;if(r==t||"string"==typeof t&&r.name==t)return e.splice(n,1),this.state.modeGen++,void hr(this)}})),indentLine:ni((function(t,e,n){"string"!=typeof e&&"number"!=typeof e&&(e=null==e?this.options.smartIndent?"smart":"prev":e?"add":"subtract"),Qt(this.doc,t)&&Ma(this,t,e,n)})),indentSelection:ni((function(t){for(var e=this.doc.sel.ranges,n=-1,r=0;r<e.length;r++){var i=e[r];if(i.empty())i.head.line>n&&(Ma(this,i.head.line,t,!0),n=i.head.line,r==this.doc.sel.primIndex&&Dr(this));else{var o=i.from(),a=i.to(),s=Math.max(n,o.line);n=Math.min(this.lastLine(),a.line-(a.ch?0:1))+1;for(var c=s;c<n;++c)Ma(this,c,t);var l=this.doc.sel.ranges;0==o.ch&&e.length==l.length&&l[r].from().ch>0&&Ji(this.doc,r,new ki(o,l[r].to()),U)}}})),getTokenAt:function(t,e){return be(this,t,e)},getLineTokens:function(t,e){return be(this,ee(t),e,!0)},getTokenTypeAt:function(t){t=ce(this.doc,t);var e,n=fe(this,Gt(this.doc,t.line)),r=0,i=(n.length-1)/2,o=t.ch;if(0==o)e=n[2];else for(;;){var a=r+i>>1;if((a?n[2*a-1]:0)>=o)i=a;else{if(!(n[2*a+1]<o)){e=n[2*a+2];break}r=a+1}}var s=e?e.indexOf("overlay "):-1;return s<0?e:0==s?null:e.slice(0,s-1)},getModeAt:function(e){var n=this.doc.mode;return n.innerMode?t.innerMode(n,this.getTokenAt(e).state).mode:n},getHelper:function(t,e){return this.getHelpers(t,e)[0]},getHelpers:function(t,e){var r=[];if(!n.hasOwnProperty(e))return r;var i=n[e],o=this.getModeAt(t);if("string"==typeof o[e])i[o[e]]&&r.push(i[o[e]]);else if(o[e])for(var a=0;a<o[e].length;a++){var s=i[o[e][a]];s&&r.push(s)}else o.helperType&&i[o.helperType]?r.push(i[o.helperType]):i[o.name]&&r.push(i[o.name]);for(var c=0;c<i._global.length;c++){var l=i._global[c];l.pred(o,this)&&-1==z(r,l.val)&&r.push(l.val)}return r},getStateAfter:function(t,e){var n=this.doc;return pe(this,(t=se(n,null==t?n.first+n.size-1:t))+1,e).state},cursorCoords:function(t,e){var n=this.doc.sel.primary();return Kn(this,null==t?n.head:"object"==typeof t?ce(this.doc,t):t?n.from():n.to(),e||"page")},charCoords:function(t,e){return Gn(this,ce(this.doc,t),e||"page")},coordsChar:function(t,e){return Jn(this,(t=qn(this,t,e||"page")).left,t.top)},lineAtHeight:function(t,e){return t=qn(this,{top:t,left:0},e||"page").top,Zt(this.doc,t+this.display.viewOffset)},heightAtLine:function(t,e,n){var r,i=!1;if("number"==typeof t){var o=this.doc.first+this.doc.size-1;t<this.doc.first?t=this.doc.first:t>o&&(t=o,i=!0),r=Gt(this.doc,t)}else r=t;return Wn(this,r,{top:0,left:0},e||"page",n||i).top+(i?this.doc.height-$e(r):0)},defaultTextHeight:function(){return ir(this.display)},defaultCharWidth:function(){return or(this.display)},getViewport:function(){return{from:this.display.viewFrom,to:this.display.viewTo}},addWidget:function(t,e,n,r,i){var o,a,s,c=this.display,l=(t=Kn(this,ce(this.doc,t))).bottom,u=t.left;if(e.style.position="absolute",e.setAttribute("cm-ignore-events","true"),this.display.input.setUneditable(e),c.sizer.appendChild(e),"over"==r)l=t.top;else if("above"==r||"near"==r){var d=Math.max(c.wrapper.clientHeight,this.doc.height),h=Math.max(c.sizer.clientWidth,c.lineSpace.clientWidth);('above'==r||t.bottom+e.offsetHeight>d)&&t.top>e.offsetHeight?l=t.top-e.offsetHeight:t.bottom+e.offsetHeight<=d&&(l=t.bottom),u+e.offsetWidth>h&&(u=h-e.offsetWidth)}e.style.top=l+"px",e.style.left=e.style.right="","right"==i?(u=c.sizer.clientWidth-e.offsetWidth,e.style.right="0px"):("left"==i?u=0:"middle"==i&&(u=(c.sizer.clientWidth-e.offsetWidth)/2),e.style.left=u+"px"),n&&(o=this,a={left:u,top:l,right:u+e.offsetWidth,bottom:l+e.offsetHeight},null!=(s=_r(o,a)).scrollTop&&Rr(o,s.scrollTop),null!=s.scrollLeft&&Fr(o,s.scrollLeft))},triggerOnKeyDown:ni(da),triggerOnKeyPress:ni(fa),triggerOnKeyUp:ha,triggerOnMouseDown:ni(ya),execCommand:function(t){if(na.hasOwnProperty(t))return na[t].call(null,this)},triggerElectric:ni((function(t){Ra(this,t)})),findPosH:function(t,e,n,r){var i=1;e<0&&(i=-1,e=-e);for(var o=ce(this.doc,t),a=0;a<e&&!(o=za(this.doc,o,i,n,r)).hitSide;++a);return o},moveH:ni((function(t,e){var n=this;this.extendSelectionsBy((function(r){return n.display.shift||n.doc.extend||r.empty()?za(n.doc,r.head,t,e,n.options.rtlMoveVisually):t<0?r.from():r.to()}),W)})),deleteH:ni((function(t,e){var n=this.doc.sel,r=this.doc;n.somethingSelected()?r.replaceSelection("",null,"+delete"):Zo(this,(function(n){var i=za(r,n.head,t,e,!1);return t<0?{from:i,to:n.head}:{from:n.head,to:i}}))})),findPosV:function(t,e,n,r){var i=1,o=r;e<0&&(i=-1,e=-e);for(var a=ce(this.doc,t),s=0;s<e;++s){var c=Kn(this,a,"div");if(null==o?o=c.left:c.left=o,(a=Ha(this,c,i,n)).hitSide)break}return a},moveV:ni((function(t,e){var n=this,r=this.doc,i=[],o=!this.display.shift&&!r.extend&&r.sel.somethingSelected();if(r.extendSelectionsBy((function(a){if(o)return t<0?a.from():a.to();var s=Kn(n,a.head,"div");null!=a.goalColumn&&(s.left=a.goalColumn),i.push(s.left);var c=Ha(n,s,t,e);return"page"==e&&a==r.sel.primary()&&Mr(n,Gn(n,c,"div").top-s.top),c}),W),i.length)for(var a=0;a<r.sel.ranges.length;a++)r.sel.ranges[a].goalColumn=i[a]})),findWordAt:function(t){var e=Gt(this.doc,t.line).text,n=t.ch,r=t.ch;if(e){var i=this.getHelper(t,"wordChars");"before"!=t.sticky&&r!=e.length||!n?++r:--n;for(var o=e.charAt(n),a=et(o,i)?function(t){return et(t,i)}:/\s/.test(o)?function(t){return/\s/.test(t)}:function(t){return!/\s/.test(t)&&!et(t)};n>0&&a(e.charAt(n-1));)--n;for(;r<e.length&&a(e.charAt(r));)++r}return new ki(ee(t.line,n),ee(t.line,r))},toggleOverwrite:function(t){null!=t&&t==this.state.overwrite||((this.state.overwrite=!this.state.overwrite)?A(this.display.cursorDiv,"CodeMirror-overwrite"):j(this.display.cursorDiv,"CodeMirror-overwrite"),gt(this,"overwriteToggle",this,this.state.overwrite))},hasFocus:function(){return this.display.input.getField()==D()},isReadOnly:function(){return!(!this.options.readOnly&&!this.doc.cantEdit)},scrollTo:ni((function(t,e){Ar(this,t,e)})),getScrollInfo:function(){var t=this.display.scroller;return{left:t.scrollLeft,top:t.scrollTop,height:t.scrollHeight-Tn(this)-this.display.barHeight,width:t.scrollWidth-Tn(this)-this.display.barWidth,clientHeight:En(this),clientWidth:Pn(this)}},scrollIntoView:ni((function(t,e){null==t?(t={from:this.doc.sel.primary().head,to:null},null==e&&(e=this.options.cursorScrollMargin)):"number"==typeof t?t={from:ee(t,0),to:null}:null==t.from&&(t={from:t,to:null}),t.to||(t.to=t.from),t.margin=e||0,null!=t.from.line?function(t,e){Lr(t),t.curOp.scrollToPos=e}(this,t):Nr(this,t.from,t.to,t.margin)})),setSize:ni((function(t,e){var n=this,r=function(t){return"number"==typeof t||/^\d+$/.test(String(t))?t+"px":t};null!=t&&(this.display.wrapper.style.width=r(t)),null!=e&&(this.display.wrapper.style.height=r(e)),this.options.lineWrapping&&zn(this);var i=this.display.viewFrom;this.doc.iter(i,this.display.viewTo,(function(t){if(t.widgets)for(var e=0;e<t.widgets.length;e++)if(t.widgets[e].noHScroll){fr(n,i,"widget");break}++i})),this.curOp.forceUpdate=!0,gt(this,"refresh",this)})),operation:function(t){return ti(this,t)},startOperation:function(){return Gr(this)},endOperation:function(){return Kr(this)},refresh:ni((function(){var t=this.display.cachedTextHeight;hr(this),this.curOp.forceUpdate=!0,Hn(this),Ar(this,this.doc.scrollLeft,this.doc.scrollTop),ui(this.display),(null==t||Math.abs(t-ir(this.display))>.5||this.options.lineWrapping)&&lr(this),gt(this,"refresh",this)})),swapDoc:ni((function(t){var e=this.doc;return e.cm=null,this.state.selectingText&&this.state.selectingText(),Ri(this,t),Hn(this),this.display.input.reset(),Ar(this,t.scrollLeft,t.scrollTop),this.curOp.forceScroll=!0,ln(this,"swapDoc",this,e),e})),phrase:function(t){var e=this.options.phrases;return e&&Object.prototype.hasOwnProperty.call(e,t)?e[t]:t},getInputField:function(){return this.display.input.getField()},getWrapperElement:function(){return this.display.wrapper},getScrollerElement:function(){return this.display.scroller},getGutterElement:function(){return this.display.gutters}},bt(t),t.registerHelper=function(e,r,i){n.hasOwnProperty(e)||(n[e]=t[e]={_global:[]}),n[e][r]=i},t.registerGlobalHelper=function(e,r,i,o){t.registerHelper(e,r,o),n[e]._global.push({pred:i,val:o})}}(Ea);var Ka="iter insert remove copy getEditor constructor".split(" ");for(var Ya in Do.prototype)Do.prototype.hasOwnProperty(Ya)&&z(Ka,Ya)<0&&(Ea.prototype[Ya]=function(t){return function(){return t.apply(this.doc,arguments)}}(Do.prototype[Ya]));return bt(Do),Ea.inputStyles={textarea:Ga,contenteditable:Ba},Ea.defineMode=function(t){Ea.defaults.mode||"null"==t||(Ea.defaults.mode=t),Ft.apply(this,arguments)},Ea.defineMIME=function(t,e){It[t]=e},Ea.defineMode("null",(function(){return{token:function(t){return t.skipToEnd()}}})),Ea.defineMIME("text/plain","null"),Ea.defineExtension=function(t,e){Ea.prototype[t]=e},Ea.defineDocExtension=function(t,e){Do.prototype[t]=e},Ea.fromTextArea=function(t,e){if((e=e?I(e):{}).value=t.value,!e.tabindex&&t.tabIndex&&(e.tabindex=t.tabIndex),!e.placeholder&&t.placeholder&&(e.placeholder=t.placeholder),null==e.autofocus){var n=D();e.autofocus=n==t||null!=t.getAttribute("autofocus")&&n==document.body}function r(){t.value=s.getValue()}var i;if(t.form&&(ht(t.form,"submit",r),!e.leaveSubmitMethodAlone)){var o=t.form;i=o.submit;try{var a=o.submit=function(){r(),o.submit=i,o.submit(),o.submit=a}}catch(t){}}e.finishInit=function(n){n.save=r,n.getTextArea=function(){return t},n.toTextArea=function(){n.toTextArea=isNaN,r(),t.parentNode.removeChild(n.getWrapperElement()),t.style.display="",t.form&&(pt(t.form,"submit",r),e.leaveSubmitMethodAlone||"function"!=typeof t.form.submit||(t.form.submit=i))}},t.style.display="none";var s=Ea((function(e){return t.parentNode.insertBefore(e,t.nextSibling)}),e);return s},function(t){t.off=pt,t.on=ht,t.wheelEventPixels=Oi,t.Doc=Do,t.splitLines=Dt,t.countColumn=F,t.findColumn=q,t.isWordChar=tt,t.Pass=B,t.signal=gt,t.Line=Ge,t.changeEnd=Ti,t.scrollbarModel=$r,t.Pos=ee,t.cmpPos=ne,t.modes=Rt,t.mimeModes=It,t.resolveMode=Vt,t.getMode=zt,t.modeExtensions=Ht,t.extendMode=Bt,t.copyState=Ut,t.startState=Wt,t.innerMode=$t,t.commands=na,t.keyMap=$o,t.keyName=Xo,t.isModifierKey=Ko,t.lookupKey=Go,t.normalizeKeyMap=qo,t.StringStream=qt,t.SharedTextMarker=Po,t.TextMarker=jo,t.LineWidget=Co,t.e_preventDefault=wt,t.e_stopPropagation=Ot,t.e_stop=Ct,t.addClass=A,t.contains=M,t.rmClass=j,t.keyNames=zo}(Ea),Ea.version="5.63.0",Ea}())},function(t,e,n){"use strict";n.r(e);var r=n(2),i=n.n(r),o=n(13);e["default"]=i.a.View.extend({initialize:function(t){this.config=t.config||{},this.pfx=this.config.stylePrefix||'',this.target=t.target||{},this.propTarget=t.propTarget||{},this.onChange=t.onChange,this.onInputRender=t.onInputRender||{},this.customValue=t.customValue||{},this.properties=[];var e=this.collection;this.listenTo(e,'add',this.addTo),this.listenTo(e,'reset',this.render)},addTo:function(t,e,n){this.add(t,null,n)},add:function(t,e){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},r=e||this.el,i=new t.typeView({model:t,name:t.get('name'),id:this.pfx+t.get('property'),target:this.target,propTarget:this.propTarget,onChange:this.onChange,onInputRender:this.onInputRender,config:this.config});'composite'!=t.get('type')&&(i.customValue=this.customValue),i.render();var a=i.el;this.properties.push(i),i.updateVisibility(),Object(o["b"])(r,a,n.at)},render:function(){var t=this,e=this.$el;this.clearItems();var n=document.createDocumentFragment();return this.collection.each((function(e){return t.add(e,n)})),e.empty(),e.append(n),e.attr('class',"".concat(this.pfx,"properties")),this},remove:function(){i.a.View.prototype.remove.apply(this,arguments),this.clearItems()},clearItems:function(){this.properties.forEach((function(t){return t.remove()})),this.properties=[]}})},function(t,e,n){"use strict";var r=n(0),i=n(2),o=n.n(i);e["a"]=o.a.View.extend({itemView:'',itemsView:'',itemType:'type',autoAdd:0,initialize:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},e=arguments.length>1?arguments[1]:void 0;this.config=e||t.config||{},this.autoAdd&&this.listenTo(this.collection,'add',this.addTo),this.items=[],this.init()},init:function(){},addTo:function(t){this.add(t)},itemViewNotFound:function(t){var e=this.config,n=this.ns,r=e.em,i="".concat(n?"[".concat(n,"]: "):'',"'").concat(t,"' type not found");r&&r.logWarning(i)},add:function(t,e){var n,i=this.config,o=this.reuseView,a=this.items,s=this.itemsView,c=void 0===s?{}:s,l=e||null,u=this.itemView,d=t.get(this.itemType);c[d]?u=c[d]:!d||c[d]||Object(r["includes"])(['button','checkbox','color','date','datetime-local','email','file','hidden','image','month','number','password','radio','range','reset','search','submit','tel','text','time','url','week'],d)||this.itemViewNotFound(d),n=t.view&&o?t.view:new u({model:t,config:i},i),a&&a.push(n);var h=n.render().el;l?l.appendChild(h):this.$el.append(h)},render:function(){var t=document.createDocumentFragment();return this.clearItems(),this.$el.empty(),this.collection.length&&this.collection.each((function(e){this.add(e,t)}),this),this.$el.append(t),this.onRender(),this},onRender:function(){},onRemoveBefore:function(){},onRemove:function(){},remove:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},e=this.items;this.onRemoveBefore(e,t),this.clearItems(),o.a.View.prototype.remove.apply(this,arguments),this.onRemove(e,t)},clearItems:function(){this.items}})},function(t,e,n){"use strict";var r=n(14),i=n.n(r),o=n(11),a=n.n(o),s=n(3),c=n.n(s),l=n(22),u=n.n(l),d=n(2),h=n.n(d),f=n(0),p=n(10),g=["at"];function v(t,e){var n=Object.keys(t);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(t);e&&(r=r.filter((function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable}))),n.push.apply(n,r)}return n}function m(t){for(var e=1;e<arguments.length;e++){var n=null!=arguments[e]?arguments[e]:{};e%2?v(Object(n),!0).forEach((function(e){c()(t,e,n[e])})):Object.getOwnPropertyDescriptors?Object.defineProperties(t,Object.getOwnPropertyDescriptors(n)):v(Object(n)).forEach((function(e){Object.defineProperty(t,e,Object.getOwnPropertyDescriptor(n,e))}))}return t}var y=function t(e){var n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:[],r=e||[];return r.forEach((function(e){n.push(e.getId()),t(e.components(),n)})),n},b=function t(e){var n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:[];return e.map((function(e){n.push(e.getId()),t(e.components(),n)})),n};e["a"]=h.a.Collection.extend({initialize:function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};this.opt=e,this.listenTo(this,'add',this.onAdd),this.listenTo(this,'remove',this.removeChildren),this.listenTo(this,'reset',this.resetChildren);var n=e.em,r=e.config;this.config=r,this.em=n,this.domc=e.domc||n&&n.get('DomComponents')},resetChildren:function(t){var e=this,n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},r=this,i=n.previousModels||[],o=i.filter((function(e){return!t.get(e.cid)})),a=b(t);n.keepIds=y(i).filter((function(t){return a.indexOf(t)>=0})),o.forEach((function(t){return e.removeChildren(t,r,n)})),t.each((function(t){return e.onAdd(t)}))},removeChildren:function(t,e){var n=this,r=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};if(t){var i=this.domc,o=this.em,a=i?i.allById():{},s=r.temporary;if(t.prevColl=this,!s){var c=t.getId(),l=o.get('SelectorManager').getAll(),u=o.get('CssComposer').getAll(),d=(r.keepIds||[]).indexOf(c)<0;delete a[c];var h=d?u.remove(u.filter((function(t){return t.getSelectors().getFullString()==="#".concat(c)})),r):[];l.remove(h.map((function(t){return t.getSelectors().at(0)}))),t.opt.temporary||(o.get('Commands').run('core:component-style-clear',{target:t}),t.removed(),t.trigger('removed'),o.trigger('component:remove',t));var f=t.components();f.forEach((function(t){return n.removeChildren(t,e,r)}))}var p=t.components();o.stopListening(p),o.stopListening(t),o.stopListening(t.get('classes')),t.__postRemove()}},model:function(t,e){var n,r=e.collection.opt,i=r.em,o=i.get('DomComponents').componentTypes;e.em=i,e.config=r.config,e.componentTypes=o,e.domc=r.domc;for(var a=0;a<o.length;a++){if(o[a].id==t.type){n=o[a].model;break}}return n||(n=o[o.length-1].model,i&&t.type&&i.logWarning("Component type '".concat(t.type,"' not found"),{attrs:t,options:e})),new n(t,e)},parseString:function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},n=this.em,r=this.domc,i=n.get('CssComposer'),o=n.get('Parser').parseHtml(t);if(p["a"].checkId(o.html,o.css,r.componentsById,e),o.css&&i&&!e.temporary){e.at;var a=u()(e,g);i.addCollection(o.css,m(m({},a),{},{extend:1}))}return o.html},add:function(t){var e=this,n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};this.parent;n.keepIds=y(n.previousModels),Object(f["isString"])(t)?t=this.parseString(t,n):Object(f["isArray"])(t)&&(t=a()(t)).forEach((function(r,i){if(Object(f["isString"])(r)){var o=e.parseString(r,n);t[i]=Object(f["isArray"])(o)&&!o.length?null:o}}));var r=Object(f["isArray"])(t);t=(r?t:[t]).filter((function(t){return t})).map((function(t){return e.processDef(t)})),t=r?Object(f["flatten"])(t,1):t[0];var i=h.a.Collection.prototype.add.apply(this,[t,n]);return this.__firstAdd=i,i},processDef:function(t){if(t.cid&&t.ccid)return t;var e=this.em,n=this.config,r=(void 0===n?{}:n).processor,o=t;if(r){var a=r(o=m({},o));a&&(Object(f["each"])(o,(function(t,e){return delete o[e]})),Object(f["extend"])(o,a))}if(o.$$typeof&&'object'==i()(o.props)){(o=m({},o)).props=m({},o.props);var s=e.get('DomComponents'),c=e.get('Parser').parserHtml;Object(f["each"])(o,(function(t,e){Object(f["includes"])(['props','type'],e)||delete o[e]}));var l=o.props,u=l.children;delete l.children,delete o.props;var d=c.splitPropsFromAttr(l);o.attributes=d.attrs,u&&(o.components=u),o.type?s.getType(o.type)||(o.tagName=o.type,delete o.type):o.type='textnode',Object(f["extend"])(o,d.props)}return o},onAdd:function(t,e){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},r=this.domc,i=this.em,o=t.getStyle(),a=i&&i.getConfig('avoidInlineStyle');if(r&&r.Component.ensureInList(t),!Object(f["isEmpty"])(o)&&!a&&i&&i.get&&i.getConfig('forceClass')&&!n.temporary){var s=t.cid;i.get('CssComposer').setClassRule(s,o);t.setStyle({}),t.addClass(s)}t.__postAdd({recursive:1}),this.__onAddEnd()},__onAddEnd:Object(f["debounce"])((function(){}))})},function(t,e,n){"use strict";n.r(e);var r=n(2);e["default"]=r["Model"].extend({initialize:function(t){this.config=t||{},this.editorModel=this.em=this.config.em||{},this.pfx=this.config.stylePrefix,this.ppfx=this.config.pStylePrefix,this.hoverClass=this.pfx+'hover',this.badgeClass=this.pfx+'badge',this.plhClass=this.pfx+'placeholder',this.freezClass=this.ppfx+'freezed',this.canvas=this.em.get&&this.em.get('Canvas'),this.init(this.config)},onFrameScroll:function(t){},getCanvas:function(){return this.canvas.getElement()},getCanvasBody:function(){return this.canvas.getBody()},getCanvasTools:function(){return this.canvas.getToolsEl()},offset:function(t){var e=t.getBoundingClientRect();return{top:e.top+t.ownerDocument.body.scrollTop,left:e.left+t.ownerDocument.body.scrollLeft}},init:function(t){},callRun:function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},n=this.id;if(t.trigger("run:".concat(n,":before"),e),!e||!e.abort){var r=e.sender||t,i=this.run(t,r,e);return t.trigger("run:".concat(n),i,e),t.trigger('run',n,i,e),i}t.trigger("abort:".concat(n),e)},callStop:function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},n=this.id,r=e.sender||t;t.trigger("stop:".concat(n,":before"),e);var i=this.stop(t,r,e);return t.trigger("stop:".concat(n),i,e),t.trigger('stop',n,i,e),i},stopCommand:function(){this.em.get('Commands').stop(this.id)},run:function(t,e){},stop:function(t,e){}})},function(t,e,n){"use strict";var r=n(3),i=n.n(r),o=n(0),a=n(1),s=n(44);function c(t,e){var n=Object.keys(t);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(t);e&&(r=r.filter((function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable}))),n.push.apply(n,r)}return n}function l(t){for(var e=1;e<arguments.length;e++){var n=null!=arguments[e]?arguments[e]:{};e%2?c(Object(n),!0).forEach((function(e){i()(t,e,n[e])})):Object.getOwnPropertyDescriptors?Object.defineProperties(t,Object.getOwnPropertyDescriptors(n)):c(Object(n)).forEach((function(e){Object.defineProperty(t,e,Object.getOwnPropertyDescriptor(n,e))}))}return t}var u=Object(s["a"])().parseStyle;e["a"]={parseStyle:u,extendStyle:function(t){return l(l({},this.getStyle()),t)},getStyle:function(t){var e=l({},this.get('style')||{});return t&&Object(o["isString"])(t)?e[t]:e},setStyle:function(){var t=this,e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};Object(o["isString"])(e)&&(e=u(e));var r=this.getStyle(n),i=l({},e);this.set('style',i,n);var s=Object(a["shallowDiff"])(r,i);return Object(o["keys"])(s).forEach((function(e){var n=t.em;t.trigger("change:style:".concat(e)),n&&(n.trigger("styleable:change",t,e),n.trigger("styleable:change:".concat(e),t,e))})),i},addStyle:function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:'',n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};'string'==typeof t?t={prop:e}:n=e||{},t=this.extendStyle(t),this.setStyle(t,n)},removeStyle:function(t){var e=this.getStyle();delete e[t],this.setStyle(e)},styleToString:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},e=[],n=this.getStyle(t);for(var r in n){var i=t.important,a=Object(o["isArray"])(i)?i.indexOf(r)>=0:i,s="".concat(n[r]).concat(a?' !important':''),c='__'==r.substr(0,2);s&&!c&&e.push("".concat(r,":").concat(s,";"))}return e.join('')},getSelectors:function(){return this.get('selectors')||this.get('classes')},getSelectorsString:function(){return this.selectorsToString?this.selectorsToString():this.getSelectors().getFullString()}}},function(t,e,n){"use strict";n.r(e);var r=n(3),i=n.n(r),o=n(2),a=n.n(o),s=n(38),c=n(5),l=n.n(c),u=n(6),d=n.n(u),h=n(8),f=n.n(h),p=n(9),g=n.n(p),v=n(4),m=n.n(v),y=n(0),b=n(1);function w(t,e){var n=Object.keys(t);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(t);e&&(r=r.filter((function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable}))),n.push.apply(n,r)}return n}function O(t){for(var e=1;e<arguments.length;e++){var n=null!=arguments[e]?arguments[e]:{};e%2?w(Object(n),!0).forEach((function(e){i()(t,e,n[e])})):Object.getOwnPropertyDescriptors?Object.defineProperties(t,Object.getOwnPropertyDescriptors(n)):w(Object(n)).forEach((function(e){Object.defineProperty(t,e,Object.getOwnPropertyDescriptor(n,e))}))}return t}function x(t){var e=function(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],(function(){}))),!0}catch(t){return!1}}();return function(){var n,r=m()(t);if(e){var i=m()(this).constructor;n=Reflect.construct(r,arguments,i)}else n=r.apply(this,arguments);return g()(this,n)}}var C=function(t){f()(n,t);var e=x(n);function n(){return l()(this,n),e.apply(this,arguments)}return d()(n,[{key:"initialize",value:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},r=this.get('id')||'',i=this.get('name')||'';!this.get('property')&&this.set('property',(i||r).replace(/ /g,'-'));var o=this.get('property');!this.get('id')&&this.set('id',o),!i&&this.set('name',Object(b["capitalize"])(o).replace(/-/g,' ')),n.callInit(this,t,e)}},{key:"init",value:function(){}},{key:"getId",value:function(){return this.get('id')}},{key:"getType",value:function(){return this.get('type')}},{key:"getName",value:function(){return this.get('property')}},{key:"getLabel",value:function(){return this.get('name')}},{key:"getValue",value:function(){var t=this.get('value');return Object(y["isUndefined"])(t)?this.getDefaultValue():t}},{key:"clearValue",value:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};return this.set({value:void 0,status:''},t),this}},{key:"setValue",value:function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:1,n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},r=this.parseValue(t),i=!e;!i&&this.set({value:void 0},{avoidStore:i,silent:!0}),this.set(r,O({avoidStore:i},n))}},{key:"setValueFromInput",value:function(t,e){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};this.setValue(t,e,O(O({},n),{},{fromInput:1}))}},{key:"parseValue",value:function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},n={value:t},r='!important';if(Object(y["isString"])(t)&&-1!==t.indexOf(r)&&(n.value=t.replace(r,'').trim(),n.important=1),!this.get('functionName')&&!e.complete)return n;var i=[],o="".concat(n.value),a=o.indexOf('(')+1,s=o.lastIndexOf(')'),c=o.substring(0,a-1);if(c&&(n.functionName=c),i.push(a),s>=0&&i.push(s),n.value=String.prototype.substring.apply(o,i),e.numeric){var l=parseFloat(n.value);n.unit=n.value.replace(l,''),n.value=l}return n}},{key:"splitValues",value:function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:',',n=[],r='(',i=')',o='',a=0;return(t||'').split('').forEach((function(t){t==r?(a++,o+=r):t==i&&a>0?(a--,o+=i):t===e&&0==a?(n.push(o),o=''):o+=t})),''!==o&&n.push(o),n.map((function(t){return t.trim()}))}},{key:"getDefaultValue",value:function(){return this.get('defaults')}},{key:"getFullValue",value:function(t){var e=this.get('functionName'),n=this.getDefaultValue(),r=Object(y["isUndefined"])(t)?this.get('value'):t,i=!Object(y["isUndefined"])(r)&&''!==r;if(r&&n&&r===n)return n;if(e&&i){var o='url'===e?"'".concat(r.replace(/'/g,''),"'"):r;r="".concat(e,"(").concat(o,")")}return i&&this.get('important')&&(r="".concat(r," !important")),r||''}}]),n}(o["Model"]);function k(t,e){var n=Object.keys(t);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(t);e&&(r=r.filter((function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable}))),n.push.apply(n,r)}return n}function S(t){for(var e=1;e<arguments.length;e++){var n=null!=arguments[e]?arguments[e]:{};e%2?k(Object(n),!0).forEach((function(e){i()(t,e,n[e])})):Object.getOwnPropertyDescriptors?Object.defineProperties(t,Object.getOwnPropertyDescriptors(n)):k(Object(n)).forEach((function(e){Object.defineProperty(t,e,Object.getOwnPropertyDescriptor(n,e))}))}return t}C.callParentInit=function(t,e,n){var r=arguments.length>3&&void 0!==arguments[3]?arguments[3]:{};t.prototype.initialize.apply(e,[n,O(O({},r),{},{skipInit:1})])},C.callInit=function(t,e){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};!n.skipInit&&t.init(e,n)},C.getDefaults=function(){return Object(y["result"])(this.prototype,'defaults')},C.prototype.defaults={name:'',property:'',type:'',defaults:'',info:'',value:'',icon:'',functionName:'',status:'',visible:!0,fixedValues:['initial','inherit'],full:0,important:0,toRequire:0,requires:null,requiresParent:null};var j=C.extend({defaults:S(S({},C.prototype.defaults),{},{detached:0,properties:[],separator:' '}),initialize:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};C.callParentInit(C,this,t,e);var r=this.get('properties')||[],i=n(33).default;this.set('properties',new i(r)),this.listenTo(this,'change:value',this.updateValues),C.callInit(this,t,e)},clearValue:function(){return this.get('properties').each((function(t){return t.clearValue()})),C.prototype.clearValue.apply(this,arguments)},updateValues:function(){var t=this.getFullValue().split(this.getSplitSeparator());this.get('properties').each((function(e,n){var r=t.length;t[n]||t[n%r+(1!=r&&r%2?1:0)]}))},getSplitSeparator:function(){return new RegExp("".concat(this.get('separator'),"(?![^\\(]*\\))"))},getDefaultValue:function(t){var e=this.get('defaults');return e&&!t?e:(e='',this.get('properties').each((function(t,n){return e+="".concat(t.getDefaultValue()," ")})),e.trim())},getFullValue:function(){return this.get('detached')?'':this.get('properties').getFullValue()},getPropertyAt:function(t){return this.get('properties').at(t)}}),T=a.a.Model.extend({defaults:{index:'',value:'',values:{},active:!1,preview:!1,properties:[]},initialize:function(){var t=this.get('properties'),e=this.get('value');this.set('properties',t instanceof Mt?t:new Mt(t));var n=this.get('properties');if(n.forEach(this.onPropAdd,this),this.listenTo(n,'add',this.onPropAdd),!e){var r='',i=this.get('values');for(var o in i)r+=' '+i[o];this.set('value',r.trim())}},onPropAdd:function(t){var e=this.collection;t.parent=e&&e.property},getPropertyAt:function(t){return this.get('properties').at(t)},getPropertyValue:function(t){var e='';return this.get('properties').each((function(n){n.get('property')==t&&(e=n.getFullValue())})),e},getFullValue:function(){var t=[];return this.get('properties').each((function(e){return t.push(e.getFullValue())})),t.join(' ').trim()}});function P(t,e){var n=Object.keys(t);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(t);e&&(r=r.filter((function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable}))),n.push.apply(n,r)}return n}function E(t){for(var e=1;e<arguments.length;e++){var n=null!=arguments[e]?arguments[e]:{};e%2?P(Object(n),!0).forEach((function(e){i()(t,e,n[e])})):Object.getOwnPropertyDescriptors?Object.defineProperties(t,Object.getOwnPropertyDescriptors(n)):P(Object(n)).forEach((function(e){Object.defineProperty(t,e,Object.getOwnPropertyDescriptor(n,e))}))}return t}var _=a.a.Collection.extend({model:T,initialize:function(){this.idx=1,this.on('add',this.onAdd),this.on('reset',this.onReset)},onAdd:function(t,e,n){n.noIncrement||t.set('index',this.idx++),n.active&&this.active(this.indexOf(t))},onReset:function(){this.idx=1},getSeparator:function(){var t=this.property;return t?t.get('layerSeparator'):', '},getLayersFromValue:function(t){var e=this,n=[];return t.replace(/\(([\w\s,.]*)\)/g,(function(e){var n=e.replace(/,\s*/g,',');t=t.replace(e,n)})),(t?t.split(this.getSeparator()):[]).forEach((function(t){n.push({properties:e.properties.parseValue(t)})})),n},getLayersFromStyle:function(t){var e=[],n=this.properties;return n.each((function(n){var r=t[n.get('property')];(r?r.split(', '):[]).forEach((function(t,r){t=n.parseValue(t.trim()).value;var i=e[r],o=E(E({},n.attributes),{value:t});i?i.properties.push(o):e[r]={properties:[o]}}))})),e.forEach((function(t){var e=t.properties.map((function(t){return t.property}));n.each((function(n){var r=n.get('property');e.indexOf(r)<0&&t.properties.push(E({},n.attributes))}))})),e},active:function(t){this.each((function(t){return t.set('active',0)}));var e=this.at(t);e&&e.set('active',1)},getFullValue:function(){var t=[];return this.each((function(e){return t.push(e.getFullValue())})),t.join(this.getSeparator())},getPropertyValues:function(t,e){var n=[];return this.each((function(r){var i=r.getPropertyValue(t);i?n.push(i):!Object(y["isUndefined"])(e)&&n.push(e)})),n.join(', ')}});function M(t,e){var n=Object.keys(t);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(t);e&&(r=r.filter((function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable}))),n.push.apply(n,r)}return n}function D(t){for(var e=1;e<arguments.length;e++){var n=null!=arguments[e]?arguments[e]:{};e%2?M(Object(n),!0).forEach((function(e){i()(t,e,n[e])})):Object.getOwnPropertyDescriptors?Object.defineProperties(t,Object.getOwnPropertyDescriptors(n)):M(Object(n)).forEach((function(e){Object.defineProperty(t,e,Object.getOwnPropertyDescriptor(n,e))}))}return t}var A=j.extend({defaults:D(D({},j.prototype.defaults),{},{layers:[],layerSeparator:', ',prepend:0,preview:0}),initialize:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};j.callParentInit(j,this,t,e);var n=this.get('layers'),r=new _(n);r.property=this,r.properties=this.get('properties'),this.set('layers',r),j.callInit(this,t,e)},getLayers:function(){return this.get('layers')},getCurrentLayer:function(){return this.getLayers().filter((function(t){return t.get('active')}))[0]},getFullValue:function(){return this.get('detached')?'':this.get('layers').getFullValue()},getValueFromStyle:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},e=this.getLayers().getLayersFromStyle(t);return new _(e).getFullValue()},clearValue:function(){return this.getLayers().reset(),j.prototype.clearValue.apply(this,arguments)},getValueFromTarget:function(t){var e=this.attributes,n=e.detached,r=e.property,i=e.properties,o=t.getStyle(),a={};return i.forEach((function(t){var e=t.get('property'),n=o[e];n&&(a[e]=n)})),n?Object(y["keys"])(a).length?a:'':o[r]},getLayersFromTarget:function(t){}}),L=n(22),N=n.n(L),R=["status","value"],I=["complete"];function F(t,e){var n=Object.keys(t);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(t);e&&(r=r.filter((function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable}))),n.push.apply(n,r)}return n}function V(t){for(var e=1;e<arguments.length;e++){var n=null!=arguments[e]?arguments[e]:{};e%2?F(Object(n),!0).forEach((function(e){i()(t,e,n[e])})):Object.getOwnPropertyDescriptors?Object.defineProperties(t,Object.getOwnPropertyDescriptors(n)):F(Object(n)).forEach((function(e){Object.defineProperty(t,e,Object.getOwnPropertyDescriptor(n,e))}))}return t}var z='data-clear-style',H='component:styleUpdate',B=a.a.View.extend({template:function(){var t=this.pfx,e=this.ppfx;return"\n      <div class=\"".concat(t,"label\" data-sm-label></div>\n      <div class=\"").concat(e,"fields\" data-sm-fields></div>\n    ")},templateLabel:function(t){var e=this.pfx,n=this.em,r=t.parent,i=t.attributes,o=i.icon,a=void 0===o?'':o,s=i.info,c=void 0===s?'':s,l=i.id,u=i.name,d=n&&n.t("styleManager.properties.".concat(l))||u;return"\n      <span class=\"".concat(e,"icon ").concat(a,"\" title=\"").concat(c,"\">\n        ").concat(d,"\n      </span>\n      ").concat(r?'':"<b class=\"".concat(e,"clear\" ").concat(z,">&Cross;</b>"),"\n    ")},templateInput:function(t){return"\n      <div class=\"".concat(this.ppfx,"field\">\n        <input placeholder=\"").concat(t.getDefaultValue(),"\"/>\n      </div>\n    ")},events:i()({change:'inputValueChanged'},"click [".concat(z,"]"),'clear'),initialize:function(){var t=this,e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};Object(y["bindAll"])(this,'targetUpdated','__change','__updateStyle'),this.config=e.config||{};var n=this.config.em;this.em=n,this.pfx=this.config.stylePrefix||'',this.ppfx=this.config.pStylePrefix||'',this.target=e.target||{},this.propTarget=e.propTarget||{},this.onChange=e.onChange,this.onInputRender=e.onInputRender||{},this.customValue=e.customValue||{};var r=this.model;this.property=r.get('property'),this.input=null;var i=this.pfx;if(this.inputHolderId='#'+i+'input-holder',this.sector=r.collection&&r.collection.sector,this.__destroyFn=this.destroy?this.destroy.bind(this):function(){},r.view=this,r.get('value')||r.set('value',r.getDefaultValue()),n){this.listenTo(n,"update:component:style:".concat(this.property),this.targetUpdated);var o=r.get('requires')||{};Object.keys(o).forEach((function(e){t.listenTo(n,"component:styleUpdate:".concat(e),t.targetUpdated)}))}this.listenTo(this.propTarget,'update',this.targetUpdated),this.listenTo(r,'destroy remove',this.remove),this.listenTo(r,'change:value',this.modelValueChanged),this.listenTo(r,'targetUpdated',this.targetUpdated),this.listenTo(r,'change:visible',this.updateVisibility),this.listenTo(r,'change:status',this.updateStatus),this.listenTo(r,'change:name change:className change:full',this.render);var a=this.init&&this.init.bind(this);a&&a()},remove:function(){var t=this;a.a.View.prototype.remove.apply(this,arguments),['em','target','input','$input','propTarget','sector'].forEach((function(e){return t[e]={}})),this.__destroyFn(this._getClbOpts())},updateStatus:function(){var t=this.model,e=t.get('status'),n=t.parent,r=this.pfx,i=this.ppfx,o=this.config,a="".concat(i,"four-color"),s="".concat(i,"color-warn"),c=this.$el.children(".".concat(r,"label")),l=this.getClearEl(),u=l?l.style:{};switch(c.removeClass("".concat(a," ").concat(s)),u.display='none',e){case'updated':!n&&c.addClass(a),o.clearProperties&&(u.display='inline');break;case'computed':c.addClass(s)}},clear:function(t){var e=this;t&&t.stopPropagation(),this.model.clearValue(),this.__unset(),setTimeout((function(){return e.targetUpdated()}))},getClearEl:function(){return this.clearEl||(this.clearEl=this.el.querySelector("[".concat(z,"]"))),this.clearEl},getTarget:function(){return this.getTargetModel()},getTargets:function(){return this.propTarget.targets||[this.getTarget()]},getFirstTarget:function(){return this.getTargets()[0]},getTargetModel:function(){return this.propTarget&&this.propTarget.model},getHelperModel:function(){return this.propTarget&&this.propTarget.helper},inputValueChanged:function(t){t&&t.stopPropagation(),this.emit||(this.model.setValueFromInput(this.getInputValue()),this.elementUpdated())},elementUpdated:function(){this.setStatus('updated')},setStatus:function(t){this.model.set('status',t);var e=this.model.parent;e&&'updated'==t&&e.set('status',t)},emitUpdateTarget:Object(y["debounce"])((function(){var t=this.config.em;t&&t.trigger('styleManager:update:target',this.getFirstTarget())})),_getTargetData:function(){var t=this.model,e=this.config,n=this.getTargetValue({ignoreDefault:1}),r=t.getDefaultValue(),i=this.getComputedValue(),o='',a='';return n?(o=n,e.highlightChanged&&(a='updated')):i&&e.showComputed&&i!=r?(o=i,e.highlightComputed&&(a='computed')):(o=r,a=''),{value:o,status:a,targetValue:n,defaultValue:r,computedValue:i}},targetUpdated:function(t,e){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};if(!this.config.fromLayer&&(this.emitUpdateTarget(),this.checkVisibility())){var r=this.config,i=r.em,o=this.model,a=o.get('property'),s=this._getTargetData(),c=s.status,l=s.value,u=N()(s,R),d=V({status:c,value:l},u);return this.setStatus(c),o.setValue(l,0,V({fromTarget:1},n)),this.__update(l),i&&(i.trigger('styleManager:change',this,a,l,d),i.trigger("styleManager:change:".concat(a),this,l,d),this._emitUpdate(d)),d}},_emitUpdate:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},e=this.em,n=this.model;if(e){var r=n.get('property'),i=V(V({},this._getEventData()),t),o=i.id;e.trigger('style:update',i),e.trigger("style:update:".concat(r),i),r!==o&&e.trigger("style:update:".concat(o),i)}},_getEventData:function(){var t=this.model;return{propertyView:this,targets:this.getTargets(),value:t.getFullValue(),property:t,id:t.get('id'),name:t.get('property')}},checkVisibility:function(){var t=1;return this.config.hideNotStylable&&(this.isTargetStylable()&&this.isComponentStylable()?this.show():(this.hide(),t=0),this.sector&&this.sector.trigger('updateVisibility')),t},getTargetValue:function(){var t,e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},n=this.model,r=this.getFirstTarget(),i=this.customValue;if(!r)return t;if((t=r.getStyle()[n.get('property')])||e.ignoreDefault||(t=n.getDefaultValue()),'function'==typeof i&&!e.ignoreCustomValue){var o=n.collection.indexOf(n),a=i(this,o,t);a&&(t=a)}return t},getComputedValue:function(){var t=this.propTarget,e=t.computed||{},n=t.computedDefault||{},r=this.config.avoidComputed||[],i=this.model.get('property'),o=r.indexOf(i)<0,a=e[i],s=n[Object(b["camelCase"])(i)];return e&&o&&s!==a&&a||''},getInputValue:function(){var t=this.getInputEl();return t?t.value:''},modelValueChanged:function(t,e){var n=this,r=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},o=this.model,a=o.getFullValue();if(r.fromInput||this.setValue(a),!r.fromTarget){this.getTargets().forEach((function(t){return n.__updateTarget(t,r)}));var s=this.config.em;if(!s)return;var c=o.get('property'),l=i()({},c,a);s.getSelectedAll().forEach((function(t){!r.noEmit&&s.trigger('component:update',t,l,r),s.trigger(H,t,c,r),s.trigger("".concat(H,":").concat(c),t,a,r),t.trigger("change:style",t,l,r),t.trigger("change:style:".concat(c),t,a,r)}))}},__updateTarget:function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},n=this.model,r=n.getFullValue(),i=this.onChange;t&&this.isComponentStylable()&&(e.fromTarget||(i&&!e.fromParent?i(t,this,e):this.updateTargetStyle(r,null,V(V({},e),{},{target:t}))),this._emitUpdate())},updateTargetStyle:function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:'',n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},r=e||this.model.get('property'),i=n.target||this.getFirstTarget(),o=i.getStyle();t?o[r]=t:delete o[r],n.avoidStore?o.__=1:delete o.__,i.setStyle(o,n);var a=this.getHelperModel();a&&a.setStyle(o,n)},isTargetStylable:function(t){var e=t||this.getFirstTarget(),n=this.model,r=n.get('id'),i=n.get('property'),o=n.get('toRequire'),a=e.get('unstylable'),s=e.get('stylable-require'),c=n.get('requires'),l=n.get('requiresParent'),u=this.sector?this.sector.collection:null,d=this.em?this.em.getSelected():null,h=e.get('stylable');if(Object(y["isArray"])(h)&&(h=h.indexOf(i)>=0),Object(y["isArray"])(a)&&(h=a.indexOf(i)<0),o&&(h=!t||s&&(s.indexOf(r)>=0||s.indexOf(i)>=0)),u&&c){var f=Object.keys(c);u.each((function(t){t.get('properties').each((function(t){if(Object(y["includes"])(f,t.id)){var e=c[t.id];h=h&&Object(y["includes"])(e,t.get('value'))}}))}))}if(l){var p=d&&d.parent(),g=p&&p.getEl();if(g){var v=window.getComputedStyle(g);Object(y["each"])(l,(function(t,e){h=h&&v[e]&&Object(y["includes"])(t,v[e])}))}else h=!1}return h},isComponentStylable:function(){var t=this.em,e=t&&t.getSelected();return!e||this.isTargetStylable(e)},setRawValue:function(t){this.setValue(this.model.parseValue(t))},setValue:function(t){var e=this.model,n=Object(y["isUndefined"])(t)?e.getDefaultValue():t;if(this.update)return this.__update(n);var r=this.getInputEl();r&&(r.value=n)},getInputEl:function(){return this.input||(this.input=this.el.querySelector('input')),this.input},updateVisibility:function(){this.el.style.display=this.model.get('visible')?'':'none'},show:function(){this.model.set('visible',1)},hide:function(){this.model.set('visible',0)},cleanValue:function(){this.setValue('')},clearCached:function(){this.clearEl=null,this.input=null,this.$input=null},__unset:function(){var t=this.unset&&this.unset.bind(this);t&&t(this._getClbOpts())},__update:function(t){var e=this.update&&this.update.bind(this);e&&e(V(V({},this._getClbOpts()),{},{value:t}))},__change:function(){for(var t=this.emit&&this.emit.bind(this),e=arguments.length,n=new Array(e),r=0;r<e;r++)n[r]=arguments[r];t&&t.apply(void 0,[this._getClbOpts()].concat(n))},__updateStyle:function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},n=e.complete,r=N()(e,I),i=this.em,o=this.model,a=o.get('property'),s=!1!==n;Object(b["isObject"])(t)?this.getTargets().forEach((function(e){e.addStyle(t,{avoidStore:!s}),i&&i.trigger(H,e,a,r)})):o.setValueFromInput(t,n,r),s&&this.elementUpdated()},_getClbOpts:function(){var t=this.model,e=this.el,n=this.createdEl,r=this.propTarget,i=t.get('property'),o=r.computed||{},a=r.parentRules||[],s=Object(b["find"])(a,(function(t){return!!t.getStyle()[i]}));return{el:e,createdEl:n,props:t.attributes,setProps:function(){return t.set.apply(t,arguments)},change:this.__change,updateStyle:this.__updateStyle,targets:this.getTargets(),target:this.getFirstTarget(),computed:o,parentRules:a,parentRule:s}},render:function(){this.clearCached();var t=this.pfx,e=this.model,n=this.el,r=this.$el,i=e.get('property'),o=e.get('full'),a=e.get('className')||'',s="".concat(t,"property");this.createdEl&&this.__destroyFn(this._getClbOpts()),r.empty().append(this.template(e)),r.find('[data-sm-label]').append(this.templateLabel(e));var c=this.create&&this.create.bind(this);this.createdEl=c&&c(this._getClbOpts()),r.find('[data-sm-fields]').append(this.createdEl||this.templateInput(e)),n.className="".concat(s," ").concat(t).concat(e.get('type')," ").concat(s,"__").concat(i," ").concat(a).trim(),n.className+=o?" ".concat(s,"--full"):'',this.updateStatus();var l=this.onRender&&this.onRender.bind(this);l&&l(),this.setValue(e.get('value'),{fromTarget:1})}});function U(t,e){var n=Object.keys(t);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(t);e&&(r=r.filter((function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable}))),n.push.apply(n,r)}return n}function $(t){for(var e=1;e<arguments.length;e++){var n=null!=arguments[e]?arguments[e]:{};e%2?U(Object(n),!0).forEach((function(e){i()(t,e,n[e])})):Object.getOwnPropertyDescriptors?Object.defineProperties(t,Object.getOwnPropertyDescriptors(n)):U(Object(n)).forEach((function(e){Object.defineProperty(t,e,Object.getOwnPropertyDescriptor(n,e))}))}return t}var W=a.a.$,q=B.extend({templateInput:function(){var t=this.pfx;return"\n      <div class=\"".concat(t,"field ").concat(t,"composite\">\n        <span id=\"").concat(t,"input-holder\"></span>\n      </div>\n    ")},inputValueChanged:function(){if(!this.model.get('detached')){for(var t=arguments.length,e=new Array(t),n=0;n<t;n++)e[n]=arguments[n];B.prototype.inputValueChanged.apply(this,e)}},clear:function(t){var e=this.properties;e&&e.forEach((function(t){return t.clear()})),B.prototype.clear.apply(this,arguments)},remove:function(){var t=this;this.model.get('properties').reset(),B.prototype.remove.apply(this,arguments),['properties','props','$props'].forEach((function(e){return t[e]={}}))},onRender:function(){var t=this.model,e=t.get('properties')||[];if(this.properties=[],e.length&&(this.$input||(this.$input=W('<input type="hidden" value="0">'),this.input=this.$input.get(0)),this.props||(this.props=t.get('properties')),!this.$props)){this.props.each((function(e,n){e&&'composite'==e.get('type')&&(this.props.remove(e),console.warn('Nested composite types not yet allowed.')),e.parent=t}),this);var r=new(0,n(28).default)(this.getPropsConfig());this.$props=r.render().$el,this.properties=r.properties,this.$el.find("#".concat(this.pfx,"input-holder")).append(this.$props)}},getPropsConfig:function(t){var e=this,n=this.model,r={config:$($({},this.config),{},{highlightComputed:0}),collection:this.props,target:this.target,propTarget:this.propTarget,onChange:function(t,e,r){n.set('value',n.getFullValue(),r)},customValue:function(t,n){return e.valueOnIndex(n,t)}};return n.get('detached')&&delete r.onChange,r},valueOnIndex:function(t,e){var n,r=this.getTargetValue({ignoreDefault:1});r?n=r.split(this.model.getSplitSeparator())[t]:n=e&&e.getTargetValue({ignoreCustomValue:1,ignoreDefault:1});return n},clearCached:function(){B.prototype.clearCached.apply(this,arguments),this.$input=null,this.props=null,this.$props=null}}),G=n(28);function K(t,e){var n=Object.keys(t);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(t);e&&(r=r.filter((function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable}))),n.push.apply(n,r)}return n}function Y(t){for(var e=1;e<arguments.length;e++){var n=null!=arguments[e]?arguments[e]:{};e%2?K(Object(n),!0).forEach((function(e){i()(t,e,n[e])})):Object.getOwnPropertyDescriptors?Object.defineProperties(t,Object.getOwnPropertyDescriptors(n)):K(Object(n)).forEach((function(e){Object.defineProperty(t,e,Object.getOwnPropertyDescriptor(n,e))}))}return t}var X=a.a.View.extend({events:{click:'active','click [data-close-layer]':'removeItem','mousedown [data-move-layer]':'initSorter','touchstart [data-move-layer]':'initSorter'},template:function(t){var e=this.pfx,n=this.ppfx,r=this.em,i="".concat(r&&r.t('styleManager.layer')," ").concat(t.get('index'));return"\n      <div id=\"".concat(e,"move\" class=\"").concat(n,"no-touch-actions\" data-move-layer>\n        <i class=\"fa fa-arrows\"></i>\n      </div>\n      <div id=\"").concat(e,"label\">").concat(i,"</div>\n      <div id=\"").concat(e,"preview-box\">\n      \t<div id=\"").concat(e,"preview\" data-preview></div>\n      </div>\n      <div id=\"").concat(e,"close-layer\" class=\"").concat(e,"btn-close\" data-close-layer>\n        &Cross;\n      </div>\n      <div id=\"").concat(e,"inputs\" data-properties></div>\n      <div style=\"clear:both\"></div>\n    ")},initialize:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},e=this.model;this.stackModel=t.stackModel,this.config=t.config||{},this.em=this.config.em,this.pfx=this.config.stylePrefix||'',this.ppfx=this.config.pStylePrefix||'',this.sorter=t.sorter||null,this.propsConfig=t.propsConfig||{},this.customPreview=t.onPreview,this.listenTo(e,'destroy remove',this.remove),this.listenTo(e,'change:active',this.updateVisibility),this.listenTo(e.get('properties'),'change',this.updatePreview),e.view=this,e.set({droppable:0,draggable:1}),this.$el.data('model',e)},initSorter:function(t){this.sorter&&this.sorter.startSort(this.el)},removeItem:function(t){t&&t.stopPropagation(),this.remove()},remove:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},e=this.model,n=this.props,r=e.collection,i=this.stackModel;a.a.View.prototype.remove.apply(this,arguments),r&&r.contains(e)&&r.remove(e),i&&i.set&&(i.set({stackIndex:null},{silent:!0}),!t.fromTarget&&i.trigger('updateValue')),n&&n.remove()},onPreview:function(t){var e=this.stackModel,n=e&&e.get('detached'),r=t.split(' '),i=3,o=[],a={};return this.model.get('properties').each((function(t,e){var s=t.get('property'),c=n?t.getFullValue():r[e]||'';if(c&&'integer'==t.get('type')){var l=parseInt(c,10),u=c.replace(l,'');c=(l=(l=(l=isNaN(l)?0:l)>i?i:l)<-i?-i:l)+u}o.push(c),a[s]=c})),n?a:o.join(' ')},updatePreview:function(){var t=this.stackModel,e=this.customPreview,n=this.getPreviewEl(),r=this.model.getFullValue(),i=e?e(r):this.onPreview(r);if(i&&t&&n){var o=n.style;if(Object(y["isString"])(i))o[t.get('property')]=i;else{var a=[];Object(y["each"])(i,(function(t,e){return a.push("".concat(e,":").concat(t))})),n.setAttribute('style',a.join(';'))}}},getPropertiesWrapper:function(){return this.propsWrapEl||(this.propsWrapEl=this.el.querySelector('[data-properties]')),this.propsWrapEl},getPreviewEl:function(){return this.previewEl||(this.previewEl=this.el.querySelector('[data-preview]')),this.previewEl},active:function(){var t=this.model,e=t.collection;e.active(e.indexOf(t))},updateVisibility:function(){var t=this.pfx,e=this.getPropertiesWrapper(),n=this.model.get('active');e.style.display=n?'':'none',this.$el[n?'addClass':'removeClass']("".concat(t,"active"))},render:function(){var t=this.propsConfig,e=this.model,n=this.el,r=this.pfx,i=e.get('preview'),o=new G["default"]({collection:e.get('properties'),config:Y(Y({},this.config),{},{fromLayer:1}),target:t.target,customValue:t.customValue,propTarget:t.propTarget,onChange:t.onChange}),a=o.render().el;return n.innerHTML=this.template(e),n.className="".concat(r,"layer").concat(i?'':" ".concat(r,"no-preview")),this.props=o,this.getPropertiesWrapper().appendChild(a),this.updateVisibility(),this.updatePreview(),this}}),J=a.a.View.extend({initialize:function(t){this.config=t.config||{},this.stackModel=t.stackModel,this.preview=t.preview,this.pfx=this.config.stylePrefix||'',this.ppfx=this.config.pStylePrefix||'',this.propsConfig=t.propsConfig;var e=this.pfx,n=this.ppfx,r=this.collection;this.className="".concat(e,"layers ").concat(n,"field"),this.listenTo(r,'add',this.addTo),this.listenTo(r,'deselectAll',this.deselectAll),this.listenTo(r,'reset',this.reset),this.items=[];var i=this.config.em||'',o=i?i.get('Utils'):'';this.sorter=o?new o.Sorter({container:this.el,ignoreViewChildren:1,containerSel:".".concat(e,"layers"),itemSel:".".concat(e,"layer"),pfx:this.config.pStylePrefix}):'',r.view=this,this.$el.data('model',r),this.$el.data('collection',r)},addTo:function(t){var e=this.collection.indexOf(t);this.addToCollection(t,null,e)},addToCollection:function(t,e,n){var r=e||null,i=this.stackModel,o=this.config,a=this.sorter,s=this.propsConfig;void 0!==this.preview&&t.set('preview',this.preview);var c=new X({model:t,config:o,sorter:a,stackModel:i,propsConfig:s}),l=c.render().el;if(this.items.push(c),r)r.appendChild(l);else if(void 0!==n){var u='before';this.$el.children().length==n&&(n--,u='after'),n<0?this.$el.append(l):this.$el.children().eq(n)[u](l)}else this.$el.append(l);return l},deselectAll:function(){this.$el.find('.'+this.pfx+'layer').removeClass(this.pfx+'active')},reset:function(t,e){this.clearItems(e),this.render()},render:function(){var t=document.createDocumentFragment();return this.$el.empty(),this.collection.each((function(e){this.addToCollection(e,t)}),this),this.$el.append(t),this.$el.attr('class',this.className),this.sorter&&(this.sorter.plh=null),this},remove:function(){this.clearItems(),a.a.View.prototype.remove.apply(this,arguments)},clearItems:function(t){this.items.forEach((function(e){return e.remove(t)})),this.items=[]}});function Z(t,e){var n=Object.keys(t);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(t);e&&(r=r.filter((function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable}))),n.push.apply(n,r)}return n}var Q=new(n(39)["a"]),tt=q.extend({templateInput:function(){var t=this.pfx;this.ppfx;return"\n      <div class=\"".concat(t,"field ").concat(t,"stack\">\n        <button type=\"button\" id=\"").concat(t,"add\" data-add-layer>+</button>\n        <div data-layers-wrapper></div>\n      </div>\n    ")},init:function(){var t=this.model;this.pfx;t.set('stackIndex',null),this.events["click [data-add-layer]"]='addLayer',this.listenTo(t,'change:stackIndex',this.indexChanged),this.listenTo(t,'updateValue',this.inputValueChanged),this.delegateEvents();var e=this.getPropsConfig();this.layers=new J({collection:this.getLayers(),stackModel:t,preview:t.get('preview'),config:this.config,propsConfig:e});var r=n(28).default;this.propsView=new r({target:this.target,collection:t.get('properties'),stackModel:t,config:this.config,onChange:e.onChange,propTarget:e.propTarget})},targetUpdated:function(){var t,e=this;if(this.model.get('detached'))t=this._getTargetData(),this.setStatus(t.status),this.checkVisibility();else{for(var n=arguments.length,r=new Array(n),i=0;i<n;i++)r[i]=arguments[i];t=q.prototype.targetUpdated.apply(this,r)}setTimeout((function(){return e.refreshLayers(t)}))},getLayers:function(){return this.model.get('layers')},indexChanged:function(t){var e=this.model;this.getLayers().active(e.get('stackIndex'))},addLayer:function(){var t=this.model,e=this.getLayers(),n=t.get('prepend'),r=t.get('properties').deepClone();r.each((function(t){return t.set('value','')}));var o=e.add({properties:r},function(t){for(var e=1;e<arguments.length;e++){var n=null!=arguments[e]?arguments[e]:{};e%2?Z(Object(n),!0).forEach((function(e){i()(t,e,n[e])})):Object.getOwnPropertyDescriptors?Object.defineProperties(t,Object.getOwnPropertyDescriptors(n)):Z(Object(n)).forEach((function(e){Object.defineProperty(t,e,Object.getOwnPropertyDescriptor(n,e))}))}return t}({active:1},n&&{at:0}));this.inputValueChanged({up:1}),t.set('stackIndex',e.indexOf(o))},inputValueChanged:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},e=this.model;t.up&&this.elementUpdated(),e.get('detached')?e.get('properties').each((function(t){return t.trigger('change:value')})):e.set('value',this.getLayerValues())},setValue:function(){},getLayerValues:function(){return this.getLayers().getFullValue()},_getClassRule:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},e=this.em,n=t.skipAdd,r=void 0===n?1:n,i=e.getSelected(),o=e.get('StyleManager').getModelToStyle(i,{skipAdd:r,useClasses:1});return o!==i&&o},_getParentTarget:function(t){for(var e,n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},r=this.em,i=this.model,o=i.get('property'),a=n.isValid||function(t){return t.getStyle()[o]},s=r.get('CssComposer').getAll().filter((function(e){return e.selectorsToString()===t.getSelectorsString()})),c=s.reduce((function(t,e){return t[e.getAtRule()]=e,t}),{}),l=Q.sortMediaObject(c),u=l.map((function(t){return t.value})),d=u.indexOf(t),h=u.splice(0,d),f=h.length-1;f>-1;f--){var p=h[f];if(a(p)){e=p;break}}return e},refreshLayers:function(){var t,e,n,r,i,o,a=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},s=[],c=this.model,l=this.em,u=this.getLayers(),d=c.get('detached'),h=c.get('property'),f=this.getFirstTarget(),p=this.getComputedValue(),g=l.getSelected(),v={fromTarget:1};if(d){e=a.targetValue||{};var m=function(t){var e=c.get('properties').at(0).get('property');return t&&!Object(y["isUndefined"])(t.getStyle()[e])};if(!Object(y["keys"])(e).length&&p&&g){var b={isValid:function(t){return m(t)}};(r=this._getParentTarget(f,b))?e=r.getStyle():(n=this._getClassRule(),r=!(i=m(n)&&n.getStyle())&&this._getParentTarget(this._getClassRule({skipAdd:0}),b),o=m(r)&&r.getStyle(),e=i||o||{})}t=e,s=u.getLayersFromStyle(e)}else{var w=this.getTargetValue({ignoreDefault:1}),O=w;!O&&p&&((r=this._getParentTarget(f))?O=r.getStyle()[h]:(o=(r=!(i=(n=this._getClassRule())&&n.getStyle()[h])&&this._getParentTarget(this._getClassRule({skipAdd:0})))&&r.getStyle()[h],O=i||o||p)),t=O=O==c.getDefaultValue()?'':O,s=u.getLayersFromValue(O)}var x=c.getLayersFromTarget(f,{resultValue:t,layersObj:s})||s;u.reset(null,v),u.add(x,v),c.set({stackIndex:null},{silent:!0})},getTargetValue:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},e=this.model,n=e.attributes.detached,r=this.getFirstTarget(),i=q.prototype.getTargetValue.call(this,t);return Object(y["isUndefined"])(i)&&!n?i=e.getValueFromStyle(r.getStyle()):n&&(i=e.getValueFromTarget(r)),i},getPropsConfig:function(){var t=this,e=t.model;return{target:t.target,propTarget:t.propTarget,onChange:function(n,r,o){var a=r.model,s=e.get('status');if(e.get('detached')){var c=a.get('property'),l=a.getDefaultValue(),u=t.getLayers(),d=u.getPropertyValues(c,l);r.updateTargetStyle(d,null,o),'background-image'!=c||o.avoidStore||'computed'!=s||e.get('properties').filter((function(t){return'__'==t.get('property').substr(0,2)})).forEach((function(e){var n=e.get('property'),r=u.getPropertyValues(n,e.getDefaultValue());t.getTargets().forEach((function(t){return t.addStyle(i()({},n,r),o)}))}))}else if('updated'==s){var h=e.getFullValue();e.set('value',h,o),!h&&r.updateTargetStyle(h,null,o)}}}},onRender:function(){var t=this.el,e=this.layers,n=this.propsView,r=t.querySelector('[data-layers-wrapper]');n.render(),r.appendChild(e.render().el)}}),et=a.a.$,nt=B.extend({templateInput:function(){var t=this.pfx,e=this.em;return"\n    <div class=\"".concat(t,"field ").concat(t,"file\">\n      <div id='").concat(t,"input-holder'>\n        <div class=\"").concat(t,"btn-c\">\n          <button class=\"").concat(t,"btn\" id=\"").concat(t,"images\" type=\"button\">\n            ").concat(e.t('styleManager.fileButton'),"\n          </button>\n        </div>\n        <div style=\"clear:both;\"></div>\n      </div>\n      <div id=\"").concat(t,"preview-box\">\n        <div id=\"").concat(t,"preview-file\"></div>\n        <div id=\"").concat(t,"close\">&Cross;</div>\n      </div>\n    </div>\n    ")},init:function(){var t=this.em;this.modal=t.get('Modal'),this.am=t.get('AssetManager'),this.events['click #'+this.pfx+'close']='removeFile',this.events['click #'+this.pfx+'images']='openAssetManager',this.delegateEvents()},onRender:function(){if(!this.$input){var t=this.model.getDefaultValue();this.$input=et("<input placeholder=\"".concat(t,"\">"))}this.$preview||(this.$preview=this.$el.find('#'+this.pfx+'preview-file')),this.$previewBox||(this.$previewBox=this.$el.find('#'+this.pfx+'preview-box')),this.setValue(this.componentValue,0)},clearCached:function(){B.prototype.clearCached.apply(this,arguments),this.$preview=null,this.$previewBox=null},setValue:function(t,e){B.prototype.setValue.apply(this,arguments),this.setPreviewView(t&&t!=this.model.getDefaultValue()),this.setPreview(t)},setPreviewView:function(t){var e=this.$previewBox;e&&e[t?'addClass':'removeClass']("".concat(this.pfx,"show")),e&&e.css({display:t?'block':'none'})},spreadUrl:function(t){this.model.set('value',t),this.setPreviewView(1)},setPreview:function(t){var e=this.$preview;t=t&&t.indexOf('url(')<0?"url(".concat(t,")"):t,e&&e.css('background-image',t)},cleanValue:function(){this.setPreviewView(0),this.model.set({value:''},{silent:!0})},removeFile:function(){this.model.set('value',this.model.getDefaultValue());for(var t=arguments.length,e=new Array(t),n=0;n<t;n++)e[n]=arguments[n];B.prototype.cleanValue.apply(this,e),this.setPreviewView(0)},openAssetManager:function(){var t=this,e=this.em,n=e&&e.get('AssetManager');n&&n.open({select:function(e,r){var i;i=e,t.spreadUrl(Object(y["isString"])(i)?i:i.get('src')),r&&n.close()},target:this.getTargetModel(),types:['image'],accept:'image/*'})}}),rt=a.a.$,it=B.extend({templateInput:function(){return''},init:function(){var t=this.model;this.listenTo(t,'change:unit',this.modelValueChanged),this.listenTo(t,'el:change',this.elementUpdated),this.listenTo(t,'change:units',this.render)},setValue:function(t){var e=this.model.parseValue(t);t="".concat(e.value).concat(e.unit),this.inputInst.setValue(t,{silent:1})},onRender:function(){var t=this.ppfx;if(!this.input){var e=this.model.input;e.ppfx=t,e.render(),this.el.querySelector(".".concat(t,"fields")).appendChild(e.el),this.$input=e.inputEl,this.unit=e.unitEl,this.$unit=rt(this.unit),this.input=this.$input.get(0),this.inputInst=e}},clearCached:function(){B.prototype.clearCached.apply(this,arguments),this.unit=null,this.$unit=null}}),ot=n(45);function at(t,e){var n=Object.keys(t);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(t);e&&(r=r.filter((function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable}))),n.push.apply(n,r)}return n}function st(t){for(var e=1;e<arguments.length;e++){var n=null!=arguments[e]?arguments[e]:{};e%2?at(Object(n),!0).forEach((function(e){i()(t,e,n[e])})):Object.getOwnPropertyDescriptors?Object.defineProperties(t,Object.getOwnPropertyDescriptors(n)):at(Object(n)).forEach((function(e){Object.defineProperty(t,e,Object.getOwnPropertyDescriptor(n,e))}))}return t}var ct=it.extend({setValue:function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};e=st(st({},e),{},{silent:1}),this.inputInst.setValue(t,e)},remove:function(){var t=this;it.prototype.remove.apply(this,arguments);var e=this.inputInst;e&&e.remove&&e.remove(),['inputInst','$color'].forEach((function(e){return t[e]={}}))},onRender:function(){if(!this.input){var t=this.ppfx,e=new ot["a"]({target:this.target,model:this.model,ppfx:t}).render();this.el.querySelector(".".concat(t,"fields")).appendChild(e.el),this.$input=e.inputEl,this.$color=e.colorEl,this.input=this.$input.get(0),this.inputInst=e}}}),lt=n(11),ut=n.n(lt);function dt(t,e){var n=Object.keys(t);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(t);e&&(r=r.filter((function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable}))),n.push.apply(n,r)}return n}function ht(t){for(var e=1;e<arguments.length;e++){var n=null!=arguments[e]?arguments[e]:{};e%2?dt(Object(n),!0).forEach((function(e){i()(t,e,n[e])})):Object.getOwnPropertyDescriptors?Object.defineProperties(t,Object.getOwnPropertyDescriptors(n)):dt(Object(n)).forEach((function(e){Object.defineProperty(t,e,Object.getOwnPropertyDescriptor(n,e))}))}return t}var ft=C.extend({defaults:function(){return ht(ht({},C.prototype.defaults),{},{options:[],full:1})},initialize:function(){for(var t=arguments.length,e=new Array(t),n=0;n<t;n++)e[n]=arguments[n];C.prototype.initialize.apply(this,e),this.listenTo(this,'change:options',this.onOptionChange)},onOptionChange:function(){this.set('list',this.get('options'))},getOptions:function(){var t=this.attributes,e=t.options,n=t.list;return e&&e.length?e:n},setOptions:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:[];return this.set('options',t),this},addOption:function(t){if(t){var e=this.getOptions();this.setOptions([].concat(ut()(e),[t]))}return this}});function pt(t,e){var n=Object.keys(t);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(t);e&&(r=r.filter((function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable}))),n.push.apply(n,r)}return n}function gt(t){for(var e=1;e<arguments.length;e++){var n=null!=arguments[e]?arguments[e]:{};e%2?pt(Object(n),!0).forEach((function(e){i()(t,e,n[e])})):Object.getOwnPropertyDescriptors?Object.defineProperties(t,Object.getOwnPropertyDescriptors(n)):pt(Object(n)).forEach((function(e){Object.defineProperty(t,e,Object.getOwnPropertyDescriptor(n,e))}))}return t}var vt=ft.extend({defaults:function(){return gt(gt({},ft.prototype.defaults()),{},{full:0})}}),mt=(a.a.$,B.extend({templateInput:function(){var t=this.pfx,e=this.ppfx;return"\n      <div class=\"".concat(e,"field ").concat(e,"select\">\n        <span id=\"").concat(t,"input-holder\"></span>\n        <div class=\"").concat(e,"sel-arrow\">\n          <div class=\"").concat(e,"d-s-arrow\"></div>\n        </div>\n      </div>\n    ")},initialize:function(){for(var t=arguments.length,e=new Array(t),n=0;n<t;n++)e[n]=arguments[n];B.prototype.initialize.apply(this,e),this.listenTo(this.model,'change:options',this.updateOptions)},updateOptions:function(){this.input=null,this.onRender()},onRender:function(){var t=this.pfx,e=this.model.getOptions();if(!this.input){var n='';e.forEach((function(t){var e=t.name||t.value,r=t.style?t.style.replace(/"/g,'&quot;'):'',i=r?"style=\"".concat(r,"\""):'',o=t.value.replace(/"/g,'&quot;');n+="<option value=\"".concat(o,"\" ").concat(i,">").concat(e,"</option>")}));var r=this.el.querySelector("#".concat(t,"input-holder"));r.innerHTML="<select>".concat(n,"</select>"),this.input=r.firstChild}}})),yt=B.extend({templateInput:function(){this.pfx;var t=this.ppfx;return"\n      <div class=\"".concat(t,"field ").concat(t,"field-radio\">\n      </div>\n    ")},onRender:function(){var t=this.pfx,e=this.ppfx,n="".concat(e,"radio-item-label"),r=this.model,i=r.get('property'),o=r.get('list')||r.get('options')||[],a=r.cid,s="".concat(t,"radio ").concat(t,"radio-").concat(i);if(!this.input&&o&&o.length){var c='';o.forEach((function(r){var o=r.className?"".concat(r.className," ").concat(t,"icon ").concat(n):'',l="".concat(i,"-").concat(r.value,"-").concat(a),u=r.name||r.value,d=r.title?"title=\"".concat(r.title,"\""):'';c+="\n            <div class=\"".concat(e,"radio-item\">\n              <input type=\"radio\" class=\"").concat(s,"\" id=\"").concat(l,"\" name=\"").concat(i,"-").concat(a,"\" value=\"").concat(r.value,"\"/>\n              <label class=\"").concat(o||n,"\" ").concat(d," for=\"").concat(l,"\">").concat(o?'':u,"</label>\n            </div>\n          ")}));var l=this.el.querySelector(".".concat(e,"field"));l.innerHTML="<div class=\"".concat(e,"radio-items\">").concat(c,"</div>"),this.input=l.firstChild}},getInputValue:function(){var t=this.getCheckedEl();return t?t.value:''},getCheckedEl:function(){var t=this.getInputEl();return t?t.querySelector('input:checked'):''},setValue:function(t){var e=this.model,n=t||e.get('value')||e.getDefaultValue(),r=this.getInputEl(),i=r?r.querySelector("[value=\"".concat(n,"\"]")):'';if(i)i.checked=!0;else{var o=this.getCheckedEl();o&&(o.checked=!1)}}}),bt=n(40);function wt(t,e){var n=Object.keys(t);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(t);e&&(r=r.filter((function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable}))),n.push.apply(n,r)}return n}function Ot(t){for(var e=1;e<arguments.length;e++){var n=null!=arguments[e]?arguments[e]:{};e%2?wt(Object(n),!0).forEach((function(e){i()(t,e,n[e])})):Object.getOwnPropertyDescriptors?Object.defineProperties(t,Object.getOwnPropertyDescriptors(n)):wt(Object(n)).forEach((function(e){Object.defineProperty(t,e,Object.getOwnPropertyDescriptor(n,e))}))}return t}var xt=C.extend({defaults:Ot(Ot({},C.prototype.defaults),{},{units:[],unit:'',step:1,min:'',max:''}),getUnits:function(){return this.get('units')||[]},getValueUnit:function(){return this.get('unit')},initialize:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};C.callParentInit(C,this,t,e);var n=this.get('unit'),r=this.get('units');this.input=Object(b["hasWin"])()&&new bt["a"]({model:this}),r.length&&!n&&this.set('unit',r[0]),C.callInit(this,t,e)},clearValue:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};return this.set({value:void 0,unit:void 0},t),this},parseValue:function(t){var e=C.prototype.parseValue.apply(this,arguments),n=this.input.validateInputValue(e.value,{deepCheck:1}),r=n.value,i=n.unit;return e.value=r,e.unit=i,e},getFullValue:function(){var t=this.get('value'),e=this.get('unit');return t=Object(y["isUndefined"])(t)?'':t,e=!Object(y["isUndefined"])(e)&&t?e:'',t="".concat(t).concat(e),C.prototype.getFullValue.apply(this,[t])}});function Ct(t,e){var n=Object.keys(t);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(t);e&&(r=r.filter((function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable}))),n.push.apply(n,r)}return n}function kt(t){for(var e=1;e<arguments.length;e++){var n=null!=arguments[e]?arguments[e]:{};e%2?Ct(Object(n),!0).forEach((function(e){i()(t,e,n[e])})):Object.getOwnPropertyDescriptors?Object.defineProperties(t,Object.getOwnPropertyDescriptors(n)):Ct(Object(n)).forEach((function(e){Object.defineProperty(t,e,Object.getOwnPropertyDescriptor(n,e))}))}return t}var St=xt.extend({defaults:kt(kt({},xt.prototype.defaults),{},{showInput:1})});function jt(t,e){var n=Object.keys(t);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(t);e&&(r=r.filter((function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable}))),n.push.apply(n,r)}return n}function Tt(t){for(var e=1;e<arguments.length;e++){var n=null!=arguments[e]?arguments[e]:{};e%2?jt(Object(n),!0).forEach((function(e){i()(t,e,n[e])})):Object.getOwnPropertyDescriptors?Object.defineProperties(t,Object.getOwnPropertyDescriptors(n)):jt(Object(n)).forEach((function(e){Object.defineProperty(t,e,Object.getOwnPropertyDescriptor(n,e))}))}return t}var Pt=it.extend({events:function(){return Tt(Tt({},it.prototype.events),{},{'change [type=range]':'inputValueChanged','input [type=range]':'inputValueChangedSoft',change:''})},templateInput:function(t){var e=this.ppfx;return"\n      <div class=\"".concat(e,"field ").concat(e,"field-range\">\n        <input type=\"range\"\n          min=\"").concat(t.get('min'),"\"\n          max=\"").concat(t.get('max'),"\"\n          step=\"").concat(t.get('step'),"\"/>\n      </div>\n    ")},getSliderEl:function(){return this.slider||(this.slider=this.el.querySelector('input[type=range]')),this.slider},inputValueChanged:function(){var t=this.model,e=t.get('step');this.getInputEl().value=this.getSliderEl().value;var n=this.getInputValue()-e;t.set('value',n,{avoidStore:1}).set('value',n+e),this.elementUpdated()},inputValueChangedSoft:function(){this.getInputEl().value=this.getSliderEl().value,this.model.set('value',this.getInputValue(),{avoidStore:1}),this.elementUpdated()},setValue:function(t){var e=this.model.parseValue(t);this.getSliderEl().value=parseFloat(e.value),it.prototype.setValue.apply(this,arguments)},onRender:function(){it.prototype.onRender.apply(this,arguments),this.model.get('showInput')||(this.inputInst.el.style.display='none')},clearCached:function(){it.prototype.clearCached.apply(this,arguments),this.slider=null}});function Et(t,e){var n=Object.keys(t);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(t);e&&(r=r.filter((function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable}))),n.push.apply(n,r)}return n}function _t(t){for(var e=1;e<arguments.length;e++){var n=null!=arguments[e]?arguments[e]:{};e%2?Et(Object(n),!0).forEach((function(e){i()(t,e,n[e])})):Object.getOwnPropertyDescriptors?Object.defineProperties(t,Object.getOwnPropertyDescriptors(n)):Et(Object(n)).forEach((function(e){Object.defineProperty(t,e,Object.getOwnPropertyDescriptor(n,e))}))}return t}var Mt=e["default"]=a.a.Collection.extend(s["a"]).extend({extendViewApi:1,types:[{id:'stack',model:A,view:tt,isType:function(t){if(t&&'stack'==t.type)return t}},{id:'composite',model:j,view:q,isType:function(t){if(t&&'composite'==t.type)return t}},{id:'file',model:C,view:nt,isType:function(t){if(t&&'file'==t.type)return t}},{id:'color',model:C,view:ct,isType:function(t){if(t&&'color'==t.type)return t}},{id:'select',model:vt,view:mt,isType:function(t){if(t&&'select'==t.type)return t}},{id:'radio',model:ft,view:yt,isType:function(t){if(t&&'radio'==t.type)return t}},{id:'slider',model:St,view:Pt,isType:function(t){if(t&&'slider'==t.type)return t}},{id:'integer',model:xt,view:it,isType:function(t){if(t&&'integer'==t.type)return t}},{id:'base',model:C,view:B,isType:function(t){return t.type='base',t}}],deepClone:function(){var t=this.clone();return t.reset(t.map((function(t){var e=t.clone();return e.typeView=t.typeView,e}))),t},parseValue:function(t){var e=this,n=[];return t.split(' ').forEach((function(t,r){var i=e.at(r);i&&n.push(_t(_t({},i.attributes),{value:t}))})),n},getFullValue:function(){var t='';return this.each((function(e){return t+="".concat(e.getFullValue()," ")})),t.trim()}})},function(t,e){function n(t,e,n,r,i,o,a){try{var s=t[o](a),c=s.value}catch(t){return void n(t)}s.done?e(c):Promise.resolve(c).then(r,i)}t.exports=function(t){return function(){var e=this,r=arguments;return new Promise((function(i,o){var a=t.apply(e,r);function s(t){n(a,i,o,s,c,"next",t)}function c(t){n(a,i,o,s,c,"throw",t)}s(void 0)}))}},t.exports["default"]=t.exports,t.exports.__esModule=!0},function(t,e){var n;n=function(){return this}();try{n=n||new Function("return this")()}catch(t){"object"==typeof window&&(n=window)}t.exports=n},function(t,e,n){"use strict";n.r(e);var r=n(2),i=n.n(r).a.$;e["default"]={startSelectPosition:function(t,e){var n=this,r=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};this.isPointed=!1;var i=this.editorModel.get('Utils'),o=t.ownerDocument.body;i&&!this.sorter&&(this.sorter=new i.Sorter({container:o,placer:this.canvas.getPlacerEl(),containerSel:'*',itemSel:'*',pfx:this.ppfx,direction:'a',document:e,wmargin:1,nested:1,em:this.editorModel,canvasRelative:1,scale:function(){return n.em.getZoomDecimal()}})),r.onStart&&(this.sorter.onStart=r.onStart),t&&this.sorter.startSort(t,{container:o})},getOffsetDim:function(){var t=this.offset(this.canvas.getFrameEl()),e=this.offset(this.canvas.getElement());return{top:t.top-e.top,left:t.left-e.left}},stopSelectPosition:function(){this.posTargetCollection=null,this.posIndex='after'==this.posMethod&&0!==this.cDim.length?this.posIndex+1:this.posIndex,this.sorter&&(this.sorter.moved=0,this.sorter.endMove()),this.cDim&&(this.posIsLastEl=0!==this.cDim.length&&'after'==this.posMethod&&this.posIndex==this.cDim.length,this.posTargetEl=0===this.cDim.length?i(this.outsideElem):!this.posIsLastEl&&this.cDim[this.posIndex]?i(this.cDim[this.posIndex][5]).parent():i(this.outsideElem),this.posTargetModel=this.posTargetEl.data('model'),this.posTargetCollection=this.posTargetEl.data('model-comp'))},enable:function(){this.startSelectPosition()},nearFloat:function(t,e,n){var r=t||0,i=e||'before',o=n.length,a=0!==o&&'after'==i&&r==o;return 0!==o&&(!a&&!n[r][4]||n[r-1]&&!n[r-1][4]||a&&!n[r-1][4])?1:0},run:function(){this.enable()},stop:function(){this.stopSelectPosition(),this.$wrapper.css('cursor',''),this.$wrapper.unbind()}}},function(t,e,n){"use strict";var r=n(46),i=n(1);Object(i["hasWin"])()&&(window.Promise=window.Promise||r["a"]),e["a"]='function'==typeof fetch?fetch.bind():function(t,e){return new r["a"]((function(n,i){var o=new XMLHttpRequest;for(var a in o.open(e.method||'get',t),o.withCredentials='include'==e.credentials,e.headers||{})o.setRequestHeader(a,e.headers[a]);o.onload=function(t){return n({status:o.status,statusText:o.statusText,text:function(){return r["a"].resolve(o.responseText)}})},o.onerror=i,o.upload&&e.onProgress&&(o.upload.onprogress=e.onProgress),e.body?o.send(e.body):o.send()}))}},function(t,e,n){"use strict";var r=n(0),i=n(2),o=n.n(i),a=o.a.Model,s=o.a.View;e["a"]={types:[],initialize:function(t,e){var n=this;this.model=function(){var t,e,r,i=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},o=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(i&&i.type){var a=n.getBaseType();t=(r=n.getType(i.type))?r.model:a.model,e=r?r.view:a.view}else{var s=n.recognizeType(i);t=(r=s.type).model,e=r.view,i=s.attributes}var c=new t(i,o);return c.typeView=e,c};var r=this.init&&this.init.bind(this);r&&r()},recognizeType:function(t){for(var e=this.getTypes(),n=0;n<e.length;n++){var r=e[n],i=r.isType(t);if(i='boolean'==typeof i&&i?{type:r.id}:i)return{type:r,attributes:i}}return{type:this.getBaseType(),attributes:t}},getBaseType:function(){var t=this.getTypes();return t[t.length-1]},getTypes:function(){return this.types},getType:function(t){for(var e=this.getTypes(),n=0;n<e.length;n++){var r=e[n];if(r.id===t)return r}},addType:function(t,e){var n=this.getType(t),i=this.getBaseType(),o=n?n.model:i.model,c=n?n.view:i.view,l=e.model,u=e.view,d=e.isType;l=l instanceof a||Object(r["isFunction"])(l)?l:o.extend(l||{}),u=u instanceof s||Object(r["isFunction"])(u)?u:c.extend(u||{}),!this.extendViewApi||e.model||e.view||(u=u.extend(e)),n?(n.model=l,n.view=u,n.isType=d||n.isType):(e.id=t,e.model=l,e.view=u,e.isType=d||function(e){if(e&&e.type==t)return!0},this.getTypes().unshift(e))}}},function(t,e,n){"use strict";var r=n(2),i=n.n(r),o=n(0),a=Number.MAX_VALUE;e["a"]=i.a.Model.extend({initialize:function(){Object(o["bindAll"])(this,'sortRules'),this.compCls=[],this.ids=[]},buildFromModel:function(t){var e=this,n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},r='',i=this.em,o=i&&i.getConfig('avoidInlineStyle'),a=t.styleToString(),s=t.get('classes'),c=n.wrapperIsBody,l=t.get('wrapper');if(this.ids.push("#".concat(t.getId())),s.each((function(t){return e.compCls.push(t.getFullName())})),!o&&a){var u="#".concat(t.getId());r="".concat(u=c&&l?'body':u,"{").concat(a,"}")}var d=t.components();return d.each((function(t){return r+=e.buildFromModel(t,n)})),r},build:function(t){var e=this,n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},r=n.json,i=n.em||'',a=n.cssc||i&&i.get('CssComposer');this.em=i,this.compCls=[],this.ids=[],this.model=t;var s=[],c=t?this.buildFromModel(t,n):'',l=Object(o["isUndefined"])(n.clearStyles)&&i?i.getConfig('clearStyles'):n.clearStyles;if(a){var u=n.rules||a.getAll(),d={},h=[];u.forEach((function(t){var i=t.getAtRule();if(i){var o=d[i];o?o.push(t):d[i]=[t]}else{var a=e.buildFromRule(t,h,n);r?s.push(a):c+=a}})),this.sortMediaObject(d).forEach((function(t){var i='',o=t.key;t.value.forEach((function(t){var a=e.buildFromRule(t,h,n);t.get('singleAtRule')?c+="".concat(o,"{").concat(a,"}"):i+=a,r&&s.push(a)})),i&&(c+="".concat(o,"{").concat(i,"}"))})),i&&l&&u.remove&&u.remove(h)}return r?s.filter((function(t){return t})):c},buildFromRule:function(t,e){var n,r=this,i=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},o='',a=this.model,s=t.selectorsToString({skipAdd:1}),c=t.get('selectorsAdd'),l=t.get('singleAtRule');if(t.get('selectors').each((function(t){var e=t.getFullName();(r.compCls.indexOf(e)>=0||r.ids.indexOf(e)>=0||i.keepUnusedStyles)&&(n=1)})),s&&n||c||l||!a){var u=t.getDeclaration({body:1});u&&(i.json?o=t:o+=u)}else e.push(t);return o},getQueryLength:function(t){var e=/(-?\d*\.?\d+)\w{0,}/.exec(t);return e?parseFloat(e[1]):a},sortMediaObject:function(){var t=this,e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},n=[];return Object(o["each"])(e,(function(t,e){return n.push({key:e,value:t})})),n.sort((function(e,n){var r=[e.key,n.key].every((function(t){return-1!==t.indexOf('min-width')})),i=r?e.key:n.key,o=r?n.key:e.key;return t.getQueryLength(i)-t.getQueryLength(o)}))},sortRules:function(t,e){var n=function(t){return t.get('mediaText')},r=[n(t),n(e)].every((function(t){return-1!==t.indexOf('min-width')})),i=n(r?t:e),o=n(r?e:t);return this.getQueryLength(i)-this.getQueryLength(o)}})},function(t,e,n){"use strict";var r=n(2),i=n.n(r),o=n(0),a=n(1),s=n(25);i.a.$;e["a"]=s["a"].extend({events:{'change input':'handleChange','change select':'handleUnitChange','click [data-arrow-up]':'upArrowClick','click [data-arrow-down]':'downArrowClick','mousedown [data-arrows]':'downIncrement',keydown:'handleKeyDown'},template:function(){var t=this.ppfx;return"\n      <span class=\"".concat(t,"input-holder\"></span>\n      <span class=\"").concat(t,"field-units\"></span>\n      <div class=\"").concat(t,"field-arrows\" data-arrows>\n        <div class=\"").concat(t,"field-arrow-u\" data-arrow-up></div>\n        <div class=\"").concat(t,"field-arrow-d\" data-arrow-down></div>\n      </div>\n    ")},inputClass:function(){var t=this.ppfx;return this.opts.contClass||"".concat(t,"field ").concat(t,"field-integer")},initialize:function(){s["a"].prototype.initialize.apply(this,arguments),Object(o["bindAll"])(this,'moveIncrement','upIncrement'),this.doc=document,this.listenTo(this.model,'change:unit',this.handleModelChange)},setValue:function(t,e){var n=e||{},r=this.validateInputValue(t,{deepCheck:1}),i={value:r.value};(r.unit||r.force)&&(i.unit=r.unit),this.model.set(i,n),n.silent&&this.handleModelChange()},handleChange:function(t){t.stopPropagation(),this.setValue(this.getInputEl().value),this.elementUpdated()},handleUnitChange:function(t){t.stopPropagation();var e=this.getUnitEl().value;this.model.set('unit',e),this.elementUpdated()},handleKeyDown:function(t){'ArrowUp'===t.key&&(t.preventDefault(),this.upArrowClick()),'ArrowDown'===t.key&&(t.preventDefault(),this.downArrowClick())},elementUpdated:function(){this.model.trigger('el:change')},handleModelChange:function(){var t=this.model;this.getInputEl().value=t.get('value');var e=this.getUnitEl();e&&(e.value=t.get('unit')||'')},getUnitEl:function(){if(!this.unitEl){var t=this.model,e=t.get('units')||[];if(e.length){var n=[];e.forEach((function(e){var r=e==t.get('unit')?'selected':'';n.push("<option ".concat(r,">").concat(e,"</option>"))}));var r=document.createElement('div');r.innerHTML="<select class=\"".concat(this.ppfx,"input-unit\">").concat(n.join(''),"</select>"),this.unitEl=r.firstChild}}return this.unitEl},upArrowClick:function(){var t=this.model,e=t.get('step'),n=parseFloat(t.get('value'));n=this.normalizeValue(n+e);var r=this.validateInputValue(n);t.set('value',r.value),this.elementUpdated()},downArrowClick:function(){var t=this.model,e=t.get('step'),n=parseFloat(t.get('value')),r=this.normalizeValue(n-e),i=this.validateInputValue(r);t.set('value',i.value),this.elementUpdated()},downIncrement:function(t){t.preventDefault(),this.moved=0;var e=this.model.get('value');e=this.normalizeValue(e),this.current={y:t.pageY,val:e},Object(a["on"])(this.doc,'mousemove',this.moveIncrement),Object(a["on"])(this.doc,'mouseup',this.upIncrement)},moveIncrement:function(t){this.moved=1;var e=this.model,n=e.get('step'),r=this.current,i=this.normalizeValue(r.val+(r.y-t.pageY)*n);return this.prValue=this.validateInputValue(i).value,e.set('value',this.prValue,{avoidStore:1}),!1},upIncrement:function(){var t=this.model,e=t.get('step');if(Object(a["off"])(this.doc,'mouseup',this.upIncrement),Object(a["off"])(this.doc,'mousemove',this.moveIncrement),this.prValue&&this.moved){var n=this.prValue-e;t.set('value',n,{avoidStore:1}).set('value',n+e),this.elementUpdated()}},normalizeValue:function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:0,n=this.model,r=n.get('step'),i=0;if(isNaN(t))return e;if(t=parseFloat(t),Math.floor(t)!==t){var o=r.toString().split('.')[1];i=o?o.length:0}return i?parseFloat(t.toFixed(i)):t},validateInputValue:function(t,e){var n=0,r=e||{},i=this.model,a='',s=Object(o["isUndefined"])(t)?a:t,c=i.get('units')||[],l=i.get('unit')||c.length&&c[0]||'',u=i.get('max'),d=i.get('min'),h=!!i.get('limitlessMax'),f=!!i.get('limitlessMin');if(r.deepCheck){var p=i.get('fixedValues')||[];if(s){var g=new RegExp('^'+p.join('|'),'g');if(p.length&&g.test(s))s=s.match(g)[0],l='',n=1;else{var v=s+'';s+='',s=parseFloat(s.replace(',','.')),s=isNaN(s)?a:s;var m=v.replace(s,'');Object(o["indexOf"])(c,m)>=0&&(l=m)}}}return h||Object(o["isUndefined"])(u)||''===u||(s=s>u?u:s),f||Object(o["isUndefined"])(d)||''===d||(s=s<d?d:s),{force:n,value:s,unit:l}},render:function(){s["a"].prototype.render.call(this),this.unitEl=null;var t=this.getUnitEl();return t&&this.$el.find(".".concat(this.ppfx,"field-units")).get(0).appendChild(t),this}})},function(t,e,n){var r=n(94),i=n(95),o=n(50),a=n(96);t.exports=function(t,e){return r(t)||i(t,e)||o(t,e)||a()},t.exports["default"]=t.exports,t.exports.__esModule=!0},function(t,e,n){"use strict";var r=n(2),i=n.n(r),o=n(0);e["a"]=i.a.View.extend({initialize:function(t){this.opts=t||{},this.config=t.config||{},this.em=this.config.em;var e=this.collection;this.listenTo(e,'add',this.addTo),this.listenTo(e,'reset',this.resetChildren),this.listenTo(e,'remove',this.removeChildren)},removeChildren:function(t,e){var n=this,r=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};t.views.forEach((function(t){if(t){var e=t.childrenView,n=t.scriptContainer;e&&e.stopListening(),n&&n.remove(),t.remove.apply(t)}}));var i=t.components();i.forEach((function(t){return n.removeChildren(t,e,r)}))},addTo:function(t){var e=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},n=this.config.em,r=this.collection.indexOf(t);if(this.addToCollection(t,null,r),n&&!e.temporary){var i=function t(e){n.trigger('component:add',e),e.components().forEach((function(e){return t(e)}))};i(t)}},addToCollection:function(t,e,r){this.compView||(this.compView=n(12).default);for(var i=this.config,a=this.opts,s=this.em,c=e||null,l=i.frameView,u=void 0===l?{}:l,d=u.model&&t.getView(u.model),h=a.componentTypes||s&&s.get('DomComponents').getTypes(),f=t.get('type')||'default',p=this.compView,g=0;g<h.length;g++)if(h[g].id==f){p=h[g].view;break}var v,m=d||new p({model:t,config:i,componentTypes:h});try{v=m.render().el}catch(t){v=document.createTextNode(''),s.logError(t)}if(c)c.appendChild(v);else{var y=this.parentEl,b=y.childNodes;if(Object(o["isUndefined"])(r))y.appendChild(v);else{var w=b.length==r;w&&r--,w||!b.length?y.appendChild(v):y.insertBefore(v,b[r])}}return v},resetChildren:function(t){var e=this,n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},r=n.previousModels,i=void 0===r?[]:r;this.parentEl.innerHTML='',i.forEach((function(t){return e.removeChildren(t,e.collection)})),t.each((function(t){return e.addToCollection(t)}))},render:function(t){var e=this,n=this.el,r=document.createDocumentFragment();return this.parentEl=t||this.el,this.collection.each((function(t){return e.addToCollection(t,r)})),n.innerHTML='',n.appendChild(r),this}})},function(t,e,n){"use strict";var r=n(2),i=n.n(r),o=i.a.View.extend({tagName:'style',initialize:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};this.config=t.config||{};var e=this.model;this.listenTo(e,'change',this.render),this.listenTo(e,'destroy remove',this.remove),this.listenTo(e.get('selectors'),'change',this.render)},render:function(){var t=this.model,e=this.el,n=t.get('important');return e.innerHTML=t.toCSS({important:n}),this}}),a=o.extend({_createElement:function(t){return document.createTextNode('')},render:function(){var t=this.model,e=t.get('important');return this.el.textContent=t.getDeclaration({important:e}),this}}),s=i.a.$,c=function(t,e){return"".concat(t).concat(e?"-".concat(parseFloat(e)):'')};e["a"]=i.a.View.extend({initialize:function(t){var e=t.config||{};this.atRules={},this.config=e,this.em=e.em,this.pfx=e.stylePrefix||'',this.className=this.pfx+'rules';var n=this.collection;this.listenTo(n,'add',this.addTo),this.listenTo(n,'reset',this.render)},addTo:function(t){this.addToCollection(t)},addToCollection:function(t,e){if(this.renderStarted){var n,r,i=e||null,s={model:t,config:this.config};if('keyframes'===t.get('atRuleType')){var l=t.getAtRule(),u=this.atRules[l];if(!u){var d=document.createElement('style');u=document.createTextNode(''),d.appendChild(document.createTextNode("".concat(l,"{"))),d.appendChild(u),d.appendChild(document.createTextNode("}")),this.atRules[l]=u,n=d}r=new a(s),u.appendData(r.render().el.textContent)}else n=(r=new o(s)).render().el;var h=this.className,f=t.get('mediaText'),p=c(h),g=p;if(f&&(g=c(h,this.getMediaWidth(f))),n){var v,m=i||this.el;try{v=m.querySelector("#".concat(g))}catch(t){}v||(v=m.querySelector("#".concat(p))),v.appendChild(n)}return n}},getMediaWidth:function(t){return t&&t.replace("(".concat(this.em.getConfig('mediaCondition'),": "),'').replace(')','')},render:function(){var t=this;this.renderStarted=1,this.atRules={};var e=this.em,n=this.$el,r=this.className,i=this.collection,o=document.createDocumentFragment();n.empty();var a=e.get('DeviceManager').getAll().pluck('priority');return a.every((function(t){return t}))&&a.unshift(0),a.forEach((function(t){return s("<div id=\"".concat(c(r,t),"\"></div>")).appendTo(o)})),i.each((function(e){return t.addToCollection(e,o)})),n.append(o),n.attr('class',r),this}})},function(t,e,n){"use strict";var r=n(3),i=n.n(r),o=n(14),a=n.n(o),s=n(0),c='text/html',l=c,u=function(t){var e,n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},r=new DOMParser,i=n.htmlType||l,o=i===c,a=o?t:"<div>".concat(t,"</div>"),u=r.parseFromString(a,i);if(o){var d=u.head,h=u.body,f=d.querySelectorAll('script');Object(s["each"])(f,(function(t){return h.appendChild(t)}));var p=[];Object(s["each"])(d.children,(function(t){return p.push(t)})),Object(s["each"])(p,(function(t,e){return h.insertBefore(t,h.children[e])})),e=h}else e=u.firstChild;return e};function d(t,e){var n=Object.keys(t);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(t);e&&(r=r.filter((function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable}))),n.push.apply(n,r)}return n}function h(t){for(var e=1;e<arguments.length;e++){var n=null!=arguments[e]?arguments[e]:{};e%2?d(Object(n),!0).forEach((function(e){i()(t,e,n[e])})):Object.getOwnPropertyDescriptors?Object.defineProperties(t,Object.getOwnPropertyDescriptors(n)):d(Object(n)).forEach((function(e){Object.defineProperty(t,e,Object.getOwnPropertyDescriptor(n,e))}))}return t}e["a"]=function(t){var e=t,n='data-gjs-',r='parse:html';return{compTypes:'',modelAttrStart:n,splitPropsFromAttr:function(){var t=this,e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},r={},i={};return Object(s["each"])(e,(function(e,o){if(0===o.indexOf(t.modelAttrStart)){var a=o.replace(n,''),c=e.length,l=e&&Object(s["isString"])(e),u=l&&e.substr(0,1),d=l&&e.substr(c-1);e='false'!==(e='true'===e||e)&&e;try{e='{'==u&&'}'==d||'['==u&&']'==d?JSON.parse(e):e}catch(t){}r[a]=e}else i[o]=e})),{props:r,attrs:i}},parseStyle:function(t){for(var e={},n=t.split(';'),r=0,i=n.length;r<i;r++){var o=n[r].trim();if(o){var a=o.split(':');e[a[0].trim()]=a.slice(1).join(':').trim()}}return e},parseClass:function(t){for(var e=[],n=t.split(' '),r=0,i=n.length;r<i;r++){var o=n[r].trim();o&&e.push(o)}return e},parseNode:function(r){for(var i=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},o=[],s=r.childNodes,c=0,l=s.length;c<l;c++){var u=s[c],d=u.attributes||[],f=d.length,p=o[o.length-1],g=u.childNodes.length,v=this.compTypes,m={};if(v){var y='',b=u.getAttribute&&u.getAttribute("".concat(n,"type"));if(b)m={type:b};else{for(var w=0;w<v.length;w++){var O=v[w];if(y=O.model.isComponent(u,i)){'object'!==a()(y)&&(y={type:O.id});break}}m=y}}m.tagName||(m.tagName=u.tagName?u.tagName.toLowerCase():''),f&&(m.attributes={});for(var x=0;x<f;x++){var C=d[x].nodeName,k=d[x].nodeValue;if('style'==C)m.style=this.parseStyle(k);else if('class'==C)m.classes=this.parseClass(k);else{if('contenteditable'==C)continue;if(0===C.indexOf(n)){var S=C.replace(n,''),j=k.length,T=k&&k.substr(0,1),P=k&&k.substr(j-1);k='false'!==(k='true'===k||k)&&k;try{k='{'==T&&'}'==P||'['==T&&']'==P?JSON.parse(k):k}catch(t){}m[S]=k}else''===k&&!0===u[C]&&(k=!0),m.attributes[C]=k}}if(g&&!m.components){var E=u.childNodes[0];1===g&&3===E.nodeType?(!m.type&&(m.type='text'),m.components={type:'textnode',content:E.nodeValue}):m.components=this.parseNode(u,h(h({},i),{},{inSvg:i.inSvg||'svg'===m.type}))}if('textnode'==m.type){if(p&&'textnode'==p.type){p.content+=m.content;continue}if(!t.keepEmptyTextNodes){var _=u.nodeValue;if(' '!=_&&!_.trim())continue}}g||'/>'!=="".concat(u.outerHTML).slice(-2)||(m.void=!0);var M=m.components;if(!m.type&&M){for(var D=1,A=0,L=0;L<M.length;L++){var N=M[L],R=N.type;if(['text','textnode'].indexOf(R)<0&&e.textTags.indexOf(N.tagName)<0){D=0;break}'textnode'==R&&(A=1)}D&&A&&(m.type='text')}(m.tagName||'textnode'==m.type)&&o.push(m)}return o},parse:function(n,i){var o=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},a=e.em,c=a&&a.get('Config')||{},l={html:null,css:null},d=h(h({},t),o),f=Object(s["isFunction"])(d.parserHtml)?d.parserHtml(n,d):u(n,d),p=f.querySelectorAll('script'),g=p.length;if(!c.allowScripts)for(;g--;)p[g].parentNode.removeChild(p[g]);if(i){for(var v=f.querySelectorAll('style'),m=v.length,y='';m--;)y=v[m].innerHTML+y,v[m].parentNode.removeChild(v[m]);y&&(l.css=i.parse(y))}a&&a.trigger("".concat(r,":root"),{input:n,root:f});var b=this.parseNode(f),w=1!==b.length||e.returnArray?b:b[0];return l.html=w,a&&a.trigger(r,{input:n,output:l}),l}}}},function(t,e,n){"use strict";var r=n(3),i=n.n(r),o=n(2),a=n.n(o),s=n(0),c=n(14),l=n.n(c),u=n(1),d=n(25);function h(t,e){var n=Object.keys(t);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(t);e&&(r=r.filter((function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable}))),n.push.apply(n,r)}return n}function f(t){for(var e=1;e<arguments.length;e++){var n=null!=arguments[e]?arguments[e]:{};e%2?h(Object(n),!0).forEach((function(e){i()(t,e,n[e])})):Object.getOwnPropertyDescriptors?Object.defineProperties(t,Object.getOwnPropertyDescriptors(n)):h(Object(n)).forEach((function(e){Object.defineProperty(t,e,Object.getOwnPropertyDescriptor(n,e))}))}return t}var p=a.a.$;p&&function(t,e){if(Object(u["hasWin"])()){var n={beforeShow:P,move:P,change:P,show:P,hide:P,color:!1,flat:!1,showInput:!1,allowEmpty:!1,showButtons:!0,clickoutFiresChange:!0,showInitial:!1,showPalette:!1,showPaletteOnly:!1,hideAfterPaletteSelect:!1,togglePaletteOnly:!1,showSelectionPalette:!0,localStorageKey:!1,appendTo:'body',maxSelectionSize:7,cancelText:'cancel',chooseText:'choose',togglePaletteMoreText:'more',togglePaletteLessText:'less',clearText:'Clear Color Selection',noColorSelectedText:'No Color Selected',preferredFormat:!1,className:'',containerClassName:'',replacerClassName:'',showAlpha:!1,theme:'sp-light',palette:[['#ffffff','#000000','#ff0000','#ff8000','#ffff00','#008000','#0000ff','#4b0082','#9400d3']],selectionPalette:[],disabled:!1,offset:null},r=[],i=!!/msie/i.exec(window.navigator.userAgent),o=function(){function t(t,e){return!!~(''+t).indexOf(e)}var e=document.createElement('div').style;return e.cssText='background-color:rgba(0,0,0,.5)',t(e.backgroundColor,'rgba')||t(e.backgroundColor,'hsla')}(),a=["<div class='sp-replacer'>","<div class='sp-preview'><div class='sp-preview-inner'></div></div>","<div class='sp-dd'>&#9660;</div>",'</div>'].join(''),s=function(){var t='';if(i)for(var e=1;e<=6;e++)t+="<div class='sp-"+e+"'></div>";return["<div class='sp-container sp-hidden'>","<div class='sp-palette-container'>","<div class='sp-palette sp-thumb sp-cf'></div>","<div class='sp-palette-button-container sp-cf'>","<button type='button' class='sp-palette-toggle'></button>",'</div>','</div>',"<div class='sp-picker-container'>","<div class='sp-top sp-cf'>","<div class='sp-fill'></div>","<div class='sp-top-inner'>","<div class='sp-color'>","<div class='sp-sat'>","<div class='sp-val'>","<div class='sp-dragger'></div>",'</div>','</div>','</div>',"<div class='sp-clear sp-clear-display'>",'</div>',"<div class='sp-hue'>","<div class='sp-slider'></div>",t,'</div>','</div>',"<div class='sp-alpha'><div class='sp-alpha-inner'><div class='sp-alpha-handle'></div></div></div>",'</div>',"<div class='sp-input-container sp-cf'>","<input class='sp-input' type='text' spellcheck='false'  />",'</div>',"<div class='sp-initial sp-thumb sp-cf'></div>","<div class='sp-button-container sp-cf'>","<a class='sp-cancel' href='#'></a>","<button type='button' class='sp-choose'></button>",'</div>','</div>','</div>'].join('')}(),c='spectrum.id';t.fn.spectrum=function(e,n){if('string'==typeof e){var i=this,o=Array.prototype.slice.call(arguments,1);return this.each((function(){var n=r[t(this).data(c)];if(n){var a=n[e];if(!a)throw new Error("Spectrum: no such method: '"+e+"'");'get'==e?i=n.get():'container'==e?i=n.container:'option'==e?i=n.option.apply(n,o):'destroy'==e?(n.destroy(),t(this).removeData(c)):a.apply(n,o)}})),i}return this.spectrum('destroy').each((function(){var n=T(this,t.extend({},e,t(this).data()));t(this).data(c,n.id)}))},t.fn.spectrum.load=!0,t.fn.spectrum.loadOpts={},t.fn.spectrum.draggable=M,t.fn.spectrum.defaults=n,t.fn.spectrum.inputTypeColorSupport=function e(){if(void 0===e._cachedResult){var n=t("<input type='color'/>")[0];e._cachedResult='color'===n.type&&''!==n.value}return e._cachedResult},t.spectrum={},t.spectrum.localization={},t.spectrum.palettes={},t.fn.spectrum.processNativeColorInputs=function(){var e=t('input[type=color]');e.length&&!D()&&e.spectrum({preferredFormat:'hex6'})};var d=/^[\s,#]+/,h=/\s+$/,f=0,p=Math,g=p.round,v=p.min,m=p.max,y=p.random,b=function t(e,n){if(n=n||{},(e=e||'')instanceof t)return e;if(!(this instanceof t))return new t(e,n);var r=function(t){var e={r:0,g:0,b:0},n=1,r=!1,i=!1;'string'==typeof t&&(t=function(t){t=t.replace(d,'').replace(h,'').toLowerCase();var e,n=!1;if(C[t])t=C[t],n=!0;else if('transparent'==t)return{r:0,g:0,b:0,a:0,format:'name'};if(e=S.rgb.exec(t))return{r:e[1],g:e[2],b:e[3]};if(e=S.rgba.exec(t))return{r:e[1],g:e[2],b:e[3],a:e[4]};if(e=S.hsl.exec(t))return{h:e[1],s:e[2],l:e[3]};if(e=S.hsla.exec(t))return{h:e[1],s:e[2],l:e[3],a:e[4]};if(e=S.hsv.exec(t))return{h:e[1],s:e[2],v:e[3]};if(e=S.hsva.exec(t))return{h:e[1],s:e[2],v:e[3],a:e[4]};if(e=S.hex8.exec(t))return{a:(r=e[1],Q(r)/255),r:Q(e[2]),g:Q(e[3]),b:Q(e[4]),format:n?'name':'hex8'};var r;if(e=S.hex6.exec(t))return{r:Q(e[1]),g:Q(e[2]),b:Q(e[3]),format:n?'name':'hex'};if(e=S.hex3.exec(t))return{r:Q(e[1]+''+e[1]),g:Q(e[2]+''+e[2]),b:Q(e[3]+''+e[3]),format:n?'name':'hex'};return!1}(t));'object'==l()(t)&&(t.hasOwnProperty('r')&&t.hasOwnProperty('g')&&t.hasOwnProperty('b')?(o=t.r,a=t.g,s=t.b,e={r:255*J(o,255),g:255*J(a,255),b:255*J(s,255)},r=!0,i='%'===String(t.r).substr(-1)?'prgb':'rgb'):t.hasOwnProperty('h')&&t.hasOwnProperty('s')&&t.hasOwnProperty('v')?(t.s=et(t.s),t.v=et(t.v),e=function(t,e,n){t=6*J(t,360),e=J(e,100),n=J(n,100);var r=p.floor(t),i=t-r,o=n*(1-e),a=n*(1-i*e),s=n*(1-(1-i)*e),c=r%6;return{r:255*[n,a,o,o,s,n][c],g:255*[s,n,n,a,o,o][c],b:255*[o,o,s,n,n,a][c]}}(t.h,t.s,t.v),r=!0,i='hsv'):t.hasOwnProperty('h')&&t.hasOwnProperty('s')&&t.hasOwnProperty('l')&&(t.s=et(t.s),t.l=et(t.l),e=function(t,e,n){var r,i,o;function a(t,e,n){return n<0&&(n+=1),n>1&&(n-=1),n<1/6?t+6*(e-t)*n:n<1/2?e:n<2/3?t+(e-t)*(2/3-n)*6:t}if(t=J(t,360),e=J(e,100),n=J(n,100),0===e)r=i=o=n;else{var s=n<.5?n*(1+e):n+e-n*e,c=2*n-s;r=a(c,s,t+1/3),i=a(c,s,t),o=a(c,s,t-1/3)}return{r:255*r,g:255*i,b:255*o}}(t.h,t.s,t.l),r=!0,i='hsl'),t.hasOwnProperty('a')&&(n=t.a));var o,a,s;return n=X(n),{ok:r,format:t.format||i,r:v(255,m(e.r,0)),g:v(255,m(e.g,0)),b:v(255,m(e.b,0)),a:n}}(e);this._originalInput=e,this._r=r.r,this._g=r.g,this._b=r.b,this._a=r.a,this._roundA=g(100*this._a)/100,this._format=n.format||r.format,this._gradientType=n.gradientType,this._r<1&&(this._r=g(this._r)),this._g<1&&(this._g=g(this._g)),this._b<1&&(this._b=g(this._b)),this._ok=r.ok,this._tc_id=f++};b.prototype={isDark:function(){return this.getBrightness()<128},isLight:function(){return!this.isDark()},isValid:function(){return this._ok},getOriginalInput:function(){return this._originalInput},getFormat:function(){return this._format},getAlpha:function(){return this._a},getBrightness:function(){var t=this.toRgb();return(299*t.r+587*t.g+114*t.b)/1e3},setAlpha:function(t){return this._a=X(t),this._roundA=g(100*this._a)/100,this},toHsv:function(){var t=L(this._r,this._g,this._b);return{h:360*t.h,s:t.s,v:t.v,a:this._a}},toHsvString:function(){var t=L(this._r,this._g,this._b),e=g(360*t.h),n=g(100*t.s),r=g(100*t.v);return 1==this._a?'hsv('+e+', '+n+'%, '+r+'%)':'hsva('+e+', '+n+'%, '+r+'%, '+this._roundA+')'},toHsl:function(){var t=A(this._r,this._g,this._b);return{h:360*t.h,s:t.s,l:t.l,a:this._a}},toHslString:function(){var t=A(this._r,this._g,this._b),e=g(360*t.h),n=g(100*t.s),r=g(100*t.l);return 1==this._a?'hsl('+e+', '+n+'%, '+r+'%)':'hsla('+e+', '+n+'%, '+r+'%, '+this._roundA+')'},toHex:function(t){return N(this._r,this._g,this._b,t)},toHexString:function(t){return'#'+this.toHex(t)},toHex8:function(){return R(this._r,this._g,this._b,this._a)},toHex8String:function(){return'#'+this.toHex8()},toRgb:function(){return{r:g(this._r),g:g(this._g),b:g(this._b),a:this._a}},toRgbString:function(){return 1==this._a?'rgb('+g(this._r)+', '+g(this._g)+', '+g(this._b)+')':'rgba('+g(this._r)+', '+g(this._g)+', '+g(this._b)+', '+this._roundA+')'},toPercentageRgb:function(){return{r:g(100*J(this._r,255))+'%',g:g(100*J(this._g,255))+'%',b:g(100*J(this._b,255))+'%',a:this._a}},toPercentageRgbString:function(){return 1==this._a?'rgb('+g(100*J(this._r,255))+'%, '+g(100*J(this._g,255))+'%, '+g(100*J(this._b,255))+'%)':'rgba('+g(100*J(this._r,255))+'%, '+g(100*J(this._g,255))+'%, '+g(100*J(this._b,255))+'%, '+this._roundA+')'},toName:function(){return 0===this._a?'transparent':!(this._a<1)&&(k[N(this._r,this._g,this._b,!0)]||!1)},toFilter:function(t){var e='#'+R(this._r,this._g,this._b,this._a),n=e,r=this._gradientType?'GradientType = 1, ':'';t&&(n=b(t).toHex8String());return'progid:DXImageTransform.Microsoft.gradient('+r+'startColorstr='+e+',endColorstr='+n+')'},toString:function(t){var e=!!t;t=t||this._format;var n=!1,r=this._a<1&&this._a>=0;return e||!r||'hex'!==t&&'hex6'!==t&&'hex3'!==t&&'name'!==t?('rgb'===t&&(n=this.toRgbString()),'prgb'===t&&(n=this.toPercentageRgbString()),'hex'!==t&&'hex6'!==t||(n=this.toHexString()),'hex3'===t&&(n=this.toHexString(!0)),'hex8'===t&&(n=this.toHex8String()),'name'===t&&(n=this.toName()),'hsl'===t&&(n=this.toHslString()),'hsv'===t&&(n=this.toHsvString()),n||this.toHexString()):'name'===t&&0===this._a?this.toName():this.toRgbString()},_applyModification:function(t,e){var n=t.apply(null,[this].concat([].slice.call(e)));return this._r=n._r,this._g=n._g,this._b=n._b,this.setAlpha(n._a),this},lighten:function(){return this._applyModification(z,arguments)},brighten:function(){return this._applyModification(H,arguments)},darken:function(){return this._applyModification(B,arguments)},desaturate:function(){return this._applyModification(I,arguments)},saturate:function(){return this._applyModification(F,arguments)},greyscale:function(){return this._applyModification(V,arguments)},spin:function(){return this._applyModification(U,arguments)},_applyCombination:function(t,e){return t.apply(null,[this].concat([].slice.call(e)))},analogous:function(){return this._applyCombination(K,arguments)},complement:function(){return this._applyCombination($,arguments)},monochromatic:function(){return this._applyCombination(Y,arguments)},splitcomplement:function(){return this._applyCombination(G,arguments)},triad:function(){return this._applyCombination(W,arguments)},tetrad:function(){return this._applyCombination(q,arguments)}},b.fromRatio=function(t,e){if('object'==l()(t)){var n={};for(var r in t)t.hasOwnProperty(r)&&(n[r]='a'===r?t[r]:et(t[r]));t=n}return b(t,e)},b.equals=function(t,e){return!(!t||!e)&&b(t).toRgbString()==b(e).toRgbString()},b.random=function(){return b.fromRatio({r:y(),g:y(),b:y()})},b.mix=function(t,e,n){n=0===n?0:n||50;var r,i=b(t).toRgb(),o=b(e).toRgb(),a=n/100,s=2*a-1,c=o.a-i.a,l=1-(r=((r=s*c==-1?s:(s+c)/(1+s*c))+1)/2),u={r:o.r*r+i.r*l,g:o.g*r+i.g*l,b:o.b*r+i.b*l,a:o.a*a+i.a*(1-a)};return b(u)},b.readability=function(t,e){var n=b(t),r=b(e),i=n.toRgb(),o=r.toRgb(),a=n.getBrightness(),s=r.getBrightness(),c=Math.max(i.r,o.r)-Math.min(i.r,o.r)+Math.max(i.g,o.g)-Math.min(i.g,o.g)+Math.max(i.b,o.b)-Math.min(i.b,o.b);return{brightness:Math.abs(a-s),color:c}},b.isReadable=function(t,e){var n=b.readability(t,e);return n.brightness>125&&n.color>500},b.mostReadable=function(t,e){for(var n=null,r=0,i=!1,o=0;o<e.length;o++){var a=b.readability(t,e[o]),s=a.brightness>125&&a.color>500,c=3*(a.brightness/125)+a.color/500;(s&&!i||s&&i&&c>r||!s&&!i&&c>r)&&(i=s,r=c,n=b(e[o]))}return n};var w,O,x,C=b.names={aliceblue:'f0f8ff',antiquewhite:'faebd7',aqua:'0ff',aquamarine:'7fffd4',azure:'f0ffff',beige:'f5f5dc',bisque:'ffe4c4',black:'000',blanchedalmond:'ffebcd',blue:'00f',blueviolet:'8a2be2',brown:'a52a2a',burlywood:'deb887',burntsienna:'ea7e5d',cadetblue:'5f9ea0',chartreuse:'7fff00',chocolate:'d2691e',coral:'ff7f50',cornflowerblue:'6495ed',cornsilk:'fff8dc',crimson:'dc143c',cyan:'0ff',darkblue:'00008b',darkcyan:'008b8b',darkgoldenrod:'b8860b',darkgray:'a9a9a9',darkgreen:'006400',darkgrey:'a9a9a9',darkkhaki:'bdb76b',darkmagenta:'8b008b',darkolivegreen:'556b2f',darkorange:'ff8c00',darkorchid:'9932cc',darkred:'8b0000',darksalmon:'e9967a',darkseagreen:'8fbc8f',darkslateblue:'483d8b',darkslategray:'2f4f4f',darkslategrey:'2f4f4f',darkturquoise:'00ced1',darkviolet:'9400d3',deeppink:'ff1493',deepskyblue:'00bfff',dimgray:'696969',dimgrey:'696969',dodgerblue:'1e90ff',firebrick:'b22222',floralwhite:'fffaf0',forestgreen:'228b22',fuchsia:'f0f',gainsboro:'dcdcdc',ghostwhite:'f8f8ff',gold:'ffd700',goldenrod:'daa520',gray:'808080',green:'008000',greenyellow:'adff2f',grey:'808080',honeydew:'f0fff0',hotpink:'ff69b4',indianred:'cd5c5c',indigo:'4b0082',ivory:'fffff0',khaki:'f0e68c',lavender:'e6e6fa',lavenderblush:'fff0f5',lawngreen:'7cfc00',lemonchiffon:'fffacd',lightblue:'add8e6',lightcoral:'f08080',lightcyan:'e0ffff',lightgoldenrodyellow:'fafad2',lightgray:'d3d3d3',lightgreen:'90ee90',lightgrey:'d3d3d3',lightpink:'ffb6c1',lightsalmon:'ffa07a',lightseagreen:'20b2aa',lightskyblue:'87cefa',lightslategray:'789',lightslategrey:'789',lightsteelblue:'b0c4de',lightyellow:'ffffe0',lime:'0f0',limegreen:'32cd32',linen:'faf0e6',magenta:'f0f',maroon:'800000',mediumaquamarine:'66cdaa',mediumblue:'0000cd',mediumorchid:'ba55d3',mediumpurple:'9370db',mediumseagreen:'3cb371',mediumslateblue:'7b68ee',mediumspringgreen:'00fa9a',mediumturquoise:'48d1cc',mediumvioletred:'c71585',midnightblue:'191970',mintcream:'f5fffa',mistyrose:'ffe4e1',moccasin:'ffe4b5',navajowhite:'ffdead',navy:'000080',oldlace:'fdf5e6',olive:'808000',olivedrab:'6b8e23',orange:'ffa500',orangered:'ff4500',orchid:'da70d6',palegoldenrod:'eee8aa',palegreen:'98fb98',paleturquoise:'afeeee',palevioletred:'db7093',papayawhip:'ffefd5',peachpuff:'ffdab9',peru:'cd853f',pink:'ffc0cb',plum:'dda0dd',powderblue:'b0e0e6',purple:'800080',rebeccapurple:'663399',red:'f00',rosybrown:'bc8f8f',royalblue:'4169e1',saddlebrown:'8b4513',salmon:'fa8072',sandybrown:'f4a460',seagreen:'2e8b57',seashell:'fff5ee',sienna:'a0522d',silver:'c0c0c0',skyblue:'87ceeb',slateblue:'6a5acd',slategray:'708090',slategrey:'708090',snow:'fffafa',springgreen:'00ff7f',steelblue:'4682b4',tan:'d2b48c',teal:'008080',thistle:'d8bfd8',tomato:'ff6347',turquoise:'40e0d0',violet:'ee82ee',wheat:'f5deb3',white:'fff',whitesmoke:'f5f5f5',yellow:'ff0',yellowgreen:'9acd32'},k=b.hexNames=function(t){var e={};for(var n in t)t.hasOwnProperty(n)&&(e[t[n]]=n);return e}(C),S=(O='[\\s|\\(]+('+(w='(?:'+'[-\\+]?\\d*\\.\\d+%?'+')|(?:'+'[-\\+]?\\d+%?'+')')+')[,|\\s]+('+w+')[,|\\s]+('+w+')\\s*\\)?',x='[\\s|\\(]+('+w+')[,|\\s]+('+w+')[,|\\s]+('+w+')[,|\\s]+('+w+')\\s*\\)?',{rgb:new RegExp('rgb'+O),rgba:new RegExp('rgba'+x),hsl:new RegExp('hsl'+O),hsla:new RegExp('hsla'+x),hsv:new RegExp('hsv'+O),hsva:new RegExp('hsva'+x),hex3:/^([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})$/,hex6:/^([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})$/,hex8:/^([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})$/});window.tinycolor=b,t((function(){t.fn.spectrum.load&&t.fn.spectrum.processNativeColorInputs()}))}function j(e,n,r,i){for(var a=[],s=0;s<e.length;s++){var c=e[s];if(c){var l=b(c),u=l.toHsl().l<.5?'sp-thumb-el sp-thumb-dark':'sp-thumb-el sp-thumb-light';u+=b.equals(n,c)?' sp-thumb-active':'';var d=l.toString(i.preferredFormat||'rgb'),h=o?'background-color:'+l.toRgbString():'filter:'+l.toFilter();a.push('<span title="'+d+'" data-color="'+l.toRgbString()+'" class="'+u+'"><span class="sp-thumb-inner" style="'+h+';"></span></span>')}else{a.push(t('<div />').append(t('<span data-color="" style="background-color:transparent;" class="'+'sp-clear-display'+'"></span>').attr('title',i.noColorSelectedText)).html())}}return"<div class='sp-cf "+r+"'>"+a.join('')+'</div>'}function T(c,l){var u,d,h,f,p=function(e,r){var i=t.extend({},n,e);return i.callbacks={move:_(i.move,r),change:_(i.change,r),show:_(i.show,r),hide:_(i.hide,r),beforeShow:_(i.beforeShow,r)},i}(l,c),g=p.flat,v=p.showSelectionPalette,m=p.localStorageKey,y=p.theme,w=p.callbacks,O=(u=Wt,d=10,function(){var t=this,e=arguments,n=function(){f=null,u.apply(t,e)};h&&clearTimeout(f),!h&&f||(f=setTimeout(n,d))}),x=!1,C=!1,k=!0,S=0,T=0,P=0,A=0,L=0,N=0,R=0,I=0,F=0,V=0,z=1,H=[],B=[],U={},$=p.selectionPalette.slice(0),W=p.maxSelectionSize,q='sp-dragging',G=null,K=c.ownerDocument,Y=(K.body,t(c)),X=!1,J=t(s,K).addClass(y),Z=J.find('.sp-picker-container'),Q=J.find('.sp-color'),tt=J.find('.sp-dragger'),et=J.find('.sp-hue'),nt=J.find('.sp-slider'),rt=J.find('.sp-alpha-inner'),it=J.find('.sp-alpha'),ot=J.find('.sp-alpha-handle'),at=J.find('.sp-input'),st=J.find('.sp-palette'),ct=J.find('.sp-initial'),lt=J.find('.sp-cancel'),ut=J.find('.sp-clear'),dt=J.find('.sp-choose'),ht=J.find('.sp-palette-toggle'),ft=Y.is('input'),pt=ft&&'color'===Y.attr('type')&&D(),gt=ft&&!g,vt=gt?t(a).addClass(y).addClass(p.className).addClass(p.replacerClassName):t([]),mt=gt?vt:Y,yt=vt.find('.sp-preview-inner'),bt=p.color||ft&&Y.val(),wt=!1,Ot=p.preferredFormat,xt=!p.showButtons||p.clickoutFiresChange,Ct=!bt,kt=p.allowEmpty&&!pt;function St(){if(p.showPaletteOnly&&(p.showPalette=!0),ht.text(p.showPaletteOnly?p.togglePaletteMoreText:p.togglePaletteLessText),p.palette){H=p.palette.slice(0),B=t.isArray(H[0])?H:[H],U={};for(var e=0;e<B.length;e++)for(var n=0;n<B[e].length;n++){var r=b(B[e][n]).toRgbString();U[r]=!0}}J.toggleClass('sp-flat',g),J.toggleClass('sp-input-disabled',!p.showInput),J.toggleClass('sp-alpha-enabled',p.showAlpha),J.toggleClass('sp-clear-enabled',kt),J.toggleClass('sp-buttons-disabled',!p.showButtons),J.toggleClass('sp-palette-buttons-disabled',!p.togglePaletteOnly),J.toggleClass('sp-palette-disabled',!p.showPalette),J.toggleClass('sp-palette-only',p.showPaletteOnly),J.toggleClass('sp-initial-disabled',!p.showInitial),J.addClass(p.className).addClass(p.containerClassName),Wt()}function jt(){if(m&&window.localStorage){try{var e=window.localStorage[m].split(',#');e.length>1&&(delete window.localStorage[m],t.each(e,(function(t,e){Tt(e)})))}catch(t){}try{$=window.localStorage[m].split(';')}catch(t){}}}function Tt(e){if(v){var n=b(e).toRgbString();if(!U[n]&&-1===t.inArray(n,$))for($.push(n);$.length>W;)$.shift();if(m&&window.localStorage)try{window.localStorage[m]=$.join(';')}catch(t){}}}function Pt(){var e=zt(),n=t.map(B,(function(t,n){return j(t,e,'sp-palette-row sp-palette-row-'+n,p)}));jt(),$&&n.push(j(function(){var t=[];if(p.showPalette)for(var e=0;e<$.length;e++){var n=b($[e]).toRgbString();U[n]||t.push($[e])}return t.reverse().slice(0,p.maxSelectionSize)}(),e,'sp-palette-row sp-palette-row-selection',p)),st.html(n.join(''))}function Et(){if(p.showInitial){var t=wt,e=zt();ct.html(j([t,e],e,'sp-palette-row-initial',p))}}function _t(){(T<=0||S<=0||A<=0)&&Wt(),C=!0,J.addClass(q),G=null,Y.trigger('dragstart.spectrum',[zt()])}function Mt(){C=!1,J.removeClass(q),Y.trigger('dragstop.spectrum',[zt()])}function Dt(){var t=at.val();if(null!==t&&''!==t||!kt){var e=b(t);e.isValid()?(Vt(e),$t(!0)):at.addClass('sp-validation-error')}else Vt(null),$t(!0)}function At(){x?It():Lt()}function Lt(){var e=t.Event('beforeShow.spectrum');if(x)Wt();else if(Y.trigger('beforeShow.spectrum',[zt()]),!1!==w.beforeShow(zt())&&!e.isDefaultPrevented()){!function(){for(var t=0;t<r.length;t++)r[t]&&r[t].hide()}(),x=!0;var n=t(K);n.bind('keydown.spectrum',Nt),n.bind('click.spectrum',Rt),t(window).bind('resize.spectrum',O),vt.addClass('sp-active'),J.removeClass('sp-hidden'),Wt(),Bt(),wt=zt(),Et(),w.show(wt),Y.trigger('show.spectrum',[wt])}}function Nt(t){27===t.keyCode&&It()}function Rt(t){2!=t.button&&(C||(xt?$t(!0):Ft(),It()))}function It(){x&&!g&&(x=!1,t(K).unbind('keydown.spectrum',Nt),t(K).unbind('click.spectrum',Rt),t(window).unbind('resize.spectrum',O),vt.removeClass('sp-active'),J.addClass('sp-hidden'),w.hide(zt()),Y.trigger('hide.spectrum',[zt()]))}function Ft(){Vt(wt,!0)}function Vt(t,e){var n,r;b.equals(t,zt())?Bt():(!t&&kt?Ct=!0:(Ct=!1,k=!t,r=(n=b(t)).toHsv(),I=r.h%360/360,F=r.s,V=r.v,z=r.a),Bt(),n&&n.isValid()&&!e&&(Ot=p.preferredFormat||n.getFormat()))}function zt(t){return t=t||{},kt&&Ct?null:b.fromRatio({h:I,s:F,v:V,a:Math.round(100*z)/100},{format:t.format||Ot})}function Ht(){Bt(),w.move(zt()),Y.trigger('move.spectrum',[zt()])}function Bt(){at.removeClass('sp-validation-error'),Ut();var t=b.fromRatio({h:I,s:1,v:1});Q.css('background-color',t.toHexString());var e=Ot;z<1&&(0!==z||'name'!==e)&&('hex'!==e&&'hex3'!==e&&'hex6'!==e&&'name'!==e||(e='rgb'));var n=zt({format:e}),r='';if(yt.removeClass('sp-clear-display'),yt.css('background-color','transparent'),!n&&kt)yt.addClass('sp-clear-display');else{var a=n.toHexString(),s=n.toRgbString();if(o||1===n.alpha?yt.css('background-color',s):(yt.css('background-color','transparent'),yt.css('filter',n.toFilter())),p.showAlpha){var c=n.toRgb();c.a=0;var l=b(c).toRgbString(),u='linear-gradient(left, '+l+', '+a+')';i?rt.css('filter',b(l).toFilter({gradientType:1},a)):(rt.css('background','-webkit-'+u),rt.css('background','-moz-'+u),rt.css('background','-ms-'+u),rt.css('background','linear-gradient(to right, '+l+', '+a+')'))}r=n.toString(e)}p.showInput&&at.val(r),p.showPalette&&Pt(),Et()}function Ut(){var t=F,e=V;if(kt&&Ct)ot.hide(),nt.hide(),tt.hide();else{ot.show(),nt.show(),tt.show();var n=t*S,r=T-e*T;n=Math.max(-P,Math.min(S-P,n-P)),r=Math.max(-P,Math.min(T-P,r-P)),tt.css({top:r+'px',left:n+'px'});var i=z*L;ot.css({left:i-N/2+'px'});var o=I*A;nt.css({top:o-R+'px'})}}function $t(t){var e=zt(),n='',r=!!k||!b.equals(e,wt);e&&(n=e.toString(Ot),Tt(e)),ft&&Y.val(n),t&&r&&(w.change(e),Y.trigger('change',[e]))}function Wt(){x&&(S=Q.width(),T=Q.height(),P=tt.height(),et.width(),A=et.height(),R=nt.height(),L=it.width(),N=ot.width(),g||(J.css('position','absolute'),p.offset?J.offset(p.offset):J.offset(function(e,n){var r=0,i=e.outerWidth(),o=e.outerHeight(),a=n.outerHeight(),s=e[0].ownerDocument,c=s.documentElement,l=c.clientWidth,u=c.clientHeight,d=t(s).scrollLeft(),h=t(s).scrollTop(),f=l+d,p=u+h,g=n.offset();return g.top+=a,g.left-=Math.min(g.left,g.left+i>f&&f>i?Math.abs(g.left+i-f):0),g.top-=Math.min(g.top,g.top+o>p&&p>o?Math.abs(o+a-r):r),g}(J,mt))),Ut(),p.showPalette&&Pt(),Y.trigger('reflow.spectrum'))}function qt(){It(),X=!0,Y.attr('disabled',!0),mt.addClass('sp-disabled')}!function(){if(i&&J.find('*:not(input)').attr('unselectable','on'),St(),gt&&Y.after(vt).hide(),kt||ut.hide(),g)Y.after(J).hide();else{var e='parent'===p.appendTo?Y.parent():t(p.appendTo);1!==e.length&&(e=t('body')),e.append(J)}function n(e){return e.data&&e.data.ignore?(Vt(t(e.target).closest('.sp-thumb-el').data('color')),Ht()):(Vt(t(e.target).closest('.sp-thumb-el').data('color')),Ht(),$t(!0),p.hideAfterPaletteSelect&&It()),!1}jt(),mt.bind('click.spectrum touchstart.spectrum',(function(e){X||At(),e.stopPropagation(),t(e.target).is('input')||e.preventDefault()})),(Y.is(':disabled')||!0===p.disabled)&&qt(),J.click(E),at.change(Dt),at.bind('paste',(function(){setTimeout(Dt,1)})),at.keydown((function(t){13==t.keyCode&&Dt()})),lt.text(p.cancelText),lt.bind('click.spectrum',(function(t){t.stopPropagation(),t.preventDefault(),Ft(),It()})),ut.attr('title',p.clearText),ut.bind('click.spectrum',(function(t){t.stopPropagation(),t.preventDefault(),Ct=!0,Ht(),g&&$t(!0)})),dt.text(p.chooseText),dt.bind('click.spectrum',(function(t){t.stopPropagation(),t.preventDefault(),i&&at.is(':focus')&&at.trigger('change'),at.hasClass('sp-validation-error')||($t(!0),It())})),ht.text(p.showPaletteOnly?p.togglePaletteMoreText:p.togglePaletteLessText),ht.bind('click.spectrum',(function(t){t.stopPropagation(),t.preventDefault(),p.showPaletteOnly=!p.showPaletteOnly,p.showPaletteOnly||g||J.css('left','-='+(Z.outerWidth(!0)+5)),St()})),M(it,(function(t,e,n){z=t/L,Ct=!1,n.shiftKey&&(z=Math.round(10*z)/10),Ht()}),_t,Mt),M(et,(function(t,e){I=parseFloat(e/A),Ct=!1,p.showAlpha||(z=1),Ht()}),_t,Mt),M(Q,(function(t,e,n){if(n.shiftKey){if(!G){var r=F*S,i=T-V*T,o=Math.abs(t-r)>Math.abs(e-i);G=o?'x':'y'}}else G=null;var a=!G||'y'===G;(!G||'x'===G)&&(F=parseFloat(t/S)),a&&(V=parseFloat((T-e)/T)),Ct=!1,p.showAlpha||(z=1),Ht()}),_t,Mt),bt?(Vt(bt),Bt(),Ot=p.preferredFormat||b(bt).getFormat(),Tt(bt)):Bt(),g&&Lt();var r=i?'mousedown.spectrum':'click.spectrum touchstart.spectrum';st.delegate('.sp-thumb-el',r,n),ct.delegate('.sp-thumb-el:nth-child(1)',r,{ignore:!0},n)}();var Gt={show:Lt,hide:It,toggle:At,reflow:Wt,option:function(n,r){return n===e?t.extend({},p):r===e?p[n]:(p[n]=r,'preferredFormat'===n&&(Ot=p.preferredFormat),void St())},enable:function(){X=!1,Y.attr('disabled',!1),mt.removeClass('sp-disabled')},disable:qt,offset:function(t){p.offset=t,Wt()},set:function(t){Vt(t),$t()},get:zt,destroy:function(){Y.show(),mt.unbind('click.spectrum touchstart.spectrum'),J.remove(),vt.remove(),r[Gt.id]=null},container:J};return Gt.id=r.push(Gt)-1,Gt}function P(){}function E(t){t.stopPropagation()}function _(t,e){var n=Array.prototype.slice,r=n.call(arguments,2);return function(){return t.apply(e,r.concat(n.call(arguments)))}}function M(e,n,r,o){n=n||function(){},r=r||function(){},o=o||function(){};var a=document,s=!1,c={},l=0,u=0,d='ontouchstart'in window,h={};function f(t){t.stopPropagation&&t.stopPropagation(),t.preventDefault&&t.preventDefault(),t.returnValue=!1}function p(t){if(s){if(i&&a.documentMode<9&&!t.button)return g();var r=t&&t.touches&&t.touches[0],o=r&&r.pageX||t.pageX,h=r&&r.pageY||t.pageY,p=Math.max(0,Math.min(o-c.left,u)),v=Math.max(0,Math.min(h-c.top,l));d&&f(t),n.apply(e,[p,v,t])}}function g(){s&&(t(a).unbind(h),t(a.body).removeClass('sp-dragging'),setTimeout((function(){o.apply(e,arguments)}),0)),s=!1}h['selectstart']=f,h['dragstart']=f,h['touchmove mousemove']=p,h['touchend mouseup']=g,t(e).bind('touchstart mousedown',(function(n){var i=n.which?3==n.which:2==n.button;i||s||!1!==r.apply(e,arguments)&&(s=!0,l=t(e).height(),u=t(e).width(),c=t(e).offset(),t(a).bind(h),t(a.body).addClass('sp-dragging'),p(n),f(n))}))}function D(){return t.fn.spectrum.inputTypeColorSupport()}function A(t,e,n){t=J(t,255),e=J(e,255),n=J(n,255);var r,i,o=m(t,e,n),a=v(t,e,n),s=(o+a)/2;if(o==a)r=i=0;else{var c=o-a;switch(i=s>.5?c/(2-o-a):c/(o+a),o){case t:r=(e-n)/c+(e<n?6:0);break;case e:r=(n-t)/c+2;break;case n:r=(t-e)/c+4}r/=6}return{h:r,s:i,l:s}}function L(t,e,n){t=J(t,255),e=J(e,255),n=J(n,255);var r,i,o=m(t,e,n),a=v(t,e,n),s=o,c=o-a;if(i=0===o?0:c/o,o==a)r=0;else{switch(o){case t:r=(e-n)/c+(e<n?6:0);break;case e:r=(n-t)/c+2;break;case n:r=(t-e)/c+4}r/=6}return{h:r,s:i,v:s}}function N(t,e,n,r){var i=[tt(g(t).toString(16)),tt(g(e).toString(16)),tt(g(n).toString(16))];return r&&i[0].charAt(0)==i[0].charAt(1)&&i[1].charAt(0)==i[1].charAt(1)&&i[2].charAt(0)==i[2].charAt(1)?i[0].charAt(0)+i[1].charAt(0)+i[2].charAt(0):i.join('')}function R(t,e,n,r){var i;return[tt((i=r,Math.round(255*parseFloat(i)).toString(16))),tt(g(t).toString(16)),tt(g(e).toString(16)),tt(g(n).toString(16))].join('')}function I(t,e){e=0===e?0:e||10;var n=b(t).toHsl();return n.s-=e/100,n.s=Z(n.s),b(n)}function F(t,e){e=0===e?0:e||10;var n=b(t).toHsl();return n.s+=e/100,n.s=Z(n.s),b(n)}function V(t){return b(t).desaturate(100)}function z(t,e){e=0===e?0:e||10;var n=b(t).toHsl();return n.l+=e/100,n.l=Z(n.l),b(n)}function H(t,e){e=0===e?0:e||10;var n=b(t).toRgb();return n.r=m(0,v(255,n.r-g(255*(-e/100)))),n.g=m(0,v(255,n.g-g(255*(-e/100)))),n.b=m(0,v(255,n.b-g(255*(-e/100)))),b(n)}function B(t,e){e=0===e?0:e||10;var n=b(t).toHsl();return n.l-=e/100,n.l=Z(n.l),b(n)}function U(t,e){var n=b(t).toHsl(),r=(g(n.h)+e)%360;return n.h=r<0?360+r:r,b(n)}function $(t){var e=b(t).toHsl();return e.h=(e.h+180)%360,b(e)}function W(t){var e=b(t).toHsl(),n=e.h;return[b(t),b({h:(n+120)%360,s:e.s,l:e.l}),b({h:(n+240)%360,s:e.s,l:e.l})]}function q(t){var e=b(t).toHsl(),n=e.h;return[b(t),b({h:(n+90)%360,s:e.s,l:e.l}),b({h:(n+180)%360,s:e.s,l:e.l}),b({h:(n+270)%360,s:e.s,l:e.l})]}function G(t){var e=b(t).toHsl(),n=e.h;return[b(t),b({h:(n+72)%360,s:e.s,l:e.l}),b({h:(n+216)%360,s:e.s,l:e.l})]}function K(t,e,n){e=e||6,n=n||30;var r=b(t).toHsl(),i=360/n,o=[b(t)];for(r.h=(r.h-(i*e>>1)+720)%360;--e;)r.h=(r.h+i)%360,o.push(b(r));return o}function Y(t,e){e=e||6;for(var n=b(t).toHsv(),r=n.h,i=n.s,o=n.v,a=[],s=1/e;e--;)a.push(b({h:r,s:i,v:o})),o=(o+s)%1;return a}function X(t){return t=parseFloat(t),(isNaN(t)||t<0||t>1)&&(t=1),t}function J(t,e){(function(t){return'string'==typeof t&&-1!=t.indexOf('.')&&1===parseFloat(t)})(t)&&(t='100%');var n=function(t){return'string'==typeof t&&-1!=t.indexOf('%')}(t);return t=v(e,m(0,parseFloat(t))),n&&(t=parseInt(t*e,10)/100),p.abs(t-e)<1e-6?1:t%e/parseFloat(e)}function Z(t){return v(1,m(0,t))}function Q(t){return parseInt(t,16)}function tt(t){return 1==t.length?'0'+t:''+t}function et(t){return t<=1&&(t=100*t+'%'),t}}(p);var g=function(t){var e='name'===t.getFormat()&&t.toName(),n=1==t.getAlpha()?t.toHexString():t.toRgbString();return e||n.replace(/ /g,'')};e["a"]=d["a"].extend({template:function(){var t=this.ppfx;return"\n      <div class=\"".concat(this.holderClass(),"\"></div>\n      <div class=\"").concat(t,"field-colorp\">\n        <div class=\"").concat(t,"field-colorp-c\" data-colorp-c>\n          <div class=\"").concat(t,"checker-bg\"></div>\n        </div>\n      </div>\n    ")},inputClass:function(){var t=this.ppfx;return"".concat(t,"field ").concat(t,"field-color")},holderClass:function(){return"".concat(this.ppfx,"input-holder")},remove:function(){d["a"].prototype.remove.apply(this,arguments),this.colorEl.spectrum('destroy')},__onInputChange:function(t){var e=t,n=this.getColorEl();if(n){n.spectrum('set',e);var r=n.spectrum('get'),i=e&&g(r);i&&(e=i)}this.model.set({value:e},{fromInput:1})},setValue:function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},n=this.model,r=n.get('defaults'),i=Object(s["isUndefined"])(t)?Object(s["isUndefined"])(r)?'':r:t,o=this.getInputEl(),a=this.getColorEl(),c='none'!=i?i:'';o.value=i,a.get(0).style.backgroundColor=c,(e.fromTarget||e.fromInput&&!e.avoidStore)&&(a.spectrum('set',c),this.noneColor='none'==i)},getColorEl:function(){if(!this.colorEl){var t,e=this.em,n=this,r=this.ppfx,i=this.model,o=p("<div class=\"".concat(this.ppfx,"field-color-picker\"></div>")),a=o.get(0).style,s=e&&e.config?e.config.el:'',c=e&&e.getConfig&&e.getConfig('colorPicker')||{},l=0;this.$el.find("[data-colorp-c]").append(o),o.spectrum(f(f(f({color:i.getValue()||!1,containerClassName:"".concat(r,"one-bg ").concat(r,"two-color"),appendTo:s||'body',maxSelectionSize:8,showPalette:!0,showAlpha:!0,chooseText:'Ok',cancelText:'⨯',palette:[]},c),i.get('colorPicker')||{}),{},{move:function(t){var e=g(t);a.backgroundColor=e,i.setValueFromInput(e,0)},change:function(t){l=1;var e=g(t);a.backgroundColor=e,i.setValueFromInput(0,0),i.setValueFromInput(e),n.noneColor=0},show:function(e){l=0,t=g(e)},hide:function(e){!l&&t&&(n.noneColor&&(t=''),a.backgroundColor=t,o.spectrum('set',t),i.setValueFromInput(t,0))}})),e&&e.on&&this.listenTo(e,'component:selected',(function(){l=1,o.spectrum('hide')})),this.colorEl=o}return this.colorEl},render:function(){return d["a"].prototype.render.call(this),this.getColorEl(),this}})},function(t,e,n){"use strict";(function(t){var r=n(14),i=n.n(r),o=n(77),a=n(78),s=setTimeout;function c(t){return Boolean(t&&void 0!==t.length)}function l(){}function u(t){if(!(this instanceof u))throw new TypeError('Promises must be constructed via new');if('function'!=typeof t)throw new TypeError('not a function');this._state=0,this._handled=!1,this._value=void 0,this._deferreds=[],v(t,this)}function d(t,e){for(;3===t._state;)t=t._value;0!==t._state?(t._handled=!0,u._immediateFn((function(){var n=1===t._state?e.onFulfilled:e.onRejected;if(null!==n){var r;try{r=n(t._value)}catch(t){return void f(e.promise,t)}h(e.promise,r)}else(1===t._state?h:f)(e.promise,t._value)}))):t._deferreds.push(e)}function h(t,e){try{if(e===t)throw new TypeError('A promise cannot be resolved with itself.');if(e&&('object'===i()(e)||'function'==typeof e)){var n=e.then;if(e instanceof u)return t._state=3,t._value=e,void p(t);if('function'==typeof n)return void v((r=n,o=e,function(){r.apply(o,arguments)}),t)}t._state=1,t._value=e,p(t)}catch(e){f(t,e)}var r,o}function f(t,e){t._state=2,t._value=e,p(t)}function p(t){2===t._state&&0===t._deferreds.length&&u._immediateFn((function(){t._handled||u._unhandledRejectionFn(t._value)}));for(var e=0,n=t._deferreds.length;e<n;e++)d(t,t._deferreds[e]);t._deferreds=null}function g(t,e,n){this.onFulfilled='function'==typeof t?t:null,this.onRejected='function'==typeof e?e:null,this.promise=n}function v(t,e){var n=!1;try{t((function(t){n||(n=!0,h(e,t))}),(function(t){n||(n=!0,f(e,t))}))}catch(t){if(n)return;n=!0,f(e,t)}}u.prototype['catch']=function(t){return this.then(null,t)},u.prototype.then=function(t,e){var n=new this.constructor(l);return d(this,new g(t,e,n)),n},u.prototype['finally']=o["a"],u.all=function(t){return new u((function(e,n){if(!c(t))return n(new TypeError('Promise.all accepts an array'));var r=Array.prototype.slice.call(t);if(0===r.length)return e([]);var o=r.length;function a(t,s){try{if(s&&('object'===i()(s)||'function'==typeof s)){var c=s.then;if('function'==typeof c)return void c.call(s,(function(e){a(t,e)}),n)}r[t]=s,0==--o&&e(r)}catch(t){n(t)}}for(var s=0;s<r.length;s++)a(s,r[s])}))},u.allSettled=a["a"],u.resolve=function(t){return t&&'object'===i()(t)&&t.constructor===u?t:new u((function(e){e(t)}))},u.reject=function(t){return new u((function(e,n){n(t)}))},u.race=function(t){return new u((function(e,n){if(!c(t))return n(new TypeError('Promise.race accepts an array'));for(var r=0,i=t.length;r<i;r++)u.resolve(t[r]).then(e,n)}))},u._immediateFn='function'==typeof t&&function(e){t(e)}||function(t){s(t,0)},u._unhandledRejectionFn=function(t){'undefined'!=typeof console&&console&&console.warn('Possible Unhandled Promise Rejection:',t)},e["a"]=u}).call(this,n(84).setImmediate)},function(t,e,n){"use strict";n.r(e),n.d(e,"evAll",(function(){return F})),n.d(e,"evPfx",(function(){return V})),n.d(e,"evPageSelect",(function(){return z})),n.d(e,"evPageSelectBefore",(function(){return H})),n.d(e,"evPageUpdate",(function(){return B})),n.d(e,"evPageAdd",(function(){return U})),n.d(e,"evPageAddBefore",(function(){return $})),n.d(e,"evPageRemove",(function(){return W})),n.d(e,"evPageRemoveBefore",(function(){return q}));var r=n(11),i=n.n(r),o=n(3),a=n.n(o),s=n(0),c=n(1),l=n(2),u=n(5),d=n.n(u),h=n(6),f=n.n(h),p=n(8),g=n.n(p),v=n(9),m=n.n(v),y=n(4),b=n.n(y);function w(t,e){var n=Object.keys(t);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(t);e&&(r=r.filter((function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable}))),n.push.apply(n,r)}return n}function O(t){for(var e=1;e<arguments.length;e++){var n=null!=arguments[e]?arguments[e]:{};e%2?w(Object(n),!0).forEach((function(e){a()(t,e,n[e])})):Object.getOwnPropertyDescriptors?Object.defineProperties(t,Object.getOwnPropertyDescriptors(n)):w(Object(n)).forEach((function(e){Object.defineProperty(t,e,Object.getOwnPropertyDescriptor(n,e))}))}return t}function x(t){var e=function(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],(function(){}))),!0}catch(t){return!1}}();return function(){var n,r=b()(t);if(e){var i=b()(this).constructor;n=Reflect.construct(r,arguments,i)}else n=r.apply(this,arguments);return m()(this,n)}}var C='__aw',k='__ah',S=function(t){g()(n,t);var e=x(n);function n(){return d()(this,n),e.apply(this,arguments)}return f()(n,[{key:"defaults",value:function(){return{x:0,y:0,changesCount:0,attributes:{},width:null,height:null,head:[],component:'',styles:'',_undo:!0,_undoexc:['changesCount']}}},{key:"initialize",value:function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},n=e.config,r=n.em,i=this.attributes,o=i.styles,a=i.component,l=r.get('DomComponents'),u=l.getConfig(),d=r.get('CssComposer').getAll(),h={};this.em=r;var f={em:r,config:u,frame:this,idMap:h};if(!Object(c["isComponent"])(a)){var p=Object(c["isObject"])(a)?a:{components:a};!p.type&&(p.type='wrapper');var g=l.getType('wrapper').model;this.set('component',new g(p,f))}if(o){if(!Object(c["isObject"])(o)){var v=Object.keys(h);v.length&&Array.isArray(o)&&o.forEach((function(t){var e=t.selectors;if(e&&1==e.length){var n=e[0],r=n.name&&2===n.type&&n;if(r&&h[r.name])r.name=h[r.name];else if(Object(s["isString"])(n)&&'#'===n[0]){var i=n.substring(1);i&&h[i]&&(e[0]="#".concat(h[i]))}}})),d.add(o),this.set('styles',d)}}else this.set('styles',d);!t.width&&this.set(C,1),!t.height&&this.set(k,1)}},{key:"onRemove",value:function(){this.getComponent().remove({root:1})}},{key:"changesUp",value:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};t.temporary||t.noCount||t.avoidStore||this.set('changesCount',this.get('changesCount')+1)}},{key:"getComponent",value:function(){return this.get('component')}},{key:"getStyles",value:function(){return this.get('styles')}},{key:"disable",value:function(){this.trigger('disable')}},{key:"remove",value:function(){this.view=0;var t=this.collection;return t&&t.remove(this)}},{key:"getHead",value:function(){var t=this.get('head')||[];return i()(t)}},{key:"setHead",value:function(t){return this.set('head',i()(t))}},{key:"addHeadItem",value:function(t){var e=this.getHead();e.push(t),this.setHead(e)}},{key:"getHeadByAttr",value:function(t,e,n){return this.getHead().filter((function(r){return r.attributes&&r.attributes[t]==e&&(!n||n===r.tag)}))[0]}},{key:"removeHeadByAttr",value:function(t,e,n){var r=this.getHead(),i=this.getHeadByAttr(t,e,n),o=r.indexOf(i);o>=0&&(r.splice(o,1),this.setHead(r))}},{key:"addLink",value:function(t){var e='link';!this.getHeadByAttr('href',t,e)&&this.addHeadItem({tag:e,attributes:{href:t,rel:'stylesheet'}})}},{key:"removeLink",value:function(t){this.removeHeadByAttr('href',t,'link')}},{key:"addScript",value:function(t){var e='script';!this.getHeadByAttr('src',t,e)&&this.addHeadItem({tag:e,attributes:{src:t}})}},{key:"removeScript",value:function(t){this.removeHeadByAttr('src',t,'script')}},{key:"getPage",value:function(){var t=this.collection;return t&&t.page}},{key:"_emitUpdated",value:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};this.em.trigger('frame:updated',O({frame:this},t))}},{key:"toJSON",value:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},e=l["Model"].prototype.toJSON.call(this,t),n=this.em,r=n&&n.get('StorageManager'),i=r&&r.getConfig(),o=Object(s["result"])(this,'defaults');if(i&&!t.fromUndo){var a={component:this.getComponent()};i.storeHtml&&(e.html=n.getHtml(a)),i.storeCss&&(e.css=n.getCss(a))}return t.fromUndo&&delete e.component,delete e.styles,delete e.changesCount,e[C]&&delete e.width,e[k]&&delete e.height,Object(s["forEach"])(e,(function(t,n){0===n.indexOf('_')&&delete e[n]})),Object(s["forEach"])(o,(function(t,n){e[n]===t&&delete e[n]})),Object(s["forEach"])(['attributes','head'],(function(t){Object(s["isEmpty"])(e[t])&&delete e[t]})),e}}]),n}(l["Model"]);function j(t,e){var n=Object.keys(t);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(t);e&&(r=r.filter((function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable}))),n.push.apply(n,r)}return n}function T(t){for(var e=1;e<arguments.length;e++){var n=null!=arguments[e]?arguments[e]:{};e%2?j(Object(n),!0).forEach((function(e){a()(t,e,n[e])})):Object.getOwnPropertyDescriptors?Object.defineProperties(t,Object.getOwnPropertyDescriptors(n)):j(Object(n)).forEach((function(e){Object.defineProperty(t,e,Object.getOwnPropertyDescriptor(n,e))}))}return t}function P(t){var e=function(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],(function(){}))),!0}catch(t){return!1}}();return function(){var n,r=b()(t);if(e){var i=b()(this).constructor;n=Reflect.construct(r,arguments,i)}else n=r.apply(this,arguments);return m()(this,n)}}var E=function(t){g()(n,t);var e=P(n);function n(){return d()(this,n),e.apply(this,arguments)}return f()(n,[{key:"initialize",value:function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};Object(s["bindAll"])(this,'itemLoaded'),this.config=e,this.on('reset',this.onReset),this.on('remove',this.onRemove)}},{key:"onReset",value:function(t){var e=this,n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},r=n.previousModels||[];r.map((function(t){return e.onRemove(t)}))}},{key:"onRemove",value:function(t){t&&t.onRemove()}},{key:"itemLoaded",value:function(){this.loadedItems++,this.loadedItems>=this.itemsToLoad&&(this.trigger('loaded:all'),this.listenToLoadItems(0))}},{key:"listenToLoad",value:function(){this.loadedItems=0,this.itemsToLoad=this.length,this.listenToLoadItems(1)}},{key:"listenToLoadItems",value:function(t){var e=this;this.forEach((function(n){return n[t?'on':'off']('loaded',e.itemLoaded)}))}},{key:"add",value:function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},n=this.config;return l["Collection"].prototype.add.call(this,t,T(T({},e),{},{config:n}))}}]),n}(l["Collection"]);function _(t){var e=function(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],(function(){}))),!0}catch(t){return!1}}();return function(){var n,r=b()(t);if(e){var i=b()(this).constructor;n=Reflect.construct(r,arguments,i)}else n=r.apply(this,arguments);return m()(this,n)}}E.prototype.model=S;var M=function(t){g()(n,t);var e=_(n);function n(){return d()(this,n),e.apply(this,arguments)}return f()(n,[{key:"defaults",value:function(){return{frames:[],_undo:!0}}},{key:"initialize",value:function(t){var e=this,n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},r=n.config,i=void 0===r?{}:r,o=i.em,a={};this.em=o,t.frames||(a.component=t.component,a.styles=t.styles,['component','styles'].map((function(t){return e.unset(t)})));var s=t.frames||[a],c=new E(s,i);c.page=this,this.set('frames',c);var l=o&&o.get('UndoManager');l&&l.add(c)}},{key:"onRemove",value:function(){this.get('frames').reset()}},{key:"getFrames",value:function(){return this.get('frames')}},{key:"getId",value:function(){return this.id}},{key:"getName",value:function(){return this.get('name')}},{key:"setName",value:function(t){return this.get({name:t})}},{key:"getAllFrames",value:function(){return this.getFrames().models||[]}},{key:"getMainFrame",value:function(){return this.getFrames().at(0)}},{key:"getMainComponent",value:function(){var t=this.getMainFrame();return t&&t.getComponent()}},{key:"toJSON",value:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},e=l["Model"].prototype.toJSON.call(this,t),n=Object(s["result"])(this,'defaults');return Object(s["forEach"])(e,(function(t,n){0===n.indexOf('_')&&delete e[n]})),Object(s["forEach"])(n,(function(t,n){e[n]===t&&delete e[n]})),e}}]),n}(l["Model"]);function D(t,e){var n=Object.keys(t);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(t);e&&(r=r.filter((function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable}))),n.push.apply(n,r)}return n}function A(t){for(var e=1;e<arguments.length;e++){var n=null!=arguments[e]?arguments[e]:{};e%2?D(Object(n),!0).forEach((function(e){a()(t,e,n[e])})):Object.getOwnPropertyDescriptors?Object.defineProperties(t,Object.getOwnPropertyDescriptors(n)):D(Object(n)).forEach((function(e){Object.defineProperty(t,e,Object.getOwnPropertyDescriptor(n,e))}))}return t}function L(t){var e=function(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],(function(){}))),!0}catch(t){return!1}}();return function(){var n,r=b()(t);if(e){var i=b()(this).constructor;n=Reflect.construct(r,arguments,i)}else n=r.apply(this,arguments);return m()(this,n)}}var N=function(t){g()(n,t);var e=L(n);function n(){return d()(this,n),e.apply(this,arguments)}return f()(n,[{key:"initialize",value:function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};this.config=e,this.on('reset',this.onReset),this.on('remove',this.onRemove)}},{key:"onReset",value:function(t){var e=this,n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},r=n.previousModels||[];r.map((function(t){return e.onRemove(t)}))}},{key:"onRemove",value:function(t){t&&t.onRemove()}},{key:"add",value:function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},n=this.config;return l["Collection"].prototype.add.call(this,t,A(A({},e),{},{config:n}))}}]),n}(l["Collection"]);function R(t,e){var n=Object.keys(t);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(t);e&&(r=r.filter((function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable}))),n.push.apply(n,r)}return n}function I(t){for(var e=1;e<arguments.length;e++){var n=null!=arguments[e]?arguments[e]:{};e%2?R(Object(n),!0).forEach((function(e){a()(t,e,n[e])})):Object.getOwnPropertyDescriptors?Object.defineProperties(t,Object.getOwnPropertyDescriptors(n)):R(Object(n)).forEach((function(e){Object.defineProperty(t,e,Object.getOwnPropertyDescriptor(n,e))}))}return t}N.prototype.model=M;var F='page',V="".concat(F,":"),z="".concat(V,"select"),H="".concat(z,":before"),B="".concat(V,"update"),U="".concat(V,"add"),$="".concat(U,":before"),W="".concat(V,"remove"),q="".concat(W,":before"),G='change:selected',K='main';e["default"]=function(){return{name:'PageManager',storageKey:'pages',Page:M,Pages:N,events:{all:F,select:z,selectBefore:H,update:B,add:U,addBefore:$,remove:W,removeBefore:q},init:function(){var t=this,e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};Object(s["bindAll"])(this,'_onPageChange');var n=e.em,r=I({},e);this.config=r,this.em=n;var i=new N([],r);this.pages=i;var o=new l["Model"]({_undo:!0});return this.model=o,i.on('add',(function(t,e,r){return n.trigger(U,t,r)})),i.on('remove',(function(t,e,r){return n.trigger(W,t,r)})),i.on('change',(function(t,e){n.trigger(B,t,t.changedAttributes(),e)})),i.on('reset',(function(e){return e.at(0)&&t.select(e.at(0))})),i.on('all',this.__onChange,this),o.on(G,this._onPageChange),this},__onChange:function(t,e,n,r){var i=r||n;this.em.trigger(F,{event:t,page:e,options:i})},onLoad:function(){var t=this.pages,e={silent:!0};t.add(this.config.pages||[],e);var n=t.length?this.getMain():this.add({type:K},e);this.select(n,e)},_onPageChange:function(t,e,n){var r=this.em,i=r.get('LayerManager'),o=e.getMainComponent();i&&o&&i.setRoot(o),r.trigger(z,e,t.previous('selected')),this.__onChange(G,e,n)},postLoad:function(){var t=this.em,e=this.model,n=t.get('UndoManager');n&&n.add(e),n&&n.add(this.pages)},add:function(t){var e=this,n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},r=this.em;t.id=t.id||this._createId();var i=function(){var r=e.pages.add(t,n);return n.select&&e.select(r),r};return!n.silent&&r.trigger($,t,i,n),!n.abort&&i()},remove:function(t){var e=this,n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},r=this.em,i=Object(s["isString"])(t)?this.get(t):t,o=function(){return i&&e.pages.remove(i,n),i};return!n.silent&&r.trigger(q,i,o,n),!n.abort&&o()},get:function(t){return this.pages.filter((function(e){return e.get('id')===t}))[0]},getMain:function(){var t=this.pages;return t.filter((function(t){return t.get('type')===K}))[0]||t.at(0)},getAll:function(){return i()(this.pages.models)},getAllWrappers:function(){var t=this.getAll();return Object(s["unique"])(Object(s["flatten"])(t.map((function(t){return t.getAllFrames().map((function(t){return t.getComponent()}))}))))},getAllMap:function(){return this.getAll().reduce((function(t,e){return t[e.get('id')]=e,t}),{})},select:function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},n=Object(s["isString"])(t)?this.get(t):t;return n&&(this.em.trigger(H,n,e),this.model.set('selected',n,e)),this},getSelected:function(){return this.model.get('selected')},destroy:function(){var t=this;this.pages.off().reset(),this.model.stopListening(),this.model.clear({silent:!0}),['selected','config','em','pages','model'].map((function(e){return t[e]=0}))},store:function(t){if(!this.em.get('hasPages'))return{};var e={},n=this.config;return e[this.storageKey]=JSON.stringify(this.getAll()),!t&&n.stm&&n.stm.store(e),e},load:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},e=this.storageKey,n=t[e]||[];if('string'==typeof n)try{n=JSON.parse(t[e])}catch(t){}return n&&n.length&&this.pages.reset(n),n},_createId:function(){var t,e=this.getAll().length+16,n=this.getAllMap();do{t=Object(c["createId"])(e)}while(n[t]);return t}}}},function(t,e,n){"use strict";n.r(e);var r=n(2),i=n.n(r),o=i.a.Model.extend({defaults:{id:'',label:'',tagName:'span',className:'',command:'',context:'',buttons:[],attributes:{},options:{},active:!1,dragDrop:!1,togglable:!0,runDefaultCommand:!0,stopDefaultCommand:!1,disable:!1},initialize:function(t){if(this.get('buttons').length){var e=n(48).default;this.set('buttons',new e(this.get('buttons')))}}});e["default"]=i.a.Collection.extend({model:o,deactivateAllExceptOne:function(t,e){this.forEach((function(n,r){n!==t&&(n.set('active',!1),e&&n.get('buttons').length&&n.get('buttons').deactivateAllExceptOne(t,e))}))},deactivateAll:function(t,e){var n=t||'';this.forEach((function(t){t.get('context')==n&&t!==e&&t.set('active',!1,{fromCollection:1})}))},disableAllButtons:function(t){var e=t||'';this.forEach((function(t,n){t.get('context')==e&&t.set('disable',!0)}))},disableAllButtonsExceptOne:function(t,e){this.forEach((function(n,r){n!==t&&(n.set('disable',!0),e&&n.get('buttons').length&&n.get('buttons').disableAllButtonsExceptOne(t,e))}))}})},function(t,e){t.exports=function(t,e){(null==e||e>t.length)&&(e=t.length);for(var n=0,r=new Array(e);n<e;n++)r[n]=t[n];return r},t.exports["default"]=t.exports,t.exports.__esModule=!0},function(t,e,n){var r=n(49);t.exports=function(t,e){if(t){if("string"==typeof t)return r(t,e);var n=Object.prototype.toString.call(t).slice(8,-1);return"Object"===n&&t.constructor&&(n=t.constructor.name),"Map"===n||"Set"===n?Array.from(t):"Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)?r(t,e):void 0}},t.exports["default"]=t.exports,t.exports.__esModule=!0},function(t,e,n){ true&&function(t){"use strict";function e(t){for(var e={},n=0;n<t.length;++n)e[t[n].toLowerCase()]=!0;return e}t.defineMode("css",(function(e,n){var r=n.inline;n.propertyKeywords||(n=t.resolveMode("text/css"));var i,o,a=e.indentUnit,s=n.tokenHooks,c=n.documentTypes||{},l=n.mediaTypes||{},u=n.mediaFeatures||{},d=n.mediaValueKeywords||{},h=n.propertyKeywords||{},f=n.nonStandardPropertyKeywords||{},p=n.fontProperties||{},g=n.counterDescriptors||{},v=n.colorKeywords||{},m=n.valueKeywords||{},y=n.allowNested,b=n.lineComment,w=!0===n.supportsAtComponent,O=!1!==e.highlightNonStandardPropertyKeywords;function x(t,e){return i=e,t}function C(t,e){var n=t.next();if(s[n]){var r=s[n](t,e);if(!1!==r)return r}return"@"==n?(t.eatWhile(/[\w\\\-]/),x("def",t.current())):"="==n||("~"==n||"|"==n)&&t.eat("=")?x(null,"compare"):"\""==n||"'"==n?(e.tokenize=k(n),e.tokenize(t,e)):"#"==n?(t.eatWhile(/[\w\\\-]/),x("atom","hash")):"!"==n?(t.match(/^\s*\w*/),x("keyword","important")):/\d/.test(n)||"."==n&&t.eat(/\d/)?(t.eatWhile(/[\w.%]/),x("number","unit")):"-"!==n?/[,+>*\/]/.test(n)?x(null,"select-op"):"."==n&&t.match(/^-?[_a-z][_a-z0-9-]*/i)?x("qualifier","qualifier"):/[:;{}\[\]\(\)]/.test(n)?x(null,n):t.match(/^[\w-.]+(?=\()/)?(/^(url(-prefix)?|domain|regexp)$/i.test(t.current())&&(e.tokenize=S),x("variable callee","variable")):/[\w\\\-]/.test(n)?(t.eatWhile(/[\w\\\-]/),x("property","word")):x(null,null):/[\d.]/.test(t.peek())?(t.eatWhile(/[\w.%]/),x("number","unit")):t.match(/^-[\w\\\-]*/)?(t.eatWhile(/[\w\\\-]/),t.match(/^\s*:/,!1)?x("variable-2","variable-definition"):x("variable-2","variable")):t.match(/^\w+-/)?x("meta","meta"):void 0}function k(t){return function(e,n){for(var r,i=!1;null!=(r=e.next());){if(r==t&&!i){")"==t&&e.backUp(1);break}i=!i&&"\\"==r}return(r==t||!i&&")"!=t)&&(n.tokenize=null),x("string","string")}}function S(t,e){return t.next(),t.match(/^\s*[\"\')]/,!1)?e.tokenize=null:e.tokenize=k(")"),x(null,"(")}function j(t,e,n){this.type=t,this.indent=e,this.prev=n}function T(t,e,n,r){return t.context=new j(n,e.indentation()+(!1===r?0:a),t.context),n}function P(t){return t.context.prev&&(t.context=t.context.prev),t.context.type}function E(t,e,n){return D[n.context.type](t,e,n)}function _(t,e,n,r){for(var i=r||1;i>0;i--)n.context=n.context.prev;return E(t,e,n)}function M(t){var e=t.current().toLowerCase();o=m.hasOwnProperty(e)?"atom":v.hasOwnProperty(e)?"keyword":"variable"}var D={top:function(t,e,n){if("{"==t)return T(n,e,"block");if("}"==t&&n.context.prev)return P(n);if(w&&/@component/i.test(t))return T(n,e,"atComponentBlock");if(/^@(-moz-)?document$/i.test(t))return T(n,e,"documentTypes");if(/^@(media|supports|(-moz-)?document|import)$/i.test(t))return T(n,e,"atBlock");if(/^@(font-face|counter-style)/i.test(t))return n.stateArg=t,"restricted_atBlock_before";if(/^@(-(moz|ms|o|webkit)-)?keyframes$/i.test(t))return"keyframes";if(t&&"@"==t.charAt(0))return T(n,e,"at");if("hash"==t)o="builtin";else if("word"==t)o="tag";else{if("variable-definition"==t)return"maybeprop";if("interpolation"==t)return T(n,e,"interpolation");if(":"==t)return"pseudo";if(y&&"("==t)return T(n,e,"parens")}return n.context.type},block:function(t,e,n){if("word"==t){var r=e.current().toLowerCase();return h.hasOwnProperty(r)?(o="property","maybeprop"):f.hasOwnProperty(r)?(o=O?"string-2":"property","maybeprop"):y?(o=e.match(/^\s*:(?:\s|$)/,!1)?"property":"tag","block"):(o+=" error","maybeprop")}return"meta"==t?"block":y||"hash"!=t&&"qualifier"!=t?D.top(t,e,n):(o="error","block")},maybeprop:function(t,e,n){return":"==t?T(n,e,"prop"):E(t,e,n)},prop:function(t,e,n){if(";"==t)return P(n);if("{"==t&&y)return T(n,e,"propBlock");if("}"==t||"{"==t)return _(t,e,n);if("("==t)return T(n,e,"parens");if("hash"!=t||/^#([0-9a-fA-f]{3,4}|[0-9a-fA-f]{6}|[0-9a-fA-f]{8})$/.test(e.current())){if("word"==t)M(e);else if("interpolation"==t)return T(n,e,"interpolation")}else o+=" error";return"prop"},propBlock:function(t,e,n){return"}"==t?P(n):"word"==t?(o="property","maybeprop"):n.context.type},parens:function(t,e,n){return"{"==t||"}"==t?_(t,e,n):")"==t?P(n):"("==t?T(n,e,"parens"):"interpolation"==t?T(n,e,"interpolation"):("word"==t&&M(e),"parens")},pseudo:function(t,e,n){return"meta"==t?"pseudo":"word"==t?(o="variable-3",n.context.type):E(t,e,n)},documentTypes:function(t,e,n){return"word"==t&&c.hasOwnProperty(e.current())?(o="tag",n.context.type):D.atBlock(t,e,n)},atBlock:function(t,e,n){if("("==t)return T(n,e,"atBlock_parens");if("}"==t||";"==t)return _(t,e,n);if("{"==t)return P(n)&&T(n,e,y?"block":"top");if("interpolation"==t)return T(n,e,"interpolation");if("word"==t){var r=e.current().toLowerCase();o="only"==r||"not"==r||"and"==r||"or"==r?"keyword":l.hasOwnProperty(r)?"attribute":u.hasOwnProperty(r)?"property":d.hasOwnProperty(r)?"keyword":h.hasOwnProperty(r)?"property":f.hasOwnProperty(r)?O?"string-2":"property":m.hasOwnProperty(r)?"atom":v.hasOwnProperty(r)?"keyword":"error"}return n.context.type},atComponentBlock:function(t,e,n){return"}"==t?_(t,e,n):"{"==t?P(n)&&T(n,e,y?"block":"top",!1):("word"==t&&(o="error"),n.context.type)},atBlock_parens:function(t,e,n){return")"==t?P(n):"{"==t||"}"==t?_(t,e,n,2):D.atBlock(t,e,n)},restricted_atBlock_before:function(t,e,n){return"{"==t?T(n,e,"restricted_atBlock"):"word"==t&&"@counter-style"==n.stateArg?(o="variable","restricted_atBlock_before"):E(t,e,n)},restricted_atBlock:function(t,e,n){return"}"==t?(n.stateArg=null,P(n)):"word"==t?(o="@font-face"==n.stateArg&&!p.hasOwnProperty(e.current().toLowerCase())||"@counter-style"==n.stateArg&&!g.hasOwnProperty(e.current().toLowerCase())?"error":"property","maybeprop"):"restricted_atBlock"},keyframes:function(t,e,n){return"word"==t?(o="variable","keyframes"):"{"==t?T(n,e,"top"):E(t,e,n)},at:function(t,e,n){return";"==t?P(n):"{"==t||"}"==t?_(t,e,n):("word"==t?o="tag":"hash"==t&&(o="builtin"),"at")},interpolation:function(t,e,n){return"}"==t?P(n):"{"==t||";"==t?_(t,e,n):("word"==t?o="variable":"variable"!=t&&"("!=t&&")"!=t&&(o="error"),"interpolation")}};return{startState:function(t){return{tokenize:null,state:r?"block":"top",stateArg:null,context:new j(r?"block":"top",t||0,null)}},token:function(t,e){if(!e.tokenize&&t.eatSpace())return null;var n=(e.tokenize||C)(t,e);return n&&"object"==typeof n&&(i=n[1],n=n[0]),o=n,"comment"!=i&&(e.state=D[e.state](i,t,e)),o},indent:function(t,e){var n=t.context,r=e&&e.charAt(0),i=n.indent;return"prop"!=n.type||"}"!=r&&")"!=r||(n=n.prev),n.prev&&("}"!=r||"block"!=n.type&&"top"!=n.type&&"interpolation"!=n.type&&"restricted_atBlock"!=n.type?(")"!=r||"parens"!=n.type&&"atBlock_parens"!=n.type)&&("{"!=r||"at"!=n.type&&"atBlock"!=n.type)||(i=Math.max(0,n.indent-a)):i=(n=n.prev).indent),i},electricChars:"}",blockCommentStart:"/*",blockCommentEnd:"*/",blockCommentContinue:" * ",lineComment:b,fold:"brace"}}));var n=["domain","regexp","url","url-prefix"],r=e(n),i=["all","aural","braille","handheld","print","projection","screen","tty","tv","embossed"],o=e(i),a=["width","min-width","max-width","height","min-height","max-height","device-width","min-device-width","max-device-width","device-height","min-device-height","max-device-height","aspect-ratio","min-aspect-ratio","max-aspect-ratio","device-aspect-ratio","min-device-aspect-ratio","max-device-aspect-ratio","color","min-color","max-color","color-index","min-color-index","max-color-index","monochrome","min-monochrome","max-monochrome","resolution","min-resolution","max-resolution","scan","grid","orientation","device-pixel-ratio","min-device-pixel-ratio","max-device-pixel-ratio","pointer","any-pointer","hover","any-hover","prefers-color-scheme"],s=e(a),c=["landscape","portrait","none","coarse","fine","on-demand","hover","interlace","progressive","dark","light"],l=e(c),u=["align-content","align-items","align-self","alignment-adjust","alignment-baseline","all","anchor-point","animation","animation-delay","animation-direction","animation-duration","animation-fill-mode","animation-iteration-count","animation-name","animation-play-state","animation-timing-function","appearance","azimuth","backdrop-filter","backface-visibility","background","background-attachment","background-blend-mode","background-clip","background-color","background-image","background-origin","background-position","background-position-x","background-position-y","background-repeat","background-size","baseline-shift","binding","bleed","block-size","bookmark-label","bookmark-level","bookmark-state","bookmark-target","border","border-bottom","border-bottom-color","border-bottom-left-radius","border-bottom-right-radius","border-bottom-style","border-bottom-width","border-collapse","border-color","border-image","border-image-outset","border-image-repeat","border-image-slice","border-image-source","border-image-width","border-left","border-left-color","border-left-style","border-left-width","border-radius","border-right","border-right-color","border-right-style","border-right-width","border-spacing","border-style","border-top","border-top-color","border-top-left-radius","border-top-right-radius","border-top-style","border-top-width","border-width","bottom","box-decoration-break","box-shadow","box-sizing","break-after","break-before","break-inside","caption-side","caret-color","clear","clip","color","color-profile","column-count","column-fill","column-gap","column-rule","column-rule-color","column-rule-style","column-rule-width","column-span","column-width","columns","contain","content","counter-increment","counter-reset","crop","cue","cue-after","cue-before","cursor","direction","display","dominant-baseline","drop-initial-after-adjust","drop-initial-after-align","drop-initial-before-adjust","drop-initial-before-align","drop-initial-size","drop-initial-value","elevation","empty-cells","fit","fit-content","fit-position","flex","flex-basis","flex-direction","flex-flow","flex-grow","flex-shrink","flex-wrap","float","float-offset","flow-from","flow-into","font","font-family","font-feature-settings","font-kerning","font-language-override","font-optical-sizing","font-size","font-size-adjust","font-stretch","font-style","font-synthesis","font-variant","font-variant-alternates","font-variant-caps","font-variant-east-asian","font-variant-ligatures","font-variant-numeric","font-variant-position","font-variation-settings","font-weight","gap","grid","grid-area","grid-auto-columns","grid-auto-flow","grid-auto-rows","grid-column","grid-column-end","grid-column-gap","grid-column-start","grid-gap","grid-row","grid-row-end","grid-row-gap","grid-row-start","grid-template","grid-template-areas","grid-template-columns","grid-template-rows","hanging-punctuation","height","hyphens","icon","image-orientation","image-rendering","image-resolution","inline-box-align","inset","inset-block","inset-block-end","inset-block-start","inset-inline","inset-inline-end","inset-inline-start","isolation","justify-content","justify-items","justify-self","left","letter-spacing","line-break","line-height","line-height-step","line-stacking","line-stacking-ruby","line-stacking-shift","line-stacking-strategy","list-style","list-style-image","list-style-position","list-style-type","margin","margin-bottom","margin-left","margin-right","margin-top","marks","marquee-direction","marquee-loop","marquee-play-count","marquee-speed","marquee-style","mask-clip","mask-composite","mask-image","mask-mode","mask-origin","mask-position","mask-repeat","mask-size","mask-type","max-block-size","max-height","max-inline-size","max-width","min-block-size","min-height","min-inline-size","min-width","mix-blend-mode","move-to","nav-down","nav-index","nav-left","nav-right","nav-up","object-fit","object-position","offset","offset-anchor","offset-distance","offset-path","offset-position","offset-rotate","opacity","order","orphans","outline","outline-color","outline-offset","outline-style","outline-width","overflow","overflow-style","overflow-wrap","overflow-x","overflow-y","padding","padding-bottom","padding-left","padding-right","padding-top","page","page-break-after","page-break-before","page-break-inside","page-policy","pause","pause-after","pause-before","perspective","perspective-origin","pitch","pitch-range","place-content","place-items","place-self","play-during","position","presentation-level","punctuation-trim","quotes","region-break-after","region-break-before","region-break-inside","region-fragment","rendering-intent","resize","rest","rest-after","rest-before","richness","right","rotate","rotation","rotation-point","row-gap","ruby-align","ruby-overhang","ruby-position","ruby-span","scale","scroll-behavior","scroll-margin","scroll-margin-block","scroll-margin-block-end","scroll-margin-block-start","scroll-margin-bottom","scroll-margin-inline","scroll-margin-inline-end","scroll-margin-inline-start","scroll-margin-left","scroll-margin-right","scroll-margin-top","scroll-padding","scroll-padding-block","scroll-padding-block-end","scroll-padding-block-start","scroll-padding-bottom","scroll-padding-inline","scroll-padding-inline-end","scroll-padding-inline-start","scroll-padding-left","scroll-padding-right","scroll-padding-top","scroll-snap-align","scroll-snap-type","shape-image-threshold","shape-inside","shape-margin","shape-outside","size","speak","speak-as","speak-header","speak-numeral","speak-punctuation","speech-rate","stress","string-set","tab-size","table-layout","target","target-name","target-new","target-position","text-align","text-align-last","text-combine-upright","text-decoration","text-decoration-color","text-decoration-line","text-decoration-skip","text-decoration-skip-ink","text-decoration-style","text-emphasis","text-emphasis-color","text-emphasis-position","text-emphasis-style","text-height","text-indent","text-justify","text-orientation","text-outline","text-overflow","text-rendering","text-shadow","text-size-adjust","text-space-collapse","text-transform","text-underline-position","text-wrap","top","touch-action","transform","transform-origin","transform-style","transition","transition-delay","transition-duration","transition-property","transition-timing-function","translate","unicode-bidi","user-select","vertical-align","visibility","voice-balance","voice-duration","voice-family","voice-pitch","voice-range","voice-rate","voice-stress","voice-volume","volume","white-space","widows","width","will-change","word-break","word-spacing","word-wrap","writing-mode","z-index","clip-path","clip-rule","mask","enable-background","filter","flood-color","flood-opacity","lighting-color","stop-color","stop-opacity","pointer-events","color-interpolation","color-interpolation-filters","color-rendering","fill","fill-opacity","fill-rule","image-rendering","marker","marker-end","marker-mid","marker-start","paint-order","shape-rendering","stroke","stroke-dasharray","stroke-dashoffset","stroke-linecap","stroke-linejoin","stroke-miterlimit","stroke-opacity","stroke-width","text-rendering","baseline-shift","dominant-baseline","glyph-orientation-horizontal","glyph-orientation-vertical","text-anchor","writing-mode"],d=e(u),h=["accent-color","aspect-ratio","border-block","border-block-color","border-block-end","border-block-end-color","border-block-end-style","border-block-end-width","border-block-start","border-block-start-color","border-block-start-style","border-block-start-width","border-block-style","border-block-width","border-inline","border-inline-color","border-inline-end","border-inline-end-color","border-inline-end-style","border-inline-end-width","border-inline-start","border-inline-start-color","border-inline-start-style","border-inline-start-width","border-inline-style","border-inline-width","content-visibility","margin-block","margin-block-end","margin-block-start","margin-inline","margin-inline-end","margin-inline-start","overflow-anchor","overscroll-behavior","padding-block","padding-block-end","padding-block-start","padding-inline","padding-inline-end","padding-inline-start","scroll-snap-stop","scrollbar-3d-light-color","scrollbar-arrow-color","scrollbar-base-color","scrollbar-dark-shadow-color","scrollbar-face-color","scrollbar-highlight-color","scrollbar-shadow-color","scrollbar-track-color","searchfield-cancel-button","searchfield-decoration","searchfield-results-button","searchfield-results-decoration","shape-inside","zoom"],f=e(h),p=e(["font-display","font-family","src","unicode-range","font-variant","font-feature-settings","font-stretch","font-weight","font-style"]),g=e(["additive-symbols","fallback","negative","pad","prefix","range","speak-as","suffix","symbols","system"]),v=["aliceblue","antiquewhite","aqua","aquamarine","azure","beige","bisque","black","blanchedalmond","blue","blueviolet","brown","burlywood","cadetblue","chartreuse","chocolate","coral","cornflowerblue","cornsilk","crimson","cyan","darkblue","darkcyan","darkgoldenrod","darkgray","darkgreen","darkgrey","darkkhaki","darkmagenta","darkolivegreen","darkorange","darkorchid","darkred","darksalmon","darkseagreen","darkslateblue","darkslategray","darkslategrey","darkturquoise","darkviolet","deeppink","deepskyblue","dimgray","dimgrey","dodgerblue","firebrick","floralwhite","forestgreen","fuchsia","gainsboro","ghostwhite","gold","goldenrod","gray","grey","green","greenyellow","honeydew","hotpink","indianred","indigo","ivory","khaki","lavender","lavenderblush","lawngreen","lemonchiffon","lightblue","lightcoral","lightcyan","lightgoldenrodyellow","lightgray","lightgreen","lightgrey","lightpink","lightsalmon","lightseagreen","lightskyblue","lightslategray","lightslategrey","lightsteelblue","lightyellow","lime","limegreen","linen","magenta","maroon","mediumaquamarine","mediumblue","mediumorchid","mediumpurple","mediumseagreen","mediumslateblue","mediumspringgreen","mediumturquoise","mediumvioletred","midnightblue","mintcream","mistyrose","moccasin","navajowhite","navy","oldlace","olive","olivedrab","orange","orangered","orchid","palegoldenrod","palegreen","paleturquoise","palevioletred","papayawhip","peachpuff","peru","pink","plum","powderblue","purple","rebeccapurple","red","rosybrown","royalblue","saddlebrown","salmon","sandybrown","seagreen","seashell","sienna","silver","skyblue","slateblue","slategray","slategrey","snow","springgreen","steelblue","tan","teal","thistle","tomato","turquoise","violet","wheat","white","whitesmoke","yellow","yellowgreen"],m=e(v),y=["above","absolute","activeborder","additive","activecaption","afar","after-white-space","ahead","alias","all","all-scroll","alphabetic","alternate","always","amharic","amharic-abegede","antialiased","appworkspace","arabic-indic","armenian","asterisks","attr","auto","auto-flow","avoid","avoid-column","avoid-page","avoid-region","axis-pan","background","backwards","baseline","below","bidi-override","binary","bengali","blink","block","block-axis","blur","bold","bolder","border","border-box","both","bottom","break","break-all","break-word","brightness","bullets","button","button-bevel","buttonface","buttonhighlight","buttonshadow","buttontext","calc","cambodian","capitalize","caps-lock-indicator","caption","captiontext","caret","cell","center","checkbox","circle","cjk-decimal","cjk-earthly-branch","cjk-heavenly-stem","cjk-ideographic","clear","clip","close-quote","col-resize","collapse","color","color-burn","color-dodge","column","column-reverse","compact","condensed","contain","content","contents","content-box","context-menu","continuous","contrast","copy","counter","counters","cover","crop","cross","crosshair","cubic-bezier","currentcolor","cursive","cyclic","darken","dashed","decimal","decimal-leading-zero","default","default-button","dense","destination-atop","destination-in","destination-out","destination-over","devanagari","difference","disc","discard","disclosure-closed","disclosure-open","document","dot-dash","dot-dot-dash","dotted","double","down","drop-shadow","e-resize","ease","ease-in","ease-in-out","ease-out","element","ellipse","ellipsis","embed","end","ethiopic","ethiopic-abegede","ethiopic-abegede-am-et","ethiopic-abegede-gez","ethiopic-abegede-ti-er","ethiopic-abegede-ti-et","ethiopic-halehame-aa-er","ethiopic-halehame-aa-et","ethiopic-halehame-am-et","ethiopic-halehame-gez","ethiopic-halehame-om-et","ethiopic-halehame-sid-et","ethiopic-halehame-so-et","ethiopic-halehame-ti-er","ethiopic-halehame-ti-et","ethiopic-halehame-tig","ethiopic-numeric","ew-resize","exclusion","expanded","extends","extra-condensed","extra-expanded","fantasy","fast","fill","fill-box","fixed","flat","flex","flex-end","flex-start","footnotes","forwards","from","geometricPrecision","georgian","grayscale","graytext","grid","groove","gujarati","gurmukhi","hand","hangul","hangul-consonant","hard-light","hebrew","help","hidden","hide","higher","highlight","highlighttext","hiragana","hiragana-iroha","horizontal","hsl","hsla","hue","hue-rotate","icon","ignore","inactiveborder","inactivecaption","inactivecaptiontext","infinite","infobackground","infotext","inherit","initial","inline","inline-axis","inline-block","inline-flex","inline-grid","inline-table","inset","inside","intrinsic","invert","italic","japanese-formal","japanese-informal","justify","kannada","katakana","katakana-iroha","keep-all","khmer","korean-hangul-formal","korean-hanja-formal","korean-hanja-informal","landscape","lao","large","larger","left","level","lighter","lighten","line-through","linear","linear-gradient","lines","list-item","listbox","listitem","local","logical","loud","lower","lower-alpha","lower-armenian","lower-greek","lower-hexadecimal","lower-latin","lower-norwegian","lower-roman","lowercase","ltr","luminosity","malayalam","manipulation","match","matrix","matrix3d","media-controls-background","media-current-time-display","media-fullscreen-button","media-mute-button","media-play-button","media-return-to-realtime-button","media-rewind-button","media-seek-back-button","media-seek-forward-button","media-slider","media-sliderthumb","media-time-remaining-display","media-volume-slider","media-volume-slider-container","media-volume-sliderthumb","medium","menu","menulist","menulist-button","menulist-text","menulist-textfield","menutext","message-box","middle","min-intrinsic","mix","mongolian","monospace","move","multiple","multiple_mask_images","multiply","myanmar","n-resize","narrower","ne-resize","nesw-resize","no-close-quote","no-drop","no-open-quote","no-repeat","none","normal","not-allowed","nowrap","ns-resize","numbers","numeric","nw-resize","nwse-resize","oblique","octal","opacity","open-quote","optimizeLegibility","optimizeSpeed","oriya","oromo","outset","outside","outside-shape","overlay","overline","padding","padding-box","painted","page","paused","persian","perspective","pinch-zoom","plus-darker","plus-lighter","pointer","polygon","portrait","pre","pre-line","pre-wrap","preserve-3d","progress","push-button","radial-gradient","radio","read-only","read-write","read-write-plaintext-only","rectangle","region","relative","repeat","repeating-linear-gradient","repeating-radial-gradient","repeat-x","repeat-y","reset","reverse","rgb","rgba","ridge","right","rotate","rotate3d","rotateX","rotateY","rotateZ","round","row","row-resize","row-reverse","rtl","run-in","running","s-resize","sans-serif","saturate","saturation","scale","scale3d","scaleX","scaleY","scaleZ","screen","scroll","scrollbar","scroll-position","se-resize","searchfield","searchfield-cancel-button","searchfield-decoration","searchfield-results-button","searchfield-results-decoration","self-start","self-end","semi-condensed","semi-expanded","separate","sepia","serif","show","sidama","simp-chinese-formal","simp-chinese-informal","single","skew","skewX","skewY","skip-white-space","slide","slider-horizontal","slider-vertical","sliderthumb-horizontal","sliderthumb-vertical","slow","small","small-caps","small-caption","smaller","soft-light","solid","somali","source-atop","source-in","source-out","source-over","space","space-around","space-between","space-evenly","spell-out","square","square-button","start","static","status-bar","stretch","stroke","stroke-box","sub","subpixel-antialiased","svg_masks","super","sw-resize","symbolic","symbols","system-ui","table","table-caption","table-cell","table-column","table-column-group","table-footer-group","table-header-group","table-row","table-row-group","tamil","telugu","text","text-bottom","text-top","textarea","textfield","thai","thick","thin","threeddarkshadow","threedface","threedhighlight","threedlightshadow","threedshadow","tibetan","tigre","tigrinya-er","tigrinya-er-abegede","tigrinya-et","tigrinya-et-abegede","to","top","trad-chinese-formal","trad-chinese-informal","transform","translate","translate3d","translateX","translateY","translateZ","transparent","ultra-condensed","ultra-expanded","underline","unidirectional-pan","unset","up","upper-alpha","upper-armenian","upper-greek","upper-hexadecimal","upper-latin","upper-norwegian","upper-roman","uppercase","urdu","url","var","vertical","vertical-text","view-box","visible","visibleFill","visiblePainted","visibleStroke","visual","w-resize","wait","wave","wider","window","windowframe","windowtext","words","wrap","wrap-reverse","x-large","x-small","xor","xx-large","xx-small"],b=e(y),w=n.concat(i).concat(a).concat(c).concat(u).concat(h).concat(v).concat(y);function O(t,e){for(var n,r=!1;null!=(n=t.next());){if(r&&"/"==n){e.tokenize=null;break}r="*"==n}return["comment","comment"]}t.registerHelper("hintWords","css",w),t.defineMIME("text/css",{documentTypes:r,mediaTypes:o,mediaFeatures:s,mediaValueKeywords:l,propertyKeywords:d,nonStandardPropertyKeywords:f,fontProperties:p,counterDescriptors:g,colorKeywords:m,valueKeywords:b,tokenHooks:{"/":function(t,e){return!!t.eat("*")&&(e.tokenize=O,O(t,e))}},name:"css"}),t.defineMIME("text/x-scss",{mediaTypes:o,mediaFeatures:s,mediaValueKeywords:l,propertyKeywords:d,nonStandardPropertyKeywords:f,colorKeywords:m,valueKeywords:b,fontProperties:p,allowNested:!0,lineComment:"//",tokenHooks:{"/":function(t,e){return t.eat("/")?(t.skipToEnd(),["comment","comment"]):t.eat("*")?(e.tokenize=O,O(t,e)):["operator","operator"]},":":function(t){return!!t.match(/^\s*\{/,!1)&&[null,null]},$:function(t){return t.match(/^[\w-]+/),t.match(/^\s*:/,!1)?["variable-2","variable-definition"]:["variable-2","variable"]},"#":function(t){return!!t.eat("{")&&[null,"interpolation"]}},name:"css",helperType:"scss"}),t.defineMIME("text/x-less",{mediaTypes:o,mediaFeatures:s,mediaValueKeywords:l,propertyKeywords:d,nonStandardPropertyKeywords:f,colorKeywords:m,valueKeywords:b,fontProperties:p,allowNested:!0,lineComment:"//",tokenHooks:{"/":function(t,e){return t.eat("/")?(t.skipToEnd(),["comment","comment"]):t.eat("*")?(e.tokenize=O,O(t,e)):["operator","operator"]},"@":function(t){return t.eat("{")?[null,"interpolation"]:!t.match(/^(charset|document|font-face|import|(-(moz|ms|o|webkit)-)?keyframes|media|namespace|page|supports)\b/i,!1)&&(t.eatWhile(/[\w\\\-]/),t.match(/^\s*:/,!1)?["variable-2","variable-definition"]:["variable-2","variable"])},"&":function(){return["atom","atom"]}},name:"css",helperType:"less"}),t.defineMIME("text/x-gss",{documentTypes:r,mediaTypes:o,mediaFeatures:s,propertyKeywords:d,nonStandardPropertyKeywords:f,fontProperties:p,counterDescriptors:g,colorKeywords:m,valueKeywords:b,supportsAtComponent:!0,tokenHooks:{"/":function(t,e){return!!t.eat("*")&&(e.tokenize=O,O(t,e))}},name:"css",helperType:"gss"})}(n(27))},function(t,e,n){"use strict";n.r(e),e["default"]={run:function(t){t.DomComponents.clear(),t.CssComposer.clear()}}},function(t,e,n){"use strict";n.r(e);var r=n(0),i=n(1),o=n(24);e["default"]={run:function(t){Object(r["bindAll"])(this,'onKeyUp','enableDragger','disableDragger'),this.editor=t,this.canvasModel=this.canvas.getCanvasView().model,this.toggleMove(1)},stop:function(t){this.toggleMove(),this.disableDragger()},onKeyUp:function(t){' '===Object(i["getKeyChar"])(t)&&this.editor.stopCommand(this.id)},enableDragger:function(t){this.toggleDragger(1,t)},disableDragger:function(t){this.toggleDragger(0,t)},toggleDragger:function(t,e){var n=this.canvasModel,r=this.em,i=this.dragger,a=t?'add':'remove';this.getCanvas().classList[a]("".concat(this.ppfx,"is__grabbing")),i||(i=new o["a"]({getPosition:function(){return{x:n.get('x'),y:n.get('y')}},setPosition:function(t){var e=t.x,r=t.y;n.set({x:e,y:r})},onStart:function(t,e){r.trigger('canvas:move:start',e)},onDrag:function(t,e){r.trigger('canvas:move',e)},onEnd:function(t,e){r.trigger('canvas:move:end',e)}}),this.dragger=i),t?i.start(e):i.stop()},toggleMove:function(t){var e=this.ppfx,n=t?'add':'remove',r=t?'on':'off',o={on:i["on"],off:i["off"]},a=this.getCanvas(),s=["".concat(e,"is__grab")];!t&&s.push("".concat(e,"is__grabbing")),s.forEach((function(t){return a.classList[n](t)})),o[r](document,'keyup',this.onKeyUp),o[r](a,'mousedown',this.enableDragger),o[r](document,'mouseup',this.disableDragger)}}},function(t,e,n){"use strict";n.r(e);var r=n(11),i=n.n(r),o=n(0);e["default"]={run:function(t,e){var n=this,r=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},a=[],s=r.component||t.getSelectedAll();return s=Object(o["isArray"])(s)?i()(s):[s],t.select(null),s.forEach((function(t){if(!t||!t.get('removable'))return n.em.logWarning('The element is not removable',{component:t});t.remove(),t.collection&&a.push(t)})),a.length&&t.select(a),s}}},function(t,e,n){"use strict";n.r(e);var r=n(3),i=n.n(r),o=n(0),a=n(24);function s(t,e){var n=Object.keys(t);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(t);e&&(r=r.filter((function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable}))),n.push.apply(n,r)}return n}function c(t){for(var e=1;e<arguments.length;e++){var n=null!=arguments[e]?arguments[e]:{};e%2?s(Object(n),!0).forEach((function(e){i()(t,e,n[e])})):Object.getOwnPropertyDescriptors?Object.defineProperties(t,Object.getOwnPropertyDescriptors(n)):s(Object(n)).forEach((function(e){Object.defineProperty(t,e,Object.getOwnPropertyDescriptor(n,e))}))}return t}var l='dmode';e["default"]={run:function(t,e){var n=this,r=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};Object(o["bindAll"])(this,'setPosition','onStart','onDrag','onEnd','getPosition','getGuidesStatic','renderGuide','getGuidesTarget');var i=r.target,s=r.event,u=r.mode,d=r.dragger,h=void 0===d?{}:d,f=i.getEl(),p=c({doc:f.ownerDocument,onStart:this.onStart,onEnd:this.onEnd,onDrag:this.onDrag,getPosition:this.getPosition,setPosition:this.setPosition,guidesStatic:function(){return n.guidesStatic},guidesTarget:function(){return n.guidesTarget}},h);this.setupGuides(),this.opts=r,this.editor=t,this.em=t.getModel(),this.target=i,this.isTran='translate'==u,this.guidesContainer=this.getGuidesContainer(),this.guidesTarget=this.getGuidesTarget(),this.guidesStatic=this.getGuidesStatic();var g=this.dragger;return g?g.setOptions(p):(g=new a["a"](p),this.dragger=g),s&&g.start(s),this.toggleDrag(1),this.em.trigger("".concat(l,":start"),this.getEventOpts()),g},getEventOpts:function(){return{mode:this.opts.mode,target:this.target,guidesTarget:this.guidesTarget,guidesStatic:this.guidesStatic}},stop:function(){this.toggleDrag()},setupGuides:function(){(this.guides||[]).forEach((function(t){var e=t.guide;e&&e.parentNode.removeChild(e)})),this.guides=[]},getGuidesContainer:function(){var t=this,e=this.guidesEl;if(!e){var n=this.editor,r=this.em,i=this.opts,a=n.getConfig('stylePrefix'),s=document.createElement('div'),c=document.createElement('div'),l="<div class=\"".concat(a,"guide-info__line ").concat(a,"danger-bg\">\n        <div class=\"").concat(a,"guide-info__content ").concat(a,"danger-color\"></div>\n      </div>");(e=document.createElement('div')).className="".concat(a,"guides"),s.className="".concat(a,"guide-info ").concat(a,"guide-info__x"),c.className="".concat(a,"guide-info ").concat(a,"guide-info__y"),s.innerHTML=l,c.innerHTML=l,e.appendChild(s),e.appendChild(c),n.Canvas.getGlobalToolsEl().appendChild(e),this.guidesEl=e,this.elGuideInfoX=s,this.elGuideInfoY=c,this.elGuideInfoContentX=s.querySelector(".".concat(a,"guide-info__content")),this.elGuideInfoContentY=c.querySelector(".".concat(a,"guide-info__content")),r.on('canvas:update frame:scroll',Object(o["debounce"])((function(){t.updateGuides(),i.debug&&t.guides.forEach((function(e){return t.renderGuide(e)}))}),200))}return e},getGuidesStatic:function(){var t=this,e=[],n=this.target.getEl(),r=n.parentNode,i=void 0===r?{}:r;return Object(o["each"])(i.children,(function(r){return e=e.concat(n!==r?t.getElementGuides(r):[])})),e.concat(this.getElementGuides(i))},getGuidesTarget:function(){return this.getElementGuides(this.target.getEl())},updateGuides:function(t){var e,n,r=this;(t||this.guides).forEach((function(t){var i=t.origin,a=e===i?n:r.getElementPos(i);e=i,n=a,Object(o["each"])(r.getGuidePosUpdate(t,a),(function(e,n){return t[n]=e})),t.originRect=a}))},getGuidePosUpdate:function(t,e){var n={},r=e.top,i=e.height,o=e.left,a=e.width;switch(t.type){case't':n.y=r;break;case'b':n.y=r+i;break;case'l':n.x=o;break;case'r':n.x=o+a;break;case'x':n.x=o+a/2;break;case'y':n.y=r+i/2}return n},renderGuide:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},e=t.guide||document.createElement('div'),n='px',r=t.active?2:1,i=e.children[0];return e.style="position: absolute; background-color: ".concat(t.active?'green':'red',";"),e.children.length||((i=document.createElement('div')).style='position: absolute; color: red; padding: 5px; top: 0; left: 0;',e.appendChild(i)),t.y?(e.style.width='100%',e.style.height="".concat(r).concat(n),e.style.top="".concat(t.y).concat(n),e.style.left=0):(e.style.width="".concat(r).concat(n),e.style.height='100%',e.style.left="".concat(t.x).concat(n),e.style.top="0".concat(n)),!t.guide&&this.guidesContainer.appendChild(e),e},getElementPos:function(t){return this.editor.Canvas.getElementPos(t,{noScroll:1})},getElementGuides:function(t){var e=this,n=this.opts,r=this.getElementPos(t),i=r.top,o=r.height,a=r.left,s=r.width,l=[{type:'t',y:i},{type:'b',y:i+o},{type:'l',x:a},{type:'r',x:a+s},{type:'x',x:a+s/2},{type:'y',y:i+o/2}].map((function(i){return c(c({},i),{},{origin:t,originRect:r,guide:n.debug&&e.renderGuide(i)})}));return l.forEach((function(t){return e.guides.push(t)})),l},getTranslate:function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:'x',n=0;return(t||'').split(' ').forEach((function(t){var r=t.trim(),i="translate".concat(e.toUpperCase(),"(");0===r.indexOf(i)&&(n=parseFloat(r.replace(i,'')))})),n},setTranslate:function(t,e,n){var r="translate".concat(e.toUpperCase(),"("),i="".concat(r).concat(n,")"),o=(t||'').split(' ').map((function(t){return 0===t.trim().indexOf(r)&&(t=i),t})).join(' ');return o.indexOf(r)<0&&(o+=" ".concat(i)),o},getPosition:function(){var t=this.target,e=this.isTran,n=t.getStyle(),r=n.left,i=n.top,o=n.transform,a=0,s=0;return e?(a=this.getTranslate(o),s=this.getTranslate(o,'y')):(a=parseFloat(r||0),s=parseFloat(i||0)),{x:a,y:s}},setPosition:function(t){var e=t.x,n=t.y,r=t.end,i=t.position,a=t.width,s=t.height,c=this.target,l=this.isTran,u=this.em,d='px',h=r?'':1,f="".concat(e).concat(d),p="".concat(n).concat(d),g={};if(l){var v=c.getStyle()['transform']||'';v=this.setTranslate(v,'x',f),g={transform:v=this.setTranslate(v,'y',p),en:h},c.addStyle(g,{avoidStore:!r})}else{var m={position:i,width:a,height:s},y={left:f,top:p,en:h};Object(o["keys"])(m).forEach((function(t){var e=m[t];e&&(y[t]=e)})),g=y,c.addStyle(g,{avoidStore:!r})}u.getSelected()&&Object(o["keys"])(g).forEach((function(t){return u.trigger("update:component:style:".concat(t))}))},_getDragData:function(){var t=this.target;return{target:t,parent:t.parent(),index:t.index()}},onStart:function(t){var e=this.target,n=this.editor,r=this.isTran,i=this.opts,o=i.center,a=i.onStart,s=n.Canvas,c=e.getStyle(),l='absolute';if(a&&a(this._getDragData()),!r&&c.position!==l){var u=s.offset(e.getEl()),d=u.left,h=u.top,f=u.width,p=u.height;if(o){var g=s.getMouseRelativeCanvas(t);d=g.x,h=g.y}this.setPosition({x:d,y:h,width:"".concat(f,"px"),height:"".concat(p,"px"),position:l})}},onDrag:function(){var t=this,e=this.guidesTarget,n=this.opts,r=n.onDrag;this.updateGuides(e),n.debug&&e.forEach((function(e){return t.renderGuide(e)})),n.guidesInfo&&this.renderGuideInfo(e.filter((function(t){return t.active}))),r&&r(this._getDragData())},onEnd:function(t,e){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},r=this.editor,i=this.opts,o=this.id,a=i.onEnd;a&&a(t,n,c(c({event:t},n),this._getDragData())),r.stopCommand(o),this.hideGuidesInfo(),this.em.trigger("".concat(l,":end"),this.getEventOpts())},hideGuidesInfo:function(){var t=this;['X','Y'].forEach((function(e){var n=t["elGuideInfo".concat(e)];n&&(n.style.display='none')}))},renderGuideInfo:function(){var t=this,e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:[],n=this.guidesStatic;this.hideGuidesInfo(),e.forEach((function(e){var r=e.origin,i=e.x,a=t.getElementPos(r),s=Object(o["isUndefined"])(i)?'y':'x',u='y'===s,d=a[u?'left':'top'],h=a.rect[u?'left':'top'],f=u?d+a.width:d+a.height,p=u?h+a.rect.width:h+a.rect.height,g=t["elGuideInfo".concat(s.toUpperCase())],v=t["elGuideInfoContent".concat(s.toUpperCase())],m=g.style,y=n.filter((function(t){return t.type===e.type})).map((function(t){var e=t.originRect,n=e.left,r=e.width,i=e.top,o=e.height,a=u?n+r:i+o;return{gap:a<d?d-a:(u?n:i)-f,guide:t}})).filter((function(t){return t.gap>0})).sort((function(t,e){return t.gap-e.gap})).map((function(t){return t.guide}))[0];if(y){var b=y.originRect,w=b.left,O=b.width,x=b.top,C=b.height,k=b.rect,S=u?w<a.left:x<a.top,j=u?w:x,T=u?k.left:k.top,P=u?w+O:x+C,E=u?k.left+k.width:k.top+k.height,_=u?e.y:e.x,M=S?P:f,D="".concat(_,"px"),A=S?d-P:j-f,L=S?h-E:T-p;m.display='',m[u?'top':'left']=D,m[u?'left':'top']="".concat(M,"px"),m[u?'width':'height']="".concat(A,"px"),v.innerHTML="".concat(Math.round(L),"px"),t.em.trigger("".concat(l,":active"),c(c({},t.getEventOpts()),{},{guide:e,guidesStatic:n,matched:y,posFirst:_,posSecond:M,size:A,sizeRaw:L,elGuideInfo:g,elGuideInfoCnt:v}))}}))},toggleDrag:function(t){var e=this.ppfx,n=this.editor,r=t?'add':'remove',i=["".concat(e,"is__grabbing")],o=n.Canvas,a=o.getBody();i.forEach((function(t){return a.classList[r](t)})),o[t?'startAutoscroll':'stopAutoscroll']()}}},function(t,e,n){"use strict";n.r(e),e["default"]={run:function(t){if(t.Canvas.hasFocus()){var e=[];t.getSelectedAll().forEach((function(t){var n=t.components(),r=n&&n.filter((function(t){return t.get('selectable')}))[0];r&&e.push(r)})),e.length&&t.select(e)}}}},function(t,e,n){"use strict";n.r(e),e["default"]={run:function(t,e){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};if(t.Canvas.hasFocus()||n.force){var r=[];t.getSelectedAll().forEach((function(t){for(var e=t.parent();e&&!e.get('selectable');)e=e.parent();e&&r.push(e)})),r.length&&t.select(r)}}}},function(t,e,n){"use strict";n.r(e),e["default"]={run:function(t){if(t.Canvas.hasFocus()){var e=[];t.getSelectedAll().forEach((function(t){var n=t.parent();if(n){var r,i=n.components().length,o=0,a=0;do{o++,r=(a=t.index()+o)<=i?n.getChildAt(a):null}while(r&&!r.get('selectable'));e.push(r||t)}})),e.length&&t.select(e)}}}},function(t,e,n){"use strict";n.r(e),e["default"]={run:function(t){if(t.Canvas.hasFocus()){var e=[];t.getSelectedAll().forEach((function(t){var n=t.parent();if(n){var r,i=0,o=0;do{i++,r=(o=t.index()-i)>=0?n.getChildAt(o):null}while(r&&!r.get('selectable'));e.push(r||t)}})),e.length&&t.select(e)}}}},function(t,e,n){"use strict";n.r(e);var r=n(0);e["default"]={run:function(t,e){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},i=n.target,o=[];if(!i.get('styles'))return o;var a=i.get('type'),s=t.Pages.getAllWrappers(),c=Object(r["flatten"])(s.map((function(t){return t.findType(a)}))).length;if(!c){var l=t.CssComposer.getAll();o=l.filter((function(t){return t.get('group')==="cmp:".concat(a)})),l.remove(o)}return o}}},function(t,e,n){"use strict";n.r(e);var r=n(11),i=n.n(r);e["default"]={run:function(t){var e=t.getModel(),n=i()(t.getSelectedAll());n.length&&e.set('clipboard',n)}}},function(t,e,n){"use strict";n.r(e);var r=n(0),i=n(2),o=n.n(i),a=n(23),s=o.a.$;e["default"]=Object(r["extend"])({},a["default"],{init:function(t){Object(r["bindAll"])(this,'startDelete','stopDelete','onDelete'),this.hoverClass=this.pfx+'hover-delete',this.badgeClass=this.pfx+'badge-red'},enable:function(){this.$el.find('*').mouseover(this.startDelete).mouseout(this.stopDelete).click(this.onDelete)},startDelete:function(t){t.stopPropagation();var e=s(t.target);e.data('model').get('removable')&&(e.addClass(this.hoverClass),this.attachBadge(e.get(0)))},stopDelete:function(t){t.stopPropagation(),s(t.target).removeClass(this.hoverClass),this.badge&&this.badge.css({left:-1e3,top:-1e3})},onDelete:function(t){t.stopPropagation();var e=s(t.target);e.data('model').get('removable')&&(e.data('model').destroy(),this.removeBadge(),this.clean())},updateBadgeLabel:function(t){this.badge.html('Remove '+t.getName())}})},function(t,e,n){"use strict";n.r(e);var r=n(2),i=n.n(r).a.$;e["default"]={run:function(t,e){var n=this;e&&e.set&&e.set('active',0);var r=t.getConfig(),o=t.Modal,a=r.stylePrefix;if(this.cm=t.CodeManager||null,!this.$editors){var s=this.buildEditor('htmlmixed','hopscotch','HTML'),c=this.buildEditor('css','hopscotch','CSS');this.htmlEditor=s.el,this.cssEditor=c.el;var l=i("<div class=\"".concat(a,"export-dl\"></div>"));l.append(s.$el).append(c.$el),this.$editors=l}o.open({title:r.textViewCode,content:this.$editors}).getModel().once('change:open',(function(){return t.stopCommand(n.id)})),this.htmlEditor.setContent(t.getHtml()),this.cssEditor.setContent(t.getCss())},stop:function(t){var e=t.Modal;e&&e.close()},buildEditor:function(t,e,n){var r=document.createElement('textarea');!this.codeMirror&&(this.codeMirror=this.cm.getViewer('CodeMirror'));var i=this.codeMirror.clone().set({label:n,codeName:t,theme:e,input:r}),o=new this.cm.EditorView({model:i,config:this.cm.getConfig()}).render().$el;return i.init(r),{el:i,$el:o}}}},function(t,e,n){"use strict";n.r(e);var r=n(0);e["default"]={isEnabled:function(){var t=document;return t.fullscreenElement||t.webkitFullscreenElement||t.mozFullScreenElement?1:0},enable:function(t){var e='';return t.requestFullscreen?t.requestFullscreen():t.webkitRequestFullscreen?(e='webkit',t.webkitRequestFullscreen()):t.mozRequestFullScreen?(e='moz',t.mozRequestFullScreen()):t.msRequestFullscreen?t.msRequestFullscreen():console.warn('Fullscreen not supported'),e},disable:function(){var t=document;this.isEnabled()&&(t.exitFullscreen?t.exitFullscreen():t.webkitExitFullscreen?t.webkitExitFullscreen():t.mozCancelFullScreen?t.mozCancelFullScreen():t.msExitFullscreen&&t.msExitFullscreen())},fsChanged:function(t,e){document;var n=(t||'')+'fullscreenchange';this.isEnabled()||(this.stop(null,this.sender),document.removeEventListener(n,this.fsChanged))},run:function(t,e){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};this.sender=e;var i=n.target,o=Object(r["isElement"])(i)?i:document.querySelector(i),a=this.enable(o||t.getContainer());this.fsChanged=this.fsChanged.bind(this,a),document.addEventListener(a+'fullscreenchange',this.fsChanged),t.trigger('change:canvasOffset')},stop:function(t,e){e&&e.set&&e.set('active',!1),this.disable(),t&&t.trigger('change:canvasOffset')}}},function(t,e,n){"use strict";n.r(e);var r=n(0),i=n(2),o=n.n(i),a=n(1),s=n(23),c=n(36),l=o.a.$;e["default"]=Object(r["extend"])({},c["default"],s["default"],{init:function(t){s["default"].init.apply(this,arguments),Object(r["bindAll"])(this,'initSorter','rollback','onEndMove'),this.opt=t,this.hoverClass=this.ppfx+'highlighter-warning',this.badgeClass=this.ppfx+'badge-warning',this.noSelClass=this.ppfx+'no-select'},enable:function(){for(var t=arguments.length,e=new Array(t),n=0;n<t;n++)e[n]=arguments[n];s["default"].enable.apply(this,e),this.getBadgeEl().addClass(this.badgeClass),this.getHighlighterEl().addClass(this.hoverClass);var r=this.$wrapper;r.css('cursor','move'),r.on('mousedown',this.initSorter),r.addClass(this.noSelClass)},toggleClipboard:function(){},initSorter:function(t){var e=l(t.target).data('model').get('draggable');e&&(this.cacheEl=null,this.startSelectPosition(t.target,this.frameEl.contentDocument),this.sorter.draggable=e,this.sorter.onEndMove=this.onEndMove.bind(this),this.stopSelectComponent(),this.$wrapper.off('mousedown',this.initSorter),Object(a["on"])(this.getContentWindow(),'keydown',this.rollback))},initSorterFromModel:function(t){var e=t.get('draggable');if(e){this.cacheEl=null;var n=t.view.el;this.startSelectPosition(n,this.frameEl.contentDocument),this.sorter.draggable=e,this.sorter.onEndMove=this.onEndMoveFromModel.bind(this),this.stopSelectComponent(),Object(a["on"])(this.getContentWindow(),'keydown',this.rollback)}},initSorterFromModels:function(t){this.cacheEl=null;var e=t[t.length-1],n=(this.em.get('currentFrame')||{}).model,r=e.getEl(n),i=r.ownerDocument;this.startSelectPosition(r,i,{onStart:this.onStart}),this.sorter.draggable=e.get('draggable'),this.sorter.toMove=t,this.sorter.onMoveClb=this.onDrag,this.sorter.onEndMove=this.onEndMoveFromModel.bind(this),this.stopSelectComponent(),Object(a["on"])(this.getContentWindow(),'keydown',this.rollback)},onEndMoveFromModel:function(){Object(a["off"])(this.getContentWindow(),'keydown',this.rollback)},onEndMove:function(){this.enable(),Object(a["off"])(this.getContentWindow(),'keydown',this.rollback)},onSelect:function(t,e){},rollback:function(t,e){(27==(t.which||t.keyCode)||e)&&(this.sorter.moved=!1,this.sorter.endMove())},getBadgeEl:function(){return this.$badge||(this.$badge=l(this.getBadge())),this.$badge},getHighlighterEl:function(){return this.$hl||(this.$hl=l(this.canvas.getHighlighter())),this.$hl},stop:function(){for(var t=arguments.length,e=new Array(t),n=0;n<t;n++)e[n]=arguments[n];s["default"].stop.apply(this,e),this.getBadgeEl().removeClass(this.badgeClass),this.getHighlighterEl().removeClass(this.hoverClass);var r=this.$wrapper;r.css('cursor','').unbind().removeClass(this.noSelClass)}})},function(t,e,n){"use strict";n.r(e);var r=n(0),i=n(13);e["default"]={open:function(t){var e=this,n=this.editor,i=this.title,o=this.config,a=this.am,s=o.custom;if(Object(r["isFunction"])(s.open))return s.open(a.__customData());n.Modal.open({title:i,content:t}).onceClose((function(){return n.stopCommand(e.id)}))},close:function(){var t=this.config.custom;if(Object(r["isFunction"])(t.close))return t.close(this.am.__customData());var e=this.editor.Modal;e&&e.close()},run:function(t,e){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},r=t.AssetManager,o=r.getConfig(),a=n.types,s=void 0===a?[]:a,c=n.accept,l=n.select;if(this.title=n.modalTitle||t.t('assetManager.modalTitle')||'',this.editor=t,this.config=o,this.am=r,r.setTarget(n.target),r.onClick(n.onClick),r.onDblClick(n.onDblClick),r.onSelect(n.onSelect),r.__behaviour({select:l,types:s,options:n}),o.custom)this.rendered=this.rendered||Object(i["f"])('div'),this.rendered.className="".concat(o.stylePrefix,"custom-wrp"),r.__behaviour({container:this.rendered}),r.__trgCustom();else{if(!this.rendered||s){var u=r.getAll().filter((function(t){return t}));s&&s.length&&(u=u.filter((function(t){return-1!==s.indexOf(t.get('type'))}))),r.render(u),this.rendered=r.getContainer()}if(c){var d=this.rendered.querySelector("input#".concat(o.stylePrefix,"uploadFile"));d&&d.setAttribute('accept',c)}}return this.open(this.rendered),this},stop:function(t){this.editor=t,this.close(this.rendered)}}},function(t,e,n){"use strict";n.r(e);var r=n(0),i=n(13);e["default"]={open:function(){var t=this.container,e=this.editor,n=this.bm,i=this.config,o=i.custom,a=i.appendTo;if(Object(r["isFunction"])(o.open))return o.open(n.__customData());if(this.firstRender&&!a){var s='views-container',c=e.Panels;(c.getPanel(s)||c.addPanel({id:s})).set('appendContent',t).trigger('change:appendContent'),o||t.appendChild(n.render())}t&&(t.style.display='block')},close:function(){var t=this.container,e=this.config.custom;if(Object(r["isFunction"])(e.close))return e.close(this.bm.__customData());t&&(t.style.display='none')},run:function(t){var e=t.Blocks;this.config=e.getConfig(),this.firstRender=!this.container,this.container=this.container||Object(i["f"])('div'),this.editor=t,this.bm=e;var n=this.container;e.__behaviour({container:n}),this.config.custom&&e.__trgCustom(),this.open()},stop:function(){this.close()}}},function(t,e,n){"use strict";n.r(e),e["default"]={run:function(t){var e=t.LayerManager,n=t.Panels;if(!e.getConfig().appendTo){if(!this.layers){var r='views-container',i=document.createElement('div'),o=n.getPanel(r)||n.addPanel({id:r});i.appendChild(e.render()),o.set('appendContent',i).trigger('change:appendContent'),this.layers=i}this.layers.style.display='block'}},stop:function(){var t=this.layers;t&&(t.style.display='none')}}},function(t,e,n){"use strict";n.r(e);var r=n(2),i=n.n(r).a.$;e["default"]={run:function(t,e){if(this.sender=e,!this.$cn){var n=t.getConfig(),r=t.Panels,o='change:appendContent';this.$cn=i('<div></div>'),this.$cn2=i('<div></div>'),this.$cn.append(this.$cn2);var a=t.DeviceManager;if(a&&n.showDevices){var s=r.addPanel({id:'devices-c'}),c=a.render();s.set('appendContent',c).trigger(o)}var l=t.SelectorManager,u=l.getConfig();u.custom?l.__trgCustom({container:this.$cn2.get(0)}):u.appendTo||this.$cn2.append(l.render([]));var d=t.StyleManager,h=d.getConfig();if(!h.appendTo){this.$cn2.append(d.render());var f=h.stylePrefix;this.$header=i("<div class=\"".concat(f,"header\">").concat(t.t('styleManager.empty'),"</div>")),this.$cn.append(this.$header)}var p='views-container';this.panel=r.getPanel(p),this.panel||(this.panel=r.addPanel({id:p})),this.panel.set('appendContent',this.$cn).trigger(o),this.target=t.editor,this.listenTo(this.target,'component:toggled',this.toggleSm)}this.toggleSm()},toggleSm:function(){var t=this.target,e=this.sender;if(!e||!e.get||e.get('active')){var n=t.get('SelectorManager').getConfig().componentFirst,r=t.getSelectedAll().length;1===r||r>1&&n?(this.$cn2&&this.$cn2.show(),this.$header&&this.$header.hide()):(this.$cn2&&this.$cn2.hide(),this.$header&&this.$header.show())}},stop:function(){this.$cn2&&this.$cn2.hide(),this.$header&&this.$header.hide()}}},function(t,e,n){"use strict";n.r(e);var r=n(2),i=n.n(r).a.$;e["default"]={run:function(t,e){this.sender=e;var n=t.getModel(),r=t.Config.stylePrefix,o=t.TraitManager,a=o.getConfig();if(!a.appendTo){if(!this.$cn){this.$cn=i('<div></div>'),this.$cn2=i('<div></div>'),this.$cn.append(this.$cn2),this.$header=i('<div>').append("<div class=\"".concat(a.stylePrefix,"header\">").concat(n.t('traitManager.empty'),"</div>")),this.$cn.append(this.$header),this.$cn2.append("<div class=\"".concat(r,"traits-label\">").concat(n.t('traitManager.label'),"</div>")),this.$cn2.append(o.render());var s=t.Panels;(s.getPanel('views-container')?s.getPanel('views-container'):s.addPanel({id:'views-container'})).set('appendContent',this.$cn.get(0)).trigger('change:appendContent'),this.target=t.getModel(),this.listenTo(this.target,'component:toggled',this.toggleTm)}this.toggleTm()}},toggleTm:function(){var t=this.sender;t&&t.get&&!t.get('active')||(1===this.target.getSelectedAll().length?(this.$cn2.show(),this.$header.hide()):(this.$cn2.hide(),this.$header.show()))},stop:function(){this.$cn2&&this.$cn2.hide(),this.$header&&this.$header.hide()}}},function(t,e,n){"use strict";n.r(e);var r=n(0);e["default"]={run:function(t){var e=t.getModel().get('clipboard'),n=t.getSelected();e&&n&&(t.getSelectedAll().forEach((function(n){if(n){var i,o=n.collection,a=o.indexOf(n)+1,s=e.filter((function(t){return t.get('copyable')}));i=Object(r["contains"])(e,n)&&n.get('copyable')?o.add(n.clone(),{at:a}):o.add(s.map((function(t){return t.clone()})),{at:a}),(i=Object(r["isArray"])(i)?i:[i]).forEach((function(e){return t.trigger('component:paste',e)}))}})),n.emitUpdate())}}},function(t,e,n){"use strict";n.r(e);var r=n(11),i=n.n(r),o=n(0),a='sw-visibility';e["default"]={getPanels:function(t){return this.panels||(this.panels=t.Panels.getPanels()),this.panels},preventDrag:function(t){t.abort=1},tglEffects:function(t){var e=this.em,n=t?'on':'off';if(e){var r=e.get('Canvas'),i=r.getBody(),a=r.getToolbarEl();a&&(a.style.display=t?'none':'');var s=i.querySelectorAll(".".concat(this.ppfx,"no-pointer"));Object(o["each"])(s,(function(e){return e.style.pointerEvents=t?'all':''})),e[n]('run:tlb-move:before',this.preventDrag)}},run:function(t,e){var n=this;this.sender=e,this.selected=i()(t.getSelectedAll()),t.select(),this.shouldRunSwVisibility||(this.shouldRunSwVisibility=t.Commands.isActive(a)),this.shouldRunSwVisibility&&t.stopCommand(a),t.getModel().stopDefault();var r=this.getPanels(t),o=t.Canvas.getElement(),s=t.getEl(),c=t.Config.stylePrefix;if(!this.helper){var l=document.createElement('span');l.className="".concat(c,"off-prv fa fa-eye-slash"),s.appendChild(l),l.onclick=function(){return n.stopCommand()},this.helper=l}this.helper.style.display='inline-block',r.forEach((function(t){return t.set('visible',!1)}));var u=o.style;u.width='100%',u.height='100%',u.top='0',u.left='0',u.padding='0',u.margin='0',t.refresh(),this.tglEffects(1)},stop:function(t){var e=this.sender,n=void 0===e?{}:e,r=this.selected;n.set&&n.set('active',0);var i=this.getPanels(t);this.shouldRunSwVisibility&&(t.runCommand(a),this.shouldRunSwVisibility=!1),t.getModel().runDefault(),i.forEach((function(t){return t.set('visible',!0)})),t.Canvas.getElement().setAttribute('style',''),r&&t.select(r),delete this.selected,this.helper&&(this.helper.style.display='none'),t.refresh(),this.tglEffects()}}},function(t,e,n){"use strict";n.r(e),e["default"]={run:function(t,e,n){var r=n||{},i=r.el||'',o=t.Canvas,a=this.canvasResizer,s=r.options||{},c=o.getCanvasView();return s.appendTo=o.getResizerEl(),s.prefix=t.getConfig().stylePrefix,s.posFetcher=c.getElementPos.bind(c),s.mousePosFetcher=o.getMouseRelativePos,a&&!r.forceNew||(this.canvasResizer=t.Utils.Resizer.init(s),a=this.canvasResizer),a.setOptions(s),a.blur(),a.focus(i),a},stop:function(){var t=this.canvasResizer;t&&t.blur()}}},function(t,e,n){"use strict";n.r(e);var r=n(3),i=n.n(r),o=n(2),a=n.n(o),s=n(0),c=n(1);function l(t,e){var n=Object.keys(t);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(t);e&&(r=r.filter((function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable}))),n.push.apply(n,r)}return n}var u=a.a.$;e["default"]={getOffsetMethod:function(t){return'get'+(t||'')+'OffsetViewerEl'},run:function(t,e,n){var r=n||{},o=r.state||'',a=t.getConfig(),d=this.em.getZoomDecimal(),h=r.el||'';if(!a.showOffsets||Object(c["isTextNode"])(h)||!a.showOffsetsSelected&&'Fixed'==o)t.stopCommand(this.id,n);else{var f=t.Canvas,p=function(t){for(var e=1;e<arguments.length;e++){var n=null!=arguments[e]?arguments[e]:{};e%2?l(Object(n),!0).forEach((function(e){i()(t,e,n[e])})):Object.getOwnPropertyDescriptors?Object.defineProperties(t,Object.getOwnPropertyDescriptors(n)):l(Object(n)).forEach((function(e){Object.defineProperty(t,e,Object.getOwnPropertyDescriptor(n,e))}))}return t}({},r.elPos||f.getElementPos(h));Object(s["isUndefined"])(r.top)||(p.top=r.top),Object(s["isUndefined"])(r.left)||(p.left=r.left);var g=window.getComputedStyle(h),v=this.ppfx,m=o+'State',y=f[this.getOffsetMethod(o)](n.view);y.style.opacity='';var b=this['marginT'+o],w=this['marginB'+o],O=this['marginL'+o],x=this['marginR'+o],C=this['padT'+o],k=this['padB'+o],S=this['padL'+o],j=this['padR'+o];if(y.childNodes.length&&(this[m]='1',b=y.querySelector('[data-offset-m-t]'),w=y.querySelector('[data-offset-m-b]'),O=y.querySelector('[data-offset-m-l]'),x=y.querySelector('[data-offset-m-r]'),C=y.querySelector('[data-offset-p-t]'),k=y.querySelector('[data-offset-p-b]'),S=y.querySelector('[data-offset-p-l]'),j=y.querySelector('[data-offset-p-r]')),!this[m]){var T=o.toLowerCase(),P=T+'margin-v',E=T+'padding-v',_=u("<div class=\"".concat(v,"marginName\">")).get(0),M=u("<div class=\"".concat(v,"paddingName\">")).get(0),D=v+E+'-el',A="".concat(v+P+'-el'," ").concat(v+P),L="".concat(D," ").concat(v+E);b=u("<div class=\"".concat(A,"-top\"></div>")).get(0),w=u("<div class=\"".concat(A,"-bottom\"></div>")).get(0),O=u("<div class=\"".concat(A,"-left\"></div>")).get(0),x=u("<div class=\"".concat(A,"-right\"></div>")).get(0),C=u("<div class=\"".concat(L,"-top\"></div>")).get(0),k=u("<div class=\"".concat(L,"-bottom\"></div>")).get(0),S=u("<div class=\"".concat(L,"-left\"></div>")).get(0),j=u("<div class=\"".concat(L,"-right\"></div>")).get(0),this['marginT'+o]=b,this['marginB'+o]=w,this['marginL'+o]=O,this['marginR'+o]=x,this['padT'+o]=C,this['padB'+o]=k,this['padL'+o]=S,this['padR'+o]=j,_.appendChild(b),_.appendChild(w),_.appendChild(O),_.appendChild(x),M.appendChild(C),M.appendChild(k),M.appendChild(S),M.appendChild(j),y.appendChild(_),y.appendChild(M),this[m]='1'}var N='px',R=parseFloat(g.marginLeft.replace(N,''))*d,I=parseFloat(g.marginRight.replace(N,''))*d,F=parseFloat(g.marginTop.replace(N,''))*d,V=parseFloat(g.marginBottom.replace(N,''))*d,z=b.style,H=w.style,B=O.style,U=x.style,$=C.style,W=k.style,q=S.style,G=j.style,K=parseFloat(p.left),Y=parseFloat(g.width)*d+N;z.height=F+N,z.width=Y,z.top=p.top-F+N,z.left=K+N,H.height=V+N,H.width=Y,H.top=p.top+p.height+N,H.left=K+N;var X=p.height+F+V+N,J=p.top-F+N;B.height=X,B.width=R+N,B.top=J,B.left=K-R+N,U.height=X,U.width=I+N,U.top=J,U.left=K+p.width+N;var Z=parseFloat(g.paddingTop)*d;$.height=Z+N;var Q=parseFloat(g.paddingBottom)*d;W.height=Q+N;var tt=p.height-Q-Z+N,et=p.top+Z+N;q.height=tt,q.width=parseFloat(g.paddingLeft)*d+N,q.top=et;var nt=parseFloat(g.paddingRight)*d;G.height=tt,G.width=nt+N,G.top=et}},stop:function(t,e){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},r=n||{},i=r.state||'',o=this.getOffsetMethod(i),a=t.Canvas,s=a[o](n.view);s.style.opacity=0}}},function(t,e,n){"use strict";n.r(e);var r=n(0);e["default"]={init:function(){Object(r["bindAll"])(this,'_onFramesChange')},run:function(t){this.toggleVis(t)},stop:function(t){this.toggleVis(t,0)},toggleVis:function(t){var e=this,n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:1;if(!t.Commands.isActive('preview')){var r=t.Canvas,i=n?'on':'off';r.getFrames().forEach((function(t){return e._upFrame(t,n)})),r.getModel()[i]('change:frames',this._onFramesChange)}},_onFramesChange:function(t,e){var n=this;e.forEach((function(t){return n._upFrame(t,1)}))},_upFrame:function(t,e){var n=e?'add':'remove';t.view.getBody().classList[n]("".concat(this.ppfx,"dashed"))}}},function(t,e,n){var r,i,o; true&&(i=[n(0),n(2)],void 0===(o='function'==typeof(r=function(t,e){var n=Array.prototype.slice;function r(t,e,n){return n.length<=4?t.call(e,n[0],n[1],n[2],n[3]):t.apply(e,n)}function i(t,e){return n.call(t,e)}function o(e,n){return null!=e&&(t.isArray(n)||(n=i(arguments,1)),t.all(n,(function(t){return t in e})))}var a,s,c=(a=!1,s=-1,function(){return a||(s++,a=!0,t.defer((function(){a=!1}))),s});function l(){this.registeredObjects=[],this.cidIndexes=[]}function u(e,n,r,i){for(var o,a=0,s=n.length;a<s;a++)if(o=n[a]){if("on"===e){if(!i.objectRegistry.register(o))continue}else if(!i.objectRegistry.unregister(o))continue;t.isFunction(o[e])&&o[e]("all",r,i)}}function d(e,n){var r=n.type,i=n.undoTypes,o=!i[r]||i[r][e];t.isFunction(o)&&o(n.object,n.before,n.after,n.options)}function h(e,r,i,o,a){if(!(i.isCurrentlyUndoRedoing||"undo"===e&&-1===i.pointer||"redo"===e&&i.pointer===i.length-1)){i.isCurrentlyUndoRedoing=!0;var s,c,l="undo"===e;for(a?c=l&&i.pointer===i.length-1||!l&&-1===i.pointer?t.clone(i.models):n.apply(i.models,l?[0,i.pointer]:[i.pointer,i.length-1]):(s=i.at(l?i.pointer:i.pointer+1),c=o?i.where({magicFusionIndex:s.get("magicFusionIndex")}):[s]),i.pointer+=(l?-1:1)*c.length;s=l?c.pop():c.shift();)s[e]();i.isCurrentlyUndoRedoing=!1,r.trigger(e,r)}}function f(t,e,n,i){if(t.track&&!t.isCurrentlyUndoRedoing&&e in i&&function(t,e){var n=t.condition,i=typeof n;return"function"===i?!!r(n,t,e):"boolean"!==i||n}(i[e],n)){var a=r(i[e]["on"],i[e],n);if(o(a,"object","before","after")){if(a.type=e,a.magicFusionIndex=c(),a.undoTypes=i,t.pointer<t.length-1)for(var s=t.length-t.pointer-1;s--;)t.pop();t.pointer=t.length,t.add(a),t.length>t.maximumStackLength&&(t.shift(),t.pointer--)}}}l.prototype={isRegistered:function(e){return e&&e.cid?this.registeredObjects[e.cid]:t.contains(this.registeredObjects,e)},register:function(t){return!this.isRegistered(t)&&(t&&t.cid?(this.registeredObjects[t.cid]=t,this.cidIndexes.push(t.cid)):this.registeredObjects.push(t),!0)},unregister:function(e){if(this.isRegistered(e)){if(e&&e.cid)delete this.registeredObjects[e.cid],this.cidIndexes.splice(t.indexOf(this.cidIndexes,e.cid),1);else{var n=t.indexOf(this.registeredObjects,e);this.registeredObjects.splice(n,1)}return!0}return!1},get:function(){return t.map(this.cidIndexes,(function(t){return this.registeredObjects[t]}),this).concat(this.registeredObjects)}};var p={add:{undo:function(t,e,n,r){t.remove(n,r)},redo:function(t,e,n,r){r.index&&(r.at=r.index),t.add(n,r)},on:function(e,n,r){return{object:n,before:void 0,after:e,options:t.clone(r)}}},remove:{undo:function(t,e,n,r){"index"in r&&(r.at=r.index),t.add(e,r)},redo:function(t,e,n,r){t.remove(e,r)},on:function(e,n,r){return{object:n,before:e,after:void 0,options:t.clone(r)}}},change:{undo:function(e,n,r,i){t.isEmpty(n)?t.each(t.keys(r),e.unset,e):(e.set(n),i&&i.unsetData&&i.unsetData.before&&i.unsetData.before.length&&t.each(i.unsetData.before,e.unset,e))},redo:function(e,n,r,i){t.isEmpty(r)?t.each(t.keys(n),e.unset,e):(e.set(r),i&&i.unsetData&&i.unsetData.after&&i.unsetData.after.length&&t.each(i.unsetData.after,e.unset,e))},on:function(e,n){var r=e.changedAttributes(),i=t.keys(r),o=t.pick(e.previousAttributes(),i),a=t.keys(o),s=(n||(n={})).unsetData={after:[],before:[]};return i.length!=a.length&&(i.length>a.length?t.each(i,(function(t){t in o||s.before.push(t)}),this):t.each(a,(function(t){t in r||s.after.push(t)}))),{object:e,before:o,after:r,options:t.clone(n)}}},reset:{undo:function(t,e,n){t.reset(e)},redo:function(t,e,n){t.reset(n)},on:function(e,n){return{object:e,before:n.previousModels,after:t.clone(e.models)}}}};function g(){}function v(e,n,r,i){if("object"==typeof n)return t.each(n,(function(t,n){2===e?v(e,t,r,i):v(e,n,t,r)}));switch(e){case 0:o(r,"undo","redo","on")&&t.all(t.pick(r,"undo","redo","on"),t.isFunction)&&(i[n]=r);break;case 1:i[n]&&t.isObject(r)&&(i[n]=t.extend({},i[n],r));break;case 2:delete i[n]}return this}g.prototype=p;var m=e.Model.extend({defaults:{type:null,object:null,before:null,after:null,magicFusionIndex:null},undo:function(t){d("undo",this.attributes)},redo:function(t){d("redo",this.attributes)}}),y=e.Collection.extend({model:m,pointer:-1,track:!1,isCurrentlyUndoRedoing:!1,maximumStackLength:1/0,setMaxLength:function(t){this.maximumStackLength=t}}),b=e.Model.extend({defaults:{maximumStackLength:1/0,track:!1},initialize:function(e){this.stack=new y,this.objectRegistry=new l,this.undoTypes=new g,this.stack.setMaxLength(this.get("maximumStackLength")),this.on("change:maximumStackLength",(function(t,e){this.stack.setMaxLength(e)}),this),e&&e.track&&this.startTracking(),e&&e.register&&(t.isArray(e.register)||t.isArguments(e.register)?r(this.register,this,e.register):this.register(e.register))},startTracking:function(){this.set("track",!0),this.stack.track=!0},stopTracking:function(){this.set("track",!1),this.stack.track=!1},isTracking:function(){return this.get("track")},_addToStack:function(t){f(this.stack,t,i(arguments,1),this.undoTypes)},register:function(){u("on",arguments,this._addToStack,this)},unregister:function(){u("off",arguments,this._addToStack,this)},unregisterAll:function(){r(this.unregister,this,this.objectRegistry.get())},undo:function(t){h("undo",this,this.stack,t)},undoAll:function(){h("undo",this,this.stack,!1,!0)},redo:function(t){h("redo",this,this.stack,t)},redoAll:function(){h("redo",this,this.stack,!1,!0)},isAvailable:function(t){var e=this.stack,n=e.length;switch(t){case"undo":return n>0&&e.pointer>-1;case"redo":return n>0&&e.pointer<n-1;default:return!1}},merge:function(e){for(var n,r=t.isArray(e)?e:i(arguments);n=r.pop();)n instanceof b&&n.stack instanceof y&&(n.stack=this.stack)},addUndoType:function(t,e){v(0,t,e,this.undoTypes)},changeUndoType:function(t,e){v(1,t,e,this.undoTypes)},removeUndoType:function(t){v(2,t,void 0,this.undoTypes)},clear:function(){this.stack.reset(),this.stack.pointer=-1}});return t.extend(b,{defaults:function(e){t.extend(b.prototype.defaults,e)},addUndoType:function(t,e){v(0,t,e,p)},changeUndoType:function(t,e){v(1,t,e,p)},removeUndoType:function(t){v(2,t,void 0,p)}}),e.UndoManager=b})?r.apply(e,i):r)||(t.exports=o))},function(t,e,n){"use strict";e["a"]=function(t){var e=this.constructor;return this.then((function(n){return e.resolve(t()).then((function(){return n}))}),(function(n){return e.resolve(t()).then((function(){return e.reject(n)}))}))}},function(t,e,n){"use strict";var r=n(14),i=n.n(r);e["a"]=function(t){return new this((function(e,n){if(!t||void 0===t.length)return n(new TypeError(i()(t)+' '+t+' is not iterable(cannot read property Symbol(Symbol.iterator))'));var r=Array.prototype.slice.call(t);if(0===r.length)return e([]);var o=r.length;function a(t,n){if(n&&('object'===i()(n)||'function'==typeof n)){var s=n.then;if('function'==typeof s)return void s.call(n,(function(e){a(t,e)}),(function(n){r[t]={status:'rejected',reason:n},0==--o&&e(r)}))}r[t]={status:'fulfilled',value:n},0==--o&&e(r)}for(var s=0;s<r.length;s++)a(s,r[s])}))}},function(t,e,n){var r=n(49);t.exports=function(t){if(Array.isArray(t))return r(t)},t.exports["default"]=t.exports,t.exports.__esModule=!0},function(t,e){t.exports=function(t){if("undefined"!=typeof Symbol&&null!=t[Symbol.iterator]||null!=t["@@iterator"])return Array.from(t)},t.exports["default"]=t.exports,t.exports.__esModule=!0},function(t,e){t.exports=function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")},t.exports["default"]=t.exports,t.exports.__esModule=!0},function(t,e){t.exports=function(t,e){if(null==t)return{};var n,r,i={},o=Object.keys(t);for(r=0;r<o.length;r++)n=o[r],e.indexOf(n)>=0||(i[n]=t[n]);return i},t.exports["default"]=t.exports,t.exports.__esModule=!0},function(t,e,n){"use strict";n.r(e);var r=n(3),i=n.n(r),o=n(76),a=n.n(o),s=n(0);function c(t,e){var n=Object.keys(t);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(t);e&&(r=r.filter((function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable}))),n.push.apply(n,r)}return n}function l(t){for(var e=1;e<arguments.length;e++){var n=null!=arguments[e]?arguments[e]:{};e%2?c(Object(n),!0).forEach((function(e){i()(t,e,n[e])})):Object.getOwnPropertyDescriptors?Object.defineProperties(t,Object.getOwnPropertyDescriptors(n)):c(Object(n)).forEach((function(e){Object.defineProperty(t,e,Object.getOwnPropertyDescriptor(n,e))}))}return t}e["default"]=function(){var t,e,n,r,i={maximumStackLength:500,trackSelection:1},o=function(t){return t.avoidStore||t.noUndo},c=function(t){return Object.keys(t.changedAttributes())};return{name:'UndoManager',init:function(){var u=this,d=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};n=l(l({},i),d),t=n.em,this.em=t;var h=!0;return(e=new a.a(l({track:!0,register:[]},n))).changeUndoType('change',{condition:function(t){var e=t.get('_undo');if(e){var n=t.get('_undoexc');if(Object(s["isArray"])(n)&&c(t).some((function(t){return n.indexOf(t)>=0})))return!1;if(Object(s["isBoolean"])(e))return!0;if(Object(s["isArray"])(e)&&c(t).some((function(t){return e.indexOf(t)>=0})))return!0}return!1},on:function(t,e,n){!r&&(r=t.previousAttributes());var i=n||e||{};if(i.noUndo&&setTimeout((function(){r=null})),!o(i)){var a=t.toJSON({fromUndo:h}),c={object:t,before:r,after:a};if(r=null,!Object(s["isEmpty"])(a))return c}}}),e.changeUndoType('add',{on:function(t,e){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};if(!o(n)&&u.isRegistered(e))return{object:e,before:void 0,after:t,options:l(l({},n),{},{fromUndo:h})}}}),e.changeUndoType('remove',{on:function(t,e){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};if(!o(n)&&u.isRegistered(e))return{object:e,before:t,after:void 0,options:l(l({},n),{},{fromUndo:h})}}}),e.on('undo redo',(function(){t.trigger('component:toggled change:canvasOffset'),t.getSelectedAll().map((function(t){return t.trigger('rerender:layer')}))})),['undo','redo'].forEach((function(n){return e.on(n,(function(){return t.trigger(n)}))})),this},postLoad:function(){n.trackSelection&&t&&this.add(t.get('selected'))},getConfig:function(){return n},add:function(t){return e.register(t),this},remove:function(t){return e.unregister(t),this},removeAll:function(){return e.unregisterAll(),this},start:function(){return e.startTracking(),this},stop:function(){return e.stopTracking(),this},undo:function(){var n=!(arguments.length>0&&void 0!==arguments[0])||arguments[0];return!t.isEditing()&&e.undo(n),this},undoAll:function(){return e.undoAll(),this},redo:function(){var n=!(arguments.length>0&&void 0!==arguments[0])||arguments[0];return!t.isEditing()&&e.redo(n),this},redoAll:function(){return e.redoAll(),this},hasUndo:function(){return e.isAvailable('undo')},hasRedo:function(){return e.isAvailable('redo')},isRegistered:function(t){return!!this.getInstance().objectRegistry.isRegistered(t)},getStack:function(){return e.stack},getStackGroup:function(){var t=[],e=[];return this.getStack().forEach((function(n){var r=n.get('magicFusionIndex');e.indexOf(r)<0&&(e.push(r),t.push(n))})),t},__getStackRead:function(){var t={};return this.getStack().forEach((function(e){var n=e.get('magicFusionIndex'),r=function(t){var e=t.attributes;return{type:e.type,after:e.after,before:e.before,object:e.object}}(e);t[n]?t[n].push(r):t[n]=[r]})),Object.keys(t).map((function(e){return t[e]}))},getPointer:function(){return this.getStack().pointer},clear:function(){return e.clear(),this},getInstance:function(){return e},destroy:function(){this.clear().removeAll(),[t,e,n,r].forEach((function(t){return{}})),this.em={}}}}},function(t,e,n){(function(t){var r=void 0!==t&&t||"undefined"!=typeof self&&self||window,i=Function.prototype.apply;function o(t,e){this._id=t,this._clearFn=e}e.setTimeout=function(){return new o(i.call(setTimeout,r,arguments),clearTimeout)},e.setInterval=function(){return new o(i.call(setInterval,r,arguments),clearInterval)},e.clearTimeout=e.clearInterval=function(t){t&&t.close()},o.prototype.unref=o.prototype.ref=function(){},o.prototype.close=function(){this._clearFn.call(r,this._id)},e.enroll=function(t,e){clearTimeout(t._idleTimeoutId),t._idleTimeout=e},e.unenroll=function(t){clearTimeout(t._idleTimeoutId),t._idleTimeout=-1},e._unrefActive=e.active=function(t){clearTimeout(t._idleTimeoutId);var e=t._idleTimeout;e>=0&&(t._idleTimeoutId=setTimeout((function(){t._onTimeout&&t._onTimeout()}),e))},n(85),e.setImmediate="undefined"!=typeof self&&self.setImmediate||void 0!==t&&t.setImmediate||this&&this.setImmediate,e.clearImmediate="undefined"!=typeof self&&self.clearImmediate||void 0!==t&&t.clearImmediate||this&&this.clearImmediate}).call(this,n(35))},function(t,e,n){(function(t,e){!function(t,n){"use strict";if(!t.setImmediate){var r,i,o,a,s,c=1,l={},u=!1,d=t.document,h=Object.getPrototypeOf&&Object.getPrototypeOf(t);h=h&&h.setTimeout?h:t,"[object process]"==={}.toString.call(t.process)?r=function(t){e.nextTick((function(){p(t)}))}:!function(){if(t.postMessage&&!t.importScripts){var e=!0,n=t.onmessage;return t.onmessage=function(){e=!1},t.postMessage("","*"),t.onmessage=n,e}}()?t.MessageChannel?((o=new MessageChannel).port1.onmessage=function(t){p(t.data)},r=function(t){o.port2.postMessage(t)}):d&&"onreadystatechange"in d.createElement("script")?(i=d.documentElement,r=function(t){var e=d.createElement("script");e.onreadystatechange=function(){p(t),e.onreadystatechange=null,i.removeChild(e),e=null},i.appendChild(e)}):r=function(t){setTimeout(p,0,t)}:(a="setImmediate$"+Math.random()+"$",s=function(e){e.source===t&&"string"==typeof e.data&&0===e.data.indexOf(a)&&p(+e.data.slice(a.length))},t.addEventListener?t.addEventListener("message",s,!1):t.attachEvent("onmessage",s),r=function(e){t.postMessage(a+e,"*")}),h.setImmediate=function(t){"function"!=typeof t&&(t=new Function(""+t));for(var e=new Array(arguments.length-1),n=0;n<e.length;n++)e[n]=arguments[n+1];var i={callback:t,args:e};return l[c]=i,r(c),c++},h.clearImmediate=f}function f(t){delete l[t]}function p(t){if(u)setTimeout(p,0,t);else{var e=l[t];if(e){u=!0;try{!function(t){var e=t.callback,r=t.args;switch(r.length){case 0:e();break;case 1:e(r[0]);break;case 2:e(r[0],r[1]);break;case 3:e(r[0],r[1],r[2]);break;default:e.apply(n,r)}}(e)}finally{f(t),u=!1}}}}}("undefined"==typeof self?void 0===t?this:t:self)}).call(this,n(35),n(86))},function(t,e){var n,r,i=t.exports={};function o(){throw new Error('setTimeout has not been defined')}function a(){throw new Error('clearTimeout has not been defined')}function s(t){if(n===setTimeout)return setTimeout(t,0);if((n===o||!n)&&setTimeout)return n=setTimeout,setTimeout(t,0);try{return n(t,0)}catch(e){try{return n.call(null,t,0)}catch(e){return n.call(this,t,0)}}}!function(){try{n='function'==typeof setTimeout?setTimeout:o}catch(t){n=o}try{r='function'==typeof clearTimeout?clearTimeout:a}catch(t){r=a}}();var c,l=[],u=!1,d=-1;function h(){u&&c&&(u=!1,c.length?l=c.concat(l):d=-1,l.length&&f())}function f(){if(!u){var t=s(h);u=!0;for(var e=l.length;e;){for(c=l,l=[];++d<e;)c&&c[d].run();d=-1,e=l.length}c=null,u=!1,function(t){if(r===clearTimeout)return clearTimeout(t);if((r===a||!r)&&clearTimeout)return r=clearTimeout,clearTimeout(t);try{r(t)}catch(e){try{return r.call(null,t)}catch(e){return r.call(this,t)}}}(t)}}function p(t,e){this.fun=t,this.array=e}function g(){}i.nextTick=function(t){var e=new Array(arguments.length-1);if(arguments.length>1)for(var n=1;n<arguments.length;n++)e[n-1]=arguments[n];l.push(new p(t,e)),1!==l.length||u||s(f)},p.prototype.run=function(){this.fun.apply(null,this.array)},i.title='browser',i.browser=!0,i.env={},i.argv=[],i.version='',i.versions={},i.on=g,i.addListener=g,i.once=g,i.off=g,i.removeListener=g,i.removeAllListeners=g,i.emit=g,i.prependListener=g,i.prependOnceListener=g,i.listeners=function(t){return[]},i.binding=function(t){throw new Error('process.binding is not supported')},i.cwd=function(){return'/'},i.chdir=function(t){throw new Error('process.chdir is not supported')},i.umask=function(){return 0}},function(t,e){function n(e,r){return t.exports=n=Object.setPrototypeOf||function(t,e){return t.__proto__=e,t},t.exports["default"]=t.exports,t.exports.__esModule=!0,n(e,r)}t.exports=n,t.exports["default"]=t.exports,t.exports.__esModule=!0},function(t,e){t.exports=function(t){if(void 0===t)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return t},t.exports["default"]=t.exports,t.exports.__esModule=!0},function(t,e,n){ true&&function(t){"use strict";var e={script:[["lang",/(javascript|babel)/i,"javascript"],["type",/^(?:text|application)\/(?:x-)?(?:java|ecma)script$|^module$|^$/i,"javascript"],["type",/./,"text/plain"],[null,null,"javascript"]],style:[["lang",/^css$/i,"css"],["type",/^(text\/)?(x-)?(stylesheet|css)$/i,"css"],["type",/./,"text/plain"],[null,null,"css"]]},n={};function r(t,e){var r=t.match(function(t){var e=n[t];return e||(n[t]=new RegExp("\\s+"+t+"\\s*=\\s*('|\")?([^'\"]+)('|\")?\\s*"))}(e));return r?/^\s*(.*?)\s*$/.exec(r[2])[1]:""}function i(t,e){return new RegExp((e?"^":"")+"</s*"+t+"s*>","i")}function o(t,e){for(var n in t)for(var r=e[n]||(e[n]=[]),i=t[n],o=i.length-1;o>=0;o--)r.unshift(i[o])}t.defineMode("htmlmixed",(function(n,a){var s=t.getMode(n,{name:"xml",htmlMode:!0,multilineTagIndentFactor:a.multilineTagIndentFactor,multilineTagIndentPastTag:a.multilineTagIndentPastTag,allowMissingTagName:a.allowMissingTagName}),c={},l=a&&a.tags,u=a&&a.scriptTypes;if(o(e,c),l&&o(l,c),u)for(var d=u.length-1;d>=0;d--)c.script.unshift(["type",u[d].matches,u[d].mode]);function h(e,o){var a,l=s.token(e,o.htmlState),u=/\btag\b/.test(l);if(u&&!/[<>\s\/]/.test(e.current())&&(a=o.htmlState.tagName&&o.htmlState.tagName.toLowerCase())&&c.hasOwnProperty(a))o.inTag=a+" ";else if(o.inTag&&u&&/>$/.test(e.current())){var d=/^([\S]+) (.*)/.exec(o.inTag);o.inTag=null;var f=">"==e.current()&&function(t,e){for(var n=0;n<t.length;n++){var i=t[n];if(!i[0]||i[1].test(r(e,i[0])))return i[2]}}(c[d[1]],d[2]),p=t.getMode(n,f),g=i(d[1],!0),v=i(d[1],!1);o.token=function(t,e){return t.match(g,!1)?(e.token=h,e.localState=e.localMode=null,null):function(t,e,n){var r=t.current(),i=r.search(e);return i>-1?t.backUp(r.length-i):r.match(/<\/?$/)&&(t.backUp(r.length),t.match(e,!1)||t.match(r)),n}(t,v,e.localMode.token(t,e.localState))},o.localMode=p,o.localState=t.startState(p,s.indent(o.htmlState,"",""))}else o.inTag&&(o.inTag+=e.current(),e.eol()&&(o.inTag+=" "));return l}return{startState:function(){return{token:h,inTag:null,localMode:null,localState:null,htmlState:t.startState(s)}},copyState:function(e){var n;return e.localState&&(n=t.copyState(e.localMode,e.localState)),{token:e.token,inTag:e.inTag,localMode:e.localMode,localState:n,htmlState:t.copyState(s,e.htmlState)}},token:function(t,e){return e.token(t,e)},indent:function(e,n,r){return!e.localMode||/^\s*<\//.test(n)?s.indent(e.htmlState,n,r):e.localMode.indent?e.localMode.indent(e.localState,n,r):t.Pass},innerMode:function(t){return{state:t.localState||t.htmlState,mode:t.localMode||s}}}}),"xml","javascript","css"),t.defineMIME("text/html","htmlmixed")}(n(27),n(90),n(91),n(51))},function(t,e,n){ true&&function(t){"use strict";var e={autoSelfClosers:{area:!0,base:!0,br:!0,col:!0,command:!0,embed:!0,frame:!0,hr:!0,img:!0,input:!0,keygen:!0,link:!0,meta:!0,param:!0,source:!0,track:!0,wbr:!0,menuitem:!0},implicitlyClosed:{dd:!0,li:!0,optgroup:!0,option:!0,p:!0,rp:!0,rt:!0,tbody:!0,td:!0,tfoot:!0,th:!0,tr:!0},contextGrabbers:{dd:{dd:!0,dt:!0},dt:{dd:!0,dt:!0},li:{li:!0},option:{option:!0,optgroup:!0},optgroup:{optgroup:!0},p:{address:!0,article:!0,aside:!0,blockquote:!0,dir:!0,div:!0,dl:!0,fieldset:!0,footer:!0,form:!0,h1:!0,h2:!0,h3:!0,h4:!0,h5:!0,h6:!0,header:!0,hgroup:!0,hr:!0,menu:!0,nav:!0,ol:!0,p:!0,pre:!0,section:!0,table:!0,ul:!0},rp:{rp:!0,rt:!0},rt:{rp:!0,rt:!0},tbody:{tbody:!0,tfoot:!0},td:{td:!0,th:!0},tfoot:{tbody:!0},th:{td:!0,th:!0},thead:{tbody:!0,tfoot:!0},tr:{tr:!0}},doNotIndent:{pre:!0},allowUnquoted:!0,allowMissing:!0,caseFold:!0},n={autoSelfClosers:{},implicitlyClosed:{},contextGrabbers:{},doNotIndent:{},allowUnquoted:!1,allowMissing:!1,allowMissingTagName:!1,caseFold:!1};t.defineMode("xml",(function(r,i){var o,a,s=r.indentUnit,c={},l=i.htmlMode?e:n;for(var u in l)c[u]=l[u];for(var u in i)c[u]=i[u];function d(t,e){function n(n){return e.tokenize=n,n(t,e)}var r=t.next();return"<"==r?t.eat("!")?t.eat("[")?t.match("CDATA[")?n(f("atom","]]>")):null:t.match("--")?n(f("comment","--\x3e")):t.match("DOCTYPE",!0,!0)?(t.eatWhile(/[\w\._\-]/),n(function t(e){return function(n,r){for(var i;null!=(i=n.next());){if("<"==i)return r.tokenize=t(e+1),r.tokenize(n,r);if(">"==i){if(1==e){r.tokenize=d;break}return r.tokenize=t(e-1),r.tokenize(n,r)}}return"meta"}}(1))):null:t.eat("?")?(t.eatWhile(/[\w\._\-]/),e.tokenize=f("meta","?>"),"meta"):(o=t.eat("/")?"closeTag":"openTag",e.tokenize=h,"tag bracket"):"&"==r?(t.eat("#")?t.eat("x")?t.eatWhile(/[a-fA-F\d]/)&&t.eat(";"):t.eatWhile(/[\d]/)&&t.eat(";"):t.eatWhile(/[\w\.\-:]/)&&t.eat(";"))?"atom":"error":(t.eatWhile(/[^&<]/),null)}function h(t,e){var n,r,i=t.next();if(">"==i||"/"==i&&t.eat(">"))return e.tokenize=d,o=">"==i?"endTag":"selfcloseTag","tag bracket";if("="==i)return o="equals",null;if("<"==i){e.tokenize=d,e.state=y,e.tagName=e.tagStart=null;var a=e.tokenize(t,e);return a?a+" tag error":"tag error"}return/[\'\"]/.test(i)?(e.tokenize=(n=i,(r=function(t,e){for(;!t.eol();)if(t.next()==n){e.tokenize=h;break}return"string"}).isInAttribute=!0,r),e.stringStartCol=t.column(),e.tokenize(t,e)):(t.match(/^[^\s\u00a0=<>\"\']*[^\s\u00a0=<>\"\'\/]/),"word")}function f(t,e){return function(n,r){for(;!n.eol();){if(n.match(e)){r.tokenize=d;break}n.next()}return t}}function p(t){return t&&t.toLowerCase()}function g(t,e,n){this.prev=t.context,this.tagName=e||"",this.indent=t.indented,this.startOfLine=n,(c.doNotIndent.hasOwnProperty(e)||t.context&&t.context.noIndent)&&(this.noIndent=!0)}function v(t){t.context&&(t.context=t.context.prev)}function m(t,e){for(var n;1;){if(!t.context)return;if(n=t.context.tagName,!c.contextGrabbers.hasOwnProperty(p(n))||!c.contextGrabbers[p(n)].hasOwnProperty(p(e)))return;v(t)}}function y(t,e,n){return"openTag"==t?(n.tagStart=e.column(),b):"closeTag"==t?w:y}function b(t,e,n){return"word"==t?(n.tagName=e.current(),a="tag",C):c.allowMissingTagName&&"endTag"==t?(a="tag bracket",C(t,0,n)):(a="error",b)}function w(t,e,n){if("word"==t){var r=e.current();return n.context&&n.context.tagName!=r&&c.implicitlyClosed.hasOwnProperty(p(n.context.tagName))&&v(n),n.context&&n.context.tagName==r||!1===c.matchClosing?(a="tag",O):(a="tag error",x)}return c.allowMissingTagName&&"endTag"==t?(a="tag bracket",O(t,0,n)):(a="error",x)}function O(t,e,n){return"endTag"!=t?(a="error",O):(v(n),y)}function x(t,e,n){return a="error",O(t,0,n)}function C(t,e,n){if("word"==t)return a="attribute",k;if("endTag"==t||"selfcloseTag"==t){var r=n.tagName,i=n.tagStart;return n.tagName=n.tagStart=null,"selfcloseTag"==t||c.autoSelfClosers.hasOwnProperty(p(r))?m(n,r):(m(n,r),n.context=new g(n,r,i==n.indented)),y}return a="error",C}function k(t,e,n){return"equals"==t?S:(c.allowMissing||(a="error"),C(t,0,n))}function S(t,e,n){return"string"==t?j:"word"==t&&c.allowUnquoted?(a="string",C):(a="error",C(t,0,n))}function j(t,e,n){return"string"==t?j:C(t,0,n)}return d.isInText=!0,{startState:function(t){var e={tokenize:d,state:y,indented:t||0,tagName:null,tagStart:null,context:null};return null!=t&&(e.baseIndent=t),e},token:function(t,e){if(!e.tagName&&t.sol()&&(e.indented=t.indentation()),t.eatSpace())return null;o=null;var n=e.tokenize(t,e);return(n||o)&&"comment"!=n&&(a=null,e.state=e.state(o||n,t,e),a&&(n="error"==a?n+" error":a)),n},indent:function(e,n,r){var i=e.context;if(e.tokenize.isInAttribute)return e.tagStart==e.indented?e.stringStartCol+1:e.indented+s;if(i&&i.noIndent)return t.Pass;if(e.tokenize!=h&&e.tokenize!=d)return r?r.match(/^(\s*)/)[0].length:0;if(e.tagName)return!1!==c.multilineTagIndentPastTag?e.tagStart+e.tagName.length+2:e.tagStart+s*(c.multilineTagIndentFactor||1);if(c.alignCDATA&&/<!\[CDATA\[/.test(n))return 0;var o=n&&/^<(\/)?([\w_:\.-]*)/.exec(n);if(o&&o[1])for(;i;){if(i.tagName==o[2]){i=i.prev;break}if(!c.implicitlyClosed.hasOwnProperty(p(i.tagName)))break;i=i.prev}else if(o)for(;i;){var a=c.contextGrabbers[p(i.tagName)];if(!a||!a.hasOwnProperty(p(o[2])))break;i=i.prev}for(;i&&i.prev&&!i.startOfLine;)i=i.prev;return i?i.indent+s:e.baseIndent||0},electricInput:/<\/[\s\w:]+>$/,blockCommentStart:"\x3c!--",blockCommentEnd:"--\x3e",configuration:c.htmlMode?"html":"xml",helperType:c.htmlMode?"html":"xml",skipAttribute:function(t){t.state==S&&(t.state=C)},xmlCurrentTag:function(t){return t.tagName?{name:t.tagName,close:"closeTag"==t.type}:null},xmlCurrentContext:function(t){for(var e=[],n=t.context;n;n=n.prev)e.push(n.tagName);return e.reverse()}}})),t.defineMIME("text/xml","xml"),t.defineMIME("application/xml","xml"),t.mimeModes.hasOwnProperty("text/html")||t.defineMIME("text/html",{name:"xml",htmlMode:!0})}(n(27))},function(t,e,n){ true&&function(t){"use strict";t.defineMode("javascript",(function(e,n){var r,i,o=e.indentUnit,a=n.statementIndent,s=n.jsonld,c=n.json||s,l=!1!==n.trackScope,u=n.typescript,d=n.wordCharacters||/[\w$\xa1-\uffff]/,h=function(){function t(t){return{type:t,style:"keyword"}}var e=t("keyword a"),n=t("keyword b"),r=t("keyword c"),i=t("keyword d"),o=t("operator"),a={type:"atom",style:"atom"};return{if:t("if"),while:e,with:e,else:n,do:n,try:n,finally:n,return:i,break:i,continue:i,new:t("new"),delete:r,void:r,throw:r,debugger:t("debugger"),var:t("var"),const:t("var"),let:t("var"),function:t("function"),catch:t("catch"),for:t("for"),switch:t("switch"),case:t("case"),default:t("default"),in:o,typeof:o,instanceof:o,true:a,false:a,null:a,undefined:a,NaN:a,Infinity:a,this:t("this"),class:t("class"),super:t("atom"),yield:r,export:t("export"),import:t("import"),extends:r,await:r}}(),f=/[+\-*&%=<>!?|~^@]/,p=/^@(context|id|value|language|type|container|list|set|reverse|index|base|vocab|graph)"/;function g(t,e,n){return r=t,i=n,e}function v(t,e){var n,r=t.next();if('"'==r||"'"==r)return e.tokenize=(n=r,function(t,e){var r,i=!1;if(s&&"@"==t.peek()&&t.match(p))return e.tokenize=v,g("jsonld-keyword","meta");for(;null!=(r=t.next())&&(r!=n||i);)i=!i&&"\\"==r;return i||(e.tokenize=v),g("string","string")}),e.tokenize(t,e);if("."==r&&t.match(/^\d[\d_]*(?:[eE][+\-]?[\d_]+)?/))return g("number","number");if("."==r&&t.match(".."))return g("spread","meta");if(/[\[\]{}\(\),;\:\.]/.test(r))return g(r);if("="==r&&t.eat(">"))return g("=>","operator");if("0"==r&&t.match(/^(?:x[\dA-Fa-f_]+|o[0-7_]+|b[01_]+)n?/))return g("number","number");if(/\d/.test(r))return t.match(/^[\d_]*(?:n|(?:\.[\d_]*)?(?:[eE][+\-]?[\d_]+)?)?/),g("number","number");if("/"==r)return t.eat("*")?(e.tokenize=m,m(t,e)):t.eat("/")?(t.skipToEnd(),g("comment","comment")):Qt(t,e,1)?(function(t){for(var e,n=!1,r=!1;null!=(e=t.next());){if(!n){if("/"==e&&!r)return;"["==e?r=!0:r&&"]"==e&&(r=!1)}n=!n&&"\\"==e}}(t),t.match(/^\b(([gimyus])(?![gimyus]*\2))+\b/),g("regexp","string-2")):(t.eat("="),g("operator","operator",t.current()));if("`"==r)return e.tokenize=y,y(t,e);if("#"==r&&"!"==t.peek())return t.skipToEnd(),g("meta","meta");if("#"==r&&t.eatWhile(d))return g("variable","property");if("<"==r&&t.match("!--")||"-"==r&&t.match("->")&&!/\S/.test(t.string.slice(0,t.start)))return t.skipToEnd(),g("comment","comment");if(f.test(r))return">"==r&&e.lexical&&">"==e.lexical.type||(t.eat("=")?"!"!=r&&"="!=r||t.eat("="):/[<>*+\-|&?]/.test(r)&&(t.eat(r),">"==r&&t.eat(r))),"?"==r&&t.eat(".")?g("."):g("operator","operator",t.current());if(d.test(r)){t.eatWhile(d);var i=t.current();if("."!=e.lastType){if(h.propertyIsEnumerable(i)){var o=h[i];return g(o.type,o.style,i)}if("async"==i&&t.match(/^(\s|\/\*([^*]|\*(?!\/))*?\*\/)*[\[\(\w]/,!1))return g("async","keyword",i)}return g("variable","variable",i)}}function m(t,e){for(var n,r=!1;n=t.next();){if("/"==n&&r){e.tokenize=v;break}r="*"==n}return g("comment","comment")}function y(t,e){for(var n,r=!1;null!=(n=t.next());){if(!r&&("`"==n||"$"==n&&t.eat("{"))){e.tokenize=v;break}r=!r&&"\\"==n}return g("quasi","string-2",t.current())}var b="([{}])";function w(t,e){e.fatArrowAt&&(e.fatArrowAt=null);var n=t.string.indexOf("=>",t.start);if(!(n<0)){if(u){var r=/:\s*(?:\w+(?:<[^>]*>|\[\])?|\{[^}]*\})\s*$/.exec(t.string.slice(t.start,n));r&&(n=r.index)}for(var i=0,o=!1,a=n-1;a>=0;--a){var s=t.string.charAt(a),c=b.indexOf(s);if(c>=0&&c<3){if(!i){++a;break}if(0==--i){"("==s&&(o=!0);break}}else if(c>=3&&c<6)++i;else if(d.test(s))o=!0;else if(/["'\/`]/.test(s))for(;;--a){if(0==a)return;if(t.string.charAt(a-1)==s&&"\\"!=t.string.charAt(a-2)){a--;break}}else if(o&&!i){++a;break}}o&&!i&&(e.fatArrowAt=a)}}var O={atom:!0,number:!0,variable:!0,string:!0,regexp:!0,this:!0,import:!0,"jsonld-keyword":!0};function x(t,e,n,r,i,o){this.indented=t,this.column=e,this.type=n,this.prev=i,this.info=o,null!=r&&(this.align=r)}function C(t,e){if(!l)return!1;for(var n=t.localVars;n;n=n.next)if(n.name==e)return!0;for(var r=t.context;r;r=r.prev)for(n=r.vars;n;n=n.next)if(n.name==e)return!0}function k(t,e,n,r,i){var o=t.cc;for(S.state=t,S.stream=i,S.marked=null,S.cc=o,S.style=e,t.lexical.hasOwnProperty("align")||(t.lexical.align=!0);1;)if((o.length?o.pop():c?B:z)(n,r)){for(;o.length&&o[o.length-1].lex;)o.pop()();return S.marked?S.marked:"variable"==n&&C(t,r)?"variable-2":e}}var S={state:null,column:null,marked:null,cc:null};function j(){for(var t=arguments.length-1;t>=0;t--)S.cc.push(arguments[t])}function T(){return j.apply(null,arguments),!0}function P(t,e){for(var n=e;n;n=n.next)if(n.name==t)return!0;return!1}function E(t){var e=S.state;if(S.marked="def",l){if(e.context)if("var"==e.lexical.info&&e.context&&e.context.block){var r=function t(e,n){if(n){if(n.block){var r=t(e,n.prev);return r?r==n.prev?n:new M(r,n.vars,!0):null}return P(e,n.vars)?n:new M(n.prev,new D(e,n.vars),!1)}return null}(t,e.context);if(null!=r)return void(e.context=r)}else if(!P(t,e.localVars))return void(e.localVars=new D(t,e.localVars));n.globalVars&&!P(t,e.globalVars)&&(e.globalVars=new D(t,e.globalVars))}}function _(t){return"public"==t||"private"==t||"protected"==t||"abstract"==t||"readonly"==t}function M(t,e,n){this.prev=t,this.vars=e,this.block=n}function D(t,e){this.name=t,this.next=e}var A=new D("this",new D("arguments",null));function L(){S.state.context=new M(S.state.context,S.state.localVars,!1),S.state.localVars=A}function N(){S.state.context=new M(S.state.context,S.state.localVars,!0),S.state.localVars=null}function R(){S.state.localVars=S.state.context.vars,S.state.context=S.state.context.prev}function I(t,e){var n=function(){var n=S.state,r=n.indented;if("stat"==n.lexical.type)r=n.lexical.indented;else for(var i=n.lexical;i&&")"==i.type&&i.align;i=i.prev)r=i.indented;n.lexical=new x(r,S.stream.column(),t,null,n.lexical,e)};return n.lex=!0,n}function F(){var t=S.state;t.lexical.prev&&(")"==t.lexical.type&&(t.indented=t.lexical.indented),t.lexical=t.lexical.prev)}function V(t){return function e(n){return n==t?T():";"==t||"}"==n||")"==n||"]"==n?j():T(e)}}function z(t,e){return"var"==t?T(I("vardef",e),kt,V(";"),F):"keyword a"==t?T(I("form"),$,z,F):"keyword b"==t?T(I("form"),z,F):"keyword d"==t?S.stream.match(/^\s*$/,!1)?T():T(I("stat"),q,V(";"),F):"debugger"==t?T(V(";")):"{"==t?T(I("}"),N,ct,F,R):";"==t?T():"if"==t?("else"==S.state.lexical.info&&S.state.cc[S.state.cc.length-1]==F&&S.state.cc.pop()(),T(I("form"),$,z,F,_t)):"function"==t?T(Lt):"for"==t?T(I("form"),N,Mt,z,R,F):"class"==t||u&&"interface"==e?(S.marked="keyword",T(I("form","class"==t?t:e),Vt,F)):"variable"==t?u&&"declare"==e?(S.marked="keyword",T(z)):u&&("module"==e||"enum"==e||"type"==e)&&S.stream.match(/^\s*\w/,!1)?(S.marked="keyword","enum"==e?T(Jt):"type"==e?T(Rt,V("operator"),ft,V(";")):T(I("form"),St,V("{"),I("}"),ct,F,F)):u&&"namespace"==e?(S.marked="keyword",T(I("form"),B,z,F)):u&&"abstract"==e?(S.marked="keyword",T(z)):T(I("stat"),et):"switch"==t?T(I("form"),$,V("{"),I("}","switch"),N,ct,F,F,R):"case"==t?T(B,V(":")):"default"==t?T(V(":")):"catch"==t?T(I("form"),L,H,z,F,R):"export"==t?T(I("stat"),Ut,F):"import"==t?T(I("stat"),Wt,F):"async"==t?T(z):"@"==e?T(B,z):j(I("stat"),B,V(";"),F)}function H(t){if("("==t)return T(It,V(")"))}function B(t,e){return W(t,e,!1)}function U(t,e){return W(t,e,!0)}function $(t){return"("!=t?j():T(I(")"),q,V(")"),F)}function W(t,e,n){if(S.state.fatArrowAt==S.stream.start){var r=n?Z:J;if("("==t)return T(L,I(")"),at(It,")"),F,V("=>"),r,R);if("variable"==t)return j(L,St,V("=>"),r,R)}var i=n?K:G;return O.hasOwnProperty(t)?T(i):"function"==t?T(Lt,i):"class"==t||u&&"interface"==e?(S.marked="keyword",T(I("form"),Ft,F)):"keyword c"==t||"async"==t?T(n?U:B):"("==t?T(I(")"),q,V(")"),F,i):"operator"==t||"spread"==t?T(n?U:B):"["==t?T(I("]"),Xt,F,i):"{"==t?st(rt,"}",null,i):"quasi"==t?j(Y,i):"new"==t?T(function(t){return function(e){return"."==e?T(t?tt:Q):"variable"==e&&u?T(Ot,t?K:G):j(t?U:B)}}(n)):T()}function q(t){return t.match(/[;\}\)\],]/)?j():j(B)}function G(t,e){return","==t?T(q):K(t,e,!1)}function K(t,e,n){var r=0==n?G:K,i=0==n?B:U;return"=>"==t?T(L,n?Z:J,R):"operator"==t?/\+\+|--/.test(e)||u&&"!"==e?T(r):u&&"<"==e&&S.stream.match(/^([^<>]|<[^<>]*>)*>\s*\(/,!1)?T(I(">"),at(ft,">"),F,r):"?"==e?T(B,V(":"),i):T(i):"quasi"==t?j(Y,r):";"!=t?"("==t?st(U,")","call",r):"."==t?T(nt,r):"["==t?T(I("]"),q,V("]"),F,r):u&&"as"==e?(S.marked="keyword",T(ft,r)):"regexp"==t?(S.state.lastType=S.marked="operator",S.stream.backUp(S.stream.pos-S.stream.start-1),T(i)):void 0:void 0}function Y(t,e){return"quasi"!=t?j():"${"!=e.slice(e.length-2)?T(Y):T(q,X)}function X(t){if("}"==t)return S.marked="string-2",S.state.tokenize=y,T(Y)}function J(t){return w(S.stream,S.state),j("{"==t?z:B)}function Z(t){return w(S.stream,S.state),j("{"==t?z:U)}function Q(t,e){if("target"==e)return S.marked="keyword",T(G)}function tt(t,e){if("target"==e)return S.marked="keyword",T(K)}function et(t){return":"==t?T(F,z):j(G,V(";"),F)}function nt(t){if("variable"==t)return S.marked="property",T()}function rt(t,e){return"async"==t?(S.marked="property",T(rt)):"variable"==t||"keyword"==S.style?(S.marked="property","get"==e||"set"==e?T(it):(u&&S.state.fatArrowAt==S.stream.start&&(n=S.stream.match(/^\s*:\s*/,!1))&&(S.state.fatArrowAt=S.stream.pos+n[0].length),T(ot))):"number"==t||"string"==t?(S.marked=s?"property":S.style+" property",T(ot)):"jsonld-keyword"==t?T(ot):u&&_(e)?(S.marked="keyword",T(rt)):"["==t?T(B,lt,V("]"),ot):"spread"==t?T(U,ot):"*"==e?(S.marked="keyword",T(rt)):":"==t?j(ot):void 0;var n}function it(t){return"variable"!=t?j(ot):(S.marked="property",T(Lt))}function ot(t){return":"==t?T(U):"("==t?j(Lt):void 0}function at(t,e,n){function r(i,o){if(n?n.indexOf(i)>-1:","==i){var a=S.state.lexical;return"call"==a.info&&(a.pos=(a.pos||0)+1),T((function(n,r){return n==e||r==e?j():j(t)}),r)}return i==e||o==e?T():n&&n.indexOf(";")>-1?j(t):T(V(e))}return function(n,i){return n==e||i==e?T():j(t,r)}}function st(t,e,n){for(var r=3;r<arguments.length;r++)S.cc.push(arguments[r]);return T(I(e,n),at(t,e),F)}function ct(t){return"}"==t?T():j(z,ct)}function lt(t,e){if(u){if(":"==t)return T(ft);if("?"==e)return T(lt)}}function ut(t,e){if(u&&(":"==t||"in"==e))return T(ft)}function dt(t){if(u&&":"==t)return S.stream.match(/^\s*\w+\s+is\b/,!1)?T(B,ht,ft):T(ft)}function ht(t,e){if("is"==e)return S.marked="keyword",T()}function ft(t,e){return"keyof"==e||"typeof"==e||"infer"==e||"readonly"==e?(S.marked="keyword",T("typeof"==e?U:ft)):"variable"==t||"void"==e?(S.marked="type",T(wt)):"|"==e||"&"==e?T(ft):"string"==t||"number"==t||"atom"==t?T(wt):"["==t?T(I("]"),at(ft,"]",","),F,wt):"{"==t?T(I("}"),gt,F,wt):"("==t?T(at(bt,")"),pt,wt):"<"==t?T(at(ft,">"),ft):"quasi"==t?j(mt,wt):void 0}function pt(t){if("=>"==t)return T(ft)}function gt(t){return t.match(/[\}\)\]]/)?T():","==t||";"==t?T(gt):j(vt,gt)}function vt(t,e){return"variable"==t||"keyword"==S.style?(S.marked="property",T(vt)):"?"==e||"number"==t||"string"==t?T(vt):":"==t?T(ft):"["==t?T(V("variable"),ut,V("]"),vt):"("==t?j(Nt,vt):t.match(/[;\}\)\],]/)?void 0:T()}function mt(t,e){return"quasi"!=t?j():"${"!=e.slice(e.length-2)?T(mt):T(ft,yt)}function yt(t){if("}"==t)return S.marked="string-2",S.state.tokenize=y,T(mt)}function bt(t,e){return"variable"==t&&S.stream.match(/^\s*[?:]/,!1)||"?"==e?T(bt):":"==t?T(ft):"spread"==t?T(bt):j(ft)}function wt(t,e){return"<"==e?T(I(">"),at(ft,">"),F,wt):"|"==e||"."==t||"&"==e?T(ft):"["==t?T(ft,V("]"),wt):"extends"==e||"implements"==e?(S.marked="keyword",T(ft)):"?"==e?T(ft,V(":"),ft):void 0}function Ot(t,e){if("<"==e)return T(I(">"),at(ft,">"),F,wt)}function xt(){return j(ft,Ct)}function Ct(t,e){if("="==e)return T(ft)}function kt(t,e){return"enum"==e?(S.marked="keyword",T(Jt)):j(St,lt,Pt,Et)}function St(t,e){return u&&_(e)?(S.marked="keyword",T(St)):"variable"==t?(E(e),T()):"spread"==t?T(St):"["==t?st(Tt,"]"):"{"==t?st(jt,"}"):void 0}function jt(t,e){return"variable"!=t||S.stream.match(/^\s*:/,!1)?("variable"==t&&(S.marked="property"),"spread"==t?T(St):"}"==t?j():"["==t?T(B,V(']'),V(':'),jt):T(V(":"),St,Pt)):(E(e),T(Pt))}function Tt(){return j(St,Pt)}function Pt(t,e){if("="==e)return T(U)}function Et(t){if(","==t)return T(kt)}function _t(t,e){if("keyword b"==t&&"else"==e)return T(I("form","else"),z,F)}function Mt(t,e){return"await"==e?T(Mt):"("==t?T(I(")"),Dt,F):void 0}function Dt(t){return"var"==t?T(kt,At):"variable"==t?T(At):j(At)}function At(t,e){return")"==t?T():";"==t?T(At):"in"==e||"of"==e?(S.marked="keyword",T(B,At)):j(B,At)}function Lt(t,e){return"*"==e?(S.marked="keyword",T(Lt)):"variable"==t?(E(e),T(Lt)):"("==t?T(L,I(")"),at(It,")"),F,dt,z,R):u&&"<"==e?T(I(">"),at(xt,">"),F,Lt):void 0}function Nt(t,e){return"*"==e?(S.marked="keyword",T(Nt)):"variable"==t?(E(e),T(Nt)):"("==t?T(L,I(")"),at(It,")"),F,dt,R):u&&"<"==e?T(I(">"),at(xt,">"),F,Nt):void 0}function Rt(t,e){return"keyword"==t||"variable"==t?(S.marked="type",T(Rt)):"<"==e?T(I(">"),at(xt,">"),F):void 0}function It(t,e){return"@"==e&&T(B,It),"spread"==t?T(It):u&&_(e)?(S.marked="keyword",T(It)):u&&"this"==t?T(lt,Pt):j(St,lt,Pt)}function Ft(t,e){return"variable"==t?Vt(t,e):zt(t,e)}function Vt(t,e){if("variable"==t)return E(e),T(zt)}function zt(t,e){return"<"==e?T(I(">"),at(xt,">"),F,zt):"extends"==e||"implements"==e||u&&","==t?("implements"==e&&(S.marked="keyword"),T(u?ft:B,zt)):"{"==t?T(I("}"),Ht,F):void 0}function Ht(t,e){return"async"==t||"variable"==t&&("static"==e||"get"==e||"set"==e||u&&_(e))&&S.stream.match(/^\s+[\w$\xa1-\uffff]/,!1)?(S.marked="keyword",T(Ht)):"variable"==t||"keyword"==S.style?(S.marked="property",T(Bt,Ht)):"number"==t||"string"==t?T(Bt,Ht):"["==t?T(B,lt,V("]"),Bt,Ht):"*"==e?(S.marked="keyword",T(Ht)):u&&"("==t?j(Nt,Ht):";"==t||","==t?T(Ht):"}"==t?T():"@"==e?T(B,Ht):void 0}function Bt(t,e){if("!"==e)return T(Bt);if("?"==e)return T(Bt);if(":"==t)return T(ft,Pt);if("="==e)return T(U);var n=S.state.lexical.prev;return j(n&&"interface"==n.info?Nt:Lt)}function Ut(t,e){return"*"==e?(S.marked="keyword",T(Yt,V(";"))):"default"==e?(S.marked="keyword",T(B,V(";"))):"{"==t?T(at($t,"}"),Yt,V(";")):j(z)}function $t(t,e){return"as"==e?(S.marked="keyword",T(V("variable"))):"variable"==t?j(U,$t):void 0}function Wt(t){return"string"==t?T():"("==t?j(B):"."==t?j(G):j(qt,Gt,Yt)}function qt(t,e){return"{"==t?st(qt,"}"):("variable"==t&&E(e),"*"==e&&(S.marked="keyword"),T(Kt))}function Gt(t){if(","==t)return T(qt,Gt)}function Kt(t,e){if("as"==e)return S.marked="keyword",T(qt)}function Yt(t,e){if("from"==e)return S.marked="keyword",T(B)}function Xt(t){return"]"==t?T():j(at(U,"]"))}function Jt(){return j(I("form"),St,V("{"),I("}"),at(Zt,"}"),F,F)}function Zt(){return j(St,Pt)}function Qt(t,e,n){return e.tokenize==v&&/^(?:operator|sof|keyword [bcd]|case|new|export|default|spread|[\[{}\(,;:]|=>)$/.test(e.lastType)||"quasi"==e.lastType&&/\{\s*$/.test(t.string.slice(0,t.pos-(n||0)))}return R.lex=!0,F.lex=!0,{startState:function(t){var e={tokenize:v,lastType:"sof",cc:[],lexical:new x((t||0)-o,0,"block",!1),localVars:n.localVars,context:n.localVars&&new M(null,null,!1),indented:t||0};return n.globalVars&&"object"==typeof n.globalVars&&(e.globalVars=n.globalVars),e},token:function(t,e){if(t.sol()&&(e.lexical.hasOwnProperty("align")||(e.lexical.align=!1),e.indented=t.indentation(),w(t,e)),e.tokenize!=m&&t.eatSpace())return null;var n=e.tokenize(t,e);return"comment"==r?n:(e.lastType="operator"!=r||"++"!=i&&"--"!=i?r:"incdec",k(e,n,r,i,t))},indent:function(e,r){if(e.tokenize==m||e.tokenize==y)return t.Pass;if(e.tokenize!=v)return 0;var i,s=r&&r.charAt(0),c=e.lexical;if(!/^\s*else\b/.test(r))for(var l=e.cc.length-1;l>=0;--l){var u=e.cc[l];if(u==F)c=c.prev;else if(u!=_t&&u!=R)break}for(;("stat"==c.type||"form"==c.type)&&("}"==s||(i=e.cc[e.cc.length-1])&&(i==G||i==K)&&!/^[,\.=+\-*:?[\(]/.test(r));)c=c.prev;a&&")"==c.type&&"stat"==c.prev.type&&(c=c.prev);var d=c.type,h=s==d;return"vardef"==d?c.indented+("operator"==e.lastType||","==e.lastType?c.info.length+1:0):"form"==d&&"{"==s?c.indented:"form"==d?c.indented+o:"stat"==d?c.indented+(function(t,e){return"operator"==t.lastType||","==t.lastType||f.test(e.charAt(0))||/[,.]/.test(e.charAt(0))}(e,r)?a||o:0):"switch"!=c.info||h||0==n.doubleIndentSwitch?c.align?c.column+(h?0:1):c.indented+(h?0:o):c.indented+(/^(?:case|default)\b/.test(r)?o:2*o)},electricInput:/^\s*(?:case .*?:|default:|\{|\})$/,blockCommentStart:c?null:"/*",blockCommentEnd:c?null:"*/",blockCommentContinue:c?null:" * ",lineComment:c?null:"//",fold:"brace",closeBrackets:"()[]{}''\"\"``",helperType:c?"json":"javascript",jsonldMode:s,jsonMode:c,expressionAllowed:Qt,skipExpression:function(e){k(e,"atom","atom","true",new t.StringStream("",2,null))}}})),t.registerHelper("wordChars","javascript",/[\w$]/),t.defineMIME("text/javascript","javascript"),t.defineMIME("text/ecmascript","javascript"),t.defineMIME("application/javascript","javascript"),t.defineMIME("application/x-javascript","javascript"),t.defineMIME("application/ecmascript","javascript"),t.defineMIME("application/json",{name:"javascript",json:!0}),t.defineMIME("application/x-json",{name:"javascript",json:!0}),t.defineMIME("application/manifest+json",{name:"javascript",json:!0}),t.defineMIME("application/ld+json",{name:"javascript",jsonld:!0}),t.defineMIME("text/typescript",{name:"javascript",typescript:!0}),t.defineMIME("application/typescript",{name:"javascript",typescript:!0})}(n(27))},function(t,e,n){ true&&function(t){t.extendMode("css",{commentStart:"/*",commentEnd:"*/",newlineAfterToken:function(t,e){return/^[;{}]$/.test(e)}}),t.extendMode("javascript",{commentStart:"/*",commentEnd:"*/",newlineAfterToken:function(t,e,n,r){return this.jsonMode?/^[\[,{]$/.test(e)||/^}/.test(n):(";"!=e||!r.lexical||")"!=r.lexical.type)&&/^[;{}]$/.test(e)&&!/^;/.test(n)}});var e=/^(a|abbr|acronym|area|base|bdo|big|br|button|caption|cite|code|col|colgroup|dd|del|dfn|em|frame|hr|iframe|img|input|ins|kbd|label|legend|link|map|object|optgroup|option|param|q|samp|script|select|small|span|strong|sub|sup|textarea|tt|var)$/;t.extendMode("xml",{commentStart:"\x3c!--",commentEnd:"--\x3e",newlineAfterToken:function(t,n,r,i){var o=!1;return"html"==this.configuration&&(o=!!i.context&&e.test(i.context.tagName)),!o&&("tag"==t&&/>$/.test(n)&&i.context||/^</.test(r))}}),t.defineExtension("commentRange",(function(e,n,r){var i=this,o=t.innerMode(i.getMode(),i.getTokenAt(n).state).mode;i.operation((function(){if(e)i.replaceRange(o.commentEnd,r),i.replaceRange(o.commentStart,n),n.line==r.line&&n.ch==r.ch&&i.setCursor(n.line,n.ch+o.commentStart.length);else{var t=i.getRange(n,r),a=t.indexOf(o.commentStart),s=t.lastIndexOf(o.commentEnd);a>-1&&s>-1&&s>a&&(t=t.substr(0,a)+t.substring(a+o.commentStart.length,s)+t.substr(s+o.commentEnd.length)),i.replaceRange(t,n,r)}}))})),t.defineExtension("autoIndentRange",(function(t,e){var n=this;this.operation((function(){for(var r=t.line;r<=e.line;r++)n.indentLine(r,"smart")}))})),t.defineExtension("autoFormatRange",(function(e,n){var r=this,i=r.getMode(),o=r.getRange(e,n).split("\n"),a=t.copyState(i,r.getTokenAt(e).state),s=r.getOption("tabSize"),c="",l=0,u=0===e.ch;function d(){c+="\n",u=!0,++l}for(var h=0;h<o.length;++h){for(var f=new t.StringStream(o[h],s);!f.eol();){var p=t.innerMode(i,a),g=i.token(f,a),v=f.current();f.start=f.pos,u&&!/\S/.test(v)||(c+=v,u=!1),!u&&p.mode.newlineAfterToken&&p.mode.newlineAfterToken(g,v,f.string.slice(f.pos)||o[h+1]||"",p.state)&&d()}!f.pos&&i.blankLine&&i.blankLine(a),!u&&h<o.length-1&&d()}r.operation((function(){r.replaceRange(c,e,n);for(var t=e.line+1,i=e.line+l;t<=i;++t)r.indentLine(t,"smart");r.setSelection(e,r.getCursor(!1))}))}))}(n(27))},function(t,e,n){var r=function(t){"use strict";var e,n=Object.prototype,r=n.hasOwnProperty,i="function"==typeof Symbol?Symbol:{},o=i.iterator||"@@iterator",a=i.asyncIterator||"@@asyncIterator",s=i.toStringTag||"@@toStringTag";function c(t,e,n){return Object.defineProperty(t,e,{value:n,enumerable:!0,configurable:!0,writable:!0}),t[e]}try{c({},"")}catch(t){c=function(t,e,n){return t[e]=n}}function l(t,e,n,r){var i=e&&e.prototype instanceof v?e:v,o=Object.create(i.prototype),a=new P(r||[]);return o._invoke=function(t,e,n){var r=d;return function(i,o){if(r===f)throw new Error("Generator is already running");if(r===p){if("throw"===i)throw o;return _()}for(n.method=i,n.arg=o;1;){var a=n.delegate;if(a){var s=S(a,n);if(s){if(s===g)continue;return s}}if("next"===n.method)n.sent=n._sent=n.arg;else if("throw"===n.method){if(r===d)throw r=p,n.arg;n.dispatchException(n.arg)}else"return"===n.method&&n.abrupt("return",n.arg);r=f;var c=u(t,e,n);if("normal"===c.type){if(r=n.done?p:h,c.arg===g)continue;return{value:c.arg,done:n.done}}"throw"===c.type&&(r=p,n.method="throw",n.arg=c.arg)}}}(t,n,a),o}function u(t,e,n){try{return{type:"normal",arg:t.call(e,n)}}catch(t){return{type:"throw",arg:t}}}t.wrap=l;var d="suspendedStart",h="suspendedYield",f="executing",p="completed",g={};function v(){}function m(){}function y(){}var b={};b[o]=function(){return this};var w=Object.getPrototypeOf,O=w&&w(w(E([])));O&&O!==n&&r.call(O,o)&&(b=O);var x=y.prototype=v.prototype=Object.create(b);function C(t){["next","throw","return"].forEach((function(e){c(t,e,(function(t){return this._invoke(e,t)}))}))}function k(t,e){var n;this._invoke=function(i,o){function a(){return new e((function(n,a){!function n(i,o,a,s){var c=u(t[i],t,o);if("throw"!==c.type){var l=c.arg,d=l.value;return d&&"object"==typeof d&&r.call(d,"__await")?e.resolve(d.__await).then((function(t){n("next",t,a,s)}),(function(t){n("throw",t,a,s)})):e.resolve(d).then((function(t){l.value=t,a(l)}),(function(t){return n("throw",t,a,s)}))}s(c.arg)}(i,o,n,a)}))}return n=n?n.then(a,a):a()}}function S(t,n){var r=t.iterator[n.method];if(r===e){if(n.delegate=null,"throw"===n.method){if(t.iterator["return"]&&(n.method="return",n.arg=e,S(t,n),"throw"===n.method))return g;n.method="throw",n.arg=new TypeError("The iterator does not provide a 'throw' method")}return g}var i=u(r,t.iterator,n.arg);if("throw"===i.type)return n.method="throw",n.arg=i.arg,n.delegate=null,g;var o=i.arg;return o?o.done?(n[t.resultName]=o.value,n.next=t.nextLoc,"return"!==n.method&&(n.method="next",n.arg=e),n.delegate=null,g):o:(n.method="throw",n.arg=new TypeError("iterator result is not an object"),n.delegate=null,g)}function j(t){var e={tryLoc:t[0]};1 in t&&(e.catchLoc=t[1]),2 in t&&(e.finallyLoc=t[2],e.afterLoc=t[3]),this.tryEntries.push(e)}function T(t){var e=t.completion||{};e.type="normal",delete e.arg,t.completion=e}function P(t){this.tryEntries=[{tryLoc:"root"}],t.forEach(j,this),this.reset(!0)}function E(t){if(t){var n=t[o];if(n)return n.call(t);if("function"==typeof t.next)return t;if(!isNaN(t.length)){var i=-1,a=function n(){for(;++i<t.length;)if(r.call(t,i))return n.value=t[i],n.done=!1,n;return n.value=e,n.done=!0,n};return a.next=a}}return{next:_}}function _(){return{value:e,done:!0}}return m.prototype=x.constructor=y,y.constructor=m,m.displayName=c(y,s,"GeneratorFunction"),t.isGeneratorFunction=function(t){var e="function"==typeof t&&t.constructor;return!!e&&(e===m||"GeneratorFunction"===(e.displayName||e.name))},t.mark=function(t){return Object.setPrototypeOf?Object.setPrototypeOf(t,y):(t.__proto__=y,c(t,s,"GeneratorFunction")),t.prototype=Object.create(x),t},t.awrap=function(t){return{__await:t}},C(k.prototype),k.prototype[a]=function(){return this},t.AsyncIterator=k,t.async=function(e,n,r,i,o){void 0===o&&(o=Promise);var a=new k(l(e,n,r,i),o);return t.isGeneratorFunction(n)?a:a.next().then((function(t){return t.done?t.value:a.next()}))},C(x),c(x,s,"Generator"),x[o]=function(){return this},x.toString=function(){return"[object Generator]"},t.keys=function(t){var e=[];for(var n in t)e.push(n);return e.reverse(),function n(){for(;e.length;){var r=e.pop();if(r in t)return n.value=r,n.done=!1,n}return n.done=!0,n}},t.values=E,P.prototype={constructor:P,reset:function(t){if(this.prev=0,this.next=0,this.sent=this._sent=e,this.done=!1,this.delegate=null,this.method="next",this.arg=e,this.tryEntries.forEach(T),!t)for(var n in this)"t"===n.charAt(0)&&r.call(this,n)&&!isNaN(+n.slice(1))&&(this[n]=e)},stop:function(){this.done=!0;var t=this.tryEntries[0].completion;if("throw"===t.type)throw t.arg;return this.rval},dispatchException:function(t){if(this.done)throw t;var n=this;function i(r,i){return s.type="throw",s.arg=t,n.next=r,i&&(n.method="next",n.arg=e),!!i}for(var o=this.tryEntries.length-1;o>=0;--o){var a=this.tryEntries[o],s=a.completion;if("root"===a.tryLoc)return i("end");if(a.tryLoc<=this.prev){var c=r.call(a,"catchLoc"),l=r.call(a,"finallyLoc");if(c&&l){if(this.prev<a.catchLoc)return i(a.catchLoc,!0);if(this.prev<a.finallyLoc)return i(a.finallyLoc)}else if(c){if(this.prev<a.catchLoc)return i(a.catchLoc,!0)}else{if(!l)throw new Error("try statement without catch or finally");if(this.prev<a.finallyLoc)return i(a.finallyLoc)}}}},abrupt:function(t,e){for(var n=this.tryEntries.length-1;n>=0;--n){var i=this.tryEntries[n];if(i.tryLoc<=this.prev&&r.call(i,"finallyLoc")&&this.prev<i.finallyLoc){var o=i;break}}o&&("break"===t||"continue"===t)&&o.tryLoc<=e&&e<=o.finallyLoc&&(o=null);var a=o?o.completion:{};return a.type=t,a.arg=e,o?(this.method="next",this.next=o.finallyLoc,g):this.complete(a)},complete:function(t,e){if("throw"===t.type)throw t.arg;return"break"===t.type||"continue"===t.type?this.next=t.arg:"return"===t.type?(this.rval=this.arg=t.arg,this.method="return",this.next="end"):"normal"===t.type&&e&&(this.next=e),g},finish:function(t){for(var e=this.tryEntries.length-1;e>=0;--e){var n=this.tryEntries[e];if(n.finallyLoc===t)return this.complete(n.completion,n.afterLoc),T(n),g}},catch:function(t){for(var e=this.tryEntries.length-1;e>=0;--e){var n=this.tryEntries[e];if(n.tryLoc===t){var r=n.completion;if("throw"===r.type){var i=r.arg;T(n)}return i}}throw new Error("illegal catch attempt")},delegateYield:function(t,n,r){return this.delegate={iterator:E(t),resultName:n,nextLoc:r},"next"===this.method&&(this.arg=e),g}},t}( true?t.exports:0);try{regeneratorRuntime=r}catch(t){Function("r","regeneratorRuntime = r")(r)}},function(t,e){t.exports=function(t){if(Array.isArray(t))return t},t.exports["default"]=t.exports,t.exports.__esModule=!0},function(t,e){t.exports=function(t,e){var n=t&&("undefined"!=typeof Symbol&&t[Symbol.iterator]||t["@@iterator"]);if(null!=n){var r,i,o=[],a=!0,s=!1;try{for(n=n.call(t);!(a=(r=n.next()).done)&&(o.push(r.value),!e||o.length!==e);a=!0);}catch(t){s=!0,i=t}finally{try{a||null==n["return"]||n["return"]()}finally{if(s)throw i}}return o}},t.exports["default"]=t.exports,t.exports.__esModule=!0},function(t,e){t.exports=function(){throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")},t.exports["default"]=t.exports,t.exports.__esModule=!0},function(t,e,n){"use strict";n.r(e);var r=n(2),i=n(10);e["default"]=r["View"].extend({initialize:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};this.items=[],this.opt=t;var e=t.config||{};this.level=t.level,this.config=e,this.preview=t.preview,this.ppfx=e.pStylePrefix||'',this.pfx=e.stylePrefix||'',this.parent=t.parent,this.parentView=t.parentView;var n=this.pfx,r=this.ppfx,o=this.parent,a=this.collection;this.listenTo(a,'add',this.addTo),this.listenTo(a,'reset resetNavigator',this.render),this.listenTo(a,'remove',this.removeChildren),this.className="".concat(n,"layers");var s=e.em;if(e.sortable&&!this.opt.sorter){var c=s.get('Utils');this.opt.sorter=new c.Sorter({container:e.sortContainer||this.el,containerSel:".".concat(this.className),itemSel:".".concat(n,"layer"),ignoreViewChildren:1,onEndMove:function(t,e,n){var r=e.getSourceModel();s.setSelected(r,{forceChange:1}),s.trigger("".concat(i["b"],":end"),n)},avoidSelectOnEnd:1,nested:1,ppfx:r,pfx:n})}this.sorter=this.opt.sorter||'',this.$el.data('collection',a),o&&this.$el.data('model',o)},removeChildren:function(t){var e=t.viewLayer;e&&(e.remove(),t.viewLayer=0)},addTo:function(t){var e=this.collection.indexOf(t);this.addToCollection(t,null,e)},addToCollection:function(t,e,n){var r=this.level,i=this.parentView,o=this.opt.ItemView,a=e||null,s=new o({ItemView:o,level:r,model:t,parentView:i,config:this.config,sorter:this.sorter,isCountable:this.isCountable,opened:this.opt.opened}),c=s.render().el;if(a)a.appendChild(c);else if(void 0!==n){var l='before';this.$el.children().length==n&&(n--,l='after'),n<0?this.$el.append(c):this.$el.children().eq(n)[l](c)}else this.$el.append(c);return this.items.push(s),c},remove:function(){r["View"].prototype.remove.apply(this,arguments),this.items.map((function(t){return t.remove()}))},isCountable:function(t,e){var n=t.get('type'),r=t.get('tagName');return!(('textnode'==n||'br'==r)&&e||!t.get('layerable'))},render:function(){var t=this,e=document.createDocumentFragment(),n=this.el;return n.innerHTML='',this.collection.each((function(n){return t.addToCollection(n,e)})),n.appendChild(e),n.className=this.className,this}})},function(t,e,n){var r={"./CanvasClear":52,"./CanvasClear.js":52,"./CanvasMove":53,"./CanvasMove.js":53,"./CommandAbstract":31,"./CommandAbstract.js":31,"./ComponentDelete":54,"./ComponentDelete.js":54,"./ComponentDrag":55,"./ComponentDrag.js":55,"./ComponentEnter":56,"./ComponentEnter.js":56,"./ComponentExit":57,"./ComponentExit.js":57,"./ComponentNext":58,"./ComponentNext.js":58,"./ComponentPrev":59,"./ComponentPrev.js":59,"./ComponentStyleClear":60,"./ComponentStyleClear.js":60,"./CopyComponent":61,"./CopyComponent.js":61,"./DeleteComponent":62,"./DeleteComponent.js":62,"./ExportTemplate":63,"./ExportTemplate.js":63,"./Fullscreen":64,"./Fullscreen.js":64,"./MoveComponent":65,"./MoveComponent.js":65,"./OpenAssets":66,"./OpenAssets.js":66,"./OpenBlocks":67,"./OpenBlocks.js":67,"./OpenLayers":68,"./OpenLayers.js":68,"./OpenStyleManager":69,"./OpenStyleManager.js":69,"./OpenTraitManager":70,"./OpenTraitManager.js":70,"./PasteComponent":71,"./PasteComponent.js":71,"./Preview":72,"./Preview.js":72,"./Resize":73,"./Resize.js":73,"./SelectComponent":23,"./SelectComponent.js":23,"./SelectPosition":36,"./SelectPosition.js":36,"./ShowOffset":74,"./ShowOffset.js":74,"./SwitchVisibility":75,"./SwitchVisibility.js":75};function i(t){var e=o(t);return n(e)}function o(t){if(!n.o(r,t)){var e=new Error("Cannot find module '"+t+"'");throw e.code='MODULE_NOT_FOUND',e}return r[t]}i.keys=function(){return Object.keys(r)},i.resolve=o,t.exports=i,i.id=98},function(t,e,n){"use strict";n.r(e);var r=n(3),i=n.n(r),o=n(14),a=n.n(o),s=(n(2),n(0)),c={stylePrefix:'comp-',components:[],draggableComponents:1,storeWrapper:0,processor:0,voidElements:['area','base','br','col','embed','hr','img','input','keygen','link','menuitem','meta','param','source','track','wbr']},l=n(10),u=n(30),d=n(12),h=n(42),f=n(1);function p(t,e){var n=Object.keys(t);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(t);e&&(r=r.filter((function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable}))),n.push.apply(n,r)}return n}function g(t){for(var e=1;e<arguments.length;e++){var n=null!=arguments[e]?arguments[e]:{};e%2?p(Object(n),!0).forEach((function(e){i()(t,e,n[e])})):Object.getOwnPropertyDescriptors?Object.defineProperties(t,Object.getOwnPropertyDescriptors(n)):p(Object(n)).forEach((function(e){Object.defineProperty(t,e,Object.getOwnPropertyDescriptor(n,e))}))}return t}var v=l["a"].extend({defaults:g(g({},l["a"].prototype.defaults),{},{type:'cell',tagName:'td',draggable:['tr']})},{isComponent:function(t){return['td','th'].indexOf(Object(f["toLowerCase"])(t.tagName))>=0}}),m=d["default"].extend({});function y(t,e){var n=Object.keys(t);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(t);e&&(r=r.filter((function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable}))),n.push.apply(n,r)}return n}function b(t){for(var e=1;e<arguments.length;e++){var n=null!=arguments[e]?arguments[e]:{};e%2?y(Object(n),!0).forEach((function(e){i()(t,e,n[e])})):Object.getOwnPropertyDescriptors?Object.defineProperties(t,Object.getOwnPropertyDescriptors(n)):y(Object(n)).forEach((function(e){Object.defineProperty(t,e,Object.getOwnPropertyDescriptor(n,e))}))}return t}var w='tr',O=l["a"].extend({defaults:b(b({},l["a"].prototype.defaults),{},{tagName:w,draggable:['thead','tbody','tfoot'],droppable:['th','td']})},{isComponent:function(t){return Object(f["toLowerCase"])(t.tagName)===w}}),x=d["default"].extend({});function C(t,e){var n=Object.keys(t);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(t);e&&(r=r.filter((function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable}))),n.push.apply(n,r)}return n}function k(t){for(var e=1;e<arguments.length;e++){var n=null!=arguments[e]?arguments[e]:{};e%2?C(Object(n),!0).forEach((function(e){i()(t,e,n[e])})):Object.getOwnPropertyDescriptors?Object.defineProperties(t,Object.getOwnPropertyDescriptors(n)):C(Object(n)).forEach((function(e){Object.defineProperty(t,e,Object.getOwnPropertyDescriptor(n,e))}))}return t}var S='table',j=l["a"].extend({defaults:k(k({},l["a"].prototype.defaults),{},{type:S,tagName:S,droppable:['tbody','thead','tfoot']}),initialize:function(t,e){l["a"].prototype.initialize.apply(this,arguments);var n=this.get('components');!n.length&&n.add({type:'tbody'})}},{isComponent:function(t){return Object(f["toLowerCase"])(t.tagName)===S}}),T=d["default"].extend({events:{}});function P(t,e){var n=Object.keys(t);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(t);e&&(r=r.filter((function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable}))),n.push.apply(n,r)}return n}function E(t){for(var e=1;e<arguments.length;e++){var n=null!=arguments[e]?arguments[e]:{};e%2?P(Object(n),!0).forEach((function(e){i()(t,e,n[e])})):Object.getOwnPropertyDescriptors?Object.defineProperties(t,Object.getOwnPropertyDescriptors(n)):P(Object(n)).forEach((function(e){Object.defineProperty(t,e,Object.getOwnPropertyDescriptor(n,e))}))}return t}var _='tbody',M=l["a"].extend({defaults:E(E({},l["a"].prototype.defaults),{},{type:_,tagName:_,draggable:['table'],droppable:['tr'],columns:1,rows:1}),initialize:function(t,e){l["a"].prototype.initialize.apply(this,arguments);var n=this.get('components'),r=this.get('columns'),i=this.get('rows');if(!n.length){for(var o=[];i--;){for(var a=[],s=r;s--;)a.push({type:'cell',classes:['cell']});o.push({type:'row',classes:['row'],components:a})}n.add(o)}}},{isComponent:function(t){return Object(f["toLowerCase"])(t.tagName)===_}});function D(t,e){var n=Object.keys(t);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(t);e&&(r=r.filter((function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable}))),n.push.apply(n,r)}return n}function A(t){for(var e=1;e<arguments.length;e++){var n=null!=arguments[e]?arguments[e]:{};e%2?D(Object(n),!0).forEach((function(e){i()(t,e,n[e])})):Object.getOwnPropertyDescriptors?Object.defineProperties(t,Object.getOwnPropertyDescriptors(n)):D(Object(n)).forEach((function(e){Object.defineProperty(t,e,Object.getOwnPropertyDescriptor(n,e))}))}return t}var L='thead',N=M.extend({defaults:A(A({},M.prototype.defaults),{},{type:L,tagName:L})},{isComponent:function(t){return Object(f["toLowerCase"])(t.tagName)===L}}),R=d["default"].extend({}),I=d["default"].extend({});function F(t,e){var n=Object.keys(t);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(t);e&&(r=r.filter((function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable}))),n.push.apply(n,r)}return n}function V(t){for(var e=1;e<arguments.length;e++){var n=null!=arguments[e]?arguments[e]:{};e%2?F(Object(n),!0).forEach((function(e){i()(t,e,n[e])})):Object.getOwnPropertyDescriptors?Object.defineProperties(t,Object.getOwnPropertyDescriptors(n)):F(Object(n)).forEach((function(e){Object.defineProperty(t,e,Object.getOwnPropertyDescriptor(n,e))}))}return t}var z='tfoot',H=M.extend({defaults:V(V({},M.prototype.defaults),{},{type:z,tagName:z})},{isComponent:function(t){return Object(f["toLowerCase"])(t.tagName)===z}}),B=d["default"].extend({});function U(t,e){var n=Object.keys(t);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(t);e&&(r=r.filter((function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable}))),n.push.apply(n,r)}return n}function $(t){for(var e=1;e<arguments.length;e++){var n=null!=arguments[e]?arguments[e]:{};e%2?U(Object(n),!0).forEach((function(e){i()(t,e,n[e])})):Object.getOwnPropertyDescriptors?Object.defineProperties(t,Object.getOwnPropertyDescriptors(n)):U(Object(n)).forEach((function(e){Object.defineProperty(t,e,Object.getOwnPropertyDescriptor(n,e))}))}return t}var W='xmlns="http://www.w3.org/2000/svg" width="100" viewBox="0 0 24 24" style="fill: rgba(0,0,0,0.15); transform: scale(0.75)"',q=l["a"].extend({defaults:$($({},l["a"].prototype.defaults),{},{type:'image',tagName:'img',void:!0,droppable:0,editable:1,highlightable:0,resizable:{ratioDefault:1},traits:['alt'],src:"<svg ".concat(W,">\n        <path d=\"M8.5 13.5l2.5 3 3.5-4.5 4.5 6H5m16 1V5a2 2 0 0 0-2-2H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2z\"></path>\n      </svg>"),fallback:"<svg ".concat(W,">\n        <path d=\"M2.28 3L1 4.27l2 2V19c0 1.1.9 2 2 2h12.73l2 2L21 21.72 2.28 3m2.55 0L21 19.17V5a2 2 0 0 0-2-2H4.83M8.5 13.5l2.5 3 1-1.25L14.73 18H5l3.5-4.5z\"></path>\n      </svg>"),file:''}),initialize:function(t,e){l["a"].prototype.initialize.apply(this,arguments);var n=this.get('attributes'),r=n.src;r&&this.set('src',r,{silent:1})},initToolbar:function(){for(var t=arguments.length,e=new Array(t),n=0;n<t;n++)e[n]=arguments[n];l["a"].prototype.initToolbar.apply(this,e);var r=this.em;if(r){var i=r.get('Commands'),o='image-editor';if(i.has(o)){for(var a=!1,s=this.get('toolbar'),c=0;c<s.length;c++)if('image-editor'===s[c].command){a=!0;break}a||(s.push({attributes:{class:'fa fa-pencil'},command:o}),this.set('toolbar',s))}}},getAttrToHTML:function(){for(var t=arguments.length,e=new Array(t),n=0;n<t;n++)e[n]=arguments[n];var r=l["a"].prototype.getAttrToHTML.apply(this,e),i=this.getSrcResult();return i&&(r.src=i),r},getSrcResult:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},e=this.get(t.fallback?'fallback':'src')||'',n=e;return e&&'<svg'===e.substr(0,4)&&(n="data:image/svg+xml;base64,".concat(window.btoa(e))),n},isDefaultSrc:function(){return this.get('src')===Object(s["result"])(this,'defaults').src},toJSON:function(){for(var t=arguments.length,e=new Array(t),n=0;n<t;n++)e[n]=arguments[n];var r=l["a"].prototype.toJSON.apply(this,e);return r.attributes&&r.src===r.attributes.src&&delete r.src,r},parseUri:function(t){var e=document.createElement('a');e.href=t;for(var n={},r=e.search.substring(1).split('&'),i=0;i<r.length;i++){var o=r[i].split('='),a=decodeURIComponent(o[0]);a&&(n[a]=decodeURIComponent(o[1]))}return{hostname:e.hostname,pathname:e.pathname,protocol:e.protocol,search:e.search,hash:e.hash,port:e.port,query:n}}},{isComponent:function(t){return'img'===Object(f["toLowerCase"])(t.tagName)}});function G(t,e){var n=Object.keys(t);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(t);e&&(r=r.filter((function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable}))),n.push.apply(n,r)}return n}function K(t){for(var e=1;e<arguments.length;e++){var n=null!=arguments[e]?arguments[e]:{};e%2?G(Object(n),!0).forEach((function(e){i()(t,e,n[e])})):Object.getOwnPropertyDescriptors?Object.defineProperties(t,Object.getOwnPropertyDescriptors(n)):G(Object(n)).forEach((function(e){Object.defineProperty(t,e,Object.getOwnPropertyDescriptor(n,e))}))}return t}var Y=q.extend({defaults:K(K({},q.prototype.defaults),{},{type:'map',src:'',void:0,mapUrl:'https://maps.google.com/maps',tagName:'iframe',mapType:'q',address:'',zoom:'1',attributes:{frameborder:0},toolbar:l["a"].prototype.defaults.toolbar,traits:[{label:'Address',name:'address',placeholder:'eg. London, UK',changeProp:1},{type:'select',label:'Map type',name:'mapType',changeProp:1,options:[{value:'q',name:'Roadmap'},{value:'w',name:'Satellite'}]},{label:'Zoom',name:'zoom',type:'range',min:'1',max:'20',changeProp:1}]}),initialize:function(t,e){this.get('src')?this.parseFromSrc():this.updateSrc(),q.prototype.initialize.apply(this,arguments),this.listenTo(this,'change:address change:zoom change:mapType',this.updateSrc)},updateSrc:function(){this.set('src',this.getMapUrl())},getMapUrl:function(){var t=this.get('address'),e=this.get('zoom'),n=this.get('mapType');t=t?'&q='+t:'',e=e?'&z='+e:'',n=n?'&t='+n:'';var r=this.get('mapUrl')+'?'+t+e+n;return r+='&output=embed'},parseFromSrc:function(){var t=this.parseUri(this.get('src')).query;t.q&&this.set('address',t.q),t.z&&this.set('zoom',t.z),t.t&&this.set('mapType',t.t)}},{isComponent:function(t){var e='';return'iframe'==Object(f["toLowerCase"])(t.tagName)&&/maps\.google\.com/.test(t.src)&&(e={type:'map',src:t.src}),e}}),X=d["default"].extend({tagName:'img',events:{dblclick:'onActive',click:'initResize',error:'onError',load:'onLoad',dragstart:'noDrag'},initialize:function(t){d["default"].prototype.initialize.apply(this,arguments),this.listenTo(this.model,'change:src',this.updateSrc),this.classEmpty="".concat(this.ppfx,"plh-image"),this.fetchFile()},fetchFile:function(){if(!this.modelOpt.temporary){var t=this.model,e=t.get('file');if(e)this.em.get('AssetManager').FileUploader().uploadFile({dataTransfer:{files:[e]}},(function(e){var n=e&&e.data&&e.data[0],r=n&&(Object(s["isString"])(n)?n:n.src);r&&t.set({src:r})})),t.set('file','')}},updateSrc:function(){var t=this.model,e=this.classEmpty,n=this.$el,r=t.getSrcResult(),i=r&&!t.isDefaultSrc();t.addAttributes({src:r}),n[i?'removeClass':'addClass'](e)},onActive:function(t){t&&t.stopPropagation();var e=this.em,n=this.model,r=e&&e.get('AssetManager');r&&n.get('editable')&&r.open({select:function(t,e){n.set({src:t.getSrc()}),e&&r.close()},target:n,types:['image'],accept:'image/*'})},onError:function(){var t=this.model.getSrcResult({fallback:1});t&&(this.el.src=t)},onLoad:function(){this.em.trigger('change:canvasOffset')},noDrag:function(t){return t.preventDefault(),!1},render:function(){if(this.renderAttributes(),this.modelOpt.temporary)return this;this.updateSrc();var t=this.$el,e=this.model,n=t.attr('class')||'';return!e.get('src')&&t.attr('class',"".concat(n," ").concat(this.classEmpty).trim()),this.postRender(),this}}),J=X.extend({tagName:'div',events:{},initialize:function(t){X.prototype.initialize.apply(this,arguments),this.classEmpty=this.ppfx+'plh-map'},updateSrc:function(){this.getIframe().src=this.model.get('src')},getIframe:function(){if(!this.iframe){var t=document.createElement('iframe');t.src=this.model.get('src'),t.frameBorder=0,t.style.height='100%',t.style.width='100%',t.className=this.ppfx+'no-pointer',this.iframe=t}return this.iframe},render:function(){for(var t=arguments.length,e=new Array(t),n=0;n<t;n++)e[n]=arguments[n];return X.prototype.render.apply(this,e),this.updateClasses(),this.el.appendChild(this.getIframe()),this}});function Z(t,e){var n=Object.keys(t);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(t);e&&(r=r.filter((function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable}))),n.push.apply(n,r)}return n}function Q(t){for(var e=1;e<arguments.length;e++){var n=null!=arguments[e]?arguments[e]:{};e%2?Z(Object(n),!0).forEach((function(e){i()(t,e,n[e])})):Object.getOwnPropertyDescriptors?Object.defineProperties(t,Object.getOwnPropertyDescriptors(n)):Z(Object(n)).forEach((function(e){Object.defineProperty(t,e,Object.getOwnPropertyDescriptor(n,e))}))}return t}var tt=l["a"].extend({defaults:Q(Q({},l["a"].prototype.defaults),{},{type:'text',droppable:!1,editable:!0}),toHTML:function(){return l["a"].prototype.toHTML.apply(this,arguments)}});function et(t,e){var n=Object.keys(t);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(t);e&&(r=r.filter((function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable}))),n.push.apply(n,r)}return n}function nt(t){for(var e=1;e<arguments.length;e++){var n=null!=arguments[e]?arguments[e]:{};e%2?et(Object(n),!0).forEach((function(e){i()(t,e,n[e])})):Object.getOwnPropertyDescriptors?Object.defineProperties(t,Object.getOwnPropertyDescriptors(n)):et(Object(n)).forEach((function(e){Object.defineProperty(t,e,Object.getOwnPropertyDescriptor(n,e))}))}return t}var rt=tt.extend({defaults:nt(nt({},tt.prototype.defaults),{},{type:'link',tagName:'a',traits:['title','href','target']}),getAttrToHTML:function(){for(var t=arguments.length,e=new Array(t),n=0;n<t;n++)e[n]=arguments[n];var r=tt.prototype.getAttrToHTML.apply(this,e);return delete r.onmousedown,r}},{isComponent:function(t){var e;if('a'===Object(f["toLowerCase"])(t.tagName)){e={type:'link',editable:0};var n=t.childNodes,r=n.length;r||delete e.editable;for(var i=0;i<r;i++){var o=n[i];if(3==o.nodeType&&''!=o.textContent.trim()){delete e.editable;break}}}return e}}),it=n(34),ot=n.n(it),at=n(26),st=n.n(at);function ct(t,e){var n=Object.keys(t);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(t);e&&(r=r.filter((function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable}))),n.push.apply(n,r)}return n}function lt(t){for(var e=1;e<arguments.length;e++){var n=null!=arguments[e]?arguments[e]:{};e%2?ct(Object(n),!0).forEach((function(e){i()(t,e,n[e])})):Object.getOwnPropertyDescriptors?Object.defineProperties(t,Object.getOwnPropertyDescriptors(n)):ct(Object(n)).forEach((function(e){Object.defineProperty(t,e,Object.getOwnPropertyDescriptor(n,e))}))}return t}var ut=d["default"].prototype,dt=d["default"].extend({events:{dblclick:'onActive',input:'onInput'},initialize:function(t){ut.initialize.apply(this,arguments),this.disableEditing=this.disableEditing.bind(this);var e=this.model,n=this.em;this.listenTo(e,'focus',this.onActive),this.listenTo(e,'change:content',this.updateContentText),this.listenTo(e,'sync:content',this.syncContent),this.rte=n&&n.get('RichTextEditor')},updateContentText:function(t,e){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};!n.fromDisable&&this.disableEditing()},onActive:function(t){var e=this;return ot()(st.a.mark((function n(){var r,i;return st.a.wrap((function(n){for(;1;)switch(n.prev=n.next){case 0:if(r=e.rte,i=e.em,!(e.rteEnabled||!e.model.get('editable')||i&&i.isEditing())){n.next=3;break}return n.abrupt("return");case 3:if(t&&t.stopPropagation&&t.stopPropagation(),!r){n.next=14;break}return n.prev=5,n.next=8,r.enable(e,e.activeRte);case 8:e.activeRte=n.sent,n.next=14;break;case 11:n.prev=11,n.t0=n["catch"](5),i.logError(n.t0);case 14:e.toggleEvents(1);case 15:case"end":return n.stop()}}),n,null,[[5,11]])})))()},onDisable:function(){this.disableEditing()},disableEditing:function(){var t=this;return ot()(st.a.mark((function e(){var n,r,i,o,a;return st.a.wrap((function(e){for(;1;)switch(e.prev=e.next){case 0:if(n=t.model,r=t.rte,i=t.activeRte,o=t.em,a=n&&n.get('editable'),!r){e.next=12;break}return e.prev=3,e.next=6,r.disable(t,i);case 6:e.next=11;break;case 8:e.prev=8,e.t0=e["catch"](3),o.logError(e.t0);case 11:a&&t.syncContent();case 12:t.toggleEvents();case 13:case"end":return e.stop()}}),e,null,[[3,8]])})))()},getContent:function(){var t=this.activeRte;return t&&'function'==typeof t.getContent?t.getContent():this.getChildrenContainer().innerHTML},syncContent:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},e=this.model,n=this.rte,r=this.rteEnabled;if(r||t.force){var i=this.getContent(),o=e.components(),a=lt({fromDisable:1},t);if(e.set('content','',a),n.customRte)o.length&&o.reset(null,t),e.set('content',i,a);else{var s=function e(n){var r=!!n.get('textable'),i=!['text','default',''].some((function(t){return n.is(t)}))||r;n.set(lt({_innertext:!i,editable:i&&n.get('editable'),selectable:i,hoverable:i,removable:r,draggable:r,highlightable:0,copyable:r},!r&&{toolbar:''}),t),n.get('components').each((function(t){return e(t)}))};o.reset(i,t),o.each((function(t){return s(t)})),o.trigger('resetNavigator')}}},onInput:function(){var t=this.em,e='component',n=["".concat(e,":update"),"".concat(e,":input")].join(' ');t&&t.trigger(n,this.model)},disablePropagation:function(t){t.stopPropagation()},toggleEvents:function(t){var e=this.em,n=this.model,r=this.$el,i={on:f["on"],off:f["off"]},o=t?'on':'off';e.setEditing(t?this:0),this.rteEnabled=!!t;var a=[this.el.ownerDocument,document];if(i.off(a,'mousedown',this.disableEditing),i[o](a,'mousedown',this.disableEditing),e[o]('toolbar:run:before',this.disableEditing),n&&(n[o]('removed',this.disableEditing),n.trigger("rte:".concat(t?'enable':'disable'))),r&&r.off('mousedown',this.disablePropagation),r&&r[o]('mousedown',this.disablePropagation),this.config.draggableComponents)for(var s=this.el;s;)s.draggable=!t,(s=s.parentNode)&&'BODY'==s.tagName&&(s=0)}}),ht=dt.extend({render:function(){for(var t=arguments.length,e=new Array(t),n=0;n<t;n++)e[n]=arguments[n];return dt.prototype.render.apply(this,e),this.el.addEventListener('click',this.prevDef,!0),this}});function ft(t,e){var n=Object.keys(t);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(t);e&&(r=r.filter((function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable}))),n.push.apply(n,r)}return n}function pt(t){for(var e=1;e<arguments.length;e++){var n=null!=arguments[e]?arguments[e]:{};e%2?ft(Object(n),!0).forEach((function(e){i()(t,e,n[e])})):Object.getOwnPropertyDescriptors?Object.defineProperties(t,Object.getOwnPropertyDescriptors(n)):ft(Object(n)).forEach((function(e){Object.defineProperty(t,e,Object.getOwnPropertyDescriptor(n,e))}))}return t}var gt='label',vt=tt.extend({defaults:pt(pt({},tt.prototype.defaults),{},{type:gt,tagName:gt,traits:['id','title','for']})},{isComponent:function(t){return Object(f["toLowerCase"])(t.tagName)===gt}}),mt=ht.extend({tagName:'span'});function yt(t,e){var n=Object.keys(t);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(t);e&&(r=r.filter((function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable}))),n.push.apply(n,r)}return n}function bt(t){for(var e=1;e<arguments.length;e++){var n=null!=arguments[e]?arguments[e]:{};e%2?yt(Object(n),!0).forEach((function(e){i()(t,e,n[e])})):Object.getOwnPropertyDescriptors?Object.defineProperties(t,Object.getOwnPropertyDescriptors(n)):yt(Object(n)).forEach((function(e){Object.defineProperty(t,e,Object.getOwnPropertyDescriptor(n,e))}))}return t}var wt='video',Ot='yt',xt='vi',Ct='ytnc',kt=q.extend({defaults:bt(bt({},q.prototype.defaults),{},{type:wt,tagName:wt,videoId:'',void:0,provider:'so',ytUrl:'https://www.youtube.com/embed/',ytncUrl:'https://www.youtube-nocookie.com/embed/',viUrl:'https://player.vimeo.com/video/',loop:0,poster:'',muted:0,autoplay:0,controls:1,color:'',list:'',rel:1,modestbranding:0,sources:[],attributes:{allowfullscreen:'allowfullscreen'}}),initialize:function(t,e){this.em=e.em,this.get('src')&&this.parseFromSrc(),this.updateTraits(),this.listenTo(this,'change:provider',this.updateTraits),this.listenTo(this,'change:videoId change:provider',this.updateSrc),q.prototype.initialize.apply(this,arguments)},updateTraits:function(){var t,e='iframe';switch(this.get('provider')){case Ot:case Ct:t=this.getYoutubeTraits();break;case xt:t=this.getVimeoTraits();break;default:e='video',t=this.getSourceTraits()}this.set({tagName:e},{silent:1}),this.set({traits:t}),this.em.trigger('component:toggled')},parseFromSrc:function(){var t=this.get('provider'),e=this.parseUri(this.get('src')),n=e.query;switch(t){case Ot:case Ct:case xt:var r=e.pathname.split('/').pop();this.set('videoId',r),n.list&&this.set('list',n.list),n.autoplay&&this.set('autoplay',1),n.loop&&this.set('loop',1),0===parseInt(n.controls)&&this.set('controls',0),n.color&&this.set('color',n.color),'0'===n.rel&&this.set('rel',0),'1'===n.modestbranding&&this.set('modestbranding',1)}},updateSrc:function(){var t='';switch(this.get('provider')){case Ot:t=this.getYoutubeSrc();break;case Ct:t=this.getYoutubeNoCookieSrc();break;case xt:t=this.getVimeoSrc()}this.set({src:t})},getAttrToHTML:function(){for(var t=arguments.length,e=new Array(t),n=0;n<t;n++)e[n]=arguments[n];var r=q.prototype.getAttrToHTML.apply(this,e),i=this.get('provider');switch(i){case Ot:case Ct:case xt:break;default:this.get('loop')&&(r.loop='loop'),this.get('autoplay')&&(r.autoplay='autoplay'),this.get('controls')&&(r.controls='controls')}return r},getProviderTrait:function(){return{type:'select',label:'Provider',name:'provider',changeProp:1,options:[{value:'so',name:'HTML5 Source'},{value:Ot,name:'Youtube'},{value:Ct,name:'Youtube (no cookie)'},{value:xt,name:'Vimeo'}]}},getSourceTraits:function(){return[this.getProviderTrait(),{label:'Source',name:'src',placeholder:'eg. ./media/video.mp4',changeProp:1},{label:'Poster',name:'poster',placeholder:'eg. ./media/image.jpg'},this.getAutoplayTrait(),this.getLoopTrait(),this.getControlsTrait()]},getYoutubeTraits:function(){return[this.getProviderTrait(),{label:'Video ID',name:'videoId',placeholder:'eg. jNQXAC9IVRw',changeProp:1},this.getAutoplayTrait(),this.getLoopTrait(),this.getControlsTrait(),{type:'checkbox',label:'Related',name:'rel',changeProp:1},{type:'checkbox',label:'Modest',name:'modestbranding',changeProp:1}]},getVimeoTraits:function(){return[this.getProviderTrait(),{label:'Video ID',name:'videoId',placeholder:'eg. 123456789',changeProp:1},{label:'Color',name:'color',placeholder:'eg. FF0000',changeProp:1},this.getAutoplayTrait(),this.getLoopTrait()]},getAutoplayTrait:function(){return{type:'checkbox',label:'Autoplay',name:'autoplay',changeProp:1}},getLoopTrait:function(){return{type:'checkbox',label:'Loop',name:'loop',changeProp:1}},getControlsTrait:function(){return{type:'checkbox',label:'Controls',name:'controls',changeProp:1}},getYoutubeSrc:function(){var t=this.get('videoId'),e=this.get('ytUrl'),n=this.get('list');return e+=t+(t.indexOf('?')<0?'?':''),e+=n?"&list=".concat(n):'',e+=this.get('autoplay')?'&autoplay=1':'',e+=this.get('controls')?'':'&controls=0&showinfo=0',e+=this.get('loop')?"&loop=1&playlist=".concat(t):'',e+=this.get('rel')?'':'&rel=0',e+=this.get('modestbranding')?'&modestbranding=1':''},getYoutubeNoCookieSrc:function(){var t=this.getYoutubeSrc();return t=t.replace(this.get('ytUrl'),this.get('ytncUrl'))},getVimeoSrc:function(){var t=this.get('viUrl');return t+=this.get('videoId')+'?',t+=this.get('autoplay')?'&autoplay=1':'',t+=this.get('loop')?'&loop=1':'',t+=this.get('controls')?'':'&title=0&portrait=0&badge=0',t+=this.get('color')?'&color='+this.get('color'):''}},{isComponent:function(t){var e='',n=t.tagName,r=t.src,i=/youtube\.com\/embed/.test(r),o=/youtube-nocookie\.com\/embed/.test(r),a=/player\.vimeo\.com\/video/.test(r),s=i||o||a;return(Object(f["toLowerCase"])(n)==wt||'iframe'==Object(f["toLowerCase"])(n)&&s)&&(e={type:'video'},r&&(e.src=r),s&&(i?e.provider=Ot:o?e.provider=Ct:a&&(e.provider=xt))),e}}),St=X.extend({tagName:'div',events:{},initialize:function(t){d["default"].prototype.initialize.apply(this,arguments);var e=this.model,n=['loop','autoplay','controls','color','rel','modestbranding','poster'],r=n.map((function(t){return"change:".concat(t)})).join(' ');this.listenTo(e,'change:provider',this.updateProvider),this.listenTo(e,'change:src',this.updateSrc),this.listenTo(e,r,this.updateVideo)},updateProvider:function(){var t=this.model.get('provider');this.el.innerHTML='',this.el.appendChild(this.renderByProvider(t))},updateSrc:function(){var t=this.model,e=this.videoEl;if(e){var n=t.get('provider'),r=t.get('src');switch(n){case'yt':r=t.getYoutubeSrc();break;case'ytnc':r=t.getYoutubeNoCookieSrc();break;case'vi':r=t.getVimeoSrc()}e.src=r}},updateVideo:function(){var t=this.model.get('provider'),e=this.videoEl,n=this.model;switch(t){case'yt':case'ytnc':case'vi':this.model.trigger('change:videoId');break;default:e.loop=n.get('loop'),e.autoplay=n.get('autoplay'),e.controls=n.get('controls'),e.poster=n.get('poster')}},renderByProvider:function(t){var e;switch(t){case'yt':e=this.renderYoutube();break;case'ytnc':e=this.renderYoutubeNoCookie();break;case'vi':e=this.renderVimeo();break;default:e=this.renderSource()}return this.videoEl=e,e},renderSource:function(){var t=document.createElement('video');return t.src=this.model.get('src'),this.initVideoEl(t),t},renderYoutube:function(){var t=document.createElement('iframe');return t.src=this.model.getYoutubeSrc(),t.frameBorder=0,t.setAttribute('allowfullscreen',!0),this.initVideoEl(t),t},renderYoutubeNoCookie:function(){var t=document.createElement('iframe');return t.src=this.model.getYoutubeNoCookieSrc(),t.frameBorder=0,t.setAttribute('allowfullscreen',!0),this.initVideoEl(t),t},renderVimeo:function(){var t=document.createElement('iframe');return t.src=this.model.getVimeoSrc(),t.frameBorder=0,t.setAttribute('allowfullscreen',!0),this.initVideoEl(t),t},initVideoEl:function(t){t.className=this.ppfx+'no-pointer',t.style.height='100%',t.style.width='100%'},render:function(){for(var t=arguments.length,e=new Array(t),n=0;n<t;n++)e[n]=arguments[n];X.prototype.render.apply(this,e),this.updateClasses();var r=this.model.get('provider');return this.el.appendChild(this.renderByProvider(r)),this.updateVideo(),this}});function jt(t,e){var n=Object.keys(t);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(t);e&&(r=r.filter((function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable}))),n.push.apply(n,r)}return n}function Tt(t){for(var e=1;e<arguments.length;e++){var n=null!=arguments[e]?arguments[e]:{};e%2?jt(Object(n),!0).forEach((function(e){i()(t,e,n[e])})):Object.getOwnPropertyDescriptors?Object.defineProperties(t,Object.getOwnPropertyDescriptors(n)):jt(Object(n)).forEach((function(e){Object.defineProperty(t,e,Object.getOwnPropertyDescriptor(n,e))}))}return t}var Pt='script',Et=l["a"].extend({defaults:Tt(Tt({},l["a"].prototype.defaults),{},{type:Pt,tagName:Pt,droppable:!1,draggable:!1,layerable:!1})},{isComponent:function(t){if(Object(f["toLowerCase"])(t.tagName)==Pt){var e={type:Pt};return t.src&&(e.src=t.src,e.onload=t.onload),e}}}),_t=X.extend({tagName:'script',events:{},render:function(){var t=this.model,e=this.em,n=t.get('src'),r=e&&e.get('scriptCount'),i=r||0,o='';if(n){var a=t.get('onload'),s="script".concat(i),c="script".concat(i+1),l="".concat(s,"Start"),u="".concat(c,"Start");o="\n        var ".concat(s," = document.createElement('script');\n        ").concat(s,".onload = function() {\n          ").concat(a?"".concat(a,"();\n"):'',"\n          typeof ").concat(u," == 'function' && ").concat(u,"();\n        };\n        ").concat(s,".src = '").concat(n,"';\n        function ").concat(l,"() { document.body.appendChild(").concat(s,"); };\n        ").concat(i?'':"".concat(l,"();"),"\n      "),e&&e.set('scriptCount',i+1)}else o=t.__innerHTML();return this.el.innerHTML=o,this.postRender(),this}});function Mt(t,e){var n=Object.keys(t);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(t);e&&(r=r.filter((function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable}))),n.push.apply(n,r)}return n}function Dt(t){for(var e=1;e<arguments.length;e++){var n=null!=arguments[e]?arguments[e]:{};e%2?Mt(Object(n),!0).forEach((function(e){i()(t,e,n[e])})):Object.getOwnPropertyDescriptors?Object.defineProperties(t,Object.getOwnPropertyDescriptors(n)):Mt(Object(n)).forEach((function(e){Object.defineProperty(t,e,Object.getOwnPropertyDescriptor(n,e))}))}return t}var At='svg',Lt=l["a"].extend({defaults:Dt(Dt({},l["a"].prototype.defaults),{},{type:At,tagName:At,highlightable:0,resizable:{ratioDefault:1}}),getName:function(){var t=this.get('tagName'),e=this.get('custom-name');return t=t.charAt(0).toUpperCase()+t.slice(1),e||t}},{isComponent:function(t){return Object(f["toLowerCase"])(t.tagName)===At}});function Nt(t,e){var n=Object.keys(t);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(t);e&&(r=r.filter((function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable}))),n.push.apply(n,r)}return n}function Rt(t){for(var e=1;e<arguments.length;e++){var n=null!=arguments[e]?arguments[e]:{};e%2?Nt(Object(n),!0).forEach((function(e){i()(t,e,n[e])})):Object.getOwnPropertyDescriptors?Object.defineProperties(t,Object.getOwnPropertyDescriptors(n)):Nt(Object(n)).forEach((function(e){Object.defineProperty(t,e,Object.getOwnPropertyDescriptor(n,e))}))}return t}var It=Lt.extend({defaults:Rt(Rt({},Lt.prototype.defaults),{},{selectable:!1,hoverable:!1,layerable:!1})},{isComponent:function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};return!!e.inSvg}}),Ft=d["default"].extend({_createElement:function(t){return document.createElementNS('http://www.w3.org/2000/svg',t)}});function Vt(t,e){var n=Object.keys(t);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(t);e&&(r=r.filter((function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable}))),n.push.apply(n,r)}return n}function zt(t){for(var e=1;e<arguments.length;e++){var n=null!=arguments[e]?arguments[e]:{};e%2?Vt(Object(n),!0).forEach((function(e){i()(t,e,n[e])})):Object.getOwnPropertyDescriptors?Object.defineProperties(t,Object.getOwnPropertyDescriptors(n)):Vt(Object(n)).forEach((function(e){Object.defineProperty(t,e,Object.getOwnPropertyDescriptor(n,e))}))}return t}var Ht=l["a"].extend({defaults:zt(zt({},l["a"].prototype.defaults),{},{tagName:'',droppable:!1,layerable:!1,selectable:!1,editable:!0}),toHTML:function(){var t=this.parent(),e=this.get('content');return t&&t.is('script')?e:Object(f["escape"])(e)}},{isComponent:function(t){var e='';return 3===t.nodeType&&(e={type:'textnode',content:t.textContent}),e}});function Bt(t,e){var n=Object.keys(t);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(t);e&&(r=r.filter((function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable}))),n.push.apply(n,r)}return n}var Ut=Ht.extend({defaults:function(t){for(var e=1;e<arguments.length;e++){var n=null!=arguments[e]?arguments[e]:{};e%2?Bt(Object(n),!0).forEach((function(e){i()(t,e,n[e])})):Object.getOwnPropertyDescriptors?Object.defineProperties(t,Object.getOwnPropertyDescriptors(n)):Bt(Object(n)).forEach((function(e){Object.defineProperty(t,e,Object.getOwnPropertyDescriptor(n,e))}))}return t}({},Ht.prototype.defaults),toHTML:function(){return"\x3c!--".concat(this.get('content'),"--\x3e")}},{isComponent:function(t){if(8==t.nodeType)return{tagName:'NULL',type:'comment',content:t.textContent}}}),$t=d["default"].extend({initialize:function(){d["default"].prototype.initialize.apply(this,arguments)},_setAttributes:function(){},renderAttributes:function(){},updateStatus:function(){},updateClasses:function(){},setAttribute:function(){},updateAttributes:function(){},initClasses:function(){},initComponents:function(){},delegateEvents:function(){},_createElement:function(){return document.createTextNode('')},render:function(){var t=this.model,e=this.el;return t.opt.temporary||(e.textContent=t.get('content')),this}}),Wt=$t.extend({_createElement:function(){return document.createComment(this.model.get('content'))}});function qt(t,e){var n=Object.keys(t);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(t);e&&(r=r.filter((function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable}))),n.push.apply(n,r)}return n}function Gt(t){for(var e=1;e<arguments.length;e++){var n=null!=arguments[e]?arguments[e]:{};e%2?qt(Object(n),!0).forEach((function(e){i()(t,e,n[e])})):Object.getOwnPropertyDescriptors?Object.defineProperties(t,Object.getOwnPropertyDescriptors(n)):qt(Object(n)).forEach((function(e){Object.defineProperty(t,e,Object.getOwnPropertyDescriptor(n,e))}))}return t}var Kt=l["a"].extend({defaults:Gt(Gt({},l["a"].prototype.defaults),{},{__wrapper:1,removable:!1,copyable:!1,draggable:!1,components:[],traits:[],stylable:['background','background-color','background-image','background-repeat','background-attachment','background-position','background-size']}),__postAdd:function(){var t=this.em&&this.em.get('UndoManager');return t&&!this.__hasUm&&t.add(this),l["a"].prototype.__postAdd.call(this,arguments)},__postRemove:function(){var t=this.em&&this.em.get('UndoManager');return t&&t.remove(this),l["a"].prototype.__postRemove.call(this,arguments)}},{isComponent:function(){return!1}});function Yt(t,e){var n=Object.keys(t);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(t);e&&(r=r.filter((function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable}))),n.push.apply(n,r)}return n}function Xt(t){for(var e=1;e<arguments.length;e++){var n=null!=arguments[e]?arguments[e]:{};e%2?Yt(Object(n),!0).forEach((function(e){i()(t,e,n[e])})):Object.getOwnPropertyDescriptors?Object.defineProperties(t,Object.getOwnPropertyDescriptors(n)):Yt(Object(n)).forEach((function(e){Object.defineProperty(t,e,Object.getOwnPropertyDescriptor(n,e))}))}return t}var Jt='iframe',Zt=l["a"].extend({defaults:function(){return Xt(Xt({},l["a"].prototype.defaults),{},{type:Jt,tagName:Jt,droppable:!1,resizable:!0,traits:['id','title','src'],attributes:{frameborder:'0'}})}},{isComponent:function(t){return Object(f["toLowerCase"])(t.tagName)===Jt}}),Qt=n(13),te=d["default"].extend({tagName:'div',initialize:function(){for(var t=arguments.length,e=new Array(t),n=0;n<t;n++)e[n]=arguments[n];d["default"].prototype.initialize.apply(this,e),this.listenTo(this.model,'change:attributes:src',this.updateSrc)},updateSrc:function(){var t=Object(Qt["h"])(this.el,'iframe')[0];t&&Object(Qt["d"])(t,{src:this.__getSrc()})},render:function(){for(var t=arguments.length,e=new Array(t),n=0;n<t;n++)e[n]=arguments[n];d["default"].prototype.render.apply(this,e);var r=Object(Qt["f"])('iframe',{class:"".concat(this.ppfx,"no-pointer"),style:'width: 100%; height: 100%; border: none',src:this.__getSrc()});return this.el.appendChild(r),this},__getSrc:function(){return this.model.getAttributes().src||''}});function ee(t,e){var n=Object.keys(t);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(t);e&&(r=r.filter((function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable}))),n.push.apply(n,r)}return n}function ne(t){for(var e=1;e<arguments.length;e++){var n=null!=arguments[e]?arguments[e]:{};e%2?ee(Object(n),!0).forEach((function(e){i()(t,e,n[e])})):Object.getOwnPropertyDescriptors?Object.defineProperties(t,Object.getOwnPropertyDescriptors(n)):ee(Object(n)).forEach((function(e){Object.defineProperty(t,e,Object.getOwnPropertyDescriptor(n,e))}))}return t}e["default"]=function(){var t,e,n,r={},i={},o=[{id:'cell',model:v,view:m},{id:'row',model:O,view:x},{id:'table',model:j,view:T},{id:'thead',model:N,view:R},{id:'tbody',model:M,view:I},{id:'tfoot',model:H,view:B},{id:'map',model:Y,view:J},{id:'link',model:rt,view:ht},{id:'label',model:vt,view:mt},{id:'video',model:kt,view:St},{id:'image',model:q,view:X},{id:'script',model:Et,view:_t},{id:'svg-in',model:It,view:Ft},{id:'svg',model:Lt,view:Ft},{id:'iframe',model:Zt,view:te},{id:'comment',model:Ut,view:Wt},{id:'textnode',model:Ht,view:$t},{id:'text',model:tt,view:dt},{id:'wrapper',model:Kt,view:d["default"]},{id:'default',model:l["a"],view:d["default"]}];return{Component:l["a"],Components:u["a"],ComponentsView:h["a"],componentTypes:o,componentsById:i,name:'DomComponents',getConfig:function(){return r},storageKey:function(){var t=[],e=r.stm&&r.stm.getConfig()||{};return e.storeHtml&&t.push('html'),e.storeComponents&&t.push('components'),t},init:function(e){var n=this;for(var i in t=(r=e||{}).em,this.em=t,t&&(r.components=t.config.components||r.components),c)i in r||(r[i]=c[i]);var a=r.pStylePrefix;if(a&&(r.stylePrefix=a+r.stylePrefix),t){r.modal=t.get('Modal')||'',r.am=t.get('AssetManager')||'',t.get('Parser').compTypes=o,t.on('change:componentHovered',this.componentHovered,this);var s=t.get('selected');t.listenTo(s,'add',(function(t,e,r){return n.selectAdd(s.getComponent(t),r)})),t.listenTo(s,'remove',(function(t,e,r){return n.selectRemove(s.getComponent(t),r)}))}return t.get('hasPages')&&(r.components=''),this},onLoad:function(){r.components&&this.setComponents(r.components,{silent:1})},load:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:'',e=this.em,n='';!t&&r.stm&&(t=r.em.getCacheLoad());var i=t,o=i.components,a=i.html;if(o)if(Object(s["isObject"])(o)||Object(s["isArray"])(o))n=o;else try{n=JSON.parse(o)}catch(t){e&&e.logError(t)}else a&&(n=a);var c=n&&n.constructor===Object;return(n&&n.length||c)&&(this.clear(),c?this.getWrapper().set(n):this.getComponents().add(n)),n},store:function(t){if(!r.stm||this.em.get('hasPages'))return{};var e={},n=this.storageKey();if(n.indexOf('html')>=0&&(e.html=r.em.getHtml()),n.indexOf('components')>=0){var i=r.storeWrapper?this.getWrapper():this.getComponents();e.components=JSON.stringify(i)}return t||r.stm.store(e),e},getComponent:function(){var t=this.em.get('PageManager').getSelected(),e=t&&t.getMainFrame();return e&&e.getComponent()},getWrapper:function(){return this.getComponent()},getComponents:function(){var t=this.getWrapper();return t&&t.get('components')},addComponent:function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};return this.getComponents().add(t,e)},render:function(){return n.render().el},clear:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};return this.getComponents().map((function(t){return t})).forEach((function(e){return e.remove(t)})),this},setComponents:function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};this.clear(e).addComponent(t,e)},addType:function(t,e){var n=this.em,r=e.model,i=void 0===r?{}:r,c=e.view,l=void 0===c?{}:c,u=e.isComponent,d=e.extend,h=e.extendView,f=e.extendFn,p=void 0===f?[]:f,g=e.extendFnView,v=void 0===g?[]:g,m=this.getType(t),y=this.getType(d),b=this.getType(h),w=y||(m||this.getType('default')),O=w.model,x=b?b.view:w.view,C=function(t,e,n){return t.reduce((function(t,r){var i=e[r],o=n.prototype[r];return i&&o&&(t[r]=function(){o.bind(this).apply(void 0,arguments),i.bind(this).apply(void 0,arguments)}),t}),{})};'object'===a()(i)&&(e.model=O.extend(ne(ne(ne({},i),C(p,i,O)),{},{defaults:ne(ne({},Object(s["result"])(O.prototype,'defaults')||{}),Object(s["result"])(i,'defaults')||{})}),{isComponent:!m||y||u?u||function(){return 0}:O.isComponent})),'object'===a()(l)&&(e.view=x.extend(ne(ne({},l),C(v,l,x)))),m?(m.model=e.model,m.view=e.view):(e.id=t,o.unshift(e));var k="component:type:".concat(m?'update':'add');return n&&n.trigger(k,m||e),this},getType:function(t){for(var e=o,n=0;n<e.length;n++){if(e[n].id==t)return e[n]}},removeType:function(t){var e=o,n=this.getType(t);if(n){var r=e.indexOf(n);return e.splice(r,1),n}},getTypes:function(){return o},selectAdd:function(t){var e=this,n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};t&&(t.set({status:'selected'}),['component:selected','component:toggled'].forEach((function(r){return e.em.trigger(r,t,n)})))},selectRemove:function(t){var e=this,n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(t){this.em;t.set({status:'',state:''}),['component:deselected','component:toggled'].forEach((function(r){return e.em.trigger(r,t,n)}))}},componentHovered:function(){var t=r.em,e=t.get('componentHovered'),n=t.previous('componentHovered'),i='hovered';n&&n.get('status')==i&&n.set({status:'',state:''}),e&&Object(s["isEmpty"])(e.get('status'))&&e.set('status',i)},allById:function(){return i},destroy:function(){var o=this.allById();Object.keys(o).forEach((function(t){return o[t]&&o[t].remove()})),n&&n.remove(),[r,t,i,e,n].forEach((function(t){return{}})),this.em={}}}}},function(t,e,n){"use strict";n.r(e);var r=n(3),i=n.n(r),o=n(0),a=n(18),s={stylePrefix:'gjs-',components:'',style:'',fromElement:0,noticeOnUnload:!0,showOffsets:!1,showOffsetsSelected:!1,forceClass:!0,height:'900px',width:'100%',log:['warning','error'],baseCss:"\n    * {\n      box-sizing: border-box;\n    }\n    html, body, [data-gjs-type=wrapper] {\n      min-height: 100%;\n    }\n    body {\n      margin: 0;\n      height: 100%;\n      background-color: #fff\n    }\n    [data-gjs-type=wrapper] {\n      overflow: auto;\n      overflow-x: hidden;\n    }\n\n    * ::-webkit-scrollbar-track {\n      background: rgba(0, 0, 0, 0.1)\n    }\n\n    * ::-webkit-scrollbar-thumb {\n      background: rgba(255, 255, 255, 0.2)\n    }\n\n    * ::-webkit-scrollbar {\n      width: 10px\n    }\n  ",protectedCss:'* { box-sizing: border-box; } body {margin: 0;}',canvasCss:'',defaultCommand:'select-comp',showToolbar:1,allowScripts:0,showDevices:1,devicePreviewMode:0,mediaCondition:'max-width',tagVarStart:'{[ ',tagVarEnd:' ]}',keepEmptyTextNodes:0,jsInHtml:!0,nativeDnD:1,multipleSelection:1,exportWrapper:0,wrapperIsBody:1,optsHtml:{},optsCss:{},avoidInlineStyle:1,avoidDefaults:1,clearStyles:0,dragMode:0,listenToEl:[],cssIcons:'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css',el:'',i18n:{},undoManager:{},assetManager:{},canvas:{},layers:{},storageManager:{},richTextEditor:{},domComponents:{},modal:{},codeManager:{},panels:{},commands:{},cssComposer:{},selectorManager:{},deviceManager:{},styleManager:{sectors:[{name:'General',open:!1,buildProps:['float','display','position','top','right','left','bottom']},{name:'Flex',open:!1,buildProps:['flex-direction','flex-wrap','justify-content','align-items','align-content','order','flex-basis','flex-grow','flex-shrink','align-self']},{name:'Dimension',open:!1,buildProps:['width','height','max-width','min-height','margin','padding']},{name:'Typography',open:!1,buildProps:['font-family','font-size','font-weight','letter-spacing','color','line-height','text-align','text-shadow'],properties:[{property:'text-align',list:[{value:'left',className:'fa fa-align-left'},{value:'center',className:'fa fa-align-center'},{value:'right',className:'fa fa-align-right'},{value:'justify',className:'fa fa-align-justify'}]}]},{name:'Decorations',open:!1,buildProps:['border-radius-c','background-color','border-radius','border','box-shadow','background']},{name:'Extra',open:!1,buildProps:['transition','perspective','transform']}]},blockManager:{},traitManager:{},textViewCode:'Code',keepUnusedStyles:0,multiFrames:0,customUI:!1},c=n(22),l=n.n(c),u=n(2),d=n.n(u),h=n(1),f=n(6),p=n.n(f),g=n(5),v=n.n(g),m=n(8),y=n.n(m),b=n(9),w=n.n(b),O=n(4),x=n.n(O);function C(t){var e=function(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],(function(){}))),!0}catch(t){return!1}}();return function(){var n,r=x()(t);if(e){var i=x()(this).constructor;n=Reflect.construct(r,arguments,i)}else n=r.apply(this,arguments);return w()(this,n)}}var k=function(t){y()(n,t);var e=C(n);function n(){return v()(this,n),e.apply(this,arguments)}return n}(u["Model"]),S=function(t){y()(n,t);var e=C(n);function n(){return v()(this,n),e.apply(this,arguments)}return p()(n,[{key:"getByComponent",value:function(t){var e=this;return this.filter((function(n){return e.getComponent(n)===t}))[0]}},{key:"addComponent",value:function(t,e){var n=this,r=(Object(o["isArray"])(t)?t:[t]).filter((function(t){return!n.hasComponent(t)})).map((function(t){return{component:t}}));return this.push(r,e)}},{key:"getComponent",value:function(t){return t.get('component')}},{key:"hasComponent",value:function(t){var e=this.getByComponent(t);return e&&this.contains(e)}},{key:"lastComponent",value:function(){var t=this.last();return t&&this.getComponent(t)}},{key:"allComponents",value:function(){var t=this;return this.map((function(e){return t.getComponent(e)})).filter((function(t){return t}))}},{key:"removeComponent",value:function(t,e){var n=this,r=(Object(o["isArray"])(t)?t:[t]).map((function(t){return n.getByComponent(t)}));return this.remove(r,e)}}]),n}(u["Collection"]);S.prototype.model=k;var j=["unset"];function T(t,e){var n=Object.keys(t);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(t);e&&(r=r.filter((function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable}))),n.push.apply(n,r)}return n}function P(t){for(var e=1;e<arguments.length;e++){var n=null!=arguments[e]?arguments[e]:{};e%2?T(Object(n),!0).forEach((function(e){i()(t,e,n[e])})):Object.getOwnPropertyDescriptors?Object.defineProperties(t,Object.getOwnPropertyDescriptors(n)):T(Object(n)).forEach((function(e){Object.defineProperty(t,e,Object.getOwnPropertyDescriptor(n,e))}))}return t}d.a.$=a["default"];var E,_,M=[n(114),n(115),n(118),n(83),n(110),n(108),n(111),n(106),n(109),n(112),n(107),n(104),n(116),n(101),n(113),n(47),n(102),n(99),n(117),n(105),n(119),n(103)];!function(t){var e=t.$;if(e&&e.prototype&&'jQuery'!==e.prototype.constructor.name){var n=e.fn;n.hide=function(){return this.css('display','none')},n.show=function(){return this.css('display','block')},n.focus=function(){var t=this.get(0);return t&&t.focus(),this},n.bind=function(t,e){return this.on(t,e)},n.unbind=function(t,e){if(Object(o["isObject"])(t)){for(var n in t)t.hasOwnProperty(n)&&this.off(n,t[n]);return this}return this.off(t,e)},n.click=function(t){return t?this.on('click',t):this.trigger('click')},n.change=function(t){return t?this.on('change',t):this.trigger('change')},n.keydown=function(t){return t?this.on('keydown',t):this.trigger('keydown')},n.delegate=function(t,e,n,r){return r||(r=n),this.on(e,t,(function(t){t.data=n,r(t)}))},n.scrollLeft=function(){var t=this.get(0),e=(t=9==t.nodeType?t.defaultView:t)instanceof Window?t:null;return e?e.pageXOffset:t.scrollLeft||0},n.scrollTop=function(){var t=this.get(0),e=(t=9==t.nodeType?t.defaultView:t)instanceof Window?t:null;return e?e.pageYOffset:t.scrollTop||0};var r=e.prototype.offset;n.offset=function(t){var e,n;return t&&(e=t.top,n=t.left),void 0!==e&&this.css('top',"".concat(e,"px")),void 0!==n&&this.css('left',"".concat(n,"px")),r.call(this)},e.map=function(t,e){for(var n=[],r=0;r<t.length;r++)n.push(e(t[r],r));return n};var i=Array.prototype.indexOf;e.inArray=function(t,e,n){return null==e?-1:i.call(e,t,n)},e.Event=function(t,n){if(!(this instanceof e.Event))return new e.Event(t,n);this.type=t,this.isDefaultPrevented=function(){return!1}}}}({Backbone:d.a,$:d.a.$});var D={debug:console.log,info:console.info,warning:console.warn,error:console.error},A=d.a.Model.extend({defaults:function(){return{editing:0,selected:0,clipboard:null,dmode:0,componentHovered:null,previousModel:null,changesCount:0,storables:[],modules:[],toLoad:[],opened:{},device:''}},initialize:function(){var t=this,e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};this.config=e,this.set('Config',e),this.set('modules',[]),this.set('toLoad',[]),this.set('storables',[]),this.set('selected',new S),this.set('dmode',e.dragMode),this.set('hasPages',!!e.pageManager);var n=e.el,r=e.log,i=!0===r?Object(o["keys"])(D):Object(o["isArray"])(r)?r:[];Object(o["bindAll"])(this,'initBaseColorPicker'),n&&e.fromElement&&(this.config.components=n.innerHTML),this.attrsOrig=n?Object(o["toArray"])(n.attributes).reduce((function(t,e){return t[e.nodeName]=e.nodeValue,t}),{}):'',M.forEach((function(e){return t.loadModule(e)})),this.on('change:componentHovered',this.componentHovered,this),this.on('change:changesCount',this.updateChanges,this),this.on('change:readyLoad change:readyCanvas',this._checkReady,this),i.forEach((function(e){return t.listenLog(e)})),[{from:'change:selectedComponent',to:'component:toggled'}].forEach((function(e){var n=e.from,r=e.to;t.listenTo(t,n,(function(){for(var e=arguments.length,i=new Array(e),o=0;o<e;o++)i[o]=arguments[o];t.trigger.apply(t,[r].concat(i)),t.logWarning("The event '".concat(n,"' is deprecated, replace it with '").concat(r,"'"))}))}))},_checkReady:function(){this.get('readyLoad')&&this.get('readyCanvas')&&!this.get('ready')&&this.set('ready',!0)},getContainer:function(){return this.config.el},listenLog:function(t){this.listenTo(this,"log:".concat(t),D[t])},getConfig:function(t){var e=this.config;return Object(o["isUndefined"])(t)?e:e[t]},loadOnStart:function(){var t=this,e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:null,n=this.get('StorageManager');this.get('toLoad').forEach((function(t){t.onLoad()}));var r=function(){t.get('modules').forEach((function(e){return e.postLoad&&e.postLoad(t)})),t.set('readyLoad',1),e&&e()};n&&n.canAutoload()?this.load(r):setTimeout(r)},updateChanges:function(){var t=this,e=this.get('StorageManager'),n=this.get('changesCount');_&&clearTimeout(_),_=setTimeout((function(){return t.trigger('update')})),this.config.noticeOnUnload&&(window.onbeforeunload=n?function(t){return 1}:null),e.isAutosave()&&n>=e.getStepsBeforeSave()&&this.store()},loadModule:function(t){var e=this.config,n=new(t.default||t),r=n.name.charAt(0).toLowerCase()+n.name.slice(1),i=Object(o["isUndefined"])(e[r])?e[n.name]:e[r],a=!0===i?{}:i||{},s=this.get('StorageManager');if(a.pStylePrefix=e.pStylePrefix||'',Object(o["isUndefined"])(i)||i||(a._disable=1),n.storageKey&&n.store&&n.load&&s){a.stm=s;var c='domComponents'==r?'unshift':'push';this.get('storables')[c](n)}return a.em=this,n.init(P({},a)),!n.private&&this.set(n.name,n),n.onLoad&&this.get('toLoad').push(n),this.get('modules').push(n),this},init:function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};this.destroyed&&(this.initialize(e),this.destroyed=0),this.set('Editor',t)},getEditor:function(){return this.get('Editor')},handleUpdates:function(t,e){var n=this,r=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};r.temporary||r.noCount||r.avoidStore||!this.get('ready')||(E&&clearTimeout(E),E=setTimeout((function(){var t=n.get('changesCount')||0,e=(r.unset,l()(r,j));n.set('changesCount',t+1,e)}),0))},changesUp:function(t){this.handleUpdates(0,0,t)},componentHovered:function(t,e,n){var r=this.previous('componentHovered');r&&this.trigger('component:unhovered',r,n),e&&this.trigger('component:hovered',e,n)},getSelected:function(){return this.get('selected').lastComponent()},getSelectedAll:function(){return this.get('selected').allComponents()},setSelected:function(t){var e=this,n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},r=n.event,i=r&&(r.ctrlKey||r.metaKey),s=r||{},c=s.shiftKey,l=Object(o["isArray"])(t),u=(l?t:[t]).map((function(t){return Object(h["getModel"])(t,a["default"])})),d=this.getSelectedAll(),f=this.getConfig('multipleSelection');l&&this.removeSelected(d.filter((function(t){return!Object(o["contains"])(u,t)}))),u.forEach((function(t){var r=Object(h["getModel"])(t,a["default"]);if(!r||r.get('selectable')){if(i&&f)return e.toggleSelected(r);if(c&&f){e.clearSelection(e.get('Canvas').getWindow());var s,u,p=r.collection,g=r.index();if(e.getSelectedAll().forEach((function(t){var e=t.collection,n=t.index();e===p&&(n<g?s=Object(o["isUndefined"])(s)?n:Math.max(s,n):n>g&&(u=Object(o["isUndefined"])(u)?n:Math.min(u,n)))})),!Object(o["isUndefined"])(s))for(;s!==g;)e.addSelected(p.at(s)),s++;if(!Object(o["isUndefined"])(u))for(;u!==g;)e.addSelected(p.at(u)),u--;return e.addSelected(r)}!l&&e.removeSelected(d.filter((function(t){return t!==r}))),e.addSelected(r,n),r}}))},addSelected:function(t){var e=this,n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},r=Object(h["getModel"])(t,a["default"]),i=Object(o["isArray"])(r)?r:[r];i.forEach((function(t){if(!t||t.get('selectable')){var r=e.get('selected');n.forceChange&&e.removeSelected(t,n),r.addComponent(t,n)}}))},removeSelected:function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};this.get('selected').removeComponent(Object(h["getModel"])(t,a["default"]),e)},toggleSelected:function(t){var e=this,n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},r=Object(h["getModel"])(t,a["default"]),i=Object(o["isArray"])(r)?r:[r];i.forEach((function(t){e.get('selected').hasComponent(t)?e.removeSelected(t,n):e.addSelected(t,n)}))},setHovered:function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},n=Object(h["getModel"])(t,a["default"]);n&&!n.get('hoverable')||(e.forceChange&&this.set('componentHovered',''),this.set('componentHovered',n,e))},getHovered:function(){return this.get('componentHovered')},setComponents:function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};return this.get('DomComponents').setComponents(t,e)},getComponents:function(){var t=this.get('DomComponents'),e=this.get('CodeManager');if(t&&e){var n=t.getComponents();return e.getCode(n,'json')}},setStyle:function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},n=this.get('CssComposer');return n.clear(e),n.getAll().add(t,e),this},addStyle:function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},n=this.getStyle().add(t,e);return Object(o["isArray"])(n)?n:[n]},getStyle:function(){return this.get('CssComposer').getAll()},setState:function(t){return this.set('state',t),this},getState:function(){return this.get('state')||''},getHtml:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},e=this.config,n=e.optsHtml,r=e.exportWrapper,i=e.wrapperIsBody,o=e.jsInHtml?this.getJs(t):'',a=t.component||this.get('DomComponents').getComponent(),s=a?this.get('CodeManager').getCode(a,'html',P(P({exportWrapper:r,wrapperIsBody:i},n),t)):'';return s+=o?"<script>".concat(o,"<\/script>"):''},getCss:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},e=this.config,n=e.optsCss,r=e.wrapperIsBody,i=t.avoidProtected,a=Object(o["isUndefined"])(t.keepUnusedStyles)?e.keepUnusedStyles:t.keepUnusedStyles,s=this.get('CssComposer'),c=t.component||this.get('DomComponents').getComponent(),l=i?'':e.protectedCss,u=c&&this.get('CodeManager').getCode(c,'css',P(P({cssc:s,wrapperIsBody:r,keepUnusedStyles:a},n),t));return c?t.json?u:l+u:''},getJs:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},e=t.component||this.get('DomComponents').getWrapper();return e?this.get('CodeManager').getCode(e,'js').trim():''},store:function(t){var e=this,n=this.get('StorageManager');if(n){var r=this.storeData();return n.store(r,(function(n){t&&t(n,r),e.set('changesCount',0),e.trigger('storage:store',r)})),r}},storeData:function(){var t={},e=this.getEditing();return e&&e.trigger('sync:content',{noCount:!0}),this.get('storables').forEach((function(e){t=P(P({},t),e.store(1))})),t},load:function(){var t=this,e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:null;this.getCacheLoad(1,(function(n){t.loadData(n),e&&e(n)}))},loadData:function(){var t=this,e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},n=this.get('StorageManager'),r=n.__clearKeys(e);return this.get('storables').forEach((function(e){e.load(r),e.postLoad&&e.postLoad(t)})),r},getCacheLoad:function(t,e){var n=this;if(this.cacheLoad&&!t)return this.cacheLoad;var r=this.get('StorageManager'),i=[];if(!r)return{};this.get('storables').forEach((function(t){var e=t.storageKey;e=Object(o["isFunction"])(e)?e():e,(Object(o["isArray"])(e)?e:[e]).forEach((function(t){return i.push(t)}))})),r.load(i,(function(t){n.cacheLoad=t,e&&e(t),setTimeout((function(){return n.trigger('storage:load',t)}))}))},getDeviceModel:function(){var t=this.get('device');return this.get('DeviceManager').get(t)},runDefault:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},e=this.get('Commands').get(this.config.defaultCommand);e&&!this.defaultRunning&&(e.stop(this,this,t),e.run(this,this,t),this.defaultRunning=1)},stopDefault:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},e=this.get('Commands'),n=e.get(this.config.defaultCommand);n&&this.defaultRunning&&(n.stop(this,this,t),this.defaultRunning=0)},refreshCanvas:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};this.set('canvasOffset',null),this.set('canvasOffset',this.get('Canvas').getOffset()),t.tools&&this.trigger('canvas:updateTools')},clearSelection:function(t){(t||window).getSelection().removeAllRanges()},getCurrentMedia:function(){var t=this.config,e=this.getDeviceModel(),n=t.mediaCondition,r=t.devicePreviewMode,i=e&&e.get('widthMedia');return e&&i&&!r?"(".concat(n,": ").concat(i,")"):''},getWrapper:function(){return this.get('DomComponents').getWrapper()},setCurrentFrame:function(t){return this.set('currentFrame',t)},getCurrentFrame:function(){return this.get('currentFrame')},getCurrentFrameModel:function(){return(this.getCurrentFrame()||{}).model},getDirtyCount:function(){return this.get('changesCount')},getZoomDecimal:function(){return this.get('Canvas').getZoomDecimal()},getZoomMultiplier:function(){return this.get('Canvas').getZoomMultiplier()},setDragMode:function(t){return this.set('dmode',t)},t:function(){var t;return(t=this.get('I18n')).t.apply(t,arguments)},inAbsoluteMode:function(){return'absolute'===this.get('dmode')},destroyAll:function(){var t=this,e=this.config,n=this.view,r=this.getEditor(),i=(e.grapesjs||{}).editors,o=void 0===i?[]:i;this.stopDefault(),this.get('modules').slice().reverse().forEach((function(t){return t.destroy()})),n&&n.remove(),this.stopListening(),this.clear({silent:!0}),this.destroyed=1,['config','view','_previousAttributes','_events','_listeners'].forEach((function(e){return t[e]={}})),o.splice(o.indexOf(r),1),Object(h["hasWin"])()&&Object(a["default"])(e.el).empty().attr(this.attrsOrig)},getEditing:function(){var t=this.get('editing');return t&&t.model||null},setEditing:function(t){return this.set('editing',t),this},isEditing:function(){return!!this.get('editing')},log:function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},n=e.ns,r=e.level,i=void 0===r?'debug':r;if(this.trigger('log',t,e),i&&this.trigger("log:".concat(i),t,e),n){var o="log-".concat(n);this.trigger(o,t,e),i&&this.trigger("".concat(o,":").concat(i),t,e)}},logInfo:function(t,e){this.log(t,P(P({},e),{},{level:'info'}))},logWarning:function(t,e){this.log(t,P(P({},e),{},{level:'warning'}))},logError:function(t,e){this.log(t,P(P({},e),{},{level:'error'}))},initBaseColorPicker:function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},n=this.getConfig(),r=n.colorPicker,i=void 0===r?{}:r,o=n.el,s=n.stylePrefix;return Object(a["default"])(t).spectrum(P(P({containerClassName:"".concat(s,"one-bg ").concat(s,"two-color"),appendTo:o||'body',maxSelectionSize:8,showPalette:!0,palette:[],showAlpha:!0,chooseText:'Ok',cancelText:'⨯'},e),i))},data:function(t,e,n){var r='_gjs-data';if(t[r]||(t[r]={}),Object(o["isUndefined"])(n))return t[r][e];t[r][e]=n}}),L=d.a.$,N=d.a.View.extend({initialize:function(){var t=this,e=this.model;e.view=this,this.conf=e.config,this.pn=e.get('Panels'),this.cv=e.get('Canvas'),e.once('change:ready',(function(){t.pn.active(),t.pn.disableButtons(),setTimeout((function(){e.trigger('load',e.get('Editor')),e.set('changesCount',0)}))}))},render:function(){this.model;var t=this.$el,e=this.conf,n=e.stylePrefix,r=L(e.el||"body ".concat(e.container));return Object(h["appendStyles"])(e.cssIcons,{unique:1,prepand:1}),t.empty(),e.width&&r.css('width',e.width),e.height&&r.css('height',e.height),t.append(this.cv.render()),t.append(this.pn.render()),t.attr('class',"".concat(n,"editor ").concat(n,"one-bg ").concat(n,"two-color")),r.addClass("".concat(n,"editor-cont")).empty().append(t),this}}),R=n(17);function I(t,e){var n=Object.keys(t);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(t);e&&(r=r.filter((function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable}))),n.push.apply(n,r)}return n}function F(t){for(var e=1;e<arguments.length;e++){var n=null!=arguments[e]?arguments[e]:{};e%2?I(Object(n),!0).forEach((function(e){i()(t,e,n[e])})):Object.getOwnPropertyDescriptors?Object.defineProperties(t,Object.getOwnPropertyDescriptors(n)):I(Object(n)).forEach((function(e){Object.defineProperty(t,e,Object.getOwnPropertyDescriptor(n,e))}))}return t}var V=function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},n=e.$,r=F(F({},s),t);r.pStylePrefix=r.stylePrefix;var i,o=new A(r);return{$:n,editor:o,init:function(){var t=this,e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};return o.init(this,F(F({},r),e)),['I18n','Utils','Config','Commands','Keymaps','Modal','Panels','Canvas','Parser','CodeManager','UndoManager','RichTextEditor',['Pages','PageManager'],'DomComponents',['Components','DomComponents'],'LayerManager',['Layers','LayerManager'],'CssComposer',['Css','CssComposer'],'StorageManager',['Storage','StorageManager'],'AssetManager',['Assets','AssetManager'],'BlockManager',['Blocks','BlockManager'],'TraitManager',['Traits','TraitManager'],'SelectorManager',['Selectors','SelectorManager'],'StyleManager',['Styles','StyleManager'],'DeviceManager',['Devices','DeviceManager']].forEach((function(e){Array.isArray(e)?t[e[0]]=o.get(e[1]):t[e]=o.get(e)})),o.once('change:ready',(function(){t.UndoManager.clear(),o.get('modules').forEach((function(t){t.postRender&&t.postRender(i)}))})),this},getConfig:function(t){return o.getConfig(t)},getHtml:function(t){return o.getHtml(t)},getCss:function(t){return o.getCss(t)},getJs:function(t){return o.getJs(t)},getComponents:function(){return o.get('DomComponents').getComponents()},getWrapper:function(){return o.get('DomComponents').getWrapper()},setComponents:function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};return o.setComponents(t,e),this},addComponents:function(t,e){return this.getWrapper().append(t,e)},getStyle:function(){return o.get('CssComposer').getAll()},setStyle:function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};return o.setStyle(t,e),this},addStyle:function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};return o.addStyle(t,e)},getSelected:function(){return o.getSelected()},getSelectedAll:function(){return o.getSelectedAll()},getSelectedToStyle:function(){var t=o.getSelected();if(t)return this.StyleManager.getModelToStyle(t)},select:function(t,e){return o.setSelected(t,e),this},selectAdd:function(t){return o.addSelected(t),this},selectRemove:function(t){return o.removeSelected(t),this},selectToggle:function(t){return o.toggleSelected(t),this},getEditing:function(){return o.getEditing()},setDevice:function(t){return o.set('device',t),this},getDevice:function(){return o.get('device')},runCommand:function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};return o.get('Commands').run(t,e)},stopCommand:function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};return o.get('Commands').stop(t,e)},store:function(t){return o.store(t)},storeData:function(){return o.storeData()},load:function(t){return o.load(t)},loadData:function(t){return o.loadData(t)},getContainer:function(){return r.el},getDirtyCount:function(){return o.getDirtyCount()},refresh:function(t){o.refreshCanvas(t)},setCustomRte:function(t){this.RichTextEditor.customRte=t},setCustomParserCss:function(t){return this.Parser.getConfig().parserCss=t,this},setDragMode:function(t){return o.setDragMode(t),this},log:function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};return o.log(t,e),this},t:function(){return o.t.apply(o,arguments)},on:function(t,e){return o.on(t,e),this},once:function(t,e){return o.once(t,e),this},off:function(t,e){return o.off(t,e),this},trigger:function(t){return o.trigger.apply(o,arguments),this},destroy:function(){return o.destroyAll()},getEl:function(){return i&&i.el},getModel:function(){return o},render:function(){return i&&i.remove(),(i=new N({model:o,config:r})).render().el},onReady:function(t){o.get('ready')?t(this):o.on('load',t)},html:R["a"]}},z={plugins:[]};function H(t,e){var n=Object.keys(t);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(t);e&&(r=r.filter((function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable}))),n.push.apply(n,r)}return n}function B(t){for(var e=1;e<arguments.length;e++){var n=null!=arguments[e]?arguments[e]:{};e%2?H(Object(n),!0).forEach((function(e){i()(t,e,n[e])})):Object.getOwnPropertyDescriptors?Object.defineProperties(t,Object.getOwnPropertyDescriptors(n)):H(Object(n)).forEach((function(e){Object.defineProperty(t,e,Object.getOwnPropertyDescriptor(n,e))}))}return t}!function(){if(Object(h["hasWin"])()&&function(){for(var t,e=window.navigator.userAgent,n=[['edge',/Edge\/([0-9\._]+)/],['ie',/MSIE\s(7\.0)/],['ie',/MSIE\s([0-9\.]+);.*Trident\/[4-7].0/],['ie',/Trident\/7\.0.*rv\:([0-9\.]+).*\).*Gecko$/]],r=0;r<n.length;r++){if(t=n[r][1].exec(e))break}return!!t}()){var t=DOMImplementation.prototype.createHTMLDocument;DOMImplementation.prototype.createHTMLDocument=function(e){return e||(e=''),t.apply(document.implementation,[e])}}}();var U=new function(t){var e=t||{};for(var n in z)n in e||(e[n]=z[n]);var r={};return{add:function(t,e){return r[t]?r[t]:(r[t]=e,e)},get:function(t){return r[t]},getAll:function(){return r}}},$=[],W={autorender:1,plugins:[],pluginsOpts:{}};e["default"]={$:a["default"],editors:$,plugins:U,version:'0.17.29',init:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},e=t,n=e.headless,r=t.container;if(!r&&!n)throw new Error("'container' is required");(t=B(B(B({},W),t),{},{grapesjs:this})).el=!n&&(Object(o["isElement"])(r)?r:document.querySelector(r));var i=new V(t,{$:a["default"]}).init(),s=i.getModel();return t.plugins.forEach((function(e){var n=U.get(e),r=t.pluginsOpts[e]||{};if(!n){var a=window[e];n=a&&a.default?a.default:a}n?n(i,r):Object(o["isFunction"])(e)?e(i,r):s.logWarning("Plugin ".concat(e," not found"),{context:'plugins',plugin:e})})),s.loadOnStart(),t.autorender&&!n&&i.render(),$.push(i),i}}},function(t,e,n){"use strict";n.r(e),n.d(e,"evAll",(function(){return q})),n.d(e,"evPfx",(function(){return G})),n.d(e,"evSelect",(function(){return K})),n.d(e,"evUpdate",(function(){return Y})),n.d(e,"evAdd",(function(){return X})),n.d(e,"evRemove",(function(){return J})),n.d(e,"evRemoveBefore",(function(){return Z})),n.d(e,"evCustom",(function(){return Q})),n.d(e,"evOpen",(function(){return tt})),n.d(e,"evClose",(function(){return et}));var r=n(3),i=n.n(r),o=n(0),a=n(21),s={assets:[],noAssets:'',stylePrefix:'am-',upload:0,uploadName:'files',headers:{},params:{},credentials:'include',multiUpload:!0,autoAdd:!0,customFetch:null,uploadFile:null,embedAsBase64:!0,handleAdd:null,beforeUpload:null,showUrlInput:!0,custom:!1,dropzone:!1,openAssetsOnDrop:1,dropzoneContent:''},c=n(2),l=n.n(c),u=n(5),d=n.n(u),h=n(6),f=n.n(h),p=n(8),g=n.n(p),v=n(9),m=n.n(v),y=n(4),b=n.n(y);function w(t){var e=function(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],(function(){}))),!0}catch(t){return!1}}();return function(){var n,r=b()(t);if(e){var i=b()(this).constructor;n=Reflect.construct(r,arguments,i)}else n=r.apply(this,arguments);return m()(this,n)}}var O=function(t){g()(n,t);var e=w(n);function n(){return d()(this,n),e.apply(this,arguments)}return f()(n,[{key:"defaults",value:function(){return{type:'',src:''}}},{key:"getType",value:function(){return this.get('type')}},{key:"getSrc",value:function(){return this.get('src')}},{key:"getFilename",value:function(){return this.get('src').split('/').pop().split('?').shift()}},{key:"getExtension",value:function(){return this.getFilename().split('.').pop()}}]),n}(c["Model"]);function x(t,e){var n=Object.keys(t);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(t);e&&(r=r.filter((function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable}))),n.push.apply(n,r)}return n}function C(t){for(var e=1;e<arguments.length;e++){var n=null!=arguments[e]?arguments[e]:{};e%2?x(Object(n),!0).forEach((function(e){i()(t,e,n[e])})):Object.getOwnPropertyDescriptors?Object.defineProperties(t,Object.getOwnPropertyDescriptors(n)):x(Object(n)).forEach((function(e){Object.defineProperty(t,e,Object.getOwnPropertyDescriptor(n,e))}))}return t}function k(t){var e=function(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],(function(){}))),!0}catch(t){return!1}}();return function(){var n,r=b()(t);if(e){var i=b()(this).constructor;n=Reflect.construct(r,arguments,i)}else n=r.apply(this,arguments);return m()(this,n)}}O.prototype.idAttribute='src',O.getDefaults=function(){return Object(o["result"])(this.prototype,'defaults')};var S,j,T,P=function(t){g()(n,t);var e=k(n);function n(){return d()(this,n),e.apply(this,arguments)}return f()(n,[{key:"defaults",value:function(){return C(C({},O.getDefaults()),{},{type:'image',unitDim:'px',height:0,width:0})}}]),n}(O),E=n(19),_=n.n(E),M=l.a.View.extend({initialize:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};this.options=t,this.collection=t.collection;var e=t.config||{};this.config=e,this.pfx=e.stylePrefix||'',this.ppfx=e.pStylePrefix||'',this.em=e.em,this.className=this.pfx+'asset',this.listenTo(this.model,'destroy remove',this.remove),this.model.view=this;var n=this.init&&this.init.bind(this);n&&n(t)},__getBhv:function(){var t=this.em,e=t&&t.get('AssetManager');return e&&e.__getBehaviour()||{}},template:function(){var t=this.pfx;return"\n      <div class=\"".concat(t,"preview-cont\">\n        ").concat(this.getPreview(),"\n      </div>\n      <div class=\"").concat(t,"meta\">\n        ").concat(this.getInfo(),"\n      </div>\n      <div class=\"").concat(t,"close\" data-toggle=\"asset-remove\">\n        &Cross;\n      </div>\n    ")},updateTarget:function(t){t&&t.set&&(t.set('attributes',Object(o["clone"])(t.get('attributes'))),t.set('src',this.model.get('src')))},getPreview:function(){return''},getInfo:function(){return''},render:function(){var t=this.el;return t.innerHTML=this.template(this,this.model),t.className=this.className,this}}),D=n(17),A=M.extend({events:{'click [data-toggle=asset-remove]':'onRemove',click:'onClick',dblclick:'onDblClick'},getPreview:function(){var t=this.pfx,e=this.ppfx,n=this.model.get('src');return Object(D["a"])(S||(S=_()(["\n      <div class=\"","preview\" style=\"background-image: url('","');\"></div>\n      <div class=\"","preview-bg ","checker-bg\"></div>\n    "])),t,n,t,e)},getInfo:function(){var t=this.pfx,e=this.model,n=e.get('name'),r=e.get('width'),i=e.get('height'),o=e.get('unitDim'),a=r&&i?"".concat(r,"x").concat(i).concat(o):'';return n=n||e.getFilename(),Object(D["a"])(j||(j=_()(["\n      <div class=\"","name\">","</div>\n      <div class=\"","dimensions\">","</div>\n    "])),t,n,t,a)},init:function(t){var e=this.pfx;this.className+=" ".concat(e,"asset-image")},onClick:function(){var t=this.model,e=this.pfx,n=this.__getBhv().select,r=this.config.onClick,i=this.collection;i.trigger('deselectAll'),this.$el.addClass(e+'highlight'),Object(o["isFunction"])(n)?n(t,!1):Object(o["isFunction"])(r)?r(t):this.updateTarget(i.target)},onDblClick:function(){var t=this.em,e=this.model,n=this.__getBhv().select,r=this.config.onDblClick,i=this.collection,a=i.target,s=i.onSelect;Object(o["isFunction"])(n)?n(e,!0):Object(o["isFunction"])(r)?r(e):(this.updateTarget(a),t&&t.get('Modal').close()),Object(o["isFunction"])(s)&&s(e)},onRemove:function(t){t.stopImmediatePropagation(),this.model.collection.remove(this.model)}}),L=n(38),N=l.a.Collection.extend(L["a"]).extend({types:[{id:'image',model:P,view:A,isType:function(t){return'string'==typeof t?{type:'image',src:t}:t}}]}),R=n(22),I=n.n(R),F=["pfx","ppfx","em"],V=l.a.View.extend({events:{submit:'handleSubmit'},template:function(t){var e=t.pfx,n=t.ppfx,r=t.em,i=(I()(t,F),'');return this.config.showUrlInput&&(i="\n          <form class=\"".concat(e,"add-asset\">\n            <div class=\"").concat(n,"field ").concat(e,"add-field\">\n              <input placeholder=\"").concat(r&&r.t('assetManager.inputPlh'),"\"/>\n            </div>\n            <button class=\"").concat(n,"btn-prim\">").concat(r&&r.t('assetManager.addButton'),"</button>\n            <div style=\"clear:both\"></div>\n          </form>\n      ")),"\n    <div class=\"".concat(e,"assets-cont\">\n      <div class=\"").concat(e,"assets-header\">\n        ").concat(i,"\n      </div>\n      <div class=\"").concat(e,"assets\" data-el=\"assets\"></div>\n      <div style=\"clear:both\"></div>\n    </div>\n    ")},initialize:function(t){this.options=t,this.config=t.config,this.pfx=this.config.stylePrefix||'',this.ppfx=this.config.pStylePrefix||'',this.em=this.config.em;var e=this.collection;this.listenTo(e,'reset',this.renderAssets),this.listenTo(e,'add',this.addToAsset),this.listenTo(e,'remove',this.removedAsset),this.listenTo(e,'deselectAll',this.deselectAll)},handleSubmit:function(t){t.preventDefault();var e=this.getAddInput(),n=e&&e.value.trim(),r=this.config.handleAdd;n&&(e.value='',this.getAssetsEl().scrollTop=0,r?r.bind(this)(n):this.options.globalCollection.add(n,{at:0}))},getAssetsEl:function(){return this.el.querySelector(".".concat(this.pfx,"assets"))},getAddInput:function(){return this.inputUrl&&this.inputUrl.value||(this.inputUrl=this.el.querySelector(".".concat(this.pfx,"add-asset input"))),this.inputUrl},removedAsset:function(t){this.collection.length||this.toggleNoAssets()},addToAsset:function(t){1==this.collection.length&&this.toggleNoAssets(1),this.addAsset(t)},addAsset:function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:null,n=e,r=this.collection,i=this.config,o=new t.typeView({model:t,collection:r,config:i}).render().el;if(n)n.appendChild(o);else{var a=this.getAssetsEl();a&&a.insertBefore(o,a.firstChild)}return o},toggleNoAssets:function(t){var e=this.$el.find(".".concat(this.pfx,"assets"));if(t)e.empty();else{var n=this.config.noAssets;n&&e.append(n)}},deselectAll:function(){var t=this.pfx;this.$el.find(".".concat(t,"highlight")).removeClass("".concat(t,"highlight"))},renderAssets:function(){var t=this,e=document.createDocumentFragment(),n=this.$el.find(".".concat(this.pfx,"assets"));n.empty(),this.toggleNoAssets(this.collection.length),this.collection.each((function(n){return t.addAsset(n,e)})),n.append(e)},render:function(){var t=this.options.fu.render().el;return this.$el.empty(),this.$el.append(t).append(this.template(this)),this.el.className="".concat(this.ppfx,"asset-manager"),this.renderAssets(),this}}),z=n(37);function H(t,e){var n="undefined"!=typeof Symbol&&t[Symbol.iterator]||t["@@iterator"];if(!n){if(Array.isArray(t)||(n=function(t,e){if(!t)return;if("string"==typeof t)return B(t,e);var n=Object.prototype.toString.call(t).slice(8,-1);"Object"===n&&t.constructor&&(n=t.constructor.name);if("Map"===n||"Set"===n)return Array.from(t);if("Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))return B(t,e)}(t))||e&&t&&"number"==typeof t.length){n&&(t=n);var r=0,i=function(){};return{s:i,n:function(){return r>=t.length?{done:!0}:{done:!1,value:t[r++]}},e:function(t){throw t},f:i}}throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}var o,a=!0,s=!1;return{s:function(){n=n.call(t)},n:function(){var t=n.next();return a=t.done,t},e:function(t){s=!0,o=t},f:function(){try{a||null==n.return||n.return()}finally{if(s)throw o}}}}function B(t,e){(null==e||e>t.length)&&(e=t.length);for(var n=0,r=new Array(e);n<e;n++)r[n]=t[n];return r}var U=l.a.View.extend({template:function(t){var e=t.pfx,n=t.title,r=t.uploadId,i=t.disabled,o=t.multiUpload;return Object(D["a"])(T||(T=_()(["\n        <form>\n          <div id=\"","title\">","</div>\n          <input\n            type=\"file\"\n            id=\"","\"\n            name=\"file\"\n            accept=\"*/*\"\n            ","\n            ","\n          />\n          <div style=\"clear:both;\"></div>\n        </form>\n      "])),e,n,r,i?'disabled':'',o?'multiple':'')},events:{},initialize:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};this.options=t;var e=t.config||{};this.module=e.module,this.config=e,this.em=this.config.em,this.pfx=e.stylePrefix||'',this.ppfx=e.pStylePrefix||'',this.target=this.options.globalCollection||{},this.uploadId=this.pfx+'uploadFile',this.disabled=void 0!==e.disableUpload?e.disableUpload:!e.upload&&!e.embedAsBase64,this.multiUpload=void 0===e.multiUpload||e.multiUpload,this.events['change #'+this.uploadId]='uploadFile';var n=e.uploadFile;n?this.uploadFile=n.bind(this):!e.upload&&e.embedAsBase64&&(this.uploadFile=this.constructor.embedAsBase64),this.delegateEvents()},onUploadStart:function(){var t=this.module;t&&t.__propEv('asset:upload:start')},onUploadEnd:function(t){var e=this.$el,n=this.module;n&&n.__propEv('asset:upload:end',t);var r=e.find('input');r&&r.val('')},onUploadError:function(t){var e=this.module;console.error(t),this.onUploadEnd(t),e&&e.__propEv('asset:upload:error',t)},onUploadResponse:function(t,e){var n,r=this.module,i=this.config,o=this.target;try{n='string'==typeof t?JSON.parse(t):t}catch(e){n=t}r&&r.__propEv('asset:upload:response',n),i.autoAdd&&o&&o.add(n.data,{at:0}),this.onUploadEnd(t),e&&e(n)},uploadFile:function(t,e){var n=this,r=t.dataTransfer?t.dataTransfer.files:t.target.files,i=this.config,o=i.beforeUpload;if(!1!==(o&&o(r))){var a=new FormData,s=i.params,c=i.customFetch;for(var l in s)a.append(l,s[l]);if(this.multiUpload)for(var u=0;u<r.length;u++)a.append("".concat(i.uploadName,"[]"),r[u]);else r.length&&a.append(i.uploadName,r[0]);this.target;var d=i.upload,h=i.headers,f='X-Requested-With';if(void 0===h[f]&&(h[f]='XMLHttpRequest'),d){this.onUploadStart();var p={method:'post',credentials:i.credentials||'include',headers:h,body:a};return(c?c(d,p):Object(z["a"])(d,p).then((function(t){return 1==(t.status/200|0)?t.text():t.text().then((function(t){return Promise.reject(t)}))}))).then((function(t){return n.onUploadResponse(t,e)})).catch((function(t){return n.onUploadError(t)}))}}},initDrop:function(){var t=this;if(!this.uploadForm&&(this.uploadForm=this.$el.find('form').get(0),'draggable'in this.uploadForm)){this.uploadFile;this.uploadForm.ondragover=function(){return this.className=t.pfx+'hover',!1},this.uploadForm.ondragleave=function(){return this.className='',!1},this.uploadForm.ondrop=function(e){this.className='',e.preventDefault(),t.uploadFile(e)}}},initDropzone:function(t){var e=this,n=0,r=this.config,i=t.model,o=t.el,a=i.get('Editor'),s=(i.get('Config').el,i.get('Canvas').getBody()),c=this.ppfx,l="".concat(c,"dropzone-active"),u="".concat(c,"dropzone"),d=function(){o.className=o.className.replace(l,'').trim(),n=0},h=function(){return n||(o.className+=" ".concat(l),n=1),!1},f=function(){return d(),!1},p=function(t){if(d(),t.preventDefault(),t.stopPropagation(),e.uploadFile(t),r.openAssetsOnDrop&&a){var n=a.getSelected();a.runCommand('open-assets',{target:n,onSelect:function(){a.Modal.close(),a.AssetManager.setTarget(null)}})}return!1};t.$el.append("<div class=\"".concat(u,"\">").concat(r.dropzoneContent,"</div>")),d(),'draggable'in o&&[o,s].forEach((function(t){t.ondragover=h,t.ondragleave=f,t.ondrop=p}))},render:function(){var t=this.$el,e=this.pfx,n=this.em;return t.html(this.template({title:n&&n.t('assetManager.uploadTitle'),uploadId:this.uploadId,disabled:this.disabled,multiUpload:this.multiUpload,pfx:e})),this.initDrop(),t.attr('class',e+'file-uploader'),this}},{embedAsBase64:function(t,e){var n=this,r=t.dataTransfer?t.dataTransfer.files:t.target.files,i={data:[]};if(FileReader){var o,a=[],s=/^(.+)\/(.+)$/,c=H(r);try{var l=function(){var t=o.value,e=new Promise((function(e,n){var r=new FileReader;r.addEventListener('load',(function(i){var o,a=t.name,c=s.exec(t.type);if('image'===(o=c?c[1]:t.type)){var l={src:r.result,name:a,type:o,height:0,width:0},u=new Image;u.addEventListener('error',(function(t){n(t)})),u.addEventListener('load',(function(){l.height=u.height,l.width=u.width,e(l)})),u.src=l.src}else e(o?{src:r.result,name:a,type:o}:r.result)})),r.addEventListener('error',(function(t){n(t)})),r.addEventListener('abort',(function(t){n('Aborted')})),r.readAsDataURL(t)}));a.push(e)};for(c.s();!(o=c.n()).done;)l()}catch(t){c.e(t)}finally{c.f()}Promise.all(a).then((function(t){i.data=t,n.onUploadResponse(i,e)}),(function(t){n.onUploadError(t)}))}else this.onUploadError(new Error('Unsupported platform, FileReader is not defined'))}});function $(t,e){var n=Object.keys(t);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(t);e&&(r=r.filter((function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable}))),n.push.apply(n,r)}return n}function W(t){for(var e=1;e<arguments.length;e++){var n=null!=arguments[e]?arguments[e]:{};e%2?$(Object(n),!0).forEach((function(e){i()(t,e,n[e])})):Object.getOwnPropertyDescriptors?Object.defineProperties(t,Object.getOwnPropertyDescriptors(n)):$(Object(n)).forEach((function(e){Object.defineProperty(t,e,Object.getOwnPropertyDescriptor(n,e))}))}return t}var q='asset',G="".concat(q,":"),K="".concat(G,"select"),Y="".concat(G,"update"),X="".concat(G,"add"),J="".concat(G,"remove"),Z="".concat(J,":before"),Q="".concat(G,"custom"),tt="".concat(G,"open"),et="".concat(G,"close");e["default"]=function(){var t,e,n,r,i={},c='open-assets';return W(W({},a["a"]),{},{name:'AssetManager',storageKey:'assets',Asset:N,Assets:N,events:{all:q,select:K,update:Y,add:X,remove:J,removeBefore:Z,custom:Q,open:tt,close:et},init:function(){var n=this,r=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},o=(i=W(W({},s),r)).pStylePrefix,a=i,c=a.em;return this.config=i,this.em=c,o&&(i.stylePrefix=o+i.stylePrefix),t=new N([]),e=new N([]),this.all=t,this.__initListen(),t.on('add',(function(t){return n.getAllVisible().add(t)})),t.on('remove',(function(t){return n.getAllVisible().remove(t)})),this},__propEv:function(t){for(var e,n,r=arguments.length,i=new Array(r>1?r-1:0),o=1;o<r;o++)i[o-1]=arguments[o];(e=this.em).trigger.apply(e,[t].concat(i)),(n=this.getAll()).trigger.apply(n,[t].concat(i))},__onAllEvent:Object(o["debounce"])((function(){this.__trgCustom()})),__trgCustom:function(){(this.__getBehaviour().container||this.getConfig('custom').open)&&this.em.trigger(this.events.custom,this.__customData())},__customData:function(){var t=this,e=this.__getBehaviour();return{am:this,open:this.isOpen(),assets:this.getAll().models,types:e.types||[],container:e.container,close:function(){return t.close()},remove:function(){return t.remove.apply(t,arguments)},select:function(n,r){var i=t.add(n);Object(o["isFunction"])(e.select)&&e.select(i,r)},options:e.options||{}}},open:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},e=this.em.get('Commands');e.run(c,W({types:['image'],select:function(){}},t))},close:function(){this.em.get('Commands').stop(c)},isOpen:function(){var t=this.em.get('Commands');return!(!t||!t.isActive(c))},add:function(e){var n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};return void 0===n.at&&(n.at=0),t.add(e,n)},get:function(e){return t.where({src:e})[0]||null},getAll:function(){return t},getAllVisible:function(){return e},remove:function(t,e){return this.__remove(t,e)},store:function(t){var e={},n=JSON.stringify(this.getAll().toJSON());return e[this.storageKey]=n,!t&&i.stm&&i.stm.store(e),e},load:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},e=this.storageKey,n=t[e]||[];if('string'==typeof n)try{n=JSON.parse(t[e])}catch(t){}return n&&n.length&&this.getAll().reset(n),n},getContainer:function(){return this.__getBehaviour().container||n&&n.el},getAssetsEl:function(){return n.el.querySelector('[data-el=assets]')},render:function(o){if(!this.getConfig('custom')){var a=o||this.getAll().models;if(!n){var s={collection:e,globalCollection:t,config:i,module:this};r=new U(s),s.fu=r;var c=n&&n.el;(n=new V(W({el:c},s))).render()}return e.reset(a),this.getContainer()}},addType:function(t,e){this.getAll().addType(t,e)},getType:function(t){return this.getAll().getType(t)},getTypes:function(){return this.getAll().getTypes()},AssetsView:function(){return n},FileUploader:function(){return r},onLoad:function(){var t=this;this.getAll().reset(i.assets);var e=this.em,n=this.events;e.on("run:".concat(c),(function(){return t.__propEv(n.open)})),e.on("stop:".concat(c),(function(){return t.__propEv(n.close)}))},postRender:function(t){i.dropzone&&r&&r.initDropzone(t)},setTarget:function(t){e.target=t},onSelect:function(t){e.onSelect=t},onClick:function(t){i.onClick=t},onDblClick:function(t){i.onDblClick=t},__behaviour:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};return this._bhv=W(W({},this._bhv||{}),t)},__getBehaviour:function(){return this._bhv||{}},destroy:function(){t.stopListening(),e.stopListening(),t.reset(),e.reset(),r&&r.remove(),n&&n.remove(),[t,n,r].forEach((function(t){return null})),this._bhv={},i={}}})}},function(t,e,n){"use strict";n.r(e);var r=n(3),i=n.n(r),o=n(0),a={stylePrefix:'trt-',appendTo:'',optionsTarget:[{value:!1},{value:'_blank'}]},s=n(29),c=n(41),l=n.n(c),u=n(2),d=n.n(u),h=n(1);function f(t,e){var n=Object.keys(t);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(t);e&&(r=r.filter((function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable}))),n.push.apply(n,r)}return n}function p(t){for(var e=1;e<arguments.length;e++){var n=null!=arguments[e]?arguments[e]:{};e%2?f(Object(n),!0).forEach((function(e){i()(t,e,n[e])})):Object.getOwnPropertyDescriptors?Object.defineProperties(t,Object.getOwnPropertyDescriptors(n)):f(Object(n)).forEach((function(e){Object.defineProperty(t,e,Object.getOwnPropertyDescriptor(n,e))}))}return t}var g=d.a.$,v=d.a.View.extend({events:{},eventCapture:['change'],appendInput:1,attributes:function(){return this.model.get('attributes')},templateLabel:function(){var t=this.ppfx,e=this.getLabel();return"<div class=\"".concat(t,"label\" title=\"").concat(e,"\">").concat(e,"</div>")},templateInput:function(){var t=this.clsField;return"<div class=\"".concat(t,"\" data-input></div>")},initialize:function(){var t=this,e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},n=e.config,r=void 0===n?{}:n,i=this.model,o=this.eventCapture,a=i.target,s=i.attributes.type;this.config=r,this.em=r.em,this.pfx=r.stylePrefix||'',this.ppfx=r.pStylePrefix||'',this.target=a;var c=this.ppfx;this.clsField="".concat(c,"field ").concat(c,"field-").concat(s),[['change:value',this.onValueChange],['remove',this.removeView]].forEach((function(e){var n=l()(e,2),r=n[0],o=n[1];i.off(r,o),t.listenTo(i,r,o)})),i.view=this,this.listenTo(i,'change:label',this.render),this.listenTo(i,'change:placeholder',this.rerender),this.events={},o.forEach((function(e){return t.events[e]='onChange'})),this.delegateEvents(),this.init()},getClbOpts:function(){return{component:this.target,trait:this.model,elInput:this.getInputElem()}},removeView:function(){this.remove(),this.removed()},init:function(){},removed:function(){},onRender:function(){},onUpdate:function(){},onEvent:function(){},onChange:function(t){var e=this.getInputElem();e&&!Object(o["isUndefined"])(e.value)&&this.model.set('value',e.value),this.onEvent(p(p({},this.getClbOpts()),{},{event:t}))},getValueForTarget:function(){return this.model.get('value')},setInputValue:function(t){var e=this.getInputElem();e&&(e.value=t)},onValueChange:function(t,e){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};if(n.fromTarget)this.setInputValue(t.get('value')),this.postUpdate();else{var r=this.getValueForTarget();t.setTargetValue(r,n)}},renderLabel:function(){var t=this.$el,e=this.target,n=this.getLabel(),r=this.templateLabel(e);this.createLabel&&(r=this.createLabel({label:n,component:e,trait:this})||''),t.find('[data-label]').append(r)},getLabel:function(){var t=this.em,e=this.model.attributes,n=e.label,r=e.name;return t.t("traitManager.traits.labels.".concat(r))||Object(h["capitalize"])(n||r).replace(/-/g,' ')},getComponent:function(){return this.target},getInputEl:function(){if(!this.$input){var t=this.em,e=this.model,n=e,r=e.attributes.name,i=n.get('placeholder')||n.get('default')||'',a=n.get('type')||'text',s=n.get('min'),c=n.get('max'),l=this.getModelValue(),u=g("<input type=\"".concat(a,"\" placeholder=\"").concat(i,"\">")),d=t.t("traitManager.traits.attributes.".concat(r))||{};u.attr(d),Object(o["isUndefined"])(l)||(n.set({value:l},{silent:!0}),u.prop('value',l)),s&&u.prop('min',s),c&&u.prop('max',c),this.$input=u}return this.$input.get(0)},getInputElem:function(){var t=this.input,e=this.$input;return t||e&&e.get&&e.get(0)||this.getElInput()},getModelValue:function(){var t,e=this.model,n=this.target,r=e.get('name');if(e.get('changeProp'))t=n.get(r);else{var i=n.get('attributes');t=e.get('value')||i[r]}return Object(o["isUndefined"])(t)?'':t},getElInput:function(){return this.elInput},renderField:function(){var t=this.$el,e=this.appendInput,n=this.model,r=t.find('[data-input]'),i=r[r.length-1],a=n.el;a||(a=this.createInput?this.createInput(this.getClbOpts()):this.getInputEl()),Object(o["isString"])(a)?(i.innerHTML=a,this.elInput=i.firstChild):(e?i.appendChild(a):i.insertBefore(a,i.firstChild),this.elInput=a),n.el=this.elInput},hasLabel:function(){var t=this.model.attributes.label;return!this.noLabel&&!1!==t},rerender:function(){this.model.el=null,this.render()},postUpdate:function(){this.onUpdate(this.getClbOpts())},render:function(){var t=this.$el,e=this.pfx,n=this.ppfx,r=this.model.attributes,i=r.type,a=r.id,s=this.hasLabel&&this.hasLabel(),c="".concat(e,"trait");this.$input=null;var l="<div class=\"".concat(c," ").concat(c,"--").concat(i,"\">\n      ").concat(s?"<div class=\"".concat(n,"label-wrp\" data-label></div>"):'',"\n      <div class=\"").concat(n,"field-wrp ").concat(n,"field-wrp--").concat(i,"\" data-input>\n        ").concat(this.templateInput?Object(o["isFunction"])(this.templateInput)?this.templateInput(this.getClbOpts()):this.templateInput:'',"\n      </div>\n    </div>");return t.empty().append(l),s&&this.renderLabel(),this.renderField(),this.el.className="".concat(c,"__wrp ").concat(c,"__wrp-").concat(a),this.postUpdate(),this.onRender(this.getClbOpts()),this}}),m=s["a"].extend({ns:'Traits',itemView:v,reuseView:1,initialize:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},e=t.config||{},n=e.stylePrefix||'',r=t.editor;this.config=e,this.em=r,this.pfx=n,this.ppfx=e.pStylePrefix||'',this.className="".concat(n,"traits"),this.listenTo(r,'component:toggled',this.updatedCollection)},updatedCollection:function(){var t=this.ppfx,e=this.className,n=this.em.getSelected();this.el.className="".concat(e," ").concat(t,"one-bg ").concat(t,"two-color"),this.collection=n?n.get('traits'):[],this.render()}}),y=d.a.$,b=v.extend({init:function(){this.listenTo(this.model,'change:options',this.rerender)},templateInput:function(){var t=this.ppfx,e=this.clsField;return"<div class=\"".concat(e,"\">\n      <div data-input></div>\n      <div class=\"").concat(t,"sel-arrow\">\n        <div class=\"").concat(t,"d-s-arrow\"></div>\n      </div>\n    </div>")},getInputEl:function(){if(!this.$input){var t=this.model,e=this.em,n=t.get('name'),r=t.get('options')||[],i=[],a='<select>';r.forEach((function(t){var r,s,c,l='';Object(o["isString"])(t)?(r=t,s=t):(r=t.name||t.label||t.value,s="".concat(Object(o["isUndefined"])(t.value)?t.id:t.value).replace(/"/g,'&quot;'),l+=(c=t.style?t.style.replace(/"/g,'&quot;'):'')?" style=\"".concat(c,"\""):'');var u=e.t("traitManager.traits.options.".concat(n,".").concat(s))||r;a+="<option value=\"".concat(s,"\"").concat(l,">").concat(u,"</option>"),i.push(s)})),a+='</select>',this.$input=y(a);var s=t.getTargetValue(),c=i.indexOf(s)>=0?s:t.get('default');!Object(o["isUndefined"])(c)&&this.$input.val(c)}return this.$input.get(0)}}),w=v.extend({appendInput:0,templateInput:function(){var t=this.ppfx,e=this.clsField;return"<label class=\"".concat(e,"\" data-input>\n    <i class=\"").concat(t,"chk-icon\"></i>\n  </label>")},onChange:function(){var t=this.getInputElem().checked;this.model.set('value',this.getCheckedValue(t))},getCheckedValue:function(t){var e=t,n=this.model.attributes,r=n.valueTrue,i=n.valueFalse;return e&&!Object(o["isUndefined"])(r)&&(e=r),e||Object(o["isUndefined"])(i)||(e=i),e},getInputEl:function(){for(var t=!this.$input,e=arguments.length,n=new Array(e),r=0;r<e;r++)n[r]=arguments[r];var i=v.prototype.getInputEl.apply(this,n);if(t){var a,s,c=this.model,l=this.target,u=c.attributes,d=(u.valueTrue,u.valueFalse),h=c.get('name');c.get('changeProp')?s=a=l.get(h):a=!(!(s=l.get('attributes')[h])&&''!==s),Object(o["isUndefined"])(d)||s!==d||(a=!1),i.checked=a}return i}}),O=n(40),x=v.extend({getValueForTarget:function(){var t=this.model,e=t.attributes,n=e.value,r=e.unit;return Object(o["isUndefined"])(n)||''===n?t.get('default'):n+r},getInputEl:function(){if(!this.input){var t=this.ppfx,e=this.model,n=this.getModelValue(),r=new O["a"]({contClass:"".concat(t,"field-int"),type:'number',model:e,ppfx:t});this.input=r.render(),this.$input=this.input.inputEl,this.$unit=this.input.unitEl,e.set('value',n,{fromTarget:1}),this.$input.val(n),this.input=r.el}return this.input}}),C=n(45),k=v.extend({templateInput:'',getInputEl:function(){if(!this.input){var t=this.model,e=this.getModelValue(),n=new C["a"]({model:t,target:this.config.em,contClass:this.ppfx+'field-color',ppfx:this.ppfx}).render();n.setValue(e,{fromTarget:1}),this.input=n.el}return this.input}}),S=v.extend({eventCapture:['click button'],templateInput:'',onChange:function(){this.handleClick()},handleClick:function(){var t=this.model,e=this.em,n=t.get('command');n&&(Object(o["isString"])(n)?e.get('Commands').run(n):n(e.get('Editor'),t))},renderLabel:function(){this.model.get('label')&&v.prototype.renderLabel.apply(this,arguments)},getInputEl:function(){var t=this.model,e=this.ppfx,n=t.props(),r=n.labelButton,i=n.text,o=n.full,a=r||i,s="".concat(e,"btn");return"<button type=\"button\" class=\"".concat(s,"-prim").concat(o?" ".concat(s,"--full"):'',"\">").concat(a,"</button>")}});function j(t,e){var n=Object.keys(t);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(t);e&&(r=r.filter((function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable}))),n.push.apply(n,r)}return n}function T(t){for(var e=1;e<arguments.length;e++){var n=null!=arguments[e]?arguments[e]:{};e%2?j(Object(n),!0).forEach((function(e){i()(t,e,n[e])})):Object.getOwnPropertyDescriptors?Object.defineProperties(t,Object.getOwnPropertyDescriptors(n)):j(Object(n)).forEach((function(e){Object.defineProperty(t,e,Object.getOwnPropertyDescriptor(n,e))}))}return t}e["default"]=function(){var t,e={},n={text:v,number:x,select:b,checkbox:w,color:k,button:S};return{TraitsView:m,name:'TraitManager',getConfig:function(){return e},init:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};e=t,Object(o["defaults"])(e,a);var r=e.pStylePrefix;return this.types=T({},n),r&&(e.stylePrefix="".concat(r).concat(e.stylePrefix)),this},postRender:function(){var t=this.getConfig().appendTo;t&&(Object(o["isElement"])(t)?t:document.querySelector(t)).appendChild(this.render())},getTraitsViewer:function(){return t},addType:function(t,e){var n=this.getType('text');this.types[t]=n.extend(e)},getType:function(t){return this.getTypes()[t]},getTypes:function(){return this.types},render:function(){var n=t&&t.el;return(t=new m({el:n,collection:[],editor:e.em,config:e})).itemsView=this.getTypes(),t.updatedCollection(),t.el},destroy:function(){t&&t.remove(),[e,t].forEach((function(t){return{}}))}}}},function(t,e,n){"use strict";n.r(e),n.d(e,"evAll",(function(){return H})),n.d(e,"evPfx",(function(){return B})),n.d(e,"evAdd",(function(){return U})),n.d(e,"evUpdate",(function(){return $})),n.d(e,"evRemove",(function(){return W})),n.d(e,"evRemoveBefore",(function(){return q})),n.d(e,"evDrag",(function(){return G})),n.d(e,"evDragStart",(function(){return K})),n.d(e,"evDragStop",(function(){return Y})),n.d(e,"evCustom",(function(){return X}));var r=n(3),i=n.n(r),o=n(0),a=n(21),s={appendTo:'',appendOnClick:!1,blocks:[],custom:!1},c=n(5),l=n.n(c),u=n(6),d=n.n(u),h=n(8),f=n.n(h),p=n(9),g=n.n(p),v=n(4),m=n.n(v),y=n(2),b=n.n(y);function w(t){var e=function(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],(function(){}))),!0}catch(t){return!1}}();return function(){var n,r=m()(t);if(e){var i=m()(this).constructor;n=Reflect.construct(r,arguments,i)}else n=r.apply(this,arguments);return g()(this,n)}}var O=function(t){f()(n,t);var e=w(n);function n(){return l()(this,n),e.apply(this,arguments)}return d()(n,[{key:"defaults",value:function(){return{label:'',content:'',media:'',category:'',activate:!1,select:null,resetId:!1,disable:!1,onClick:null,attributes:{}}}},{key:"getId",value:function(){return this.id}},{key:"getLabel",value:function(){return this.get('label')}},{key:"getMedia",value:function(){return this.get('media')}},{key:"getContent",value:function(){return this.get('content')}},{key:"getCategoryLabel",value:function(){var t=this.get('category');return Object(o["isFunction"])(t.get)?t.get('label'):t.label?t.label:t}}]),n}(y["Model"]);function x(t){var e=function(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],(function(){}))),!0}catch(t){return!1}}();return function(){var n,r=m()(t);if(e){var i=m()(this).constructor;n=Reflect.construct(r,arguments,i)}else n=r.apply(this,arguments);return g()(this,n)}}var C=function(t){f()(n,t);var e=x(n);function n(){return l()(this,n),e.apply(this,arguments)}return n}(y["Collection"]);function k(t){var e=function(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],(function(){}))),!0}catch(t){return!1}}();return function(){var n,r=m()(t);if(e){var i=m()(this).constructor;n=Reflect.construct(r,arguments,i)}else n=r.apply(this,arguments);return g()(this,n)}}C.prototype.model=O;var S=function(t){f()(n,t);var e=k(n);function n(){return l()(this,n),e.apply(this,arguments)}return d()(n,[{key:"defaults",value:function(){return{id:'',label:'',open:!0,attributes:{}}}}]),n}(y["Model"]);function j(t){var e=function(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],(function(){}))),!0}catch(t){return!1}}();return function(){var n,r=m()(t);if(e){var i=m()(this).constructor;n=Reflect.construct(r,arguments,i)}else n=r.apply(this,arguments);return g()(this,n)}}var T=function(t){f()(n,t);var e=j(n);function n(){return l()(this,n),e.apply(this,arguments)}return n}(y["Collection"]);T.prototype.model=S;var P,E=n(1),_=b.a.View.extend({events:{click:'handleClick',mousedown:'startDrag',dragstart:'handleDragStart',drag:'handleDrag',dragend:'handleDragEnd'},initialize:function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},n=this.model;this.em=e.em,this.config=e,this.endDrag=this.endDrag.bind(this),this.ppfx=e.pStylePrefix||'',this.listenTo(n,'destroy remove',this.remove),this.listenTo(n,'change',this.render)},__getModule:function(){return this.em.get('BlockManager')},handleClick:function(t){var e=this.config,n=this.model,r=this.em,i=n.get('onClick')||e.appendOnClick;if(r.trigger('block:click',n,t),i){if(Object(o["isFunction"])(i))return i(n,r.getEditor(),{event:t});var a,s=e.getSorter(),c=n.get('content'),l=r.getSelected();if(s.setDropContent(c),l)if(s.validTarget(l.getEl(),c).valid)a=l;else{var u=l.parent();s.validTarget(u.getEl(),c).valid&&(a=u)}if(!a){var d=r.getWrapper();s.validTarget(d.getEl(),c).valid&&(a=d)}var h=a&&a.append(c)[0];h&&r.setSelected(h,{scroll:1})}},startDrag:function(t){var e=this.config,n=this.em,r=this.model.get('disable');if(0===t.button&&e.getSorter&&!this.el.draggable&&!r){n.refreshCanvas();var i=e.getSorter();i.setDragHelper(this.el,t),i.setDropContent(this.model.get('content')),i.startSort(this.el),Object(E["on"])(document,'mouseup',this.endDrag)}},handleDragStart:function(t){this.__getModule().__startDrag(this.model,t)},handleDrag:function(t){this.__getModule().__drag(t)},handleDragEnd:function(){this.__getModule().__endDrag()},endDrag:function(t){Object(E["off"])(document,'mouseup',this.endDrag);var e=this.config.getSorter();e.moved=0,e.endMove()},render:function(){var t=this.em,e=this.el,n=this.$el,r=this.ppfx,i=this.model,o=i.get('disable'),a=i.get('attributes')||{},s=a.class||'',c="".concat(r,"block"),l=t&&t.t("blockManager.labels.".concat(i.id))||i.get('label'),u=i.get('render'),d=i.get('media'),h=o?"".concat(c,"--disable"):"".concat(r,"four-color-h");n.a