type DecorationProps = {
  className: string;
};

export default function Decoration({ className }: DecorationProps) {
  return (
    <div className={className}>
      <svg
        viewBox="0 0 200 239"
        version="1.1"
        xmlns="http://www.w3.org/2000/svg"
      >
        <title>形状结合</title>
        <defs>
          <rect id="path-1" x="0" y="0" width="1879" height="1080" rx="8" />
          <filter
            x="-3.3%"
            y="-5.1%"
            width="106.9%"
            height="112.0%"
            filterUnits="objectBoundingBox"
            id="filter-2"
          >
            <feMorphology
              radius="5"
              operator="dilate"
              in="SourceAlpha"
              result="shadowSpreadOuter1"
            />
            <feOffset
              dx="3"
              dy="10"
              in="shadowSpreadOuter1"
              result="shadowOffsetOuter1"
            />
            <feGaussianBlur
              stdDeviation="15"
              in="shadowOffsetOuter1"
              result="shadowBlurOuter1"
            />
            <feColorMatrix
              values="0 0 0 0 0.960215693   0 0 0 0 0.936679918   0 0 0 0 0.889608369  0 0 0 1 0"
              type="matrix"
              in="shadowBlurOuter1"
            />
          </filter>
        </defs>
        <g
          id="页面-1"
          stroke="none"
          strokeWidth="1"
          fill="none"
          fillRule="evenodd"
        >
          <g id="编组-4" transform="translate(-1893.000000, -577.000000)">
            <rect
              id="矩形"
              fill="#FFFFFF"
              x="0"
              y="0"
              width="3202"
              height="1852"
            />
            <g id="screen" transform="translate(213.000000, 577.000000)">
              <g id="38">
                <g id="蒙版">
                  <use
                    fill="black"
                    fillOpacity="1"
                    filter="url(#filter-2)"
                    xlinkHref="#path-1"
                  />
                  <use fill="#FFFEFC" fillRule="evenodd" xlinkHref="#path-1" />
                </g>
                <path
                  d="M1827.84563,178.362611 C1828.90884,178.611451 1830.01024,178.844901 1830.96736,179.334263 C1831.46878,179.591011 1831.98688,179.717515 1832.44047,179.932228 C1834.20272,180.76531 1836.22638,181.138576 1837.60706,182.73317 C1837.94452,183.122249 1838.64737,183.08355 1839.17712,183.439335 C1844.17353,186.795805 1847.32359,191.402757 1848.27107,197.311679 C1849.19615,203.080453 1849.41295,208.898254 1848.02935,214.665421 C1847.71812,215.962418 1847.1093,217.105102 1846.51385,218.291488 C1845.83009,219.654289 1844.93665,220.922252 1844.44729,222.386121 C1844.34251,222.69947 1844.20849,223.057827 1843.973,223.263377 C1842.55896,224.498388 1841.57401,226.11004 1840.24154,227.422509 C1838.73598,228.905566 1837.08857,230.163181 1835.32833,231.323748 C1833.93971,232.23918 1832.6627,233.342783 1831.31979,234.323116 C1829.68111,235.518644 1827.68579,236.104955 1825.7625,236.770332 C1823.98809,237.38417 1822.1509,237.680842 1820.31039,237.986656 C1820.00748,238.036688 1819.75612,238.215113 1819.52807,237.854344 C1819.46608,237.756191 1819.2547,237.659644 1819.15444,237.692496 C1816.25192,238.654143 1812.38986,237.734088 1810.05497,236.521984 C1807.1209,234.998539 1804.43769,233.089311 1802.30503,230.585936 C1800.58232,228.563083 1799.38055,226.181269 1798.7185,223.533024 C1798.20874,221.495201 1797.63615,219.481189 1797.28577,217.401774 C1796.79808,214.511409 1797.58039,211.930575 1799.01728,209.49632 C1800.22445,207.45056 1801.57644,205.499338 1803.00497,203.595636 C1804.43478,201.689321 1806.54333,200.892436 1808.62897,200.229973 C1811.13064,199.435198 1813.75598,199.087289 1816.41799,199.189663 C1818.2814,199.261294 1819.86261,199.920844 1821.2009,201.199154 C1823.04101,202.956882 1824.37217,205.062418 1825.42333,207.361549 C1826.30179,209.284038 1826.33755,211.390076 1826.73409,213.415341 C1826.82903,213.896767 1826.50151,214.242566 1825.92183,214.282953 C1825.43036,214.317111 1825.04337,214.523465 1825.23857,215.144737 C1825.31553,215.144737 1825.3526,215.147651 1825.38877,215.144336 C1825.86316,215.102743 1825.93017,214.149335 1826.52773,214.540544 C1827.06874,214.895083 1826.92306,215.550514 1826.87685,216.114723 C1826.68215,218.487896 1825.80409,220.562288 1824.02144,222.161884 C1822.54371,223.487212 1821.23124,224.964945 1819.20397,225.659858 C1815.11094,227.06385 1813.08397,225.873747 1810.10158,223.113585 C1809.12165,222.206792 1808.82618,220.925166 1808.36716,219.733757 C1806.99773,216.180929 1809.673,213.797307 1812.67197,213.764857 C1812.34787,214.981583 1810.72536,214.733235 1810.17813,215.994466 C1811.20016,215.685337 1811.84183,215.087372 1812.60415,214.735244 C1812.94372,214.578419 1813.54259,214.164806 1813.67691,214.59168 C1813.83635,215.098122 1814.67895,215.304175 1814.09766,216.307815 C1813.4785,217.37726 1812.79514,218.533306 1812.45938,219.787003 C1812.17306,220.854439 1812.86677,221.69161 1813.93119,221.597575 C1816.91067,221.335463 1819.47894,220.050421 1821.55042,218.00858 C1822.88911,216.689782 1823.25329,214.76026 1823.10471,212.880568 C1822.94778,210.904431 1822.85706,208.900364 1822.04069,207.028207 C1821.79515,206.466008 1820.64835,204.442049 1820.14442,204.064604 C1819.76406,203.779988 1819.31418,203.643859 1818.81447,203.646772 C1818.55728,203.648078 1818.13282,203.921442 1818.08831,203.284798 C1818.06711,202.980993 1817.52983,202.971449 1817.50943,203.214473 C1817.44082,204.029642 1816.81331,203.824896 1816.41467,203.849007 C1814.22625,203.979711 1812.18763,204.788652 1810.06953,205.230595 C1809.20564,205.41113 1808.44834,206.036221 1808.16784,206.983702 C1808.04055,207.413188 1807.79753,207.776467 1807.46459,207.979506 C1805.73308,209.033982 1805.26371,210.877808 1804.44312,212.529846 C1803.95627,213.509778 1803.03993,214.235533 1802.70036,215.354106 C1802.14157,217.19542 1802.11033,219.063357 1802.51269,220.891811 C1802.95795,222.912957 1803.46982,224.942441 1804.32829,226.838307 C1805.57083,229.581391 1807.96229,230.940073 1810.66217,231.905839 C1811.707,232.279969 1812.90916,232.063568 1813.87834,232.856334 C1814.02984,232.980307 1814.9287,232.489237 1815.55198,232.42936 C1821.46764,231.860128 1826.76322,229.621778 1831.76756,226.501651 C1834.98343,224.49678 1837.39398,221.771579 1839.50916,218.70932 C1842.72171,214.058716 1843.67291,208.768454 1843.79066,203.278569 C1843.84933,200.523329 1843.77117,197.759048 1843.4116,195.012649 C1842.89522,191.067708 1840.87286,188.233101 1837.37941,186.31892 C1835.78323,185.443813 1834.13913,184.636942 1832.54034,183.775981 C1831.89616,183.428937 1830.90166,182.92792 1829.76058,183.175093 C1828.769,183.389816 1827.59758,182.825969 1826.46283,182.792263 C1825.24149,182.756477 1824.04264,182.281672 1822.79427,182.611246 C1822.47218,182.696138 1822.40015,182.589606 1822.57787,182.266693 C1822.7152,182.017018 1822.40145,181.884274 1822.28863,181.986226 C1821.27002,182.900041 1819.8156,182.10815 1818.71752,182.994086 C1818.05455,183.528798 1817.8482,182.259208 1817.10416,182.087765 C1817.15198,182.65327 1817.52902,183.358612 1816.41005,182.959546 C1815.8154,182.747315 1815.47834,183.722303 1814.67071,183.813847 C1814.2371,183.862532 1813.52923,184.092656 1812.96201,184.279078 C1812.59129,184.401413 1812.11941,184.257438 1811.98871,184.808385 C1811.94832,184.97817 1811.83017,185.098426 1811.66501,185.003548 C1810.82272,184.5196 1810.27177,185.202045 1809.66838,185.529952 C1807.20499,186.870299 1804.8293,188.398767 1802.7528,190.255854 C1799.78586,192.909122 1796.97867,195.753273 1794.60593,198.981199 C1794.5614,199.04198 1794.53852,199.143047 1794.48109,199.166757 C1793.94637,199.386875 1794.57555,200.88249 1793.32926,200.271565 C1791.62772,199.438112 1791.23864,198.694071 1791.88489,197.429926 C1792.64473,195.943453 1793.4724,194.486214 1794.35084,193.065545 C1797.53379,187.91724 1801.98545,184.088075 1807.19625,181.151476 C1810.70577,179.173631 1814.57497,178.204067 1818.59345,177.917774 C1821.69157,177.696806 1824.79291,177.646871 1827.84563,178.362611 Z M1836.33538,224.359445 C1832.4896,228.240591 1827.62631,230.387418 1822.82049,232.690266 C1823.77922,232.392288 1824.75504,232.139721 1825.69378,231.788095 C1829.45185,230.380386 1832.7492,228.156201 1835.97672,225.834164 C1836.25129,225.636551 1836.90592,225.076863 1836.33538,224.359445 Z M1821.66826,218.946014 C1820.4003,220.583084 1818.50896,221.277595 1816.79875,222.402396 C1817.28309,222.253005 1817.7612,222.077795 1818.25267,221.959247 C1819.78445,221.59014 1820.76569,220.357139 1822.03154,219.571506 C1822.26121,219.428746 1822.35353,219.108365 1822.20545,218.864537 C1822.02481,218.566158 1821.79847,218.778741 1821.66826,218.946014 Z M1808.36264,201.822939 C1807.07057,201.935258 1806.0623,202.591492 1805.16807,203.465735 C1806.40891,203.255664 1807.32725,202.427936 1808.36264,201.822939 Z M1796.82512,191.436814 C1801.27101,186.982619 1805.98947,182.916266 1811.99875,180.665027 C1808.70884,180.374986 1798.32858,187.995502 1796.82512,191.436814 Z M1809.85946,184.271583 C1809.46614,184.246206 1809.24311,184.469247 1809.07333,184.773022 C1809.00099,184.902852 1808.95397,185.110492 1809.11793,185.156264 C1809.41913,185.240322 1809.66798,185.09052 1809.89563,184.870392 C1810.127,184.647351 1810.55518,184.776347 1810.85567,184.27533 C1810.44326,184.27533 1810.15031,184.29031 1809.85946,184.271583 Z M1879.99908,0.00193867399 L1879.99891,18.99493 C1879.50355,19.4096513 1879.04928,19.8744027 1878.72665,20.5136138 C1879.0256,20.601995 1879.02699,20.9312221 1879.4161,20.9305799 C1879.63117,20.9297029 1879.81789,20.8784133 1880.00021,20.8226234 L1880,142.741854 C1879.52571,142.965612 1879.0505,143.187387 1878.57442,143.407295 C1877.32521,143.983378 1876.07146,144.569583 1874.79304,145.079294 C1873.70759,145.513068 1872.61441,145.956933 1871.50711,146.318371 C1868.91896,147.163378 1866.32828,148.006453 1863.6766,148.656392 C1861.65041,149.15301 1859.60354,149.524562 1857.55438,149.902764 C1856.24175,150.144623 1854.92398,150.327338 1853.59624,150.458802 C1851.47344,150.668208 1849.35014,150.832811 1847.2178,150.946491 C1845.21264,151.051894 1843.22444,150.725376 1841.22996,150.938589 C1840.06154,150.539456 1838.79429,150.914885 1837.6307,150.47704 C1837.01553,150.646667 1836.42469,150.37841 1835.84251,150.294829 C1835.2451,150.209191 1834.60106,150.277502 1834.01852,149.97279 C1833.75302,149.833555 1833.39407,150.052096 1833.07107,149.879252 C1832.8018,149.735532 1832.49324,149.613347 1832.16605,149.736569 C1832.02094,149.309404 1831.68158,149.764198 1831.42968,149.566956 C1831.17747,149.367487 1830.79672,149.220444 1830.48012,149.235749 C1829.70516,149.273856 1829.04747,148.761572 1828.34845,148.767387 C1827.59063,148.77421 1827.00521,148.311248 1826.32458,148.288333 C1825.48831,148.260705 1824.92609,147.60385 1824.1433,147.501134 C1824.07508,147.492518 1824.02781,147.3243 1823.96967,147.227777 C1823.79197,147.23778 1823.80971,147.436207 1823.6582,147.56148 C1823.46399,147.344792 1823.30152,147.06678 1823.06057,146.917938 C1822.7773,146.743897 1822.4258,146.681305 1822.05125,146.552337 C1821.79923,146.707818 1821.51384,146.883684 1821.26362,147.037658 C1820.87006,146.787391 1820.48575,146.819756 1820.18947,146.50948 C1820.06019,146.37359 1819.61861,146.395796 1819.31915,146.348998 C1818.92754,146.287471 1818.74617,145.758566 1818.42259,145.846908 C1817.99112,145.965035 1817.69016,145.761527 1817.3566,145.647737 C1814.24021,144.589553 1811.12872,143.51712 1808.02121,142.434368 C1807.68822,142.318646 1807.25138,142.342487 1807.09473,141.902849 C1806.57312,142.310826 1806.48301,141.574274 1806.10852,141.522892 C1805.76445,141.476671 1805.47502,141.228257 1805.17102,141.025831 C1804.65277,140.681626 1803.97427,140.584005 1803.37334,140.355839 C1802.97113,140.203532 1802.54979,140.14133 1802.22333,139.752662 C1801.96284,139.443025 1801.45409,139.430414 1801.06919,139.177817 C1800.6057,138.872659 1800.12595,138.509834 1799.56901,138.32763 C1799.19165,138.204067 1798.82851,138.090716 1798.5312,137.757776 C1798.31033,137.509593 1797.78086,137.638605 1797.64009,137.187431 C1796.89508,136.978718 1796.34465,136.442805 1795.70579,136.053884 C1794.16871,135.117677 1792.7149,134.069885 1791.30306,132.957915 C1790.1199,132.026692 1788.92096,131.114471 1787.74708,130.172633 C1787.36666,129.866324 1786.9933,129.542261 1786.6377,129.212622 C1785.35693,128.021469 1784.0357,126.854635 1782.89873,125.533431 C1781.8862,124.356011 1780.81738,123.222961 1779.85316,121.998425 C1779.34069,121.347017 1778.68646,120.789175 1778.13476,120.15082 C1776.83502,118.648185 1775.579,117.111732 1774.40108,115.510792 C1773.36839,114.106486 1772.29743,112.72938 1771.54495,111.138926 C1771.34758,110.720331 1771.03018,110.360283 1770.80538,109.953491 C1770.5498,109.490415 1770.40148,108.953766 1770.08727,108.540628 C1769.67818,108.00344 1769.44864,107.374013 1769.07406,106.835958 C1768.78315,106.418094 1769.03656,105.825327 1768.47007,105.48789 C1768.05838,105.243067 1768.29488,104.512724 1767.81663,104.205672 C1767.86831,103.482878 1767.1735,103.086384 1767.05891,102.383904 C1766.94803,101.703954 1766.47299,101.08456 1766.15765,100.438337 C1765.84193,99.7919829 1765.4507,99.1695706 1765.22699,98.4911456 C1764.81525,97.2432733 1764.10268,96.1287645 1763.67163,94.9061187 C1763.25987,93.7400572 1762.591,92.6597204 1762.42342,91.4183546 C1762.38381,91.1242072 1762.12588,91.1512107 1762.03844,90.9425963 C1761.94697,90.7262218 1762.04544,90.5093694 1761.93506,90.310918 C1761.48666,89.5030651 1761.18909,88.6302661 1760.87668,87.7672334 C1760.43309,86.5402701 1760.02264,85.2960325 1759.57017,84.0766386 C1758.86687,82.1801091 1758.35831,80.2380021 1757.85999,78.2877356 C1757.53514,77.0177179 1757.25564,75.7356932 1756.9629,74.4576045 C1756.62297,72.9730777 1756.2704,71.4916351 1755.9624,70.0011007 C1755.7285,68.8644024 1755.57061,67.7124412 1755.34959,66.5738048 C1755.17419,65.6708207 1754.96379,64.77491 1754.75261,63.8787311 C1754.45969,62.6409584 1754.21067,61.3906782 1753.92712,60.1550694 C1753.52294,58.3955358 1753.24987,56.6258958 1753.04537,54.8437374 C1752.94229,53.9454665 1752.83167,53.0435375 1752.8435,52.1221426 C1752.85054,51.5444238 1752.82175,50.9224914 1752.74279,50.3491603 C1752.58135,49.1768495 1752.74137,48.0334119 1752.75964,46.8772912 C1752.76596,46.4703928 1752.87582,46.0938308 1752.90628,45.7101188 C1752.9344,45.3511018 1752.99609,45.0057692 1753.04263,44.6520331 C1753.18167,43.5938119 1753.51754,42.5608615 1753.47405,41.4780405 C1753.47131,41.4080319 1753.47997,41.3291989 1753.50929,41.2670433 C1754.02613,40.1827149 1753.95237,38.9449647 1754.43104,37.841118 C1754.85709,36.859408 1754.77179,35.7228791 1755.27042,34.7502227 C1755.10364,34.0446477 1755.60428,33.4764456 1755.67505,32.832483 C1755.8663,31.0973385 1756.63492,29.5450648 1757.15273,27.9159897 C1757.66903,26.2938349 1758.25734,24.6964724 1758.80544,23.0842058 C1759.19358,21.9416422 1759.86133,20.9379648 1760.42365,19.8851312 C1760.5447,19.6575649 1760.79843,19.4575146 1760.87085,19.1730428 C1760.99384,18.686779 1761.2926,18.3495488 1761.71517,18.1052079 C1761.47362,17.8059179 1761.62701,17.4793042 1761.78554,17.2707004 C1762.7895,15.9488503 1763.57143,14.4819102 1764.53095,13.1280766 C1765.03529,12.4162187 1765.51784,11.6449022 1765.90937,10.8401193 C1766.21952,10.2027115 1766.75765,9.71733447 1767.08873,9.08044134 C1767.44486,8.39511538 1767.98667,7.82111384 1768.39328,7.15529772 C1768.73623,6.59389247 1769.27389,6.16997853 1769.64439,5.60393005 C1770.1807,4.78386658 1770.79053,4.00972905 1771.40828,3.2471358 C1771.80326,2.75954004 1772.13815,2.20237303 1772.69912,1.87308127 C1772.84683,1.78666199 1772.86953,1.64530066 1772.95678,1.53763695 C1773.33008,1.07593688 1773.68869,0.605780643 1774.1208,0.186751123 L1774.304,0.001 L1776.58836,-0.000100874754 C1776.47502,0.172917567 1776.40532,0.377914418 1776.4136,0.639612448 C1775.94484,0.441655175 1775.84919,0.920117323 1775.56148,1.0054005 C1775.61271,1.42797049 1774.86973,1.43841589 1775.08778,1.99896781 C1775.24322,2.39876893 1774.9863,2.65668919 1774.53972,2.66272491 C1774.50607,2.5930174 1774.47264,2.52519294 1774.42583,2.42853436 C1774.35157,2.76560956 1773.82701,2.72842982 1773.8692,3.11973039 C1773.98221,3.36413622 1774.2124,2.90649894 1774.29418,3.28890643 C1773.87734,3.76069346 1773.48605,4.31554402 1772.98172,4.73467786 C1772.64548,5.01458951 1772.60331,5.28790806 1772.55699,5.71386548 C1772.95506,5.36811733 1773.16734,4.92673231 1773.6847,4.93625092 L1773.62597,4.8184328 C1773.55209,4.66449578 1773.5158,4.52182616 1773.75498,4.37425029 C1774.02679,4.20603357 1774.24646,4.31067806 1774.49678,4.37487509 C1774.58681,4.39843814 1774.63106,4.31592311 1774.59882,4.24850751 C1774.49007,4.16175744 1774.38091,4.07487001 1774.22029,3.94699538 C1774.89704,3.31341604 1775.45664,2.60082278 1776.22726,2.09466318 C1776.27835,2.19937975 1776.31137,2.26706683 1776.3751,2.39770633 C1776.54585,2.3095508 1776.67464,2.2433929 1776.8047,2.17639929 C1776.63336,1.92115291 1776.71493,1.63058671 1776.64747,1.3714752 C1776.92294,1.00731056 1777.33635,1.69452619 1777.59189,1.24646693 C1777.57172,1.03657795 1777.22796,1.11318763 1777.26541,0.856305399 C1777.3276,0.464925426 1777.69399,0.313336441 1777.90561,0.0465119137 C1778.09366,0.0601536113 1778.24301,0.25374716 1778.44964,0.135658015 C1778.43449,0.0908051339 1778.41999,0.0459359846 1778.40747,0.00133501913 L1788.57867,0.0014280606 C1788.54574,0.0262703562 1788.51281,0.0511202664 1788.47989,0.0759776927 C1788.10912,0.356323978 1787.72885,0.676004596 1787.44082,1.18417228 C1788.40667,1.01596961 1789.02398,0.39146252 1789.76183,0.0213926479 L1789.798,0.001 L1879.99908,0.00193867399 Z M1876.21591,143.517474 C1875.59875,143.856423 1874.91075,144.064729 1874.25694,144.253991 C1872.68774,144.707141 1871.18726,145.343335 1869.63701,145.840198 C1868.80929,146.105585 1867.98738,146.459036 1867.15855,146.644348 C1865.28976,147.063407 1863.45529,147.611161 1861.58247,148.020331 C1859.06584,148.571206 1856.52158,148.927686 1853.99585,149.403173 C1853.39584,149.516398 1852.7961,149.409768 1852.21676,149.521608 C1850.93967,149.768266 1849.65151,149.945236 1848.35589,149.94326 C1847.37417,149.943109 1846.413,150.145544 1845.41693,150.085204 C1844.80189,150.047685 1844.1138,150.040264 1843.46421,150.220354 C1843.6238,150.435748 1843.82418,150.477121 1844.05506,150.454616 C1845.03073,150.3613 1846.01627,150.393577 1846.9902,150.379354 C1848.74456,150.351223 1850.48355,150.207294 1852.22253,150.032546 C1855.19162,149.73522 1858.14513,149.310338 1861.06774,148.70056 C1862.3167,148.439963 1863.56329,148.16155 1864.79485,147.828025 C1866.11211,147.470882 1867.40179,147.011798 1868.71784,146.648924 C1869.98005,146.300452 1871.17884,145.7782 1872.41971,145.371376 C1873.46168,145.029944 1874.41725,144.461132 1875.49797,144.216986 C1875.71322,144.16891 1875.91061,144.030746 1876.11086,143.924381 C1876.30856,143.819261 1876.5449,143.759321 1876.68402,143.602154 C1876.48827,143.380685 1876.35359,143.441628 1876.21591,143.517474 Z M1813.98869,131.891737 C1813.95603,132.239627 1813.93589,132.446259 1813.91654,132.652105 C1813.3354,132.482815 1813.43633,133.333595 1812.83737,133.296298 C1812.24393,133.1334 1811.58705,132.790338 1810.82333,132.829128 C1810.47152,132.846119 1810.46286,132.963206 1810.53502,133.223933 C1811.05214,133.390304 1811.54248,133.681335 1812.06253,133.499141 C1812.27895,133.680973 1812.01691,133.898881 1812.21953,134.045153 C1812.88447,134.274109 1813.5603,134.687446 1814.24008,134.69307 C1814.99151,134.698924 1815.59276,135.019643 1816.25572,135.204354 C1816.94465,135.396947 1817.61371,135.662386 1818.29166,135.895823 C1818.46996,135.957216 1818.64593,136.026306 1818.8273,136.076006 C1818.88921,136.093074 1818.96505,136.060748 1819.0345,136.050663 C1819.09624,135.882789 1819.21902,135.72956 1819.16686,135.532032 C1818.45027,135.560485 1818.47732,135.53686 1818.17888,135.009088 C1818.02205,134.729829 1818.30739,134.684637 1818.31262,134.537683 C1818.3286,134.106483 1817.82351,134.153574 1817.68131,133.888915 C1817.53095,133.690515 1817.97398,133.522175 1817.65657,133.301317 C1817.39132,133.587184 1817.50672,134.176248 1816.91395,134.183587 C1816.43799,133.719005 1816.43799,133.719005 1815.85747,134.176821 C1815.74643,134.440349 1816.25777,134.335908 1816.13939,134.655344 C1815.88693,134.526977 1815.49495,134.673579 1815.59502,134.136394 C1815.62446,133.976525 1815.24449,133.740498 1815.13462,133.625102 C1814.893,133.521718 1814.8003,133.781995 1814.66722,133.616108 C1814.44917,133.343394 1814.53247,133.024629 1814.46656,132.752239 C1814.65318,132.611427 1814.89497,132.609681 1814.99383,132.431212 C1814.7193,132.092302 1814.45931,132.546799 1814.2191,132.327019 C1814.17333,132.241135 1814.12153,132.142546 1813.98869,131.891737 Z M1879.20873,127.928893 C1878.05208,127.94608 1877.1665,128.666496 1876.11496,128.915378 C1875.02616,129.173742 1873.98057,129.559618 1872.93784,129.946474 C1871.86226,130.345398 1870.80774,130.800446 1869.75156,131.229425 C1869.89216,131.373465 1870.10096,131.495302 1870.3117,131.389358 C1871.0921,130.992924 1872.07461,131.364171 1872.7859,130.727183 C1873.38571,130.923091 1873.82691,130.515051 1874.33568,130.342786 C1874.69591,130.219253 1875.09552,130.194283 1875.36285,130.309707 C1875.7688,129.96391 1876.10317,129.788971 1876.57862,129.741237 C1876.97043,129.701892 1877.30695,129.341748 1877.75316,129.391264 C1877.67756,128.712839 1877.74085,128.674067 1878.67908,128.735742 C1878.70146,128.593628 1878.50131,128.496022 1878.66043,128.24374 C1878.79048,128.168454 1878.99977,128.048198 1879.20873,127.928893 Z M1871.92996,121.773872 C1871.17014,121.758753 1870.60022,122.204284 1869.95657,122.425736 C1869.20804,122.683325 1868.44036,122.885444 1867.70214,123.193334 C1866.98976,123.490995 1866.26918,123.781584 1865.54823,124.045483 C1864.73418,124.34214 1863.87646,124.524944 1863.0942,124.917546 C1862.82344,125.052763 1862.55139,125.287411 1862.27845,125.29012 C1861.91495,125.293525 1861.64867,125.458969 1861.35348,125.591085 C1861.03786,125.733167 1860.73034,125.89185 1860.43663,126.0351 C1860.73139,126.55842 1861.3919,125.883759 1861.56433,126.537088 C1862.11638,126.260721 1862.72338,126.275286 1863.31367,126.181028 C1864.01087,126.069398 1864.68917,125.846064 1865.38466,125.714718 C1865.64822,125.665212 1865.72606,125.213876 1866.08045,125.425155 C1867.00656,124.590127 1868.15814,124.248188 1869.33075,123.900738 C1869.42952,124.033563 1869.51043,124.141112 1869.58599,124.242572 C1869.72355,124.179433 1869.86078,124.117244 1869.99323,124.056596 C1869.94818,123.952896 1869.9072,123.855907 1869.86652,123.761145 C1870.09568,123.558481 1870.33469,123.999916 1870.56769,123.73057 C1870.45551,123.636692 1870.34805,123.547626 1870.24092,123.45761 C1870.50077,122.817123 1870.50113,122.812996 1871.14595,122.890523 C1871.27257,122.905434 1871.36047,122.884696 1871.40144,122.756427 C1871.49078,122.589556 1871.34636,122.478203 1871.30733,122.344697 C1871.50728,122.140473 1872.02052,122.223692 1871.92996,121.773872 Z M1872.06113,119.65253 C1872.03781,119.664691 1871.98624,119.67562 1871.97646,119.700941 C1871.87358,119.984278 1871.77768,120.268956 1871.6668,120.590976 C1869.75281,120.826587 1865.20446,122.40238 1864.20793,123.710422 C1864.73719,123.58665 1865.24566,123.702229 1865.59294,123.184288 C1865.71999,122.994278 1866.07759,122.977154 1866.27965,122.81616 C1866.56913,122.58645 1866.82476,122.985793 1867.12821,122.789581 C1867.4438,122.585862 1867.92077,122.576905 1868.15931,122.325405 C1868.48774,121.979479 1868.91603,122.139699 1869.24982,121.926312 C1869.56476,121.724493 1869.91871,121.464918 1870.26226,121.454645 C1870.66492,121.442413 1870.87722,120.95237 1871.26509,121.118864 C1871.67544,121.294158 1871.78367,120.62803 1872.17553,120.841584 C1872.68522,120.543196 1873.31651,120.576745 1873.81521,120.233133 C1873.99243,120.110338 1874.09542,120.008733 1873.98242,119.772193 C1873.48136,119.678292 1873.02739,119.932115 1872.60342,120.043263 C1872.36412,119.92049 1872.38738,119.559799 1872.06113,119.65253 Z M1841.12665,90.7253547 C1840.34885,91.7570157 1839.5058,92.7396457 1838.73766,93.7778198 C1838.46759,94.1427811 1838.08163,94.4561467 1838.00655,94.9488134 C1837.20527,95.6206879 1836.767,96.5790653 1836.24603,97.4314008 C1835.70991,98.3082732 1835.10862,99.151016 1834.54248,99.9962976 C1833.2916,101.862784 1832.13396,103.798562 1830.74753,105.572687 C1830.69313,106.130911 1829.97543,106.381052 1830.15344,107.068176 C1830.4481,106.318549 1831.16189,105.904493 1831.58,105.253685 C1832.09314,104.454965 1832.67264,103.701412 1833.20328,102.912968 C1833.65589,102.240038 1834.13884,101.59562 1834.54209,100.883378 C1834.95539,100.153348 1835.52634,99.5190433 1835.98415,98.8054016 C1836.45786,98.0674848 1836.90478,97.3012179 1837.44968,96.613312 C1837.75543,96.2277019 1838.07481,95.8627185 1838.32895,95.4338353 C1838.61492,94.951096 1838.9084,94.4539432 1839.29384,94.0553938 C1839.6855,93.650488 1839.70236,92.9433315 1840.37828,92.7669955 C1840.54136,92.7253949 1840.5621,92.4658379 1840.5679,92.2829565 C1840.57033,92.1913522 1840.49585,92.0243907 1840.51194,92.0171784 C1841.11091,91.7474068 1841.15993,91.0619495 1841.61845,90.6109994 C1841.39934,90.5801808 1841.29614,90.5000209 1841.12665,90.7253547 Z M1873.31702,77.0342914 C1869.6147,80.1615561 1866.17664,83.5211331 1862.6647,86.8021418 C1862.57235,86.8882842 1862.56487,87.0674 1862.51809,87.2032373 C1864.35519,86.002929 1865.96355,84.5751069 1867.52882,83.1026978 C1869.41413,81.3303476 1871.24977,79.5047672 1873.12125,77.7170305 C1873.3307,77.516078 1873.40234,77.3388657 1873.31702,77.0342914 Z M1762.13349,59.9397779 C1762.26176,61.6659343 1762.58164,63.275315 1762.92615,64.8782983 C1763.25379,66.4000352 1763.60271,67.9174068 1763.98386,69.425692 C1764.15717,70.1122617 1764.25243,70.8070211 1764.36997,71.5009518 C1764.38545,71.5902228 1764.46493,71.668592 1764.49415,71.7179667 C1764.66377,71.6573679 1764.80514,71.6072292 1764.9819,71.543778 C1764.94024,71.2457342 1764.96366,70.9361005 1764.83979,70.7064438 C1764.77159,70.5798936 1764.60182,70.5554393 1764.61805,70.3049562 C1764.6829,69.2923798 1764.74417,68.2732549 1764.69922,67.2611206 C1764.67607,66.7441969 1764.79575,66.212701 1764.57758,65.6934409 C1763.99269,64.3041311 1763.44227,62.9001336 1762.88293,61.5004959 C1762.83063,61.3687967 1762.69948,61.2652 1762.7614,61.0878283 C1762.84753,60.8401633 1762.64217,60.6685114 1762.54922,60.4771262 C1762.46805,60.3089231 1762.45484,60.0674268 1762.13349,59.9397779 Z M1703.22416,61.4108205 C1703.35375,61.7973433 1703.14937,61.9789962 1702.91762,62.2698547 C1701.11071,64.5384872 1698.38713,65.3277137 1695.95721,66.5269474 C1692.6447,68.1616812 1689.17664,69.4592838 1685.50455,70.1017047 C1684.1568,70.3373386 1682.80411,70.4067007 1681.44353,70.272975 C1680.86035,70.2154409 1680.33082,70.0684555 1680.08083,69.4368384 C1679.80708,68.7440738 1680.29318,68.4902219 1680.58,68.3234745 C1681.58842,67.2811362 1682.57303,67.0147448 1683.86219,67.0830537 C1686.34563,67.2148488 1688.70598,66.3981207 1691.04142,65.6345778 C1694.12889,64.6258889 1697.13636,63.4170166 1700.04614,61.9621515 C1700.78313,61.593169 1701.591,61.3564139 1702.38223,61.1102163 C1702.68348,61.0163203 1703.06576,60.9361752 1703.22416,61.4108205 Z M1685.22347,46.2600996 C1686.61283,47.4041498 1688.38612,47.6742258 1690.08298,48.0278383 C1696.05778,49.2745965 1702.10731,50.0739728 1708.14193,50.960775 C1708.61695,51.0307765 1709.10925,51.0736227 1709.34616,51.6481556 C1709.63531,52.3469289 1708.8563,52.2804812 1708.69655,52.6500854 C1708.17038,53.866852 1707.08708,53.7727441 1706.05556,53.7230867 C1700.69971,53.4643458 1695.32999,53.3291137 1690.0868,52.0154161 C1688.36682,51.5843384 1686.66382,51.1081236 1685.0083,50.4574122 C1684.276,50.1692732 1683.99129,49.2472533 1683.00564,49.2612066 C1682.60432,49.2671582 1682.14758,48.6935471 1682.04993,48.1117869 C1681.99902,47.8094924 1681.89693,47.4577368 1682.19211,47.2777993 C1682.5385,47.0666517 1682.67988,47.5042024 1683.04338,47.726732 C1682.68706,47.0006053 1682.74867,46.484908 1683.41533,46.1164102 C1684.07022,45.7542198 1684.57405,45.725112 1685.22347,46.2600996 Z M1688.71092,21.2881937 C1688.61018,22.8129944 1689.74854,23.4840513 1690.69411,24.2317599 C1696.70964,28.9880441 1703.37465,32.6610255 1710.3238,35.8405079 C1712.85976,37.0011529 1715.44052,38.063984 1717.9938,39.1858767 C1718.34033,39.3383726 1718.7697,39.3788973 1718.77825,39.9845335 C1718.78686,40.5887434 1718.26155,40.5160423 1718.05815,40.7736172 C1716.51478,42.7297351 1714.70701,41.8505447 1712.92499,41.3502297 C1703.91257,38.8204422 1695.92746,34.3598036 1688.71463,28.4538209 C1687.39478,27.3730319 1686.1897,26.1691374 1685.27909,24.7165388 C1684.6993,23.7908194 1684.36116,22.7975749 1685.04232,21.7506465 C1685.85459,21.0630826 1686.79941,20.6891269 1687.82825,20.5875249 C1688.25271,20.5452193 1688.7419,20.8215711 1688.71092,21.2881937 Z M1856.18409,23.1243634 C1855.35755,23.6319858 1854.56883,24.2022527 1853.77503,24.7616357 C1853.22167,25.1519841 1852.71507,25.61358 1852.13928,25.9641204 C1851.00374,26.6544616 1849.9952,27.5165716 1848.96492,28.3360207 C1847.71918,29.3272606 1846.47643,30.3239947 1845.21846,31.2995461 C1844.98159,31.4838342 1844.88071,31.6555476 1844.88387,31.9250305 C1845.36201,32.0074267 1845.39717,31.5309828 1845.7285,31.4034484 C1846.05616,31.2773075 1846.36039,31.0726511 1846.66194,30.8526229 C1847.80069,30.0212173 1849.01312,29.2887114 1850.20453,28.5296281 C1851.06393,27.9827429 1851.94822,27.4518615 1852.76197,26.8629057 C1853.57732,26.2726949 1854.47035,25.7984844 1855.25006,25.1661429 C1855.99091,24.5661107 1856.96898,24.2858762 1857.52673,23.4418461 C1857.14349,22.9085673 1856.75572,22.773242 1856.18409,23.1243634 Z M1803.60115,4.29331798 C1803.11171,4.53227153 1802.63984,4.71926183 1802.21444,4.98207171 C1801.79658,5.23961848 1801.31751,5.33211369 1800.88488,5.57394682 C1800.30593,5.89789519 1799.81504,6.34811309 1799.20718,6.62332525 C1798.00132,7.16885879 1796.90954,7.90986188 1795.79484,8.61928079 C1794.04802,9.73113877 1792.52528,11.1142771 1790.94952,12.4350659 C1790.58652,12.7391266 1790.2719,13.1017105 1789.9349,13.4376717 C1794.54937,10.5616903 1798.80867,7.18759153 1803.57852,4.59047344 C1803.61101,4.57265247 1803.59061,4.45693112 1803.60115,4.29331798 Z"
                  id="形状结合"
                  fill="#000000"
                />
              </g>
            </g>
          </g>
        </g>
      </svg>
    </div>
  );
}
