# [C++ links](README.md): standard & standardization

# Contents

- [Compiler Support](#compiler-support)
- [References](#references)
- [Standard](#standard)
- [Standardization](#standardization)
- [C++26](#c26): [C++26 Talks](#c26-talks)
- [C++23](#c23): [C++23 Talks](#c23-talks)
- [C++20](#c20): [C++20 Readings](#c20-readings), [C++20 Talks](#c20-talks)
- [C++17](#c17): [C++17 Readings](#c17-readings), [C++17 Talks](#c17-talks)
- [C++14](#c14): [C++14 Readings](#c14-readings), [C++14 Talks](#c14-talks)
- [C++11](#c11): [C++11 Readings](#c11-readings), [C++11 Talks](#c11-talks)
- [History](#history)

---

# Compiler Support

- C++ compiler support - http://en.cppreference.com/w/cpp/compiler_support
- EDG C++ Front End - Supported C++ and C Language Features
	- http://www.edg.com/c/features
- GNU
	- C++ Standards Support in GCC - https://gcc.gnu.org/projects/cxx-status.html
	- GNU C++ Library (libstdc++) - https://gcc.gnu.org/onlinedocs/libstdc++/manual/status.html
- LLVM
	- Clang - http://clang.llvm.org/cxx_status.html
	- libc++ - http://libcxx.llvm.org/
- Intel C++ Compiler
	- C++11: https://software.intel.com/en-us/articles/c0x-features-supported-by-intel-c-compiler
	- C++14: https://software.intel.com/en-us/articles/c14-features-supported-by-intel-c-compiler
	- C++17: https://software.intel.com/en-us/articles/c17-features-supported-by-intel-c-compiler
- Visual C++
	- Support For C++11/14/17 Features: https://msdn.microsoft.com/en-us/library/hh567368.aspx
	- Microsoft C++ language conformance table: https://docs.microsoft.com/en-us/cpp/visual-cpp-language-conformance

---

# References

- https://cppreference.com/
	- cppman: C++ manual pages for Linux/MacOS
		- https://github.com/aitjcize/cppman
	- C++ standard library reference (cppreference)
		- https://github.com/p12tic/cppreference-doc
	- Formatted C++ stdlib man pages (cppreference)
		- https://github.com/jeaye/stdman
- A cheatsheet of modern C++ language and library features
	- https://github.com/AnthonyCalandra/modern-cpp-features

---

# Standard

- C++ standard draft
	- https://github.com/cplusplus/draft
	- https://eel.is/c++draft/
	- C++ Standards Drafts in HTML - https://ubershmekel.github.io/cppdrafts/
	- HTML version of the C++ working paper
		- https://github.com/timsong-cpp/cppwp
		- https://timsong-cpp.github.io/cppwp/
- Specref (search WG21 papers)
	- https://www.specref.org/
- wg21.link - WG21 redirect service - https://wg21.link/
- Where do I find the current C or C++ standard documents?
	- https://stackoverflow.com/questions/81656/where-do-i-find-the-current-c-or-c-standard-documents

---

# Standardization

- JTC1/SC22/WG21 - The C++ Standards Committee - ISOCPP - http://www.open-std.org/jtc1/sc22/wg21/
- Standardization - Standard C++ Foundation
	- https://isocpp.org/std
	- Standing Documents
	- SD-6: SG10 Feature Test Recommendations
		- https://wg21.link/sd6
	- Standard Library Compatibility Guidelines (SD-8)
		- https://isocpp.org/std/standing-documents/sd-8-standard-library-compatibility
		- CppCon 2018; Titus Winters
		- https://www.youtube.com/watch?v=BWvSSsKCiAw
- C++ International Standard schedule
	- https://wg21.link/P1000
- Current Status
	- https://isocpp.org/std/status
- ISO C++ paper scheduling and management
	- track proposals on GitHub
	- https://github.com/cplusplus/papers/issues
- LEWG ISO C++ GitHub
	- Project planning for the C++ Library Evolution Working Group 
	- https://github.com/cplusplus/LEWG
	- https://github.com/cplusplus/LEWG/wiki
- WG21 CWG Issues
	- https://wg21.cmeerw.net/cwg/
- Bikeshed: A preprocessor for anyone writing specifications that converts source files into actual specs.
	- https://tabatkins.github.io/bikeshed/
	- https://github.com/tabatkins/bikeshed
- How I format my C++ papers
	- https://mpark.github.io/programming/2018/11/16/how-i-format-my-cpp-papers/
- JeanHeyd Meneide
	- A Perspective on C++ Standardization in 2018
		- https://thephd.github.io/perspective-standardization-in-2018
	- Getting You There - Your C++ Standardization Efforts in 2019
		- https://thephd.github.io/getting-there-standardization-in-2019
- Specification Style Guidelines
	- https://github.com/cplusplus/draft/wiki/Specification-Style-Guidelines

---

# C++26

## C++26: Talks

- C++26 Preview
	- C++Now 2024
	- Jeffrey Garland
	- https://www.youtube.com/watch?v=CwYILWyTRMQ
- C++26 Preview - The Smaller Features
	- CppCon 2024
	- Jeff Garland
	- https://www.youtube.com/watch?v=xmqkRcAslw8
	- https://github.com/CppCon/CppCon2024/blob/main/Presentations/Cpp_26_Preview.pdf
- What’s New in C++26
	- April 2024 C++ Meetup @ Google
	- Alexander Fokin
	- https://www.youtube.com/watch?v=FqzrQf6Xr8g

## C++26: Trip Reports

### C++26: Trip Reports: 2024-11

- Trip Report: Fall ISO C++ Meeting in Wrocław, Poland
	- Jonathan Müller
	- https://www.think-cell.com/en/career/devblog/trip-report-fall-iso-cpp-meeting-in-wroclaw-poland
- Trip report: November 2024 ISO C++ standards meeting (Wrocław, Poland)
	- https://herbsutter.com/2024/11/24/wg21-2024-11/

### C++26: Trip Reports: 2024-06

- Trip report: Summer ISO C++ standards meeting (St Louis, MO, USA)
	- https://herbsutter.com/2024/07/02/trip-report-summer-iso-c-standards-meeting-st-louis-mo-usa/

### C++26: Trip Reports: 2024-03

- 2024-03 Tokyo ISO C++ Committee Trip Report — Third C++26 meeting!
	- https://old.reddit.com/r/cpp/comments/1bloatw/202403_tokyo_iso_c_committee_trip_report_third/
- Trip Report: Spring ISO C++ Meeting in Tokyo, Japan
	- https://www.think-cell.com/en/career/devblog/trip-report-spring-iso-cpp-meeting-in-tokyo-japan
- Trip report: Winter ISO C++ standards meeting (Tokyo, Japan)
	- https://herbsutter.com/2024/03/22/trip-report-winter-iso-c-standards-meeting-tokyo-japan/
- Trip Report: Winter ISO C++ Standards Meeting in Tokyo
	- https://blog.developer.adobe.com/trip-report-winter-iso-c-standards-meeting-6d38b5bcec54

### C++26: Trip Reports: 2023-11

- 2023-11 Kona ISO C++ Committee Trip Report — Second C++26 meeting!
	- https://old.reddit.com/r/cpp/comments/17vnfqq/202311_kona_iso_c_committee_trip_report_second/
- Trip report: Autumn ISO C++ standards meeting (Kona, HI, USA)
	- https://herbsutter.com/2023/11/11/trip-report-autumn-iso-c-standards-meeting-kona-hi-usa/
- Trip Report: Freestanding in Kona 2023
	- https://old.reddit.com/r/cpp/comments/17v56oc/trip_report_freestanding_in_kona_2023/

### C++26: Trip Reports: 2023-06

- 2023-06 Varna ISO C++ Committee Trip Report — First Official C++26 meeting!
	- https://old.reddit.com/r/cpp/comments/14h4ono/202306_varna_iso_c_committee_trip_report_first/
- Five Awesome C++ Papers for the H1 2023 - C++26, Varna and More 
	- https://www.cppstories.com/2023/h1-cpp-papers23/
- Trip report: Summer ISO C++ standards meeting (Varna, Bulgaria)
	- https://herbsutter.com/2023/06/16/trip-report-summer-iso-c-standards-meeting-varna-bulgaria/
- Trip report: Summer ISO C++ Meeting in Varna, Bulgaria
	- https://www.think-cell.com/en/career/devblog/trip-report-summer-iso-cpp-meeting-in-varna-bulgaria

---

# C++23

## C++23: Talks

- A Preview of C++23
	- NDC TechTown 2022
	- Daniela Engert
	- https://www.youtube.com/watch?v=r8c6ws9Tow0
- C++23 - What's In It For You?
	- CppCon 2022
	- Marc Gregoire
	- https://www.youtube.com/watch?v=b0NkuoUkv0M
- C++23 Standard Library Preview
	- Jeff Garland
	- CppCon 2021
			- https://www.youtube.com/watch?v=22MBluMsRBo
			- http://crystalclearsoftware.com/2021cppcon/cpp23lib.pdf
	- Meeting C++ 2021
		- https://www.youtube.com/watch?v=rTVQe7zVQUw
- C++23: An Overview of Almost All New and Updated Features
	- CppCon 2023
	- Marc Gregoire
	- https://www.youtube.com/watch?v=Cttb8vMuq-Y
	- https://github.com/CppCon/CppCon2023/blob/main/Presentations/CppCon_-_C23_An_Overview_of_Almost_All_New_and_Updated_Features.pptx
- How C++23 changes the way we write code
	- Timur Doumler
	- 2022-11-18: Meeting C++ 2022
		- https://www.youtube.com/watch?v=QyFVoYcaORg
	- 2022-09-15: CppCon 2022
		- https://www.youtube.com/watch?v=eD-ceG-oByA
	- 2022-09-01: NDC TechTown 2022
		- https://www.youtube.com/watch?v=HdZTw5qLg6A
- New Algorithms in C++23
	- Italian C++ Conference 2023
	- Conor Hoekstra
	- https://www.youtube.com/watch?v=5FU7Gtkb0IA
	- https://github.com/codereport/Content/tree/main/Talks/2023-06-ItalianC%2B%2B
	- https://github.com/italiancpp/itcppcon23/blob/main/New%20Algorithms%20in%20C%2B%2B23%20-%20Conor%20Hoekstra.pdf
- What's New In C++23
	- Sy Brand
	- CppCon 2022
		- https://www.youtube.com/watch?v=vbHWDvY59SQ
	- Pure Virtual C++ 2022
		- https://docs.microsoft.com/en-us/events/pure-virtual-cpp-2022/whats-new-in-cpp23
		- https://www.youtube.com/watch?v=mQzijnbnTO4

## C++23: Trip Reports

- C++ 23 Status Report
	- https://github.com/steve-downey/papers/blob/master/wg21-status.org
- 2021 C++ Standardization Highlights
	- https://botondballo.wordpress.com/2022/01/03/2021-c-standardization-highlights/

### 2023-02 Issaquah

- 2023-02 Issaquah ISO C++ Committee Trip Report — C++23 Is Done! 🎉
	- https://old.reddit.com/r/cpp/comments/112ef9t/202302_issaquah_iso_c_committee_trip_report_c23/
- ISO C++ Feb 2023 meeting trip report (core language)
	- https://developers.redhat.com/blog/2023/04/10/iso-c-feb-2023-meeting-trip-report-core-language

### 2022-11 Kona

- 2022-11 Kona ISO C++ Committee Trip Report — C++23 First Draft!
	- https://old.reddit.com/r/cpp/comments/yxuqp7/202211_kona_iso_c_committee_trip_report_c23_first/
- Soursop and Ponies in Kona: A C++ Committee Trip Report
	- https://cor3ntin.github.io/posts/kona22/
- Trip report: Autumn ISO C++ standards meeting (Kona)
	- https://herbsutter.com/2022/11/12/trip-report-autumn-iso-c-standards-meeting-kona/

### 2022-07-25 Virtual Meeting

- July 2022 ISO C++ committee virtual meeting report
	- https://blog.jetbrains.com/clion/2022/07/july-2022-iso-cpp/

### 2021-06-07 Virtual Meeting

- Trip report: Summer 2021 ISO C++ standards meeting (virtual)
	- https://herbsutter.com/2021/06/09/trip-report-summer-2021-iso-c-standards-meeting-virtual/

### 2021-02-22 Virtual Meeting

- Trip report: Winter 2021 ISO C++ standards meeting (virtual)
	- https://herbsutter.com/2021/02/22/trip-report-winter-2021-iso-c-standards-meeting-virtual/

### 2020-11-09 Virtual Meeting

- Report from the virtual ISO C++ meetings in 2020 (core language) 
	- https://developers.redhat.com/blog/2021/05/07/report-from-the-virtual-iso-c-meetings-in-2020-core-language
- Trip report: Autumn ISO C++ standards meeting (virtual)
	- https://herbsutter.com/2020/11/13/trip-report-autumn-iso-c-standards-meeting-virtual/

---

# C++20

See also: [Coroutines](https://gist.github.com/MattPD/9b55db49537a90545a90447392ad3aeb#file-cpp-std-coroutines-draft-md), [Modules](https://gist.github.com/MattPD/0ad1e6ba7e24f220ff635ea4a34947be#file-cpp-std-modules-draft-md).

## C++20: Readings

- All C++20 core language features with examples
	- https://oleksandrkvl.github.io/2021/04/02/cpp-20-overview.html
- C++20 features described in Before/After tables ("Tony Tables")
	- https://github.com/tvaneerd/cpp20_in_TTs
- C++ 20: The Core Language
	- https://www.modernescpp.com/index.php/c-20-the-core-language
- C++ at the End of 2018
	- https://www.bfilipek.com/2018/12/c-at-end-of-2018.html
- C++ at the end of 2019
	- https://www.bfilipek.com/2019/12/cpp-status-2019.html
- Changes between C++17 and C++20
	- 2020-03-02; Thomas Köppe
	- https://wg21.link/p2131

## C++20: Talks

- Beyond C++17
	- C++Now 2018; Mateusz Pusz
	- https://www.youtube.com/watch?v=y7PBciQp0B8
- Beyond C++17 (Part 2 of N)
	- C++Now 2019; Mateusz Pusz
	- https://www.youtube.com/watch?v=XjUmU3q1XsA
- C++ Weekly C++20; Jason Turner
	- https://www.youtube.com/playlist?list=PLs3KjaCtOwSYdpfm74DYyd1kOXEhCd1Rv
- C++20 in Breadth (not depth!)
	- C++Now 2019; Alisdair Meredith
	- https://www.youtube.com/watch?v=tczJe5YGHuc
- C++20 STL Features: One Year of Development on GitHub
	- CppCon 2020; Stephan T. Lavavej
	- https://www.youtube.com/watch?v=8kjRx8vo6y4
	- https://github.com/CppCon/CppCon2020/tree/main/Presentations/cpp20_stl_features_1_year_of_development_on_github
- C++20 - Reaching for the Aims of C++
	- CppCon 2021; Bjarne Stroustrup
	- https://www.youtube.com/watch?v=15QF2q66NhU
- C++20: The Small Pearls
	- ACCU 2022; Rainer Grimm
	- https://www.youtube.com/watch?v=OLRXMgXtprQ
	- https://www.grimm-jaud.de/images/stories/pdfs/Cpp20Bristol.pdf
	- (older version) C++20 - The Hidden Pearls
		- Meeting C++ 2021; Rainer Grimm
		- https://www.youtube.com/watch?v=KKi6-T8xuX4
		- https://meetingcpp.com/mcpp/slides/2021/C+20TheHiddenPearls6091.pdf
- C++20: An (Almost) Complete Overview
	- CppCon 2020; Marc Gregoire
	- https://www.youtube.com/watch?v=FRkJCvHWdwQ
	- https://github.com/CppCon/CppCon2020/tree/main/Presentations/cpp20_an_almost_complete_overview
- C++20: C++ at 40
	- CppCon 2019; Bjarne Stroustrup
	- https://www.youtube.com/watch?v=u_ij0YNkFUs
- C++20: My Favourite Code Examples
	- Nico Josuttis
	- ACCU 2022
		- https://www.youtube.com/watch?v=UCIKbUvEKfI
		- https://accu.digital-medium.co.uk/wp-content/uploads/2022/04/josuttis_C20_ACCUTalk_220407.pdf
	- C++ on Sea 2021
		- https://www.youtube.com/watch?v=qdSAPQiRBDo
	- Meeting C++ 2021
		- https://www.youtube.com/watch?v=ey4pTOfdi9k
	- NDC TechTown 2022
		- https://www.youtube.com/watch?v=ailViuK1gmk
- C++20: The small things
	- Timur Doumler
	- St. Petersburg C++ User Group, 11.06.2019
		- https://www.youtube.com/watch?v=AgatxxXNwBM
		- https://www.dropbox.com/s/hf5e7ss1ukjdxok/cpp20_small_things.pdf?dl=0
	- CppCon 2019
		- https://www.youtube.com/watch?v=Xb6u8BrfHjw
- C++20: What's in it for you?
	- CppCon 2019; Marc Gregoire
	- https://www.youtube.com/watch?v=Y652wQqbYEI
	- https://github.com/CppCon/CppCon2019/tree/master/Presentations/cpp20_whats_in_it_for_you
	- http://www.nuonsoft.com/blog/2019/09/30/slides-of-my-cppcon-2019-presentation-c20-whats-in-it-for-you/
- Changes to the C++ standard library for C++20
	- EuroLLVM 2019; Marshall Clow
	- https://www.youtube.com/watch?v=coXGSfUak-Q
	- http://llvm.org/devmtg/2019-04/slides/TechTalk-Clow-Changes_to_the_C++_standard_library_for_C++20.pdf
- How C++20 Changes the Way We Write Code
	- CppCon 2020; Timur Doumler
	- https://www.youtube.com/watch?v=ImLFlLjSveM
	- https://github.com/CppCon/CppCon2020/tree/main/Presentations/how_cpp20_changes_the_way_we_write_code
- The Best Parts of C++
	- CppCon 2019; Jason Turner
	- https://www.youtube.com/watch?v=iz5Qx18H6lg
	- https://github.com/CppCon/CppCon2019/tree/master/Presentations/back_to_basics_the_best_parts_of_cpp
- The C++20 Firehose Talk
	- Meeting C++ 2019; Fabio Fracassi
	- https://www.youtube.com/watch?v=A_k43Eq5srs
- The C++20 Standard Library: Beyond Ranges
	- CppCon 2019; Jeff Garland
	- https://www.youtube.com/watch?v=fI19ttpUNRQ

## C++20: Trip Reports

### 2020-02 Prague

- 2020-02 Prague ISO C++ Committee Trip Report — 🎉 C++20 is Done!
	- https://old.reddit.com/r/cpp/comments/f47x4o/202002_prague_iso_c_committee_trip_report_c20_is/
- CppCast Episode 235: Prague Trip Report with Hana Dusikova
	- https://cppcast.com/hana-dusikova-prague-trip-report/
- Freestanding in Prague
	- https://old.reddit.com/r/cpp/comments/f5hgqm/freestanding_in_prague/
- Report from the February 2020 ISO C++ meeting (Core Language Working Group) 
	- https://developers.redhat.com/blog/2020/04/23/report-from-the-february-2020-iso-c-meeting-core-language-working-group
- Shipping C++20 in Prague
	- https://cor3ntin.github.io/posts/cpp20/
- Trip Report: C++ Standards Meeting in Prague, February 2020
	- https://botondballo.wordpress.com/2020/03/12/trip-report-c-standards-meeting-in-prague-february-2020/
- Trip report: February 2020 ISO C++ committee meeting, Prague
	- https://timur.audio/trip-report-february-2020-iso-c-committee-meeting-prague
- Trip report: Winter ISO C++ standards meeting (Prague)
	- https://herbsutter.com/2020/02/15/trip-report-winter-iso-c-standards-meeting-prague/
- WG21 in Prague - (Partial) Trip Report
	- https://old.reddit.com/user/InbalL/comments/f5ftop/wg21_in_prague_partial_trip_report/

### 2019-11 Belfast

- 2019-11 Belfast ISO C++ Committee Trip Report
	- https://www.reddit.com/r/cpp/comments/dtuov8/201911_belfast_iso_c_committee_trip_report/
- Herb Sutter's Trip report: Autumn ISO C++ standards meeting (Belfast)
	- https://herbsutter.com/2019/11/09/trip-report-autumn-iso-c-standards-meeting-belfast/
- Trip Report: C++ Standards Meeting in Belfast, November 2019
	- https://botondballo.wordpress.com/2019/11/15/trip-report-c-standards-meeting-in-belfast-november-2019/
- Trip Report: Freestanding Errors in Belfast
	- https://www.reddit.com/r/cpp/comments/dvh72f/trip_report_freestanding_errors_in_belfast/
- WG21 in my own backyard: Belfast trip report
	- https://hatcat.com/?p=115

### 2019-07 Cologne

- Cologne ISO C++ Committee Trip Report
	- 🚀 The C++20 Eagle has Landed 🚀 (C++20 Committee Draft shipped; Contracts Moved From C++20 to a Study Group; `std::format` in C++20; C++20 Synchronization Library)
	- https://old.reddit.com/r/cpp/comments/cfk9de/201907_cologne_iso_c_committee_trip_report_the/
- Report from July 2019 ISO C++ Meeting (Core Language)
	- https://developers.redhat.com/blog/2019/09/03/report-from-july-2019-iso-c-meeting-core-language/
- Report from July 2019 ISO C++ Standards Committee Meeting (Concurrency and Parallelism Study Group)
	- https://developers.redhat.com/blog/2019/11/15/report-from-july-2019-iso-c-standards-committee-meeting-concurrency-and-parallelism-study-group/
- The German tour: Cologne trip report
	- https://hatcat.com/?p=86
	- Trip report: Summer ISO C++ standards meeting (Cologne)
	- https://herbsutter.com/2019/07/20/trip-report-summer-iso-c-standards-meeting-cologne/
- Trip Report: C++ Standards Meeting in Cologne, July 2019
	- https://botondballo.wordpress.com/2019/07/26/trip-report-c-standards-meeting-in-cologne-july-2019/
- Trip Report: ISO C++ Meeting Cologne (2019)
	- https://www.silexica.com/news/iso_cpp_meeting_2019/
- Trip report: July 2019 ISO C++ committee meeting, Cologne, Germany
	- http://timur.audio/trip-report-july-2019-iso-c-committee-meeting-cologne-germany

### 2019-02 Kona

- 2019-02 Kona ISO C++ Committee Trip Report
	- C++20 design is complete; Modules in C++20; Coroutines in C++20; Reflection TS v1 published; work begins on a C++ Ecosystem Technical Report
	- https://www.reddit.com/r/cpp/comments/au0c4x/201902_kona_iso_c_committee_trip_report_c20/
- CppCast Episode 188: Kona Trip Report with Peter Bindels
	- http://cppcast.com/2019/02/peter-bindels/
- Kona: A trip report
	- https://cor3ntin.github.io/posts/kona2019/
- Report from February 2019 ISO WG21 C++ Standards Committee Meeting
	- https://developers.redhat.com/blog/2019/06/21/report-from-february-2019-iso-wg21-c-standards-committee-meeting/
- Report from the February 2019 ISO C++ meeting (Core Language working group)
	- https://developers.redhat.com/blog/2019/04/11/report-from-the-february-2019-iso-c-meeting-core-language-working-group/
- Telescopes and matrices and audio: Kona trip report
	- https://hatcat.com/?p=69
- Trip Report: C++ Standards Meeting in Kona, February 2019
	- https://botondballo.wordpress.com/2019/03/20/trip-report-c-standards-meeting-in-kona-february-2019/
- Trip report: February 2019 ISO C++ committee meeting, Kona, Hawai’i
	- http://timur.audio/trip-report-february-2019-iso-c-committee-meeting-kona-hawaii
- Trip Report: Freestanding (and Modules) in Kona
	- https://www.reddit.com/r/cpp/comments/ax1z2y/trip_report_freestanding_and_modules_in_kona/
- Trip report: Winter ISO C++ standards meeting (Kona)
	- https://herbsutter.com/2019/02/23/trip-report-winter-iso-c-standards-meeting-kona/

### 2018-11 San Diego

- 2018 San Diego ISO C++ Committee Trip Report (Ranges v1 TS for C++20; consensus on modules design; new Language and Library Evolution Incubators)
	- https://www.reddit.com/r/cpp/comments/9vwvbz/2018_san_diego_iso_c_committee_trip_report_ranges/
- Fall 2018 ISO WG21 C++ Standards Committee meeting trip report
	- https://developers.redhat.com/blog/2019/01/10/fall-2018-iso-wg21-c-standards-committee-meeting-trip-report/
- Freestanding in San Diego
	- https://www.reddit.com/r/cpp/comments/9xr4b5/trip_report_freestanding_in_san_diego/
- If I Only Had A Brain: 2018 CppSAN WG21 Trip Report
	- https://robot-dreams.net/2018/11/14/2018-cppsan-wg21-trip-report/
- November 2018 ISO C++ meeting trip report (Core Language)
	- https://developers.redhat.com/blog/2019/02/15/november-2018-iso-c-meeting-trip-report-core-language/
- Pre-trip report: Fall ISO C++ standards meeting (San Diego)
	- https://herbsutter.com/2018/11/05/pre-trip-report-fall-iso-c-standards-meeting-san-diego/
- San Diego Committee Meeting: A Trip Report
	- https://cor3ntin.github.io/posts/sandiego/
- The San Diego 2018 Aftermath
	- https://thephd.github.io/san-diego-2018-c++-committee-trip-report
- Trip Report: C++ Standards Meeting in San Diego, November 2018
	- https://botondballo.wordpress.com/2018/11/30/trip-report-c-standards-meeting-in-san-diego-november-2018/
- Trip report: Fall ISO C++ standards meeting (San Diego)
	- https://herbsutter.com/2018/11/13/trip-report-fall-iso-c-standards-meeting-san-diego/

### 2018-06 Rapperswil

- 2018 Rapperswil ISO C++ Committee meeting trip report
	- https://www.reddit.com/r/cpp/comments/8prqzm/2018_rapperswil_iso_c_committee_trip_report/
- 2D or not 2D: that is the question: Rapperswil trip report
	- https://hatcat.com/?p=48
- ISO C++ Committee – Rapperswil 2018 trip report
	- https://blog.jetbrains.com/clion/2018/06/iso-cpp-committee-rapperswil-2018-trip-report/
- June 2018 ISO C++ Meeting Trip Report (Core Language)
	- https://developers.redhat.com/blog/2018/07/02/iso-cpp-summer-2018-core-language/
- Rapperswil Committee Meeting: A Trip Report
	- https://cor3ntin.github.io/posts/rapperswil/
- The (Late) Rapperswil Trip Report
	- https://thephd.github.io/2018/08/21/The-Late-Rapperswil-Trip-Report.html
- Trip Report: C++ Standards Meeting in Rapperswil, June 2018
	- https://botondballo.wordpress.com/2018/06/20/trip-report-c-standards-meeting-in-rapperswil-june-2018/
- Trip report: Summer ISO C++ standards meeting (Rapperswil)
	- https://herbsutter.com/2018/07/02/trip-report-summer-iso-c-standards-meeting-rapperswil/

### 2018-03 Jacksonville

- 2018 Jacksonville ISO C++ Committee Reddit Trip Report
	- https://www.reddit.com/r/cpp/comments/854mu9/2018_jacksonville_iso_c_committee_reddit_trip/
- Freestanding trip report: emBO++ and Jacksonville wg21 2018 experience
	- https://old.reddit.com/r/cpp/comments/86mopg/freestanding_trip_report_embo_and_jacksonville/
- GoingNative 65: ISO C++ @ Jacksonville Debriefing
	- https://channel9.msdn.com/Shows/C9-GoingNative/GoingNative-65-ISO-C--Jacksonville-Debriefing
- ISO C++ Committee – Jacksonville 2018 trip report - Timur Doumler
	- https://blog.jetbrains.com/clion/2018/03/iso-cpp-committee-jacksonville-2018-trip-report-2/
- Jacksonville’18 ISO C++ Report - J. Daniel García
	- https://usingstdcpp.org/2018/03/18/jacksonville18-iso-cpp-report/
- March 2018 ISO C++ Meeting Trip Report (SG1: Concurrency and Parallelism)
	- https://developers.redhat.com/blog/2018/04/30/march-2018-iso-c-meeting-trip-report/
- Oh, lock-free circular buffers, yay! Hey, no 2D graphics? Jacksonville trip report - Guy Davidson
	- https://hatcat.com/?p=33
- Text Formatting at the ISO C++ standards meeting in Jacksonville
	- http://zverovich.net/2018/03/17/text-formatting-jacksonville.html
- Trip Report: C++ Standards Meeting in Jacksonville, March 2018
	- https://botondballo.wordpress.com/2018/03/28/trip-report-c-standards-meeting-in-jacksonville-march-2018/
- Trip report: first ISO C++ meeting experience - Vittorio Romeo
	- https://vittorioromeo.info/index/blog/mar18_iso_meeting_report.html
- Trip report: Winter ISO C++ standards meeting (Jacksonville) - Herb Sutter
	- https://herbsutter.com/2018/04/02/trip-report-winter-iso-c-standards-meeting-jacksonville/

### 2017-11 Albuquerque

- 2017 Albuquerque ISO C++ Committee Reddit Trip Report
	- https://www.reddit.com/r/cpp/comments/7ca2sh/2017_albuquerque_iso_c_committee_reddit_trip/
- Red Hat at the ISO C++ Standards Meeting (November 2017): Parallelism and Concurrency
	- https://developers.redhat.com/blog/2017/12/01/red-hat-iso-c-standards-meeting-november-2017-parallelism-concurrency/
- Trip Report: C++ Standards Meeting in Albuquerque, November 2017
	- https://botondballo.wordpress.com/2017/11/20/trip-report-c-standards-meeting-in-albuquerque-november-2017/
- Trip report: Fall ISO C++ standards meeting (Albuquerque)
	- https://herbsutter.com/2017/11/11/trip-report-fall-iso-c-standards-meeting-albuquerque/

---

# C++17

## C++17: Readings

- C++17 features described in Before/After tables ("Tony Tables")
	- https://github.com/tvaneerd/cpp17_in_TTs
- C++17 for the daily job
	- C++ Day 2016 – Italian C++ Community; Marco Arena
	- http://www.italiancpp.org/wp-content/uploads/2016/10/Cpp17-for-the-daily-job.pdf
- Changes between C++14 and C++17
	- 2018-11-26; Thomas Köppe
	- https://wg21.link/p0636
- 17 Smaller but Handy C++17 Features
	- https://www.bfilipek.com/2019/08/17smallercpp17features.html
- C++17 - Egor Bredikhin, 12.10.2017
	- https://www.viva64.com/en/b/0533/
- C++17 - What's New in the Core Language?
	- http://www.modernescpp.com/index.php/cpp17-core
- C++17 Features
	- https://www.bfilipek.com/2017/01/cpp17features.html
	- https://github.com/fenbf/cpp17features
- C++17 in details: language clarifications
	- http://www.bfilipek.com/2017/06/cpp17-details-clarifications.html
- C++17 in detail: Summary & Bonus
	- http://www.bfilipek.com/2017/09/c17-in-detail-summary-bonus.html
- C++ Status at the end of 2016
	- http://www.bfilipek.com/2016/12/c-status-at-end-of-2016.html
- C++ Status at the end of 2017
	- https://www.bfilipek.com/2017/12/cpp-status-2017.html
- What's in C++17? - JF Bastien
	- Slides: https://jfbastien.github.io/what-is-cpp17
	- Source: https://github.com/jfbastien/what-is-cpp17
- What are the new features in C++17?
	- http://stackoverflow.com/questions/38060436/what-are-the-new-features-in-c17/38060437

### C++17: Readings - Books

- A Tour of C++ (Second Edition)
	- 2018; Bjarne Stroustrup
	- http://www.stroustrup.com/tour2.html
- C++17 - The Complete Guide
	- 2019; Nicolai Josuttis
	- https://leanpub.com/cpp17
	- http://www.cppstd17.com/
- C++ Concurrency in Action, Second Edition
	- 2017 (early access) / 2018 (publication)
	- Anthony Williams
	- https://www.manning.com/books/c-plus-plus-concurrency-in-action-second-edition
- C++ Templates - The Complete Guide, 2nd Edition
	- 2017; David Vandevoorde, Nicolai M. Josuttis, and Douglas Gregor
	- http://www.tmplbook.com/
- Programming: Principles and Practice Using C++ (Second Edition)
	- 2014; Bjarne Stroustrup
	- http://www.stroustrup.com/programming.html

## C++17: Talks

- (Ab)using C++17
	- C++Now 2017; Jason Turner
	- https://www.youtube.com/watch?v=AqDsso3S5fg
- Beware of C++17
	- CoreHard Spring 2018; Nicolai Josuttis
	- https://www.youtube.com/watch?v=560l4b3i4ew
	- https://www.slideshare.net/corehard_by/beware-of-c17
	- https://corehard.by/2018/06/13/corehard-spring-2018-nicolai-josuttis-beware-of-c17/
- C++17
	- NDC Oslo 2017; Nicolai Josuttis
	- part 1: The Language Features
		- https://www.youtube.com/watch?v=WDGP5pO1TyM
	- part 2: The Library Features
		- https://www.youtube.com/watch?v=_PEgl63V7wc
- C++17 - The Best Features
	- ACCU 2018; Nicolai Josuttis
	- https://www.youtube.com/watch?v=e2ZQyYr0Oi0
- C++17 in Breadth
	- CppCon 2016; Alisdair Meredith
	- Part 1: https://www.youtube.com/watch?v=22jIHfvelZk
	- Part 2: https://www.youtube.com/watch?v=-rIixnNJM4k
- C++17 Features
	- Bryce Adelstein Lelbach
	- C++Now 2017
		- https://www.youtube.com/watch?v=LvwXJjRQfHk
	- CppCon 2017
		- Part 1: https://www.youtube.com/watch?v=fI2xiUqqH3Q
		- Part 2: https://www.youtube.com/watch?v=qjxBKINAWk0
		- Slides: https://brycelelbach.github.io/cpp17_features/
- C++17 Parallel Algorithms
	- CppCon 2017; Dietmar Kühl
	- https://www.youtube.com/watch?v=Ve8cHE9LNfk&list=PLHTh1InhhwT6bwIpRk0ZbCA0N2p1taxd6&index=120
- C++17 — the biggest traps
	- C++ Russia 2019; Nicolai Josuttis
	- https://www.youtube.com/watch?v=h-zy1hBqT74&list=PLZN9ZGiWZoZry4qywRiaNQ1CqGEpqKyMw&index=9
- C++17: The Language Features
	- NDC 2017; Nicolai Josuttis
	- https://www.youtube.com/watch?v=pEzV32yRu4U
- C++17: The Library Features
	- NDC 2017; Nicolai Josuttis
	- https://www.youtube.com/watch?v=ELwTKHiKZS4
- Clang, libc++ and the C++ standard (C++17)
	- 2016 EuroLLVM Developers' Meeting
	- Marshall Clow, Richard Smith
	- https://www.youtube.com/watch?v=zQ9tT8fbtSo
	- http://llvm.org/devmtg/2016-03/Presentations/Clang-LibCPlusPlus-CPlusPlusStandard.pdf
- Combining C++17 Features
	- NDC TechTown 2019; Nicolai Josuttis
	- https://www.youtube.com/watch?v=cOtb8Sb88TY
- Enhanced Support for Value Semantics in C++17
	- CppCon 2017; Michael Park
	- https://github.com/mpark/cppcon17
	- https://www.youtube.com/watch?v=LmiDF2YheAM
- Exploring C++17 and beyond
	- Mark Isaacson
	- http://maintainablecode.logdown.com/posts/745037-tech-talk-exploring-c-17
	- Meeting C++ 2016 - https://www.youtube.com/watch?v=-ctgSbEfRxU
	- code::dive 2017 - https://www.youtube.com/watch?v=4bcfGjimzec
- How to Adopt Modern C++17 into Your C++ Code
	- Microsoft Build 2018; Herb Sutter
	- https://channel9.msdn.com/events/Build/2018/BRK2146
	- https://www.youtube.com/watch?v=UsrHQAzSXkA
- I Wish I Could Use C++ 1x/y/z
	- CppCon 2017; Joel Falcou
	- https://www.youtube.com/watch?v=gPj90zwLphw&index=119&list=PLHTh1InhhwT6bwIpRk0ZbCA0N2p1taxd6
- Implementing tuple in C++17
	- C++Now 2016; Alisdair Meredith
	- https://www.youtube.com/watch?v=76wBvD8ZVeo
- Practical C++17
	- Jason Turner
	- CppCon 2017
		- https://www.youtube.com/watch?v=nnY4e4faNp0
		- https://github.com/CppCon/CppCon2017/blob/master/Tutorials/Practical%20C%2B%2B17/
	- Meeting C++ 2017
		- https://www.youtube.com/watch?v=YePHP4aIc1g
- Remedial C++17 Language Features
	- NWCPP - Northwest C++ Users Group 2022
	- Peter Williamson
	- https://www.youtube.com/watch?v=f09IzxxEf8s
	- https://nwcpp.org/Oct-2022.html
- Remedial C++17 Library Features
	- NWCPP - Northwest C++ Users Group 2023
	- Peter Williamson
	- https://www.youtube.com/watch?v=U6Eef79GRF4
	- https://nwcpp.org/April-2023.html
- Remedial C++ 17 Library Features - Part 2
	- NWCPP - Northwest C++ Users Group 2023
	- Peter Williamson
	- https://www.youtube.com/watch?v=y3uDSkvZRT4
	- https://nwcpp.org/November-2023.html
- Seventeenification: Porting sqlpp11 to C++17
	- CppCon 2017; Roland Bock
	- https://www.youtube.com/watch?v=bA7b1HEFVFk&list=PLHTh1InhhwT6bwIpRk0ZbCA0N2p1taxd6&index=65
- The C++17 Parallel Algorithms Library and Beyond
	- CppCon 2016; Bryce Adelstein Lelbach
	- https://www.youtube.com/watch?v=Vck6kzWjY88
- The new C++17 and why it's good for you
	- ADC 2017; Timur Doumler
	- https://www.youtube.com/watch?v=ky_eXBMcJK0

## C++17: Trip Reports

### 2017-07 Toronto

- 2017 Toronto ISO C++ Committee Discussion Thread (Concepts in C++20; Coroutines, Ranges and Networking TSes published)
	- https://www.reddit.com/r/cpp/comments/6ngkgc/2017_toronto_iso_c_committee_discussion_thread/
	- https://www.codeplay.com/portal/news/2017/07/10/what-s-in-cpp20-and-the-cpp17-final-score-card-a-report-from-kona-and-look-at-the-toronto-cpp-meeting.html
	- https://herbsutter.com/2017/07/15/trip-report-summer-iso-c-standards-meeting-toronto/
- Red Hat at the ISO C++ Standards Meeting (July 2017): Parallelism and Concurrency
	- https://developers.redhat.com/blog/2017/08/29/red-hat-at-the-iso-c-standards-meeting-july-2017-parallelism-and-concurrency/
- Trip Report: C++ Standards Meeting in Toronto, July 2017
	- https://botondballo.wordpress.com/2017/08/02/trip-report-c-standards-meeting-in-toronto-july-2017/
- Trip report: Evolution Working Group at the Summer ISO C++ standards meeting (Toronto)
	- https://blogs.msdn.microsoft.com/vcblog/2017/07/28/trip-report-evolution-working-group-at-the-summer-iso-c-standards-meeting-toronto/

### 2017-02 Kona

- Trip Report: C++ Standards Meeting in Kona, February 2017
	- https://botondballo.wordpress.com/2017/03/27/trip-report-c-standards-meeting-in-kona-february-2017/
- Trip report: Winter ISO C++ standards meeting (Kona), C++17 is complete
	- https://herbsutter.com/2017/03/24/trip-report-winter-iso-c-standards-meeting-kona-c17-is-complete/
- Red Hat at the ISO C++ Standards Meetings (November 2016, Issaquah, and February 2017, Kona): Library
	- https://developers.redhat.com/blog/2017/06/30/red-hat-at-the-iso-c-standards-meetings-november-2016-issaquah-and-february-2017-kona-library/
- Red Hat at the ISO C++ Standards Meeting (April 2017, Kona): Core Language
	- https://developers.redhat.com/blog/2017/06/27/red-hat-at-the-iso-c-standards-meeting-april-2017-kona-core-language/
- Red Hat at the ISO C++ Standards Meeting (March 2017): Parallelism and Concurrency -
	- https://developers.redhat.com/blog/2017/06/16/red-hat-at-the-iso-c-standards-meeting-march-2017-parallelism-and-concurrency/

### 2016-11 Issaquah

- The view from Nov 2016 C++ Standard Meeting Issaquah
	- https://www.codeplay.com/portal/12-09-16-the-view-from-nov-2016-cpp-standard-meeting-issaquah
- Trip Report: C++ Standards Meeting in Issaquah, November 2016
	- https://botondballo.wordpress.com/2016/11/25/trip-report-c-standards-meeting-in-issaquah-november-2016/
- Trip report: Fall ISO C++ standards meeting (Issaquah)
	- https://herbsutter.com/2016/11/15/trip-report-fall-iso-c-standards-meeting-issaquah/

### 2016-06 Oulu

- C++17, All Final Features from Oulu in a Few Slides
	- https://codeplay.com/portal/c17-all-final-features-from-oulu-in-a-few-slides
	- Slides (PDF): https://codeplay.com/public/uploaded/filehost/0cbdaf_c++17post-oulu2016.pdf
- C++: Oulu Trip Report (Part I)
	- https://usingstdcpp.org/2016/07/07/cpp-oulu-trip-report-part-i/
- Red Hat at the ISO C++ Standards Meeting (June 2016, Oulu): Core Language
	- https://developers.redhat.com/blog/2016/07/13/red-hat-iso-c-standards-meeting-june-2016-core-language/
- Red Hat at the ISO C++ Standards Meeting (June 2016, Oulu): Library
	- https://developers.redhat.com/blog/2016/07/18/red-hat-at-the-iso-c-standards-meeting-june-2016-oulu-library/
- Red Hat at the ISO C++ Standards Meeting (June 2016, Oulu): Parallelism and Concurrency
	- https://developers.redhat.com/blog/2016/07/15/red-hat-at-the-iso-c-standards-meeting-june-2016-oulu-parallelism-and-concurrency/
- Trip Report: C++ Standards Meeting in Oulu, June 2016
	- https://botondballo.wordpress.com/2016/07/06/trip-report-c-standards-meeting-in-oulu-june-2016/
- Trip report: Summer ISO C++ standards meeting (Oulu)
	- https://herbsutter.com/2016/06/30/trip-report-summer-iso-c-standards-meeting-oulu/
- What the ISO C++ committee added to the C++17 working draft at the Oulu 2016 meeting
	- https://www.reddit.com/r/cpp/comments/4pmlpz/what_the_iso_c_committee_added_to_the_c17_working/

### 2016-03 Jacksonville

- Jacksonville C++ Core Language Meeting Report
	- https://developers.redhat.com/blog/2016/05/16/jacksonville-c-core-language-meeting-report/
- Red Hat at the ISO C++ Standards Meeting (March 2016): Library
	- https://developers.redhat.com/blog/2016/06/02/red-hat-at-the-iso-c-standards-meeting-march-2016-library/
- Red Hat at the ISO C++ Standards Meeting (March 2016): Parallelism, Concurrency, and Coroutines
	- https://developers.redhat.com/blog/2016/04/21/red-hat-at-the-iso-c-standards-meeting-march-2016-parallelism-concurrency-and-coroutines/
- Trip report: C++ meeting at Jacksonville - https://usingstdcpp.org/2016/03/05/trip-report-c-meeting-at-jacksonville/

### 2015-05 Lenexa

- Lenexa C++ Meeting Report (Core Language)
	- https://developers.redhat.com/blog/2015/06/10/lenexa-c-meeting-report-core-language/
- Red Hat at the ISO C++ Standards Meeting (May 2015): Parallelism and Concurrency
	- https://developers.redhat.com/blog/2015/06/16/red-hat-at-the-iso-c-standards-meeting-may-2015-parallelism-and-concurrency/

### 2014-11 Urbana-Champaign

- Red Hat at the ISO C++ Standards Meeting (November 2014): Core
	- https://developers.redhat.com/blog/2014/12/09/red-hat-at-the-iso-c-standards-meeting-november-2014-core/
- Red Hat at the ISO C++ Standards Meeting (November 2014): Library
	- https://developers.redhat.com/blog/2014/12/16/red-hat-at-the-iso-c-standards-meeting-november-2014-library/
- Red Hat at the ISO C++ Standards Meeting (Nov 2014): Parallelism and Concurrency
	- https://developers.redhat.com/blog/2014/12/11/red-hat-at-iso-cpp-standards-meeting-nov-2014-parallelism-concurrency/

### 2014-06 Rapperswil

- Red Hat at the ISO C++ Standards Meeting (June 2014): Core and Library
	- https://developers.redhat.com/blog/2014/08/21/iso-cxx-meeting-rapperswil-2014-core-library/
- Red Hat at the ISO C++ Standards Meeting (June 2014): Parallelism and Concurrency
	- https://developers.redhat.com/blog/2014/08/20/red-hat-iso-c-standards-meeting-june-2014-parallelism-concurrency/

---

# C++14

## C++14: Readings

- C++ FAQ
	- C++14 Overview: https://isocpp.org/wiki/faq/cpp14
	- C++14 Language Extensions: https://isocpp.org/wiki/faq/cpp14-language
	- C++14 Library Extensions: https://isocpp.org/wiki/faq/cpp14-library
- Changes between C++11 and C++14
	- 2018-10-08; Thomas Köppe
	- http://wg21.link/p1319

### C++14: Readings - Books

- Effective Modern C++: 42 Specific Ways to Improve Your Use of C++11 and C++14
	- 2014; Scott Meyers
	- http://shop.oreilly.com/product/0636920033707.do

## C++14: Talks

- A Tutorial Introduction to C++11/14
	- C++Now 2014; Leor Zolman
	- Part I - https://www.youtube.com/watch?v=TK_SfTfxaxc
	- Part II - https://www.youtube.com/watch?v=oTQ0kn0E9xI
- An Overview of C++11/14
	- CppCon 2014; Leor Zolman
	- Part I - https://www.youtube.com/watch?v=Gycxew-hztI
	- Part II - https://www.youtube.com/watch?v=pBI0tS2yfjw
- Backporting to the Future
	- Pacific++ 2018: Andrew Paxie
	- https://www.youtube.com/watch?v=KKvSVyZ4_5k
- C++11/14 at Scale: What Have We Learned?
	- Vittorio Romeo
	- ACCU 2021
		- https://www.youtube.com/watch?v=H8wzuvynV78
		- https://accu.org/conf-docs/PDFs_2021/vittorio_romeo_cpp_11_14_at_scale_what_have_we_learned.pdf
	- CppCon 2021
		- https://www.youtube.com/watch?v=7Mfbpbyq6fs
- C++14: Through the Looking Glass
	- C++Now 2014; Michael Wong
	- https://www.youtube.com/watch?v=a8cb0IFqae8
- Dive into C++11/14 - Vittorio Romeo
	- https://www.youtube.com/playlist?list=PLTEcWGdSiQenl4YRPvSqW7UPC6SiGNN7e
- Migration of C++ Libraries to C++14
	- Meeting C++ 2015; Joel Falcou
	- https://www.youtube.com/watch?v=idPThkw2p6c
- What's New In The C++14 Library
	- CppCon 2014; Alisdair Meredith
	- https://www.youtube.com/watch?v=fBU1R7jp_TE
- Writing Good C++14... By Default
	- CppCon 2015; Herb Sutter
	- https://www.youtube.com/watch?v=hEx5DNLWGgA

## C++14: Trip Reports

- Red Hat at the ISO C++ Standards Meeting (February 2014)
	- https://developers.redhat.com/blog/2014/05/28/red-hat-iso-c-standards-meeting-february-2014/
- Red Hat at the ISO C++ Standards Meeting, Bristol, UK
	- https://developers.redhat.com/blog/2013/05/16/red-hat-at-the-iso-c-standards-meeting-bristol-uk/

---

# C++11

## C++11: Readings

- Posts: Leaving C++03 - Going to C++11
	- https://www.implementingquantlib.com/posts/going-to-11.html

### C++11: Readings - Books

- A Tour of C++
	- 2013; Bjarne Stroustrup
	- http://www.stroustrup.com/Tour.html
	- https://isocpp.org/tour
- C++ Primer (5th Edition)
	- 2012; Stanley B. Lippman and Josée Lajoie
	- http://www.informit.com/store/c-plus-plus-primer-9780321714114
- Programming: Principles and Practice Using C++
	- 2008; Bjarne Stroustrup
	- http://www.stroustrup.com/programming1.html
- The C++ Programming Language, 4th Edition
	- 2013; Bjarne Stroustrup
	- http://www.stroustrup.com/4th.html
- The C++ Standard Library: A Tutorial and Reference (2nd Edition)
	- 2012; Nicolai M. Josuttis
	- http://www.cppstdlib.com/

## C++11: Talks

- A Whirlwind Overview of C++11
	- C++Now 2012; Leor Zolman
	- https://www.youtube.com/watch?v=jrCrWdrH17g
- A Zephyr Overview of C++11
	- C++Now 2013; Leor Zolman
	- Part I - https://www.youtube.com/watch?v=quZ8gttFgtQ
	- Part II - https://www.youtube.com/watch?v=hn4jtjbxO14
- C++11 Library Design
	- C++Now 2014; Eric Niebler
	- https://www.youtube.com/watch?v=zgOF4NrQllo
- C++11: New Tools for Class and Library Authors
	- C++Now 2012; Scott Schurr
	- https://www.youtube.com/watch?v=qOPLwkBHpx8
- Fresh Paint
	- C++Now 2011; Alisdair Meredith
	- https://www.youtube.com/watch?v=ourmFvidEpk
- Introduction to Modern C++ Techniques
	- C++Now 2012; Michael Caisse
	- Part I - https://www.youtube.com/watch?v=9TFV2JxX7L0
	- Part II - https://www.youtube.com/watch?v=urshrBatNo4
- Other C++11 Gems
	- C++Now 2012; Beman Dawes, Jeff Garland, Alisdair Meredith
	- https://www.youtube.com/watch?v=28A7bl2DjvY
- Remedial C++ 11
	- Northwest C++ Users Group 2019; Pete Williamson
	- https://www.youtube.com/watch?v=i1zNN_U6tEQ
	- https://nwcpp.org/January-2019.html

---

# History

- C++ Historical Sources Archive
	- http://www.softwarepreservation.org/projects/c_plus_plus/
	- https://mcjones.org/dustydecks/archives/2007/06/11/61/
- Bjarne Stroustrup's Homepage
	- http://www.stroustrup.com/
- Brian Kernighan's Home Page
	- https://www.cs.princeton.edu/~bwk/
- Collected Papers of Alexander A. Stepanov
	- http://stepanovpapers.com/
- Dennis M. Ritchie's Home Page
	- https://www.bell-labs.com/usr/dmr/www/
- History of C++
	- https://en.cppreference.com/w/cpp/language/history
- Standard Template Library Programmer's Guide
	- https://www.boost.org/sgi/stl/
	- https://github.com/justinmeiners/sgi-stl-docs
	- http://www.martinbroadhurst.com/stl/
	- http://www.rrsd.com/software_development/stl/

## History (2020)

- ISO/IEC 14882:2020 - https://www.iso.org/standard/79358.html
- Direction for ISO C++
	- 2020-01-13
	- Michael Wong, Howard Hinnant, Roger Orr, Bjarne Stroustrup, Daveed Vandevoorde
	- https://wg21.link/p2000
	- http://www.open-std.org/jtc1/sc22/wg21/docs/papers/2020/p2000r1.pdf
- Thriving in a Crowded and Changing World: C++ 2006–2020
	- ACM/SIGPLAN History of Programming Languages HOPL-IV 2020
	- Bjarne Stroustrup
	- https://www.stroustrup.com/hopl20main-p5-p-bfc9cd4--final.pdf
	- https://doi.org/10.1145/3386320
	- https://www.pldi21.org/prerecorded_hopl.5.html

## History (2019)

- Bjarne Stroustrup: C++
	- 2019 Artificial Intelligence (AI) Podcast
	- https://lexfridman.com/bjarne-stroustrup/
	- https://www.youtube.com/watch?v=uTxRF5ag27A
- Direction for ISO C++
	- 2019-10-07
	- H. Hinnant, R. Orr, B. Stroustrup, D. Vandevoorde, M. Wong
	- https://wg21.link/P0939
- The Continuing Evolution of C++
	- 2019; Celebrating Honoris Causa Doctorate at UC3M (Universidad Carlos III de Madrid)
	- Bjarne Stroustrup
	- https://www.youtube.com/watch?v=ooehrkYkGdA
- Unix50 - Unix Today and Tomorrow: The Languages
	- https://www.youtube.com/watch?v=xnCgoEyz31M
	- "Brian Kernighan discussed the little languages of Unix and how it works well with other programming languages while Bjarne Stroustrup focused on the journey from C to C++ and its value. Tom Van Cutsem, Lieven Trappeniers and Lode Hoste of Nokia Bell Labs discussed new computational tools being created using Augmented/Artificial intelligence and machine learning that are transforming software development."

## History (2017)

- ISO/IEC 14882:2017 - https://www.iso.org/standard/68564.html
- C++ Stability, Velocity, and Deployment Plans
	- 2017-06-19
	- Titus Winters, Bjarne Stroustrup, Daveed Vandevoorde, Beman Dawes, Michael Wong, Howard Hinnant
	- https://wg21.link/P0684R0
- History and Spirit of C
	- NDC Techtown 2017; Olve Maudal
	- https://www.youtube.com/watch?v=xGVRF-Y--hI
- Operating principles for evolving C++
	- 2017-01-31
	- JC van Winkel, Jose Daniel Garcia, Ville Voutilainen, Roger Orr, Michael Wong, Sylvain Bonnal
	- https://wg21.link/P0559
- Oral History of Brian Kernighan
	- Interviewed by John R. Mashey on 2017-04-24
	- https://www.youtube.com/watch?v=bTWv-l0JhAc
	- https://www.computerhistory.org/collections/catalog/102740169
- The Continuing Evolution of C++
	- 2017 Strachey Lecture, University of Oxford
	- Bjarne Stroustrup
	- http://podcasts.ox.ac.uk/continuing-evolution-c
	- http://www.cs.ox.ac.uk/seminars/1886.html

## History (2016)

- AlexFest!
	- A celebration of the work of Alexander A. Stepanov.
	- https://www.youtube.com/playlist?list=PLHxtyCq_WDLWyNjTNTxEow-6EgF2roZOu
- C++ Today (C++14)
	- Churchill College, May 2016; Bjarne Stroustrup
	- https://www.youtube.com/watch?v=aPvbxuOBQ70
- What C++ is and what it will become
	- Meeting C++ 2016 (Keynote); Bjarne Stroustrup
	- https://www.youtube.com/watch?v=DvUL0Y2bpyc

## History (2015)

- Brian Kernighan (2015) Computerphile
	- https://www.youtube.com/playlist?list=PLzH6n4zXuckqZ90zLyy36qjO5YIn1RulG
- C and Unix at Bell Labs
	- VCF East 10; Brian Kernighan
	- https://www.youtube.com/watch?v=TUWt_StXKsY
	- https://www.youtube.com/watch?v=-dxTlU0CB8g
- History and Spirit of C and C++
	- NDC 2015; Olve Maudal
	- https://vimeo.com/132192250
- How to succeed in language design without really trying
	- 2015; Brian Kernighan
	- https://www.youtube.com/watch?v=Sg4U4r_AgJU
- Object Oriented Programming without Inheritance
	- ECOOP 2015; Bjarne Stroustrup
	- https://www.youtube.com/watch?v=xcpSLRpOMJM
- Oral history of Bjarne Stroustrup
	- Bjarne Stroustrup interviewed by Paul McJones (2015)
	- https://www.computerhistory.org/collections/catalog/102740024
	- http://www.mcjones.org/dustydecks/archives/2015/04/06/799/
- Thoughts about C++17
	- 2015-05-15
	- Bjarne Stroustrup
	- https://wg21.link/N4492
- What – if anything – have we learned from C++?
	- Curry On/PLE 2015 (Keynote); Bjarne Stroustrup
	- https://www.youtube.com/watch?v=2egL4y_VpYg

## History (2014)

- ISO/IEC 14882:2014 - https://www.iso.org/standard/64029.html
- The Essence of C++
	- 2014; The University of Edinburgh; Bjarne Stroustrup
	- https://www.youtube.com/watch?v=86xWVb4XIyE
- Why C++ Sails When the Vasa Sank
	- Yandex Moscow C++ Party 2014
	- Scott Meyers
	- https://www.youtube.com/watch?v=ltCgzYcpFUI
	- http://www.aristeia.com/TalkNotes/C++vstheVasa2-ups.pdf
	- https://scottmeyers.blogspot.com/2014/06/another-new-video.html
	- https://events.yandex.ru/lib/talks/1954/

## History (2012)

- Dennis Ritchie Day at Bell Labs, Murray Hill, NJ, September 7, 2012
	- [Bell Labs Tribute to Dennis Ritchie](https://www.prnewswire.com/news-releases/alcatel-lucents-bell-labs-hosts-event-to-explore-the-impact-of-software-on-society-and-to-honor-the-life-of-dennis-ritchie---the-co-inventor-of-unix-168600196.html)
	- The Lasting Legacy of Dennis Ritchie: The Impact of Software on Society
		- 2012; Brian Kernighan
		- https://vimeo.com/73293774
		- https://www.youtube.com/watch?v=uxtKwJZbYr0
	- Al Aho from Columbia University at the Dennis Ritchie Tribute at Bell Labs
		- https://vimeo.com/73296848
		- http://www.cs.columbia.edu/%7Eaho/Talks/12-09-07_DMR.pdf
	- Doug McIlroy at the Dennis Ritchie Tribute at Bell Labs
		- https://vimeo.com/73204980
- Workshop on Quality Software: A Festschrift for Bjarne Stroustrup
	- https://parasollab.web.illinois.edu/events/bjarnefest/
	- https://www.youtube.com/playlist?list=PLRgQTVaiosr8MCB7CAwvtNMa-zAnW1_Vz

## History (2011)

- ISO/IEC 14882:2011 - https://www.iso.org/standard/50372.html
- Why I Created C++
	- 2011
	- Bjarne Stroustrup
	- https://www.youtube.com/watch?v=JBjjnqG0BP8
	- http://bigthink.com/videos/why-i-created-c

## History (pre-2011)

- 2007
	- Evolving a language in and for the real world: C++ 1991-2006
		- HOPL III 2007; Bjarne Stroustrup
		- http://www.stroustrup.com/hopl-almost-final.pdf
		- slides & videos: http://portal.acm.org/toc.cfm?id=1238844
- 2003
	- ISO/IEC 14882:2003 - https://www.iso.org/standard/38110.html
- 2002
	- C and C++: Siblings
		- The C/C++ Users Journal 2002; Bjarne Stroustrup
		- http://www.stroustrup.com/siblings_short.pdf
	- Sibling rivalry: C and C++
		- 2002; Bjarne Stroustrup
		- http://www.stroustrup.com/sibling_rivalry.pdf
	- STL and Its Design Principles
		- 2002; Alexander Stepanov
		- https://www.youtube.com/watch?v=COuHLky7E2Q
		- https://www.youtube.com/watch?v=1-CmNNp5eag
- 1999
	- An Overview of the C++ Programming Language
		- The Handbook of Object Technology (Editor: Saba Zamir) 1999
		- Bjarne Stroustrup
		- http://www.stroustrup.com/crc.pdf
- 1998
	- ISO/IEC 14882:1998 - https://www.iso.org/standard/25845.html
- 1994
	- The Design and Evolution of C++
		- 1994; Bjarne Stroustrup
		- http://www.stroustrup.com/dne.html
	- The Design of C++
		- March 1994; Bjarne Stroustrup
		- https://www.youtube.com/watch?v=69edOm889V4
		- http://www.computerhistory.org/collections/catalog/102624733
	- The programming language standards scene, ten years on Paper 16: C++
		- Computer Standards & Interfaces 16 (1994)
		- Richard M. De Morgan
		- https://doi.org/10.1016/0920-5489(94)90036-1
- 1993
	- Five Little Languages and How They Grew: Talk at HOPL
		- HOPL II 1993; Dennis M. Ritchie
		- https://www.bell-labs.com/usr/dmr/www/hopl.html
	- The Development of the C Language
		- Dennis M. Ritchie
		- https://www.bell-labs.com/usr/dmr/www/chist.html
	- A History of C++: 1979−1991
		- HOPL II 1993; Bjarne Stroustrup
		- http://www.stroustrup.com/hopl2.pdf
- 1989
	- From C to C++: Interviews With Dennis Ritchie and Bjarne Stroustrup
		- January 01, 1989; Al Stevens
		- http://www.drdobbs.com/cpp/from-c-to-c-interviews-with-dennis-ritch/184408272
- 1988
	- The State of C
	- Brian W. Kernighan and Dennis M. Ritchie
		- http://www.drdobbs.com/cpp/the-state-of-c/223000089
		- https://archive.org/stream/BYTE-1988-08#page/n330/
- 1983
	- Adding classes to the C language: An exercise in language evolution
		- Software: Practice and Experience, 13(2) 1983; Bjarne Stroustrup
		- https://doi.org/10.1002/spe.4380130205
- 1982
	- Classes: an abstract data type facility for the C language
		- SIGPLAN Notices 17, 1 (January 1982); Bjarne Stroustrup
		- https://doi.org/10.1145/947886.947893
