# [C++ links](README.md): computer architecture

See also: [Assembly (Arm)](assembly.arm.md), [Assembly (RISC-V)](assembly.riscv.md), [Assembly (x86)](assembly.x86.md)

# Contents

- [Books](#books)
- [Communities](#communities)
- [Competitions](#competitions)
- [Conferences](#conferences)
- [Courses](#courses)
- [Emulation & Simulation](#emulation--simulation)
- [Journals & Publications](#journals--publications)

---

# Books

- The Elements of Computing Systems: Building a Modern Computer from First Principles
	- Build a Modern Computer from First Principles: From NAND to Tetris
	- Noam Nisan and Shimon Schocken
	- 2nd Edition; 2021 
	- http://www.nand2tetris.org/
	- (no prerequisites)
- Introduction to Computing Systems: From Bits & Gates to C/C++ & Beyond
	- Yale Patt and Sanjay Patel
	- (3rd Edition; 2020)
	- https://www.mheducation.com/highered/product/introduction-computing-systems-bits-gates-c-c-beyond-patt-patel/M9781260150537.html
	- (no prerequisites, freshmen year level)
- Digital Design and Computer Architecture
	- ARM Edition (1st Edition; 2015): https://www.elsevier.com/books/digital-design-and-computer-architecture/harris/978-0-12-800056-4
	- RISC-V Edition (1st Edition; 2021): https://www.elsevier.com/books/digital-design-and-computer-architecture-risc-v-edition/harris/978-0-12-820064-3
	- (background; no prerequisites beyond basic programming) digital logic, hardware 
- Computer Systems: A Programmer's Perspective (CS:APP)
	- http://csapp.cs.cmu.edu/
	- (undergraduate level, basic programming background helpful)
- Computer Organization and Design: The Hardware-Software Interface
	- David A. Patterson, John L. Hennessy
	- RISC-V Edition (2nd Edition; 2020) - https://www.elsevier.com/books/computer-organization-and-design-risc-v-edition/patterson/978-0-12-820331-6
	- (undergraduate level)
- Computer Architecture: A Quantitative Approach
	- John L. Hennessy, David A. Patterson 
	- 6th Edition; 2017 - https://www.elsevier.com/books/computer-architecture/hennessy/978-0-12-811905-1
	- (graduate level)
- Modern Processor Design: Fundamentals of Superscalar Processors
	- J.P. Shen and M.H. Lipasti
	- 2005
	- https://www.waveland.com/browse.php?t=624
- Readings in Computer Architecture
	- 1999
	- Mark D. Hill, Norman P. Jouppi, Gurindar S. Sohi
	- http://pages.cs.wisc.edu/~markhill/readings/www/
	- (a collection of seminal papers in computer architecture)
- ACM International Conference on Supercomputing (ICS) 25th Anniversary Volume
	 2014
	- https://dl.acm.org/citation.cfm?id=2591635&picked=prox
- Synthesis Lectures on Computer Architecture
	- https://dblp.org/db/series/synthesis-cac
	- https://www.springer.com/series/16916

---

# Communities

- Computer Architecture Community - https://comp-arch-community.slack.com/ ([invitation](https://join.slack.com/t/comp-arch-community/shared_invite/enQtNTAwNTcxMTQ4NzU4LTZmOGY0NGI4NDIzY2NmZWMxNjBlMGJmYTMzNzkxNzc2YmQ1OTAwZTE4ODRmN2FmZmYwNGFhODIxOGE2YWQwNWM))
- Computer Architecture Student Association
	- https://www.comparchsa.org/
- Computer Science Research and Practice: `#architecture`
	- Slack Workspace: https://cs-research-practice.slack.com
	- Invitation: https://bit.ly/join-cs-slack

---

# Competitions

- The 1st JILP Championship Branch Prediction Competition (CBP-1)
	- http://www.jilp.org/cbp/
- The 1st JILP Data Prefetching Championship (DPC-1)
	- http://www.jilp.org/dpc/
- The 2nd Data Prefetching Championship (DPC-2)
	- http://comparch-conf.gatech.edu/dpc2/
- The 2nd Cache Replacement Championship (CRC-2)
	- http://crc2.ece.tamu.edu/
- The 1st Instruction Prefetching Championship (IPC-1)
	- https://research.ece.ncsu.edu/ipc/

## Journal of Instruction-Level Parallelism (JILP) Workshop on Computer Architecture Competitions (JWAC)

- 1st JILP Workshop on Computer Architecture Competitions (JWAC-1): Cache Replacement Championship (CRC)
	- http://www.jilp.org/jwac-1/
- 2nd JILP Workshop on Computer Architecture Competitions (JWAC-2): Championship Branch Prediction (CBP-2)
	- http://www.jilp.org/jwac-2/
- 3rd JILP Workshop on Computer Architecture Competitions (JWAC-3): Memory Scheduling Championship (MSC)
	- https://www.cs.utah.edu/~rajeev/jwac12/
- 4th JILP Workshop on Computer Architecture Competitions (JWAC-4): Championship Branch Prediction (CBP-4)
	- http://www.jilp.org/cbp2014/
- 5th JILP Workshop on Computer Architecture Competitions (JWAC-5): Championship Branch Prediction (CBP-5)
	- http://www.jilp.org/cbp2016/
- 6th JILP Workshop on Computer Architecture Competitions (JWAC-6): Championship Value Prediction (CVP-1)
	- https://www.microarch.org/cvp1/

---

# Conferences

- ASPLOS: International Conference on Architectural Support for Programming Languages and Operating Systems - https://asplos-conference.org/ - http://dblp.uni-trier.de/db/conf/asplos/
- Hot Chips: A Symposium on High Performance Chips - http://www.hotchips.org/archives/
- HPCA: International Symposium on High-Performance Computer Architecture - http://www.hpca-conf.org/ - http://dblp.uni-trier.de/db/conf/hpca/
- ICS: International Conference on Supercomputing - http://www.ics-conference.org/ - http://dblp.uni-trier.de/db/conf/ics/
- ISCA: International Symposium on Computer Architecture - https://iscaconf.org/ - http://dblp.uni-trier.de/db/conf/isca/
- MICRO: International Symposium on Microarchitecture - http://www.microarch.org/ - http://dblp.uni-trier.de/db/conf/micro/
- PACT: International Conference on Parallel Architecture and Compilation - http://pactconf.org/ - http://dblp.uni-trier.de/db/conf/IEEEpact/
- WikiCFP (Calls For Papers) - http://www.wikicfp.com/cfp/call?conference=computer%20architecture

---

# Courses

- Computer Architecture - Princeton University / Coursera
	- https://www.coursera.org/course/comparch
- CS/ECE 3810 Computer Organization - University of Utah
	- Prof. Rajeev Balasubramonian
	- https://www.cs.utah.edu/~rajeev/cs3810/
	- https://www.youtube.com/playlist?list=PLm7BxCUdWqZzjZ-jRe73KUfj2GsSS2FPy
- CS/EE 6810 Computer Architecture, University of Utah
	- Prof. Rajeev Balasubramonian
	- http://www.eng.utah.edu/~cs6810/
	- https://www.youtube.com/playlist?list=PL8EC1756A7B1764F6
- Great Ideas in Computer Architecture (Machine Structures) - UC Berkeley
	- http://inst.eecs.berkeley.edu/~cs61c/
	- Computer Science 61C, 001 - Spring 2015
		- https://archive.org/details/ucberkeley-webcast-PL-XXv-cvA_iCl2-D-FS5mk0jFF6cYSJs_
- High-performance and Embedded Computer Architecture
	- TU Berlin, Embedded Systems Architecture; Prof. Juurlink
	- https://www.youtube.com/channel/UCPSsA8oxlSBjidJsSPdpjsQ/
- High Performance Computer Architecture - Georgia Institute of Technology / Udacity
	- https://www.udacity.com/course/high-performance-computer-architecture--ud007
- Onur Mutlu's Lecture Videos and Materials - Carnegie Mellon, ETH
	- http://people.inf.ethz.ch/omutlu/lecture-videos.html
	- _(Strongly recommended -- both the videos as well as the carefully selected, highly relevant readings!)_
- Parallel Computer Architecture and Programming (CMU 15-418/618)
	- http://15418.courses.cs.cmu.edu/
- MIT 6.004 Computation Structures
	- https://6004.mit.edu/
	- YouTube: https://www.youtube.com/channel/UC1DcxXg6GkAcp2zk2w7U6qQ
	- OCW: https://ocw.mit.edu/courses/electrical-engineering-and-computer-science/6-004-computation-structures-spring-2009/
	- edX
		- edX Part 1: Digital Circuits - https://www.edx.org/course/computation-structures-part-1-digital-mitx-6-004-1x-0
		- edX Part 2: Computer Architecture - https://www.edx.org/course/computation-structures-2-computer-mitx-6-004-2x
		- edX Part 3: Computer Organization - https://www.edx.org/course/computation-structures-3-computer-mitx-6-004-3x-0
- MIT 6.172 Performance Engineering of Software Systems, Fall 2010
	- https://www.youtube.com/playlist?list=PLD2AE32F507F10481
	- https://ocw.mit.edu/courses/electrical-engineering-and-computer-science/6-172-performance-engineering-of-software-systems-fall-2010/video-lectures/
- The Hardware/Software Interface - University of Washington
	- http://courses.cs.washington.edu/courses/cse351/
- Workshops on Computer Architecture Education
	- https://people.engr.ncsu.edu/efg/wcaes.html
	- https://projects.ncsu.edu/wcae/

## Courses: Memory

- Memory Device Technologies and Applications
	- Georgia Tech
	- Fall 2021; Shimeng Yu
	- https://www.youtube.com/playlist?list=PLnQi8W6dRSW5yM5nmfEwA4aqUr5EHZqw4

---

# Emulation & Simulation

## Readings

- A Look at Computer Architecture Evaluation Methodologies
	- Mario Badr and Natalie Enright Jerger
	- Workshop on Pioneering Processor Paradigms (WP3) 2018
	- http://mariobadr.com/pdfs/2018-02-25-WP3-paper.pdf
	- http://mariobadr.com/pdfs/2018-02-25-WP3-presentation.pdf
	- Survey on Computer Architecture Evaluation Methodologies
		- https://github.com/mariobadr/survey-wp3
- A Survey of Cache Simulators
	- ACM Computing Surveys (CSUR) 2019
	- Hadi Brais, Rajshekar Kalayappan, Preeti Ranjan Panda
	- https://homepages.iitdh.ac.in/~rajshekar.k/papers/Survey_Of_Cache_Simulators.pdf
	- A survey on architectural simulators focused on CPU caches
		- https://github.com/hadibrais/archsim
- A Survey of Computer Architecture Simulation Techniques and Tools
	- IEEE Access 2019
	- Ayaz Akram, Lina Sawalha
	- https://ieeexplore.ieee.org/document/8718630

## Software

- ChampSim
	- https://github.com/ChampSim/ChampSim
	- The Championship Simulator: Architectural Simulation for Education and Competition
		- 2022
		- Nathan Gober, Gino Chacon, Lei Wang, Paul V. Gratz, Daniel A. Jiménez, Elvira Teran, Seth H. Pugsley, Jinchun Kim
		- https://arxiv.org/abs/2210.14324
- gem5 - http://gem5.org/
	- Learning gem5: http://learning.gem5.org/
		- Book: https://github.com/powerjg/learning_gem5
		- Tutorial: http://learning.gem5.org/tutorial/
			- Slides (HPCA 2017): http://www.cs.wisc.edu/multifacet/papers/learning_gem5_tutorial.pdf
			- Videos (HPCA 2017): https://www.youtube.com/playlist?list=PL-J9GXT0E7AIidmX_DW7pooRJzjoaJtix
- GPGPU-Sim
	- http://www.gpgpu-sim.org/
	- https://github.com/gpgpu-sim/gpgpu-sim_distribution
- Intel Software Development Emulator (SDE) - https://software.intel.com/en-us/articles/intel-software-development-emulator
- MacSim: Simulator for Heterogeneous Architecture
	- a cycle-level, heterogeneous architecture simulator for x86 and NVIDIA PTX instructions
	- http://comparch.gatech.edu/hparch/macsim.html
	- https://github.com/gthparch/macsim
- MARSSx86
	- http://marss86.org/
	- https://github.com/avadhpatel/marss
- Multi2Sim
	- http://www.multi2sim.org/
	- https://github.com/Multi2Sim/multi2sim
- QEMU: a generic and open source machine & userspace emulator and virtualizer
	- https://www.qemu.org/
	- https://gitlab.com/qemu-project/qemu
	- QEMU internals: A series of posts about QEMU internals
		- https://airbus-seclab.github.io/qemu_blog/
	- QEMU, a Fast and Portable Dynamic Translator
		- 2005 USENIX Annual Technical Conference
		- Fabrice Bellard
		- https://www.usenix.org/conference/2005-usenix-annual-technical-conference/qemu-fast-and-portable-dynamic-translator
- SimEng (the Simulation Engine): a framework for building modern cycle-accurate processor simulators
	- https://github.com/UoB-HPC/SimEng
	- https://uob-hpc.github.io/SimEng/
- Sniper - http://snipersim.org/
- Structural Simulation Toolkit (SST) - http://sst-simulator.org/
	- https://github.com/sstsimulator
	- Modsim2017 Presentation: http://hpc.pnl.gov/modsim/2017/Presentations/SST_Modsim17.pdf
	- SST components overview (2016): https://www.youtube.com/watch?v=D5gDYy9aqf4
	- ISCA 2015 Tutorial: https://www.osti.gov/scitech/servlets/purl/1257684
- XIOSim - A detailed microarchitectural x86 simulator
	- https://github.com/s-kanev/XIOSim
- ZSim
	- https://github.com/s5z/zsim
	- http://zsim.csail.mit.edu/tutorial/

---

# Journals & Publications

- ACM SIGARCH - https://www.sigarch.org/
	- Computer Architecture News: http://dl.acm.org/citation.cfm?id=J89
	- Computer Architecture Today: https://www.sigarch.org/blog/
- ACM Transactions on Architecture and Code Optimization - http://taco.acm.org/
- Andy Glew's CompArch wiki - https://sites.google.com/site/paulclaytonplace/andy-glew-s-comparch-wiki
- Computer Architecture Journals List - http://pascal.eng.uci.edu/info/jounral_list.htm
- IEEE Computer Architecture Letters (CAL) - https://www.computer.org/web/cal
- IEEE Micro - https://publications.computer.org/micro/
- IEEE Technical Committee on Computer Architecture (TCCA) Awards - http://ieeetcca.org/awards/
- ISCA: International Symposium on Computer Architecture
	- Influential ISCA Paper Award
		- https://www.sigarch.org/awards/acm-sigarchieee-cs-tcca-influential-isca-paper-award/
	- 25 years of ISCA (1973-1995)
		- https://dl.acm.org/doi/proceedings/10.1145/285930
	- ISCA@50 Retrospective: 1996-2020
		- https://www.sigarch.org/isca50-retrospective-1996-2020/
		- https://sites.coecis.cornell.edu/isca50retrospective/
- MICRO Test of Time (ToT) Award - http://www.microarch.org/Micro-ToT-Award/
