from tests import TestCase

from src.masonite.utils.http import generate_wsgi
from src.masonite.request import Request


class TestRequest(TestCase):
    def setUp(self):
        super().setUp()
        self.request = Request(generate_wsgi(path="/test"))

    def test_request_no_input_returns_empty_string(self):
        self.assertEqual(self.request.input("notavailable"), "")

    def test_request_can_get_string_value(self):
        self.request.input_bag.query_string = {"test": "value"}
        self.assertEqual(self.request.input("test"), "value")

    def test_request_can_get_list_value(self):
        self.request.input_bag.query_string = {"test": ["foo", "bar"]}
        self.assertEqual(self.request.input("test"), ["foo", "bar"])

    def test_request_can_get_float_value(self):
        self.request.input_bag.query_string = {"test": 3.1415926}
        self.assertEqual(self.request.input("test"), 3.1415926)

    def test_request_can_get_nested_value_from_query_string(self):
        self.request.input_bag.query_string = {"key": "val", "a": {"b": {"c": 1}}}
        self.assertEqual(self.request.input("a.b.c"), 1)

    def test_request_can_get_nested_value_from_post_data(self):
        self.request.input_bag.post_data = {"key": "val", "a": {"b": {"c": 1}}}
        self.assertEqual(self.request.input("a.b.c"), 1)

    def test_request_can_get_nested_value_from_post_data_using_wildcard(self):
        self.request.input_bag.post_data = {"key": "val", "a": {"b": [{"i": 1,"c":2} ,{"i":6, "c":8}]}}
        self.assertEqual(self.request.input("a.b.*.i"), [1,6])