from typing import Callable, Any
from jinja2 import PackageLoader, BaseLoader

class View:
    """View facade."""

    def render(template: str, dictionary: dict = {}) -> "View":
        """Render the given template name with the given context as string."""
        ...
    def get_content(self) -> str:
        """Get the rendered content as string."""
        ...
    def hydrate_from_composers(self):
        """Add data into the view from specified composers."""
        ...
    def composer(composer_name: str, dictionary: dict) -> "View":
        """Add/Update composer with the given name and data."""
        ...
    def share(dictionary: dict) -> "View":
        """Share data to all templates."""
        ...
    def exists(template: str) -> bool:
        """Check if a template with the given name exists."""
        ...
    def add_location(template_location: str, loader: "BaseLoader" = PackageLoader):
        """Add location directory from which view templates can be loaded. The Jinja2 loader type
        can be specified."""
        ...
    def add_namespaced_location(namespace: str, template_location: str):
        """Add namespaced location directory from which view templates can be loaded."""
        ...
    def add_from_package(package_name: str, path_in_package: str): ...
    def filter(name: str, function: Callable):
        """Add filter functions to views with the given name."""
        ...
    def add_extension(extension: str) -> "View":
        """Register Jinja2 extension to views."""
        ...
    def load_template(template: str):
        """Private method for loading all the locations into the current environment."""
        ...
    def get_current_loaders(self):
        """Get all enabled Jinja2 loaders."""
        ...
    def set_separator(token: str) -> "View":
        """Change separator for view names (default is /)."""
        ...
    def set_file_extension(extension: str) -> "View":
        """Change file view extension (default is .html)."""
        ...
    def get_response(self) -> str:
        """Get the rendered content as string."""
        ...
    def test(key: str, obj: Any) -> "View": ...
