/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.block.decomposition.chol;

import org.ejml.alg.block.BlockInnerRankUpdate;
import org.ejml.alg.block.BlockMatrixOps;
import org.ejml.alg.block.BlockTriangularSolver;
import org.ejml.alg.block.decomposition.chol.BlockInnerCholesky;
import org.ejml.data.BlockMatrix64F;
import org.ejml.data.D1Submatrix64F;
import org.ejml.factory.CholeskyDecomposition;

public class BlockCholeskyOuterForm
implements CholeskyDecomposition<BlockMatrix64F> {
    private boolean lower = false;
    private BlockMatrix64F T;

    public BlockCholeskyOuterForm(boolean lower) {
        this.lower = lower;
    }

    @Override
    public boolean decompose(BlockMatrix64F A) {
        if (A.numCols != A.numRows) {
            throw new IllegalArgumentException("A must be square");
        }
        this.T = A;
        if (this.lower) {
            return this.decomposeLower();
        }
        return this.decomposeUpper();
    }

    private boolean decomposeLower() {
        int blockLength = this.T.blockLength;
        D1Submatrix64F subA = new D1Submatrix64F(this.T);
        D1Submatrix64F subB = new D1Submatrix64F(this.T);
        D1Submatrix64F subC = new D1Submatrix64F(this.T);
        for (int i = 0; i < this.T.numCols; i += blockLength) {
            int widthA = Math.min(blockLength, this.T.numCols - i);
            subA.col0 = i;
            subA.col1 = i + widthA;
            subA.row0 = subA.col0;
            subA.row1 = subA.col1;
            subB.col0 = i;
            subB.col1 = i + widthA;
            subB.row0 = i + widthA;
            subB.row1 = this.T.numRows;
            subC.col0 = i + widthA;
            subC.col1 = this.T.numRows;
            subC.row0 = i + widthA;
            subC.row1 = this.T.numRows;
            if (!BlockInnerCholesky.lower(subA)) {
                return false;
            }
            if (widthA != blockLength) continue;
            BlockTriangularSolver.solveBlock(blockLength, false, subA, subB, false, true);
            BlockInnerRankUpdate.symmRankNMinus_L(blockLength, subC, subB);
        }
        BlockMatrixOps.zeroTriangle(true, this.T);
        return true;
    }

    private boolean decomposeUpper() {
        int blockLength = this.T.blockLength;
        D1Submatrix64F subA = new D1Submatrix64F(this.T);
        D1Submatrix64F subB = new D1Submatrix64F(this.T);
        D1Submatrix64F subC = new D1Submatrix64F(this.T);
        for (int i = 0; i < this.T.numCols; i += blockLength) {
            int widthA = Math.min(blockLength, this.T.numCols - i);
            subA.col0 = i;
            subA.col1 = i + widthA;
            subA.row0 = subA.col0;
            subA.row1 = subA.col1;
            subB.col0 = i + widthA;
            subB.col1 = this.T.numCols;
            subB.row0 = i;
            subB.row1 = i + widthA;
            subC.col0 = i + widthA;
            subC.col1 = this.T.numCols;
            subC.row0 = i + widthA;
            subC.row1 = this.T.numCols;
            if (!BlockInnerCholesky.upper(subA)) {
                return false;
            }
            if (widthA != blockLength) continue;
            BlockTriangularSolver.solveBlock(blockLength, true, subA, subB, true, false);
            BlockInnerRankUpdate.symmRankNMinus_U(blockLength, subC, subB);
        }
        BlockMatrixOps.zeroTriangle(false, this.T);
        return true;
    }

    @Override
    public boolean isLower() {
        return this.lower;
    }

    @Override
    public BlockMatrix64F getT(BlockMatrix64F T) {
        if (T == null) {
            return this.T;
        }
        T.set(this.T);
        return T;
    }

    @Override
    public boolean inputModified() {
        return true;
    }
}

