## Palíndromo

Um palíndromo é uma palavra, frase, número ou sequência de palavras que são lidas igualmente na forma normal e de trás para frente.

## Passos

1. Limpa a string removendo toda a pontuação e espaços em branco e converte todas as letras para minúsculas.
2. Inverte a string limpa (passo anterior).
3. Se a string limpa for igual à string limpa invertida temos um palíndromo.

## Exemplos

### Palíndromo de uma palavra
- Coco
- Ovo
- Osso
- Reler
- Salas

## Frases palíndromas
- Socorram-me, subi no ônibus em Marrocos.
- A base do teto desaba.
- A mãe te ama.
- Arara rara.
- O céu sueco.

## Implementações
- [C](../../../algorithms/C/strings/palindrome.c)
- [C++](../../../algorithms/CPlusPlus/Maths/palindrome.cpp)
- [C#](../../../algorithms/CSharp/src/Strings/palindrome.cs)
- [Haskell](../../../algorithms/Haskell/strings/palindrome.hs)
- [Java](../../../algorithms/Java/strings/palindrome.java)
- [JavaScript](../../../algorithms/JavaScript/src/strings/palindrome.js)
- [Python](../../../algorithms/Python/strings/palindrome.py)
- [Rust](../../../algorithms/Rust/strings/palindrome/src/main.rs)

## Video URL
[Video no youtube a explicar o palíndromo](https://www.youtube.com/watch?v=j3yTHI8uSCg)

## Outros

[Wikipédia](https://pt.wikipedia.org/wiki/Pal%C3%ADndromo)
[Mais exemplos de palíndromos](https://www.todamateria.com.br/palindromo/)