# 回文
回文とは、始めから読んだ場合と終わりから読んだ場合で、同じように読める文字列のことである。言葉遊びの一種である。

## ステップ
1. すべての句読点と空白を取り除き、すべての文字をひらがなに変換する。
2. 1で得た文字列を反転させる。
3. 1の文字列と2の文字列が同じであれば、回文となる。

## 例

### 単語
- しんぶんし
- たけやぶやけた
- わたしまけましたわ

### 短文
- イカ食べたかい
- 馬鹿なカバ
- 遠い音
- 柿の木か

## 実装
- [C](../../../algorithms/C/strings/palindrome.c)
- [C++](../../../algorithms/CPlusPlus/Maths/palindrome.cpp)
- [C#](../../../algorithms/CSharp/src/Strings/palindrome.cs)
- [Haskell](../../../algorithms/Haskell/strings/palindrome.hs)
- [Java](../../../algorithms/Java/strings/palindrome.java)
- [JavaScript](../../../algorithms/JavaScript/src/strings/palindrome.js)
- [Python](../../../algorithms/Python/strings/palindrome.py)
- [Rust](../../../algorithms/Rust/strings/palindrome/src/main.rs)

## 動画のURL
[A coursera video explaining the palindrome Algorithm](https://www.coursera.org/lecture/program-code/palindrome-algorithm-1-zzQqs) 

## その他
[Wikipedia](https://ja.wikipedia.org/wiki/%E5%9B%9E%E6%96%87)
