# Java

## Arrays

- [Counting Inversions](arrays/counting-inversions.java)
- [Kadanes Algorithm](arrays/kadanes-algorithm.java)
- [Left Rotation](arrays/left-rotation.java)
- [Unique Digits of Large Number](arrays/unique-digits-of-large-number.java)
- [Majority Element](arrays/majority-element.java)
- [Longest Consecutive Subsequence](arrays/longest-consecutive-subsequence.java)
- [K-th Element of Two Sorted Arrays](arrays/kth-element--orted-array.java)
- [Trapping Rain Water](arrays/trapping-rain-water.java)
- [Ugly Number](arrays/ugly-number.java)
- [Merge Without Extra Space](arrays/merge-without-extra-space.java)

## Graphs

- [Dijkstras](graphs/Dijkstras.java)
- [Prims](graphs/Prims.java)


## Linked Lists

- [Circular Singly Linked List](linked-lists/circular-singly-linkedlist.java)
- [Circular](linked-lists/circular.java)
- [Clone Linked List](linked-lists/clone-linkedlist.java)
- [Doubly](linked-lists/doubly.java)
- [Reverse](linked-lists/reverse.java)
- [Singly](linked-lists/singly.java)
- [Fold Linked List](linked-lists/fold-linked-list.java)

## Maths

- [Factorial](Maths/factorial_using_big_integer.java)
- [Nth-Fibonacci](Maths/Nth_Fibonacci.java)
- [Catalan Numbers](Maths/catalan-numbers.java)
- [Nth Geek Onacci Number](Maths/nth-geek-onacci-number.java)
- [Random Node in Linked List](Maths/algorithms_random_node.java)
- [Square Root using BinarySearch](Maths/square-root.java)
- [Roman Numerals Conversion](Maths/roman-numerals.java)
- [Permutation Sequence](Maths/permutation_sequence.java)

## Queues

- [Circular Queue using Linked List](queues/circular-queue-linked-list.java)
- [Queue using Linked List](queues/queue-linked-list.java)
- [Priority Queue using Array](queues/priority-queue-array.java)

## Scheduling

- [Multi-Level Queue Scheduling](scheduling/multi-level-queue-scheduling.java)
- [Round Robin](scheduling/round-robin.java)

## Searching

- [Binary Search](searching/binary-search.java)
- [Jump Search](searching/jump-search.java)
- [Linear Search](searching/linear-search.java)
- [Allocate minimum number of pages](searching/allocate-min-pages.java)
- [Exponential Search](searching/Exponential-search.java)
- [Interpolation Search](searching/interpolation-search.java)
- [Ternery Search](searching/ternery-search.java)

## Sorting

- [Bubble Sort](sorting/bubble-sort.java)
- [Counting Sort](sorting/counting-sort.java)
- [Heap Sort](sorting/heap-sort.java)
- [Insertion Sort](sorting/insertion-sort.java)
- [Merge Sort](sorting/merge-sort.java)
- [Quick Sort](sorting/quick-sort.java)
- [Selection Sort](sorting/selection-sort.java)
- [Shell Sort](sorting/shell-sort.java)
- [Cyclic Sort](sorting/cyclic-sort.java)

## Stacks

- [Balanced Parenthesis](stacks/balanced-paranthesis.java)
- [Stack](stacks/stack.java)
- [The Stock Span Problem](stacks/the-stock-span-problem.java)
- [Celebrity Problem](stacks/celebrity-problem.java)
- [Sliding Window Maximum](stacks/sliding-window-maximum.java)
- [Min Stack](stacks/Min-Stack.java)
- [Next Greater Element](stacks/Next_Greater_Element.java)

## Strings

- [KMP](strings/kmp.java)
- [Palindrome](strings/palindrome.java)
- [Rabin Krap](strings/rabin-karp.java)
- [Sequence](strings/sequence.java)
- [Split String](strings/SplitString.java)
- [Tokenizer](strings/tokenizer.java)
- [Anagram](strings/anagram.java)
- [Longest Common Substring](strings/Longest_common_substring.java)
- [Boyer Moore Search](strings/Boyer_Moore.java)
- [Reverse String](strings/reverse-string.java)
- [First Non Repeating Character](strings/first-non-repeating-char.java)
- [Isomorphic Strings](strings/isomorphic_strings.java)

## Trees

- [Pre in Post Traversal](trees/pre-in-post-traversal.java)
- [Left View of a Tree](trees/left-view.java)
- [Right View of a Tree](trees/right-view.java)
- [Zig-Zag Traversal of a Tree](trees/zig-zag-traversal.java)
- [Min Heap](trees/MinHeap.java)
- [Check Tree Traversal](trees/check-tree-traversal.java)
- [Random Node of a binary tree](trees/tree-random-node.java)
- [Left Leaf Sum of a Binary tree](trees/Left-Leaf-Sum.java)

## Backtracking

- [N Queen Problem](backtracking/nqueen.java)

## Bit Manipulation

- [Count Set Bits](bit-manipulation/count-set-bits.java)

## Recursion

- [Array sorted or not](recursion/array-sorted.java)
- [Sum of all the elements in the array](recursion/array-sum.java)
- [Binary search using recursion](recursion/binary-search.java)
- [Factorial of a number](recursion/Factorial.java)
- [First uppercase letter in a string](recursion/first-uppercase-letter.java)
- [Linear search using recursion](recursion/linear-search.java)
- [Minimum and maximum element in the array](recursion/min-max-in-array.java)
- [Printing 1 to N and N to 1](recursion/print-n.java)
- [Print PI value in the string](recursion/print-pi.java)
- [Reverse the string](recursion/reverse-string.java)
- [Find the length of the string](recursion/string-length.java)
