# C++

## Arrays

- [Counting Inversions](Arrays/counting-inversions.cpp)
- [Dutch Flag Algorithm](Arrays/dutch-flag-algo.cpp)
- [Left Rotation](Arrays/left-rotation.cpp)
- [Max Subarray Sum](Arrays/max-subarray-sum.cpp)
- [Shift Negatives](Arrays/shift-negatives.cpp)
- [Boyer–Moore Voting Algorithm](Arrays/boyer_more.cpp)
- [Reverse Array](Arrays/reverse-array.cpp)
- [Sorted-Rotated Search Array](Arrays/search-sorted-rotated.cpp)
- [Fractional Knapsack](Arrays/fractional-knapsack.cpp)
- [Quick Selection](Arrays/quick-select.cpp)
- [Remove Duplicates](Arrays/remove-duplicates.cpp)
- [Leaders In The Array](Arrays/leaders-in-array.cpp)
- [Elements appear thrice In The Array](Arrays/Elements_appears_thrice.cpp)
- [Maximum Difference](Arrays/maximum-difference.cpp)
- [Occurrence of one in sorted array](Arrays/occurence-of-one-in-sorted-array.cpp)
- [Segregate 0s and 1s](Arrays/segregate-0-and-1.cpp)
- [Search insert position](Arrays/search-insert-position.cpp)
- [Matrix Multiplication](Arrays/matrix-multiplication.cpp)
- [Smallest Sum Possible](Arrays/smallest-sum-possible.cpp)
- [Smallest Possible Sum](Arrays/smallest-possible-sum.cpp)
- [Index of Smallest element of Array](Arrays/index-of-smallest-element-of-array.cpp)
- [Move Zeros to End of The Array](Arrays/move-zeros-to-end-of-array.cpp)
- [Kadane's Algorithm](Arrays/Kadane's-Algorithm.cpp)
- [All unique triplet that sum up to given value](Arrays/three-sum.cpp)
- [Merge two sorted array without using extraspace](Arrays/merge-two-sorted-array.cpp)
- [All unique triplet that sum up to given value](Arrays/three-sum.cpp)
- [Next permutation](Arrays/next-permutation.cpp)
- [Maximum Minimum Average of numbers](Arrays/max-min-avg.cpp)
- [Sparse Matrix](Arrays/sparse_matrix.cpp)
- [Balanced Parenthesis](Arrays/balanced-parenthesis.cpp)
- [Find special index](Arrays/specialindex2.cpp)
- [Largest and smallest number in an array](Arrays/Largest-smallest.cpp)

## Dynamic-Programming

- [Longest Common Subsequence](Dynamic-Programming/longest-common-subsequence.cpp)
- [Longest Common Substring](Dynamic-Programming/longest-common-substring.cpp)
- [0/1-knapsack](Dynamic-Programming/01-knapsack.cpp)
- [Matrix chain Multiplication](Dynamic-Programming/matrix-chain-multiplication.cpp)
- [Edit Distance](Dynamic-Programming/edit-distance.cpp)
- [Fibonacci](Dynamic-Programming/fibonacci.cpp)
- [Rod Cutting](Dynamic-Programming/rod-cutting.cpp)

## Graphs

- [Bellman Ford Algorithm](Graphs/bellman-ford.cpp)
- [kruskal Algorithm](Graphs/kruskal-algorithm.cpp)
- [Breadth First Search](Graphs/breadth-first-search.cpp)
- [Topological sort](Graphs/topological-sort.cpp)
- [Dfs traversal with stack](Graphs/dfs-through-stackdatastructure.cpp)
- [Dfs traversal with recursion](Graphs/dfs-traversal.cpp)
- [Connected Components](Graphs/total-connected-components.cpp)
- [Dijkstra's Algorithm](Graphs/dijkstra.cpp)
- [Cycle Detection](Graphs/cycle-detection.cpp)
- [Prim's Algorithm](Graphs/prim's_algorithm.cpp)
- [Floyd Warshall](Graphs/floyd-warshall.cpp)
- [Detecting Cycle in Directed graph using three colors](Graphs/detecting-cycle-in-a-graph-using-three-color-mechanism.cpp)



## Multiplication

- [Karatsuba](Multiplication/karatsuba.cpp)

## Linked Lists

- [All possible insertions](Linked-Lists/all-possible-insertion.cpp)
- [Singly linked lists](Linked-Lists/singly.cpp)
- [doubley linked lists](Linked-Lists/doubly.cpp)
- [Circular linked lists](Linked-Lists/circular.cpp)
- [Removing Elements of given value](Linked-Lists/remove-specific-elements.cpp)
- [Reversing a linked lists](Linked-Lists/reverse.cpp)
- [Merging two sorted linked lists](Linked-Lists/merge.cpp)
- [Reorder List](Linked-Lists/Reorder-List.cpp)
- [Detecting cycle in a singly linked list](Linked-Lists/Cycle-Detection.cpp)
- [Find Merge Point of two singly linked list](Linked-Lists/Find-Merge-Point.cpp)
- [Segregate Even Odd Nodes of linked list](Linked-Lists/segregate-even-odd-nodes-of-linked-list.cpp)
- [Remove Duplicate in Sorted linked list](Linked-Lists/remove-duplicates-in-sorted-linked-list.cpp)
- [Reverse the linked list using stack](Linked-Lists/reverse-the-list-using-stack.cpp)
- [Reverse the linked list in groups of K](Linked-Lists/reverse-the-list-in-groups-of-k.cpp)
## Searching

- [Linear Search](Searching/linear-search.cpp)
- [Jump Search](Searching/jump-search.cpp)
- [Binary Search](Searching/binary-search.cpp)
- [Finding squareroot using Binary search](Searching/sqrt-monotonic-binary-search.cpp)
- [KMP String Searching](Searching/kmp.cpp)
- [Ternary Search](Searching/Ternary-search.cpp)
- [Interpolation Search](Searching/interpolation-search.cpp)
- [Exponential Search](Searching/exponential-search.cpp)
- [Linear search in 2D array](Searching/linear-search-in-2d.cpp)

## Stacks

- [Balancing Parenthesis](Stacks/balanced-parenthesis.cpp)
- [Reversing Stack](Stacks/reverse-stack.cpp)
- [Stack using Array](Stacks/stack-using-array.cpp)
- [Infix to postfix expression conversion](Stacks/infix-to-postfix.cpp)
- [Stock Span Problem using Stacks](Stacks/stock-span-problem.cpp)
- [Prefix to Postfix expression conversion](Stacks/prefix_to_postfix.cpp)
- [Redundant Parenthesis](Stacks/redundant-parenthesis.cpp)

## Sorting

- [Bubble Sort](Sorting/bubble-sort.cpp)
- [Insertion Sort](Sorting/insertion-sort.cpp)
- [Quicksort](Sorting/quick-sort.cpp)
- [Selection Sort](Sorting/selection-sort.cpp)
- [3 way Quick Sort](Sorting/3way-quick-sort.cpp)
- [Bucket Sort](Sorting/bucket-sort.cpp)
- [Comb Sort](Sorting/comb-sort.cpp)
- [Counting Sort](Sorting/counting-sort.cpp)
- [heap Sort](Sorting/heap-sort.cpp)
- [Radix Sort](Sorting/radix-sort.cpp)
- [Shell Sort](Sorting/shell-sort.cpp)
- [Binary Insertion Sort](Sorting/binary-insertion-sort.cpp)
- [Merge Sort](Sorting/merge-sort.cpp)
- [Wave Sort](Sorting/wave-sort.cpp)
- [Cycle Sort](Sorting/cycle-sort.cpp)

## Strings

- [Rabin-Karp pattern search algo](Strings/rabin-karp.cpp)
- [All subsequence of a string (Recursion) ](Strings/sequence.cpp)
- [String reversal](Strings/string-reverse.cpp)
- [String tokanisation](Strings/string-tokeniser.cpp)
- [Anagram check](Strings/anagram.cpp)
- [Remove occurrences from string](Strings/remove-occurrences.cpp)
- [Delete alternate characters in a string](Strings/delete-alternate-characters.cpp)
- [Print first letter of every word](Strings/print-first-letter.cpp)
- [Display longest name in a string array](Strings/longest-name.cpp)
- [Boyer Moore pattern search](Strings/Boyer_Moore.cpp)
- [Longest common prefix](Strings/longest-common-prefix.cpp)
- [First unique character in the string](Strings/first-unique-character.cpp)
- [Sliding Window to match target string](Strings/sliding-window.cpp)
- [Reverse String Wordwise](Strings/ReverseTheStringWordwise.cpp)

## Trees

- [Creating Binary Tree](Trees/build-binary-tree.cpp)
- [Counting and finding sum of all the nodes in BST](Trees/count-and-sum-of-nodes-in-binary-tree.cpp)
- [Level Order Traversal](Trees/level-order-traversal.cpp)
- [Depth first Traversal](Trees/pre-in-post-traversal.cpp)
- [Binary Search Tree](Trees/binary-search-tree.cpp)
- [In order morris traversal](Trees/in-order-morris-traversal.cpp)
- [In order Predecessor and Successor](Trees/in-order-predecessor-and-successor.cpp)
- [Avl Tree](Trees/avl.cpp)
- [Min Heap](Trees/min-heap.cpp)
- [Finding the height of a given tree](Trees/Height-Of-Tree.cpp)
- [Finding the elements of a tree visible from top view](Trees/Top-View-Of-A-Tree.cpp)
- [Binary Tree Implementation](Trees/binary-tree-implementation.cpp)
- [Iterative Segment Tree](Trees/IterativeSegmentTree.cpp)
- [Print all nodes at level k](Trees/print-all-nodes-at-a-level.cpp)
- [Sum of right leaves](Trees/sum-of-right-leaves.cpp)

## Trie

- [Trie for searching](Trie/trie_search.cpp)
- [Trie for insert search and prefix_search](Trie/trie_insert_search_startWith.cpp)
- [Trie for delete](Trie/trie_delete.cpp)
- [Find Words Matching Pattern Dictionary](Trie/find_all_words_matching_pattern_in_given_dictionary.cpp)

# Maths

- [Kaprekar Number](Maths/Kaprekar-number.cpp)
- [Prime Number](Maths/prime-check.cpp)
- [Prime Sieve](Maths/prime-sieve.cpp)
- [Fibonacci Series](Maths/fibonaccci-series.cpp)
- [Binomial Coefficient](Maths/binomial-coefficient.cpp)
- [Armstrong Number](Maths/armstrong.cpp)
- [Palindrome](Maths/palindrome.cpp)
- [Reverse digit of a number](Maths/reverse-digits.cpp)
- [Missing number](Maths/missing-number.cpp)
- [Factorial of a number](Maths/factorial.cpp)
- [Prime-number](Maths/prime-number.cpp)
- [Totient-function](Maths/totient.cpp)
- [Even number of digits](Maths/even-no-of-digits.cpp)
- [Power of two](Maths/power-of-two.cpp)
- [Small numbers](Maths/small-numbers.cpp)
- [Segmented Sieve](Maths/segmented-sieve-range.cpp)
- [Binary Power](Maths/binary-power.cpp)

# Recursion

- [Tower of Hanoi](Recursion/towerofHanoi.cpp)
- [Factorial](Recursion/factorial.cpp)
- [Permutation](Recursion/permutation.cpp)
- [GCD/HCF of two numbers](Recursion/GCD-of-two-numbers.cpp)
- [Sum of all elements of an array](Recursion/Sum-of-all-elements-in-an-array.cpp)
- [Decimal number to Binary conversion](Recursion/decimal-to-binary-conversion.cpp)
- [Sum of digits of a decimal integer](Recursion/sum-of-digits-of-an-integer.cpp)
- [Binary search using recursion](Recursion/binary-search.cpp)
- [First uppercase letter in a string](Recursion/first-uppercase-letter.cpp)
- [Reverse a string using recursion](Recursion/reverse-string.cpp)
- [Find string length using recursion](Recursion/string-length.cpp)
- [Sum of n natural numbers](Recursion/sum-of-n.cpp)
- [Minimum and maximum element in array](Recursion/min-max-element-in-array.cpp)
- [Prime Check](Recursion/recursive-prime.cpp)
- [Array sorted or not](Recursion\array-sorted-or-not.cpp)
- [Product of two numbers](Recursion\product-of-numbers.cpp)
- [Product of digits in a number](Recursion\product-of-digits.cpp)
- [Linear search using recursion](Recursion/linear-search.cpp)
- [Reverse a number using recursion](Recursion/reverse-a-number.cpp)

## Number System

- [Binary Addition](Number-system/binary_addition.cpp)
- [Binary to Decimal](Number-system/binary_to_decimal.cpp)
- [Decimal To Binary](Number-system/decimal_to_binary.cpp)
- [Decimal To Hexa-Decimal](Number-system/decimal_to_hexa.cpp)
- [Hexa-Decimal To Decimal](Number-system/hexa_to_decimal.cpp)
- [Decimal To Octal](Number-system/decimal_to_octal.cpp)
- [Octal To Decimal](Number-system/octal_to_decimal.cpp)

## Backtracking

- [N-Queens Problem](Backtracking/n-queens.cpp)
- [Rat In A Maze Problem](Backtracking/rat-in-a-maze-problem.cpp)
