meta:
  id: hccapx
  title: Hashcat capture file
  license: Unlicense
  application:
    - Hashcat
    - aircrack-ng
  endian: le
  file-extension: hccapx
doc: |
  Native format of Hashcat password "recovery" utility
doc-ref: https://hashcat.net/wiki/doku.php?id=hccapx
seq:
  - id: records
    type: hccapx_record
    repeat: eos
types:
  hccapx_record:
    seq:
      - id: magic
        contents: "HCPX"
      - id: version
        type: u4
        doc: The version number of the .hccapx file format.
      - id: ignore_replay_counter
        type: b1
        doc: |
          Indicates if the message pair matching was done based on
          replay counter or not.

          Whenever it was set to 1 it means that the replay counter
          was ignored (i.e. it was not considered at all by the
          matching algorithm).

          Hashcat currently does not perform any particular action
          based on this bit, but nonetheless this information could be
          crucial for some 3th party tools and for
          analysis/statistics. There could be some opportunity to
          implement some further logic based on this particular
          information also within hashcat (in the future).
      - id: message_pair
        type: b7
        doc: |
          The message_pair value describes which messages of the 4-way
          handshake were combined to form the .hccapx structure. It is
          always a pair of 2 messages: 1 from the AP (access point)
          and 1 from the STA (client).

          Furthermore, the message_pair value also gives a hint from
          which of the 2 messages the EAPOL origins. This is
          interesting data, but not necessarily needed for hashcat to
          be able to crack the hash.

          On the other hand, it could be very important to know if
          “only” message 1 and message 2 were captured or if for
          instance message 3 and/or message 4 were captured too. If
          message 3 and/or message 4 were captured it should be a hard
          evidence that the connection was established and that the
          password the client used was the correct one.
      - id: len_essid
        -orig-id: essid_len
        type: u1
      - id: essid
        size: len_essid
      - id: padding1
        size: 32 - len_essid
      - id: keyver
        type: u1
        doc: |
          The flag used to distinguish WPA from WPA2 ciphers. Value of
          1 means WPA, other - WPA2.
      - id: keymic
        size: 16
        doc: |
          The final hash value. MD5 for WPA and SHA-1 for WPA2
          (truncated to 128 bit).
      - id: mac_ap
        size: 6
        doc: The BSSID (MAC address) of the access point.
      - id: nonce_ap
        size: 32
        doc: Nonce (random salt) generated by the access point.
      - id: mac_station
        -orig-id: mac_sta
        size: 6
        doc: The MAC address of the client connecting to the access point.
      - id: nonce_station
        -orig-id: nonce_sta
        size: 32
        doc: Nonce (random salt) generated by the client connecting to the access point.
      - id: len_eapol
        -orig-id: eapol_len
        type: u2
        doc: The length of the EAPOL data.
      - id: eapol
        size: len_eapol
      - id: padding2
        size: 256 - len_eapol
