# 曺全碑隸 (暂名)
起初是想找点免费美观的隶书字体，没找到合适的，于是创建了个开源「黑体(?)汉隶」计划，相当于复刻曹全碑。

下图里“CoQuBeLi”示范了汉隶风格西文的构思，除了“〇”都有曹全碑字笔画对应。预感该字体汉字部分不适合横排，将注重于竖排特性，且用OpenType特性及扩充区〔SIP、TIP〕汉字来支持隶书异体、篆书古形⋯⋯

![曹全碑隶](CoQuBeLi.png)

## 关于制作
「字形」和「字符」并不一一对应，本字体中将大量出现复用字形（多字符对一字形）的情况，如输入`曹曺`均显示为「曺」字，参见 [字形列表.txt][zi]

西文、标点主要用隶书笔画拼成，所以会在字量足够之后再雕琢。

在 […宽泛统计.txt](docs/曹全碑文宽泛统计.txt) 等文件列出字符对应碑阳具体的哪个字形。

- 20220707 v0.0  ：发布概念版字体，看看效果如何。
- 20220712 v0.002：更新字体，并发布`字形列表.txt`
- 20220726 v0.003：更新及修正，添加`kern`
- 20220806 v0.005：更新及修正、调整x字高，添加`ccmp` `hwid` `ital` `vert`；修正`…宽泛统计.txt`
- 20220810 v0.006：更新及改善笔画细节，添加`cpct` `vkrn`；字体在文件管理器中缩略图或显示为`文字美`
- 20220818 v0.007：更新及改善，添加`aalt` `calt` `halt` `palt` `salt` `vrt2` `zero`；支持[VS][uvs]
- 20220828 v0.008：更新及改善，添加`case` `liga` `lnum` `onum` `pnum` `tnum`
- 20220915 v0.009：英文已齐全，添加同形希腊\西里尔文，改善`case`四则运算，添加`dlig` `CQBL`

[新建了个**字体协作Q群**`613746416`](https://t.bilibili.com/704315533620674584)，方便想来协作但难以访问github的人。

## 已有特性
1. `aalt`替换全览，本字体用于列某汉字的所有异体
1. `calt`语境替换，根据上下文替换字形，类同我的[Monu]对`Qu`相遇处理
1. `salt`样式替换，算是一种不看语境有替就换的无脑特性
1. `case`注重大写，标点垂直位置区分大小写、数字改大写形式等，西文特性
1. `ccmp`字形重组，例如用于连续且不顶格的破折号、居中省略号 ~和变体选择符~
1. `cpct`标点居中，替换居中的标点，东亚特性
1. `fwid`全角字宽，替换字形，差不多算是东亚的西文特性
1. `hwid`半角字宽，同上
1. `pwid`比例字宽，同上，基本上是西文特性
1. `halt`字宽半角，东亚特性，仅调整单个东亚标点左右边距，本字体用于标点挤压
1. `palt`字宽比例，同上，仅调整单个字面左右边距，本字体用于挤近全角英文
1. `ital`意大利体，东亚的西文特性，本字体用于将`「」`替换为顺笔方向的半角`⸤⸣`（测试）
1. `kern`调字偶距，基本上是西文特性，本字体也用于标点挤压（适用排版功能欠缺的软件）
1. `liga`标准连字，默认开启，例如~ABAJ→啊~ `f​i`→`ﬁ`
1. `dlig`酌情连字，默认关闭，例如`!?`→`⁉`
1. `lnum`平齐数字，替换数字字形
1. `onum`古典数字，同上，数字高低不平，宛如小写字母
1. `pnum`比例数字，替换为不等宽数字
1. `tnum`列表数字，替换为等宽数字
1. `vert`竖排替换，东亚特性
1. `vrt2`竖排旋替，同上，希望不旋转地解决西文竖排
1. `vkrn`竖排字距，同上，希望借以解决西文竖排，本字体用于竖排标点挤压（测试）
1. `zero`换斜杠〇，只要让`0`相对`o`区别更明显即可，不一定划斜杠
1. [SVS](http://unicode.org/Public/UCD/latest/ucd/StandardizedVariants.txt)，本字体[目前支持的标准变体序列][uvs]（变体选择符，非OT特性）
1. `CQBL`此为自定义特性，仅此字体支持，尽可能还原字形为曹全碑原状
   - 即一对一替换到私用区U+E100～E45F，网页CSS写法：`font-feature-settings:'CQBL';`

如果你的软件无法调用以上这些特性，可以尝试手动解决，比如某些特性只是自动替换字形，那么可以直接到[字形列表.txt][zi]复制替换后的字形。

## 预期特性
- `mark`标记定位，西文变音或假名浊点用的特性，本字体当然要支持汉语拼音
- `qwid`四分字宽，本字体可能仅用于¼EM宽数字
- `twid`三分字宽，本字体可能仅用于⅓EM宽数字
- `ss01`样式集＃，本字体计划支持到`ss16`
- `vhal`字高半角，东亚特性，仅调整单个东亚标点上下边距，本字体用于竖排标点挤压
- `vpal`字高比例，同上，仅调整单个字面上下边距
<!--
- `hist`
-->

## docs

### 曹全碑文宽泛统计.txt
为便于指明字体源文件里某字形出典而作。
- 该文本为逐字统计某字出现次数和序数，且不区分异体（如`曺` `𣍘`都算作`曹`），只区分个别写法完全不同的多对一简体：`于` `於`、`后` `後`、`谷` `穀`。至于全部区分的文件，自然是“…严格统计.txt”……
  - `曹×6`表示碑阳共出现6次「曹」（**复字**）且在碑文中第一次出现，该个字形在源文件里记作`曹1`。
  - `全_1`表示仅出现一次（**孤字**），字形记作`全`不用数字区分。
  - `曹02`则是计序，这个字形记作`曹2`。
    - 注1：为了对齐，仅计次用的17进制，`之×H`即`之×17`，字形记作`之1`。顺带：B=11，C=12。
    - 注2：`怀_2`是特例，字形记作`懷`，按碑上下文看，可当作`褱×2`（字形记作`褱`）的异体。
- **碑外字**（曹全碑未出现的汉字）用`+`号强调，如「碑」字记作`碑+`，我将优先制作`碑` `隶\隸` `綿` `飴`。
    - 2022-7-7注：`碑+` `隸+`已经制作了。
- 每行`|`后方为注释。`≈`表示差不多同义，`→`表示错别字，`≠`表示可能是别字。顺带，百度百科错误太多。
- 当前字形制作优先级：孤字清晰 > 复字择优 > 孤字破损 > 碑外造字。
- 个人原创汉字字体十分艰巨，若有感兴趣的同好来帮忙，除了[字形列表][zi]列举的，该文本未列出的也就是我目前不会做的字，可以避免撞车。

### 字形列表.txt
字体里存在的字形一览，每行一个字形。
- 字形命名详见`宽泛统计.txt`，以`;`隔开备注。
- `tab符`之后的是对应字符，某些是一对多。无`tab符`则表示该字形无对应字符，或需OT特性来调用。
- 私用区U+E100～EFFF主要用于放汉字变体。
  - 碑文出现最多的`之`字有17次，索性将每字变体上限设为16个，放在私用区的U+E460～EFFF便于排版功能欠缺的软件复制用。为每个字保留一整段码位，规律为`某字1～15`对应到`U+Exx1～ExxF`、`某字16`放在`U+Exx0`（虽然不至于做这么多变体…）……而`xx`的值，先做先得。当然这样地挥霍码位，若未来私用区不够使，增补私用区也行……该区的字形与原碑不重复。
  - 私用区的U+E100～E45F为原碑字形逐字备份（除了缺损未作和未调整的），为那些追求碑文保持大小不一原状的人保留。
- 私用区U+E020～E07F留空给ASCII字符变体（对应U+20～7F，我的[Monu]系列就是这样）。U+E000～E0FF的剩余空间或摆放`fwid` `hwid` `twid` `qwid`等其它西文排版特性用的字符，其中U+E018～E01F留给中文弯引号（对应U+2018～201F，我的[Ctrl Zpix](https://github.com/MY1L/Ctrl)类似这样）
  - U+E0A0～E0A2``、U+E0B0～E0B3``或留空以避让Powerline符号。
  - 本字体是扁体，正常弯引号比半角一半还窄，若做成全角，那左右空隙实在太大了，因此无论调`fwid` `hwid`都是中文的半角弯引号。
- 私用区剩下部分，其中U+F000～F0FF留空给东亚排版变体（如竖排标点和假名，对应U+3000～30FF，虽然[Monu]系列用的是U+E341～E3FC）。至于竖排ASCII字符，就让全角字符兼用罢。
- 数字(Figures)样式缩写对应特性连招和含义——
  - `onum` `pnum` osf：OldStyle，比例古典，即本字体默认样式。例外：本字体`6` `8`的osf等同lf样式
  - `lnum` `tnum` tf：Tabular，等宽平齐，例外：本字体tf等同半角(`hwid`)，`6`的tf等同osf样式
  - `onum` `tnum` tosf：等宽古典，例外：本字体tosf也等同半角，`6` `8`的tosf等同tf样式
  - `lnum` `pnum` lf：Lining，比例平齐
  - `zero` `*num` zer0︀：斜杠〇（0̸）

[Monu]: https://github.com/MY1L/QuQi
[uvs]: docs/CoQuBeLi.uvs
[zi]: docs/字形列表.txt