- [循环神经网络RNN](#循环神经网络rnn)
    - [使用潜变量](#使用潜变量)
    - [RNN](#rnn)
    - [困惑度](#困惑度)
    - [梯度裁剪](#梯度裁剪)
    - [更多的应用RNNs](#更多的应用rnns)

### 使用潜变量

- RNN使用了隐藏层来记录过去发生的所有事件的信息，从而引入时许的特性，并且避免常规序列模型每次都要重新计算前面所有已发生的事件而带来的巨大计算量。![截屏2022-02-12 下午2.17.32](https://github.com/kinza99/DeepLearning-MuLi-Notes/blob/main/imgs/54/54-01.png)

### RNN

- 流程如下，首先有一个输入序列，对于时刻t，我们用t-1时刻的输入x~t-1~和潜变量h~t-1~来计算新的潜变量h~t~。同时，对于t时刻的输出o~t~，则直接使用h~t~来计算得到。注意，计算第一个潜变量只需要输入即可（因为前面并不存在以往的潜变量）。![截屏2022-02-12 下午2.34.14](https://github.com/kinza99/DeepLearning-MuLi-Notes/blob/main/imgs/54/54-02.png) 
- 值得注意的是，RNN本质也是一种MLP，尤其是将h~t-1~这一项去掉时就完全退化成了MLP。RNN的核心其实也就是h~t-1~这一项，它使得模型可以和前面的信息联系起来，将时序信息储存起来，可以把RNN理解为是包含时序信息的MLP。

### 困惑度

- 为了衡量一个语言模型的好坏，例如分类模型，可以使用平均交叉熵来衡量，就是将预测概率的负对数值求和之后再去平均，即常用的交叉熵损失。但是由于某些历史原因，NLP往往不是用这种方式，而是在这种方式的基础上最后再取指数，即exp，这样得到的结果如果是1，说明完美；如果是无穷大，说明结果很差。

### 梯度裁剪

- 在T个时间步中进行反向传播，会由于产生O(T)长度的梯度乘法链，导致导数数值不稳定，这里使用一个限制θ，通常为5到10，来控制梯度乘法链的长度。使用如下的公式![截屏2022-02-12 下午3.10.38](https://github.com/kinza99/DeepLearning-MuLi-Notes/blob/main/imgs/54/54-03.png)在这个公式中，如果梯度长度大于θ，梯度g会变为
  $$
  \frac{\theta}{\Vert g \Vert} g
  $$
  这样再对g求2范式就变成了θ，所以可以把梯度限制在θ以下。

### 更多的应用RNNs

- 基本的应用如下图![截屏2022-02-12 下午3.36.29](https://github.com/kinza99/DeepLearning-MuLi-Notes/blob/main/imgs/54/54-04.png)
