## 46 语义分割

### 目录

- [1.语义分割](#1语义分割)
- [2.应用](#2应用)
- [3.实例分割](#3实例分割)
- [4.QA](#4qa)

### 1.语义分割

有时只能实现框选的目标检测还是太粗糙了，无法得到更精细的信息。语义分割将图片中的每个像素分类到对应的类别。

分割这一概念在计算机视觉中由来已久。最早的图片分割对给定图片使用聚类等方法把语义上比较像的像素放在一起，但通常不会告诉我们这些像素到底是什么。而语义分割可以告诉我们每个像素对应的label是什么。

这也意味着我们需要对图片的每一个像素都做label，使得语义分割成为了一个比较精细且大的任务。语义分割的数据集成本也较高，往往规模小像素高。常用的数据集之一是Pascal VOC2012。

<img src="..\imgs\46\46-01.jpg" alt="46-01" style="zoom:25%;" />

### 2.应用

背景虚化：传统的背景替换往往采用绿幕。在没有绿幕的情况下传统相机可以通过光圈来实现背景虚化，对于手机等设备而言背景虚化通常使用的都是语义分割或结合图像景深信息。

路面分割：如无人驾驶时用于实时识别周围物体，实现找路的功能。

### 3.实例分割

语义分割只关心像素属于哪一类，而实例分割则更进一步，如图片里有两只狗，则需要得出哪个像素属于哪一只狗。可以将其理解为目标检测的进化版本。

<img src="..\imgs\46\46-02.png" alt="46-02" style="zoom:25%;" />

### 4.QA

Q1: 能否做更细的语义分割如狗的头/身/腿？

> 可以，有标注数据即可，不过可能会出现不同标注者对身体部位分界不同之类的问题。针对狗头这一例子可以考虑使用姿态识别得到关节点。

Q2: 目标检测里做图像增广，目标框做对应变换后不再是矩形怎么办？

> 如果很关心角度信息可以给框加入一个表示旋转角度的feature，也可以考虑在旋转后的原框外面画一个大框把它圈起来，这个大框是可以计算出来的。

Q3: 把人像语义分割做到slides中的效果大概需要多少训练集？

> 人像这块技术相对比较成熟，应该能找到很好的预训练模型在其基础上调整即可。人像的形状是比较容易做的，难点主要在于光照不同（可能使背景与人像/衣服模糊）

Q4: 三维语义分割标注怎么做？

> （这里把三维理解成有景深的图片）一个简单的做法是把图片压缩成2维，也可以使用三维卷积。三维的分割实际上是好做的，因为一个物体的像素景深往往是连续的且与背景差距较大。

Q5: 自动驾驶用语义分割，实例分割还是目标检测更合适？

> 自动驾驶需要用到大量不同的模型，语义分割主要用于路面分割，目标检测用于检测前车/行人及其距离/速度。

Q6: 语义分割有什么标注工具？

> 国内外的数据标注公司会有这方面的平台，可以自己找找，老师认为这个比较简单，工具大同小异。
>
> （弹幕提及较多：labelme）

Q7: 摄像头怕过曝，逆光相关

> 过曝不常见，但欠曝在光线不足时很常见，一种方法是做大量数据增广。逆光更难做一点，不过photoshop可以模拟出逆光效果用于数据增强，也可以在采集数据时采集一些逆光照片，检查低置信度的照片确认是否为逆光，之后加以标注对模型重新训练。这样的方法可能会涉及到数据隐私问题。

Q8: 自动驾驶用纯视觉方案能不能做到很可靠？

> tesla做的就是纯视觉，国内/Google用激光雷达（贵但精准），此外大家都会用摄像头和雷达。老师的广电是使用纯摄像头方案一方面是因为技术团队在这方面有积累，另一个可能的原因是摄像头便宜，第三个原因是tesla的算力很大能很好处理大量摄像头信息，最后是Tesla有大量的数据积累，大量的数据可以弥补传感器方面的劣势。
>
> 理论上纯视觉自动驾驶是可行的，但目前只有Tesla做的还算可靠。
