# 微调
   - [微调](#微调)
  - [背景](#背景)
  - [步骤](#步骤)
 - [总结](#总结)

### 背景

- 很多时候，例如我们想对家具进行分类，但是往往在努力收集数据得到的数据集也比较小假如我们想识别图片中不同类型的椅子，然后向用户推荐购买链接。 一种可能的方法是首先识别100把普通椅子，为每把椅子拍摄1000张不同角度的图像，然后在收集的图像数据集上训练一个分类模型。 尽管这个椅子数据集可能大于Fashion-MNIST数据集，但实例数量仍然不到ImageNet中的十分之一。 适合ImageNet的复杂模型可能会在这个椅子数据集上过拟合。 此外，由于训练样本数量有限，训练模型的准确性可能无法满足实际要求。为了避免这种情况，我们可以有两种方法：
  - 显然的想法就是收集更多的数据，但是，收集和标记数据可能需要大量的时间和金钱。 例如，为了收集ImageNet数据集，研究人员花费了数百万美元的研究资金。 尽管目前的数据收集成本已大幅降低，但这一成本仍不能忽视。
  - 我们可以考虑迁移学习将从*源数据集*学到的知识迁移到*目标数据集*。 例如，尽管ImageNet数据集中的大多数图像与椅子无关，但在此数据集上训练的模型可能会提取更通用的图像特征，这有助于识别边缘、纹理、形状和对象组合。 这些类似的特征也可能有效地识别椅子。

### 步骤

- 如图所示，微调包括以下四个步骤：
  1. 在源数据集（例如ImageNet数据集）上预训练神经网络模型，即***源模型***。
  2. 创建一个新的神经网络模型，即***目标模型***。这将复制源模型上的所有模型设计及其参数（输出层除外）。我们假定这些模型参数包含从源数据集中学到的知识，这些知识也将适用于目标数据集。我们还假设源模型的输出层与源数据集的标签密切相关；因此不在目标模型中使用该层。
  3. 向目标模型添加输出层，其输出数是目标数据集中的类别数。然后随机初始化该层的模型参数。
  4. 在目标数据集（如椅子数据集）上训练目标模型。输出层将从头开始进行训练，而所有其他层的参数将根据源模型的参数进行微调。

<div align="center">
    <img src="../imgs/37/37-01.png" alt="image" align="center" width="500" />
</div>

  5. 通常来讲，微调速度更快，并且具有较强的正则性，一般学习率比较小，也不需要很多轮的数据迭代，对于不同的任务往往只需要改变最后输出层，这一层随机初始化即可。

### 总结

- 迁移学习将从源数据集中学到的知识“迁移”到目标数据集，微调是迁移学习的常见技巧。
- 除输出层外，目标模型从源模型中复制所有模型设计及其参数，并根据目标数据集对这些参数进行微调。但是，目标模型的输出层需要从头开始训练。
- 通常，微调参数使用较小的学习率，而从头开始训练输出层可以使用更大的学习率。
