## 36 数据增广

### 目录

* [1. 使用增强数据训练](#1-使用增强数据训练)
* [2. 增强手段](#2-增强手段)
  + [2.1 翻转](#21-翻转)
  + [2.2 切割](#22-切割)
  + [2.3 颜色](#23-颜色)
  + [2.4 其他](#24-其他)
* [3. 总结](#3-总结)
* [4. QA](#4-qa)

数据增广不仅用于处理图片，也可用于文本和语音，这里只涉及到图片。

### 1. 使用增强数据训练

采集数据得到的训练场景与实际部署场景不同是常见的问题，这种变化有时会显著影响模型表现。在训练集中尽可能模拟部署时可能遇到的场景对模型的泛化性十分重要。

数据增强是指在一个已有数据集上操作使其有更多的多样性。对语音来说可以加入不同的背景噪音，对图片而言可以改变其颜色，形状等。

一般来说不会先将数据集做增广后存下来再用于训练；而是直接在线生成，从原始数据中读图片并随机做数据增强，再进入模型训练。通常只在训练时做数据增强而测试时不用。可以将数据增强理解为一个正则项。

### 2. 增强手段

#### 2.1 翻转

一些例子：左右翻转，上下翻转

要注意不是所有增强策略都总是可行，如建筑图片上下翻转就不太合适，而之前的树叶分类竞赛中的树叶图片就没关系。

<img src="..\imgs\36\36-01.png" alt="36-01" style="zoom:25%;" />

#### 2.2 切割

从图片中切割一块然后变形到固定形状。一般做法是随机取一个高宽比，随机取图片大小（切下部分占原图的百分数），随机取位置。

<img src="..\imgs\36\36-02.png" alt="36-02" style="zoom:25%;" />

#### 2.3 颜色

改变色调，饱和度，明亮度。

<img src="..\imgs\36\36-03.png" alt="36-03" style="zoom:25%;" />

#### 2.4 其他

还可以有很多种不同的方法，如高斯模糊，部分像素变黑，图片变形，锐化等等。理论上讲Photoshop能做到的都可以用作图片数据增强，但效果好坏另当别论。如果测试集中有类似的效果那么相应的数据增广手段会更有效。

<img src="..\imgs\36\36-04.png" alt="36-04" style="zoom:25%;" />

### 3. 总结

- 数据增广通过变形数据来获取多样性从而使得模型泛化性能更好
- 常见图片增广包括翻转，切割，变色

### 4. QA

Q1: 理论上是不是原始样本足够多就不需要做增广？

> 是的，但实际情况中很难有足够多样性的图片能覆盖测试的所有情况。
>
> 数据量大也不一定意味着足够多样，可能简单情况已经很充分，但对于很难的情况覆盖率不够。

Q2: （代码实现中的）num_worker值是不是根据GPU性能而定？

> 是。
>
> 这里老师还提到虽然深度学习主要用GPU，但CPU也不能太差，否则可能数据预处理跟不上，CPU的内存带宽和到显卡的带宽不够。具体决定num_worker可以自己定一个值然后跑一个epoch看看耗时。

Q3: 金融风控领域经常面临极度偏斜数据（欺诈样本极少），是否可对正样本做数据增广？

> 可以，类似地震预测等等正样本少的情况都可以尝试对正样本做增广，负样本可以不用。

Q4: 测试一般做什么样的增广？如何理解对测试集增广能提高精度？

> 一般不对测试集做增广。也可以对一张测试图像做增广，将每个增广出的图片都做一次预测最后取平均，会一定程度改善精度。但这样会使得对每张图片预测计算量成倍增长，所以使用较少。

Q5: 课件里提到的对比实验固定了所有随机种子吗？昨晚增广后训练精度下降是不是意味着还可以继续训练减少gap？

> 没有。
>
> 是的，课堂演示时往往跑的epoch较少，另外训练到后期gap一般不会减少。

Q6: 图片增广后需要人工一张张确认效果吗？

> 不用全看，大概看看效果即可。

Q7: 图片增广后训练数据与测试数据分布可能不同，会对模型最终精度有影响吗？

> 首先多数图片增广手段不改变数据分布，因为亮度变化等是随机的，数据的均值不变，翻转不影响分布，crop可能会有改变但影响不大。
>
> 后面还有问题提到对增广不改变数据分布的理解，可理解成增广不改变均值但稍微增大方差。很多时候讨论训练集和测试集分布是否相同不是看原始的像素分布而是看各label比例或图片色调等是否差不多。

Q8: 关于图神经网络

> 图神经网络很强大但不好训练，目前落地还太早了

Q9: 关于mosaic和crop

> 把多张图片拼起来训练。这里老师理解错了问题，提到了加马赛克和本节代码中一次展示八张图片只是一起显示而不是使用了crop方法。

Q10: 用对一个事物的视频描述做数据集是不是会比增广更有效？

> 可以这么认为，但拍视频是很贵的事情，获取视频往往划不来。

Q11: 多张图片叠加是否也是有效的增广方式？

> 是的，这种方法叫mix-up，非常有用。
>
> 后面有问到为什么mix-up有用，老师也不清楚。
>
> lable的叠加是对两张图片label按特定分布随机取权重加权求和

Q12: 做车辆位置识别如果实际应用场景摄像头高度角度清晰度都和训练集不一样，是不是只能针对场景单独采集数据重新打标训练？

> 是，可以考虑将实际部署时识别错误的数据加入训练集使得训练集测试集分布趋同

Q13: 是否会出现图像增广减小类间差异，混淆不同类别的情况？

> 那倒不会。可以考虑不要crop太小的区域。

Q14: 实际操作用torchvision还是albumentation?

> 都差不多
