## 32-深度学习硬件
### 目录
- [32-深度学习硬件](#32-深度学习硬件)
  - [目录](#目录)
  - [1.DSP:数字信号处理](#1dsp数字信号处理)
  - [2.可编程阵列（FPGA）](#2可编程阵列fpga)
  - [3.AI ASIC](#3ai-asic)
  - [总结](#总结)

- 本节我们介绍除了 GPU CPU 之外更多的芯片
- 引入：手机内部的芯片有很多——GPU CPU ISP WIFI……

### 1.DSP:数字信号处理

- 为数字信号处理算法设计：点积、卷积、FFT

- 低功耗，高性能
  - 比移动GPU快5倍，功耗更低
- VLIW：very long instruction word
  - 频率低，核少，但是一条指令可以进行上百次的累加，便于重复
- 缺点：编程和调试困难，编译器良莠不齐（做的人少，工具不是很好用）

### 2.可编程阵列（FPGA）

- 有大量的可以用来编程的逻辑单元和可配置链接
- 可以配置成计算复杂函数
  - 编程语言：VHDL Verilog
- 通常比通用硬件更高效，但是体积更大不方便
- 缺点：工具链质量良莠不齐，一次编译需要数个小时（烧一次板子，物理上的改变）
- 用途：主要用来模拟，看看效果好不好，如果好可以进一步造芯片

### 3.AI ASIC

- 深度学习热门领域（针对特定领域）
  - 大公司都在造自己的芯片（Intel Qualcomm Google Amazon Facebook）
- Google TPU 是标志性芯片（听说在Google内部已经盛行 取代GPU了）
  - 能够媲美 Nvidia GPU性能
  - 在Google 大量部署
  - 核心是 systolic array（时间快 容易造）
-  systolic array
  - 计算单元（PE）阵列
  - 特别适合做矩阵乘法
  - 设计和制造相对简单（核少）
  - 矩阵乘法例子：见PPT
    - 对于一般的矩阵乘法：通过切开、填充来匹配SA大小
    - 批量输入来降低延迟（避免空等，先出的硬件空闲）
    - 通常有其他硬件单元来处理别的NN操作子，例如激活层
  - 缺点：只针对深度学习这方面有用，别的方面效果不大

### 总结

- 灵活性、易用性：Intel(CPU) > GPU > DSP > FPGA > ASIC
- 性能功耗：Intel(CPU) < GPU < DSP < FPGA < ASIC