  ## GooLeNet
  #### 目录
  - [GooLeNet](#goolenet)
  - [目录](#目录)
  - [含并行连结的网络](#含并行连结的网络)
  - [Inception块](#inception块)
  - [GooLeNet模型](#goolenet模型)
  - [总结](#总结)
  
#### 含并行连结的网络

  - GoogLeNet吸收了NiN中串联网络的思想，并在此基础上做了改进。我们往往不确定到底选取什么样的层效果更好，到底是3X3卷积层还是5X5的卷积层，诸如此类的问题是GooLeNet选择了另一种思路“小学生才做选择，我全都要”，这也使得GooLeNet成为了第一个模型中超过1000个层的模型。

#### Inception块

  - 在GoogLeNet中，基本的卷积块被称为*Inception块*（Inception block）

    ![截屏2022-01-23 上午10.11.18](https://github.com/kinza99/DeepLearning-MuLi-Notes/blob/main/imgs/27/27-1.png)

  - Inception块由四条并行路径组成。 前三条路径使用窗口大小为1×11×1、3×33×3和5×55×5的卷积层，从不同空间大小中提取信息。 中间的两条路径在输入上执行1×11×1卷积，以减少通道数，从而降低模型的复杂性。 第四条路径使用3×33×3最大汇聚层，然后使用1×11×1卷积层来改变通道数。 这四条路径都使用合适的填充来使输入与输出的高和宽一致，最后我们将每条线路的输出在通道维度上连结，并构成Inception块的输出。在Inception块中，通常调整的超参数是每层输出通道数。

#### GooLeNet模型

  - GoogLeNet一共使用9个Inception块和全局平均汇聚层的堆叠来生成其估计值。Inception块之间的最大汇聚层可降低维度。 第一个模块类似于AlexNet和LeNet，Inception块的组合从VGG继承，全局平均汇聚层避免了在最后使用全连接层。![截屏2022-01-23 上午10.17.11](https://github.com/kinza99/DeepLearning-MuLi-Notes/blob/main/imgs/27/27-2.png)
  - 第一个模块是7×7卷积层。
  - 第二个模块使用两个卷积层：第一个卷积层是1×1卷积层；第二个卷积层使用将通道数量增加三倍的3×3卷积层。 这对应于Inception块中的第二条路径。
  - 第三个模块串联两个完整的Inception块。 第一个Inception块的输出通道数为64+128+32+32=25664+128+32+32=256，四个路径之间的输出通道数量比为64:128:32:32=2:4:1:164:128:32:32=2:4:1:1。 第二个和第三个路径首先将输入通道的数量分别减少到96/192=1/296/192=1/2和16/192=1/1216/192=1/12，然后连接第二个卷积层。第二个Inception块的输出通道数增加到128+192+96+64=480128+192+96+64=480，四个路径之间的输出通道数量比为128:192:96:64=4:6:3:2128:192:96:64=4:6:3:2。 第二条和第三条路径首先将输入通道的数量分别减少到128/256=1/2128/256=1/2和32/256=1/832/256=1/8。
  - 第四模块更加复杂， 它串联了5个Inception块，其输出通道数分别是192+208+48+64=512192+208+48+64=512、160+224+64+64=512160+224+64+64=512、128+256+64+64=512128+256+64+64=512、112+288+64+64=528112+288+64+64=528和256+320+128+128=832256+320+128+128=832。 这些路径的通道数分配和第三模块中的类似，首先是含3×3卷积层的第二条路径输出最多通道，其次是仅含1×1卷积层的第一条路径，之后是含5×5卷积层的第三条路径和含3×3最大汇聚层的第四条路径。 其中第二、第三条路径都会先按比例减小通道数。 这些比例在各个Inception块中都略有不同。

#### 总结

  - Inception块相当于一个有4条路径的子网络。它通过不同窗口形状的卷积层和最大汇聚层来并行抽取信息，并使用1×1卷积层减少每像素级别上的通道维数从而降低模型复杂度。

  - GoogLeNet将多个设计精细的Inception块与其他层（卷积层、全连接层）串联起来。其中Inception块的通道数分配之比是在ImageNet数据集上通过大量的实验得来的。

  - GoogLeNet和它的后继者们一度是ImageNet上最有效的模型之一：它以较低的计算复杂度提供了类似的测试精度。

    

