## 25 使用块的网络 VGG

### 目录

 * [1. VGG块](#1-vgg块)
  * [2. VGG架构](#2-vgg架构)
  * [3. 总结](#3-总结)
  * [4. QA](#4-qa)

Alexnet最大的问题在于长得不规则，结构不甚清晰，也不便于调整。想要把网络做的更深更大需要更好的设计思想和标准框架。

### 1. VGG块

直到现在更深更大的模型也是我们努力的方向，在当时AlexNet比LeNet更深更大得到了更好的精度，大家也希望把网络做的更深更大。选择之一是使用更多的全连接层，但全连接层的成本很高；第二个选择是使用更多的卷积层，但缺乏好的指导思想来说明在哪加，加多少。最终VGG采取了将卷积层组合成块，再把卷积块组合到一起的思路。

VGG块可以看作是AlexNet思路的拓展，AlexNet中将三个相同的卷积层放在一起再加上一个池化层，而VGG将其拓展成可以使用任意个3x3，不改变输入大小的的卷积层，最后加上一个2x2的最大池化层。

<img src="..\imgs\25\25-01.PNG" alt="25-01" style="zoom:25%;" />

为什么选择3x3卷积呢？在计算量相同的情况下选用更大的卷积核涉及对网络会越浅，VGG作者经过实验发现用3x3卷积的效果要比5x5好，也就是说神经网络库深且窄的效果会更好。

### 2. VGG架构

多个VGG块后接全连接层，不同次数的重复块得到不同的架构，如VGG-16, VGG-19等，后面的数字取决于网络层数。

可以讲VGG看作是将AlexNet中连续卷积的部分取出加以推广和复制，并删去了AlexNet中不那么规整的前几层。

<img src="..\imgs\25\25-02.PNG" alt="25-02" style="zoom:25%;" />

VGG较AlexNet相比性能有很大的提升，而代价是处理样本速度的降低和内存占用的增加。

### 3. 总结

- VGG使用可重复使用的卷积块来构建深度卷积网络

- 不同卷积块个数和超参数可以得到不同复杂度的变种

这些思想影响了后面神经网络的设计，在之后的模型中被广泛使用。

### 4. QA

Q1: 视觉领域人工特征的研究还有无进展？

> 现在在计算机视觉做人工特征是一种“政治不正确”的事，可能会因被认为没有novelty而发不出paper ;-)
>
> 老师认为人工特征提取确实应该被取代掉，随着技术进步可以把这部分工作交给机器，人去做更高级的事。

Q2: 需要学习特征值/特征向量/奇异值分解的知识吗？

> 这门课中不一定会讲，但很多深度学习模型用到矩阵分解的思想，但是用的不多，想学可以学。

Q3: Colab限时12小时与验证码的解决方法

> 充钱

Q4: 训练loss一直下降，测试loss一只不降的原因

> 代码写错了/过拟合(训练集和测试集很不一样)

Q5: 为什么VGG（1，1，224，224）输入高宽减半后通道数是64？

> 第一个卷积层的输出通道选的是64。(通道数变化是自定的，和高宽变化没有关系)
