## 线性回归+基础优化算法

- [线性回归+基础优化算法](#线性回归基础优化算法)
  - [1.线性回归](#1线性回归)
  - [2.基础优化算法](#2基础优化算法)
  - [3.线性回归的从零开始实现](#3线性回归的从零开始实现)
  - [4.新型回归的简洁实现](#4新型回归的简洁实现)
  - [5.- 线性回归+基础优化算法](#5--线性回归基础优化算法)

### 1.线性回归

- 房价预测例子

- **线性模型**

  - 输入：$x=[x_1,x_2,...,x_n]^T$

  - 线性模型需要确定一个n维权重和一个标量偏差$\omega=[\omega_1,\omega_2,...,\omega_n]^T,b$

  - 输出 ：$y=\omega_1x_1+\omega_2x_2+...+\omega_nx_n+b$，

    向量版本的是 $y=<\omega,x>+b$

  - 线性模型可以看作是单层神经网络（图片）

    >- 神经网络源于神经科学（图片）
    >  - 最早的神经网络是源自神经科学的，但是时至今日，很多神经网络已经远远高于神经科学，可解释性也不是很强，不必纠结

- 衡量估计质量

  - 我们需要估计模型的预估值和真实值之间的差距，例如房屋售价和股价

  - 假设$y$是真实值，$\tilde{y}$是估计值，我们可以比较

    $l(y,\tilde{y})=\frac{1}{2}(y-\tilde{y})^2$，这个叫做**平方损失**

- **训练数据**

  - 收集一些数据点来决定参数值（权重$\omega$和偏差$b$），例如6个月内被卖掉的房子。

  - 这被称之为训练数据

  - 通常越多越好。需要注意的是，现实世界的数据都是有限的，但是为了训练出精确的参数往往需要训练数据越多越好，当训练数据不足的时候，我们还需要进行额外处理。

  - 假设我们有n个样本，记为

    $X=[x_1,x_2,...,x_n]^T,y=[y_1,y_2,...y_n]^T$

    $X$的每一行是一个样本，$y$的每一行是一个输出的实数值。

- **参数学习**

  - **训练损失**。但我们训练参数的时候，需要定义一个损失函数来衡量参数的好坏，应用前文提过的平方损失有公式：

    ​	$l(X,x,\omega,b)=\frac{1}{2n}\sum_{i=1}^n(y_i-<x_i,w>-b)^2=\frac{1}{2n}||y-X\omega-b||^2$

  - **最小化损失来学习参数**。训练参数的目的就是使损失函数的值尽可能小（这意味着预估值和真实值更接近）。最后求得的参数值可表示为：

    $\omega^*,b^*=argmin_{\omega,b}l(X,x,\omega,b)$

- **显示解**

  - 线性回归有显示解，即可以直接矩阵数学运算，得到参数w和b的最优解，而不是用梯度下降，牛顿法等参数优化方式一点点逼近最优解。

  - **推导过程**：

    - 为了方便矩阵表示和计算，将偏差加入权重，$X\gets[X,1],\omega\gets[\omega,b]$

    - 损失函数是凸函数，最优解满足导数为0，可解出显示解

      令$\frac{\partial}{\partial\omega} l(X,y,\omega)=0$

      有$\frac{1}{n}(y-X\omega)^TX=0$

      解得$\omega^*=(X^TX)^{-1}X^Ty$

- 总结

  - 线性回归是对n维输入的加权，外加偏差
  - 使用**平方损失**来衡量预测值和真实值之间的误差
  - **线性回归有显示解**
  - 线性回归可以看作单层神经网络



### 2.基础优化算法

- **梯度下降**

  - 当模型没有显示解的时候，应用梯度下降法逼近最优解。
  - 梯度下降法的具体步骤：
    - 挑选一个初始值$\omega_0$
    - 重复迭代参数，迭代公式为：$\omega_t=\omega_{t-1}-\lambda\frac{\partial l}{\partial\omega_{t-1} } $
      - **$-\frac{\partial l}{\partial\omega_{t-1}}$为函数值下降最快的方向，学习率$\lambda$为学习步长。**
  - 选择学习率
    - 学习率$\lambda$为学习步长，代表了沿负梯度方向走了多远，这是超参数（人为指定的的值，不是训练得到的）
    - 学习率不能太大，也不能太小，需要选取适当。

- **小批量随机梯度下降**

  - 在整个训练集上算梯度太贵了

    - 在实际应用中，很少直接应用梯度下降法，这是因为每次更新都需要计算训练集上所有的样本，耗费时间太长。一个深度神经网络模型，迭代一次可能需要数分钟甚至数小时。

  - 为了减少运算代价，我们可以==随机采样==b个样本$i_1,i_2,...,i_b$来近似损失，损失函数为：

    ​	$\frac{1}{b}\sum_{i\in I_b}l(x_i,y_i,\omega)$ , 

    其中**b是批量大小(batch size)，也是超参数**

  - **选择批量大小**
    
    - b也不能太大：内存消耗增加；浪费计算资源，一个极端的情况是可能会重复选取很多差不多的样本，浪费计算资源
    - b也不能太小：每次计算量太小，很难以并行，不能最大限度利用GPU资源

- **总结**

  - 梯度下降通过不断**沿着负梯度方向**更新参数求解
  - 小批量随机梯度下降是深度学习默认的求解算法（简单，稳定）
  - **两个重要的超参数：批量大小（batch size），学习率（lr）**

### 3.线性回归的从零开始实现

- 代码

### 4.新型回归的简洁实现

- 代码

### 5.- [线性回归+基础优化算法](#线性回归基础优化算法)
  - [1.线性回归](#1线性回归)
  - [2.基础优化算法](#2基础优化算法)
  - [3.线性回归的从零开始实现](#3线性回归的从零开始实现)
  - [4.新型回归的简洁实现](#4新型回归的简洁实现)
  - [5.QA](#5qa)QA

- **1.为什么使用平方损失而不是绝对差值？**
  - 其实差别不大，最开始使用平方损失是因为它可导，现在其实都可以使用。
- **2.损失为什么要求平均？**
  - 本质上没有关系，但是如果不求平均，梯度的数值会比较大，这时需要学习率除以n。如果不除以n，可能会随着样本数量的增大而让梯度变得很大。
- **3.不管是梯度下降还是随机梯度下降，怎么找到合适的学习率？**
  - 选择对学习率不敏感的优化方法，比如Adam
  - 合理参数初始化
- **4.训练过程中，过拟合和欠拟合情况下，学习率和batch_size应该如何调整？**
  - 理论上学习率和batch_size对最后的拟合结果不会有影响
- **5.深度学习上，设置损失函数的时候，需要考虑正则吗？**
  - 会考虑，但是和损失函数是分开的，深度学习中正则没有太大的用处，有很多其他的技术可以有正则的效果。
- **6.如果样本大小不是批量数的整数倍，需要随机剔除多余的样本吗？**
  - 就取多余的样本作为一个批次
  - 直接丢弃
  - 从下一个epoch里面补少的样本
